/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifdef ABV4ABS
#include "cell_vb.h"
#include "font_vb.h"
#include "tbd_vb.h"
#include "worksheet_vb.h"
#include "workbook_vb.h"
#include "application_vb.h"
#include "interior_vb.h"
#include "row_vb.h"
#include "column_vb.h"
#include "border_vb.h"
#include "chart_vb.h"
#include "axis_vb.h"
#include "title_vb.h"
#include "button_vb.h"
#include "fac_vb.h"
#include "range_vb.h"
#endif

#include "mathfct.h"
#include "textfct.h"
#include "statfct.h"
#include "informationfct.h"
#include "properties.h"
#include <stdlib.h>

static Fct arrayfct2[] = {
#ifdef ABV4ABS
  {"CELLS", &vb_getcell, CELL, 2, NULL, NULL},
  {"WKSCELLS", &vb_worksheet_getcell, CELL, 2, NULL, NULL},
  {"Range_old", &vb_getrange1, STRING, 1, NULL, NULL},
  {"Range", &vb_getrange, RANGEN, 1, NULL, NULL},
  {"Worksheets", &vb_getworksheet, WORKSHEET, 1, NULL, NULL},
  {"Workbooks", &vb_getworkbook, WORKBOOK, 1, NULL, NULL},
  {"Columns", &vb_getcolumn, COLUMN, 1, NULL, NULL},
  {"Rows", &vb_getrow, ROW, 1, NULL, NULL},
  {"SeriesCollection", &vb_getserie, SERIE, 1, NULL, NULL},
  {"Axes", &vb_getaxis, AXIS, 1, NULL, NULL},
  {"REPAINT", &vb_repaint, 1, 1, NULL, NULL},
  {"SHELL", &vb_shell, INTEGER, 1, NULL, NULL},
  {"OpenFac", &vb_openfac, FAC, 1, NULL, NULL},
#endif
  {"DEBUGPRINT", &vb_print, 1, 1, NULL, NULL},
  {NULL, NULL, 0, 0, NULL, NULL}
};

int
initclasses ()
{

#ifdef ABV4ABS
  class_add ("WORKBOOK", WORKBOOK, Workbookdata, Workbookfct);
  class_add ("WORKSHEET", WORKSHEET, Worksheetdata, Worksheetfct);
  class_add ("Cell", CELL, Celldata, Cellfct);
  class_add ("Font", FONT, Fontdata, Fontfct);
  class_add ("Column", COLUMN, Columndata, Columnfct);
  class_add ("Border", BORDER, Borderdata, Borderfct);
  class_add ("Row", ROW, Rowdata, Rowfct);
  class_add ("Serie", SERIE, Seriedata, Seriefct);
  class_add ("Axis", AXIS, Axisdata, Axisfct);
  class_add ("Interior", INTERIOR, Interiordata, Interiorfct);
  class_add ("ChartObjects", CHARTOBJECTS, Chartobjectsdata, Chartobjectsfct);
  class_add ("ChartObject", CHARTOBJECT, Chartobjectdata, Chartobjectfct);
  class_add ("Chart", CHART, Chartdata, Chartfct);
  class_add ("ChartTitle", CHARTTITLE, Titledata, Titlefct);
  class_add ("AxisTitle", AXISTITLE, Titledata, Titlefct);
  class_add ("Title", TITLE, Titledata, Titlefct);
  class_add ("SeriesCollection", SERIESCOLLECTION, Seriescollectiondata,
	     Seriescollectionfct);
  class_add ("Range", RANGE, Celldata, Cellfct);
  class_add ("Application", APPLICATION, Applicationdata, Applicationfct);
  class_add ("shapes", SHAPES, Shapesdata, Shapesfct);
  class_add ("WORKBOOKS", WORKBOOKS, Workbooksdata, Workbooksfct);
  class_add ("WORKSHEETS", WORKSHEETS, Worksheetsdata, Worksheetsfct);
  class_add ("BUTTONS", BUTTONS, Buttonsdata, Buttonsfct);
  class_add ("BUTTON", BUTTON, Buttondata, Buttonfct);
  class_add ("FAC", FAC, Facdata, Facfct);
  class_add ("RangeN", RANGEN, Rangedata, Rangefct);
#endif
  return 0;
}

int
initproperties ()
{
#ifdef ABV4ABS
  property_add ("ActiveChart", CHART, NULL, &vb_get_ActiveChart);
  property_add ("ActiveWorksheet", WORKSHEET, NULL, &vb_get_ActiveWorksheet);
  property_add ("ActiveCell", CELL, NULL, &vb_get_ActiveCell);
  property_add ("ChartObjects", CELL, NULL, &vb_get_tempchartobjects);
  property_add ("ActiveSheet", WORKSHEET, NULL, &vb_get_ActiveWorksheet);
  property_add ("Selection", RANGE, NULL, &vb_get_Selection);
  property_add ("Worksheets", WORKSHEETS, NULL, &vb_get_Worksheets);
  property_add ("Workbooks", WORKBOOKS, NULL, &vb_get_Workbooks);
#endif
  return 0;
}

int
initbuiltinfunction ()
{
  addarrayfunction (arrayfct2);
#ifdef ABV4ABS
  addarrayfunction (matharrayfct);
  addarrayfunction (textarrayfct);
  addarrayfunction (statarrayfct);
  addarrayfunction (informationarrayfct);
#endif
  return 0;
}

int
initvb ()
{
  inittables ();
  initbuiltinfunction ();
  initclasses ();
  initproperties ();
  return 0;
}
