/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "gram_ext.h"
#include "y.tab.h"
#include "parser_ext.h"
#include "symboltable.h"
#include <math.h>
#include <string.h>
#include "memory.h"
#include "libfct.h"
#include "properties.h"

extern int yyparse ();
static int vbdebug = 0;

nodeType *ActiveNode;

static int lastbuiltin = -1;

int
check_type ()
{

  return IDENTIFIER;
}

obj putconstidentifier ()
{

  obj id;
  int i = 0;
  char *tokenbuf = GetLastToken ();
  id.type = CONST;

  for (i = 0; i < strlen (tokenbuf); i++)
    {
      if ('a' <= tokenbuf[i] && tokenbuf[i] <= 'z')
	tokenbuf[i] = 'A' + tokenbuf[i] - 'a';
    };

  id.label = biglook (tokenbuf, 1);
  id.rec.s = NULL;

  return id;
}

obj putidentifier ()
{

  obj id;
  int i = 0;
  char *tokenbuf = GetLastToken ();
  id.type = IDENTIFIER;

  i = 0;

  if (properties != NULL)
    while (properties[i].name != NULL)
      {
	if (strcasecmp (tokenbuf, properties[i].name) == 0)
	  {
	    id.type = PROPERTY;
	    id.rec.i = i;
	    id.label = properties[i].name;
	  }
	i++;
      }

  i = 0;

  while (arrayfct[i].name != NULL)
    {
      if (vbdebug)
	fprintf (stderr, "libfct:tokenbuf %s array %s\n", tokenbuf,
		 arrayfct[i].name);
      if (strcasecmp (tokenbuf, arrayfct[i].name) == 0)
	{
	  id.type = BUILTINFUNCTION;
	  id.rec.i = i;
	  id.label = arrayfct[i].name;
	}
      if (vbdebug)
	fprintf (stderr, "after \n");
      i++;
    }

  if (id.type == IDENTIFIER)
    {
      for (i = 0; i < strlen (tokenbuf); i++)
	{
	  if ('a' <= tokenbuf[i] && tokenbuf[i] <= 'z')
	    tokenbuf[i] = 'A' + tokenbuf[i] - 'a';
	};

      id.label = biglook (tokenbuf, 1);
      id.rec.s = NULL;
    }

  return id;
}

int
check_member ()
{
  return MEMBER;
}

obj putmember ()
{

  obj id;
  int i = 0;
  char *tokenbuf = GetLastToken ();

  for (i = 0; i < strlen (tokenbuf); i++)
    {
      if ('a' <= tokenbuf[i] && tokenbuf[i] <= 'z')
	tokenbuf[i] = 'A' + tokenbuf[i] - 'a';
    };

  id.label = biglook (tokenbuf + 1, 1);
  id.rec.s = NULL;
  id.type = MEMBER;

  return id;
}

obj putuserfunction ()
{

  obj o;

  o.type = USERFUNCTION;

  return o;
}

obj putmemberfunction ()
{

  obj o;

  o.type = MEMBERFUNCTION;

  return o;
}

obj putbuiltinfunction ()
{

  obj o;

  o.type = BUILTINFUNCTION;
  o.label = arrayfct[lastbuiltin].name;
  o.rec.i = lastbuiltin;

  return o;
}

nodeType *
parsefile (code)
     char **code;
{
  SetFileInput (code);
  if (!yyparse ())
    {
      return ActiveNode;
    }
  else
    return NULL;
}

nodeType *
parseexpression (expression)
     char *expression;
{
  if (expression == NULL)
    return NULL;
  if (expression[0] == '=')
    expression++;

  SetStringInput (expression);
  if (!yyparse ())
    {
      return ActiveNode;
    }
  else
    return NULL;
}

obj putinteger ()
{
  obj o;
  o.type = INTEGER;
  o.label = NULL;
  sscanf (GetLastToken (), "%d", &o.rec.i);
  return o;
}

obj putfloat ()
{
  obj o;
  o.type = DOUBLE;
  o.label = NULL;
  sscanf (GetLastToken (), "%lf", &o.rec.d);
  return o;
}

obj putstring ()
{
  obj o;
  int len = 0;
  char *tokenbuf = GetLastToken ();
  o.type = STRING_CONSTANT;
  o.label = NULL;
  if (tokenbuf != NULL)
    len = strlen (tokenbuf);
  if (len > 0)
    {
      o.rec.s =
	(char *) absmalloc (sizeof (char) * (len + 1), "putstring:o.rec.s");

      strcpy (o.rec.s, tokenbuf);
      o.rec.s[len] = '\0';
    }
  else
    {
      o.rec.s = NULL;
    }
  return o;
}

obj addstring (obj o)
{
  int len1 = 0;
  int len2 = 0;
  char *tokenbuf = GetLastToken ();
  o.type = STRING_CONSTANT;
  o.label = NULL;
  if (o.rec.s != NULL)
    len1 = strlen (o.rec.s);
  if (tokenbuf != NULL)
    len2 = strlen (tokenbuf);

  o.rec.s =
    (char *) absrealloc (o.rec.s, sizeof (char) * (len1 + len2 + 1),
			 "addstring:o.rec.s");
  if (len1 > 0)
    {
      strcat (o.rec.s, tokenbuf);
      o.rec.s[len1 + len2] = '\0';
    }
  else if (len2 > 0)
    {
      strcpy (o.rec.s, tokenbuf);
      o.rec.s[len2] = '\0';
    }
  else
    {
      o.rec.s = NULL;
    }
  return o;
}

obj cleanstring (obj o)
{
  int len = 0;
  int i = 0;
  int skip = 0;
  o.type = STRING_CONSTANT;
  o.label = NULL;
  if (o.rec.s != NULL)
    len = strlen (o.rec.s);

  if (len > 1)
    {
      for (i = 1; i < len - 1 - skip; i++)
	{
	  if (o.rec.s[i + skip] == o.rec.s[i + skip + 1]
	      && o.rec.s[i + skip] == '\"')
	    skip++;
	  o.rec.s[i - 1] = o.rec.s[i + skip];
	}
      o.rec.s[len - 2 - skip] = '\0';
    }
  else
    {
      o.rec.s = NULL;
    }
  return o;
}
