/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Bond;
import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Network;
import com.xensource.xenapi.PIFMetrics;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Tunnel;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VLAN;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class PIF
extends XenAPIObject {
    protected final String ref;

    PIF(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PIF) {
            PIF pIF = (PIF)object;
            return pIF.ref.equals(this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPIFRecord(v);
    }

    public static PIF getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "PIF.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toPIF(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getDevice(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_device";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Network getNetwork(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_network";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toNetwork(v);
    }

    public Host getHost(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_host";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toHost(v);
    }

    public String getMAC(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_MAC";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Long getMTU(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_MTU";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Long getVLAN(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_VLAN";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public PIFMetrics getMetrics(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_metrics";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPIFMetrics(v);
    }

    public Boolean getPhysical(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_physical";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Boolean getCurrentlyAttached(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_currently_attached";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Types.IpConfigurationMode getIpConfigurationMode(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_ip_configuration_mode";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toIpConfigurationMode(v);
    }

    public String getIP(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_IP";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNetmask(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_netmask";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getGateway(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_gateway";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getDNS(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_DNS";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Bond getBondSlaveOf(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_bond_slave_of";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBond(v);
    }

    public Set<Bond> getBondMasterOf(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_bond_master_of";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfBond(v);
    }

    public VLAN getVLANMasterOf(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_VLAN_master_of";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVLAN(v);
    }

    public Set<VLAN> getVLANSlaveOf(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_VLAN_slave_of";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVLAN(v);
    }

    public Boolean getManagement(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_management";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Map<String, String> getOtherConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Boolean getDisallowUnplug(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_disallow_unplug";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Set<Tunnel> getTunnelAccessPIFOf(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_tunnel_access_PIF_of";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfTunnel(v);
    }

    public Set<Tunnel> getTunnelTransportPIFOf(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_tunnel_transport_PIF_of";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfTunnel(v);
    }

    public Types.Ipv6ConfigurationMode getIpv6ConfigurationMode(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_ipv6_configuration_mode";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toIpv6ConfigurationMode(v);
    }

    public Set<String> getIPv6(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_IPv6";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public String getIpv6Gateway(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_ipv6_gateway";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Types.PrimaryAddressType getPrimaryAddressType(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_primary_address_type";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPrimaryAddressType(v);
    }

    public void setOtherConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.set_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToOtherConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "PIF.add_to_other_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromOtherConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "PIF.remove_from_other_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setDisallowUnplug(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.set_disallow_unplug";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    @Deprecated
    public static Task createVLANAsync(Connection connection, String string, Network network, Host host, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VlanTagInvalid {
        String string2 = "Async.PIF.create_VLAN";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    @Deprecated
    public static PIF createVLAN(Connection connection, String string, Network network, Host host, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VlanTagInvalid {
        String string2 = "PIF.create_VLAN";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toPIF(v);
    }

    @Deprecated
    public Task destroyAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.PifIsPhysical {
        String string = "Async.PIF.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    @Deprecated
    public void destroy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.PifIsPhysical {
        String string = "PIF.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task reconfigureIpAsync(Connection connection, Types.IpConfigurationMode ipConfigurationMode, String string, String string2, String string3, String string4) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string5 = "Async.PIF.reconfigure_ip";
        String string6 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string6), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)ipConfigurationMode), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string4)};
        Map map = connection.dispatch(string5, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void reconfigureIp(Connection connection, Types.IpConfigurationMode ipConfigurationMode, String string, String string2, String string3, String string4) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string5 = "PIF.reconfigure_ip";
        String string6 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string6), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)ipConfigurationMode), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string4)};
        Map map = connection.dispatch(string5, objectArray);
    }

    public Task reconfigureIpv6Async(Connection connection, Types.Ipv6ConfigurationMode ipv6ConfigurationMode, String string, String string2, String string3) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string4 = "Async.PIF.reconfigure_ipv6";
        String string5 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string5), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)ipv6ConfigurationMode), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3)};
        Map map = connection.dispatch(string4, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void reconfigureIpv6(Connection connection, Types.Ipv6ConfigurationMode ipv6ConfigurationMode, String string, String string2, String string3) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string4 = "PIF.reconfigure_ipv6";
        String string5 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string5), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)ipv6ConfigurationMode), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3)};
        Map map = connection.dispatch(string4, objectArray);
    }

    public Task setPrimaryAddressTypeAsync(Connection connection, Types.PrimaryAddressType primaryAddressType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PIF.set_primary_address_type";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)primaryAddressType)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setPrimaryAddressType(Connection connection, Types.PrimaryAddressType primaryAddressType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.set_primary_address_type";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)primaryAddressType)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task scanAsync(Connection connection, Host host) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PIF.scan";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(host)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void scan(Connection connection, Host host) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.scan";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(host)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task introduceAsync(Connection connection, Host host, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.PIF.introduce";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static PIF introduce(Connection connection, Host host, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "PIF.introduce";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toPIF(v);
    }

    public Task forgetAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.PifTunnelStillExists {
        String string = "Async.PIF.forget";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void forget(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.PifTunnelStillExists {
        String string = "PIF.forget";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task unplugAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PIF.unplug";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void unplug(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.unplug";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task plugAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.TransportPifNotConfigured {
        String string = "Async.PIF.plug";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void plug(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.TransportPifNotConfigured {
        String string = "PIF.plug";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task dbIntroduceAsync(Connection connection, String string, Network network, Host host, String string2, Long l, Long l2, Boolean bl, Types.IpConfigurationMode ipConfigurationMode, String string3, String string4, String string5, String string6, Bond bond, VLAN vLAN, Boolean bl2, Map<String, String> map, Boolean bl3, Types.Ipv6ConfigurationMode ipv6ConfigurationMode, Set<String> set, String string7, Types.PrimaryAddressType primaryAddressType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string8 = "Async.PIF.db_introduce";
        String string9 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string9), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(l2), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC((Object)ipConfigurationMode), Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string5), Marshalling.toXMLRPC(string6), Marshalling.toXMLRPC(bond), Marshalling.toXMLRPC(vLAN), Marshalling.toXMLRPC(bl2), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(bl3), Marshalling.toXMLRPC((Object)ipv6ConfigurationMode), Marshalling.toXMLRPC(set), Marshalling.toXMLRPC(string7), Marshalling.toXMLRPC((Object)primaryAddressType)};
        Map map2 = connection.dispatch(string8, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public static PIF dbIntroduce(Connection connection, String string, Network network, Host host, String string2, Long l, Long l2, Boolean bl, Types.IpConfigurationMode ipConfigurationMode, String string3, String string4, String string5, String string6, Bond bond, VLAN vLAN, Boolean bl2, Map<String, String> map, Boolean bl3, Types.Ipv6ConfigurationMode ipv6ConfigurationMode, Set<String> set, String string7, Types.PrimaryAddressType primaryAddressType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string8 = "PIF.db_introduce";
        String string9 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string9), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(l2), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC((Object)ipConfigurationMode), Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string5), Marshalling.toXMLRPC(string6), Marshalling.toXMLRPC(bond), Marshalling.toXMLRPC(vLAN), Marshalling.toXMLRPC(bl2), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(bl3), Marshalling.toXMLRPC((Object)ipv6ConfigurationMode), Marshalling.toXMLRPC(set), Marshalling.toXMLRPC(string7), Marshalling.toXMLRPC((Object)primaryAddressType)};
        Map map2 = connection.dispatch(string8, objectArray);
        Object v = map2.get("Value");
        return Types.toPIF(v);
    }

    public Task dbForgetAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PIF.db_forget";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void dbForget(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.db_forget";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<PIF> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPIF(v);
    }

    public static Map<PIF, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PIF.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfPIFPIFRecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public String device;
        public Network network;
        public Host host;
        public String MAC;
        public Long MTU;
        public Long VLAN;
        public PIFMetrics metrics;
        public Boolean physical;
        public Boolean currentlyAttached;
        public Types.IpConfigurationMode ipConfigurationMode;
        public String IP;
        public String netmask;
        public String gateway;
        public String DNS;
        public Bond bondSlaveOf;
        public Set<Bond> bondMasterOf;
        public VLAN VLANMasterOf;
        public Set<VLAN> VLANSlaveOf;
        public Boolean management;
        public Map<String, String> otherConfig;
        public Boolean disallowUnplug;
        public Set<Tunnel> tunnelAccessPIFOf;
        public Set<Tunnel> tunnelTransportPIFOf;
        public Types.Ipv6ConfigurationMode ipv6ConfigurationMode;
        public Set<String> IPv6;
        public String ipv6Gateway;
        public Types.PrimaryAddressType primaryAddressType;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "device", this.device);
            printWriter.printf("%1$20s: %2$s\n", "network", this.network);
            printWriter.printf("%1$20s: %2$s\n", "host", this.host);
            printWriter.printf("%1$20s: %2$s\n", "MAC", this.MAC);
            printWriter.printf("%1$20s: %2$s\n", "MTU", this.MTU);
            printWriter.printf("%1$20s: %2$s\n", "VLAN", this.VLAN);
            printWriter.printf("%1$20s: %2$s\n", "metrics", this.metrics);
            printWriter.printf("%1$20s: %2$s\n", "physical", this.physical);
            printWriter.printf("%1$20s: %2$s\n", "currentlyAttached", this.currentlyAttached);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"ipConfigurationMode", this.ipConfigurationMode});
            printWriter.printf("%1$20s: %2$s\n", "IP", this.IP);
            printWriter.printf("%1$20s: %2$s\n", "netmask", this.netmask);
            printWriter.printf("%1$20s: %2$s\n", "gateway", this.gateway);
            printWriter.printf("%1$20s: %2$s\n", "DNS", this.DNS);
            printWriter.printf("%1$20s: %2$s\n", "bondSlaveOf", this.bondSlaveOf);
            printWriter.printf("%1$20s: %2$s\n", "bondMasterOf", this.bondMasterOf);
            printWriter.printf("%1$20s: %2$s\n", "VLANMasterOf", this.VLANMasterOf);
            printWriter.printf("%1$20s: %2$s\n", "VLANSlaveOf", this.VLANSlaveOf);
            printWriter.printf("%1$20s: %2$s\n", "management", this.management);
            printWriter.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            printWriter.printf("%1$20s: %2$s\n", "disallowUnplug", this.disallowUnplug);
            printWriter.printf("%1$20s: %2$s\n", "tunnelAccessPIFOf", this.tunnelAccessPIFOf);
            printWriter.printf("%1$20s: %2$s\n", "tunnelTransportPIFOf", this.tunnelTransportPIFOf);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"ipv6ConfigurationMode", this.ipv6ConfigurationMode});
            printWriter.printf("%1$20s: %2$s\n", "IPv6", this.IPv6);
            printWriter.printf("%1$20s: %2$s\n", "ipv6Gateway", this.ipv6Gateway);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"primaryAddressType", this.primaryAddressType});
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("device", this.device == null ? "" : this.device);
            hashMap.put("network", this.network == null ? new Network("OpaqueRef:NULL") : this.network);
            hashMap.put("host", this.host == null ? new Host("OpaqueRef:NULL") : this.host);
            hashMap.put("MAC", this.MAC == null ? "" : this.MAC);
            hashMap.put("MTU", this.MTU == null ? 0L : this.MTU);
            hashMap.put("VLAN", this.VLAN == null ? 0L : this.VLAN);
            hashMap.put("metrics", this.metrics == null ? new PIFMetrics("OpaqueRef:NULL") : this.metrics);
            hashMap.put("physical", this.physical == null ? false : this.physical);
            hashMap.put("currently_attached", this.currentlyAttached == null ? false : this.currentlyAttached);
            hashMap.put("ip_configuration_mode", (Object)(this.ipConfigurationMode == null ? Types.IpConfigurationMode.UNRECOGNIZED : this.ipConfigurationMode));
            hashMap.put("IP", this.IP == null ? "" : this.IP);
            hashMap.put("netmask", this.netmask == null ? "" : this.netmask);
            hashMap.put("gateway", this.gateway == null ? "" : this.gateway);
            hashMap.put("DNS", this.DNS == null ? "" : this.DNS);
            hashMap.put("bond_slave_of", this.bondSlaveOf == null ? new Bond("OpaqueRef:NULL") : this.bondSlaveOf);
            hashMap.put("bond_master_of", this.bondMasterOf == null ? new LinkedHashSet() : this.bondMasterOf);
            hashMap.put("VLAN_master_of", this.VLANMasterOf == null ? new VLAN("OpaqueRef:NULL") : this.VLANMasterOf);
            hashMap.put("VLAN_slave_of", this.VLANSlaveOf == null ? new LinkedHashSet() : this.VLANSlaveOf);
            hashMap.put("management", this.management == null ? false : this.management);
            hashMap.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            hashMap.put("disallow_unplug", this.disallowUnplug == null ? false : this.disallowUnplug);
            hashMap.put("tunnel_access_PIF_of", this.tunnelAccessPIFOf == null ? new LinkedHashSet() : this.tunnelAccessPIFOf);
            hashMap.put("tunnel_transport_PIF_of", this.tunnelTransportPIFOf == null ? new LinkedHashSet() : this.tunnelTransportPIFOf);
            hashMap.put("ipv6_configuration_mode", (Object)(this.ipv6ConfigurationMode == null ? Types.Ipv6ConfigurationMode.UNRECOGNIZED : this.ipv6ConfigurationMode));
            hashMap.put("IPv6", this.IPv6 == null ? new LinkedHashSet() : this.IPv6);
            hashMap.put("ipv6_gateway", this.ipv6Gateway == null ? "" : this.ipv6Gateway);
            hashMap.put("primary_address_type", (Object)(this.primaryAddressType == null ? Types.PrimaryAddressType.UNRECOGNIZED : this.primaryAddressType));
            return hashMap;
        }
    }
}

