
#pragma once

#include <cstdlib>

namespace unicode {

const char32_t START_OF_HEADING = 0x0001;
const char32_t START_OF_TEXT = 0x0002;
const char32_t END_OF_TEXT = 0x0003;
const char32_t END_OF_TRANSMISSION = 0x0004;
const char32_t ENQUIRY = 0x0005;
const char32_t ACKNOWLEDGE = 0x0006;
const char32_t ALERT = 0x0007;
const char32_t BACKSPACE = 0x0008;
const char32_t CHARACTER_TABULATION = 0x0009;
const char32_t LINE_FEED = 0x000A;
const char32_t LINE_TABULATION = 0x000B;
const char32_t FORM_FEED = 0x000C;
const char32_t CARRIAGE_RETURN = 0x000D;
const char32_t SHIFT_OUT = 0x000E;
const char32_t SHIFT_IN = 0x000F;
const char32_t DATA_LINK_ESCAPE = 0x0010;
const char32_t DEVICE_CONTROL_ONE = 0x0011;
const char32_t DEVICE_CONTROL_TWO = 0x0012;
const char32_t DEVICE_CONTROL_THREE = 0x0013;
const char32_t DEVICE_CONTROL_FOUR = 0x0014;
const char32_t NEGATIVE_ACKNOWLEDGE = 0x0015;
const char32_t SYNCHRONOUS_IDLE = 0x0016;
const char32_t END_OF_TRANSMISSION_BLOCK = 0x0017;
const char32_t CANCEL = 0x0018;
const char32_t END_OF_MEDIUM = 0x0019;
const char32_t SUBSTITUTE = 0x001A;
const char32_t ESCAPE = 0x001B;
const char32_t INFORMATION_SEPARATOR_FOUR = 0x001C;
const char32_t INFORMATION_SEPARATOR_THREE = 0x001D;
const char32_t INFORMATION_SEPARATOR_TWO = 0x001E;
const char32_t INFORMATION_SEPARATOR_ONE = 0x001F;
const char32_t SPACE = 0x0020;
const char32_t EXCLAMATION_MARK = 0x0021;
const char32_t QUOTATION_MARK = 0x0022;
const char32_t NUMBER_SIGN = 0x0023;
const char32_t DOLLAR_SIGN = 0x0024;
const char32_t PERCENT_SIGN = 0x0025;
const char32_t AMPERSAND = 0x0026;
const char32_t APOSTROPHE = 0x0027;
const char32_t LEFT_PARENTHESIS = 0x0028;
const char32_t RIGHT_PARENTHESIS = 0x0029;
const char32_t ASTERISK = 0x002A;
const char32_t PLUS_SIGN = 0x002B;
const char32_t COMMA = 0x002C;
const char32_t HYPHEN_MINUS = 0x002D;
const char32_t FULL_STOP = 0x002E;
const char32_t SOLIDUS = 0x002F;
const char32_t DIGIT_ZERO = 0x0030;
const char32_t DIGIT_ONE = 0x0031;
const char32_t DIGIT_TWO = 0x0032;
const char32_t DIGIT_THREE = 0x0033;
const char32_t DIGIT_FOUR = 0x0034;
const char32_t DIGIT_FIVE = 0x0035;
const char32_t DIGIT_SIX = 0x0036;
const char32_t DIGIT_SEVEN = 0x0037;
const char32_t DIGIT_EIGHT = 0x0038;
const char32_t DIGIT_NINE = 0x0039;
const char32_t COLON = 0x003A;
const char32_t SEMICOLON = 0x003B;
const char32_t LESS_THAN_SIGN = 0x003C;
const char32_t EQUALS_SIGN = 0x003D;
const char32_t GREATER_THAN_SIGN = 0x003E;
const char32_t QUESTION_MARK = 0x003F;
const char32_t COMMERCIAL_AT = 0x0040;
const char32_t LATIN_CAPITAL_LETTER_A = 0x0041;
const char32_t LATIN_CAPITAL_LETTER_B = 0x0042;
const char32_t LATIN_CAPITAL_LETTER_C = 0x0043;
const char32_t LATIN_CAPITAL_LETTER_D = 0x0044;
const char32_t LATIN_CAPITAL_LETTER_E = 0x0045;
const char32_t LATIN_CAPITAL_LETTER_F = 0x0046;
const char32_t LATIN_CAPITAL_LETTER_G = 0x0047;
const char32_t LATIN_CAPITAL_LETTER_H = 0x0048;
const char32_t LATIN_CAPITAL_LETTER_I = 0x0049;
const char32_t LATIN_CAPITAL_LETTER_J = 0x004A;
const char32_t LATIN_CAPITAL_LETTER_K = 0x004B;
const char32_t LATIN_CAPITAL_LETTER_L = 0x004C;
const char32_t LATIN_CAPITAL_LETTER_M = 0x004D;
const char32_t LATIN_CAPITAL_LETTER_N = 0x004E;
const char32_t LATIN_CAPITAL_LETTER_O = 0x004F;
const char32_t LATIN_CAPITAL_LETTER_P = 0x0050;
const char32_t LATIN_CAPITAL_LETTER_Q = 0x0051;
const char32_t LATIN_CAPITAL_LETTER_R = 0x0052;
const char32_t LATIN_CAPITAL_LETTER_S = 0x0053;
const char32_t LATIN_CAPITAL_LETTER_T = 0x0054;
const char32_t LATIN_CAPITAL_LETTER_U = 0x0055;
const char32_t LATIN_CAPITAL_LETTER_V = 0x0056;
const char32_t LATIN_CAPITAL_LETTER_W = 0x0057;
const char32_t LATIN_CAPITAL_LETTER_X = 0x0058;
const char32_t LATIN_CAPITAL_LETTER_Y = 0x0059;
const char32_t LATIN_CAPITAL_LETTER_Z = 0x005A;
const char32_t LEFT_SQUARE_BRACKET = 0x005B;
const char32_t REVERSE_SOLIDUS = 0x005C;
const char32_t RIGHT_SQUARE_BRACKET = 0x005D;
const char32_t CIRCUMFLEX_ACCENT = 0x005E;
const char32_t LOW_LINE = 0x005F;
const char32_t GRAVE_ACCENT = 0x0060;
const char32_t LATIN_SMALL_LETTER_A = 0x0061;
const char32_t LATIN_SMALL_LETTER_B = 0x0062;
const char32_t LATIN_SMALL_LETTER_C = 0x0063;
const char32_t LATIN_SMALL_LETTER_D = 0x0064;
const char32_t LATIN_SMALL_LETTER_E = 0x0065;
const char32_t LATIN_SMALL_LETTER_F = 0x0066;
const char32_t LATIN_SMALL_LETTER_G = 0x0067;
const char32_t LATIN_SMALL_LETTER_H = 0x0068;
const char32_t LATIN_SMALL_LETTER_I = 0x0069;
const char32_t LATIN_SMALL_LETTER_J = 0x006A;
const char32_t LATIN_SMALL_LETTER_K = 0x006B;
const char32_t LATIN_SMALL_LETTER_L = 0x006C;
const char32_t LATIN_SMALL_LETTER_M = 0x006D;
const char32_t LATIN_SMALL_LETTER_N = 0x006E;
const char32_t LATIN_SMALL_LETTER_O = 0x006F;
const char32_t LATIN_SMALL_LETTER_P = 0x0070;
const char32_t LATIN_SMALL_LETTER_Q = 0x0071;
const char32_t LATIN_SMALL_LETTER_R = 0x0072;
const char32_t LATIN_SMALL_LETTER_S = 0x0073;
const char32_t LATIN_SMALL_LETTER_T = 0x0074;
const char32_t LATIN_SMALL_LETTER_U = 0x0075;
const char32_t LATIN_SMALL_LETTER_V = 0x0076;
const char32_t LATIN_SMALL_LETTER_W = 0x0077;
const char32_t LATIN_SMALL_LETTER_X = 0x0078;
const char32_t LATIN_SMALL_LETTER_Y = 0x0079;
const char32_t LATIN_SMALL_LETTER_Z = 0x007A;
const char32_t LEFT_CURLY_BRACKET = 0x007B;
const char32_t VERTICAL_LINE = 0x007C;
const char32_t RIGHT_CURLY_BRACKET = 0x007D;
const char32_t TILDE = 0x007E;
const char32_t DELETE = 0x007F;
const char32_t PADDING_CHARACTER = 0x0080;
const char32_t HIGH_OCTET_PRESET = 0x0081;
const char32_t BREAK_PERMITTED_HERE = 0x0082;
const char32_t NO_BREAK_HERE = 0x0083;
const char32_t INDEX = 0x0084;
const char32_t NEXT_LINE = 0x0085;
const char32_t START_OF_SELECTED_AREA = 0x0086;
const char32_t END_OF_SELECTED_AREA = 0x0087;
const char32_t CHARACTER_TABULATION_SET = 0x0088;
const char32_t CHARACTER_TABULATION_WITH_JUSTIFICATION = 0x0089;
const char32_t LINE_TABULATION_SET = 0x008A;
const char32_t PARTIAL_LINE_FORWARD = 0x008B;
const char32_t PARTIAL_LINE_BACKWARD = 0x008C;
const char32_t REVERSE_LINE_FEED = 0x008D;
const char32_t SINGLE_SHIFT_TWO = 0x008E;
const char32_t SINGLE_SHIFT_THREE = 0x008F;
const char32_t DEVICE_CONTROL_STRING = 0x0090;
const char32_t PRIVATE_USE_ONE = 0x0091;
const char32_t PRIVATE_USE_TWO = 0x0092;
const char32_t SET_TRANSMIT_STATE = 0x0093;
const char32_t CANCEL_CHARACTER = 0x0094;
const char32_t MESSAGE_WAITING = 0x0095;
const char32_t START_OF_GUARDED_AREA = 0x0096;
const char32_t END_OF_GUARDED_AREA = 0x0097;
const char32_t START_OF_STRING = 0x0098;
const char32_t SINGLE_GRAPHIC_CHARACTER_INTRODUCER = 0x0099;
const char32_t SINGLE_CHARACTER_INTRODUCER = 0x009A;
const char32_t CONTROL_SEQUENCE_INTRODUCER = 0x009B;
const char32_t STRING_TERMINATOR = 0x009C;
const char32_t OPERATING_SYSTEM_COMMAND = 0x009D;
const char32_t PRIVACY_MESSAGE = 0x009E;
const char32_t APPLICATION_PROGRAM_COMMAND = 0x009F;
const char32_t NO_BREAK_SPACE = 0x00A0;
const char32_t INVERTED_EXCLAMATION_MARK = 0x00A1;
const char32_t CENT_SIGN = 0x00A2;
const char32_t POUND_SIGN = 0x00A3;
const char32_t CURRENCY_SIGN = 0x00A4;
const char32_t YEN_SIGN = 0x00A5;
const char32_t BROKEN_BAR = 0x00A6;
const char32_t SECTION_SIGN = 0x00A7;
const char32_t DIAERESIS = 0x00A8;
const char32_t COPYRIGHT_SIGN = 0x00A9;
const char32_t FEMININE_ORDINAL_INDICATOR = 0x00AA;
const char32_t LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK = 0x00AB;
const char32_t NOT_SIGN = 0x00AC;
const char32_t SOFT_HYPHEN = 0x00AD;
const char32_t REGISTERED_SIGN = 0x00AE;
const char32_t MACRON = 0x00AF;
const char32_t DEGREE_SIGN = 0x00B0;
const char32_t PLUS_MINUS_SIGN = 0x00B1;
const char32_t SUPERSCRIPT_TWO = 0x00B2;
const char32_t SUPERSCRIPT_THREE = 0x00B3;
const char32_t ACUTE_ACCENT = 0x00B4;
const char32_t MICRO_SIGN = 0x00B5;
const char32_t PILCROW_SIGN = 0x00B6;
const char32_t MIDDLE_DOT = 0x00B7;
const char32_t CEDILLA = 0x00B8;
const char32_t SUPERSCRIPT_ONE = 0x00B9;
const char32_t MASCULINE_ORDINAL_INDICATOR = 0x00BA;
const char32_t RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK = 0x00BB;
const char32_t VULGAR_FRACTION_ONE_QUARTER = 0x00BC;
const char32_t VULGAR_FRACTION_ONE_HALF = 0x00BD;
const char32_t VULGAR_FRACTION_THREE_QUARTERS = 0x00BE;
const char32_t INVERTED_QUESTION_MARK = 0x00BF;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_GRAVE = 0x00C0;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_ACUTE = 0x00C1;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX = 0x00C2;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_TILDE = 0x00C3;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS = 0x00C4;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE = 0x00C5;
const char32_t LATIN_CAPITAL_LETTER_AE = 0x00C6;
const char32_t LATIN_CAPITAL_LETTER_C_WITH_CEDILLA = 0x00C7;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_GRAVE = 0x00C8;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_ACUTE = 0x00C9;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX = 0x00CA;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS = 0x00CB;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_GRAVE = 0x00CC;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_ACUTE = 0x00CD;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX = 0x00CE;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS = 0x00CF;
const char32_t LATIN_CAPITAL_LETTER_ETH = 0x00D0;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_TILDE = 0x00D1;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_GRAVE = 0x00D2;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_ACUTE = 0x00D3;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX = 0x00D4;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_TILDE = 0x00D5;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS = 0x00D6;
const char32_t MULTIPLICATION_SIGN = 0x00D7;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_STROKE = 0x00D8;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_GRAVE = 0x00D9;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_ACUTE = 0x00DA;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX = 0x00DB;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS = 0x00DC;
const char32_t LATIN_CAPITAL_LETTER_Y_WITH_ACUTE = 0x00DD;
const char32_t LATIN_CAPITAL_LETTER_THORN = 0x00DE;
const char32_t LATIN_SMALL_LETTER_SHARP_S = 0x00DF;
const char32_t LATIN_SMALL_LETTER_A_WITH_GRAVE = 0x00E0;
const char32_t LATIN_SMALL_LETTER_A_WITH_ACUTE = 0x00E1;
const char32_t LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX = 0x00E2;
const char32_t LATIN_SMALL_LETTER_A_WITH_TILDE = 0x00E3;
const char32_t LATIN_SMALL_LETTER_A_WITH_DIAERESIS = 0x00E4;
const char32_t LATIN_SMALL_LETTER_A_WITH_RING_ABOVE = 0x00E5;
const char32_t LATIN_SMALL_LETTER_AE = 0x00E6;
const char32_t LATIN_SMALL_LETTER_C_WITH_CEDILLA = 0x00E7;
const char32_t LATIN_SMALL_LETTER_E_WITH_GRAVE = 0x00E8;
const char32_t LATIN_SMALL_LETTER_E_WITH_ACUTE = 0x00E9;
const char32_t LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX = 0x00EA;
const char32_t LATIN_SMALL_LETTER_E_WITH_DIAERESIS = 0x00EB;
const char32_t LATIN_SMALL_LETTER_I_WITH_GRAVE = 0x00EC;
const char32_t LATIN_SMALL_LETTER_I_WITH_ACUTE = 0x00ED;
const char32_t LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX = 0x00EE;
const char32_t LATIN_SMALL_LETTER_I_WITH_DIAERESIS = 0x00EF;
const char32_t LATIN_SMALL_LETTER_ETH = 0x00F0;
const char32_t LATIN_SMALL_LETTER_N_WITH_TILDE = 0x00F1;
const char32_t LATIN_SMALL_LETTER_O_WITH_GRAVE = 0x00F2;
const char32_t LATIN_SMALL_LETTER_O_WITH_ACUTE = 0x00F3;
const char32_t LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX = 0x00F4;
const char32_t LATIN_SMALL_LETTER_O_WITH_TILDE = 0x00F5;
const char32_t LATIN_SMALL_LETTER_O_WITH_DIAERESIS = 0x00F6;
const char32_t DIVISION_SIGN = 0x00F7;
const char32_t LATIN_SMALL_LETTER_O_WITH_STROKE = 0x00F8;
const char32_t LATIN_SMALL_LETTER_U_WITH_GRAVE = 0x00F9;
const char32_t LATIN_SMALL_LETTER_U_WITH_ACUTE = 0x00FA;
const char32_t LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX = 0x00FB;
const char32_t LATIN_SMALL_LETTER_U_WITH_DIAERESIS = 0x00FC;
const char32_t LATIN_SMALL_LETTER_Y_WITH_ACUTE = 0x00FD;
const char32_t LATIN_SMALL_LETTER_THORN = 0x00FE;
const char32_t LATIN_SMALL_LETTER_Y_WITH_DIAERESIS = 0x00FF;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_MACRON = 0x0100;
const char32_t LATIN_SMALL_LETTER_A_WITH_MACRON = 0x0101;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_BREVE = 0x0102;
const char32_t LATIN_SMALL_LETTER_A_WITH_BREVE = 0x0103;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_OGONEK = 0x0104;
const char32_t LATIN_SMALL_LETTER_A_WITH_OGONEK = 0x0105;
const char32_t LATIN_CAPITAL_LETTER_C_WITH_ACUTE = 0x0106;
const char32_t LATIN_SMALL_LETTER_C_WITH_ACUTE = 0x0107;
const char32_t LATIN_CAPITAL_LETTER_C_WITH_CIRCUMFLEX = 0x0108;
const char32_t LATIN_SMALL_LETTER_C_WITH_CIRCUMFLEX = 0x0109;
const char32_t LATIN_CAPITAL_LETTER_C_WITH_DOT_ABOVE = 0x010A;
const char32_t LATIN_SMALL_LETTER_C_WITH_DOT_ABOVE = 0x010B;
const char32_t LATIN_CAPITAL_LETTER_C_WITH_CARON = 0x010C;
const char32_t LATIN_SMALL_LETTER_C_WITH_CARON = 0x010D;
const char32_t LATIN_CAPITAL_LETTER_D_WITH_CARON = 0x010E;
const char32_t LATIN_SMALL_LETTER_D_WITH_CARON = 0x010F;
const char32_t LATIN_CAPITAL_LETTER_D_WITH_STROKE = 0x0110;
const char32_t LATIN_SMALL_LETTER_D_WITH_STROKE = 0x0111;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_MACRON = 0x0112;
const char32_t LATIN_SMALL_LETTER_E_WITH_MACRON = 0x0113;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_BREVE = 0x0114;
const char32_t LATIN_SMALL_LETTER_E_WITH_BREVE = 0x0115;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_DOT_ABOVE = 0x0116;
const char32_t LATIN_SMALL_LETTER_E_WITH_DOT_ABOVE = 0x0117;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_OGONEK = 0x0118;
const char32_t LATIN_SMALL_LETTER_E_WITH_OGONEK = 0x0119;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_CARON = 0x011A;
const char32_t LATIN_SMALL_LETTER_E_WITH_CARON = 0x011B;
const char32_t LATIN_CAPITAL_LETTER_G_WITH_CIRCUMFLEX = 0x011C;
const char32_t LATIN_SMALL_LETTER_G_WITH_CIRCUMFLEX = 0x011D;
const char32_t LATIN_CAPITAL_LETTER_G_WITH_BREVE = 0x011E;
const char32_t LATIN_SMALL_LETTER_G_WITH_BREVE = 0x011F;
const char32_t LATIN_CAPITAL_LETTER_G_WITH_DOT_ABOVE = 0x0120;
const char32_t LATIN_SMALL_LETTER_G_WITH_DOT_ABOVE = 0x0121;
const char32_t LATIN_CAPITAL_LETTER_G_WITH_CEDILLA = 0x0122;
const char32_t LATIN_SMALL_LETTER_G_WITH_CEDILLA = 0x0123;
const char32_t LATIN_CAPITAL_LETTER_H_WITH_CIRCUMFLEX = 0x0124;
const char32_t LATIN_SMALL_LETTER_H_WITH_CIRCUMFLEX = 0x0125;
const char32_t LATIN_CAPITAL_LETTER_H_WITH_STROKE = 0x0126;
const char32_t LATIN_SMALL_LETTER_H_WITH_STROKE = 0x0127;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_TILDE = 0x0128;
const char32_t LATIN_SMALL_LETTER_I_WITH_TILDE = 0x0129;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_MACRON = 0x012A;
const char32_t LATIN_SMALL_LETTER_I_WITH_MACRON = 0x012B;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_BREVE = 0x012C;
const char32_t LATIN_SMALL_LETTER_I_WITH_BREVE = 0x012D;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_OGONEK = 0x012E;
const char32_t LATIN_SMALL_LETTER_I_WITH_OGONEK = 0x012F;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE = 0x0130;
const char32_t LATIN_SMALL_LETTER_DOTLESS_I = 0x0131;
const char32_t LATIN_CAPITAL_LIGATURE_IJ = 0x0132;
const char32_t LATIN_SMALL_LIGATURE_IJ = 0x0133;
const char32_t LATIN_CAPITAL_LETTER_J_WITH_CIRCUMFLEX = 0x0134;
const char32_t LATIN_SMALL_LETTER_J_WITH_CIRCUMFLEX = 0x0135;
const char32_t LATIN_CAPITAL_LETTER_K_WITH_CEDILLA = 0x0136;
const char32_t LATIN_SMALL_LETTER_K_WITH_CEDILLA = 0x0137;
const char32_t LATIN_SMALL_LETTER_KRA = 0x0138;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_ACUTE = 0x0139;
const char32_t LATIN_SMALL_LETTER_L_WITH_ACUTE = 0x013A;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_CEDILLA = 0x013B;
const char32_t LATIN_SMALL_LETTER_L_WITH_CEDILLA = 0x013C;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_CARON = 0x013D;
const char32_t LATIN_SMALL_LETTER_L_WITH_CARON = 0x013E;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_MIDDLE_DOT = 0x013F;
const char32_t LATIN_SMALL_LETTER_L_WITH_MIDDLE_DOT = 0x0140;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_STROKE = 0x0141;
const char32_t LATIN_SMALL_LETTER_L_WITH_STROKE = 0x0142;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_ACUTE = 0x0143;
const char32_t LATIN_SMALL_LETTER_N_WITH_ACUTE = 0x0144;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_CEDILLA = 0x0145;
const char32_t LATIN_SMALL_LETTER_N_WITH_CEDILLA = 0x0146;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_CARON = 0x0147;
const char32_t LATIN_SMALL_LETTER_N_WITH_CARON = 0x0148;
const char32_t LATIN_SMALL_LETTER_N_PRECEDED_BY_APOSTROPHE = 0x0149;
const char32_t LATIN_CAPITAL_LETTER_ENG = 0x014A;
const char32_t LATIN_SMALL_LETTER_ENG = 0x014B;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_MACRON = 0x014C;
const char32_t LATIN_SMALL_LETTER_O_WITH_MACRON = 0x014D;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_BREVE = 0x014E;
const char32_t LATIN_SMALL_LETTER_O_WITH_BREVE = 0x014F;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_ACUTE = 0x0150;
const char32_t LATIN_SMALL_LETTER_O_WITH_DOUBLE_ACUTE = 0x0151;
const char32_t LATIN_CAPITAL_LIGATURE_OE = 0x0152;
const char32_t LATIN_SMALL_LIGATURE_OE = 0x0153;
const char32_t LATIN_CAPITAL_LETTER_R_WITH_ACUTE = 0x0154;
const char32_t LATIN_SMALL_LETTER_R_WITH_ACUTE = 0x0155;
const char32_t LATIN_CAPITAL_LETTER_R_WITH_CEDILLA = 0x0156;
const char32_t LATIN_SMALL_LETTER_R_WITH_CEDILLA = 0x0157;
const char32_t LATIN_CAPITAL_LETTER_R_WITH_CARON = 0x0158;
const char32_t LATIN_SMALL_LETTER_R_WITH_CARON = 0x0159;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_ACUTE = 0x015A;
const char32_t LATIN_SMALL_LETTER_S_WITH_ACUTE = 0x015B;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_CIRCUMFLEX = 0x015C;
const char32_t LATIN_SMALL_LETTER_S_WITH_CIRCUMFLEX = 0x015D;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_CEDILLA = 0x015E;
const char32_t LATIN_SMALL_LETTER_S_WITH_CEDILLA = 0x015F;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_CARON = 0x0160;
const char32_t LATIN_SMALL_LETTER_S_WITH_CARON = 0x0161;
const char32_t LATIN_CAPITAL_LETTER_T_WITH_CEDILLA = 0x0162;
const char32_t LATIN_SMALL_LETTER_T_WITH_CEDILLA = 0x0163;
const char32_t LATIN_CAPITAL_LETTER_T_WITH_CARON = 0x0164;
const char32_t LATIN_SMALL_LETTER_T_WITH_CARON = 0x0165;
const char32_t LATIN_CAPITAL_LETTER_T_WITH_STROKE = 0x0166;
const char32_t LATIN_SMALL_LETTER_T_WITH_STROKE = 0x0167;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_TILDE = 0x0168;
const char32_t LATIN_SMALL_LETTER_U_WITH_TILDE = 0x0169;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_MACRON = 0x016A;
const char32_t LATIN_SMALL_LETTER_U_WITH_MACRON = 0x016B;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_BREVE = 0x016C;
const char32_t LATIN_SMALL_LETTER_U_WITH_BREVE = 0x016D;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_RING_ABOVE = 0x016E;
const char32_t LATIN_SMALL_LETTER_U_WITH_RING_ABOVE = 0x016F;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE = 0x0170;
const char32_t LATIN_SMALL_LETTER_U_WITH_DOUBLE_ACUTE = 0x0171;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_OGONEK = 0x0172;
const char32_t LATIN_SMALL_LETTER_U_WITH_OGONEK = 0x0173;
const char32_t LATIN_CAPITAL_LETTER_W_WITH_CIRCUMFLEX = 0x0174;
const char32_t LATIN_SMALL_LETTER_W_WITH_CIRCUMFLEX = 0x0175;
const char32_t LATIN_CAPITAL_LETTER_Y_WITH_CIRCUMFLEX = 0x0176;
const char32_t LATIN_SMALL_LETTER_Y_WITH_CIRCUMFLEX = 0x0177;
const char32_t LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS = 0x0178;
const char32_t LATIN_CAPITAL_LETTER_Z_WITH_ACUTE = 0x0179;
const char32_t LATIN_SMALL_LETTER_Z_WITH_ACUTE = 0x017A;
const char32_t LATIN_CAPITAL_LETTER_Z_WITH_DOT_ABOVE = 0x017B;
const char32_t LATIN_SMALL_LETTER_Z_WITH_DOT_ABOVE = 0x017C;
const char32_t LATIN_CAPITAL_LETTER_Z_WITH_CARON = 0x017D;
const char32_t LATIN_SMALL_LETTER_Z_WITH_CARON = 0x017E;
const char32_t LATIN_SMALL_LETTER_LONG_S = 0x017F;
const char32_t LATIN_SMALL_LETTER_B_WITH_STROKE = 0x0180;
const char32_t LATIN_CAPITAL_LETTER_B_WITH_HOOK = 0x0181;
const char32_t LATIN_CAPITAL_LETTER_B_WITH_TOPBAR = 0x0182;
const char32_t LATIN_SMALL_LETTER_B_WITH_TOPBAR = 0x0183;
const char32_t LATIN_CAPITAL_LETTER_TONE_SIX = 0x0184;
const char32_t LATIN_SMALL_LETTER_TONE_SIX = 0x0185;
const char32_t LATIN_CAPITAL_LETTER_OPEN_O = 0x0186;
const char32_t LATIN_CAPITAL_LETTER_C_WITH_HOOK = 0x0187;
const char32_t LATIN_SMALL_LETTER_C_WITH_HOOK = 0x0188;
const char32_t LATIN_CAPITAL_LETTER_AFRICAN_D = 0x0189;
const char32_t LATIN_CAPITAL_LETTER_D_WITH_HOOK = 0x018A;
const char32_t LATIN_CAPITAL_LETTER_D_WITH_TOPBAR = 0x018B;
const char32_t LATIN_SMALL_LETTER_D_WITH_TOPBAR = 0x018C;
const char32_t LATIN_SMALL_LETTER_TURNED_DELTA = 0x018D;
const char32_t LATIN_CAPITAL_LETTER_REVERSED_E = 0x018E;
const char32_t LATIN_CAPITAL_LETTER_SCHWA = 0x018F;
const char32_t LATIN_CAPITAL_LETTER_OPEN_E = 0x0190;
const char32_t LATIN_CAPITAL_LETTER_F_WITH_HOOK = 0x0191;
const char32_t LATIN_SMALL_LETTER_F_WITH_HOOK = 0x0192;
const char32_t LATIN_CAPITAL_LETTER_G_WITH_HOOK = 0x0193;
const char32_t LATIN_CAPITAL_LETTER_GAMMA = 0x0194;
const char32_t LATIN_SMALL_LETTER_HV = 0x0195;
const char32_t LATIN_CAPITAL_LETTER_IOTA = 0x0196;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_STROKE = 0x0197;
const char32_t LATIN_CAPITAL_LETTER_K_WITH_HOOK = 0x0198;
const char32_t LATIN_SMALL_LETTER_K_WITH_HOOK = 0x0199;
const char32_t LATIN_SMALL_LETTER_L_WITH_BAR = 0x019A;
const char32_t LATIN_SMALL_LETTER_LAMBDA_WITH_STROKE = 0x019B;
const char32_t LATIN_CAPITAL_LETTER_TURNED_M = 0x019C;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_LEFT_HOOK = 0x019D;
const char32_t LATIN_SMALL_LETTER_N_WITH_LONG_RIGHT_LEG = 0x019E;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_MIDDLE_TILDE = 0x019F;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_HORN = 0x01A0;
const char32_t LATIN_SMALL_LETTER_O_WITH_HORN = 0x01A1;
const char32_t LATIN_CAPITAL_LETTER_OI = 0x01A2;
const char32_t LATIN_SMALL_LETTER_OI = 0x01A3;
const char32_t LATIN_CAPITAL_LETTER_P_WITH_HOOK = 0x01A4;
const char32_t LATIN_SMALL_LETTER_P_WITH_HOOK = 0x01A5;
const char32_t LATIN_LETTER_YR = 0x01A6;
const char32_t LATIN_CAPITAL_LETTER_TONE_TWO = 0x01A7;
const char32_t LATIN_SMALL_LETTER_TONE_TWO = 0x01A8;
const char32_t LATIN_CAPITAL_LETTER_ESH = 0x01A9;
const char32_t LATIN_LETTER_REVERSED_ESH_LOOP = 0x01AA;
const char32_t LATIN_SMALL_LETTER_T_WITH_PALATAL_HOOK = 0x01AB;
const char32_t LATIN_CAPITAL_LETTER_T_WITH_HOOK = 0x01AC;
const char32_t LATIN_SMALL_LETTER_T_WITH_HOOK = 0x01AD;
const char32_t LATIN_CAPITAL_LETTER_T_WITH_RETROFLEX_HOOK = 0x01AE;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_HORN = 0x01AF;
const char32_t LATIN_SMALL_LETTER_U_WITH_HORN = 0x01B0;
const char32_t LATIN_CAPITAL_LETTER_UPSILON = 0x01B1;
const char32_t LATIN_CAPITAL_LETTER_V_WITH_HOOK = 0x01B2;
const char32_t LATIN_CAPITAL_LETTER_Y_WITH_HOOK = 0x01B3;
const char32_t LATIN_SMALL_LETTER_Y_WITH_HOOK = 0x01B4;
const char32_t LATIN_CAPITAL_LETTER_Z_WITH_STROKE = 0x01B5;
const char32_t LATIN_SMALL_LETTER_Z_WITH_STROKE = 0x01B6;
const char32_t LATIN_CAPITAL_LETTER_EZH = 0x01B7;
const char32_t LATIN_CAPITAL_LETTER_EZH_REVERSED = 0x01B8;
const char32_t LATIN_SMALL_LETTER_EZH_REVERSED = 0x01B9;
const char32_t LATIN_SMALL_LETTER_EZH_WITH_TAIL = 0x01BA;
const char32_t LATIN_LETTER_TWO_WITH_STROKE = 0x01BB;
const char32_t LATIN_CAPITAL_LETTER_TONE_FIVE = 0x01BC;
const char32_t LATIN_SMALL_LETTER_TONE_FIVE = 0x01BD;
const char32_t LATIN_LETTER_INVERTED_GLOTTAL_STOP_WITH_STROKE = 0x01BE;
const char32_t LATIN_LETTER_WYNN = 0x01BF;
const char32_t LATIN_LETTER_DENTAL_CLICK = 0x01C0;
const char32_t LATIN_LETTER_LATERAL_CLICK = 0x01C1;
const char32_t LATIN_LETTER_ALVEOLAR_CLICK = 0x01C2;
const char32_t LATIN_LETTER_RETROFLEX_CLICK = 0x01C3;
const char32_t LATIN_CAPITAL_LETTER_DZ_WITH_CARON = 0x01C4;
const char32_t LATIN_CAPITAL_LETTER_D_WITH_SMALL_LETTER_Z_WITH_CARON = 0x01C5;
const char32_t LATIN_SMALL_LETTER_DZ_WITH_CARON = 0x01C6;
const char32_t LATIN_CAPITAL_LETTER_LJ = 0x01C7;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_SMALL_LETTER_J = 0x01C8;
const char32_t LATIN_SMALL_LETTER_LJ = 0x01C9;
const char32_t LATIN_CAPITAL_LETTER_NJ = 0x01CA;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_SMALL_LETTER_J = 0x01CB;
const char32_t LATIN_SMALL_LETTER_NJ = 0x01CC;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_CARON = 0x01CD;
const char32_t LATIN_SMALL_LETTER_A_WITH_CARON = 0x01CE;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_CARON = 0x01CF;
const char32_t LATIN_SMALL_LETTER_I_WITH_CARON = 0x01D0;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_CARON = 0x01D1;
const char32_t LATIN_SMALL_LETTER_O_WITH_CARON = 0x01D2;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_CARON = 0x01D3;
const char32_t LATIN_SMALL_LETTER_U_WITH_CARON = 0x01D4;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_MACRON = 0x01D5;
const char32_t LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_MACRON = 0x01D6;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_ACUTE = 0x01D7;
const char32_t LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_ACUTE = 0x01D8;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_CARON = 0x01D9;
const char32_t LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_CARON = 0x01DA;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_GRAVE = 0x01DB;
const char32_t LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_GRAVE = 0x01DC;
const char32_t LATIN_SMALL_LETTER_TURNED_E = 0x01DD;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS_AND_MACRON = 0x01DE;
const char32_t LATIN_SMALL_LETTER_A_WITH_DIAERESIS_AND_MACRON = 0x01DF;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_DOT_ABOVE_AND_MACRON = 0x01E0;
const char32_t LATIN_SMALL_LETTER_A_WITH_DOT_ABOVE_AND_MACRON = 0x01E1;
const char32_t LATIN_CAPITAL_LETTER_AE_WITH_MACRON = 0x01E2;
const char32_t LATIN_SMALL_LETTER_AE_WITH_MACRON = 0x01E3;
const char32_t LATIN_CAPITAL_LETTER_G_WITH_STROKE = 0x01E4;
const char32_t LATIN_SMALL_LETTER_G_WITH_STROKE = 0x01E5;
const char32_t LATIN_CAPITAL_LETTER_G_WITH_CARON = 0x01E6;
const char32_t LATIN_SMALL_LETTER_G_WITH_CARON = 0x01E7;
const char32_t LATIN_CAPITAL_LETTER_K_WITH_CARON = 0x01E8;
const char32_t LATIN_SMALL_LETTER_K_WITH_CARON = 0x01E9;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_OGONEK = 0x01EA;
const char32_t LATIN_SMALL_LETTER_O_WITH_OGONEK = 0x01EB;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_OGONEK_AND_MACRON = 0x01EC;
const char32_t LATIN_SMALL_LETTER_O_WITH_OGONEK_AND_MACRON = 0x01ED;
const char32_t LATIN_CAPITAL_LETTER_EZH_WITH_CARON = 0x01EE;
const char32_t LATIN_SMALL_LETTER_EZH_WITH_CARON = 0x01EF;
const char32_t LATIN_SMALL_LETTER_J_WITH_CARON = 0x01F0;
const char32_t LATIN_CAPITAL_LETTER_DZ = 0x01F1;
const char32_t LATIN_CAPITAL_LETTER_D_WITH_SMALL_LETTER_Z = 0x01F2;
const char32_t LATIN_SMALL_LETTER_DZ = 0x01F3;
const char32_t LATIN_CAPITAL_LETTER_G_WITH_ACUTE = 0x01F4;
const char32_t LATIN_SMALL_LETTER_G_WITH_ACUTE = 0x01F5;
const char32_t LATIN_CAPITAL_LETTER_HWAIR = 0x01F6;
const char32_t LATIN_CAPITAL_LETTER_WYNN = 0x01F7;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_GRAVE = 0x01F8;
const char32_t LATIN_SMALL_LETTER_N_WITH_GRAVE = 0x01F9;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE_AND_ACUTE = 0x01FA;
const char32_t LATIN_SMALL_LETTER_A_WITH_RING_ABOVE_AND_ACUTE = 0x01FB;
const char32_t LATIN_CAPITAL_LETTER_AE_WITH_ACUTE = 0x01FC;
const char32_t LATIN_SMALL_LETTER_AE_WITH_ACUTE = 0x01FD;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_STROKE_AND_ACUTE = 0x01FE;
const char32_t LATIN_SMALL_LETTER_O_WITH_STROKE_AND_ACUTE = 0x01FF;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_DOUBLE_GRAVE = 0x0200;
const char32_t LATIN_SMALL_LETTER_A_WITH_DOUBLE_GRAVE = 0x0201;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_INVERTED_BREVE = 0x0202;
const char32_t LATIN_SMALL_LETTER_A_WITH_INVERTED_BREVE = 0x0203;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_DOUBLE_GRAVE = 0x0204;
const char32_t LATIN_SMALL_LETTER_E_WITH_DOUBLE_GRAVE = 0x0205;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_INVERTED_BREVE = 0x0206;
const char32_t LATIN_SMALL_LETTER_E_WITH_INVERTED_BREVE = 0x0207;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_DOUBLE_GRAVE = 0x0208;
const char32_t LATIN_SMALL_LETTER_I_WITH_DOUBLE_GRAVE = 0x0209;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_INVERTED_BREVE = 0x020A;
const char32_t LATIN_SMALL_LETTER_I_WITH_INVERTED_BREVE = 0x020B;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_GRAVE = 0x020C;
const char32_t LATIN_SMALL_LETTER_O_WITH_DOUBLE_GRAVE = 0x020D;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_INVERTED_BREVE = 0x020E;
const char32_t LATIN_SMALL_LETTER_O_WITH_INVERTED_BREVE = 0x020F;
const char32_t LATIN_CAPITAL_LETTER_R_WITH_DOUBLE_GRAVE = 0x0210;
const char32_t LATIN_SMALL_LETTER_R_WITH_DOUBLE_GRAVE = 0x0211;
const char32_t LATIN_CAPITAL_LETTER_R_WITH_INVERTED_BREVE = 0x0212;
const char32_t LATIN_SMALL_LETTER_R_WITH_INVERTED_BREVE = 0x0213;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_GRAVE = 0x0214;
const char32_t LATIN_SMALL_LETTER_U_WITH_DOUBLE_GRAVE = 0x0215;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_INVERTED_BREVE = 0x0216;
const char32_t LATIN_SMALL_LETTER_U_WITH_INVERTED_BREVE = 0x0217;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_COMMA_BELOW = 0x0218;
const char32_t LATIN_SMALL_LETTER_S_WITH_COMMA_BELOW = 0x0219;
const char32_t LATIN_CAPITAL_LETTER_T_WITH_COMMA_BELOW = 0x021A;
const char32_t LATIN_SMALL_LETTER_T_WITH_COMMA_BELOW = 0x021B;
const char32_t LATIN_CAPITAL_LETTER_YOGH = 0x021C;
const char32_t LATIN_SMALL_LETTER_YOGH = 0x021D;
const char32_t LATIN_CAPITAL_LETTER_H_WITH_CARON = 0x021E;
const char32_t LATIN_SMALL_LETTER_H_WITH_CARON = 0x021F;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_LONG_RIGHT_LEG = 0x0220;
const char32_t LATIN_SMALL_LETTER_D_WITH_CURL = 0x0221;
const char32_t LATIN_CAPITAL_LETTER_OU = 0x0222;
const char32_t LATIN_SMALL_LETTER_OU = 0x0223;
const char32_t LATIN_CAPITAL_LETTER_Z_WITH_HOOK = 0x0224;
const char32_t LATIN_SMALL_LETTER_Z_WITH_HOOK = 0x0225;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_DOT_ABOVE = 0x0226;
const char32_t LATIN_SMALL_LETTER_A_WITH_DOT_ABOVE = 0x0227;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_CEDILLA = 0x0228;
const char32_t LATIN_SMALL_LETTER_E_WITH_CEDILLA = 0x0229;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS_AND_MACRON = 0x022A;
const char32_t LATIN_SMALL_LETTER_O_WITH_DIAERESIS_AND_MACRON = 0x022B;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_MACRON = 0x022C;
const char32_t LATIN_SMALL_LETTER_O_WITH_TILDE_AND_MACRON = 0x022D;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_DOT_ABOVE = 0x022E;
const char32_t LATIN_SMALL_LETTER_O_WITH_DOT_ABOVE = 0x022F;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_DOT_ABOVE_AND_MACRON = 0x0230;
const char32_t LATIN_SMALL_LETTER_O_WITH_DOT_ABOVE_AND_MACRON = 0x0231;
const char32_t LATIN_CAPITAL_LETTER_Y_WITH_MACRON = 0x0232;
const char32_t LATIN_SMALL_LETTER_Y_WITH_MACRON = 0x0233;
const char32_t LATIN_SMALL_LETTER_L_WITH_CURL = 0x0234;
const char32_t LATIN_SMALL_LETTER_N_WITH_CURL = 0x0235;
const char32_t LATIN_SMALL_LETTER_T_WITH_CURL = 0x0236;
const char32_t LATIN_SMALL_LETTER_DOTLESS_J = 0x0237;
const char32_t LATIN_SMALL_LETTER_DB_DIGRAPH = 0x0238;
const char32_t LATIN_SMALL_LETTER_QP_DIGRAPH = 0x0239;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_STROKE = 0x023A;
const char32_t LATIN_CAPITAL_LETTER_C_WITH_STROKE = 0x023B;
const char32_t LATIN_SMALL_LETTER_C_WITH_STROKE = 0x023C;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_BAR = 0x023D;
const char32_t LATIN_CAPITAL_LETTER_T_WITH_DIAGONAL_STROKE = 0x023E;
const char32_t LATIN_SMALL_LETTER_S_WITH_SWASH_TAIL = 0x023F;
const char32_t LATIN_SMALL_LETTER_Z_WITH_SWASH_TAIL = 0x0240;
const char32_t LATIN_CAPITAL_LETTER_GLOTTAL_STOP = 0x0241;
const char32_t LATIN_SMALL_LETTER_GLOTTAL_STOP = 0x0242;
const char32_t LATIN_CAPITAL_LETTER_B_WITH_STROKE = 0x0243;
const char32_t LATIN_CAPITAL_LETTER_U_BAR = 0x0244;
const char32_t LATIN_CAPITAL_LETTER_TURNED_V = 0x0245;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_STROKE = 0x0246;
const char32_t LATIN_SMALL_LETTER_E_WITH_STROKE = 0x0247;
const char32_t LATIN_CAPITAL_LETTER_J_WITH_STROKE = 0x0248;
const char32_t LATIN_SMALL_LETTER_J_WITH_STROKE = 0x0249;
const char32_t LATIN_CAPITAL_LETTER_SMALL_Q_WITH_HOOK_TAIL = 0x024A;
const char32_t LATIN_SMALL_LETTER_Q_WITH_HOOK_TAIL = 0x024B;
const char32_t LATIN_CAPITAL_LETTER_R_WITH_STROKE = 0x024C;
const char32_t LATIN_SMALL_LETTER_R_WITH_STROKE = 0x024D;
const char32_t LATIN_CAPITAL_LETTER_Y_WITH_STROKE = 0x024E;
const char32_t LATIN_SMALL_LETTER_Y_WITH_STROKE = 0x024F;
const char32_t LATIN_SMALL_LETTER_TURNED_A = 0x0250;
const char32_t LATIN_SMALL_LETTER_ALPHA = 0x0251;
const char32_t LATIN_SMALL_LETTER_TURNED_ALPHA = 0x0252;
const char32_t LATIN_SMALL_LETTER_B_WITH_HOOK = 0x0253;
const char32_t LATIN_SMALL_LETTER_OPEN_O = 0x0254;
const char32_t LATIN_SMALL_LETTER_C_WITH_CURL = 0x0255;
const char32_t LATIN_SMALL_LETTER_D_WITH_TAIL = 0x0256;
const char32_t LATIN_SMALL_LETTER_D_WITH_HOOK = 0x0257;
const char32_t LATIN_SMALL_LETTER_REVERSED_E = 0x0258;
const char32_t LATIN_SMALL_LETTER_SCHWA = 0x0259;
const char32_t LATIN_SMALL_LETTER_SCHWA_WITH_HOOK = 0x025A;
const char32_t LATIN_SMALL_LETTER_OPEN_E = 0x025B;
const char32_t LATIN_SMALL_LETTER_REVERSED_OPEN_E = 0x025C;
const char32_t LATIN_SMALL_LETTER_REVERSED_OPEN_E_WITH_HOOK = 0x025D;
const char32_t LATIN_SMALL_LETTER_CLOSED_REVERSED_OPEN_E = 0x025E;
const char32_t LATIN_SMALL_LETTER_DOTLESS_J_WITH_STROKE = 0x025F;
const char32_t LATIN_SMALL_LETTER_G_WITH_HOOK = 0x0260;
const char32_t LATIN_SMALL_LETTER_SCRIPT_G = 0x0261;
const char32_t LATIN_LETTER_SMALL_CAPITAL_G = 0x0262;
const char32_t LATIN_SMALL_LETTER_GAMMA = 0x0263;
const char32_t LATIN_SMALL_LETTER_RAMS_HORN = 0x0264;
const char32_t LATIN_SMALL_LETTER_TURNED_H = 0x0265;
const char32_t LATIN_SMALL_LETTER_H_WITH_HOOK = 0x0266;
const char32_t LATIN_SMALL_LETTER_HENG_WITH_HOOK = 0x0267;
const char32_t LATIN_SMALL_LETTER_I_WITH_STROKE = 0x0268;
const char32_t LATIN_SMALL_LETTER_IOTA = 0x0269;
const char32_t LATIN_LETTER_SMALL_CAPITAL_I = 0x026A;
const char32_t LATIN_SMALL_LETTER_L_WITH_MIDDLE_TILDE = 0x026B;
const char32_t LATIN_SMALL_LETTER_L_WITH_BELT = 0x026C;
const char32_t LATIN_SMALL_LETTER_L_WITH_RETROFLEX_HOOK = 0x026D;
const char32_t LATIN_SMALL_LETTER_LEZH = 0x026E;
const char32_t LATIN_SMALL_LETTER_TURNED_M = 0x026F;
const char32_t LATIN_SMALL_LETTER_TURNED_M_WITH_LONG_LEG = 0x0270;
const char32_t LATIN_SMALL_LETTER_M_WITH_HOOK = 0x0271;
const char32_t LATIN_SMALL_LETTER_N_WITH_LEFT_HOOK = 0x0272;
const char32_t LATIN_SMALL_LETTER_N_WITH_RETROFLEX_HOOK = 0x0273;
const char32_t LATIN_LETTER_SMALL_CAPITAL_N = 0x0274;
const char32_t LATIN_SMALL_LETTER_BARRED_O = 0x0275;
const char32_t LATIN_LETTER_SMALL_CAPITAL_OE = 0x0276;
const char32_t LATIN_SMALL_LETTER_CLOSED_OMEGA = 0x0277;
const char32_t LATIN_SMALL_LETTER_PHI = 0x0278;
const char32_t LATIN_SMALL_LETTER_TURNED_R = 0x0279;
const char32_t LATIN_SMALL_LETTER_TURNED_R_WITH_LONG_LEG = 0x027A;
const char32_t LATIN_SMALL_LETTER_TURNED_R_WITH_HOOK = 0x027B;
const char32_t LATIN_SMALL_LETTER_R_WITH_LONG_LEG = 0x027C;
const char32_t LATIN_SMALL_LETTER_R_WITH_TAIL = 0x027D;
const char32_t LATIN_SMALL_LETTER_R_WITH_FISHHOOK = 0x027E;
const char32_t LATIN_SMALL_LETTER_REVERSED_R_WITH_FISHHOOK = 0x027F;
const char32_t LATIN_LETTER_SMALL_CAPITAL_R = 0x0280;
const char32_t LATIN_LETTER_SMALL_CAPITAL_INVERTED_R = 0x0281;
const char32_t LATIN_SMALL_LETTER_S_WITH_HOOK = 0x0282;
const char32_t LATIN_SMALL_LETTER_ESH = 0x0283;
const char32_t LATIN_SMALL_LETTER_DOTLESS_J_WITH_STROKE_AND_HOOK = 0x0284;
const char32_t LATIN_SMALL_LETTER_SQUAT_REVERSED_ESH = 0x0285;
const char32_t LATIN_SMALL_LETTER_ESH_WITH_CURL = 0x0286;
const char32_t LATIN_SMALL_LETTER_TURNED_T = 0x0287;
const char32_t LATIN_SMALL_LETTER_T_WITH_RETROFLEX_HOOK = 0x0288;
const char32_t LATIN_SMALL_LETTER_U_BAR = 0x0289;
const char32_t LATIN_SMALL_LETTER_UPSILON = 0x028A;
const char32_t LATIN_SMALL_LETTER_V_WITH_HOOK = 0x028B;
const char32_t LATIN_SMALL_LETTER_TURNED_V = 0x028C;
const char32_t LATIN_SMALL_LETTER_TURNED_W = 0x028D;
const char32_t LATIN_SMALL_LETTER_TURNED_Y = 0x028E;
const char32_t LATIN_LETTER_SMALL_CAPITAL_Y = 0x028F;
const char32_t LATIN_SMALL_LETTER_Z_WITH_RETROFLEX_HOOK = 0x0290;
const char32_t LATIN_SMALL_LETTER_Z_WITH_CURL = 0x0291;
const char32_t LATIN_SMALL_LETTER_EZH = 0x0292;
const char32_t LATIN_SMALL_LETTER_EZH_WITH_CURL = 0x0293;
const char32_t LATIN_LETTER_GLOTTAL_STOP = 0x0294;
const char32_t LATIN_LETTER_PHARYNGEAL_VOICED_FRICATIVE = 0x0295;
const char32_t LATIN_LETTER_INVERTED_GLOTTAL_STOP = 0x0296;
const char32_t LATIN_LETTER_STRETCHED_C = 0x0297;
const char32_t LATIN_LETTER_BILABIAL_CLICK = 0x0298;
const char32_t LATIN_LETTER_SMALL_CAPITAL_B = 0x0299;
const char32_t LATIN_SMALL_LETTER_CLOSED_OPEN_E = 0x029A;
const char32_t LATIN_LETTER_SMALL_CAPITAL_G_WITH_HOOK = 0x029B;
const char32_t LATIN_LETTER_SMALL_CAPITAL_H = 0x029C;
const char32_t LATIN_SMALL_LETTER_J_WITH_CROSSED_TAIL = 0x029D;
const char32_t LATIN_SMALL_LETTER_TURNED_K = 0x029E;
const char32_t LATIN_LETTER_SMALL_CAPITAL_L = 0x029F;
const char32_t LATIN_SMALL_LETTER_Q_WITH_HOOK = 0x02A0;
const char32_t LATIN_LETTER_GLOTTAL_STOP_WITH_STROKE = 0x02A1;
const char32_t LATIN_LETTER_REVERSED_GLOTTAL_STOP_WITH_STROKE = 0x02A2;
const char32_t LATIN_SMALL_LETTER_DZ_DIGRAPH = 0x02A3;
const char32_t LATIN_SMALL_LETTER_DEZH_DIGRAPH = 0x02A4;
const char32_t LATIN_SMALL_LETTER_DZ_DIGRAPH_WITH_CURL = 0x02A5;
const char32_t LATIN_SMALL_LETTER_TS_DIGRAPH = 0x02A6;
const char32_t LATIN_SMALL_LETTER_TESH_DIGRAPH = 0x02A7;
const char32_t LATIN_SMALL_LETTER_TC_DIGRAPH_WITH_CURL = 0x02A8;
const char32_t LATIN_SMALL_LETTER_FENG_DIGRAPH = 0x02A9;
const char32_t LATIN_SMALL_LETTER_LS_DIGRAPH = 0x02AA;
const char32_t LATIN_SMALL_LETTER_LZ_DIGRAPH = 0x02AB;
const char32_t LATIN_LETTER_BILABIAL_PERCUSSIVE = 0x02AC;
const char32_t LATIN_LETTER_BIDENTAL_PERCUSSIVE = 0x02AD;
const char32_t LATIN_SMALL_LETTER_TURNED_H_WITH_FISHHOOK = 0x02AE;
const char32_t LATIN_SMALL_LETTER_TURNED_H_WITH_FISHHOOK_AND_TAIL = 0x02AF;
const char32_t MODIFIER_LETTER_SMALL_H = 0x02B0;
const char32_t MODIFIER_LETTER_SMALL_H_WITH_HOOK = 0x02B1;
const char32_t MODIFIER_LETTER_SMALL_J = 0x02B2;
const char32_t MODIFIER_LETTER_SMALL_R = 0x02B3;
const char32_t MODIFIER_LETTER_SMALL_TURNED_R = 0x02B4;
const char32_t MODIFIER_LETTER_SMALL_TURNED_R_WITH_HOOK = 0x02B5;
const char32_t MODIFIER_LETTER_SMALL_CAPITAL_INVERTED_R = 0x02B6;
const char32_t MODIFIER_LETTER_SMALL_W = 0x02B7;
const char32_t MODIFIER_LETTER_SMALL_Y = 0x02B8;
const char32_t MODIFIER_LETTER_PRIME = 0x02B9;
const char32_t MODIFIER_LETTER_DOUBLE_PRIME = 0x02BA;
const char32_t MODIFIER_LETTER_TURNED_COMMA = 0x02BB;
const char32_t MODIFIER_LETTER_APOSTROPHE = 0x02BC;
const char32_t MODIFIER_LETTER_REVERSED_COMMA = 0x02BD;
const char32_t MODIFIER_LETTER_RIGHT_HALF_RING = 0x02BE;
const char32_t MODIFIER_LETTER_LEFT_HALF_RING = 0x02BF;
const char32_t MODIFIER_LETTER_GLOTTAL_STOP = 0x02C0;
const char32_t MODIFIER_LETTER_REVERSED_GLOTTAL_STOP = 0x02C1;
const char32_t MODIFIER_LETTER_LEFT_ARROWHEAD = 0x02C2;
const char32_t MODIFIER_LETTER_RIGHT_ARROWHEAD = 0x02C3;
const char32_t MODIFIER_LETTER_UP_ARROWHEAD = 0x02C4;
const char32_t MODIFIER_LETTER_DOWN_ARROWHEAD = 0x02C5;
const char32_t MODIFIER_LETTER_CIRCUMFLEX_ACCENT = 0x02C6;
const char32_t CARON = 0x02C7;
const char32_t MODIFIER_LETTER_VERTICAL_LINE = 0x02C8;
const char32_t MODIFIER_LETTER_MACRON = 0x02C9;
const char32_t MODIFIER_LETTER_ACUTE_ACCENT = 0x02CA;
const char32_t MODIFIER_LETTER_GRAVE_ACCENT = 0x02CB;
const char32_t MODIFIER_LETTER_LOW_VERTICAL_LINE = 0x02CC;
const char32_t MODIFIER_LETTER_LOW_MACRON = 0x02CD;
const char32_t MODIFIER_LETTER_LOW_GRAVE_ACCENT = 0x02CE;
const char32_t MODIFIER_LETTER_LOW_ACUTE_ACCENT = 0x02CF;
const char32_t MODIFIER_LETTER_TRIANGULAR_COLON = 0x02D0;
const char32_t MODIFIER_LETTER_HALF_TRIANGULAR_COLON = 0x02D1;
const char32_t MODIFIER_LETTER_CENTRED_RIGHT_HALF_RING = 0x02D2;
const char32_t MODIFIER_LETTER_CENTRED_LEFT_HALF_RING = 0x02D3;
const char32_t MODIFIER_LETTER_UP_TACK = 0x02D4;
const char32_t MODIFIER_LETTER_DOWN_TACK = 0x02D5;
const char32_t MODIFIER_LETTER_PLUS_SIGN = 0x02D6;
const char32_t MODIFIER_LETTER_MINUS_SIGN = 0x02D7;
const char32_t BREVE = 0x02D8;
const char32_t DOT_ABOVE = 0x02D9;
const char32_t RING_ABOVE = 0x02DA;
const char32_t OGONEK = 0x02DB;
const char32_t SMALL_TILDE = 0x02DC;
const char32_t DOUBLE_ACUTE_ACCENT = 0x02DD;
const char32_t MODIFIER_LETTER_RHOTIC_HOOK = 0x02DE;
const char32_t MODIFIER_LETTER_CROSS_ACCENT = 0x02DF;
const char32_t MODIFIER_LETTER_SMALL_GAMMA = 0x02E0;
const char32_t MODIFIER_LETTER_SMALL_L = 0x02E1;
const char32_t MODIFIER_LETTER_SMALL_S = 0x02E2;
const char32_t MODIFIER_LETTER_SMALL_X = 0x02E3;
const char32_t MODIFIER_LETTER_SMALL_REVERSED_GLOTTAL_STOP = 0x02E4;
const char32_t MODIFIER_LETTER_EXTRA_HIGH_TONE_BAR = 0x02E5;
const char32_t MODIFIER_LETTER_HIGH_TONE_BAR = 0x02E6;
const char32_t MODIFIER_LETTER_MID_TONE_BAR = 0x02E7;
const char32_t MODIFIER_LETTER_LOW_TONE_BAR = 0x02E8;
const char32_t MODIFIER_LETTER_EXTRA_LOW_TONE_BAR = 0x02E9;
const char32_t MODIFIER_LETTER_YIN_DEPARTING_TONE_MARK = 0x02EA;
const char32_t MODIFIER_LETTER_YANG_DEPARTING_TONE_MARK = 0x02EB;
const char32_t MODIFIER_LETTER_VOICING = 0x02EC;
const char32_t MODIFIER_LETTER_UNASPIRATED = 0x02ED;
const char32_t MODIFIER_LETTER_DOUBLE_APOSTROPHE = 0x02EE;
const char32_t MODIFIER_LETTER_LOW_DOWN_ARROWHEAD = 0x02EF;
const char32_t MODIFIER_LETTER_LOW_UP_ARROWHEAD = 0x02F0;
const char32_t MODIFIER_LETTER_LOW_LEFT_ARROWHEAD = 0x02F1;
const char32_t MODIFIER_LETTER_LOW_RIGHT_ARROWHEAD = 0x02F2;
const char32_t MODIFIER_LETTER_LOW_RING = 0x02F3;
const char32_t MODIFIER_LETTER_MIDDLE_GRAVE_ACCENT = 0x02F4;
const char32_t MODIFIER_LETTER_MIDDLE_DOUBLE_GRAVE_ACCENT = 0x02F5;
const char32_t MODIFIER_LETTER_MIDDLE_DOUBLE_ACUTE_ACCENT = 0x02F6;
const char32_t MODIFIER_LETTER_LOW_TILDE = 0x02F7;
const char32_t MODIFIER_LETTER_RAISED_COLON = 0x02F8;
const char32_t MODIFIER_LETTER_BEGIN_HIGH_TONE = 0x02F9;
const char32_t MODIFIER_LETTER_END_HIGH_TONE = 0x02FA;
const char32_t MODIFIER_LETTER_BEGIN_LOW_TONE = 0x02FB;
const char32_t MODIFIER_LETTER_END_LOW_TONE = 0x02FC;
const char32_t MODIFIER_LETTER_SHELF = 0x02FD;
const char32_t MODIFIER_LETTER_OPEN_SHELF = 0x02FE;
const char32_t MODIFIER_LETTER_LOW_LEFT_ARROW = 0x02FF;
const char32_t COMBINING_GRAVE_ACCENT = 0x0300;
const char32_t COMBINING_ACUTE_ACCENT = 0x0301;
const char32_t COMBINING_CIRCUMFLEX_ACCENT = 0x0302;
const char32_t COMBINING_TILDE = 0x0303;
const char32_t COMBINING_MACRON = 0x0304;
const char32_t COMBINING_OVERLINE = 0x0305;
const char32_t COMBINING_BREVE = 0x0306;
const char32_t COMBINING_DOT_ABOVE = 0x0307;
const char32_t COMBINING_DIAERESIS = 0x0308;
const char32_t COMBINING_HOOK_ABOVE = 0x0309;
const char32_t COMBINING_RING_ABOVE = 0x030A;
const char32_t COMBINING_DOUBLE_ACUTE_ACCENT = 0x030B;
const char32_t COMBINING_CARON = 0x030C;
const char32_t COMBINING_VERTICAL_LINE_ABOVE = 0x030D;
const char32_t COMBINING_DOUBLE_VERTICAL_LINE_ABOVE = 0x030E;
const char32_t COMBINING_DOUBLE_GRAVE_ACCENT = 0x030F;
const char32_t COMBINING_CANDRABINDU = 0x0310;
const char32_t COMBINING_INVERTED_BREVE = 0x0311;
const char32_t COMBINING_TURNED_COMMA_ABOVE = 0x0312;
const char32_t COMBINING_COMMA_ABOVE = 0x0313;
const char32_t COMBINING_REVERSED_COMMA_ABOVE = 0x0314;
const char32_t COMBINING_COMMA_ABOVE_RIGHT = 0x0315;
const char32_t COMBINING_GRAVE_ACCENT_BELOW = 0x0316;
const char32_t COMBINING_ACUTE_ACCENT_BELOW = 0x0317;
const char32_t COMBINING_LEFT_TACK_BELOW = 0x0318;
const char32_t COMBINING_RIGHT_TACK_BELOW = 0x0319;
const char32_t COMBINING_LEFT_ANGLE_ABOVE = 0x031A;
const char32_t COMBINING_HORN = 0x031B;
const char32_t COMBINING_LEFT_HALF_RING_BELOW = 0x031C;
const char32_t COMBINING_UP_TACK_BELOW = 0x031D;
const char32_t COMBINING_DOWN_TACK_BELOW = 0x031E;
const char32_t COMBINING_PLUS_SIGN_BELOW = 0x031F;
const char32_t COMBINING_MINUS_SIGN_BELOW = 0x0320;
const char32_t COMBINING_PALATALIZED_HOOK_BELOW = 0x0321;
const char32_t COMBINING_RETROFLEX_HOOK_BELOW = 0x0322;
const char32_t COMBINING_DOT_BELOW = 0x0323;
const char32_t COMBINING_DIAERESIS_BELOW = 0x0324;
const char32_t COMBINING_RING_BELOW = 0x0325;
const char32_t COMBINING_COMMA_BELOW = 0x0326;
const char32_t COMBINING_CEDILLA = 0x0327;
const char32_t COMBINING_OGONEK = 0x0328;
const char32_t COMBINING_VERTICAL_LINE_BELOW = 0x0329;
const char32_t COMBINING_BRIDGE_BELOW = 0x032A;
const char32_t COMBINING_INVERTED_DOUBLE_ARCH_BELOW = 0x032B;
const char32_t COMBINING_CARON_BELOW = 0x032C;
const char32_t COMBINING_CIRCUMFLEX_ACCENT_BELOW = 0x032D;
const char32_t COMBINING_BREVE_BELOW = 0x032E;
const char32_t COMBINING_INVERTED_BREVE_BELOW = 0x032F;
const char32_t COMBINING_TILDE_BELOW = 0x0330;
const char32_t COMBINING_MACRON_BELOW = 0x0331;
const char32_t COMBINING_LOW_LINE = 0x0332;
const char32_t COMBINING_DOUBLE_LOW_LINE = 0x0333;
const char32_t COMBINING_TILDE_OVERLAY = 0x0334;
const char32_t COMBINING_SHORT_STROKE_OVERLAY = 0x0335;
const char32_t COMBINING_LONG_STROKE_OVERLAY = 0x0336;
const char32_t COMBINING_SHORT_SOLIDUS_OVERLAY = 0x0337;
const char32_t COMBINING_LONG_SOLIDUS_OVERLAY = 0x0338;
const char32_t COMBINING_RIGHT_HALF_RING_BELOW = 0x0339;
const char32_t COMBINING_INVERTED_BRIDGE_BELOW = 0x033A;
const char32_t COMBINING_SQUARE_BELOW = 0x033B;
const char32_t COMBINING_SEAGULL_BELOW = 0x033C;
const char32_t COMBINING_X_ABOVE = 0x033D;
const char32_t COMBINING_VERTICAL_TILDE = 0x033E;
const char32_t COMBINING_DOUBLE_OVERLINE = 0x033F;
const char32_t COMBINING_GRAVE_TONE_MARK = 0x0340;
const char32_t COMBINING_ACUTE_TONE_MARK = 0x0341;
const char32_t COMBINING_GREEK_PERISPOMENI = 0x0342;
const char32_t COMBINING_GREEK_KORONIS = 0x0343;
const char32_t COMBINING_GREEK_DIALYTIKA_TONOS = 0x0344;
const char32_t COMBINING_GREEK_YPOGEGRAMMENI = 0x0345;
const char32_t COMBINING_BRIDGE_ABOVE = 0x0346;
const char32_t COMBINING_EQUALS_SIGN_BELOW = 0x0347;
const char32_t COMBINING_DOUBLE_VERTICAL_LINE_BELOW = 0x0348;
const char32_t COMBINING_LEFT_ANGLE_BELOW = 0x0349;
const char32_t COMBINING_NOT_TILDE_ABOVE = 0x034A;
const char32_t COMBINING_HOMOTHETIC_ABOVE = 0x034B;
const char32_t COMBINING_ALMOST_EQUAL_TO_ABOVE = 0x034C;
const char32_t COMBINING_LEFT_RIGHT_ARROW_BELOW = 0x034D;
const char32_t COMBINING_UPWARDS_ARROW_BELOW = 0x034E;
const char32_t COMBINING_GRAPHEME_JOINER = 0x034F;
const char32_t COMBINING_RIGHT_ARROWHEAD_ABOVE = 0x0350;
const char32_t COMBINING_LEFT_HALF_RING_ABOVE = 0x0351;
const char32_t COMBINING_FERMATA = 0x0352;
const char32_t COMBINING_X_BELOW = 0x0353;
const char32_t COMBINING_LEFT_ARROWHEAD_BELOW = 0x0354;
const char32_t COMBINING_RIGHT_ARROWHEAD_BELOW = 0x0355;
const char32_t COMBINING_RIGHT_ARROWHEAD_AND_UP_ARROWHEAD_BELOW = 0x0356;
const char32_t COMBINING_RIGHT_HALF_RING_ABOVE = 0x0357;
const char32_t COMBINING_DOT_ABOVE_RIGHT = 0x0358;
const char32_t COMBINING_ASTERISK_BELOW = 0x0359;
const char32_t COMBINING_DOUBLE_RING_BELOW = 0x035A;
const char32_t COMBINING_ZIGZAG_ABOVE = 0x035B;
const char32_t COMBINING_DOUBLE_BREVE_BELOW = 0x035C;
const char32_t COMBINING_DOUBLE_BREVE = 0x035D;
const char32_t COMBINING_DOUBLE_MACRON = 0x035E;
const char32_t COMBINING_DOUBLE_MACRON_BELOW = 0x035F;
const char32_t COMBINING_DOUBLE_TILDE = 0x0360;
const char32_t COMBINING_DOUBLE_INVERTED_BREVE = 0x0361;
const char32_t COMBINING_DOUBLE_RIGHTWARDS_ARROW_BELOW = 0x0362;
const char32_t COMBINING_LATIN_SMALL_LETTER_A = 0x0363;
const char32_t COMBINING_LATIN_SMALL_LETTER_E = 0x0364;
const char32_t COMBINING_LATIN_SMALL_LETTER_I = 0x0365;
const char32_t COMBINING_LATIN_SMALL_LETTER_O = 0x0366;
const char32_t COMBINING_LATIN_SMALL_LETTER_U = 0x0367;
const char32_t COMBINING_LATIN_SMALL_LETTER_C = 0x0368;
const char32_t COMBINING_LATIN_SMALL_LETTER_D = 0x0369;
const char32_t COMBINING_LATIN_SMALL_LETTER_H = 0x036A;
const char32_t COMBINING_LATIN_SMALL_LETTER_M = 0x036B;
const char32_t COMBINING_LATIN_SMALL_LETTER_R = 0x036C;
const char32_t COMBINING_LATIN_SMALL_LETTER_T = 0x036D;
const char32_t COMBINING_LATIN_SMALL_LETTER_V = 0x036E;
const char32_t COMBINING_LATIN_SMALL_LETTER_X = 0x036F;
const char32_t GREEK_CAPITAL_LETTER_HETA = 0x0370;
const char32_t GREEK_SMALL_LETTER_HETA = 0x0371;
const char32_t GREEK_CAPITAL_LETTER_ARCHAIC_SAMPI = 0x0372;
const char32_t GREEK_SMALL_LETTER_ARCHAIC_SAMPI = 0x0373;
const char32_t GREEK_NUMERAL_SIGN = 0x0374;
const char32_t GREEK_LOWER_NUMERAL_SIGN = 0x0375;
const char32_t GREEK_CAPITAL_LETTER_PAMPHYLIAN_DIGAMMA = 0x0376;
const char32_t GREEK_SMALL_LETTER_PAMPHYLIAN_DIGAMMA = 0x0377;
const char32_t GREEK_YPOGEGRAMMENI = 0x037A;
const char32_t GREEK_SMALL_REVERSED_LUNATE_SIGMA_SYMBOL = 0x037B;
const char32_t GREEK_SMALL_DOTTED_LUNATE_SIGMA_SYMBOL = 0x037C;
const char32_t GREEK_SMALL_REVERSED_DOTTED_LUNATE_SIGMA_SYMBOL = 0x037D;
const char32_t GREEK_QUESTION_MARK = 0x037E;
const char32_t GREEK_CAPITAL_LETTER_YOT = 0x037F;
const char32_t GREEK_TONOS = 0x0384;
const char32_t GREEK_DIALYTIKA_TONOS = 0x0385;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_TONOS = 0x0386;
const char32_t GREEK_ANO_TELEIA = 0x0387;
const char32_t GREEK_CAPITAL_LETTER_EPSILON_WITH_TONOS = 0x0388;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_TONOS = 0x0389;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_TONOS = 0x038A;
const char32_t GREEK_CAPITAL_LETTER_OMICRON_WITH_TONOS = 0x038C;
const char32_t GREEK_CAPITAL_LETTER_UPSILON_WITH_TONOS = 0x038E;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_TONOS = 0x038F;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_TONOS = 0x0390;
const char32_t GREEK_CAPITAL_LETTER_ALPHA = 0x0391;
const char32_t GREEK_CAPITAL_LETTER_BETA = 0x0392;
const char32_t GREEK_CAPITAL_LETTER_GAMMA = 0x0393;
const char32_t GREEK_CAPITAL_LETTER_DELTA = 0x0394;
const char32_t GREEK_CAPITAL_LETTER_EPSILON = 0x0395;
const char32_t GREEK_CAPITAL_LETTER_ZETA = 0x0396;
const char32_t GREEK_CAPITAL_LETTER_ETA = 0x0397;
const char32_t GREEK_CAPITAL_LETTER_THETA = 0x0398;
const char32_t GREEK_CAPITAL_LETTER_IOTA = 0x0399;
const char32_t GREEK_CAPITAL_LETTER_KAPPA = 0x039A;
const char32_t GREEK_CAPITAL_LETTER_LAMDA = 0x039B;
const char32_t GREEK_CAPITAL_LETTER_MU = 0x039C;
const char32_t GREEK_CAPITAL_LETTER_NU = 0x039D;
const char32_t GREEK_CAPITAL_LETTER_XI = 0x039E;
const char32_t GREEK_CAPITAL_LETTER_OMICRON = 0x039F;
const char32_t GREEK_CAPITAL_LETTER_PI = 0x03A0;
const char32_t GREEK_CAPITAL_LETTER_RHO = 0x03A1;
const char32_t GREEK_CAPITAL_LETTER_SIGMA = 0x03A3;
const char32_t GREEK_CAPITAL_LETTER_TAU = 0x03A4;
const char32_t GREEK_CAPITAL_LETTER_UPSILON = 0x03A5;
const char32_t GREEK_CAPITAL_LETTER_PHI = 0x03A6;
const char32_t GREEK_CAPITAL_LETTER_CHI = 0x03A7;
const char32_t GREEK_CAPITAL_LETTER_PSI = 0x03A8;
const char32_t GREEK_CAPITAL_LETTER_OMEGA = 0x03A9;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_DIALYTIKA = 0x03AA;
const char32_t GREEK_CAPITAL_LETTER_UPSILON_WITH_DIALYTIKA = 0x03AB;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_TONOS = 0x03AC;
const char32_t GREEK_SMALL_LETTER_EPSILON_WITH_TONOS = 0x03AD;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_TONOS = 0x03AE;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_TONOS = 0x03AF;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_TONOS = 0x03B0;
const char32_t GREEK_SMALL_LETTER_ALPHA = 0x03B1;
const char32_t GREEK_SMALL_LETTER_BETA = 0x03B2;
const char32_t GREEK_SMALL_LETTER_GAMMA = 0x03B3;
const char32_t GREEK_SMALL_LETTER_DELTA = 0x03B4;
const char32_t GREEK_SMALL_LETTER_EPSILON = 0x03B5;
const char32_t GREEK_SMALL_LETTER_ZETA = 0x03B6;
const char32_t GREEK_SMALL_LETTER_ETA = 0x03B7;
const char32_t GREEK_SMALL_LETTER_THETA = 0x03B8;
const char32_t GREEK_SMALL_LETTER_IOTA = 0x03B9;
const char32_t GREEK_SMALL_LETTER_KAPPA = 0x03BA;
const char32_t GREEK_SMALL_LETTER_LAMDA = 0x03BB;
const char32_t GREEK_SMALL_LETTER_MU = 0x03BC;
const char32_t GREEK_SMALL_LETTER_NU = 0x03BD;
const char32_t GREEK_SMALL_LETTER_XI = 0x03BE;
const char32_t GREEK_SMALL_LETTER_OMICRON = 0x03BF;
const char32_t GREEK_SMALL_LETTER_PI = 0x03C0;
const char32_t GREEK_SMALL_LETTER_RHO = 0x03C1;
const char32_t GREEK_SMALL_LETTER_FINAL_SIGMA = 0x03C2;
const char32_t GREEK_SMALL_LETTER_SIGMA = 0x03C3;
const char32_t GREEK_SMALL_LETTER_TAU = 0x03C4;
const char32_t GREEK_SMALL_LETTER_UPSILON = 0x03C5;
const char32_t GREEK_SMALL_LETTER_PHI = 0x03C6;
const char32_t GREEK_SMALL_LETTER_CHI = 0x03C7;
const char32_t GREEK_SMALL_LETTER_PSI = 0x03C8;
const char32_t GREEK_SMALL_LETTER_OMEGA = 0x03C9;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA = 0x03CA;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA = 0x03CB;
const char32_t GREEK_SMALL_LETTER_OMICRON_WITH_TONOS = 0x03CC;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_TONOS = 0x03CD;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_TONOS = 0x03CE;
const char32_t GREEK_CAPITAL_KAI_SYMBOL = 0x03CF;
const char32_t GREEK_BETA_SYMBOL = 0x03D0;
const char32_t GREEK_THETA_SYMBOL = 0x03D1;
const char32_t GREEK_UPSILON_WITH_HOOK_SYMBOL = 0x03D2;
const char32_t GREEK_UPSILON_WITH_ACUTE_AND_HOOK_SYMBOL = 0x03D3;
const char32_t GREEK_UPSILON_WITH_DIAERESIS_AND_HOOK_SYMBOL = 0x03D4;
const char32_t GREEK_PHI_SYMBOL = 0x03D5;
const char32_t GREEK_PI_SYMBOL = 0x03D6;
const char32_t GREEK_KAI_SYMBOL = 0x03D7;
const char32_t GREEK_LETTER_ARCHAIC_KOPPA = 0x03D8;
const char32_t GREEK_SMALL_LETTER_ARCHAIC_KOPPA = 0x03D9;
const char32_t GREEK_LETTER_STIGMA = 0x03DA;
const char32_t GREEK_SMALL_LETTER_STIGMA = 0x03DB;
const char32_t GREEK_LETTER_DIGAMMA = 0x03DC;
const char32_t GREEK_SMALL_LETTER_DIGAMMA = 0x03DD;
const char32_t GREEK_LETTER_KOPPA = 0x03DE;
const char32_t GREEK_SMALL_LETTER_KOPPA = 0x03DF;
const char32_t GREEK_LETTER_SAMPI = 0x03E0;
const char32_t GREEK_SMALL_LETTER_SAMPI = 0x03E1;
const char32_t COPTIC_CAPITAL_LETTER_SHEI = 0x03E2;
const char32_t COPTIC_SMALL_LETTER_SHEI = 0x03E3;
const char32_t COPTIC_CAPITAL_LETTER_FEI = 0x03E4;
const char32_t COPTIC_SMALL_LETTER_FEI = 0x03E5;
const char32_t COPTIC_CAPITAL_LETTER_KHEI = 0x03E6;
const char32_t COPTIC_SMALL_LETTER_KHEI = 0x03E7;
const char32_t COPTIC_CAPITAL_LETTER_HORI = 0x03E8;
const char32_t COPTIC_SMALL_LETTER_HORI = 0x03E9;
const char32_t COPTIC_CAPITAL_LETTER_GANGIA = 0x03EA;
const char32_t COPTIC_SMALL_LETTER_GANGIA = 0x03EB;
const char32_t COPTIC_CAPITAL_LETTER_SHIMA = 0x03EC;
const char32_t COPTIC_SMALL_LETTER_SHIMA = 0x03ED;
const char32_t COPTIC_CAPITAL_LETTER_DEI = 0x03EE;
const char32_t COPTIC_SMALL_LETTER_DEI = 0x03EF;
const char32_t GREEK_KAPPA_SYMBOL = 0x03F0;
const char32_t GREEK_RHO_SYMBOL = 0x03F1;
const char32_t GREEK_LUNATE_SIGMA_SYMBOL = 0x03F2;
const char32_t GREEK_LETTER_YOT = 0x03F3;
const char32_t GREEK_CAPITAL_THETA_SYMBOL = 0x03F4;
const char32_t GREEK_LUNATE_EPSILON_SYMBOL = 0x03F5;
const char32_t GREEK_REVERSED_LUNATE_EPSILON_SYMBOL = 0x03F6;
const char32_t GREEK_CAPITAL_LETTER_SHO = 0x03F7;
const char32_t GREEK_SMALL_LETTER_SHO = 0x03F8;
const char32_t GREEK_CAPITAL_LUNATE_SIGMA_SYMBOL = 0x03F9;
const char32_t GREEK_CAPITAL_LETTER_SAN = 0x03FA;
const char32_t GREEK_SMALL_LETTER_SAN = 0x03FB;
const char32_t GREEK_RHO_WITH_STROKE_SYMBOL = 0x03FC;
const char32_t GREEK_CAPITAL_REVERSED_LUNATE_SIGMA_SYMBOL = 0x03FD;
const char32_t GREEK_CAPITAL_DOTTED_LUNATE_SIGMA_SYMBOL = 0x03FE;
const char32_t GREEK_CAPITAL_REVERSED_DOTTED_LUNATE_SIGMA_SYMBOL = 0x03FF;
const char32_t CYRILLIC_CAPITAL_LETTER_IE_WITH_GRAVE = 0x0400;
const char32_t CYRILLIC_CAPITAL_LETTER_IO = 0x0401;
const char32_t CYRILLIC_CAPITAL_LETTER_DJE = 0x0402;
const char32_t CYRILLIC_CAPITAL_LETTER_GJE = 0x0403;
const char32_t CYRILLIC_CAPITAL_LETTER_UKRAINIAN_IE = 0x0404;
const char32_t CYRILLIC_CAPITAL_LETTER_DZE = 0x0405;
const char32_t CYRILLIC_CAPITAL_LETTER_BYELORUSSIAN_UKRAINIAN_I = 0x0406;
const char32_t CYRILLIC_CAPITAL_LETTER_YI = 0x0407;
const char32_t CYRILLIC_CAPITAL_LETTER_JE = 0x0408;
const char32_t CYRILLIC_CAPITAL_LETTER_LJE = 0x0409;
const char32_t CYRILLIC_CAPITAL_LETTER_NJE = 0x040A;
const char32_t CYRILLIC_CAPITAL_LETTER_TSHE = 0x040B;
const char32_t CYRILLIC_CAPITAL_LETTER_KJE = 0x040C;
const char32_t CYRILLIC_CAPITAL_LETTER_I_WITH_GRAVE = 0x040D;
const char32_t CYRILLIC_CAPITAL_LETTER_SHORT_U = 0x040E;
const char32_t CYRILLIC_CAPITAL_LETTER_DZHE = 0x040F;
const char32_t CYRILLIC_CAPITAL_LETTER_A = 0x0410;
const char32_t CYRILLIC_CAPITAL_LETTER_BE = 0x0411;
const char32_t CYRILLIC_CAPITAL_LETTER_VE = 0x0412;
const char32_t CYRILLIC_CAPITAL_LETTER_GHE = 0x0413;
const char32_t CYRILLIC_CAPITAL_LETTER_DE = 0x0414;
const char32_t CYRILLIC_CAPITAL_LETTER_IE = 0x0415;
const char32_t CYRILLIC_CAPITAL_LETTER_ZHE = 0x0416;
const char32_t CYRILLIC_CAPITAL_LETTER_ZE = 0x0417;
const char32_t CYRILLIC_CAPITAL_LETTER_I = 0x0418;
const char32_t CYRILLIC_CAPITAL_LETTER_SHORT_I = 0x0419;
const char32_t CYRILLIC_CAPITAL_LETTER_KA = 0x041A;
const char32_t CYRILLIC_CAPITAL_LETTER_EL = 0x041B;
const char32_t CYRILLIC_CAPITAL_LETTER_EM = 0x041C;
const char32_t CYRILLIC_CAPITAL_LETTER_EN = 0x041D;
const char32_t CYRILLIC_CAPITAL_LETTER_O = 0x041E;
const char32_t CYRILLIC_CAPITAL_LETTER_PE = 0x041F;
const char32_t CYRILLIC_CAPITAL_LETTER_ER = 0x0420;
const char32_t CYRILLIC_CAPITAL_LETTER_ES = 0x0421;
const char32_t CYRILLIC_CAPITAL_LETTER_TE = 0x0422;
const char32_t CYRILLIC_CAPITAL_LETTER_U = 0x0423;
const char32_t CYRILLIC_CAPITAL_LETTER_EF = 0x0424;
const char32_t CYRILLIC_CAPITAL_LETTER_HA = 0x0425;
const char32_t CYRILLIC_CAPITAL_LETTER_TSE = 0x0426;
const char32_t CYRILLIC_CAPITAL_LETTER_CHE = 0x0427;
const char32_t CYRILLIC_CAPITAL_LETTER_SHA = 0x0428;
const char32_t CYRILLIC_CAPITAL_LETTER_SHCHA = 0x0429;
const char32_t CYRILLIC_CAPITAL_LETTER_HARD_SIGN = 0x042A;
const char32_t CYRILLIC_CAPITAL_LETTER_YERU = 0x042B;
const char32_t CYRILLIC_CAPITAL_LETTER_SOFT_SIGN = 0x042C;
const char32_t CYRILLIC_CAPITAL_LETTER_E = 0x042D;
const char32_t CYRILLIC_CAPITAL_LETTER_YU = 0x042E;
const char32_t CYRILLIC_CAPITAL_LETTER_YA = 0x042F;
const char32_t CYRILLIC_SMALL_LETTER_A = 0x0430;
const char32_t CYRILLIC_SMALL_LETTER_BE = 0x0431;
const char32_t CYRILLIC_SMALL_LETTER_VE = 0x0432;
const char32_t CYRILLIC_SMALL_LETTER_GHE = 0x0433;
const char32_t CYRILLIC_SMALL_LETTER_DE = 0x0434;
const char32_t CYRILLIC_SMALL_LETTER_IE = 0x0435;
const char32_t CYRILLIC_SMALL_LETTER_ZHE = 0x0436;
const char32_t CYRILLIC_SMALL_LETTER_ZE = 0x0437;
const char32_t CYRILLIC_SMALL_LETTER_I = 0x0438;
const char32_t CYRILLIC_SMALL_LETTER_SHORT_I = 0x0439;
const char32_t CYRILLIC_SMALL_LETTER_KA = 0x043A;
const char32_t CYRILLIC_SMALL_LETTER_EL = 0x043B;
const char32_t CYRILLIC_SMALL_LETTER_EM = 0x043C;
const char32_t CYRILLIC_SMALL_LETTER_EN = 0x043D;
const char32_t CYRILLIC_SMALL_LETTER_O = 0x043E;
const char32_t CYRILLIC_SMALL_LETTER_PE = 0x043F;
const char32_t CYRILLIC_SMALL_LETTER_ER = 0x0440;
const char32_t CYRILLIC_SMALL_LETTER_ES = 0x0441;
const char32_t CYRILLIC_SMALL_LETTER_TE = 0x0442;
const char32_t CYRILLIC_SMALL_LETTER_U = 0x0443;
const char32_t CYRILLIC_SMALL_LETTER_EF = 0x0444;
const char32_t CYRILLIC_SMALL_LETTER_HA = 0x0445;
const char32_t CYRILLIC_SMALL_LETTER_TSE = 0x0446;
const char32_t CYRILLIC_SMALL_LETTER_CHE = 0x0447;
const char32_t CYRILLIC_SMALL_LETTER_SHA = 0x0448;
const char32_t CYRILLIC_SMALL_LETTER_SHCHA = 0x0449;
const char32_t CYRILLIC_SMALL_LETTER_HARD_SIGN = 0x044A;
const char32_t CYRILLIC_SMALL_LETTER_YERU = 0x044B;
const char32_t CYRILLIC_SMALL_LETTER_SOFT_SIGN = 0x044C;
const char32_t CYRILLIC_SMALL_LETTER_E = 0x044D;
const char32_t CYRILLIC_SMALL_LETTER_YU = 0x044E;
const char32_t CYRILLIC_SMALL_LETTER_YA = 0x044F;
const char32_t CYRILLIC_SMALL_LETTER_IE_WITH_GRAVE = 0x0450;
const char32_t CYRILLIC_SMALL_LETTER_IO = 0x0451;
const char32_t CYRILLIC_SMALL_LETTER_DJE = 0x0452;
const char32_t CYRILLIC_SMALL_LETTER_GJE = 0x0453;
const char32_t CYRILLIC_SMALL_LETTER_UKRAINIAN_IE = 0x0454;
const char32_t CYRILLIC_SMALL_LETTER_DZE = 0x0455;
const char32_t CYRILLIC_SMALL_LETTER_BYELORUSSIAN_UKRAINIAN_I = 0x0456;
const char32_t CYRILLIC_SMALL_LETTER_YI = 0x0457;
const char32_t CYRILLIC_SMALL_LETTER_JE = 0x0458;
const char32_t CYRILLIC_SMALL_LETTER_LJE = 0x0459;
const char32_t CYRILLIC_SMALL_LETTER_NJE = 0x045A;
const char32_t CYRILLIC_SMALL_LETTER_TSHE = 0x045B;
const char32_t CYRILLIC_SMALL_LETTER_KJE = 0x045C;
const char32_t CYRILLIC_SMALL_LETTER_I_WITH_GRAVE = 0x045D;
const char32_t CYRILLIC_SMALL_LETTER_SHORT_U = 0x045E;
const char32_t CYRILLIC_SMALL_LETTER_DZHE = 0x045F;
const char32_t CYRILLIC_CAPITAL_LETTER_OMEGA = 0x0460;
const char32_t CYRILLIC_SMALL_LETTER_OMEGA = 0x0461;
const char32_t CYRILLIC_CAPITAL_LETTER_YAT = 0x0462;
const char32_t CYRILLIC_SMALL_LETTER_YAT = 0x0463;
const char32_t CYRILLIC_CAPITAL_LETTER_IOTIFIED_E = 0x0464;
const char32_t CYRILLIC_SMALL_LETTER_IOTIFIED_E = 0x0465;
const char32_t CYRILLIC_CAPITAL_LETTER_LITTLE_YUS = 0x0466;
const char32_t CYRILLIC_SMALL_LETTER_LITTLE_YUS = 0x0467;
const char32_t CYRILLIC_CAPITAL_LETTER_IOTIFIED_LITTLE_YUS = 0x0468;
const char32_t CYRILLIC_SMALL_LETTER_IOTIFIED_LITTLE_YUS = 0x0469;
const char32_t CYRILLIC_CAPITAL_LETTER_BIG_YUS = 0x046A;
const char32_t CYRILLIC_SMALL_LETTER_BIG_YUS = 0x046B;
const char32_t CYRILLIC_CAPITAL_LETTER_IOTIFIED_BIG_YUS = 0x046C;
const char32_t CYRILLIC_SMALL_LETTER_IOTIFIED_BIG_YUS = 0x046D;
const char32_t CYRILLIC_CAPITAL_LETTER_KSI = 0x046E;
const char32_t CYRILLIC_SMALL_LETTER_KSI = 0x046F;
const char32_t CYRILLIC_CAPITAL_LETTER_PSI = 0x0470;
const char32_t CYRILLIC_SMALL_LETTER_PSI = 0x0471;
const char32_t CYRILLIC_CAPITAL_LETTER_FITA = 0x0472;
const char32_t CYRILLIC_SMALL_LETTER_FITA = 0x0473;
const char32_t CYRILLIC_CAPITAL_LETTER_IZHITSA = 0x0474;
const char32_t CYRILLIC_SMALL_LETTER_IZHITSA = 0x0475;
const char32_t CYRILLIC_CAPITAL_LETTER_IZHITSA_WITH_DOUBLE_GRAVE_ACCENT = 0x0476;
const char32_t CYRILLIC_SMALL_LETTER_IZHITSA_WITH_DOUBLE_GRAVE_ACCENT = 0x0477;
const char32_t CYRILLIC_CAPITAL_LETTER_UK = 0x0478;
const char32_t CYRILLIC_SMALL_LETTER_UK = 0x0479;
const char32_t CYRILLIC_CAPITAL_LETTER_ROUND_OMEGA = 0x047A;
const char32_t CYRILLIC_SMALL_LETTER_ROUND_OMEGA = 0x047B;
const char32_t CYRILLIC_CAPITAL_LETTER_OMEGA_WITH_TITLO = 0x047C;
const char32_t CYRILLIC_SMALL_LETTER_OMEGA_WITH_TITLO = 0x047D;
const char32_t CYRILLIC_CAPITAL_LETTER_OT = 0x047E;
const char32_t CYRILLIC_SMALL_LETTER_OT = 0x047F;
const char32_t CYRILLIC_CAPITAL_LETTER_KOPPA = 0x0480;
const char32_t CYRILLIC_SMALL_LETTER_KOPPA = 0x0481;
const char32_t CYRILLIC_THOUSANDS_SIGN = 0x0482;
const char32_t COMBINING_CYRILLIC_TITLO = 0x0483;
const char32_t COMBINING_CYRILLIC_PALATALIZATION = 0x0484;
const char32_t COMBINING_CYRILLIC_DASIA_PNEUMATA = 0x0485;
const char32_t COMBINING_CYRILLIC_PSILI_PNEUMATA = 0x0486;
const char32_t COMBINING_CYRILLIC_POKRYTIE = 0x0487;
const char32_t COMBINING_CYRILLIC_HUNDRED_THOUSANDS_SIGN = 0x0488;
const char32_t COMBINING_CYRILLIC_MILLIONS_SIGN = 0x0489;
const char32_t CYRILLIC_CAPITAL_LETTER_SHORT_I_WITH_TAIL = 0x048A;
const char32_t CYRILLIC_SMALL_LETTER_SHORT_I_WITH_TAIL = 0x048B;
const char32_t CYRILLIC_CAPITAL_LETTER_SEMISOFT_SIGN = 0x048C;
const char32_t CYRILLIC_SMALL_LETTER_SEMISOFT_SIGN = 0x048D;
const char32_t CYRILLIC_CAPITAL_LETTER_ER_WITH_TICK = 0x048E;
const char32_t CYRILLIC_SMALL_LETTER_ER_WITH_TICK = 0x048F;
const char32_t CYRILLIC_CAPITAL_LETTER_GHE_WITH_UPTURN = 0x0490;
const char32_t CYRILLIC_SMALL_LETTER_GHE_WITH_UPTURN = 0x0491;
const char32_t CYRILLIC_CAPITAL_LETTER_GHE_WITH_STROKE = 0x0492;
const char32_t CYRILLIC_SMALL_LETTER_GHE_WITH_STROKE = 0x0493;
const char32_t CYRILLIC_CAPITAL_LETTER_GHE_WITH_MIDDLE_HOOK = 0x0494;
const char32_t CYRILLIC_SMALL_LETTER_GHE_WITH_MIDDLE_HOOK = 0x0495;
const char32_t CYRILLIC_CAPITAL_LETTER_ZHE_WITH_DESCENDER = 0x0496;
const char32_t CYRILLIC_SMALL_LETTER_ZHE_WITH_DESCENDER = 0x0497;
const char32_t CYRILLIC_CAPITAL_LETTER_ZE_WITH_DESCENDER = 0x0498;
const char32_t CYRILLIC_SMALL_LETTER_ZE_WITH_DESCENDER = 0x0499;
const char32_t CYRILLIC_CAPITAL_LETTER_KA_WITH_DESCENDER = 0x049A;
const char32_t CYRILLIC_SMALL_LETTER_KA_WITH_DESCENDER = 0x049B;
const char32_t CYRILLIC_CAPITAL_LETTER_KA_WITH_VERTICAL_STROKE = 0x049C;
const char32_t CYRILLIC_SMALL_LETTER_KA_WITH_VERTICAL_STROKE = 0x049D;
const char32_t CYRILLIC_CAPITAL_LETTER_KA_WITH_STROKE = 0x049E;
const char32_t CYRILLIC_SMALL_LETTER_KA_WITH_STROKE = 0x049F;
const char32_t CYRILLIC_CAPITAL_LETTER_BASHKIR_KA = 0x04A0;
const char32_t CYRILLIC_SMALL_LETTER_BASHKIR_KA = 0x04A1;
const char32_t CYRILLIC_CAPITAL_LETTER_EN_WITH_DESCENDER = 0x04A2;
const char32_t CYRILLIC_SMALL_LETTER_EN_WITH_DESCENDER = 0x04A3;
const char32_t CYRILLIC_CAPITAL_LIGATURE_EN_GHE = 0x04A4;
const char32_t CYRILLIC_SMALL_LIGATURE_EN_GHE = 0x04A5;
const char32_t CYRILLIC_CAPITAL_LETTER_PE_WITH_MIDDLE_HOOK = 0x04A6;
const char32_t CYRILLIC_SMALL_LETTER_PE_WITH_MIDDLE_HOOK = 0x04A7;
const char32_t CYRILLIC_CAPITAL_LETTER_ABKHASIAN_HA = 0x04A8;
const char32_t CYRILLIC_SMALL_LETTER_ABKHASIAN_HA = 0x04A9;
const char32_t CYRILLIC_CAPITAL_LETTER_ES_WITH_DESCENDER = 0x04AA;
const char32_t CYRILLIC_SMALL_LETTER_ES_WITH_DESCENDER = 0x04AB;
const char32_t CYRILLIC_CAPITAL_LETTER_TE_WITH_DESCENDER = 0x04AC;
const char32_t CYRILLIC_SMALL_LETTER_TE_WITH_DESCENDER = 0x04AD;
const char32_t CYRILLIC_CAPITAL_LETTER_STRAIGHT_U = 0x04AE;
const char32_t CYRILLIC_SMALL_LETTER_STRAIGHT_U = 0x04AF;
const char32_t CYRILLIC_CAPITAL_LETTER_STRAIGHT_U_WITH_STROKE = 0x04B0;
const char32_t CYRILLIC_SMALL_LETTER_STRAIGHT_U_WITH_STROKE = 0x04B1;
const char32_t CYRILLIC_CAPITAL_LETTER_HA_WITH_DESCENDER = 0x04B2;
const char32_t CYRILLIC_SMALL_LETTER_HA_WITH_DESCENDER = 0x04B3;
const char32_t CYRILLIC_CAPITAL_LIGATURE_TE_TSE = 0x04B4;
const char32_t CYRILLIC_SMALL_LIGATURE_TE_TSE = 0x04B5;
const char32_t CYRILLIC_CAPITAL_LETTER_CHE_WITH_DESCENDER = 0x04B6;
const char32_t CYRILLIC_SMALL_LETTER_CHE_WITH_DESCENDER = 0x04B7;
const char32_t CYRILLIC_CAPITAL_LETTER_CHE_WITH_VERTICAL_STROKE = 0x04B8;
const char32_t CYRILLIC_SMALL_LETTER_CHE_WITH_VERTICAL_STROKE = 0x04B9;
const char32_t CYRILLIC_CAPITAL_LETTER_SHHA = 0x04BA;
const char32_t CYRILLIC_SMALL_LETTER_SHHA = 0x04BB;
const char32_t CYRILLIC_CAPITAL_LETTER_ABKHASIAN_CHE = 0x04BC;
const char32_t CYRILLIC_SMALL_LETTER_ABKHASIAN_CHE = 0x04BD;
const char32_t CYRILLIC_CAPITAL_LETTER_ABKHASIAN_CHE_WITH_DESCENDER = 0x04BE;
const char32_t CYRILLIC_SMALL_LETTER_ABKHASIAN_CHE_WITH_DESCENDER = 0x04BF;
const char32_t CYRILLIC_LETTER_PALOCHKA = 0x04C0;
const char32_t CYRILLIC_CAPITAL_LETTER_ZHE_WITH_BREVE = 0x04C1;
const char32_t CYRILLIC_SMALL_LETTER_ZHE_WITH_BREVE = 0x04C2;
const char32_t CYRILLIC_CAPITAL_LETTER_KA_WITH_HOOK = 0x04C3;
const char32_t CYRILLIC_SMALL_LETTER_KA_WITH_HOOK = 0x04C4;
const char32_t CYRILLIC_CAPITAL_LETTER_EL_WITH_TAIL = 0x04C5;
const char32_t CYRILLIC_SMALL_LETTER_EL_WITH_TAIL = 0x04C6;
const char32_t CYRILLIC_CAPITAL_LETTER_EN_WITH_HOOK = 0x04C7;
const char32_t CYRILLIC_SMALL_LETTER_EN_WITH_HOOK = 0x04C8;
const char32_t CYRILLIC_CAPITAL_LETTER_EN_WITH_TAIL = 0x04C9;
const char32_t CYRILLIC_SMALL_LETTER_EN_WITH_TAIL = 0x04CA;
const char32_t CYRILLIC_CAPITAL_LETTER_KHAKASSIAN_CHE = 0x04CB;
const char32_t CYRILLIC_SMALL_LETTER_KHAKASSIAN_CHE = 0x04CC;
const char32_t CYRILLIC_CAPITAL_LETTER_EM_WITH_TAIL = 0x04CD;
const char32_t CYRILLIC_SMALL_LETTER_EM_WITH_TAIL = 0x04CE;
const char32_t CYRILLIC_SMALL_LETTER_PALOCHKA = 0x04CF;
const char32_t CYRILLIC_CAPITAL_LETTER_A_WITH_BREVE = 0x04D0;
const char32_t CYRILLIC_SMALL_LETTER_A_WITH_BREVE = 0x04D1;
const char32_t CYRILLIC_CAPITAL_LETTER_A_WITH_DIAERESIS = 0x04D2;
const char32_t CYRILLIC_SMALL_LETTER_A_WITH_DIAERESIS = 0x04D3;
const char32_t CYRILLIC_CAPITAL_LIGATURE_A_IE = 0x04D4;
const char32_t CYRILLIC_SMALL_LIGATURE_A_IE = 0x04D5;
const char32_t CYRILLIC_CAPITAL_LETTER_IE_WITH_BREVE = 0x04D6;
const char32_t CYRILLIC_SMALL_LETTER_IE_WITH_BREVE = 0x04D7;
const char32_t CYRILLIC_CAPITAL_LETTER_SCHWA = 0x04D8;
const char32_t CYRILLIC_SMALL_LETTER_SCHWA = 0x04D9;
const char32_t CYRILLIC_CAPITAL_LETTER_SCHWA_WITH_DIAERESIS = 0x04DA;
const char32_t CYRILLIC_SMALL_LETTER_SCHWA_WITH_DIAERESIS = 0x04DB;
const char32_t CYRILLIC_CAPITAL_LETTER_ZHE_WITH_DIAERESIS = 0x04DC;
const char32_t CYRILLIC_SMALL_LETTER_ZHE_WITH_DIAERESIS = 0x04DD;
const char32_t CYRILLIC_CAPITAL_LETTER_ZE_WITH_DIAERESIS = 0x04DE;
const char32_t CYRILLIC_SMALL_LETTER_ZE_WITH_DIAERESIS = 0x04DF;
const char32_t CYRILLIC_CAPITAL_LETTER_ABKHASIAN_DZE = 0x04E0;
const char32_t CYRILLIC_SMALL_LETTER_ABKHASIAN_DZE = 0x04E1;
const char32_t CYRILLIC_CAPITAL_LETTER_I_WITH_MACRON = 0x04E2;
const char32_t CYRILLIC_SMALL_LETTER_I_WITH_MACRON = 0x04E3;
const char32_t CYRILLIC_CAPITAL_LETTER_I_WITH_DIAERESIS = 0x04E4;
const char32_t CYRILLIC_SMALL_LETTER_I_WITH_DIAERESIS = 0x04E5;
const char32_t CYRILLIC_CAPITAL_LETTER_O_WITH_DIAERESIS = 0x04E6;
const char32_t CYRILLIC_SMALL_LETTER_O_WITH_DIAERESIS = 0x04E7;
const char32_t CYRILLIC_CAPITAL_LETTER_BARRED_O = 0x04E8;
const char32_t CYRILLIC_SMALL_LETTER_BARRED_O = 0x04E9;
const char32_t CYRILLIC_CAPITAL_LETTER_BARRED_O_WITH_DIAERESIS = 0x04EA;
const char32_t CYRILLIC_SMALL_LETTER_BARRED_O_WITH_DIAERESIS = 0x04EB;
const char32_t CYRILLIC_CAPITAL_LETTER_E_WITH_DIAERESIS = 0x04EC;
const char32_t CYRILLIC_SMALL_LETTER_E_WITH_DIAERESIS = 0x04ED;
const char32_t CYRILLIC_CAPITAL_LETTER_U_WITH_MACRON = 0x04EE;
const char32_t CYRILLIC_SMALL_LETTER_U_WITH_MACRON = 0x04EF;
const char32_t CYRILLIC_CAPITAL_LETTER_U_WITH_DIAERESIS = 0x04F0;
const char32_t CYRILLIC_SMALL_LETTER_U_WITH_DIAERESIS = 0x04F1;
const char32_t CYRILLIC_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE = 0x04F2;
const char32_t CYRILLIC_SMALL_LETTER_U_WITH_DOUBLE_ACUTE = 0x04F3;
const char32_t CYRILLIC_CAPITAL_LETTER_CHE_WITH_DIAERESIS = 0x04F4;
const char32_t CYRILLIC_SMALL_LETTER_CHE_WITH_DIAERESIS = 0x04F5;
const char32_t CYRILLIC_CAPITAL_LETTER_GHE_WITH_DESCENDER = 0x04F6;
const char32_t CYRILLIC_SMALL_LETTER_GHE_WITH_DESCENDER = 0x04F7;
const char32_t CYRILLIC_CAPITAL_LETTER_YERU_WITH_DIAERESIS = 0x04F8;
const char32_t CYRILLIC_SMALL_LETTER_YERU_WITH_DIAERESIS = 0x04F9;
const char32_t CYRILLIC_CAPITAL_LETTER_GHE_WITH_STROKE_AND_HOOK = 0x04FA;
const char32_t CYRILLIC_SMALL_LETTER_GHE_WITH_STROKE_AND_HOOK = 0x04FB;
const char32_t CYRILLIC_CAPITAL_LETTER_HA_WITH_HOOK = 0x04FC;
const char32_t CYRILLIC_SMALL_LETTER_HA_WITH_HOOK = 0x04FD;
const char32_t CYRILLIC_CAPITAL_LETTER_HA_WITH_STROKE = 0x04FE;
const char32_t CYRILLIC_SMALL_LETTER_HA_WITH_STROKE = 0x04FF;
const char32_t CYRILLIC_CAPITAL_LETTER_KOMI_DE = 0x0500;
const char32_t CYRILLIC_SMALL_LETTER_KOMI_DE = 0x0501;
const char32_t CYRILLIC_CAPITAL_LETTER_KOMI_DJE = 0x0502;
const char32_t CYRILLIC_SMALL_LETTER_KOMI_DJE = 0x0503;
const char32_t CYRILLIC_CAPITAL_LETTER_KOMI_ZJE = 0x0504;
const char32_t CYRILLIC_SMALL_LETTER_KOMI_ZJE = 0x0505;
const char32_t CYRILLIC_CAPITAL_LETTER_KOMI_DZJE = 0x0506;
const char32_t CYRILLIC_SMALL_LETTER_KOMI_DZJE = 0x0507;
const char32_t CYRILLIC_CAPITAL_LETTER_KOMI_LJE = 0x0508;
const char32_t CYRILLIC_SMALL_LETTER_KOMI_LJE = 0x0509;
const char32_t CYRILLIC_CAPITAL_LETTER_KOMI_NJE = 0x050A;
const char32_t CYRILLIC_SMALL_LETTER_KOMI_NJE = 0x050B;
const char32_t CYRILLIC_CAPITAL_LETTER_KOMI_SJE = 0x050C;
const char32_t CYRILLIC_SMALL_LETTER_KOMI_SJE = 0x050D;
const char32_t CYRILLIC_CAPITAL_LETTER_KOMI_TJE = 0x050E;
const char32_t CYRILLIC_SMALL_LETTER_KOMI_TJE = 0x050F;
const char32_t CYRILLIC_CAPITAL_LETTER_REVERSED_ZE = 0x0510;
const char32_t CYRILLIC_SMALL_LETTER_REVERSED_ZE = 0x0511;
const char32_t CYRILLIC_CAPITAL_LETTER_EL_WITH_HOOK = 0x0512;
const char32_t CYRILLIC_SMALL_LETTER_EL_WITH_HOOK = 0x0513;
const char32_t CYRILLIC_CAPITAL_LETTER_LHA = 0x0514;
const char32_t CYRILLIC_SMALL_LETTER_LHA = 0x0515;
const char32_t CYRILLIC_CAPITAL_LETTER_RHA = 0x0516;
const char32_t CYRILLIC_SMALL_LETTER_RHA = 0x0517;
const char32_t CYRILLIC_CAPITAL_LETTER_YAE = 0x0518;
const char32_t CYRILLIC_SMALL_LETTER_YAE = 0x0519;
const char32_t CYRILLIC_CAPITAL_LETTER_QA = 0x051A;
const char32_t CYRILLIC_SMALL_LETTER_QA = 0x051B;
const char32_t CYRILLIC_CAPITAL_LETTER_WE = 0x051C;
const char32_t CYRILLIC_SMALL_LETTER_WE = 0x051D;
const char32_t CYRILLIC_CAPITAL_LETTER_ALEUT_KA = 0x051E;
const char32_t CYRILLIC_SMALL_LETTER_ALEUT_KA = 0x051F;
const char32_t CYRILLIC_CAPITAL_LETTER_EL_WITH_MIDDLE_HOOK = 0x0520;
const char32_t CYRILLIC_SMALL_LETTER_EL_WITH_MIDDLE_HOOK = 0x0521;
const char32_t CYRILLIC_CAPITAL_LETTER_EN_WITH_MIDDLE_HOOK = 0x0522;
const char32_t CYRILLIC_SMALL_LETTER_EN_WITH_MIDDLE_HOOK = 0x0523;
const char32_t CYRILLIC_CAPITAL_LETTER_PE_WITH_DESCENDER = 0x0524;
const char32_t CYRILLIC_SMALL_LETTER_PE_WITH_DESCENDER = 0x0525;
const char32_t CYRILLIC_CAPITAL_LETTER_SHHA_WITH_DESCENDER = 0x0526;
const char32_t CYRILLIC_SMALL_LETTER_SHHA_WITH_DESCENDER = 0x0527;
const char32_t CYRILLIC_CAPITAL_LETTER_EN_WITH_LEFT_HOOK = 0x0528;
const char32_t CYRILLIC_SMALL_LETTER_EN_WITH_LEFT_HOOK = 0x0529;
const char32_t CYRILLIC_CAPITAL_LETTER_DZZHE = 0x052A;
const char32_t CYRILLIC_SMALL_LETTER_DZZHE = 0x052B;
const char32_t CYRILLIC_CAPITAL_LETTER_DCHE = 0x052C;
const char32_t CYRILLIC_SMALL_LETTER_DCHE = 0x052D;
const char32_t CYRILLIC_CAPITAL_LETTER_EL_WITH_DESCENDER = 0x052E;
const char32_t CYRILLIC_SMALL_LETTER_EL_WITH_DESCENDER = 0x052F;
const char32_t ARMENIAN_CAPITAL_LETTER_AYB = 0x0531;
const char32_t ARMENIAN_CAPITAL_LETTER_BEN = 0x0532;
const char32_t ARMENIAN_CAPITAL_LETTER_GIM = 0x0533;
const char32_t ARMENIAN_CAPITAL_LETTER_DA = 0x0534;
const char32_t ARMENIAN_CAPITAL_LETTER_ECH = 0x0535;
const char32_t ARMENIAN_CAPITAL_LETTER_ZA = 0x0536;
const char32_t ARMENIAN_CAPITAL_LETTER_EH = 0x0537;
const char32_t ARMENIAN_CAPITAL_LETTER_ET = 0x0538;
const char32_t ARMENIAN_CAPITAL_LETTER_TO = 0x0539;
const char32_t ARMENIAN_CAPITAL_LETTER_ZHE = 0x053A;
const char32_t ARMENIAN_CAPITAL_LETTER_INI = 0x053B;
const char32_t ARMENIAN_CAPITAL_LETTER_LIWN = 0x053C;
const char32_t ARMENIAN_CAPITAL_LETTER_XEH = 0x053D;
const char32_t ARMENIAN_CAPITAL_LETTER_CA = 0x053E;
const char32_t ARMENIAN_CAPITAL_LETTER_KEN = 0x053F;
const char32_t ARMENIAN_CAPITAL_LETTER_HO = 0x0540;
const char32_t ARMENIAN_CAPITAL_LETTER_JA = 0x0541;
const char32_t ARMENIAN_CAPITAL_LETTER_GHAD = 0x0542;
const char32_t ARMENIAN_CAPITAL_LETTER_CHEH = 0x0543;
const char32_t ARMENIAN_CAPITAL_LETTER_MEN = 0x0544;
const char32_t ARMENIAN_CAPITAL_LETTER_YI = 0x0545;
const char32_t ARMENIAN_CAPITAL_LETTER_NOW = 0x0546;
const char32_t ARMENIAN_CAPITAL_LETTER_SHA = 0x0547;
const char32_t ARMENIAN_CAPITAL_LETTER_VO = 0x0548;
const char32_t ARMENIAN_CAPITAL_LETTER_CHA = 0x0549;
const char32_t ARMENIAN_CAPITAL_LETTER_PEH = 0x054A;
const char32_t ARMENIAN_CAPITAL_LETTER_JHEH = 0x054B;
const char32_t ARMENIAN_CAPITAL_LETTER_RA = 0x054C;
const char32_t ARMENIAN_CAPITAL_LETTER_SEH = 0x054D;
const char32_t ARMENIAN_CAPITAL_LETTER_VEW = 0x054E;
const char32_t ARMENIAN_CAPITAL_LETTER_TIWN = 0x054F;
const char32_t ARMENIAN_CAPITAL_LETTER_REH = 0x0550;
const char32_t ARMENIAN_CAPITAL_LETTER_CO = 0x0551;
const char32_t ARMENIAN_CAPITAL_LETTER_YIWN = 0x0552;
const char32_t ARMENIAN_CAPITAL_LETTER_PIWR = 0x0553;
const char32_t ARMENIAN_CAPITAL_LETTER_KEH = 0x0554;
const char32_t ARMENIAN_CAPITAL_LETTER_OH = 0x0555;
const char32_t ARMENIAN_CAPITAL_LETTER_FEH = 0x0556;
const char32_t ARMENIAN_MODIFIER_LETTER_LEFT_HALF_RING = 0x0559;
const char32_t ARMENIAN_APOSTROPHE = 0x055A;
const char32_t ARMENIAN_EMPHASIS_MARK = 0x055B;
const char32_t ARMENIAN_EXCLAMATION_MARK = 0x055C;
const char32_t ARMENIAN_COMMA = 0x055D;
const char32_t ARMENIAN_QUESTION_MARK = 0x055E;
const char32_t ARMENIAN_ABBREVIATION_MARK = 0x055F;
const char32_t ARMENIAN_SMALL_LETTER_TURNED_AYB = 0x0560;
const char32_t ARMENIAN_SMALL_LETTER_AYB = 0x0561;
const char32_t ARMENIAN_SMALL_LETTER_BEN = 0x0562;
const char32_t ARMENIAN_SMALL_LETTER_GIM = 0x0563;
const char32_t ARMENIAN_SMALL_LETTER_DA = 0x0564;
const char32_t ARMENIAN_SMALL_LETTER_ECH = 0x0565;
const char32_t ARMENIAN_SMALL_LETTER_ZA = 0x0566;
const char32_t ARMENIAN_SMALL_LETTER_EH = 0x0567;
const char32_t ARMENIAN_SMALL_LETTER_ET = 0x0568;
const char32_t ARMENIAN_SMALL_LETTER_TO = 0x0569;
const char32_t ARMENIAN_SMALL_LETTER_ZHE = 0x056A;
const char32_t ARMENIAN_SMALL_LETTER_INI = 0x056B;
const char32_t ARMENIAN_SMALL_LETTER_LIWN = 0x056C;
const char32_t ARMENIAN_SMALL_LETTER_XEH = 0x056D;
const char32_t ARMENIAN_SMALL_LETTER_CA = 0x056E;
const char32_t ARMENIAN_SMALL_LETTER_KEN = 0x056F;
const char32_t ARMENIAN_SMALL_LETTER_HO = 0x0570;
const char32_t ARMENIAN_SMALL_LETTER_JA = 0x0571;
const char32_t ARMENIAN_SMALL_LETTER_GHAD = 0x0572;
const char32_t ARMENIAN_SMALL_LETTER_CHEH = 0x0573;
const char32_t ARMENIAN_SMALL_LETTER_MEN = 0x0574;
const char32_t ARMENIAN_SMALL_LETTER_YI = 0x0575;
const char32_t ARMENIAN_SMALL_LETTER_NOW = 0x0576;
const char32_t ARMENIAN_SMALL_LETTER_SHA = 0x0577;
const char32_t ARMENIAN_SMALL_LETTER_VO = 0x0578;
const char32_t ARMENIAN_SMALL_LETTER_CHA = 0x0579;
const char32_t ARMENIAN_SMALL_LETTER_PEH = 0x057A;
const char32_t ARMENIAN_SMALL_LETTER_JHEH = 0x057B;
const char32_t ARMENIAN_SMALL_LETTER_RA = 0x057C;
const char32_t ARMENIAN_SMALL_LETTER_SEH = 0x057D;
const char32_t ARMENIAN_SMALL_LETTER_VEW = 0x057E;
const char32_t ARMENIAN_SMALL_LETTER_TIWN = 0x057F;
const char32_t ARMENIAN_SMALL_LETTER_REH = 0x0580;
const char32_t ARMENIAN_SMALL_LETTER_CO = 0x0581;
const char32_t ARMENIAN_SMALL_LETTER_YIWN = 0x0582;
const char32_t ARMENIAN_SMALL_LETTER_PIWR = 0x0583;
const char32_t ARMENIAN_SMALL_LETTER_KEH = 0x0584;
const char32_t ARMENIAN_SMALL_LETTER_OH = 0x0585;
const char32_t ARMENIAN_SMALL_LETTER_FEH = 0x0586;
const char32_t ARMENIAN_SMALL_LIGATURE_ECH_YIWN = 0x0587;
const char32_t ARMENIAN_SMALL_LETTER_YI_WITH_STROKE = 0x0588;
const char32_t ARMENIAN_FULL_STOP = 0x0589;
const char32_t ARMENIAN_HYPHEN = 0x058A;
const char32_t RIGHT_FACING_ARMENIAN_ETERNITY_SIGN = 0x058D;
const char32_t LEFT_FACING_ARMENIAN_ETERNITY_SIGN = 0x058E;
const char32_t ARMENIAN_DRAM_SIGN = 0x058F;
const char32_t HEBREW_ACCENT_ETNAHTA = 0x0591;
const char32_t HEBREW_ACCENT_SEGOL = 0x0592;
const char32_t HEBREW_ACCENT_SHALSHELET = 0x0593;
const char32_t HEBREW_ACCENT_ZAQEF_QATAN = 0x0594;
const char32_t HEBREW_ACCENT_ZAQEF_GADOL = 0x0595;
const char32_t HEBREW_ACCENT_TIPEHA = 0x0596;
const char32_t HEBREW_ACCENT_REVIA = 0x0597;
const char32_t HEBREW_ACCENT_ZARQA = 0x0598;
const char32_t HEBREW_ACCENT_PASHTA = 0x0599;
const char32_t HEBREW_ACCENT_YETIV = 0x059A;
const char32_t HEBREW_ACCENT_TEVIR = 0x059B;
const char32_t HEBREW_ACCENT_GERESH = 0x059C;
const char32_t HEBREW_ACCENT_GERESH_MUQDAM = 0x059D;
const char32_t HEBREW_ACCENT_GERSHAYIM = 0x059E;
const char32_t HEBREW_ACCENT_QARNEY_PARA = 0x059F;
const char32_t HEBREW_ACCENT_TELISHA_GEDOLA = 0x05A0;
const char32_t HEBREW_ACCENT_PAZER = 0x05A1;
const char32_t HEBREW_ACCENT_ATNAH_HAFUKH = 0x05A2;
const char32_t HEBREW_ACCENT_MUNAH = 0x05A3;
const char32_t HEBREW_ACCENT_MAHAPAKH = 0x05A4;
const char32_t HEBREW_ACCENT_MERKHA = 0x05A5;
const char32_t HEBREW_ACCENT_MERKHA_KEFULA = 0x05A6;
const char32_t HEBREW_ACCENT_DARGA = 0x05A7;
const char32_t HEBREW_ACCENT_QADMA = 0x05A8;
const char32_t HEBREW_ACCENT_TELISHA_QETANA = 0x05A9;
const char32_t HEBREW_ACCENT_YERAH_BEN_YOMO = 0x05AA;
const char32_t HEBREW_ACCENT_OLE = 0x05AB;
const char32_t HEBREW_ACCENT_ILUY = 0x05AC;
const char32_t HEBREW_ACCENT_DEHI = 0x05AD;
const char32_t HEBREW_ACCENT_ZINOR = 0x05AE;
const char32_t HEBREW_MARK_MASORA_CIRCLE = 0x05AF;
const char32_t HEBREW_POINT_SHEVA = 0x05B0;
const char32_t HEBREW_POINT_HATAF_SEGOL = 0x05B1;
const char32_t HEBREW_POINT_HATAF_PATAH = 0x05B2;
const char32_t HEBREW_POINT_HATAF_QAMATS = 0x05B3;
const char32_t HEBREW_POINT_HIRIQ = 0x05B4;
const char32_t HEBREW_POINT_TSERE = 0x05B5;
const char32_t HEBREW_POINT_SEGOL = 0x05B6;
const char32_t HEBREW_POINT_PATAH = 0x05B7;
const char32_t HEBREW_POINT_QAMATS = 0x05B8;
const char32_t HEBREW_POINT_HOLAM = 0x05B9;
const char32_t HEBREW_POINT_HOLAM_HASER_FOR_VAV = 0x05BA;
const char32_t HEBREW_POINT_QUBUTS = 0x05BB;
const char32_t HEBREW_POINT_DAGESH_OR_MAPIQ = 0x05BC;
const char32_t HEBREW_POINT_METEG = 0x05BD;
const char32_t HEBREW_PUNCTUATION_MAQAF = 0x05BE;
const char32_t HEBREW_POINT_RAFE = 0x05BF;
const char32_t HEBREW_PUNCTUATION_PASEQ = 0x05C0;
const char32_t HEBREW_POINT_SHIN_DOT = 0x05C1;
const char32_t HEBREW_POINT_SIN_DOT = 0x05C2;
const char32_t HEBREW_PUNCTUATION_SOF_PASUQ = 0x05C3;
const char32_t HEBREW_MARK_UPPER_DOT = 0x05C4;
const char32_t HEBREW_MARK_LOWER_DOT = 0x05C5;
const char32_t HEBREW_PUNCTUATION_NUN_HAFUKHA = 0x05C6;
const char32_t HEBREW_POINT_QAMATS_QATAN = 0x05C7;
const char32_t HEBREW_LETTER_ALEF = 0x05D0;
const char32_t HEBREW_LETTER_BET = 0x05D1;
const char32_t HEBREW_LETTER_GIMEL = 0x05D2;
const char32_t HEBREW_LETTER_DALET = 0x05D3;
const char32_t HEBREW_LETTER_HE = 0x05D4;
const char32_t HEBREW_LETTER_VAV = 0x05D5;
const char32_t HEBREW_LETTER_ZAYIN = 0x05D6;
const char32_t HEBREW_LETTER_HET = 0x05D7;
const char32_t HEBREW_LETTER_TET = 0x05D8;
const char32_t HEBREW_LETTER_YOD = 0x05D9;
const char32_t HEBREW_LETTER_FINAL_KAF = 0x05DA;
const char32_t HEBREW_LETTER_KAF = 0x05DB;
const char32_t HEBREW_LETTER_LAMED = 0x05DC;
const char32_t HEBREW_LETTER_FINAL_MEM = 0x05DD;
const char32_t HEBREW_LETTER_MEM = 0x05DE;
const char32_t HEBREW_LETTER_FINAL_NUN = 0x05DF;
const char32_t HEBREW_LETTER_NUN = 0x05E0;
const char32_t HEBREW_LETTER_SAMEKH = 0x05E1;
const char32_t HEBREW_LETTER_AYIN = 0x05E2;
const char32_t HEBREW_LETTER_FINAL_PE = 0x05E3;
const char32_t HEBREW_LETTER_PE = 0x05E4;
const char32_t HEBREW_LETTER_FINAL_TSADI = 0x05E5;
const char32_t HEBREW_LETTER_TSADI = 0x05E6;
const char32_t HEBREW_LETTER_QOF = 0x05E7;
const char32_t HEBREW_LETTER_RESH = 0x05E8;
const char32_t HEBREW_LETTER_SHIN = 0x05E9;
const char32_t HEBREW_LETTER_TAV = 0x05EA;
const char32_t HEBREW_YOD_TRIANGLE = 0x05EF;
const char32_t HEBREW_LIGATURE_YIDDISH_DOUBLE_VAV = 0x05F0;
const char32_t HEBREW_LIGATURE_YIDDISH_VAV_YOD = 0x05F1;
const char32_t HEBREW_LIGATURE_YIDDISH_DOUBLE_YOD = 0x05F2;
const char32_t HEBREW_PUNCTUATION_GERESH = 0x05F3;
const char32_t HEBREW_PUNCTUATION_GERSHAYIM = 0x05F4;
const char32_t ARABIC_NUMBER_SIGN = 0x0600;
const char32_t ARABIC_SIGN_SANAH = 0x0601;
const char32_t ARABIC_FOOTNOTE_MARKER = 0x0602;
const char32_t ARABIC_SIGN_SAFHA = 0x0603;
const char32_t ARABIC_SIGN_SAMVAT = 0x0604;
const char32_t ARABIC_NUMBER_MARK_ABOVE = 0x0605;
const char32_t ARABIC_INDIC_CUBE_ROOT = 0x0606;
const char32_t ARABIC_INDIC_FOURTH_ROOT = 0x0607;
const char32_t ARABIC_RAY = 0x0608;
const char32_t ARABIC_INDIC_PER_MILLE_SIGN = 0x0609;
const char32_t ARABIC_INDIC_PER_TEN_THOUSAND_SIGN = 0x060A;
const char32_t AFGHANI_SIGN = 0x060B;
const char32_t ARABIC_COMMA = 0x060C;
const char32_t ARABIC_DATE_SEPARATOR = 0x060D;
const char32_t ARABIC_POETIC_VERSE_SIGN = 0x060E;
const char32_t ARABIC_SIGN_MISRA = 0x060F;
const char32_t ARABIC_SIGN_SALLALLAHOU_ALAYHE_WASSALLAM = 0x0610;
const char32_t ARABIC_SIGN_ALAYHE_ASSALLAM = 0x0611;
const char32_t ARABIC_SIGN_RAHMATULLAH_ALAYHE = 0x0612;
const char32_t ARABIC_SIGN_RADI_ALLAHOU_ANHU = 0x0613;
const char32_t ARABIC_SIGN_TAKHALLUS = 0x0614;
const char32_t ARABIC_SMALL_HIGH_TAH = 0x0615;
const char32_t ARABIC_SMALL_HIGH_LIGATURE_ALEF_WITH_LAM_WITH_YEH = 0x0616;
const char32_t ARABIC_SMALL_HIGH_ZAIN = 0x0617;
const char32_t ARABIC_SMALL_FATHA = 0x0618;
const char32_t ARABIC_SMALL_DAMMA = 0x0619;
const char32_t ARABIC_SMALL_KASRA = 0x061A;
const char32_t ARABIC_SEMICOLON = 0x061B;
const char32_t ARABIC_LETTER_MARK = 0x061C;
const char32_t ARABIC_TRIPLE_DOT_PUNCTUATION_MARK = 0x061E;
const char32_t ARABIC_QUESTION_MARK = 0x061F;
const char32_t ARABIC_LETTER_KASHMIRI_YEH = 0x0620;
const char32_t ARABIC_LETTER_HAMZA = 0x0621;
const char32_t ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE = 0x0622;
const char32_t ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE = 0x0623;
const char32_t ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE = 0x0624;
const char32_t ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW = 0x0625;
const char32_t ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE = 0x0626;
const char32_t ARABIC_LETTER_ALEF = 0x0627;
const char32_t ARABIC_LETTER_BEH = 0x0628;
const char32_t ARABIC_LETTER_TEH_MARBUTA = 0x0629;
const char32_t ARABIC_LETTER_TEH = 0x062A;
const char32_t ARABIC_LETTER_THEH = 0x062B;
const char32_t ARABIC_LETTER_JEEM = 0x062C;
const char32_t ARABIC_LETTER_HAH = 0x062D;
const char32_t ARABIC_LETTER_KHAH = 0x062E;
const char32_t ARABIC_LETTER_DAL = 0x062F;
const char32_t ARABIC_LETTER_THAL = 0x0630;
const char32_t ARABIC_LETTER_REH = 0x0631;
const char32_t ARABIC_LETTER_ZAIN = 0x0632;
const char32_t ARABIC_LETTER_SEEN = 0x0633;
const char32_t ARABIC_LETTER_SHEEN = 0x0634;
const char32_t ARABIC_LETTER_SAD = 0x0635;
const char32_t ARABIC_LETTER_DAD = 0x0636;
const char32_t ARABIC_LETTER_TAH = 0x0637;
const char32_t ARABIC_LETTER_ZAH = 0x0638;
const char32_t ARABIC_LETTER_AIN = 0x0639;
const char32_t ARABIC_LETTER_GHAIN = 0x063A;
const char32_t ARABIC_LETTER_KEHEH_WITH_TWO_DOTS_ABOVE = 0x063B;
const char32_t ARABIC_LETTER_KEHEH_WITH_THREE_DOTS_BELOW = 0x063C;
const char32_t ARABIC_LETTER_FARSI_YEH_WITH_INVERTED_V = 0x063D;
const char32_t ARABIC_LETTER_FARSI_YEH_WITH_TWO_DOTS_ABOVE = 0x063E;
const char32_t ARABIC_LETTER_FARSI_YEH_WITH_THREE_DOTS_ABOVE = 0x063F;
const char32_t ARABIC_TATWEEL = 0x0640;
const char32_t ARABIC_LETTER_FEH = 0x0641;
const char32_t ARABIC_LETTER_QAF = 0x0642;
const char32_t ARABIC_LETTER_KAF = 0x0643;
const char32_t ARABIC_LETTER_LAM = 0x0644;
const char32_t ARABIC_LETTER_MEEM = 0x0645;
const char32_t ARABIC_LETTER_NOON = 0x0646;
const char32_t ARABIC_LETTER_HEH = 0x0647;
const char32_t ARABIC_LETTER_WAW = 0x0648;
const char32_t ARABIC_LETTER_ALEF_MAKSURA = 0x0649;
const char32_t ARABIC_LETTER_YEH = 0x064A;
const char32_t ARABIC_FATHATAN = 0x064B;
const char32_t ARABIC_DAMMATAN = 0x064C;
const char32_t ARABIC_KASRATAN = 0x064D;
const char32_t ARABIC_FATHA = 0x064E;
const char32_t ARABIC_DAMMA = 0x064F;
const char32_t ARABIC_KASRA = 0x0650;
const char32_t ARABIC_SHADDA = 0x0651;
const char32_t ARABIC_SUKUN = 0x0652;
const char32_t ARABIC_MADDAH_ABOVE = 0x0653;
const char32_t ARABIC_HAMZA_ABOVE = 0x0654;
const char32_t ARABIC_HAMZA_BELOW = 0x0655;
const char32_t ARABIC_SUBSCRIPT_ALEF = 0x0656;
const char32_t ARABIC_INVERTED_DAMMA = 0x0657;
const char32_t ARABIC_MARK_NOON_GHUNNA = 0x0658;
const char32_t ARABIC_ZWARAKAY = 0x0659;
const char32_t ARABIC_VOWEL_SIGN_SMALL_V_ABOVE = 0x065A;
const char32_t ARABIC_VOWEL_SIGN_INVERTED_SMALL_V_ABOVE = 0x065B;
const char32_t ARABIC_VOWEL_SIGN_DOT_BELOW = 0x065C;
const char32_t ARABIC_REVERSED_DAMMA = 0x065D;
const char32_t ARABIC_FATHA_WITH_TWO_DOTS = 0x065E;
const char32_t ARABIC_WAVY_HAMZA_BELOW = 0x065F;
const char32_t ARABIC_INDIC_DIGIT_ZERO = 0x0660;
const char32_t ARABIC_INDIC_DIGIT_ONE = 0x0661;
const char32_t ARABIC_INDIC_DIGIT_TWO = 0x0662;
const char32_t ARABIC_INDIC_DIGIT_THREE = 0x0663;
const char32_t ARABIC_INDIC_DIGIT_FOUR = 0x0664;
const char32_t ARABIC_INDIC_DIGIT_FIVE = 0x0665;
const char32_t ARABIC_INDIC_DIGIT_SIX = 0x0666;
const char32_t ARABIC_INDIC_DIGIT_SEVEN = 0x0667;
const char32_t ARABIC_INDIC_DIGIT_EIGHT = 0x0668;
const char32_t ARABIC_INDIC_DIGIT_NINE = 0x0669;
const char32_t ARABIC_PERCENT_SIGN = 0x066A;
const char32_t ARABIC_DECIMAL_SEPARATOR = 0x066B;
const char32_t ARABIC_THOUSANDS_SEPARATOR = 0x066C;
const char32_t ARABIC_FIVE_POINTED_STAR = 0x066D;
const char32_t ARABIC_LETTER_DOTLESS_BEH = 0x066E;
const char32_t ARABIC_LETTER_DOTLESS_QAF = 0x066F;
const char32_t ARABIC_LETTER_SUPERSCRIPT_ALEF = 0x0670;
const char32_t ARABIC_LETTER_ALEF_WASLA = 0x0671;
const char32_t ARABIC_LETTER_ALEF_WITH_WAVY_HAMZA_ABOVE = 0x0672;
const char32_t ARABIC_LETTER_ALEF_WITH_WAVY_HAMZA_BELOW = 0x0673;
const char32_t ARABIC_LETTER_HIGH_HAMZA = 0x0674;
const char32_t ARABIC_LETTER_HIGH_HAMZA_ALEF = 0x0675;
const char32_t ARABIC_LETTER_HIGH_HAMZA_WAW = 0x0676;
const char32_t ARABIC_LETTER_U_WITH_HAMZA_ABOVE = 0x0677;
const char32_t ARABIC_LETTER_HIGH_HAMZA_YEH = 0x0678;
const char32_t ARABIC_LETTER_TTEH = 0x0679;
const char32_t ARABIC_LETTER_TTEHEH = 0x067A;
const char32_t ARABIC_LETTER_BEEH = 0x067B;
const char32_t ARABIC_LETTER_TEH_WITH_RING = 0x067C;
const char32_t ARABIC_LETTER_TEH_WITH_THREE_DOTS_ABOVE_DOWNWARDS = 0x067D;
const char32_t ARABIC_LETTER_PEH = 0x067E;
const char32_t ARABIC_LETTER_TEHEH = 0x067F;
const char32_t ARABIC_LETTER_BEHEH = 0x0680;
const char32_t ARABIC_LETTER_HAH_WITH_HAMZA_ABOVE = 0x0681;
const char32_t ARABIC_LETTER_HAH_WITH_TWO_DOTS_VERTICAL_ABOVE = 0x0682;
const char32_t ARABIC_LETTER_NYEH = 0x0683;
const char32_t ARABIC_LETTER_DYEH = 0x0684;
const char32_t ARABIC_LETTER_HAH_WITH_THREE_DOTS_ABOVE = 0x0685;
const char32_t ARABIC_LETTER_TCHEH = 0x0686;
const char32_t ARABIC_LETTER_TCHEHEH = 0x0687;
const char32_t ARABIC_LETTER_DDAL = 0x0688;
const char32_t ARABIC_LETTER_DAL_WITH_RING = 0x0689;
const char32_t ARABIC_LETTER_DAL_WITH_DOT_BELOW = 0x068A;
const char32_t ARABIC_LETTER_DAL_WITH_DOT_BELOW_AND_SMALL_TAH = 0x068B;
const char32_t ARABIC_LETTER_DAHAL = 0x068C;
const char32_t ARABIC_LETTER_DDAHAL = 0x068D;
const char32_t ARABIC_LETTER_DUL = 0x068E;
const char32_t ARABIC_LETTER_DAL_WITH_THREE_DOTS_ABOVE_DOWNWARDS = 0x068F;
const char32_t ARABIC_LETTER_DAL_WITH_FOUR_DOTS_ABOVE = 0x0690;
const char32_t ARABIC_LETTER_RREH = 0x0691;
const char32_t ARABIC_LETTER_REH_WITH_SMALL_V = 0x0692;
const char32_t ARABIC_LETTER_REH_WITH_RING = 0x0693;
const char32_t ARABIC_LETTER_REH_WITH_DOT_BELOW = 0x0694;
const char32_t ARABIC_LETTER_REH_WITH_SMALL_V_BELOW = 0x0695;
const char32_t ARABIC_LETTER_REH_WITH_DOT_BELOW_AND_DOT_ABOVE = 0x0696;
const char32_t ARABIC_LETTER_REH_WITH_TWO_DOTS_ABOVE = 0x0697;
const char32_t ARABIC_LETTER_JEH = 0x0698;
const char32_t ARABIC_LETTER_REH_WITH_FOUR_DOTS_ABOVE = 0x0699;
const char32_t ARABIC_LETTER_SEEN_WITH_DOT_BELOW_AND_DOT_ABOVE = 0x069A;
const char32_t ARABIC_LETTER_SEEN_WITH_THREE_DOTS_BELOW = 0x069B;
const char32_t ARABIC_LETTER_SEEN_WITH_THREE_DOTS_BELOW_AND_THREE_DOTS_ABOVE = 0x069C;
const char32_t ARABIC_LETTER_SAD_WITH_TWO_DOTS_BELOW = 0x069D;
const char32_t ARABIC_LETTER_SAD_WITH_THREE_DOTS_ABOVE = 0x069E;
const char32_t ARABIC_LETTER_TAH_WITH_THREE_DOTS_ABOVE = 0x069F;
const char32_t ARABIC_LETTER_AIN_WITH_THREE_DOTS_ABOVE = 0x06A0;
const char32_t ARABIC_LETTER_DOTLESS_FEH = 0x06A1;
const char32_t ARABIC_LETTER_FEH_WITH_DOT_MOVED_BELOW = 0x06A2;
const char32_t ARABIC_LETTER_FEH_WITH_DOT_BELOW = 0x06A3;
const char32_t ARABIC_LETTER_VEH = 0x06A4;
const char32_t ARABIC_LETTER_FEH_WITH_THREE_DOTS_BELOW = 0x06A5;
const char32_t ARABIC_LETTER_PEHEH = 0x06A6;
const char32_t ARABIC_LETTER_QAF_WITH_DOT_ABOVE = 0x06A7;
const char32_t ARABIC_LETTER_QAF_WITH_THREE_DOTS_ABOVE = 0x06A8;
const char32_t ARABIC_LETTER_KEHEH = 0x06A9;
const char32_t ARABIC_LETTER_SWASH_KAF = 0x06AA;
const char32_t ARABIC_LETTER_KAF_WITH_RING = 0x06AB;
const char32_t ARABIC_LETTER_KAF_WITH_DOT_ABOVE = 0x06AC;
const char32_t ARABIC_LETTER_NG = 0x06AD;
const char32_t ARABIC_LETTER_KAF_WITH_THREE_DOTS_BELOW = 0x06AE;
const char32_t ARABIC_LETTER_GAF = 0x06AF;
const char32_t ARABIC_LETTER_GAF_WITH_RING = 0x06B0;
const char32_t ARABIC_LETTER_NGOEH = 0x06B1;
const char32_t ARABIC_LETTER_GAF_WITH_TWO_DOTS_BELOW = 0x06B2;
const char32_t ARABIC_LETTER_GUEH = 0x06B3;
const char32_t ARABIC_LETTER_GAF_WITH_THREE_DOTS_ABOVE = 0x06B4;
const char32_t ARABIC_LETTER_LAM_WITH_SMALL_V = 0x06B5;
const char32_t ARABIC_LETTER_LAM_WITH_DOT_ABOVE = 0x06B6;
const char32_t ARABIC_LETTER_LAM_WITH_THREE_DOTS_ABOVE = 0x06B7;
const char32_t ARABIC_LETTER_LAM_WITH_THREE_DOTS_BELOW = 0x06B8;
const char32_t ARABIC_LETTER_NOON_WITH_DOT_BELOW = 0x06B9;
const char32_t ARABIC_LETTER_NOON_GHUNNA = 0x06BA;
const char32_t ARABIC_LETTER_RNOON = 0x06BB;
const char32_t ARABIC_LETTER_NOON_WITH_RING = 0x06BC;
const char32_t ARABIC_LETTER_NOON_WITH_THREE_DOTS_ABOVE = 0x06BD;
const char32_t ARABIC_LETTER_HEH_DOACHASHMEE = 0x06BE;
const char32_t ARABIC_LETTER_TCHEH_WITH_DOT_ABOVE = 0x06BF;
const char32_t ARABIC_LETTER_HEH_WITH_YEH_ABOVE = 0x06C0;
const char32_t ARABIC_LETTER_HEH_GOAL = 0x06C1;
const char32_t ARABIC_LETTER_HEH_GOAL_WITH_HAMZA_ABOVE = 0x06C2;
const char32_t ARABIC_LETTER_TEH_MARBUTA_GOAL = 0x06C3;
const char32_t ARABIC_LETTER_WAW_WITH_RING = 0x06C4;
const char32_t ARABIC_LETTER_KIRGHIZ_OE = 0x06C5;
const char32_t ARABIC_LETTER_OE = 0x06C6;
const char32_t ARABIC_LETTER_U = 0x06C7;
const char32_t ARABIC_LETTER_YU = 0x06C8;
const char32_t ARABIC_LETTER_KIRGHIZ_YU = 0x06C9;
const char32_t ARABIC_LETTER_WAW_WITH_TWO_DOTS_ABOVE = 0x06CA;
const char32_t ARABIC_LETTER_VE = 0x06CB;
const char32_t ARABIC_LETTER_FARSI_YEH = 0x06CC;
const char32_t ARABIC_LETTER_YEH_WITH_TAIL = 0x06CD;
const char32_t ARABIC_LETTER_YEH_WITH_SMALL_V = 0x06CE;
const char32_t ARABIC_LETTER_WAW_WITH_DOT_ABOVE = 0x06CF;
const char32_t ARABIC_LETTER_E = 0x06D0;
const char32_t ARABIC_LETTER_YEH_WITH_THREE_DOTS_BELOW = 0x06D1;
const char32_t ARABIC_LETTER_YEH_BARREE = 0x06D2;
const char32_t ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE = 0x06D3;
const char32_t ARABIC_FULL_STOP = 0x06D4;
const char32_t ARABIC_LETTER_AE = 0x06D5;
const char32_t ARABIC_SMALL_HIGH_LIGATURE_SAD_WITH_LAM_WITH_ALEF_MAKSURA = 0x06D6;
const char32_t ARABIC_SMALL_HIGH_LIGATURE_QAF_WITH_LAM_WITH_ALEF_MAKSURA = 0x06D7;
const char32_t ARABIC_SMALL_HIGH_MEEM_INITIAL_FORM = 0x06D8;
const char32_t ARABIC_SMALL_HIGH_LAM_ALEF = 0x06D9;
const char32_t ARABIC_SMALL_HIGH_JEEM = 0x06DA;
const char32_t ARABIC_SMALL_HIGH_THREE_DOTS = 0x06DB;
const char32_t ARABIC_SMALL_HIGH_SEEN = 0x06DC;
const char32_t ARABIC_END_OF_AYAH = 0x06DD;
const char32_t ARABIC_START_OF_RUB_EL_HIZB = 0x06DE;
const char32_t ARABIC_SMALL_HIGH_ROUNDED_ZERO = 0x06DF;
const char32_t ARABIC_SMALL_HIGH_UPRIGHT_RECTANGULAR_ZERO = 0x06E0;
const char32_t ARABIC_SMALL_HIGH_DOTLESS_HEAD_OF_KHAH = 0x06E1;
const char32_t ARABIC_SMALL_HIGH_MEEM_ISOLATED_FORM = 0x06E2;
const char32_t ARABIC_SMALL_LOW_SEEN = 0x06E3;
const char32_t ARABIC_SMALL_HIGH_MADDA = 0x06E4;
const char32_t ARABIC_SMALL_WAW = 0x06E5;
const char32_t ARABIC_SMALL_YEH = 0x06E6;
const char32_t ARABIC_SMALL_HIGH_YEH = 0x06E7;
const char32_t ARABIC_SMALL_HIGH_NOON = 0x06E8;
const char32_t ARABIC_PLACE_OF_SAJDAH = 0x06E9;
const char32_t ARABIC_EMPTY_CENTRE_LOW_STOP = 0x06EA;
const char32_t ARABIC_EMPTY_CENTRE_HIGH_STOP = 0x06EB;
const char32_t ARABIC_ROUNDED_HIGH_STOP_WITH_FILLED_CENTRE = 0x06EC;
const char32_t ARABIC_SMALL_LOW_MEEM = 0x06ED;
const char32_t ARABIC_LETTER_DAL_WITH_INVERTED_V = 0x06EE;
const char32_t ARABIC_LETTER_REH_WITH_INVERTED_V = 0x06EF;
const char32_t EXTENDED_ARABIC_INDIC_DIGIT_ZERO = 0x06F0;
const char32_t EXTENDED_ARABIC_INDIC_DIGIT_ONE = 0x06F1;
const char32_t EXTENDED_ARABIC_INDIC_DIGIT_TWO = 0x06F2;
const char32_t EXTENDED_ARABIC_INDIC_DIGIT_THREE = 0x06F3;
const char32_t EXTENDED_ARABIC_INDIC_DIGIT_FOUR = 0x06F4;
const char32_t EXTENDED_ARABIC_INDIC_DIGIT_FIVE = 0x06F5;
const char32_t EXTENDED_ARABIC_INDIC_DIGIT_SIX = 0x06F6;
const char32_t EXTENDED_ARABIC_INDIC_DIGIT_SEVEN = 0x06F7;
const char32_t EXTENDED_ARABIC_INDIC_DIGIT_EIGHT = 0x06F8;
const char32_t EXTENDED_ARABIC_INDIC_DIGIT_NINE = 0x06F9;
const char32_t ARABIC_LETTER_SHEEN_WITH_DOT_BELOW = 0x06FA;
const char32_t ARABIC_LETTER_DAD_WITH_DOT_BELOW = 0x06FB;
const char32_t ARABIC_LETTER_GHAIN_WITH_DOT_BELOW = 0x06FC;
const char32_t ARABIC_SIGN_SINDHI_AMPERSAND = 0x06FD;
const char32_t ARABIC_SIGN_SINDHI_POSTPOSITION_MEN = 0x06FE;
const char32_t ARABIC_LETTER_HEH_WITH_INVERTED_V = 0x06FF;
const char32_t SYRIAC_END_OF_PARAGRAPH = 0x0700;
const char32_t SYRIAC_SUPRALINEAR_FULL_STOP = 0x0701;
const char32_t SYRIAC_SUBLINEAR_FULL_STOP = 0x0702;
const char32_t SYRIAC_SUPRALINEAR_COLON = 0x0703;
const char32_t SYRIAC_SUBLINEAR_COLON = 0x0704;
const char32_t SYRIAC_HORIZONTAL_COLON = 0x0705;
const char32_t SYRIAC_COLON_SKEWED_LEFT = 0x0706;
const char32_t SYRIAC_COLON_SKEWED_RIGHT = 0x0707;
const char32_t SYRIAC_SUPRALINEAR_COLON_SKEWED_LEFT = 0x0708;
const char32_t SYRIAC_SUBLINEAR_COLON_SKEWED_RIGHT = 0x0709;
const char32_t SYRIAC_CONTRACTION = 0x070A;
const char32_t SYRIAC_HARKLEAN_OBELUS = 0x070B;
const char32_t SYRIAC_HARKLEAN_METOBELUS = 0x070C;
const char32_t SYRIAC_HARKLEAN_ASTERISCUS = 0x070D;
const char32_t SYRIAC_ABBREVIATION_MARK = 0x070F;
const char32_t SYRIAC_LETTER_ALAPH = 0x0710;
const char32_t SYRIAC_LETTER_SUPERSCRIPT_ALAPH = 0x0711;
const char32_t SYRIAC_LETTER_BETH = 0x0712;
const char32_t SYRIAC_LETTER_GAMAL = 0x0713;
const char32_t SYRIAC_LETTER_GAMAL_GARSHUNI = 0x0714;
const char32_t SYRIAC_LETTER_DALATH = 0x0715;
const char32_t SYRIAC_LETTER_DOTLESS_DALATH_RISH = 0x0716;
const char32_t SYRIAC_LETTER_HE = 0x0717;
const char32_t SYRIAC_LETTER_WAW = 0x0718;
const char32_t SYRIAC_LETTER_ZAIN = 0x0719;
const char32_t SYRIAC_LETTER_HETH = 0x071A;
const char32_t SYRIAC_LETTER_TETH = 0x071B;
const char32_t SYRIAC_LETTER_TETH_GARSHUNI = 0x071C;
const char32_t SYRIAC_LETTER_YUDH = 0x071D;
const char32_t SYRIAC_LETTER_YUDH_HE = 0x071E;
const char32_t SYRIAC_LETTER_KAPH = 0x071F;
const char32_t SYRIAC_LETTER_LAMADH = 0x0720;
const char32_t SYRIAC_LETTER_MIM = 0x0721;
const char32_t SYRIAC_LETTER_NUN = 0x0722;
const char32_t SYRIAC_LETTER_SEMKATH = 0x0723;
const char32_t SYRIAC_LETTER_FINAL_SEMKATH = 0x0724;
const char32_t SYRIAC_LETTER_E = 0x0725;
const char32_t SYRIAC_LETTER_PE = 0x0726;
const char32_t SYRIAC_LETTER_REVERSED_PE = 0x0727;
const char32_t SYRIAC_LETTER_SADHE = 0x0728;
const char32_t SYRIAC_LETTER_QAPH = 0x0729;
const char32_t SYRIAC_LETTER_RISH = 0x072A;
const char32_t SYRIAC_LETTER_SHIN = 0x072B;
const char32_t SYRIAC_LETTER_TAW = 0x072C;
const char32_t SYRIAC_LETTER_PERSIAN_BHETH = 0x072D;
const char32_t SYRIAC_LETTER_PERSIAN_GHAMAL = 0x072E;
const char32_t SYRIAC_LETTER_PERSIAN_DHALATH = 0x072F;
const char32_t SYRIAC_PTHAHA_ABOVE = 0x0730;
const char32_t SYRIAC_PTHAHA_BELOW = 0x0731;
const char32_t SYRIAC_PTHAHA_DOTTED = 0x0732;
const char32_t SYRIAC_ZQAPHA_ABOVE = 0x0733;
const char32_t SYRIAC_ZQAPHA_BELOW = 0x0734;
const char32_t SYRIAC_ZQAPHA_DOTTED = 0x0735;
const char32_t SYRIAC_RBASA_ABOVE = 0x0736;
const char32_t SYRIAC_RBASA_BELOW = 0x0737;
const char32_t SYRIAC_DOTTED_ZLAMA_HORIZONTAL = 0x0738;
const char32_t SYRIAC_DOTTED_ZLAMA_ANGULAR = 0x0739;
const char32_t SYRIAC_HBASA_ABOVE = 0x073A;
const char32_t SYRIAC_HBASA_BELOW = 0x073B;
const char32_t SYRIAC_HBASA_ESASA_DOTTED = 0x073C;
const char32_t SYRIAC_ESASA_ABOVE = 0x073D;
const char32_t SYRIAC_ESASA_BELOW = 0x073E;
const char32_t SYRIAC_RWAHA = 0x073F;
const char32_t SYRIAC_FEMININE_DOT = 0x0740;
const char32_t SYRIAC_QUSHSHAYA = 0x0741;
const char32_t SYRIAC_RUKKAKHA = 0x0742;
const char32_t SYRIAC_TWO_VERTICAL_DOTS_ABOVE = 0x0743;
const char32_t SYRIAC_TWO_VERTICAL_DOTS_BELOW = 0x0744;
const char32_t SYRIAC_THREE_DOTS_ABOVE = 0x0745;
const char32_t SYRIAC_THREE_DOTS_BELOW = 0x0746;
const char32_t SYRIAC_OBLIQUE_LINE_ABOVE = 0x0747;
const char32_t SYRIAC_OBLIQUE_LINE_BELOW = 0x0748;
const char32_t SYRIAC_MUSIC = 0x0749;
const char32_t SYRIAC_BARREKH = 0x074A;
const char32_t SYRIAC_LETTER_SOGDIAN_ZHAIN = 0x074D;
const char32_t SYRIAC_LETTER_SOGDIAN_KHAPH = 0x074E;
const char32_t SYRIAC_LETTER_SOGDIAN_FE = 0x074F;
const char32_t ARABIC_LETTER_BEH_WITH_THREE_DOTS_HORIZONTALLY_BELOW = 0x0750;
const char32_t ARABIC_LETTER_BEH_WITH_DOT_BELOW_AND_THREE_DOTS_ABOVE = 0x0751;
const char32_t ARABIC_LETTER_BEH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW = 0x0752;
const char32_t ARABIC_LETTER_BEH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW_AND_TWO_DOTS_ABOVE = 0x0753;
const char32_t ARABIC_LETTER_BEH_WITH_TWO_DOTS_BELOW_AND_DOT_ABOVE = 0x0754;
const char32_t ARABIC_LETTER_BEH_WITH_INVERTED_SMALL_V_BELOW = 0x0755;
const char32_t ARABIC_LETTER_BEH_WITH_SMALL_V = 0x0756;
const char32_t ARABIC_LETTER_HAH_WITH_TWO_DOTS_ABOVE = 0x0757;
const char32_t ARABIC_LETTER_HAH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW = 0x0758;
const char32_t ARABIC_LETTER_DAL_WITH_TWO_DOTS_VERTICALLY_BELOW_AND_SMALL_TAH = 0x0759;
const char32_t ARABIC_LETTER_DAL_WITH_INVERTED_SMALL_V_BELOW = 0x075A;
const char32_t ARABIC_LETTER_REH_WITH_STROKE = 0x075B;
const char32_t ARABIC_LETTER_SEEN_WITH_FOUR_DOTS_ABOVE = 0x075C;
const char32_t ARABIC_LETTER_AIN_WITH_TWO_DOTS_ABOVE = 0x075D;
const char32_t ARABIC_LETTER_AIN_WITH_THREE_DOTS_POINTING_DOWNWARDS_ABOVE = 0x075E;
const char32_t ARABIC_LETTER_AIN_WITH_TWO_DOTS_VERTICALLY_ABOVE = 0x075F;
const char32_t ARABIC_LETTER_FEH_WITH_TWO_DOTS_BELOW = 0x0760;
const char32_t ARABIC_LETTER_FEH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW = 0x0761;
const char32_t ARABIC_LETTER_KEHEH_WITH_DOT_ABOVE = 0x0762;
const char32_t ARABIC_LETTER_KEHEH_WITH_THREE_DOTS_ABOVE = 0x0763;
const char32_t ARABIC_LETTER_KEHEH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW = 0x0764;
const char32_t ARABIC_LETTER_MEEM_WITH_DOT_ABOVE = 0x0765;
const char32_t ARABIC_LETTER_MEEM_WITH_DOT_BELOW = 0x0766;
const char32_t ARABIC_LETTER_NOON_WITH_TWO_DOTS_BELOW = 0x0767;
const char32_t ARABIC_LETTER_NOON_WITH_SMALL_TAH = 0x0768;
const char32_t ARABIC_LETTER_NOON_WITH_SMALL_V = 0x0769;
const char32_t ARABIC_LETTER_LAM_WITH_BAR = 0x076A;
const char32_t ARABIC_LETTER_REH_WITH_TWO_DOTS_VERTICALLY_ABOVE = 0x076B;
const char32_t ARABIC_LETTER_REH_WITH_HAMZA_ABOVE = 0x076C;
const char32_t ARABIC_LETTER_SEEN_WITH_TWO_DOTS_VERTICALLY_ABOVE = 0x076D;
const char32_t ARABIC_LETTER_HAH_WITH_SMALL_ARABIC_LETTER_TAH_BELOW = 0x076E;
const char32_t ARABIC_LETTER_HAH_WITH_SMALL_ARABIC_LETTER_TAH_AND_TWO_DOTS = 0x076F;
const char32_t ARABIC_LETTER_SEEN_WITH_SMALL_ARABIC_LETTER_TAH_AND_TWO_DOTS = 0x0770;
const char32_t ARABIC_LETTER_REH_WITH_SMALL_ARABIC_LETTER_TAH_AND_TWO_DOTS = 0x0771;
const char32_t ARABIC_LETTER_HAH_WITH_SMALL_ARABIC_LETTER_TAH_ABOVE = 0x0772;
const char32_t ARABIC_LETTER_ALEF_WITH_EXTENDED_ARABIC_INDIC_DIGIT_TWO_ABOVE = 0x0773;
const char32_t ARABIC_LETTER_ALEF_WITH_EXTENDED_ARABIC_INDIC_DIGIT_THREE_ABOVE = 0x0774;
const char32_t ARABIC_LETTER_FARSI_YEH_WITH_EXTENDED_ARABIC_INDIC_DIGIT_TWO_ABOVE = 0x0775;
const char32_t ARABIC_LETTER_FARSI_YEH_WITH_EXTENDED_ARABIC_INDIC_DIGIT_THREE_ABOVE = 0x0776;
const char32_t ARABIC_LETTER_FARSI_YEH_WITH_EXTENDED_ARABIC_INDIC_DIGIT_FOUR_BELOW = 0x0777;
const char32_t ARABIC_LETTER_WAW_WITH_EXTENDED_ARABIC_INDIC_DIGIT_TWO_ABOVE = 0x0778;
const char32_t ARABIC_LETTER_WAW_WITH_EXTENDED_ARABIC_INDIC_DIGIT_THREE_ABOVE = 0x0779;
const char32_t ARABIC_LETTER_YEH_BARREE_WITH_EXTENDED_ARABIC_INDIC_DIGIT_TWO_ABOVE = 0x077A;
const char32_t ARABIC_LETTER_YEH_BARREE_WITH_EXTENDED_ARABIC_INDIC_DIGIT_THREE_ABOVE = 0x077B;
const char32_t ARABIC_LETTER_HAH_WITH_EXTENDED_ARABIC_INDIC_DIGIT_FOUR_BELOW = 0x077C;
const char32_t ARABIC_LETTER_SEEN_WITH_EXTENDED_ARABIC_INDIC_DIGIT_FOUR_ABOVE = 0x077D;
const char32_t ARABIC_LETTER_SEEN_WITH_INVERTED_V = 0x077E;
const char32_t ARABIC_LETTER_KAF_WITH_TWO_DOTS_ABOVE = 0x077F;
const char32_t THAANA_LETTER_HAA = 0x0780;
const char32_t THAANA_LETTER_SHAVIYANI = 0x0781;
const char32_t THAANA_LETTER_NOONU = 0x0782;
const char32_t THAANA_LETTER_RAA = 0x0783;
const char32_t THAANA_LETTER_BAA = 0x0784;
const char32_t THAANA_LETTER_LHAVIYANI = 0x0785;
const char32_t THAANA_LETTER_KAAFU = 0x0786;
const char32_t THAANA_LETTER_ALIFU = 0x0787;
const char32_t THAANA_LETTER_VAAVU = 0x0788;
const char32_t THAANA_LETTER_MEEMU = 0x0789;
const char32_t THAANA_LETTER_FAAFU = 0x078A;
const char32_t THAANA_LETTER_DHAALU = 0x078B;
const char32_t THAANA_LETTER_THAA = 0x078C;
const char32_t THAANA_LETTER_LAAMU = 0x078D;
const char32_t THAANA_LETTER_GAAFU = 0x078E;
const char32_t THAANA_LETTER_GNAVIYANI = 0x078F;
const char32_t THAANA_LETTER_SEENU = 0x0790;
const char32_t THAANA_LETTER_DAVIYANI = 0x0791;
const char32_t THAANA_LETTER_ZAVIYANI = 0x0792;
const char32_t THAANA_LETTER_TAVIYANI = 0x0793;
const char32_t THAANA_LETTER_YAA = 0x0794;
const char32_t THAANA_LETTER_PAVIYANI = 0x0795;
const char32_t THAANA_LETTER_JAVIYANI = 0x0796;
const char32_t THAANA_LETTER_CHAVIYANI = 0x0797;
const char32_t THAANA_LETTER_TTAA = 0x0798;
const char32_t THAANA_LETTER_HHAA = 0x0799;
const char32_t THAANA_LETTER_KHAA = 0x079A;
const char32_t THAANA_LETTER_THAALU = 0x079B;
const char32_t THAANA_LETTER_ZAA = 0x079C;
const char32_t THAANA_LETTER_SHEENU = 0x079D;
const char32_t THAANA_LETTER_SAADHU = 0x079E;
const char32_t THAANA_LETTER_DAADHU = 0x079F;
const char32_t THAANA_LETTER_TO = 0x07A0;
const char32_t THAANA_LETTER_ZO = 0x07A1;
const char32_t THAANA_LETTER_AINU = 0x07A2;
const char32_t THAANA_LETTER_GHAINU = 0x07A3;
const char32_t THAANA_LETTER_QAAFU = 0x07A4;
const char32_t THAANA_LETTER_WAAVU = 0x07A5;
const char32_t THAANA_ABAFILI = 0x07A6;
const char32_t THAANA_AABAAFILI = 0x07A7;
const char32_t THAANA_IBIFILI = 0x07A8;
const char32_t THAANA_EEBEEFILI = 0x07A9;
const char32_t THAANA_UBUFILI = 0x07AA;
const char32_t THAANA_OOBOOFILI = 0x07AB;
const char32_t THAANA_EBEFILI = 0x07AC;
const char32_t THAANA_EYBEYFILI = 0x07AD;
const char32_t THAANA_OBOFILI = 0x07AE;
const char32_t THAANA_OABOAFILI = 0x07AF;
const char32_t THAANA_SUKUN = 0x07B0;
const char32_t THAANA_LETTER_NAA = 0x07B1;
const char32_t NKO_DIGIT_ZERO = 0x07C0;
const char32_t NKO_DIGIT_ONE = 0x07C1;
const char32_t NKO_DIGIT_TWO = 0x07C2;
const char32_t NKO_DIGIT_THREE = 0x07C3;
const char32_t NKO_DIGIT_FOUR = 0x07C4;
const char32_t NKO_DIGIT_FIVE = 0x07C5;
const char32_t NKO_DIGIT_SIX = 0x07C6;
const char32_t NKO_DIGIT_SEVEN = 0x07C7;
const char32_t NKO_DIGIT_EIGHT = 0x07C8;
const char32_t NKO_DIGIT_NINE = 0x07C9;
const char32_t NKO_LETTER_A = 0x07CA;
const char32_t NKO_LETTER_EE = 0x07CB;
const char32_t NKO_LETTER_I = 0x07CC;
const char32_t NKO_LETTER_E = 0x07CD;
const char32_t NKO_LETTER_U = 0x07CE;
const char32_t NKO_LETTER_OO = 0x07CF;
const char32_t NKO_LETTER_O = 0x07D0;
const char32_t NKO_LETTER_DAGBASINNA = 0x07D1;
const char32_t NKO_LETTER_N = 0x07D2;
const char32_t NKO_LETTER_BA = 0x07D3;
const char32_t NKO_LETTER_PA = 0x07D4;
const char32_t NKO_LETTER_TA = 0x07D5;
const char32_t NKO_LETTER_JA = 0x07D6;
const char32_t NKO_LETTER_CHA = 0x07D7;
const char32_t NKO_LETTER_DA = 0x07D8;
const char32_t NKO_LETTER_RA = 0x07D9;
const char32_t NKO_LETTER_RRA = 0x07DA;
const char32_t NKO_LETTER_SA = 0x07DB;
const char32_t NKO_LETTER_GBA = 0x07DC;
const char32_t NKO_LETTER_FA = 0x07DD;
const char32_t NKO_LETTER_KA = 0x07DE;
const char32_t NKO_LETTER_LA = 0x07DF;
const char32_t NKO_LETTER_NA_WOLOSO = 0x07E0;
const char32_t NKO_LETTER_MA = 0x07E1;
const char32_t NKO_LETTER_NYA = 0x07E2;
const char32_t NKO_LETTER_NA = 0x07E3;
const char32_t NKO_LETTER_HA = 0x07E4;
const char32_t NKO_LETTER_WA = 0x07E5;
const char32_t NKO_LETTER_YA = 0x07E6;
const char32_t NKO_LETTER_NYA_WOLOSO = 0x07E7;
const char32_t NKO_LETTER_JONA_JA = 0x07E8;
const char32_t NKO_LETTER_JONA_CHA = 0x07E9;
const char32_t NKO_LETTER_JONA_RA = 0x07EA;
const char32_t NKO_COMBINING_SHORT_HIGH_TONE = 0x07EB;
const char32_t NKO_COMBINING_SHORT_LOW_TONE = 0x07EC;
const char32_t NKO_COMBINING_SHORT_RISING_TONE = 0x07ED;
const char32_t NKO_COMBINING_LONG_DESCENDING_TONE = 0x07EE;
const char32_t NKO_COMBINING_LONG_HIGH_TONE = 0x07EF;
const char32_t NKO_COMBINING_LONG_LOW_TONE = 0x07F0;
const char32_t NKO_COMBINING_LONG_RISING_TONE = 0x07F1;
const char32_t NKO_COMBINING_NASALIZATION_MARK = 0x07F2;
const char32_t NKO_COMBINING_DOUBLE_DOT_ABOVE = 0x07F3;
const char32_t NKO_HIGH_TONE_APOSTROPHE = 0x07F4;
const char32_t NKO_LOW_TONE_APOSTROPHE = 0x07F5;
const char32_t NKO_SYMBOL_OO_DENNEN = 0x07F6;
const char32_t NKO_SYMBOL_GBAKURUNEN = 0x07F7;
const char32_t NKO_COMMA = 0x07F8;
const char32_t NKO_EXCLAMATION_MARK = 0x07F9;
const char32_t NKO_LAJANYALAN = 0x07FA;
const char32_t NKO_DANTAYALAN = 0x07FD;
const char32_t NKO_DOROME_SIGN = 0x07FE;
const char32_t NKO_TAMAN_SIGN = 0x07FF;
const char32_t SAMARITAN_LETTER_ALAF = 0x0800;
const char32_t SAMARITAN_LETTER_BIT = 0x0801;
const char32_t SAMARITAN_LETTER_GAMAN = 0x0802;
const char32_t SAMARITAN_LETTER_DALAT = 0x0803;
const char32_t SAMARITAN_LETTER_IY = 0x0804;
const char32_t SAMARITAN_LETTER_BAA = 0x0805;
const char32_t SAMARITAN_LETTER_ZEN = 0x0806;
const char32_t SAMARITAN_LETTER_IT = 0x0807;
const char32_t SAMARITAN_LETTER_TIT = 0x0808;
const char32_t SAMARITAN_LETTER_YUT = 0x0809;
const char32_t SAMARITAN_LETTER_KAAF = 0x080A;
const char32_t SAMARITAN_LETTER_LABAT = 0x080B;
const char32_t SAMARITAN_LETTER_MIM = 0x080C;
const char32_t SAMARITAN_LETTER_NUN = 0x080D;
const char32_t SAMARITAN_LETTER_SINGAAT = 0x080E;
const char32_t SAMARITAN_LETTER_IN = 0x080F;
const char32_t SAMARITAN_LETTER_FI = 0x0810;
const char32_t SAMARITAN_LETTER_TSAADIY = 0x0811;
const char32_t SAMARITAN_LETTER_QUF = 0x0812;
const char32_t SAMARITAN_LETTER_RISH = 0x0813;
const char32_t SAMARITAN_LETTER_SHAN = 0x0814;
const char32_t SAMARITAN_LETTER_TAAF = 0x0815;
const char32_t SAMARITAN_MARK_IN = 0x0816;
const char32_t SAMARITAN_MARK_IN_ALAF = 0x0817;
const char32_t SAMARITAN_MARK_OCCLUSION = 0x0818;
const char32_t SAMARITAN_MARK_DAGESH = 0x0819;
const char32_t SAMARITAN_MODIFIER_LETTER_EPENTHETIC_YUT = 0x081A;
const char32_t SAMARITAN_MARK_EPENTHETIC_YUT = 0x081B;
const char32_t SAMARITAN_VOWEL_SIGN_LONG_E = 0x081C;
const char32_t SAMARITAN_VOWEL_SIGN_E = 0x081D;
const char32_t SAMARITAN_VOWEL_SIGN_OVERLONG_AA = 0x081E;
const char32_t SAMARITAN_VOWEL_SIGN_LONG_AA = 0x081F;
const char32_t SAMARITAN_VOWEL_SIGN_AA = 0x0820;
const char32_t SAMARITAN_VOWEL_SIGN_OVERLONG_A = 0x0821;
const char32_t SAMARITAN_VOWEL_SIGN_LONG_A = 0x0822;
const char32_t SAMARITAN_VOWEL_SIGN_A = 0x0823;
const char32_t SAMARITAN_MODIFIER_LETTER_SHORT_A = 0x0824;
const char32_t SAMARITAN_VOWEL_SIGN_SHORT_A = 0x0825;
const char32_t SAMARITAN_VOWEL_SIGN_LONG_U = 0x0826;
const char32_t SAMARITAN_VOWEL_SIGN_U = 0x0827;
const char32_t SAMARITAN_MODIFIER_LETTER_I = 0x0828;
const char32_t SAMARITAN_VOWEL_SIGN_LONG_I = 0x0829;
const char32_t SAMARITAN_VOWEL_SIGN_I = 0x082A;
const char32_t SAMARITAN_VOWEL_SIGN_O = 0x082B;
const char32_t SAMARITAN_VOWEL_SIGN_SUKUN = 0x082C;
const char32_t SAMARITAN_MARK_NEQUDAA = 0x082D;
const char32_t SAMARITAN_PUNCTUATION_NEQUDAA = 0x0830;
const char32_t SAMARITAN_PUNCTUATION_AFSAAQ = 0x0831;
const char32_t SAMARITAN_PUNCTUATION_ANGED = 0x0832;
const char32_t SAMARITAN_PUNCTUATION_BAU = 0x0833;
const char32_t SAMARITAN_PUNCTUATION_ATMAAU = 0x0834;
const char32_t SAMARITAN_PUNCTUATION_SHIYYAALAA = 0x0835;
const char32_t SAMARITAN_ABBREVIATION_MARK = 0x0836;
const char32_t SAMARITAN_PUNCTUATION_MELODIC_QITSA = 0x0837;
const char32_t SAMARITAN_PUNCTUATION_ZIQAA = 0x0838;
const char32_t SAMARITAN_PUNCTUATION_QITSA = 0x0839;
const char32_t SAMARITAN_PUNCTUATION_ZAEF = 0x083A;
const char32_t SAMARITAN_PUNCTUATION_TURU = 0x083B;
const char32_t SAMARITAN_PUNCTUATION_ARKAANU = 0x083C;
const char32_t SAMARITAN_PUNCTUATION_SOF_MASHFAAT = 0x083D;
const char32_t SAMARITAN_PUNCTUATION_ANNAAU = 0x083E;
const char32_t MANDAIC_LETTER_HALQA = 0x0840;
const char32_t MANDAIC_LETTER_AB = 0x0841;
const char32_t MANDAIC_LETTER_AG = 0x0842;
const char32_t MANDAIC_LETTER_AD = 0x0843;
const char32_t MANDAIC_LETTER_AH = 0x0844;
const char32_t MANDAIC_LETTER_USHENNA = 0x0845;
const char32_t MANDAIC_LETTER_AZ = 0x0846;
const char32_t MANDAIC_LETTER_IT = 0x0847;
const char32_t MANDAIC_LETTER_ATT = 0x0848;
const char32_t MANDAIC_LETTER_AKSA = 0x0849;
const char32_t MANDAIC_LETTER_AK = 0x084A;
const char32_t MANDAIC_LETTER_AL = 0x084B;
const char32_t MANDAIC_LETTER_AM = 0x084C;
const char32_t MANDAIC_LETTER_AN = 0x084D;
const char32_t MANDAIC_LETTER_AS = 0x084E;
const char32_t MANDAIC_LETTER_IN = 0x084F;
const char32_t MANDAIC_LETTER_AP = 0x0850;
const char32_t MANDAIC_LETTER_ASZ = 0x0851;
const char32_t MANDAIC_LETTER_AQ = 0x0852;
const char32_t MANDAIC_LETTER_AR = 0x0853;
const char32_t MANDAIC_LETTER_ASH = 0x0854;
const char32_t MANDAIC_LETTER_AT = 0x0855;
const char32_t MANDAIC_LETTER_DUSHENNA = 0x0856;
const char32_t MANDAIC_LETTER_KAD = 0x0857;
const char32_t MANDAIC_LETTER_AIN = 0x0858;
const char32_t MANDAIC_AFFRICATION_MARK = 0x0859;
const char32_t MANDAIC_VOCALIZATION_MARK = 0x085A;
const char32_t MANDAIC_GEMINATION_MARK = 0x085B;
const char32_t MANDAIC_PUNCTUATION = 0x085E;
const char32_t SYRIAC_LETTER_MALAYALAM_NGA = 0x0860;
const char32_t SYRIAC_LETTER_MALAYALAM_JA = 0x0861;
const char32_t SYRIAC_LETTER_MALAYALAM_NYA = 0x0862;
const char32_t SYRIAC_LETTER_MALAYALAM_TTA = 0x0863;
const char32_t SYRIAC_LETTER_MALAYALAM_NNA = 0x0864;
const char32_t SYRIAC_LETTER_MALAYALAM_NNNA = 0x0865;
const char32_t SYRIAC_LETTER_MALAYALAM_BHA = 0x0866;
const char32_t SYRIAC_LETTER_MALAYALAM_RA = 0x0867;
const char32_t SYRIAC_LETTER_MALAYALAM_LLA = 0x0868;
const char32_t SYRIAC_LETTER_MALAYALAM_LLLA = 0x0869;
const char32_t SYRIAC_LETTER_MALAYALAM_SSA = 0x086A;
const char32_t ARABIC_LETTER_BEH_WITH_SMALL_V_BELOW = 0x08A0;
const char32_t ARABIC_LETTER_BEH_WITH_HAMZA_ABOVE = 0x08A1;
const char32_t ARABIC_LETTER_JEEM_WITH_TWO_DOTS_ABOVE = 0x08A2;
const char32_t ARABIC_LETTER_TAH_WITH_TWO_DOTS_ABOVE = 0x08A3;
const char32_t ARABIC_LETTER_FEH_WITH_DOT_BELOW_AND_THREE_DOTS_ABOVE = 0x08A4;
const char32_t ARABIC_LETTER_QAF_WITH_DOT_BELOW = 0x08A5;
const char32_t ARABIC_LETTER_LAM_WITH_DOUBLE_BAR = 0x08A6;
const char32_t ARABIC_LETTER_MEEM_WITH_THREE_DOTS_ABOVE = 0x08A7;
const char32_t ARABIC_LETTER_YEH_WITH_TWO_DOTS_BELOW_AND_HAMZA_ABOVE = 0x08A8;
const char32_t ARABIC_LETTER_YEH_WITH_TWO_DOTS_BELOW_AND_DOT_ABOVE = 0x08A9;
const char32_t ARABIC_LETTER_REH_WITH_LOOP = 0x08AA;
const char32_t ARABIC_LETTER_WAW_WITH_DOT_WITHIN = 0x08AB;
const char32_t ARABIC_LETTER_ROHINGYA_YEH = 0x08AC;
const char32_t ARABIC_LETTER_LOW_ALEF = 0x08AD;
const char32_t ARABIC_LETTER_DAL_WITH_THREE_DOTS_BELOW = 0x08AE;
const char32_t ARABIC_LETTER_SAD_WITH_THREE_DOTS_BELOW = 0x08AF;
const char32_t ARABIC_LETTER_GAF_WITH_INVERTED_STROKE = 0x08B0;
const char32_t ARABIC_LETTER_STRAIGHT_WAW = 0x08B1;
const char32_t ARABIC_LETTER_ZAIN_WITH_INVERTED_V_ABOVE = 0x08B2;
const char32_t ARABIC_LETTER_AIN_WITH_THREE_DOTS_BELOW = 0x08B3;
const char32_t ARABIC_LETTER_KAF_WITH_DOT_BELOW = 0x08B4;
const char32_t ARABIC_LETTER_BEH_WITH_SMALL_MEEM_ABOVE = 0x08B6;
const char32_t ARABIC_LETTER_PEH_WITH_SMALL_MEEM_ABOVE = 0x08B7;
const char32_t ARABIC_LETTER_TEH_WITH_SMALL_TEH_ABOVE = 0x08B8;
const char32_t ARABIC_LETTER_REH_WITH_SMALL_NOON_ABOVE = 0x08B9;
const char32_t ARABIC_LETTER_YEH_WITH_TWO_DOTS_BELOW_AND_SMALL_NOON_ABOVE = 0x08BA;
const char32_t ARABIC_LETTER_AFRICAN_FEH = 0x08BB;
const char32_t ARABIC_LETTER_AFRICAN_QAF = 0x08BC;
const char32_t ARABIC_LETTER_AFRICAN_NOON = 0x08BD;
const char32_t ARABIC_LETTER_PEH_WITH_SMALL_V = 0x08BE;
const char32_t ARABIC_LETTER_TEH_WITH_SMALL_V = 0x08BF;
const char32_t ARABIC_LETTER_TTEH_WITH_SMALL_V = 0x08C0;
const char32_t ARABIC_LETTER_TCHEH_WITH_SMALL_V = 0x08C1;
const char32_t ARABIC_LETTER_KEHEH_WITH_SMALL_V = 0x08C2;
const char32_t ARABIC_LETTER_GHAIN_WITH_THREE_DOTS_ABOVE = 0x08C3;
const char32_t ARABIC_LETTER_AFRICAN_QAF_WITH_THREE_DOTS_ABOVE = 0x08C4;
const char32_t ARABIC_LETTER_JEEM_WITH_THREE_DOTS_ABOVE = 0x08C5;
const char32_t ARABIC_LETTER_JEEM_WITH_THREE_DOTS_BELOW = 0x08C6;
const char32_t ARABIC_LETTER_LAM_WITH_SMALL_ARABIC_LETTER_TAH_ABOVE = 0x08C7;
const char32_t ARABIC_SMALL_LOW_WAW = 0x08D3;
const char32_t ARABIC_SMALL_HIGH_WORD_AR_RUB = 0x08D4;
const char32_t ARABIC_SMALL_HIGH_SAD = 0x08D5;
const char32_t ARABIC_SMALL_HIGH_AIN = 0x08D6;
const char32_t ARABIC_SMALL_HIGH_QAF = 0x08D7;
const char32_t ARABIC_SMALL_HIGH_NOON_WITH_KASRA = 0x08D8;
const char32_t ARABIC_SMALL_LOW_NOON_WITH_KASRA = 0x08D9;
const char32_t ARABIC_SMALL_HIGH_WORD_ATH_THALATHA = 0x08DA;
const char32_t ARABIC_SMALL_HIGH_WORD_AS_SAJDA = 0x08DB;
const char32_t ARABIC_SMALL_HIGH_WORD_AN_NISF = 0x08DC;
const char32_t ARABIC_SMALL_HIGH_WORD_SAKTA = 0x08DD;
const char32_t ARABIC_SMALL_HIGH_WORD_QIF = 0x08DE;
const char32_t ARABIC_SMALL_HIGH_WORD_WAQFA = 0x08DF;
const char32_t ARABIC_SMALL_HIGH_FOOTNOTE_MARKER = 0x08E0;
const char32_t ARABIC_SMALL_HIGH_SIGN_SAFHA = 0x08E1;
const char32_t ARABIC_DISPUTED_END_OF_AYAH = 0x08E2;
const char32_t ARABIC_TURNED_DAMMA_BELOW = 0x08E3;
const char32_t ARABIC_CURLY_FATHA = 0x08E4;
const char32_t ARABIC_CURLY_DAMMA = 0x08E5;
const char32_t ARABIC_CURLY_KASRA = 0x08E6;
const char32_t ARABIC_CURLY_FATHATAN = 0x08E7;
const char32_t ARABIC_CURLY_DAMMATAN = 0x08E8;
const char32_t ARABIC_CURLY_KASRATAN = 0x08E9;
const char32_t ARABIC_TONE_ONE_DOT_ABOVE = 0x08EA;
const char32_t ARABIC_TONE_TWO_DOTS_ABOVE = 0x08EB;
const char32_t ARABIC_TONE_LOOP_ABOVE = 0x08EC;
const char32_t ARABIC_TONE_ONE_DOT_BELOW = 0x08ED;
const char32_t ARABIC_TONE_TWO_DOTS_BELOW = 0x08EE;
const char32_t ARABIC_TONE_LOOP_BELOW = 0x08EF;
const char32_t ARABIC_OPEN_FATHATAN = 0x08F0;
const char32_t ARABIC_OPEN_DAMMATAN = 0x08F1;
const char32_t ARABIC_OPEN_KASRATAN = 0x08F2;
const char32_t ARABIC_SMALL_HIGH_WAW = 0x08F3;
const char32_t ARABIC_FATHA_WITH_RING = 0x08F4;
const char32_t ARABIC_FATHA_WITH_DOT_ABOVE = 0x08F5;
const char32_t ARABIC_KASRA_WITH_DOT_BELOW = 0x08F6;
const char32_t ARABIC_LEFT_ARROWHEAD_ABOVE = 0x08F7;
const char32_t ARABIC_RIGHT_ARROWHEAD_ABOVE = 0x08F8;
const char32_t ARABIC_LEFT_ARROWHEAD_BELOW = 0x08F9;
const char32_t ARABIC_RIGHT_ARROWHEAD_BELOW = 0x08FA;
const char32_t ARABIC_DOUBLE_RIGHT_ARROWHEAD_ABOVE = 0x08FB;
const char32_t ARABIC_DOUBLE_RIGHT_ARROWHEAD_ABOVE_WITH_DOT = 0x08FC;
const char32_t ARABIC_RIGHT_ARROWHEAD_ABOVE_WITH_DOT = 0x08FD;
const char32_t ARABIC_DAMMA_WITH_DOT = 0x08FE;
const char32_t ARABIC_MARK_SIDEWAYS_NOON_GHUNNA = 0x08FF;
const char32_t DEVANAGARI_SIGN_INVERTED_CANDRABINDU = 0x0900;
const char32_t DEVANAGARI_SIGN_CANDRABINDU = 0x0901;
const char32_t DEVANAGARI_SIGN_ANUSVARA = 0x0902;
const char32_t DEVANAGARI_SIGN_VISARGA = 0x0903;
const char32_t DEVANAGARI_LETTER_SHORT_A = 0x0904;
const char32_t DEVANAGARI_LETTER_A = 0x0905;
const char32_t DEVANAGARI_LETTER_AA = 0x0906;
const char32_t DEVANAGARI_LETTER_I = 0x0907;
const char32_t DEVANAGARI_LETTER_II = 0x0908;
const char32_t DEVANAGARI_LETTER_U = 0x0909;
const char32_t DEVANAGARI_LETTER_UU = 0x090A;
const char32_t DEVANAGARI_LETTER_VOCALIC_R = 0x090B;
const char32_t DEVANAGARI_LETTER_VOCALIC_L = 0x090C;
const char32_t DEVANAGARI_LETTER_CANDRA_E = 0x090D;
const char32_t DEVANAGARI_LETTER_SHORT_E = 0x090E;
const char32_t DEVANAGARI_LETTER_E = 0x090F;
const char32_t DEVANAGARI_LETTER_AI = 0x0910;
const char32_t DEVANAGARI_LETTER_CANDRA_O = 0x0911;
const char32_t DEVANAGARI_LETTER_SHORT_O = 0x0912;
const char32_t DEVANAGARI_LETTER_O = 0x0913;
const char32_t DEVANAGARI_LETTER_AU = 0x0914;
const char32_t DEVANAGARI_LETTER_KA = 0x0915;
const char32_t DEVANAGARI_LETTER_KHA = 0x0916;
const char32_t DEVANAGARI_LETTER_GA = 0x0917;
const char32_t DEVANAGARI_LETTER_GHA = 0x0918;
const char32_t DEVANAGARI_LETTER_NGA = 0x0919;
const char32_t DEVANAGARI_LETTER_CA = 0x091A;
const char32_t DEVANAGARI_LETTER_CHA = 0x091B;
const char32_t DEVANAGARI_LETTER_JA = 0x091C;
const char32_t DEVANAGARI_LETTER_JHA = 0x091D;
const char32_t DEVANAGARI_LETTER_NYA = 0x091E;
const char32_t DEVANAGARI_LETTER_TTA = 0x091F;
const char32_t DEVANAGARI_LETTER_TTHA = 0x0920;
const char32_t DEVANAGARI_LETTER_DDA = 0x0921;
const char32_t DEVANAGARI_LETTER_DDHA = 0x0922;
const char32_t DEVANAGARI_LETTER_NNA = 0x0923;
const char32_t DEVANAGARI_LETTER_TA = 0x0924;
const char32_t DEVANAGARI_LETTER_THA = 0x0925;
const char32_t DEVANAGARI_LETTER_DA = 0x0926;
const char32_t DEVANAGARI_LETTER_DHA = 0x0927;
const char32_t DEVANAGARI_LETTER_NA = 0x0928;
const char32_t DEVANAGARI_LETTER_NNNA = 0x0929;
const char32_t DEVANAGARI_LETTER_PA = 0x092A;
const char32_t DEVANAGARI_LETTER_PHA = 0x092B;
const char32_t DEVANAGARI_LETTER_BA = 0x092C;
const char32_t DEVANAGARI_LETTER_BHA = 0x092D;
const char32_t DEVANAGARI_LETTER_MA = 0x092E;
const char32_t DEVANAGARI_LETTER_YA = 0x092F;
const char32_t DEVANAGARI_LETTER_RA = 0x0930;
const char32_t DEVANAGARI_LETTER_RRA = 0x0931;
const char32_t DEVANAGARI_LETTER_LA = 0x0932;
const char32_t DEVANAGARI_LETTER_LLA = 0x0933;
const char32_t DEVANAGARI_LETTER_LLLA = 0x0934;
const char32_t DEVANAGARI_LETTER_VA = 0x0935;
const char32_t DEVANAGARI_LETTER_SHA = 0x0936;
const char32_t DEVANAGARI_LETTER_SSA = 0x0937;
const char32_t DEVANAGARI_LETTER_SA = 0x0938;
const char32_t DEVANAGARI_LETTER_HA = 0x0939;
const char32_t DEVANAGARI_VOWEL_SIGN_OE = 0x093A;
const char32_t DEVANAGARI_VOWEL_SIGN_OOE = 0x093B;
const char32_t DEVANAGARI_SIGN_NUKTA = 0x093C;
const char32_t DEVANAGARI_SIGN_AVAGRAHA = 0x093D;
const char32_t DEVANAGARI_VOWEL_SIGN_AA = 0x093E;
const char32_t DEVANAGARI_VOWEL_SIGN_I = 0x093F;
const char32_t DEVANAGARI_VOWEL_SIGN_II = 0x0940;
const char32_t DEVANAGARI_VOWEL_SIGN_U = 0x0941;
const char32_t DEVANAGARI_VOWEL_SIGN_UU = 0x0942;
const char32_t DEVANAGARI_VOWEL_SIGN_VOCALIC_R = 0x0943;
const char32_t DEVANAGARI_VOWEL_SIGN_VOCALIC_RR = 0x0944;
const char32_t DEVANAGARI_VOWEL_SIGN_CANDRA_E = 0x0945;
const char32_t DEVANAGARI_VOWEL_SIGN_SHORT_E = 0x0946;
const char32_t DEVANAGARI_VOWEL_SIGN_E = 0x0947;
const char32_t DEVANAGARI_VOWEL_SIGN_AI = 0x0948;
const char32_t DEVANAGARI_VOWEL_SIGN_CANDRA_O = 0x0949;
const char32_t DEVANAGARI_VOWEL_SIGN_SHORT_O = 0x094A;
const char32_t DEVANAGARI_VOWEL_SIGN_O = 0x094B;
const char32_t DEVANAGARI_VOWEL_SIGN_AU = 0x094C;
const char32_t DEVANAGARI_SIGN_VIRAMA = 0x094D;
const char32_t DEVANAGARI_VOWEL_SIGN_PRISHTHAMATRA_E = 0x094E;
const char32_t DEVANAGARI_VOWEL_SIGN_AW = 0x094F;
const char32_t DEVANAGARI_OM = 0x0950;
const char32_t DEVANAGARI_STRESS_SIGN_UDATTA = 0x0951;
const char32_t DEVANAGARI_STRESS_SIGN_ANUDATTA = 0x0952;
const char32_t DEVANAGARI_GRAVE_ACCENT = 0x0953;
const char32_t DEVANAGARI_ACUTE_ACCENT = 0x0954;
const char32_t DEVANAGARI_VOWEL_SIGN_CANDRA_LONG_E = 0x0955;
const char32_t DEVANAGARI_VOWEL_SIGN_UE = 0x0956;
const char32_t DEVANAGARI_VOWEL_SIGN_UUE = 0x0957;
const char32_t DEVANAGARI_LETTER_QA = 0x0958;
const char32_t DEVANAGARI_LETTER_KHHA = 0x0959;
const char32_t DEVANAGARI_LETTER_GHHA = 0x095A;
const char32_t DEVANAGARI_LETTER_ZA = 0x095B;
const char32_t DEVANAGARI_LETTER_DDDHA = 0x095C;
const char32_t DEVANAGARI_LETTER_RHA = 0x095D;
const char32_t DEVANAGARI_LETTER_FA = 0x095E;
const char32_t DEVANAGARI_LETTER_YYA = 0x095F;
const char32_t DEVANAGARI_LETTER_VOCALIC_RR = 0x0960;
const char32_t DEVANAGARI_LETTER_VOCALIC_LL = 0x0961;
const char32_t DEVANAGARI_VOWEL_SIGN_VOCALIC_L = 0x0962;
const char32_t DEVANAGARI_VOWEL_SIGN_VOCALIC_LL = 0x0963;
const char32_t DEVANAGARI_DANDA = 0x0964;
const char32_t DEVANAGARI_DOUBLE_DANDA = 0x0965;
const char32_t DEVANAGARI_DIGIT_ZERO = 0x0966;
const char32_t DEVANAGARI_DIGIT_ONE = 0x0967;
const char32_t DEVANAGARI_DIGIT_TWO = 0x0968;
const char32_t DEVANAGARI_DIGIT_THREE = 0x0969;
const char32_t DEVANAGARI_DIGIT_FOUR = 0x096A;
const char32_t DEVANAGARI_DIGIT_FIVE = 0x096B;
const char32_t DEVANAGARI_DIGIT_SIX = 0x096C;
const char32_t DEVANAGARI_DIGIT_SEVEN = 0x096D;
const char32_t DEVANAGARI_DIGIT_EIGHT = 0x096E;
const char32_t DEVANAGARI_DIGIT_NINE = 0x096F;
const char32_t DEVANAGARI_ABBREVIATION_SIGN = 0x0970;
const char32_t DEVANAGARI_SIGN_HIGH_SPACING_DOT = 0x0971;
const char32_t DEVANAGARI_LETTER_CANDRA_A = 0x0972;
const char32_t DEVANAGARI_LETTER_OE = 0x0973;
const char32_t DEVANAGARI_LETTER_OOE = 0x0974;
const char32_t DEVANAGARI_LETTER_AW = 0x0975;
const char32_t DEVANAGARI_LETTER_UE = 0x0976;
const char32_t DEVANAGARI_LETTER_UUE = 0x0977;
const char32_t DEVANAGARI_LETTER_MARWARI_DDA = 0x0978;
const char32_t DEVANAGARI_LETTER_ZHA = 0x0979;
const char32_t DEVANAGARI_LETTER_HEAVY_YA = 0x097A;
const char32_t DEVANAGARI_LETTER_GGA = 0x097B;
const char32_t DEVANAGARI_LETTER_JJA = 0x097C;
const char32_t DEVANAGARI_LETTER_GLOTTAL_STOP = 0x097D;
const char32_t DEVANAGARI_LETTER_DDDA = 0x097E;
const char32_t DEVANAGARI_LETTER_BBA = 0x097F;
const char32_t BENGALI_ANJI = 0x0980;
const char32_t BENGALI_SIGN_CANDRABINDU = 0x0981;
const char32_t BENGALI_SIGN_ANUSVARA = 0x0982;
const char32_t BENGALI_SIGN_VISARGA = 0x0983;
const char32_t BENGALI_LETTER_A = 0x0985;
const char32_t BENGALI_LETTER_AA = 0x0986;
const char32_t BENGALI_LETTER_I = 0x0987;
const char32_t BENGALI_LETTER_II = 0x0988;
const char32_t BENGALI_LETTER_U = 0x0989;
const char32_t BENGALI_LETTER_UU = 0x098A;
const char32_t BENGALI_LETTER_VOCALIC_R = 0x098B;
const char32_t BENGALI_LETTER_VOCALIC_L = 0x098C;
const char32_t BENGALI_LETTER_E = 0x098F;
const char32_t BENGALI_LETTER_AI = 0x0990;
const char32_t BENGALI_LETTER_O = 0x0993;
const char32_t BENGALI_LETTER_AU = 0x0994;
const char32_t BENGALI_LETTER_KA = 0x0995;
const char32_t BENGALI_LETTER_KHA = 0x0996;
const char32_t BENGALI_LETTER_GA = 0x0997;
const char32_t BENGALI_LETTER_GHA = 0x0998;
const char32_t BENGALI_LETTER_NGA = 0x0999;
const char32_t BENGALI_LETTER_CA = 0x099A;
const char32_t BENGALI_LETTER_CHA = 0x099B;
const char32_t BENGALI_LETTER_JA = 0x099C;
const char32_t BENGALI_LETTER_JHA = 0x099D;
const char32_t BENGALI_LETTER_NYA = 0x099E;
const char32_t BENGALI_LETTER_TTA = 0x099F;
const char32_t BENGALI_LETTER_TTHA = 0x09A0;
const char32_t BENGALI_LETTER_DDA = 0x09A1;
const char32_t BENGALI_LETTER_DDHA = 0x09A2;
const char32_t BENGALI_LETTER_NNA = 0x09A3;
const char32_t BENGALI_LETTER_TA = 0x09A4;
const char32_t BENGALI_LETTER_THA = 0x09A5;
const char32_t BENGALI_LETTER_DA = 0x09A6;
const char32_t BENGALI_LETTER_DHA = 0x09A7;
const char32_t BENGALI_LETTER_NA = 0x09A8;
const char32_t BENGALI_LETTER_PA = 0x09AA;
const char32_t BENGALI_LETTER_PHA = 0x09AB;
const char32_t BENGALI_LETTER_BA = 0x09AC;
const char32_t BENGALI_LETTER_BHA = 0x09AD;
const char32_t BENGALI_LETTER_MA = 0x09AE;
const char32_t BENGALI_LETTER_YA = 0x09AF;
const char32_t BENGALI_LETTER_RA = 0x09B0;
const char32_t BENGALI_LETTER_LA = 0x09B2;
const char32_t BENGALI_LETTER_SHA = 0x09B6;
const char32_t BENGALI_LETTER_SSA = 0x09B7;
const char32_t BENGALI_LETTER_SA = 0x09B8;
const char32_t BENGALI_LETTER_HA = 0x09B9;
const char32_t BENGALI_SIGN_NUKTA = 0x09BC;
const char32_t BENGALI_SIGN_AVAGRAHA = 0x09BD;
const char32_t BENGALI_VOWEL_SIGN_AA = 0x09BE;
const char32_t BENGALI_VOWEL_SIGN_I = 0x09BF;
const char32_t BENGALI_VOWEL_SIGN_II = 0x09C0;
const char32_t BENGALI_VOWEL_SIGN_U = 0x09C1;
const char32_t BENGALI_VOWEL_SIGN_UU = 0x09C2;
const char32_t BENGALI_VOWEL_SIGN_VOCALIC_R = 0x09C3;
const char32_t BENGALI_VOWEL_SIGN_VOCALIC_RR = 0x09C4;
const char32_t BENGALI_VOWEL_SIGN_E = 0x09C7;
const char32_t BENGALI_VOWEL_SIGN_AI = 0x09C8;
const char32_t BENGALI_VOWEL_SIGN_O = 0x09CB;
const char32_t BENGALI_VOWEL_SIGN_AU = 0x09CC;
const char32_t BENGALI_SIGN_VIRAMA = 0x09CD;
const char32_t BENGALI_LETTER_KHANDA_TA = 0x09CE;
const char32_t BENGALI_AU_LENGTH_MARK = 0x09D7;
const char32_t BENGALI_LETTER_RRA = 0x09DC;
const char32_t BENGALI_LETTER_RHA = 0x09DD;
const char32_t BENGALI_LETTER_YYA = 0x09DF;
const char32_t BENGALI_LETTER_VOCALIC_RR = 0x09E0;
const char32_t BENGALI_LETTER_VOCALIC_LL = 0x09E1;
const char32_t BENGALI_VOWEL_SIGN_VOCALIC_L = 0x09E2;
const char32_t BENGALI_VOWEL_SIGN_VOCALIC_LL = 0x09E3;
const char32_t BENGALI_DIGIT_ZERO = 0x09E6;
const char32_t BENGALI_DIGIT_ONE = 0x09E7;
const char32_t BENGALI_DIGIT_TWO = 0x09E8;
const char32_t BENGALI_DIGIT_THREE = 0x09E9;
const char32_t BENGALI_DIGIT_FOUR = 0x09EA;
const char32_t BENGALI_DIGIT_FIVE = 0x09EB;
const char32_t BENGALI_DIGIT_SIX = 0x09EC;
const char32_t BENGALI_DIGIT_SEVEN = 0x09ED;
const char32_t BENGALI_DIGIT_EIGHT = 0x09EE;
const char32_t BENGALI_DIGIT_NINE = 0x09EF;
const char32_t BENGALI_LETTER_RA_WITH_MIDDLE_DIAGONAL = 0x09F0;
const char32_t BENGALI_LETTER_RA_WITH_LOWER_DIAGONAL = 0x09F1;
const char32_t BENGALI_RUPEE_MARK = 0x09F2;
const char32_t BENGALI_RUPEE_SIGN = 0x09F3;
const char32_t BENGALI_CURRENCY_NUMERATOR_ONE = 0x09F4;
const char32_t BENGALI_CURRENCY_NUMERATOR_TWO = 0x09F5;
const char32_t BENGALI_CURRENCY_NUMERATOR_THREE = 0x09F6;
const char32_t BENGALI_CURRENCY_NUMERATOR_FOUR = 0x09F7;
const char32_t BENGALI_CURRENCY_NUMERATOR_ONE_LESS_THAN_THE_DENOMINATOR = 0x09F8;
const char32_t BENGALI_CURRENCY_DENOMINATOR_SIXTEEN = 0x09F9;
const char32_t BENGALI_ISSHAR = 0x09FA;
const char32_t BENGALI_GANDA_MARK = 0x09FB;
const char32_t BENGALI_LETTER_VEDIC_ANUSVARA = 0x09FC;
const char32_t BENGALI_ABBREVIATION_SIGN = 0x09FD;
const char32_t BENGALI_SANDHI_MARK = 0x09FE;
const char32_t GURMUKHI_SIGN_ADAK_BINDI = 0x0A01;
const char32_t GURMUKHI_SIGN_BINDI = 0x0A02;
const char32_t GURMUKHI_SIGN_VISARGA = 0x0A03;
const char32_t GURMUKHI_LETTER_A = 0x0A05;
const char32_t GURMUKHI_LETTER_AA = 0x0A06;
const char32_t GURMUKHI_LETTER_I = 0x0A07;
const char32_t GURMUKHI_LETTER_II = 0x0A08;
const char32_t GURMUKHI_LETTER_U = 0x0A09;
const char32_t GURMUKHI_LETTER_UU = 0x0A0A;
const char32_t GURMUKHI_LETTER_EE = 0x0A0F;
const char32_t GURMUKHI_LETTER_AI = 0x0A10;
const char32_t GURMUKHI_LETTER_OO = 0x0A13;
const char32_t GURMUKHI_LETTER_AU = 0x0A14;
const char32_t GURMUKHI_LETTER_KA = 0x0A15;
const char32_t GURMUKHI_LETTER_KHA = 0x0A16;
const char32_t GURMUKHI_LETTER_GA = 0x0A17;
const char32_t GURMUKHI_LETTER_GHA = 0x0A18;
const char32_t GURMUKHI_LETTER_NGA = 0x0A19;
const char32_t GURMUKHI_LETTER_CA = 0x0A1A;
const char32_t GURMUKHI_LETTER_CHA = 0x0A1B;
const char32_t GURMUKHI_LETTER_JA = 0x0A1C;
const char32_t GURMUKHI_LETTER_JHA = 0x0A1D;
const char32_t GURMUKHI_LETTER_NYA = 0x0A1E;
const char32_t GURMUKHI_LETTER_TTA = 0x0A1F;
const char32_t GURMUKHI_LETTER_TTHA = 0x0A20;
const char32_t GURMUKHI_LETTER_DDA = 0x0A21;
const char32_t GURMUKHI_LETTER_DDHA = 0x0A22;
const char32_t GURMUKHI_LETTER_NNA = 0x0A23;
const char32_t GURMUKHI_LETTER_TA = 0x0A24;
const char32_t GURMUKHI_LETTER_THA = 0x0A25;
const char32_t GURMUKHI_LETTER_DA = 0x0A26;
const char32_t GURMUKHI_LETTER_DHA = 0x0A27;
const char32_t GURMUKHI_LETTER_NA = 0x0A28;
const char32_t GURMUKHI_LETTER_PA = 0x0A2A;
const char32_t GURMUKHI_LETTER_PHA = 0x0A2B;
const char32_t GURMUKHI_LETTER_BA = 0x0A2C;
const char32_t GURMUKHI_LETTER_BHA = 0x0A2D;
const char32_t GURMUKHI_LETTER_MA = 0x0A2E;
const char32_t GURMUKHI_LETTER_YA = 0x0A2F;
const char32_t GURMUKHI_LETTER_RA = 0x0A30;
const char32_t GURMUKHI_LETTER_LA = 0x0A32;
const char32_t GURMUKHI_LETTER_LLA = 0x0A33;
const char32_t GURMUKHI_LETTER_VA = 0x0A35;
const char32_t GURMUKHI_LETTER_SHA = 0x0A36;
const char32_t GURMUKHI_LETTER_SA = 0x0A38;
const char32_t GURMUKHI_LETTER_HA = 0x0A39;
const char32_t GURMUKHI_SIGN_NUKTA = 0x0A3C;
const char32_t GURMUKHI_VOWEL_SIGN_AA = 0x0A3E;
const char32_t GURMUKHI_VOWEL_SIGN_I = 0x0A3F;
const char32_t GURMUKHI_VOWEL_SIGN_II = 0x0A40;
const char32_t GURMUKHI_VOWEL_SIGN_U = 0x0A41;
const char32_t GURMUKHI_VOWEL_SIGN_UU = 0x0A42;
const char32_t GURMUKHI_VOWEL_SIGN_EE = 0x0A47;
const char32_t GURMUKHI_VOWEL_SIGN_AI = 0x0A48;
const char32_t GURMUKHI_VOWEL_SIGN_OO = 0x0A4B;
const char32_t GURMUKHI_VOWEL_SIGN_AU = 0x0A4C;
const char32_t GURMUKHI_SIGN_VIRAMA = 0x0A4D;
const char32_t GURMUKHI_SIGN_UDAAT = 0x0A51;
const char32_t GURMUKHI_LETTER_KHHA = 0x0A59;
const char32_t GURMUKHI_LETTER_GHHA = 0x0A5A;
const char32_t GURMUKHI_LETTER_ZA = 0x0A5B;
const char32_t GURMUKHI_LETTER_RRA = 0x0A5C;
const char32_t GURMUKHI_LETTER_FA = 0x0A5E;
const char32_t GURMUKHI_DIGIT_ZERO = 0x0A66;
const char32_t GURMUKHI_DIGIT_ONE = 0x0A67;
const char32_t GURMUKHI_DIGIT_TWO = 0x0A68;
const char32_t GURMUKHI_DIGIT_THREE = 0x0A69;
const char32_t GURMUKHI_DIGIT_FOUR = 0x0A6A;
const char32_t GURMUKHI_DIGIT_FIVE = 0x0A6B;
const char32_t GURMUKHI_DIGIT_SIX = 0x0A6C;
const char32_t GURMUKHI_DIGIT_SEVEN = 0x0A6D;
const char32_t GURMUKHI_DIGIT_EIGHT = 0x0A6E;
const char32_t GURMUKHI_DIGIT_NINE = 0x0A6F;
const char32_t GURMUKHI_TIPPI = 0x0A70;
const char32_t GURMUKHI_ADDAK = 0x0A71;
const char32_t GURMUKHI_IRI = 0x0A72;
const char32_t GURMUKHI_URA = 0x0A73;
const char32_t GURMUKHI_EK_ONKAR = 0x0A74;
const char32_t GURMUKHI_SIGN_YAKASH = 0x0A75;
const char32_t GURMUKHI_ABBREVIATION_SIGN = 0x0A76;
const char32_t GUJARATI_SIGN_CANDRABINDU = 0x0A81;
const char32_t GUJARATI_SIGN_ANUSVARA = 0x0A82;
const char32_t GUJARATI_SIGN_VISARGA = 0x0A83;
const char32_t GUJARATI_LETTER_A = 0x0A85;
const char32_t GUJARATI_LETTER_AA = 0x0A86;
const char32_t GUJARATI_LETTER_I = 0x0A87;
const char32_t GUJARATI_LETTER_II = 0x0A88;
const char32_t GUJARATI_LETTER_U = 0x0A89;
const char32_t GUJARATI_LETTER_UU = 0x0A8A;
const char32_t GUJARATI_LETTER_VOCALIC_R = 0x0A8B;
const char32_t GUJARATI_LETTER_VOCALIC_L = 0x0A8C;
const char32_t GUJARATI_VOWEL_CANDRA_E = 0x0A8D;
const char32_t GUJARATI_LETTER_E = 0x0A8F;
const char32_t GUJARATI_LETTER_AI = 0x0A90;
const char32_t GUJARATI_VOWEL_CANDRA_O = 0x0A91;
const char32_t GUJARATI_LETTER_O = 0x0A93;
const char32_t GUJARATI_LETTER_AU = 0x0A94;
const char32_t GUJARATI_LETTER_KA = 0x0A95;
const char32_t GUJARATI_LETTER_KHA = 0x0A96;
const char32_t GUJARATI_LETTER_GA = 0x0A97;
const char32_t GUJARATI_LETTER_GHA = 0x0A98;
const char32_t GUJARATI_LETTER_NGA = 0x0A99;
const char32_t GUJARATI_LETTER_CA = 0x0A9A;
const char32_t GUJARATI_LETTER_CHA = 0x0A9B;
const char32_t GUJARATI_LETTER_JA = 0x0A9C;
const char32_t GUJARATI_LETTER_JHA = 0x0A9D;
const char32_t GUJARATI_LETTER_NYA = 0x0A9E;
const char32_t GUJARATI_LETTER_TTA = 0x0A9F;
const char32_t GUJARATI_LETTER_TTHA = 0x0AA0;
const char32_t GUJARATI_LETTER_DDA = 0x0AA1;
const char32_t GUJARATI_LETTER_DDHA = 0x0AA2;
const char32_t GUJARATI_LETTER_NNA = 0x0AA3;
const char32_t GUJARATI_LETTER_TA = 0x0AA4;
const char32_t GUJARATI_LETTER_THA = 0x0AA5;
const char32_t GUJARATI_LETTER_DA = 0x0AA6;
const char32_t GUJARATI_LETTER_DHA = 0x0AA7;
const char32_t GUJARATI_LETTER_NA = 0x0AA8;
const char32_t GUJARATI_LETTER_PA = 0x0AAA;
const char32_t GUJARATI_LETTER_PHA = 0x0AAB;
const char32_t GUJARATI_LETTER_BA = 0x0AAC;
const char32_t GUJARATI_LETTER_BHA = 0x0AAD;
const char32_t GUJARATI_LETTER_MA = 0x0AAE;
const char32_t GUJARATI_LETTER_YA = 0x0AAF;
const char32_t GUJARATI_LETTER_RA = 0x0AB0;
const char32_t GUJARATI_LETTER_LA = 0x0AB2;
const char32_t GUJARATI_LETTER_LLA = 0x0AB3;
const char32_t GUJARATI_LETTER_VA = 0x0AB5;
const char32_t GUJARATI_LETTER_SHA = 0x0AB6;
const char32_t GUJARATI_LETTER_SSA = 0x0AB7;
const char32_t GUJARATI_LETTER_SA = 0x0AB8;
const char32_t GUJARATI_LETTER_HA = 0x0AB9;
const char32_t GUJARATI_SIGN_NUKTA = 0x0ABC;
const char32_t GUJARATI_SIGN_AVAGRAHA = 0x0ABD;
const char32_t GUJARATI_VOWEL_SIGN_AA = 0x0ABE;
const char32_t GUJARATI_VOWEL_SIGN_I = 0x0ABF;
const char32_t GUJARATI_VOWEL_SIGN_II = 0x0AC0;
const char32_t GUJARATI_VOWEL_SIGN_U = 0x0AC1;
const char32_t GUJARATI_VOWEL_SIGN_UU = 0x0AC2;
const char32_t GUJARATI_VOWEL_SIGN_VOCALIC_R = 0x0AC3;
const char32_t GUJARATI_VOWEL_SIGN_VOCALIC_RR = 0x0AC4;
const char32_t GUJARATI_VOWEL_SIGN_CANDRA_E = 0x0AC5;
const char32_t GUJARATI_VOWEL_SIGN_E = 0x0AC7;
const char32_t GUJARATI_VOWEL_SIGN_AI = 0x0AC8;
const char32_t GUJARATI_VOWEL_SIGN_CANDRA_O = 0x0AC9;
const char32_t GUJARATI_VOWEL_SIGN_O = 0x0ACB;
const char32_t GUJARATI_VOWEL_SIGN_AU = 0x0ACC;
const char32_t GUJARATI_SIGN_VIRAMA = 0x0ACD;
const char32_t GUJARATI_OM = 0x0AD0;
const char32_t GUJARATI_LETTER_VOCALIC_RR = 0x0AE0;
const char32_t GUJARATI_LETTER_VOCALIC_LL = 0x0AE1;
const char32_t GUJARATI_VOWEL_SIGN_VOCALIC_L = 0x0AE2;
const char32_t GUJARATI_VOWEL_SIGN_VOCALIC_LL = 0x0AE3;
const char32_t GUJARATI_DIGIT_ZERO = 0x0AE6;
const char32_t GUJARATI_DIGIT_ONE = 0x0AE7;
const char32_t GUJARATI_DIGIT_TWO = 0x0AE8;
const char32_t GUJARATI_DIGIT_THREE = 0x0AE9;
const char32_t GUJARATI_DIGIT_FOUR = 0x0AEA;
const char32_t GUJARATI_DIGIT_FIVE = 0x0AEB;
const char32_t GUJARATI_DIGIT_SIX = 0x0AEC;
const char32_t GUJARATI_DIGIT_SEVEN = 0x0AED;
const char32_t GUJARATI_DIGIT_EIGHT = 0x0AEE;
const char32_t GUJARATI_DIGIT_NINE = 0x0AEF;
const char32_t GUJARATI_ABBREVIATION_SIGN = 0x0AF0;
const char32_t GUJARATI_RUPEE_SIGN = 0x0AF1;
const char32_t GUJARATI_LETTER_ZHA = 0x0AF9;
const char32_t GUJARATI_SIGN_SUKUN = 0x0AFA;
const char32_t GUJARATI_SIGN_SHADDA = 0x0AFB;
const char32_t GUJARATI_SIGN_MADDAH = 0x0AFC;
const char32_t GUJARATI_SIGN_THREE_DOT_NUKTA_ABOVE = 0x0AFD;
const char32_t GUJARATI_SIGN_CIRCLE_NUKTA_ABOVE = 0x0AFE;
const char32_t GUJARATI_SIGN_TWO_CIRCLE_NUKTA_ABOVE = 0x0AFF;
const char32_t ORIYA_SIGN_CANDRABINDU = 0x0B01;
const char32_t ORIYA_SIGN_ANUSVARA = 0x0B02;
const char32_t ORIYA_SIGN_VISARGA = 0x0B03;
const char32_t ORIYA_LETTER_A = 0x0B05;
const char32_t ORIYA_LETTER_AA = 0x0B06;
const char32_t ORIYA_LETTER_I = 0x0B07;
const char32_t ORIYA_LETTER_II = 0x0B08;
const char32_t ORIYA_LETTER_U = 0x0B09;
const char32_t ORIYA_LETTER_UU = 0x0B0A;
const char32_t ORIYA_LETTER_VOCALIC_R = 0x0B0B;
const char32_t ORIYA_LETTER_VOCALIC_L = 0x0B0C;
const char32_t ORIYA_LETTER_E = 0x0B0F;
const char32_t ORIYA_LETTER_AI = 0x0B10;
const char32_t ORIYA_LETTER_O = 0x0B13;
const char32_t ORIYA_LETTER_AU = 0x0B14;
const char32_t ORIYA_LETTER_KA = 0x0B15;
const char32_t ORIYA_LETTER_KHA = 0x0B16;
const char32_t ORIYA_LETTER_GA = 0x0B17;
const char32_t ORIYA_LETTER_GHA = 0x0B18;
const char32_t ORIYA_LETTER_NGA = 0x0B19;
const char32_t ORIYA_LETTER_CA = 0x0B1A;
const char32_t ORIYA_LETTER_CHA = 0x0B1B;
const char32_t ORIYA_LETTER_JA = 0x0B1C;
const char32_t ORIYA_LETTER_JHA = 0x0B1D;
const char32_t ORIYA_LETTER_NYA = 0x0B1E;
const char32_t ORIYA_LETTER_TTA = 0x0B1F;
const char32_t ORIYA_LETTER_TTHA = 0x0B20;
const char32_t ORIYA_LETTER_DDA = 0x0B21;
const char32_t ORIYA_LETTER_DDHA = 0x0B22;
const char32_t ORIYA_LETTER_NNA = 0x0B23;
const char32_t ORIYA_LETTER_TA = 0x0B24;
const char32_t ORIYA_LETTER_THA = 0x0B25;
const char32_t ORIYA_LETTER_DA = 0x0B26;
const char32_t ORIYA_LETTER_DHA = 0x0B27;
const char32_t ORIYA_LETTER_NA = 0x0B28;
const char32_t ORIYA_LETTER_PA = 0x0B2A;
const char32_t ORIYA_LETTER_PHA = 0x0B2B;
const char32_t ORIYA_LETTER_BA = 0x0B2C;
const char32_t ORIYA_LETTER_BHA = 0x0B2D;
const char32_t ORIYA_LETTER_MA = 0x0B2E;
const char32_t ORIYA_LETTER_YA = 0x0B2F;
const char32_t ORIYA_LETTER_RA = 0x0B30;
const char32_t ORIYA_LETTER_LA = 0x0B32;
const char32_t ORIYA_LETTER_LLA = 0x0B33;
const char32_t ORIYA_LETTER_VA = 0x0B35;
const char32_t ORIYA_LETTER_SHA = 0x0B36;
const char32_t ORIYA_LETTER_SSA = 0x0B37;
const char32_t ORIYA_LETTER_SA = 0x0B38;
const char32_t ORIYA_LETTER_HA = 0x0B39;
const char32_t ORIYA_SIGN_NUKTA = 0x0B3C;
const char32_t ORIYA_SIGN_AVAGRAHA = 0x0B3D;
const char32_t ORIYA_VOWEL_SIGN_AA = 0x0B3E;
const char32_t ORIYA_VOWEL_SIGN_I = 0x0B3F;
const char32_t ORIYA_VOWEL_SIGN_II = 0x0B40;
const char32_t ORIYA_VOWEL_SIGN_U = 0x0B41;
const char32_t ORIYA_VOWEL_SIGN_UU = 0x0B42;
const char32_t ORIYA_VOWEL_SIGN_VOCALIC_R = 0x0B43;
const char32_t ORIYA_VOWEL_SIGN_VOCALIC_RR = 0x0B44;
const char32_t ORIYA_VOWEL_SIGN_E = 0x0B47;
const char32_t ORIYA_VOWEL_SIGN_AI = 0x0B48;
const char32_t ORIYA_VOWEL_SIGN_O = 0x0B4B;
const char32_t ORIYA_VOWEL_SIGN_AU = 0x0B4C;
const char32_t ORIYA_SIGN_VIRAMA = 0x0B4D;
const char32_t ORIYA_SIGN_OVERLINE = 0x0B55;
const char32_t ORIYA_AI_LENGTH_MARK = 0x0B56;
const char32_t ORIYA_AU_LENGTH_MARK = 0x0B57;
const char32_t ORIYA_LETTER_RRA = 0x0B5C;
const char32_t ORIYA_LETTER_RHA = 0x0B5D;
const char32_t ORIYA_LETTER_YYA = 0x0B5F;
const char32_t ORIYA_LETTER_VOCALIC_RR = 0x0B60;
const char32_t ORIYA_LETTER_VOCALIC_LL = 0x0B61;
const char32_t ORIYA_VOWEL_SIGN_VOCALIC_L = 0x0B62;
const char32_t ORIYA_VOWEL_SIGN_VOCALIC_LL = 0x0B63;
const char32_t ORIYA_DIGIT_ZERO = 0x0B66;
const char32_t ORIYA_DIGIT_ONE = 0x0B67;
const char32_t ORIYA_DIGIT_TWO = 0x0B68;
const char32_t ORIYA_DIGIT_THREE = 0x0B69;
const char32_t ORIYA_DIGIT_FOUR = 0x0B6A;
const char32_t ORIYA_DIGIT_FIVE = 0x0B6B;
const char32_t ORIYA_DIGIT_SIX = 0x0B6C;
const char32_t ORIYA_DIGIT_SEVEN = 0x0B6D;
const char32_t ORIYA_DIGIT_EIGHT = 0x0B6E;
const char32_t ORIYA_DIGIT_NINE = 0x0B6F;
const char32_t ORIYA_ISSHAR = 0x0B70;
const char32_t ORIYA_LETTER_WA = 0x0B71;
const char32_t ORIYA_FRACTION_ONE_QUARTER = 0x0B72;
const char32_t ORIYA_FRACTION_ONE_HALF = 0x0B73;
const char32_t ORIYA_FRACTION_THREE_QUARTERS = 0x0B74;
const char32_t ORIYA_FRACTION_ONE_SIXTEENTH = 0x0B75;
const char32_t ORIYA_FRACTION_ONE_EIGHTH = 0x0B76;
const char32_t ORIYA_FRACTION_THREE_SIXTEENTHS = 0x0B77;
const char32_t TAMIL_SIGN_ANUSVARA = 0x0B82;
const char32_t TAMIL_SIGN_VISARGA = 0x0B83;
const char32_t TAMIL_LETTER_A = 0x0B85;
const char32_t TAMIL_LETTER_AA = 0x0B86;
const char32_t TAMIL_LETTER_I = 0x0B87;
const char32_t TAMIL_LETTER_II = 0x0B88;
const char32_t TAMIL_LETTER_U = 0x0B89;
const char32_t TAMIL_LETTER_UU = 0x0B8A;
const char32_t TAMIL_LETTER_E = 0x0B8E;
const char32_t TAMIL_LETTER_EE = 0x0B8F;
const char32_t TAMIL_LETTER_AI = 0x0B90;
const char32_t TAMIL_LETTER_O = 0x0B92;
const char32_t TAMIL_LETTER_OO = 0x0B93;
const char32_t TAMIL_LETTER_AU = 0x0B94;
const char32_t TAMIL_LETTER_KA = 0x0B95;
const char32_t TAMIL_LETTER_NGA = 0x0B99;
const char32_t TAMIL_LETTER_CA = 0x0B9A;
const char32_t TAMIL_LETTER_JA = 0x0B9C;
const char32_t TAMIL_LETTER_NYA = 0x0B9E;
const char32_t TAMIL_LETTER_TTA = 0x0B9F;
const char32_t TAMIL_LETTER_NNA = 0x0BA3;
const char32_t TAMIL_LETTER_TA = 0x0BA4;
const char32_t TAMIL_LETTER_NA = 0x0BA8;
const char32_t TAMIL_LETTER_NNNA = 0x0BA9;
const char32_t TAMIL_LETTER_PA = 0x0BAA;
const char32_t TAMIL_LETTER_MA = 0x0BAE;
const char32_t TAMIL_LETTER_YA = 0x0BAF;
const char32_t TAMIL_LETTER_RA = 0x0BB0;
const char32_t TAMIL_LETTER_RRA = 0x0BB1;
const char32_t TAMIL_LETTER_LA = 0x0BB2;
const char32_t TAMIL_LETTER_LLA = 0x0BB3;
const char32_t TAMIL_LETTER_LLLA = 0x0BB4;
const char32_t TAMIL_LETTER_VA = 0x0BB5;
const char32_t TAMIL_LETTER_SHA = 0x0BB6;
const char32_t TAMIL_LETTER_SSA = 0x0BB7;
const char32_t TAMIL_LETTER_SA = 0x0BB8;
const char32_t TAMIL_LETTER_HA = 0x0BB9;
const char32_t TAMIL_VOWEL_SIGN_AA = 0x0BBE;
const char32_t TAMIL_VOWEL_SIGN_I = 0x0BBF;
const char32_t TAMIL_VOWEL_SIGN_II = 0x0BC0;
const char32_t TAMIL_VOWEL_SIGN_U = 0x0BC1;
const char32_t TAMIL_VOWEL_SIGN_UU = 0x0BC2;
const char32_t TAMIL_VOWEL_SIGN_E = 0x0BC6;
const char32_t TAMIL_VOWEL_SIGN_EE = 0x0BC7;
const char32_t TAMIL_VOWEL_SIGN_AI = 0x0BC8;
const char32_t TAMIL_VOWEL_SIGN_O = 0x0BCA;
const char32_t TAMIL_VOWEL_SIGN_OO = 0x0BCB;
const char32_t TAMIL_VOWEL_SIGN_AU = 0x0BCC;
const char32_t TAMIL_SIGN_VIRAMA = 0x0BCD;
const char32_t TAMIL_OM = 0x0BD0;
const char32_t TAMIL_AU_LENGTH_MARK = 0x0BD7;
const char32_t TAMIL_DIGIT_ZERO = 0x0BE6;
const char32_t TAMIL_DIGIT_ONE = 0x0BE7;
const char32_t TAMIL_DIGIT_TWO = 0x0BE8;
const char32_t TAMIL_DIGIT_THREE = 0x0BE9;
const char32_t TAMIL_DIGIT_FOUR = 0x0BEA;
const char32_t TAMIL_DIGIT_FIVE = 0x0BEB;
const char32_t TAMIL_DIGIT_SIX = 0x0BEC;
const char32_t TAMIL_DIGIT_SEVEN = 0x0BED;
const char32_t TAMIL_DIGIT_EIGHT = 0x0BEE;
const char32_t TAMIL_DIGIT_NINE = 0x0BEF;
const char32_t TAMIL_NUMBER_TEN = 0x0BF0;
const char32_t TAMIL_NUMBER_ONE_HUNDRED = 0x0BF1;
const char32_t TAMIL_NUMBER_ONE_THOUSAND = 0x0BF2;
const char32_t TAMIL_DAY_SIGN = 0x0BF3;
const char32_t TAMIL_MONTH_SIGN = 0x0BF4;
const char32_t TAMIL_YEAR_SIGN = 0x0BF5;
const char32_t TAMIL_DEBIT_SIGN = 0x0BF6;
const char32_t TAMIL_CREDIT_SIGN = 0x0BF7;
const char32_t TAMIL_AS_ABOVE_SIGN = 0x0BF8;
const char32_t TAMIL_RUPEE_SIGN = 0x0BF9;
const char32_t TAMIL_NUMBER_SIGN = 0x0BFA;
const char32_t TELUGU_SIGN_COMBINING_CANDRABINDU_ABOVE = 0x0C00;
const char32_t TELUGU_SIGN_CANDRABINDU = 0x0C01;
const char32_t TELUGU_SIGN_ANUSVARA = 0x0C02;
const char32_t TELUGU_SIGN_VISARGA = 0x0C03;
const char32_t TELUGU_SIGN_COMBINING_ANUSVARA_ABOVE = 0x0C04;
const char32_t TELUGU_LETTER_A = 0x0C05;
const char32_t TELUGU_LETTER_AA = 0x0C06;
const char32_t TELUGU_LETTER_I = 0x0C07;
const char32_t TELUGU_LETTER_II = 0x0C08;
const char32_t TELUGU_LETTER_U = 0x0C09;
const char32_t TELUGU_LETTER_UU = 0x0C0A;
const char32_t TELUGU_LETTER_VOCALIC_R = 0x0C0B;
const char32_t TELUGU_LETTER_VOCALIC_L = 0x0C0C;
const char32_t TELUGU_LETTER_E = 0x0C0E;
const char32_t TELUGU_LETTER_EE = 0x0C0F;
const char32_t TELUGU_LETTER_AI = 0x0C10;
const char32_t TELUGU_LETTER_O = 0x0C12;
const char32_t TELUGU_LETTER_OO = 0x0C13;
const char32_t TELUGU_LETTER_AU = 0x0C14;
const char32_t TELUGU_LETTER_KA = 0x0C15;
const char32_t TELUGU_LETTER_KHA = 0x0C16;
const char32_t TELUGU_LETTER_GA = 0x0C17;
const char32_t TELUGU_LETTER_GHA = 0x0C18;
const char32_t TELUGU_LETTER_NGA = 0x0C19;
const char32_t TELUGU_LETTER_CA = 0x0C1A;
const char32_t TELUGU_LETTER_CHA = 0x0C1B;
const char32_t TELUGU_LETTER_JA = 0x0C1C;
const char32_t TELUGU_LETTER_JHA = 0x0C1D;
const char32_t TELUGU_LETTER_NYA = 0x0C1E;
const char32_t TELUGU_LETTER_TTA = 0x0C1F;
const char32_t TELUGU_LETTER_TTHA = 0x0C20;
const char32_t TELUGU_LETTER_DDA = 0x0C21;
const char32_t TELUGU_LETTER_DDHA = 0x0C22;
const char32_t TELUGU_LETTER_NNA = 0x0C23;
const char32_t TELUGU_LETTER_TA = 0x0C24;
const char32_t TELUGU_LETTER_THA = 0x0C25;
const char32_t TELUGU_LETTER_DA = 0x0C26;
const char32_t TELUGU_LETTER_DHA = 0x0C27;
const char32_t TELUGU_LETTER_NA = 0x0C28;
const char32_t TELUGU_LETTER_PA = 0x0C2A;
const char32_t TELUGU_LETTER_PHA = 0x0C2B;
const char32_t TELUGU_LETTER_BA = 0x0C2C;
const char32_t TELUGU_LETTER_BHA = 0x0C2D;
const char32_t TELUGU_LETTER_MA = 0x0C2E;
const char32_t TELUGU_LETTER_YA = 0x0C2F;
const char32_t TELUGU_LETTER_RA = 0x0C30;
const char32_t TELUGU_LETTER_RRA = 0x0C31;
const char32_t TELUGU_LETTER_LA = 0x0C32;
const char32_t TELUGU_LETTER_LLA = 0x0C33;
const char32_t TELUGU_LETTER_LLLA = 0x0C34;
const char32_t TELUGU_LETTER_VA = 0x0C35;
const char32_t TELUGU_LETTER_SHA = 0x0C36;
const char32_t TELUGU_LETTER_SSA = 0x0C37;
const char32_t TELUGU_LETTER_SA = 0x0C38;
const char32_t TELUGU_LETTER_HA = 0x0C39;
const char32_t TELUGU_SIGN_AVAGRAHA = 0x0C3D;
const char32_t TELUGU_VOWEL_SIGN_AA = 0x0C3E;
const char32_t TELUGU_VOWEL_SIGN_I = 0x0C3F;
const char32_t TELUGU_VOWEL_SIGN_II = 0x0C40;
const char32_t TELUGU_VOWEL_SIGN_U = 0x0C41;
const char32_t TELUGU_VOWEL_SIGN_UU = 0x0C42;
const char32_t TELUGU_VOWEL_SIGN_VOCALIC_R = 0x0C43;
const char32_t TELUGU_VOWEL_SIGN_VOCALIC_RR = 0x0C44;
const char32_t TELUGU_VOWEL_SIGN_E = 0x0C46;
const char32_t TELUGU_VOWEL_SIGN_EE = 0x0C47;
const char32_t TELUGU_VOWEL_SIGN_AI = 0x0C48;
const char32_t TELUGU_VOWEL_SIGN_O = 0x0C4A;
const char32_t TELUGU_VOWEL_SIGN_OO = 0x0C4B;
const char32_t TELUGU_VOWEL_SIGN_AU = 0x0C4C;
const char32_t TELUGU_SIGN_VIRAMA = 0x0C4D;
const char32_t TELUGU_LENGTH_MARK = 0x0C55;
const char32_t TELUGU_AI_LENGTH_MARK = 0x0C56;
const char32_t TELUGU_LETTER_TSA = 0x0C58;
const char32_t TELUGU_LETTER_DZA = 0x0C59;
const char32_t TELUGU_LETTER_RRRA = 0x0C5A;
const char32_t TELUGU_LETTER_VOCALIC_RR = 0x0C60;
const char32_t TELUGU_LETTER_VOCALIC_LL = 0x0C61;
const char32_t TELUGU_VOWEL_SIGN_VOCALIC_L = 0x0C62;
const char32_t TELUGU_VOWEL_SIGN_VOCALIC_LL = 0x0C63;
const char32_t TELUGU_DIGIT_ZERO = 0x0C66;
const char32_t TELUGU_DIGIT_ONE = 0x0C67;
const char32_t TELUGU_DIGIT_TWO = 0x0C68;
const char32_t TELUGU_DIGIT_THREE = 0x0C69;
const char32_t TELUGU_DIGIT_FOUR = 0x0C6A;
const char32_t TELUGU_DIGIT_FIVE = 0x0C6B;
const char32_t TELUGU_DIGIT_SIX = 0x0C6C;
const char32_t TELUGU_DIGIT_SEVEN = 0x0C6D;
const char32_t TELUGU_DIGIT_EIGHT = 0x0C6E;
const char32_t TELUGU_DIGIT_NINE = 0x0C6F;
const char32_t TELUGU_SIGN_SIDDHAM = 0x0C77;
const char32_t TELUGU_FRACTION_DIGIT_ZERO_FOR_ODD_POWERS_OF_FOUR = 0x0C78;
const char32_t TELUGU_FRACTION_DIGIT_ONE_FOR_ODD_POWERS_OF_FOUR = 0x0C79;
const char32_t TELUGU_FRACTION_DIGIT_TWO_FOR_ODD_POWERS_OF_FOUR = 0x0C7A;
const char32_t TELUGU_FRACTION_DIGIT_THREE_FOR_ODD_POWERS_OF_FOUR = 0x0C7B;
const char32_t TELUGU_FRACTION_DIGIT_ONE_FOR_EVEN_POWERS_OF_FOUR = 0x0C7C;
const char32_t TELUGU_FRACTION_DIGIT_TWO_FOR_EVEN_POWERS_OF_FOUR = 0x0C7D;
const char32_t TELUGU_FRACTION_DIGIT_THREE_FOR_EVEN_POWERS_OF_FOUR = 0x0C7E;
const char32_t TELUGU_SIGN_TUUMU = 0x0C7F;
const char32_t KANNADA_SIGN_SPACING_CANDRABINDU = 0x0C80;
const char32_t KANNADA_SIGN_CANDRABINDU = 0x0C81;
const char32_t KANNADA_SIGN_ANUSVARA = 0x0C82;
const char32_t KANNADA_SIGN_VISARGA = 0x0C83;
const char32_t KANNADA_SIGN_SIDDHAM = 0x0C84;
const char32_t KANNADA_LETTER_A = 0x0C85;
const char32_t KANNADA_LETTER_AA = 0x0C86;
const char32_t KANNADA_LETTER_I = 0x0C87;
const char32_t KANNADA_LETTER_II = 0x0C88;
const char32_t KANNADA_LETTER_U = 0x0C89;
const char32_t KANNADA_LETTER_UU = 0x0C8A;
const char32_t KANNADA_LETTER_VOCALIC_R = 0x0C8B;
const char32_t KANNADA_LETTER_VOCALIC_L = 0x0C8C;
const char32_t KANNADA_LETTER_E = 0x0C8E;
const char32_t KANNADA_LETTER_EE = 0x0C8F;
const char32_t KANNADA_LETTER_AI = 0x0C90;
const char32_t KANNADA_LETTER_O = 0x0C92;
const char32_t KANNADA_LETTER_OO = 0x0C93;
const char32_t KANNADA_LETTER_AU = 0x0C94;
const char32_t KANNADA_LETTER_KA = 0x0C95;
const char32_t KANNADA_LETTER_KHA = 0x0C96;
const char32_t KANNADA_LETTER_GA = 0x0C97;
const char32_t KANNADA_LETTER_GHA = 0x0C98;
const char32_t KANNADA_LETTER_NGA = 0x0C99;
const char32_t KANNADA_LETTER_CA = 0x0C9A;
const char32_t KANNADA_LETTER_CHA = 0x0C9B;
const char32_t KANNADA_LETTER_JA = 0x0C9C;
const char32_t KANNADA_LETTER_JHA = 0x0C9D;
const char32_t KANNADA_LETTER_NYA = 0x0C9E;
const char32_t KANNADA_LETTER_TTA = 0x0C9F;
const char32_t KANNADA_LETTER_TTHA = 0x0CA0;
const char32_t KANNADA_LETTER_DDA = 0x0CA1;
const char32_t KANNADA_LETTER_DDHA = 0x0CA2;
const char32_t KANNADA_LETTER_NNA = 0x0CA3;
const char32_t KANNADA_LETTER_TA = 0x0CA4;
const char32_t KANNADA_LETTER_THA = 0x0CA5;
const char32_t KANNADA_LETTER_DA = 0x0CA6;
const char32_t KANNADA_LETTER_DHA = 0x0CA7;
const char32_t KANNADA_LETTER_NA = 0x0CA8;
const char32_t KANNADA_LETTER_PA = 0x0CAA;
const char32_t KANNADA_LETTER_PHA = 0x0CAB;
const char32_t KANNADA_LETTER_BA = 0x0CAC;
const char32_t KANNADA_LETTER_BHA = 0x0CAD;
const char32_t KANNADA_LETTER_MA = 0x0CAE;
const char32_t KANNADA_LETTER_YA = 0x0CAF;
const char32_t KANNADA_LETTER_RA = 0x0CB0;
const char32_t KANNADA_LETTER_RRA = 0x0CB1;
const char32_t KANNADA_LETTER_LA = 0x0CB2;
const char32_t KANNADA_LETTER_LLA = 0x0CB3;
const char32_t KANNADA_LETTER_VA = 0x0CB5;
const char32_t KANNADA_LETTER_SHA = 0x0CB6;
const char32_t KANNADA_LETTER_SSA = 0x0CB7;
const char32_t KANNADA_LETTER_SA = 0x0CB8;
const char32_t KANNADA_LETTER_HA = 0x0CB9;
const char32_t KANNADA_SIGN_NUKTA = 0x0CBC;
const char32_t KANNADA_SIGN_AVAGRAHA = 0x0CBD;
const char32_t KANNADA_VOWEL_SIGN_AA = 0x0CBE;
const char32_t KANNADA_VOWEL_SIGN_I = 0x0CBF;
const char32_t KANNADA_VOWEL_SIGN_II = 0x0CC0;
const char32_t KANNADA_VOWEL_SIGN_U = 0x0CC1;
const char32_t KANNADA_VOWEL_SIGN_UU = 0x0CC2;
const char32_t KANNADA_VOWEL_SIGN_VOCALIC_R = 0x0CC3;
const char32_t KANNADA_VOWEL_SIGN_VOCALIC_RR = 0x0CC4;
const char32_t KANNADA_VOWEL_SIGN_E = 0x0CC6;
const char32_t KANNADA_VOWEL_SIGN_EE = 0x0CC7;
const char32_t KANNADA_VOWEL_SIGN_AI = 0x0CC8;
const char32_t KANNADA_VOWEL_SIGN_O = 0x0CCA;
const char32_t KANNADA_VOWEL_SIGN_OO = 0x0CCB;
const char32_t KANNADA_VOWEL_SIGN_AU = 0x0CCC;
const char32_t KANNADA_SIGN_VIRAMA = 0x0CCD;
const char32_t KANNADA_LENGTH_MARK = 0x0CD5;
const char32_t KANNADA_AI_LENGTH_MARK = 0x0CD6;
const char32_t KANNADA_LETTER_FA = 0x0CDE;
const char32_t KANNADA_LETTER_VOCALIC_RR = 0x0CE0;
const char32_t KANNADA_LETTER_VOCALIC_LL = 0x0CE1;
const char32_t KANNADA_VOWEL_SIGN_VOCALIC_L = 0x0CE2;
const char32_t KANNADA_VOWEL_SIGN_VOCALIC_LL = 0x0CE3;
const char32_t KANNADA_DIGIT_ZERO = 0x0CE6;
const char32_t KANNADA_DIGIT_ONE = 0x0CE7;
const char32_t KANNADA_DIGIT_TWO = 0x0CE8;
const char32_t KANNADA_DIGIT_THREE = 0x0CE9;
const char32_t KANNADA_DIGIT_FOUR = 0x0CEA;
const char32_t KANNADA_DIGIT_FIVE = 0x0CEB;
const char32_t KANNADA_DIGIT_SIX = 0x0CEC;
const char32_t KANNADA_DIGIT_SEVEN = 0x0CED;
const char32_t KANNADA_DIGIT_EIGHT = 0x0CEE;
const char32_t KANNADA_DIGIT_NINE = 0x0CEF;
const char32_t KANNADA_SIGN_JIHVAMULIYA = 0x0CF1;
const char32_t KANNADA_SIGN_UPADHMANIYA = 0x0CF2;
const char32_t MALAYALAM_SIGN_COMBINING_ANUSVARA_ABOVE = 0x0D00;
const char32_t MALAYALAM_SIGN_CANDRABINDU = 0x0D01;
const char32_t MALAYALAM_SIGN_ANUSVARA = 0x0D02;
const char32_t MALAYALAM_SIGN_VISARGA = 0x0D03;
const char32_t MALAYALAM_LETTER_VEDIC_ANUSVARA = 0x0D04;
const char32_t MALAYALAM_LETTER_A = 0x0D05;
const char32_t MALAYALAM_LETTER_AA = 0x0D06;
const char32_t MALAYALAM_LETTER_I = 0x0D07;
const char32_t MALAYALAM_LETTER_II = 0x0D08;
const char32_t MALAYALAM_LETTER_U = 0x0D09;
const char32_t MALAYALAM_LETTER_UU = 0x0D0A;
const char32_t MALAYALAM_LETTER_VOCALIC_R = 0x0D0B;
const char32_t MALAYALAM_LETTER_VOCALIC_L = 0x0D0C;
const char32_t MALAYALAM_LETTER_E = 0x0D0E;
const char32_t MALAYALAM_LETTER_EE = 0x0D0F;
const char32_t MALAYALAM_LETTER_AI = 0x0D10;
const char32_t MALAYALAM_LETTER_O = 0x0D12;
const char32_t MALAYALAM_LETTER_OO = 0x0D13;
const char32_t MALAYALAM_LETTER_AU = 0x0D14;
const char32_t MALAYALAM_LETTER_KA = 0x0D15;
const char32_t MALAYALAM_LETTER_KHA = 0x0D16;
const char32_t MALAYALAM_LETTER_GA = 0x0D17;
const char32_t MALAYALAM_LETTER_GHA = 0x0D18;
const char32_t MALAYALAM_LETTER_NGA = 0x0D19;
const char32_t MALAYALAM_LETTER_CA = 0x0D1A;
const char32_t MALAYALAM_LETTER_CHA = 0x0D1B;
const char32_t MALAYALAM_LETTER_JA = 0x0D1C;
const char32_t MALAYALAM_LETTER_JHA = 0x0D1D;
const char32_t MALAYALAM_LETTER_NYA = 0x0D1E;
const char32_t MALAYALAM_LETTER_TTA = 0x0D1F;
const char32_t MALAYALAM_LETTER_TTHA = 0x0D20;
const char32_t MALAYALAM_LETTER_DDA = 0x0D21;
const char32_t MALAYALAM_LETTER_DDHA = 0x0D22;
const char32_t MALAYALAM_LETTER_NNA = 0x0D23;
const char32_t MALAYALAM_LETTER_TA = 0x0D24;
const char32_t MALAYALAM_LETTER_THA = 0x0D25;
const char32_t MALAYALAM_LETTER_DA = 0x0D26;
const char32_t MALAYALAM_LETTER_DHA = 0x0D27;
const char32_t MALAYALAM_LETTER_NA = 0x0D28;
const char32_t MALAYALAM_LETTER_NNNA = 0x0D29;
const char32_t MALAYALAM_LETTER_PA = 0x0D2A;
const char32_t MALAYALAM_LETTER_PHA = 0x0D2B;
const char32_t MALAYALAM_LETTER_BA = 0x0D2C;
const char32_t MALAYALAM_LETTER_BHA = 0x0D2D;
const char32_t MALAYALAM_LETTER_MA = 0x0D2E;
const char32_t MALAYALAM_LETTER_YA = 0x0D2F;
const char32_t MALAYALAM_LETTER_RA = 0x0D30;
const char32_t MALAYALAM_LETTER_RRA = 0x0D31;
const char32_t MALAYALAM_LETTER_LA = 0x0D32;
const char32_t MALAYALAM_LETTER_LLA = 0x0D33;
const char32_t MALAYALAM_LETTER_LLLA = 0x0D34;
const char32_t MALAYALAM_LETTER_VA = 0x0D35;
const char32_t MALAYALAM_LETTER_SHA = 0x0D36;
const char32_t MALAYALAM_LETTER_SSA = 0x0D37;
const char32_t MALAYALAM_LETTER_SA = 0x0D38;
const char32_t MALAYALAM_LETTER_HA = 0x0D39;
const char32_t MALAYALAM_LETTER_TTTA = 0x0D3A;
const char32_t MALAYALAM_SIGN_VERTICAL_BAR_VIRAMA = 0x0D3B;
const char32_t MALAYALAM_SIGN_CIRCULAR_VIRAMA = 0x0D3C;
const char32_t MALAYALAM_SIGN_AVAGRAHA = 0x0D3D;
const char32_t MALAYALAM_VOWEL_SIGN_AA = 0x0D3E;
const char32_t MALAYALAM_VOWEL_SIGN_I = 0x0D3F;
const char32_t MALAYALAM_VOWEL_SIGN_II = 0x0D40;
const char32_t MALAYALAM_VOWEL_SIGN_U = 0x0D41;
const char32_t MALAYALAM_VOWEL_SIGN_UU = 0x0D42;
const char32_t MALAYALAM_VOWEL_SIGN_VOCALIC_R = 0x0D43;
const char32_t MALAYALAM_VOWEL_SIGN_VOCALIC_RR = 0x0D44;
const char32_t MALAYALAM_VOWEL_SIGN_E = 0x0D46;
const char32_t MALAYALAM_VOWEL_SIGN_EE = 0x0D47;
const char32_t MALAYALAM_VOWEL_SIGN_AI = 0x0D48;
const char32_t MALAYALAM_VOWEL_SIGN_O = 0x0D4A;
const char32_t MALAYALAM_VOWEL_SIGN_OO = 0x0D4B;
const char32_t MALAYALAM_VOWEL_SIGN_AU = 0x0D4C;
const char32_t MALAYALAM_SIGN_VIRAMA = 0x0D4D;
const char32_t MALAYALAM_LETTER_DOT_REPH = 0x0D4E;
const char32_t MALAYALAM_SIGN_PARA = 0x0D4F;
const char32_t MALAYALAM_LETTER_CHILLU_M = 0x0D54;
const char32_t MALAYALAM_LETTER_CHILLU_Y = 0x0D55;
const char32_t MALAYALAM_LETTER_CHILLU_LLL = 0x0D56;
const char32_t MALAYALAM_AU_LENGTH_MARK = 0x0D57;
const char32_t MALAYALAM_FRACTION_ONE_ONE_HUNDRED_AND_SIXTIETH = 0x0D58;
const char32_t MALAYALAM_FRACTION_ONE_FORTIETH = 0x0D59;
const char32_t MALAYALAM_FRACTION_THREE_EIGHTIETHS = 0x0D5A;
const char32_t MALAYALAM_FRACTION_ONE_TWENTIETH = 0x0D5B;
const char32_t MALAYALAM_FRACTION_ONE_TENTH = 0x0D5C;
const char32_t MALAYALAM_FRACTION_THREE_TWENTIETHS = 0x0D5D;
const char32_t MALAYALAM_FRACTION_ONE_FIFTH = 0x0D5E;
const char32_t MALAYALAM_LETTER_ARCHAIC_II = 0x0D5F;
const char32_t MALAYALAM_LETTER_VOCALIC_RR = 0x0D60;
const char32_t MALAYALAM_LETTER_VOCALIC_LL = 0x0D61;
const char32_t MALAYALAM_VOWEL_SIGN_VOCALIC_L = 0x0D62;
const char32_t MALAYALAM_VOWEL_SIGN_VOCALIC_LL = 0x0D63;
const char32_t MALAYALAM_DIGIT_ZERO = 0x0D66;
const char32_t MALAYALAM_DIGIT_ONE = 0x0D67;
const char32_t MALAYALAM_DIGIT_TWO = 0x0D68;
const char32_t MALAYALAM_DIGIT_THREE = 0x0D69;
const char32_t MALAYALAM_DIGIT_FOUR = 0x0D6A;
const char32_t MALAYALAM_DIGIT_FIVE = 0x0D6B;
const char32_t MALAYALAM_DIGIT_SIX = 0x0D6C;
const char32_t MALAYALAM_DIGIT_SEVEN = 0x0D6D;
const char32_t MALAYALAM_DIGIT_EIGHT = 0x0D6E;
const char32_t MALAYALAM_DIGIT_NINE = 0x0D6F;
const char32_t MALAYALAM_NUMBER_TEN = 0x0D70;
const char32_t MALAYALAM_NUMBER_ONE_HUNDRED = 0x0D71;
const char32_t MALAYALAM_NUMBER_ONE_THOUSAND = 0x0D72;
const char32_t MALAYALAM_FRACTION_ONE_QUARTER = 0x0D73;
const char32_t MALAYALAM_FRACTION_ONE_HALF = 0x0D74;
const char32_t MALAYALAM_FRACTION_THREE_QUARTERS = 0x0D75;
const char32_t MALAYALAM_FRACTION_ONE_SIXTEENTH = 0x0D76;
const char32_t MALAYALAM_FRACTION_ONE_EIGHTH = 0x0D77;
const char32_t MALAYALAM_FRACTION_THREE_SIXTEENTHS = 0x0D78;
const char32_t MALAYALAM_DATE_MARK = 0x0D79;
const char32_t MALAYALAM_LETTER_CHILLU_NN = 0x0D7A;
const char32_t MALAYALAM_LETTER_CHILLU_N = 0x0D7B;
const char32_t MALAYALAM_LETTER_CHILLU_RR = 0x0D7C;
const char32_t MALAYALAM_LETTER_CHILLU_L = 0x0D7D;
const char32_t MALAYALAM_LETTER_CHILLU_LL = 0x0D7E;
const char32_t MALAYALAM_LETTER_CHILLU_K = 0x0D7F;
const char32_t SINHALA_SIGN_CANDRABINDU = 0x0D81;
const char32_t SINHALA_SIGN_ANUSVARAYA = 0x0D82;
const char32_t SINHALA_SIGN_VISARGAYA = 0x0D83;
const char32_t SINHALA_LETTER_AYANNA = 0x0D85;
const char32_t SINHALA_LETTER_AAYANNA = 0x0D86;
const char32_t SINHALA_LETTER_AEYANNA = 0x0D87;
const char32_t SINHALA_LETTER_AEEYANNA = 0x0D88;
const char32_t SINHALA_LETTER_IYANNA = 0x0D89;
const char32_t SINHALA_LETTER_IIYANNA = 0x0D8A;
const char32_t SINHALA_LETTER_UYANNA = 0x0D8B;
const char32_t SINHALA_LETTER_UUYANNA = 0x0D8C;
const char32_t SINHALA_LETTER_IRUYANNA = 0x0D8D;
const char32_t SINHALA_LETTER_IRUUYANNA = 0x0D8E;
const char32_t SINHALA_LETTER_ILUYANNA = 0x0D8F;
const char32_t SINHALA_LETTER_ILUUYANNA = 0x0D90;
const char32_t SINHALA_LETTER_EYANNA = 0x0D91;
const char32_t SINHALA_LETTER_EEYANNA = 0x0D92;
const char32_t SINHALA_LETTER_AIYANNA = 0x0D93;
const char32_t SINHALA_LETTER_OYANNA = 0x0D94;
const char32_t SINHALA_LETTER_OOYANNA = 0x0D95;
const char32_t SINHALA_LETTER_AUYANNA = 0x0D96;
const char32_t SINHALA_LETTER_ALPAPRAANA_KAYANNA = 0x0D9A;
const char32_t SINHALA_LETTER_MAHAAPRAANA_KAYANNA = 0x0D9B;
const char32_t SINHALA_LETTER_ALPAPRAANA_GAYANNA = 0x0D9C;
const char32_t SINHALA_LETTER_MAHAAPRAANA_GAYANNA = 0x0D9D;
const char32_t SINHALA_LETTER_KANTAJA_NAASIKYAYA = 0x0D9E;
const char32_t SINHALA_LETTER_SANYAKA_GAYANNA = 0x0D9F;
const char32_t SINHALA_LETTER_ALPAPRAANA_CAYANNA = 0x0DA0;
const char32_t SINHALA_LETTER_MAHAAPRAANA_CAYANNA = 0x0DA1;
const char32_t SINHALA_LETTER_ALPAPRAANA_JAYANNA = 0x0DA2;
const char32_t SINHALA_LETTER_MAHAAPRAANA_JAYANNA = 0x0DA3;
const char32_t SINHALA_LETTER_TAALUJA_NAASIKYAYA = 0x0DA4;
const char32_t SINHALA_LETTER_TAALUJA_SANYOOGA_NAAKSIKYAYA = 0x0DA5;
const char32_t SINHALA_LETTER_SANYAKA_JAYANNA = 0x0DA6;
const char32_t SINHALA_LETTER_ALPAPRAANA_TTAYANNA = 0x0DA7;
const char32_t SINHALA_LETTER_MAHAAPRAANA_TTAYANNA = 0x0DA8;
const char32_t SINHALA_LETTER_ALPAPRAANA_DDAYANNA = 0x0DA9;
const char32_t SINHALA_LETTER_MAHAAPRAANA_DDAYANNA = 0x0DAA;
const char32_t SINHALA_LETTER_MUURDHAJA_NAYANNA = 0x0DAB;
const char32_t SINHALA_LETTER_SANYAKA_DDAYANNA = 0x0DAC;
const char32_t SINHALA_LETTER_ALPAPRAANA_TAYANNA = 0x0DAD;
const char32_t SINHALA_LETTER_MAHAAPRAANA_TAYANNA = 0x0DAE;
const char32_t SINHALA_LETTER_ALPAPRAANA_DAYANNA = 0x0DAF;
const char32_t SINHALA_LETTER_MAHAAPRAANA_DAYANNA = 0x0DB0;
const char32_t SINHALA_LETTER_DANTAJA_NAYANNA = 0x0DB1;
const char32_t SINHALA_LETTER_SANYAKA_DAYANNA = 0x0DB3;
const char32_t SINHALA_LETTER_ALPAPRAANA_PAYANNA = 0x0DB4;
const char32_t SINHALA_LETTER_MAHAAPRAANA_PAYANNA = 0x0DB5;
const char32_t SINHALA_LETTER_ALPAPRAANA_BAYANNA = 0x0DB6;
const char32_t SINHALA_LETTER_MAHAAPRAANA_BAYANNA = 0x0DB7;
const char32_t SINHALA_LETTER_MAYANNA = 0x0DB8;
const char32_t SINHALA_LETTER_AMBA_BAYANNA = 0x0DB9;
const char32_t SINHALA_LETTER_YAYANNA = 0x0DBA;
const char32_t SINHALA_LETTER_RAYANNA = 0x0DBB;
const char32_t SINHALA_LETTER_DANTAJA_LAYANNA = 0x0DBD;
const char32_t SINHALA_LETTER_VAYANNA = 0x0DC0;
const char32_t SINHALA_LETTER_TAALUJA_SAYANNA = 0x0DC1;
const char32_t SINHALA_LETTER_MUURDHAJA_SAYANNA = 0x0DC2;
const char32_t SINHALA_LETTER_DANTAJA_SAYANNA = 0x0DC3;
const char32_t SINHALA_LETTER_HAYANNA = 0x0DC4;
const char32_t SINHALA_LETTER_MUURDHAJA_LAYANNA = 0x0DC5;
const char32_t SINHALA_LETTER_FAYANNA = 0x0DC6;
const char32_t SINHALA_SIGN_AL_LAKUNA = 0x0DCA;
const char32_t SINHALA_VOWEL_SIGN_AELA_PILLA = 0x0DCF;
const char32_t SINHALA_VOWEL_SIGN_KETTI_AEDA_PILLA = 0x0DD0;
const char32_t SINHALA_VOWEL_SIGN_DIGA_AEDA_PILLA = 0x0DD1;
const char32_t SINHALA_VOWEL_SIGN_KETTI_IS_PILLA = 0x0DD2;
const char32_t SINHALA_VOWEL_SIGN_DIGA_IS_PILLA = 0x0DD3;
const char32_t SINHALA_VOWEL_SIGN_KETTI_PAA_PILLA = 0x0DD4;
const char32_t SINHALA_VOWEL_SIGN_DIGA_PAA_PILLA = 0x0DD6;
const char32_t SINHALA_VOWEL_SIGN_GAETTA_PILLA = 0x0DD8;
const char32_t SINHALA_VOWEL_SIGN_KOMBUVA = 0x0DD9;
const char32_t SINHALA_VOWEL_SIGN_DIGA_KOMBUVA = 0x0DDA;
const char32_t SINHALA_VOWEL_SIGN_KOMBU_DEKA = 0x0DDB;
const char32_t SINHALA_VOWEL_SIGN_KOMBUVA_HAA_AELA_PILLA = 0x0DDC;
const char32_t SINHALA_VOWEL_SIGN_KOMBUVA_HAA_DIGA_AELA_PILLA = 0x0DDD;
const char32_t SINHALA_VOWEL_SIGN_KOMBUVA_HAA_GAYANUKITTA = 0x0DDE;
const char32_t SINHALA_VOWEL_SIGN_GAYANUKITTA = 0x0DDF;
const char32_t SINHALA_LITH_DIGIT_ZERO = 0x0DE6;
const char32_t SINHALA_LITH_DIGIT_ONE = 0x0DE7;
const char32_t SINHALA_LITH_DIGIT_TWO = 0x0DE8;
const char32_t SINHALA_LITH_DIGIT_THREE = 0x0DE9;
const char32_t SINHALA_LITH_DIGIT_FOUR = 0x0DEA;
const char32_t SINHALA_LITH_DIGIT_FIVE = 0x0DEB;
const char32_t SINHALA_LITH_DIGIT_SIX = 0x0DEC;
const char32_t SINHALA_LITH_DIGIT_SEVEN = 0x0DED;
const char32_t SINHALA_LITH_DIGIT_EIGHT = 0x0DEE;
const char32_t SINHALA_LITH_DIGIT_NINE = 0x0DEF;
const char32_t SINHALA_VOWEL_SIGN_DIGA_GAETTA_PILLA = 0x0DF2;
const char32_t SINHALA_VOWEL_SIGN_DIGA_GAYANUKITTA = 0x0DF3;
const char32_t SINHALA_PUNCTUATION_KUNDDALIYA = 0x0DF4;
const char32_t THAI_CHARACTER_KO_KAI = 0x0E01;
const char32_t THAI_CHARACTER_KHO_KHAI = 0x0E02;
const char32_t THAI_CHARACTER_KHO_KHUAT = 0x0E03;
const char32_t THAI_CHARACTER_KHO_KHWAI = 0x0E04;
const char32_t THAI_CHARACTER_KHO_KHON = 0x0E05;
const char32_t THAI_CHARACTER_KHO_RAKHANG = 0x0E06;
const char32_t THAI_CHARACTER_NGO_NGU = 0x0E07;
const char32_t THAI_CHARACTER_CHO_CHAN = 0x0E08;
const char32_t THAI_CHARACTER_CHO_CHING = 0x0E09;
const char32_t THAI_CHARACTER_CHO_CHANG = 0x0E0A;
const char32_t THAI_CHARACTER_SO_SO = 0x0E0B;
const char32_t THAI_CHARACTER_CHO_CHOE = 0x0E0C;
const char32_t THAI_CHARACTER_YO_YING = 0x0E0D;
const char32_t THAI_CHARACTER_DO_CHADA = 0x0E0E;
const char32_t THAI_CHARACTER_TO_PATAK = 0x0E0F;
const char32_t THAI_CHARACTER_THO_THAN = 0x0E10;
const char32_t THAI_CHARACTER_THO_NANGMONTHO = 0x0E11;
const char32_t THAI_CHARACTER_THO_PHUTHAO = 0x0E12;
const char32_t THAI_CHARACTER_NO_NEN = 0x0E13;
const char32_t THAI_CHARACTER_DO_DEK = 0x0E14;
const char32_t THAI_CHARACTER_TO_TAO = 0x0E15;
const char32_t THAI_CHARACTER_THO_THUNG = 0x0E16;
const char32_t THAI_CHARACTER_THO_THAHAN = 0x0E17;
const char32_t THAI_CHARACTER_THO_THONG = 0x0E18;
const char32_t THAI_CHARACTER_NO_NU = 0x0E19;
const char32_t THAI_CHARACTER_BO_BAIMAI = 0x0E1A;
const char32_t THAI_CHARACTER_PO_PLA = 0x0E1B;
const char32_t THAI_CHARACTER_PHO_PHUNG = 0x0E1C;
const char32_t THAI_CHARACTER_FO_FA = 0x0E1D;
const char32_t THAI_CHARACTER_PHO_PHAN = 0x0E1E;
const char32_t THAI_CHARACTER_FO_FAN = 0x0E1F;
const char32_t THAI_CHARACTER_PHO_SAMPHAO = 0x0E20;
const char32_t THAI_CHARACTER_MO_MA = 0x0E21;
const char32_t THAI_CHARACTER_YO_YAK = 0x0E22;
const char32_t THAI_CHARACTER_RO_RUA = 0x0E23;
const char32_t THAI_CHARACTER_RU = 0x0E24;
const char32_t THAI_CHARACTER_LO_LING = 0x0E25;
const char32_t THAI_CHARACTER_LU = 0x0E26;
const char32_t THAI_CHARACTER_WO_WAEN = 0x0E27;
const char32_t THAI_CHARACTER_SO_SALA = 0x0E28;
const char32_t THAI_CHARACTER_SO_RUSI = 0x0E29;
const char32_t THAI_CHARACTER_SO_SUA = 0x0E2A;
const char32_t THAI_CHARACTER_HO_HIP = 0x0E2B;
const char32_t THAI_CHARACTER_LO_CHULA = 0x0E2C;
const char32_t THAI_CHARACTER_O_ANG = 0x0E2D;
const char32_t THAI_CHARACTER_HO_NOKHUK = 0x0E2E;
const char32_t THAI_CHARACTER_PAIYANNOI = 0x0E2F;
const char32_t THAI_CHARACTER_SARA_A = 0x0E30;
const char32_t THAI_CHARACTER_MAI_HAN_AKAT = 0x0E31;
const char32_t THAI_CHARACTER_SARA_AA = 0x0E32;
const char32_t THAI_CHARACTER_SARA_AM = 0x0E33;
const char32_t THAI_CHARACTER_SARA_I = 0x0E34;
const char32_t THAI_CHARACTER_SARA_II = 0x0E35;
const char32_t THAI_CHARACTER_SARA_UE = 0x0E36;
const char32_t THAI_CHARACTER_SARA_UEE = 0x0E37;
const char32_t THAI_CHARACTER_SARA_U = 0x0E38;
const char32_t THAI_CHARACTER_SARA_UU = 0x0E39;
const char32_t THAI_CHARACTER_PHINTHU = 0x0E3A;
const char32_t THAI_CURRENCY_SYMBOL_BAHT = 0x0E3F;
const char32_t THAI_CHARACTER_SARA_E = 0x0E40;
const char32_t THAI_CHARACTER_SARA_AE = 0x0E41;
const char32_t THAI_CHARACTER_SARA_O = 0x0E42;
const char32_t THAI_CHARACTER_SARA_AI_MAIMUAN = 0x0E43;
const char32_t THAI_CHARACTER_SARA_AI_MAIMALAI = 0x0E44;
const char32_t THAI_CHARACTER_LAKKHANGYAO = 0x0E45;
const char32_t THAI_CHARACTER_MAIYAMOK = 0x0E46;
const char32_t THAI_CHARACTER_MAITAIKHU = 0x0E47;
const char32_t THAI_CHARACTER_MAI_EK = 0x0E48;
const char32_t THAI_CHARACTER_MAI_THO = 0x0E49;
const char32_t THAI_CHARACTER_MAI_TRI = 0x0E4A;
const char32_t THAI_CHARACTER_MAI_CHATTAWA = 0x0E4B;
const char32_t THAI_CHARACTER_THANTHAKHAT = 0x0E4C;
const char32_t THAI_CHARACTER_NIKHAHIT = 0x0E4D;
const char32_t THAI_CHARACTER_YAMAKKAN = 0x0E4E;
const char32_t THAI_CHARACTER_FONGMAN = 0x0E4F;
const char32_t THAI_DIGIT_ZERO = 0x0E50;
const char32_t THAI_DIGIT_ONE = 0x0E51;
const char32_t THAI_DIGIT_TWO = 0x0E52;
const char32_t THAI_DIGIT_THREE = 0x0E53;
const char32_t THAI_DIGIT_FOUR = 0x0E54;
const char32_t THAI_DIGIT_FIVE = 0x0E55;
const char32_t THAI_DIGIT_SIX = 0x0E56;
const char32_t THAI_DIGIT_SEVEN = 0x0E57;
const char32_t THAI_DIGIT_EIGHT = 0x0E58;
const char32_t THAI_DIGIT_NINE = 0x0E59;
const char32_t THAI_CHARACTER_ANGKHANKHU = 0x0E5A;
const char32_t THAI_CHARACTER_KHOMUT = 0x0E5B;
const char32_t LAO_LETTER_KO = 0x0E81;
const char32_t LAO_LETTER_KHO_SUNG = 0x0E82;
const char32_t LAO_LETTER_KHO_TAM = 0x0E84;
const char32_t LAO_LETTER_PALI_GHA = 0x0E86;
const char32_t LAO_LETTER_NGO = 0x0E87;
const char32_t LAO_LETTER_CO = 0x0E88;
const char32_t LAO_LETTER_PALI_CHA = 0x0E89;
const char32_t LAO_LETTER_SO_TAM = 0x0E8A;
const char32_t LAO_LETTER_PALI_JHA = 0x0E8C;
const char32_t LAO_LETTER_NYO = 0x0E8D;
const char32_t LAO_LETTER_PALI_NYA = 0x0E8E;
const char32_t LAO_LETTER_PALI_TTA = 0x0E8F;
const char32_t LAO_LETTER_PALI_TTHA = 0x0E90;
const char32_t LAO_LETTER_PALI_DDA = 0x0E91;
const char32_t LAO_LETTER_PALI_DDHA = 0x0E92;
const char32_t LAO_LETTER_PALI_NNA = 0x0E93;
const char32_t LAO_LETTER_DO = 0x0E94;
const char32_t LAO_LETTER_TO = 0x0E95;
const char32_t LAO_LETTER_THO_SUNG = 0x0E96;
const char32_t LAO_LETTER_THO_TAM = 0x0E97;
const char32_t LAO_LETTER_PALI_DHA = 0x0E98;
const char32_t LAO_LETTER_NO = 0x0E99;
const char32_t LAO_LETTER_BO = 0x0E9A;
const char32_t LAO_LETTER_PO = 0x0E9B;
const char32_t LAO_LETTER_PHO_SUNG = 0x0E9C;
const char32_t LAO_LETTER_FO_TAM = 0x0E9D;
const char32_t LAO_LETTER_PHO_TAM = 0x0E9E;
const char32_t LAO_LETTER_FO_SUNG = 0x0E9F;
const char32_t LAO_LETTER_PALI_BHA = 0x0EA0;
const char32_t LAO_LETTER_MO = 0x0EA1;
const char32_t LAO_LETTER_YO = 0x0EA2;
const char32_t LAO_LETTER_LO_LING = 0x0EA3;
const char32_t LAO_LETTER_LO_LOOT = 0x0EA5;
const char32_t LAO_LETTER_WO = 0x0EA7;
const char32_t LAO_LETTER_SANSKRIT_SHA = 0x0EA8;
const char32_t LAO_LETTER_SANSKRIT_SSA = 0x0EA9;
const char32_t LAO_LETTER_SO_SUNG = 0x0EAA;
const char32_t LAO_LETTER_HO_SUNG = 0x0EAB;
const char32_t LAO_LETTER_PALI_LLA = 0x0EAC;
const char32_t LAO_LETTER_O = 0x0EAD;
const char32_t LAO_LETTER_HO_TAM = 0x0EAE;
const char32_t LAO_ELLIPSIS = 0x0EAF;
const char32_t LAO_VOWEL_SIGN_A = 0x0EB0;
const char32_t LAO_VOWEL_SIGN_MAI_KAN = 0x0EB1;
const char32_t LAO_VOWEL_SIGN_AA = 0x0EB2;
const char32_t LAO_VOWEL_SIGN_AM = 0x0EB3;
const char32_t LAO_VOWEL_SIGN_I = 0x0EB4;
const char32_t LAO_VOWEL_SIGN_II = 0x0EB5;
const char32_t LAO_VOWEL_SIGN_Y = 0x0EB6;
const char32_t LAO_VOWEL_SIGN_YY = 0x0EB7;
const char32_t LAO_VOWEL_SIGN_U = 0x0EB8;
const char32_t LAO_VOWEL_SIGN_UU = 0x0EB9;
const char32_t LAO_SIGN_PALI_VIRAMA = 0x0EBA;
const char32_t LAO_VOWEL_SIGN_MAI_KON = 0x0EBB;
const char32_t LAO_SEMIVOWEL_SIGN_LO = 0x0EBC;
const char32_t LAO_SEMIVOWEL_SIGN_NYO = 0x0EBD;
const char32_t LAO_VOWEL_SIGN_E = 0x0EC0;
const char32_t LAO_VOWEL_SIGN_EI = 0x0EC1;
const char32_t LAO_VOWEL_SIGN_O = 0x0EC2;
const char32_t LAO_VOWEL_SIGN_AY = 0x0EC3;
const char32_t LAO_VOWEL_SIGN_AI = 0x0EC4;
const char32_t LAO_KO_LA = 0x0EC6;
const char32_t LAO_TONE_MAI_EK = 0x0EC8;
const char32_t LAO_TONE_MAI_THO = 0x0EC9;
const char32_t LAO_TONE_MAI_TI = 0x0ECA;
const char32_t LAO_TONE_MAI_CATAWA = 0x0ECB;
const char32_t LAO_CANCELLATION_MARK = 0x0ECC;
const char32_t LAO_NIGGAHITA = 0x0ECD;
const char32_t LAO_DIGIT_ZERO = 0x0ED0;
const char32_t LAO_DIGIT_ONE = 0x0ED1;
const char32_t LAO_DIGIT_TWO = 0x0ED2;
const char32_t LAO_DIGIT_THREE = 0x0ED3;
const char32_t LAO_DIGIT_FOUR = 0x0ED4;
const char32_t LAO_DIGIT_FIVE = 0x0ED5;
const char32_t LAO_DIGIT_SIX = 0x0ED6;
const char32_t LAO_DIGIT_SEVEN = 0x0ED7;
const char32_t LAO_DIGIT_EIGHT = 0x0ED8;
const char32_t LAO_DIGIT_NINE = 0x0ED9;
const char32_t LAO_HO_NO = 0x0EDC;
const char32_t LAO_HO_MO = 0x0EDD;
const char32_t LAO_LETTER_KHMU_GO = 0x0EDE;
const char32_t LAO_LETTER_KHMU_NYO = 0x0EDF;
const char32_t TIBETAN_SYLLABLE_OM = 0x0F00;
const char32_t TIBETAN_MARK_GTER_YIG_MGO_TRUNCATED_A = 0x0F01;
const char32_t TIBETAN_MARK_GTER_YIG_MGO__UM_RNAM_BCAD_MA = 0x0F02;
const char32_t TIBETAN_MARK_GTER_YIG_MGO__UM_GTER_TSHEG_MA = 0x0F03;
const char32_t TIBETAN_MARK_INITIAL_YIG_MGO_MDUN_MA = 0x0F04;
const char32_t TIBETAN_MARK_CLOSING_YIG_MGO_SGAB_MA = 0x0F05;
const char32_t TIBETAN_MARK_CARET_YIG_MGO_PHUR_SHAD_MA = 0x0F06;
const char32_t TIBETAN_MARK_YIG_MGO_TSHEG_SHAD_MA = 0x0F07;
const char32_t TIBETAN_MARK_SBRUL_SHAD = 0x0F08;
const char32_t TIBETAN_MARK_BSKUR_YIG_MGO = 0x0F09;
const char32_t TIBETAN_MARK_BKA__SHOG_YIG_MGO = 0x0F0A;
const char32_t TIBETAN_MARK_INTERSYLLABIC_TSHEG = 0x0F0B;
const char32_t TIBETAN_MARK_DELIMITER_TSHEG_BSTAR = 0x0F0C;
const char32_t TIBETAN_MARK_SHAD = 0x0F0D;
const char32_t TIBETAN_MARK_NYIS_SHAD = 0x0F0E;
const char32_t TIBETAN_MARK_TSHEG_SHAD = 0x0F0F;
const char32_t TIBETAN_MARK_NYIS_TSHEG_SHAD = 0x0F10;
const char32_t TIBETAN_MARK_RIN_CHEN_SPUNGS_SHAD = 0x0F11;
const char32_t TIBETAN_MARK_RGYA_GRAM_SHAD = 0x0F12;
const char32_t TIBETAN_MARK_CARET__DZUD_RTAGS_ME_LONG_CAN = 0x0F13;
const char32_t TIBETAN_MARK_GTER_TSHEG = 0x0F14;
const char32_t TIBETAN_LOGOTYPE_SIGN_CHAD_RTAGS = 0x0F15;
const char32_t TIBETAN_LOGOTYPE_SIGN_LHAG_RTAGS = 0x0F16;
const char32_t TIBETAN_ASTROLOGICAL_SIGN_SGRA_GCAN__CHAR_RTAGS = 0x0F17;
const char32_t TIBETAN_ASTROLOGICAL_SIGN__KHYUD_PA = 0x0F18;
const char32_t TIBETAN_ASTROLOGICAL_SIGN_SDONG_TSHUGS = 0x0F19;
const char32_t TIBETAN_SIGN_RDEL_DKAR_GCIG = 0x0F1A;
const char32_t TIBETAN_SIGN_RDEL_DKAR_GNYIS = 0x0F1B;
const char32_t TIBETAN_SIGN_RDEL_DKAR_GSUM = 0x0F1C;
const char32_t TIBETAN_SIGN_RDEL_NAG_GCIG = 0x0F1D;
const char32_t TIBETAN_SIGN_RDEL_NAG_GNYIS = 0x0F1E;
const char32_t TIBETAN_SIGN_RDEL_DKAR_RDEL_NAG = 0x0F1F;
const char32_t TIBETAN_DIGIT_ZERO = 0x0F20;
const char32_t TIBETAN_DIGIT_ONE = 0x0F21;
const char32_t TIBETAN_DIGIT_TWO = 0x0F22;
const char32_t TIBETAN_DIGIT_THREE = 0x0F23;
const char32_t TIBETAN_DIGIT_FOUR = 0x0F24;
const char32_t TIBETAN_DIGIT_FIVE = 0x0F25;
const char32_t TIBETAN_DIGIT_SIX = 0x0F26;
const char32_t TIBETAN_DIGIT_SEVEN = 0x0F27;
const char32_t TIBETAN_DIGIT_EIGHT = 0x0F28;
const char32_t TIBETAN_DIGIT_NINE = 0x0F29;
const char32_t TIBETAN_DIGIT_HALF_ONE = 0x0F2A;
const char32_t TIBETAN_DIGIT_HALF_TWO = 0x0F2B;
const char32_t TIBETAN_DIGIT_HALF_THREE = 0x0F2C;
const char32_t TIBETAN_DIGIT_HALF_FOUR = 0x0F2D;
const char32_t TIBETAN_DIGIT_HALF_FIVE = 0x0F2E;
const char32_t TIBETAN_DIGIT_HALF_SIX = 0x0F2F;
const char32_t TIBETAN_DIGIT_HALF_SEVEN = 0x0F30;
const char32_t TIBETAN_DIGIT_HALF_EIGHT = 0x0F31;
const char32_t TIBETAN_DIGIT_HALF_NINE = 0x0F32;
const char32_t TIBETAN_DIGIT_HALF_ZERO = 0x0F33;
const char32_t TIBETAN_MARK_BSDUS_RTAGS = 0x0F34;
const char32_t TIBETAN_MARK_NGAS_BZUNG_NYI_ZLA = 0x0F35;
const char32_t TIBETAN_MARK_CARET__DZUD_RTAGS_BZHI_MIG_CAN = 0x0F36;
const char32_t TIBETAN_MARK_NGAS_BZUNG_SGOR_RTAGS = 0x0F37;
const char32_t TIBETAN_MARK_CHE_MGO = 0x0F38;
const char32_t TIBETAN_MARK_TSA__PHRU = 0x0F39;
const char32_t TIBETAN_MARK_GUG_RTAGS_GYON = 0x0F3A;
const char32_t TIBETAN_MARK_GUG_RTAGS_GYAS = 0x0F3B;
const char32_t TIBETAN_MARK_ANG_KHANG_GYON = 0x0F3C;
const char32_t TIBETAN_MARK_ANG_KHANG_GYAS = 0x0F3D;
const char32_t TIBETAN_SIGN_YAR_TSHES = 0x0F3E;
const char32_t TIBETAN_SIGN_MAR_TSHES = 0x0F3F;
const char32_t TIBETAN_LETTER_KA = 0x0F40;
const char32_t TIBETAN_LETTER_KHA = 0x0F41;
const char32_t TIBETAN_LETTER_GA = 0x0F42;
const char32_t TIBETAN_LETTER_GHA = 0x0F43;
const char32_t TIBETAN_LETTER_NGA = 0x0F44;
const char32_t TIBETAN_LETTER_CA = 0x0F45;
const char32_t TIBETAN_LETTER_CHA = 0x0F46;
const char32_t TIBETAN_LETTER_JA = 0x0F47;
const char32_t TIBETAN_LETTER_NYA = 0x0F49;
const char32_t TIBETAN_LETTER_TTA = 0x0F4A;
const char32_t TIBETAN_LETTER_TTHA = 0x0F4B;
const char32_t TIBETAN_LETTER_DDA = 0x0F4C;
const char32_t TIBETAN_LETTER_DDHA = 0x0F4D;
const char32_t TIBETAN_LETTER_NNA = 0x0F4E;
const char32_t TIBETAN_LETTER_TA = 0x0F4F;
const char32_t TIBETAN_LETTER_THA = 0x0F50;
const char32_t TIBETAN_LETTER_DA = 0x0F51;
const char32_t TIBETAN_LETTER_DHA = 0x0F52;
const char32_t TIBETAN_LETTER_NA = 0x0F53;
const char32_t TIBETAN_LETTER_PA = 0x0F54;
const char32_t TIBETAN_LETTER_PHA = 0x0F55;
const char32_t TIBETAN_LETTER_BA = 0x0F56;
const char32_t TIBETAN_LETTER_BHA = 0x0F57;
const char32_t TIBETAN_LETTER_MA = 0x0F58;
const char32_t TIBETAN_LETTER_TSA = 0x0F59;
const char32_t TIBETAN_LETTER_TSHA = 0x0F5A;
const char32_t TIBETAN_LETTER_DZA = 0x0F5B;
const char32_t TIBETAN_LETTER_DZHA = 0x0F5C;
const char32_t TIBETAN_LETTER_WA = 0x0F5D;
const char32_t TIBETAN_LETTER_ZHA = 0x0F5E;
const char32_t TIBETAN_LETTER_ZA = 0x0F5F;
const char32_t TIBETAN_LETTER__A = 0x0F60;
const char32_t TIBETAN_LETTER_YA = 0x0F61;
const char32_t TIBETAN_LETTER_RA = 0x0F62;
const char32_t TIBETAN_LETTER_LA = 0x0F63;
const char32_t TIBETAN_LETTER_SHA = 0x0F64;
const char32_t TIBETAN_LETTER_SSA = 0x0F65;
const char32_t TIBETAN_LETTER_SA = 0x0F66;
const char32_t TIBETAN_LETTER_HA = 0x0F67;
const char32_t TIBETAN_LETTER_A = 0x0F68;
const char32_t TIBETAN_LETTER_KSSA = 0x0F69;
const char32_t TIBETAN_LETTER_FIXED_FORM_RA = 0x0F6A;
const char32_t TIBETAN_LETTER_KKA = 0x0F6B;
const char32_t TIBETAN_LETTER_RRA = 0x0F6C;
const char32_t TIBETAN_VOWEL_SIGN_AA = 0x0F71;
const char32_t TIBETAN_VOWEL_SIGN_I = 0x0F72;
const char32_t TIBETAN_VOWEL_SIGN_II = 0x0F73;
const char32_t TIBETAN_VOWEL_SIGN_U = 0x0F74;
const char32_t TIBETAN_VOWEL_SIGN_UU = 0x0F75;
const char32_t TIBETAN_VOWEL_SIGN_VOCALIC_R = 0x0F76;
const char32_t TIBETAN_VOWEL_SIGN_VOCALIC_RR = 0x0F77;
const char32_t TIBETAN_VOWEL_SIGN_VOCALIC_L = 0x0F78;
const char32_t TIBETAN_VOWEL_SIGN_VOCALIC_LL = 0x0F79;
const char32_t TIBETAN_VOWEL_SIGN_E = 0x0F7A;
const char32_t TIBETAN_VOWEL_SIGN_EE = 0x0F7B;
const char32_t TIBETAN_VOWEL_SIGN_O = 0x0F7C;
const char32_t TIBETAN_VOWEL_SIGN_OO = 0x0F7D;
const char32_t TIBETAN_SIGN_RJES_SU_NGA_RO = 0x0F7E;
const char32_t TIBETAN_SIGN_RNAM_BCAD = 0x0F7F;
const char32_t TIBETAN_VOWEL_SIGN_REVERSED_I = 0x0F80;
const char32_t TIBETAN_VOWEL_SIGN_REVERSED_II = 0x0F81;
const char32_t TIBETAN_SIGN_NYI_ZLA_NAA_DA = 0x0F82;
const char32_t TIBETAN_SIGN_SNA_LDAN = 0x0F83;
const char32_t TIBETAN_MARK_HALANTA = 0x0F84;
const char32_t TIBETAN_MARK_PALUTA = 0x0F85;
const char32_t TIBETAN_SIGN_LCI_RTAGS = 0x0F86;
const char32_t TIBETAN_SIGN_YANG_RTAGS = 0x0F87;
const char32_t TIBETAN_SIGN_LCE_TSA_CAN = 0x0F88;
const char32_t TIBETAN_SIGN_MCHU_CAN = 0x0F89;
const char32_t TIBETAN_SIGN_GRU_CAN_RGYINGS = 0x0F8A;
const char32_t TIBETAN_SIGN_GRU_MED_RGYINGS = 0x0F8B;
const char32_t TIBETAN_SIGN_INVERTED_MCHU_CAN = 0x0F8C;
const char32_t TIBETAN_SUBJOINED_SIGN_LCE_TSA_CAN = 0x0F8D;
const char32_t TIBETAN_SUBJOINED_SIGN_MCHU_CAN = 0x0F8E;
const char32_t TIBETAN_SUBJOINED_SIGN_INVERTED_MCHU_CAN = 0x0F8F;
const char32_t TIBETAN_SUBJOINED_LETTER_KA = 0x0F90;
const char32_t TIBETAN_SUBJOINED_LETTER_KHA = 0x0F91;
const char32_t TIBETAN_SUBJOINED_LETTER_GA = 0x0F92;
const char32_t TIBETAN_SUBJOINED_LETTER_GHA = 0x0F93;
const char32_t TIBETAN_SUBJOINED_LETTER_NGA = 0x0F94;
const char32_t TIBETAN_SUBJOINED_LETTER_CA = 0x0F95;
const char32_t TIBETAN_SUBJOINED_LETTER_CHA = 0x0F96;
const char32_t TIBETAN_SUBJOINED_LETTER_JA = 0x0F97;
const char32_t TIBETAN_SUBJOINED_LETTER_NYA = 0x0F99;
const char32_t TIBETAN_SUBJOINED_LETTER_TTA = 0x0F9A;
const char32_t TIBETAN_SUBJOINED_LETTER_TTHA = 0x0F9B;
const char32_t TIBETAN_SUBJOINED_LETTER_DDA = 0x0F9C;
const char32_t TIBETAN_SUBJOINED_LETTER_DDHA = 0x0F9D;
const char32_t TIBETAN_SUBJOINED_LETTER_NNA = 0x0F9E;
const char32_t TIBETAN_SUBJOINED_LETTER_TA = 0x0F9F;
const char32_t TIBETAN_SUBJOINED_LETTER_THA = 0x0FA0;
const char32_t TIBETAN_SUBJOINED_LETTER_DA = 0x0FA1;
const char32_t TIBETAN_SUBJOINED_LETTER_DHA = 0x0FA2;
const char32_t TIBETAN_SUBJOINED_LETTER_NA = 0x0FA3;
const char32_t TIBETAN_SUBJOINED_LETTER_PA = 0x0FA4;
const char32_t TIBETAN_SUBJOINED_LETTER_PHA = 0x0FA5;
const char32_t TIBETAN_SUBJOINED_LETTER_BA = 0x0FA6;
const char32_t TIBETAN_SUBJOINED_LETTER_BHA = 0x0FA7;
const char32_t TIBETAN_SUBJOINED_LETTER_MA = 0x0FA8;
const char32_t TIBETAN_SUBJOINED_LETTER_TSA = 0x0FA9;
const char32_t TIBETAN_SUBJOINED_LETTER_TSHA = 0x0FAA;
const char32_t TIBETAN_SUBJOINED_LETTER_DZA = 0x0FAB;
const char32_t TIBETAN_SUBJOINED_LETTER_DZHA = 0x0FAC;
const char32_t TIBETAN_SUBJOINED_LETTER_WA = 0x0FAD;
const char32_t TIBETAN_SUBJOINED_LETTER_ZHA = 0x0FAE;
const char32_t TIBETAN_SUBJOINED_LETTER_ZA = 0x0FAF;
const char32_t TIBETAN_SUBJOINED_LETTER__A = 0x0FB0;
const char32_t TIBETAN_SUBJOINED_LETTER_YA = 0x0FB1;
const char32_t TIBETAN_SUBJOINED_LETTER_RA = 0x0FB2;
const char32_t TIBETAN_SUBJOINED_LETTER_LA = 0x0FB3;
const char32_t TIBETAN_SUBJOINED_LETTER_SHA = 0x0FB4;
const char32_t TIBETAN_SUBJOINED_LETTER_SSA = 0x0FB5;
const char32_t TIBETAN_SUBJOINED_LETTER_SA = 0x0FB6;
const char32_t TIBETAN_SUBJOINED_LETTER_HA = 0x0FB7;
const char32_t TIBETAN_SUBJOINED_LETTER_A = 0x0FB8;
const char32_t TIBETAN_SUBJOINED_LETTER_KSSA = 0x0FB9;
const char32_t TIBETAN_SUBJOINED_LETTER_FIXED_FORM_WA = 0x0FBA;
const char32_t TIBETAN_SUBJOINED_LETTER_FIXED_FORM_YA = 0x0FBB;
const char32_t TIBETAN_SUBJOINED_LETTER_FIXED_FORM_RA = 0x0FBC;
const char32_t TIBETAN_KU_RU_KHA = 0x0FBE;
const char32_t TIBETAN_KU_RU_KHA_BZHI_MIG_CAN = 0x0FBF;
const char32_t TIBETAN_CANTILLATION_SIGN_HEAVY_BEAT = 0x0FC0;
const char32_t TIBETAN_CANTILLATION_SIGN_LIGHT_BEAT = 0x0FC1;
const char32_t TIBETAN_CANTILLATION_SIGN_CANG_TE_U = 0x0FC2;
const char32_t TIBETAN_CANTILLATION_SIGN_SBUB__CHAL = 0x0FC3;
const char32_t TIBETAN_SYMBOL_DRIL_BU = 0x0FC4;
const char32_t TIBETAN_SYMBOL_RDO_RJE = 0x0FC5;
const char32_t TIBETAN_SYMBOL_PADMA_GDAN = 0x0FC6;
const char32_t TIBETAN_SYMBOL_RDO_RJE_RGYA_GRAM = 0x0FC7;
const char32_t TIBETAN_SYMBOL_PHUR_PA = 0x0FC8;
const char32_t TIBETAN_SYMBOL_NOR_BU = 0x0FC9;
const char32_t TIBETAN_SYMBOL_NOR_BU_NYIS__KHYIL = 0x0FCA;
const char32_t TIBETAN_SYMBOL_NOR_BU_GSUM__KHYIL = 0x0FCB;
const char32_t TIBETAN_SYMBOL_NOR_BU_BZHI__KHYIL = 0x0FCC;
const char32_t TIBETAN_SIGN_RDEL_NAG_RDEL_DKAR = 0x0FCE;
const char32_t TIBETAN_SIGN_RDEL_NAG_GSUM = 0x0FCF;
const char32_t TIBETAN_MARK_BSKA__SHOG_GI_MGO_RGYAN = 0x0FD0;
const char32_t TIBETAN_MARK_MNYAM_YIG_GI_MGO_RGYAN = 0x0FD1;
const char32_t TIBETAN_MARK_NYIS_TSHEG = 0x0FD2;
const char32_t TIBETAN_MARK_INITIAL_BRDA_RNYING_YIG_MGO_MDUN_MA = 0x0FD3;
const char32_t TIBETAN_MARK_CLOSING_BRDA_RNYING_YIG_MGO_SGAB_MA = 0x0FD4;
const char32_t RIGHT_FACING_SVASTI_SIGN = 0x0FD5;
const char32_t LEFT_FACING_SVASTI_SIGN = 0x0FD6;
const char32_t RIGHT_FACING_SVASTI_SIGN_WITH_DOTS = 0x0FD7;
const char32_t LEFT_FACING_SVASTI_SIGN_WITH_DOTS = 0x0FD8;
const char32_t TIBETAN_MARK_LEADING_MCHAN_RTAGS = 0x0FD9;
const char32_t TIBETAN_MARK_TRAILING_MCHAN_RTAGS = 0x0FDA;
const char32_t MYANMAR_LETTER_KA = 0x1000;
const char32_t MYANMAR_LETTER_KHA = 0x1001;
const char32_t MYANMAR_LETTER_GA = 0x1002;
const char32_t MYANMAR_LETTER_GHA = 0x1003;
const char32_t MYANMAR_LETTER_NGA = 0x1004;
const char32_t MYANMAR_LETTER_CA = 0x1005;
const char32_t MYANMAR_LETTER_CHA = 0x1006;
const char32_t MYANMAR_LETTER_JA = 0x1007;
const char32_t MYANMAR_LETTER_JHA = 0x1008;
const char32_t MYANMAR_LETTER_NYA = 0x1009;
const char32_t MYANMAR_LETTER_NNYA = 0x100A;
const char32_t MYANMAR_LETTER_TTA = 0x100B;
const char32_t MYANMAR_LETTER_TTHA = 0x100C;
const char32_t MYANMAR_LETTER_DDA = 0x100D;
const char32_t MYANMAR_LETTER_DDHA = 0x100E;
const char32_t MYANMAR_LETTER_NNA = 0x100F;
const char32_t MYANMAR_LETTER_TA = 0x1010;
const char32_t MYANMAR_LETTER_THA = 0x1011;
const char32_t MYANMAR_LETTER_DA = 0x1012;
const char32_t MYANMAR_LETTER_DHA = 0x1013;
const char32_t MYANMAR_LETTER_NA = 0x1014;
const char32_t MYANMAR_LETTER_PA = 0x1015;
const char32_t MYANMAR_LETTER_PHA = 0x1016;
const char32_t MYANMAR_LETTER_BA = 0x1017;
const char32_t MYANMAR_LETTER_BHA = 0x1018;
const char32_t MYANMAR_LETTER_MA = 0x1019;
const char32_t MYANMAR_LETTER_YA = 0x101A;
const char32_t MYANMAR_LETTER_RA = 0x101B;
const char32_t MYANMAR_LETTER_LA = 0x101C;
const char32_t MYANMAR_LETTER_WA = 0x101D;
const char32_t MYANMAR_LETTER_SA = 0x101E;
const char32_t MYANMAR_LETTER_HA = 0x101F;
const char32_t MYANMAR_LETTER_LLA = 0x1020;
const char32_t MYANMAR_LETTER_A = 0x1021;
const char32_t MYANMAR_LETTER_SHAN_A = 0x1022;
const char32_t MYANMAR_LETTER_I = 0x1023;
const char32_t MYANMAR_LETTER_II = 0x1024;
const char32_t MYANMAR_LETTER_U = 0x1025;
const char32_t MYANMAR_LETTER_UU = 0x1026;
const char32_t MYANMAR_LETTER_E = 0x1027;
const char32_t MYANMAR_LETTER_MON_E = 0x1028;
const char32_t MYANMAR_LETTER_O = 0x1029;
const char32_t MYANMAR_LETTER_AU = 0x102A;
const char32_t MYANMAR_VOWEL_SIGN_TALL_AA = 0x102B;
const char32_t MYANMAR_VOWEL_SIGN_AA = 0x102C;
const char32_t MYANMAR_VOWEL_SIGN_I = 0x102D;
const char32_t MYANMAR_VOWEL_SIGN_II = 0x102E;
const char32_t MYANMAR_VOWEL_SIGN_U = 0x102F;
const char32_t MYANMAR_VOWEL_SIGN_UU = 0x1030;
const char32_t MYANMAR_VOWEL_SIGN_E = 0x1031;
const char32_t MYANMAR_VOWEL_SIGN_AI = 0x1032;
const char32_t MYANMAR_VOWEL_SIGN_MON_II = 0x1033;
const char32_t MYANMAR_VOWEL_SIGN_MON_O = 0x1034;
const char32_t MYANMAR_VOWEL_SIGN_E_ABOVE = 0x1035;
const char32_t MYANMAR_SIGN_ANUSVARA = 0x1036;
const char32_t MYANMAR_SIGN_DOT_BELOW = 0x1037;
const char32_t MYANMAR_SIGN_VISARGA = 0x1038;
const char32_t MYANMAR_SIGN_VIRAMA = 0x1039;
const char32_t MYANMAR_SIGN_ASAT = 0x103A;
const char32_t MYANMAR_CONSONANT_SIGN_MEDIAL_YA = 0x103B;
const char32_t MYANMAR_CONSONANT_SIGN_MEDIAL_RA = 0x103C;
const char32_t MYANMAR_CONSONANT_SIGN_MEDIAL_WA = 0x103D;
const char32_t MYANMAR_CONSONANT_SIGN_MEDIAL_HA = 0x103E;
const char32_t MYANMAR_LETTER_GREAT_SA = 0x103F;
const char32_t MYANMAR_DIGIT_ZERO = 0x1040;
const char32_t MYANMAR_DIGIT_ONE = 0x1041;
const char32_t MYANMAR_DIGIT_TWO = 0x1042;
const char32_t MYANMAR_DIGIT_THREE = 0x1043;
const char32_t MYANMAR_DIGIT_FOUR = 0x1044;
const char32_t MYANMAR_DIGIT_FIVE = 0x1045;
const char32_t MYANMAR_DIGIT_SIX = 0x1046;
const char32_t MYANMAR_DIGIT_SEVEN = 0x1047;
const char32_t MYANMAR_DIGIT_EIGHT = 0x1048;
const char32_t MYANMAR_DIGIT_NINE = 0x1049;
const char32_t MYANMAR_SIGN_LITTLE_SECTION = 0x104A;
const char32_t MYANMAR_SIGN_SECTION = 0x104B;
const char32_t MYANMAR_SYMBOL_LOCATIVE = 0x104C;
const char32_t MYANMAR_SYMBOL_COMPLETED = 0x104D;
const char32_t MYANMAR_SYMBOL_AFOREMENTIONED = 0x104E;
const char32_t MYANMAR_SYMBOL_GENITIVE = 0x104F;
const char32_t MYANMAR_LETTER_SHA = 0x1050;
const char32_t MYANMAR_LETTER_SSA = 0x1051;
const char32_t MYANMAR_LETTER_VOCALIC_R = 0x1052;
const char32_t MYANMAR_LETTER_VOCALIC_RR = 0x1053;
const char32_t MYANMAR_LETTER_VOCALIC_L = 0x1054;
const char32_t MYANMAR_LETTER_VOCALIC_LL = 0x1055;
const char32_t MYANMAR_VOWEL_SIGN_VOCALIC_R = 0x1056;
const char32_t MYANMAR_VOWEL_SIGN_VOCALIC_RR = 0x1057;
const char32_t MYANMAR_VOWEL_SIGN_VOCALIC_L = 0x1058;
const char32_t MYANMAR_VOWEL_SIGN_VOCALIC_LL = 0x1059;
const char32_t MYANMAR_LETTER_MON_NGA = 0x105A;
const char32_t MYANMAR_LETTER_MON_JHA = 0x105B;
const char32_t MYANMAR_LETTER_MON_BBA = 0x105C;
const char32_t MYANMAR_LETTER_MON_BBE = 0x105D;
const char32_t MYANMAR_CONSONANT_SIGN_MON_MEDIAL_NA = 0x105E;
const char32_t MYANMAR_CONSONANT_SIGN_MON_MEDIAL_MA = 0x105F;
const char32_t MYANMAR_CONSONANT_SIGN_MON_MEDIAL_LA = 0x1060;
const char32_t MYANMAR_LETTER_SGAW_KAREN_SHA = 0x1061;
const char32_t MYANMAR_VOWEL_SIGN_SGAW_KAREN_EU = 0x1062;
const char32_t MYANMAR_TONE_MARK_SGAW_KAREN_HATHI = 0x1063;
const char32_t MYANMAR_TONE_MARK_SGAW_KAREN_KE_PHO = 0x1064;
const char32_t MYANMAR_LETTER_WESTERN_PWO_KAREN_THA = 0x1065;
const char32_t MYANMAR_LETTER_WESTERN_PWO_KAREN_PWA = 0x1066;
const char32_t MYANMAR_VOWEL_SIGN_WESTERN_PWO_KAREN_EU = 0x1067;
const char32_t MYANMAR_VOWEL_SIGN_WESTERN_PWO_KAREN_UE = 0x1068;
const char32_t MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_1 = 0x1069;
const char32_t MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_2 = 0x106A;
const char32_t MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_3 = 0x106B;
const char32_t MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_4 = 0x106C;
const char32_t MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_5 = 0x106D;
const char32_t MYANMAR_LETTER_EASTERN_PWO_KAREN_NNA = 0x106E;
const char32_t MYANMAR_LETTER_EASTERN_PWO_KAREN_YWA = 0x106F;
const char32_t MYANMAR_LETTER_EASTERN_PWO_KAREN_GHWA = 0x1070;
const char32_t MYANMAR_VOWEL_SIGN_GEBA_KAREN_I = 0x1071;
const char32_t MYANMAR_VOWEL_SIGN_KAYAH_OE = 0x1072;
const char32_t MYANMAR_VOWEL_SIGN_KAYAH_U = 0x1073;
const char32_t MYANMAR_VOWEL_SIGN_KAYAH_EE = 0x1074;
const char32_t MYANMAR_LETTER_SHAN_KA = 0x1075;
const char32_t MYANMAR_LETTER_SHAN_KHA = 0x1076;
const char32_t MYANMAR_LETTER_SHAN_GA = 0x1077;
const char32_t MYANMAR_LETTER_SHAN_CA = 0x1078;
const char32_t MYANMAR_LETTER_SHAN_ZA = 0x1079;
const char32_t MYANMAR_LETTER_SHAN_NYA = 0x107A;
const char32_t MYANMAR_LETTER_SHAN_DA = 0x107B;
const char32_t MYANMAR_LETTER_SHAN_NA = 0x107C;
const char32_t MYANMAR_LETTER_SHAN_PHA = 0x107D;
const char32_t MYANMAR_LETTER_SHAN_FA = 0x107E;
const char32_t MYANMAR_LETTER_SHAN_BA = 0x107F;
const char32_t MYANMAR_LETTER_SHAN_THA = 0x1080;
const char32_t MYANMAR_LETTER_SHAN_HA = 0x1081;
const char32_t MYANMAR_CONSONANT_SIGN_SHAN_MEDIAL_WA = 0x1082;
const char32_t MYANMAR_VOWEL_SIGN_SHAN_AA = 0x1083;
const char32_t MYANMAR_VOWEL_SIGN_SHAN_E = 0x1084;
const char32_t MYANMAR_VOWEL_SIGN_SHAN_E_ABOVE = 0x1085;
const char32_t MYANMAR_VOWEL_SIGN_SHAN_FINAL_Y = 0x1086;
const char32_t MYANMAR_SIGN_SHAN_TONE_2 = 0x1087;
const char32_t MYANMAR_SIGN_SHAN_TONE_3 = 0x1088;
const char32_t MYANMAR_SIGN_SHAN_TONE_5 = 0x1089;
const char32_t MYANMAR_SIGN_SHAN_TONE_6 = 0x108A;
const char32_t MYANMAR_SIGN_SHAN_COUNCIL_TONE_2 = 0x108B;
const char32_t MYANMAR_SIGN_SHAN_COUNCIL_TONE_3 = 0x108C;
const char32_t MYANMAR_SIGN_SHAN_COUNCIL_EMPHATIC_TONE = 0x108D;
const char32_t MYANMAR_LETTER_RUMAI_PALAUNG_FA = 0x108E;
const char32_t MYANMAR_SIGN_RUMAI_PALAUNG_TONE_5 = 0x108F;
const char32_t MYANMAR_SHAN_DIGIT_ZERO = 0x1090;
const char32_t MYANMAR_SHAN_DIGIT_ONE = 0x1091;
const char32_t MYANMAR_SHAN_DIGIT_TWO = 0x1092;
const char32_t MYANMAR_SHAN_DIGIT_THREE = 0x1093;
const char32_t MYANMAR_SHAN_DIGIT_FOUR = 0x1094;
const char32_t MYANMAR_SHAN_DIGIT_FIVE = 0x1095;
const char32_t MYANMAR_SHAN_DIGIT_SIX = 0x1096;
const char32_t MYANMAR_SHAN_DIGIT_SEVEN = 0x1097;
const char32_t MYANMAR_SHAN_DIGIT_EIGHT = 0x1098;
const char32_t MYANMAR_SHAN_DIGIT_NINE = 0x1099;
const char32_t MYANMAR_SIGN_KHAMTI_TONE_1 = 0x109A;
const char32_t MYANMAR_SIGN_KHAMTI_TONE_3 = 0x109B;
const char32_t MYANMAR_VOWEL_SIGN_AITON_A = 0x109C;
const char32_t MYANMAR_VOWEL_SIGN_AITON_AI = 0x109D;
const char32_t MYANMAR_SYMBOL_SHAN_ONE = 0x109E;
const char32_t MYANMAR_SYMBOL_SHAN_EXCLAMATION = 0x109F;
const char32_t GEORGIAN_CAPITAL_LETTER_AN = 0x10A0;
const char32_t GEORGIAN_CAPITAL_LETTER_BAN = 0x10A1;
const char32_t GEORGIAN_CAPITAL_LETTER_GAN = 0x10A2;
const char32_t GEORGIAN_CAPITAL_LETTER_DON = 0x10A3;
const char32_t GEORGIAN_CAPITAL_LETTER_EN = 0x10A4;
const char32_t GEORGIAN_CAPITAL_LETTER_VIN = 0x10A5;
const char32_t GEORGIAN_CAPITAL_LETTER_ZEN = 0x10A6;
const char32_t GEORGIAN_CAPITAL_LETTER_TAN = 0x10A7;
const char32_t GEORGIAN_CAPITAL_LETTER_IN = 0x10A8;
const char32_t GEORGIAN_CAPITAL_LETTER_KAN = 0x10A9;
const char32_t GEORGIAN_CAPITAL_LETTER_LAS = 0x10AA;
const char32_t GEORGIAN_CAPITAL_LETTER_MAN = 0x10AB;
const char32_t GEORGIAN_CAPITAL_LETTER_NAR = 0x10AC;
const char32_t GEORGIAN_CAPITAL_LETTER_ON = 0x10AD;
const char32_t GEORGIAN_CAPITAL_LETTER_PAR = 0x10AE;
const char32_t GEORGIAN_CAPITAL_LETTER_ZHAR = 0x10AF;
const char32_t GEORGIAN_CAPITAL_LETTER_RAE = 0x10B0;
const char32_t GEORGIAN_CAPITAL_LETTER_SAN = 0x10B1;
const char32_t GEORGIAN_CAPITAL_LETTER_TAR = 0x10B2;
const char32_t GEORGIAN_CAPITAL_LETTER_UN = 0x10B3;
const char32_t GEORGIAN_CAPITAL_LETTER_PHAR = 0x10B4;
const char32_t GEORGIAN_CAPITAL_LETTER_KHAR = 0x10B5;
const char32_t GEORGIAN_CAPITAL_LETTER_GHAN = 0x10B6;
const char32_t GEORGIAN_CAPITAL_LETTER_QAR = 0x10B7;
const char32_t GEORGIAN_CAPITAL_LETTER_SHIN = 0x10B8;
const char32_t GEORGIAN_CAPITAL_LETTER_CHIN = 0x10B9;
const char32_t GEORGIAN_CAPITAL_LETTER_CAN = 0x10BA;
const char32_t GEORGIAN_CAPITAL_LETTER_JIL = 0x10BB;
const char32_t GEORGIAN_CAPITAL_LETTER_CIL = 0x10BC;
const char32_t GEORGIAN_CAPITAL_LETTER_CHAR = 0x10BD;
const char32_t GEORGIAN_CAPITAL_LETTER_XAN = 0x10BE;
const char32_t GEORGIAN_CAPITAL_LETTER_JHAN = 0x10BF;
const char32_t GEORGIAN_CAPITAL_LETTER_HAE = 0x10C0;
const char32_t GEORGIAN_CAPITAL_LETTER_HE = 0x10C1;
const char32_t GEORGIAN_CAPITAL_LETTER_HIE = 0x10C2;
const char32_t GEORGIAN_CAPITAL_LETTER_WE = 0x10C3;
const char32_t GEORGIAN_CAPITAL_LETTER_HAR = 0x10C4;
const char32_t GEORGIAN_CAPITAL_LETTER_HOE = 0x10C5;
const char32_t GEORGIAN_CAPITAL_LETTER_YN = 0x10C7;
const char32_t GEORGIAN_CAPITAL_LETTER_AEN = 0x10CD;
const char32_t GEORGIAN_LETTER_AN = 0x10D0;
const char32_t GEORGIAN_LETTER_BAN = 0x10D1;
const char32_t GEORGIAN_LETTER_GAN = 0x10D2;
const char32_t GEORGIAN_LETTER_DON = 0x10D3;
const char32_t GEORGIAN_LETTER_EN = 0x10D4;
const char32_t GEORGIAN_LETTER_VIN = 0x10D5;
const char32_t GEORGIAN_LETTER_ZEN = 0x10D6;
const char32_t GEORGIAN_LETTER_TAN = 0x10D7;
const char32_t GEORGIAN_LETTER_IN = 0x10D8;
const char32_t GEORGIAN_LETTER_KAN = 0x10D9;
const char32_t GEORGIAN_LETTER_LAS = 0x10DA;
const char32_t GEORGIAN_LETTER_MAN = 0x10DB;
const char32_t GEORGIAN_LETTER_NAR = 0x10DC;
const char32_t GEORGIAN_LETTER_ON = 0x10DD;
const char32_t GEORGIAN_LETTER_PAR = 0x10DE;
const char32_t GEORGIAN_LETTER_ZHAR = 0x10DF;
const char32_t GEORGIAN_LETTER_RAE = 0x10E0;
const char32_t GEORGIAN_LETTER_SAN = 0x10E1;
const char32_t GEORGIAN_LETTER_TAR = 0x10E2;
const char32_t GEORGIAN_LETTER_UN = 0x10E3;
const char32_t GEORGIAN_LETTER_PHAR = 0x10E4;
const char32_t GEORGIAN_LETTER_KHAR = 0x10E5;
const char32_t GEORGIAN_LETTER_GHAN = 0x10E6;
const char32_t GEORGIAN_LETTER_QAR = 0x10E7;
const char32_t GEORGIAN_LETTER_SHIN = 0x10E8;
const char32_t GEORGIAN_LETTER_CHIN = 0x10E9;
const char32_t GEORGIAN_LETTER_CAN = 0x10EA;
const char32_t GEORGIAN_LETTER_JIL = 0x10EB;
const char32_t GEORGIAN_LETTER_CIL = 0x10EC;
const char32_t GEORGIAN_LETTER_CHAR = 0x10ED;
const char32_t GEORGIAN_LETTER_XAN = 0x10EE;
const char32_t GEORGIAN_LETTER_JHAN = 0x10EF;
const char32_t GEORGIAN_LETTER_HAE = 0x10F0;
const char32_t GEORGIAN_LETTER_HE = 0x10F1;
const char32_t GEORGIAN_LETTER_HIE = 0x10F2;
const char32_t GEORGIAN_LETTER_WE = 0x10F3;
const char32_t GEORGIAN_LETTER_HAR = 0x10F4;
const char32_t GEORGIAN_LETTER_HOE = 0x10F5;
const char32_t GEORGIAN_LETTER_FI = 0x10F6;
const char32_t GEORGIAN_LETTER_YN = 0x10F7;
const char32_t GEORGIAN_LETTER_ELIFI = 0x10F8;
const char32_t GEORGIAN_LETTER_TURNED_GAN = 0x10F9;
const char32_t GEORGIAN_LETTER_AIN = 0x10FA;
const char32_t GEORGIAN_PARAGRAPH_SEPARATOR = 0x10FB;
const char32_t MODIFIER_LETTER_GEORGIAN_NAR = 0x10FC;
const char32_t GEORGIAN_LETTER_AEN = 0x10FD;
const char32_t GEORGIAN_LETTER_HARD_SIGN = 0x10FE;
const char32_t GEORGIAN_LETTER_LABIAL_SIGN = 0x10FF;
const char32_t HANGUL_CHOSEONG_KIYEOK = 0x1100;
const char32_t HANGUL_CHOSEONG_SSANGKIYEOK = 0x1101;
const char32_t HANGUL_CHOSEONG_NIEUN = 0x1102;
const char32_t HANGUL_CHOSEONG_TIKEUT = 0x1103;
const char32_t HANGUL_CHOSEONG_SSANGTIKEUT = 0x1104;
const char32_t HANGUL_CHOSEONG_RIEUL = 0x1105;
const char32_t HANGUL_CHOSEONG_MIEUM = 0x1106;
const char32_t HANGUL_CHOSEONG_PIEUP = 0x1107;
const char32_t HANGUL_CHOSEONG_SSANGPIEUP = 0x1108;
const char32_t HANGUL_CHOSEONG_SIOS = 0x1109;
const char32_t HANGUL_CHOSEONG_SSANGSIOS = 0x110A;
const char32_t HANGUL_CHOSEONG_IEUNG = 0x110B;
const char32_t HANGUL_CHOSEONG_CIEUC = 0x110C;
const char32_t HANGUL_CHOSEONG_SSANGCIEUC = 0x110D;
const char32_t HANGUL_CHOSEONG_CHIEUCH = 0x110E;
const char32_t HANGUL_CHOSEONG_KHIEUKH = 0x110F;
const char32_t HANGUL_CHOSEONG_THIEUTH = 0x1110;
const char32_t HANGUL_CHOSEONG_PHIEUPH = 0x1111;
const char32_t HANGUL_CHOSEONG_HIEUH = 0x1112;
const char32_t HANGUL_CHOSEONG_NIEUN_KIYEOK = 0x1113;
const char32_t HANGUL_CHOSEONG_SSANGNIEUN = 0x1114;
const char32_t HANGUL_CHOSEONG_NIEUN_TIKEUT = 0x1115;
const char32_t HANGUL_CHOSEONG_NIEUN_PIEUP = 0x1116;
const char32_t HANGUL_CHOSEONG_TIKEUT_KIYEOK = 0x1117;
const char32_t HANGUL_CHOSEONG_RIEUL_NIEUN = 0x1118;
const char32_t HANGUL_CHOSEONG_SSANGRIEUL = 0x1119;
const char32_t HANGUL_CHOSEONG_RIEUL_HIEUH = 0x111A;
const char32_t HANGUL_CHOSEONG_KAPYEOUNRIEUL = 0x111B;
const char32_t HANGUL_CHOSEONG_MIEUM_PIEUP = 0x111C;
const char32_t HANGUL_CHOSEONG_KAPYEOUNMIEUM = 0x111D;
const char32_t HANGUL_CHOSEONG_PIEUP_KIYEOK = 0x111E;
const char32_t HANGUL_CHOSEONG_PIEUP_NIEUN = 0x111F;
const char32_t HANGUL_CHOSEONG_PIEUP_TIKEUT = 0x1120;
const char32_t HANGUL_CHOSEONG_PIEUP_SIOS = 0x1121;
const char32_t HANGUL_CHOSEONG_PIEUP_SIOS_KIYEOK = 0x1122;
const char32_t HANGUL_CHOSEONG_PIEUP_SIOS_TIKEUT = 0x1123;
const char32_t HANGUL_CHOSEONG_PIEUP_SIOS_PIEUP = 0x1124;
const char32_t HANGUL_CHOSEONG_PIEUP_SSANGSIOS = 0x1125;
const char32_t HANGUL_CHOSEONG_PIEUP_SIOS_CIEUC = 0x1126;
const char32_t HANGUL_CHOSEONG_PIEUP_CIEUC = 0x1127;
const char32_t HANGUL_CHOSEONG_PIEUP_CHIEUCH = 0x1128;
const char32_t HANGUL_CHOSEONG_PIEUP_THIEUTH = 0x1129;
const char32_t HANGUL_CHOSEONG_PIEUP_PHIEUPH = 0x112A;
const char32_t HANGUL_CHOSEONG_KAPYEOUNPIEUP = 0x112B;
const char32_t HANGUL_CHOSEONG_KAPYEOUNSSANGPIEUP = 0x112C;
const char32_t HANGUL_CHOSEONG_SIOS_KIYEOK = 0x112D;
const char32_t HANGUL_CHOSEONG_SIOS_NIEUN = 0x112E;
const char32_t HANGUL_CHOSEONG_SIOS_TIKEUT = 0x112F;
const char32_t HANGUL_CHOSEONG_SIOS_RIEUL = 0x1130;
const char32_t HANGUL_CHOSEONG_SIOS_MIEUM = 0x1131;
const char32_t HANGUL_CHOSEONG_SIOS_PIEUP = 0x1132;
const char32_t HANGUL_CHOSEONG_SIOS_PIEUP_KIYEOK = 0x1133;
const char32_t HANGUL_CHOSEONG_SIOS_SSANGSIOS = 0x1134;
const char32_t HANGUL_CHOSEONG_SIOS_IEUNG = 0x1135;
const char32_t HANGUL_CHOSEONG_SIOS_CIEUC = 0x1136;
const char32_t HANGUL_CHOSEONG_SIOS_CHIEUCH = 0x1137;
const char32_t HANGUL_CHOSEONG_SIOS_KHIEUKH = 0x1138;
const char32_t HANGUL_CHOSEONG_SIOS_THIEUTH = 0x1139;
const char32_t HANGUL_CHOSEONG_SIOS_PHIEUPH = 0x113A;
const char32_t HANGUL_CHOSEONG_SIOS_HIEUH = 0x113B;
const char32_t HANGUL_CHOSEONG_CHITUEUMSIOS = 0x113C;
const char32_t HANGUL_CHOSEONG_CHITUEUMSSANGSIOS = 0x113D;
const char32_t HANGUL_CHOSEONG_CEONGCHIEUMSIOS = 0x113E;
const char32_t HANGUL_CHOSEONG_CEONGCHIEUMSSANGSIOS = 0x113F;
const char32_t HANGUL_CHOSEONG_PANSIOS = 0x1140;
const char32_t HANGUL_CHOSEONG_IEUNG_KIYEOK = 0x1141;
const char32_t HANGUL_CHOSEONG_IEUNG_TIKEUT = 0x1142;
const char32_t HANGUL_CHOSEONG_IEUNG_MIEUM = 0x1143;
const char32_t HANGUL_CHOSEONG_IEUNG_PIEUP = 0x1144;
const char32_t HANGUL_CHOSEONG_IEUNG_SIOS = 0x1145;
const char32_t HANGUL_CHOSEONG_IEUNG_PANSIOS = 0x1146;
const char32_t HANGUL_CHOSEONG_SSANGIEUNG = 0x1147;
const char32_t HANGUL_CHOSEONG_IEUNG_CIEUC = 0x1148;
const char32_t HANGUL_CHOSEONG_IEUNG_CHIEUCH = 0x1149;
const char32_t HANGUL_CHOSEONG_IEUNG_THIEUTH = 0x114A;
const char32_t HANGUL_CHOSEONG_IEUNG_PHIEUPH = 0x114B;
const char32_t HANGUL_CHOSEONG_YESIEUNG = 0x114C;
const char32_t HANGUL_CHOSEONG_CIEUC_IEUNG = 0x114D;
const char32_t HANGUL_CHOSEONG_CHITUEUMCIEUC = 0x114E;
const char32_t HANGUL_CHOSEONG_CHITUEUMSSANGCIEUC = 0x114F;
const char32_t HANGUL_CHOSEONG_CEONGCHIEUMCIEUC = 0x1150;
const char32_t HANGUL_CHOSEONG_CEONGCHIEUMSSANGCIEUC = 0x1151;
const char32_t HANGUL_CHOSEONG_CHIEUCH_KHIEUKH = 0x1152;
const char32_t HANGUL_CHOSEONG_CHIEUCH_HIEUH = 0x1153;
const char32_t HANGUL_CHOSEONG_CHITUEUMCHIEUCH = 0x1154;
const char32_t HANGUL_CHOSEONG_CEONGCHIEUMCHIEUCH = 0x1155;
const char32_t HANGUL_CHOSEONG_PHIEUPH_PIEUP = 0x1156;
const char32_t HANGUL_CHOSEONG_KAPYEOUNPHIEUPH = 0x1157;
const char32_t HANGUL_CHOSEONG_SSANGHIEUH = 0x1158;
const char32_t HANGUL_CHOSEONG_YEORINHIEUH = 0x1159;
const char32_t HANGUL_CHOSEONG_KIYEOK_TIKEUT = 0x115A;
const char32_t HANGUL_CHOSEONG_NIEUN_SIOS = 0x115B;
const char32_t HANGUL_CHOSEONG_NIEUN_CIEUC = 0x115C;
const char32_t HANGUL_CHOSEONG_NIEUN_HIEUH = 0x115D;
const char32_t HANGUL_CHOSEONG_TIKEUT_RIEUL = 0x115E;
const char32_t HANGUL_CHOSEONG_FILLER = 0x115F;
const char32_t HANGUL_JUNGSEONG_FILLER = 0x1160;
const char32_t HANGUL_JUNGSEONG_A = 0x1161;
const char32_t HANGUL_JUNGSEONG_AE = 0x1162;
const char32_t HANGUL_JUNGSEONG_YA = 0x1163;
const char32_t HANGUL_JUNGSEONG_YAE = 0x1164;
const char32_t HANGUL_JUNGSEONG_EO = 0x1165;
const char32_t HANGUL_JUNGSEONG_E = 0x1166;
const char32_t HANGUL_JUNGSEONG_YEO = 0x1167;
const char32_t HANGUL_JUNGSEONG_YE = 0x1168;
const char32_t HANGUL_JUNGSEONG_O = 0x1169;
const char32_t HANGUL_JUNGSEONG_WA = 0x116A;
const char32_t HANGUL_JUNGSEONG_WAE = 0x116B;
const char32_t HANGUL_JUNGSEONG_OE = 0x116C;
const char32_t HANGUL_JUNGSEONG_YO = 0x116D;
const char32_t HANGUL_JUNGSEONG_U = 0x116E;
const char32_t HANGUL_JUNGSEONG_WEO = 0x116F;
const char32_t HANGUL_JUNGSEONG_WE = 0x1170;
const char32_t HANGUL_JUNGSEONG_WI = 0x1171;
const char32_t HANGUL_JUNGSEONG_YU = 0x1172;
const char32_t HANGUL_JUNGSEONG_EU = 0x1173;
const char32_t HANGUL_JUNGSEONG_YI = 0x1174;
const char32_t HANGUL_JUNGSEONG_I = 0x1175;
const char32_t HANGUL_JUNGSEONG_A_O = 0x1176;
const char32_t HANGUL_JUNGSEONG_A_U = 0x1177;
const char32_t HANGUL_JUNGSEONG_YA_O = 0x1178;
const char32_t HANGUL_JUNGSEONG_YA_YO = 0x1179;
const char32_t HANGUL_JUNGSEONG_EO_O = 0x117A;
const char32_t HANGUL_JUNGSEONG_EO_U = 0x117B;
const char32_t HANGUL_JUNGSEONG_EO_EU = 0x117C;
const char32_t HANGUL_JUNGSEONG_YEO_O = 0x117D;
const char32_t HANGUL_JUNGSEONG_YEO_U = 0x117E;
const char32_t HANGUL_JUNGSEONG_O_EO = 0x117F;
const char32_t HANGUL_JUNGSEONG_O_E = 0x1180;
const char32_t HANGUL_JUNGSEONG_O_YE = 0x1181;
const char32_t HANGUL_JUNGSEONG_O_O = 0x1182;
const char32_t HANGUL_JUNGSEONG_O_U = 0x1183;
const char32_t HANGUL_JUNGSEONG_YO_YA = 0x1184;
const char32_t HANGUL_JUNGSEONG_YO_YAE = 0x1185;
const char32_t HANGUL_JUNGSEONG_YO_YEO = 0x1186;
const char32_t HANGUL_JUNGSEONG_YO_O = 0x1187;
const char32_t HANGUL_JUNGSEONG_YO_I = 0x1188;
const char32_t HANGUL_JUNGSEONG_U_A = 0x1189;
const char32_t HANGUL_JUNGSEONG_U_AE = 0x118A;
const char32_t HANGUL_JUNGSEONG_U_EO_EU = 0x118B;
const char32_t HANGUL_JUNGSEONG_U_YE = 0x118C;
const char32_t HANGUL_JUNGSEONG_U_U = 0x118D;
const char32_t HANGUL_JUNGSEONG_YU_A = 0x118E;
const char32_t HANGUL_JUNGSEONG_YU_EO = 0x118F;
const char32_t HANGUL_JUNGSEONG_YU_E = 0x1190;
const char32_t HANGUL_JUNGSEONG_YU_YEO = 0x1191;
const char32_t HANGUL_JUNGSEONG_YU_YE = 0x1192;
const char32_t HANGUL_JUNGSEONG_YU_U = 0x1193;
const char32_t HANGUL_JUNGSEONG_YU_I = 0x1194;
const char32_t HANGUL_JUNGSEONG_EU_U = 0x1195;
const char32_t HANGUL_JUNGSEONG_EU_EU = 0x1196;
const char32_t HANGUL_JUNGSEONG_YI_U = 0x1197;
const char32_t HANGUL_JUNGSEONG_I_A = 0x1198;
const char32_t HANGUL_JUNGSEONG_I_YA = 0x1199;
const char32_t HANGUL_JUNGSEONG_I_O = 0x119A;
const char32_t HANGUL_JUNGSEONG_I_U = 0x119B;
const char32_t HANGUL_JUNGSEONG_I_EU = 0x119C;
const char32_t HANGUL_JUNGSEONG_I_ARAEA = 0x119D;
const char32_t HANGUL_JUNGSEONG_ARAEA = 0x119E;
const char32_t HANGUL_JUNGSEONG_ARAEA_EO = 0x119F;
const char32_t HANGUL_JUNGSEONG_ARAEA_U = 0x11A0;
const char32_t HANGUL_JUNGSEONG_ARAEA_I = 0x11A1;
const char32_t HANGUL_JUNGSEONG_SSANGARAEA = 0x11A2;
const char32_t HANGUL_JUNGSEONG_A_EU = 0x11A3;
const char32_t HANGUL_JUNGSEONG_YA_U = 0x11A4;
const char32_t HANGUL_JUNGSEONG_YEO_YA = 0x11A5;
const char32_t HANGUL_JUNGSEONG_O_YA = 0x11A6;
const char32_t HANGUL_JUNGSEONG_O_YAE = 0x11A7;
const char32_t HANGUL_JONGSEONG_KIYEOK = 0x11A8;
const char32_t HANGUL_JONGSEONG_SSANGKIYEOK = 0x11A9;
const char32_t HANGUL_JONGSEONG_KIYEOK_SIOS = 0x11AA;
const char32_t HANGUL_JONGSEONG_NIEUN = 0x11AB;
const char32_t HANGUL_JONGSEONG_NIEUN_CIEUC = 0x11AC;
const char32_t HANGUL_JONGSEONG_NIEUN_HIEUH = 0x11AD;
const char32_t HANGUL_JONGSEONG_TIKEUT = 0x11AE;
const char32_t HANGUL_JONGSEONG_RIEUL = 0x11AF;
const char32_t HANGUL_JONGSEONG_RIEUL_KIYEOK = 0x11B0;
const char32_t HANGUL_JONGSEONG_RIEUL_MIEUM = 0x11B1;
const char32_t HANGUL_JONGSEONG_RIEUL_PIEUP = 0x11B2;
const char32_t HANGUL_JONGSEONG_RIEUL_SIOS = 0x11B3;
const char32_t HANGUL_JONGSEONG_RIEUL_THIEUTH = 0x11B4;
const char32_t HANGUL_JONGSEONG_RIEUL_PHIEUPH = 0x11B5;
const char32_t HANGUL_JONGSEONG_RIEUL_HIEUH = 0x11B6;
const char32_t HANGUL_JONGSEONG_MIEUM = 0x11B7;
const char32_t HANGUL_JONGSEONG_PIEUP = 0x11B8;
const char32_t HANGUL_JONGSEONG_PIEUP_SIOS = 0x11B9;
const char32_t HANGUL_JONGSEONG_SIOS = 0x11BA;
const char32_t HANGUL_JONGSEONG_SSANGSIOS = 0x11BB;
const char32_t HANGUL_JONGSEONG_IEUNG = 0x11BC;
const char32_t HANGUL_JONGSEONG_CIEUC = 0x11BD;
const char32_t HANGUL_JONGSEONG_CHIEUCH = 0x11BE;
const char32_t HANGUL_JONGSEONG_KHIEUKH = 0x11BF;
const char32_t HANGUL_JONGSEONG_THIEUTH = 0x11C0;
const char32_t HANGUL_JONGSEONG_PHIEUPH = 0x11C1;
const char32_t HANGUL_JONGSEONG_HIEUH = 0x11C2;
const char32_t HANGUL_JONGSEONG_KIYEOK_RIEUL = 0x11C3;
const char32_t HANGUL_JONGSEONG_KIYEOK_SIOS_KIYEOK = 0x11C4;
const char32_t HANGUL_JONGSEONG_NIEUN_KIYEOK = 0x11C5;
const char32_t HANGUL_JONGSEONG_NIEUN_TIKEUT = 0x11C6;
const char32_t HANGUL_JONGSEONG_NIEUN_SIOS = 0x11C7;
const char32_t HANGUL_JONGSEONG_NIEUN_PANSIOS = 0x11C8;
const char32_t HANGUL_JONGSEONG_NIEUN_THIEUTH = 0x11C9;
const char32_t HANGUL_JONGSEONG_TIKEUT_KIYEOK = 0x11CA;
const char32_t HANGUL_JONGSEONG_TIKEUT_RIEUL = 0x11CB;
const char32_t HANGUL_JONGSEONG_RIEUL_KIYEOK_SIOS = 0x11CC;
const char32_t HANGUL_JONGSEONG_RIEUL_NIEUN = 0x11CD;
const char32_t HANGUL_JONGSEONG_RIEUL_TIKEUT = 0x11CE;
const char32_t HANGUL_JONGSEONG_RIEUL_TIKEUT_HIEUH = 0x11CF;
const char32_t HANGUL_JONGSEONG_SSANGRIEUL = 0x11D0;
const char32_t HANGUL_JONGSEONG_RIEUL_MIEUM_KIYEOK = 0x11D1;
const char32_t HANGUL_JONGSEONG_RIEUL_MIEUM_SIOS = 0x11D2;
const char32_t HANGUL_JONGSEONG_RIEUL_PIEUP_SIOS = 0x11D3;
const char32_t HANGUL_JONGSEONG_RIEUL_PIEUP_HIEUH = 0x11D4;
const char32_t HANGUL_JONGSEONG_RIEUL_KAPYEOUNPIEUP = 0x11D5;
const char32_t HANGUL_JONGSEONG_RIEUL_SSANGSIOS = 0x11D6;
const char32_t HANGUL_JONGSEONG_RIEUL_PANSIOS = 0x11D7;
const char32_t HANGUL_JONGSEONG_RIEUL_KHIEUKH = 0x11D8;
const char32_t HANGUL_JONGSEONG_RIEUL_YEORINHIEUH = 0x11D9;
const char32_t HANGUL_JONGSEONG_MIEUM_KIYEOK = 0x11DA;
const char32_t HANGUL_JONGSEONG_MIEUM_RIEUL = 0x11DB;
const char32_t HANGUL_JONGSEONG_MIEUM_PIEUP = 0x11DC;
const char32_t HANGUL_JONGSEONG_MIEUM_SIOS = 0x11DD;
const char32_t HANGUL_JONGSEONG_MIEUM_SSANGSIOS = 0x11DE;
const char32_t HANGUL_JONGSEONG_MIEUM_PANSIOS = 0x11DF;
const char32_t HANGUL_JONGSEONG_MIEUM_CHIEUCH = 0x11E0;
const char32_t HANGUL_JONGSEONG_MIEUM_HIEUH = 0x11E1;
const char32_t HANGUL_JONGSEONG_KAPYEOUNMIEUM = 0x11E2;
const char32_t HANGUL_JONGSEONG_PIEUP_RIEUL = 0x11E3;
const char32_t HANGUL_JONGSEONG_PIEUP_PHIEUPH = 0x11E4;
const char32_t HANGUL_JONGSEONG_PIEUP_HIEUH = 0x11E5;
const char32_t HANGUL_JONGSEONG_KAPYEOUNPIEUP = 0x11E6;
const char32_t HANGUL_JONGSEONG_SIOS_KIYEOK = 0x11E7;
const char32_t HANGUL_JONGSEONG_SIOS_TIKEUT = 0x11E8;
const char32_t HANGUL_JONGSEONG_SIOS_RIEUL = 0x11E9;
const char32_t HANGUL_JONGSEONG_SIOS_PIEUP = 0x11EA;
const char32_t HANGUL_JONGSEONG_PANSIOS = 0x11EB;
const char32_t HANGUL_JONGSEONG_IEUNG_KIYEOK = 0x11EC;
const char32_t HANGUL_JONGSEONG_IEUNG_SSANGKIYEOK = 0x11ED;
const char32_t HANGUL_JONGSEONG_SSANGIEUNG = 0x11EE;
const char32_t HANGUL_JONGSEONG_IEUNG_KHIEUKH = 0x11EF;
const char32_t HANGUL_JONGSEONG_YESIEUNG = 0x11F0;
const char32_t HANGUL_JONGSEONG_YESIEUNG_SIOS = 0x11F1;
const char32_t HANGUL_JONGSEONG_YESIEUNG_PANSIOS = 0x11F2;
const char32_t HANGUL_JONGSEONG_PHIEUPH_PIEUP = 0x11F3;
const char32_t HANGUL_JONGSEONG_KAPYEOUNPHIEUPH = 0x11F4;
const char32_t HANGUL_JONGSEONG_HIEUH_NIEUN = 0x11F5;
const char32_t HANGUL_JONGSEONG_HIEUH_RIEUL = 0x11F6;
const char32_t HANGUL_JONGSEONG_HIEUH_MIEUM = 0x11F7;
const char32_t HANGUL_JONGSEONG_HIEUH_PIEUP = 0x11F8;
const char32_t HANGUL_JONGSEONG_YEORINHIEUH = 0x11F9;
const char32_t HANGUL_JONGSEONG_KIYEOK_NIEUN = 0x11FA;
const char32_t HANGUL_JONGSEONG_KIYEOK_PIEUP = 0x11FB;
const char32_t HANGUL_JONGSEONG_KIYEOK_CHIEUCH = 0x11FC;
const char32_t HANGUL_JONGSEONG_KIYEOK_KHIEUKH = 0x11FD;
const char32_t HANGUL_JONGSEONG_KIYEOK_HIEUH = 0x11FE;
const char32_t HANGUL_JONGSEONG_SSANGNIEUN = 0x11FF;
const char32_t ETHIOPIC_SYLLABLE_HA = 0x1200;
const char32_t ETHIOPIC_SYLLABLE_HU = 0x1201;
const char32_t ETHIOPIC_SYLLABLE_HI = 0x1202;
const char32_t ETHIOPIC_SYLLABLE_HAA = 0x1203;
const char32_t ETHIOPIC_SYLLABLE_HEE = 0x1204;
const char32_t ETHIOPIC_SYLLABLE_HE = 0x1205;
const char32_t ETHIOPIC_SYLLABLE_HO = 0x1206;
const char32_t ETHIOPIC_SYLLABLE_HOA = 0x1207;
const char32_t ETHIOPIC_SYLLABLE_LA = 0x1208;
const char32_t ETHIOPIC_SYLLABLE_LU = 0x1209;
const char32_t ETHIOPIC_SYLLABLE_LI = 0x120A;
const char32_t ETHIOPIC_SYLLABLE_LAA = 0x120B;
const char32_t ETHIOPIC_SYLLABLE_LEE = 0x120C;
const char32_t ETHIOPIC_SYLLABLE_LE = 0x120D;
const char32_t ETHIOPIC_SYLLABLE_LO = 0x120E;
const char32_t ETHIOPIC_SYLLABLE_LWA = 0x120F;
const char32_t ETHIOPIC_SYLLABLE_HHA = 0x1210;
const char32_t ETHIOPIC_SYLLABLE_HHU = 0x1211;
const char32_t ETHIOPIC_SYLLABLE_HHI = 0x1212;
const char32_t ETHIOPIC_SYLLABLE_HHAA = 0x1213;
const char32_t ETHIOPIC_SYLLABLE_HHEE = 0x1214;
const char32_t ETHIOPIC_SYLLABLE_HHE = 0x1215;
const char32_t ETHIOPIC_SYLLABLE_HHO = 0x1216;
const char32_t ETHIOPIC_SYLLABLE_HHWA = 0x1217;
const char32_t ETHIOPIC_SYLLABLE_MA = 0x1218;
const char32_t ETHIOPIC_SYLLABLE_MU = 0x1219;
const char32_t ETHIOPIC_SYLLABLE_MI = 0x121A;
const char32_t ETHIOPIC_SYLLABLE_MAA = 0x121B;
const char32_t ETHIOPIC_SYLLABLE_MEE = 0x121C;
const char32_t ETHIOPIC_SYLLABLE_ME = 0x121D;
const char32_t ETHIOPIC_SYLLABLE_MO = 0x121E;
const char32_t ETHIOPIC_SYLLABLE_MWA = 0x121F;
const char32_t ETHIOPIC_SYLLABLE_SZA = 0x1220;
const char32_t ETHIOPIC_SYLLABLE_SZU = 0x1221;
const char32_t ETHIOPIC_SYLLABLE_SZI = 0x1222;
const char32_t ETHIOPIC_SYLLABLE_SZAA = 0x1223;
const char32_t ETHIOPIC_SYLLABLE_SZEE = 0x1224;
const char32_t ETHIOPIC_SYLLABLE_SZE = 0x1225;
const char32_t ETHIOPIC_SYLLABLE_SZO = 0x1226;
const char32_t ETHIOPIC_SYLLABLE_SZWA = 0x1227;
const char32_t ETHIOPIC_SYLLABLE_RA = 0x1228;
const char32_t ETHIOPIC_SYLLABLE_RU = 0x1229;
const char32_t ETHIOPIC_SYLLABLE_RI = 0x122A;
const char32_t ETHIOPIC_SYLLABLE_RAA = 0x122B;
const char32_t ETHIOPIC_SYLLABLE_REE = 0x122C;
const char32_t ETHIOPIC_SYLLABLE_RE = 0x122D;
const char32_t ETHIOPIC_SYLLABLE_RO = 0x122E;
const char32_t ETHIOPIC_SYLLABLE_RWA = 0x122F;
const char32_t ETHIOPIC_SYLLABLE_SA = 0x1230;
const char32_t ETHIOPIC_SYLLABLE_SU = 0x1231;
const char32_t ETHIOPIC_SYLLABLE_SI = 0x1232;
const char32_t ETHIOPIC_SYLLABLE_SAA = 0x1233;
const char32_t ETHIOPIC_SYLLABLE_SEE = 0x1234;
const char32_t ETHIOPIC_SYLLABLE_SE = 0x1235;
const char32_t ETHIOPIC_SYLLABLE_SO = 0x1236;
const char32_t ETHIOPIC_SYLLABLE_SWA = 0x1237;
const char32_t ETHIOPIC_SYLLABLE_SHA = 0x1238;
const char32_t ETHIOPIC_SYLLABLE_SHU = 0x1239;
const char32_t ETHIOPIC_SYLLABLE_SHI = 0x123A;
const char32_t ETHIOPIC_SYLLABLE_SHAA = 0x123B;
const char32_t ETHIOPIC_SYLLABLE_SHEE = 0x123C;
const char32_t ETHIOPIC_SYLLABLE_SHE = 0x123D;
const char32_t ETHIOPIC_SYLLABLE_SHO = 0x123E;
const char32_t ETHIOPIC_SYLLABLE_SHWA = 0x123F;
const char32_t ETHIOPIC_SYLLABLE_QA = 0x1240;
const char32_t ETHIOPIC_SYLLABLE_QU = 0x1241;
const char32_t ETHIOPIC_SYLLABLE_QI = 0x1242;
const char32_t ETHIOPIC_SYLLABLE_QAA = 0x1243;
const char32_t ETHIOPIC_SYLLABLE_QEE = 0x1244;
const char32_t ETHIOPIC_SYLLABLE_QE = 0x1245;
const char32_t ETHIOPIC_SYLLABLE_QO = 0x1246;
const char32_t ETHIOPIC_SYLLABLE_QOA = 0x1247;
const char32_t ETHIOPIC_SYLLABLE_QWA = 0x1248;
const char32_t ETHIOPIC_SYLLABLE_QWI = 0x124A;
const char32_t ETHIOPIC_SYLLABLE_QWAA = 0x124B;
const char32_t ETHIOPIC_SYLLABLE_QWEE = 0x124C;
const char32_t ETHIOPIC_SYLLABLE_QWE = 0x124D;
const char32_t ETHIOPIC_SYLLABLE_QHA = 0x1250;
const char32_t ETHIOPIC_SYLLABLE_QHU = 0x1251;
const char32_t ETHIOPIC_SYLLABLE_QHI = 0x1252;
const char32_t ETHIOPIC_SYLLABLE_QHAA = 0x1253;
const char32_t ETHIOPIC_SYLLABLE_QHEE = 0x1254;
const char32_t ETHIOPIC_SYLLABLE_QHE = 0x1255;
const char32_t ETHIOPIC_SYLLABLE_QHO = 0x1256;
const char32_t ETHIOPIC_SYLLABLE_QHWA = 0x1258;
const char32_t ETHIOPIC_SYLLABLE_QHWI = 0x125A;
const char32_t ETHIOPIC_SYLLABLE_QHWAA = 0x125B;
const char32_t ETHIOPIC_SYLLABLE_QHWEE = 0x125C;
const char32_t ETHIOPIC_SYLLABLE_QHWE = 0x125D;
const char32_t ETHIOPIC_SYLLABLE_BA = 0x1260;
const char32_t ETHIOPIC_SYLLABLE_BU = 0x1261;
const char32_t ETHIOPIC_SYLLABLE_BI = 0x1262;
const char32_t ETHIOPIC_SYLLABLE_BAA = 0x1263;
const char32_t ETHIOPIC_SYLLABLE_BEE = 0x1264;
const char32_t ETHIOPIC_SYLLABLE_BE = 0x1265;
const char32_t ETHIOPIC_SYLLABLE_BO = 0x1266;
const char32_t ETHIOPIC_SYLLABLE_BWA = 0x1267;
const char32_t ETHIOPIC_SYLLABLE_VA = 0x1268;
const char32_t ETHIOPIC_SYLLABLE_VU = 0x1269;
const char32_t ETHIOPIC_SYLLABLE_VI = 0x126A;
const char32_t ETHIOPIC_SYLLABLE_VAA = 0x126B;
const char32_t ETHIOPIC_SYLLABLE_VEE = 0x126C;
const char32_t ETHIOPIC_SYLLABLE_VE = 0x126D;
const char32_t ETHIOPIC_SYLLABLE_VO = 0x126E;
const char32_t ETHIOPIC_SYLLABLE_VWA = 0x126F;
const char32_t ETHIOPIC_SYLLABLE_TA = 0x1270;
const char32_t ETHIOPIC_SYLLABLE_TU = 0x1271;
const char32_t ETHIOPIC_SYLLABLE_TI = 0x1272;
const char32_t ETHIOPIC_SYLLABLE_TAA = 0x1273;
const char32_t ETHIOPIC_SYLLABLE_TEE = 0x1274;
const char32_t ETHIOPIC_SYLLABLE_TE = 0x1275;
const char32_t ETHIOPIC_SYLLABLE_TO = 0x1276;
const char32_t ETHIOPIC_SYLLABLE_TWA = 0x1277;
const char32_t ETHIOPIC_SYLLABLE_CA = 0x1278;
const char32_t ETHIOPIC_SYLLABLE_CU = 0x1279;
const char32_t ETHIOPIC_SYLLABLE_CI = 0x127A;
const char32_t ETHIOPIC_SYLLABLE_CAA = 0x127B;
const char32_t ETHIOPIC_SYLLABLE_CEE = 0x127C;
const char32_t ETHIOPIC_SYLLABLE_CE = 0x127D;
const char32_t ETHIOPIC_SYLLABLE_CO = 0x127E;
const char32_t ETHIOPIC_SYLLABLE_CWA = 0x127F;
const char32_t ETHIOPIC_SYLLABLE_XA = 0x1280;
const char32_t ETHIOPIC_SYLLABLE_XU = 0x1281;
const char32_t ETHIOPIC_SYLLABLE_XI = 0x1282;
const char32_t ETHIOPIC_SYLLABLE_XAA = 0x1283;
const char32_t ETHIOPIC_SYLLABLE_XEE = 0x1284;
const char32_t ETHIOPIC_SYLLABLE_XE = 0x1285;
const char32_t ETHIOPIC_SYLLABLE_XO = 0x1286;
const char32_t ETHIOPIC_SYLLABLE_XOA = 0x1287;
const char32_t ETHIOPIC_SYLLABLE_XWA = 0x1288;
const char32_t ETHIOPIC_SYLLABLE_XWI = 0x128A;
const char32_t ETHIOPIC_SYLLABLE_XWAA = 0x128B;
const char32_t ETHIOPIC_SYLLABLE_XWEE = 0x128C;
const char32_t ETHIOPIC_SYLLABLE_XWE = 0x128D;
const char32_t ETHIOPIC_SYLLABLE_NA = 0x1290;
const char32_t ETHIOPIC_SYLLABLE_NU = 0x1291;
const char32_t ETHIOPIC_SYLLABLE_NI = 0x1292;
const char32_t ETHIOPIC_SYLLABLE_NAA = 0x1293;
const char32_t ETHIOPIC_SYLLABLE_NEE = 0x1294;
const char32_t ETHIOPIC_SYLLABLE_NE = 0x1295;
const char32_t ETHIOPIC_SYLLABLE_NO = 0x1296;
const char32_t ETHIOPIC_SYLLABLE_NWA = 0x1297;
const char32_t ETHIOPIC_SYLLABLE_NYA = 0x1298;
const char32_t ETHIOPIC_SYLLABLE_NYU = 0x1299;
const char32_t ETHIOPIC_SYLLABLE_NYI = 0x129A;
const char32_t ETHIOPIC_SYLLABLE_NYAA = 0x129B;
const char32_t ETHIOPIC_SYLLABLE_NYEE = 0x129C;
const char32_t ETHIOPIC_SYLLABLE_NYE = 0x129D;
const char32_t ETHIOPIC_SYLLABLE_NYO = 0x129E;
const char32_t ETHIOPIC_SYLLABLE_NYWA = 0x129F;
const char32_t ETHIOPIC_SYLLABLE_GLOTTAL_A = 0x12A0;
const char32_t ETHIOPIC_SYLLABLE_GLOTTAL_U = 0x12A1;
const char32_t ETHIOPIC_SYLLABLE_GLOTTAL_I = 0x12A2;
const char32_t ETHIOPIC_SYLLABLE_GLOTTAL_AA = 0x12A3;
const char32_t ETHIOPIC_SYLLABLE_GLOTTAL_EE = 0x12A4;
const char32_t ETHIOPIC_SYLLABLE_GLOTTAL_E = 0x12A5;
const char32_t ETHIOPIC_SYLLABLE_GLOTTAL_O = 0x12A6;
const char32_t ETHIOPIC_SYLLABLE_GLOTTAL_WA = 0x12A7;
const char32_t ETHIOPIC_SYLLABLE_KA = 0x12A8;
const char32_t ETHIOPIC_SYLLABLE_KU = 0x12A9;
const char32_t ETHIOPIC_SYLLABLE_KI = 0x12AA;
const char32_t ETHIOPIC_SYLLABLE_KAA = 0x12AB;
const char32_t ETHIOPIC_SYLLABLE_KEE = 0x12AC;
const char32_t ETHIOPIC_SYLLABLE_KE = 0x12AD;
const char32_t ETHIOPIC_SYLLABLE_KO = 0x12AE;
const char32_t ETHIOPIC_SYLLABLE_KOA = 0x12AF;
const char32_t ETHIOPIC_SYLLABLE_KWA = 0x12B0;
const char32_t ETHIOPIC_SYLLABLE_KWI = 0x12B2;
const char32_t ETHIOPIC_SYLLABLE_KWAA = 0x12B3;
const char32_t ETHIOPIC_SYLLABLE_KWEE = 0x12B4;
const char32_t ETHIOPIC_SYLLABLE_KWE = 0x12B5;
const char32_t ETHIOPIC_SYLLABLE_KXA = 0x12B8;
const char32_t ETHIOPIC_SYLLABLE_KXU = 0x12B9;
const char32_t ETHIOPIC_SYLLABLE_KXI = 0x12BA;
const char32_t ETHIOPIC_SYLLABLE_KXAA = 0x12BB;
const char32_t ETHIOPIC_SYLLABLE_KXEE = 0x12BC;
const char32_t ETHIOPIC_SYLLABLE_KXE = 0x12BD;
const char32_t ETHIOPIC_SYLLABLE_KXO = 0x12BE;
const char32_t ETHIOPIC_SYLLABLE_KXWA = 0x12C0;
const char32_t ETHIOPIC_SYLLABLE_KXWI = 0x12C2;
const char32_t ETHIOPIC_SYLLABLE_KXWAA = 0x12C3;
const char32_t ETHIOPIC_SYLLABLE_KXWEE = 0x12C4;
const char32_t ETHIOPIC_SYLLABLE_KXWE = 0x12C5;
const char32_t ETHIOPIC_SYLLABLE_WA = 0x12C8;
const char32_t ETHIOPIC_SYLLABLE_WU = 0x12C9;
const char32_t ETHIOPIC_SYLLABLE_WI = 0x12CA;
const char32_t ETHIOPIC_SYLLABLE_WAA = 0x12CB;
const char32_t ETHIOPIC_SYLLABLE_WEE = 0x12CC;
const char32_t ETHIOPIC_SYLLABLE_WE = 0x12CD;
const char32_t ETHIOPIC_SYLLABLE_WO = 0x12CE;
const char32_t ETHIOPIC_SYLLABLE_WOA = 0x12CF;
const char32_t ETHIOPIC_SYLLABLE_PHARYNGEAL_A = 0x12D0;
const char32_t ETHIOPIC_SYLLABLE_PHARYNGEAL_U = 0x12D1;
const char32_t ETHIOPIC_SYLLABLE_PHARYNGEAL_I = 0x12D2;
const char32_t ETHIOPIC_SYLLABLE_PHARYNGEAL_AA = 0x12D3;
const char32_t ETHIOPIC_SYLLABLE_PHARYNGEAL_EE = 0x12D4;
const char32_t ETHIOPIC_SYLLABLE_PHARYNGEAL_E = 0x12D5;
const char32_t ETHIOPIC_SYLLABLE_PHARYNGEAL_O = 0x12D6;
const char32_t ETHIOPIC_SYLLABLE_ZA = 0x12D8;
const char32_t ETHIOPIC_SYLLABLE_ZU = 0x12D9;
const char32_t ETHIOPIC_SYLLABLE_ZI = 0x12DA;
const char32_t ETHIOPIC_SYLLABLE_ZAA = 0x12DB;
const char32_t ETHIOPIC_SYLLABLE_ZEE = 0x12DC;
const char32_t ETHIOPIC_SYLLABLE_ZE = 0x12DD;
const char32_t ETHIOPIC_SYLLABLE_ZO = 0x12DE;
const char32_t ETHIOPIC_SYLLABLE_ZWA = 0x12DF;
const char32_t ETHIOPIC_SYLLABLE_ZHA = 0x12E0;
const char32_t ETHIOPIC_SYLLABLE_ZHU = 0x12E1;
const char32_t ETHIOPIC_SYLLABLE_ZHI = 0x12E2;
const char32_t ETHIOPIC_SYLLABLE_ZHAA = 0x12E3;
const char32_t ETHIOPIC_SYLLABLE_ZHEE = 0x12E4;
const char32_t ETHIOPIC_SYLLABLE_ZHE = 0x12E5;
const char32_t ETHIOPIC_SYLLABLE_ZHO = 0x12E6;
const char32_t ETHIOPIC_SYLLABLE_ZHWA = 0x12E7;
const char32_t ETHIOPIC_SYLLABLE_YA = 0x12E8;
const char32_t ETHIOPIC_SYLLABLE_YU = 0x12E9;
const char32_t ETHIOPIC_SYLLABLE_YI = 0x12EA;
const char32_t ETHIOPIC_SYLLABLE_YAA = 0x12EB;
const char32_t ETHIOPIC_SYLLABLE_YEE = 0x12EC;
const char32_t ETHIOPIC_SYLLABLE_YE = 0x12ED;
const char32_t ETHIOPIC_SYLLABLE_YO = 0x12EE;
const char32_t ETHIOPIC_SYLLABLE_YOA = 0x12EF;
const char32_t ETHIOPIC_SYLLABLE_DA = 0x12F0;
const char32_t ETHIOPIC_SYLLABLE_DU = 0x12F1;
const char32_t ETHIOPIC_SYLLABLE_DI = 0x12F2;
const char32_t ETHIOPIC_SYLLABLE_DAA = 0x12F3;
const char32_t ETHIOPIC_SYLLABLE_DEE = 0x12F4;
const char32_t ETHIOPIC_SYLLABLE_DE = 0x12F5;
const char32_t ETHIOPIC_SYLLABLE_DO = 0x12F6;
const char32_t ETHIOPIC_SYLLABLE_DWA = 0x12F7;
const char32_t ETHIOPIC_SYLLABLE_DDA = 0x12F8;
const char32_t ETHIOPIC_SYLLABLE_DDU = 0x12F9;
const char32_t ETHIOPIC_SYLLABLE_DDI = 0x12FA;
const char32_t ETHIOPIC_SYLLABLE_DDAA = 0x12FB;
const char32_t ETHIOPIC_SYLLABLE_DDEE = 0x12FC;
const char32_t ETHIOPIC_SYLLABLE_DDE = 0x12FD;
const char32_t ETHIOPIC_SYLLABLE_DDO = 0x12FE;
const char32_t ETHIOPIC_SYLLABLE_DDWA = 0x12FF;
const char32_t ETHIOPIC_SYLLABLE_JA = 0x1300;
const char32_t ETHIOPIC_SYLLABLE_JU = 0x1301;
const char32_t ETHIOPIC_SYLLABLE_JI = 0x1302;
const char32_t ETHIOPIC_SYLLABLE_JAA = 0x1303;
const char32_t ETHIOPIC_SYLLABLE_JEE = 0x1304;
const char32_t ETHIOPIC_SYLLABLE_JE = 0x1305;
const char32_t ETHIOPIC_SYLLABLE_JO = 0x1306;
const char32_t ETHIOPIC_SYLLABLE_JWA = 0x1307;
const char32_t ETHIOPIC_SYLLABLE_GA = 0x1308;
const char32_t ETHIOPIC_SYLLABLE_GU = 0x1309;
const char32_t ETHIOPIC_SYLLABLE_GI = 0x130A;
const char32_t ETHIOPIC_SYLLABLE_GAA = 0x130B;
const char32_t ETHIOPIC_SYLLABLE_GEE = 0x130C;
const char32_t ETHIOPIC_SYLLABLE_GE = 0x130D;
const char32_t ETHIOPIC_SYLLABLE_GO = 0x130E;
const char32_t ETHIOPIC_SYLLABLE_GOA = 0x130F;
const char32_t ETHIOPIC_SYLLABLE_GWA = 0x1310;
const char32_t ETHIOPIC_SYLLABLE_GWI = 0x1312;
const char32_t ETHIOPIC_SYLLABLE_GWAA = 0x1313;
const char32_t ETHIOPIC_SYLLABLE_GWEE = 0x1314;
const char32_t ETHIOPIC_SYLLABLE_GWE = 0x1315;
const char32_t ETHIOPIC_SYLLABLE_GGA = 0x1318;
const char32_t ETHIOPIC_SYLLABLE_GGU = 0x1319;
const char32_t ETHIOPIC_SYLLABLE_GGI = 0x131A;
const char32_t ETHIOPIC_SYLLABLE_GGAA = 0x131B;
const char32_t ETHIOPIC_SYLLABLE_GGEE = 0x131C;
const char32_t ETHIOPIC_SYLLABLE_GGE = 0x131D;
const char32_t ETHIOPIC_SYLLABLE_GGO = 0x131E;
const char32_t ETHIOPIC_SYLLABLE_GGWAA = 0x131F;
const char32_t ETHIOPIC_SYLLABLE_THA = 0x1320;
const char32_t ETHIOPIC_SYLLABLE_THU = 0x1321;
const char32_t ETHIOPIC_SYLLABLE_THI = 0x1322;
const char32_t ETHIOPIC_SYLLABLE_THAA = 0x1323;
const char32_t ETHIOPIC_SYLLABLE_THEE = 0x1324;
const char32_t ETHIOPIC_SYLLABLE_THE = 0x1325;
const char32_t ETHIOPIC_SYLLABLE_THO = 0x1326;
const char32_t ETHIOPIC_SYLLABLE_THWA = 0x1327;
const char32_t ETHIOPIC_SYLLABLE_CHA = 0x1328;
const char32_t ETHIOPIC_SYLLABLE_CHU = 0x1329;
const char32_t ETHIOPIC_SYLLABLE_CHI = 0x132A;
const char32_t ETHIOPIC_SYLLABLE_CHAA = 0x132B;
const char32_t ETHIOPIC_SYLLABLE_CHEE = 0x132C;
const char32_t ETHIOPIC_SYLLABLE_CHE = 0x132D;
const char32_t ETHIOPIC_SYLLABLE_CHO = 0x132E;
const char32_t ETHIOPIC_SYLLABLE_CHWA = 0x132F;
const char32_t ETHIOPIC_SYLLABLE_PHA = 0x1330;
const char32_t ETHIOPIC_SYLLABLE_PHU = 0x1331;
const char32_t ETHIOPIC_SYLLABLE_PHI = 0x1332;
const char32_t ETHIOPIC_SYLLABLE_PHAA = 0x1333;
const char32_t ETHIOPIC_SYLLABLE_PHEE = 0x1334;
const char32_t ETHIOPIC_SYLLABLE_PHE = 0x1335;
const char32_t ETHIOPIC_SYLLABLE_PHO = 0x1336;
const char32_t ETHIOPIC_SYLLABLE_PHWA = 0x1337;
const char32_t ETHIOPIC_SYLLABLE_TSA = 0x1338;
const char32_t ETHIOPIC_SYLLABLE_TSU = 0x1339;
const char32_t ETHIOPIC_SYLLABLE_TSI = 0x133A;
const char32_t ETHIOPIC_SYLLABLE_TSAA = 0x133B;
const char32_t ETHIOPIC_SYLLABLE_TSEE = 0x133C;
const char32_t ETHIOPIC_SYLLABLE_TSE = 0x133D;
const char32_t ETHIOPIC_SYLLABLE_TSO = 0x133E;
const char32_t ETHIOPIC_SYLLABLE_TSWA = 0x133F;
const char32_t ETHIOPIC_SYLLABLE_TZA = 0x1340;
const char32_t ETHIOPIC_SYLLABLE_TZU = 0x1341;
const char32_t ETHIOPIC_SYLLABLE_TZI = 0x1342;
const char32_t ETHIOPIC_SYLLABLE_TZAA = 0x1343;
const char32_t ETHIOPIC_SYLLABLE_TZEE = 0x1344;
const char32_t ETHIOPIC_SYLLABLE_TZE = 0x1345;
const char32_t ETHIOPIC_SYLLABLE_TZO = 0x1346;
const char32_t ETHIOPIC_SYLLABLE_TZOA = 0x1347;
const char32_t ETHIOPIC_SYLLABLE_FA = 0x1348;
const char32_t ETHIOPIC_SYLLABLE_FU = 0x1349;
const char32_t ETHIOPIC_SYLLABLE_FI = 0x134A;
const char32_t ETHIOPIC_SYLLABLE_FAA = 0x134B;
const char32_t ETHIOPIC_SYLLABLE_FEE = 0x134C;
const char32_t ETHIOPIC_SYLLABLE_FE = 0x134D;
const char32_t ETHIOPIC_SYLLABLE_FO = 0x134E;
const char32_t ETHIOPIC_SYLLABLE_FWA = 0x134F;
const char32_t ETHIOPIC_SYLLABLE_PA = 0x1350;
const char32_t ETHIOPIC_SYLLABLE_PU = 0x1351;
const char32_t ETHIOPIC_SYLLABLE_PI = 0x1352;
const char32_t ETHIOPIC_SYLLABLE_PAA = 0x1353;
const char32_t ETHIOPIC_SYLLABLE_PEE = 0x1354;
const char32_t ETHIOPIC_SYLLABLE_PE = 0x1355;
const char32_t ETHIOPIC_SYLLABLE_PO = 0x1356;
const char32_t ETHIOPIC_SYLLABLE_PWA = 0x1357;
const char32_t ETHIOPIC_SYLLABLE_RYA = 0x1358;
const char32_t ETHIOPIC_SYLLABLE_MYA = 0x1359;
const char32_t ETHIOPIC_SYLLABLE_FYA = 0x135A;
const char32_t ETHIOPIC_COMBINING_GEMINATION_AND_VOWEL_LENGTH_MARK = 0x135D;
const char32_t ETHIOPIC_COMBINING_VOWEL_LENGTH_MARK = 0x135E;
const char32_t ETHIOPIC_COMBINING_GEMINATION_MARK = 0x135F;
const char32_t ETHIOPIC_SECTION_MARK = 0x1360;
const char32_t ETHIOPIC_WORDSPACE = 0x1361;
const char32_t ETHIOPIC_FULL_STOP = 0x1362;
const char32_t ETHIOPIC_COMMA = 0x1363;
const char32_t ETHIOPIC_SEMICOLON = 0x1364;
const char32_t ETHIOPIC_COLON = 0x1365;
const char32_t ETHIOPIC_PREFACE_COLON = 0x1366;
const char32_t ETHIOPIC_QUESTION_MARK = 0x1367;
const char32_t ETHIOPIC_PARAGRAPH_SEPARATOR = 0x1368;
const char32_t ETHIOPIC_DIGIT_ONE = 0x1369;
const char32_t ETHIOPIC_DIGIT_TWO = 0x136A;
const char32_t ETHIOPIC_DIGIT_THREE = 0x136B;
const char32_t ETHIOPIC_DIGIT_FOUR = 0x136C;
const char32_t ETHIOPIC_DIGIT_FIVE = 0x136D;
const char32_t ETHIOPIC_DIGIT_SIX = 0x136E;
const char32_t ETHIOPIC_DIGIT_SEVEN = 0x136F;
const char32_t ETHIOPIC_DIGIT_EIGHT = 0x1370;
const char32_t ETHIOPIC_DIGIT_NINE = 0x1371;
const char32_t ETHIOPIC_NUMBER_TEN = 0x1372;
const char32_t ETHIOPIC_NUMBER_TWENTY = 0x1373;
const char32_t ETHIOPIC_NUMBER_THIRTY = 0x1374;
const char32_t ETHIOPIC_NUMBER_FORTY = 0x1375;
const char32_t ETHIOPIC_NUMBER_FIFTY = 0x1376;
const char32_t ETHIOPIC_NUMBER_SIXTY = 0x1377;
const char32_t ETHIOPIC_NUMBER_SEVENTY = 0x1378;
const char32_t ETHIOPIC_NUMBER_EIGHTY = 0x1379;
const char32_t ETHIOPIC_NUMBER_NINETY = 0x137A;
const char32_t ETHIOPIC_NUMBER_HUNDRED = 0x137B;
const char32_t ETHIOPIC_NUMBER_TEN_THOUSAND = 0x137C;
const char32_t ETHIOPIC_SYLLABLE_SEBATBEIT_MWA = 0x1380;
const char32_t ETHIOPIC_SYLLABLE_MWI = 0x1381;
const char32_t ETHIOPIC_SYLLABLE_MWEE = 0x1382;
const char32_t ETHIOPIC_SYLLABLE_MWE = 0x1383;
const char32_t ETHIOPIC_SYLLABLE_SEBATBEIT_BWA = 0x1384;
const char32_t ETHIOPIC_SYLLABLE_BWI = 0x1385;
const char32_t ETHIOPIC_SYLLABLE_BWEE = 0x1386;
const char32_t ETHIOPIC_SYLLABLE_BWE = 0x1387;
const char32_t ETHIOPIC_SYLLABLE_SEBATBEIT_FWA = 0x1388;
const char32_t ETHIOPIC_SYLLABLE_FWI = 0x1389;
const char32_t ETHIOPIC_SYLLABLE_FWEE = 0x138A;
const char32_t ETHIOPIC_SYLLABLE_FWE = 0x138B;
const char32_t ETHIOPIC_SYLLABLE_SEBATBEIT_PWA = 0x138C;
const char32_t ETHIOPIC_SYLLABLE_PWI = 0x138D;
const char32_t ETHIOPIC_SYLLABLE_PWEE = 0x138E;
const char32_t ETHIOPIC_SYLLABLE_PWE = 0x138F;
const char32_t ETHIOPIC_TONAL_MARK_YIZET = 0x1390;
const char32_t ETHIOPIC_TONAL_MARK_DERET = 0x1391;
const char32_t ETHIOPIC_TONAL_MARK_RIKRIK = 0x1392;
const char32_t ETHIOPIC_TONAL_MARK_SHORT_RIKRIK = 0x1393;
const char32_t ETHIOPIC_TONAL_MARK_DIFAT = 0x1394;
const char32_t ETHIOPIC_TONAL_MARK_KENAT = 0x1395;
const char32_t ETHIOPIC_TONAL_MARK_CHIRET = 0x1396;
const char32_t ETHIOPIC_TONAL_MARK_HIDET = 0x1397;
const char32_t ETHIOPIC_TONAL_MARK_DERET_HIDET = 0x1398;
const char32_t ETHIOPIC_TONAL_MARK_KURT = 0x1399;
const char32_t CHEROKEE_LETTER_A = 0x13A0;
const char32_t CHEROKEE_LETTER_E = 0x13A1;
const char32_t CHEROKEE_LETTER_I = 0x13A2;
const char32_t CHEROKEE_LETTER_O = 0x13A3;
const char32_t CHEROKEE_LETTER_U = 0x13A4;
const char32_t CHEROKEE_LETTER_V = 0x13A5;
const char32_t CHEROKEE_LETTER_GA = 0x13A6;
const char32_t CHEROKEE_LETTER_KA = 0x13A7;
const char32_t CHEROKEE_LETTER_GE = 0x13A8;
const char32_t CHEROKEE_LETTER_GI = 0x13A9;
const char32_t CHEROKEE_LETTER_GO = 0x13AA;
const char32_t CHEROKEE_LETTER_GU = 0x13AB;
const char32_t CHEROKEE_LETTER_GV = 0x13AC;
const char32_t CHEROKEE_LETTER_HA = 0x13AD;
const char32_t CHEROKEE_LETTER_HE = 0x13AE;
const char32_t CHEROKEE_LETTER_HI = 0x13AF;
const char32_t CHEROKEE_LETTER_HO = 0x13B0;
const char32_t CHEROKEE_LETTER_HU = 0x13B1;
const char32_t CHEROKEE_LETTER_HV = 0x13B2;
const char32_t CHEROKEE_LETTER_LA = 0x13B3;
const char32_t CHEROKEE_LETTER_LE = 0x13B4;
const char32_t CHEROKEE_LETTER_LI = 0x13B5;
const char32_t CHEROKEE_LETTER_LO = 0x13B6;
const char32_t CHEROKEE_LETTER_LU = 0x13B7;
const char32_t CHEROKEE_LETTER_LV = 0x13B8;
const char32_t CHEROKEE_LETTER_MA = 0x13B9;
const char32_t CHEROKEE_LETTER_ME = 0x13BA;
const char32_t CHEROKEE_LETTER_MI = 0x13BB;
const char32_t CHEROKEE_LETTER_MO = 0x13BC;
const char32_t CHEROKEE_LETTER_MU = 0x13BD;
const char32_t CHEROKEE_LETTER_NA = 0x13BE;
const char32_t CHEROKEE_LETTER_HNA = 0x13BF;
const char32_t CHEROKEE_LETTER_NAH = 0x13C0;
const char32_t CHEROKEE_LETTER_NE = 0x13C1;
const char32_t CHEROKEE_LETTER_NI = 0x13C2;
const char32_t CHEROKEE_LETTER_NO = 0x13C3;
const char32_t CHEROKEE_LETTER_NU = 0x13C4;
const char32_t CHEROKEE_LETTER_NV = 0x13C5;
const char32_t CHEROKEE_LETTER_QUA = 0x13C6;
const char32_t CHEROKEE_LETTER_QUE = 0x13C7;
const char32_t CHEROKEE_LETTER_QUI = 0x13C8;
const char32_t CHEROKEE_LETTER_QUO = 0x13C9;
const char32_t CHEROKEE_LETTER_QUU = 0x13CA;
const char32_t CHEROKEE_LETTER_QUV = 0x13CB;
const char32_t CHEROKEE_LETTER_SA = 0x13CC;
const char32_t CHEROKEE_LETTER_S = 0x13CD;
const char32_t CHEROKEE_LETTER_SE = 0x13CE;
const char32_t CHEROKEE_LETTER_SI = 0x13CF;
const char32_t CHEROKEE_LETTER_SO = 0x13D0;
const char32_t CHEROKEE_LETTER_SU = 0x13D1;
const char32_t CHEROKEE_LETTER_SV = 0x13D2;
const char32_t CHEROKEE_LETTER_DA = 0x13D3;
const char32_t CHEROKEE_LETTER_TA = 0x13D4;
const char32_t CHEROKEE_LETTER_DE = 0x13D5;
const char32_t CHEROKEE_LETTER_TE = 0x13D6;
const char32_t CHEROKEE_LETTER_DI = 0x13D7;
const char32_t CHEROKEE_LETTER_TI = 0x13D8;
const char32_t CHEROKEE_LETTER_DO = 0x13D9;
const char32_t CHEROKEE_LETTER_DU = 0x13DA;
const char32_t CHEROKEE_LETTER_DV = 0x13DB;
const char32_t CHEROKEE_LETTER_DLA = 0x13DC;
const char32_t CHEROKEE_LETTER_TLA = 0x13DD;
const char32_t CHEROKEE_LETTER_TLE = 0x13DE;
const char32_t CHEROKEE_LETTER_TLI = 0x13DF;
const char32_t CHEROKEE_LETTER_TLO = 0x13E0;
const char32_t CHEROKEE_LETTER_TLU = 0x13E1;
const char32_t CHEROKEE_LETTER_TLV = 0x13E2;
const char32_t CHEROKEE_LETTER_TSA = 0x13E3;
const char32_t CHEROKEE_LETTER_TSE = 0x13E4;
const char32_t CHEROKEE_LETTER_TSI = 0x13E5;
const char32_t CHEROKEE_LETTER_TSO = 0x13E6;
const char32_t CHEROKEE_LETTER_TSU = 0x13E7;
const char32_t CHEROKEE_LETTER_TSV = 0x13E8;
const char32_t CHEROKEE_LETTER_WA = 0x13E9;
const char32_t CHEROKEE_LETTER_WE = 0x13EA;
const char32_t CHEROKEE_LETTER_WI = 0x13EB;
const char32_t CHEROKEE_LETTER_WO = 0x13EC;
const char32_t CHEROKEE_LETTER_WU = 0x13ED;
const char32_t CHEROKEE_LETTER_WV = 0x13EE;
const char32_t CHEROKEE_LETTER_YA = 0x13EF;
const char32_t CHEROKEE_LETTER_YE = 0x13F0;
const char32_t CHEROKEE_LETTER_YI = 0x13F1;
const char32_t CHEROKEE_LETTER_YO = 0x13F2;
const char32_t CHEROKEE_LETTER_YU = 0x13F3;
const char32_t CHEROKEE_LETTER_YV = 0x13F4;
const char32_t CHEROKEE_LETTER_MV = 0x13F5;
const char32_t CHEROKEE_SMALL_LETTER_YE = 0x13F8;
const char32_t CHEROKEE_SMALL_LETTER_YI = 0x13F9;
const char32_t CHEROKEE_SMALL_LETTER_YO = 0x13FA;
const char32_t CHEROKEE_SMALL_LETTER_YU = 0x13FB;
const char32_t CHEROKEE_SMALL_LETTER_YV = 0x13FC;
const char32_t CHEROKEE_SMALL_LETTER_MV = 0x13FD;
const char32_t CANADIAN_SYLLABICS_HYPHEN = 0x1400;
const char32_t CANADIAN_SYLLABICS_E = 0x1401;
const char32_t CANADIAN_SYLLABICS_AAI = 0x1402;
const char32_t CANADIAN_SYLLABICS_I = 0x1403;
const char32_t CANADIAN_SYLLABICS_II = 0x1404;
const char32_t CANADIAN_SYLLABICS_O = 0x1405;
const char32_t CANADIAN_SYLLABICS_OO = 0x1406;
const char32_t CANADIAN_SYLLABICS_Y_CREE_OO = 0x1407;
const char32_t CANADIAN_SYLLABICS_CARRIER_EE = 0x1408;
const char32_t CANADIAN_SYLLABICS_CARRIER_I = 0x1409;
const char32_t CANADIAN_SYLLABICS_A = 0x140A;
const char32_t CANADIAN_SYLLABICS_AA = 0x140B;
const char32_t CANADIAN_SYLLABICS_WE = 0x140C;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_WE = 0x140D;
const char32_t CANADIAN_SYLLABICS_WI = 0x140E;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_WI = 0x140F;
const char32_t CANADIAN_SYLLABICS_WII = 0x1410;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_WII = 0x1411;
const char32_t CANADIAN_SYLLABICS_WO = 0x1412;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_WO = 0x1413;
const char32_t CANADIAN_SYLLABICS_WOO = 0x1414;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_WOO = 0x1415;
const char32_t CANADIAN_SYLLABICS_NASKAPI_WOO = 0x1416;
const char32_t CANADIAN_SYLLABICS_WA = 0x1417;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_WA = 0x1418;
const char32_t CANADIAN_SYLLABICS_WAA = 0x1419;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_WAA = 0x141A;
const char32_t CANADIAN_SYLLABICS_NASKAPI_WAA = 0x141B;
const char32_t CANADIAN_SYLLABICS_AI = 0x141C;
const char32_t CANADIAN_SYLLABICS_Y_CREE_W = 0x141D;
const char32_t CANADIAN_SYLLABICS_GLOTTAL_STOP = 0x141E;
const char32_t CANADIAN_SYLLABICS_FINAL_ACUTE = 0x141F;
const char32_t CANADIAN_SYLLABICS_FINAL_GRAVE = 0x1420;
const char32_t CANADIAN_SYLLABICS_FINAL_BOTTOM_HALF_RING = 0x1421;
const char32_t CANADIAN_SYLLABICS_FINAL_TOP_HALF_RING = 0x1422;
const char32_t CANADIAN_SYLLABICS_FINAL_RIGHT_HALF_RING = 0x1423;
const char32_t CANADIAN_SYLLABICS_FINAL_RING = 0x1424;
const char32_t CANADIAN_SYLLABICS_FINAL_DOUBLE_ACUTE = 0x1425;
const char32_t CANADIAN_SYLLABICS_FINAL_DOUBLE_SHORT_VERTICAL_STROKES = 0x1426;
const char32_t CANADIAN_SYLLABICS_FINAL_MIDDLE_DOT = 0x1427;
const char32_t CANADIAN_SYLLABICS_FINAL_SHORT_HORIZONTAL_STROKE = 0x1428;
const char32_t CANADIAN_SYLLABICS_FINAL_PLUS = 0x1429;
const char32_t CANADIAN_SYLLABICS_FINAL_DOWN_TACK = 0x142A;
const char32_t CANADIAN_SYLLABICS_EN = 0x142B;
const char32_t CANADIAN_SYLLABICS_IN = 0x142C;
const char32_t CANADIAN_SYLLABICS_ON = 0x142D;
const char32_t CANADIAN_SYLLABICS_AN = 0x142E;
const char32_t CANADIAN_SYLLABICS_PE = 0x142F;
const char32_t CANADIAN_SYLLABICS_PAAI = 0x1430;
const char32_t CANADIAN_SYLLABICS_PI = 0x1431;
const char32_t CANADIAN_SYLLABICS_PII = 0x1432;
const char32_t CANADIAN_SYLLABICS_PO = 0x1433;
const char32_t CANADIAN_SYLLABICS_POO = 0x1434;
const char32_t CANADIAN_SYLLABICS_Y_CREE_POO = 0x1435;
const char32_t CANADIAN_SYLLABICS_CARRIER_HEE = 0x1436;
const char32_t CANADIAN_SYLLABICS_CARRIER_HI = 0x1437;
const char32_t CANADIAN_SYLLABICS_PA = 0x1438;
const char32_t CANADIAN_SYLLABICS_PAA = 0x1439;
const char32_t CANADIAN_SYLLABICS_PWE = 0x143A;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_PWE = 0x143B;
const char32_t CANADIAN_SYLLABICS_PWI = 0x143C;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_PWI = 0x143D;
const char32_t CANADIAN_SYLLABICS_PWII = 0x143E;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_PWII = 0x143F;
const char32_t CANADIAN_SYLLABICS_PWO = 0x1440;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_PWO = 0x1441;
const char32_t CANADIAN_SYLLABICS_PWOO = 0x1442;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_PWOO = 0x1443;
const char32_t CANADIAN_SYLLABICS_PWA = 0x1444;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_PWA = 0x1445;
const char32_t CANADIAN_SYLLABICS_PWAA = 0x1446;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_PWAA = 0x1447;
const char32_t CANADIAN_SYLLABICS_Y_CREE_PWAA = 0x1448;
const char32_t CANADIAN_SYLLABICS_P = 0x1449;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_P = 0x144A;
const char32_t CANADIAN_SYLLABICS_CARRIER_H = 0x144B;
const char32_t CANADIAN_SYLLABICS_TE = 0x144C;
const char32_t CANADIAN_SYLLABICS_TAAI = 0x144D;
const char32_t CANADIAN_SYLLABICS_TI = 0x144E;
const char32_t CANADIAN_SYLLABICS_TII = 0x144F;
const char32_t CANADIAN_SYLLABICS_TO = 0x1450;
const char32_t CANADIAN_SYLLABICS_TOO = 0x1451;
const char32_t CANADIAN_SYLLABICS_Y_CREE_TOO = 0x1452;
const char32_t CANADIAN_SYLLABICS_CARRIER_DEE = 0x1453;
const char32_t CANADIAN_SYLLABICS_CARRIER_DI = 0x1454;
const char32_t CANADIAN_SYLLABICS_TA = 0x1455;
const char32_t CANADIAN_SYLLABICS_TAA = 0x1456;
const char32_t CANADIAN_SYLLABICS_TWE = 0x1457;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_TWE = 0x1458;
const char32_t CANADIAN_SYLLABICS_TWI = 0x1459;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_TWI = 0x145A;
const char32_t CANADIAN_SYLLABICS_TWII = 0x145B;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_TWII = 0x145C;
const char32_t CANADIAN_SYLLABICS_TWO = 0x145D;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_TWO = 0x145E;
const char32_t CANADIAN_SYLLABICS_TWOO = 0x145F;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_TWOO = 0x1460;
const char32_t CANADIAN_SYLLABICS_TWA = 0x1461;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_TWA = 0x1462;
const char32_t CANADIAN_SYLLABICS_TWAA = 0x1463;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_TWAA = 0x1464;
const char32_t CANADIAN_SYLLABICS_NASKAPI_TWAA = 0x1465;
const char32_t CANADIAN_SYLLABICS_T = 0x1466;
const char32_t CANADIAN_SYLLABICS_TTE = 0x1467;
const char32_t CANADIAN_SYLLABICS_TTI = 0x1468;
const char32_t CANADIAN_SYLLABICS_TTO = 0x1469;
const char32_t CANADIAN_SYLLABICS_TTA = 0x146A;
const char32_t CANADIAN_SYLLABICS_KE = 0x146B;
const char32_t CANADIAN_SYLLABICS_KAAI = 0x146C;
const char32_t CANADIAN_SYLLABICS_KI = 0x146D;
const char32_t CANADIAN_SYLLABICS_KII = 0x146E;
const char32_t CANADIAN_SYLLABICS_KO = 0x146F;
const char32_t CANADIAN_SYLLABICS_KOO = 0x1470;
const char32_t CANADIAN_SYLLABICS_Y_CREE_KOO = 0x1471;
const char32_t CANADIAN_SYLLABICS_KA = 0x1472;
const char32_t CANADIAN_SYLLABICS_KAA = 0x1473;
const char32_t CANADIAN_SYLLABICS_KWE = 0x1474;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_KWE = 0x1475;
const char32_t CANADIAN_SYLLABICS_KWI = 0x1476;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_KWI = 0x1477;
const char32_t CANADIAN_SYLLABICS_KWII = 0x1478;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_KWII = 0x1479;
const char32_t CANADIAN_SYLLABICS_KWO = 0x147A;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_KWO = 0x147B;
const char32_t CANADIAN_SYLLABICS_KWOO = 0x147C;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_KWOO = 0x147D;
const char32_t CANADIAN_SYLLABICS_KWA = 0x147E;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_KWA = 0x147F;
const char32_t CANADIAN_SYLLABICS_KWAA = 0x1480;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_KWAA = 0x1481;
const char32_t CANADIAN_SYLLABICS_NASKAPI_KWAA = 0x1482;
const char32_t CANADIAN_SYLLABICS_K = 0x1483;
const char32_t CANADIAN_SYLLABICS_KW = 0x1484;
const char32_t CANADIAN_SYLLABICS_SOUTH_SLAVEY_KEH = 0x1485;
const char32_t CANADIAN_SYLLABICS_SOUTH_SLAVEY_KIH = 0x1486;
const char32_t CANADIAN_SYLLABICS_SOUTH_SLAVEY_KOH = 0x1487;
const char32_t CANADIAN_SYLLABICS_SOUTH_SLAVEY_KAH = 0x1488;
const char32_t CANADIAN_SYLLABICS_CE = 0x1489;
const char32_t CANADIAN_SYLLABICS_CAAI = 0x148A;
const char32_t CANADIAN_SYLLABICS_CI = 0x148B;
const char32_t CANADIAN_SYLLABICS_CII = 0x148C;
const char32_t CANADIAN_SYLLABICS_CO = 0x148D;
const char32_t CANADIAN_SYLLABICS_COO = 0x148E;
const char32_t CANADIAN_SYLLABICS_Y_CREE_COO = 0x148F;
const char32_t CANADIAN_SYLLABICS_CA = 0x1490;
const char32_t CANADIAN_SYLLABICS_CAA = 0x1491;
const char32_t CANADIAN_SYLLABICS_CWE = 0x1492;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_CWE = 0x1493;
const char32_t CANADIAN_SYLLABICS_CWI = 0x1494;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_CWI = 0x1495;
const char32_t CANADIAN_SYLLABICS_CWII = 0x1496;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_CWII = 0x1497;
const char32_t CANADIAN_SYLLABICS_CWO = 0x1498;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_CWO = 0x1499;
const char32_t CANADIAN_SYLLABICS_CWOO = 0x149A;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_CWOO = 0x149B;
const char32_t CANADIAN_SYLLABICS_CWA = 0x149C;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_CWA = 0x149D;
const char32_t CANADIAN_SYLLABICS_CWAA = 0x149E;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_CWAA = 0x149F;
const char32_t CANADIAN_SYLLABICS_NASKAPI_CWAA = 0x14A0;
const char32_t CANADIAN_SYLLABICS_C = 0x14A1;
const char32_t CANADIAN_SYLLABICS_SAYISI_TH = 0x14A2;
const char32_t CANADIAN_SYLLABICS_ME = 0x14A3;
const char32_t CANADIAN_SYLLABICS_MAAI = 0x14A4;
const char32_t CANADIAN_SYLLABICS_MI = 0x14A5;
const char32_t CANADIAN_SYLLABICS_MII = 0x14A6;
const char32_t CANADIAN_SYLLABICS_MO = 0x14A7;
const char32_t CANADIAN_SYLLABICS_MOO = 0x14A8;
const char32_t CANADIAN_SYLLABICS_Y_CREE_MOO = 0x14A9;
const char32_t CANADIAN_SYLLABICS_MA = 0x14AA;
const char32_t CANADIAN_SYLLABICS_MAA = 0x14AB;
const char32_t CANADIAN_SYLLABICS_MWE = 0x14AC;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_MWE = 0x14AD;
const char32_t CANADIAN_SYLLABICS_MWI = 0x14AE;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_MWI = 0x14AF;
const char32_t CANADIAN_SYLLABICS_MWII = 0x14B0;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_MWII = 0x14B1;
const char32_t CANADIAN_SYLLABICS_MWO = 0x14B2;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_MWO = 0x14B3;
const char32_t CANADIAN_SYLLABICS_MWOO = 0x14B4;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_MWOO = 0x14B5;
const char32_t CANADIAN_SYLLABICS_MWA = 0x14B6;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_MWA = 0x14B7;
const char32_t CANADIAN_SYLLABICS_MWAA = 0x14B8;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_MWAA = 0x14B9;
const char32_t CANADIAN_SYLLABICS_NASKAPI_MWAA = 0x14BA;
const char32_t CANADIAN_SYLLABICS_M = 0x14BB;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_M = 0x14BC;
const char32_t CANADIAN_SYLLABICS_MH = 0x14BD;
const char32_t CANADIAN_SYLLABICS_ATHAPASCAN_M = 0x14BE;
const char32_t CANADIAN_SYLLABICS_SAYISI_M = 0x14BF;
const char32_t CANADIAN_SYLLABICS_NE = 0x14C0;
const char32_t CANADIAN_SYLLABICS_NAAI = 0x14C1;
const char32_t CANADIAN_SYLLABICS_NI = 0x14C2;
const char32_t CANADIAN_SYLLABICS_NII = 0x14C3;
const char32_t CANADIAN_SYLLABICS_NO = 0x14C4;
const char32_t CANADIAN_SYLLABICS_NOO = 0x14C5;
const char32_t CANADIAN_SYLLABICS_Y_CREE_NOO = 0x14C6;
const char32_t CANADIAN_SYLLABICS_NA = 0x14C7;
const char32_t CANADIAN_SYLLABICS_NAA = 0x14C8;
const char32_t CANADIAN_SYLLABICS_NWE = 0x14C9;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_NWE = 0x14CA;
const char32_t CANADIAN_SYLLABICS_NWA = 0x14CB;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_NWA = 0x14CC;
const char32_t CANADIAN_SYLLABICS_NWAA = 0x14CD;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_NWAA = 0x14CE;
const char32_t CANADIAN_SYLLABICS_NASKAPI_NWAA = 0x14CF;
const char32_t CANADIAN_SYLLABICS_N = 0x14D0;
const char32_t CANADIAN_SYLLABICS_CARRIER_NG = 0x14D1;
const char32_t CANADIAN_SYLLABICS_NH = 0x14D2;
const char32_t CANADIAN_SYLLABICS_LE = 0x14D3;
const char32_t CANADIAN_SYLLABICS_LAAI = 0x14D4;
const char32_t CANADIAN_SYLLABICS_LI = 0x14D5;
const char32_t CANADIAN_SYLLABICS_LII = 0x14D6;
const char32_t CANADIAN_SYLLABICS_LO = 0x14D7;
const char32_t CANADIAN_SYLLABICS_LOO = 0x14D8;
const char32_t CANADIAN_SYLLABICS_Y_CREE_LOO = 0x14D9;
const char32_t CANADIAN_SYLLABICS_LA = 0x14DA;
const char32_t CANADIAN_SYLLABICS_LAA = 0x14DB;
const char32_t CANADIAN_SYLLABICS_LWE = 0x14DC;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_LWE = 0x14DD;
const char32_t CANADIAN_SYLLABICS_LWI = 0x14DE;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_LWI = 0x14DF;
const char32_t CANADIAN_SYLLABICS_LWII = 0x14E0;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_LWII = 0x14E1;
const char32_t CANADIAN_SYLLABICS_LWO = 0x14E2;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_LWO = 0x14E3;
const char32_t CANADIAN_SYLLABICS_LWOO = 0x14E4;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_LWOO = 0x14E5;
const char32_t CANADIAN_SYLLABICS_LWA = 0x14E6;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_LWA = 0x14E7;
const char32_t CANADIAN_SYLLABICS_LWAA = 0x14E8;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_LWAA = 0x14E9;
const char32_t CANADIAN_SYLLABICS_L = 0x14EA;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_L = 0x14EB;
const char32_t CANADIAN_SYLLABICS_MEDIAL_L = 0x14EC;
const char32_t CANADIAN_SYLLABICS_SE = 0x14ED;
const char32_t CANADIAN_SYLLABICS_SAAI = 0x14EE;
const char32_t CANADIAN_SYLLABICS_SI = 0x14EF;
const char32_t CANADIAN_SYLLABICS_SII = 0x14F0;
const char32_t CANADIAN_SYLLABICS_SO = 0x14F1;
const char32_t CANADIAN_SYLLABICS_SOO = 0x14F2;
const char32_t CANADIAN_SYLLABICS_Y_CREE_SOO = 0x14F3;
const char32_t CANADIAN_SYLLABICS_SA = 0x14F4;
const char32_t CANADIAN_SYLLABICS_SAA = 0x14F5;
const char32_t CANADIAN_SYLLABICS_SWE = 0x14F6;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SWE = 0x14F7;
const char32_t CANADIAN_SYLLABICS_SWI = 0x14F8;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SWI = 0x14F9;
const char32_t CANADIAN_SYLLABICS_SWII = 0x14FA;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SWII = 0x14FB;
const char32_t CANADIAN_SYLLABICS_SWO = 0x14FC;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SWO = 0x14FD;
const char32_t CANADIAN_SYLLABICS_SWOO = 0x14FE;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SWOO = 0x14FF;
const char32_t CANADIAN_SYLLABICS_SWA = 0x1500;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SWA = 0x1501;
const char32_t CANADIAN_SYLLABICS_SWAA = 0x1502;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SWAA = 0x1503;
const char32_t CANADIAN_SYLLABICS_NASKAPI_SWAA = 0x1504;
const char32_t CANADIAN_SYLLABICS_S = 0x1505;
const char32_t CANADIAN_SYLLABICS_ATHAPASCAN_S = 0x1506;
const char32_t CANADIAN_SYLLABICS_SW = 0x1507;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_S = 0x1508;
const char32_t CANADIAN_SYLLABICS_MOOSE_CREE_SK = 0x1509;
const char32_t CANADIAN_SYLLABICS_NASKAPI_SKW = 0x150A;
const char32_t CANADIAN_SYLLABICS_NASKAPI_S_W = 0x150B;
const char32_t CANADIAN_SYLLABICS_NASKAPI_SPWA = 0x150C;
const char32_t CANADIAN_SYLLABICS_NASKAPI_STWA = 0x150D;
const char32_t CANADIAN_SYLLABICS_NASKAPI_SKWA = 0x150E;
const char32_t CANADIAN_SYLLABICS_NASKAPI_SCWA = 0x150F;
const char32_t CANADIAN_SYLLABICS_SHE = 0x1510;
const char32_t CANADIAN_SYLLABICS_SHI = 0x1511;
const char32_t CANADIAN_SYLLABICS_SHII = 0x1512;
const char32_t CANADIAN_SYLLABICS_SHO = 0x1513;
const char32_t CANADIAN_SYLLABICS_SHOO = 0x1514;
const char32_t CANADIAN_SYLLABICS_SHA = 0x1515;
const char32_t CANADIAN_SYLLABICS_SHAA = 0x1516;
const char32_t CANADIAN_SYLLABICS_SHWE = 0x1517;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SHWE = 0x1518;
const char32_t CANADIAN_SYLLABICS_SHWI = 0x1519;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SHWI = 0x151A;
const char32_t CANADIAN_SYLLABICS_SHWII = 0x151B;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SHWII = 0x151C;
const char32_t CANADIAN_SYLLABICS_SHWO = 0x151D;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SHWO = 0x151E;
const char32_t CANADIAN_SYLLABICS_SHWOO = 0x151F;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SHWOO = 0x1520;
const char32_t CANADIAN_SYLLABICS_SHWA = 0x1521;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SHWA = 0x1522;
const char32_t CANADIAN_SYLLABICS_SHWAA = 0x1523;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_SHWAA = 0x1524;
const char32_t CANADIAN_SYLLABICS_SH = 0x1525;
const char32_t CANADIAN_SYLLABICS_YE = 0x1526;
const char32_t CANADIAN_SYLLABICS_YAAI = 0x1527;
const char32_t CANADIAN_SYLLABICS_YI = 0x1528;
const char32_t CANADIAN_SYLLABICS_YII = 0x1529;
const char32_t CANADIAN_SYLLABICS_YO = 0x152A;
const char32_t CANADIAN_SYLLABICS_YOO = 0x152B;
const char32_t CANADIAN_SYLLABICS_Y_CREE_YOO = 0x152C;
const char32_t CANADIAN_SYLLABICS_YA = 0x152D;
const char32_t CANADIAN_SYLLABICS_YAA = 0x152E;
const char32_t CANADIAN_SYLLABICS_YWE = 0x152F;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_YWE = 0x1530;
const char32_t CANADIAN_SYLLABICS_YWI = 0x1531;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_YWI = 0x1532;
const char32_t CANADIAN_SYLLABICS_YWII = 0x1533;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_YWII = 0x1534;
const char32_t CANADIAN_SYLLABICS_YWO = 0x1535;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_YWO = 0x1536;
const char32_t CANADIAN_SYLLABICS_YWOO = 0x1537;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_YWOO = 0x1538;
const char32_t CANADIAN_SYLLABICS_YWA = 0x1539;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_YWA = 0x153A;
const char32_t CANADIAN_SYLLABICS_YWAA = 0x153B;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_YWAA = 0x153C;
const char32_t CANADIAN_SYLLABICS_NASKAPI_YWAA = 0x153D;
const char32_t CANADIAN_SYLLABICS_Y = 0x153E;
const char32_t CANADIAN_SYLLABICS_BIBLE_CREE_Y = 0x153F;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_Y = 0x1540;
const char32_t CANADIAN_SYLLABICS_SAYISI_YI = 0x1541;
const char32_t CANADIAN_SYLLABICS_RE = 0x1542;
const char32_t CANADIAN_SYLLABICS_R_CREE_RE = 0x1543;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_LE = 0x1544;
const char32_t CANADIAN_SYLLABICS_RAAI = 0x1545;
const char32_t CANADIAN_SYLLABICS_RI = 0x1546;
const char32_t CANADIAN_SYLLABICS_RII = 0x1547;
const char32_t CANADIAN_SYLLABICS_RO = 0x1548;
const char32_t CANADIAN_SYLLABICS_ROO = 0x1549;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_LO = 0x154A;
const char32_t CANADIAN_SYLLABICS_RA = 0x154B;
const char32_t CANADIAN_SYLLABICS_RAA = 0x154C;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_LA = 0x154D;
const char32_t CANADIAN_SYLLABICS_RWAA = 0x154E;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_RWAA = 0x154F;
const char32_t CANADIAN_SYLLABICS_R = 0x1550;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_R = 0x1551;
const char32_t CANADIAN_SYLLABICS_MEDIAL_R = 0x1552;
const char32_t CANADIAN_SYLLABICS_FE = 0x1553;
const char32_t CANADIAN_SYLLABICS_FAAI = 0x1554;
const char32_t CANADIAN_SYLLABICS_FI = 0x1555;
const char32_t CANADIAN_SYLLABICS_FII = 0x1556;
const char32_t CANADIAN_SYLLABICS_FO = 0x1557;
const char32_t CANADIAN_SYLLABICS_FOO = 0x1558;
const char32_t CANADIAN_SYLLABICS_FA = 0x1559;
const char32_t CANADIAN_SYLLABICS_FAA = 0x155A;
const char32_t CANADIAN_SYLLABICS_FWAA = 0x155B;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_FWAA = 0x155C;
const char32_t CANADIAN_SYLLABICS_F = 0x155D;
const char32_t CANADIAN_SYLLABICS_THE = 0x155E;
const char32_t CANADIAN_SYLLABICS_N_CREE_THE = 0x155F;
const char32_t CANADIAN_SYLLABICS_THI = 0x1560;
const char32_t CANADIAN_SYLLABICS_N_CREE_THI = 0x1561;
const char32_t CANADIAN_SYLLABICS_THII = 0x1562;
const char32_t CANADIAN_SYLLABICS_N_CREE_THII = 0x1563;
const char32_t CANADIAN_SYLLABICS_THO = 0x1564;
const char32_t CANADIAN_SYLLABICS_THOO = 0x1565;
const char32_t CANADIAN_SYLLABICS_THA = 0x1566;
const char32_t CANADIAN_SYLLABICS_THAA = 0x1567;
const char32_t CANADIAN_SYLLABICS_THWAA = 0x1568;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_THWAA = 0x1569;
const char32_t CANADIAN_SYLLABICS_TH = 0x156A;
const char32_t CANADIAN_SYLLABICS_TTHE = 0x156B;
const char32_t CANADIAN_SYLLABICS_TTHI = 0x156C;
const char32_t CANADIAN_SYLLABICS_TTHO = 0x156D;
const char32_t CANADIAN_SYLLABICS_TTHA = 0x156E;
const char32_t CANADIAN_SYLLABICS_TTH = 0x156F;
const char32_t CANADIAN_SYLLABICS_TYE = 0x1570;
const char32_t CANADIAN_SYLLABICS_TYI = 0x1571;
const char32_t CANADIAN_SYLLABICS_TYO = 0x1572;
const char32_t CANADIAN_SYLLABICS_TYA = 0x1573;
const char32_t CANADIAN_SYLLABICS_NUNAVIK_HE = 0x1574;
const char32_t CANADIAN_SYLLABICS_NUNAVIK_HI = 0x1575;
const char32_t CANADIAN_SYLLABICS_NUNAVIK_HII = 0x1576;
const char32_t CANADIAN_SYLLABICS_NUNAVIK_HO = 0x1577;
const char32_t CANADIAN_SYLLABICS_NUNAVIK_HOO = 0x1578;
const char32_t CANADIAN_SYLLABICS_NUNAVIK_HA = 0x1579;
const char32_t CANADIAN_SYLLABICS_NUNAVIK_HAA = 0x157A;
const char32_t CANADIAN_SYLLABICS_NUNAVIK_H = 0x157B;
const char32_t CANADIAN_SYLLABICS_NUNAVUT_H = 0x157C;
const char32_t CANADIAN_SYLLABICS_HK = 0x157D;
const char32_t CANADIAN_SYLLABICS_QAAI = 0x157E;
const char32_t CANADIAN_SYLLABICS_QI = 0x157F;
const char32_t CANADIAN_SYLLABICS_QII = 0x1580;
const char32_t CANADIAN_SYLLABICS_QO = 0x1581;
const char32_t CANADIAN_SYLLABICS_QOO = 0x1582;
const char32_t CANADIAN_SYLLABICS_QA = 0x1583;
const char32_t CANADIAN_SYLLABICS_QAA = 0x1584;
const char32_t CANADIAN_SYLLABICS_Q = 0x1585;
const char32_t CANADIAN_SYLLABICS_TLHE = 0x1586;
const char32_t CANADIAN_SYLLABICS_TLHI = 0x1587;
const char32_t CANADIAN_SYLLABICS_TLHO = 0x1588;
const char32_t CANADIAN_SYLLABICS_TLHA = 0x1589;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_RE = 0x158A;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_RI = 0x158B;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_RO = 0x158C;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_RA = 0x158D;
const char32_t CANADIAN_SYLLABICS_NGAAI = 0x158E;
const char32_t CANADIAN_SYLLABICS_NGI = 0x158F;
const char32_t CANADIAN_SYLLABICS_NGII = 0x1590;
const char32_t CANADIAN_SYLLABICS_NGO = 0x1591;
const char32_t CANADIAN_SYLLABICS_NGOO = 0x1592;
const char32_t CANADIAN_SYLLABICS_NGA = 0x1593;
const char32_t CANADIAN_SYLLABICS_NGAA = 0x1594;
const char32_t CANADIAN_SYLLABICS_NG = 0x1595;
const char32_t CANADIAN_SYLLABICS_NNG = 0x1596;
const char32_t CANADIAN_SYLLABICS_SAYISI_SHE = 0x1597;
const char32_t CANADIAN_SYLLABICS_SAYISI_SHI = 0x1598;
const char32_t CANADIAN_SYLLABICS_SAYISI_SHO = 0x1599;
const char32_t CANADIAN_SYLLABICS_SAYISI_SHA = 0x159A;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_THE = 0x159B;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_THI = 0x159C;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_THO = 0x159D;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_THA = 0x159E;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_TH = 0x159F;
const char32_t CANADIAN_SYLLABICS_LHI = 0x15A0;
const char32_t CANADIAN_SYLLABICS_LHII = 0x15A1;
const char32_t CANADIAN_SYLLABICS_LHO = 0x15A2;
const char32_t CANADIAN_SYLLABICS_LHOO = 0x15A3;
const char32_t CANADIAN_SYLLABICS_LHA = 0x15A4;
const char32_t CANADIAN_SYLLABICS_LHAA = 0x15A5;
const char32_t CANADIAN_SYLLABICS_LH = 0x15A6;
const char32_t CANADIAN_SYLLABICS_TH_CREE_THE = 0x15A7;
const char32_t CANADIAN_SYLLABICS_TH_CREE_THI = 0x15A8;
const char32_t CANADIAN_SYLLABICS_TH_CREE_THII = 0x15A9;
const char32_t CANADIAN_SYLLABICS_TH_CREE_THO = 0x15AA;
const char32_t CANADIAN_SYLLABICS_TH_CREE_THOO = 0x15AB;
const char32_t CANADIAN_SYLLABICS_TH_CREE_THA = 0x15AC;
const char32_t CANADIAN_SYLLABICS_TH_CREE_THAA = 0x15AD;
const char32_t CANADIAN_SYLLABICS_TH_CREE_TH = 0x15AE;
const char32_t CANADIAN_SYLLABICS_AIVILIK_B = 0x15AF;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_E = 0x15B0;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_I = 0x15B1;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_O = 0x15B2;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_A = 0x15B3;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_WE = 0x15B4;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_WI = 0x15B5;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_WO = 0x15B6;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_WA = 0x15B7;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_NE = 0x15B8;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_NI = 0x15B9;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_NO = 0x15BA;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_NA = 0x15BB;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_KE = 0x15BC;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_KI = 0x15BD;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_KO = 0x15BE;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_KA = 0x15BF;
const char32_t CANADIAN_SYLLABICS_SAYISI_HE = 0x15C0;
const char32_t CANADIAN_SYLLABICS_SAYISI_HI = 0x15C1;
const char32_t CANADIAN_SYLLABICS_SAYISI_HO = 0x15C2;
const char32_t CANADIAN_SYLLABICS_SAYISI_HA = 0x15C3;
const char32_t CANADIAN_SYLLABICS_CARRIER_GHU = 0x15C4;
const char32_t CANADIAN_SYLLABICS_CARRIER_GHO = 0x15C5;
const char32_t CANADIAN_SYLLABICS_CARRIER_GHE = 0x15C6;
const char32_t CANADIAN_SYLLABICS_CARRIER_GHEE = 0x15C7;
const char32_t CANADIAN_SYLLABICS_CARRIER_GHI = 0x15C8;
const char32_t CANADIAN_SYLLABICS_CARRIER_GHA = 0x15C9;
const char32_t CANADIAN_SYLLABICS_CARRIER_RU = 0x15CA;
const char32_t CANADIAN_SYLLABICS_CARRIER_RO = 0x15CB;
const char32_t CANADIAN_SYLLABICS_CARRIER_RE = 0x15CC;
const char32_t CANADIAN_SYLLABICS_CARRIER_REE = 0x15CD;
const char32_t CANADIAN_SYLLABICS_CARRIER_RI = 0x15CE;
const char32_t CANADIAN_SYLLABICS_CARRIER_RA = 0x15CF;
const char32_t CANADIAN_SYLLABICS_CARRIER_WU = 0x15D0;
const char32_t CANADIAN_SYLLABICS_CARRIER_WO = 0x15D1;
const char32_t CANADIAN_SYLLABICS_CARRIER_WE = 0x15D2;
const char32_t CANADIAN_SYLLABICS_CARRIER_WEE = 0x15D3;
const char32_t CANADIAN_SYLLABICS_CARRIER_WI = 0x15D4;
const char32_t CANADIAN_SYLLABICS_CARRIER_WA = 0x15D5;
const char32_t CANADIAN_SYLLABICS_CARRIER_HWU = 0x15D6;
const char32_t CANADIAN_SYLLABICS_CARRIER_HWO = 0x15D7;
const char32_t CANADIAN_SYLLABICS_CARRIER_HWE = 0x15D8;
const char32_t CANADIAN_SYLLABICS_CARRIER_HWEE = 0x15D9;
const char32_t CANADIAN_SYLLABICS_CARRIER_HWI = 0x15DA;
const char32_t CANADIAN_SYLLABICS_CARRIER_HWA = 0x15DB;
const char32_t CANADIAN_SYLLABICS_CARRIER_THU = 0x15DC;
const char32_t CANADIAN_SYLLABICS_CARRIER_THO = 0x15DD;
const char32_t CANADIAN_SYLLABICS_CARRIER_THE = 0x15DE;
const char32_t CANADIAN_SYLLABICS_CARRIER_THEE = 0x15DF;
const char32_t CANADIAN_SYLLABICS_CARRIER_THI = 0x15E0;
const char32_t CANADIAN_SYLLABICS_CARRIER_THA = 0x15E1;
const char32_t CANADIAN_SYLLABICS_CARRIER_TTU = 0x15E2;
const char32_t CANADIAN_SYLLABICS_CARRIER_TTO = 0x15E3;
const char32_t CANADIAN_SYLLABICS_CARRIER_TTE = 0x15E4;
const char32_t CANADIAN_SYLLABICS_CARRIER_TTEE = 0x15E5;
const char32_t CANADIAN_SYLLABICS_CARRIER_TTI = 0x15E6;
const char32_t CANADIAN_SYLLABICS_CARRIER_TTA = 0x15E7;
const char32_t CANADIAN_SYLLABICS_CARRIER_PU = 0x15E8;
const char32_t CANADIAN_SYLLABICS_CARRIER_PO = 0x15E9;
const char32_t CANADIAN_SYLLABICS_CARRIER_PE = 0x15EA;
const char32_t CANADIAN_SYLLABICS_CARRIER_PEE = 0x15EB;
const char32_t CANADIAN_SYLLABICS_CARRIER_PI = 0x15EC;
const char32_t CANADIAN_SYLLABICS_CARRIER_PA = 0x15ED;
const char32_t CANADIAN_SYLLABICS_CARRIER_P = 0x15EE;
const char32_t CANADIAN_SYLLABICS_CARRIER_GU = 0x15EF;
const char32_t CANADIAN_SYLLABICS_CARRIER_GO = 0x15F0;
const char32_t CANADIAN_SYLLABICS_CARRIER_GE = 0x15F1;
const char32_t CANADIAN_SYLLABICS_CARRIER_GEE = 0x15F2;
const char32_t CANADIAN_SYLLABICS_CARRIER_GI = 0x15F3;
const char32_t CANADIAN_SYLLABICS_CARRIER_GA = 0x15F4;
const char32_t CANADIAN_SYLLABICS_CARRIER_KHU = 0x15F5;
const char32_t CANADIAN_SYLLABICS_CARRIER_KHO = 0x15F6;
const char32_t CANADIAN_SYLLABICS_CARRIER_KHE = 0x15F7;
const char32_t CANADIAN_SYLLABICS_CARRIER_KHEE = 0x15F8;
const char32_t CANADIAN_SYLLABICS_CARRIER_KHI = 0x15F9;
const char32_t CANADIAN_SYLLABICS_CARRIER_KHA = 0x15FA;
const char32_t CANADIAN_SYLLABICS_CARRIER_KKU = 0x15FB;
const char32_t CANADIAN_SYLLABICS_CARRIER_KKO = 0x15FC;
const char32_t CANADIAN_SYLLABICS_CARRIER_KKE = 0x15FD;
const char32_t CANADIAN_SYLLABICS_CARRIER_KKEE = 0x15FE;
const char32_t CANADIAN_SYLLABICS_CARRIER_KKI = 0x15FF;
const char32_t CANADIAN_SYLLABICS_CARRIER_KKA = 0x1600;
const char32_t CANADIAN_SYLLABICS_CARRIER_KK = 0x1601;
const char32_t CANADIAN_SYLLABICS_CARRIER_NU = 0x1602;
const char32_t CANADIAN_SYLLABICS_CARRIER_NO = 0x1603;
const char32_t CANADIAN_SYLLABICS_CARRIER_NE = 0x1604;
const char32_t CANADIAN_SYLLABICS_CARRIER_NEE = 0x1605;
const char32_t CANADIAN_SYLLABICS_CARRIER_NI = 0x1606;
const char32_t CANADIAN_SYLLABICS_CARRIER_NA = 0x1607;
const char32_t CANADIAN_SYLLABICS_CARRIER_MU = 0x1608;
const char32_t CANADIAN_SYLLABICS_CARRIER_MO = 0x1609;
const char32_t CANADIAN_SYLLABICS_CARRIER_ME = 0x160A;
const char32_t CANADIAN_SYLLABICS_CARRIER_MEE = 0x160B;
const char32_t CANADIAN_SYLLABICS_CARRIER_MI = 0x160C;
const char32_t CANADIAN_SYLLABICS_CARRIER_MA = 0x160D;
const char32_t CANADIAN_SYLLABICS_CARRIER_YU = 0x160E;
const char32_t CANADIAN_SYLLABICS_CARRIER_YO = 0x160F;
const char32_t CANADIAN_SYLLABICS_CARRIER_YE = 0x1610;
const char32_t CANADIAN_SYLLABICS_CARRIER_YEE = 0x1611;
const char32_t CANADIAN_SYLLABICS_CARRIER_YI = 0x1612;
const char32_t CANADIAN_SYLLABICS_CARRIER_YA = 0x1613;
const char32_t CANADIAN_SYLLABICS_CARRIER_JU = 0x1614;
const char32_t CANADIAN_SYLLABICS_SAYISI_JU = 0x1615;
const char32_t CANADIAN_SYLLABICS_CARRIER_JO = 0x1616;
const char32_t CANADIAN_SYLLABICS_CARRIER_JE = 0x1617;
const char32_t CANADIAN_SYLLABICS_CARRIER_JEE = 0x1618;
const char32_t CANADIAN_SYLLABICS_CARRIER_JI = 0x1619;
const char32_t CANADIAN_SYLLABICS_SAYISI_JI = 0x161A;
const char32_t CANADIAN_SYLLABICS_CARRIER_JA = 0x161B;
const char32_t CANADIAN_SYLLABICS_CARRIER_JJU = 0x161C;
const char32_t CANADIAN_SYLLABICS_CARRIER_JJO = 0x161D;
const char32_t CANADIAN_SYLLABICS_CARRIER_JJE = 0x161E;
const char32_t CANADIAN_SYLLABICS_CARRIER_JJEE = 0x161F;
const char32_t CANADIAN_SYLLABICS_CARRIER_JJI = 0x1620;
const char32_t CANADIAN_SYLLABICS_CARRIER_JJA = 0x1621;
const char32_t CANADIAN_SYLLABICS_CARRIER_LU = 0x1622;
const char32_t CANADIAN_SYLLABICS_CARRIER_LO = 0x1623;
const char32_t CANADIAN_SYLLABICS_CARRIER_LE = 0x1624;
const char32_t CANADIAN_SYLLABICS_CARRIER_LEE = 0x1625;
const char32_t CANADIAN_SYLLABICS_CARRIER_LI = 0x1626;
const char32_t CANADIAN_SYLLABICS_CARRIER_LA = 0x1627;
const char32_t CANADIAN_SYLLABICS_CARRIER_DLU = 0x1628;
const char32_t CANADIAN_SYLLABICS_CARRIER_DLO = 0x1629;
const char32_t CANADIAN_SYLLABICS_CARRIER_DLE = 0x162A;
const char32_t CANADIAN_SYLLABICS_CARRIER_DLEE = 0x162B;
const char32_t CANADIAN_SYLLABICS_CARRIER_DLI = 0x162C;
const char32_t CANADIAN_SYLLABICS_CARRIER_DLA = 0x162D;
const char32_t CANADIAN_SYLLABICS_CARRIER_LHU = 0x162E;
const char32_t CANADIAN_SYLLABICS_CARRIER_LHO = 0x162F;
const char32_t CANADIAN_SYLLABICS_CARRIER_LHE = 0x1630;
const char32_t CANADIAN_SYLLABICS_CARRIER_LHEE = 0x1631;
const char32_t CANADIAN_SYLLABICS_CARRIER_LHI = 0x1632;
const char32_t CANADIAN_SYLLABICS_CARRIER_LHA = 0x1633;
const char32_t CANADIAN_SYLLABICS_CARRIER_TLHU = 0x1634;
const char32_t CANADIAN_SYLLABICS_CARRIER_TLHO = 0x1635;
const char32_t CANADIAN_SYLLABICS_CARRIER_TLHE = 0x1636;
const char32_t CANADIAN_SYLLABICS_CARRIER_TLHEE = 0x1637;
const char32_t CANADIAN_SYLLABICS_CARRIER_TLHI = 0x1638;
const char32_t CANADIAN_SYLLABICS_CARRIER_TLHA = 0x1639;
const char32_t CANADIAN_SYLLABICS_CARRIER_TLU = 0x163A;
const char32_t CANADIAN_SYLLABICS_CARRIER_TLO = 0x163B;
const char32_t CANADIAN_SYLLABICS_CARRIER_TLE = 0x163C;
const char32_t CANADIAN_SYLLABICS_CARRIER_TLEE = 0x163D;
const char32_t CANADIAN_SYLLABICS_CARRIER_TLI = 0x163E;
const char32_t CANADIAN_SYLLABICS_CARRIER_TLA = 0x163F;
const char32_t CANADIAN_SYLLABICS_CARRIER_ZU = 0x1640;
const char32_t CANADIAN_SYLLABICS_CARRIER_ZO = 0x1641;
const char32_t CANADIAN_SYLLABICS_CARRIER_ZE = 0x1642;
const char32_t CANADIAN_SYLLABICS_CARRIER_ZEE = 0x1643;
const char32_t CANADIAN_SYLLABICS_CARRIER_ZI = 0x1644;
const char32_t CANADIAN_SYLLABICS_CARRIER_ZA = 0x1645;
const char32_t CANADIAN_SYLLABICS_CARRIER_Z = 0x1646;
const char32_t CANADIAN_SYLLABICS_CARRIER_INITIAL_Z = 0x1647;
const char32_t CANADIAN_SYLLABICS_CARRIER_DZU = 0x1648;
const char32_t CANADIAN_SYLLABICS_CARRIER_DZO = 0x1649;
const char32_t CANADIAN_SYLLABICS_CARRIER_DZE = 0x164A;
const char32_t CANADIAN_SYLLABICS_CARRIER_DZEE = 0x164B;
const char32_t CANADIAN_SYLLABICS_CARRIER_DZI = 0x164C;
const char32_t CANADIAN_SYLLABICS_CARRIER_DZA = 0x164D;
const char32_t CANADIAN_SYLLABICS_CARRIER_SU = 0x164E;
const char32_t CANADIAN_SYLLABICS_CARRIER_SO = 0x164F;
const char32_t CANADIAN_SYLLABICS_CARRIER_SE = 0x1650;
const char32_t CANADIAN_SYLLABICS_CARRIER_SEE = 0x1651;
const char32_t CANADIAN_SYLLABICS_CARRIER_SI = 0x1652;
const char32_t CANADIAN_SYLLABICS_CARRIER_SA = 0x1653;
const char32_t CANADIAN_SYLLABICS_CARRIER_SHU = 0x1654;
const char32_t CANADIAN_SYLLABICS_CARRIER_SHO = 0x1655;
const char32_t CANADIAN_SYLLABICS_CARRIER_SHE = 0x1656;
const char32_t CANADIAN_SYLLABICS_CARRIER_SHEE = 0x1657;
const char32_t CANADIAN_SYLLABICS_CARRIER_SHI = 0x1658;
const char32_t CANADIAN_SYLLABICS_CARRIER_SHA = 0x1659;
const char32_t CANADIAN_SYLLABICS_CARRIER_SH = 0x165A;
const char32_t CANADIAN_SYLLABICS_CARRIER_TSU = 0x165B;
const char32_t CANADIAN_SYLLABICS_CARRIER_TSO = 0x165C;
const char32_t CANADIAN_SYLLABICS_CARRIER_TSE = 0x165D;
const char32_t CANADIAN_SYLLABICS_CARRIER_TSEE = 0x165E;
const char32_t CANADIAN_SYLLABICS_CARRIER_TSI = 0x165F;
const char32_t CANADIAN_SYLLABICS_CARRIER_TSA = 0x1660;
const char32_t CANADIAN_SYLLABICS_CARRIER_CHU = 0x1661;
const char32_t CANADIAN_SYLLABICS_CARRIER_CHO = 0x1662;
const char32_t CANADIAN_SYLLABICS_CARRIER_CHE = 0x1663;
const char32_t CANADIAN_SYLLABICS_CARRIER_CHEE = 0x1664;
const char32_t CANADIAN_SYLLABICS_CARRIER_CHI = 0x1665;
const char32_t CANADIAN_SYLLABICS_CARRIER_CHA = 0x1666;
const char32_t CANADIAN_SYLLABICS_CARRIER_TTSU = 0x1667;
const char32_t CANADIAN_SYLLABICS_CARRIER_TTSO = 0x1668;
const char32_t CANADIAN_SYLLABICS_CARRIER_TTSE = 0x1669;
const char32_t CANADIAN_SYLLABICS_CARRIER_TTSEE = 0x166A;
const char32_t CANADIAN_SYLLABICS_CARRIER_TTSI = 0x166B;
const char32_t CANADIAN_SYLLABICS_CARRIER_TTSA = 0x166C;
const char32_t CANADIAN_SYLLABICS_CHI_SIGN = 0x166D;
const char32_t CANADIAN_SYLLABICS_FULL_STOP = 0x166E;
const char32_t CANADIAN_SYLLABICS_QAI = 0x166F;
const char32_t CANADIAN_SYLLABICS_NGAI = 0x1670;
const char32_t CANADIAN_SYLLABICS_NNGI = 0x1671;
const char32_t CANADIAN_SYLLABICS_NNGII = 0x1672;
const char32_t CANADIAN_SYLLABICS_NNGO = 0x1673;
const char32_t CANADIAN_SYLLABICS_NNGOO = 0x1674;
const char32_t CANADIAN_SYLLABICS_NNGA = 0x1675;
const char32_t CANADIAN_SYLLABICS_NNGAA = 0x1676;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_THWEE = 0x1677;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_THWI = 0x1678;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_THWII = 0x1679;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_THWO = 0x167A;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_THWOO = 0x167B;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_THWA = 0x167C;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_THWAA = 0x167D;
const char32_t CANADIAN_SYLLABICS_WOODS_CREE_FINAL_TH = 0x167E;
const char32_t CANADIAN_SYLLABICS_BLACKFOOT_W = 0x167F;
const char32_t OGHAM_SPACE_MARK = 0x1680;
const char32_t OGHAM_LETTER_BEITH = 0x1681;
const char32_t OGHAM_LETTER_LUIS = 0x1682;
const char32_t OGHAM_LETTER_FEARN = 0x1683;
const char32_t OGHAM_LETTER_SAIL = 0x1684;
const char32_t OGHAM_LETTER_NION = 0x1685;
const char32_t OGHAM_LETTER_UATH = 0x1686;
const char32_t OGHAM_LETTER_DAIR = 0x1687;
const char32_t OGHAM_LETTER_TINNE = 0x1688;
const char32_t OGHAM_LETTER_COLL = 0x1689;
const char32_t OGHAM_LETTER_CEIRT = 0x168A;
const char32_t OGHAM_LETTER_MUIN = 0x168B;
const char32_t OGHAM_LETTER_GORT = 0x168C;
const char32_t OGHAM_LETTER_NGEADAL = 0x168D;
const char32_t OGHAM_LETTER_STRAIF = 0x168E;
const char32_t OGHAM_LETTER_RUIS = 0x168F;
const char32_t OGHAM_LETTER_AILM = 0x1690;
const char32_t OGHAM_LETTER_ONN = 0x1691;
const char32_t OGHAM_LETTER_UR = 0x1692;
const char32_t OGHAM_LETTER_EADHADH = 0x1693;
const char32_t OGHAM_LETTER_IODHADH = 0x1694;
const char32_t OGHAM_LETTER_EABHADH = 0x1695;
const char32_t OGHAM_LETTER_OR = 0x1696;
const char32_t OGHAM_LETTER_UILLEANN = 0x1697;
const char32_t OGHAM_LETTER_IFIN = 0x1698;
const char32_t OGHAM_LETTER_EAMHANCHOLL = 0x1699;
const char32_t OGHAM_LETTER_PEITH = 0x169A;
const char32_t OGHAM_FEATHER_MARK = 0x169B;
const char32_t OGHAM_REVERSED_FEATHER_MARK = 0x169C;
const char32_t RUNIC_LETTER_FEHU_FEOH_FE_F = 0x16A0;
const char32_t RUNIC_LETTER_V = 0x16A1;
const char32_t RUNIC_LETTER_URUZ_UR_U = 0x16A2;
const char32_t RUNIC_LETTER_YR = 0x16A3;
const char32_t RUNIC_LETTER_Y = 0x16A4;
const char32_t RUNIC_LETTER_W = 0x16A5;
const char32_t RUNIC_LETTER_THURISAZ_THURS_THORN = 0x16A6;
const char32_t RUNIC_LETTER_ETH = 0x16A7;
const char32_t RUNIC_LETTER_ANSUZ_A = 0x16A8;
const char32_t RUNIC_LETTER_OS_O = 0x16A9;
const char32_t RUNIC_LETTER_AC_A = 0x16AA;
const char32_t RUNIC_LETTER_AESC = 0x16AB;
const char32_t RUNIC_LETTER_LONG_BRANCH_OSS_O = 0x16AC;
const char32_t RUNIC_LETTER_SHORT_TWIG_OSS_O = 0x16AD;
const char32_t RUNIC_LETTER_O = 0x16AE;
const char32_t RUNIC_LETTER_OE = 0x16AF;
const char32_t RUNIC_LETTER_ON = 0x16B0;
const char32_t RUNIC_LETTER_RAIDO_RAD_REID_R = 0x16B1;
const char32_t RUNIC_LETTER_KAUNA = 0x16B2;
const char32_t RUNIC_LETTER_CEN = 0x16B3;
const char32_t RUNIC_LETTER_KAUN_K = 0x16B4;
const char32_t RUNIC_LETTER_G = 0x16B5;
const char32_t RUNIC_LETTER_ENG = 0x16B6;
const char32_t RUNIC_LETTER_GEBO_GYFU_G = 0x16B7;
const char32_t RUNIC_LETTER_GAR = 0x16B8;
const char32_t RUNIC_LETTER_WUNJO_WYNN_W = 0x16B9;
const char32_t RUNIC_LETTER_HAGLAZ_H = 0x16BA;
const char32_t RUNIC_LETTER_HAEGL_H = 0x16BB;
const char32_t RUNIC_LETTER_LONG_BRANCH_HAGALL_H = 0x16BC;
const char32_t RUNIC_LETTER_SHORT_TWIG_HAGALL_H = 0x16BD;
const char32_t RUNIC_LETTER_NAUDIZ_NYD_NAUD_N = 0x16BE;
const char32_t RUNIC_LETTER_SHORT_TWIG_NAUD_N = 0x16BF;
const char32_t RUNIC_LETTER_DOTTED_N = 0x16C0;
const char32_t RUNIC_LETTER_ISAZ_IS_ISS_I = 0x16C1;
const char32_t RUNIC_LETTER_E = 0x16C2;
const char32_t RUNIC_LETTER_JERAN_J = 0x16C3;
const char32_t RUNIC_LETTER_GER = 0x16C4;
const char32_t RUNIC_LETTER_LONG_BRANCH_AR_AE = 0x16C5;
const char32_t RUNIC_LETTER_SHORT_TWIG_AR_A = 0x16C6;
const char32_t RUNIC_LETTER_IWAZ_EOH = 0x16C7;
const char32_t RUNIC_LETTER_PERTHO_PEORTH_P = 0x16C8;
const char32_t RUNIC_LETTER_ALGIZ_EOLHX = 0x16C9;
const char32_t RUNIC_LETTER_SOWILO_S = 0x16CA;
const char32_t RUNIC_LETTER_SIGEL_LONG_BRANCH_SOL_S = 0x16CB;
const char32_t RUNIC_LETTER_SHORT_TWIG_SOL_S = 0x16CC;
const char32_t RUNIC_LETTER_C = 0x16CD;
const char32_t RUNIC_LETTER_Z = 0x16CE;
const char32_t RUNIC_LETTER_TIWAZ_TIR_TYR_T = 0x16CF;
const char32_t RUNIC_LETTER_SHORT_TWIG_TYR_T = 0x16D0;
const char32_t RUNIC_LETTER_D = 0x16D1;
const char32_t RUNIC_LETTER_BERKANAN_BEORC_BJARKAN_B = 0x16D2;
const char32_t RUNIC_LETTER_SHORT_TWIG_BJARKAN_B = 0x16D3;
const char32_t RUNIC_LETTER_DOTTED_P = 0x16D4;
const char32_t RUNIC_LETTER_OPEN_P = 0x16D5;
const char32_t RUNIC_LETTER_EHWAZ_EH_E = 0x16D6;
const char32_t RUNIC_LETTER_MANNAZ_MAN_M = 0x16D7;
const char32_t RUNIC_LETTER_LONG_BRANCH_MADR_M = 0x16D8;
const char32_t RUNIC_LETTER_SHORT_TWIG_MADR_M = 0x16D9;
const char32_t RUNIC_LETTER_LAUKAZ_LAGU_LOGR_L = 0x16DA;
const char32_t RUNIC_LETTER_DOTTED_L = 0x16DB;
const char32_t RUNIC_LETTER_INGWAZ = 0x16DC;
const char32_t RUNIC_LETTER_ING = 0x16DD;
const char32_t RUNIC_LETTER_DAGAZ_DAEG_D = 0x16DE;
const char32_t RUNIC_LETTER_OTHALAN_ETHEL_O = 0x16DF;
const char32_t RUNIC_LETTER_EAR = 0x16E0;
const char32_t RUNIC_LETTER_IOR = 0x16E1;
const char32_t RUNIC_LETTER_CWEORTH = 0x16E2;
const char32_t RUNIC_LETTER_CALC = 0x16E3;
const char32_t RUNIC_LETTER_CEALC = 0x16E4;
const char32_t RUNIC_LETTER_STAN = 0x16E5;
const char32_t RUNIC_LETTER_LONG_BRANCH_YR = 0x16E6;
const char32_t RUNIC_LETTER_SHORT_TWIG_YR = 0x16E7;
const char32_t RUNIC_LETTER_ICELANDIC_YR = 0x16E8;
const char32_t RUNIC_LETTER_Q = 0x16E9;
const char32_t RUNIC_LETTER_X = 0x16EA;
const char32_t RUNIC_SINGLE_PUNCTUATION = 0x16EB;
const char32_t RUNIC_MULTIPLE_PUNCTUATION = 0x16EC;
const char32_t RUNIC_CROSS_PUNCTUATION = 0x16ED;
const char32_t RUNIC_ARLAUG_SYMBOL = 0x16EE;
const char32_t RUNIC_TVIMADUR_SYMBOL = 0x16EF;
const char32_t RUNIC_BELGTHOR_SYMBOL = 0x16F0;
const char32_t RUNIC_LETTER_K = 0x16F1;
const char32_t RUNIC_LETTER_SH = 0x16F2;
const char32_t RUNIC_LETTER_OO = 0x16F3;
const char32_t RUNIC_LETTER_FRANKS_CASKET_OS = 0x16F4;
const char32_t RUNIC_LETTER_FRANKS_CASKET_IS = 0x16F5;
const char32_t RUNIC_LETTER_FRANKS_CASKET_EH = 0x16F6;
const char32_t RUNIC_LETTER_FRANKS_CASKET_AC = 0x16F7;
const char32_t RUNIC_LETTER_FRANKS_CASKET_AESC = 0x16F8;
const char32_t TAGALOG_LETTER_A = 0x1700;
const char32_t TAGALOG_LETTER_I = 0x1701;
const char32_t TAGALOG_LETTER_U = 0x1702;
const char32_t TAGALOG_LETTER_KA = 0x1703;
const char32_t TAGALOG_LETTER_GA = 0x1704;
const char32_t TAGALOG_LETTER_NGA = 0x1705;
const char32_t TAGALOG_LETTER_TA = 0x1706;
const char32_t TAGALOG_LETTER_DA = 0x1707;
const char32_t TAGALOG_LETTER_NA = 0x1708;
const char32_t TAGALOG_LETTER_PA = 0x1709;
const char32_t TAGALOG_LETTER_BA = 0x170A;
const char32_t TAGALOG_LETTER_MA = 0x170B;
const char32_t TAGALOG_LETTER_YA = 0x170C;
const char32_t TAGALOG_LETTER_LA = 0x170E;
const char32_t TAGALOG_LETTER_WA = 0x170F;
const char32_t TAGALOG_LETTER_SA = 0x1710;
const char32_t TAGALOG_LETTER_HA = 0x1711;
const char32_t TAGALOG_VOWEL_SIGN_I = 0x1712;
const char32_t TAGALOG_VOWEL_SIGN_U = 0x1713;
const char32_t TAGALOG_SIGN_VIRAMA = 0x1714;
const char32_t HANUNOO_LETTER_A = 0x1720;
const char32_t HANUNOO_LETTER_I = 0x1721;
const char32_t HANUNOO_LETTER_U = 0x1722;
const char32_t HANUNOO_LETTER_KA = 0x1723;
const char32_t HANUNOO_LETTER_GA = 0x1724;
const char32_t HANUNOO_LETTER_NGA = 0x1725;
const char32_t HANUNOO_LETTER_TA = 0x1726;
const char32_t HANUNOO_LETTER_DA = 0x1727;
const char32_t HANUNOO_LETTER_NA = 0x1728;
const char32_t HANUNOO_LETTER_PA = 0x1729;
const char32_t HANUNOO_LETTER_BA = 0x172A;
const char32_t HANUNOO_LETTER_MA = 0x172B;
const char32_t HANUNOO_LETTER_YA = 0x172C;
const char32_t HANUNOO_LETTER_RA = 0x172D;
const char32_t HANUNOO_LETTER_LA = 0x172E;
const char32_t HANUNOO_LETTER_WA = 0x172F;
const char32_t HANUNOO_LETTER_SA = 0x1730;
const char32_t HANUNOO_LETTER_HA = 0x1731;
const char32_t HANUNOO_VOWEL_SIGN_I = 0x1732;
const char32_t HANUNOO_VOWEL_SIGN_U = 0x1733;
const char32_t HANUNOO_SIGN_PAMUDPOD = 0x1734;
const char32_t PHILIPPINE_SINGLE_PUNCTUATION = 0x1735;
const char32_t PHILIPPINE_DOUBLE_PUNCTUATION = 0x1736;
const char32_t BUHID_LETTER_A = 0x1740;
const char32_t BUHID_LETTER_I = 0x1741;
const char32_t BUHID_LETTER_U = 0x1742;
const char32_t BUHID_LETTER_KA = 0x1743;
const char32_t BUHID_LETTER_GA = 0x1744;
const char32_t BUHID_LETTER_NGA = 0x1745;
const char32_t BUHID_LETTER_TA = 0x1746;
const char32_t BUHID_LETTER_DA = 0x1747;
const char32_t BUHID_LETTER_NA = 0x1748;
const char32_t BUHID_LETTER_PA = 0x1749;
const char32_t BUHID_LETTER_BA = 0x174A;
const char32_t BUHID_LETTER_MA = 0x174B;
const char32_t BUHID_LETTER_YA = 0x174C;
const char32_t BUHID_LETTER_RA = 0x174D;
const char32_t BUHID_LETTER_LA = 0x174E;
const char32_t BUHID_LETTER_WA = 0x174F;
const char32_t BUHID_LETTER_SA = 0x1750;
const char32_t BUHID_LETTER_HA = 0x1751;
const char32_t BUHID_VOWEL_SIGN_I = 0x1752;
const char32_t BUHID_VOWEL_SIGN_U = 0x1753;
const char32_t TAGBANWA_LETTER_A = 0x1760;
const char32_t TAGBANWA_LETTER_I = 0x1761;
const char32_t TAGBANWA_LETTER_U = 0x1762;
const char32_t TAGBANWA_LETTER_KA = 0x1763;
const char32_t TAGBANWA_LETTER_GA = 0x1764;
const char32_t TAGBANWA_LETTER_NGA = 0x1765;
const char32_t TAGBANWA_LETTER_TA = 0x1766;
const char32_t TAGBANWA_LETTER_DA = 0x1767;
const char32_t TAGBANWA_LETTER_NA = 0x1768;
const char32_t TAGBANWA_LETTER_PA = 0x1769;
const char32_t TAGBANWA_LETTER_BA = 0x176A;
const char32_t TAGBANWA_LETTER_MA = 0x176B;
const char32_t TAGBANWA_LETTER_YA = 0x176C;
const char32_t TAGBANWA_LETTER_LA = 0x176E;
const char32_t TAGBANWA_LETTER_WA = 0x176F;
const char32_t TAGBANWA_LETTER_SA = 0x1770;
const char32_t TAGBANWA_VOWEL_SIGN_I = 0x1772;
const char32_t TAGBANWA_VOWEL_SIGN_U = 0x1773;
const char32_t KHMER_LETTER_KA = 0x1780;
const char32_t KHMER_LETTER_KHA = 0x1781;
const char32_t KHMER_LETTER_KO = 0x1782;
const char32_t KHMER_LETTER_KHO = 0x1783;
const char32_t KHMER_LETTER_NGO = 0x1784;
const char32_t KHMER_LETTER_CA = 0x1785;
const char32_t KHMER_LETTER_CHA = 0x1786;
const char32_t KHMER_LETTER_CO = 0x1787;
const char32_t KHMER_LETTER_CHO = 0x1788;
const char32_t KHMER_LETTER_NYO = 0x1789;
const char32_t KHMER_LETTER_DA = 0x178A;
const char32_t KHMER_LETTER_TTHA = 0x178B;
const char32_t KHMER_LETTER_DO = 0x178C;
const char32_t KHMER_LETTER_TTHO = 0x178D;
const char32_t KHMER_LETTER_NNO = 0x178E;
const char32_t KHMER_LETTER_TA = 0x178F;
const char32_t KHMER_LETTER_THA = 0x1790;
const char32_t KHMER_LETTER_TO = 0x1791;
const char32_t KHMER_LETTER_THO = 0x1792;
const char32_t KHMER_LETTER_NO = 0x1793;
const char32_t KHMER_LETTER_BA = 0x1794;
const char32_t KHMER_LETTER_PHA = 0x1795;
const char32_t KHMER_LETTER_PO = 0x1796;
const char32_t KHMER_LETTER_PHO = 0x1797;
const char32_t KHMER_LETTER_MO = 0x1798;
const char32_t KHMER_LETTER_YO = 0x1799;
const char32_t KHMER_LETTER_RO = 0x179A;
const char32_t KHMER_LETTER_LO = 0x179B;
const char32_t KHMER_LETTER_VO = 0x179C;
const char32_t KHMER_LETTER_SHA = 0x179D;
const char32_t KHMER_LETTER_SSO = 0x179E;
const char32_t KHMER_LETTER_SA = 0x179F;
const char32_t KHMER_LETTER_HA = 0x17A0;
const char32_t KHMER_LETTER_LA = 0x17A1;
const char32_t KHMER_LETTER_QA = 0x17A2;
const char32_t KHMER_INDEPENDENT_VOWEL_QAQ = 0x17A3;
const char32_t KHMER_INDEPENDENT_VOWEL_QAA = 0x17A4;
const char32_t KHMER_INDEPENDENT_VOWEL_QI = 0x17A5;
const char32_t KHMER_INDEPENDENT_VOWEL_QII = 0x17A6;
const char32_t KHMER_INDEPENDENT_VOWEL_QU = 0x17A7;
const char32_t KHMER_INDEPENDENT_VOWEL_QUK = 0x17A8;
const char32_t KHMER_INDEPENDENT_VOWEL_QUU = 0x17A9;
const char32_t KHMER_INDEPENDENT_VOWEL_QUUV = 0x17AA;
const char32_t KHMER_INDEPENDENT_VOWEL_RY = 0x17AB;
const char32_t KHMER_INDEPENDENT_VOWEL_RYY = 0x17AC;
const char32_t KHMER_INDEPENDENT_VOWEL_LY = 0x17AD;
const char32_t KHMER_INDEPENDENT_VOWEL_LYY = 0x17AE;
const char32_t KHMER_INDEPENDENT_VOWEL_QE = 0x17AF;
const char32_t KHMER_INDEPENDENT_VOWEL_QAI = 0x17B0;
const char32_t KHMER_INDEPENDENT_VOWEL_QOO_TYPE_ONE = 0x17B1;
const char32_t KHMER_INDEPENDENT_VOWEL_QOO_TYPE_TWO = 0x17B2;
const char32_t KHMER_INDEPENDENT_VOWEL_QAU = 0x17B3;
const char32_t KHMER_VOWEL_INHERENT_AQ = 0x17B4;
const char32_t KHMER_VOWEL_INHERENT_AA = 0x17B5;
const char32_t KHMER_VOWEL_SIGN_AA = 0x17B6;
const char32_t KHMER_VOWEL_SIGN_I = 0x17B7;
const char32_t KHMER_VOWEL_SIGN_II = 0x17B8;
const char32_t KHMER_VOWEL_SIGN_Y = 0x17B9;
const char32_t KHMER_VOWEL_SIGN_YY = 0x17BA;
const char32_t KHMER_VOWEL_SIGN_U = 0x17BB;
const char32_t KHMER_VOWEL_SIGN_UU = 0x17BC;
const char32_t KHMER_VOWEL_SIGN_UA = 0x17BD;
const char32_t KHMER_VOWEL_SIGN_OE = 0x17BE;
const char32_t KHMER_VOWEL_SIGN_YA = 0x17BF;
const char32_t KHMER_VOWEL_SIGN_IE = 0x17C0;
const char32_t KHMER_VOWEL_SIGN_E = 0x17C1;
const char32_t KHMER_VOWEL_SIGN_AE = 0x17C2;
const char32_t KHMER_VOWEL_SIGN_AI = 0x17C3;
const char32_t KHMER_VOWEL_SIGN_OO = 0x17C4;
const char32_t KHMER_VOWEL_SIGN_AU = 0x17C5;
const char32_t KHMER_SIGN_NIKAHIT = 0x17C6;
const char32_t KHMER_SIGN_REAHMUK = 0x17C7;
const char32_t KHMER_SIGN_YUUKALEAPINTU = 0x17C8;
const char32_t KHMER_SIGN_MUUSIKATOAN = 0x17C9;
const char32_t KHMER_SIGN_TRIISAP = 0x17CA;
const char32_t KHMER_SIGN_BANTOC = 0x17CB;
const char32_t KHMER_SIGN_ROBAT = 0x17CC;
const char32_t KHMER_SIGN_TOANDAKHIAT = 0x17CD;
const char32_t KHMER_SIGN_KAKABAT = 0x17CE;
const char32_t KHMER_SIGN_AHSDA = 0x17CF;
const char32_t KHMER_SIGN_SAMYOK_SANNYA = 0x17D0;
const char32_t KHMER_SIGN_VIRIAM = 0x17D1;
const char32_t KHMER_SIGN_COENG = 0x17D2;
const char32_t KHMER_SIGN_BATHAMASAT = 0x17D3;
const char32_t KHMER_SIGN_KHAN = 0x17D4;
const char32_t KHMER_SIGN_BARIYOOSAN = 0x17D5;
const char32_t KHMER_SIGN_CAMNUC_PII_KUUH = 0x17D6;
const char32_t KHMER_SIGN_LEK_TOO = 0x17D7;
const char32_t KHMER_SIGN_BEYYAL = 0x17D8;
const char32_t KHMER_SIGN_PHNAEK_MUAN = 0x17D9;
const char32_t KHMER_SIGN_KOOMUUT = 0x17DA;
const char32_t KHMER_CURRENCY_SYMBOL_RIEL = 0x17DB;
const char32_t KHMER_SIGN_AVAKRAHASANYA = 0x17DC;
const char32_t KHMER_SIGN_ATTHACAN = 0x17DD;
const char32_t KHMER_DIGIT_ZERO = 0x17E0;
const char32_t KHMER_DIGIT_ONE = 0x17E1;
const char32_t KHMER_DIGIT_TWO = 0x17E2;
const char32_t KHMER_DIGIT_THREE = 0x17E3;
const char32_t KHMER_DIGIT_FOUR = 0x17E4;
const char32_t KHMER_DIGIT_FIVE = 0x17E5;
const char32_t KHMER_DIGIT_SIX = 0x17E6;
const char32_t KHMER_DIGIT_SEVEN = 0x17E7;
const char32_t KHMER_DIGIT_EIGHT = 0x17E8;
const char32_t KHMER_DIGIT_NINE = 0x17E9;
const char32_t KHMER_SYMBOL_LEK_ATTAK_SON = 0x17F0;
const char32_t KHMER_SYMBOL_LEK_ATTAK_MUOY = 0x17F1;
const char32_t KHMER_SYMBOL_LEK_ATTAK_PII = 0x17F2;
const char32_t KHMER_SYMBOL_LEK_ATTAK_BEI = 0x17F3;
const char32_t KHMER_SYMBOL_LEK_ATTAK_BUON = 0x17F4;
const char32_t KHMER_SYMBOL_LEK_ATTAK_PRAM = 0x17F5;
const char32_t KHMER_SYMBOL_LEK_ATTAK_PRAM_MUOY = 0x17F6;
const char32_t KHMER_SYMBOL_LEK_ATTAK_PRAM_PII = 0x17F7;
const char32_t KHMER_SYMBOL_LEK_ATTAK_PRAM_BEI = 0x17F8;
const char32_t KHMER_SYMBOL_LEK_ATTAK_PRAM_BUON = 0x17F9;
const char32_t MONGOLIAN_BIRGA = 0x1800;
const char32_t MONGOLIAN_ELLIPSIS = 0x1801;
const char32_t MONGOLIAN_COMMA = 0x1802;
const char32_t MONGOLIAN_FULL_STOP = 0x1803;
const char32_t MONGOLIAN_COLON = 0x1804;
const char32_t MONGOLIAN_FOUR_DOTS = 0x1805;
const char32_t MONGOLIAN_TODO_SOFT_HYPHEN = 0x1806;
const char32_t MONGOLIAN_SIBE_SYLLABLE_BOUNDARY_MARKER = 0x1807;
const char32_t MONGOLIAN_MANCHU_COMMA = 0x1808;
const char32_t MONGOLIAN_MANCHU_FULL_STOP = 0x1809;
const char32_t MONGOLIAN_NIRUGU = 0x180A;
const char32_t MONGOLIAN_FREE_VARIATION_SELECTOR_ONE = 0x180B;
const char32_t MONGOLIAN_FREE_VARIATION_SELECTOR_TWO = 0x180C;
const char32_t MONGOLIAN_FREE_VARIATION_SELECTOR_THREE = 0x180D;
const char32_t MONGOLIAN_VOWEL_SEPARATOR = 0x180E;
const char32_t MONGOLIAN_DIGIT_ZERO = 0x1810;
const char32_t MONGOLIAN_DIGIT_ONE = 0x1811;
const char32_t MONGOLIAN_DIGIT_TWO = 0x1812;
const char32_t MONGOLIAN_DIGIT_THREE = 0x1813;
const char32_t MONGOLIAN_DIGIT_FOUR = 0x1814;
const char32_t MONGOLIAN_DIGIT_FIVE = 0x1815;
const char32_t MONGOLIAN_DIGIT_SIX = 0x1816;
const char32_t MONGOLIAN_DIGIT_SEVEN = 0x1817;
const char32_t MONGOLIAN_DIGIT_EIGHT = 0x1818;
const char32_t MONGOLIAN_DIGIT_NINE = 0x1819;
const char32_t MONGOLIAN_LETTER_A = 0x1820;
const char32_t MONGOLIAN_LETTER_E = 0x1821;
const char32_t MONGOLIAN_LETTER_I = 0x1822;
const char32_t MONGOLIAN_LETTER_O = 0x1823;
const char32_t MONGOLIAN_LETTER_U = 0x1824;
const char32_t MONGOLIAN_LETTER_OE = 0x1825;
const char32_t MONGOLIAN_LETTER_UE = 0x1826;
const char32_t MONGOLIAN_LETTER_EE = 0x1827;
const char32_t MONGOLIAN_LETTER_NA = 0x1828;
const char32_t MONGOLIAN_LETTER_ANG = 0x1829;
const char32_t MONGOLIAN_LETTER_BA = 0x182A;
const char32_t MONGOLIAN_LETTER_PA = 0x182B;
const char32_t MONGOLIAN_LETTER_QA = 0x182C;
const char32_t MONGOLIAN_LETTER_GA = 0x182D;
const char32_t MONGOLIAN_LETTER_MA = 0x182E;
const char32_t MONGOLIAN_LETTER_LA = 0x182F;
const char32_t MONGOLIAN_LETTER_SA = 0x1830;
const char32_t MONGOLIAN_LETTER_SHA = 0x1831;
const char32_t MONGOLIAN_LETTER_TA = 0x1832;
const char32_t MONGOLIAN_LETTER_DA = 0x1833;
const char32_t MONGOLIAN_LETTER_CHA = 0x1834;
const char32_t MONGOLIAN_LETTER_JA = 0x1835;
const char32_t MONGOLIAN_LETTER_YA = 0x1836;
const char32_t MONGOLIAN_LETTER_RA = 0x1837;
const char32_t MONGOLIAN_LETTER_WA = 0x1838;
const char32_t MONGOLIAN_LETTER_FA = 0x1839;
const char32_t MONGOLIAN_LETTER_KA = 0x183A;
const char32_t MONGOLIAN_LETTER_KHA = 0x183B;
const char32_t MONGOLIAN_LETTER_TSA = 0x183C;
const char32_t MONGOLIAN_LETTER_ZA = 0x183D;
const char32_t MONGOLIAN_LETTER_HAA = 0x183E;
const char32_t MONGOLIAN_LETTER_ZRA = 0x183F;
const char32_t MONGOLIAN_LETTER_LHA = 0x1840;
const char32_t MONGOLIAN_LETTER_ZHI = 0x1841;
const char32_t MONGOLIAN_LETTER_CHI = 0x1842;
const char32_t MONGOLIAN_LETTER_TODO_LONG_VOWEL_SIGN = 0x1843;
const char32_t MONGOLIAN_LETTER_TODO_E = 0x1844;
const char32_t MONGOLIAN_LETTER_TODO_I = 0x1845;
const char32_t MONGOLIAN_LETTER_TODO_O = 0x1846;
const char32_t MONGOLIAN_LETTER_TODO_U = 0x1847;
const char32_t MONGOLIAN_LETTER_TODO_OE = 0x1848;
const char32_t MONGOLIAN_LETTER_TODO_UE = 0x1849;
const char32_t MONGOLIAN_LETTER_TODO_ANG = 0x184A;
const char32_t MONGOLIAN_LETTER_TODO_BA = 0x184B;
const char32_t MONGOLIAN_LETTER_TODO_PA = 0x184C;
const char32_t MONGOLIAN_LETTER_TODO_QA = 0x184D;
const char32_t MONGOLIAN_LETTER_TODO_GA = 0x184E;
const char32_t MONGOLIAN_LETTER_TODO_MA = 0x184F;
const char32_t MONGOLIAN_LETTER_TODO_TA = 0x1850;
const char32_t MONGOLIAN_LETTER_TODO_DA = 0x1851;
const char32_t MONGOLIAN_LETTER_TODO_CHA = 0x1852;
const char32_t MONGOLIAN_LETTER_TODO_JA = 0x1853;
const char32_t MONGOLIAN_LETTER_TODO_TSA = 0x1854;
const char32_t MONGOLIAN_LETTER_TODO_YA = 0x1855;
const char32_t MONGOLIAN_LETTER_TODO_WA = 0x1856;
const char32_t MONGOLIAN_LETTER_TODO_KA = 0x1857;
const char32_t MONGOLIAN_LETTER_TODO_GAA = 0x1858;
const char32_t MONGOLIAN_LETTER_TODO_HAA = 0x1859;
const char32_t MONGOLIAN_LETTER_TODO_JIA = 0x185A;
const char32_t MONGOLIAN_LETTER_TODO_NIA = 0x185B;
const char32_t MONGOLIAN_LETTER_TODO_DZA = 0x185C;
const char32_t MONGOLIAN_LETTER_SIBE_E = 0x185D;
const char32_t MONGOLIAN_LETTER_SIBE_I = 0x185E;
const char32_t MONGOLIAN_LETTER_SIBE_IY = 0x185F;
const char32_t MONGOLIAN_LETTER_SIBE_UE = 0x1860;
const char32_t MONGOLIAN_LETTER_SIBE_U = 0x1861;
const char32_t MONGOLIAN_LETTER_SIBE_ANG = 0x1862;
const char32_t MONGOLIAN_LETTER_SIBE_KA = 0x1863;
const char32_t MONGOLIAN_LETTER_SIBE_GA = 0x1864;
const char32_t MONGOLIAN_LETTER_SIBE_HA = 0x1865;
const char32_t MONGOLIAN_LETTER_SIBE_PA = 0x1866;
const char32_t MONGOLIAN_LETTER_SIBE_SHA = 0x1867;
const char32_t MONGOLIAN_LETTER_SIBE_TA = 0x1868;
const char32_t MONGOLIAN_LETTER_SIBE_DA = 0x1869;
const char32_t MONGOLIAN_LETTER_SIBE_JA = 0x186A;
const char32_t MONGOLIAN_LETTER_SIBE_FA = 0x186B;
const char32_t MONGOLIAN_LETTER_SIBE_GAA = 0x186C;
const char32_t MONGOLIAN_LETTER_SIBE_HAA = 0x186D;
const char32_t MONGOLIAN_LETTER_SIBE_TSA = 0x186E;
const char32_t MONGOLIAN_LETTER_SIBE_ZA = 0x186F;
const char32_t MONGOLIAN_LETTER_SIBE_RAA = 0x1870;
const char32_t MONGOLIAN_LETTER_SIBE_CHA = 0x1871;
const char32_t MONGOLIAN_LETTER_SIBE_ZHA = 0x1872;
const char32_t MONGOLIAN_LETTER_MANCHU_I = 0x1873;
const char32_t MONGOLIAN_LETTER_MANCHU_KA = 0x1874;
const char32_t MONGOLIAN_LETTER_MANCHU_RA = 0x1875;
const char32_t MONGOLIAN_LETTER_MANCHU_FA = 0x1876;
const char32_t MONGOLIAN_LETTER_MANCHU_ZHA = 0x1877;
const char32_t MONGOLIAN_LETTER_CHA_WITH_TWO_DOTS = 0x1878;
const char32_t MONGOLIAN_LETTER_ALI_GALI_ANUSVARA_ONE = 0x1880;
const char32_t MONGOLIAN_LETTER_ALI_GALI_VISARGA_ONE = 0x1881;
const char32_t MONGOLIAN_LETTER_ALI_GALI_DAMARU = 0x1882;
const char32_t MONGOLIAN_LETTER_ALI_GALI_UBADAMA = 0x1883;
const char32_t MONGOLIAN_LETTER_ALI_GALI_INVERTED_UBADAMA = 0x1884;
const char32_t MONGOLIAN_LETTER_ALI_GALI_BALUDA = 0x1885;
const char32_t MONGOLIAN_LETTER_ALI_GALI_THREE_BALUDA = 0x1886;
const char32_t MONGOLIAN_LETTER_ALI_GALI_A = 0x1887;
const char32_t MONGOLIAN_LETTER_ALI_GALI_I = 0x1888;
const char32_t MONGOLIAN_LETTER_ALI_GALI_KA = 0x1889;
const char32_t MONGOLIAN_LETTER_ALI_GALI_NGA = 0x188A;
const char32_t MONGOLIAN_LETTER_ALI_GALI_CA = 0x188B;
const char32_t MONGOLIAN_LETTER_ALI_GALI_TTA = 0x188C;
const char32_t MONGOLIAN_LETTER_ALI_GALI_TTHA = 0x188D;
const char32_t MONGOLIAN_LETTER_ALI_GALI_DDA = 0x188E;
const char32_t MONGOLIAN_LETTER_ALI_GALI_NNA = 0x188F;
const char32_t MONGOLIAN_LETTER_ALI_GALI_TA = 0x1890;
const char32_t MONGOLIAN_LETTER_ALI_GALI_DA = 0x1891;
const char32_t MONGOLIAN_LETTER_ALI_GALI_PA = 0x1892;
const char32_t MONGOLIAN_LETTER_ALI_GALI_PHA = 0x1893;
const char32_t MONGOLIAN_LETTER_ALI_GALI_SSA = 0x1894;
const char32_t MONGOLIAN_LETTER_ALI_GALI_ZHA = 0x1895;
const char32_t MONGOLIAN_LETTER_ALI_GALI_ZA = 0x1896;
const char32_t MONGOLIAN_LETTER_ALI_GALI_AH = 0x1897;
const char32_t MONGOLIAN_LETTER_TODO_ALI_GALI_TA = 0x1898;
const char32_t MONGOLIAN_LETTER_TODO_ALI_GALI_ZHA = 0x1899;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_GHA = 0x189A;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_NGA = 0x189B;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_CA = 0x189C;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_JHA = 0x189D;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_TTA = 0x189E;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_DDHA = 0x189F;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_TA = 0x18A0;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_DHA = 0x18A1;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_SSA = 0x18A2;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_CYA = 0x18A3;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_ZHA = 0x18A4;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_ZA = 0x18A5;
const char32_t MONGOLIAN_LETTER_ALI_GALI_HALF_U = 0x18A6;
const char32_t MONGOLIAN_LETTER_ALI_GALI_HALF_YA = 0x18A7;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_BHA = 0x18A8;
const char32_t MONGOLIAN_LETTER_ALI_GALI_DAGALGA = 0x18A9;
const char32_t MONGOLIAN_LETTER_MANCHU_ALI_GALI_LHA = 0x18AA;
const char32_t CANADIAN_SYLLABICS_OY = 0x18B0;
const char32_t CANADIAN_SYLLABICS_AY = 0x18B1;
const char32_t CANADIAN_SYLLABICS_AAY = 0x18B2;
const char32_t CANADIAN_SYLLABICS_WAY = 0x18B3;
const char32_t CANADIAN_SYLLABICS_POY = 0x18B4;
const char32_t CANADIAN_SYLLABICS_PAY = 0x18B5;
const char32_t CANADIAN_SYLLABICS_PWOY = 0x18B6;
const char32_t CANADIAN_SYLLABICS_TAY = 0x18B7;
const char32_t CANADIAN_SYLLABICS_KAY = 0x18B8;
const char32_t CANADIAN_SYLLABICS_KWAY = 0x18B9;
const char32_t CANADIAN_SYLLABICS_MAY = 0x18BA;
const char32_t CANADIAN_SYLLABICS_NOY = 0x18BB;
const char32_t CANADIAN_SYLLABICS_NAY = 0x18BC;
const char32_t CANADIAN_SYLLABICS_LAY = 0x18BD;
const char32_t CANADIAN_SYLLABICS_SOY = 0x18BE;
const char32_t CANADIAN_SYLLABICS_SAY = 0x18BF;
const char32_t CANADIAN_SYLLABICS_SHOY = 0x18C0;
const char32_t CANADIAN_SYLLABICS_SHAY = 0x18C1;
const char32_t CANADIAN_SYLLABICS_SHWOY = 0x18C2;
const char32_t CANADIAN_SYLLABICS_YOY = 0x18C3;
const char32_t CANADIAN_SYLLABICS_YAY = 0x18C4;
const char32_t CANADIAN_SYLLABICS_RAY = 0x18C5;
const char32_t CANADIAN_SYLLABICS_NWI = 0x18C6;
const char32_t CANADIAN_SYLLABICS_OJIBWAY_NWI = 0x18C7;
const char32_t CANADIAN_SYLLABICS_NWII = 0x18C8;
const char32_t CANADIAN_SYLLABICS_OJIBWAY_NWII = 0x18C9;
const char32_t CANADIAN_SYLLABICS_NWO = 0x18CA;
const char32_t CANADIAN_SYLLABICS_OJIBWAY_NWO = 0x18CB;
const char32_t CANADIAN_SYLLABICS_NWOO = 0x18CC;
const char32_t CANADIAN_SYLLABICS_OJIBWAY_NWOO = 0x18CD;
const char32_t CANADIAN_SYLLABICS_RWEE = 0x18CE;
const char32_t CANADIAN_SYLLABICS_RWI = 0x18CF;
const char32_t CANADIAN_SYLLABICS_RWII = 0x18D0;
const char32_t CANADIAN_SYLLABICS_RWO = 0x18D1;
const char32_t CANADIAN_SYLLABICS_RWOO = 0x18D2;
const char32_t CANADIAN_SYLLABICS_RWA = 0x18D3;
const char32_t CANADIAN_SYLLABICS_OJIBWAY_P = 0x18D4;
const char32_t CANADIAN_SYLLABICS_OJIBWAY_T = 0x18D5;
const char32_t CANADIAN_SYLLABICS_OJIBWAY_K = 0x18D6;
const char32_t CANADIAN_SYLLABICS_OJIBWAY_C = 0x18D7;
const char32_t CANADIAN_SYLLABICS_OJIBWAY_M = 0x18D8;
const char32_t CANADIAN_SYLLABICS_OJIBWAY_N = 0x18D9;
const char32_t CANADIAN_SYLLABICS_OJIBWAY_S = 0x18DA;
const char32_t CANADIAN_SYLLABICS_OJIBWAY_SH = 0x18DB;
const char32_t CANADIAN_SYLLABICS_EASTERN_W = 0x18DC;
const char32_t CANADIAN_SYLLABICS_WESTERN_W = 0x18DD;
const char32_t CANADIAN_SYLLABICS_FINAL_SMALL_RING = 0x18DE;
const char32_t CANADIAN_SYLLABICS_FINAL_RAISED_DOT = 0x18DF;
const char32_t CANADIAN_SYLLABICS_R_CREE_RWE = 0x18E0;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_LOO = 0x18E1;
const char32_t CANADIAN_SYLLABICS_WEST_CREE_LAA = 0x18E2;
const char32_t CANADIAN_SYLLABICS_THWE = 0x18E3;
const char32_t CANADIAN_SYLLABICS_THWA = 0x18E4;
const char32_t CANADIAN_SYLLABICS_TTHWE = 0x18E5;
const char32_t CANADIAN_SYLLABICS_TTHOO = 0x18E6;
const char32_t CANADIAN_SYLLABICS_TTHAA = 0x18E7;
const char32_t CANADIAN_SYLLABICS_TLHWE = 0x18E8;
const char32_t CANADIAN_SYLLABICS_TLHOO = 0x18E9;
const char32_t CANADIAN_SYLLABICS_SAYISI_SHWE = 0x18EA;
const char32_t CANADIAN_SYLLABICS_SAYISI_SHOO = 0x18EB;
const char32_t CANADIAN_SYLLABICS_SAYISI_HOO = 0x18EC;
const char32_t CANADIAN_SYLLABICS_CARRIER_GWU = 0x18ED;
const char32_t CANADIAN_SYLLABICS_CARRIER_DENE_GEE = 0x18EE;
const char32_t CANADIAN_SYLLABICS_CARRIER_GAA = 0x18EF;
const char32_t CANADIAN_SYLLABICS_CARRIER_GWA = 0x18F0;
const char32_t CANADIAN_SYLLABICS_SAYISI_JUU = 0x18F1;
const char32_t CANADIAN_SYLLABICS_CARRIER_JWA = 0x18F2;
const char32_t CANADIAN_SYLLABICS_BEAVER_DENE_L = 0x18F3;
const char32_t CANADIAN_SYLLABICS_BEAVER_DENE_R = 0x18F4;
const char32_t CANADIAN_SYLLABICS_CARRIER_DENTAL_S = 0x18F5;
const char32_t LIMBU_VOWEL_CARRIER_LETTER = 0x1900;
const char32_t LIMBU_LETTER_KA = 0x1901;
const char32_t LIMBU_LETTER_KHA = 0x1902;
const char32_t LIMBU_LETTER_GA = 0x1903;
const char32_t LIMBU_LETTER_GHA = 0x1904;
const char32_t LIMBU_LETTER_NGA = 0x1905;
const char32_t LIMBU_LETTER_CA = 0x1906;
const char32_t LIMBU_LETTER_CHA = 0x1907;
const char32_t LIMBU_LETTER_JA = 0x1908;
const char32_t LIMBU_LETTER_JHA = 0x1909;
const char32_t LIMBU_LETTER_YAN = 0x190A;
const char32_t LIMBU_LETTER_TA = 0x190B;
const char32_t LIMBU_LETTER_THA = 0x190C;
const char32_t LIMBU_LETTER_DA = 0x190D;
const char32_t LIMBU_LETTER_DHA = 0x190E;
const char32_t LIMBU_LETTER_NA = 0x190F;
const char32_t LIMBU_LETTER_PA = 0x1910;
const char32_t LIMBU_LETTER_PHA = 0x1911;
const char32_t LIMBU_LETTER_BA = 0x1912;
const char32_t LIMBU_LETTER_BHA = 0x1913;
const char32_t LIMBU_LETTER_MA = 0x1914;
const char32_t LIMBU_LETTER_YA = 0x1915;
const char32_t LIMBU_LETTER_RA = 0x1916;
const char32_t LIMBU_LETTER_LA = 0x1917;
const char32_t LIMBU_LETTER_WA = 0x1918;
const char32_t LIMBU_LETTER_SHA = 0x1919;
const char32_t LIMBU_LETTER_SSA = 0x191A;
const char32_t LIMBU_LETTER_SA = 0x191B;
const char32_t LIMBU_LETTER_HA = 0x191C;
const char32_t LIMBU_LETTER_GYAN = 0x191D;
const char32_t LIMBU_LETTER_TRA = 0x191E;
const char32_t LIMBU_VOWEL_SIGN_A = 0x1920;
const char32_t LIMBU_VOWEL_SIGN_I = 0x1921;
const char32_t LIMBU_VOWEL_SIGN_U = 0x1922;
const char32_t LIMBU_VOWEL_SIGN_EE = 0x1923;
const char32_t LIMBU_VOWEL_SIGN_AI = 0x1924;
const char32_t LIMBU_VOWEL_SIGN_OO = 0x1925;
const char32_t LIMBU_VOWEL_SIGN_AU = 0x1926;
const char32_t LIMBU_VOWEL_SIGN_E = 0x1927;
const char32_t LIMBU_VOWEL_SIGN_O = 0x1928;
const char32_t LIMBU_SUBJOINED_LETTER_YA = 0x1929;
const char32_t LIMBU_SUBJOINED_LETTER_RA = 0x192A;
const char32_t LIMBU_SUBJOINED_LETTER_WA = 0x192B;
const char32_t LIMBU_SMALL_LETTER_KA = 0x1930;
const char32_t LIMBU_SMALL_LETTER_NGA = 0x1931;
const char32_t LIMBU_SMALL_LETTER_ANUSVARA = 0x1932;
const char32_t LIMBU_SMALL_LETTER_TA = 0x1933;
const char32_t LIMBU_SMALL_LETTER_NA = 0x1934;
const char32_t LIMBU_SMALL_LETTER_PA = 0x1935;
const char32_t LIMBU_SMALL_LETTER_MA = 0x1936;
const char32_t LIMBU_SMALL_LETTER_RA = 0x1937;
const char32_t LIMBU_SMALL_LETTER_LA = 0x1938;
const char32_t LIMBU_SIGN_MUKPHRENG = 0x1939;
const char32_t LIMBU_SIGN_KEMPHRENG = 0x193A;
const char32_t LIMBU_SIGN_SA_I = 0x193B;
const char32_t LIMBU_SIGN_LOO = 0x1940;
const char32_t LIMBU_EXCLAMATION_MARK = 0x1944;
const char32_t LIMBU_QUESTION_MARK = 0x1945;
const char32_t LIMBU_DIGIT_ZERO = 0x1946;
const char32_t LIMBU_DIGIT_ONE = 0x1947;
const char32_t LIMBU_DIGIT_TWO = 0x1948;
const char32_t LIMBU_DIGIT_THREE = 0x1949;
const char32_t LIMBU_DIGIT_FOUR = 0x194A;
const char32_t LIMBU_DIGIT_FIVE = 0x194B;
const char32_t LIMBU_DIGIT_SIX = 0x194C;
const char32_t LIMBU_DIGIT_SEVEN = 0x194D;
const char32_t LIMBU_DIGIT_EIGHT = 0x194E;
const char32_t LIMBU_DIGIT_NINE = 0x194F;
const char32_t TAI_LE_LETTER_KA = 0x1950;
const char32_t TAI_LE_LETTER_XA = 0x1951;
const char32_t TAI_LE_LETTER_NGA = 0x1952;
const char32_t TAI_LE_LETTER_TSA = 0x1953;
const char32_t TAI_LE_LETTER_SA = 0x1954;
const char32_t TAI_LE_LETTER_YA = 0x1955;
const char32_t TAI_LE_LETTER_TA = 0x1956;
const char32_t TAI_LE_LETTER_THA = 0x1957;
const char32_t TAI_LE_LETTER_LA = 0x1958;
const char32_t TAI_LE_LETTER_PA = 0x1959;
const char32_t TAI_LE_LETTER_PHA = 0x195A;
const char32_t TAI_LE_LETTER_MA = 0x195B;
const char32_t TAI_LE_LETTER_FA = 0x195C;
const char32_t TAI_LE_LETTER_VA = 0x195D;
const char32_t TAI_LE_LETTER_HA = 0x195E;
const char32_t TAI_LE_LETTER_QA = 0x195F;
const char32_t TAI_LE_LETTER_KHA = 0x1960;
const char32_t TAI_LE_LETTER_TSHA = 0x1961;
const char32_t TAI_LE_LETTER_NA = 0x1962;
const char32_t TAI_LE_LETTER_A = 0x1963;
const char32_t TAI_LE_LETTER_I = 0x1964;
const char32_t TAI_LE_LETTER_EE = 0x1965;
const char32_t TAI_LE_LETTER_EH = 0x1966;
const char32_t TAI_LE_LETTER_U = 0x1967;
const char32_t TAI_LE_LETTER_OO = 0x1968;
const char32_t TAI_LE_LETTER_O = 0x1969;
const char32_t TAI_LE_LETTER_UE = 0x196A;
const char32_t TAI_LE_LETTER_E = 0x196B;
const char32_t TAI_LE_LETTER_AUE = 0x196C;
const char32_t TAI_LE_LETTER_AI = 0x196D;
const char32_t TAI_LE_LETTER_TONE_2 = 0x1970;
const char32_t TAI_LE_LETTER_TONE_3 = 0x1971;
const char32_t TAI_LE_LETTER_TONE_4 = 0x1972;
const char32_t TAI_LE_LETTER_TONE_5 = 0x1973;
const char32_t TAI_LE_LETTER_TONE_6 = 0x1974;
const char32_t NEW_TAI_LUE_LETTER_HIGH_QA = 0x1980;
const char32_t NEW_TAI_LUE_LETTER_LOW_QA = 0x1981;
const char32_t NEW_TAI_LUE_LETTER_HIGH_KA = 0x1982;
const char32_t NEW_TAI_LUE_LETTER_HIGH_XA = 0x1983;
const char32_t NEW_TAI_LUE_LETTER_HIGH_NGA = 0x1984;
const char32_t NEW_TAI_LUE_LETTER_LOW_KA = 0x1985;
const char32_t NEW_TAI_LUE_LETTER_LOW_XA = 0x1986;
const char32_t NEW_TAI_LUE_LETTER_LOW_NGA = 0x1987;
const char32_t NEW_TAI_LUE_LETTER_HIGH_TSA = 0x1988;
const char32_t NEW_TAI_LUE_LETTER_HIGH_SA = 0x1989;
const char32_t NEW_TAI_LUE_LETTER_HIGH_YA = 0x198A;
const char32_t NEW_TAI_LUE_LETTER_LOW_TSA = 0x198B;
const char32_t NEW_TAI_LUE_LETTER_LOW_SA = 0x198C;
const char32_t NEW_TAI_LUE_LETTER_LOW_YA = 0x198D;
const char32_t NEW_TAI_LUE_LETTER_HIGH_TA = 0x198E;
const char32_t NEW_TAI_LUE_LETTER_HIGH_THA = 0x198F;
const char32_t NEW_TAI_LUE_LETTER_HIGH_NA = 0x1990;
const char32_t NEW_TAI_LUE_LETTER_LOW_TA = 0x1991;
const char32_t NEW_TAI_LUE_LETTER_LOW_THA = 0x1992;
const char32_t NEW_TAI_LUE_LETTER_LOW_NA = 0x1993;
const char32_t NEW_TAI_LUE_LETTER_HIGH_PA = 0x1994;
const char32_t NEW_TAI_LUE_LETTER_HIGH_PHA = 0x1995;
const char32_t NEW_TAI_LUE_LETTER_HIGH_MA = 0x1996;
const char32_t NEW_TAI_LUE_LETTER_LOW_PA = 0x1997;
const char32_t NEW_TAI_LUE_LETTER_LOW_PHA = 0x1998;
const char32_t NEW_TAI_LUE_LETTER_LOW_MA = 0x1999;
const char32_t NEW_TAI_LUE_LETTER_HIGH_FA = 0x199A;
const char32_t NEW_TAI_LUE_LETTER_HIGH_VA = 0x199B;
const char32_t NEW_TAI_LUE_LETTER_HIGH_LA = 0x199C;
const char32_t NEW_TAI_LUE_LETTER_LOW_FA = 0x199D;
const char32_t NEW_TAI_LUE_LETTER_LOW_VA = 0x199E;
const char32_t NEW_TAI_LUE_LETTER_LOW_LA = 0x199F;
const char32_t NEW_TAI_LUE_LETTER_HIGH_HA = 0x19A0;
const char32_t NEW_TAI_LUE_LETTER_HIGH_DA = 0x19A1;
const char32_t NEW_TAI_LUE_LETTER_HIGH_BA = 0x19A2;
const char32_t NEW_TAI_LUE_LETTER_LOW_HA = 0x19A3;
const char32_t NEW_TAI_LUE_LETTER_LOW_DA = 0x19A4;
const char32_t NEW_TAI_LUE_LETTER_LOW_BA = 0x19A5;
const char32_t NEW_TAI_LUE_LETTER_HIGH_KVA = 0x19A6;
const char32_t NEW_TAI_LUE_LETTER_HIGH_XVA = 0x19A7;
const char32_t NEW_TAI_LUE_LETTER_LOW_KVA = 0x19A8;
const char32_t NEW_TAI_LUE_LETTER_LOW_XVA = 0x19A9;
const char32_t NEW_TAI_LUE_LETTER_HIGH_SUA = 0x19AA;
const char32_t NEW_TAI_LUE_LETTER_LOW_SUA = 0x19AB;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_VOWEL_SHORTENER = 0x19B0;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_AA = 0x19B1;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_II = 0x19B2;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_U = 0x19B3;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_UU = 0x19B4;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_E = 0x19B5;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_AE = 0x19B6;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_O = 0x19B7;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_OA = 0x19B8;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_UE = 0x19B9;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_AY = 0x19BA;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_AAY = 0x19BB;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_UY = 0x19BC;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_OY = 0x19BD;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_OAY = 0x19BE;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_UEY = 0x19BF;
const char32_t NEW_TAI_LUE_VOWEL_SIGN_IY = 0x19C0;
const char32_t NEW_TAI_LUE_LETTER_FINAL_V = 0x19C1;
const char32_t NEW_TAI_LUE_LETTER_FINAL_NG = 0x19C2;
const char32_t NEW_TAI_LUE_LETTER_FINAL_N = 0x19C3;
const char32_t NEW_TAI_LUE_LETTER_FINAL_M = 0x19C4;
const char32_t NEW_TAI_LUE_LETTER_FINAL_K = 0x19C5;
const char32_t NEW_TAI_LUE_LETTER_FINAL_D = 0x19C6;
const char32_t NEW_TAI_LUE_LETTER_FINAL_B = 0x19C7;
const char32_t NEW_TAI_LUE_TONE_MARK_1 = 0x19C8;
const char32_t NEW_TAI_LUE_TONE_MARK_2 = 0x19C9;
const char32_t NEW_TAI_LUE_DIGIT_ZERO = 0x19D0;
const char32_t NEW_TAI_LUE_DIGIT_ONE = 0x19D1;
const char32_t NEW_TAI_LUE_DIGIT_TWO = 0x19D2;
const char32_t NEW_TAI_LUE_DIGIT_THREE = 0x19D3;
const char32_t NEW_TAI_LUE_DIGIT_FOUR = 0x19D4;
const char32_t NEW_TAI_LUE_DIGIT_FIVE = 0x19D5;
const char32_t NEW_TAI_LUE_DIGIT_SIX = 0x19D6;
const char32_t NEW_TAI_LUE_DIGIT_SEVEN = 0x19D7;
const char32_t NEW_TAI_LUE_DIGIT_EIGHT = 0x19D8;
const char32_t NEW_TAI_LUE_DIGIT_NINE = 0x19D9;
const char32_t NEW_TAI_LUE_THAM_DIGIT_ONE = 0x19DA;
const char32_t NEW_TAI_LUE_SIGN_LAE = 0x19DE;
const char32_t NEW_TAI_LUE_SIGN_LAEV = 0x19DF;
const char32_t KHMER_SYMBOL_PATHAMASAT = 0x19E0;
const char32_t KHMER_SYMBOL_MUOY_KOET = 0x19E1;
const char32_t KHMER_SYMBOL_PII_KOET = 0x19E2;
const char32_t KHMER_SYMBOL_BEI_KOET = 0x19E3;
const char32_t KHMER_SYMBOL_BUON_KOET = 0x19E4;
const char32_t KHMER_SYMBOL_PRAM_KOET = 0x19E5;
const char32_t KHMER_SYMBOL_PRAM_MUOY_KOET = 0x19E6;
const char32_t KHMER_SYMBOL_PRAM_PII_KOET = 0x19E7;
const char32_t KHMER_SYMBOL_PRAM_BEI_KOET = 0x19E8;
const char32_t KHMER_SYMBOL_PRAM_BUON_KOET = 0x19E9;
const char32_t KHMER_SYMBOL_DAP_KOET = 0x19EA;
const char32_t KHMER_SYMBOL_DAP_MUOY_KOET = 0x19EB;
const char32_t KHMER_SYMBOL_DAP_PII_KOET = 0x19EC;
const char32_t KHMER_SYMBOL_DAP_BEI_KOET = 0x19ED;
const char32_t KHMER_SYMBOL_DAP_BUON_KOET = 0x19EE;
const char32_t KHMER_SYMBOL_DAP_PRAM_KOET = 0x19EF;
const char32_t KHMER_SYMBOL_TUTEYASAT = 0x19F0;
const char32_t KHMER_SYMBOL_MUOY_ROC = 0x19F1;
const char32_t KHMER_SYMBOL_PII_ROC = 0x19F2;
const char32_t KHMER_SYMBOL_BEI_ROC = 0x19F3;
const char32_t KHMER_SYMBOL_BUON_ROC = 0x19F4;
const char32_t KHMER_SYMBOL_PRAM_ROC = 0x19F5;
const char32_t KHMER_SYMBOL_PRAM_MUOY_ROC = 0x19F6;
const char32_t KHMER_SYMBOL_PRAM_PII_ROC = 0x19F7;
const char32_t KHMER_SYMBOL_PRAM_BEI_ROC = 0x19F8;
const char32_t KHMER_SYMBOL_PRAM_BUON_ROC = 0x19F9;
const char32_t KHMER_SYMBOL_DAP_ROC = 0x19FA;
const char32_t KHMER_SYMBOL_DAP_MUOY_ROC = 0x19FB;
const char32_t KHMER_SYMBOL_DAP_PII_ROC = 0x19FC;
const char32_t KHMER_SYMBOL_DAP_BEI_ROC = 0x19FD;
const char32_t KHMER_SYMBOL_DAP_BUON_ROC = 0x19FE;
const char32_t KHMER_SYMBOL_DAP_PRAM_ROC = 0x19FF;
const char32_t BUGINESE_LETTER_KA = 0x1A00;
const char32_t BUGINESE_LETTER_GA = 0x1A01;
const char32_t BUGINESE_LETTER_NGA = 0x1A02;
const char32_t BUGINESE_LETTER_NGKA = 0x1A03;
const char32_t BUGINESE_LETTER_PA = 0x1A04;
const char32_t BUGINESE_LETTER_BA = 0x1A05;
const char32_t BUGINESE_LETTER_MA = 0x1A06;
const char32_t BUGINESE_LETTER_MPA = 0x1A07;
const char32_t BUGINESE_LETTER_TA = 0x1A08;
const char32_t BUGINESE_LETTER_DA = 0x1A09;
const char32_t BUGINESE_LETTER_NA = 0x1A0A;
const char32_t BUGINESE_LETTER_NRA = 0x1A0B;
const char32_t BUGINESE_LETTER_CA = 0x1A0C;
const char32_t BUGINESE_LETTER_JA = 0x1A0D;
const char32_t BUGINESE_LETTER_NYA = 0x1A0E;
const char32_t BUGINESE_LETTER_NYCA = 0x1A0F;
const char32_t BUGINESE_LETTER_YA = 0x1A10;
const char32_t BUGINESE_LETTER_RA = 0x1A11;
const char32_t BUGINESE_LETTER_LA = 0x1A12;
const char32_t BUGINESE_LETTER_VA = 0x1A13;
const char32_t BUGINESE_LETTER_SA = 0x1A14;
const char32_t BUGINESE_LETTER_A = 0x1A15;
const char32_t BUGINESE_LETTER_HA = 0x1A16;
const char32_t BUGINESE_VOWEL_SIGN_I = 0x1A17;
const char32_t BUGINESE_VOWEL_SIGN_U = 0x1A18;
const char32_t BUGINESE_VOWEL_SIGN_E = 0x1A19;
const char32_t BUGINESE_VOWEL_SIGN_O = 0x1A1A;
const char32_t BUGINESE_VOWEL_SIGN_AE = 0x1A1B;
const char32_t BUGINESE_PALLAWA = 0x1A1E;
const char32_t BUGINESE_END_OF_SECTION = 0x1A1F;
const char32_t TAI_THAM_LETTER_HIGH_KA = 0x1A20;
const char32_t TAI_THAM_LETTER_HIGH_KHA = 0x1A21;
const char32_t TAI_THAM_LETTER_HIGH_KXA = 0x1A22;
const char32_t TAI_THAM_LETTER_LOW_KA = 0x1A23;
const char32_t TAI_THAM_LETTER_LOW_KXA = 0x1A24;
const char32_t TAI_THAM_LETTER_LOW_KHA = 0x1A25;
const char32_t TAI_THAM_LETTER_NGA = 0x1A26;
const char32_t TAI_THAM_LETTER_HIGH_CA = 0x1A27;
const char32_t TAI_THAM_LETTER_HIGH_CHA = 0x1A28;
const char32_t TAI_THAM_LETTER_LOW_CA = 0x1A29;
const char32_t TAI_THAM_LETTER_LOW_SA = 0x1A2A;
const char32_t TAI_THAM_LETTER_LOW_CHA = 0x1A2B;
const char32_t TAI_THAM_LETTER_NYA = 0x1A2C;
const char32_t TAI_THAM_LETTER_RATA = 0x1A2D;
const char32_t TAI_THAM_LETTER_HIGH_RATHA = 0x1A2E;
const char32_t TAI_THAM_LETTER_DA = 0x1A2F;
const char32_t TAI_THAM_LETTER_LOW_RATHA = 0x1A30;
const char32_t TAI_THAM_LETTER_RANA = 0x1A31;
const char32_t TAI_THAM_LETTER_HIGH_TA = 0x1A32;
const char32_t TAI_THAM_LETTER_HIGH_THA = 0x1A33;
const char32_t TAI_THAM_LETTER_LOW_TA = 0x1A34;
const char32_t TAI_THAM_LETTER_LOW_THA = 0x1A35;
const char32_t TAI_THAM_LETTER_NA = 0x1A36;
const char32_t TAI_THAM_LETTER_BA = 0x1A37;
const char32_t TAI_THAM_LETTER_HIGH_PA = 0x1A38;
const char32_t TAI_THAM_LETTER_HIGH_PHA = 0x1A39;
const char32_t TAI_THAM_LETTER_HIGH_FA = 0x1A3A;
const char32_t TAI_THAM_LETTER_LOW_PA = 0x1A3B;
const char32_t TAI_THAM_LETTER_LOW_FA = 0x1A3C;
const char32_t TAI_THAM_LETTER_LOW_PHA = 0x1A3D;
const char32_t TAI_THAM_LETTER_MA = 0x1A3E;
const char32_t TAI_THAM_LETTER_LOW_YA = 0x1A3F;
const char32_t TAI_THAM_LETTER_HIGH_YA = 0x1A40;
const char32_t TAI_THAM_LETTER_RA = 0x1A41;
const char32_t TAI_THAM_LETTER_RUE = 0x1A42;
const char32_t TAI_THAM_LETTER_LA = 0x1A43;
const char32_t TAI_THAM_LETTER_LUE = 0x1A44;
const char32_t TAI_THAM_LETTER_WA = 0x1A45;
const char32_t TAI_THAM_LETTER_HIGH_SHA = 0x1A46;
const char32_t TAI_THAM_LETTER_HIGH_SSA = 0x1A47;
const char32_t TAI_THAM_LETTER_HIGH_SA = 0x1A48;
const char32_t TAI_THAM_LETTER_HIGH_HA = 0x1A49;
const char32_t TAI_THAM_LETTER_LLA = 0x1A4A;
const char32_t TAI_THAM_LETTER_A = 0x1A4B;
const char32_t TAI_THAM_LETTER_LOW_HA = 0x1A4C;
const char32_t TAI_THAM_LETTER_I = 0x1A4D;
const char32_t TAI_THAM_LETTER_II = 0x1A4E;
const char32_t TAI_THAM_LETTER_U = 0x1A4F;
const char32_t TAI_THAM_LETTER_UU = 0x1A50;
const char32_t TAI_THAM_LETTER_EE = 0x1A51;
const char32_t TAI_THAM_LETTER_OO = 0x1A52;
const char32_t TAI_THAM_LETTER_LAE = 0x1A53;
const char32_t TAI_THAM_LETTER_GREAT_SA = 0x1A54;
const char32_t TAI_THAM_CONSONANT_SIGN_MEDIAL_RA = 0x1A55;
const char32_t TAI_THAM_CONSONANT_SIGN_MEDIAL_LA = 0x1A56;
const char32_t TAI_THAM_CONSONANT_SIGN_LA_TANG_LAI = 0x1A57;
const char32_t TAI_THAM_SIGN_MAI_KANG_LAI = 0x1A58;
const char32_t TAI_THAM_CONSONANT_SIGN_FINAL_NGA = 0x1A59;
const char32_t TAI_THAM_CONSONANT_SIGN_LOW_PA = 0x1A5A;
const char32_t TAI_THAM_CONSONANT_SIGN_HIGH_RATHA_OR_LOW_PA = 0x1A5B;
const char32_t TAI_THAM_CONSONANT_SIGN_MA = 0x1A5C;
const char32_t TAI_THAM_CONSONANT_SIGN_BA = 0x1A5D;
const char32_t TAI_THAM_CONSONANT_SIGN_SA = 0x1A5E;
const char32_t TAI_THAM_SIGN_SAKOT = 0x1A60;
const char32_t TAI_THAM_VOWEL_SIGN_A = 0x1A61;
const char32_t TAI_THAM_VOWEL_SIGN_MAI_SAT = 0x1A62;
const char32_t TAI_THAM_VOWEL_SIGN_AA = 0x1A63;
const char32_t TAI_THAM_VOWEL_SIGN_TALL_AA = 0x1A64;
const char32_t TAI_THAM_VOWEL_SIGN_I = 0x1A65;
const char32_t TAI_THAM_VOWEL_SIGN_II = 0x1A66;
const char32_t TAI_THAM_VOWEL_SIGN_UE = 0x1A67;
const char32_t TAI_THAM_VOWEL_SIGN_UUE = 0x1A68;
const char32_t TAI_THAM_VOWEL_SIGN_U = 0x1A69;
const char32_t TAI_THAM_VOWEL_SIGN_UU = 0x1A6A;
const char32_t TAI_THAM_VOWEL_SIGN_O = 0x1A6B;
const char32_t TAI_THAM_VOWEL_SIGN_OA_BELOW = 0x1A6C;
const char32_t TAI_THAM_VOWEL_SIGN_OY = 0x1A6D;
const char32_t TAI_THAM_VOWEL_SIGN_E = 0x1A6E;
const char32_t TAI_THAM_VOWEL_SIGN_AE = 0x1A6F;
const char32_t TAI_THAM_VOWEL_SIGN_OO = 0x1A70;
const char32_t TAI_THAM_VOWEL_SIGN_AI = 0x1A71;
const char32_t TAI_THAM_VOWEL_SIGN_THAM_AI = 0x1A72;
const char32_t TAI_THAM_VOWEL_SIGN_OA_ABOVE = 0x1A73;
const char32_t TAI_THAM_SIGN_MAI_KANG = 0x1A74;
const char32_t TAI_THAM_SIGN_TONE_1 = 0x1A75;
const char32_t TAI_THAM_SIGN_TONE_2 = 0x1A76;
const char32_t TAI_THAM_SIGN_KHUEN_TONE_3 = 0x1A77;
const char32_t TAI_THAM_SIGN_KHUEN_TONE_4 = 0x1A78;
const char32_t TAI_THAM_SIGN_KHUEN_TONE_5 = 0x1A79;
const char32_t TAI_THAM_SIGN_RA_HAAM = 0x1A7A;
const char32_t TAI_THAM_SIGN_MAI_SAM = 0x1A7B;
const char32_t TAI_THAM_SIGN_KHUEN_LUE_KARAN = 0x1A7C;
const char32_t TAI_THAM_COMBINING_CRYPTOGRAMMIC_DOT = 0x1A7F;
const char32_t TAI_THAM_HORA_DIGIT_ZERO = 0x1A80;
const char32_t TAI_THAM_HORA_DIGIT_ONE = 0x1A81;
const char32_t TAI_THAM_HORA_DIGIT_TWO = 0x1A82;
const char32_t TAI_THAM_HORA_DIGIT_THREE = 0x1A83;
const char32_t TAI_THAM_HORA_DIGIT_FOUR = 0x1A84;
const char32_t TAI_THAM_HORA_DIGIT_FIVE = 0x1A85;
const char32_t TAI_THAM_HORA_DIGIT_SIX = 0x1A86;
const char32_t TAI_THAM_HORA_DIGIT_SEVEN = 0x1A87;
const char32_t TAI_THAM_HORA_DIGIT_EIGHT = 0x1A88;
const char32_t TAI_THAM_HORA_DIGIT_NINE = 0x1A89;
const char32_t TAI_THAM_THAM_DIGIT_ZERO = 0x1A90;
const char32_t TAI_THAM_THAM_DIGIT_ONE = 0x1A91;
const char32_t TAI_THAM_THAM_DIGIT_TWO = 0x1A92;
const char32_t TAI_THAM_THAM_DIGIT_THREE = 0x1A93;
const char32_t TAI_THAM_THAM_DIGIT_FOUR = 0x1A94;
const char32_t TAI_THAM_THAM_DIGIT_FIVE = 0x1A95;
const char32_t TAI_THAM_THAM_DIGIT_SIX = 0x1A96;
const char32_t TAI_THAM_THAM_DIGIT_SEVEN = 0x1A97;
const char32_t TAI_THAM_THAM_DIGIT_EIGHT = 0x1A98;
const char32_t TAI_THAM_THAM_DIGIT_NINE = 0x1A99;
const char32_t TAI_THAM_SIGN_WIANG = 0x1AA0;
const char32_t TAI_THAM_SIGN_WIANGWAAK = 0x1AA1;
const char32_t TAI_THAM_SIGN_SAWAN = 0x1AA2;
const char32_t TAI_THAM_SIGN_KEOW = 0x1AA3;
const char32_t TAI_THAM_SIGN_HOY = 0x1AA4;
const char32_t TAI_THAM_SIGN_DOKMAI = 0x1AA5;
const char32_t TAI_THAM_SIGN_REVERSED_ROTATED_RANA = 0x1AA6;
const char32_t TAI_THAM_SIGN_MAI_YAMOK = 0x1AA7;
const char32_t TAI_THAM_SIGN_KAAN = 0x1AA8;
const char32_t TAI_THAM_SIGN_KAANKUU = 0x1AA9;
const char32_t TAI_THAM_SIGN_SATKAAN = 0x1AAA;
const char32_t TAI_THAM_SIGN_SATKAANKUU = 0x1AAB;
const char32_t TAI_THAM_SIGN_HANG = 0x1AAC;
const char32_t TAI_THAM_SIGN_CAANG = 0x1AAD;
const char32_t COMBINING_DOUBLED_CIRCUMFLEX_ACCENT = 0x1AB0;
const char32_t COMBINING_DIAERESIS_RING = 0x1AB1;
const char32_t COMBINING_INFINITY = 0x1AB2;
const char32_t COMBINING_DOWNWARDS_ARROW = 0x1AB3;
const char32_t COMBINING_TRIPLE_DOT = 0x1AB4;
const char32_t COMBINING_X_X_BELOW = 0x1AB5;
const char32_t COMBINING_WIGGLY_LINE_BELOW = 0x1AB6;
const char32_t COMBINING_OPEN_MARK_BELOW = 0x1AB7;
const char32_t COMBINING_DOUBLE_OPEN_MARK_BELOW = 0x1AB8;
const char32_t COMBINING_LIGHT_CENTRALIZATION_STROKE_BELOW = 0x1AB9;
const char32_t COMBINING_STRONG_CENTRALIZATION_STROKE_BELOW = 0x1ABA;
const char32_t COMBINING_PARENTHESES_ABOVE = 0x1ABB;
const char32_t COMBINING_DOUBLE_PARENTHESES_ABOVE = 0x1ABC;
const char32_t COMBINING_PARENTHESES_BELOW = 0x1ABD;
const char32_t COMBINING_PARENTHESES_OVERLAY = 0x1ABE;
const char32_t COMBINING_LATIN_SMALL_LETTER_W_BELOW = 0x1ABF;
const char32_t COMBINING_LATIN_SMALL_LETTER_TURNED_W_BELOW = 0x1AC0;
const char32_t BALINESE_SIGN_ULU_RICEM = 0x1B00;
const char32_t BALINESE_SIGN_ULU_CANDRA = 0x1B01;
const char32_t BALINESE_SIGN_CECEK = 0x1B02;
const char32_t BALINESE_SIGN_SURANG = 0x1B03;
const char32_t BALINESE_SIGN_BISAH = 0x1B04;
const char32_t BALINESE_LETTER_AKARA = 0x1B05;
const char32_t BALINESE_LETTER_AKARA_TEDUNG = 0x1B06;
const char32_t BALINESE_LETTER_IKARA = 0x1B07;
const char32_t BALINESE_LETTER_IKARA_TEDUNG = 0x1B08;
const char32_t BALINESE_LETTER_UKARA = 0x1B09;
const char32_t BALINESE_LETTER_UKARA_TEDUNG = 0x1B0A;
const char32_t BALINESE_LETTER_RA_REPA = 0x1B0B;
const char32_t BALINESE_LETTER_RA_REPA_TEDUNG = 0x1B0C;
const char32_t BALINESE_LETTER_LA_LENGA = 0x1B0D;
const char32_t BALINESE_LETTER_LA_LENGA_TEDUNG = 0x1B0E;
const char32_t BALINESE_LETTER_EKARA = 0x1B0F;
const char32_t BALINESE_LETTER_AIKARA = 0x1B10;
const char32_t BALINESE_LETTER_OKARA = 0x1B11;
const char32_t BALINESE_LETTER_OKARA_TEDUNG = 0x1B12;
const char32_t BALINESE_LETTER_KA = 0x1B13;
const char32_t BALINESE_LETTER_KA_MAHAPRANA = 0x1B14;
const char32_t BALINESE_LETTER_GA = 0x1B15;
const char32_t BALINESE_LETTER_GA_GORA = 0x1B16;
const char32_t BALINESE_LETTER_NGA = 0x1B17;
const char32_t BALINESE_LETTER_CA = 0x1B18;
const char32_t BALINESE_LETTER_CA_LACA = 0x1B19;
const char32_t BALINESE_LETTER_JA = 0x1B1A;
const char32_t BALINESE_LETTER_JA_JERA = 0x1B1B;
const char32_t BALINESE_LETTER_NYA = 0x1B1C;
const char32_t BALINESE_LETTER_TA_LATIK = 0x1B1D;
const char32_t BALINESE_LETTER_TA_MURDA_MAHAPRANA = 0x1B1E;
const char32_t BALINESE_LETTER_DA_MURDA_ALPAPRANA = 0x1B1F;
const char32_t BALINESE_LETTER_DA_MURDA_MAHAPRANA = 0x1B20;
const char32_t BALINESE_LETTER_NA_RAMBAT = 0x1B21;
const char32_t BALINESE_LETTER_TA = 0x1B22;
const char32_t BALINESE_LETTER_TA_TAWA = 0x1B23;
const char32_t BALINESE_LETTER_DA = 0x1B24;
const char32_t BALINESE_LETTER_DA_MADU = 0x1B25;
const char32_t BALINESE_LETTER_NA = 0x1B26;
const char32_t BALINESE_LETTER_PA = 0x1B27;
const char32_t BALINESE_LETTER_PA_KAPAL = 0x1B28;
const char32_t BALINESE_LETTER_BA = 0x1B29;
const char32_t BALINESE_LETTER_BA_KEMBANG = 0x1B2A;
const char32_t BALINESE_LETTER_MA = 0x1B2B;
const char32_t BALINESE_LETTER_YA = 0x1B2C;
const char32_t BALINESE_LETTER_RA = 0x1B2D;
const char32_t BALINESE_LETTER_LA = 0x1B2E;
const char32_t BALINESE_LETTER_WA = 0x1B2F;
const char32_t BALINESE_LETTER_SA_SAGA = 0x1B30;
const char32_t BALINESE_LETTER_SA_SAPA = 0x1B31;
const char32_t BALINESE_LETTER_SA = 0x1B32;
const char32_t BALINESE_LETTER_HA = 0x1B33;
const char32_t BALINESE_SIGN_REREKAN = 0x1B34;
const char32_t BALINESE_VOWEL_SIGN_TEDUNG = 0x1B35;
const char32_t BALINESE_VOWEL_SIGN_ULU = 0x1B36;
const char32_t BALINESE_VOWEL_SIGN_ULU_SARI = 0x1B37;
const char32_t BALINESE_VOWEL_SIGN_SUKU = 0x1B38;
const char32_t BALINESE_VOWEL_SIGN_SUKU_ILUT = 0x1B39;
const char32_t BALINESE_VOWEL_SIGN_RA_REPA = 0x1B3A;
const char32_t BALINESE_VOWEL_SIGN_RA_REPA_TEDUNG = 0x1B3B;
const char32_t BALINESE_VOWEL_SIGN_LA_LENGA = 0x1B3C;
const char32_t BALINESE_VOWEL_SIGN_LA_LENGA_TEDUNG = 0x1B3D;
const char32_t BALINESE_VOWEL_SIGN_TALING = 0x1B3E;
const char32_t BALINESE_VOWEL_SIGN_TALING_REPA = 0x1B3F;
const char32_t BALINESE_VOWEL_SIGN_TALING_TEDUNG = 0x1B40;
const char32_t BALINESE_VOWEL_SIGN_TALING_REPA_TEDUNG = 0x1B41;
const char32_t BALINESE_VOWEL_SIGN_PEPET = 0x1B42;
const char32_t BALINESE_VOWEL_SIGN_PEPET_TEDUNG = 0x1B43;
const char32_t BALINESE_ADEG_ADEG = 0x1B44;
const char32_t BALINESE_LETTER_KAF_SASAK = 0x1B45;
const char32_t BALINESE_LETTER_KHOT_SASAK = 0x1B46;
const char32_t BALINESE_LETTER_TZIR_SASAK = 0x1B47;
const char32_t BALINESE_LETTER_EF_SASAK = 0x1B48;
const char32_t BALINESE_LETTER_VE_SASAK = 0x1B49;
const char32_t BALINESE_LETTER_ZAL_SASAK = 0x1B4A;
const char32_t BALINESE_LETTER_ASYURA_SASAK = 0x1B4B;
const char32_t BALINESE_DIGIT_ZERO = 0x1B50;
const char32_t BALINESE_DIGIT_ONE = 0x1B51;
const char32_t BALINESE_DIGIT_TWO = 0x1B52;
const char32_t BALINESE_DIGIT_THREE = 0x1B53;
const char32_t BALINESE_DIGIT_FOUR = 0x1B54;
const char32_t BALINESE_DIGIT_FIVE = 0x1B55;
const char32_t BALINESE_DIGIT_SIX = 0x1B56;
const char32_t BALINESE_DIGIT_SEVEN = 0x1B57;
const char32_t BALINESE_DIGIT_EIGHT = 0x1B58;
const char32_t BALINESE_DIGIT_NINE = 0x1B59;
const char32_t BALINESE_PANTI = 0x1B5A;
const char32_t BALINESE_PAMADA = 0x1B5B;
const char32_t BALINESE_WINDU = 0x1B5C;
const char32_t BALINESE_CARIK_PAMUNGKAH = 0x1B5D;
const char32_t BALINESE_CARIK_SIKI = 0x1B5E;
const char32_t BALINESE_CARIK_PAREREN = 0x1B5F;
const char32_t BALINESE_PAMENENG = 0x1B60;
const char32_t BALINESE_MUSICAL_SYMBOL_DONG = 0x1B61;
const char32_t BALINESE_MUSICAL_SYMBOL_DENG = 0x1B62;
const char32_t BALINESE_MUSICAL_SYMBOL_DUNG = 0x1B63;
const char32_t BALINESE_MUSICAL_SYMBOL_DANG = 0x1B64;
const char32_t BALINESE_MUSICAL_SYMBOL_DANG_SURANG = 0x1B65;
const char32_t BALINESE_MUSICAL_SYMBOL_DING = 0x1B66;
const char32_t BALINESE_MUSICAL_SYMBOL_DAENG = 0x1B67;
const char32_t BALINESE_MUSICAL_SYMBOL_DEUNG = 0x1B68;
const char32_t BALINESE_MUSICAL_SYMBOL_DAING = 0x1B69;
const char32_t BALINESE_MUSICAL_SYMBOL_DANG_GEDE = 0x1B6A;
const char32_t BALINESE_MUSICAL_SYMBOL_COMBINING_TEGEH = 0x1B6B;
const char32_t BALINESE_MUSICAL_SYMBOL_COMBINING_ENDEP = 0x1B6C;
const char32_t BALINESE_MUSICAL_SYMBOL_COMBINING_KEMPUL = 0x1B6D;
const char32_t BALINESE_MUSICAL_SYMBOL_COMBINING_KEMPLI = 0x1B6E;
const char32_t BALINESE_MUSICAL_SYMBOL_COMBINING_JEGOGAN = 0x1B6F;
const char32_t BALINESE_MUSICAL_SYMBOL_COMBINING_KEMPUL_WITH_JEGOGAN = 0x1B70;
const char32_t BALINESE_MUSICAL_SYMBOL_COMBINING_KEMPLI_WITH_JEGOGAN = 0x1B71;
const char32_t BALINESE_MUSICAL_SYMBOL_COMBINING_BENDE = 0x1B72;
const char32_t BALINESE_MUSICAL_SYMBOL_COMBINING_GONG = 0x1B73;
const char32_t BALINESE_MUSICAL_SYMBOL_RIGHT_HAND_OPEN_DUG = 0x1B74;
const char32_t BALINESE_MUSICAL_SYMBOL_RIGHT_HAND_OPEN_DAG = 0x1B75;
const char32_t BALINESE_MUSICAL_SYMBOL_RIGHT_HAND_CLOSED_TUK = 0x1B76;
const char32_t BALINESE_MUSICAL_SYMBOL_RIGHT_HAND_CLOSED_TAK = 0x1B77;
const char32_t BALINESE_MUSICAL_SYMBOL_LEFT_HAND_OPEN_PANG = 0x1B78;
const char32_t BALINESE_MUSICAL_SYMBOL_LEFT_HAND_OPEN_PUNG = 0x1B79;
const char32_t BALINESE_MUSICAL_SYMBOL_LEFT_HAND_CLOSED_PLAK = 0x1B7A;
const char32_t BALINESE_MUSICAL_SYMBOL_LEFT_HAND_CLOSED_PLUK = 0x1B7B;
const char32_t BALINESE_MUSICAL_SYMBOL_LEFT_HAND_OPEN_PING = 0x1B7C;
const char32_t SUNDANESE_SIGN_PANYECEK = 0x1B80;
const char32_t SUNDANESE_SIGN_PANGLAYAR = 0x1B81;
const char32_t SUNDANESE_SIGN_PANGWISAD = 0x1B82;
const char32_t SUNDANESE_LETTER_A = 0x1B83;
const char32_t SUNDANESE_LETTER_I = 0x1B84;
const char32_t SUNDANESE_LETTER_U = 0x1B85;
const char32_t SUNDANESE_LETTER_AE = 0x1B86;
const char32_t SUNDANESE_LETTER_O = 0x1B87;
const char32_t SUNDANESE_LETTER_E = 0x1B88;
const char32_t SUNDANESE_LETTER_EU = 0x1B89;
const char32_t SUNDANESE_LETTER_KA = 0x1B8A;
const char32_t SUNDANESE_LETTER_QA = 0x1B8B;
const char32_t SUNDANESE_LETTER_GA = 0x1B8C;
const char32_t SUNDANESE_LETTER_NGA = 0x1B8D;
const char32_t SUNDANESE_LETTER_CA = 0x1B8E;
const char32_t SUNDANESE_LETTER_JA = 0x1B8F;
const char32_t SUNDANESE_LETTER_ZA = 0x1B90;
const char32_t SUNDANESE_LETTER_NYA = 0x1B91;
const char32_t SUNDANESE_LETTER_TA = 0x1B92;
const char32_t SUNDANESE_LETTER_DA = 0x1B93;
const char32_t SUNDANESE_LETTER_NA = 0x1B94;
const char32_t SUNDANESE_LETTER_PA = 0x1B95;
const char32_t SUNDANESE_LETTER_FA = 0x1B96;
const char32_t SUNDANESE_LETTER_VA = 0x1B97;
const char32_t SUNDANESE_LETTER_BA = 0x1B98;
const char32_t SUNDANESE_LETTER_MA = 0x1B99;
const char32_t SUNDANESE_LETTER_YA = 0x1B9A;
const char32_t SUNDANESE_LETTER_RA = 0x1B9B;
const char32_t SUNDANESE_LETTER_LA = 0x1B9C;
const char32_t SUNDANESE_LETTER_WA = 0x1B9D;
const char32_t SUNDANESE_LETTER_SA = 0x1B9E;
const char32_t SUNDANESE_LETTER_XA = 0x1B9F;
const char32_t SUNDANESE_LETTER_HA = 0x1BA0;
const char32_t SUNDANESE_CONSONANT_SIGN_PAMINGKAL = 0x1BA1;
const char32_t SUNDANESE_CONSONANT_SIGN_PANYAKRA = 0x1BA2;
const char32_t SUNDANESE_CONSONANT_SIGN_PANYIKU = 0x1BA3;
const char32_t SUNDANESE_VOWEL_SIGN_PANGHULU = 0x1BA4;
const char32_t SUNDANESE_VOWEL_SIGN_PANYUKU = 0x1BA5;
const char32_t SUNDANESE_VOWEL_SIGN_PANAELAENG = 0x1BA6;
const char32_t SUNDANESE_VOWEL_SIGN_PANOLONG = 0x1BA7;
const char32_t SUNDANESE_VOWEL_SIGN_PAMEPET = 0x1BA8;
const char32_t SUNDANESE_VOWEL_SIGN_PANEULEUNG = 0x1BA9;
const char32_t SUNDANESE_SIGN_PAMAAEH = 0x1BAA;
const char32_t SUNDANESE_SIGN_VIRAMA = 0x1BAB;
const char32_t SUNDANESE_CONSONANT_SIGN_PASANGAN_MA = 0x1BAC;
const char32_t SUNDANESE_CONSONANT_SIGN_PASANGAN_WA = 0x1BAD;
const char32_t SUNDANESE_LETTER_KHA = 0x1BAE;
const char32_t SUNDANESE_LETTER_SYA = 0x1BAF;
const char32_t SUNDANESE_DIGIT_ZERO = 0x1BB0;
const char32_t SUNDANESE_DIGIT_ONE = 0x1BB1;
const char32_t SUNDANESE_DIGIT_TWO = 0x1BB2;
const char32_t SUNDANESE_DIGIT_THREE = 0x1BB3;
const char32_t SUNDANESE_DIGIT_FOUR = 0x1BB4;
const char32_t SUNDANESE_DIGIT_FIVE = 0x1BB5;
const char32_t SUNDANESE_DIGIT_SIX = 0x1BB6;
const char32_t SUNDANESE_DIGIT_SEVEN = 0x1BB7;
const char32_t SUNDANESE_DIGIT_EIGHT = 0x1BB8;
const char32_t SUNDANESE_DIGIT_NINE = 0x1BB9;
const char32_t SUNDANESE_AVAGRAHA = 0x1BBA;
const char32_t SUNDANESE_LETTER_REU = 0x1BBB;
const char32_t SUNDANESE_LETTER_LEU = 0x1BBC;
const char32_t SUNDANESE_LETTER_BHA = 0x1BBD;
const char32_t SUNDANESE_LETTER_FINAL_K = 0x1BBE;
const char32_t SUNDANESE_LETTER_FINAL_M = 0x1BBF;
const char32_t BATAK_LETTER_A = 0x1BC0;
const char32_t BATAK_LETTER_SIMALUNGUN_A = 0x1BC1;
const char32_t BATAK_LETTER_HA = 0x1BC2;
const char32_t BATAK_LETTER_SIMALUNGUN_HA = 0x1BC3;
const char32_t BATAK_LETTER_MANDAILING_HA = 0x1BC4;
const char32_t BATAK_LETTER_BA = 0x1BC5;
const char32_t BATAK_LETTER_KARO_BA = 0x1BC6;
const char32_t BATAK_LETTER_PA = 0x1BC7;
const char32_t BATAK_LETTER_SIMALUNGUN_PA = 0x1BC8;
const char32_t BATAK_LETTER_NA = 0x1BC9;
const char32_t BATAK_LETTER_MANDAILING_NA = 0x1BCA;
const char32_t BATAK_LETTER_WA = 0x1BCB;
const char32_t BATAK_LETTER_SIMALUNGUN_WA = 0x1BCC;
const char32_t BATAK_LETTER_PAKPAK_WA = 0x1BCD;
const char32_t BATAK_LETTER_GA = 0x1BCE;
const char32_t BATAK_LETTER_SIMALUNGUN_GA = 0x1BCF;
const char32_t BATAK_LETTER_JA = 0x1BD0;
const char32_t BATAK_LETTER_DA = 0x1BD1;
const char32_t BATAK_LETTER_RA = 0x1BD2;
const char32_t BATAK_LETTER_SIMALUNGUN_RA = 0x1BD3;
const char32_t BATAK_LETTER_MA = 0x1BD4;
const char32_t BATAK_LETTER_SIMALUNGUN_MA = 0x1BD5;
const char32_t BATAK_LETTER_SOUTHERN_TA = 0x1BD6;
const char32_t BATAK_LETTER_NORTHERN_TA = 0x1BD7;
const char32_t BATAK_LETTER_SA = 0x1BD8;
const char32_t BATAK_LETTER_SIMALUNGUN_SA = 0x1BD9;
const char32_t BATAK_LETTER_MANDAILING_SA = 0x1BDA;
const char32_t BATAK_LETTER_YA = 0x1BDB;
const char32_t BATAK_LETTER_SIMALUNGUN_YA = 0x1BDC;
const char32_t BATAK_LETTER_NGA = 0x1BDD;
const char32_t BATAK_LETTER_LA = 0x1BDE;
const char32_t BATAK_LETTER_SIMALUNGUN_LA = 0x1BDF;
const char32_t BATAK_LETTER_NYA = 0x1BE0;
const char32_t BATAK_LETTER_CA = 0x1BE1;
const char32_t BATAK_LETTER_NDA = 0x1BE2;
const char32_t BATAK_LETTER_MBA = 0x1BE3;
const char32_t BATAK_LETTER_I = 0x1BE4;
const char32_t BATAK_LETTER_U = 0x1BE5;
const char32_t BATAK_SIGN_TOMPI = 0x1BE6;
const char32_t BATAK_VOWEL_SIGN_E = 0x1BE7;
const char32_t BATAK_VOWEL_SIGN_PAKPAK_E = 0x1BE8;
const char32_t BATAK_VOWEL_SIGN_EE = 0x1BE9;
const char32_t BATAK_VOWEL_SIGN_I = 0x1BEA;
const char32_t BATAK_VOWEL_SIGN_KARO_I = 0x1BEB;
const char32_t BATAK_VOWEL_SIGN_O = 0x1BEC;
const char32_t BATAK_VOWEL_SIGN_KARO_O = 0x1BED;
const char32_t BATAK_VOWEL_SIGN_U = 0x1BEE;
const char32_t BATAK_VOWEL_SIGN_U_FOR_SIMALUNGUN_SA = 0x1BEF;
const char32_t BATAK_CONSONANT_SIGN_NG = 0x1BF0;
const char32_t BATAK_CONSONANT_SIGN_H = 0x1BF1;
const char32_t BATAK_PANGOLAT = 0x1BF2;
const char32_t BATAK_PANONGONAN = 0x1BF3;
const char32_t BATAK_SYMBOL_BINDU_NA_METEK = 0x1BFC;
const char32_t BATAK_SYMBOL_BINDU_PINARBORAS = 0x1BFD;
const char32_t BATAK_SYMBOL_BINDU_JUDUL = 0x1BFE;
const char32_t BATAK_SYMBOL_BINDU_PANGOLAT = 0x1BFF;
const char32_t LEPCHA_LETTER_KA = 0x1C00;
const char32_t LEPCHA_LETTER_KLA = 0x1C01;
const char32_t LEPCHA_LETTER_KHA = 0x1C02;
const char32_t LEPCHA_LETTER_GA = 0x1C03;
const char32_t LEPCHA_LETTER_GLA = 0x1C04;
const char32_t LEPCHA_LETTER_NGA = 0x1C05;
const char32_t LEPCHA_LETTER_CA = 0x1C06;
const char32_t LEPCHA_LETTER_CHA = 0x1C07;
const char32_t LEPCHA_LETTER_JA = 0x1C08;
const char32_t LEPCHA_LETTER_NYA = 0x1C09;
const char32_t LEPCHA_LETTER_TA = 0x1C0A;
const char32_t LEPCHA_LETTER_THA = 0x1C0B;
const char32_t LEPCHA_LETTER_DA = 0x1C0C;
const char32_t LEPCHA_LETTER_NA = 0x1C0D;
const char32_t LEPCHA_LETTER_PA = 0x1C0E;
const char32_t LEPCHA_LETTER_PLA = 0x1C0F;
const char32_t LEPCHA_LETTER_PHA = 0x1C10;
const char32_t LEPCHA_LETTER_FA = 0x1C11;
const char32_t LEPCHA_LETTER_FLA = 0x1C12;
const char32_t LEPCHA_LETTER_BA = 0x1C13;
const char32_t LEPCHA_LETTER_BLA = 0x1C14;
const char32_t LEPCHA_LETTER_MA = 0x1C15;
const char32_t LEPCHA_LETTER_MLA = 0x1C16;
const char32_t LEPCHA_LETTER_TSA = 0x1C17;
const char32_t LEPCHA_LETTER_TSHA = 0x1C18;
const char32_t LEPCHA_LETTER_DZA = 0x1C19;
const char32_t LEPCHA_LETTER_YA = 0x1C1A;
const char32_t LEPCHA_LETTER_RA = 0x1C1B;
const char32_t LEPCHA_LETTER_LA = 0x1C1C;
const char32_t LEPCHA_LETTER_HA = 0x1C1D;
const char32_t LEPCHA_LETTER_HLA = 0x1C1E;
const char32_t LEPCHA_LETTER_VA = 0x1C1F;
const char32_t LEPCHA_LETTER_SA = 0x1C20;
const char32_t LEPCHA_LETTER_SHA = 0x1C21;
const char32_t LEPCHA_LETTER_WA = 0x1C22;
const char32_t LEPCHA_LETTER_A = 0x1C23;
const char32_t LEPCHA_SUBJOINED_LETTER_YA = 0x1C24;
const char32_t LEPCHA_SUBJOINED_LETTER_RA = 0x1C25;
const char32_t LEPCHA_VOWEL_SIGN_AA = 0x1C26;
const char32_t LEPCHA_VOWEL_SIGN_I = 0x1C27;
const char32_t LEPCHA_VOWEL_SIGN_O = 0x1C28;
const char32_t LEPCHA_VOWEL_SIGN_OO = 0x1C29;
const char32_t LEPCHA_VOWEL_SIGN_U = 0x1C2A;
const char32_t LEPCHA_VOWEL_SIGN_UU = 0x1C2B;
const char32_t LEPCHA_VOWEL_SIGN_E = 0x1C2C;
const char32_t LEPCHA_CONSONANT_SIGN_K = 0x1C2D;
const char32_t LEPCHA_CONSONANT_SIGN_M = 0x1C2E;
const char32_t LEPCHA_CONSONANT_SIGN_L = 0x1C2F;
const char32_t LEPCHA_CONSONANT_SIGN_N = 0x1C30;
const char32_t LEPCHA_CONSONANT_SIGN_P = 0x1C31;
const char32_t LEPCHA_CONSONANT_SIGN_R = 0x1C32;
const char32_t LEPCHA_CONSONANT_SIGN_T = 0x1C33;
const char32_t LEPCHA_CONSONANT_SIGN_NYIN_DO = 0x1C34;
const char32_t LEPCHA_CONSONANT_SIGN_KANG = 0x1C35;
const char32_t LEPCHA_SIGN_RAN = 0x1C36;
const char32_t LEPCHA_SIGN_NUKTA = 0x1C37;
const char32_t LEPCHA_PUNCTUATION_TA_ROL = 0x1C3B;
const char32_t LEPCHA_PUNCTUATION_NYET_THYOOM_TA_ROL = 0x1C3C;
const char32_t LEPCHA_PUNCTUATION_CER_WA = 0x1C3D;
const char32_t LEPCHA_PUNCTUATION_TSHOOK_CER_WA = 0x1C3E;
const char32_t LEPCHA_PUNCTUATION_TSHOOK = 0x1C3F;
const char32_t LEPCHA_DIGIT_ZERO = 0x1C40;
const char32_t LEPCHA_DIGIT_ONE = 0x1C41;
const char32_t LEPCHA_DIGIT_TWO = 0x1C42;
const char32_t LEPCHA_DIGIT_THREE = 0x1C43;
const char32_t LEPCHA_DIGIT_FOUR = 0x1C44;
const char32_t LEPCHA_DIGIT_FIVE = 0x1C45;
const char32_t LEPCHA_DIGIT_SIX = 0x1C46;
const char32_t LEPCHA_DIGIT_SEVEN = 0x1C47;
const char32_t LEPCHA_DIGIT_EIGHT = 0x1C48;
const char32_t LEPCHA_DIGIT_NINE = 0x1C49;
const char32_t LEPCHA_LETTER_TTA = 0x1C4D;
const char32_t LEPCHA_LETTER_TTHA = 0x1C4E;
const char32_t LEPCHA_LETTER_DDA = 0x1C4F;
const char32_t OL_CHIKI_DIGIT_ZERO = 0x1C50;
const char32_t OL_CHIKI_DIGIT_ONE = 0x1C51;
const char32_t OL_CHIKI_DIGIT_TWO = 0x1C52;
const char32_t OL_CHIKI_DIGIT_THREE = 0x1C53;
const char32_t OL_CHIKI_DIGIT_FOUR = 0x1C54;
const char32_t OL_CHIKI_DIGIT_FIVE = 0x1C55;
const char32_t OL_CHIKI_DIGIT_SIX = 0x1C56;
const char32_t OL_CHIKI_DIGIT_SEVEN = 0x1C57;
const char32_t OL_CHIKI_DIGIT_EIGHT = 0x1C58;
const char32_t OL_CHIKI_DIGIT_NINE = 0x1C59;
const char32_t OL_CHIKI_LETTER_LA = 0x1C5A;
const char32_t OL_CHIKI_LETTER_AT = 0x1C5B;
const char32_t OL_CHIKI_LETTER_AG = 0x1C5C;
const char32_t OL_CHIKI_LETTER_ANG = 0x1C5D;
const char32_t OL_CHIKI_LETTER_AL = 0x1C5E;
const char32_t OL_CHIKI_LETTER_LAA = 0x1C5F;
const char32_t OL_CHIKI_LETTER_AAK = 0x1C60;
const char32_t OL_CHIKI_LETTER_AAJ = 0x1C61;
const char32_t OL_CHIKI_LETTER_AAM = 0x1C62;
const char32_t OL_CHIKI_LETTER_AAW = 0x1C63;
const char32_t OL_CHIKI_LETTER_LI = 0x1C64;
const char32_t OL_CHIKI_LETTER_IS = 0x1C65;
const char32_t OL_CHIKI_LETTER_IH = 0x1C66;
const char32_t OL_CHIKI_LETTER_INY = 0x1C67;
const char32_t OL_CHIKI_LETTER_IR = 0x1C68;
const char32_t OL_CHIKI_LETTER_LU = 0x1C69;
const char32_t OL_CHIKI_LETTER_UC = 0x1C6A;
const char32_t OL_CHIKI_LETTER_UD = 0x1C6B;
const char32_t OL_CHIKI_LETTER_UNN = 0x1C6C;
const char32_t OL_CHIKI_LETTER_UY = 0x1C6D;
const char32_t OL_CHIKI_LETTER_LE = 0x1C6E;
const char32_t OL_CHIKI_LETTER_EP = 0x1C6F;
const char32_t OL_CHIKI_LETTER_EDD = 0x1C70;
const char32_t OL_CHIKI_LETTER_EN = 0x1C71;
const char32_t OL_CHIKI_LETTER_ERR = 0x1C72;
const char32_t OL_CHIKI_LETTER_LO = 0x1C73;
const char32_t OL_CHIKI_LETTER_OTT = 0x1C74;
const char32_t OL_CHIKI_LETTER_OB = 0x1C75;
const char32_t OL_CHIKI_LETTER_OV = 0x1C76;
const char32_t OL_CHIKI_LETTER_OH = 0x1C77;
const char32_t OL_CHIKI_MU_TTUDDAG = 0x1C78;
const char32_t OL_CHIKI_GAAHLAA_TTUDDAAG = 0x1C79;
const char32_t OL_CHIKI_MU_GAAHLAA_TTUDDAAG = 0x1C7A;
const char32_t OL_CHIKI_RELAA = 0x1C7B;
const char32_t OL_CHIKI_PHAARKAA = 0x1C7C;
const char32_t OL_CHIKI_AHAD = 0x1C7D;
const char32_t OL_CHIKI_PUNCTUATION_MUCAAD = 0x1C7E;
const char32_t OL_CHIKI_PUNCTUATION_DOUBLE_MUCAAD = 0x1C7F;
const char32_t CYRILLIC_SMALL_LETTER_ROUNDED_VE = 0x1C80;
const char32_t CYRILLIC_SMALL_LETTER_LONG_LEGGED_DE = 0x1C81;
const char32_t CYRILLIC_SMALL_LETTER_NARROW_O = 0x1C82;
const char32_t CYRILLIC_SMALL_LETTER_WIDE_ES = 0x1C83;
const char32_t CYRILLIC_SMALL_LETTER_TALL_TE = 0x1C84;
const char32_t CYRILLIC_SMALL_LETTER_THREE_LEGGED_TE = 0x1C85;
const char32_t CYRILLIC_SMALL_LETTER_TALL_HARD_SIGN = 0x1C86;
const char32_t CYRILLIC_SMALL_LETTER_TALL_YAT = 0x1C87;
const char32_t CYRILLIC_SMALL_LETTER_UNBLENDED_UK = 0x1C88;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_AN = 0x1C90;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_BAN = 0x1C91;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_GAN = 0x1C92;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_DON = 0x1C93;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_EN = 0x1C94;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_VIN = 0x1C95;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_ZEN = 0x1C96;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_TAN = 0x1C97;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_IN = 0x1C98;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_KAN = 0x1C99;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_LAS = 0x1C9A;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_MAN = 0x1C9B;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_NAR = 0x1C9C;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_ON = 0x1C9D;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_PAR = 0x1C9E;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_ZHAR = 0x1C9F;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_RAE = 0x1CA0;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_SAN = 0x1CA1;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_TAR = 0x1CA2;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_UN = 0x1CA3;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_PHAR = 0x1CA4;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_KHAR = 0x1CA5;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_GHAN = 0x1CA6;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_QAR = 0x1CA7;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_SHIN = 0x1CA8;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_CHIN = 0x1CA9;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_CAN = 0x1CAA;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_JIL = 0x1CAB;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_CIL = 0x1CAC;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_CHAR = 0x1CAD;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_XAN = 0x1CAE;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_JHAN = 0x1CAF;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_HAE = 0x1CB0;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_HE = 0x1CB1;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_HIE = 0x1CB2;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_WE = 0x1CB3;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_HAR = 0x1CB4;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_HOE = 0x1CB5;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_FI = 0x1CB6;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_YN = 0x1CB7;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_ELIFI = 0x1CB8;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_TURNED_GAN = 0x1CB9;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_AIN = 0x1CBA;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_AEN = 0x1CBD;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_HARD_SIGN = 0x1CBE;
const char32_t GEORGIAN_MTAVRULI_CAPITAL_LETTER_LABIAL_SIGN = 0x1CBF;
const char32_t SUNDANESE_PUNCTUATION_BINDU_SURYA = 0x1CC0;
const char32_t SUNDANESE_PUNCTUATION_BINDU_PANGLONG = 0x1CC1;
const char32_t SUNDANESE_PUNCTUATION_BINDU_PURNAMA = 0x1CC2;
const char32_t SUNDANESE_PUNCTUATION_BINDU_CAKRA = 0x1CC3;
const char32_t SUNDANESE_PUNCTUATION_BINDU_LEU_SATANGA = 0x1CC4;
const char32_t SUNDANESE_PUNCTUATION_BINDU_KA_SATANGA = 0x1CC5;
const char32_t SUNDANESE_PUNCTUATION_BINDU_DA_SATANGA = 0x1CC6;
const char32_t SUNDANESE_PUNCTUATION_BINDU_BA_SATANGA = 0x1CC7;
const char32_t VEDIC_TONE_KARSHANA = 0x1CD0;
const char32_t VEDIC_TONE_SHARA = 0x1CD1;
const char32_t VEDIC_TONE_PRENKHA = 0x1CD2;
const char32_t VEDIC_SIGN_NIHSHVASA = 0x1CD3;
const char32_t VEDIC_SIGN_YAJURVEDIC_MIDLINE_SVARITA = 0x1CD4;
const char32_t VEDIC_TONE_YAJURVEDIC_AGGRAVATED_INDEPENDENT_SVARITA = 0x1CD5;
const char32_t VEDIC_TONE_YAJURVEDIC_INDEPENDENT_SVARITA = 0x1CD6;
const char32_t VEDIC_TONE_YAJURVEDIC_KATHAKA_INDEPENDENT_SVARITA = 0x1CD7;
const char32_t VEDIC_TONE_CANDRA_BELOW = 0x1CD8;
const char32_t VEDIC_TONE_YAJURVEDIC_KATHAKA_INDEPENDENT_SVARITA_SCHROEDER = 0x1CD9;
const char32_t VEDIC_TONE_DOUBLE_SVARITA = 0x1CDA;
const char32_t VEDIC_TONE_TRIPLE_SVARITA = 0x1CDB;
const char32_t VEDIC_TONE_KATHAKA_ANUDATTA = 0x1CDC;
const char32_t VEDIC_TONE_DOT_BELOW = 0x1CDD;
const char32_t VEDIC_TONE_TWO_DOTS_BELOW = 0x1CDE;
const char32_t VEDIC_TONE_THREE_DOTS_BELOW = 0x1CDF;
const char32_t VEDIC_TONE_RIGVEDIC_KASHMIRI_INDEPENDENT_SVARITA = 0x1CE0;
const char32_t VEDIC_TONE_ATHARVAVEDIC_INDEPENDENT_SVARITA = 0x1CE1;
const char32_t VEDIC_SIGN_VISARGA_SVARITA = 0x1CE2;
const char32_t VEDIC_SIGN_VISARGA_UDATTA = 0x1CE3;
const char32_t VEDIC_SIGN_REVERSED_VISARGA_UDATTA = 0x1CE4;
const char32_t VEDIC_SIGN_VISARGA_ANUDATTA = 0x1CE5;
const char32_t VEDIC_SIGN_REVERSED_VISARGA_ANUDATTA = 0x1CE6;
const char32_t VEDIC_SIGN_VISARGA_UDATTA_WITH_TAIL = 0x1CE7;
const char32_t VEDIC_SIGN_VISARGA_ANUDATTA_WITH_TAIL = 0x1CE8;
const char32_t VEDIC_SIGN_ANUSVARA_ANTARGOMUKHA = 0x1CE9;
const char32_t VEDIC_SIGN_ANUSVARA_BAHIRGOMUKHA = 0x1CEA;
const char32_t VEDIC_SIGN_ANUSVARA_VAMAGOMUKHA = 0x1CEB;
const char32_t VEDIC_SIGN_ANUSVARA_VAMAGOMUKHA_WITH_TAIL = 0x1CEC;
const char32_t VEDIC_SIGN_TIRYAK = 0x1CED;
const char32_t VEDIC_SIGN_HEXIFORM_LONG_ANUSVARA = 0x1CEE;
const char32_t VEDIC_SIGN_LONG_ANUSVARA = 0x1CEF;
const char32_t VEDIC_SIGN_RTHANG_LONG_ANUSVARA = 0x1CF0;
const char32_t VEDIC_SIGN_ANUSVARA_UBHAYATO_MUKHA = 0x1CF1;
const char32_t VEDIC_SIGN_ARDHAVISARGA = 0x1CF2;
const char32_t VEDIC_SIGN_ROTATED_ARDHAVISARGA = 0x1CF3;
const char32_t VEDIC_TONE_CANDRA_ABOVE = 0x1CF4;
const char32_t VEDIC_SIGN_JIHVAMULIYA = 0x1CF5;
const char32_t VEDIC_SIGN_UPADHMANIYA = 0x1CF6;
const char32_t VEDIC_SIGN_ATIKRAMA = 0x1CF7;
const char32_t VEDIC_TONE_RING_ABOVE = 0x1CF8;
const char32_t VEDIC_TONE_DOUBLE_RING_ABOVE = 0x1CF9;
const char32_t VEDIC_SIGN_DOUBLE_ANUSVARA_ANTARGOMUKHA = 0x1CFA;
const char32_t LATIN_LETTER_SMALL_CAPITAL_A = 0x1D00;
const char32_t LATIN_LETTER_SMALL_CAPITAL_AE = 0x1D01;
const char32_t LATIN_SMALL_LETTER_TURNED_AE = 0x1D02;
const char32_t LATIN_LETTER_SMALL_CAPITAL_BARRED_B = 0x1D03;
const char32_t LATIN_LETTER_SMALL_CAPITAL_C = 0x1D04;
const char32_t LATIN_LETTER_SMALL_CAPITAL_D = 0x1D05;
const char32_t LATIN_LETTER_SMALL_CAPITAL_ETH = 0x1D06;
const char32_t LATIN_LETTER_SMALL_CAPITAL_E = 0x1D07;
const char32_t LATIN_SMALL_LETTER_TURNED_OPEN_E = 0x1D08;
const char32_t LATIN_SMALL_LETTER_TURNED_I = 0x1D09;
const char32_t LATIN_LETTER_SMALL_CAPITAL_J = 0x1D0A;
const char32_t LATIN_LETTER_SMALL_CAPITAL_K = 0x1D0B;
const char32_t LATIN_LETTER_SMALL_CAPITAL_L_WITH_STROKE = 0x1D0C;
const char32_t LATIN_LETTER_SMALL_CAPITAL_M = 0x1D0D;
const char32_t LATIN_LETTER_SMALL_CAPITAL_REVERSED_N = 0x1D0E;
const char32_t LATIN_LETTER_SMALL_CAPITAL_O = 0x1D0F;
const char32_t LATIN_LETTER_SMALL_CAPITAL_OPEN_O = 0x1D10;
const char32_t LATIN_SMALL_LETTER_SIDEWAYS_O = 0x1D11;
const char32_t LATIN_SMALL_LETTER_SIDEWAYS_OPEN_O = 0x1D12;
const char32_t LATIN_SMALL_LETTER_SIDEWAYS_O_WITH_STROKE = 0x1D13;
const char32_t LATIN_SMALL_LETTER_TURNED_OE = 0x1D14;
const char32_t LATIN_LETTER_SMALL_CAPITAL_OU = 0x1D15;
const char32_t LATIN_SMALL_LETTER_TOP_HALF_O = 0x1D16;
const char32_t LATIN_SMALL_LETTER_BOTTOM_HALF_O = 0x1D17;
const char32_t LATIN_LETTER_SMALL_CAPITAL_P = 0x1D18;
const char32_t LATIN_LETTER_SMALL_CAPITAL_REVERSED_R = 0x1D19;
const char32_t LATIN_LETTER_SMALL_CAPITAL_TURNED_R = 0x1D1A;
const char32_t LATIN_LETTER_SMALL_CAPITAL_T = 0x1D1B;
const char32_t LATIN_LETTER_SMALL_CAPITAL_U = 0x1D1C;
const char32_t LATIN_SMALL_LETTER_SIDEWAYS_U = 0x1D1D;
const char32_t LATIN_SMALL_LETTER_SIDEWAYS_DIAERESIZED_U = 0x1D1E;
const char32_t LATIN_SMALL_LETTER_SIDEWAYS_TURNED_M = 0x1D1F;
const char32_t LATIN_LETTER_SMALL_CAPITAL_V = 0x1D20;
const char32_t LATIN_LETTER_SMALL_CAPITAL_W = 0x1D21;
const char32_t LATIN_LETTER_SMALL_CAPITAL_Z = 0x1D22;
const char32_t LATIN_LETTER_SMALL_CAPITAL_EZH = 0x1D23;
const char32_t LATIN_LETTER_VOICED_LARYNGEAL_SPIRANT = 0x1D24;
const char32_t LATIN_LETTER_AIN = 0x1D25;
const char32_t GREEK_LETTER_SMALL_CAPITAL_GAMMA = 0x1D26;
const char32_t GREEK_LETTER_SMALL_CAPITAL_LAMDA = 0x1D27;
const char32_t GREEK_LETTER_SMALL_CAPITAL_PI = 0x1D28;
const char32_t GREEK_LETTER_SMALL_CAPITAL_RHO = 0x1D29;
const char32_t GREEK_LETTER_SMALL_CAPITAL_PSI = 0x1D2A;
const char32_t CYRILLIC_LETTER_SMALL_CAPITAL_EL = 0x1D2B;
const char32_t MODIFIER_LETTER_CAPITAL_A = 0x1D2C;
const char32_t MODIFIER_LETTER_CAPITAL_AE = 0x1D2D;
const char32_t MODIFIER_LETTER_CAPITAL_B = 0x1D2E;
const char32_t MODIFIER_LETTER_CAPITAL_BARRED_B = 0x1D2F;
const char32_t MODIFIER_LETTER_CAPITAL_D = 0x1D30;
const char32_t MODIFIER_LETTER_CAPITAL_E = 0x1D31;
const char32_t MODIFIER_LETTER_CAPITAL_REVERSED_E = 0x1D32;
const char32_t MODIFIER_LETTER_CAPITAL_G = 0x1D33;
const char32_t MODIFIER_LETTER_CAPITAL_H = 0x1D34;
const char32_t MODIFIER_LETTER_CAPITAL_I = 0x1D35;
const char32_t MODIFIER_LETTER_CAPITAL_J = 0x1D36;
const char32_t MODIFIER_LETTER_CAPITAL_K = 0x1D37;
const char32_t MODIFIER_LETTER_CAPITAL_L = 0x1D38;
const char32_t MODIFIER_LETTER_CAPITAL_M = 0x1D39;
const char32_t MODIFIER_LETTER_CAPITAL_N = 0x1D3A;
const char32_t MODIFIER_LETTER_CAPITAL_REVERSED_N = 0x1D3B;
const char32_t MODIFIER_LETTER_CAPITAL_O = 0x1D3C;
const char32_t MODIFIER_LETTER_CAPITAL_OU = 0x1D3D;
const char32_t MODIFIER_LETTER_CAPITAL_P = 0x1D3E;
const char32_t MODIFIER_LETTER_CAPITAL_R = 0x1D3F;
const char32_t MODIFIER_LETTER_CAPITAL_T = 0x1D40;
const char32_t MODIFIER_LETTER_CAPITAL_U = 0x1D41;
const char32_t MODIFIER_LETTER_CAPITAL_W = 0x1D42;
const char32_t MODIFIER_LETTER_SMALL_A = 0x1D43;
const char32_t MODIFIER_LETTER_SMALL_TURNED_A = 0x1D44;
const char32_t MODIFIER_LETTER_SMALL_ALPHA = 0x1D45;
const char32_t MODIFIER_LETTER_SMALL_TURNED_AE = 0x1D46;
const char32_t MODIFIER_LETTER_SMALL_B = 0x1D47;
const char32_t MODIFIER_LETTER_SMALL_D = 0x1D48;
const char32_t MODIFIER_LETTER_SMALL_E = 0x1D49;
const char32_t MODIFIER_LETTER_SMALL_SCHWA = 0x1D4A;
const char32_t MODIFIER_LETTER_SMALL_OPEN_E = 0x1D4B;
const char32_t MODIFIER_LETTER_SMALL_TURNED_OPEN_E = 0x1D4C;
const char32_t MODIFIER_LETTER_SMALL_G = 0x1D4D;
const char32_t MODIFIER_LETTER_SMALL_TURNED_I = 0x1D4E;
const char32_t MODIFIER_LETTER_SMALL_K = 0x1D4F;
const char32_t MODIFIER_LETTER_SMALL_M = 0x1D50;
const char32_t MODIFIER_LETTER_SMALL_ENG = 0x1D51;
const char32_t MODIFIER_LETTER_SMALL_O = 0x1D52;
const char32_t MODIFIER_LETTER_SMALL_OPEN_O = 0x1D53;
const char32_t MODIFIER_LETTER_SMALL_TOP_HALF_O = 0x1D54;
const char32_t MODIFIER_LETTER_SMALL_BOTTOM_HALF_O = 0x1D55;
const char32_t MODIFIER_LETTER_SMALL_P = 0x1D56;
const char32_t MODIFIER_LETTER_SMALL_T = 0x1D57;
const char32_t MODIFIER_LETTER_SMALL_U = 0x1D58;
const char32_t MODIFIER_LETTER_SMALL_SIDEWAYS_U = 0x1D59;
const char32_t MODIFIER_LETTER_SMALL_TURNED_M = 0x1D5A;
const char32_t MODIFIER_LETTER_SMALL_V = 0x1D5B;
const char32_t MODIFIER_LETTER_SMALL_AIN = 0x1D5C;
const char32_t MODIFIER_LETTER_SMALL_BETA = 0x1D5D;
const char32_t MODIFIER_LETTER_SMALL_GREEK_GAMMA = 0x1D5E;
const char32_t MODIFIER_LETTER_SMALL_DELTA = 0x1D5F;
const char32_t MODIFIER_LETTER_SMALL_GREEK_PHI = 0x1D60;
const char32_t MODIFIER_LETTER_SMALL_CHI = 0x1D61;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_I = 0x1D62;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_R = 0x1D63;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_U = 0x1D64;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_V = 0x1D65;
const char32_t GREEK_SUBSCRIPT_SMALL_LETTER_BETA = 0x1D66;
const char32_t GREEK_SUBSCRIPT_SMALL_LETTER_GAMMA = 0x1D67;
const char32_t GREEK_SUBSCRIPT_SMALL_LETTER_RHO = 0x1D68;
const char32_t GREEK_SUBSCRIPT_SMALL_LETTER_PHI = 0x1D69;
const char32_t GREEK_SUBSCRIPT_SMALL_LETTER_CHI = 0x1D6A;
const char32_t LATIN_SMALL_LETTER_UE = 0x1D6B;
const char32_t LATIN_SMALL_LETTER_B_WITH_MIDDLE_TILDE = 0x1D6C;
const char32_t LATIN_SMALL_LETTER_D_WITH_MIDDLE_TILDE = 0x1D6D;
const char32_t LATIN_SMALL_LETTER_F_WITH_MIDDLE_TILDE = 0x1D6E;
const char32_t LATIN_SMALL_LETTER_M_WITH_MIDDLE_TILDE = 0x1D6F;
const char32_t LATIN_SMALL_LETTER_N_WITH_MIDDLE_TILDE = 0x1D70;
const char32_t LATIN_SMALL_LETTER_P_WITH_MIDDLE_TILDE = 0x1D71;
const char32_t LATIN_SMALL_LETTER_R_WITH_MIDDLE_TILDE = 0x1D72;
const char32_t LATIN_SMALL_LETTER_R_WITH_FISHHOOK_AND_MIDDLE_TILDE = 0x1D73;
const char32_t LATIN_SMALL_LETTER_S_WITH_MIDDLE_TILDE = 0x1D74;
const char32_t LATIN_SMALL_LETTER_T_WITH_MIDDLE_TILDE = 0x1D75;
const char32_t LATIN_SMALL_LETTER_Z_WITH_MIDDLE_TILDE = 0x1D76;
const char32_t LATIN_SMALL_LETTER_TURNED_G = 0x1D77;
const char32_t MODIFIER_LETTER_CYRILLIC_EN = 0x1D78;
const char32_t LATIN_SMALL_LETTER_INSULAR_G = 0x1D79;
const char32_t LATIN_SMALL_LETTER_TH_WITH_STRIKETHROUGH = 0x1D7A;
const char32_t LATIN_SMALL_CAPITAL_LETTER_I_WITH_STROKE = 0x1D7B;
const char32_t LATIN_SMALL_LETTER_IOTA_WITH_STROKE = 0x1D7C;
const char32_t LATIN_SMALL_LETTER_P_WITH_STROKE = 0x1D7D;
const char32_t LATIN_SMALL_CAPITAL_LETTER_U_WITH_STROKE = 0x1D7E;
const char32_t LATIN_SMALL_LETTER_UPSILON_WITH_STROKE = 0x1D7F;
const char32_t LATIN_SMALL_LETTER_B_WITH_PALATAL_HOOK = 0x1D80;
const char32_t LATIN_SMALL_LETTER_D_WITH_PALATAL_HOOK = 0x1D81;
const char32_t LATIN_SMALL_LETTER_F_WITH_PALATAL_HOOK = 0x1D82;
const char32_t LATIN_SMALL_LETTER_G_WITH_PALATAL_HOOK = 0x1D83;
const char32_t LATIN_SMALL_LETTER_K_WITH_PALATAL_HOOK = 0x1D84;
const char32_t LATIN_SMALL_LETTER_L_WITH_PALATAL_HOOK = 0x1D85;
const char32_t LATIN_SMALL_LETTER_M_WITH_PALATAL_HOOK = 0x1D86;
const char32_t LATIN_SMALL_LETTER_N_WITH_PALATAL_HOOK = 0x1D87;
const char32_t LATIN_SMALL_LETTER_P_WITH_PALATAL_HOOK = 0x1D88;
const char32_t LATIN_SMALL_LETTER_R_WITH_PALATAL_HOOK = 0x1D89;
const char32_t LATIN_SMALL_LETTER_S_WITH_PALATAL_HOOK = 0x1D8A;
const char32_t LATIN_SMALL_LETTER_ESH_WITH_PALATAL_HOOK = 0x1D8B;
const char32_t LATIN_SMALL_LETTER_V_WITH_PALATAL_HOOK = 0x1D8C;
const char32_t LATIN_SMALL_LETTER_X_WITH_PALATAL_HOOK = 0x1D8D;
const char32_t LATIN_SMALL_LETTER_Z_WITH_PALATAL_HOOK = 0x1D8E;
const char32_t LATIN_SMALL_LETTER_A_WITH_RETROFLEX_HOOK = 0x1D8F;
const char32_t LATIN_SMALL_LETTER_ALPHA_WITH_RETROFLEX_HOOK = 0x1D90;
const char32_t LATIN_SMALL_LETTER_D_WITH_HOOK_AND_TAIL = 0x1D91;
const char32_t LATIN_SMALL_LETTER_E_WITH_RETROFLEX_HOOK = 0x1D92;
const char32_t LATIN_SMALL_LETTER_OPEN_E_WITH_RETROFLEX_HOOK = 0x1D93;
const char32_t LATIN_SMALL_LETTER_REVERSED_OPEN_E_WITH_RETROFLEX_HOOK = 0x1D94;
const char32_t LATIN_SMALL_LETTER_SCHWA_WITH_RETROFLEX_HOOK = 0x1D95;
const char32_t LATIN_SMALL_LETTER_I_WITH_RETROFLEX_HOOK = 0x1D96;
const char32_t LATIN_SMALL_LETTER_OPEN_O_WITH_RETROFLEX_HOOK = 0x1D97;
const char32_t LATIN_SMALL_LETTER_ESH_WITH_RETROFLEX_HOOK = 0x1D98;
const char32_t LATIN_SMALL_LETTER_U_WITH_RETROFLEX_HOOK = 0x1D99;
const char32_t LATIN_SMALL_LETTER_EZH_WITH_RETROFLEX_HOOK = 0x1D9A;
const char32_t MODIFIER_LETTER_SMALL_TURNED_ALPHA = 0x1D9B;
const char32_t MODIFIER_LETTER_SMALL_C = 0x1D9C;
const char32_t MODIFIER_LETTER_SMALL_C_WITH_CURL = 0x1D9D;
const char32_t MODIFIER_LETTER_SMALL_ETH = 0x1D9E;
const char32_t MODIFIER_LETTER_SMALL_REVERSED_OPEN_E = 0x1D9F;
const char32_t MODIFIER_LETTER_SMALL_F = 0x1DA0;
const char32_t MODIFIER_LETTER_SMALL_DOTLESS_J_WITH_STROKE = 0x1DA1;
const char32_t MODIFIER_LETTER_SMALL_SCRIPT_G = 0x1DA2;
const char32_t MODIFIER_LETTER_SMALL_TURNED_H = 0x1DA3;
const char32_t MODIFIER_LETTER_SMALL_I_WITH_STROKE = 0x1DA4;
const char32_t MODIFIER_LETTER_SMALL_IOTA = 0x1DA5;
const char32_t MODIFIER_LETTER_SMALL_CAPITAL_I = 0x1DA6;
const char32_t MODIFIER_LETTER_SMALL_CAPITAL_I_WITH_STROKE = 0x1DA7;
const char32_t MODIFIER_LETTER_SMALL_J_WITH_CROSSED_TAIL = 0x1DA8;
const char32_t MODIFIER_LETTER_SMALL_L_WITH_RETROFLEX_HOOK = 0x1DA9;
const char32_t MODIFIER_LETTER_SMALL_L_WITH_PALATAL_HOOK = 0x1DAA;
const char32_t MODIFIER_LETTER_SMALL_CAPITAL_L = 0x1DAB;
const char32_t MODIFIER_LETTER_SMALL_M_WITH_HOOK = 0x1DAC;
const char32_t MODIFIER_LETTER_SMALL_TURNED_M_WITH_LONG_LEG = 0x1DAD;
const char32_t MODIFIER_LETTER_SMALL_N_WITH_LEFT_HOOK = 0x1DAE;
const char32_t MODIFIER_LETTER_SMALL_N_WITH_RETROFLEX_HOOK = 0x1DAF;
const char32_t MODIFIER_LETTER_SMALL_CAPITAL_N = 0x1DB0;
const char32_t MODIFIER_LETTER_SMALL_BARRED_O = 0x1DB1;
const char32_t MODIFIER_LETTER_SMALL_PHI = 0x1DB2;
const char32_t MODIFIER_LETTER_SMALL_S_WITH_HOOK = 0x1DB3;
const char32_t MODIFIER_LETTER_SMALL_ESH = 0x1DB4;
const char32_t MODIFIER_LETTER_SMALL_T_WITH_PALATAL_HOOK = 0x1DB5;
const char32_t MODIFIER_LETTER_SMALL_U_BAR = 0x1DB6;
const char32_t MODIFIER_LETTER_SMALL_UPSILON = 0x1DB7;
const char32_t MODIFIER_LETTER_SMALL_CAPITAL_U = 0x1DB8;
const char32_t MODIFIER_LETTER_SMALL_V_WITH_HOOK = 0x1DB9;
const char32_t MODIFIER_LETTER_SMALL_TURNED_V = 0x1DBA;
const char32_t MODIFIER_LETTER_SMALL_Z = 0x1DBB;
const char32_t MODIFIER_LETTER_SMALL_Z_WITH_RETROFLEX_HOOK = 0x1DBC;
const char32_t MODIFIER_LETTER_SMALL_Z_WITH_CURL = 0x1DBD;
const char32_t MODIFIER_LETTER_SMALL_EZH = 0x1DBE;
const char32_t MODIFIER_LETTER_SMALL_THETA = 0x1DBF;
const char32_t COMBINING_DOTTED_GRAVE_ACCENT = 0x1DC0;
const char32_t COMBINING_DOTTED_ACUTE_ACCENT = 0x1DC1;
const char32_t COMBINING_SNAKE_BELOW = 0x1DC2;
const char32_t COMBINING_SUSPENSION_MARK = 0x1DC3;
const char32_t COMBINING_MACRON_ACUTE = 0x1DC4;
const char32_t COMBINING_GRAVE_MACRON = 0x1DC5;
const char32_t COMBINING_MACRON_GRAVE = 0x1DC6;
const char32_t COMBINING_ACUTE_MACRON = 0x1DC7;
const char32_t COMBINING_GRAVE_ACUTE_GRAVE = 0x1DC8;
const char32_t COMBINING_ACUTE_GRAVE_ACUTE = 0x1DC9;
const char32_t COMBINING_LATIN_SMALL_LETTER_R_BELOW = 0x1DCA;
const char32_t COMBINING_BREVE_MACRON = 0x1DCB;
const char32_t COMBINING_MACRON_BREVE = 0x1DCC;
const char32_t COMBINING_DOUBLE_CIRCUMFLEX_ABOVE = 0x1DCD;
const char32_t COMBINING_OGONEK_ABOVE = 0x1DCE;
const char32_t COMBINING_ZIGZAG_BELOW = 0x1DCF;
const char32_t COMBINING_IS_BELOW = 0x1DD0;
const char32_t COMBINING_UR_ABOVE = 0x1DD1;
const char32_t COMBINING_US_ABOVE = 0x1DD2;
const char32_t COMBINING_LATIN_SMALL_LETTER_FLATTENED_OPEN_A_ABOVE = 0x1DD3;
const char32_t COMBINING_LATIN_SMALL_LETTER_AE = 0x1DD4;
const char32_t COMBINING_LATIN_SMALL_LETTER_AO = 0x1DD5;
const char32_t COMBINING_LATIN_SMALL_LETTER_AV = 0x1DD6;
const char32_t COMBINING_LATIN_SMALL_LETTER_C_CEDILLA = 0x1DD7;
const char32_t COMBINING_LATIN_SMALL_LETTER_INSULAR_D = 0x1DD8;
const char32_t COMBINING_LATIN_SMALL_LETTER_ETH = 0x1DD9;
const char32_t COMBINING_LATIN_SMALL_LETTER_G = 0x1DDA;
const char32_t COMBINING_LATIN_LETTER_SMALL_CAPITAL_G = 0x1DDB;
const char32_t COMBINING_LATIN_SMALL_LETTER_K = 0x1DDC;
const char32_t COMBINING_LATIN_SMALL_LETTER_L = 0x1DDD;
const char32_t COMBINING_LATIN_LETTER_SMALL_CAPITAL_L = 0x1DDE;
const char32_t COMBINING_LATIN_LETTER_SMALL_CAPITAL_M = 0x1DDF;
const char32_t COMBINING_LATIN_SMALL_LETTER_N = 0x1DE0;
const char32_t COMBINING_LATIN_LETTER_SMALL_CAPITAL_N = 0x1DE1;
const char32_t COMBINING_LATIN_LETTER_SMALL_CAPITAL_R = 0x1DE2;
const char32_t COMBINING_LATIN_SMALL_LETTER_R_ROTUNDA = 0x1DE3;
const char32_t COMBINING_LATIN_SMALL_LETTER_S = 0x1DE4;
const char32_t COMBINING_LATIN_SMALL_LETTER_LONG_S = 0x1DE5;
const char32_t COMBINING_LATIN_SMALL_LETTER_Z = 0x1DE6;
const char32_t COMBINING_LATIN_SMALL_LETTER_ALPHA = 0x1DE7;
const char32_t COMBINING_LATIN_SMALL_LETTER_B = 0x1DE8;
const char32_t COMBINING_LATIN_SMALL_LETTER_BETA = 0x1DE9;
const char32_t COMBINING_LATIN_SMALL_LETTER_SCHWA = 0x1DEA;
const char32_t COMBINING_LATIN_SMALL_LETTER_F = 0x1DEB;
const char32_t COMBINING_LATIN_SMALL_LETTER_L_WITH_DOUBLE_MIDDLE_TILDE = 0x1DEC;
const char32_t COMBINING_LATIN_SMALL_LETTER_O_WITH_LIGHT_CENTRALIZATION_STROKE = 0x1DED;
const char32_t COMBINING_LATIN_SMALL_LETTER_P = 0x1DEE;
const char32_t COMBINING_LATIN_SMALL_LETTER_ESH = 0x1DEF;
const char32_t COMBINING_LATIN_SMALL_LETTER_U_WITH_LIGHT_CENTRALIZATION_STROKE = 0x1DF0;
const char32_t COMBINING_LATIN_SMALL_LETTER_W = 0x1DF1;
const char32_t COMBINING_LATIN_SMALL_LETTER_A_WITH_DIAERESIS = 0x1DF2;
const char32_t COMBINING_LATIN_SMALL_LETTER_O_WITH_DIAERESIS = 0x1DF3;
const char32_t COMBINING_LATIN_SMALL_LETTER_U_WITH_DIAERESIS = 0x1DF4;
const char32_t COMBINING_UP_TACK_ABOVE = 0x1DF5;
const char32_t COMBINING_KAVYKA_ABOVE_RIGHT = 0x1DF6;
const char32_t COMBINING_KAVYKA_ABOVE_LEFT = 0x1DF7;
const char32_t COMBINING_DOT_ABOVE_LEFT = 0x1DF8;
const char32_t COMBINING_WIDE_INVERTED_BRIDGE_BELOW = 0x1DF9;
const char32_t COMBINING_DELETION_MARK = 0x1DFB;
const char32_t COMBINING_DOUBLE_INVERTED_BREVE_BELOW = 0x1DFC;
const char32_t COMBINING_ALMOST_EQUAL_TO_BELOW = 0x1DFD;
const char32_t COMBINING_LEFT_ARROWHEAD_ABOVE = 0x1DFE;
const char32_t COMBINING_RIGHT_ARROWHEAD_AND_DOWN_ARROWHEAD_BELOW = 0x1DFF;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_RING_BELOW = 0x1E00;
const char32_t LATIN_SMALL_LETTER_A_WITH_RING_BELOW = 0x1E01;
const char32_t LATIN_CAPITAL_LETTER_B_WITH_DOT_ABOVE = 0x1E02;
const char32_t LATIN_SMALL_LETTER_B_WITH_DOT_ABOVE = 0x1E03;
const char32_t LATIN_CAPITAL_LETTER_B_WITH_DOT_BELOW = 0x1E04;
const char32_t LATIN_SMALL_LETTER_B_WITH_DOT_BELOW = 0x1E05;
const char32_t LATIN_CAPITAL_LETTER_B_WITH_LINE_BELOW = 0x1E06;
const char32_t LATIN_SMALL_LETTER_B_WITH_LINE_BELOW = 0x1E07;
const char32_t LATIN_CAPITAL_LETTER_C_WITH_CEDILLA_AND_ACUTE = 0x1E08;
const char32_t LATIN_SMALL_LETTER_C_WITH_CEDILLA_AND_ACUTE = 0x1E09;
const char32_t LATIN_CAPITAL_LETTER_D_WITH_DOT_ABOVE = 0x1E0A;
const char32_t LATIN_SMALL_LETTER_D_WITH_DOT_ABOVE = 0x1E0B;
const char32_t LATIN_CAPITAL_LETTER_D_WITH_DOT_BELOW = 0x1E0C;
const char32_t LATIN_SMALL_LETTER_D_WITH_DOT_BELOW = 0x1E0D;
const char32_t LATIN_CAPITAL_LETTER_D_WITH_LINE_BELOW = 0x1E0E;
const char32_t LATIN_SMALL_LETTER_D_WITH_LINE_BELOW = 0x1E0F;
const char32_t LATIN_CAPITAL_LETTER_D_WITH_CEDILLA = 0x1E10;
const char32_t LATIN_SMALL_LETTER_D_WITH_CEDILLA = 0x1E11;
const char32_t LATIN_CAPITAL_LETTER_D_WITH_CIRCUMFLEX_BELOW = 0x1E12;
const char32_t LATIN_SMALL_LETTER_D_WITH_CIRCUMFLEX_BELOW = 0x1E13;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_MACRON_AND_GRAVE = 0x1E14;
const char32_t LATIN_SMALL_LETTER_E_WITH_MACRON_AND_GRAVE = 0x1E15;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_MACRON_AND_ACUTE = 0x1E16;
const char32_t LATIN_SMALL_LETTER_E_WITH_MACRON_AND_ACUTE = 0x1E17;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_BELOW = 0x1E18;
const char32_t LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_BELOW = 0x1E19;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_TILDE_BELOW = 0x1E1A;
const char32_t LATIN_SMALL_LETTER_E_WITH_TILDE_BELOW = 0x1E1B;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_CEDILLA_AND_BREVE = 0x1E1C;
const char32_t LATIN_SMALL_LETTER_E_WITH_CEDILLA_AND_BREVE = 0x1E1D;
const char32_t LATIN_CAPITAL_LETTER_F_WITH_DOT_ABOVE = 0x1E1E;
const char32_t LATIN_SMALL_LETTER_F_WITH_DOT_ABOVE = 0x1E1F;
const char32_t LATIN_CAPITAL_LETTER_G_WITH_MACRON = 0x1E20;
const char32_t LATIN_SMALL_LETTER_G_WITH_MACRON = 0x1E21;
const char32_t LATIN_CAPITAL_LETTER_H_WITH_DOT_ABOVE = 0x1E22;
const char32_t LATIN_SMALL_LETTER_H_WITH_DOT_ABOVE = 0x1E23;
const char32_t LATIN_CAPITAL_LETTER_H_WITH_DOT_BELOW = 0x1E24;
const char32_t LATIN_SMALL_LETTER_H_WITH_DOT_BELOW = 0x1E25;
const char32_t LATIN_CAPITAL_LETTER_H_WITH_DIAERESIS = 0x1E26;
const char32_t LATIN_SMALL_LETTER_H_WITH_DIAERESIS = 0x1E27;
const char32_t LATIN_CAPITAL_LETTER_H_WITH_CEDILLA = 0x1E28;
const char32_t LATIN_SMALL_LETTER_H_WITH_CEDILLA = 0x1E29;
const char32_t LATIN_CAPITAL_LETTER_H_WITH_BREVE_BELOW = 0x1E2A;
const char32_t LATIN_SMALL_LETTER_H_WITH_BREVE_BELOW = 0x1E2B;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_TILDE_BELOW = 0x1E2C;
const char32_t LATIN_SMALL_LETTER_I_WITH_TILDE_BELOW = 0x1E2D;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS_AND_ACUTE = 0x1E2E;
const char32_t LATIN_SMALL_LETTER_I_WITH_DIAERESIS_AND_ACUTE = 0x1E2F;
const char32_t LATIN_CAPITAL_LETTER_K_WITH_ACUTE = 0x1E30;
const char32_t LATIN_SMALL_LETTER_K_WITH_ACUTE = 0x1E31;
const char32_t LATIN_CAPITAL_LETTER_K_WITH_DOT_BELOW = 0x1E32;
const char32_t LATIN_SMALL_LETTER_K_WITH_DOT_BELOW = 0x1E33;
const char32_t LATIN_CAPITAL_LETTER_K_WITH_LINE_BELOW = 0x1E34;
const char32_t LATIN_SMALL_LETTER_K_WITH_LINE_BELOW = 0x1E35;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_DOT_BELOW = 0x1E36;
const char32_t LATIN_SMALL_LETTER_L_WITH_DOT_BELOW = 0x1E37;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_DOT_BELOW_AND_MACRON = 0x1E38;
const char32_t LATIN_SMALL_LETTER_L_WITH_DOT_BELOW_AND_MACRON = 0x1E39;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_LINE_BELOW = 0x1E3A;
const char32_t LATIN_SMALL_LETTER_L_WITH_LINE_BELOW = 0x1E3B;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_CIRCUMFLEX_BELOW = 0x1E3C;
const char32_t LATIN_SMALL_LETTER_L_WITH_CIRCUMFLEX_BELOW = 0x1E3D;
const char32_t LATIN_CAPITAL_LETTER_M_WITH_ACUTE = 0x1E3E;
const char32_t LATIN_SMALL_LETTER_M_WITH_ACUTE = 0x1E3F;
const char32_t LATIN_CAPITAL_LETTER_M_WITH_DOT_ABOVE = 0x1E40;
const char32_t LATIN_SMALL_LETTER_M_WITH_DOT_ABOVE = 0x1E41;
const char32_t LATIN_CAPITAL_LETTER_M_WITH_DOT_BELOW = 0x1E42;
const char32_t LATIN_SMALL_LETTER_M_WITH_DOT_BELOW = 0x1E43;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_DOT_ABOVE = 0x1E44;
const char32_t LATIN_SMALL_LETTER_N_WITH_DOT_ABOVE = 0x1E45;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_DOT_BELOW = 0x1E46;
const char32_t LATIN_SMALL_LETTER_N_WITH_DOT_BELOW = 0x1E47;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_LINE_BELOW = 0x1E48;
const char32_t LATIN_SMALL_LETTER_N_WITH_LINE_BELOW = 0x1E49;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_CIRCUMFLEX_BELOW = 0x1E4A;
const char32_t LATIN_SMALL_LETTER_N_WITH_CIRCUMFLEX_BELOW = 0x1E4B;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_ACUTE = 0x1E4C;
const char32_t LATIN_SMALL_LETTER_O_WITH_TILDE_AND_ACUTE = 0x1E4D;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_DIAERESIS = 0x1E4E;
const char32_t LATIN_SMALL_LETTER_O_WITH_TILDE_AND_DIAERESIS = 0x1E4F;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_MACRON_AND_GRAVE = 0x1E50;
const char32_t LATIN_SMALL_LETTER_O_WITH_MACRON_AND_GRAVE = 0x1E51;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_MACRON_AND_ACUTE = 0x1E52;
const char32_t LATIN_SMALL_LETTER_O_WITH_MACRON_AND_ACUTE = 0x1E53;
const char32_t LATIN_CAPITAL_LETTER_P_WITH_ACUTE = 0x1E54;
const char32_t LATIN_SMALL_LETTER_P_WITH_ACUTE = 0x1E55;
const char32_t LATIN_CAPITAL_LETTER_P_WITH_DOT_ABOVE = 0x1E56;
const char32_t LATIN_SMALL_LETTER_P_WITH_DOT_ABOVE = 0x1E57;
const char32_t LATIN_CAPITAL_LETTER_R_WITH_DOT_ABOVE = 0x1E58;
const char32_t LATIN_SMALL_LETTER_R_WITH_DOT_ABOVE = 0x1E59;
const char32_t LATIN_CAPITAL_LETTER_R_WITH_DOT_BELOW = 0x1E5A;
const char32_t LATIN_SMALL_LETTER_R_WITH_DOT_BELOW = 0x1E5B;
const char32_t LATIN_CAPITAL_LETTER_R_WITH_DOT_BELOW_AND_MACRON = 0x1E5C;
const char32_t LATIN_SMALL_LETTER_R_WITH_DOT_BELOW_AND_MACRON = 0x1E5D;
const char32_t LATIN_CAPITAL_LETTER_R_WITH_LINE_BELOW = 0x1E5E;
const char32_t LATIN_SMALL_LETTER_R_WITH_LINE_BELOW = 0x1E5F;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_DOT_ABOVE = 0x1E60;
const char32_t LATIN_SMALL_LETTER_S_WITH_DOT_ABOVE = 0x1E61;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_DOT_BELOW = 0x1E62;
const char32_t LATIN_SMALL_LETTER_S_WITH_DOT_BELOW = 0x1E63;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE = 0x1E64;
const char32_t LATIN_SMALL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE = 0x1E65;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_CARON_AND_DOT_ABOVE = 0x1E66;
const char32_t LATIN_SMALL_LETTER_S_WITH_CARON_AND_DOT_ABOVE = 0x1E67;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE = 0x1E68;
const char32_t LATIN_SMALL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE = 0x1E69;
const char32_t LATIN_CAPITAL_LETTER_T_WITH_DOT_ABOVE = 0x1E6A;
const char32_t LATIN_SMALL_LETTER_T_WITH_DOT_ABOVE = 0x1E6B;
const char32_t LATIN_CAPITAL_LETTER_T_WITH_DOT_BELOW = 0x1E6C;
const char32_t LATIN_SMALL_LETTER_T_WITH_DOT_BELOW = 0x1E6D;
const char32_t LATIN_CAPITAL_LETTER_T_WITH_LINE_BELOW = 0x1E6E;
const char32_t LATIN_SMALL_LETTER_T_WITH_LINE_BELOW = 0x1E6F;
const char32_t LATIN_CAPITAL_LETTER_T_WITH_CIRCUMFLEX_BELOW = 0x1E70;
const char32_t LATIN_SMALL_LETTER_T_WITH_CIRCUMFLEX_BELOW = 0x1E71;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_BELOW = 0x1E72;
const char32_t LATIN_SMALL_LETTER_U_WITH_DIAERESIS_BELOW = 0x1E73;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_TILDE_BELOW = 0x1E74;
const char32_t LATIN_SMALL_LETTER_U_WITH_TILDE_BELOW = 0x1E75;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX_BELOW = 0x1E76;
const char32_t LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX_BELOW = 0x1E77;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_TILDE_AND_ACUTE = 0x1E78;
const char32_t LATIN_SMALL_LETTER_U_WITH_TILDE_AND_ACUTE = 0x1E79;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_MACRON_AND_DIAERESIS = 0x1E7A;
const char32_t LATIN_SMALL_LETTER_U_WITH_MACRON_AND_DIAERESIS = 0x1E7B;
const char32_t LATIN_CAPITAL_LETTER_V_WITH_TILDE = 0x1E7C;
const char32_t LATIN_SMALL_LETTER_V_WITH_TILDE = 0x1E7D;
const char32_t LATIN_CAPITAL_LETTER_V_WITH_DOT_BELOW = 0x1E7E;
const char32_t LATIN_SMALL_LETTER_V_WITH_DOT_BELOW = 0x1E7F;
const char32_t LATIN_CAPITAL_LETTER_W_WITH_GRAVE = 0x1E80;
const char32_t LATIN_SMALL_LETTER_W_WITH_GRAVE = 0x1E81;
const char32_t LATIN_CAPITAL_LETTER_W_WITH_ACUTE = 0x1E82;
const char32_t LATIN_SMALL_LETTER_W_WITH_ACUTE = 0x1E83;
const char32_t LATIN_CAPITAL_LETTER_W_WITH_DIAERESIS = 0x1E84;
const char32_t LATIN_SMALL_LETTER_W_WITH_DIAERESIS = 0x1E85;
const char32_t LATIN_CAPITAL_LETTER_W_WITH_DOT_ABOVE = 0x1E86;
const char32_t LATIN_SMALL_LETTER_W_WITH_DOT_ABOVE = 0x1E87;
const char32_t LATIN_CAPITAL_LETTER_W_WITH_DOT_BELOW = 0x1E88;
const char32_t LATIN_SMALL_LETTER_W_WITH_DOT_BELOW = 0x1E89;
const char32_t LATIN_CAPITAL_LETTER_X_WITH_DOT_ABOVE = 0x1E8A;
const char32_t LATIN_SMALL_LETTER_X_WITH_DOT_ABOVE = 0x1E8B;
const char32_t LATIN_CAPITAL_LETTER_X_WITH_DIAERESIS = 0x1E8C;
const char32_t LATIN_SMALL_LETTER_X_WITH_DIAERESIS = 0x1E8D;
const char32_t LATIN_CAPITAL_LETTER_Y_WITH_DOT_ABOVE = 0x1E8E;
const char32_t LATIN_SMALL_LETTER_Y_WITH_DOT_ABOVE = 0x1E8F;
const char32_t LATIN_CAPITAL_LETTER_Z_WITH_CIRCUMFLEX = 0x1E90;
const char32_t LATIN_SMALL_LETTER_Z_WITH_CIRCUMFLEX = 0x1E91;
const char32_t LATIN_CAPITAL_LETTER_Z_WITH_DOT_BELOW = 0x1E92;
const char32_t LATIN_SMALL_LETTER_Z_WITH_DOT_BELOW = 0x1E93;
const char32_t LATIN_CAPITAL_LETTER_Z_WITH_LINE_BELOW = 0x1E94;
const char32_t LATIN_SMALL_LETTER_Z_WITH_LINE_BELOW = 0x1E95;
const char32_t LATIN_SMALL_LETTER_H_WITH_LINE_BELOW = 0x1E96;
const char32_t LATIN_SMALL_LETTER_T_WITH_DIAERESIS = 0x1E97;
const char32_t LATIN_SMALL_LETTER_W_WITH_RING_ABOVE = 0x1E98;
const char32_t LATIN_SMALL_LETTER_Y_WITH_RING_ABOVE = 0x1E99;
const char32_t LATIN_SMALL_LETTER_A_WITH_RIGHT_HALF_RING = 0x1E9A;
const char32_t LATIN_SMALL_LETTER_LONG_S_WITH_DOT_ABOVE = 0x1E9B;
const char32_t LATIN_SMALL_LETTER_LONG_S_WITH_DIAGONAL_STROKE = 0x1E9C;
const char32_t LATIN_SMALL_LETTER_LONG_S_WITH_HIGH_STROKE = 0x1E9D;
const char32_t LATIN_CAPITAL_LETTER_SHARP_S = 0x1E9E;
const char32_t LATIN_SMALL_LETTER_DELTA = 0x1E9F;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_DOT_BELOW = 0x1EA0;
const char32_t LATIN_SMALL_LETTER_A_WITH_DOT_BELOW = 0x1EA1;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_HOOK_ABOVE = 0x1EA2;
const char32_t LATIN_SMALL_LETTER_A_WITH_HOOK_ABOVE = 0x1EA3;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE = 0x1EA4;
const char32_t LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE = 0x1EA5;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE = 0x1EA6;
const char32_t LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE = 0x1EA7;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE = 0x1EA8;
const char32_t LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE = 0x1EA9;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE = 0x1EAA;
const char32_t LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE = 0x1EAB;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW = 0x1EAC;
const char32_t LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW = 0x1EAD;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_ACUTE = 0x1EAE;
const char32_t LATIN_SMALL_LETTER_A_WITH_BREVE_AND_ACUTE = 0x1EAF;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_GRAVE = 0x1EB0;
const char32_t LATIN_SMALL_LETTER_A_WITH_BREVE_AND_GRAVE = 0x1EB1;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE = 0x1EB2;
const char32_t LATIN_SMALL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE = 0x1EB3;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_TILDE = 0x1EB4;
const char32_t LATIN_SMALL_LETTER_A_WITH_BREVE_AND_TILDE = 0x1EB5;
const char32_t LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_DOT_BELOW = 0x1EB6;
const char32_t LATIN_SMALL_LETTER_A_WITH_BREVE_AND_DOT_BELOW = 0x1EB7;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_DOT_BELOW = 0x1EB8;
const char32_t LATIN_SMALL_LETTER_E_WITH_DOT_BELOW = 0x1EB9;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_HOOK_ABOVE = 0x1EBA;
const char32_t LATIN_SMALL_LETTER_E_WITH_HOOK_ABOVE = 0x1EBB;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_TILDE = 0x1EBC;
const char32_t LATIN_SMALL_LETTER_E_WITH_TILDE = 0x1EBD;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE = 0x1EBE;
const char32_t LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE = 0x1EBF;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE = 0x1EC0;
const char32_t LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE = 0x1EC1;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE = 0x1EC2;
const char32_t LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE = 0x1EC3;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE = 0x1EC4;
const char32_t LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE = 0x1EC5;
const char32_t LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW = 0x1EC6;
const char32_t LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW = 0x1EC7;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_HOOK_ABOVE = 0x1EC8;
const char32_t LATIN_SMALL_LETTER_I_WITH_HOOK_ABOVE = 0x1EC9;
const char32_t LATIN_CAPITAL_LETTER_I_WITH_DOT_BELOW = 0x1ECA;
const char32_t LATIN_SMALL_LETTER_I_WITH_DOT_BELOW = 0x1ECB;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_DOT_BELOW = 0x1ECC;
const char32_t LATIN_SMALL_LETTER_O_WITH_DOT_BELOW = 0x1ECD;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_HOOK_ABOVE = 0x1ECE;
const char32_t LATIN_SMALL_LETTER_O_WITH_HOOK_ABOVE = 0x1ECF;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE = 0x1ED0;
const char32_t LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE = 0x1ED1;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE = 0x1ED2;
const char32_t LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE = 0x1ED3;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE = 0x1ED4;
const char32_t LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE = 0x1ED5;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE = 0x1ED6;
const char32_t LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE = 0x1ED7;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW = 0x1ED8;
const char32_t LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW = 0x1ED9;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_ACUTE = 0x1EDA;
const char32_t LATIN_SMALL_LETTER_O_WITH_HORN_AND_ACUTE = 0x1EDB;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_GRAVE = 0x1EDC;
const char32_t LATIN_SMALL_LETTER_O_WITH_HORN_AND_GRAVE = 0x1EDD;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE = 0x1EDE;
const char32_t LATIN_SMALL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE = 0x1EDF;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_TILDE = 0x1EE0;
const char32_t LATIN_SMALL_LETTER_O_WITH_HORN_AND_TILDE = 0x1EE1;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_DOT_BELOW = 0x1EE2;
const char32_t LATIN_SMALL_LETTER_O_WITH_HORN_AND_DOT_BELOW = 0x1EE3;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_DOT_BELOW = 0x1EE4;
const char32_t LATIN_SMALL_LETTER_U_WITH_DOT_BELOW = 0x1EE5;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_HOOK_ABOVE = 0x1EE6;
const char32_t LATIN_SMALL_LETTER_U_WITH_HOOK_ABOVE = 0x1EE7;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_ACUTE = 0x1EE8;
const char32_t LATIN_SMALL_LETTER_U_WITH_HORN_AND_ACUTE = 0x1EE9;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_GRAVE = 0x1EEA;
const char32_t LATIN_SMALL_LETTER_U_WITH_HORN_AND_GRAVE = 0x1EEB;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE = 0x1EEC;
const char32_t LATIN_SMALL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE = 0x1EED;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_TILDE = 0x1EEE;
const char32_t LATIN_SMALL_LETTER_U_WITH_HORN_AND_TILDE = 0x1EEF;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_DOT_BELOW = 0x1EF0;
const char32_t LATIN_SMALL_LETTER_U_WITH_HORN_AND_DOT_BELOW = 0x1EF1;
const char32_t LATIN_CAPITAL_LETTER_Y_WITH_GRAVE = 0x1EF2;
const char32_t LATIN_SMALL_LETTER_Y_WITH_GRAVE = 0x1EF3;
const char32_t LATIN_CAPITAL_LETTER_Y_WITH_DOT_BELOW = 0x1EF4;
const char32_t LATIN_SMALL_LETTER_Y_WITH_DOT_BELOW = 0x1EF5;
const char32_t LATIN_CAPITAL_LETTER_Y_WITH_HOOK_ABOVE = 0x1EF6;
const char32_t LATIN_SMALL_LETTER_Y_WITH_HOOK_ABOVE = 0x1EF7;
const char32_t LATIN_CAPITAL_LETTER_Y_WITH_TILDE = 0x1EF8;
const char32_t LATIN_SMALL_LETTER_Y_WITH_TILDE = 0x1EF9;
const char32_t LATIN_CAPITAL_LETTER_MIDDLE_WELSH_LL = 0x1EFA;
const char32_t LATIN_SMALL_LETTER_MIDDLE_WELSH_LL = 0x1EFB;
const char32_t LATIN_CAPITAL_LETTER_MIDDLE_WELSH_V = 0x1EFC;
const char32_t LATIN_SMALL_LETTER_MIDDLE_WELSH_V = 0x1EFD;
const char32_t LATIN_CAPITAL_LETTER_Y_WITH_LOOP = 0x1EFE;
const char32_t LATIN_SMALL_LETTER_Y_WITH_LOOP = 0x1EFF;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_PSILI = 0x1F00;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_DASIA = 0x1F01;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA = 0x1F02;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA = 0x1F03;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA = 0x1F04;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA = 0x1F05;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI = 0x1F06;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI = 0x1F07;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI = 0x1F08;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA = 0x1F09;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_VARIA = 0x1F0A;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_VARIA = 0x1F0B;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_OXIA = 0x1F0C;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_OXIA = 0x1F0D;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI = 0x1F0E;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI = 0x1F0F;
const char32_t GREEK_SMALL_LETTER_EPSILON_WITH_PSILI = 0x1F10;
const char32_t GREEK_SMALL_LETTER_EPSILON_WITH_DASIA = 0x1F11;
const char32_t GREEK_SMALL_LETTER_EPSILON_WITH_PSILI_AND_VARIA = 0x1F12;
const char32_t GREEK_SMALL_LETTER_EPSILON_WITH_DASIA_AND_VARIA = 0x1F13;
const char32_t GREEK_SMALL_LETTER_EPSILON_WITH_PSILI_AND_OXIA = 0x1F14;
const char32_t GREEK_SMALL_LETTER_EPSILON_WITH_DASIA_AND_OXIA = 0x1F15;
const char32_t GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI = 0x1F18;
const char32_t GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA = 0x1F19;
const char32_t GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI_AND_VARIA = 0x1F1A;
const char32_t GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA_AND_VARIA = 0x1F1B;
const char32_t GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI_AND_OXIA = 0x1F1C;
const char32_t GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA_AND_OXIA = 0x1F1D;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_PSILI = 0x1F20;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_DASIA = 0x1F21;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_VARIA = 0x1F22;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_VARIA = 0x1F23;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_OXIA = 0x1F24;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_OXIA = 0x1F25;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI = 0x1F26;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI = 0x1F27;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_PSILI = 0x1F28;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_DASIA = 0x1F29;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_VARIA = 0x1F2A;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_VARIA = 0x1F2B;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_OXIA = 0x1F2C;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_OXIA = 0x1F2D;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI = 0x1F2E;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI = 0x1F2F;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_PSILI = 0x1F30;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_DASIA = 0x1F31;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_VARIA = 0x1F32;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_VARIA = 0x1F33;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_OXIA = 0x1F34;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_OXIA = 0x1F35;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_PERISPOMENI = 0x1F36;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_PERISPOMENI = 0x1F37;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI = 0x1F38;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA = 0x1F39;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_VARIA = 0x1F3A;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_VARIA = 0x1F3B;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_OXIA = 0x1F3C;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_OXIA = 0x1F3D;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_PERISPOMENI = 0x1F3E;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_PERISPOMENI = 0x1F3F;
const char32_t GREEK_SMALL_LETTER_OMICRON_WITH_PSILI = 0x1F40;
const char32_t GREEK_SMALL_LETTER_OMICRON_WITH_DASIA = 0x1F41;
const char32_t GREEK_SMALL_LETTER_OMICRON_WITH_PSILI_AND_VARIA = 0x1F42;
const char32_t GREEK_SMALL_LETTER_OMICRON_WITH_DASIA_AND_VARIA = 0x1F43;
const char32_t GREEK_SMALL_LETTER_OMICRON_WITH_PSILI_AND_OXIA = 0x1F44;
const char32_t GREEK_SMALL_LETTER_OMICRON_WITH_DASIA_AND_OXIA = 0x1F45;
const char32_t GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI = 0x1F48;
const char32_t GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA = 0x1F49;
const char32_t GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI_AND_VARIA = 0x1F4A;
const char32_t GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA_AND_VARIA = 0x1F4B;
const char32_t GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI_AND_OXIA = 0x1F4C;
const char32_t GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA_AND_OXIA = 0x1F4D;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_PSILI = 0x1F50;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_DASIA = 0x1F51;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_VARIA = 0x1F52;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_VARIA = 0x1F53;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_OXIA = 0x1F54;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_OXIA = 0x1F55;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_PERISPOMENI = 0x1F56;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_PERISPOMENI = 0x1F57;
const char32_t GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA = 0x1F59;
const char32_t GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_VARIA = 0x1F5B;
const char32_t GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_OXIA = 0x1F5D;
const char32_t GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_PERISPOMENI = 0x1F5F;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_PSILI = 0x1F60;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_DASIA = 0x1F61;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_VARIA = 0x1F62;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_VARIA = 0x1F63;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_OXIA = 0x1F64;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_OXIA = 0x1F65;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI = 0x1F66;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI = 0x1F67;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI = 0x1F68;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA = 0x1F69;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_VARIA = 0x1F6A;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_VARIA = 0x1F6B;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_OXIA = 0x1F6C;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_OXIA = 0x1F6D;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI = 0x1F6E;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI = 0x1F6F;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_VARIA = 0x1F70;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_OXIA = 0x1F71;
const char32_t GREEK_SMALL_LETTER_EPSILON_WITH_VARIA = 0x1F72;
const char32_t GREEK_SMALL_LETTER_EPSILON_WITH_OXIA = 0x1F73;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_VARIA = 0x1F74;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_OXIA = 0x1F75;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_VARIA = 0x1F76;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_OXIA = 0x1F77;
const char32_t GREEK_SMALL_LETTER_OMICRON_WITH_VARIA = 0x1F78;
const char32_t GREEK_SMALL_LETTER_OMICRON_WITH_OXIA = 0x1F79;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_VARIA = 0x1F7A;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_OXIA = 0x1F7B;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_VARIA = 0x1F7C;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_OXIA = 0x1F7D;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_YPOGEGRAMMENI = 0x1F80;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_YPOGEGRAMMENI = 0x1F81;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI = 0x1F82;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI = 0x1F83;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI = 0x1F84;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI = 0x1F85;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI = 0x1F86;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI = 0x1F87;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PROSGEGRAMMENI = 0x1F88;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PROSGEGRAMMENI = 0x1F89;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI = 0x1F8A;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI = 0x1F8B;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI = 0x1F8C;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI = 0x1F8D;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI = 0x1F8E;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI = 0x1F8F;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_YPOGEGRAMMENI = 0x1F90;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_YPOGEGRAMMENI = 0x1F91;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI = 0x1F92;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI = 0x1F93;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI = 0x1F94;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI = 0x1F95;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI = 0x1F96;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI = 0x1F97;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PROSGEGRAMMENI = 0x1F98;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PROSGEGRAMMENI = 0x1F99;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI = 0x1F9A;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI = 0x1F9B;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI = 0x1F9C;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI = 0x1F9D;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI = 0x1F9E;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI = 0x1F9F;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_YPOGEGRAMMENI = 0x1FA0;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_YPOGEGRAMMENI = 0x1FA1;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI = 0x1FA2;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI = 0x1FA3;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI = 0x1FA4;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI = 0x1FA5;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI = 0x1FA6;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI = 0x1FA7;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PROSGEGRAMMENI = 0x1FA8;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PROSGEGRAMMENI = 0x1FA9;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI = 0x1FAA;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI = 0x1FAB;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI = 0x1FAC;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI = 0x1FAD;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI = 0x1FAE;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI = 0x1FAF;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_VRACHY = 0x1FB0;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_MACRON = 0x1FB1;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_VARIA_AND_YPOGEGRAMMENI = 0x1FB2;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_YPOGEGRAMMENI = 0x1FB3;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_OXIA_AND_YPOGEGRAMMENI = 0x1FB4;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_PERISPOMENI = 0x1FB6;
const char32_t GREEK_SMALL_LETTER_ALPHA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI = 0x1FB7;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_VRACHY = 0x1FB8;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_MACRON = 0x1FB9;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_VARIA = 0x1FBA;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_OXIA = 0x1FBB;
const char32_t GREEK_CAPITAL_LETTER_ALPHA_WITH_PROSGEGRAMMENI = 0x1FBC;
const char32_t GREEK_KORONIS = 0x1FBD;
const char32_t GREEK_PROSGEGRAMMENI = 0x1FBE;
const char32_t GREEK_PSILI = 0x1FBF;
const char32_t GREEK_PERISPOMENI = 0x1FC0;
const char32_t GREEK_DIALYTIKA_AND_PERISPOMENI = 0x1FC1;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_VARIA_AND_YPOGEGRAMMENI = 0x1FC2;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_YPOGEGRAMMENI = 0x1FC3;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_OXIA_AND_YPOGEGRAMMENI = 0x1FC4;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_PERISPOMENI = 0x1FC6;
const char32_t GREEK_SMALL_LETTER_ETA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI = 0x1FC7;
const char32_t GREEK_CAPITAL_LETTER_EPSILON_WITH_VARIA = 0x1FC8;
const char32_t GREEK_CAPITAL_LETTER_EPSILON_WITH_OXIA = 0x1FC9;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_VARIA = 0x1FCA;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_OXIA = 0x1FCB;
const char32_t GREEK_CAPITAL_LETTER_ETA_WITH_PROSGEGRAMMENI = 0x1FCC;
const char32_t GREEK_PSILI_AND_VARIA = 0x1FCD;
const char32_t GREEK_PSILI_AND_OXIA = 0x1FCE;
const char32_t GREEK_PSILI_AND_PERISPOMENI = 0x1FCF;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_VRACHY = 0x1FD0;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_MACRON = 0x1FD1;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_VARIA = 0x1FD2;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_OXIA = 0x1FD3;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_PERISPOMENI = 0x1FD6;
const char32_t GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_PERISPOMENI = 0x1FD7;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_VRACHY = 0x1FD8;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_MACRON = 0x1FD9;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_VARIA = 0x1FDA;
const char32_t GREEK_CAPITAL_LETTER_IOTA_WITH_OXIA = 0x1FDB;
const char32_t GREEK_DASIA_AND_VARIA = 0x1FDD;
const char32_t GREEK_DASIA_AND_OXIA = 0x1FDE;
const char32_t GREEK_DASIA_AND_PERISPOMENI = 0x1FDF;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_VRACHY = 0x1FE0;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_MACRON = 0x1FE1;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_VARIA = 0x1FE2;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_OXIA = 0x1FE3;
const char32_t GREEK_SMALL_LETTER_RHO_WITH_PSILI = 0x1FE4;
const char32_t GREEK_SMALL_LETTER_RHO_WITH_DASIA = 0x1FE5;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_PERISPOMENI = 0x1FE6;
const char32_t GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_PERISPOMENI = 0x1FE7;
const char32_t GREEK_CAPITAL_LETTER_UPSILON_WITH_VRACHY = 0x1FE8;
const char32_t GREEK_CAPITAL_LETTER_UPSILON_WITH_MACRON = 0x1FE9;
const char32_t GREEK_CAPITAL_LETTER_UPSILON_WITH_VARIA = 0x1FEA;
const char32_t GREEK_CAPITAL_LETTER_UPSILON_WITH_OXIA = 0x1FEB;
const char32_t GREEK_CAPITAL_LETTER_RHO_WITH_DASIA = 0x1FEC;
const char32_t GREEK_DIALYTIKA_AND_VARIA = 0x1FED;
const char32_t GREEK_DIALYTIKA_AND_OXIA = 0x1FEE;
const char32_t GREEK_VARIA = 0x1FEF;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_VARIA_AND_YPOGEGRAMMENI = 0x1FF2;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_YPOGEGRAMMENI = 0x1FF3;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_OXIA_AND_YPOGEGRAMMENI = 0x1FF4;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_PERISPOMENI = 0x1FF6;
const char32_t GREEK_SMALL_LETTER_OMEGA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI = 0x1FF7;
const char32_t GREEK_CAPITAL_LETTER_OMICRON_WITH_VARIA = 0x1FF8;
const char32_t GREEK_CAPITAL_LETTER_OMICRON_WITH_OXIA = 0x1FF9;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_VARIA = 0x1FFA;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_OXIA = 0x1FFB;
const char32_t GREEK_CAPITAL_LETTER_OMEGA_WITH_PROSGEGRAMMENI = 0x1FFC;
const char32_t GREEK_OXIA = 0x1FFD;
const char32_t GREEK_DASIA = 0x1FFE;
const char32_t EN_QUAD = 0x2000;
const char32_t EM_QUAD = 0x2001;
const char32_t EN_SPACE = 0x2002;
const char32_t EM_SPACE = 0x2003;
const char32_t THREE_PER_EM_SPACE = 0x2004;
const char32_t FOUR_PER_EM_SPACE = 0x2005;
const char32_t SIX_PER_EM_SPACE = 0x2006;
const char32_t FIGURE_SPACE = 0x2007;
const char32_t PUNCTUATION_SPACE = 0x2008;
const char32_t THIN_SPACE = 0x2009;
const char32_t HAIR_SPACE = 0x200A;
const char32_t ZERO_WIDTH_SPACE = 0x200B;
const char32_t ZERO_WIDTH_NON_JOINER = 0x200C;
const char32_t ZERO_WIDTH_JOINER = 0x200D;
const char32_t LEFT_TO_RIGHT_MARK = 0x200E;
const char32_t RIGHT_TO_LEFT_MARK = 0x200F;
const char32_t HYPHEN = 0x2010;
const char32_t NON_BREAKING_HYPHEN = 0x2011;
const char32_t FIGURE_DASH = 0x2012;
const char32_t EN_DASH = 0x2013;
const char32_t EM_DASH = 0x2014;
const char32_t HORIZONTAL_BAR = 0x2015;
const char32_t DOUBLE_VERTICAL_LINE = 0x2016;
const char32_t DOUBLE_LOW_LINE = 0x2017;
const char32_t LEFT_SINGLE_QUOTATION_MARK = 0x2018;
const char32_t RIGHT_SINGLE_QUOTATION_MARK = 0x2019;
const char32_t SINGLE_LOW_9_QUOTATION_MARK = 0x201A;
const char32_t SINGLE_HIGH_REVERSED_9_QUOTATION_MARK = 0x201B;
const char32_t LEFT_DOUBLE_QUOTATION_MARK = 0x201C;
const char32_t RIGHT_DOUBLE_QUOTATION_MARK = 0x201D;
const char32_t DOUBLE_LOW_9_QUOTATION_MARK = 0x201E;
const char32_t DOUBLE_HIGH_REVERSED_9_QUOTATION_MARK = 0x201F;
const char32_t DAGGER = 0x2020;
const char32_t DOUBLE_DAGGER = 0x2021;
const char32_t BULLET = 0x2022;
const char32_t TRIANGULAR_BULLET = 0x2023;
const char32_t ONE_DOT_LEADER = 0x2024;
const char32_t TWO_DOT_LEADER = 0x2025;
const char32_t HORIZONTAL_ELLIPSIS = 0x2026;
const char32_t HYPHENATION_POINT = 0x2027;
const char32_t LINE_SEPARATOR = 0x2028;
const char32_t PARAGRAPH_SEPARATOR = 0x2029;
const char32_t LEFT_TO_RIGHT_EMBEDDING = 0x202A;
const char32_t RIGHT_TO_LEFT_EMBEDDING = 0x202B;
const char32_t POP_DIRECTIONAL_FORMATTING = 0x202C;
const char32_t LEFT_TO_RIGHT_OVERRIDE = 0x202D;
const char32_t RIGHT_TO_LEFT_OVERRIDE = 0x202E;
const char32_t NARROW_NO_BREAK_SPACE = 0x202F;
const char32_t PER_MILLE_SIGN = 0x2030;
const char32_t PER_TEN_THOUSAND_SIGN = 0x2031;
const char32_t PRIME = 0x2032;
const char32_t DOUBLE_PRIME = 0x2033;
const char32_t TRIPLE_PRIME = 0x2034;
const char32_t REVERSED_PRIME = 0x2035;
const char32_t REVERSED_DOUBLE_PRIME = 0x2036;
const char32_t REVERSED_TRIPLE_PRIME = 0x2037;
const char32_t CARET = 0x2038;
const char32_t SINGLE_LEFT_POINTING_ANGLE_QUOTATION_MARK = 0x2039;
const char32_t SINGLE_RIGHT_POINTING_ANGLE_QUOTATION_MARK = 0x203A;
const char32_t REFERENCE_MARK = 0x203B;
const char32_t DOUBLE_EXCLAMATION_MARK = 0x203C;
const char32_t INTERROBANG = 0x203D;
const char32_t OVERLINE = 0x203E;
const char32_t UNDERTIE = 0x203F;
const char32_t CHARACTER_TIE = 0x2040;
const char32_t CARET_INSERTION_POINT = 0x2041;
const char32_t ASTERISM = 0x2042;
const char32_t HYPHEN_BULLET = 0x2043;
const char32_t FRACTION_SLASH = 0x2044;
const char32_t LEFT_SQUARE_BRACKET_WITH_QUILL = 0x2045;
const char32_t RIGHT_SQUARE_BRACKET_WITH_QUILL = 0x2046;
const char32_t DOUBLE_QUESTION_MARK = 0x2047;
const char32_t QUESTION_EXCLAMATION_MARK = 0x2048;
const char32_t EXCLAMATION_QUESTION_MARK = 0x2049;
const char32_t TIRONIAN_SIGN_ET = 0x204A;
const char32_t REVERSED_PILCROW_SIGN = 0x204B;
const char32_t BLACK_LEFTWARDS_BULLET = 0x204C;
const char32_t BLACK_RIGHTWARDS_BULLET = 0x204D;
const char32_t LOW_ASTERISK = 0x204E;
const char32_t REVERSED_SEMICOLON = 0x204F;
const char32_t CLOSE_UP = 0x2050;
const char32_t TWO_ASTERISKS_ALIGNED_VERTICALLY = 0x2051;
const char32_t COMMERCIAL_MINUS_SIGN = 0x2052;
const char32_t SWUNG_DASH = 0x2053;
const char32_t INVERTED_UNDERTIE = 0x2054;
const char32_t FLOWER_PUNCTUATION_MARK = 0x2055;
const char32_t THREE_DOT_PUNCTUATION = 0x2056;
const char32_t QUADRUPLE_PRIME = 0x2057;
const char32_t FOUR_DOT_PUNCTUATION = 0x2058;
const char32_t FIVE_DOT_PUNCTUATION = 0x2059;
const char32_t TWO_DOT_PUNCTUATION = 0x205A;
const char32_t FOUR_DOT_MARK = 0x205B;
const char32_t DOTTED_CROSS = 0x205C;
const char32_t TRICOLON = 0x205D;
const char32_t VERTICAL_FOUR_DOTS = 0x205E;
const char32_t MEDIUM_MATHEMATICAL_SPACE = 0x205F;
const char32_t WORD_JOINER = 0x2060;
const char32_t FUNCTION_APPLICATION = 0x2061;
const char32_t INVISIBLE_TIMES = 0x2062;
const char32_t INVISIBLE_SEPARATOR = 0x2063;
const char32_t INVISIBLE_PLUS = 0x2064;
const char32_t LEFT_TO_RIGHT_ISOLATE = 0x2066;
const char32_t RIGHT_TO_LEFT_ISOLATE = 0x2067;
const char32_t FIRST_STRONG_ISOLATE = 0x2068;
const char32_t POP_DIRECTIONAL_ISOLATE = 0x2069;
const char32_t INHIBIT_SYMMETRIC_SWAPPING = 0x206A;
const char32_t ACTIVATE_SYMMETRIC_SWAPPING = 0x206B;
const char32_t INHIBIT_ARABIC_FORM_SHAPING = 0x206C;
const char32_t ACTIVATE_ARABIC_FORM_SHAPING = 0x206D;
const char32_t NATIONAL_DIGIT_SHAPES = 0x206E;
const char32_t NOMINAL_DIGIT_SHAPES = 0x206F;
const char32_t SUPERSCRIPT_ZERO = 0x2070;
const char32_t SUPERSCRIPT_LATIN_SMALL_LETTER_I = 0x2071;
const char32_t SUPERSCRIPT_FOUR = 0x2074;
const char32_t SUPERSCRIPT_FIVE = 0x2075;
const char32_t SUPERSCRIPT_SIX = 0x2076;
const char32_t SUPERSCRIPT_SEVEN = 0x2077;
const char32_t SUPERSCRIPT_EIGHT = 0x2078;
const char32_t SUPERSCRIPT_NINE = 0x2079;
const char32_t SUPERSCRIPT_PLUS_SIGN = 0x207A;
const char32_t SUPERSCRIPT_MINUS = 0x207B;
const char32_t SUPERSCRIPT_EQUALS_SIGN = 0x207C;
const char32_t SUPERSCRIPT_LEFT_PARENTHESIS = 0x207D;
const char32_t SUPERSCRIPT_RIGHT_PARENTHESIS = 0x207E;
const char32_t SUPERSCRIPT_LATIN_SMALL_LETTER_N = 0x207F;
const char32_t SUBSCRIPT_ZERO = 0x2080;
const char32_t SUBSCRIPT_ONE = 0x2081;
const char32_t SUBSCRIPT_TWO = 0x2082;
const char32_t SUBSCRIPT_THREE = 0x2083;
const char32_t SUBSCRIPT_FOUR = 0x2084;
const char32_t SUBSCRIPT_FIVE = 0x2085;
const char32_t SUBSCRIPT_SIX = 0x2086;
const char32_t SUBSCRIPT_SEVEN = 0x2087;
const char32_t SUBSCRIPT_EIGHT = 0x2088;
const char32_t SUBSCRIPT_NINE = 0x2089;
const char32_t SUBSCRIPT_PLUS_SIGN = 0x208A;
const char32_t SUBSCRIPT_MINUS = 0x208B;
const char32_t SUBSCRIPT_EQUALS_SIGN = 0x208C;
const char32_t SUBSCRIPT_LEFT_PARENTHESIS = 0x208D;
const char32_t SUBSCRIPT_RIGHT_PARENTHESIS = 0x208E;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_A = 0x2090;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_E = 0x2091;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_O = 0x2092;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_X = 0x2093;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_SCHWA = 0x2094;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_H = 0x2095;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_K = 0x2096;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_L = 0x2097;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_M = 0x2098;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_N = 0x2099;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_P = 0x209A;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_S = 0x209B;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_T = 0x209C;
const char32_t EURO_CURRENCY_SIGN = 0x20A0;
const char32_t COLON_SIGN = 0x20A1;
const char32_t CRUZEIRO_SIGN = 0x20A2;
const char32_t FRENCH_FRANC_SIGN = 0x20A3;
const char32_t LIRA_SIGN = 0x20A4;
const char32_t MILL_SIGN = 0x20A5;
const char32_t NAIRA_SIGN = 0x20A6;
const char32_t PESETA_SIGN = 0x20A7;
const char32_t RUPEE_SIGN = 0x20A8;
const char32_t WON_SIGN = 0x20A9;
const char32_t NEW_SHEQEL_SIGN = 0x20AA;
const char32_t DONG_SIGN = 0x20AB;
const char32_t EURO_SIGN = 0x20AC;
const char32_t KIP_SIGN = 0x20AD;
const char32_t TUGRIK_SIGN = 0x20AE;
const char32_t DRACHMA_SIGN = 0x20AF;
const char32_t GERMAN_PENNY_SIGN = 0x20B0;
const char32_t PESO_SIGN = 0x20B1;
const char32_t GUARANI_SIGN = 0x20B2;
const char32_t AUSTRAL_SIGN = 0x20B3;
const char32_t HRYVNIA_SIGN = 0x20B4;
const char32_t CEDI_SIGN = 0x20B5;
const char32_t LIVRE_TOURNOIS_SIGN = 0x20B6;
const char32_t SPESMILO_SIGN = 0x20B7;
const char32_t TENGE_SIGN = 0x20B8;
const char32_t INDIAN_RUPEE_SIGN = 0x20B9;
const char32_t TURKISH_LIRA_SIGN = 0x20BA;
const char32_t NORDIC_MARK_SIGN = 0x20BB;
const char32_t MANAT_SIGN = 0x20BC;
const char32_t RUBLE_SIGN = 0x20BD;
const char32_t LARI_SIGN = 0x20BE;
const char32_t BITCOIN_SIGN = 0x20BF;
const char32_t COMBINING_LEFT_HARPOON_ABOVE = 0x20D0;
const char32_t COMBINING_RIGHT_HARPOON_ABOVE = 0x20D1;
const char32_t COMBINING_LONG_VERTICAL_LINE_OVERLAY = 0x20D2;
const char32_t COMBINING_SHORT_VERTICAL_LINE_OVERLAY = 0x20D3;
const char32_t COMBINING_ANTICLOCKWISE_ARROW_ABOVE = 0x20D4;
const char32_t COMBINING_CLOCKWISE_ARROW_ABOVE = 0x20D5;
const char32_t COMBINING_LEFT_ARROW_ABOVE = 0x20D6;
const char32_t COMBINING_RIGHT_ARROW_ABOVE = 0x20D7;
const char32_t COMBINING_RING_OVERLAY = 0x20D8;
const char32_t COMBINING_CLOCKWISE_RING_OVERLAY = 0x20D9;
const char32_t COMBINING_ANTICLOCKWISE_RING_OVERLAY = 0x20DA;
const char32_t COMBINING_THREE_DOTS_ABOVE = 0x20DB;
const char32_t COMBINING_FOUR_DOTS_ABOVE = 0x20DC;
const char32_t COMBINING_ENCLOSING_CIRCLE = 0x20DD;
const char32_t COMBINING_ENCLOSING_SQUARE = 0x20DE;
const char32_t COMBINING_ENCLOSING_DIAMOND = 0x20DF;
const char32_t COMBINING_ENCLOSING_CIRCLE_BACKSLASH = 0x20E0;
const char32_t COMBINING_LEFT_RIGHT_ARROW_ABOVE = 0x20E1;
const char32_t COMBINING_ENCLOSING_SCREEN = 0x20E2;
const char32_t COMBINING_ENCLOSING_KEYCAP = 0x20E3;
const char32_t COMBINING_ENCLOSING_UPWARD_POINTING_TRIANGLE = 0x20E4;
const char32_t COMBINING_REVERSE_SOLIDUS_OVERLAY = 0x20E5;
const char32_t COMBINING_DOUBLE_VERTICAL_STROKE_OVERLAY = 0x20E6;
const char32_t COMBINING_ANNUITY_SYMBOL = 0x20E7;
const char32_t COMBINING_TRIPLE_UNDERDOT = 0x20E8;
const char32_t COMBINING_WIDE_BRIDGE_ABOVE = 0x20E9;
const char32_t COMBINING_LEFTWARDS_ARROW_OVERLAY = 0x20EA;
const char32_t COMBINING_LONG_DOUBLE_SOLIDUS_OVERLAY = 0x20EB;
const char32_t COMBINING_RIGHTWARDS_HARPOON_WITH_BARB_DOWNWARDS = 0x20EC;
const char32_t COMBINING_LEFTWARDS_HARPOON_WITH_BARB_DOWNWARDS = 0x20ED;
const char32_t COMBINING_LEFT_ARROW_BELOW = 0x20EE;
const char32_t COMBINING_RIGHT_ARROW_BELOW = 0x20EF;
const char32_t COMBINING_ASTERISK_ABOVE = 0x20F0;
const char32_t ACCOUNT_OF = 0x2100;
const char32_t ADDRESSED_TO_THE_SUBJECT = 0x2101;
const char32_t DOUBLE_STRUCK_CAPITAL_C = 0x2102;
const char32_t DEGREE_CELSIUS = 0x2103;
const char32_t CENTRE_LINE_SYMBOL = 0x2104;
const char32_t CARE_OF = 0x2105;
const char32_t CADA_UNA = 0x2106;
const char32_t EULER_CONSTANT = 0x2107;
const char32_t SCRUPLE = 0x2108;
const char32_t DEGREE_FAHRENHEIT = 0x2109;
const char32_t SCRIPT_SMALL_G = 0x210A;
const char32_t SCRIPT_CAPITAL_H = 0x210B;
const char32_t BLACK_LETTER_CAPITAL_H = 0x210C;
const char32_t DOUBLE_STRUCK_CAPITAL_H = 0x210D;
const char32_t PLANCK_CONSTANT = 0x210E;
const char32_t PLANCK_CONSTANT_OVER_TWO_PI = 0x210F;
const char32_t SCRIPT_CAPITAL_I = 0x2110;
const char32_t BLACK_LETTER_CAPITAL_I = 0x2111;
const char32_t SCRIPT_CAPITAL_L = 0x2112;
const char32_t SCRIPT_SMALL_L = 0x2113;
const char32_t L_B_BAR_SYMBOL = 0x2114;
const char32_t DOUBLE_STRUCK_CAPITAL_N = 0x2115;
const char32_t NUMERO_SIGN = 0x2116;
const char32_t SOUND_RECORDING_COPYRIGHT = 0x2117;
const char32_t SCRIPT_CAPITAL_P = 0x2118;
const char32_t DOUBLE_STRUCK_CAPITAL_P = 0x2119;
const char32_t DOUBLE_STRUCK_CAPITAL_Q = 0x211A;
const char32_t SCRIPT_CAPITAL_R = 0x211B;
const char32_t BLACK_LETTER_CAPITAL_R = 0x211C;
const char32_t DOUBLE_STRUCK_CAPITAL_R = 0x211D;
const char32_t PRESCRIPTION_TAKE = 0x211E;
const char32_t RESPONSE = 0x211F;
const char32_t SERVICE_MARK = 0x2120;
const char32_t TELEPHONE_SIGN = 0x2121;
const char32_t TRADE_MARK_SIGN = 0x2122;
const char32_t VERSICLE = 0x2123;
const char32_t DOUBLE_STRUCK_CAPITAL_Z = 0x2124;
const char32_t OUNCE_SIGN = 0x2125;
const char32_t OHM_SIGN = 0x2126;
const char32_t INVERTED_OHM_SIGN = 0x2127;
const char32_t BLACK_LETTER_CAPITAL_Z = 0x2128;
const char32_t TURNED_GREEK_SMALL_LETTER_IOTA = 0x2129;
const char32_t KELVIN_SIGN = 0x212A;
const char32_t ANGSTROM_SIGN = 0x212B;
const char32_t SCRIPT_CAPITAL_B = 0x212C;
const char32_t BLACK_LETTER_CAPITAL_C = 0x212D;
const char32_t ESTIMATED_SYMBOL = 0x212E;
const char32_t SCRIPT_SMALL_E = 0x212F;
const char32_t SCRIPT_CAPITAL_E = 0x2130;
const char32_t SCRIPT_CAPITAL_F = 0x2131;
const char32_t TURNED_CAPITAL_F = 0x2132;
const char32_t SCRIPT_CAPITAL_M = 0x2133;
const char32_t SCRIPT_SMALL_O = 0x2134;
const char32_t ALEF_SYMBOL = 0x2135;
const char32_t BET_SYMBOL = 0x2136;
const char32_t GIMEL_SYMBOL = 0x2137;
const char32_t DALET_SYMBOL = 0x2138;
const char32_t INFORMATION_SOURCE = 0x2139;
const char32_t ROTATED_CAPITAL_Q = 0x213A;
const char32_t FACSIMILE_SIGN = 0x213B;
const char32_t DOUBLE_STRUCK_SMALL_PI = 0x213C;
const char32_t DOUBLE_STRUCK_SMALL_GAMMA = 0x213D;
const char32_t DOUBLE_STRUCK_CAPITAL_GAMMA = 0x213E;
const char32_t DOUBLE_STRUCK_CAPITAL_PI = 0x213F;
const char32_t DOUBLE_STRUCK_N_ARY_SUMMATION = 0x2140;
const char32_t TURNED_SANS_SERIF_CAPITAL_G = 0x2141;
const char32_t TURNED_SANS_SERIF_CAPITAL_L = 0x2142;
const char32_t REVERSED_SANS_SERIF_CAPITAL_L = 0x2143;
const char32_t TURNED_SANS_SERIF_CAPITAL_Y = 0x2144;
const char32_t DOUBLE_STRUCK_ITALIC_CAPITAL_D = 0x2145;
const char32_t DOUBLE_STRUCK_ITALIC_SMALL_D = 0x2146;
const char32_t DOUBLE_STRUCK_ITALIC_SMALL_E = 0x2147;
const char32_t DOUBLE_STRUCK_ITALIC_SMALL_I = 0x2148;
const char32_t DOUBLE_STRUCK_ITALIC_SMALL_J = 0x2149;
const char32_t PROPERTY_LINE = 0x214A;
const char32_t TURNED_AMPERSAND = 0x214B;
const char32_t PER_SIGN = 0x214C;
const char32_t AKTIESELSKAB = 0x214D;
const char32_t TURNED_SMALL_F = 0x214E;
const char32_t SYMBOL_FOR_SAMARITAN_SOURCE = 0x214F;
const char32_t VULGAR_FRACTION_ONE_SEVENTH = 0x2150;
const char32_t VULGAR_FRACTION_ONE_NINTH = 0x2151;
const char32_t VULGAR_FRACTION_ONE_TENTH = 0x2152;
const char32_t VULGAR_FRACTION_ONE_THIRD = 0x2153;
const char32_t VULGAR_FRACTION_TWO_THIRDS = 0x2154;
const char32_t VULGAR_FRACTION_ONE_FIFTH = 0x2155;
const char32_t VULGAR_FRACTION_TWO_FIFTHS = 0x2156;
const char32_t VULGAR_FRACTION_THREE_FIFTHS = 0x2157;
const char32_t VULGAR_FRACTION_FOUR_FIFTHS = 0x2158;
const char32_t VULGAR_FRACTION_ONE_SIXTH = 0x2159;
const char32_t VULGAR_FRACTION_FIVE_SIXTHS = 0x215A;
const char32_t VULGAR_FRACTION_ONE_EIGHTH = 0x215B;
const char32_t VULGAR_FRACTION_THREE_EIGHTHS = 0x215C;
const char32_t VULGAR_FRACTION_FIVE_EIGHTHS = 0x215D;
const char32_t VULGAR_FRACTION_SEVEN_EIGHTHS = 0x215E;
const char32_t FRACTION_NUMERATOR_ONE = 0x215F;
const char32_t ROMAN_NUMERAL_ONE = 0x2160;
const char32_t ROMAN_NUMERAL_TWO = 0x2161;
const char32_t ROMAN_NUMERAL_THREE = 0x2162;
const char32_t ROMAN_NUMERAL_FOUR = 0x2163;
const char32_t ROMAN_NUMERAL_FIVE = 0x2164;
const char32_t ROMAN_NUMERAL_SIX = 0x2165;
const char32_t ROMAN_NUMERAL_SEVEN = 0x2166;
const char32_t ROMAN_NUMERAL_EIGHT = 0x2167;
const char32_t ROMAN_NUMERAL_NINE = 0x2168;
const char32_t ROMAN_NUMERAL_TEN = 0x2169;
const char32_t ROMAN_NUMERAL_ELEVEN = 0x216A;
const char32_t ROMAN_NUMERAL_TWELVE = 0x216B;
const char32_t ROMAN_NUMERAL_FIFTY = 0x216C;
const char32_t ROMAN_NUMERAL_ONE_HUNDRED = 0x216D;
const char32_t ROMAN_NUMERAL_FIVE_HUNDRED = 0x216E;
const char32_t ROMAN_NUMERAL_ONE_THOUSAND = 0x216F;
const char32_t SMALL_ROMAN_NUMERAL_ONE = 0x2170;
const char32_t SMALL_ROMAN_NUMERAL_TWO = 0x2171;
const char32_t SMALL_ROMAN_NUMERAL_THREE = 0x2172;
const char32_t SMALL_ROMAN_NUMERAL_FOUR = 0x2173;
const char32_t SMALL_ROMAN_NUMERAL_FIVE = 0x2174;
const char32_t SMALL_ROMAN_NUMERAL_SIX = 0x2175;
const char32_t SMALL_ROMAN_NUMERAL_SEVEN = 0x2176;
const char32_t SMALL_ROMAN_NUMERAL_EIGHT = 0x2177;
const char32_t SMALL_ROMAN_NUMERAL_NINE = 0x2178;
const char32_t SMALL_ROMAN_NUMERAL_TEN = 0x2179;
const char32_t SMALL_ROMAN_NUMERAL_ELEVEN = 0x217A;
const char32_t SMALL_ROMAN_NUMERAL_TWELVE = 0x217B;
const char32_t SMALL_ROMAN_NUMERAL_FIFTY = 0x217C;
const char32_t SMALL_ROMAN_NUMERAL_ONE_HUNDRED = 0x217D;
const char32_t SMALL_ROMAN_NUMERAL_FIVE_HUNDRED = 0x217E;
const char32_t SMALL_ROMAN_NUMERAL_ONE_THOUSAND = 0x217F;
const char32_t ROMAN_NUMERAL_ONE_THOUSAND_C_D = 0x2180;
const char32_t ROMAN_NUMERAL_FIVE_THOUSAND = 0x2181;
const char32_t ROMAN_NUMERAL_TEN_THOUSAND = 0x2182;
const char32_t ROMAN_NUMERAL_REVERSED_ONE_HUNDRED = 0x2183;
const char32_t LATIN_SMALL_LETTER_REVERSED_C = 0x2184;
const char32_t ROMAN_NUMERAL_SIX_LATE_FORM = 0x2185;
const char32_t ROMAN_NUMERAL_FIFTY_EARLY_FORM = 0x2186;
const char32_t ROMAN_NUMERAL_FIFTY_THOUSAND = 0x2187;
const char32_t ROMAN_NUMERAL_ONE_HUNDRED_THOUSAND = 0x2188;
const char32_t VULGAR_FRACTION_ZERO_THIRDS = 0x2189;
const char32_t TURNED_DIGIT_TWO = 0x218A;
const char32_t TURNED_DIGIT_THREE = 0x218B;
const char32_t LEFTWARDS_ARROW = 0x2190;
const char32_t UPWARDS_ARROW = 0x2191;
const char32_t RIGHTWARDS_ARROW = 0x2192;
const char32_t DOWNWARDS_ARROW = 0x2193;
const char32_t LEFT_RIGHT_ARROW = 0x2194;
const char32_t UP_DOWN_ARROW = 0x2195;
const char32_t NORTH_WEST_ARROW = 0x2196;
const char32_t NORTH_EAST_ARROW = 0x2197;
const char32_t SOUTH_EAST_ARROW = 0x2198;
const char32_t SOUTH_WEST_ARROW = 0x2199;
const char32_t LEFTWARDS_ARROW_WITH_STROKE = 0x219A;
const char32_t RIGHTWARDS_ARROW_WITH_STROKE = 0x219B;
const char32_t LEFTWARDS_WAVE_ARROW = 0x219C;
const char32_t RIGHTWARDS_WAVE_ARROW = 0x219D;
const char32_t LEFTWARDS_TWO_HEADED_ARROW = 0x219E;
const char32_t UPWARDS_TWO_HEADED_ARROW = 0x219F;
const char32_t RIGHTWARDS_TWO_HEADED_ARROW = 0x21A0;
const char32_t DOWNWARDS_TWO_HEADED_ARROW = 0x21A1;
const char32_t LEFTWARDS_ARROW_WITH_TAIL = 0x21A2;
const char32_t RIGHTWARDS_ARROW_WITH_TAIL = 0x21A3;
const char32_t LEFTWARDS_ARROW_FROM_BAR = 0x21A4;
const char32_t UPWARDS_ARROW_FROM_BAR = 0x21A5;
const char32_t RIGHTWARDS_ARROW_FROM_BAR = 0x21A6;
const char32_t DOWNWARDS_ARROW_FROM_BAR = 0x21A7;
const char32_t UP_DOWN_ARROW_WITH_BASE = 0x21A8;
const char32_t LEFTWARDS_ARROW_WITH_HOOK = 0x21A9;
const char32_t RIGHTWARDS_ARROW_WITH_HOOK = 0x21AA;
const char32_t LEFTWARDS_ARROW_WITH_LOOP = 0x21AB;
const char32_t RIGHTWARDS_ARROW_WITH_LOOP = 0x21AC;
const char32_t LEFT_RIGHT_WAVE_ARROW = 0x21AD;
const char32_t LEFT_RIGHT_ARROW_WITH_STROKE = 0x21AE;
const char32_t DOWNWARDS_ZIGZAG_ARROW = 0x21AF;
const char32_t UPWARDS_ARROW_WITH_TIP_LEFTWARDS = 0x21B0;
const char32_t UPWARDS_ARROW_WITH_TIP_RIGHTWARDS = 0x21B1;
const char32_t DOWNWARDS_ARROW_WITH_TIP_LEFTWARDS = 0x21B2;
const char32_t DOWNWARDS_ARROW_WITH_TIP_RIGHTWARDS = 0x21B3;
const char32_t RIGHTWARDS_ARROW_WITH_CORNER_DOWNWARDS = 0x21B4;
const char32_t DOWNWARDS_ARROW_WITH_CORNER_LEFTWARDS = 0x21B5;
const char32_t ANTICLOCKWISE_TOP_SEMICIRCLE_ARROW = 0x21B6;
const char32_t CLOCKWISE_TOP_SEMICIRCLE_ARROW = 0x21B7;
const char32_t NORTH_WEST_ARROW_TO_LONG_BAR = 0x21B8;
const char32_t LEFTWARDS_ARROW_TO_BAR_OVER_RIGHTWARDS_ARROW_TO_BAR = 0x21B9;
const char32_t ANTICLOCKWISE_OPEN_CIRCLE_ARROW = 0x21BA;
const char32_t CLOCKWISE_OPEN_CIRCLE_ARROW = 0x21BB;
const char32_t LEFTWARDS_HARPOON_WITH_BARB_UPWARDS = 0x21BC;
const char32_t LEFTWARDS_HARPOON_WITH_BARB_DOWNWARDS = 0x21BD;
const char32_t UPWARDS_HARPOON_WITH_BARB_RIGHTWARDS = 0x21BE;
const char32_t UPWARDS_HARPOON_WITH_BARB_LEFTWARDS = 0x21BF;
const char32_t RIGHTWARDS_HARPOON_WITH_BARB_UPWARDS = 0x21C0;
const char32_t RIGHTWARDS_HARPOON_WITH_BARB_DOWNWARDS = 0x21C1;
const char32_t DOWNWARDS_HARPOON_WITH_BARB_RIGHTWARDS = 0x21C2;
const char32_t DOWNWARDS_HARPOON_WITH_BARB_LEFTWARDS = 0x21C3;
const char32_t RIGHTWARDS_ARROW_OVER_LEFTWARDS_ARROW = 0x21C4;
const char32_t UPWARDS_ARROW_LEFTWARDS_OF_DOWNWARDS_ARROW = 0x21C5;
const char32_t LEFTWARDS_ARROW_OVER_RIGHTWARDS_ARROW = 0x21C6;
const char32_t LEFTWARDS_PAIRED_ARROWS = 0x21C7;
const char32_t UPWARDS_PAIRED_ARROWS = 0x21C8;
const char32_t RIGHTWARDS_PAIRED_ARROWS = 0x21C9;
const char32_t DOWNWARDS_PAIRED_ARROWS = 0x21CA;
const char32_t LEFTWARDS_HARPOON_OVER_RIGHTWARDS_HARPOON = 0x21CB;
const char32_t RIGHTWARDS_HARPOON_OVER_LEFTWARDS_HARPOON = 0x21CC;
const char32_t LEFTWARDS_DOUBLE_ARROW_WITH_STROKE = 0x21CD;
const char32_t LEFT_RIGHT_DOUBLE_ARROW_WITH_STROKE = 0x21CE;
const char32_t RIGHTWARDS_DOUBLE_ARROW_WITH_STROKE = 0x21CF;
const char32_t LEFTWARDS_DOUBLE_ARROW = 0x21D0;
const char32_t UPWARDS_DOUBLE_ARROW = 0x21D1;
const char32_t RIGHTWARDS_DOUBLE_ARROW = 0x21D2;
const char32_t DOWNWARDS_DOUBLE_ARROW = 0x21D3;
const char32_t LEFT_RIGHT_DOUBLE_ARROW = 0x21D4;
const char32_t UP_DOWN_DOUBLE_ARROW = 0x21D5;
const char32_t NORTH_WEST_DOUBLE_ARROW = 0x21D6;
const char32_t NORTH_EAST_DOUBLE_ARROW = 0x21D7;
const char32_t SOUTH_EAST_DOUBLE_ARROW = 0x21D8;
const char32_t SOUTH_WEST_DOUBLE_ARROW = 0x21D9;
const char32_t LEFTWARDS_TRIPLE_ARROW = 0x21DA;
const char32_t RIGHTWARDS_TRIPLE_ARROW = 0x21DB;
const char32_t LEFTWARDS_SQUIGGLE_ARROW = 0x21DC;
const char32_t RIGHTWARDS_SQUIGGLE_ARROW = 0x21DD;
const char32_t UPWARDS_ARROW_WITH_DOUBLE_STROKE = 0x21DE;
const char32_t DOWNWARDS_ARROW_WITH_DOUBLE_STROKE = 0x21DF;
const char32_t LEFTWARDS_DASHED_ARROW = 0x21E0;
const char32_t UPWARDS_DASHED_ARROW = 0x21E1;
const char32_t RIGHTWARDS_DASHED_ARROW = 0x21E2;
const char32_t DOWNWARDS_DASHED_ARROW = 0x21E3;
const char32_t LEFTWARDS_ARROW_TO_BAR = 0x21E4;
const char32_t RIGHTWARDS_ARROW_TO_BAR = 0x21E5;
const char32_t LEFTWARDS_WHITE_ARROW = 0x21E6;
const char32_t UPWARDS_WHITE_ARROW = 0x21E7;
const char32_t RIGHTWARDS_WHITE_ARROW = 0x21E8;
const char32_t DOWNWARDS_WHITE_ARROW = 0x21E9;
const char32_t UPWARDS_WHITE_ARROW_FROM_BAR = 0x21EA;
const char32_t UPWARDS_WHITE_ARROW_ON_PEDESTAL = 0x21EB;
const char32_t UPWARDS_WHITE_ARROW_ON_PEDESTAL_WITH_HORIZONTAL_BAR = 0x21EC;
const char32_t UPWARDS_WHITE_ARROW_ON_PEDESTAL_WITH_VERTICAL_BAR = 0x21ED;
const char32_t UPWARDS_WHITE_DOUBLE_ARROW = 0x21EE;
const char32_t UPWARDS_WHITE_DOUBLE_ARROW_ON_PEDESTAL = 0x21EF;
const char32_t RIGHTWARDS_WHITE_ARROW_FROM_WALL = 0x21F0;
const char32_t NORTH_WEST_ARROW_TO_CORNER = 0x21F1;
const char32_t SOUTH_EAST_ARROW_TO_CORNER = 0x21F2;
const char32_t UP_DOWN_WHITE_ARROW = 0x21F3;
const char32_t RIGHT_ARROW_WITH_SMALL_CIRCLE = 0x21F4;
const char32_t DOWNWARDS_ARROW_LEFTWARDS_OF_UPWARDS_ARROW = 0x21F5;
const char32_t THREE_RIGHTWARDS_ARROWS = 0x21F6;
const char32_t LEFTWARDS_ARROW_WITH_VERTICAL_STROKE = 0x21F7;
const char32_t RIGHTWARDS_ARROW_WITH_VERTICAL_STROKE = 0x21F8;
const char32_t LEFT_RIGHT_ARROW_WITH_VERTICAL_STROKE = 0x21F9;
const char32_t LEFTWARDS_ARROW_WITH_DOUBLE_VERTICAL_STROKE = 0x21FA;
const char32_t RIGHTWARDS_ARROW_WITH_DOUBLE_VERTICAL_STROKE = 0x21FB;
const char32_t LEFT_RIGHT_ARROW_WITH_DOUBLE_VERTICAL_STROKE = 0x21FC;
const char32_t LEFTWARDS_OPEN_HEADED_ARROW = 0x21FD;
const char32_t RIGHTWARDS_OPEN_HEADED_ARROW = 0x21FE;
const char32_t LEFT_RIGHT_OPEN_HEADED_ARROW = 0x21FF;
const char32_t FOR_ALL = 0x2200;
const char32_t COMPLEMENT = 0x2201;
const char32_t PARTIAL_DIFFERENTIAL = 0x2202;
const char32_t THERE_EXISTS = 0x2203;
const char32_t THERE_DOES_NOT_EXIST = 0x2204;
const char32_t EMPTY_SET = 0x2205;
const char32_t INCREMENT = 0x2206;
const char32_t NABLA = 0x2207;
const char32_t ELEMENT_OF = 0x2208;
const char32_t NOT_AN_ELEMENT_OF = 0x2209;
const char32_t SMALL_ELEMENT_OF = 0x220A;
const char32_t CONTAINS_AS_MEMBER = 0x220B;
const char32_t DOES_NOT_CONTAIN_AS_MEMBER = 0x220C;
const char32_t SMALL_CONTAINS_AS_MEMBER = 0x220D;
const char32_t END_OF_PROOF = 0x220E;
const char32_t N_ARY_PRODUCT = 0x220F;
const char32_t N_ARY_COPRODUCT = 0x2210;
const char32_t N_ARY_SUMMATION = 0x2211;
const char32_t MINUS_SIGN = 0x2212;
const char32_t MINUS_OR_PLUS_SIGN = 0x2213;
const char32_t DOT_PLUS = 0x2214;
const char32_t DIVISION_SLASH = 0x2215;
const char32_t SET_MINUS = 0x2216;
const char32_t ASTERISK_OPERATOR = 0x2217;
const char32_t RING_OPERATOR = 0x2218;
const char32_t BULLET_OPERATOR = 0x2219;
const char32_t SQUARE_ROOT = 0x221A;
const char32_t CUBE_ROOT = 0x221B;
const char32_t FOURTH_ROOT = 0x221C;
const char32_t PROPORTIONAL_TO = 0x221D;
const char32_t INFINITY = 0x221E;
const char32_t RIGHT_ANGLE = 0x221F;
const char32_t ANGLE = 0x2220;
const char32_t MEASURED_ANGLE = 0x2221;
const char32_t SPHERICAL_ANGLE = 0x2222;
const char32_t DIVIDES = 0x2223;
const char32_t DOES_NOT_DIVIDE = 0x2224;
const char32_t PARALLEL_TO = 0x2225;
const char32_t NOT_PARALLEL_TO = 0x2226;
const char32_t LOGICAL_AND = 0x2227;
const char32_t LOGICAL_OR = 0x2228;
const char32_t INTERSECTION = 0x2229;
const char32_t UNION = 0x222A;
const char32_t INTEGRAL = 0x222B;
const char32_t DOUBLE_INTEGRAL = 0x222C;
const char32_t TRIPLE_INTEGRAL = 0x222D;
const char32_t CONTOUR_INTEGRAL = 0x222E;
const char32_t SURFACE_INTEGRAL = 0x222F;
const char32_t VOLUME_INTEGRAL = 0x2230;
const char32_t CLOCKWISE_INTEGRAL = 0x2231;
const char32_t CLOCKWISE_CONTOUR_INTEGRAL = 0x2232;
const char32_t ANTICLOCKWISE_CONTOUR_INTEGRAL = 0x2233;
const char32_t THEREFORE = 0x2234;
const char32_t BECAUSE = 0x2235;
const char32_t RATIO = 0x2236;
const char32_t PROPORTION = 0x2237;
const char32_t DOT_MINUS = 0x2238;
const char32_t EXCESS = 0x2239;
const char32_t GEOMETRIC_PROPORTION = 0x223A;
const char32_t HOMOTHETIC = 0x223B;
const char32_t TILDE_OPERATOR = 0x223C;
const char32_t REVERSED_TILDE = 0x223D;
const char32_t INVERTED_LAZY_S = 0x223E;
const char32_t SINE_WAVE = 0x223F;
const char32_t WREATH_PRODUCT = 0x2240;
const char32_t NOT_TILDE = 0x2241;
const char32_t MINUS_TILDE = 0x2242;
const char32_t ASYMPTOTICALLY_EQUAL_TO = 0x2243;
const char32_t NOT_ASYMPTOTICALLY_EQUAL_TO = 0x2244;
const char32_t APPROXIMATELY_EQUAL_TO = 0x2245;
const char32_t APPROXIMATELY_BUT_NOT_ACTUALLY_EQUAL_TO = 0x2246;
const char32_t NEITHER_APPROXIMATELY_NOR_ACTUALLY_EQUAL_TO = 0x2247;
const char32_t ALMOST_EQUAL_TO = 0x2248;
const char32_t NOT_ALMOST_EQUAL_TO = 0x2249;
const char32_t ALMOST_EQUAL_OR_EQUAL_TO = 0x224A;
const char32_t TRIPLE_TILDE = 0x224B;
const char32_t ALL_EQUAL_TO = 0x224C;
const char32_t EQUIVALENT_TO = 0x224D;
const char32_t GEOMETRICALLY_EQUIVALENT_TO = 0x224E;
const char32_t DIFFERENCE_BETWEEN = 0x224F;
const char32_t APPROACHES_THE_LIMIT = 0x2250;
const char32_t GEOMETRICALLY_EQUAL_TO = 0x2251;
const char32_t APPROXIMATELY_EQUAL_TO_OR_THE_IMAGE_OF = 0x2252;
const char32_t IMAGE_OF_OR_APPROXIMATELY_EQUAL_TO = 0x2253;
const char32_t COLON_EQUALS = 0x2254;
const char32_t EQUALS_COLON = 0x2255;
const char32_t RING_IN_EQUAL_TO = 0x2256;
const char32_t RING_EQUAL_TO = 0x2257;
const char32_t CORRESPONDS_TO = 0x2258;
const char32_t ESTIMATES = 0x2259;
const char32_t EQUIANGULAR_TO = 0x225A;
const char32_t STAR_EQUALS = 0x225B;
const char32_t DELTA_EQUAL_TO = 0x225C;
const char32_t EQUAL_TO_BY_DEFINITION = 0x225D;
const char32_t MEASURED_BY = 0x225E;
const char32_t QUESTIONED_EQUAL_TO = 0x225F;
const char32_t NOT_EQUAL_TO = 0x2260;
const char32_t IDENTICAL_TO = 0x2261;
const char32_t NOT_IDENTICAL_TO = 0x2262;
const char32_t STRICTLY_EQUIVALENT_TO = 0x2263;
const char32_t LESS_THAN_OR_EQUAL_TO = 0x2264;
const char32_t GREATER_THAN_OR_EQUAL_TO = 0x2265;
const char32_t LESS_THAN_OVER_EQUAL_TO = 0x2266;
const char32_t GREATER_THAN_OVER_EQUAL_TO = 0x2267;
const char32_t LESS_THAN_BUT_NOT_EQUAL_TO = 0x2268;
const char32_t GREATER_THAN_BUT_NOT_EQUAL_TO = 0x2269;
const char32_t MUCH_LESS_THAN = 0x226A;
const char32_t MUCH_GREATER_THAN = 0x226B;
const char32_t BETWEEN = 0x226C;
const char32_t NOT_EQUIVALENT_TO = 0x226D;
const char32_t NOT_LESS_THAN = 0x226E;
const char32_t NOT_GREATER_THAN = 0x226F;
const char32_t NEITHER_LESS_THAN_NOR_EQUAL_TO = 0x2270;
const char32_t NEITHER_GREATER_THAN_NOR_EQUAL_TO = 0x2271;
const char32_t LESS_THAN_OR_EQUIVALENT_TO = 0x2272;
const char32_t GREATER_THAN_OR_EQUIVALENT_TO = 0x2273;
const char32_t NEITHER_LESS_THAN_NOR_EQUIVALENT_TO = 0x2274;
const char32_t NEITHER_GREATER_THAN_NOR_EQUIVALENT_TO = 0x2275;
const char32_t LESS_THAN_OR_GREATER_THAN = 0x2276;
const char32_t GREATER_THAN_OR_LESS_THAN = 0x2277;
const char32_t NEITHER_LESS_THAN_NOR_GREATER_THAN = 0x2278;
const char32_t NEITHER_GREATER_THAN_NOR_LESS_THAN = 0x2279;
const char32_t PRECEDES = 0x227A;
const char32_t SUCCEEDS = 0x227B;
const char32_t PRECEDES_OR_EQUAL_TO = 0x227C;
const char32_t SUCCEEDS_OR_EQUAL_TO = 0x227D;
const char32_t PRECEDES_OR_EQUIVALENT_TO = 0x227E;
const char32_t SUCCEEDS_OR_EQUIVALENT_TO = 0x227F;
const char32_t DOES_NOT_PRECEDE = 0x2280;
const char32_t DOES_NOT_SUCCEED = 0x2281;
const char32_t SUBSET_OF = 0x2282;
const char32_t SUPERSET_OF = 0x2283;
const char32_t NOT_A_SUBSET_OF = 0x2284;
const char32_t NOT_A_SUPERSET_OF = 0x2285;
const char32_t SUBSET_OF_OR_EQUAL_TO = 0x2286;
const char32_t SUPERSET_OF_OR_EQUAL_TO = 0x2287;
const char32_t NEITHER_A_SUBSET_OF_NOR_EQUAL_TO = 0x2288;
const char32_t NEITHER_A_SUPERSET_OF_NOR_EQUAL_TO = 0x2289;
const char32_t SUBSET_OF_WITH_NOT_EQUAL_TO = 0x228A;
const char32_t SUPERSET_OF_WITH_NOT_EQUAL_TO = 0x228B;
const char32_t MULTISET = 0x228C;
const char32_t MULTISET_MULTIPLICATION = 0x228D;
const char32_t MULTISET_UNION = 0x228E;
const char32_t SQUARE_IMAGE_OF = 0x228F;
const char32_t SQUARE_ORIGINAL_OF = 0x2290;
const char32_t SQUARE_IMAGE_OF_OR_EQUAL_TO = 0x2291;
const char32_t SQUARE_ORIGINAL_OF_OR_EQUAL_TO = 0x2292;
const char32_t SQUARE_CAP = 0x2293;
const char32_t SQUARE_CUP = 0x2294;
const char32_t CIRCLED_PLUS = 0x2295;
const char32_t CIRCLED_MINUS = 0x2296;
const char32_t CIRCLED_TIMES = 0x2297;
const char32_t CIRCLED_DIVISION_SLASH = 0x2298;
const char32_t CIRCLED_DOT_OPERATOR = 0x2299;
const char32_t CIRCLED_RING_OPERATOR = 0x229A;
const char32_t CIRCLED_ASTERISK_OPERATOR = 0x229B;
const char32_t CIRCLED_EQUALS = 0x229C;
const char32_t CIRCLED_DASH = 0x229D;
const char32_t SQUARED_PLUS = 0x229E;
const char32_t SQUARED_MINUS = 0x229F;
const char32_t SQUARED_TIMES = 0x22A0;
const char32_t SQUARED_DOT_OPERATOR = 0x22A1;
const char32_t RIGHT_TACK = 0x22A2;
const char32_t LEFT_TACK = 0x22A3;
const char32_t DOWN_TACK = 0x22A4;
const char32_t UP_TACK = 0x22A5;
const char32_t ASSERTION = 0x22A6;
const char32_t MODELS = 0x22A7;
const char32_t TRUE = 0x22A8;
const char32_t FORCES = 0x22A9;
const char32_t TRIPLE_VERTICAL_BAR_RIGHT_TURNSTILE = 0x22AA;
const char32_t DOUBLE_VERTICAL_BAR_DOUBLE_RIGHT_TURNSTILE = 0x22AB;
const char32_t DOES_NOT_PROVE = 0x22AC;
const char32_t NOT_TRUE = 0x22AD;
const char32_t DOES_NOT_FORCE = 0x22AE;
const char32_t NEGATED_DOUBLE_VERTICAL_BAR_DOUBLE_RIGHT_TURNSTILE = 0x22AF;
const char32_t PRECEDES_UNDER_RELATION = 0x22B0;
const char32_t SUCCEEDS_UNDER_RELATION = 0x22B1;
const char32_t NORMAL_SUBGROUP_OF = 0x22B2;
const char32_t CONTAINS_AS_NORMAL_SUBGROUP = 0x22B3;
const char32_t NORMAL_SUBGROUP_OF_OR_EQUAL_TO = 0x22B4;
const char32_t CONTAINS_AS_NORMAL_SUBGROUP_OR_EQUAL_TO = 0x22B5;
const char32_t ORIGINAL_OF = 0x22B6;
const char32_t IMAGE_OF = 0x22B7;
const char32_t MULTIMAP = 0x22B8;
const char32_t HERMITIAN_CONJUGATE_MATRIX = 0x22B9;
const char32_t INTERCALATE = 0x22BA;
const char32_t XOR = 0x22BB;
const char32_t NAND = 0x22BC;
const char32_t NOR = 0x22BD;
const char32_t RIGHT_ANGLE_WITH_ARC = 0x22BE;
const char32_t RIGHT_TRIANGLE = 0x22BF;
const char32_t N_ARY_LOGICAL_AND = 0x22C0;
const char32_t N_ARY_LOGICAL_OR = 0x22C1;
const char32_t N_ARY_INTERSECTION = 0x22C2;
const char32_t N_ARY_UNION = 0x22C3;
const char32_t DIAMOND_OPERATOR = 0x22C4;
const char32_t DOT_OPERATOR = 0x22C5;
const char32_t STAR_OPERATOR = 0x22C6;
const char32_t DIVISION_TIMES = 0x22C7;
const char32_t BOWTIE = 0x22C8;
const char32_t LEFT_NORMAL_FACTOR_SEMIDIRECT_PRODUCT = 0x22C9;
const char32_t RIGHT_NORMAL_FACTOR_SEMIDIRECT_PRODUCT = 0x22CA;
const char32_t LEFT_SEMIDIRECT_PRODUCT = 0x22CB;
const char32_t RIGHT_SEMIDIRECT_PRODUCT = 0x22CC;
const char32_t REVERSED_TILDE_EQUALS = 0x22CD;
const char32_t CURLY_LOGICAL_OR = 0x22CE;
const char32_t CURLY_LOGICAL_AND = 0x22CF;
const char32_t DOUBLE_SUBSET = 0x22D0;
const char32_t DOUBLE_SUPERSET = 0x22D1;
const char32_t DOUBLE_INTERSECTION = 0x22D2;
const char32_t DOUBLE_UNION = 0x22D3;
const char32_t PITCHFORK = 0x22D4;
const char32_t EQUAL_AND_PARALLEL_TO = 0x22D5;
const char32_t LESS_THAN_WITH_DOT = 0x22D6;
const char32_t GREATER_THAN_WITH_DOT = 0x22D7;
const char32_t VERY_MUCH_LESS_THAN = 0x22D8;
const char32_t VERY_MUCH_GREATER_THAN = 0x22D9;
const char32_t LESS_THAN_EQUAL_TO_OR_GREATER_THAN = 0x22DA;
const char32_t GREATER_THAN_EQUAL_TO_OR_LESS_THAN = 0x22DB;
const char32_t EQUAL_TO_OR_LESS_THAN = 0x22DC;
const char32_t EQUAL_TO_OR_GREATER_THAN = 0x22DD;
const char32_t EQUAL_TO_OR_PRECEDES = 0x22DE;
const char32_t EQUAL_TO_OR_SUCCEEDS = 0x22DF;
const char32_t DOES_NOT_PRECEDE_OR_EQUAL = 0x22E0;
const char32_t DOES_NOT_SUCCEED_OR_EQUAL = 0x22E1;
const char32_t NOT_SQUARE_IMAGE_OF_OR_EQUAL_TO = 0x22E2;
const char32_t NOT_SQUARE_ORIGINAL_OF_OR_EQUAL_TO = 0x22E3;
const char32_t SQUARE_IMAGE_OF_OR_NOT_EQUAL_TO = 0x22E4;
const char32_t SQUARE_ORIGINAL_OF_OR_NOT_EQUAL_TO = 0x22E5;
const char32_t LESS_THAN_BUT_NOT_EQUIVALENT_TO = 0x22E6;
const char32_t GREATER_THAN_BUT_NOT_EQUIVALENT_TO = 0x22E7;
const char32_t PRECEDES_BUT_NOT_EQUIVALENT_TO = 0x22E8;
const char32_t SUCCEEDS_BUT_NOT_EQUIVALENT_TO = 0x22E9;
const char32_t NOT_NORMAL_SUBGROUP_OF = 0x22EA;
const char32_t DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP = 0x22EB;
const char32_t NOT_NORMAL_SUBGROUP_OF_OR_EQUAL_TO = 0x22EC;
const char32_t DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP_OR_EQUAL = 0x22ED;
const char32_t VERTICAL_ELLIPSIS = 0x22EE;
const char32_t MIDLINE_HORIZONTAL_ELLIPSIS = 0x22EF;
const char32_t UP_RIGHT_DIAGONAL_ELLIPSIS = 0x22F0;
const char32_t DOWN_RIGHT_DIAGONAL_ELLIPSIS = 0x22F1;
const char32_t ELEMENT_OF_WITH_LONG_HORIZONTAL_STROKE = 0x22F2;
const char32_t ELEMENT_OF_WITH_VERTICAL_BAR_AT_END_OF_HORIZONTAL_STROKE = 0x22F3;
const char32_t SMALL_ELEMENT_OF_WITH_VERTICAL_BAR_AT_END_OF_HORIZONTAL_STROKE = 0x22F4;
const char32_t ELEMENT_OF_WITH_DOT_ABOVE = 0x22F5;
const char32_t ELEMENT_OF_WITH_OVERBAR = 0x22F6;
const char32_t SMALL_ELEMENT_OF_WITH_OVERBAR = 0x22F7;
const char32_t ELEMENT_OF_WITH_UNDERBAR = 0x22F8;
const char32_t ELEMENT_OF_WITH_TWO_HORIZONTAL_STROKES = 0x22F9;
const char32_t CONTAINS_WITH_LONG_HORIZONTAL_STROKE = 0x22FA;
const char32_t CONTAINS_WITH_VERTICAL_BAR_AT_END_OF_HORIZONTAL_STROKE = 0x22FB;
const char32_t SMALL_CONTAINS_WITH_VERTICAL_BAR_AT_END_OF_HORIZONTAL_STROKE = 0x22FC;
const char32_t CONTAINS_WITH_OVERBAR = 0x22FD;
const char32_t SMALL_CONTAINS_WITH_OVERBAR = 0x22FE;
const char32_t Z_NOTATION_BAG_MEMBERSHIP = 0x22FF;
const char32_t DIAMETER_SIGN = 0x2300;
const char32_t ELECTRIC_ARROW = 0x2301;
const char32_t HOUSE = 0x2302;
const char32_t UP_ARROWHEAD = 0x2303;
const char32_t DOWN_ARROWHEAD = 0x2304;
const char32_t PROJECTIVE = 0x2305;
const char32_t PERSPECTIVE = 0x2306;
const char32_t WAVY_LINE = 0x2307;
const char32_t LEFT_CEILING = 0x2308;
const char32_t RIGHT_CEILING = 0x2309;
const char32_t LEFT_FLOOR = 0x230A;
const char32_t RIGHT_FLOOR = 0x230B;
const char32_t BOTTOM_RIGHT_CROP = 0x230C;
const char32_t BOTTOM_LEFT_CROP = 0x230D;
const char32_t TOP_RIGHT_CROP = 0x230E;
const char32_t TOP_LEFT_CROP = 0x230F;
const char32_t REVERSED_NOT_SIGN = 0x2310;
const char32_t SQUARE_LOZENGE = 0x2311;
const char32_t ARC = 0x2312;
const char32_t SEGMENT = 0x2313;
const char32_t SECTOR = 0x2314;
const char32_t TELEPHONE_RECORDER = 0x2315;
const char32_t POSITION_INDICATOR = 0x2316;
const char32_t VIEWDATA_SQUARE = 0x2317;
const char32_t PLACE_OF_INTEREST_SIGN = 0x2318;
const char32_t TURNED_NOT_SIGN = 0x2319;
const char32_t WATCH = 0x231A;
const char32_t HOURGLASS = 0x231B;
const char32_t TOP_LEFT_CORNER = 0x231C;
const char32_t TOP_RIGHT_CORNER = 0x231D;
const char32_t BOTTOM_LEFT_CORNER = 0x231E;
const char32_t BOTTOM_RIGHT_CORNER = 0x231F;
const char32_t TOP_HALF_INTEGRAL = 0x2320;
const char32_t BOTTOM_HALF_INTEGRAL = 0x2321;
const char32_t FROWN = 0x2322;
const char32_t SMILE = 0x2323;
const char32_t UP_ARROWHEAD_BETWEEN_TWO_HORIZONTAL_BARS = 0x2324;
const char32_t OPTION_KEY = 0x2325;
const char32_t ERASE_TO_THE_RIGHT = 0x2326;
const char32_t X_IN_A_RECTANGLE_BOX = 0x2327;
const char32_t KEYBOARD = 0x2328;
const char32_t LEFT_POINTING_ANGLE_BRACKET = 0x2329;
const char32_t RIGHT_POINTING_ANGLE_BRACKET = 0x232A;
const char32_t ERASE_TO_THE_LEFT = 0x232B;
const char32_t BENZENE_RING = 0x232C;
const char32_t CYLINDRICITY = 0x232D;
const char32_t ALL_AROUND_PROFILE = 0x232E;
const char32_t SYMMETRY = 0x232F;
const char32_t TOTAL_RUNOUT = 0x2330;
const char32_t DIMENSION_ORIGIN = 0x2331;
const char32_t CONICAL_TAPER = 0x2332;
const char32_t SLOPE = 0x2333;
const char32_t COUNTERBORE = 0x2334;
const char32_t COUNTERSINK = 0x2335;
const char32_t APL_FUNCTIONAL_SYMBOL_I_BEAM = 0x2336;
const char32_t APL_FUNCTIONAL_SYMBOL_SQUISH_QUAD = 0x2337;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_EQUAL = 0x2338;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_DIVIDE = 0x2339;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_DIAMOND = 0x233A;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_JOT = 0x233B;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_CIRCLE = 0x233C;
const char32_t APL_FUNCTIONAL_SYMBOL_CIRCLE_STILE = 0x233D;
const char32_t APL_FUNCTIONAL_SYMBOL_CIRCLE_JOT = 0x233E;
const char32_t APL_FUNCTIONAL_SYMBOL_SLASH_BAR = 0x233F;
const char32_t APL_FUNCTIONAL_SYMBOL_BACKSLASH_BAR = 0x2340;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_SLASH = 0x2341;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_BACKSLASH = 0x2342;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_LESS_THAN = 0x2343;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_GREATER_THAN = 0x2344;
const char32_t APL_FUNCTIONAL_SYMBOL_LEFTWARDS_VANE = 0x2345;
const char32_t APL_FUNCTIONAL_SYMBOL_RIGHTWARDS_VANE = 0x2346;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_LEFTWARDS_ARROW = 0x2347;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_RIGHTWARDS_ARROW = 0x2348;
const char32_t APL_FUNCTIONAL_SYMBOL_CIRCLE_BACKSLASH = 0x2349;
const char32_t APL_FUNCTIONAL_SYMBOL_DOWN_TACK_UNDERBAR = 0x234A;
const char32_t APL_FUNCTIONAL_SYMBOL_DELTA_STILE = 0x234B;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_DOWN_CARET = 0x234C;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_DELTA = 0x234D;
const char32_t APL_FUNCTIONAL_SYMBOL_DOWN_TACK_JOT = 0x234E;
const char32_t APL_FUNCTIONAL_SYMBOL_UPWARDS_VANE = 0x234F;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_UPWARDS_ARROW = 0x2350;
const char32_t APL_FUNCTIONAL_SYMBOL_UP_TACK_OVERBAR = 0x2351;
const char32_t APL_FUNCTIONAL_SYMBOL_DEL_STILE = 0x2352;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_UP_CARET = 0x2353;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_DEL = 0x2354;
const char32_t APL_FUNCTIONAL_SYMBOL_UP_TACK_JOT = 0x2355;
const char32_t APL_FUNCTIONAL_SYMBOL_DOWNWARDS_VANE = 0x2356;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_DOWNWARDS_ARROW = 0x2357;
const char32_t APL_FUNCTIONAL_SYMBOL_QUOTE_UNDERBAR = 0x2358;
const char32_t APL_FUNCTIONAL_SYMBOL_DELTA_UNDERBAR = 0x2359;
const char32_t APL_FUNCTIONAL_SYMBOL_DIAMOND_UNDERBAR = 0x235A;
const char32_t APL_FUNCTIONAL_SYMBOL_JOT_UNDERBAR = 0x235B;
const char32_t APL_FUNCTIONAL_SYMBOL_CIRCLE_UNDERBAR = 0x235C;
const char32_t APL_FUNCTIONAL_SYMBOL_UP_SHOE_JOT = 0x235D;
const char32_t APL_FUNCTIONAL_SYMBOL_QUOTE_QUAD = 0x235E;
const char32_t APL_FUNCTIONAL_SYMBOL_CIRCLE_STAR = 0x235F;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_COLON = 0x2360;
const char32_t APL_FUNCTIONAL_SYMBOL_UP_TACK_DIAERESIS = 0x2361;
const char32_t APL_FUNCTIONAL_SYMBOL_DEL_DIAERESIS = 0x2362;
const char32_t APL_FUNCTIONAL_SYMBOL_STAR_DIAERESIS = 0x2363;
const char32_t APL_FUNCTIONAL_SYMBOL_JOT_DIAERESIS = 0x2364;
const char32_t APL_FUNCTIONAL_SYMBOL_CIRCLE_DIAERESIS = 0x2365;
const char32_t APL_FUNCTIONAL_SYMBOL_DOWN_SHOE_STILE = 0x2366;
const char32_t APL_FUNCTIONAL_SYMBOL_LEFT_SHOE_STILE = 0x2367;
const char32_t APL_FUNCTIONAL_SYMBOL_TILDE_DIAERESIS = 0x2368;
const char32_t APL_FUNCTIONAL_SYMBOL_GREATER_THAN_DIAERESIS = 0x2369;
const char32_t APL_FUNCTIONAL_SYMBOL_COMMA_BAR = 0x236A;
const char32_t APL_FUNCTIONAL_SYMBOL_DEL_TILDE = 0x236B;
const char32_t APL_FUNCTIONAL_SYMBOL_ZILDE = 0x236C;
const char32_t APL_FUNCTIONAL_SYMBOL_STILE_TILDE = 0x236D;
const char32_t APL_FUNCTIONAL_SYMBOL_SEMICOLON_UNDERBAR = 0x236E;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_NOT_EQUAL = 0x236F;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD_QUESTION = 0x2370;
const char32_t APL_FUNCTIONAL_SYMBOL_DOWN_CARET_TILDE = 0x2371;
const char32_t APL_FUNCTIONAL_SYMBOL_UP_CARET_TILDE = 0x2372;
const char32_t APL_FUNCTIONAL_SYMBOL_IOTA = 0x2373;
const char32_t APL_FUNCTIONAL_SYMBOL_RHO = 0x2374;
const char32_t APL_FUNCTIONAL_SYMBOL_OMEGA = 0x2375;
const char32_t APL_FUNCTIONAL_SYMBOL_ALPHA_UNDERBAR = 0x2376;
const char32_t APL_FUNCTIONAL_SYMBOL_EPSILON_UNDERBAR = 0x2377;
const char32_t APL_FUNCTIONAL_SYMBOL_IOTA_UNDERBAR = 0x2378;
const char32_t APL_FUNCTIONAL_SYMBOL_OMEGA_UNDERBAR = 0x2379;
const char32_t APL_FUNCTIONAL_SYMBOL_ALPHA = 0x237A;
const char32_t NOT_CHECK_MARK = 0x237B;
const char32_t RIGHT_ANGLE_WITH_DOWNWARDS_ZIGZAG_ARROW = 0x237C;
const char32_t SHOULDERED_OPEN_BOX = 0x237D;
const char32_t BELL_SYMBOL = 0x237E;
const char32_t VERTICAL_LINE_WITH_MIDDLE_DOT = 0x237F;
const char32_t INSERTION_SYMBOL = 0x2380;
const char32_t CONTINUOUS_UNDERLINE_SYMBOL = 0x2381;
const char32_t DISCONTINUOUS_UNDERLINE_SYMBOL = 0x2382;
const char32_t EMPHASIS_SYMBOL = 0x2383;
const char32_t COMPOSITION_SYMBOL = 0x2384;
const char32_t WHITE_SQUARE_WITH_CENTRE_VERTICAL_LINE = 0x2385;
const char32_t ENTER_SYMBOL = 0x2386;
const char32_t ALTERNATIVE_KEY_SYMBOL = 0x2387;
const char32_t HELM_SYMBOL = 0x2388;
const char32_t CIRCLED_HORIZONTAL_BAR_WITH_NOTCH = 0x2389;
const char32_t CIRCLED_TRIANGLE_DOWN = 0x238A;
const char32_t BROKEN_CIRCLE_WITH_NORTHWEST_ARROW = 0x238B;
const char32_t UNDO_SYMBOL = 0x238C;
const char32_t MONOSTABLE_SYMBOL = 0x238D;
const char32_t HYSTERESIS_SYMBOL = 0x238E;
const char32_t OPEN_CIRCUIT_OUTPUT_H_TYPE_SYMBOL = 0x238F;
const char32_t OPEN_CIRCUIT_OUTPUT_L_TYPE_SYMBOL = 0x2390;
const char32_t PASSIVE_PULL_DOWN_OUTPUT_SYMBOL = 0x2391;
const char32_t PASSIVE_PULL_UP_OUTPUT_SYMBOL = 0x2392;
const char32_t DIRECT_CURRENT_SYMBOL_FORM_TWO = 0x2393;
const char32_t SOFTWARE_FUNCTION_SYMBOL = 0x2394;
const char32_t APL_FUNCTIONAL_SYMBOL_QUAD = 0x2395;
const char32_t DECIMAL_SEPARATOR_KEY_SYMBOL = 0x2396;
const char32_t PREVIOUS_PAGE = 0x2397;
const char32_t NEXT_PAGE = 0x2398;
const char32_t PRINT_SCREEN_SYMBOL = 0x2399;
const char32_t CLEAR_SCREEN_SYMBOL = 0x239A;
const char32_t LEFT_PARENTHESIS_UPPER_HOOK = 0x239B;
const char32_t LEFT_PARENTHESIS_EXTENSION = 0x239C;
const char32_t LEFT_PARENTHESIS_LOWER_HOOK = 0x239D;
const char32_t RIGHT_PARENTHESIS_UPPER_HOOK = 0x239E;
const char32_t RIGHT_PARENTHESIS_EXTENSION = 0x239F;
const char32_t RIGHT_PARENTHESIS_LOWER_HOOK = 0x23A0;
const char32_t LEFT_SQUARE_BRACKET_UPPER_CORNER = 0x23A1;
const char32_t LEFT_SQUARE_BRACKET_EXTENSION = 0x23A2;
const char32_t LEFT_SQUARE_BRACKET_LOWER_CORNER = 0x23A3;
const char32_t RIGHT_SQUARE_BRACKET_UPPER_CORNER = 0x23A4;
const char32_t RIGHT_SQUARE_BRACKET_EXTENSION = 0x23A5;
const char32_t RIGHT_SQUARE_BRACKET_LOWER_CORNER = 0x23A6;
const char32_t LEFT_CURLY_BRACKET_UPPER_HOOK = 0x23A7;
const char32_t LEFT_CURLY_BRACKET_MIDDLE_PIECE = 0x23A8;
const char32_t LEFT_CURLY_BRACKET_LOWER_HOOK = 0x23A9;
const char32_t CURLY_BRACKET_EXTENSION = 0x23AA;
const char32_t RIGHT_CURLY_BRACKET_UPPER_HOOK = 0x23AB;
const char32_t RIGHT_CURLY_BRACKET_MIDDLE_PIECE = 0x23AC;
const char32_t RIGHT_CURLY_BRACKET_LOWER_HOOK = 0x23AD;
const char32_t INTEGRAL_EXTENSION = 0x23AE;
const char32_t HORIZONTAL_LINE_EXTENSION = 0x23AF;
const char32_t UPPER_LEFT_OR_LOWER_RIGHT_CURLY_BRACKET_SECTION = 0x23B0;
const char32_t UPPER_RIGHT_OR_LOWER_LEFT_CURLY_BRACKET_SECTION = 0x23B1;
const char32_t SUMMATION_TOP = 0x23B2;
const char32_t SUMMATION_BOTTOM = 0x23B3;
const char32_t TOP_SQUARE_BRACKET = 0x23B4;
const char32_t BOTTOM_SQUARE_BRACKET = 0x23B5;
const char32_t BOTTOM_SQUARE_BRACKET_OVER_TOP_SQUARE_BRACKET = 0x23B6;
const char32_t RADICAL_SYMBOL_BOTTOM = 0x23B7;
const char32_t LEFT_VERTICAL_BOX_LINE = 0x23B8;
const char32_t RIGHT_VERTICAL_BOX_LINE = 0x23B9;
const char32_t HORIZONTAL_SCAN_LINE_1 = 0x23BA;
const char32_t HORIZONTAL_SCAN_LINE_3 = 0x23BB;
const char32_t HORIZONTAL_SCAN_LINE_7 = 0x23BC;
const char32_t HORIZONTAL_SCAN_LINE_9 = 0x23BD;
const char32_t DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_TOP_RIGHT = 0x23BE;
const char32_t DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_BOTTOM_RIGHT = 0x23BF;
const char32_t DENTISTRY_SYMBOL_LIGHT_VERTICAL_WITH_CIRCLE = 0x23C0;
const char32_t DENTISTRY_SYMBOL_LIGHT_DOWN_AND_HORIZONTAL_WITH_CIRCLE = 0x23C1;
const char32_t DENTISTRY_SYMBOL_LIGHT_UP_AND_HORIZONTAL_WITH_CIRCLE = 0x23C2;
const char32_t DENTISTRY_SYMBOL_LIGHT_VERTICAL_WITH_TRIANGLE = 0x23C3;
const char32_t DENTISTRY_SYMBOL_LIGHT_DOWN_AND_HORIZONTAL_WITH_TRIANGLE = 0x23C4;
const char32_t DENTISTRY_SYMBOL_LIGHT_UP_AND_HORIZONTAL_WITH_TRIANGLE = 0x23C5;
const char32_t DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_WAVE = 0x23C6;
const char32_t DENTISTRY_SYMBOL_LIGHT_DOWN_AND_HORIZONTAL_WITH_WAVE = 0x23C7;
const char32_t DENTISTRY_SYMBOL_LIGHT_UP_AND_HORIZONTAL_WITH_WAVE = 0x23C8;
const char32_t DENTISTRY_SYMBOL_LIGHT_DOWN_AND_HORIZONTAL = 0x23C9;
const char32_t DENTISTRY_SYMBOL_LIGHT_UP_AND_HORIZONTAL = 0x23CA;
const char32_t DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_TOP_LEFT = 0x23CB;
const char32_t DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_BOTTOM_LEFT = 0x23CC;
const char32_t SQUARE_FOOT = 0x23CD;
const char32_t RETURN_SYMBOL = 0x23CE;
const char32_t EJECT_SYMBOL = 0x23CF;
const char32_t VERTICAL_LINE_EXTENSION = 0x23D0;
const char32_t METRICAL_BREVE = 0x23D1;
const char32_t METRICAL_LONG_OVER_SHORT = 0x23D2;
const char32_t METRICAL_SHORT_OVER_LONG = 0x23D3;
const char32_t METRICAL_LONG_OVER_TWO_SHORTS = 0x23D4;
const char32_t METRICAL_TWO_SHORTS_OVER_LONG = 0x23D5;
const char32_t METRICAL_TWO_SHORTS_JOINED = 0x23D6;
const char32_t METRICAL_TRISEME = 0x23D7;
const char32_t METRICAL_TETRASEME = 0x23D8;
const char32_t METRICAL_PENTASEME = 0x23D9;
const char32_t EARTH_GROUND = 0x23DA;
const char32_t FUSE = 0x23DB;
const char32_t TOP_PARENTHESIS = 0x23DC;
const char32_t BOTTOM_PARENTHESIS = 0x23DD;
const char32_t TOP_CURLY_BRACKET = 0x23DE;
const char32_t BOTTOM_CURLY_BRACKET = 0x23DF;
const char32_t TOP_TORTOISE_SHELL_BRACKET = 0x23E0;
const char32_t BOTTOM_TORTOISE_SHELL_BRACKET = 0x23E1;
const char32_t WHITE_TRAPEZIUM = 0x23E2;
const char32_t BENZENE_RING_WITH_CIRCLE = 0x23E3;
const char32_t STRAIGHTNESS = 0x23E4;
const char32_t FLATNESS = 0x23E5;
const char32_t AC_CURRENT = 0x23E6;
const char32_t ELECTRICAL_INTERSECTION = 0x23E7;
const char32_t DECIMAL_EXPONENT_SYMBOL = 0x23E8;
const char32_t BLACK_RIGHT_POINTING_DOUBLE_TRIANGLE = 0x23E9;
const char32_t BLACK_LEFT_POINTING_DOUBLE_TRIANGLE = 0x23EA;
const char32_t BLACK_UP_POINTING_DOUBLE_TRIANGLE = 0x23EB;
const char32_t BLACK_DOWN_POINTING_DOUBLE_TRIANGLE = 0x23EC;
const char32_t BLACK_RIGHT_POINTING_DOUBLE_TRIANGLE_WITH_VERTICAL_BAR = 0x23ED;
const char32_t BLACK_LEFT_POINTING_DOUBLE_TRIANGLE_WITH_VERTICAL_BAR = 0x23EE;
const char32_t BLACK_RIGHT_POINTING_TRIANGLE_WITH_DOUBLE_VERTICAL_BAR = 0x23EF;
const char32_t ALARM_CLOCK = 0x23F0;
const char32_t STOPWATCH = 0x23F1;
const char32_t TIMER_CLOCK = 0x23F2;
const char32_t HOURGLASS_WITH_FLOWING_SAND = 0x23F3;
const char32_t BLACK_MEDIUM_LEFT_POINTING_TRIANGLE = 0x23F4;
const char32_t BLACK_MEDIUM_RIGHT_POINTING_TRIANGLE = 0x23F5;
const char32_t BLACK_MEDIUM_UP_POINTING_TRIANGLE = 0x23F6;
const char32_t BLACK_MEDIUM_DOWN_POINTING_TRIANGLE = 0x23F7;
const char32_t DOUBLE_VERTICAL_BAR = 0x23F8;
const char32_t BLACK_SQUARE_FOR_STOP = 0x23F9;
const char32_t BLACK_CIRCLE_FOR_RECORD = 0x23FA;
const char32_t POWER_SYMBOL = 0x23FB;
const char32_t POWER_ON_OFF_SYMBOL = 0x23FC;
const char32_t POWER_ON_SYMBOL = 0x23FD;
const char32_t POWER_SLEEP_SYMBOL = 0x23FE;
const char32_t OBSERVER_EYE_SYMBOL = 0x23FF;
const char32_t SYMBOL_FOR_NULL = 0x2400;
const char32_t SYMBOL_FOR_START_OF_HEADING = 0x2401;
const char32_t SYMBOL_FOR_START_OF_TEXT = 0x2402;
const char32_t SYMBOL_FOR_END_OF_TEXT = 0x2403;
const char32_t SYMBOL_FOR_END_OF_TRANSMISSION = 0x2404;
const char32_t SYMBOL_FOR_ENQUIRY = 0x2405;
const char32_t SYMBOL_FOR_ACKNOWLEDGE = 0x2406;
const char32_t SYMBOL_FOR_BELL = 0x2407;
const char32_t SYMBOL_FOR_BACKSPACE = 0x2408;
const char32_t SYMBOL_FOR_HORIZONTAL_TABULATION = 0x2409;
const char32_t SYMBOL_FOR_LINE_FEED = 0x240A;
const char32_t SYMBOL_FOR_VERTICAL_TABULATION = 0x240B;
const char32_t SYMBOL_FOR_FORM_FEED = 0x240C;
const char32_t SYMBOL_FOR_CARRIAGE_RETURN = 0x240D;
const char32_t SYMBOL_FOR_SHIFT_OUT = 0x240E;
const char32_t SYMBOL_FOR_SHIFT_IN = 0x240F;
const char32_t SYMBOL_FOR_DATA_LINK_ESCAPE = 0x2410;
const char32_t SYMBOL_FOR_DEVICE_CONTROL_ONE = 0x2411;
const char32_t SYMBOL_FOR_DEVICE_CONTROL_TWO = 0x2412;
const char32_t SYMBOL_FOR_DEVICE_CONTROL_THREE = 0x2413;
const char32_t SYMBOL_FOR_DEVICE_CONTROL_FOUR = 0x2414;
const char32_t SYMBOL_FOR_NEGATIVE_ACKNOWLEDGE = 0x2415;
const char32_t SYMBOL_FOR_SYNCHRONOUS_IDLE = 0x2416;
const char32_t SYMBOL_FOR_END_OF_TRANSMISSION_BLOCK = 0x2417;
const char32_t SYMBOL_FOR_CANCEL = 0x2418;
const char32_t SYMBOL_FOR_END_OF_MEDIUM = 0x2419;
const char32_t SYMBOL_FOR_SUBSTITUTE = 0x241A;
const char32_t SYMBOL_FOR_ESCAPE = 0x241B;
const char32_t SYMBOL_FOR_FILE_SEPARATOR = 0x241C;
const char32_t SYMBOL_FOR_GROUP_SEPARATOR = 0x241D;
const char32_t SYMBOL_FOR_RECORD_SEPARATOR = 0x241E;
const char32_t SYMBOL_FOR_UNIT_SEPARATOR = 0x241F;
const char32_t SYMBOL_FOR_SPACE = 0x2420;
const char32_t SYMBOL_FOR_DELETE = 0x2421;
const char32_t BLANK_SYMBOL = 0x2422;
const char32_t OPEN_BOX = 0x2423;
const char32_t SYMBOL_FOR_NEWLINE = 0x2424;
const char32_t SYMBOL_FOR_DELETE_FORM_TWO = 0x2425;
const char32_t SYMBOL_FOR_SUBSTITUTE_FORM_TWO = 0x2426;
const char32_t OCR_HOOK = 0x2440;
const char32_t OCR_CHAIR = 0x2441;
const char32_t OCR_FORK = 0x2442;
const char32_t OCR_INVERTED_FORK = 0x2443;
const char32_t OCR_BELT_BUCKLE = 0x2444;
const char32_t OCR_BOW_TIE = 0x2445;
const char32_t OCR_BRANCH_BANK_IDENTIFICATION = 0x2446;
const char32_t OCR_AMOUNT_OF_CHECK = 0x2447;
const char32_t OCR_DASH = 0x2448;
const char32_t OCR_CUSTOMER_ACCOUNT_NUMBER = 0x2449;
const char32_t OCR_DOUBLE_BACKSLASH = 0x244A;
const char32_t CIRCLED_DIGIT_ONE = 0x2460;
const char32_t CIRCLED_DIGIT_TWO = 0x2461;
const char32_t CIRCLED_DIGIT_THREE = 0x2462;
const char32_t CIRCLED_DIGIT_FOUR = 0x2463;
const char32_t CIRCLED_DIGIT_FIVE = 0x2464;
const char32_t CIRCLED_DIGIT_SIX = 0x2465;
const char32_t CIRCLED_DIGIT_SEVEN = 0x2466;
const char32_t CIRCLED_DIGIT_EIGHT = 0x2467;
const char32_t CIRCLED_DIGIT_NINE = 0x2468;
const char32_t CIRCLED_NUMBER_TEN = 0x2469;
const char32_t CIRCLED_NUMBER_ELEVEN = 0x246A;
const char32_t CIRCLED_NUMBER_TWELVE = 0x246B;
const char32_t CIRCLED_NUMBER_THIRTEEN = 0x246C;
const char32_t CIRCLED_NUMBER_FOURTEEN = 0x246D;
const char32_t CIRCLED_NUMBER_FIFTEEN = 0x246E;
const char32_t CIRCLED_NUMBER_SIXTEEN = 0x246F;
const char32_t CIRCLED_NUMBER_SEVENTEEN = 0x2470;
const char32_t CIRCLED_NUMBER_EIGHTEEN = 0x2471;
const char32_t CIRCLED_NUMBER_NINETEEN = 0x2472;
const char32_t CIRCLED_NUMBER_TWENTY = 0x2473;
const char32_t PARENTHESIZED_DIGIT_ONE = 0x2474;
const char32_t PARENTHESIZED_DIGIT_TWO = 0x2475;
const char32_t PARENTHESIZED_DIGIT_THREE = 0x2476;
const char32_t PARENTHESIZED_DIGIT_FOUR = 0x2477;
const char32_t PARENTHESIZED_DIGIT_FIVE = 0x2478;
const char32_t PARENTHESIZED_DIGIT_SIX = 0x2479;
const char32_t PARENTHESIZED_DIGIT_SEVEN = 0x247A;
const char32_t PARENTHESIZED_DIGIT_EIGHT = 0x247B;
const char32_t PARENTHESIZED_DIGIT_NINE = 0x247C;
const char32_t PARENTHESIZED_NUMBER_TEN = 0x247D;
const char32_t PARENTHESIZED_NUMBER_ELEVEN = 0x247E;
const char32_t PARENTHESIZED_NUMBER_TWELVE = 0x247F;
const char32_t PARENTHESIZED_NUMBER_THIRTEEN = 0x2480;
const char32_t PARENTHESIZED_NUMBER_FOURTEEN = 0x2481;
const char32_t PARENTHESIZED_NUMBER_FIFTEEN = 0x2482;
const char32_t PARENTHESIZED_NUMBER_SIXTEEN = 0x2483;
const char32_t PARENTHESIZED_NUMBER_SEVENTEEN = 0x2484;
const char32_t PARENTHESIZED_NUMBER_EIGHTEEN = 0x2485;
const char32_t PARENTHESIZED_NUMBER_NINETEEN = 0x2486;
const char32_t PARENTHESIZED_NUMBER_TWENTY = 0x2487;
const char32_t DIGIT_ONE_FULL_STOP = 0x2488;
const char32_t DIGIT_TWO_FULL_STOP = 0x2489;
const char32_t DIGIT_THREE_FULL_STOP = 0x248A;
const char32_t DIGIT_FOUR_FULL_STOP = 0x248B;
const char32_t DIGIT_FIVE_FULL_STOP = 0x248C;
const char32_t DIGIT_SIX_FULL_STOP = 0x248D;
const char32_t DIGIT_SEVEN_FULL_STOP = 0x248E;
const char32_t DIGIT_EIGHT_FULL_STOP = 0x248F;
const char32_t DIGIT_NINE_FULL_STOP = 0x2490;
const char32_t NUMBER_TEN_FULL_STOP = 0x2491;
const char32_t NUMBER_ELEVEN_FULL_STOP = 0x2492;
const char32_t NUMBER_TWELVE_FULL_STOP = 0x2493;
const char32_t NUMBER_THIRTEEN_FULL_STOP = 0x2494;
const char32_t NUMBER_FOURTEEN_FULL_STOP = 0x2495;
const char32_t NUMBER_FIFTEEN_FULL_STOP = 0x2496;
const char32_t NUMBER_SIXTEEN_FULL_STOP = 0x2497;
const char32_t NUMBER_SEVENTEEN_FULL_STOP = 0x2498;
const char32_t NUMBER_EIGHTEEN_FULL_STOP = 0x2499;
const char32_t NUMBER_NINETEEN_FULL_STOP = 0x249A;
const char32_t NUMBER_TWENTY_FULL_STOP = 0x249B;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_A = 0x249C;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_B = 0x249D;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_C = 0x249E;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_D = 0x249F;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_E = 0x24A0;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_F = 0x24A1;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_G = 0x24A2;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_H = 0x24A3;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_I = 0x24A4;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_J = 0x24A5;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_K = 0x24A6;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_L = 0x24A7;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_M = 0x24A8;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_N = 0x24A9;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_O = 0x24AA;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_P = 0x24AB;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_Q = 0x24AC;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_R = 0x24AD;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_S = 0x24AE;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_T = 0x24AF;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_U = 0x24B0;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_V = 0x24B1;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_W = 0x24B2;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_X = 0x24B3;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_Y = 0x24B4;
const char32_t PARENTHESIZED_LATIN_SMALL_LETTER_Z = 0x24B5;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_A = 0x24B6;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_B = 0x24B7;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_C = 0x24B8;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_D = 0x24B9;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_E = 0x24BA;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_F = 0x24BB;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_G = 0x24BC;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_H = 0x24BD;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_I = 0x24BE;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_J = 0x24BF;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_K = 0x24C0;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_L = 0x24C1;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_M = 0x24C2;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_N = 0x24C3;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_O = 0x24C4;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_P = 0x24C5;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_Q = 0x24C6;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_R = 0x24C7;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_S = 0x24C8;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_T = 0x24C9;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_U = 0x24CA;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_V = 0x24CB;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_W = 0x24CC;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_X = 0x24CD;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_Y = 0x24CE;
const char32_t CIRCLED_LATIN_CAPITAL_LETTER_Z = 0x24CF;
const char32_t CIRCLED_LATIN_SMALL_LETTER_A = 0x24D0;
const char32_t CIRCLED_LATIN_SMALL_LETTER_B = 0x24D1;
const char32_t CIRCLED_LATIN_SMALL_LETTER_C = 0x24D2;
const char32_t CIRCLED_LATIN_SMALL_LETTER_D = 0x24D3;
const char32_t CIRCLED_LATIN_SMALL_LETTER_E = 0x24D4;
const char32_t CIRCLED_LATIN_SMALL_LETTER_F = 0x24D5;
const char32_t CIRCLED_LATIN_SMALL_LETTER_G = 0x24D6;
const char32_t CIRCLED_LATIN_SMALL_LETTER_H = 0x24D7;
const char32_t CIRCLED_LATIN_SMALL_LETTER_I = 0x24D8;
const char32_t CIRCLED_LATIN_SMALL_LETTER_J = 0x24D9;
const char32_t CIRCLED_LATIN_SMALL_LETTER_K = 0x24DA;
const char32_t CIRCLED_LATIN_SMALL_LETTER_L = 0x24DB;
const char32_t CIRCLED_LATIN_SMALL_LETTER_M = 0x24DC;
const char32_t CIRCLED_LATIN_SMALL_LETTER_N = 0x24DD;
const char32_t CIRCLED_LATIN_SMALL_LETTER_O = 0x24DE;
const char32_t CIRCLED_LATIN_SMALL_LETTER_P = 0x24DF;
const char32_t CIRCLED_LATIN_SMALL_LETTER_Q = 0x24E0;
const char32_t CIRCLED_LATIN_SMALL_LETTER_R = 0x24E1;
const char32_t CIRCLED_LATIN_SMALL_LETTER_S = 0x24E2;
const char32_t CIRCLED_LATIN_SMALL_LETTER_T = 0x24E3;
const char32_t CIRCLED_LATIN_SMALL_LETTER_U = 0x24E4;
const char32_t CIRCLED_LATIN_SMALL_LETTER_V = 0x24E5;
const char32_t CIRCLED_LATIN_SMALL_LETTER_W = 0x24E6;
const char32_t CIRCLED_LATIN_SMALL_LETTER_X = 0x24E7;
const char32_t CIRCLED_LATIN_SMALL_LETTER_Y = 0x24E8;
const char32_t CIRCLED_LATIN_SMALL_LETTER_Z = 0x24E9;
const char32_t CIRCLED_DIGIT_ZERO = 0x24EA;
const char32_t NEGATIVE_CIRCLED_NUMBER_ELEVEN = 0x24EB;
const char32_t NEGATIVE_CIRCLED_NUMBER_TWELVE = 0x24EC;
const char32_t NEGATIVE_CIRCLED_NUMBER_THIRTEEN = 0x24ED;
const char32_t NEGATIVE_CIRCLED_NUMBER_FOURTEEN = 0x24EE;
const char32_t NEGATIVE_CIRCLED_NUMBER_FIFTEEN = 0x24EF;
const char32_t NEGATIVE_CIRCLED_NUMBER_SIXTEEN = 0x24F0;
const char32_t NEGATIVE_CIRCLED_NUMBER_SEVENTEEN = 0x24F1;
const char32_t NEGATIVE_CIRCLED_NUMBER_EIGHTEEN = 0x24F2;
const char32_t NEGATIVE_CIRCLED_NUMBER_NINETEEN = 0x24F3;
const char32_t NEGATIVE_CIRCLED_NUMBER_TWENTY = 0x24F4;
const char32_t DOUBLE_CIRCLED_DIGIT_ONE = 0x24F5;
const char32_t DOUBLE_CIRCLED_DIGIT_TWO = 0x24F6;
const char32_t DOUBLE_CIRCLED_DIGIT_THREE = 0x24F7;
const char32_t DOUBLE_CIRCLED_DIGIT_FOUR = 0x24F8;
const char32_t DOUBLE_CIRCLED_DIGIT_FIVE = 0x24F9;
const char32_t DOUBLE_CIRCLED_DIGIT_SIX = 0x24FA;
const char32_t DOUBLE_CIRCLED_DIGIT_SEVEN = 0x24FB;
const char32_t DOUBLE_CIRCLED_DIGIT_EIGHT = 0x24FC;
const char32_t DOUBLE_CIRCLED_DIGIT_NINE = 0x24FD;
const char32_t DOUBLE_CIRCLED_NUMBER_TEN = 0x24FE;
const char32_t NEGATIVE_CIRCLED_DIGIT_ZERO = 0x24FF;
const char32_t BOX_DRAWINGS_LIGHT_HORIZONTAL = 0x2500;
const char32_t BOX_DRAWINGS_HEAVY_HORIZONTAL = 0x2501;
const char32_t BOX_DRAWINGS_LIGHT_VERTICAL = 0x2502;
const char32_t BOX_DRAWINGS_HEAVY_VERTICAL = 0x2503;
const char32_t BOX_DRAWINGS_LIGHT_TRIPLE_DASH_HORIZONTAL = 0x2504;
const char32_t BOX_DRAWINGS_HEAVY_TRIPLE_DASH_HORIZONTAL = 0x2505;
const char32_t BOX_DRAWINGS_LIGHT_TRIPLE_DASH_VERTICAL = 0x2506;
const char32_t BOX_DRAWINGS_HEAVY_TRIPLE_DASH_VERTICAL = 0x2507;
const char32_t BOX_DRAWINGS_LIGHT_QUADRUPLE_DASH_HORIZONTAL = 0x2508;
const char32_t BOX_DRAWINGS_HEAVY_QUADRUPLE_DASH_HORIZONTAL = 0x2509;
const char32_t BOX_DRAWINGS_LIGHT_QUADRUPLE_DASH_VERTICAL = 0x250A;
const char32_t BOX_DRAWINGS_HEAVY_QUADRUPLE_DASH_VERTICAL = 0x250B;
const char32_t BOX_DRAWINGS_LIGHT_DOWN_AND_RIGHT = 0x250C;
const char32_t BOX_DRAWINGS_DOWN_LIGHT_AND_RIGHT_HEAVY = 0x250D;
const char32_t BOX_DRAWINGS_DOWN_HEAVY_AND_RIGHT_LIGHT = 0x250E;
const char32_t BOX_DRAWINGS_HEAVY_DOWN_AND_RIGHT = 0x250F;
const char32_t BOX_DRAWINGS_LIGHT_DOWN_AND_LEFT = 0x2510;
const char32_t BOX_DRAWINGS_DOWN_LIGHT_AND_LEFT_HEAVY = 0x2511;
const char32_t BOX_DRAWINGS_DOWN_HEAVY_AND_LEFT_LIGHT = 0x2512;
const char32_t BOX_DRAWINGS_HEAVY_DOWN_AND_LEFT = 0x2513;
const char32_t BOX_DRAWINGS_LIGHT_UP_AND_RIGHT = 0x2514;
const char32_t BOX_DRAWINGS_UP_LIGHT_AND_RIGHT_HEAVY = 0x2515;
const char32_t BOX_DRAWINGS_UP_HEAVY_AND_RIGHT_LIGHT = 0x2516;
const char32_t BOX_DRAWINGS_HEAVY_UP_AND_RIGHT = 0x2517;
const char32_t BOX_DRAWINGS_LIGHT_UP_AND_LEFT = 0x2518;
const char32_t BOX_DRAWINGS_UP_LIGHT_AND_LEFT_HEAVY = 0x2519;
const char32_t BOX_DRAWINGS_UP_HEAVY_AND_LEFT_LIGHT = 0x251A;
const char32_t BOX_DRAWINGS_HEAVY_UP_AND_LEFT = 0x251B;
const char32_t BOX_DRAWINGS_LIGHT_VERTICAL_AND_RIGHT = 0x251C;
const char32_t BOX_DRAWINGS_VERTICAL_LIGHT_AND_RIGHT_HEAVY = 0x251D;
const char32_t BOX_DRAWINGS_UP_HEAVY_AND_RIGHT_DOWN_LIGHT = 0x251E;
const char32_t BOX_DRAWINGS_DOWN_HEAVY_AND_RIGHT_UP_LIGHT = 0x251F;
const char32_t BOX_DRAWINGS_VERTICAL_HEAVY_AND_RIGHT_LIGHT = 0x2520;
const char32_t BOX_DRAWINGS_DOWN_LIGHT_AND_RIGHT_UP_HEAVY = 0x2521;
const char32_t BOX_DRAWINGS_UP_LIGHT_AND_RIGHT_DOWN_HEAVY = 0x2522;
const char32_t BOX_DRAWINGS_HEAVY_VERTICAL_AND_RIGHT = 0x2523;
const char32_t BOX_DRAWINGS_LIGHT_VERTICAL_AND_LEFT = 0x2524;
const char32_t BOX_DRAWINGS_VERTICAL_LIGHT_AND_LEFT_HEAVY = 0x2525;
const char32_t BOX_DRAWINGS_UP_HEAVY_AND_LEFT_DOWN_LIGHT = 0x2526;
const char32_t BOX_DRAWINGS_DOWN_HEAVY_AND_LEFT_UP_LIGHT = 0x2527;
const char32_t BOX_DRAWINGS_VERTICAL_HEAVY_AND_LEFT_LIGHT = 0x2528;
const char32_t BOX_DRAWINGS_DOWN_LIGHT_AND_LEFT_UP_HEAVY = 0x2529;
const char32_t BOX_DRAWINGS_UP_LIGHT_AND_LEFT_DOWN_HEAVY = 0x252A;
const char32_t BOX_DRAWINGS_HEAVY_VERTICAL_AND_LEFT = 0x252B;
const char32_t BOX_DRAWINGS_LIGHT_DOWN_AND_HORIZONTAL = 0x252C;
const char32_t BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_DOWN_LIGHT = 0x252D;
const char32_t BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_DOWN_LIGHT = 0x252E;
const char32_t BOX_DRAWINGS_DOWN_LIGHT_AND_HORIZONTAL_HEAVY = 0x252F;
const char32_t BOX_DRAWINGS_DOWN_HEAVY_AND_HORIZONTAL_LIGHT = 0x2530;
const char32_t BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_DOWN_HEAVY = 0x2531;
const char32_t BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_DOWN_HEAVY = 0x2532;
const char32_t BOX_DRAWINGS_HEAVY_DOWN_AND_HORIZONTAL = 0x2533;
const char32_t BOX_DRAWINGS_LIGHT_UP_AND_HORIZONTAL = 0x2534;
const char32_t BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_UP_LIGHT = 0x2535;
const char32_t BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_UP_LIGHT = 0x2536;
const char32_t BOX_DRAWINGS_UP_LIGHT_AND_HORIZONTAL_HEAVY = 0x2537;
const char32_t BOX_DRAWINGS_UP_HEAVY_AND_HORIZONTAL_LIGHT = 0x2538;
const char32_t BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_UP_HEAVY = 0x2539;
const char32_t BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_UP_HEAVY = 0x253A;
const char32_t BOX_DRAWINGS_HEAVY_UP_AND_HORIZONTAL = 0x253B;
const char32_t BOX_DRAWINGS_LIGHT_VERTICAL_AND_HORIZONTAL = 0x253C;
const char32_t BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_VERTICAL_LIGHT = 0x253D;
const char32_t BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_VERTICAL_LIGHT = 0x253E;
const char32_t BOX_DRAWINGS_VERTICAL_LIGHT_AND_HORIZONTAL_HEAVY = 0x253F;
const char32_t BOX_DRAWINGS_UP_HEAVY_AND_DOWN_HORIZONTAL_LIGHT = 0x2540;
const char32_t BOX_DRAWINGS_DOWN_HEAVY_AND_UP_HORIZONTAL_LIGHT = 0x2541;
const char32_t BOX_DRAWINGS_VERTICAL_HEAVY_AND_HORIZONTAL_LIGHT = 0x2542;
const char32_t BOX_DRAWINGS_LEFT_UP_HEAVY_AND_RIGHT_DOWN_LIGHT = 0x2543;
const char32_t BOX_DRAWINGS_RIGHT_UP_HEAVY_AND_LEFT_DOWN_LIGHT = 0x2544;
const char32_t BOX_DRAWINGS_LEFT_DOWN_HEAVY_AND_RIGHT_UP_LIGHT = 0x2545;
const char32_t BOX_DRAWINGS_RIGHT_DOWN_HEAVY_AND_LEFT_UP_LIGHT = 0x2546;
const char32_t BOX_DRAWINGS_DOWN_LIGHT_AND_UP_HORIZONTAL_HEAVY = 0x2547;
const char32_t BOX_DRAWINGS_UP_LIGHT_AND_DOWN_HORIZONTAL_HEAVY = 0x2548;
const char32_t BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_VERTICAL_HEAVY = 0x2549;
const char32_t BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_VERTICAL_HEAVY = 0x254A;
const char32_t BOX_DRAWINGS_HEAVY_VERTICAL_AND_HORIZONTAL = 0x254B;
const char32_t BOX_DRAWINGS_LIGHT_DOUBLE_DASH_HORIZONTAL = 0x254C;
const char32_t BOX_DRAWINGS_HEAVY_DOUBLE_DASH_HORIZONTAL = 0x254D;
const char32_t BOX_DRAWINGS_LIGHT_DOUBLE_DASH_VERTICAL = 0x254E;
const char32_t BOX_DRAWINGS_HEAVY_DOUBLE_DASH_VERTICAL = 0x254F;
const char32_t BOX_DRAWINGS_DOUBLE_HORIZONTAL = 0x2550;
const char32_t BOX_DRAWINGS_DOUBLE_VERTICAL = 0x2551;
const char32_t BOX_DRAWINGS_DOWN_SINGLE_AND_RIGHT_DOUBLE = 0x2552;
const char32_t BOX_DRAWINGS_DOWN_DOUBLE_AND_RIGHT_SINGLE = 0x2553;
const char32_t BOX_DRAWINGS_DOUBLE_DOWN_AND_RIGHT = 0x2554;
const char32_t BOX_DRAWINGS_DOWN_SINGLE_AND_LEFT_DOUBLE = 0x2555;
const char32_t BOX_DRAWINGS_DOWN_DOUBLE_AND_LEFT_SINGLE = 0x2556;
const char32_t BOX_DRAWINGS_DOUBLE_DOWN_AND_LEFT = 0x2557;
const char32_t BOX_DRAWINGS_UP_SINGLE_AND_RIGHT_DOUBLE = 0x2558;
const char32_t BOX_DRAWINGS_UP_DOUBLE_AND_RIGHT_SINGLE = 0x2559;
const char32_t BOX_DRAWINGS_DOUBLE_UP_AND_RIGHT = 0x255A;
const char32_t BOX_DRAWINGS_UP_SINGLE_AND_LEFT_DOUBLE = 0x255B;
const char32_t BOX_DRAWINGS_UP_DOUBLE_AND_LEFT_SINGLE = 0x255C;
const char32_t BOX_DRAWINGS_DOUBLE_UP_AND_LEFT = 0x255D;
const char32_t BOX_DRAWINGS_VERTICAL_SINGLE_AND_RIGHT_DOUBLE = 0x255E;
const char32_t BOX_DRAWINGS_VERTICAL_DOUBLE_AND_RIGHT_SINGLE = 0x255F;
const char32_t BOX_DRAWINGS_DOUBLE_VERTICAL_AND_RIGHT = 0x2560;
const char32_t BOX_DRAWINGS_VERTICAL_SINGLE_AND_LEFT_DOUBLE = 0x2561;
const char32_t BOX_DRAWINGS_VERTICAL_DOUBLE_AND_LEFT_SINGLE = 0x2562;
const char32_t BOX_DRAWINGS_DOUBLE_VERTICAL_AND_LEFT = 0x2563;
const char32_t BOX_DRAWINGS_DOWN_SINGLE_AND_HORIZONTAL_DOUBLE = 0x2564;
const char32_t BOX_DRAWINGS_DOWN_DOUBLE_AND_HORIZONTAL_SINGLE = 0x2565;
const char32_t BOX_DRAWINGS_DOUBLE_DOWN_AND_HORIZONTAL = 0x2566;
const char32_t BOX_DRAWINGS_UP_SINGLE_AND_HORIZONTAL_DOUBLE = 0x2567;
const char32_t BOX_DRAWINGS_UP_DOUBLE_AND_HORIZONTAL_SINGLE = 0x2568;
const char32_t BOX_DRAWINGS_DOUBLE_UP_AND_HORIZONTAL = 0x2569;
const char32_t BOX_DRAWINGS_VERTICAL_SINGLE_AND_HORIZONTAL_DOUBLE = 0x256A;
const char32_t BOX_DRAWINGS_VERTICAL_DOUBLE_AND_HORIZONTAL_SINGLE = 0x256B;
const char32_t BOX_DRAWINGS_DOUBLE_VERTICAL_AND_HORIZONTAL = 0x256C;
const char32_t BOX_DRAWINGS_LIGHT_ARC_DOWN_AND_RIGHT = 0x256D;
const char32_t BOX_DRAWINGS_LIGHT_ARC_DOWN_AND_LEFT = 0x256E;
const char32_t BOX_DRAWINGS_LIGHT_ARC_UP_AND_LEFT = 0x256F;
const char32_t BOX_DRAWINGS_LIGHT_ARC_UP_AND_RIGHT = 0x2570;
const char32_t BOX_DRAWINGS_LIGHT_DIAGONAL_UPPER_RIGHT_TO_LOWER_LEFT = 0x2571;
const char32_t BOX_DRAWINGS_LIGHT_DIAGONAL_UPPER_LEFT_TO_LOWER_RIGHT = 0x2572;
const char32_t BOX_DRAWINGS_LIGHT_DIAGONAL_CROSS = 0x2573;
const char32_t BOX_DRAWINGS_LIGHT_LEFT = 0x2574;
const char32_t BOX_DRAWINGS_LIGHT_UP = 0x2575;
const char32_t BOX_DRAWINGS_LIGHT_RIGHT = 0x2576;
const char32_t BOX_DRAWINGS_LIGHT_DOWN = 0x2577;
const char32_t BOX_DRAWINGS_HEAVY_LEFT = 0x2578;
const char32_t BOX_DRAWINGS_HEAVY_UP = 0x2579;
const char32_t BOX_DRAWINGS_HEAVY_RIGHT = 0x257A;
const char32_t BOX_DRAWINGS_HEAVY_DOWN = 0x257B;
const char32_t BOX_DRAWINGS_LIGHT_LEFT_AND_HEAVY_RIGHT = 0x257C;
const char32_t BOX_DRAWINGS_LIGHT_UP_AND_HEAVY_DOWN = 0x257D;
const char32_t BOX_DRAWINGS_HEAVY_LEFT_AND_LIGHT_RIGHT = 0x257E;
const char32_t BOX_DRAWINGS_HEAVY_UP_AND_LIGHT_DOWN = 0x257F;
const char32_t UPPER_HALF_BLOCK = 0x2580;
const char32_t LOWER_ONE_EIGHTH_BLOCK = 0x2581;
const char32_t LOWER_ONE_QUARTER_BLOCK = 0x2582;
const char32_t LOWER_THREE_EIGHTHS_BLOCK = 0x2583;
const char32_t LOWER_HALF_BLOCK = 0x2584;
const char32_t LOWER_FIVE_EIGHTHS_BLOCK = 0x2585;
const char32_t LOWER_THREE_QUARTERS_BLOCK = 0x2586;
const char32_t LOWER_SEVEN_EIGHTHS_BLOCK = 0x2587;
const char32_t FULL_BLOCK = 0x2588;
const char32_t LEFT_SEVEN_EIGHTHS_BLOCK = 0x2589;
const char32_t LEFT_THREE_QUARTERS_BLOCK = 0x258A;
const char32_t LEFT_FIVE_EIGHTHS_BLOCK = 0x258B;
const char32_t LEFT_HALF_BLOCK = 0x258C;
const char32_t LEFT_THREE_EIGHTHS_BLOCK = 0x258D;
const char32_t LEFT_ONE_QUARTER_BLOCK = 0x258E;
const char32_t LEFT_ONE_EIGHTH_BLOCK = 0x258F;
const char32_t RIGHT_HALF_BLOCK = 0x2590;
const char32_t LIGHT_SHADE = 0x2591;
const char32_t MEDIUM_SHADE = 0x2592;
const char32_t DARK_SHADE = 0x2593;
const char32_t UPPER_ONE_EIGHTH_BLOCK = 0x2594;
const char32_t RIGHT_ONE_EIGHTH_BLOCK = 0x2595;
const char32_t QUADRANT_LOWER_LEFT = 0x2596;
const char32_t QUADRANT_LOWER_RIGHT = 0x2597;
const char32_t QUADRANT_UPPER_LEFT = 0x2598;
const char32_t QUADRANT_UPPER_LEFT_AND_LOWER_LEFT_AND_LOWER_RIGHT = 0x2599;
const char32_t QUADRANT_UPPER_LEFT_AND_LOWER_RIGHT = 0x259A;
const char32_t QUADRANT_UPPER_LEFT_AND_UPPER_RIGHT_AND_LOWER_LEFT = 0x259B;
const char32_t QUADRANT_UPPER_LEFT_AND_UPPER_RIGHT_AND_LOWER_RIGHT = 0x259C;
const char32_t QUADRANT_UPPER_RIGHT = 0x259D;
const char32_t QUADRANT_UPPER_RIGHT_AND_LOWER_LEFT = 0x259E;
const char32_t QUADRANT_UPPER_RIGHT_AND_LOWER_LEFT_AND_LOWER_RIGHT = 0x259F;
const char32_t BLACK_SQUARE = 0x25A0;
const char32_t WHITE_SQUARE = 0x25A1;
const char32_t WHITE_SQUARE_WITH_ROUNDED_CORNERS = 0x25A2;
const char32_t WHITE_SQUARE_CONTAINING_BLACK_SMALL_SQUARE = 0x25A3;
const char32_t SQUARE_WITH_HORIZONTAL_FILL = 0x25A4;
const char32_t SQUARE_WITH_VERTICAL_FILL = 0x25A5;
const char32_t SQUARE_WITH_ORTHOGONAL_CROSSHATCH_FILL = 0x25A6;
const char32_t SQUARE_WITH_UPPER_LEFT_TO_LOWER_RIGHT_FILL = 0x25A7;
const char32_t SQUARE_WITH_UPPER_RIGHT_TO_LOWER_LEFT_FILL = 0x25A8;
const char32_t SQUARE_WITH_DIAGONAL_CROSSHATCH_FILL = 0x25A9;
const char32_t BLACK_SMALL_SQUARE = 0x25AA;
const char32_t WHITE_SMALL_SQUARE = 0x25AB;
const char32_t BLACK_RECTANGLE = 0x25AC;
const char32_t WHITE_RECTANGLE = 0x25AD;
const char32_t BLACK_VERTICAL_RECTANGLE = 0x25AE;
const char32_t WHITE_VERTICAL_RECTANGLE = 0x25AF;
const char32_t BLACK_PARALLELOGRAM = 0x25B0;
const char32_t WHITE_PARALLELOGRAM = 0x25B1;
const char32_t BLACK_UP_POINTING_TRIANGLE = 0x25B2;
const char32_t WHITE_UP_POINTING_TRIANGLE = 0x25B3;
const char32_t BLACK_UP_POINTING_SMALL_TRIANGLE = 0x25B4;
const char32_t WHITE_UP_POINTING_SMALL_TRIANGLE = 0x25B5;
const char32_t BLACK_RIGHT_POINTING_TRIANGLE = 0x25B6;
const char32_t WHITE_RIGHT_POINTING_TRIANGLE = 0x25B7;
const char32_t BLACK_RIGHT_POINTING_SMALL_TRIANGLE = 0x25B8;
const char32_t WHITE_RIGHT_POINTING_SMALL_TRIANGLE = 0x25B9;
const char32_t BLACK_RIGHT_POINTING_POINTER = 0x25BA;
const char32_t WHITE_RIGHT_POINTING_POINTER = 0x25BB;
const char32_t BLACK_DOWN_POINTING_TRIANGLE = 0x25BC;
const char32_t WHITE_DOWN_POINTING_TRIANGLE = 0x25BD;
const char32_t BLACK_DOWN_POINTING_SMALL_TRIANGLE = 0x25BE;
const char32_t WHITE_DOWN_POINTING_SMALL_TRIANGLE = 0x25BF;
const char32_t BLACK_LEFT_POINTING_TRIANGLE = 0x25C0;
const char32_t WHITE_LEFT_POINTING_TRIANGLE = 0x25C1;
const char32_t BLACK_LEFT_POINTING_SMALL_TRIANGLE = 0x25C2;
const char32_t WHITE_LEFT_POINTING_SMALL_TRIANGLE = 0x25C3;
const char32_t BLACK_LEFT_POINTING_POINTER = 0x25C4;
const char32_t WHITE_LEFT_POINTING_POINTER = 0x25C5;
const char32_t BLACK_DIAMOND = 0x25C6;
const char32_t WHITE_DIAMOND = 0x25C7;
const char32_t WHITE_DIAMOND_CONTAINING_BLACK_SMALL_DIAMOND = 0x25C8;
const char32_t FISHEYE = 0x25C9;
const char32_t LOZENGE = 0x25CA;
const char32_t WHITE_CIRCLE = 0x25CB;
const char32_t DOTTED_CIRCLE = 0x25CC;
const char32_t CIRCLE_WITH_VERTICAL_FILL = 0x25CD;
const char32_t BULLSEYE = 0x25CE;
const char32_t BLACK_CIRCLE = 0x25CF;
const char32_t CIRCLE_WITH_LEFT_HALF_BLACK = 0x25D0;
const char32_t CIRCLE_WITH_RIGHT_HALF_BLACK = 0x25D1;
const char32_t CIRCLE_WITH_LOWER_HALF_BLACK = 0x25D2;
const char32_t CIRCLE_WITH_UPPER_HALF_BLACK = 0x25D3;
const char32_t CIRCLE_WITH_UPPER_RIGHT_QUADRANT_BLACK = 0x25D4;
const char32_t CIRCLE_WITH_ALL_BUT_UPPER_LEFT_QUADRANT_BLACK = 0x25D5;
const char32_t LEFT_HALF_BLACK_CIRCLE = 0x25D6;
const char32_t RIGHT_HALF_BLACK_CIRCLE = 0x25D7;
const char32_t INVERSE_BULLET = 0x25D8;
const char32_t INVERSE_WHITE_CIRCLE = 0x25D9;
const char32_t UPPER_HALF_INVERSE_WHITE_CIRCLE = 0x25DA;
const char32_t LOWER_HALF_INVERSE_WHITE_CIRCLE = 0x25DB;
const char32_t UPPER_LEFT_QUADRANT_CIRCULAR_ARC = 0x25DC;
const char32_t UPPER_RIGHT_QUADRANT_CIRCULAR_ARC = 0x25DD;
const char32_t LOWER_RIGHT_QUADRANT_CIRCULAR_ARC = 0x25DE;
const char32_t LOWER_LEFT_QUADRANT_CIRCULAR_ARC = 0x25DF;
const char32_t UPPER_HALF_CIRCLE = 0x25E0;
const char32_t LOWER_HALF_CIRCLE = 0x25E1;
const char32_t BLACK_LOWER_RIGHT_TRIANGLE = 0x25E2;
const char32_t BLACK_LOWER_LEFT_TRIANGLE = 0x25E3;
const char32_t BLACK_UPPER_LEFT_TRIANGLE = 0x25E4;
const char32_t BLACK_UPPER_RIGHT_TRIANGLE = 0x25E5;
const char32_t WHITE_BULLET = 0x25E6;
const char32_t SQUARE_WITH_LEFT_HALF_BLACK = 0x25E7;
const char32_t SQUARE_WITH_RIGHT_HALF_BLACK = 0x25E8;
const char32_t SQUARE_WITH_UPPER_LEFT_DIAGONAL_HALF_BLACK = 0x25E9;
const char32_t SQUARE_WITH_LOWER_RIGHT_DIAGONAL_HALF_BLACK = 0x25EA;
const char32_t WHITE_SQUARE_WITH_VERTICAL_BISECTING_LINE = 0x25EB;
const char32_t WHITE_UP_POINTING_TRIANGLE_WITH_DOT = 0x25EC;
const char32_t UP_POINTING_TRIANGLE_WITH_LEFT_HALF_BLACK = 0x25ED;
const char32_t UP_POINTING_TRIANGLE_WITH_RIGHT_HALF_BLACK = 0x25EE;
const char32_t LARGE_CIRCLE = 0x25EF;
const char32_t WHITE_SQUARE_WITH_UPPER_LEFT_QUADRANT = 0x25F0;
const char32_t WHITE_SQUARE_WITH_LOWER_LEFT_QUADRANT = 0x25F1;
const char32_t WHITE_SQUARE_WITH_LOWER_RIGHT_QUADRANT = 0x25F2;
const char32_t WHITE_SQUARE_WITH_UPPER_RIGHT_QUADRANT = 0x25F3;
const char32_t WHITE_CIRCLE_WITH_UPPER_LEFT_QUADRANT = 0x25F4;
const char32_t WHITE_CIRCLE_WITH_LOWER_LEFT_QUADRANT = 0x25F5;
const char32_t WHITE_CIRCLE_WITH_LOWER_RIGHT_QUADRANT = 0x25F6;
const char32_t WHITE_CIRCLE_WITH_UPPER_RIGHT_QUADRANT = 0x25F7;
const char32_t UPPER_LEFT_TRIANGLE = 0x25F8;
const char32_t UPPER_RIGHT_TRIANGLE = 0x25F9;
const char32_t LOWER_LEFT_TRIANGLE = 0x25FA;
const char32_t WHITE_MEDIUM_SQUARE = 0x25FB;
const char32_t BLACK_MEDIUM_SQUARE = 0x25FC;
const char32_t WHITE_MEDIUM_SMALL_SQUARE = 0x25FD;
const char32_t BLACK_MEDIUM_SMALL_SQUARE = 0x25FE;
const char32_t LOWER_RIGHT_TRIANGLE = 0x25FF;
const char32_t BLACK_SUN_WITH_RAYS = 0x2600;
const char32_t CLOUD = 0x2601;
const char32_t UMBRELLA = 0x2602;
const char32_t SNOWMAN = 0x2603;
const char32_t COMET = 0x2604;
const char32_t BLACK_STAR = 0x2605;
const char32_t WHITE_STAR = 0x2606;
const char32_t LIGHTNING = 0x2607;
const char32_t THUNDERSTORM = 0x2608;
const char32_t SUN = 0x2609;
const char32_t ASCENDING_NODE = 0x260A;
const char32_t DESCENDING_NODE = 0x260B;
const char32_t CONJUNCTION = 0x260C;
const char32_t OPPOSITION = 0x260D;
const char32_t BLACK_TELEPHONE = 0x260E;
const char32_t WHITE_TELEPHONE = 0x260F;
const char32_t BALLOT_BOX = 0x2610;
const char32_t BALLOT_BOX_WITH_CHECK = 0x2611;
const char32_t BALLOT_BOX_WITH_X = 0x2612;
const char32_t SALTIRE = 0x2613;
const char32_t UMBRELLA_WITH_RAIN_DROPS = 0x2614;
const char32_t HOT_BEVERAGE = 0x2615;
const char32_t WHITE_SHOGI_PIECE = 0x2616;
const char32_t BLACK_SHOGI_PIECE = 0x2617;
const char32_t SHAMROCK = 0x2618;
const char32_t REVERSED_ROTATED_FLORAL_HEART_BULLET = 0x2619;
const char32_t BLACK_LEFT_POINTING_INDEX = 0x261A;
const char32_t BLACK_RIGHT_POINTING_INDEX = 0x261B;
const char32_t WHITE_LEFT_POINTING_INDEX = 0x261C;
const char32_t WHITE_UP_POINTING_INDEX = 0x261D;
const char32_t WHITE_RIGHT_POINTING_INDEX = 0x261E;
const char32_t WHITE_DOWN_POINTING_INDEX = 0x261F;
const char32_t SKULL_AND_CROSSBONES = 0x2620;
const char32_t CAUTION_SIGN = 0x2621;
const char32_t RADIOACTIVE_SIGN = 0x2622;
const char32_t BIOHAZARD_SIGN = 0x2623;
const char32_t CADUCEUS = 0x2624;
const char32_t ANKH = 0x2625;
const char32_t ORTHODOX_CROSS = 0x2626;
const char32_t CHI_RHO = 0x2627;
const char32_t CROSS_OF_LORRAINE = 0x2628;
const char32_t CROSS_OF_JERUSALEM = 0x2629;
const char32_t STAR_AND_CRESCENT = 0x262A;
const char32_t FARSI_SYMBOL = 0x262B;
const char32_t ADI_SHAKTI = 0x262C;
const char32_t HAMMER_AND_SICKLE = 0x262D;
const char32_t PEACE_SYMBOL = 0x262E;
const char32_t YIN_YANG = 0x262F;
const char32_t TRIGRAM_FOR_HEAVEN = 0x2630;
const char32_t TRIGRAM_FOR_LAKE = 0x2631;
const char32_t TRIGRAM_FOR_FIRE = 0x2632;
const char32_t TRIGRAM_FOR_THUNDER = 0x2633;
const char32_t TRIGRAM_FOR_WIND = 0x2634;
const char32_t TRIGRAM_FOR_WATER = 0x2635;
const char32_t TRIGRAM_FOR_MOUNTAIN = 0x2636;
const char32_t TRIGRAM_FOR_EARTH = 0x2637;
const char32_t WHEEL_OF_DHARMA = 0x2638;
const char32_t WHITE_FROWNING_FACE = 0x2639;
const char32_t WHITE_SMILING_FACE = 0x263A;
const char32_t BLACK_SMILING_FACE = 0x263B;
const char32_t WHITE_SUN_WITH_RAYS = 0x263C;
const char32_t FIRST_QUARTER_MOON = 0x263D;
const char32_t LAST_QUARTER_MOON = 0x263E;
const char32_t MERCURY = 0x263F;
const char32_t FEMALE_SIGN = 0x2640;
const char32_t EARTH = 0x2641;
const char32_t MALE_SIGN = 0x2642;
const char32_t JUPITER = 0x2643;
const char32_t SATURN = 0x2644;
const char32_t URANUS = 0x2645;
const char32_t NEPTUNE = 0x2646;
const char32_t PLUTO = 0x2647;
const char32_t ARIES = 0x2648;
const char32_t TAURUS = 0x2649;
const char32_t GEMINI = 0x264A;
const char32_t CANCER = 0x264B;
const char32_t LEO = 0x264C;
const char32_t VIRGO = 0x264D;
const char32_t LIBRA = 0x264E;
const char32_t SCORPIUS = 0x264F;
const char32_t SAGITTARIUS = 0x2650;
const char32_t CAPRICORN = 0x2651;
const char32_t AQUARIUS = 0x2652;
const char32_t PISCES = 0x2653;
const char32_t WHITE_CHESS_KING = 0x2654;
const char32_t WHITE_CHESS_QUEEN = 0x2655;
const char32_t WHITE_CHESS_ROOK = 0x2656;
const char32_t WHITE_CHESS_BISHOP = 0x2657;
const char32_t WHITE_CHESS_KNIGHT = 0x2658;
const char32_t WHITE_CHESS_PAWN = 0x2659;
const char32_t BLACK_CHESS_KING = 0x265A;
const char32_t BLACK_CHESS_QUEEN = 0x265B;
const char32_t BLACK_CHESS_ROOK = 0x265C;
const char32_t BLACK_CHESS_BISHOP = 0x265D;
const char32_t BLACK_CHESS_KNIGHT = 0x265E;
const char32_t BLACK_CHESS_PAWN = 0x265F;
const char32_t BLACK_SPADE_SUIT = 0x2660;
const char32_t WHITE_HEART_SUIT = 0x2661;
const char32_t WHITE_DIAMOND_SUIT = 0x2662;
const char32_t BLACK_CLUB_SUIT = 0x2663;
const char32_t WHITE_SPADE_SUIT = 0x2664;
const char32_t BLACK_HEART_SUIT = 0x2665;
const char32_t BLACK_DIAMOND_SUIT = 0x2666;
const char32_t WHITE_CLUB_SUIT = 0x2667;
const char32_t HOT_SPRINGS = 0x2668;
const char32_t QUARTER_NOTE = 0x2669;
const char32_t EIGHTH_NOTE = 0x266A;
const char32_t BEAMED_EIGHTH_NOTES = 0x266B;
const char32_t BEAMED_SIXTEENTH_NOTES = 0x266C;
const char32_t MUSIC_FLAT_SIGN = 0x266D;
const char32_t MUSIC_NATURAL_SIGN = 0x266E;
const char32_t MUSIC_SHARP_SIGN = 0x266F;
const char32_t WEST_SYRIAC_CROSS = 0x2670;
const char32_t EAST_SYRIAC_CROSS = 0x2671;
const char32_t UNIVERSAL_RECYCLING_SYMBOL = 0x2672;
const char32_t RECYCLING_SYMBOL_FOR_TYPE_1_PLASTICS = 0x2673;
const char32_t RECYCLING_SYMBOL_FOR_TYPE_2_PLASTICS = 0x2674;
const char32_t RECYCLING_SYMBOL_FOR_TYPE_3_PLASTICS = 0x2675;
const char32_t RECYCLING_SYMBOL_FOR_TYPE_4_PLASTICS = 0x2676;
const char32_t RECYCLING_SYMBOL_FOR_TYPE_5_PLASTICS = 0x2677;
const char32_t RECYCLING_SYMBOL_FOR_TYPE_6_PLASTICS = 0x2678;
const char32_t RECYCLING_SYMBOL_FOR_TYPE_7_PLASTICS = 0x2679;
const char32_t RECYCLING_SYMBOL_FOR_GENERIC_MATERIALS = 0x267A;
const char32_t BLACK_UNIVERSAL_RECYCLING_SYMBOL = 0x267B;
const char32_t RECYCLED_PAPER_SYMBOL = 0x267C;
const char32_t PARTIALLY_RECYCLED_PAPER_SYMBOL = 0x267D;
const char32_t PERMANENT_PAPER_SIGN = 0x267E;
const char32_t WHEELCHAIR_SYMBOL = 0x267F;
const char32_t DIE_FACE_1 = 0x2680;
const char32_t DIE_FACE_2 = 0x2681;
const char32_t DIE_FACE_3 = 0x2682;
const char32_t DIE_FACE_4 = 0x2683;
const char32_t DIE_FACE_5 = 0x2684;
const char32_t DIE_FACE_6 = 0x2685;
const char32_t WHITE_CIRCLE_WITH_DOT_RIGHT = 0x2686;
const char32_t WHITE_CIRCLE_WITH_TWO_DOTS = 0x2687;
const char32_t BLACK_CIRCLE_WITH_WHITE_DOT_RIGHT = 0x2688;
const char32_t BLACK_CIRCLE_WITH_TWO_WHITE_DOTS = 0x2689;
const char32_t MONOGRAM_FOR_YANG = 0x268A;
const char32_t MONOGRAM_FOR_YIN = 0x268B;
const char32_t DIGRAM_FOR_GREATER_YANG = 0x268C;
const char32_t DIGRAM_FOR_LESSER_YIN = 0x268D;
const char32_t DIGRAM_FOR_LESSER_YANG = 0x268E;
const char32_t DIGRAM_FOR_GREATER_YIN = 0x268F;
const char32_t WHITE_FLAG = 0x2690;
const char32_t BLACK_FLAG = 0x2691;
const char32_t HAMMER_AND_PICK = 0x2692;
const char32_t ANCHOR = 0x2693;
const char32_t CROSSED_SWORDS = 0x2694;
const char32_t STAFF_OF_AESCULAPIUS = 0x2695;
const char32_t SCALES = 0x2696;
const char32_t ALEMBIC = 0x2697;
const char32_t FLOWER = 0x2698;
const char32_t GEAR = 0x2699;
const char32_t STAFF_OF_HERMES = 0x269A;
const char32_t ATOM_SYMBOL = 0x269B;
const char32_t FLEUR_DE_LIS = 0x269C;
const char32_t OUTLINED_WHITE_STAR = 0x269D;
const char32_t THREE_LINES_CONVERGING_RIGHT = 0x269E;
const char32_t THREE_LINES_CONVERGING_LEFT = 0x269F;
const char32_t WARNING_SIGN = 0x26A0;
const char32_t HIGH_VOLTAGE_SIGN = 0x26A1;
const char32_t DOUBLED_FEMALE_SIGN = 0x26A2;
const char32_t DOUBLED_MALE_SIGN = 0x26A3;
const char32_t INTERLOCKED_FEMALE_AND_MALE_SIGN = 0x26A4;
const char32_t MALE_AND_FEMALE_SIGN = 0x26A5;
const char32_t MALE_WITH_STROKE_SIGN = 0x26A6;
const char32_t MALE_WITH_STROKE_AND_MALE_AND_FEMALE_SIGN = 0x26A7;
const char32_t VERTICAL_MALE_WITH_STROKE_SIGN = 0x26A8;
const char32_t HORIZONTAL_MALE_WITH_STROKE_SIGN = 0x26A9;
const char32_t MEDIUM_WHITE_CIRCLE = 0x26AA;
const char32_t MEDIUM_BLACK_CIRCLE = 0x26AB;
const char32_t MEDIUM_SMALL_WHITE_CIRCLE = 0x26AC;
const char32_t MARRIAGE_SYMBOL = 0x26AD;
const char32_t DIVORCE_SYMBOL = 0x26AE;
const char32_t UNMARRIED_PARTNERSHIP_SYMBOL = 0x26AF;
const char32_t COFFIN = 0x26B0;
const char32_t FUNERAL_URN = 0x26B1;
const char32_t NEUTER = 0x26B2;
const char32_t CERES = 0x26B3;
const char32_t PALLAS = 0x26B4;
const char32_t JUNO = 0x26B5;
const char32_t VESTA = 0x26B6;
const char32_t CHIRON = 0x26B7;
const char32_t BLACK_MOON_LILITH = 0x26B8;
const char32_t SEXTILE = 0x26B9;
const char32_t SEMISEXTILE = 0x26BA;
const char32_t QUINCUNX = 0x26BB;
const char32_t SESQUIQUADRATE = 0x26BC;
const char32_t SOCCER_BALL = 0x26BD;
const char32_t BASEBALL = 0x26BE;
const char32_t SQUARED_KEY = 0x26BF;
const char32_t WHITE_DRAUGHTS_MAN = 0x26C0;
const char32_t WHITE_DRAUGHTS_KING = 0x26C1;
const char32_t BLACK_DRAUGHTS_MAN = 0x26C2;
const char32_t BLACK_DRAUGHTS_KING = 0x26C3;
const char32_t SNOWMAN_WITHOUT_SNOW = 0x26C4;
const char32_t SUN_BEHIND_CLOUD = 0x26C5;
const char32_t RAIN = 0x26C6;
const char32_t BLACK_SNOWMAN = 0x26C7;
const char32_t THUNDER_CLOUD_AND_RAIN = 0x26C8;
const char32_t TURNED_WHITE_SHOGI_PIECE = 0x26C9;
const char32_t TURNED_BLACK_SHOGI_PIECE = 0x26CA;
const char32_t WHITE_DIAMOND_IN_SQUARE = 0x26CB;
const char32_t CROSSING_LANES = 0x26CC;
const char32_t DISABLED_CAR = 0x26CD;
const char32_t OPHIUCHUS = 0x26CE;
const char32_t PICK = 0x26CF;
const char32_t CAR_SLIDING = 0x26D0;
const char32_t HELMET_WITH_WHITE_CROSS = 0x26D1;
const char32_t CIRCLED_CROSSING_LANES = 0x26D2;
const char32_t CHAINS = 0x26D3;
const char32_t NO_ENTRY = 0x26D4;
const char32_t ALTERNATE_ONE_WAY_LEFT_WAY_TRAFFIC = 0x26D5;
const char32_t BLACK_TWO_WAY_LEFT_WAY_TRAFFIC = 0x26D6;
const char32_t WHITE_TWO_WAY_LEFT_WAY_TRAFFIC = 0x26D7;
const char32_t BLACK_LEFT_LANE_MERGE = 0x26D8;
const char32_t WHITE_LEFT_LANE_MERGE = 0x26D9;
const char32_t DRIVE_SLOW_SIGN = 0x26DA;
const char32_t HEAVY_WHITE_DOWN_POINTING_TRIANGLE = 0x26DB;
const char32_t LEFT_CLOSED_ENTRY = 0x26DC;
const char32_t SQUARED_SALTIRE = 0x26DD;
const char32_t FALLING_DIAGONAL_IN_WHITE_CIRCLE_IN_BLACK_SQUARE = 0x26DE;
const char32_t BLACK_TRUCK = 0x26DF;
const char32_t RESTRICTED_LEFT_ENTRY_1 = 0x26E0;
const char32_t RESTRICTED_LEFT_ENTRY_2 = 0x26E1;
const char32_t ASTRONOMICAL_SYMBOL_FOR_URANUS = 0x26E2;
const char32_t HEAVY_CIRCLE_WITH_STROKE_AND_TWO_DOTS_ABOVE = 0x26E3;
const char32_t PENTAGRAM = 0x26E4;
const char32_t RIGHT_HANDED_INTERLACED_PENTAGRAM = 0x26E5;
const char32_t LEFT_HANDED_INTERLACED_PENTAGRAM = 0x26E6;
const char32_t INVERTED_PENTAGRAM = 0x26E7;
const char32_t BLACK_CROSS_ON_SHIELD = 0x26E8;
const char32_t SHINTO_SHRINE = 0x26E9;
const char32_t CHURCH = 0x26EA;
const char32_t CASTLE = 0x26EB;
const char32_t HISTORIC_SITE = 0x26EC;
const char32_t GEAR_WITHOUT_HUB = 0x26ED;
const char32_t GEAR_WITH_HANDLES = 0x26EE;
const char32_t MAP_SYMBOL_FOR_LIGHTHOUSE = 0x26EF;
const char32_t MOUNTAIN = 0x26F0;
const char32_t UMBRELLA_ON_GROUND = 0x26F1;
const char32_t FOUNTAIN = 0x26F2;
const char32_t FLAG_IN_HOLE = 0x26F3;
const char32_t FERRY = 0x26F4;
const char32_t SAILBOAT = 0x26F5;
const char32_t SQUARE_FOUR_CORNERS = 0x26F6;
const char32_t SKIER = 0x26F7;
const char32_t ICE_SKATE = 0x26F8;
const char32_t PERSON_WITH_BALL = 0x26F9;
const char32_t TENT = 0x26FA;
const char32_t JAPANESE_BANK_SYMBOL = 0x26FB;
const char32_t HEADSTONE_GRAVEYARD_SYMBOL = 0x26FC;
const char32_t FUEL_PUMP = 0x26FD;
const char32_t CUP_ON_BLACK_SQUARE = 0x26FE;
const char32_t WHITE_FLAG_WITH_HORIZONTAL_MIDDLE_BLACK_STRIPE = 0x26FF;
const char32_t BLACK_SAFETY_SCISSORS = 0x2700;
const char32_t UPPER_BLADE_SCISSORS = 0x2701;
const char32_t BLACK_SCISSORS = 0x2702;
const char32_t LOWER_BLADE_SCISSORS = 0x2703;
const char32_t WHITE_SCISSORS = 0x2704;
const char32_t WHITE_HEAVY_CHECK_MARK = 0x2705;
const char32_t TELEPHONE_LOCATION_SIGN = 0x2706;
const char32_t TAPE_DRIVE = 0x2707;
const char32_t AIRPLANE = 0x2708;
const char32_t ENVELOPE = 0x2709;
const char32_t RAISED_FIST = 0x270A;
const char32_t RAISED_HAND = 0x270B;
const char32_t VICTORY_HAND = 0x270C;
const char32_t WRITING_HAND = 0x270D;
const char32_t LOWER_RIGHT_PENCIL = 0x270E;
const char32_t PENCIL = 0x270F;
const char32_t UPPER_RIGHT_PENCIL = 0x2710;
const char32_t WHITE_NIB = 0x2711;
const char32_t BLACK_NIB = 0x2712;
const char32_t CHECK_MARK = 0x2713;
const char32_t HEAVY_CHECK_MARK = 0x2714;
const char32_t MULTIPLICATION_X = 0x2715;
const char32_t HEAVY_MULTIPLICATION_X = 0x2716;
const char32_t BALLOT_X = 0x2717;
const char32_t HEAVY_BALLOT_X = 0x2718;
const char32_t OUTLINED_GREEK_CROSS = 0x2719;
const char32_t HEAVY_GREEK_CROSS = 0x271A;
const char32_t OPEN_CENTRE_CROSS = 0x271B;
const char32_t HEAVY_OPEN_CENTRE_CROSS = 0x271C;
const char32_t LATIN_CROSS = 0x271D;
const char32_t SHADOWED_WHITE_LATIN_CROSS = 0x271E;
const char32_t OUTLINED_LATIN_CROSS = 0x271F;
const char32_t MALTESE_CROSS = 0x2720;
const char32_t STAR_OF_DAVID = 0x2721;
const char32_t FOUR_TEARDROP_SPOKED_ASTERISK = 0x2722;
const char32_t FOUR_BALLOON_SPOKED_ASTERISK = 0x2723;
const char32_t HEAVY_FOUR_BALLOON_SPOKED_ASTERISK = 0x2724;
const char32_t FOUR_CLUB_SPOKED_ASTERISK = 0x2725;
const char32_t BLACK_FOUR_POINTED_STAR = 0x2726;
const char32_t WHITE_FOUR_POINTED_STAR = 0x2727;
const char32_t SPARKLES = 0x2728;
const char32_t STRESS_OUTLINED_WHITE_STAR = 0x2729;
const char32_t CIRCLED_WHITE_STAR = 0x272A;
const char32_t OPEN_CENTRE_BLACK_STAR = 0x272B;
const char32_t BLACK_CENTRE_WHITE_STAR = 0x272C;
const char32_t OUTLINED_BLACK_STAR = 0x272D;
const char32_t HEAVY_OUTLINED_BLACK_STAR = 0x272E;
const char32_t PINWHEEL_STAR = 0x272F;
const char32_t SHADOWED_WHITE_STAR = 0x2730;
const char32_t HEAVY_ASTERISK = 0x2731;
const char32_t OPEN_CENTRE_ASTERISK = 0x2732;
const char32_t EIGHT_SPOKED_ASTERISK = 0x2733;
const char32_t EIGHT_POINTED_BLACK_STAR = 0x2734;
const char32_t EIGHT_POINTED_PINWHEEL_STAR = 0x2735;
const char32_t SIX_POINTED_BLACK_STAR = 0x2736;
const char32_t EIGHT_POINTED_RECTILINEAR_BLACK_STAR = 0x2737;
const char32_t HEAVY_EIGHT_POINTED_RECTILINEAR_BLACK_STAR = 0x2738;
const char32_t TWELVE_POINTED_BLACK_STAR = 0x2739;
const char32_t SIXTEEN_POINTED_ASTERISK = 0x273A;
const char32_t TEARDROP_SPOKED_ASTERISK = 0x273B;
const char32_t OPEN_CENTRE_TEARDROP_SPOKED_ASTERISK = 0x273C;
const char32_t HEAVY_TEARDROP_SPOKED_ASTERISK = 0x273D;
const char32_t SIX_PETALLED_BLACK_AND_WHITE_FLORETTE = 0x273E;
const char32_t BLACK_FLORETTE = 0x273F;
const char32_t WHITE_FLORETTE = 0x2740;
const char32_t EIGHT_PETALLED_OUTLINED_BLACK_FLORETTE = 0x2741;
const char32_t CIRCLED_OPEN_CENTRE_EIGHT_POINTED_STAR = 0x2742;
const char32_t HEAVY_TEARDROP_SPOKED_PINWHEEL_ASTERISK = 0x2743;
const char32_t SNOWFLAKE = 0x2744;
const char32_t TIGHT_TRIFOLIATE_SNOWFLAKE = 0x2745;
const char32_t HEAVY_CHEVRON_SNOWFLAKE = 0x2746;
const char32_t SPARKLE = 0x2747;
const char32_t HEAVY_SPARKLE = 0x2748;
const char32_t BALLOON_SPOKED_ASTERISK = 0x2749;
const char32_t EIGHT_TEARDROP_SPOKED_PROPELLER_ASTERISK = 0x274A;
const char32_t HEAVY_EIGHT_TEARDROP_SPOKED_PROPELLER_ASTERISK = 0x274B;
const char32_t CROSS_MARK = 0x274C;
const char32_t SHADOWED_WHITE_CIRCLE = 0x274D;
const char32_t NEGATIVE_SQUARED_CROSS_MARK = 0x274E;
const char32_t LOWER_RIGHT_DROP_SHADOWED_WHITE_SQUARE = 0x274F;
const char32_t UPPER_RIGHT_DROP_SHADOWED_WHITE_SQUARE = 0x2750;
const char32_t LOWER_RIGHT_SHADOWED_WHITE_SQUARE = 0x2751;
const char32_t UPPER_RIGHT_SHADOWED_WHITE_SQUARE = 0x2752;
const char32_t BLACK_QUESTION_MARK_ORNAMENT = 0x2753;
const char32_t WHITE_QUESTION_MARK_ORNAMENT = 0x2754;
const char32_t WHITE_EXCLAMATION_MARK_ORNAMENT = 0x2755;
const char32_t BLACK_DIAMOND_MINUS_WHITE_X = 0x2756;
const char32_t HEAVY_EXCLAMATION_MARK_SYMBOL = 0x2757;
const char32_t LIGHT_VERTICAL_BAR = 0x2758;
const char32_t MEDIUM_VERTICAL_BAR = 0x2759;
const char32_t HEAVY_VERTICAL_BAR = 0x275A;
const char32_t HEAVY_SINGLE_TURNED_COMMA_QUOTATION_MARK_ORNAMENT = 0x275B;
const char32_t HEAVY_SINGLE_COMMA_QUOTATION_MARK_ORNAMENT = 0x275C;
const char32_t HEAVY_DOUBLE_TURNED_COMMA_QUOTATION_MARK_ORNAMENT = 0x275D;
const char32_t HEAVY_DOUBLE_COMMA_QUOTATION_MARK_ORNAMENT = 0x275E;
const char32_t HEAVY_LOW_SINGLE_COMMA_QUOTATION_MARK_ORNAMENT = 0x275F;
const char32_t HEAVY_LOW_DOUBLE_COMMA_QUOTATION_MARK_ORNAMENT = 0x2760;
const char32_t CURVED_STEM_PARAGRAPH_SIGN_ORNAMENT = 0x2761;
const char32_t HEAVY_EXCLAMATION_MARK_ORNAMENT = 0x2762;
const char32_t HEAVY_HEART_EXCLAMATION_MARK_ORNAMENT = 0x2763;
const char32_t HEAVY_BLACK_HEART = 0x2764;
const char32_t ROTATED_HEAVY_BLACK_HEART_BULLET = 0x2765;
const char32_t FLORAL_HEART = 0x2766;
const char32_t ROTATED_FLORAL_HEART_BULLET = 0x2767;
const char32_t MEDIUM_LEFT_PARENTHESIS_ORNAMENT = 0x2768;
const char32_t MEDIUM_RIGHT_PARENTHESIS_ORNAMENT = 0x2769;
const char32_t MEDIUM_FLATTENED_LEFT_PARENTHESIS_ORNAMENT = 0x276A;
const char32_t MEDIUM_FLATTENED_RIGHT_PARENTHESIS_ORNAMENT = 0x276B;
const char32_t MEDIUM_LEFT_POINTING_ANGLE_BRACKET_ORNAMENT = 0x276C;
const char32_t MEDIUM_RIGHT_POINTING_ANGLE_BRACKET_ORNAMENT = 0x276D;
const char32_t HEAVY_LEFT_POINTING_ANGLE_QUOTATION_MARK_ORNAMENT = 0x276E;
const char32_t HEAVY_RIGHT_POINTING_ANGLE_QUOTATION_MARK_ORNAMENT = 0x276F;
const char32_t HEAVY_LEFT_POINTING_ANGLE_BRACKET_ORNAMENT = 0x2770;
const char32_t HEAVY_RIGHT_POINTING_ANGLE_BRACKET_ORNAMENT = 0x2771;
const char32_t LIGHT_LEFT_TORTOISE_SHELL_BRACKET_ORNAMENT = 0x2772;
const char32_t LIGHT_RIGHT_TORTOISE_SHELL_BRACKET_ORNAMENT = 0x2773;
const char32_t MEDIUM_LEFT_CURLY_BRACKET_ORNAMENT = 0x2774;
const char32_t MEDIUM_RIGHT_CURLY_BRACKET_ORNAMENT = 0x2775;
const char32_t DINGBAT_NEGATIVE_CIRCLED_DIGIT_ONE = 0x2776;
const char32_t DINGBAT_NEGATIVE_CIRCLED_DIGIT_TWO = 0x2777;
const char32_t DINGBAT_NEGATIVE_CIRCLED_DIGIT_THREE = 0x2778;
const char32_t DINGBAT_NEGATIVE_CIRCLED_DIGIT_FOUR = 0x2779;
const char32_t DINGBAT_NEGATIVE_CIRCLED_DIGIT_FIVE = 0x277A;
const char32_t DINGBAT_NEGATIVE_CIRCLED_DIGIT_SIX = 0x277B;
const char32_t DINGBAT_NEGATIVE_CIRCLED_DIGIT_SEVEN = 0x277C;
const char32_t DINGBAT_NEGATIVE_CIRCLED_DIGIT_EIGHT = 0x277D;
const char32_t DINGBAT_NEGATIVE_CIRCLED_DIGIT_NINE = 0x277E;
const char32_t DINGBAT_NEGATIVE_CIRCLED_NUMBER_TEN = 0x277F;
const char32_t DINGBAT_CIRCLED_SANS_SERIF_DIGIT_ONE = 0x2780;
const char32_t DINGBAT_CIRCLED_SANS_SERIF_DIGIT_TWO = 0x2781;
const char32_t DINGBAT_CIRCLED_SANS_SERIF_DIGIT_THREE = 0x2782;
const char32_t DINGBAT_CIRCLED_SANS_SERIF_DIGIT_FOUR = 0x2783;
const char32_t DINGBAT_CIRCLED_SANS_SERIF_DIGIT_FIVE = 0x2784;
const char32_t DINGBAT_CIRCLED_SANS_SERIF_DIGIT_SIX = 0x2785;
const char32_t DINGBAT_CIRCLED_SANS_SERIF_DIGIT_SEVEN = 0x2786;
const char32_t DINGBAT_CIRCLED_SANS_SERIF_DIGIT_EIGHT = 0x2787;
const char32_t DINGBAT_CIRCLED_SANS_SERIF_DIGIT_NINE = 0x2788;
const char32_t DINGBAT_CIRCLED_SANS_SERIF_NUMBER_TEN = 0x2789;
const char32_t DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_ONE = 0x278A;
const char32_t DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_TWO = 0x278B;
const char32_t DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_THREE = 0x278C;
const char32_t DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_FOUR = 0x278D;
const char32_t DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_FIVE = 0x278E;
const char32_t DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_SIX = 0x278F;
const char32_t DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_SEVEN = 0x2790;
const char32_t DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_EIGHT = 0x2791;
const char32_t DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_NINE = 0x2792;
const char32_t DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_NUMBER_TEN = 0x2793;
const char32_t HEAVY_WIDE_HEADED_RIGHTWARDS_ARROW = 0x2794;
const char32_t HEAVY_PLUS_SIGN = 0x2795;
const char32_t HEAVY_MINUS_SIGN = 0x2796;
const char32_t HEAVY_DIVISION_SIGN = 0x2797;
const char32_t HEAVY_SOUTH_EAST_ARROW = 0x2798;
const char32_t HEAVY_RIGHTWARDS_ARROW = 0x2799;
const char32_t HEAVY_NORTH_EAST_ARROW = 0x279A;
const char32_t DRAFTING_POINT_RIGHTWARDS_ARROW = 0x279B;
const char32_t HEAVY_ROUND_TIPPED_RIGHTWARDS_ARROW = 0x279C;
const char32_t TRIANGLE_HEADED_RIGHTWARDS_ARROW = 0x279D;
const char32_t HEAVY_TRIANGLE_HEADED_RIGHTWARDS_ARROW = 0x279E;
const char32_t DASHED_TRIANGLE_HEADED_RIGHTWARDS_ARROW = 0x279F;
const char32_t HEAVY_DASHED_TRIANGLE_HEADED_RIGHTWARDS_ARROW = 0x27A0;
const char32_t BLACK_RIGHTWARDS_ARROW = 0x27A1;
const char32_t THREE_D_TOP_LIGHTED_RIGHTWARDS_ARROWHEAD = 0x27A2;
const char32_t THREE_D_BOTTOM_LIGHTED_RIGHTWARDS_ARROWHEAD = 0x27A3;
const char32_t BLACK_RIGHTWARDS_ARROWHEAD = 0x27A4;
const char32_t HEAVY_BLACK_CURVED_DOWNWARDS_AND_RIGHTWARDS_ARROW = 0x27A5;
const char32_t HEAVY_BLACK_CURVED_UPWARDS_AND_RIGHTWARDS_ARROW = 0x27A6;
const char32_t SQUAT_BLACK_RIGHTWARDS_ARROW = 0x27A7;
const char32_t HEAVY_CONCAVE_POINTED_BLACK_RIGHTWARDS_ARROW = 0x27A8;
const char32_t RIGHT_SHADED_WHITE_RIGHTWARDS_ARROW = 0x27A9;
const char32_t LEFT_SHADED_WHITE_RIGHTWARDS_ARROW = 0x27AA;
const char32_t BACK_TILTED_SHADOWED_WHITE_RIGHTWARDS_ARROW = 0x27AB;
const char32_t FRONT_TILTED_SHADOWED_WHITE_RIGHTWARDS_ARROW = 0x27AC;
const char32_t HEAVY_LOWER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW = 0x27AD;
const char32_t HEAVY_UPPER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW = 0x27AE;
const char32_t NOTCHED_LOWER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW = 0x27AF;
const char32_t CURLY_LOOP = 0x27B0;
const char32_t NOTCHED_UPPER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW = 0x27B1;
const char32_t CIRCLED_HEAVY_WHITE_RIGHTWARDS_ARROW = 0x27B2;
const char32_t WHITE_FEATHERED_RIGHTWARDS_ARROW = 0x27B3;
const char32_t BLACK_FEATHERED_SOUTH_EAST_ARROW = 0x27B4;
const char32_t BLACK_FEATHERED_RIGHTWARDS_ARROW = 0x27B5;
const char32_t BLACK_FEATHERED_NORTH_EAST_ARROW = 0x27B6;
const char32_t HEAVY_BLACK_FEATHERED_SOUTH_EAST_ARROW = 0x27B7;
const char32_t HEAVY_BLACK_FEATHERED_RIGHTWARDS_ARROW = 0x27B8;
const char32_t HEAVY_BLACK_FEATHERED_NORTH_EAST_ARROW = 0x27B9;
const char32_t TEARDROP_BARBED_RIGHTWARDS_ARROW = 0x27BA;
const char32_t HEAVY_TEARDROP_SHANKED_RIGHTWARDS_ARROW = 0x27BB;
const char32_t WEDGE_TAILED_RIGHTWARDS_ARROW = 0x27BC;
const char32_t HEAVY_WEDGE_TAILED_RIGHTWARDS_ARROW = 0x27BD;
const char32_t OPEN_OUTLINED_RIGHTWARDS_ARROW = 0x27BE;
const char32_t DOUBLE_CURLY_LOOP = 0x27BF;
const char32_t THREE_DIMENSIONAL_ANGLE = 0x27C0;
const char32_t WHITE_TRIANGLE_CONTAINING_SMALL_WHITE_TRIANGLE = 0x27C1;
const char32_t PERPENDICULAR = 0x27C2;
const char32_t OPEN_SUBSET = 0x27C3;
const char32_t OPEN_SUPERSET = 0x27C4;
const char32_t LEFT_S_SHAPED_BAG_DELIMITER = 0x27C5;
const char32_t RIGHT_S_SHAPED_BAG_DELIMITER = 0x27C6;
const char32_t OR_WITH_DOT_INSIDE = 0x27C7;
const char32_t REVERSE_SOLIDUS_PRECEDING_SUBSET = 0x27C8;
const char32_t SUPERSET_PRECEDING_SOLIDUS = 0x27C9;
const char32_t VERTICAL_BAR_WITH_HORIZONTAL_STROKE = 0x27CA;
const char32_t MATHEMATICAL_RISING_DIAGONAL = 0x27CB;
const char32_t LONG_DIVISION = 0x27CC;
const char32_t MATHEMATICAL_FALLING_DIAGONAL = 0x27CD;
const char32_t SQUARED_LOGICAL_AND = 0x27CE;
const char32_t SQUARED_LOGICAL_OR = 0x27CF;
const char32_t WHITE_DIAMOND_WITH_CENTRED_DOT = 0x27D0;
const char32_t AND_WITH_DOT = 0x27D1;
const char32_t ELEMENT_OF_OPENING_UPWARDS = 0x27D2;
const char32_t LOWER_RIGHT_CORNER_WITH_DOT = 0x27D3;
const char32_t UPPER_LEFT_CORNER_WITH_DOT = 0x27D4;
const char32_t LEFT_OUTER_JOIN = 0x27D5;
const char32_t RIGHT_OUTER_JOIN = 0x27D6;
const char32_t FULL_OUTER_JOIN = 0x27D7;
const char32_t LARGE_UP_TACK = 0x27D8;
const char32_t LARGE_DOWN_TACK = 0x27D9;
const char32_t LEFT_AND_RIGHT_DOUBLE_TURNSTILE = 0x27DA;
const char32_t LEFT_AND_RIGHT_TACK = 0x27DB;
const char32_t LEFT_MULTIMAP = 0x27DC;
const char32_t LONG_RIGHT_TACK = 0x27DD;
const char32_t LONG_LEFT_TACK = 0x27DE;
const char32_t UP_TACK_WITH_CIRCLE_ABOVE = 0x27DF;
const char32_t LOZENGE_DIVIDED_BY_HORIZONTAL_RULE = 0x27E0;
const char32_t WHITE_CONCAVE_SIDED_DIAMOND = 0x27E1;
const char32_t WHITE_CONCAVE_SIDED_DIAMOND_WITH_LEFTWARDS_TICK = 0x27E2;
const char32_t WHITE_CONCAVE_SIDED_DIAMOND_WITH_RIGHTWARDS_TICK = 0x27E3;
const char32_t WHITE_SQUARE_WITH_LEFTWARDS_TICK = 0x27E4;
const char32_t WHITE_SQUARE_WITH_RIGHTWARDS_TICK = 0x27E5;
const char32_t MATHEMATICAL_LEFT_WHITE_SQUARE_BRACKET = 0x27E6;
const char32_t MATHEMATICAL_RIGHT_WHITE_SQUARE_BRACKET = 0x27E7;
const char32_t MATHEMATICAL_LEFT_ANGLE_BRACKET = 0x27E8;
const char32_t MATHEMATICAL_RIGHT_ANGLE_BRACKET = 0x27E9;
const char32_t MATHEMATICAL_LEFT_DOUBLE_ANGLE_BRACKET = 0x27EA;
const char32_t MATHEMATICAL_RIGHT_DOUBLE_ANGLE_BRACKET = 0x27EB;
const char32_t MATHEMATICAL_LEFT_WHITE_TORTOISE_SHELL_BRACKET = 0x27EC;
const char32_t MATHEMATICAL_RIGHT_WHITE_TORTOISE_SHELL_BRACKET = 0x27ED;
const char32_t MATHEMATICAL_LEFT_FLATTENED_PARENTHESIS = 0x27EE;
const char32_t MATHEMATICAL_RIGHT_FLATTENED_PARENTHESIS = 0x27EF;
const char32_t UPWARDS_QUADRUPLE_ARROW = 0x27F0;
const char32_t DOWNWARDS_QUADRUPLE_ARROW = 0x27F1;
const char32_t ANTICLOCKWISE_GAPPED_CIRCLE_ARROW = 0x27F2;
const char32_t CLOCKWISE_GAPPED_CIRCLE_ARROW = 0x27F3;
const char32_t RIGHT_ARROW_WITH_CIRCLED_PLUS = 0x27F4;
const char32_t LONG_LEFTWARDS_ARROW = 0x27F5;
const char32_t LONG_RIGHTWARDS_ARROW = 0x27F6;
const char32_t LONG_LEFT_RIGHT_ARROW = 0x27F7;
const char32_t LONG_LEFTWARDS_DOUBLE_ARROW = 0x27F8;
const char32_t LONG_RIGHTWARDS_DOUBLE_ARROW = 0x27F9;
const char32_t LONG_LEFT_RIGHT_DOUBLE_ARROW = 0x27FA;
const char32_t LONG_LEFTWARDS_ARROW_FROM_BAR = 0x27FB;
const char32_t LONG_RIGHTWARDS_ARROW_FROM_BAR = 0x27FC;
const char32_t LONG_LEFTWARDS_DOUBLE_ARROW_FROM_BAR = 0x27FD;
const char32_t LONG_RIGHTWARDS_DOUBLE_ARROW_FROM_BAR = 0x27FE;
const char32_t LONG_RIGHTWARDS_SQUIGGLE_ARROW = 0x27FF;
const char32_t BRAILLE_PATTERN_BLANK = 0x2800;
const char32_t BRAILLE_PATTERN_DOTS_1 = 0x2801;
const char32_t BRAILLE_PATTERN_DOTS_2 = 0x2802;
const char32_t BRAILLE_PATTERN_DOTS_12 = 0x2803;
const char32_t BRAILLE_PATTERN_DOTS_3 = 0x2804;
const char32_t BRAILLE_PATTERN_DOTS_13 = 0x2805;
const char32_t BRAILLE_PATTERN_DOTS_23 = 0x2806;
const char32_t BRAILLE_PATTERN_DOTS_123 = 0x2807;
const char32_t BRAILLE_PATTERN_DOTS_4 = 0x2808;
const char32_t BRAILLE_PATTERN_DOTS_14 = 0x2809;
const char32_t BRAILLE_PATTERN_DOTS_24 = 0x280A;
const char32_t BRAILLE_PATTERN_DOTS_124 = 0x280B;
const char32_t BRAILLE_PATTERN_DOTS_34 = 0x280C;
const char32_t BRAILLE_PATTERN_DOTS_134 = 0x280D;
const char32_t BRAILLE_PATTERN_DOTS_234 = 0x280E;
const char32_t BRAILLE_PATTERN_DOTS_1234 = 0x280F;
const char32_t BRAILLE_PATTERN_DOTS_5 = 0x2810;
const char32_t BRAILLE_PATTERN_DOTS_15 = 0x2811;
const char32_t BRAILLE_PATTERN_DOTS_25 = 0x2812;
const char32_t BRAILLE_PATTERN_DOTS_125 = 0x2813;
const char32_t BRAILLE_PATTERN_DOTS_35 = 0x2814;
const char32_t BRAILLE_PATTERN_DOTS_135 = 0x2815;
const char32_t BRAILLE_PATTERN_DOTS_235 = 0x2816;
const char32_t BRAILLE_PATTERN_DOTS_1235 = 0x2817;
const char32_t BRAILLE_PATTERN_DOTS_45 = 0x2818;
const char32_t BRAILLE_PATTERN_DOTS_145 = 0x2819;
const char32_t BRAILLE_PATTERN_DOTS_245 = 0x281A;
const char32_t BRAILLE_PATTERN_DOTS_1245 = 0x281B;
const char32_t BRAILLE_PATTERN_DOTS_345 = 0x281C;
const char32_t BRAILLE_PATTERN_DOTS_1345 = 0x281D;
const char32_t BRAILLE_PATTERN_DOTS_2345 = 0x281E;
const char32_t BRAILLE_PATTERN_DOTS_12345 = 0x281F;
const char32_t BRAILLE_PATTERN_DOTS_6 = 0x2820;
const char32_t BRAILLE_PATTERN_DOTS_16 = 0x2821;
const char32_t BRAILLE_PATTERN_DOTS_26 = 0x2822;
const char32_t BRAILLE_PATTERN_DOTS_126 = 0x2823;
const char32_t BRAILLE_PATTERN_DOTS_36 = 0x2824;
const char32_t BRAILLE_PATTERN_DOTS_136 = 0x2825;
const char32_t BRAILLE_PATTERN_DOTS_236 = 0x2826;
const char32_t BRAILLE_PATTERN_DOTS_1236 = 0x2827;
const char32_t BRAILLE_PATTERN_DOTS_46 = 0x2828;
const char32_t BRAILLE_PATTERN_DOTS_146 = 0x2829;
const char32_t BRAILLE_PATTERN_DOTS_246 = 0x282A;
const char32_t BRAILLE_PATTERN_DOTS_1246 = 0x282B;
const char32_t BRAILLE_PATTERN_DOTS_346 = 0x282C;
const char32_t BRAILLE_PATTERN_DOTS_1346 = 0x282D;
const char32_t BRAILLE_PATTERN_DOTS_2346 = 0x282E;
const char32_t BRAILLE_PATTERN_DOTS_12346 = 0x282F;
const char32_t BRAILLE_PATTERN_DOTS_56 = 0x2830;
const char32_t BRAILLE_PATTERN_DOTS_156 = 0x2831;
const char32_t BRAILLE_PATTERN_DOTS_256 = 0x2832;
const char32_t BRAILLE_PATTERN_DOTS_1256 = 0x2833;
const char32_t BRAILLE_PATTERN_DOTS_356 = 0x2834;
const char32_t BRAILLE_PATTERN_DOTS_1356 = 0x2835;
const char32_t BRAILLE_PATTERN_DOTS_2356 = 0x2836;
const char32_t BRAILLE_PATTERN_DOTS_12356 = 0x2837;
const char32_t BRAILLE_PATTERN_DOTS_456 = 0x2838;
const char32_t BRAILLE_PATTERN_DOTS_1456 = 0x2839;
const char32_t BRAILLE_PATTERN_DOTS_2456 = 0x283A;
const char32_t BRAILLE_PATTERN_DOTS_12456 = 0x283B;
const char32_t BRAILLE_PATTERN_DOTS_3456 = 0x283C;
const char32_t BRAILLE_PATTERN_DOTS_13456 = 0x283D;
const char32_t BRAILLE_PATTERN_DOTS_23456 = 0x283E;
const char32_t BRAILLE_PATTERN_DOTS_123456 = 0x283F;
const char32_t BRAILLE_PATTERN_DOTS_7 = 0x2840;
const char32_t BRAILLE_PATTERN_DOTS_17 = 0x2841;
const char32_t BRAILLE_PATTERN_DOTS_27 = 0x2842;
const char32_t BRAILLE_PATTERN_DOTS_127 = 0x2843;
const char32_t BRAILLE_PATTERN_DOTS_37 = 0x2844;
const char32_t BRAILLE_PATTERN_DOTS_137 = 0x2845;
const char32_t BRAILLE_PATTERN_DOTS_237 = 0x2846;
const char32_t BRAILLE_PATTERN_DOTS_1237 = 0x2847;
const char32_t BRAILLE_PATTERN_DOTS_47 = 0x2848;
const char32_t BRAILLE_PATTERN_DOTS_147 = 0x2849;
const char32_t BRAILLE_PATTERN_DOTS_247 = 0x284A;
const char32_t BRAILLE_PATTERN_DOTS_1247 = 0x284B;
const char32_t BRAILLE_PATTERN_DOTS_347 = 0x284C;
const char32_t BRAILLE_PATTERN_DOTS_1347 = 0x284D;
const char32_t BRAILLE_PATTERN_DOTS_2347 = 0x284E;
const char32_t BRAILLE_PATTERN_DOTS_12347 = 0x284F;
const char32_t BRAILLE_PATTERN_DOTS_57 = 0x2850;
const char32_t BRAILLE_PATTERN_DOTS_157 = 0x2851;
const char32_t BRAILLE_PATTERN_DOTS_257 = 0x2852;
const char32_t BRAILLE_PATTERN_DOTS_1257 = 0x2853;
const char32_t BRAILLE_PATTERN_DOTS_357 = 0x2854;
const char32_t BRAILLE_PATTERN_DOTS_1357 = 0x2855;
const char32_t BRAILLE_PATTERN_DOTS_2357 = 0x2856;
const char32_t BRAILLE_PATTERN_DOTS_12357 = 0x2857;
const char32_t BRAILLE_PATTERN_DOTS_457 = 0x2858;
const char32_t BRAILLE_PATTERN_DOTS_1457 = 0x2859;
const char32_t BRAILLE_PATTERN_DOTS_2457 = 0x285A;
const char32_t BRAILLE_PATTERN_DOTS_12457 = 0x285B;
const char32_t BRAILLE_PATTERN_DOTS_3457 = 0x285C;
const char32_t BRAILLE_PATTERN_DOTS_13457 = 0x285D;
const char32_t BRAILLE_PATTERN_DOTS_23457 = 0x285E;
const char32_t BRAILLE_PATTERN_DOTS_123457 = 0x285F;
const char32_t BRAILLE_PATTERN_DOTS_67 = 0x2860;
const char32_t BRAILLE_PATTERN_DOTS_167 = 0x2861;
const char32_t BRAILLE_PATTERN_DOTS_267 = 0x2862;
const char32_t BRAILLE_PATTERN_DOTS_1267 = 0x2863;
const char32_t BRAILLE_PATTERN_DOTS_367 = 0x2864;
const char32_t BRAILLE_PATTERN_DOTS_1367 = 0x2865;
const char32_t BRAILLE_PATTERN_DOTS_2367 = 0x2866;
const char32_t BRAILLE_PATTERN_DOTS_12367 = 0x2867;
const char32_t BRAILLE_PATTERN_DOTS_467 = 0x2868;
const char32_t BRAILLE_PATTERN_DOTS_1467 = 0x2869;
const char32_t BRAILLE_PATTERN_DOTS_2467 = 0x286A;
const char32_t BRAILLE_PATTERN_DOTS_12467 = 0x286B;
const char32_t BRAILLE_PATTERN_DOTS_3467 = 0x286C;
const char32_t BRAILLE_PATTERN_DOTS_13467 = 0x286D;
const char32_t BRAILLE_PATTERN_DOTS_23467 = 0x286E;
const char32_t BRAILLE_PATTERN_DOTS_123467 = 0x286F;
const char32_t BRAILLE_PATTERN_DOTS_567 = 0x2870;
const char32_t BRAILLE_PATTERN_DOTS_1567 = 0x2871;
const char32_t BRAILLE_PATTERN_DOTS_2567 = 0x2872;
const char32_t BRAILLE_PATTERN_DOTS_12567 = 0x2873;
const char32_t BRAILLE_PATTERN_DOTS_3567 = 0x2874;
const char32_t BRAILLE_PATTERN_DOTS_13567 = 0x2875;
const char32_t BRAILLE_PATTERN_DOTS_23567 = 0x2876;
const char32_t BRAILLE_PATTERN_DOTS_123567 = 0x2877;
const char32_t BRAILLE_PATTERN_DOTS_4567 = 0x2878;
const char32_t BRAILLE_PATTERN_DOTS_14567 = 0x2879;
const char32_t BRAILLE_PATTERN_DOTS_24567 = 0x287A;
const char32_t BRAILLE_PATTERN_DOTS_124567 = 0x287B;
const char32_t BRAILLE_PATTERN_DOTS_34567 = 0x287C;
const char32_t BRAILLE_PATTERN_DOTS_134567 = 0x287D;
const char32_t BRAILLE_PATTERN_DOTS_234567 = 0x287E;
const char32_t BRAILLE_PATTERN_DOTS_1234567 = 0x287F;
const char32_t BRAILLE_PATTERN_DOTS_8 = 0x2880;
const char32_t BRAILLE_PATTERN_DOTS_18 = 0x2881;
const char32_t BRAILLE_PATTERN_DOTS_28 = 0x2882;
const char32_t BRAILLE_PATTERN_DOTS_128 = 0x2883;
const char32_t BRAILLE_PATTERN_DOTS_38 = 0x2884;
const char32_t BRAILLE_PATTERN_DOTS_138 = 0x2885;
const char32_t BRAILLE_PATTERN_DOTS_238 = 0x2886;
const char32_t BRAILLE_PATTERN_DOTS_1238 = 0x2887;
const char32_t BRAILLE_PATTERN_DOTS_48 = 0x2888;
const char32_t BRAILLE_PATTERN_DOTS_148 = 0x2889;
const char32_t BRAILLE_PATTERN_DOTS_248 = 0x288A;
const char32_t BRAILLE_PATTERN_DOTS_1248 = 0x288B;
const char32_t BRAILLE_PATTERN_DOTS_348 = 0x288C;
const char32_t BRAILLE_PATTERN_DOTS_1348 = 0x288D;
const char32_t BRAILLE_PATTERN_DOTS_2348 = 0x288E;
const char32_t BRAILLE_PATTERN_DOTS_12348 = 0x288F;
const char32_t BRAILLE_PATTERN_DOTS_58 = 0x2890;
const char32_t BRAILLE_PATTERN_DOTS_158 = 0x2891;
const char32_t BRAILLE_PATTERN_DOTS_258 = 0x2892;
const char32_t BRAILLE_PATTERN_DOTS_1258 = 0x2893;
const char32_t BRAILLE_PATTERN_DOTS_358 = 0x2894;
const char32_t BRAILLE_PATTERN_DOTS_1358 = 0x2895;
const char32_t BRAILLE_PATTERN_DOTS_2358 = 0x2896;
const char32_t BRAILLE_PATTERN_DOTS_12358 = 0x2897;
const char32_t BRAILLE_PATTERN_DOTS_458 = 0x2898;
const char32_t BRAILLE_PATTERN_DOTS_1458 = 0x2899;
const char32_t BRAILLE_PATTERN_DOTS_2458 = 0x289A;
const char32_t BRAILLE_PATTERN_DOTS_12458 = 0x289B;
const char32_t BRAILLE_PATTERN_DOTS_3458 = 0x289C;
const char32_t BRAILLE_PATTERN_DOTS_13458 = 0x289D;
const char32_t BRAILLE_PATTERN_DOTS_23458 = 0x289E;
const char32_t BRAILLE_PATTERN_DOTS_123458 = 0x289F;
const char32_t BRAILLE_PATTERN_DOTS_68 = 0x28A0;
const char32_t BRAILLE_PATTERN_DOTS_168 = 0x28A1;
const char32_t BRAILLE_PATTERN_DOTS_268 = 0x28A2;
const char32_t BRAILLE_PATTERN_DOTS_1268 = 0x28A3;
const char32_t BRAILLE_PATTERN_DOTS_368 = 0x28A4;
const char32_t BRAILLE_PATTERN_DOTS_1368 = 0x28A5;
const char32_t BRAILLE_PATTERN_DOTS_2368 = 0x28A6;
const char32_t BRAILLE_PATTERN_DOTS_12368 = 0x28A7;
const char32_t BRAILLE_PATTERN_DOTS_468 = 0x28A8;
const char32_t BRAILLE_PATTERN_DOTS_1468 = 0x28A9;
const char32_t BRAILLE_PATTERN_DOTS_2468 = 0x28AA;
const char32_t BRAILLE_PATTERN_DOTS_12468 = 0x28AB;
const char32_t BRAILLE_PATTERN_DOTS_3468 = 0x28AC;
const char32_t BRAILLE_PATTERN_DOTS_13468 = 0x28AD;
const char32_t BRAILLE_PATTERN_DOTS_23468 = 0x28AE;
const char32_t BRAILLE_PATTERN_DOTS_123468 = 0x28AF;
const char32_t BRAILLE_PATTERN_DOTS_568 = 0x28B0;
const char32_t BRAILLE_PATTERN_DOTS_1568 = 0x28B1;
const char32_t BRAILLE_PATTERN_DOTS_2568 = 0x28B2;
const char32_t BRAILLE_PATTERN_DOTS_12568 = 0x28B3;
const char32_t BRAILLE_PATTERN_DOTS_3568 = 0x28B4;
const char32_t BRAILLE_PATTERN_DOTS_13568 = 0x28B5;
const char32_t BRAILLE_PATTERN_DOTS_23568 = 0x28B6;
const char32_t BRAILLE_PATTERN_DOTS_123568 = 0x28B7;
const char32_t BRAILLE_PATTERN_DOTS_4568 = 0x28B8;
const char32_t BRAILLE_PATTERN_DOTS_14568 = 0x28B9;
const char32_t BRAILLE_PATTERN_DOTS_24568 = 0x28BA;
const char32_t BRAILLE_PATTERN_DOTS_124568 = 0x28BB;
const char32_t BRAILLE_PATTERN_DOTS_34568 = 0x28BC;
const char32_t BRAILLE_PATTERN_DOTS_134568 = 0x28BD;
const char32_t BRAILLE_PATTERN_DOTS_234568 = 0x28BE;
const char32_t BRAILLE_PATTERN_DOTS_1234568 = 0x28BF;
const char32_t BRAILLE_PATTERN_DOTS_78 = 0x28C0;
const char32_t BRAILLE_PATTERN_DOTS_178 = 0x28C1;
const char32_t BRAILLE_PATTERN_DOTS_278 = 0x28C2;
const char32_t BRAILLE_PATTERN_DOTS_1278 = 0x28C3;
const char32_t BRAILLE_PATTERN_DOTS_378 = 0x28C4;
const char32_t BRAILLE_PATTERN_DOTS_1378 = 0x28C5;
const char32_t BRAILLE_PATTERN_DOTS_2378 = 0x28C6;
const char32_t BRAILLE_PATTERN_DOTS_12378 = 0x28C7;
const char32_t BRAILLE_PATTERN_DOTS_478 = 0x28C8;
const char32_t BRAILLE_PATTERN_DOTS_1478 = 0x28C9;
const char32_t BRAILLE_PATTERN_DOTS_2478 = 0x28CA;
const char32_t BRAILLE_PATTERN_DOTS_12478 = 0x28CB;
const char32_t BRAILLE_PATTERN_DOTS_3478 = 0x28CC;
const char32_t BRAILLE_PATTERN_DOTS_13478 = 0x28CD;
const char32_t BRAILLE_PATTERN_DOTS_23478 = 0x28CE;
const char32_t BRAILLE_PATTERN_DOTS_123478 = 0x28CF;
const char32_t BRAILLE_PATTERN_DOTS_578 = 0x28D0;
const char32_t BRAILLE_PATTERN_DOTS_1578 = 0x28D1;
const char32_t BRAILLE_PATTERN_DOTS_2578 = 0x28D2;
const char32_t BRAILLE_PATTERN_DOTS_12578 = 0x28D3;
const char32_t BRAILLE_PATTERN_DOTS_3578 = 0x28D4;
const char32_t BRAILLE_PATTERN_DOTS_13578 = 0x28D5;
const char32_t BRAILLE_PATTERN_DOTS_23578 = 0x28D6;
const char32_t BRAILLE_PATTERN_DOTS_123578 = 0x28D7;
const char32_t BRAILLE_PATTERN_DOTS_4578 = 0x28D8;
const char32_t BRAILLE_PATTERN_DOTS_14578 = 0x28D9;
const char32_t BRAILLE_PATTERN_DOTS_24578 = 0x28DA;
const char32_t BRAILLE_PATTERN_DOTS_124578 = 0x28DB;
const char32_t BRAILLE_PATTERN_DOTS_34578 = 0x28DC;
const char32_t BRAILLE_PATTERN_DOTS_134578 = 0x28DD;
const char32_t BRAILLE_PATTERN_DOTS_234578 = 0x28DE;
const char32_t BRAILLE_PATTERN_DOTS_1234578 = 0x28DF;
const char32_t BRAILLE_PATTERN_DOTS_678 = 0x28E0;
const char32_t BRAILLE_PATTERN_DOTS_1678 = 0x28E1;
const char32_t BRAILLE_PATTERN_DOTS_2678 = 0x28E2;
const char32_t BRAILLE_PATTERN_DOTS_12678 = 0x28E3;
const char32_t BRAILLE_PATTERN_DOTS_3678 = 0x28E4;
const char32_t BRAILLE_PATTERN_DOTS_13678 = 0x28E5;
const char32_t BRAILLE_PATTERN_DOTS_23678 = 0x28E6;
const char32_t BRAILLE_PATTERN_DOTS_123678 = 0x28E7;
const char32_t BRAILLE_PATTERN_DOTS_4678 = 0x28E8;
const char32_t BRAILLE_PATTERN_DOTS_14678 = 0x28E9;
const char32_t BRAILLE_PATTERN_DOTS_24678 = 0x28EA;
const char32_t BRAILLE_PATTERN_DOTS_124678 = 0x28EB;
const char32_t BRAILLE_PATTERN_DOTS_34678 = 0x28EC;
const char32_t BRAILLE_PATTERN_DOTS_134678 = 0x28ED;
const char32_t BRAILLE_PATTERN_DOTS_234678 = 0x28EE;
const char32_t BRAILLE_PATTERN_DOTS_1234678 = 0x28EF;
const char32_t BRAILLE_PATTERN_DOTS_5678 = 0x28F0;
const char32_t BRAILLE_PATTERN_DOTS_15678 = 0x28F1;
const char32_t BRAILLE_PATTERN_DOTS_25678 = 0x28F2;
const char32_t BRAILLE_PATTERN_DOTS_125678 = 0x28F3;
const char32_t BRAILLE_PATTERN_DOTS_35678 = 0x28F4;
const char32_t BRAILLE_PATTERN_DOTS_135678 = 0x28F5;
const char32_t BRAILLE_PATTERN_DOTS_235678 = 0x28F6;
const char32_t BRAILLE_PATTERN_DOTS_1235678 = 0x28F7;
const char32_t BRAILLE_PATTERN_DOTS_45678 = 0x28F8;
const char32_t BRAILLE_PATTERN_DOTS_145678 = 0x28F9;
const char32_t BRAILLE_PATTERN_DOTS_245678 = 0x28FA;
const char32_t BRAILLE_PATTERN_DOTS_1245678 = 0x28FB;
const char32_t BRAILLE_PATTERN_DOTS_345678 = 0x28FC;
const char32_t BRAILLE_PATTERN_DOTS_1345678 = 0x28FD;
const char32_t BRAILLE_PATTERN_DOTS_2345678 = 0x28FE;
const char32_t BRAILLE_PATTERN_DOTS_12345678 = 0x28FF;
const char32_t RIGHTWARDS_TWO_HEADED_ARROW_WITH_VERTICAL_STROKE = 0x2900;
const char32_t RIGHTWARDS_TWO_HEADED_ARROW_WITH_DOUBLE_VERTICAL_STROKE = 0x2901;
const char32_t LEFTWARDS_DOUBLE_ARROW_WITH_VERTICAL_STROKE = 0x2902;
const char32_t RIGHTWARDS_DOUBLE_ARROW_WITH_VERTICAL_STROKE = 0x2903;
const char32_t LEFT_RIGHT_DOUBLE_ARROW_WITH_VERTICAL_STROKE = 0x2904;
const char32_t RIGHTWARDS_TWO_HEADED_ARROW_FROM_BAR = 0x2905;
const char32_t LEFTWARDS_DOUBLE_ARROW_FROM_BAR = 0x2906;
const char32_t RIGHTWARDS_DOUBLE_ARROW_FROM_BAR = 0x2907;
const char32_t DOWNWARDS_ARROW_WITH_HORIZONTAL_STROKE = 0x2908;
const char32_t UPWARDS_ARROW_WITH_HORIZONTAL_STROKE = 0x2909;
const char32_t UPWARDS_TRIPLE_ARROW = 0x290A;
const char32_t DOWNWARDS_TRIPLE_ARROW = 0x290B;
const char32_t LEFTWARDS_DOUBLE_DASH_ARROW = 0x290C;
const char32_t RIGHTWARDS_DOUBLE_DASH_ARROW = 0x290D;
const char32_t LEFTWARDS_TRIPLE_DASH_ARROW = 0x290E;
const char32_t RIGHTWARDS_TRIPLE_DASH_ARROW = 0x290F;
const char32_t RIGHTWARDS_TWO_HEADED_TRIPLE_DASH_ARROW = 0x2910;
const char32_t RIGHTWARDS_ARROW_WITH_DOTTED_STEM = 0x2911;
const char32_t UPWARDS_ARROW_TO_BAR = 0x2912;
const char32_t DOWNWARDS_ARROW_TO_BAR = 0x2913;
const char32_t RIGHTWARDS_ARROW_WITH_TAIL_WITH_VERTICAL_STROKE = 0x2914;
const char32_t RIGHTWARDS_ARROW_WITH_TAIL_WITH_DOUBLE_VERTICAL_STROKE = 0x2915;
const char32_t RIGHTWARDS_TWO_HEADED_ARROW_WITH_TAIL = 0x2916;
const char32_t RIGHTWARDS_TWO_HEADED_ARROW_WITH_TAIL_WITH_VERTICAL_STROKE = 0x2917;
const char32_t RIGHTWARDS_TWO_HEADED_ARROW_WITH_TAIL_WITH_DOUBLE_VERTICAL_STROKE = 0x2918;
const char32_t LEFTWARDS_ARROW_TAIL = 0x2919;
const char32_t RIGHTWARDS_ARROW_TAIL = 0x291A;
const char32_t LEFTWARDS_DOUBLE_ARROW_TAIL = 0x291B;
const char32_t RIGHTWARDS_DOUBLE_ARROW_TAIL = 0x291C;
const char32_t LEFTWARDS_ARROW_TO_BLACK_DIAMOND = 0x291D;
const char32_t RIGHTWARDS_ARROW_TO_BLACK_DIAMOND = 0x291E;
const char32_t LEFTWARDS_ARROW_FROM_BAR_TO_BLACK_DIAMOND = 0x291F;
const char32_t RIGHTWARDS_ARROW_FROM_BAR_TO_BLACK_DIAMOND = 0x2920;
const char32_t NORTH_WEST_AND_SOUTH_EAST_ARROW = 0x2921;
const char32_t NORTH_EAST_AND_SOUTH_WEST_ARROW = 0x2922;
const char32_t NORTH_WEST_ARROW_WITH_HOOK = 0x2923;
const char32_t NORTH_EAST_ARROW_WITH_HOOK = 0x2924;
const char32_t SOUTH_EAST_ARROW_WITH_HOOK = 0x2925;
const char32_t SOUTH_WEST_ARROW_WITH_HOOK = 0x2926;
const char32_t NORTH_WEST_ARROW_AND_NORTH_EAST_ARROW = 0x2927;
const char32_t NORTH_EAST_ARROW_AND_SOUTH_EAST_ARROW = 0x2928;
const char32_t SOUTH_EAST_ARROW_AND_SOUTH_WEST_ARROW = 0x2929;
const char32_t SOUTH_WEST_ARROW_AND_NORTH_WEST_ARROW = 0x292A;
const char32_t RISING_DIAGONAL_CROSSING_FALLING_DIAGONAL = 0x292B;
const char32_t FALLING_DIAGONAL_CROSSING_RISING_DIAGONAL = 0x292C;
const char32_t SOUTH_EAST_ARROW_CROSSING_NORTH_EAST_ARROW = 0x292D;
const char32_t NORTH_EAST_ARROW_CROSSING_SOUTH_EAST_ARROW = 0x292E;
const char32_t FALLING_DIAGONAL_CROSSING_NORTH_EAST_ARROW = 0x292F;
const char32_t RISING_DIAGONAL_CROSSING_SOUTH_EAST_ARROW = 0x2930;
const char32_t NORTH_EAST_ARROW_CROSSING_NORTH_WEST_ARROW = 0x2931;
const char32_t NORTH_WEST_ARROW_CROSSING_NORTH_EAST_ARROW = 0x2932;
const char32_t WAVE_ARROW_POINTING_DIRECTLY_RIGHT = 0x2933;
const char32_t ARROW_POINTING_RIGHTWARDS_THEN_CURVING_UPWARDS = 0x2934;
const char32_t ARROW_POINTING_RIGHTWARDS_THEN_CURVING_DOWNWARDS = 0x2935;
const char32_t ARROW_POINTING_DOWNWARDS_THEN_CURVING_LEFTWARDS = 0x2936;
const char32_t ARROW_POINTING_DOWNWARDS_THEN_CURVING_RIGHTWARDS = 0x2937;
const char32_t RIGHT_SIDE_ARC_CLOCKWISE_ARROW = 0x2938;
const char32_t LEFT_SIDE_ARC_ANTICLOCKWISE_ARROW = 0x2939;
const char32_t TOP_ARC_ANTICLOCKWISE_ARROW = 0x293A;
const char32_t BOTTOM_ARC_ANTICLOCKWISE_ARROW = 0x293B;
const char32_t TOP_ARC_CLOCKWISE_ARROW_WITH_MINUS = 0x293C;
const char32_t TOP_ARC_ANTICLOCKWISE_ARROW_WITH_PLUS = 0x293D;
const char32_t LOWER_RIGHT_SEMICIRCULAR_CLOCKWISE_ARROW = 0x293E;
const char32_t LOWER_LEFT_SEMICIRCULAR_ANTICLOCKWISE_ARROW = 0x293F;
const char32_t ANTICLOCKWISE_CLOSED_CIRCLE_ARROW = 0x2940;
const char32_t CLOCKWISE_CLOSED_CIRCLE_ARROW = 0x2941;
const char32_t RIGHTWARDS_ARROW_ABOVE_SHORT_LEFTWARDS_ARROW = 0x2942;
const char32_t LEFTWARDS_ARROW_ABOVE_SHORT_RIGHTWARDS_ARROW = 0x2943;
const char32_t SHORT_RIGHTWARDS_ARROW_ABOVE_LEFTWARDS_ARROW = 0x2944;
const char32_t RIGHTWARDS_ARROW_WITH_PLUS_BELOW = 0x2945;
const char32_t LEFTWARDS_ARROW_WITH_PLUS_BELOW = 0x2946;
const char32_t RIGHTWARDS_ARROW_THROUGH_X = 0x2947;
const char32_t LEFT_RIGHT_ARROW_THROUGH_SMALL_CIRCLE = 0x2948;
const char32_t UPWARDS_TWO_HEADED_ARROW_FROM_SMALL_CIRCLE = 0x2949;
const char32_t LEFT_BARB_UP_RIGHT_BARB_DOWN_HARPOON = 0x294A;
const char32_t LEFT_BARB_DOWN_RIGHT_BARB_UP_HARPOON = 0x294B;
const char32_t UP_BARB_RIGHT_DOWN_BARB_LEFT_HARPOON = 0x294C;
const char32_t UP_BARB_LEFT_DOWN_BARB_RIGHT_HARPOON = 0x294D;
const char32_t LEFT_BARB_UP_RIGHT_BARB_UP_HARPOON = 0x294E;
const char32_t UP_BARB_RIGHT_DOWN_BARB_RIGHT_HARPOON = 0x294F;
const char32_t LEFT_BARB_DOWN_RIGHT_BARB_DOWN_HARPOON = 0x2950;
const char32_t UP_BARB_LEFT_DOWN_BARB_LEFT_HARPOON = 0x2951;
const char32_t LEFTWARDS_HARPOON_WITH_BARB_UP_TO_BAR = 0x2952;
const char32_t RIGHTWARDS_HARPOON_WITH_BARB_UP_TO_BAR = 0x2953;
const char32_t UPWARDS_HARPOON_WITH_BARB_RIGHT_TO_BAR = 0x2954;
const char32_t DOWNWARDS_HARPOON_WITH_BARB_RIGHT_TO_BAR = 0x2955;
const char32_t LEFTWARDS_HARPOON_WITH_BARB_DOWN_TO_BAR = 0x2956;
const char32_t RIGHTWARDS_HARPOON_WITH_BARB_DOWN_TO_BAR = 0x2957;
const char32_t UPWARDS_HARPOON_WITH_BARB_LEFT_TO_BAR = 0x2958;
const char32_t DOWNWARDS_HARPOON_WITH_BARB_LEFT_TO_BAR = 0x2959;
const char32_t LEFTWARDS_HARPOON_WITH_BARB_UP_FROM_BAR = 0x295A;
const char32_t RIGHTWARDS_HARPOON_WITH_BARB_UP_FROM_BAR = 0x295B;
const char32_t UPWARDS_HARPOON_WITH_BARB_RIGHT_FROM_BAR = 0x295C;
const char32_t DOWNWARDS_HARPOON_WITH_BARB_RIGHT_FROM_BAR = 0x295D;
const char32_t LEFTWARDS_HARPOON_WITH_BARB_DOWN_FROM_BAR = 0x295E;
const char32_t RIGHTWARDS_HARPOON_WITH_BARB_DOWN_FROM_BAR = 0x295F;
const char32_t UPWARDS_HARPOON_WITH_BARB_LEFT_FROM_BAR = 0x2960;
const char32_t DOWNWARDS_HARPOON_WITH_BARB_LEFT_FROM_BAR = 0x2961;
const char32_t LEFTWARDS_HARPOON_WITH_BARB_UP_ABOVE_LEFTWARDS_HARPOON_WITH_BARB_DOWN = 0x2962;
const char32_t UPWARDS_HARPOON_WITH_BARB_LEFT_BESIDE_UPWARDS_HARPOON_WITH_BARB_RIGHT = 0x2963;
const char32_t RIGHTWARDS_HARPOON_WITH_BARB_UP_ABOVE_RIGHTWARDS_HARPOON_WITH_BARB_DOWN = 0x2964;
const char32_t DOWNWARDS_HARPOON_WITH_BARB_LEFT_BESIDE_DOWNWARDS_HARPOON_WITH_BARB_RIGHT = 0x2965;
const char32_t LEFTWARDS_HARPOON_WITH_BARB_UP_ABOVE_RIGHTWARDS_HARPOON_WITH_BARB_UP = 0x2966;
const char32_t LEFTWARDS_HARPOON_WITH_BARB_DOWN_ABOVE_RIGHTWARDS_HARPOON_WITH_BARB_DOWN = 0x2967;
const char32_t RIGHTWARDS_HARPOON_WITH_BARB_UP_ABOVE_LEFTWARDS_HARPOON_WITH_BARB_UP = 0x2968;
const char32_t RIGHTWARDS_HARPOON_WITH_BARB_DOWN_ABOVE_LEFTWARDS_HARPOON_WITH_BARB_DOWN = 0x2969;
const char32_t LEFTWARDS_HARPOON_WITH_BARB_UP_ABOVE_LONG_DASH = 0x296A;
const char32_t LEFTWARDS_HARPOON_WITH_BARB_DOWN_BELOW_LONG_DASH = 0x296B;
const char32_t RIGHTWARDS_HARPOON_WITH_BARB_UP_ABOVE_LONG_DASH = 0x296C;
const char32_t RIGHTWARDS_HARPOON_WITH_BARB_DOWN_BELOW_LONG_DASH = 0x296D;
const char32_t UPWARDS_HARPOON_WITH_BARB_LEFT_BESIDE_DOWNWARDS_HARPOON_WITH_BARB_RIGHT = 0x296E;
const char32_t DOWNWARDS_HARPOON_WITH_BARB_LEFT_BESIDE_UPWARDS_HARPOON_WITH_BARB_RIGHT = 0x296F;
const char32_t RIGHT_DOUBLE_ARROW_WITH_ROUNDED_HEAD = 0x2970;
const char32_t EQUALS_SIGN_ABOVE_RIGHTWARDS_ARROW = 0x2971;
const char32_t TILDE_OPERATOR_ABOVE_RIGHTWARDS_ARROW = 0x2972;
const char32_t LEFTWARDS_ARROW_ABOVE_TILDE_OPERATOR = 0x2973;
const char32_t RIGHTWARDS_ARROW_ABOVE_TILDE_OPERATOR = 0x2974;
const char32_t RIGHTWARDS_ARROW_ABOVE_ALMOST_EQUAL_TO = 0x2975;
const char32_t LESS_THAN_ABOVE_LEFTWARDS_ARROW = 0x2976;
const char32_t LEFTWARDS_ARROW_THROUGH_LESS_THAN = 0x2977;
const char32_t GREATER_THAN_ABOVE_RIGHTWARDS_ARROW = 0x2978;
const char32_t SUBSET_ABOVE_RIGHTWARDS_ARROW = 0x2979;
const char32_t LEFTWARDS_ARROW_THROUGH_SUBSET = 0x297A;
const char32_t SUPERSET_ABOVE_LEFTWARDS_ARROW = 0x297B;
const char32_t LEFT_FISH_TAIL = 0x297C;
const char32_t RIGHT_FISH_TAIL = 0x297D;
const char32_t UP_FISH_TAIL = 0x297E;
const char32_t DOWN_FISH_TAIL = 0x297F;
const char32_t TRIPLE_VERTICAL_BAR_DELIMITER = 0x2980;
const char32_t Z_NOTATION_SPOT = 0x2981;
const char32_t Z_NOTATION_TYPE_COLON = 0x2982;
const char32_t LEFT_WHITE_CURLY_BRACKET = 0x2983;
const char32_t RIGHT_WHITE_CURLY_BRACKET = 0x2984;
const char32_t LEFT_WHITE_PARENTHESIS = 0x2985;
const char32_t RIGHT_WHITE_PARENTHESIS = 0x2986;
const char32_t Z_NOTATION_LEFT_IMAGE_BRACKET = 0x2987;
const char32_t Z_NOTATION_RIGHT_IMAGE_BRACKET = 0x2988;
const char32_t Z_NOTATION_LEFT_BINDING_BRACKET = 0x2989;
const char32_t Z_NOTATION_RIGHT_BINDING_BRACKET = 0x298A;
const char32_t LEFT_SQUARE_BRACKET_WITH_UNDERBAR = 0x298B;
const char32_t RIGHT_SQUARE_BRACKET_WITH_UNDERBAR = 0x298C;
const char32_t LEFT_SQUARE_BRACKET_WITH_TICK_IN_TOP_CORNER = 0x298D;
const char32_t RIGHT_SQUARE_BRACKET_WITH_TICK_IN_BOTTOM_CORNER = 0x298E;
const char32_t LEFT_SQUARE_BRACKET_WITH_TICK_IN_BOTTOM_CORNER = 0x298F;
const char32_t RIGHT_SQUARE_BRACKET_WITH_TICK_IN_TOP_CORNER = 0x2990;
const char32_t LEFT_ANGLE_BRACKET_WITH_DOT = 0x2991;
const char32_t RIGHT_ANGLE_BRACKET_WITH_DOT = 0x2992;
const char32_t LEFT_ARC_LESS_THAN_BRACKET = 0x2993;
const char32_t RIGHT_ARC_GREATER_THAN_BRACKET = 0x2994;
const char32_t DOUBLE_LEFT_ARC_GREATER_THAN_BRACKET = 0x2995;
const char32_t DOUBLE_RIGHT_ARC_LESS_THAN_BRACKET = 0x2996;
const char32_t LEFT_BLACK_TORTOISE_SHELL_BRACKET = 0x2997;
const char32_t RIGHT_BLACK_TORTOISE_SHELL_BRACKET = 0x2998;
const char32_t DOTTED_FENCE = 0x2999;
const char32_t VERTICAL_ZIGZAG_LINE = 0x299A;
const char32_t MEASURED_ANGLE_OPENING_LEFT = 0x299B;
const char32_t RIGHT_ANGLE_VARIANT_WITH_SQUARE = 0x299C;
const char32_t MEASURED_RIGHT_ANGLE_WITH_DOT = 0x299D;
const char32_t ANGLE_WITH_S_INSIDE = 0x299E;
const char32_t ACUTE_ANGLE = 0x299F;
const char32_t SPHERICAL_ANGLE_OPENING_LEFT = 0x29A0;
const char32_t SPHERICAL_ANGLE_OPENING_UP = 0x29A1;
const char32_t TURNED_ANGLE = 0x29A2;
const char32_t REVERSED_ANGLE = 0x29A3;
const char32_t ANGLE_WITH_UNDERBAR = 0x29A4;
const char32_t REVERSED_ANGLE_WITH_UNDERBAR = 0x29A5;
const char32_t OBLIQUE_ANGLE_OPENING_UP = 0x29A6;
const char32_t OBLIQUE_ANGLE_OPENING_DOWN = 0x29A7;
const char32_t MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_UP_AND_RIGHT = 0x29A8;
const char32_t MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_UP_AND_LEFT = 0x29A9;
const char32_t MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_DOWN_AND_RIGHT = 0x29AA;
const char32_t MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_DOWN_AND_LEFT = 0x29AB;
const char32_t MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_RIGHT_AND_UP = 0x29AC;
const char32_t MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_LEFT_AND_UP = 0x29AD;
const char32_t MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_RIGHT_AND_DOWN = 0x29AE;
const char32_t MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_LEFT_AND_DOWN = 0x29AF;
const char32_t REVERSED_EMPTY_SET = 0x29B0;
const char32_t EMPTY_SET_WITH_OVERBAR = 0x29B1;
const char32_t EMPTY_SET_WITH_SMALL_CIRCLE_ABOVE = 0x29B2;
const char32_t EMPTY_SET_WITH_RIGHT_ARROW_ABOVE = 0x29B3;
const char32_t EMPTY_SET_WITH_LEFT_ARROW_ABOVE = 0x29B4;
const char32_t CIRCLE_WITH_HORIZONTAL_BAR = 0x29B5;
const char32_t CIRCLED_VERTICAL_BAR = 0x29B6;
const char32_t CIRCLED_PARALLEL = 0x29B7;
const char32_t CIRCLED_REVERSE_SOLIDUS = 0x29B8;
const char32_t CIRCLED_PERPENDICULAR = 0x29B9;
const char32_t CIRCLE_DIVIDED_BY_HORIZONTAL_BAR_AND_TOP_HALF_DIVIDED_BY_VERTICAL_BAR = 0x29BA;
const char32_t CIRCLE_WITH_SUPERIMPOSED_X = 0x29BB;
const char32_t CIRCLED_ANTICLOCKWISE_ROTATED_DIVISION_SIGN = 0x29BC;
const char32_t UP_ARROW_THROUGH_CIRCLE = 0x29BD;
const char32_t CIRCLED_WHITE_BULLET = 0x29BE;
const char32_t CIRCLED_BULLET = 0x29BF;
const char32_t CIRCLED_LESS_THAN = 0x29C0;
const char32_t CIRCLED_GREATER_THAN = 0x29C1;
const char32_t CIRCLE_WITH_SMALL_CIRCLE_TO_THE_RIGHT = 0x29C2;
const char32_t CIRCLE_WITH_TWO_HORIZONTAL_STROKES_TO_THE_RIGHT = 0x29C3;
const char32_t SQUARED_RISING_DIAGONAL_SLASH = 0x29C4;
const char32_t SQUARED_FALLING_DIAGONAL_SLASH = 0x29C5;
const char32_t SQUARED_ASTERISK = 0x29C6;
const char32_t SQUARED_SMALL_CIRCLE = 0x29C7;
const char32_t SQUARED_SQUARE = 0x29C8;
const char32_t TWO_JOINED_SQUARES = 0x29C9;
const char32_t TRIANGLE_WITH_DOT_ABOVE = 0x29CA;
const char32_t TRIANGLE_WITH_UNDERBAR = 0x29CB;
const char32_t S_IN_TRIANGLE = 0x29CC;
const char32_t TRIANGLE_WITH_SERIFS_AT_BOTTOM = 0x29CD;
const char32_t RIGHT_TRIANGLE_ABOVE_LEFT_TRIANGLE = 0x29CE;
const char32_t LEFT_TRIANGLE_BESIDE_VERTICAL_BAR = 0x29CF;
const char32_t VERTICAL_BAR_BESIDE_RIGHT_TRIANGLE = 0x29D0;
const char32_t BOWTIE_WITH_LEFT_HALF_BLACK = 0x29D1;
const char32_t BOWTIE_WITH_RIGHT_HALF_BLACK = 0x29D2;
const char32_t BLACK_BOWTIE = 0x29D3;
const char32_t TIMES_WITH_LEFT_HALF_BLACK = 0x29D4;
const char32_t TIMES_WITH_RIGHT_HALF_BLACK = 0x29D5;
const char32_t WHITE_HOURGLASS = 0x29D6;
const char32_t BLACK_HOURGLASS = 0x29D7;
const char32_t LEFT_WIGGLY_FENCE = 0x29D8;
const char32_t RIGHT_WIGGLY_FENCE = 0x29D9;
const char32_t LEFT_DOUBLE_WIGGLY_FENCE = 0x29DA;
const char32_t RIGHT_DOUBLE_WIGGLY_FENCE = 0x29DB;
const char32_t INCOMPLETE_INFINITY = 0x29DC;
const char32_t TIE_OVER_INFINITY = 0x29DD;
const char32_t INFINITY_NEGATED_WITH_VERTICAL_BAR = 0x29DE;
const char32_t DOUBLE_ENDED_MULTIMAP = 0x29DF;
const char32_t SQUARE_WITH_CONTOURED_OUTLINE = 0x29E0;
const char32_t INCREASES_AS = 0x29E1;
const char32_t SHUFFLE_PRODUCT = 0x29E2;
const char32_t EQUALS_SIGN_AND_SLANTED_PARALLEL = 0x29E3;
const char32_t EQUALS_SIGN_AND_SLANTED_PARALLEL_WITH_TILDE_ABOVE = 0x29E4;
const char32_t IDENTICAL_TO_AND_SLANTED_PARALLEL = 0x29E5;
const char32_t GLEICH_STARK = 0x29E6;
const char32_t THERMODYNAMIC = 0x29E7;
const char32_t DOWN_POINTING_TRIANGLE_WITH_LEFT_HALF_BLACK = 0x29E8;
const char32_t DOWN_POINTING_TRIANGLE_WITH_RIGHT_HALF_BLACK = 0x29E9;
const char32_t BLACK_DIAMOND_WITH_DOWN_ARROW = 0x29EA;
const char32_t BLACK_LOZENGE = 0x29EB;
const char32_t WHITE_CIRCLE_WITH_DOWN_ARROW = 0x29EC;
const char32_t BLACK_CIRCLE_WITH_DOWN_ARROW = 0x29ED;
const char32_t ERROR_BARRED_WHITE_SQUARE = 0x29EE;
const char32_t ERROR_BARRED_BLACK_SQUARE = 0x29EF;
const char32_t ERROR_BARRED_WHITE_DIAMOND = 0x29F0;
const char32_t ERROR_BARRED_BLACK_DIAMOND = 0x29F1;
const char32_t ERROR_BARRED_WHITE_CIRCLE = 0x29F2;
const char32_t ERROR_BARRED_BLACK_CIRCLE = 0x29F3;
const char32_t RULE_DELAYED = 0x29F4;
const char32_t REVERSE_SOLIDUS_OPERATOR = 0x29F5;
const char32_t SOLIDUS_WITH_OVERBAR = 0x29F6;
const char32_t REVERSE_SOLIDUS_WITH_HORIZONTAL_STROKE = 0x29F7;
const char32_t BIG_SOLIDUS = 0x29F8;
const char32_t BIG_REVERSE_SOLIDUS = 0x29F9;
const char32_t DOUBLE_PLUS = 0x29FA;
const char32_t TRIPLE_PLUS = 0x29FB;
const char32_t LEFT_POINTING_CURVED_ANGLE_BRACKET = 0x29FC;
const char32_t RIGHT_POINTING_CURVED_ANGLE_BRACKET = 0x29FD;
const char32_t TINY = 0x29FE;
const char32_t MINY = 0x29FF;
const char32_t N_ARY_CIRCLED_DOT_OPERATOR = 0x2A00;
const char32_t N_ARY_CIRCLED_PLUS_OPERATOR = 0x2A01;
const char32_t N_ARY_CIRCLED_TIMES_OPERATOR = 0x2A02;
const char32_t N_ARY_UNION_OPERATOR_WITH_DOT = 0x2A03;
const char32_t N_ARY_UNION_OPERATOR_WITH_PLUS = 0x2A04;
const char32_t N_ARY_SQUARE_INTERSECTION_OPERATOR = 0x2A05;
const char32_t N_ARY_SQUARE_UNION_OPERATOR = 0x2A06;
const char32_t TWO_LOGICAL_AND_OPERATOR = 0x2A07;
const char32_t TWO_LOGICAL_OR_OPERATOR = 0x2A08;
const char32_t N_ARY_TIMES_OPERATOR = 0x2A09;
const char32_t MODULO_TWO_SUM = 0x2A0A;
const char32_t SUMMATION_WITH_INTEGRAL = 0x2A0B;
const char32_t QUADRUPLE_INTEGRAL_OPERATOR = 0x2A0C;
const char32_t FINITE_PART_INTEGRAL = 0x2A0D;
const char32_t INTEGRAL_WITH_DOUBLE_STROKE = 0x2A0E;
const char32_t INTEGRAL_AVERAGE_WITH_SLASH = 0x2A0F;
const char32_t CIRCULATION_FUNCTION = 0x2A10;
const char32_t ANTICLOCKWISE_INTEGRATION = 0x2A11;
const char32_t LINE_INTEGRATION_WITH_RECTANGULAR_PATH_AROUND_POLE = 0x2A12;
const char32_t LINE_INTEGRATION_WITH_SEMICIRCULAR_PATH_AROUND_POLE = 0x2A13;
const char32_t LINE_INTEGRATION_NOT_INCLUDING_THE_POLE = 0x2A14;
const char32_t INTEGRAL_AROUND_A_POINT_OPERATOR = 0x2A15;
const char32_t QUATERNION_INTEGRAL_OPERATOR = 0x2A16;
const char32_t INTEGRAL_WITH_LEFTWARDS_ARROW_WITH_HOOK = 0x2A17;
const char32_t INTEGRAL_WITH_TIMES_SIGN = 0x2A18;
const char32_t INTEGRAL_WITH_INTERSECTION = 0x2A19;
const char32_t INTEGRAL_WITH_UNION = 0x2A1A;
const char32_t INTEGRAL_WITH_OVERBAR = 0x2A1B;
const char32_t INTEGRAL_WITH_UNDERBAR = 0x2A1C;
const char32_t JOIN = 0x2A1D;
const char32_t LARGE_LEFT_TRIANGLE_OPERATOR = 0x2A1E;
const char32_t Z_NOTATION_SCHEMA_COMPOSITION = 0x2A1F;
const char32_t Z_NOTATION_SCHEMA_PIPING = 0x2A20;
const char32_t Z_NOTATION_SCHEMA_PROJECTION = 0x2A21;
const char32_t PLUS_SIGN_WITH_SMALL_CIRCLE_ABOVE = 0x2A22;
const char32_t PLUS_SIGN_WITH_CIRCUMFLEX_ACCENT_ABOVE = 0x2A23;
const char32_t PLUS_SIGN_WITH_TILDE_ABOVE = 0x2A24;
const char32_t PLUS_SIGN_WITH_DOT_BELOW = 0x2A25;
const char32_t PLUS_SIGN_WITH_TILDE_BELOW = 0x2A26;
const char32_t PLUS_SIGN_WITH_SUBSCRIPT_TWO = 0x2A27;
const char32_t PLUS_SIGN_WITH_BLACK_TRIANGLE = 0x2A28;
const char32_t MINUS_SIGN_WITH_COMMA_ABOVE = 0x2A29;
const char32_t MINUS_SIGN_WITH_DOT_BELOW = 0x2A2A;
const char32_t MINUS_SIGN_WITH_FALLING_DOTS = 0x2A2B;
const char32_t MINUS_SIGN_WITH_RISING_DOTS = 0x2A2C;
const char32_t PLUS_SIGN_IN_LEFT_HALF_CIRCLE = 0x2A2D;
const char32_t PLUS_SIGN_IN_RIGHT_HALF_CIRCLE = 0x2A2E;
const char32_t VECTOR_OR_CROSS_PRODUCT = 0x2A2F;
const char32_t MULTIPLICATION_SIGN_WITH_DOT_ABOVE = 0x2A30;
const char32_t MULTIPLICATION_SIGN_WITH_UNDERBAR = 0x2A31;
const char32_t SEMIDIRECT_PRODUCT_WITH_BOTTOM_CLOSED = 0x2A32;
const char32_t SMASH_PRODUCT = 0x2A33;
const char32_t MULTIPLICATION_SIGN_IN_LEFT_HALF_CIRCLE = 0x2A34;
const char32_t MULTIPLICATION_SIGN_IN_RIGHT_HALF_CIRCLE = 0x2A35;
const char32_t CIRCLED_MULTIPLICATION_SIGN_WITH_CIRCUMFLEX_ACCENT = 0x2A36;
const char32_t MULTIPLICATION_SIGN_IN_DOUBLE_CIRCLE = 0x2A37;
const char32_t CIRCLED_DIVISION_SIGN = 0x2A38;
const char32_t PLUS_SIGN_IN_TRIANGLE = 0x2A39;
const char32_t MINUS_SIGN_IN_TRIANGLE = 0x2A3A;
const char32_t MULTIPLICATION_SIGN_IN_TRIANGLE = 0x2A3B;
const char32_t INTERIOR_PRODUCT = 0x2A3C;
const char32_t RIGHTHAND_INTERIOR_PRODUCT = 0x2A3D;
const char32_t Z_NOTATION_RELATIONAL_COMPOSITION = 0x2A3E;
const char32_t AMALGAMATION_OR_COPRODUCT = 0x2A3F;
const char32_t INTERSECTION_WITH_DOT = 0x2A40;
const char32_t UNION_WITH_MINUS_SIGN = 0x2A41;
const char32_t UNION_WITH_OVERBAR = 0x2A42;
const char32_t INTERSECTION_WITH_OVERBAR = 0x2A43;
const char32_t INTERSECTION_WITH_LOGICAL_AND = 0x2A44;
const char32_t UNION_WITH_LOGICAL_OR = 0x2A45;
const char32_t UNION_ABOVE_INTERSECTION = 0x2A46;
const char32_t INTERSECTION_ABOVE_UNION = 0x2A47;
const char32_t UNION_ABOVE_BAR_ABOVE_INTERSECTION = 0x2A48;
const char32_t INTERSECTION_ABOVE_BAR_ABOVE_UNION = 0x2A49;
const char32_t UNION_BESIDE_AND_JOINED_WITH_UNION = 0x2A4A;
const char32_t INTERSECTION_BESIDE_AND_JOINED_WITH_INTERSECTION = 0x2A4B;
const char32_t CLOSED_UNION_WITH_SERIFS = 0x2A4C;
const char32_t CLOSED_INTERSECTION_WITH_SERIFS = 0x2A4D;
const char32_t DOUBLE_SQUARE_INTERSECTION = 0x2A4E;
const char32_t DOUBLE_SQUARE_UNION = 0x2A4F;
const char32_t CLOSED_UNION_WITH_SERIFS_AND_SMASH_PRODUCT = 0x2A50;
const char32_t LOGICAL_AND_WITH_DOT_ABOVE = 0x2A51;
const char32_t LOGICAL_OR_WITH_DOT_ABOVE = 0x2A52;
const char32_t DOUBLE_LOGICAL_AND = 0x2A53;
const char32_t DOUBLE_LOGICAL_OR = 0x2A54;
const char32_t TWO_INTERSECTING_LOGICAL_AND = 0x2A55;
const char32_t TWO_INTERSECTING_LOGICAL_OR = 0x2A56;
const char32_t SLOPING_LARGE_OR = 0x2A57;
const char32_t SLOPING_LARGE_AND = 0x2A58;
const char32_t LOGICAL_OR_OVERLAPPING_LOGICAL_AND = 0x2A59;
const char32_t LOGICAL_AND_WITH_MIDDLE_STEM = 0x2A5A;
const char32_t LOGICAL_OR_WITH_MIDDLE_STEM = 0x2A5B;
const char32_t LOGICAL_AND_WITH_HORIZONTAL_DASH = 0x2A5C;
const char32_t LOGICAL_OR_WITH_HORIZONTAL_DASH = 0x2A5D;
const char32_t LOGICAL_AND_WITH_DOUBLE_OVERBAR = 0x2A5E;
const char32_t LOGICAL_AND_WITH_UNDERBAR = 0x2A5F;
const char32_t LOGICAL_AND_WITH_DOUBLE_UNDERBAR = 0x2A60;
const char32_t SMALL_VEE_WITH_UNDERBAR = 0x2A61;
const char32_t LOGICAL_OR_WITH_DOUBLE_OVERBAR = 0x2A62;
const char32_t LOGICAL_OR_WITH_DOUBLE_UNDERBAR = 0x2A63;
const char32_t Z_NOTATION_DOMAIN_ANTIRESTRICTION = 0x2A64;
const char32_t Z_NOTATION_RANGE_ANTIRESTRICTION = 0x2A65;
const char32_t EQUALS_SIGN_WITH_DOT_BELOW = 0x2A66;
const char32_t IDENTICAL_WITH_DOT_ABOVE = 0x2A67;
const char32_t TRIPLE_HORIZONTAL_BAR_WITH_DOUBLE_VERTICAL_STROKE = 0x2A68;
const char32_t TRIPLE_HORIZONTAL_BAR_WITH_TRIPLE_VERTICAL_STROKE = 0x2A69;
const char32_t TILDE_OPERATOR_WITH_DOT_ABOVE = 0x2A6A;
const char32_t TILDE_OPERATOR_WITH_RISING_DOTS = 0x2A6B;
const char32_t SIMILAR_MINUS_SIMILAR = 0x2A6C;
const char32_t CONGRUENT_WITH_DOT_ABOVE = 0x2A6D;
const char32_t EQUALS_WITH_ASTERISK = 0x2A6E;
const char32_t ALMOST_EQUAL_TO_WITH_CIRCUMFLEX_ACCENT = 0x2A6F;
const char32_t APPROXIMATELY_EQUAL_OR_EQUAL_TO = 0x2A70;
const char32_t EQUALS_SIGN_ABOVE_PLUS_SIGN = 0x2A71;
const char32_t PLUS_SIGN_ABOVE_EQUALS_SIGN = 0x2A72;
const char32_t EQUALS_SIGN_ABOVE_TILDE_OPERATOR = 0x2A73;
const char32_t DOUBLE_COLON_EQUAL = 0x2A74;
const char32_t TWO_CONSECUTIVE_EQUALS_SIGNS = 0x2A75;
const char32_t THREE_CONSECUTIVE_EQUALS_SIGNS = 0x2A76;
const char32_t EQUALS_SIGN_WITH_TWO_DOTS_ABOVE_AND_TWO_DOTS_BELOW = 0x2A77;
const char32_t EQUIVALENT_WITH_FOUR_DOTS_ABOVE = 0x2A78;
const char32_t LESS_THAN_WITH_CIRCLE_INSIDE = 0x2A79;
const char32_t GREATER_THAN_WITH_CIRCLE_INSIDE = 0x2A7A;
const char32_t LESS_THAN_WITH_QUESTION_MARK_ABOVE = 0x2A7B;
const char32_t GREATER_THAN_WITH_QUESTION_MARK_ABOVE = 0x2A7C;
const char32_t LESS_THAN_OR_SLANTED_EQUAL_TO = 0x2A7D;
const char32_t GREATER_THAN_OR_SLANTED_EQUAL_TO = 0x2A7E;
const char32_t LESS_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_INSIDE = 0x2A7F;
const char32_t GREATER_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_INSIDE = 0x2A80;
const char32_t LESS_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_ABOVE = 0x2A81;
const char32_t GREATER_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_ABOVE = 0x2A82;
const char32_t LESS_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_ABOVE_RIGHT = 0x2A83;
const char32_t GREATER_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_ABOVE_LEFT = 0x2A84;
const char32_t LESS_THAN_OR_APPROXIMATE = 0x2A85;
const char32_t GREATER_THAN_OR_APPROXIMATE = 0x2A86;
const char32_t LESS_THAN_AND_SINGLE_LINE_NOT_EQUAL_TO = 0x2A87;
const char32_t GREATER_THAN_AND_SINGLE_LINE_NOT_EQUAL_TO = 0x2A88;
const char32_t LESS_THAN_AND_NOT_APPROXIMATE = 0x2A89;
const char32_t GREATER_THAN_AND_NOT_APPROXIMATE = 0x2A8A;
const char32_t LESS_THAN_ABOVE_DOUBLE_LINE_EQUAL_ABOVE_GREATER_THAN = 0x2A8B;
const char32_t GREATER_THAN_ABOVE_DOUBLE_LINE_EQUAL_ABOVE_LESS_THAN = 0x2A8C;
const char32_t LESS_THAN_ABOVE_SIMILAR_OR_EQUAL = 0x2A8D;
const char32_t GREATER_THAN_ABOVE_SIMILAR_OR_EQUAL = 0x2A8E;
const char32_t LESS_THAN_ABOVE_SIMILAR_ABOVE_GREATER_THAN = 0x2A8F;
const char32_t GREATER_THAN_ABOVE_SIMILAR_ABOVE_LESS_THAN = 0x2A90;
const char32_t LESS_THAN_ABOVE_GREATER_THAN_ABOVE_DOUBLE_LINE_EQUAL = 0x2A91;
const char32_t GREATER_THAN_ABOVE_LESS_THAN_ABOVE_DOUBLE_LINE_EQUAL = 0x2A92;
const char32_t LESS_THAN_ABOVE_SLANTED_EQUAL_ABOVE_GREATER_THAN_ABOVE_SLANTED_EQUAL = 0x2A93;
const char32_t GREATER_THAN_ABOVE_SLANTED_EQUAL_ABOVE_LESS_THAN_ABOVE_SLANTED_EQUAL = 0x2A94;
const char32_t SLANTED_EQUAL_TO_OR_LESS_THAN = 0x2A95;
const char32_t SLANTED_EQUAL_TO_OR_GREATER_THAN = 0x2A96;
const char32_t SLANTED_EQUAL_TO_OR_LESS_THAN_WITH_DOT_INSIDE = 0x2A97;
const char32_t SLANTED_EQUAL_TO_OR_GREATER_THAN_WITH_DOT_INSIDE = 0x2A98;
const char32_t DOUBLE_LINE_EQUAL_TO_OR_LESS_THAN = 0x2A99;
const char32_t DOUBLE_LINE_EQUAL_TO_OR_GREATER_THAN = 0x2A9A;
const char32_t DOUBLE_LINE_SLANTED_EQUAL_TO_OR_LESS_THAN = 0x2A9B;
const char32_t DOUBLE_LINE_SLANTED_EQUAL_TO_OR_GREATER_THAN = 0x2A9C;
const char32_t SIMILAR_OR_LESS_THAN = 0x2A9D;
const char32_t SIMILAR_OR_GREATER_THAN = 0x2A9E;
const char32_t SIMILAR_ABOVE_LESS_THAN_ABOVE_EQUALS_SIGN = 0x2A9F;
const char32_t SIMILAR_ABOVE_GREATER_THAN_ABOVE_EQUALS_SIGN = 0x2AA0;
const char32_t DOUBLE_NESTED_LESS_THAN = 0x2AA1;
const char32_t DOUBLE_NESTED_GREATER_THAN = 0x2AA2;
const char32_t DOUBLE_NESTED_LESS_THAN_WITH_UNDERBAR = 0x2AA3;
const char32_t GREATER_THAN_OVERLAPPING_LESS_THAN = 0x2AA4;
const char32_t GREATER_THAN_BESIDE_LESS_THAN = 0x2AA5;
const char32_t LESS_THAN_CLOSED_BY_CURVE = 0x2AA6;
const char32_t GREATER_THAN_CLOSED_BY_CURVE = 0x2AA7;
const char32_t LESS_THAN_CLOSED_BY_CURVE_ABOVE_SLANTED_EQUAL = 0x2AA8;
const char32_t GREATER_THAN_CLOSED_BY_CURVE_ABOVE_SLANTED_EQUAL = 0x2AA9;
const char32_t SMALLER_THAN = 0x2AAA;
const char32_t LARGER_THAN = 0x2AAB;
const char32_t SMALLER_THAN_OR_EQUAL_TO = 0x2AAC;
const char32_t LARGER_THAN_OR_EQUAL_TO = 0x2AAD;
const char32_t EQUALS_SIGN_WITH_BUMPY_ABOVE = 0x2AAE;
const char32_t PRECEDES_ABOVE_SINGLE_LINE_EQUALS_SIGN = 0x2AAF;
const char32_t SUCCEEDS_ABOVE_SINGLE_LINE_EQUALS_SIGN = 0x2AB0;
const char32_t PRECEDES_ABOVE_SINGLE_LINE_NOT_EQUAL_TO = 0x2AB1;
const char32_t SUCCEEDS_ABOVE_SINGLE_LINE_NOT_EQUAL_TO = 0x2AB2;
const char32_t PRECEDES_ABOVE_EQUALS_SIGN = 0x2AB3;
const char32_t SUCCEEDS_ABOVE_EQUALS_SIGN = 0x2AB4;
const char32_t PRECEDES_ABOVE_NOT_EQUAL_TO = 0x2AB5;
const char32_t SUCCEEDS_ABOVE_NOT_EQUAL_TO = 0x2AB6;
const char32_t PRECEDES_ABOVE_ALMOST_EQUAL_TO = 0x2AB7;
const char32_t SUCCEEDS_ABOVE_ALMOST_EQUAL_TO = 0x2AB8;
const char32_t PRECEDES_ABOVE_NOT_ALMOST_EQUAL_TO = 0x2AB9;
const char32_t SUCCEEDS_ABOVE_NOT_ALMOST_EQUAL_TO = 0x2ABA;
const char32_t DOUBLE_PRECEDES = 0x2ABB;
const char32_t DOUBLE_SUCCEEDS = 0x2ABC;
const char32_t SUBSET_WITH_DOT = 0x2ABD;
const char32_t SUPERSET_WITH_DOT = 0x2ABE;
const char32_t SUBSET_WITH_PLUS_SIGN_BELOW = 0x2ABF;
const char32_t SUPERSET_WITH_PLUS_SIGN_BELOW = 0x2AC0;
const char32_t SUBSET_WITH_MULTIPLICATION_SIGN_BELOW = 0x2AC1;
const char32_t SUPERSET_WITH_MULTIPLICATION_SIGN_BELOW = 0x2AC2;
const char32_t SUBSET_OF_OR_EQUAL_TO_WITH_DOT_ABOVE = 0x2AC3;
const char32_t SUPERSET_OF_OR_EQUAL_TO_WITH_DOT_ABOVE = 0x2AC4;
const char32_t SUBSET_OF_ABOVE_EQUALS_SIGN = 0x2AC5;
const char32_t SUPERSET_OF_ABOVE_EQUALS_SIGN = 0x2AC6;
const char32_t SUBSET_OF_ABOVE_TILDE_OPERATOR = 0x2AC7;
const char32_t SUPERSET_OF_ABOVE_TILDE_OPERATOR = 0x2AC8;
const char32_t SUBSET_OF_ABOVE_ALMOST_EQUAL_TO = 0x2AC9;
const char32_t SUPERSET_OF_ABOVE_ALMOST_EQUAL_TO = 0x2ACA;
const char32_t SUBSET_OF_ABOVE_NOT_EQUAL_TO = 0x2ACB;
const char32_t SUPERSET_OF_ABOVE_NOT_EQUAL_TO = 0x2ACC;
const char32_t SQUARE_LEFT_OPEN_BOX_OPERATOR = 0x2ACD;
const char32_t SQUARE_RIGHT_OPEN_BOX_OPERATOR = 0x2ACE;
const char32_t CLOSED_SUBSET = 0x2ACF;
const char32_t CLOSED_SUPERSET = 0x2AD0;
const char32_t CLOSED_SUBSET_OR_EQUAL_TO = 0x2AD1;
const char32_t CLOSED_SUPERSET_OR_EQUAL_TO = 0x2AD2;
const char32_t SUBSET_ABOVE_SUPERSET = 0x2AD3;
const char32_t SUPERSET_ABOVE_SUBSET = 0x2AD4;
const char32_t SUBSET_ABOVE_SUBSET = 0x2AD5;
const char32_t SUPERSET_ABOVE_SUPERSET = 0x2AD6;
const char32_t SUPERSET_BESIDE_SUBSET = 0x2AD7;
const char32_t SUPERSET_BESIDE_AND_JOINED_BY_DASH_WITH_SUBSET = 0x2AD8;
const char32_t ELEMENT_OF_OPENING_DOWNWARDS = 0x2AD9;
const char32_t PITCHFORK_WITH_TEE_TOP = 0x2ADA;
const char32_t TRANSVERSAL_INTERSECTION = 0x2ADB;
const char32_t FORKING = 0x2ADC;
const char32_t NONFORKING = 0x2ADD;
const char32_t SHORT_LEFT_TACK = 0x2ADE;
const char32_t SHORT_DOWN_TACK = 0x2ADF;
const char32_t SHORT_UP_TACK = 0x2AE0;
const char32_t PERPENDICULAR_WITH_S = 0x2AE1;
const char32_t VERTICAL_BAR_TRIPLE_RIGHT_TURNSTILE = 0x2AE2;
const char32_t DOUBLE_VERTICAL_BAR_LEFT_TURNSTILE = 0x2AE3;
const char32_t VERTICAL_BAR_DOUBLE_LEFT_TURNSTILE = 0x2AE4;
const char32_t DOUBLE_VERTICAL_BAR_DOUBLE_LEFT_TURNSTILE = 0x2AE5;
const char32_t LONG_DASH_FROM_LEFT_MEMBER_OF_DOUBLE_VERTICAL = 0x2AE6;
const char32_t SHORT_DOWN_TACK_WITH_OVERBAR = 0x2AE7;
const char32_t SHORT_UP_TACK_WITH_UNDERBAR = 0x2AE8;
const char32_t SHORT_UP_TACK_ABOVE_SHORT_DOWN_TACK = 0x2AE9;
const char32_t DOUBLE_DOWN_TACK = 0x2AEA;
const char32_t DOUBLE_UP_TACK = 0x2AEB;
const char32_t DOUBLE_STROKE_NOT_SIGN = 0x2AEC;
const char32_t REVERSED_DOUBLE_STROKE_NOT_SIGN = 0x2AED;
const char32_t DOES_NOT_DIVIDE_WITH_REVERSED_NEGATION_SLASH = 0x2AEE;
const char32_t VERTICAL_LINE_WITH_CIRCLE_ABOVE = 0x2AEF;
const char32_t VERTICAL_LINE_WITH_CIRCLE_BELOW = 0x2AF0;
const char32_t DOWN_TACK_WITH_CIRCLE_BELOW = 0x2AF1;
const char32_t PARALLEL_WITH_HORIZONTAL_STROKE = 0x2AF2;
const char32_t PARALLEL_WITH_TILDE_OPERATOR = 0x2AF3;
const char32_t TRIPLE_VERTICAL_BAR_BINARY_RELATION = 0x2AF4;
const char32_t TRIPLE_VERTICAL_BAR_WITH_HORIZONTAL_STROKE = 0x2AF5;
const char32_t TRIPLE_COLON_OPERATOR = 0x2AF6;
const char32_t TRIPLE_NESTED_LESS_THAN = 0x2AF7;
const char32_t TRIPLE_NESTED_GREATER_THAN = 0x2AF8;
const char32_t DOUBLE_LINE_SLANTED_LESS_THAN_OR_EQUAL_TO = 0x2AF9;
const char32_t DOUBLE_LINE_SLANTED_GREATER_THAN_OR_EQUAL_TO = 0x2AFA;
const char32_t TRIPLE_SOLIDUS_BINARY_RELATION = 0x2AFB;
const char32_t LARGE_TRIPLE_VERTICAL_BAR_OPERATOR = 0x2AFC;
const char32_t DOUBLE_SOLIDUS_OPERATOR = 0x2AFD;
const char32_t WHITE_VERTICAL_BAR = 0x2AFE;
const char32_t N_ARY_WHITE_VERTICAL_BAR = 0x2AFF;
const char32_t NORTH_EAST_WHITE_ARROW = 0x2B00;
const char32_t NORTH_WEST_WHITE_ARROW = 0x2B01;
const char32_t SOUTH_EAST_WHITE_ARROW = 0x2B02;
const char32_t SOUTH_WEST_WHITE_ARROW = 0x2B03;
const char32_t LEFT_RIGHT_WHITE_ARROW = 0x2B04;
const char32_t LEFTWARDS_BLACK_ARROW = 0x2B05;
const char32_t UPWARDS_BLACK_ARROW = 0x2B06;
const char32_t DOWNWARDS_BLACK_ARROW = 0x2B07;
const char32_t NORTH_EAST_BLACK_ARROW = 0x2B08;
const char32_t NORTH_WEST_BLACK_ARROW = 0x2B09;
const char32_t SOUTH_EAST_BLACK_ARROW = 0x2B0A;
const char32_t SOUTH_WEST_BLACK_ARROW = 0x2B0B;
const char32_t LEFT_RIGHT_BLACK_ARROW = 0x2B0C;
const char32_t UP_DOWN_BLACK_ARROW = 0x2B0D;
const char32_t RIGHTWARDS_ARROW_WITH_TIP_DOWNWARDS = 0x2B0E;
const char32_t RIGHTWARDS_ARROW_WITH_TIP_UPWARDS = 0x2B0F;
const char32_t LEFTWARDS_ARROW_WITH_TIP_DOWNWARDS = 0x2B10;
const char32_t LEFTWARDS_ARROW_WITH_TIP_UPWARDS = 0x2B11;
const char32_t SQUARE_WITH_TOP_HALF_BLACK = 0x2B12;
const char32_t SQUARE_WITH_BOTTOM_HALF_BLACK = 0x2B13;
const char32_t SQUARE_WITH_UPPER_RIGHT_DIAGONAL_HALF_BLACK = 0x2B14;
const char32_t SQUARE_WITH_LOWER_LEFT_DIAGONAL_HALF_BLACK = 0x2B15;
const char32_t DIAMOND_WITH_LEFT_HALF_BLACK = 0x2B16;
const char32_t DIAMOND_WITH_RIGHT_HALF_BLACK = 0x2B17;
const char32_t DIAMOND_WITH_TOP_HALF_BLACK = 0x2B18;
const char32_t DIAMOND_WITH_BOTTOM_HALF_BLACK = 0x2B19;
const char32_t DOTTED_SQUARE = 0x2B1A;
const char32_t BLACK_LARGE_SQUARE = 0x2B1B;
const char32_t WHITE_LARGE_SQUARE = 0x2B1C;
const char32_t BLACK_VERY_SMALL_SQUARE = 0x2B1D;
const char32_t WHITE_VERY_SMALL_SQUARE = 0x2B1E;
const char32_t BLACK_PENTAGON = 0x2B1F;
const char32_t WHITE_PENTAGON = 0x2B20;
const char32_t WHITE_HEXAGON = 0x2B21;
const char32_t BLACK_HEXAGON = 0x2B22;
const char32_t HORIZONTAL_BLACK_HEXAGON = 0x2B23;
const char32_t BLACK_LARGE_CIRCLE = 0x2B24;
const char32_t BLACK_MEDIUM_DIAMOND = 0x2B25;
const char32_t WHITE_MEDIUM_DIAMOND = 0x2B26;
const char32_t BLACK_MEDIUM_LOZENGE = 0x2B27;
const char32_t WHITE_MEDIUM_LOZENGE = 0x2B28;
const char32_t BLACK_SMALL_DIAMOND = 0x2B29;
const char32_t BLACK_SMALL_LOZENGE = 0x2B2A;
const char32_t WHITE_SMALL_LOZENGE = 0x2B2B;
const char32_t BLACK_HORIZONTAL_ELLIPSE = 0x2B2C;
const char32_t WHITE_HORIZONTAL_ELLIPSE = 0x2B2D;
const char32_t BLACK_VERTICAL_ELLIPSE = 0x2B2E;
const char32_t WHITE_VERTICAL_ELLIPSE = 0x2B2F;
const char32_t LEFT_ARROW_WITH_SMALL_CIRCLE = 0x2B30;
const char32_t THREE_LEFTWARDS_ARROWS = 0x2B31;
const char32_t LEFT_ARROW_WITH_CIRCLED_PLUS = 0x2B32;
const char32_t LONG_LEFTWARDS_SQUIGGLE_ARROW = 0x2B33;
const char32_t LEFTWARDS_TWO_HEADED_ARROW_WITH_VERTICAL_STROKE = 0x2B34;
const char32_t LEFTWARDS_TWO_HEADED_ARROW_WITH_DOUBLE_VERTICAL_STROKE = 0x2B35;
const char32_t LEFTWARDS_TWO_HEADED_ARROW_FROM_BAR = 0x2B36;
const char32_t LEFTWARDS_TWO_HEADED_TRIPLE_DASH_ARROW = 0x2B37;
const char32_t LEFTWARDS_ARROW_WITH_DOTTED_STEM = 0x2B38;
const char32_t LEFTWARDS_ARROW_WITH_TAIL_WITH_VERTICAL_STROKE = 0x2B39;
const char32_t LEFTWARDS_ARROW_WITH_TAIL_WITH_DOUBLE_VERTICAL_STROKE = 0x2B3A;
const char32_t LEFTWARDS_TWO_HEADED_ARROW_WITH_TAIL = 0x2B3B;
const char32_t LEFTWARDS_TWO_HEADED_ARROW_WITH_TAIL_WITH_VERTICAL_STROKE = 0x2B3C;
const char32_t LEFTWARDS_TWO_HEADED_ARROW_WITH_TAIL_WITH_DOUBLE_VERTICAL_STROKE = 0x2B3D;
const char32_t LEFTWARDS_ARROW_THROUGH_X = 0x2B3E;
const char32_t WAVE_ARROW_POINTING_DIRECTLY_LEFT = 0x2B3F;
const char32_t EQUALS_SIGN_ABOVE_LEFTWARDS_ARROW = 0x2B40;
const char32_t REVERSE_TILDE_OPERATOR_ABOVE_LEFTWARDS_ARROW = 0x2B41;
const char32_t LEFTWARDS_ARROW_ABOVE_REVERSE_ALMOST_EQUAL_TO = 0x2B42;
const char32_t RIGHTWARDS_ARROW_THROUGH_GREATER_THAN = 0x2B43;
const char32_t RIGHTWARDS_ARROW_THROUGH_SUPERSET = 0x2B44;
const char32_t LEFTWARDS_QUADRUPLE_ARROW = 0x2B45;
const char32_t RIGHTWARDS_QUADRUPLE_ARROW = 0x2B46;
const char32_t REVERSE_TILDE_OPERATOR_ABOVE_RIGHTWARDS_ARROW = 0x2B47;
const char32_t RIGHTWARDS_ARROW_ABOVE_REVERSE_ALMOST_EQUAL_TO = 0x2B48;
const char32_t TILDE_OPERATOR_ABOVE_LEFTWARDS_ARROW = 0x2B49;
const char32_t LEFTWARDS_ARROW_ABOVE_ALMOST_EQUAL_TO = 0x2B4A;
const char32_t LEFTWARDS_ARROW_ABOVE_REVERSE_TILDE_OPERATOR = 0x2B4B;
const char32_t RIGHTWARDS_ARROW_ABOVE_REVERSE_TILDE_OPERATOR = 0x2B4C;
const char32_t DOWNWARDS_TRIANGLE_HEADED_ZIGZAG_ARROW = 0x2B4D;
const char32_t SHORT_SLANTED_NORTH_ARROW = 0x2B4E;
const char32_t SHORT_BACKSLANTED_SOUTH_ARROW = 0x2B4F;
const char32_t WHITE_MEDIUM_STAR = 0x2B50;
const char32_t BLACK_SMALL_STAR = 0x2B51;
const char32_t WHITE_SMALL_STAR = 0x2B52;
const char32_t BLACK_RIGHT_POINTING_PENTAGON = 0x2B53;
const char32_t WHITE_RIGHT_POINTING_PENTAGON = 0x2B54;
const char32_t HEAVY_LARGE_CIRCLE = 0x2B55;
const char32_t HEAVY_OVAL_WITH_OVAL_INSIDE = 0x2B56;
const char32_t HEAVY_CIRCLE_WITH_CIRCLE_INSIDE = 0x2B57;
const char32_t HEAVY_CIRCLE = 0x2B58;
const char32_t HEAVY_CIRCLED_SALTIRE = 0x2B59;
const char32_t SLANTED_NORTH_ARROW_WITH_HOOKED_HEAD = 0x2B5A;
const char32_t BACKSLANTED_SOUTH_ARROW_WITH_HOOKED_TAIL = 0x2B5B;
const char32_t SLANTED_NORTH_ARROW_WITH_HORIZONTAL_TAIL = 0x2B5C;
const char32_t BACKSLANTED_SOUTH_ARROW_WITH_HORIZONTAL_TAIL = 0x2B5D;
const char32_t BENT_ARROW_POINTING_DOWNWARDS_THEN_NORTH_EAST = 0x2B5E;
const char32_t SHORT_BENT_ARROW_POINTING_DOWNWARDS_THEN_NORTH_EAST = 0x2B5F;
const char32_t LEFTWARDS_TRIANGLE_HEADED_ARROW = 0x2B60;
const char32_t UPWARDS_TRIANGLE_HEADED_ARROW = 0x2B61;
const char32_t RIGHTWARDS_TRIANGLE_HEADED_ARROW = 0x2B62;
const char32_t DOWNWARDS_TRIANGLE_HEADED_ARROW = 0x2B63;
const char32_t LEFT_RIGHT_TRIANGLE_HEADED_ARROW = 0x2B64;
const char32_t UP_DOWN_TRIANGLE_HEADED_ARROW = 0x2B65;
const char32_t NORTH_WEST_TRIANGLE_HEADED_ARROW = 0x2B66;
const char32_t NORTH_EAST_TRIANGLE_HEADED_ARROW = 0x2B67;
const char32_t SOUTH_EAST_TRIANGLE_HEADED_ARROW = 0x2B68;
const char32_t SOUTH_WEST_TRIANGLE_HEADED_ARROW = 0x2B69;
const char32_t LEFTWARDS_TRIANGLE_HEADED_DASHED_ARROW = 0x2B6A;
const char32_t UPWARDS_TRIANGLE_HEADED_DASHED_ARROW = 0x2B6B;
const char32_t RIGHTWARDS_TRIANGLE_HEADED_DASHED_ARROW = 0x2B6C;
const char32_t DOWNWARDS_TRIANGLE_HEADED_DASHED_ARROW = 0x2B6D;
const char32_t CLOCKWISE_TRIANGLE_HEADED_OPEN_CIRCLE_ARROW = 0x2B6E;
const char32_t ANTICLOCKWISE_TRIANGLE_HEADED_OPEN_CIRCLE_ARROW = 0x2B6F;
const char32_t LEFTWARDS_TRIANGLE_HEADED_ARROW_TO_BAR = 0x2B70;
const char32_t UPWARDS_TRIANGLE_HEADED_ARROW_TO_BAR = 0x2B71;
const char32_t RIGHTWARDS_TRIANGLE_HEADED_ARROW_TO_BAR = 0x2B72;
const char32_t DOWNWARDS_TRIANGLE_HEADED_ARROW_TO_BAR = 0x2B73;
const char32_t NORTH_WEST_TRIANGLE_HEADED_ARROW_TO_BAR = 0x2B76;
const char32_t NORTH_EAST_TRIANGLE_HEADED_ARROW_TO_BAR = 0x2B77;
const char32_t SOUTH_EAST_TRIANGLE_HEADED_ARROW_TO_BAR = 0x2B78;
const char32_t SOUTH_WEST_TRIANGLE_HEADED_ARROW_TO_BAR = 0x2B79;
const char32_t LEFTWARDS_TRIANGLE_HEADED_ARROW_WITH_DOUBLE_HORIZONTAL_STROKE = 0x2B7A;
const char32_t UPWARDS_TRIANGLE_HEADED_ARROW_WITH_DOUBLE_HORIZONTAL_STROKE = 0x2B7B;
const char32_t RIGHTWARDS_TRIANGLE_HEADED_ARROW_WITH_DOUBLE_HORIZONTAL_STROKE = 0x2B7C;
const char32_t DOWNWARDS_TRIANGLE_HEADED_ARROW_WITH_DOUBLE_HORIZONTAL_STROKE = 0x2B7D;
const char32_t HORIZONTAL_TAB_KEY = 0x2B7E;
const char32_t VERTICAL_TAB_KEY = 0x2B7F;
const char32_t LEFTWARDS_TRIANGLE_HEADED_ARROW_OVER_RIGHTWARDS_TRIANGLE_HEADED_ARROW = 0x2B80;
const char32_t UPWARDS_TRIANGLE_HEADED_ARROW_LEFTWARDS_OF_DOWNWARDS_TRIANGLE_HEADED_ARROW = 0x2B81;
const char32_t RIGHTWARDS_TRIANGLE_HEADED_ARROW_OVER_LEFTWARDS_TRIANGLE_HEADED_ARROW = 0x2B82;
const char32_t DOWNWARDS_TRIANGLE_HEADED_ARROW_LEFTWARDS_OF_UPWARDS_TRIANGLE_HEADED_ARROW = 0x2B83;
const char32_t LEFTWARDS_TRIANGLE_HEADED_PAIRED_ARROWS = 0x2B84;
const char32_t UPWARDS_TRIANGLE_HEADED_PAIRED_ARROWS = 0x2B85;
const char32_t RIGHTWARDS_TRIANGLE_HEADED_PAIRED_ARROWS = 0x2B86;
const char32_t DOWNWARDS_TRIANGLE_HEADED_PAIRED_ARROWS = 0x2B87;
const char32_t LEFTWARDS_BLACK_CIRCLED_WHITE_ARROW = 0x2B88;
const char32_t UPWARDS_BLACK_CIRCLED_WHITE_ARROW = 0x2B89;
const char32_t RIGHTWARDS_BLACK_CIRCLED_WHITE_ARROW = 0x2B8A;
const char32_t DOWNWARDS_BLACK_CIRCLED_WHITE_ARROW = 0x2B8B;
const char32_t ANTICLOCKWISE_TRIANGLE_HEADED_RIGHT_U_SHAPED_ARROW = 0x2B8C;
const char32_t ANTICLOCKWISE_TRIANGLE_HEADED_BOTTOM_U_SHAPED_ARROW = 0x2B8D;
const char32_t ANTICLOCKWISE_TRIANGLE_HEADED_LEFT_U_SHAPED_ARROW = 0x2B8E;
const char32_t ANTICLOCKWISE_TRIANGLE_HEADED_TOP_U_SHAPED_ARROW = 0x2B8F;
const char32_t RETURN_LEFT = 0x2B90;
const char32_t RETURN_RIGHT = 0x2B91;
const char32_t NEWLINE_LEFT = 0x2B92;
const char32_t NEWLINE_RIGHT = 0x2B93;
const char32_t FOUR_CORNER_ARROWS_CIRCLING_ANTICLOCKWISE = 0x2B94;
const char32_t RIGHTWARDS_BLACK_ARROW = 0x2B95;
const char32_t SYMBOL_FOR_TYPE_A_ELECTRONICS = 0x2B97;
const char32_t THREE_D_TOP_LIGHTED_LEFTWARDS_EQUILATERAL_ARROWHEAD = 0x2B98;
const char32_t THREE_D_RIGHT_LIGHTED_UPWARDS_EQUILATERAL_ARROWHEAD = 0x2B99;
const char32_t THREE_D_TOP_LIGHTED_RIGHTWARDS_EQUILATERAL_ARROWHEAD = 0x2B9A;
const char32_t THREE_D_LEFT_LIGHTED_DOWNWARDS_EQUILATERAL_ARROWHEAD = 0x2B9B;
const char32_t BLACK_LEFTWARDS_EQUILATERAL_ARROWHEAD = 0x2B9C;
const char32_t BLACK_UPWARDS_EQUILATERAL_ARROWHEAD = 0x2B9D;
const char32_t BLACK_RIGHTWARDS_EQUILATERAL_ARROWHEAD = 0x2B9E;
const char32_t BLACK_DOWNWARDS_EQUILATERAL_ARROWHEAD = 0x2B9F;
const char32_t DOWNWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_LEFTWARDS = 0x2BA0;
const char32_t DOWNWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_RIGHTWARDS = 0x2BA1;
const char32_t UPWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_LEFTWARDS = 0x2BA2;
const char32_t UPWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_RIGHTWARDS = 0x2BA3;
const char32_t LEFTWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_UPWARDS = 0x2BA4;
const char32_t RIGHTWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_UPWARDS = 0x2BA5;
const char32_t LEFTWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_DOWNWARDS = 0x2BA6;
const char32_t RIGHTWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_DOWNWARDS = 0x2BA7;
const char32_t BLACK_CURVED_DOWNWARDS_AND_LEFTWARDS_ARROW = 0x2BA8;
const char32_t BLACK_CURVED_DOWNWARDS_AND_RIGHTWARDS_ARROW = 0x2BA9;
const char32_t BLACK_CURVED_UPWARDS_AND_LEFTWARDS_ARROW = 0x2BAA;
const char32_t BLACK_CURVED_UPWARDS_AND_RIGHTWARDS_ARROW = 0x2BAB;
const char32_t BLACK_CURVED_LEFTWARDS_AND_UPWARDS_ARROW = 0x2BAC;
const char32_t BLACK_CURVED_RIGHTWARDS_AND_UPWARDS_ARROW = 0x2BAD;
const char32_t BLACK_CURVED_LEFTWARDS_AND_DOWNWARDS_ARROW = 0x2BAE;
const char32_t BLACK_CURVED_RIGHTWARDS_AND_DOWNWARDS_ARROW = 0x2BAF;
const char32_t RIBBON_ARROW_DOWN_LEFT = 0x2BB0;
const char32_t RIBBON_ARROW_DOWN_RIGHT = 0x2BB1;
const char32_t RIBBON_ARROW_UP_LEFT = 0x2BB2;
const char32_t RIBBON_ARROW_UP_RIGHT = 0x2BB3;
const char32_t RIBBON_ARROW_LEFT_UP = 0x2BB4;
const char32_t RIBBON_ARROW_RIGHT_UP = 0x2BB5;
const char32_t RIBBON_ARROW_LEFT_DOWN = 0x2BB6;
const char32_t RIBBON_ARROW_RIGHT_DOWN = 0x2BB7;
const char32_t UPWARDS_WHITE_ARROW_FROM_BAR_WITH_HORIZONTAL_BAR = 0x2BB8;
const char32_t UP_ARROWHEAD_IN_A_RECTANGLE_BOX = 0x2BB9;
const char32_t OVERLAPPING_WHITE_SQUARES = 0x2BBA;
const char32_t OVERLAPPING_WHITE_AND_BLACK_SQUARES = 0x2BBB;
const char32_t OVERLAPPING_BLACK_SQUARES = 0x2BBC;
const char32_t BALLOT_BOX_WITH_LIGHT_X = 0x2BBD;
const char32_t CIRCLED_X = 0x2BBE;
const char32_t CIRCLED_BOLD_X = 0x2BBF;
const char32_t BLACK_SQUARE_CENTRED = 0x2BC0;
const char32_t BLACK_DIAMOND_CENTRED = 0x2BC1;
const char32_t TURNED_BLACK_PENTAGON = 0x2BC2;
const char32_t HORIZONTAL_BLACK_OCTAGON = 0x2BC3;
const char32_t BLACK_OCTAGON = 0x2BC4;
const char32_t BLACK_MEDIUM_UP_POINTING_TRIANGLE_CENTRED = 0x2BC5;
const char32_t BLACK_MEDIUM_DOWN_POINTING_TRIANGLE_CENTRED = 0x2BC6;
const char32_t BLACK_MEDIUM_LEFT_POINTING_TRIANGLE_CENTRED = 0x2BC7;
const char32_t BLACK_MEDIUM_RIGHT_POINTING_TRIANGLE_CENTRED = 0x2BC8;
const char32_t NEPTUNE_FORM_TWO = 0x2BC9;
const char32_t TOP_HALF_BLACK_CIRCLE = 0x2BCA;
const char32_t BOTTOM_HALF_BLACK_CIRCLE = 0x2BCB;
const char32_t LIGHT_FOUR_POINTED_BLACK_CUSP = 0x2BCC;
const char32_t ROTATED_LIGHT_FOUR_POINTED_BLACK_CUSP = 0x2BCD;
const char32_t WHITE_FOUR_POINTED_CUSP = 0x2BCE;
const char32_t ROTATED_WHITE_FOUR_POINTED_CUSP = 0x2BCF;
const char32_t SQUARE_POSITION_INDICATOR = 0x2BD0;
const char32_t UNCERTAINTY_SIGN = 0x2BD1;
const char32_t GROUP_MARK = 0x2BD2;
const char32_t PLUTO_FORM_TWO = 0x2BD3;
const char32_t PLUTO_FORM_THREE = 0x2BD4;
const char32_t PLUTO_FORM_FOUR = 0x2BD5;
const char32_t PLUTO_FORM_FIVE = 0x2BD6;
const char32_t TRANSPLUTO = 0x2BD7;
const char32_t PROSERPINA = 0x2BD8;
const char32_t ASTRAEA = 0x2BD9;
const char32_t HYGIEA = 0x2BDA;
const char32_t PHOLUS = 0x2BDB;
const char32_t NESSUS = 0x2BDC;
const char32_t WHITE_MOON_SELENA = 0x2BDD;
const char32_t BLACK_DIAMOND_ON_CROSS = 0x2BDE;
const char32_t TRUE_LIGHT_MOON_ARTA = 0x2BDF;
const char32_t CUPIDO = 0x2BE0;
const char32_t HADES = 0x2BE1;
const char32_t ZEUS = 0x2BE2;
const char32_t KRONOS = 0x2BE3;
const char32_t APOLLON = 0x2BE4;
const char32_t ADMETOS = 0x2BE5;
const char32_t VULCANUS = 0x2BE6;
const char32_t POSEIDON = 0x2BE7;
const char32_t LEFT_HALF_BLACK_STAR = 0x2BE8;
const char32_t RIGHT_HALF_BLACK_STAR = 0x2BE9;
const char32_t STAR_WITH_LEFT_HALF_BLACK = 0x2BEA;
const char32_t STAR_WITH_RIGHT_HALF_BLACK = 0x2BEB;
const char32_t LEFTWARDS_TWO_HEADED_ARROW_WITH_TRIANGLE_ARROWHEADS = 0x2BEC;
const char32_t UPWARDS_TWO_HEADED_ARROW_WITH_TRIANGLE_ARROWHEADS = 0x2BED;
const char32_t RIGHTWARDS_TWO_HEADED_ARROW_WITH_TRIANGLE_ARROWHEADS = 0x2BEE;
const char32_t DOWNWARDS_TWO_HEADED_ARROW_WITH_TRIANGLE_ARROWHEADS = 0x2BEF;
const char32_t ERIS_FORM_ONE = 0x2BF0;
const char32_t ERIS_FORM_TWO = 0x2BF1;
const char32_t SEDNA = 0x2BF2;
const char32_t RUSSIAN_ASTROLOGICAL_SYMBOL_VIGINTILE = 0x2BF3;
const char32_t RUSSIAN_ASTROLOGICAL_SYMBOL_NOVILE = 0x2BF4;
const char32_t RUSSIAN_ASTROLOGICAL_SYMBOL_QUINTILE = 0x2BF5;
const char32_t RUSSIAN_ASTROLOGICAL_SYMBOL_BINOVILE = 0x2BF6;
const char32_t RUSSIAN_ASTROLOGICAL_SYMBOL_SENTAGON = 0x2BF7;
const char32_t RUSSIAN_ASTROLOGICAL_SYMBOL_TREDECILE = 0x2BF8;
const char32_t EQUALS_SIGN_WITH_INFINITY_BELOW = 0x2BF9;
const char32_t UNITED_SYMBOL = 0x2BFA;
const char32_t SEPARATED_SYMBOL = 0x2BFB;
const char32_t DOUBLED_SYMBOL = 0x2BFC;
const char32_t PASSED_SYMBOL = 0x2BFD;
const char32_t REVERSED_RIGHT_ANGLE = 0x2BFE;
const char32_t HELLSCHREIBER_PAUSE_SYMBOL = 0x2BFF;
const char32_t GLAGOLITIC_CAPITAL_LETTER_AZU = 0x2C00;
const char32_t GLAGOLITIC_CAPITAL_LETTER_BUKY = 0x2C01;
const char32_t GLAGOLITIC_CAPITAL_LETTER_VEDE = 0x2C02;
const char32_t GLAGOLITIC_CAPITAL_LETTER_GLAGOLI = 0x2C03;
const char32_t GLAGOLITIC_CAPITAL_LETTER_DOBRO = 0x2C04;
const char32_t GLAGOLITIC_CAPITAL_LETTER_YESTU = 0x2C05;
const char32_t GLAGOLITIC_CAPITAL_LETTER_ZHIVETE = 0x2C06;
const char32_t GLAGOLITIC_CAPITAL_LETTER_DZELO = 0x2C07;
const char32_t GLAGOLITIC_CAPITAL_LETTER_ZEMLJA = 0x2C08;
const char32_t GLAGOLITIC_CAPITAL_LETTER_IZHE = 0x2C09;
const char32_t GLAGOLITIC_CAPITAL_LETTER_INITIAL_IZHE = 0x2C0A;
const char32_t GLAGOLITIC_CAPITAL_LETTER_I = 0x2C0B;
const char32_t GLAGOLITIC_CAPITAL_LETTER_DJERVI = 0x2C0C;
const char32_t GLAGOLITIC_CAPITAL_LETTER_KAKO = 0x2C0D;
const char32_t GLAGOLITIC_CAPITAL_LETTER_LJUDIJE = 0x2C0E;
const char32_t GLAGOLITIC_CAPITAL_LETTER_MYSLITE = 0x2C0F;
const char32_t GLAGOLITIC_CAPITAL_LETTER_NASHI = 0x2C10;
const char32_t GLAGOLITIC_CAPITAL_LETTER_ONU = 0x2C11;
const char32_t GLAGOLITIC_CAPITAL_LETTER_POKOJI = 0x2C12;
const char32_t GLAGOLITIC_CAPITAL_LETTER_RITSI = 0x2C13;
const char32_t GLAGOLITIC_CAPITAL_LETTER_SLOVO = 0x2C14;
const char32_t GLAGOLITIC_CAPITAL_LETTER_TVRIDO = 0x2C15;
const char32_t GLAGOLITIC_CAPITAL_LETTER_UKU = 0x2C16;
const char32_t GLAGOLITIC_CAPITAL_LETTER_FRITU = 0x2C17;
const char32_t GLAGOLITIC_CAPITAL_LETTER_HERU = 0x2C18;
const char32_t GLAGOLITIC_CAPITAL_LETTER_OTU = 0x2C19;
const char32_t GLAGOLITIC_CAPITAL_LETTER_PE = 0x2C1A;
const char32_t GLAGOLITIC_CAPITAL_LETTER_SHTA = 0x2C1B;
const char32_t GLAGOLITIC_CAPITAL_LETTER_TSI = 0x2C1C;
const char32_t GLAGOLITIC_CAPITAL_LETTER_CHRIVI = 0x2C1D;
const char32_t GLAGOLITIC_CAPITAL_LETTER_SHA = 0x2C1E;
const char32_t GLAGOLITIC_CAPITAL_LETTER_YERU = 0x2C1F;
const char32_t GLAGOLITIC_CAPITAL_LETTER_YERI = 0x2C20;
const char32_t GLAGOLITIC_CAPITAL_LETTER_YATI = 0x2C21;
const char32_t GLAGOLITIC_CAPITAL_LETTER_SPIDERY_HA = 0x2C22;
const char32_t GLAGOLITIC_CAPITAL_LETTER_YU = 0x2C23;
const char32_t GLAGOLITIC_CAPITAL_LETTER_SMALL_YUS = 0x2C24;
const char32_t GLAGOLITIC_CAPITAL_LETTER_SMALL_YUS_WITH_TAIL = 0x2C25;
const char32_t GLAGOLITIC_CAPITAL_LETTER_YO = 0x2C26;
const char32_t GLAGOLITIC_CAPITAL_LETTER_IOTATED_SMALL_YUS = 0x2C27;
const char32_t GLAGOLITIC_CAPITAL_LETTER_BIG_YUS = 0x2C28;
const char32_t GLAGOLITIC_CAPITAL_LETTER_IOTATED_BIG_YUS = 0x2C29;
const char32_t GLAGOLITIC_CAPITAL_LETTER_FITA = 0x2C2A;
const char32_t GLAGOLITIC_CAPITAL_LETTER_IZHITSA = 0x2C2B;
const char32_t GLAGOLITIC_CAPITAL_LETTER_SHTAPIC = 0x2C2C;
const char32_t GLAGOLITIC_CAPITAL_LETTER_TROKUTASTI_A = 0x2C2D;
const char32_t GLAGOLITIC_CAPITAL_LETTER_LATINATE_MYSLITE = 0x2C2E;
const char32_t GLAGOLITIC_SMALL_LETTER_AZU = 0x2C30;
const char32_t GLAGOLITIC_SMALL_LETTER_BUKY = 0x2C31;
const char32_t GLAGOLITIC_SMALL_LETTER_VEDE = 0x2C32;
const char32_t GLAGOLITIC_SMALL_LETTER_GLAGOLI = 0x2C33;
const char32_t GLAGOLITIC_SMALL_LETTER_DOBRO = 0x2C34;
const char32_t GLAGOLITIC_SMALL_LETTER_YESTU = 0x2C35;
const char32_t GLAGOLITIC_SMALL_LETTER_ZHIVETE = 0x2C36;
const char32_t GLAGOLITIC_SMALL_LETTER_DZELO = 0x2C37;
const char32_t GLAGOLITIC_SMALL_LETTER_ZEMLJA = 0x2C38;
const char32_t GLAGOLITIC_SMALL_LETTER_IZHE = 0x2C39;
const char32_t GLAGOLITIC_SMALL_LETTER_INITIAL_IZHE = 0x2C3A;
const char32_t GLAGOLITIC_SMALL_LETTER_I = 0x2C3B;
const char32_t GLAGOLITIC_SMALL_LETTER_DJERVI = 0x2C3C;
const char32_t GLAGOLITIC_SMALL_LETTER_KAKO = 0x2C3D;
const char32_t GLAGOLITIC_SMALL_LETTER_LJUDIJE = 0x2C3E;
const char32_t GLAGOLITIC_SMALL_LETTER_MYSLITE = 0x2C3F;
const char32_t GLAGOLITIC_SMALL_LETTER_NASHI = 0x2C40;
const char32_t GLAGOLITIC_SMALL_LETTER_ONU = 0x2C41;
const char32_t GLAGOLITIC_SMALL_LETTER_POKOJI = 0x2C42;
const char32_t GLAGOLITIC_SMALL_LETTER_RITSI = 0x2C43;
const char32_t GLAGOLITIC_SMALL_LETTER_SLOVO = 0x2C44;
const char32_t GLAGOLITIC_SMALL_LETTER_TVRIDO = 0x2C45;
const char32_t GLAGOLITIC_SMALL_LETTER_UKU = 0x2C46;
const char32_t GLAGOLITIC_SMALL_LETTER_FRITU = 0x2C47;
const char32_t GLAGOLITIC_SMALL_LETTER_HERU = 0x2C48;
const char32_t GLAGOLITIC_SMALL_LETTER_OTU = 0x2C49;
const char32_t GLAGOLITIC_SMALL_LETTER_PE = 0x2C4A;
const char32_t GLAGOLITIC_SMALL_LETTER_SHTA = 0x2C4B;
const char32_t GLAGOLITIC_SMALL_LETTER_TSI = 0x2C4C;
const char32_t GLAGOLITIC_SMALL_LETTER_CHRIVI = 0x2C4D;
const char32_t GLAGOLITIC_SMALL_LETTER_SHA = 0x2C4E;
const char32_t GLAGOLITIC_SMALL_LETTER_YERU = 0x2C4F;
const char32_t GLAGOLITIC_SMALL_LETTER_YERI = 0x2C50;
const char32_t GLAGOLITIC_SMALL_LETTER_YATI = 0x2C51;
const char32_t GLAGOLITIC_SMALL_LETTER_SPIDERY_HA = 0x2C52;
const char32_t GLAGOLITIC_SMALL_LETTER_YU = 0x2C53;
const char32_t GLAGOLITIC_SMALL_LETTER_SMALL_YUS = 0x2C54;
const char32_t GLAGOLITIC_SMALL_LETTER_SMALL_YUS_WITH_TAIL = 0x2C55;
const char32_t GLAGOLITIC_SMALL_LETTER_YO = 0x2C56;
const char32_t GLAGOLITIC_SMALL_LETTER_IOTATED_SMALL_YUS = 0x2C57;
const char32_t GLAGOLITIC_SMALL_LETTER_BIG_YUS = 0x2C58;
const char32_t GLAGOLITIC_SMALL_LETTER_IOTATED_BIG_YUS = 0x2C59;
const char32_t GLAGOLITIC_SMALL_LETTER_FITA = 0x2C5A;
const char32_t GLAGOLITIC_SMALL_LETTER_IZHITSA = 0x2C5B;
const char32_t GLAGOLITIC_SMALL_LETTER_SHTAPIC = 0x2C5C;
const char32_t GLAGOLITIC_SMALL_LETTER_TROKUTASTI_A = 0x2C5D;
const char32_t GLAGOLITIC_SMALL_LETTER_LATINATE_MYSLITE = 0x2C5E;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_DOUBLE_BAR = 0x2C60;
const char32_t LATIN_SMALL_LETTER_L_WITH_DOUBLE_BAR = 0x2C61;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_MIDDLE_TILDE = 0x2C62;
const char32_t LATIN_CAPITAL_LETTER_P_WITH_STROKE = 0x2C63;
const char32_t LATIN_CAPITAL_LETTER_R_WITH_TAIL = 0x2C64;
const char32_t LATIN_SMALL_LETTER_A_WITH_STROKE = 0x2C65;
const char32_t LATIN_SMALL_LETTER_T_WITH_DIAGONAL_STROKE = 0x2C66;
const char32_t LATIN_CAPITAL_LETTER_H_WITH_DESCENDER = 0x2C67;
const char32_t LATIN_SMALL_LETTER_H_WITH_DESCENDER = 0x2C68;
const char32_t LATIN_CAPITAL_LETTER_K_WITH_DESCENDER = 0x2C69;
const char32_t LATIN_SMALL_LETTER_K_WITH_DESCENDER = 0x2C6A;
const char32_t LATIN_CAPITAL_LETTER_Z_WITH_DESCENDER = 0x2C6B;
const char32_t LATIN_SMALL_LETTER_Z_WITH_DESCENDER = 0x2C6C;
const char32_t LATIN_CAPITAL_LETTER_ALPHA = 0x2C6D;
const char32_t LATIN_CAPITAL_LETTER_M_WITH_HOOK = 0x2C6E;
const char32_t LATIN_CAPITAL_LETTER_TURNED_A = 0x2C6F;
const char32_t LATIN_CAPITAL_LETTER_TURNED_ALPHA = 0x2C70;
const char32_t LATIN_SMALL_LETTER_V_WITH_RIGHT_HOOK = 0x2C71;
const char32_t LATIN_CAPITAL_LETTER_W_WITH_HOOK = 0x2C72;
const char32_t LATIN_SMALL_LETTER_W_WITH_HOOK = 0x2C73;
const char32_t LATIN_SMALL_LETTER_V_WITH_CURL = 0x2C74;
const char32_t LATIN_CAPITAL_LETTER_HALF_H = 0x2C75;
const char32_t LATIN_SMALL_LETTER_HALF_H = 0x2C76;
const char32_t LATIN_SMALL_LETTER_TAILLESS_PHI = 0x2C77;
const char32_t LATIN_SMALL_LETTER_E_WITH_NOTCH = 0x2C78;
const char32_t LATIN_SMALL_LETTER_TURNED_R_WITH_TAIL = 0x2C79;
const char32_t LATIN_SMALL_LETTER_O_WITH_LOW_RING_INSIDE = 0x2C7A;
const char32_t LATIN_LETTER_SMALL_CAPITAL_TURNED_E = 0x2C7B;
const char32_t LATIN_SUBSCRIPT_SMALL_LETTER_J = 0x2C7C;
const char32_t MODIFIER_LETTER_CAPITAL_V = 0x2C7D;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_SWASH_TAIL = 0x2C7E;
const char32_t LATIN_CAPITAL_LETTER_Z_WITH_SWASH_TAIL = 0x2C7F;
const char32_t COPTIC_CAPITAL_LETTER_ALFA = 0x2C80;
const char32_t COPTIC_SMALL_LETTER_ALFA = 0x2C81;
const char32_t COPTIC_CAPITAL_LETTER_VIDA = 0x2C82;
const char32_t COPTIC_SMALL_LETTER_VIDA = 0x2C83;
const char32_t COPTIC_CAPITAL_LETTER_GAMMA = 0x2C84;
const char32_t COPTIC_SMALL_LETTER_GAMMA = 0x2C85;
const char32_t COPTIC_CAPITAL_LETTER_DALDA = 0x2C86;
const char32_t COPTIC_SMALL_LETTER_DALDA = 0x2C87;
const char32_t COPTIC_CAPITAL_LETTER_EIE = 0x2C88;
const char32_t COPTIC_SMALL_LETTER_EIE = 0x2C89;
const char32_t COPTIC_CAPITAL_LETTER_SOU = 0x2C8A;
const char32_t COPTIC_SMALL_LETTER_SOU = 0x2C8B;
const char32_t COPTIC_CAPITAL_LETTER_ZATA = 0x2C8C;
const char32_t COPTIC_SMALL_LETTER_ZATA = 0x2C8D;
const char32_t COPTIC_CAPITAL_LETTER_HATE = 0x2C8E;
const char32_t COPTIC_SMALL_LETTER_HATE = 0x2C8F;
const char32_t COPTIC_CAPITAL_LETTER_THETHE = 0x2C90;
const char32_t COPTIC_SMALL_LETTER_THETHE = 0x2C91;
const char32_t COPTIC_CAPITAL_LETTER_IAUDA = 0x2C92;
const char32_t COPTIC_SMALL_LETTER_IAUDA = 0x2C93;
const char32_t COPTIC_CAPITAL_LETTER_KAPA = 0x2C94;
const char32_t COPTIC_SMALL_LETTER_KAPA = 0x2C95;
const char32_t COPTIC_CAPITAL_LETTER_LAULA = 0x2C96;
const char32_t COPTIC_SMALL_LETTER_LAULA = 0x2C97;
const char32_t COPTIC_CAPITAL_LETTER_MI = 0x2C98;
const char32_t COPTIC_SMALL_LETTER_MI = 0x2C99;
const char32_t COPTIC_CAPITAL_LETTER_NI = 0x2C9A;
const char32_t COPTIC_SMALL_LETTER_NI = 0x2C9B;
const char32_t COPTIC_CAPITAL_LETTER_KSI = 0x2C9C;
const char32_t COPTIC_SMALL_LETTER_KSI = 0x2C9D;
const char32_t COPTIC_CAPITAL_LETTER_O = 0x2C9E;
const char32_t COPTIC_SMALL_LETTER_O = 0x2C9F;
const char32_t COPTIC_CAPITAL_LETTER_PI = 0x2CA0;
const char32_t COPTIC_SMALL_LETTER_PI = 0x2CA1;
const char32_t COPTIC_CAPITAL_LETTER_RO = 0x2CA2;
const char32_t COPTIC_SMALL_LETTER_RO = 0x2CA3;
const char32_t COPTIC_CAPITAL_LETTER_SIMA = 0x2CA4;
const char32_t COPTIC_SMALL_LETTER_SIMA = 0x2CA5;
const char32_t COPTIC_CAPITAL_LETTER_TAU = 0x2CA6;
const char32_t COPTIC_SMALL_LETTER_TAU = 0x2CA7;
const char32_t COPTIC_CAPITAL_LETTER_UA = 0x2CA8;
const char32_t COPTIC_SMALL_LETTER_UA = 0x2CA9;
const char32_t COPTIC_CAPITAL_LETTER_FI = 0x2CAA;
const char32_t COPTIC_SMALL_LETTER_FI = 0x2CAB;
const char32_t COPTIC_CAPITAL_LETTER_KHI = 0x2CAC;
const char32_t COPTIC_SMALL_LETTER_KHI = 0x2CAD;
const char32_t COPTIC_CAPITAL_LETTER_PSI = 0x2CAE;
const char32_t COPTIC_SMALL_LETTER_PSI = 0x2CAF;
const char32_t COPTIC_CAPITAL_LETTER_OOU = 0x2CB0;
const char32_t COPTIC_SMALL_LETTER_OOU = 0x2CB1;
const char32_t COPTIC_CAPITAL_LETTER_DIALECT_P_ALEF = 0x2CB2;
const char32_t COPTIC_SMALL_LETTER_DIALECT_P_ALEF = 0x2CB3;
const char32_t COPTIC_CAPITAL_LETTER_OLD_COPTIC_AIN = 0x2CB4;
const char32_t COPTIC_SMALL_LETTER_OLD_COPTIC_AIN = 0x2CB5;
const char32_t COPTIC_CAPITAL_LETTER_CRYPTOGRAMMIC_EIE = 0x2CB6;
const char32_t COPTIC_SMALL_LETTER_CRYPTOGRAMMIC_EIE = 0x2CB7;
const char32_t COPTIC_CAPITAL_LETTER_DIALECT_P_KAPA = 0x2CB8;
const char32_t COPTIC_SMALL_LETTER_DIALECT_P_KAPA = 0x2CB9;
const char32_t COPTIC_CAPITAL_LETTER_DIALECT_P_NI = 0x2CBA;
const char32_t COPTIC_SMALL_LETTER_DIALECT_P_NI = 0x2CBB;
const char32_t COPTIC_CAPITAL_LETTER_CRYPTOGRAMMIC_NI = 0x2CBC;
const char32_t COPTIC_SMALL_LETTER_CRYPTOGRAMMIC_NI = 0x2CBD;
const char32_t COPTIC_CAPITAL_LETTER_OLD_COPTIC_OOU = 0x2CBE;
const char32_t COPTIC_SMALL_LETTER_OLD_COPTIC_OOU = 0x2CBF;
const char32_t COPTIC_CAPITAL_LETTER_SAMPI = 0x2CC0;
const char32_t COPTIC_SMALL_LETTER_SAMPI = 0x2CC1;
const char32_t COPTIC_CAPITAL_LETTER_CROSSED_SHEI = 0x2CC2;
const char32_t COPTIC_SMALL_LETTER_CROSSED_SHEI = 0x2CC3;
const char32_t COPTIC_CAPITAL_LETTER_OLD_COPTIC_SHEI = 0x2CC4;
const char32_t COPTIC_SMALL_LETTER_OLD_COPTIC_SHEI = 0x2CC5;
const char32_t COPTIC_CAPITAL_LETTER_OLD_COPTIC_ESH = 0x2CC6;
const char32_t COPTIC_SMALL_LETTER_OLD_COPTIC_ESH = 0x2CC7;
const char32_t COPTIC_CAPITAL_LETTER_AKHMIMIC_KHEI = 0x2CC8;
const char32_t COPTIC_SMALL_LETTER_AKHMIMIC_KHEI = 0x2CC9;
const char32_t COPTIC_CAPITAL_LETTER_DIALECT_P_HORI = 0x2CCA;
const char32_t COPTIC_SMALL_LETTER_DIALECT_P_HORI = 0x2CCB;
const char32_t COPTIC_CAPITAL_LETTER_OLD_COPTIC_HORI = 0x2CCC;
const char32_t COPTIC_SMALL_LETTER_OLD_COPTIC_HORI = 0x2CCD;
const char32_t COPTIC_CAPITAL_LETTER_OLD_COPTIC_HA = 0x2CCE;
const char32_t COPTIC_SMALL_LETTER_OLD_COPTIC_HA = 0x2CCF;
const char32_t COPTIC_CAPITAL_LETTER_L_SHAPED_HA = 0x2CD0;
const char32_t COPTIC_SMALL_LETTER_L_SHAPED_HA = 0x2CD1;
const char32_t COPTIC_CAPITAL_LETTER_OLD_COPTIC_HEI = 0x2CD2;
const char32_t COPTIC_SMALL_LETTER_OLD_COPTIC_HEI = 0x2CD3;
const char32_t COPTIC_CAPITAL_LETTER_OLD_COPTIC_HAT = 0x2CD4;
const char32_t COPTIC_SMALL_LETTER_OLD_COPTIC_HAT = 0x2CD5;
const char32_t COPTIC_CAPITAL_LETTER_OLD_COPTIC_GANGIA = 0x2CD6;
const char32_t COPTIC_SMALL_LETTER_OLD_COPTIC_GANGIA = 0x2CD7;
const char32_t COPTIC_CAPITAL_LETTER_OLD_COPTIC_DJA = 0x2CD8;
const char32_t COPTIC_SMALL_LETTER_OLD_COPTIC_DJA = 0x2CD9;
const char32_t COPTIC_CAPITAL_LETTER_OLD_COPTIC_SHIMA = 0x2CDA;
const char32_t COPTIC_SMALL_LETTER_OLD_COPTIC_SHIMA = 0x2CDB;
const char32_t COPTIC_CAPITAL_LETTER_OLD_NUBIAN_SHIMA = 0x2CDC;
const char32_t COPTIC_SMALL_LETTER_OLD_NUBIAN_SHIMA = 0x2CDD;
const char32_t COPTIC_CAPITAL_LETTER_OLD_NUBIAN_NGI = 0x2CDE;
const char32_t COPTIC_SMALL_LETTER_OLD_NUBIAN_NGI = 0x2CDF;
const char32_t COPTIC_CAPITAL_LETTER_OLD_NUBIAN_NYI = 0x2CE0;
const char32_t COPTIC_SMALL_LETTER_OLD_NUBIAN_NYI = 0x2CE1;
const char32_t COPTIC_CAPITAL_LETTER_OLD_NUBIAN_WAU = 0x2CE2;
const char32_t COPTIC_SMALL_LETTER_OLD_NUBIAN_WAU = 0x2CE3;
const char32_t COPTIC_SYMBOL_KAI = 0x2CE4;
const char32_t COPTIC_SYMBOL_MI_RO = 0x2CE5;
const char32_t COPTIC_SYMBOL_PI_RO = 0x2CE6;
const char32_t COPTIC_SYMBOL_STAUROS = 0x2CE7;
const char32_t COPTIC_SYMBOL_TAU_RO = 0x2CE8;
const char32_t COPTIC_SYMBOL_KHI_RO = 0x2CE9;
const char32_t COPTIC_SYMBOL_SHIMA_SIMA = 0x2CEA;
const char32_t COPTIC_CAPITAL_LETTER_CRYPTOGRAMMIC_SHEI = 0x2CEB;
const char32_t COPTIC_SMALL_LETTER_CRYPTOGRAMMIC_SHEI = 0x2CEC;
const char32_t COPTIC_CAPITAL_LETTER_CRYPTOGRAMMIC_GANGIA = 0x2CED;
const char32_t COPTIC_SMALL_LETTER_CRYPTOGRAMMIC_GANGIA = 0x2CEE;
const char32_t COPTIC_COMBINING_NI_ABOVE = 0x2CEF;
const char32_t COPTIC_COMBINING_SPIRITUS_ASPER = 0x2CF0;
const char32_t COPTIC_COMBINING_SPIRITUS_LENIS = 0x2CF1;
const char32_t COPTIC_CAPITAL_LETTER_BOHAIRIC_KHEI = 0x2CF2;
const char32_t COPTIC_SMALL_LETTER_BOHAIRIC_KHEI = 0x2CF3;
const char32_t COPTIC_OLD_NUBIAN_FULL_STOP = 0x2CF9;
const char32_t COPTIC_OLD_NUBIAN_DIRECT_QUESTION_MARK = 0x2CFA;
const char32_t COPTIC_OLD_NUBIAN_INDIRECT_QUESTION_MARK = 0x2CFB;
const char32_t COPTIC_OLD_NUBIAN_VERSE_DIVIDER = 0x2CFC;
const char32_t COPTIC_FRACTION_ONE_HALF = 0x2CFD;
const char32_t COPTIC_FULL_STOP = 0x2CFE;
const char32_t COPTIC_MORPHOLOGICAL_DIVIDER = 0x2CFF;
const char32_t GEORGIAN_SMALL_LETTER_AN = 0x2D00;
const char32_t GEORGIAN_SMALL_LETTER_BAN = 0x2D01;
const char32_t GEORGIAN_SMALL_LETTER_GAN = 0x2D02;
const char32_t GEORGIAN_SMALL_LETTER_DON = 0x2D03;
const char32_t GEORGIAN_SMALL_LETTER_EN = 0x2D04;
const char32_t GEORGIAN_SMALL_LETTER_VIN = 0x2D05;
const char32_t GEORGIAN_SMALL_LETTER_ZEN = 0x2D06;
const char32_t GEORGIAN_SMALL_LETTER_TAN = 0x2D07;
const char32_t GEORGIAN_SMALL_LETTER_IN = 0x2D08;
const char32_t GEORGIAN_SMALL_LETTER_KAN = 0x2D09;
const char32_t GEORGIAN_SMALL_LETTER_LAS = 0x2D0A;
const char32_t GEORGIAN_SMALL_LETTER_MAN = 0x2D0B;
const char32_t GEORGIAN_SMALL_LETTER_NAR = 0x2D0C;
const char32_t GEORGIAN_SMALL_LETTER_ON = 0x2D0D;
const char32_t GEORGIAN_SMALL_LETTER_PAR = 0x2D0E;
const char32_t GEORGIAN_SMALL_LETTER_ZHAR = 0x2D0F;
const char32_t GEORGIAN_SMALL_LETTER_RAE = 0x2D10;
const char32_t GEORGIAN_SMALL_LETTER_SAN = 0x2D11;
const char32_t GEORGIAN_SMALL_LETTER_TAR = 0x2D12;
const char32_t GEORGIAN_SMALL_LETTER_UN = 0x2D13;
const char32_t GEORGIAN_SMALL_LETTER_PHAR = 0x2D14;
const char32_t GEORGIAN_SMALL_LETTER_KHAR = 0x2D15;
const char32_t GEORGIAN_SMALL_LETTER_GHAN = 0x2D16;
const char32_t GEORGIAN_SMALL_LETTER_QAR = 0x2D17;
const char32_t GEORGIAN_SMALL_LETTER_SHIN = 0x2D18;
const char32_t GEORGIAN_SMALL_LETTER_CHIN = 0x2D19;
const char32_t GEORGIAN_SMALL_LETTER_CAN = 0x2D1A;
const char32_t GEORGIAN_SMALL_LETTER_JIL = 0x2D1B;
const char32_t GEORGIAN_SMALL_LETTER_CIL = 0x2D1C;
const char32_t GEORGIAN_SMALL_LETTER_CHAR = 0x2D1D;
const char32_t GEORGIAN_SMALL_LETTER_XAN = 0x2D1E;
const char32_t GEORGIAN_SMALL_LETTER_JHAN = 0x2D1F;
const char32_t GEORGIAN_SMALL_LETTER_HAE = 0x2D20;
const char32_t GEORGIAN_SMALL_LETTER_HE = 0x2D21;
const char32_t GEORGIAN_SMALL_LETTER_HIE = 0x2D22;
const char32_t GEORGIAN_SMALL_LETTER_WE = 0x2D23;
const char32_t GEORGIAN_SMALL_LETTER_HAR = 0x2D24;
const char32_t GEORGIAN_SMALL_LETTER_HOE = 0x2D25;
const char32_t GEORGIAN_SMALL_LETTER_YN = 0x2D27;
const char32_t GEORGIAN_SMALL_LETTER_AEN = 0x2D2D;
const char32_t TIFINAGH_LETTER_YA = 0x2D30;
const char32_t TIFINAGH_LETTER_YAB = 0x2D31;
const char32_t TIFINAGH_LETTER_YABH = 0x2D32;
const char32_t TIFINAGH_LETTER_YAG = 0x2D33;
const char32_t TIFINAGH_LETTER_YAGHH = 0x2D34;
const char32_t TIFINAGH_LETTER_BERBER_ACADEMY_YAJ = 0x2D35;
const char32_t TIFINAGH_LETTER_YAJ = 0x2D36;
const char32_t TIFINAGH_LETTER_YAD = 0x2D37;
const char32_t TIFINAGH_LETTER_YADH = 0x2D38;
const char32_t TIFINAGH_LETTER_YADD = 0x2D39;
const char32_t TIFINAGH_LETTER_YADDH = 0x2D3A;
const char32_t TIFINAGH_LETTER_YEY = 0x2D3B;
const char32_t TIFINAGH_LETTER_YAF = 0x2D3C;
const char32_t TIFINAGH_LETTER_YAK = 0x2D3D;
const char32_t TIFINAGH_LETTER_TUAREG_YAK = 0x2D3E;
const char32_t TIFINAGH_LETTER_YAKHH = 0x2D3F;
const char32_t TIFINAGH_LETTER_YAH = 0x2D40;
const char32_t TIFINAGH_LETTER_BERBER_ACADEMY_YAH = 0x2D41;
const char32_t TIFINAGH_LETTER_TUAREG_YAH = 0x2D42;
const char32_t TIFINAGH_LETTER_YAHH = 0x2D43;
const char32_t TIFINAGH_LETTER_YAA = 0x2D44;
const char32_t TIFINAGH_LETTER_YAKH = 0x2D45;
const char32_t TIFINAGH_LETTER_TUAREG_YAKH = 0x2D46;
const char32_t TIFINAGH_LETTER_YAQ = 0x2D47;
const char32_t TIFINAGH_LETTER_TUAREG_YAQ = 0x2D48;
const char32_t TIFINAGH_LETTER_YI = 0x2D49;
const char32_t TIFINAGH_LETTER_YAZH = 0x2D4A;
const char32_t TIFINAGH_LETTER_AHAGGAR_YAZH = 0x2D4B;
const char32_t TIFINAGH_LETTER_TUAREG_YAZH = 0x2D4C;
const char32_t TIFINAGH_LETTER_YAL = 0x2D4D;
const char32_t TIFINAGH_LETTER_YAM = 0x2D4E;
const char32_t TIFINAGH_LETTER_YAN = 0x2D4F;
const char32_t TIFINAGH_LETTER_TUAREG_YAGN = 0x2D50;
const char32_t TIFINAGH_LETTER_TUAREG_YANG = 0x2D51;
const char32_t TIFINAGH_LETTER_YAP = 0x2D52;
const char32_t TIFINAGH_LETTER_YU = 0x2D53;
const char32_t TIFINAGH_LETTER_YAR = 0x2D54;
const char32_t TIFINAGH_LETTER_YARR = 0x2D55;
const char32_t TIFINAGH_LETTER_YAGH = 0x2D56;
const char32_t TIFINAGH_LETTER_TUAREG_YAGH = 0x2D57;
const char32_t TIFINAGH_LETTER_AYER_YAGH = 0x2D58;
const char32_t TIFINAGH_LETTER_YAS = 0x2D59;
const char32_t TIFINAGH_LETTER_YASS = 0x2D5A;
const char32_t TIFINAGH_LETTER_YASH = 0x2D5B;
const char32_t TIFINAGH_LETTER_YAT = 0x2D5C;
const char32_t TIFINAGH_LETTER_YATH = 0x2D5D;
const char32_t TIFINAGH_LETTER_YACH = 0x2D5E;
const char32_t TIFINAGH_LETTER_YATT = 0x2D5F;
const char32_t TIFINAGH_LETTER_YAV = 0x2D60;
const char32_t TIFINAGH_LETTER_YAW = 0x2D61;
const char32_t TIFINAGH_LETTER_YAY = 0x2D62;
const char32_t TIFINAGH_LETTER_YAZ = 0x2D63;
const char32_t TIFINAGH_LETTER_TAWELLEMET_YAZ = 0x2D64;
const char32_t TIFINAGH_LETTER_YAZZ = 0x2D65;
const char32_t TIFINAGH_LETTER_YE = 0x2D66;
const char32_t TIFINAGH_LETTER_YO = 0x2D67;
const char32_t TIFINAGH_MODIFIER_LETTER_LABIALIZATION_MARK = 0x2D6F;
const char32_t TIFINAGH_SEPARATOR_MARK = 0x2D70;
const char32_t TIFINAGH_CONSONANT_JOINER = 0x2D7F;
const char32_t ETHIOPIC_SYLLABLE_LOA = 0x2D80;
const char32_t ETHIOPIC_SYLLABLE_MOA = 0x2D81;
const char32_t ETHIOPIC_SYLLABLE_ROA = 0x2D82;
const char32_t ETHIOPIC_SYLLABLE_SOA = 0x2D83;
const char32_t ETHIOPIC_SYLLABLE_SHOA = 0x2D84;
const char32_t ETHIOPIC_SYLLABLE_BOA = 0x2D85;
const char32_t ETHIOPIC_SYLLABLE_TOA = 0x2D86;
const char32_t ETHIOPIC_SYLLABLE_COA = 0x2D87;
const char32_t ETHIOPIC_SYLLABLE_NOA = 0x2D88;
const char32_t ETHIOPIC_SYLLABLE_NYOA = 0x2D89;
const char32_t ETHIOPIC_SYLLABLE_GLOTTAL_OA = 0x2D8A;
const char32_t ETHIOPIC_SYLLABLE_ZOA = 0x2D8B;
const char32_t ETHIOPIC_SYLLABLE_DOA = 0x2D8C;
const char32_t ETHIOPIC_SYLLABLE_DDOA = 0x2D8D;
const char32_t ETHIOPIC_SYLLABLE_JOA = 0x2D8E;
const char32_t ETHIOPIC_SYLLABLE_THOA = 0x2D8F;
const char32_t ETHIOPIC_SYLLABLE_CHOA = 0x2D90;
const char32_t ETHIOPIC_SYLLABLE_PHOA = 0x2D91;
const char32_t ETHIOPIC_SYLLABLE_POA = 0x2D92;
const char32_t ETHIOPIC_SYLLABLE_GGWA = 0x2D93;
const char32_t ETHIOPIC_SYLLABLE_GGWI = 0x2D94;
const char32_t ETHIOPIC_SYLLABLE_GGWEE = 0x2D95;
const char32_t ETHIOPIC_SYLLABLE_GGWE = 0x2D96;
const char32_t ETHIOPIC_SYLLABLE_SSA = 0x2DA0;
const char32_t ETHIOPIC_SYLLABLE_SSU = 0x2DA1;
const char32_t ETHIOPIC_SYLLABLE_SSI = 0x2DA2;
const char32_t ETHIOPIC_SYLLABLE_SSAA = 0x2DA3;
const char32_t ETHIOPIC_SYLLABLE_SSEE = 0x2DA4;
const char32_t ETHIOPIC_SYLLABLE_SSE = 0x2DA5;
const char32_t ETHIOPIC_SYLLABLE_SSO = 0x2DA6;
const char32_t ETHIOPIC_SYLLABLE_CCA = 0x2DA8;
const char32_t ETHIOPIC_SYLLABLE_CCU = 0x2DA9;
const char32_t ETHIOPIC_SYLLABLE_CCI = 0x2DAA;
const char32_t ETHIOPIC_SYLLABLE_CCAA = 0x2DAB;
const char32_t ETHIOPIC_SYLLABLE_CCEE = 0x2DAC;
const char32_t ETHIOPIC_SYLLABLE_CCE = 0x2DAD;
const char32_t ETHIOPIC_SYLLABLE_CCO = 0x2DAE;
const char32_t ETHIOPIC_SYLLABLE_ZZA = 0x2DB0;
const char32_t ETHIOPIC_SYLLABLE_ZZU = 0x2DB1;
const char32_t ETHIOPIC_SYLLABLE_ZZI = 0x2DB2;
const char32_t ETHIOPIC_SYLLABLE_ZZAA = 0x2DB3;
const char32_t ETHIOPIC_SYLLABLE_ZZEE = 0x2DB4;
const char32_t ETHIOPIC_SYLLABLE_ZZE = 0x2DB5;
const char32_t ETHIOPIC_SYLLABLE_ZZO = 0x2DB6;
const char32_t ETHIOPIC_SYLLABLE_CCHA = 0x2DB8;
const char32_t ETHIOPIC_SYLLABLE_CCHU = 0x2DB9;
const char32_t ETHIOPIC_SYLLABLE_CCHI = 0x2DBA;
const char32_t ETHIOPIC_SYLLABLE_CCHAA = 0x2DBB;
const char32_t ETHIOPIC_SYLLABLE_CCHEE = 0x2DBC;
const char32_t ETHIOPIC_SYLLABLE_CCHE = 0x2DBD;
const char32_t ETHIOPIC_SYLLABLE_CCHO = 0x2DBE;
const char32_t ETHIOPIC_SYLLABLE_QYA = 0x2DC0;
const char32_t ETHIOPIC_SYLLABLE_QYU = 0x2DC1;
const char32_t ETHIOPIC_SYLLABLE_QYI = 0x2DC2;
const char32_t ETHIOPIC_SYLLABLE_QYAA = 0x2DC3;
const char32_t ETHIOPIC_SYLLABLE_QYEE = 0x2DC4;
const char32_t ETHIOPIC_SYLLABLE_QYE = 0x2DC5;
const char32_t ETHIOPIC_SYLLABLE_QYO = 0x2DC6;
const char32_t ETHIOPIC_SYLLABLE_KYA = 0x2DC8;
const char32_t ETHIOPIC_SYLLABLE_KYU = 0x2DC9;
const char32_t ETHIOPIC_SYLLABLE_KYI = 0x2DCA;
const char32_t ETHIOPIC_SYLLABLE_KYAA = 0x2DCB;
const char32_t ETHIOPIC_SYLLABLE_KYEE = 0x2DCC;
const char32_t ETHIOPIC_SYLLABLE_KYE = 0x2DCD;
const char32_t ETHIOPIC_SYLLABLE_KYO = 0x2DCE;
const char32_t ETHIOPIC_SYLLABLE_XYA = 0x2DD0;
const char32_t ETHIOPIC_SYLLABLE_XYU = 0x2DD1;
const char32_t ETHIOPIC_SYLLABLE_XYI = 0x2DD2;
const char32_t ETHIOPIC_SYLLABLE_XYAA = 0x2DD3;
const char32_t ETHIOPIC_SYLLABLE_XYEE = 0x2DD4;
const char32_t ETHIOPIC_SYLLABLE_XYE = 0x2DD5;
const char32_t ETHIOPIC_SYLLABLE_XYO = 0x2DD6;
const char32_t ETHIOPIC_SYLLABLE_GYA = 0x2DD8;
const char32_t ETHIOPIC_SYLLABLE_GYU = 0x2DD9;
const char32_t ETHIOPIC_SYLLABLE_GYI = 0x2DDA;
const char32_t ETHIOPIC_SYLLABLE_GYAA = 0x2DDB;
const char32_t ETHIOPIC_SYLLABLE_GYEE = 0x2DDC;
const char32_t ETHIOPIC_SYLLABLE_GYE = 0x2DDD;
const char32_t ETHIOPIC_SYLLABLE_GYO = 0x2DDE;
const char32_t COMBINING_CYRILLIC_LETTER_BE = 0x2DE0;
const char32_t COMBINING_CYRILLIC_LETTER_VE = 0x2DE1;
const char32_t COMBINING_CYRILLIC_LETTER_GHE = 0x2DE2;
const char32_t COMBINING_CYRILLIC_LETTER_DE = 0x2DE3;
const char32_t COMBINING_CYRILLIC_LETTER_ZHE = 0x2DE4;
const char32_t COMBINING_CYRILLIC_LETTER_ZE = 0x2DE5;
const char32_t COMBINING_CYRILLIC_LETTER_KA = 0x2DE6;
const char32_t COMBINING_CYRILLIC_LETTER_EL = 0x2DE7;
const char32_t COMBINING_CYRILLIC_LETTER_EM = 0x2DE8;
const char32_t COMBINING_CYRILLIC_LETTER_EN = 0x2DE9;
const char32_t COMBINING_CYRILLIC_LETTER_O = 0x2DEA;
const char32_t COMBINING_CYRILLIC_LETTER_PE = 0x2DEB;
const char32_t COMBINING_CYRILLIC_LETTER_ER = 0x2DEC;
const char32_t COMBINING_CYRILLIC_LETTER_ES = 0x2DED;
const char32_t COMBINING_CYRILLIC_LETTER_TE = 0x2DEE;
const char32_t COMBINING_CYRILLIC_LETTER_HA = 0x2DEF;
const char32_t COMBINING_CYRILLIC_LETTER_TSE = 0x2DF0;
const char32_t COMBINING_CYRILLIC_LETTER_CHE = 0x2DF1;
const char32_t COMBINING_CYRILLIC_LETTER_SHA = 0x2DF2;
const char32_t COMBINING_CYRILLIC_LETTER_SHCHA = 0x2DF3;
const char32_t COMBINING_CYRILLIC_LETTER_FITA = 0x2DF4;
const char32_t COMBINING_CYRILLIC_LETTER_ES_TE = 0x2DF5;
const char32_t COMBINING_CYRILLIC_LETTER_A = 0x2DF6;
const char32_t COMBINING_CYRILLIC_LETTER_IE = 0x2DF7;
const char32_t COMBINING_CYRILLIC_LETTER_DJERV = 0x2DF8;
const char32_t COMBINING_CYRILLIC_LETTER_MONOGRAPH_UK = 0x2DF9;
const char32_t COMBINING_CYRILLIC_LETTER_YAT = 0x2DFA;
const char32_t COMBINING_CYRILLIC_LETTER_YU = 0x2DFB;
const char32_t COMBINING_CYRILLIC_LETTER_IOTIFIED_A = 0x2DFC;
const char32_t COMBINING_CYRILLIC_LETTER_LITTLE_YUS = 0x2DFD;
const char32_t COMBINING_CYRILLIC_LETTER_BIG_YUS = 0x2DFE;
const char32_t COMBINING_CYRILLIC_LETTER_IOTIFIED_BIG_YUS = 0x2DFF;
const char32_t RIGHT_ANGLE_SUBSTITUTION_MARKER = 0x2E00;
const char32_t RIGHT_ANGLE_DOTTED_SUBSTITUTION_MARKER = 0x2E01;
const char32_t LEFT_SUBSTITUTION_BRACKET = 0x2E02;
const char32_t RIGHT_SUBSTITUTION_BRACKET = 0x2E03;
const char32_t LEFT_DOTTED_SUBSTITUTION_BRACKET = 0x2E04;
const char32_t RIGHT_DOTTED_SUBSTITUTION_BRACKET = 0x2E05;
const char32_t RAISED_INTERPOLATION_MARKER = 0x2E06;
const char32_t RAISED_DOTTED_INTERPOLATION_MARKER = 0x2E07;
const char32_t DOTTED_TRANSPOSITION_MARKER = 0x2E08;
const char32_t LEFT_TRANSPOSITION_BRACKET = 0x2E09;
const char32_t RIGHT_TRANSPOSITION_BRACKET = 0x2E0A;
const char32_t RAISED_SQUARE = 0x2E0B;
const char32_t LEFT_RAISED_OMISSION_BRACKET = 0x2E0C;
const char32_t RIGHT_RAISED_OMISSION_BRACKET = 0x2E0D;
const char32_t EDITORIAL_CORONIS = 0x2E0E;
const char32_t PARAGRAPHOS = 0x2E0F;
const char32_t FORKED_PARAGRAPHOS = 0x2E10;
const char32_t REVERSED_FORKED_PARAGRAPHOS = 0x2E11;
const char32_t HYPODIASTOLE = 0x2E12;
const char32_t DOTTED_OBELOS = 0x2E13;
const char32_t DOWNWARDS_ANCORA = 0x2E14;
const char32_t UPWARDS_ANCORA = 0x2E15;
const char32_t DOTTED_RIGHT_POINTING_ANGLE = 0x2E16;
const char32_t DOUBLE_OBLIQUE_HYPHEN = 0x2E17;
const char32_t INVERTED_INTERROBANG = 0x2E18;
const char32_t PALM_BRANCH = 0x2E19;
const char32_t HYPHEN_WITH_DIAERESIS = 0x2E1A;
const char32_t TILDE_WITH_RING_ABOVE = 0x2E1B;
const char32_t LEFT_LOW_PARAPHRASE_BRACKET = 0x2E1C;
const char32_t RIGHT_LOW_PARAPHRASE_BRACKET = 0x2E1D;
const char32_t TILDE_WITH_DOT_ABOVE = 0x2E1E;
const char32_t TILDE_WITH_DOT_BELOW = 0x2E1F;
const char32_t LEFT_VERTICAL_BAR_WITH_QUILL = 0x2E20;
const char32_t RIGHT_VERTICAL_BAR_WITH_QUILL = 0x2E21;
const char32_t TOP_LEFT_HALF_BRACKET = 0x2E22;
const char32_t TOP_RIGHT_HALF_BRACKET = 0x2E23;
const char32_t BOTTOM_LEFT_HALF_BRACKET = 0x2E24;
const char32_t BOTTOM_RIGHT_HALF_BRACKET = 0x2E25;
const char32_t LEFT_SIDEWAYS_U_BRACKET = 0x2E26;
const char32_t RIGHT_SIDEWAYS_U_BRACKET = 0x2E27;
const char32_t LEFT_DOUBLE_PARENTHESIS = 0x2E28;
const char32_t RIGHT_DOUBLE_PARENTHESIS = 0x2E29;
const char32_t TWO_DOTS_OVER_ONE_DOT_PUNCTUATION = 0x2E2A;
const char32_t ONE_DOT_OVER_TWO_DOTS_PUNCTUATION = 0x2E2B;
const char32_t SQUARED_FOUR_DOT_PUNCTUATION = 0x2E2C;
const char32_t FIVE_DOT_MARK = 0x2E2D;
const char32_t REVERSED_QUESTION_MARK = 0x2E2E;
const char32_t VERTICAL_TILDE = 0x2E2F;
const char32_t RING_POINT = 0x2E30;
const char32_t WORD_SEPARATOR_MIDDLE_DOT = 0x2E31;
const char32_t TURNED_COMMA = 0x2E32;
const char32_t RAISED_DOT = 0x2E33;
const char32_t RAISED_COMMA = 0x2E34;
const char32_t TURNED_SEMICOLON = 0x2E35;
const char32_t DAGGER_WITH_LEFT_GUARD = 0x2E36;
const char32_t DAGGER_WITH_RIGHT_GUARD = 0x2E37;
const char32_t TURNED_DAGGER = 0x2E38;
const char32_t TOP_HALF_SECTION_SIGN = 0x2E39;
const char32_t TWO_EM_DASH = 0x2E3A;
const char32_t THREE_EM_DASH = 0x2E3B;
const char32_t STENOGRAPHIC_FULL_STOP = 0x2E3C;
const char32_t VERTICAL_SIX_DOTS = 0x2E3D;
const char32_t WIGGLY_VERTICAL_LINE = 0x2E3E;
const char32_t CAPITULUM = 0x2E3F;
const char32_t DOUBLE_HYPHEN = 0x2E40;
const char32_t REVERSED_COMMA = 0x2E41;
const char32_t DOUBLE_LOW_REVERSED_9_QUOTATION_MARK = 0x2E42;
const char32_t DASH_WITH_LEFT_UPTURN = 0x2E43;
const char32_t DOUBLE_SUSPENSION_MARK = 0x2E44;
const char32_t INVERTED_LOW_KAVYKA = 0x2E45;
const char32_t INVERTED_LOW_KAVYKA_WITH_KAVYKA_ABOVE = 0x2E46;
const char32_t LOW_KAVYKA = 0x2E47;
const char32_t LOW_KAVYKA_WITH_DOT = 0x2E48;
const char32_t DOUBLE_STACKED_COMMA = 0x2E49;
const char32_t DOTTED_SOLIDUS = 0x2E4A;
const char32_t TRIPLE_DAGGER = 0x2E4B;
const char32_t MEDIEVAL_COMMA = 0x2E4C;
const char32_t PARAGRAPHUS_MARK = 0x2E4D;
const char32_t PUNCTUS_ELEVATUS_MARK = 0x2E4E;
const char32_t CORNISH_VERSE_DIVIDER = 0x2E4F;
const char32_t CROSS_PATTY_WITH_RIGHT_CROSSBAR = 0x2E50;
const char32_t CROSS_PATTY_WITH_LEFT_CROSSBAR = 0x2E51;
const char32_t TIRONIAN_SIGN_CAPITAL_ET = 0x2E52;
const char32_t CJK_RADICAL_REPEAT = 0x2E80;
const char32_t CJK_RADICAL_CLIFF = 0x2E81;
const char32_t CJK_RADICAL_SECOND_ONE = 0x2E82;
const char32_t CJK_RADICAL_SECOND_TWO = 0x2E83;
const char32_t CJK_RADICAL_SECOND_THREE = 0x2E84;
const char32_t CJK_RADICAL_PERSON = 0x2E85;
const char32_t CJK_RADICAL_BOX = 0x2E86;
const char32_t CJK_RADICAL_TABLE = 0x2E87;
const char32_t CJK_RADICAL_KNIFE_ONE = 0x2E88;
const char32_t CJK_RADICAL_KNIFE_TWO = 0x2E89;
const char32_t CJK_RADICAL_DIVINATION = 0x2E8A;
const char32_t CJK_RADICAL_SEAL = 0x2E8B;
const char32_t CJK_RADICAL_SMALL_ONE = 0x2E8C;
const char32_t CJK_RADICAL_SMALL_TWO = 0x2E8D;
const char32_t CJK_RADICAL_LAME_ONE = 0x2E8E;
const char32_t CJK_RADICAL_LAME_TWO = 0x2E8F;
const char32_t CJK_RADICAL_LAME_THREE = 0x2E90;
const char32_t CJK_RADICAL_LAME_FOUR = 0x2E91;
const char32_t CJK_RADICAL_SNAKE = 0x2E92;
const char32_t CJK_RADICAL_THREAD = 0x2E93;
const char32_t CJK_RADICAL_SNOUT_ONE = 0x2E94;
const char32_t CJK_RADICAL_SNOUT_TWO = 0x2E95;
const char32_t CJK_RADICAL_HEART_ONE = 0x2E96;
const char32_t CJK_RADICAL_HEART_TWO = 0x2E97;
const char32_t CJK_RADICAL_HAND = 0x2E98;
const char32_t CJK_RADICAL_RAP = 0x2E99;
const char32_t CJK_RADICAL_CHOKE = 0x2E9B;
const char32_t CJK_RADICAL_SUN = 0x2E9C;
const char32_t CJK_RADICAL_MOON = 0x2E9D;
const char32_t CJK_RADICAL_DEATH = 0x2E9E;
const char32_t CJK_RADICAL_MOTHER = 0x2E9F;
const char32_t CJK_RADICAL_CIVILIAN = 0x2EA0;
const char32_t CJK_RADICAL_WATER_ONE = 0x2EA1;
const char32_t CJK_RADICAL_WATER_TWO = 0x2EA2;
const char32_t CJK_RADICAL_FIRE = 0x2EA3;
const char32_t CJK_RADICAL_PAW_ONE = 0x2EA4;
const char32_t CJK_RADICAL_PAW_TWO = 0x2EA5;
const char32_t CJK_RADICAL_SIMPLIFIED_HALF_TREE_TRUNK = 0x2EA6;
const char32_t CJK_RADICAL_COW = 0x2EA7;
const char32_t CJK_RADICAL_DOG = 0x2EA8;
const char32_t CJK_RADICAL_JADE = 0x2EA9;
const char32_t CJK_RADICAL_BOLT_OF_CLOTH = 0x2EAA;
const char32_t CJK_RADICAL_EYE = 0x2EAB;
const char32_t CJK_RADICAL_SPIRIT_ONE = 0x2EAC;
const char32_t CJK_RADICAL_SPIRIT_TWO = 0x2EAD;
const char32_t CJK_RADICAL_BAMBOO = 0x2EAE;
const char32_t CJK_RADICAL_SILK = 0x2EAF;
const char32_t CJK_RADICAL_C_SIMPLIFIED_SILK = 0x2EB0;
const char32_t CJK_RADICAL_NET_ONE = 0x2EB1;
const char32_t CJK_RADICAL_NET_TWO = 0x2EB2;
const char32_t CJK_RADICAL_NET_THREE = 0x2EB3;
const char32_t CJK_RADICAL_NET_FOUR = 0x2EB4;
const char32_t CJK_RADICAL_MESH = 0x2EB5;
const char32_t CJK_RADICAL_SHEEP = 0x2EB6;
const char32_t CJK_RADICAL_RAM = 0x2EB7;
const char32_t CJK_RADICAL_EWE = 0x2EB8;
const char32_t CJK_RADICAL_OLD = 0x2EB9;
const char32_t CJK_RADICAL_BRUSH_ONE = 0x2EBA;
const char32_t CJK_RADICAL_BRUSH_TWO = 0x2EBB;
const char32_t CJK_RADICAL_MEAT = 0x2EBC;
const char32_t CJK_RADICAL_MORTAR = 0x2EBD;
const char32_t CJK_RADICAL_GRASS_ONE = 0x2EBE;
const char32_t CJK_RADICAL_GRASS_TWO = 0x2EBF;
const char32_t CJK_RADICAL_GRASS_THREE = 0x2EC0;
const char32_t CJK_RADICAL_TIGER = 0x2EC1;
const char32_t CJK_RADICAL_CLOTHES = 0x2EC2;
const char32_t CJK_RADICAL_WEST_ONE = 0x2EC3;
const char32_t CJK_RADICAL_WEST_TWO = 0x2EC4;
const char32_t CJK_RADICAL_C_SIMPLIFIED_SEE = 0x2EC5;
const char32_t CJK_RADICAL_SIMPLIFIED_HORN = 0x2EC6;
const char32_t CJK_RADICAL_HORN = 0x2EC7;
const char32_t CJK_RADICAL_C_SIMPLIFIED_SPEECH = 0x2EC8;
const char32_t CJK_RADICAL_C_SIMPLIFIED_SHELL = 0x2EC9;
const char32_t CJK_RADICAL_FOOT = 0x2ECA;
const char32_t CJK_RADICAL_C_SIMPLIFIED_CART = 0x2ECB;
const char32_t CJK_RADICAL_SIMPLIFIED_WALK = 0x2ECC;
const char32_t CJK_RADICAL_WALK_ONE = 0x2ECD;
const char32_t CJK_RADICAL_WALK_TWO = 0x2ECE;
const char32_t CJK_RADICAL_CITY = 0x2ECF;
const char32_t CJK_RADICAL_C_SIMPLIFIED_GOLD = 0x2ED0;
const char32_t CJK_RADICAL_LONG_ONE = 0x2ED1;
const char32_t CJK_RADICAL_LONG_TWO = 0x2ED2;
const char32_t CJK_RADICAL_C_SIMPLIFIED_LONG = 0x2ED3;
const char32_t CJK_RADICAL_C_SIMPLIFIED_GATE = 0x2ED4;
const char32_t CJK_RADICAL_MOUND_ONE = 0x2ED5;
const char32_t CJK_RADICAL_MOUND_TWO = 0x2ED6;
const char32_t CJK_RADICAL_RAIN = 0x2ED7;
const char32_t CJK_RADICAL_BLUE = 0x2ED8;
const char32_t CJK_RADICAL_C_SIMPLIFIED_TANNED_LEATHER = 0x2ED9;
const char32_t CJK_RADICAL_C_SIMPLIFIED_LEAF = 0x2EDA;
const char32_t CJK_RADICAL_C_SIMPLIFIED_WIND = 0x2EDB;
const char32_t CJK_RADICAL_C_SIMPLIFIED_FLY = 0x2EDC;
const char32_t CJK_RADICAL_EAT_ONE = 0x2EDD;
const char32_t CJK_RADICAL_EAT_TWO = 0x2EDE;
const char32_t CJK_RADICAL_EAT_THREE = 0x2EDF;
const char32_t CJK_RADICAL_C_SIMPLIFIED_EAT = 0x2EE0;
const char32_t CJK_RADICAL_HEAD = 0x2EE1;
const char32_t CJK_RADICAL_C_SIMPLIFIED_HORSE = 0x2EE2;
const char32_t CJK_RADICAL_BONE = 0x2EE3;
const char32_t CJK_RADICAL_GHOST = 0x2EE4;
const char32_t CJK_RADICAL_C_SIMPLIFIED_FISH = 0x2EE5;
const char32_t CJK_RADICAL_C_SIMPLIFIED_BIRD = 0x2EE6;
const char32_t CJK_RADICAL_C_SIMPLIFIED_SALT = 0x2EE7;
const char32_t CJK_RADICAL_SIMPLIFIED_WHEAT = 0x2EE8;
const char32_t CJK_RADICAL_SIMPLIFIED_YELLOW = 0x2EE9;
const char32_t CJK_RADICAL_C_SIMPLIFIED_FROG = 0x2EEA;
const char32_t CJK_RADICAL_J_SIMPLIFIED_EVEN = 0x2EEB;
const char32_t CJK_RADICAL_C_SIMPLIFIED_EVEN = 0x2EEC;
const char32_t CJK_RADICAL_J_SIMPLIFIED_TOOTH = 0x2EED;
const char32_t CJK_RADICAL_C_SIMPLIFIED_TOOTH = 0x2EEE;
const char32_t CJK_RADICAL_J_SIMPLIFIED_DRAGON = 0x2EEF;
const char32_t CJK_RADICAL_C_SIMPLIFIED_DRAGON = 0x2EF0;
const char32_t CJK_RADICAL_TURTLE = 0x2EF1;
const char32_t CJK_RADICAL_J_SIMPLIFIED_TURTLE = 0x2EF2;
const char32_t CJK_RADICAL_C_SIMPLIFIED_TURTLE = 0x2EF3;
const char32_t KANGXI_RADICAL_ONE = 0x2F00;
const char32_t KANGXI_RADICAL_LINE = 0x2F01;
const char32_t KANGXI_RADICAL_DOT = 0x2F02;
const char32_t KANGXI_RADICAL_SLASH = 0x2F03;
const char32_t KANGXI_RADICAL_SECOND = 0x2F04;
const char32_t KANGXI_RADICAL_HOOK = 0x2F05;
const char32_t KANGXI_RADICAL_TWO = 0x2F06;
const char32_t KANGXI_RADICAL_LID = 0x2F07;
const char32_t KANGXI_RADICAL_MAN = 0x2F08;
const char32_t KANGXI_RADICAL_LEGS = 0x2F09;
const char32_t KANGXI_RADICAL_ENTER = 0x2F0A;
const char32_t KANGXI_RADICAL_EIGHT = 0x2F0B;
const char32_t KANGXI_RADICAL_DOWN_BOX = 0x2F0C;
const char32_t KANGXI_RADICAL_COVER = 0x2F0D;
const char32_t KANGXI_RADICAL_ICE = 0x2F0E;
const char32_t KANGXI_RADICAL_TABLE = 0x2F0F;
const char32_t KANGXI_RADICAL_OPEN_BOX = 0x2F10;
const char32_t KANGXI_RADICAL_KNIFE = 0x2F11;
const char32_t KANGXI_RADICAL_POWER = 0x2F12;
const char32_t KANGXI_RADICAL_WRAP = 0x2F13;
const char32_t KANGXI_RADICAL_SPOON = 0x2F14;
const char32_t KANGXI_RADICAL_RIGHT_OPEN_BOX = 0x2F15;
const char32_t KANGXI_RADICAL_HIDING_ENCLOSURE = 0x2F16;
const char32_t KANGXI_RADICAL_TEN = 0x2F17;
const char32_t KANGXI_RADICAL_DIVINATION = 0x2F18;
const char32_t KANGXI_RADICAL_SEAL = 0x2F19;
const char32_t KANGXI_RADICAL_CLIFF = 0x2F1A;
const char32_t KANGXI_RADICAL_PRIVATE = 0x2F1B;
const char32_t KANGXI_RADICAL_AGAIN = 0x2F1C;
const char32_t KANGXI_RADICAL_MOUTH = 0x2F1D;
const char32_t KANGXI_RADICAL_ENCLOSURE = 0x2F1E;
const char32_t KANGXI_RADICAL_EARTH = 0x2F1F;
const char32_t KANGXI_RADICAL_SCHOLAR = 0x2F20;
const char32_t KANGXI_RADICAL_GO = 0x2F21;
const char32_t KANGXI_RADICAL_GO_SLOWLY = 0x2F22;
const char32_t KANGXI_RADICAL_EVENING = 0x2F23;
const char32_t KANGXI_RADICAL_BIG = 0x2F24;
const char32_t KANGXI_RADICAL_WOMAN = 0x2F25;
const char32_t KANGXI_RADICAL_CHILD = 0x2F26;
const char32_t KANGXI_RADICAL_ROOF = 0x2F27;
const char32_t KANGXI_RADICAL_INCH = 0x2F28;
const char32_t KANGXI_RADICAL_SMALL = 0x2F29;
const char32_t KANGXI_RADICAL_LAME = 0x2F2A;
const char32_t KANGXI_RADICAL_CORPSE = 0x2F2B;
const char32_t KANGXI_RADICAL_SPROUT = 0x2F2C;
const char32_t KANGXI_RADICAL_MOUNTAIN = 0x2F2D;
const char32_t KANGXI_RADICAL_RIVER = 0x2F2E;
const char32_t KANGXI_RADICAL_WORK = 0x2F2F;
const char32_t KANGXI_RADICAL_ONESELF = 0x2F30;
const char32_t KANGXI_RADICAL_TURBAN = 0x2F31;
const char32_t KANGXI_RADICAL_DRY = 0x2F32;
const char32_t KANGXI_RADICAL_SHORT_THREAD = 0x2F33;
const char32_t KANGXI_RADICAL_DOTTED_CLIFF = 0x2F34;
const char32_t KANGXI_RADICAL_LONG_STRIDE = 0x2F35;
const char32_t KANGXI_RADICAL_TWO_HANDS = 0x2F36;
const char32_t KANGXI_RADICAL_SHOOT = 0x2F37;
const char32_t KANGXI_RADICAL_BOW = 0x2F38;
const char32_t KANGXI_RADICAL_SNOUT = 0x2F39;
const char32_t KANGXI_RADICAL_BRISTLE = 0x2F3A;
const char32_t KANGXI_RADICAL_STEP = 0x2F3B;
const char32_t KANGXI_RADICAL_HEART = 0x2F3C;
const char32_t KANGXI_RADICAL_HALBERD = 0x2F3D;
const char32_t KANGXI_RADICAL_DOOR = 0x2F3E;
const char32_t KANGXI_RADICAL_HAND = 0x2F3F;
const char32_t KANGXI_RADICAL_BRANCH = 0x2F40;
const char32_t KANGXI_RADICAL_RAP = 0x2F41;
const char32_t KANGXI_RADICAL_SCRIPT = 0x2F42;
const char32_t KANGXI_RADICAL_DIPPER = 0x2F43;
const char32_t KANGXI_RADICAL_AXE = 0x2F44;
const char32_t KANGXI_RADICAL_SQUARE = 0x2F45;
const char32_t KANGXI_RADICAL_NOT = 0x2F46;
const char32_t KANGXI_RADICAL_SUN = 0x2F47;
const char32_t KANGXI_RADICAL_SAY = 0x2F48;
const char32_t KANGXI_RADICAL_MOON = 0x2F49;
const char32_t KANGXI_RADICAL_TREE = 0x2F4A;
const char32_t KANGXI_RADICAL_LACK = 0x2F4B;
const char32_t KANGXI_RADICAL_STOP = 0x2F4C;
const char32_t KANGXI_RADICAL_DEATH = 0x2F4D;
const char32_t KANGXI_RADICAL_WEAPON = 0x2F4E;
const char32_t KANGXI_RADICAL_DO_NOT = 0x2F4F;
const char32_t KANGXI_RADICAL_COMPARE = 0x2F50;
const char32_t KANGXI_RADICAL_FUR = 0x2F51;
const char32_t KANGXI_RADICAL_CLAN = 0x2F52;
const char32_t KANGXI_RADICAL_STEAM = 0x2F53;
const char32_t KANGXI_RADICAL_WATER = 0x2F54;
const char32_t KANGXI_RADICAL_FIRE = 0x2F55;
const char32_t KANGXI_RADICAL_CLAW = 0x2F56;
const char32_t KANGXI_RADICAL_FATHER = 0x2F57;
const char32_t KANGXI_RADICAL_DOUBLE_X = 0x2F58;
const char32_t KANGXI_RADICAL_HALF_TREE_TRUNK = 0x2F59;
const char32_t KANGXI_RADICAL_SLICE = 0x2F5A;
const char32_t KANGXI_RADICAL_FANG = 0x2F5B;
const char32_t KANGXI_RADICAL_COW = 0x2F5C;
const char32_t KANGXI_RADICAL_DOG = 0x2F5D;
const char32_t KANGXI_RADICAL_PROFOUND = 0x2F5E;
const char32_t KANGXI_RADICAL_JADE = 0x2F5F;
const char32_t KANGXI_RADICAL_MELON = 0x2F60;
const char32_t KANGXI_RADICAL_TILE = 0x2F61;
const char32_t KANGXI_RADICAL_SWEET = 0x2F62;
const char32_t KANGXI_RADICAL_LIFE = 0x2F63;
const char32_t KANGXI_RADICAL_USE = 0x2F64;
const char32_t KANGXI_RADICAL_FIELD = 0x2F65;
const char32_t KANGXI_RADICAL_BOLT_OF_CLOTH = 0x2F66;
const char32_t KANGXI_RADICAL_SICKNESS = 0x2F67;
const char32_t KANGXI_RADICAL_DOTTED_TENT = 0x2F68;
const char32_t KANGXI_RADICAL_WHITE = 0x2F69;
const char32_t KANGXI_RADICAL_SKIN = 0x2F6A;
const char32_t KANGXI_RADICAL_DISH = 0x2F6B;
const char32_t KANGXI_RADICAL_EYE = 0x2F6C;
const char32_t KANGXI_RADICAL_SPEAR = 0x2F6D;
const char32_t KANGXI_RADICAL_ARROW = 0x2F6E;
const char32_t KANGXI_RADICAL_STONE = 0x2F6F;
const char32_t KANGXI_RADICAL_SPIRIT = 0x2F70;
const char32_t KANGXI_RADICAL_TRACK = 0x2F71;
const char32_t KANGXI_RADICAL_GRAIN = 0x2F72;
const char32_t KANGXI_RADICAL_CAVE = 0x2F73;
const char32_t KANGXI_RADICAL_STAND = 0x2F74;
const char32_t KANGXI_RADICAL_BAMBOO = 0x2F75;
const char32_t KANGXI_RADICAL_RICE = 0x2F76;
const char32_t KANGXI_RADICAL_SILK = 0x2F77;
const char32_t KANGXI_RADICAL_JAR = 0x2F78;
const char32_t KANGXI_RADICAL_NET = 0x2F79;
const char32_t KANGXI_RADICAL_SHEEP = 0x2F7A;
const char32_t KANGXI_RADICAL_FEATHER = 0x2F7B;
const char32_t KANGXI_RADICAL_OLD = 0x2F7C;
const char32_t KANGXI_RADICAL_AND = 0x2F7D;
const char32_t KANGXI_RADICAL_PLOW = 0x2F7E;
const char32_t KANGXI_RADICAL_EAR = 0x2F7F;
const char32_t KANGXI_RADICAL_BRUSH = 0x2F80;
const char32_t KANGXI_RADICAL_MEAT = 0x2F81;
const char32_t KANGXI_RADICAL_MINISTER = 0x2F82;
const char32_t KANGXI_RADICAL_SELF = 0x2F83;
const char32_t KANGXI_RADICAL_ARRIVE = 0x2F84;
const char32_t KANGXI_RADICAL_MORTAR = 0x2F85;
const char32_t KANGXI_RADICAL_TONGUE = 0x2F86;
const char32_t KANGXI_RADICAL_OPPOSE = 0x2F87;
const char32_t KANGXI_RADICAL_BOAT = 0x2F88;
const char32_t KANGXI_RADICAL_STOPPING = 0x2F89;
const char32_t KANGXI_RADICAL_COLOR = 0x2F8A;
const char32_t KANGXI_RADICAL_GRASS = 0x2F8B;
const char32_t KANGXI_RADICAL_TIGER = 0x2F8C;
const char32_t KANGXI_RADICAL_INSECT = 0x2F8D;
const char32_t KANGXI_RADICAL_BLOOD = 0x2F8E;
const char32_t KANGXI_RADICAL_WALK_ENCLOSURE = 0x2F8F;
const char32_t KANGXI_RADICAL_CLOTHES = 0x2F90;
const char32_t KANGXI_RADICAL_WEST = 0x2F91;
const char32_t KANGXI_RADICAL_SEE = 0x2F92;
const char32_t KANGXI_RADICAL_HORN = 0x2F93;
const char32_t KANGXI_RADICAL_SPEECH = 0x2F94;
const char32_t KANGXI_RADICAL_VALLEY = 0x2F95;
const char32_t KANGXI_RADICAL_BEAN = 0x2F96;
const char32_t KANGXI_RADICAL_PIG = 0x2F97;
const char32_t KANGXI_RADICAL_BADGER = 0x2F98;
const char32_t KANGXI_RADICAL_SHELL = 0x2F99;
const char32_t KANGXI_RADICAL_RED = 0x2F9A;
const char32_t KANGXI_RADICAL_RUN = 0x2F9B;
const char32_t KANGXI_RADICAL_FOOT = 0x2F9C;
const char32_t KANGXI_RADICAL_BODY = 0x2F9D;
const char32_t KANGXI_RADICAL_CART = 0x2F9E;
const char32_t KANGXI_RADICAL_BITTER = 0x2F9F;
const char32_t KANGXI_RADICAL_MORNING = 0x2FA0;
const char32_t KANGXI_RADICAL_WALK = 0x2FA1;
const char32_t KANGXI_RADICAL_CITY = 0x2FA2;
const char32_t KANGXI_RADICAL_WINE = 0x2FA3;
const char32_t KANGXI_RADICAL_DISTINGUISH = 0x2FA4;
const char32_t KANGXI_RADICAL_VILLAGE = 0x2FA5;
const char32_t KANGXI_RADICAL_GOLD = 0x2FA6;
const char32_t KANGXI_RADICAL_LONG = 0x2FA7;
const char32_t KANGXI_RADICAL_GATE = 0x2FA8;
const char32_t KANGXI_RADICAL_MOUND = 0x2FA9;
const char32_t KANGXI_RADICAL_SLAVE = 0x2FAA;
const char32_t KANGXI_RADICAL_SHORT_TAILED_BIRD = 0x2FAB;
const char32_t KANGXI_RADICAL_RAIN = 0x2FAC;
const char32_t KANGXI_RADICAL_BLUE = 0x2FAD;
const char32_t KANGXI_RADICAL_WRONG = 0x2FAE;
const char32_t KANGXI_RADICAL_FACE = 0x2FAF;
const char32_t KANGXI_RADICAL_LEATHER = 0x2FB0;
const char32_t KANGXI_RADICAL_TANNED_LEATHER = 0x2FB1;
const char32_t KANGXI_RADICAL_LEEK = 0x2FB2;
const char32_t KANGXI_RADICAL_SOUND = 0x2FB3;
const char32_t KANGXI_RADICAL_LEAF = 0x2FB4;
const char32_t KANGXI_RADICAL_WIND = 0x2FB5;
const char32_t KANGXI_RADICAL_FLY = 0x2FB6;
const char32_t KANGXI_RADICAL_EAT = 0x2FB7;
const char32_t KANGXI_RADICAL_HEAD = 0x2FB8;
const char32_t KANGXI_RADICAL_FRAGRANT = 0x2FB9;
const char32_t KANGXI_RADICAL_HORSE = 0x2FBA;
const char32_t KANGXI_RADICAL_BONE = 0x2FBB;
const char32_t KANGXI_RADICAL_TALL = 0x2FBC;
const char32_t KANGXI_RADICAL_HAIR = 0x2FBD;
const char32_t KANGXI_RADICAL_FIGHT = 0x2FBE;
const char32_t KANGXI_RADICAL_SACRIFICIAL_WINE = 0x2FBF;
const char32_t KANGXI_RADICAL_CAULDRON = 0x2FC0;
const char32_t KANGXI_RADICAL_GHOST = 0x2FC1;
const char32_t KANGXI_RADICAL_FISH = 0x2FC2;
const char32_t KANGXI_RADICAL_BIRD = 0x2FC3;
const char32_t KANGXI_RADICAL_SALT = 0x2FC4;
const char32_t KANGXI_RADICAL_DEER = 0x2FC5;
const char32_t KANGXI_RADICAL_WHEAT = 0x2FC6;
const char32_t KANGXI_RADICAL_HEMP = 0x2FC7;
const char32_t KANGXI_RADICAL_YELLOW = 0x2FC8;
const char32_t KANGXI_RADICAL_MILLET = 0x2FC9;
const char32_t KANGXI_RADICAL_BLACK = 0x2FCA;
const char32_t KANGXI_RADICAL_EMBROIDERY = 0x2FCB;
const char32_t KANGXI_RADICAL_FROG = 0x2FCC;
const char32_t KANGXI_RADICAL_TRIPOD = 0x2FCD;
const char32_t KANGXI_RADICAL_DRUM = 0x2FCE;
const char32_t KANGXI_RADICAL_RAT = 0x2FCF;
const char32_t KANGXI_RADICAL_NOSE = 0x2FD0;
const char32_t KANGXI_RADICAL_EVEN = 0x2FD1;
const char32_t KANGXI_RADICAL_TOOTH = 0x2FD2;
const char32_t KANGXI_RADICAL_DRAGON = 0x2FD3;
const char32_t KANGXI_RADICAL_TURTLE = 0x2FD4;
const char32_t KANGXI_RADICAL_FLUTE = 0x2FD5;
const char32_t IDEOGRAPHIC_DESCRIPTION_CHARACTER_LEFT_TO_RIGHT = 0x2FF0;
const char32_t IDEOGRAPHIC_DESCRIPTION_CHARACTER_ABOVE_TO_BELOW = 0x2FF1;
const char32_t IDEOGRAPHIC_DESCRIPTION_CHARACTER_LEFT_TO_MIDDLE_AND_RIGHT = 0x2FF2;
const char32_t IDEOGRAPHIC_DESCRIPTION_CHARACTER_ABOVE_TO_MIDDLE_AND_BELOW = 0x2FF3;
const char32_t IDEOGRAPHIC_DESCRIPTION_CHARACTER_FULL_SURROUND = 0x2FF4;
const char32_t IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_ABOVE = 0x2FF5;
const char32_t IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_BELOW = 0x2FF6;
const char32_t IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_LEFT = 0x2FF7;
const char32_t IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_UPPER_LEFT = 0x2FF8;
const char32_t IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_UPPER_RIGHT = 0x2FF9;
const char32_t IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_LOWER_LEFT = 0x2FFA;
const char32_t IDEOGRAPHIC_DESCRIPTION_CHARACTER_OVERLAID = 0x2FFB;
const char32_t IDEOGRAPHIC_SPACE = 0x3000;
const char32_t IDEOGRAPHIC_COMMA = 0x3001;
const char32_t IDEOGRAPHIC_FULL_STOP = 0x3002;
const char32_t DITTO_MARK = 0x3003;
const char32_t JAPANESE_INDUSTRIAL_STANDARD_SYMBOL = 0x3004;
const char32_t IDEOGRAPHIC_ITERATION_MARK = 0x3005;
const char32_t IDEOGRAPHIC_CLOSING_MARK = 0x3006;
const char32_t IDEOGRAPHIC_NUMBER_ZERO = 0x3007;
const char32_t LEFT_ANGLE_BRACKET = 0x3008;
const char32_t RIGHT_ANGLE_BRACKET = 0x3009;
const char32_t LEFT_DOUBLE_ANGLE_BRACKET = 0x300A;
const char32_t RIGHT_DOUBLE_ANGLE_BRACKET = 0x300B;
const char32_t LEFT_CORNER_BRACKET = 0x300C;
const char32_t RIGHT_CORNER_BRACKET = 0x300D;
const char32_t LEFT_WHITE_CORNER_BRACKET = 0x300E;
const char32_t RIGHT_WHITE_CORNER_BRACKET = 0x300F;
const char32_t LEFT_BLACK_LENTICULAR_BRACKET = 0x3010;
const char32_t RIGHT_BLACK_LENTICULAR_BRACKET = 0x3011;
const char32_t POSTAL_MARK = 0x3012;
const char32_t GETA_MARK = 0x3013;
const char32_t LEFT_TORTOISE_SHELL_BRACKET = 0x3014;
const char32_t RIGHT_TORTOISE_SHELL_BRACKET = 0x3015;
const char32_t LEFT_WHITE_LENTICULAR_BRACKET = 0x3016;
const char32_t RIGHT_WHITE_LENTICULAR_BRACKET = 0x3017;
const char32_t LEFT_WHITE_TORTOISE_SHELL_BRACKET = 0x3018;
const char32_t RIGHT_WHITE_TORTOISE_SHELL_BRACKET = 0x3019;
const char32_t LEFT_WHITE_SQUARE_BRACKET = 0x301A;
const char32_t RIGHT_WHITE_SQUARE_BRACKET = 0x301B;
const char32_t WAVE_DASH = 0x301C;
const char32_t REVERSED_DOUBLE_PRIME_QUOTATION_MARK = 0x301D;
const char32_t DOUBLE_PRIME_QUOTATION_MARK = 0x301E;
const char32_t LOW_DOUBLE_PRIME_QUOTATION_MARK = 0x301F;
const char32_t POSTAL_MARK_FACE = 0x3020;
const char32_t HANGZHOU_NUMERAL_ONE = 0x3021;
const char32_t HANGZHOU_NUMERAL_TWO = 0x3022;
const char32_t HANGZHOU_NUMERAL_THREE = 0x3023;
const char32_t HANGZHOU_NUMERAL_FOUR = 0x3024;
const char32_t HANGZHOU_NUMERAL_FIVE = 0x3025;
const char32_t HANGZHOU_NUMERAL_SIX = 0x3026;
const char32_t HANGZHOU_NUMERAL_SEVEN = 0x3027;
const char32_t HANGZHOU_NUMERAL_EIGHT = 0x3028;
const char32_t HANGZHOU_NUMERAL_NINE = 0x3029;
const char32_t IDEOGRAPHIC_LEVEL_TONE_MARK = 0x302A;
const char32_t IDEOGRAPHIC_RISING_TONE_MARK = 0x302B;
const char32_t IDEOGRAPHIC_DEPARTING_TONE_MARK = 0x302C;
const char32_t IDEOGRAPHIC_ENTERING_TONE_MARK = 0x302D;
const char32_t HANGUL_SINGLE_DOT_TONE_MARK = 0x302E;
const char32_t HANGUL_DOUBLE_DOT_TONE_MARK = 0x302F;
const char32_t WAVY_DASH = 0x3030;
const char32_t VERTICAL_KANA_REPEAT_MARK = 0x3031;
const char32_t VERTICAL_KANA_REPEAT_WITH_VOICED_SOUND_MARK = 0x3032;
const char32_t VERTICAL_KANA_REPEAT_MARK_UPPER_HALF = 0x3033;
const char32_t VERTICAL_KANA_REPEAT_WITH_VOICED_SOUND_MARK_UPPER_HALF = 0x3034;
const char32_t VERTICAL_KANA_REPEAT_MARK_LOWER_HALF = 0x3035;
const char32_t CIRCLED_POSTAL_MARK = 0x3036;
const char32_t IDEOGRAPHIC_TELEGRAPH_LINE_FEED_SEPARATOR_SYMBOL = 0x3037;
const char32_t HANGZHOU_NUMERAL_TEN = 0x3038;
const char32_t HANGZHOU_NUMERAL_TWENTY = 0x3039;
const char32_t HANGZHOU_NUMERAL_THIRTY = 0x303A;
const char32_t VERTICAL_IDEOGRAPHIC_ITERATION_MARK = 0x303B;
const char32_t MASU_MARK = 0x303C;
const char32_t PART_ALTERNATION_MARK = 0x303D;
const char32_t IDEOGRAPHIC_VARIATION_INDICATOR = 0x303E;
const char32_t IDEOGRAPHIC_HALF_FILL_SPACE = 0x303F;
const char32_t HIRAGANA_LETTER_SMALL_A = 0x3041;
const char32_t HIRAGANA_LETTER_A = 0x3042;
const char32_t HIRAGANA_LETTER_SMALL_I = 0x3043;
const char32_t HIRAGANA_LETTER_I = 0x3044;
const char32_t HIRAGANA_LETTER_SMALL_U = 0x3045;
const char32_t HIRAGANA_LETTER_U = 0x3046;
const char32_t HIRAGANA_LETTER_SMALL_E = 0x3047;
const char32_t HIRAGANA_LETTER_E = 0x3048;
const char32_t HIRAGANA_LETTER_SMALL_O = 0x3049;
const char32_t HIRAGANA_LETTER_O = 0x304A;
const char32_t HIRAGANA_LETTER_KA = 0x304B;
const char32_t HIRAGANA_LETTER_GA = 0x304C;
const char32_t HIRAGANA_LETTER_KI = 0x304D;
const char32_t HIRAGANA_LETTER_GI = 0x304E;
const char32_t HIRAGANA_LETTER_KU = 0x304F;
const char32_t HIRAGANA_LETTER_GU = 0x3050;
const char32_t HIRAGANA_LETTER_KE = 0x3051;
const char32_t HIRAGANA_LETTER_GE = 0x3052;
const char32_t HIRAGANA_LETTER_KO = 0x3053;
const char32_t HIRAGANA_LETTER_GO = 0x3054;
const char32_t HIRAGANA_LETTER_SA = 0x3055;
const char32_t HIRAGANA_LETTER_ZA = 0x3056;
const char32_t HIRAGANA_LETTER_SI = 0x3057;
const char32_t HIRAGANA_LETTER_ZI = 0x3058;
const char32_t HIRAGANA_LETTER_SU = 0x3059;
const char32_t HIRAGANA_LETTER_ZU = 0x305A;
const char32_t HIRAGANA_LETTER_SE = 0x305B;
const char32_t HIRAGANA_LETTER_ZE = 0x305C;
const char32_t HIRAGANA_LETTER_SO = 0x305D;
const char32_t HIRAGANA_LETTER_ZO = 0x305E;
const char32_t HIRAGANA_LETTER_TA = 0x305F;
const char32_t HIRAGANA_LETTER_DA = 0x3060;
const char32_t HIRAGANA_LETTER_TI = 0x3061;
const char32_t HIRAGANA_LETTER_DI = 0x3062;
const char32_t HIRAGANA_LETTER_SMALL_TU = 0x3063;
const char32_t HIRAGANA_LETTER_TU = 0x3064;
const char32_t HIRAGANA_LETTER_DU = 0x3065;
const char32_t HIRAGANA_LETTER_TE = 0x3066;
const char32_t HIRAGANA_LETTER_DE = 0x3067;
const char32_t HIRAGANA_LETTER_TO = 0x3068;
const char32_t HIRAGANA_LETTER_DO = 0x3069;
const char32_t HIRAGANA_LETTER_NA = 0x306A;
const char32_t HIRAGANA_LETTER_NI = 0x306B;
const char32_t HIRAGANA_LETTER_NU = 0x306C;
const char32_t HIRAGANA_LETTER_NE = 0x306D;
const char32_t HIRAGANA_LETTER_NO = 0x306E;
const char32_t HIRAGANA_LETTER_HA = 0x306F;
const char32_t HIRAGANA_LETTER_BA = 0x3070;
const char32_t HIRAGANA_LETTER_PA = 0x3071;
const char32_t HIRAGANA_LETTER_HI = 0x3072;
const char32_t HIRAGANA_LETTER_BI = 0x3073;
const char32_t HIRAGANA_LETTER_PI = 0x3074;
const char32_t HIRAGANA_LETTER_HU = 0x3075;
const char32_t HIRAGANA_LETTER_BU = 0x3076;
const char32_t HIRAGANA_LETTER_PU = 0x3077;
const char32_t HIRAGANA_LETTER_HE = 0x3078;
const char32_t HIRAGANA_LETTER_BE = 0x3079;
const char32_t HIRAGANA_LETTER_PE = 0x307A;
const char32_t HIRAGANA_LETTER_HO = 0x307B;
const char32_t HIRAGANA_LETTER_BO = 0x307C;
const char32_t HIRAGANA_LETTER_PO = 0x307D;
const char32_t HIRAGANA_LETTER_MA = 0x307E;
const char32_t HIRAGANA_LETTER_MI = 0x307F;
const char32_t HIRAGANA_LETTER_MU = 0x3080;
const char32_t HIRAGANA_LETTER_ME = 0x3081;
const char32_t HIRAGANA_LETTER_MO = 0x3082;
const char32_t HIRAGANA_LETTER_SMALL_YA = 0x3083;
const char32_t HIRAGANA_LETTER_YA = 0x3084;
const char32_t HIRAGANA_LETTER_SMALL_YU = 0x3085;
const char32_t HIRAGANA_LETTER_YU = 0x3086;
const char32_t HIRAGANA_LETTER_SMALL_YO = 0x3087;
const char32_t HIRAGANA_LETTER_YO = 0x3088;
const char32_t HIRAGANA_LETTER_RA = 0x3089;
const char32_t HIRAGANA_LETTER_RI = 0x308A;
const char32_t HIRAGANA_LETTER_RU = 0x308B;
const char32_t HIRAGANA_LETTER_RE = 0x308C;
const char32_t HIRAGANA_LETTER_RO = 0x308D;
const char32_t HIRAGANA_LETTER_SMALL_WA = 0x308E;
const char32_t HIRAGANA_LETTER_WA = 0x308F;
const char32_t HIRAGANA_LETTER_WI = 0x3090;
const char32_t HIRAGANA_LETTER_WE = 0x3091;
const char32_t HIRAGANA_LETTER_WO = 0x3092;
const char32_t HIRAGANA_LETTER_N = 0x3093;
const char32_t HIRAGANA_LETTER_VU = 0x3094;
const char32_t HIRAGANA_LETTER_SMALL_KA = 0x3095;
const char32_t HIRAGANA_LETTER_SMALL_KE = 0x3096;
const char32_t COMBINING_KATAKANA_HIRAGANA_VOICED_SOUND_MARK = 0x3099;
const char32_t COMBINING_KATAKANA_HIRAGANA_SEMI_VOICED_SOUND_MARK = 0x309A;
const char32_t KATAKANA_HIRAGANA_VOICED_SOUND_MARK = 0x309B;
const char32_t KATAKANA_HIRAGANA_SEMI_VOICED_SOUND_MARK = 0x309C;
const char32_t HIRAGANA_ITERATION_MARK = 0x309D;
const char32_t HIRAGANA_VOICED_ITERATION_MARK = 0x309E;
const char32_t HIRAGANA_DIGRAPH_YORI = 0x309F;
const char32_t KATAKANA_HIRAGANA_DOUBLE_HYPHEN = 0x30A0;
const char32_t KATAKANA_LETTER_SMALL_A = 0x30A1;
const char32_t KATAKANA_LETTER_A = 0x30A2;
const char32_t KATAKANA_LETTER_SMALL_I = 0x30A3;
const char32_t KATAKANA_LETTER_I = 0x30A4;
const char32_t KATAKANA_LETTER_SMALL_U = 0x30A5;
const char32_t KATAKANA_LETTER_U = 0x30A6;
const char32_t KATAKANA_LETTER_SMALL_E = 0x30A7;
const char32_t KATAKANA_LETTER_E = 0x30A8;
const char32_t KATAKANA_LETTER_SMALL_O = 0x30A9;
const char32_t KATAKANA_LETTER_O = 0x30AA;
const char32_t KATAKANA_LETTER_KA = 0x30AB;
const char32_t KATAKANA_LETTER_GA = 0x30AC;
const char32_t KATAKANA_LETTER_KI = 0x30AD;
const char32_t KATAKANA_LETTER_GI = 0x30AE;
const char32_t KATAKANA_LETTER_KU = 0x30AF;
const char32_t KATAKANA_LETTER_GU = 0x30B0;
const char32_t KATAKANA_LETTER_KE = 0x30B1;
const char32_t KATAKANA_LETTER_GE = 0x30B2;
const char32_t KATAKANA_LETTER_KO = 0x30B3;
const char32_t KATAKANA_LETTER_GO = 0x30B4;
const char32_t KATAKANA_LETTER_SA = 0x30B5;
const char32_t KATAKANA_LETTER_ZA = 0x30B6;
const char32_t KATAKANA_LETTER_SI = 0x30B7;
const char32_t KATAKANA_LETTER_ZI = 0x30B8;
const char32_t KATAKANA_LETTER_SU = 0x30B9;
const char32_t KATAKANA_LETTER_ZU = 0x30BA;
const char32_t KATAKANA_LETTER_SE = 0x30BB;
const char32_t KATAKANA_LETTER_ZE = 0x30BC;
const char32_t KATAKANA_LETTER_SO = 0x30BD;
const char32_t KATAKANA_LETTER_ZO = 0x30BE;
const char32_t KATAKANA_LETTER_TA = 0x30BF;
const char32_t KATAKANA_LETTER_DA = 0x30C0;
const char32_t KATAKANA_LETTER_TI = 0x30C1;
const char32_t KATAKANA_LETTER_DI = 0x30C2;
const char32_t KATAKANA_LETTER_SMALL_TU = 0x30C3;
const char32_t KATAKANA_LETTER_TU = 0x30C4;
const char32_t KATAKANA_LETTER_DU = 0x30C5;
const char32_t KATAKANA_LETTER_TE = 0x30C6;
const char32_t KATAKANA_LETTER_DE = 0x30C7;
const char32_t KATAKANA_LETTER_TO = 0x30C8;
const char32_t KATAKANA_LETTER_DO = 0x30C9;
const char32_t KATAKANA_LETTER_NA = 0x30CA;
const char32_t KATAKANA_LETTER_NI = 0x30CB;
const char32_t KATAKANA_LETTER_NU = 0x30CC;
const char32_t KATAKANA_LETTER_NE = 0x30CD;
const char32_t KATAKANA_LETTER_NO = 0x30CE;
const char32_t KATAKANA_LETTER_HA = 0x30CF;
const char32_t KATAKANA_LETTER_BA = 0x30D0;
const char32_t KATAKANA_LETTER_PA = 0x30D1;
const char32_t KATAKANA_LETTER_HI = 0x30D2;
const char32_t KATAKANA_LETTER_BI = 0x30D3;
const char32_t KATAKANA_LETTER_PI = 0x30D4;
const char32_t KATAKANA_LETTER_HU = 0x30D5;
const char32_t KATAKANA_LETTER_BU = 0x30D6;
const char32_t KATAKANA_LETTER_PU = 0x30D7;
const char32_t KATAKANA_LETTER_HE = 0x30D8;
const char32_t KATAKANA_LETTER_BE = 0x30D9;
const char32_t KATAKANA_LETTER_PE = 0x30DA;
const char32_t KATAKANA_LETTER_HO = 0x30DB;
const char32_t KATAKANA_LETTER_BO = 0x30DC;
const char32_t KATAKANA_LETTER_PO = 0x30DD;
const char32_t KATAKANA_LETTER_MA = 0x30DE;
const char32_t KATAKANA_LETTER_MI = 0x30DF;
const char32_t KATAKANA_LETTER_MU = 0x30E0;
const char32_t KATAKANA_LETTER_ME = 0x30E1;
const char32_t KATAKANA_LETTER_MO = 0x30E2;
const char32_t KATAKANA_LETTER_SMALL_YA = 0x30E3;
const char32_t KATAKANA_LETTER_YA = 0x30E4;
const char32_t KATAKANA_LETTER_SMALL_YU = 0x30E5;
const char32_t KATAKANA_LETTER_YU = 0x30E6;
const char32_t KATAKANA_LETTER_SMALL_YO = 0x30E7;
const char32_t KATAKANA_LETTER_YO = 0x30E8;
const char32_t KATAKANA_LETTER_RA = 0x30E9;
const char32_t KATAKANA_LETTER_RI = 0x30EA;
const char32_t KATAKANA_LETTER_RU = 0x30EB;
const char32_t KATAKANA_LETTER_RE = 0x30EC;
const char32_t KATAKANA_LETTER_RO = 0x30ED;
const char32_t KATAKANA_LETTER_SMALL_WA = 0x30EE;
const char32_t KATAKANA_LETTER_WA = 0x30EF;
const char32_t KATAKANA_LETTER_WI = 0x30F0;
const char32_t KATAKANA_LETTER_WE = 0x30F1;
const char32_t KATAKANA_LETTER_WO = 0x30F2;
const char32_t KATAKANA_LETTER_N = 0x30F3;
const char32_t KATAKANA_LETTER_VU = 0x30F4;
const char32_t KATAKANA_LETTER_SMALL_KA = 0x30F5;
const char32_t KATAKANA_LETTER_SMALL_KE = 0x30F6;
const char32_t KATAKANA_LETTER_VA = 0x30F7;
const char32_t KATAKANA_LETTER_VI = 0x30F8;
const char32_t KATAKANA_LETTER_VE = 0x30F9;
const char32_t KATAKANA_LETTER_VO = 0x30FA;
const char32_t KATAKANA_MIDDLE_DOT = 0x30FB;
const char32_t KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK = 0x30FC;
const char32_t KATAKANA_ITERATION_MARK = 0x30FD;
const char32_t KATAKANA_VOICED_ITERATION_MARK = 0x30FE;
const char32_t KATAKANA_DIGRAPH_KOTO = 0x30FF;
const char32_t BOPOMOFO_LETTER_B = 0x3105;
const char32_t BOPOMOFO_LETTER_P = 0x3106;
const char32_t BOPOMOFO_LETTER_M = 0x3107;
const char32_t BOPOMOFO_LETTER_F = 0x3108;
const char32_t BOPOMOFO_LETTER_D = 0x3109;
const char32_t BOPOMOFO_LETTER_T = 0x310A;
const char32_t BOPOMOFO_LETTER_N = 0x310B;
const char32_t BOPOMOFO_LETTER_L = 0x310C;
const char32_t BOPOMOFO_LETTER_G = 0x310D;
const char32_t BOPOMOFO_LETTER_K = 0x310E;
const char32_t BOPOMOFO_LETTER_H = 0x310F;
const char32_t BOPOMOFO_LETTER_J = 0x3110;
const char32_t BOPOMOFO_LETTER_Q = 0x3111;
const char32_t BOPOMOFO_LETTER_X = 0x3112;
const char32_t BOPOMOFO_LETTER_ZH = 0x3113;
const char32_t BOPOMOFO_LETTER_CH = 0x3114;
const char32_t BOPOMOFO_LETTER_SH = 0x3115;
const char32_t BOPOMOFO_LETTER_R = 0x3116;
const char32_t BOPOMOFO_LETTER_Z = 0x3117;
const char32_t BOPOMOFO_LETTER_C = 0x3118;
const char32_t BOPOMOFO_LETTER_S = 0x3119;
const char32_t BOPOMOFO_LETTER_A = 0x311A;
const char32_t BOPOMOFO_LETTER_O = 0x311B;
const char32_t BOPOMOFO_LETTER_E = 0x311C;
const char32_t BOPOMOFO_LETTER_EH = 0x311D;
const char32_t BOPOMOFO_LETTER_AI = 0x311E;
const char32_t BOPOMOFO_LETTER_EI = 0x311F;
const char32_t BOPOMOFO_LETTER_AU = 0x3120;
const char32_t BOPOMOFO_LETTER_OU = 0x3121;
const char32_t BOPOMOFO_LETTER_AN = 0x3122;
const char32_t BOPOMOFO_LETTER_EN = 0x3123;
const char32_t BOPOMOFO_LETTER_ANG = 0x3124;
const char32_t BOPOMOFO_LETTER_ENG = 0x3125;
const char32_t BOPOMOFO_LETTER_ER = 0x3126;
const char32_t BOPOMOFO_LETTER_I = 0x3127;
const char32_t BOPOMOFO_LETTER_U = 0x3128;
const char32_t BOPOMOFO_LETTER_IU = 0x3129;
const char32_t BOPOMOFO_LETTER_V = 0x312A;
const char32_t BOPOMOFO_LETTER_NG = 0x312B;
const char32_t BOPOMOFO_LETTER_GN = 0x312C;
const char32_t BOPOMOFO_LETTER_IH = 0x312D;
const char32_t BOPOMOFO_LETTER_O_WITH_DOT_ABOVE = 0x312E;
const char32_t BOPOMOFO_LETTER_NN = 0x312F;
const char32_t HANGUL_LETTER_KIYEOK = 0x3131;
const char32_t HANGUL_LETTER_SSANGKIYEOK = 0x3132;
const char32_t HANGUL_LETTER_KIYEOK_SIOS = 0x3133;
const char32_t HANGUL_LETTER_NIEUN = 0x3134;
const char32_t HANGUL_LETTER_NIEUN_CIEUC = 0x3135;
const char32_t HANGUL_LETTER_NIEUN_HIEUH = 0x3136;
const char32_t HANGUL_LETTER_TIKEUT = 0x3137;
const char32_t HANGUL_LETTER_SSANGTIKEUT = 0x3138;
const char32_t HANGUL_LETTER_RIEUL = 0x3139;
const char32_t HANGUL_LETTER_RIEUL_KIYEOK = 0x313A;
const char32_t HANGUL_LETTER_RIEUL_MIEUM = 0x313B;
const char32_t HANGUL_LETTER_RIEUL_PIEUP = 0x313C;
const char32_t HANGUL_LETTER_RIEUL_SIOS = 0x313D;
const char32_t HANGUL_LETTER_RIEUL_THIEUTH = 0x313E;
const char32_t HANGUL_LETTER_RIEUL_PHIEUPH = 0x313F;
const char32_t HANGUL_LETTER_RIEUL_HIEUH = 0x3140;
const char32_t HANGUL_LETTER_MIEUM = 0x3141;
const char32_t HANGUL_LETTER_PIEUP = 0x3142;
const char32_t HANGUL_LETTER_SSANGPIEUP = 0x3143;
const char32_t HANGUL_LETTER_PIEUP_SIOS = 0x3144;
const char32_t HANGUL_LETTER_SIOS = 0x3145;
const char32_t HANGUL_LETTER_SSANGSIOS = 0x3146;
const char32_t HANGUL_LETTER_IEUNG = 0x3147;
const char32_t HANGUL_LETTER_CIEUC = 0x3148;
const char32_t HANGUL_LETTER_SSANGCIEUC = 0x3149;
const char32_t HANGUL_LETTER_CHIEUCH = 0x314A;
const char32_t HANGUL_LETTER_KHIEUKH = 0x314B;
const char32_t HANGUL_LETTER_THIEUTH = 0x314C;
const char32_t HANGUL_LETTER_PHIEUPH = 0x314D;
const char32_t HANGUL_LETTER_HIEUH = 0x314E;
const char32_t HANGUL_LETTER_A = 0x314F;
const char32_t HANGUL_LETTER_AE = 0x3150;
const char32_t HANGUL_LETTER_YA = 0x3151;
const char32_t HANGUL_LETTER_YAE = 0x3152;
const char32_t HANGUL_LETTER_EO = 0x3153;
const char32_t HANGUL_LETTER_E = 0x3154;
const char32_t HANGUL_LETTER_YEO = 0x3155;
const char32_t HANGUL_LETTER_YE = 0x3156;
const char32_t HANGUL_LETTER_O = 0x3157;
const char32_t HANGUL_LETTER_WA = 0x3158;
const char32_t HANGUL_LETTER_WAE = 0x3159;
const char32_t HANGUL_LETTER_OE = 0x315A;
const char32_t HANGUL_LETTER_YO = 0x315B;
const char32_t HANGUL_LETTER_U = 0x315C;
const char32_t HANGUL_LETTER_WEO = 0x315D;
const char32_t HANGUL_LETTER_WE = 0x315E;
const char32_t HANGUL_LETTER_WI = 0x315F;
const char32_t HANGUL_LETTER_YU = 0x3160;
const char32_t HANGUL_LETTER_EU = 0x3161;
const char32_t HANGUL_LETTER_YI = 0x3162;
const char32_t HANGUL_LETTER_I = 0x3163;
const char32_t HANGUL_FILLER = 0x3164;
const char32_t HANGUL_LETTER_SSANGNIEUN = 0x3165;
const char32_t HANGUL_LETTER_NIEUN_TIKEUT = 0x3166;
const char32_t HANGUL_LETTER_NIEUN_SIOS = 0x3167;
const char32_t HANGUL_LETTER_NIEUN_PANSIOS = 0x3168;
const char32_t HANGUL_LETTER_RIEUL_KIYEOK_SIOS = 0x3169;
const char32_t HANGUL_LETTER_RIEUL_TIKEUT = 0x316A;
const char32_t HANGUL_LETTER_RIEUL_PIEUP_SIOS = 0x316B;
const char32_t HANGUL_LETTER_RIEUL_PANSIOS = 0x316C;
const char32_t HANGUL_LETTER_RIEUL_YEORINHIEUH = 0x316D;
const char32_t HANGUL_LETTER_MIEUM_PIEUP = 0x316E;
const char32_t HANGUL_LETTER_MIEUM_SIOS = 0x316F;
const char32_t HANGUL_LETTER_MIEUM_PANSIOS = 0x3170;
const char32_t HANGUL_LETTER_KAPYEOUNMIEUM = 0x3171;
const char32_t HANGUL_LETTER_PIEUP_KIYEOK = 0x3172;
const char32_t HANGUL_LETTER_PIEUP_TIKEUT = 0x3173;
const char32_t HANGUL_LETTER_PIEUP_SIOS_KIYEOK = 0x3174;
const char32_t HANGUL_LETTER_PIEUP_SIOS_TIKEUT = 0x3175;
const char32_t HANGUL_LETTER_PIEUP_CIEUC = 0x3176;
const char32_t HANGUL_LETTER_PIEUP_THIEUTH = 0x3177;
const char32_t HANGUL_LETTER_KAPYEOUNPIEUP = 0x3178;
const char32_t HANGUL_LETTER_KAPYEOUNSSANGPIEUP = 0x3179;
const char32_t HANGUL_LETTER_SIOS_KIYEOK = 0x317A;
const char32_t HANGUL_LETTER_SIOS_NIEUN = 0x317B;
const char32_t HANGUL_LETTER_SIOS_TIKEUT = 0x317C;
const char32_t HANGUL_LETTER_SIOS_PIEUP = 0x317D;
const char32_t HANGUL_LETTER_SIOS_CIEUC = 0x317E;
const char32_t HANGUL_LETTER_PANSIOS = 0x317F;
const char32_t HANGUL_LETTER_SSANGIEUNG = 0x3180;
const char32_t HANGUL_LETTER_YESIEUNG = 0x3181;
const char32_t HANGUL_LETTER_YESIEUNG_SIOS = 0x3182;
const char32_t HANGUL_LETTER_YESIEUNG_PANSIOS = 0x3183;
const char32_t HANGUL_LETTER_KAPYEOUNPHIEUPH = 0x3184;
const char32_t HANGUL_LETTER_SSANGHIEUH = 0x3185;
const char32_t HANGUL_LETTER_YEORINHIEUH = 0x3186;
const char32_t HANGUL_LETTER_YO_YA = 0x3187;
const char32_t HANGUL_LETTER_YO_YAE = 0x3188;
const char32_t HANGUL_LETTER_YO_I = 0x3189;
const char32_t HANGUL_LETTER_YU_YEO = 0x318A;
const char32_t HANGUL_LETTER_YU_YE = 0x318B;
const char32_t HANGUL_LETTER_YU_I = 0x318C;
const char32_t HANGUL_LETTER_ARAEA = 0x318D;
const char32_t HANGUL_LETTER_ARAEAE = 0x318E;
const char32_t IDEOGRAPHIC_ANNOTATION_LINKING_MARK = 0x3190;
const char32_t IDEOGRAPHIC_ANNOTATION_REVERSE_MARK = 0x3191;
const char32_t IDEOGRAPHIC_ANNOTATION_ONE_MARK = 0x3192;
const char32_t IDEOGRAPHIC_ANNOTATION_TWO_MARK = 0x3193;
const char32_t IDEOGRAPHIC_ANNOTATION_THREE_MARK = 0x3194;
const char32_t IDEOGRAPHIC_ANNOTATION_FOUR_MARK = 0x3195;
const char32_t IDEOGRAPHIC_ANNOTATION_TOP_MARK = 0x3196;
const char32_t IDEOGRAPHIC_ANNOTATION_MIDDLE_MARK = 0x3197;
const char32_t IDEOGRAPHIC_ANNOTATION_BOTTOM_MARK = 0x3198;
const char32_t IDEOGRAPHIC_ANNOTATION_FIRST_MARK = 0x3199;
const char32_t IDEOGRAPHIC_ANNOTATION_SECOND_MARK = 0x319A;
const char32_t IDEOGRAPHIC_ANNOTATION_THIRD_MARK = 0x319B;
const char32_t IDEOGRAPHIC_ANNOTATION_FOURTH_MARK = 0x319C;
const char32_t IDEOGRAPHIC_ANNOTATION_HEAVEN_MARK = 0x319D;
const char32_t IDEOGRAPHIC_ANNOTATION_EARTH_MARK = 0x319E;
const char32_t IDEOGRAPHIC_ANNOTATION_MAN_MARK = 0x319F;
const char32_t BOPOMOFO_LETTER_BU = 0x31A0;
const char32_t BOPOMOFO_LETTER_ZI = 0x31A1;
const char32_t BOPOMOFO_LETTER_JI = 0x31A2;
const char32_t BOPOMOFO_LETTER_GU = 0x31A3;
const char32_t BOPOMOFO_LETTER_EE = 0x31A4;
const char32_t BOPOMOFO_LETTER_ENN = 0x31A5;
const char32_t BOPOMOFO_LETTER_OO = 0x31A6;
const char32_t BOPOMOFO_LETTER_ONN = 0x31A7;
const char32_t BOPOMOFO_LETTER_IR = 0x31A8;
const char32_t BOPOMOFO_LETTER_ANN = 0x31A9;
const char32_t BOPOMOFO_LETTER_INN = 0x31AA;
const char32_t BOPOMOFO_LETTER_UNN = 0x31AB;
const char32_t BOPOMOFO_LETTER_IM = 0x31AC;
const char32_t BOPOMOFO_LETTER_NGG = 0x31AD;
const char32_t BOPOMOFO_LETTER_AINN = 0x31AE;
const char32_t BOPOMOFO_LETTER_AUNN = 0x31AF;
const char32_t BOPOMOFO_LETTER_AM = 0x31B0;
const char32_t BOPOMOFO_LETTER_OM = 0x31B1;
const char32_t BOPOMOFO_LETTER_ONG = 0x31B2;
const char32_t BOPOMOFO_LETTER_INNN = 0x31B3;
const char32_t BOPOMOFO_FINAL_LETTER_P = 0x31B4;
const char32_t BOPOMOFO_FINAL_LETTER_T = 0x31B5;
const char32_t BOPOMOFO_FINAL_LETTER_K = 0x31B6;
const char32_t BOPOMOFO_FINAL_LETTER_H = 0x31B7;
const char32_t BOPOMOFO_LETTER_GH = 0x31B8;
const char32_t BOPOMOFO_LETTER_LH = 0x31B9;
const char32_t BOPOMOFO_LETTER_ZY = 0x31BA;
const char32_t BOPOMOFO_FINAL_LETTER_G = 0x31BB;
const char32_t BOPOMOFO_LETTER_GW = 0x31BC;
const char32_t BOPOMOFO_LETTER_KW = 0x31BD;
const char32_t BOPOMOFO_LETTER_OE = 0x31BE;
const char32_t BOPOMOFO_LETTER_AH = 0x31BF;
const char32_t CJK_STROKE_T = 0x31C0;
const char32_t CJK_STROKE_WG = 0x31C1;
const char32_t CJK_STROKE_XG = 0x31C2;
const char32_t CJK_STROKE_BXG = 0x31C3;
const char32_t CJK_STROKE_SW = 0x31C4;
const char32_t CJK_STROKE_HZZ = 0x31C5;
const char32_t CJK_STROKE_HZG = 0x31C6;
const char32_t CJK_STROKE_HP = 0x31C7;
const char32_t CJK_STROKE_HZWG = 0x31C8;
const char32_t CJK_STROKE_SZWG = 0x31C9;
const char32_t CJK_STROKE_HZT = 0x31CA;
const char32_t CJK_STROKE_HZZP = 0x31CB;
const char32_t CJK_STROKE_HPWG = 0x31CC;
const char32_t CJK_STROKE_HZW = 0x31CD;
const char32_t CJK_STROKE_HZZZ = 0x31CE;
const char32_t CJK_STROKE_N = 0x31CF;
const char32_t CJK_STROKE_H = 0x31D0;
const char32_t CJK_STROKE_S = 0x31D1;
const char32_t CJK_STROKE_P = 0x31D2;
const char32_t CJK_STROKE_SP = 0x31D3;
const char32_t CJK_STROKE_D = 0x31D4;
const char32_t CJK_STROKE_HZ = 0x31D5;
const char32_t CJK_STROKE_HG = 0x31D6;
const char32_t CJK_STROKE_SZ = 0x31D7;
const char32_t CJK_STROKE_SWZ = 0x31D8;
const char32_t CJK_STROKE_ST = 0x31D9;
const char32_t CJK_STROKE_SG = 0x31DA;
const char32_t CJK_STROKE_PD = 0x31DB;
const char32_t CJK_STROKE_PZ = 0x31DC;
const char32_t CJK_STROKE_TN = 0x31DD;
const char32_t CJK_STROKE_SZZ = 0x31DE;
const char32_t CJK_STROKE_SWG = 0x31DF;
const char32_t CJK_STROKE_HXWG = 0x31E0;
const char32_t CJK_STROKE_HZZZG = 0x31E1;
const char32_t CJK_STROKE_PG = 0x31E2;
const char32_t CJK_STROKE_Q = 0x31E3;
const char32_t KATAKANA_LETTER_SMALL_KU = 0x31F0;
const char32_t KATAKANA_LETTER_SMALL_SI = 0x31F1;
const char32_t KATAKANA_LETTER_SMALL_SU = 0x31F2;
const char32_t KATAKANA_LETTER_SMALL_TO = 0x31F3;
const char32_t KATAKANA_LETTER_SMALL_NU = 0x31F4;
const char32_t KATAKANA_LETTER_SMALL_HA = 0x31F5;
const char32_t KATAKANA_LETTER_SMALL_HI = 0x31F6;
const char32_t KATAKANA_LETTER_SMALL_HU = 0x31F7;
const char32_t KATAKANA_LETTER_SMALL_HE = 0x31F8;
const char32_t KATAKANA_LETTER_SMALL_HO = 0x31F9;
const char32_t KATAKANA_LETTER_SMALL_MU = 0x31FA;
const char32_t KATAKANA_LETTER_SMALL_RA = 0x31FB;
const char32_t KATAKANA_LETTER_SMALL_RI = 0x31FC;
const char32_t KATAKANA_LETTER_SMALL_RU = 0x31FD;
const char32_t KATAKANA_LETTER_SMALL_RE = 0x31FE;
const char32_t KATAKANA_LETTER_SMALL_RO = 0x31FF;
const char32_t PARENTHESIZED_HANGUL_KIYEOK = 0x3200;
const char32_t PARENTHESIZED_HANGUL_NIEUN = 0x3201;
const char32_t PARENTHESIZED_HANGUL_TIKEUT = 0x3202;
const char32_t PARENTHESIZED_HANGUL_RIEUL = 0x3203;
const char32_t PARENTHESIZED_HANGUL_MIEUM = 0x3204;
const char32_t PARENTHESIZED_HANGUL_PIEUP = 0x3205;
const char32_t PARENTHESIZED_HANGUL_SIOS = 0x3206;
const char32_t PARENTHESIZED_HANGUL_IEUNG = 0x3207;
const char32_t PARENTHESIZED_HANGUL_CIEUC = 0x3208;
const char32_t PARENTHESIZED_HANGUL_CHIEUCH = 0x3209;
const char32_t PARENTHESIZED_HANGUL_KHIEUKH = 0x320A;
const char32_t PARENTHESIZED_HANGUL_THIEUTH = 0x320B;
const char32_t PARENTHESIZED_HANGUL_PHIEUPH = 0x320C;
const char32_t PARENTHESIZED_HANGUL_HIEUH = 0x320D;
const char32_t PARENTHESIZED_HANGUL_KIYEOK_A = 0x320E;
const char32_t PARENTHESIZED_HANGUL_NIEUN_A = 0x320F;
const char32_t PARENTHESIZED_HANGUL_TIKEUT_A = 0x3210;
const char32_t PARENTHESIZED_HANGUL_RIEUL_A = 0x3211;
const char32_t PARENTHESIZED_HANGUL_MIEUM_A = 0x3212;
const char32_t PARENTHESIZED_HANGUL_PIEUP_A = 0x3213;
const char32_t PARENTHESIZED_HANGUL_SIOS_A = 0x3214;
const char32_t PARENTHESIZED_HANGUL_IEUNG_A = 0x3215;
const char32_t PARENTHESIZED_HANGUL_CIEUC_A = 0x3216;
const char32_t PARENTHESIZED_HANGUL_CHIEUCH_A = 0x3217;
const char32_t PARENTHESIZED_HANGUL_KHIEUKH_A = 0x3218;
const char32_t PARENTHESIZED_HANGUL_THIEUTH_A = 0x3219;
const char32_t PARENTHESIZED_HANGUL_PHIEUPH_A = 0x321A;
const char32_t PARENTHESIZED_HANGUL_HIEUH_A = 0x321B;
const char32_t PARENTHESIZED_HANGUL_CIEUC_U = 0x321C;
const char32_t PARENTHESIZED_KOREAN_CHARACTER_OJEON = 0x321D;
const char32_t PARENTHESIZED_KOREAN_CHARACTER_O_HU = 0x321E;
const char32_t PARENTHESIZED_IDEOGRAPH_ONE = 0x3220;
const char32_t PARENTHESIZED_IDEOGRAPH_TWO = 0x3221;
const char32_t PARENTHESIZED_IDEOGRAPH_THREE = 0x3222;
const char32_t PARENTHESIZED_IDEOGRAPH_FOUR = 0x3223;
const char32_t PARENTHESIZED_IDEOGRAPH_FIVE = 0x3224;
const char32_t PARENTHESIZED_IDEOGRAPH_SIX = 0x3225;
const char32_t PARENTHESIZED_IDEOGRAPH_SEVEN = 0x3226;
const char32_t PARENTHESIZED_IDEOGRAPH_EIGHT = 0x3227;
const char32_t PARENTHESIZED_IDEOGRAPH_NINE = 0x3228;
const char32_t PARENTHESIZED_IDEOGRAPH_TEN = 0x3229;
const char32_t PARENTHESIZED_IDEOGRAPH_MOON = 0x322A;
const char32_t PARENTHESIZED_IDEOGRAPH_FIRE = 0x322B;
const char32_t PARENTHESIZED_IDEOGRAPH_WATER = 0x322C;
const char32_t PARENTHESIZED_IDEOGRAPH_WOOD = 0x322D;
const char32_t PARENTHESIZED_IDEOGRAPH_METAL = 0x322E;
const char32_t PARENTHESIZED_IDEOGRAPH_EARTH = 0x322F;
const char32_t PARENTHESIZED_IDEOGRAPH_SUN = 0x3230;
const char32_t PARENTHESIZED_IDEOGRAPH_STOCK = 0x3231;
const char32_t PARENTHESIZED_IDEOGRAPH_HAVE = 0x3232;
const char32_t PARENTHESIZED_IDEOGRAPH_SOCIETY = 0x3233;
const char32_t PARENTHESIZED_IDEOGRAPH_NAME = 0x3234;
const char32_t PARENTHESIZED_IDEOGRAPH_SPECIAL = 0x3235;
const char32_t PARENTHESIZED_IDEOGRAPH_FINANCIAL = 0x3236;
const char32_t PARENTHESIZED_IDEOGRAPH_CONGRATULATION = 0x3237;
const char32_t PARENTHESIZED_IDEOGRAPH_LABOR = 0x3238;
const char32_t PARENTHESIZED_IDEOGRAPH_REPRESENT = 0x3239;
const char32_t PARENTHESIZED_IDEOGRAPH_CALL = 0x323A;
const char32_t PARENTHESIZED_IDEOGRAPH_STUDY = 0x323B;
const char32_t PARENTHESIZED_IDEOGRAPH_SUPERVISE = 0x323C;
const char32_t PARENTHESIZED_IDEOGRAPH_ENTERPRISE = 0x323D;
const char32_t PARENTHESIZED_IDEOGRAPH_RESOURCE = 0x323E;
const char32_t PARENTHESIZED_IDEOGRAPH_ALLIANCE = 0x323F;
const char32_t PARENTHESIZED_IDEOGRAPH_FESTIVAL = 0x3240;
const char32_t PARENTHESIZED_IDEOGRAPH_REST = 0x3241;
const char32_t PARENTHESIZED_IDEOGRAPH_SELF = 0x3242;
const char32_t PARENTHESIZED_IDEOGRAPH_REACH = 0x3243;
const char32_t CIRCLED_IDEOGRAPH_QUESTION = 0x3244;
const char32_t CIRCLED_IDEOGRAPH_KINDERGARTEN = 0x3245;
const char32_t CIRCLED_IDEOGRAPH_SCHOOL = 0x3246;
const char32_t CIRCLED_IDEOGRAPH_KOTO = 0x3247;
const char32_t CIRCLED_NUMBER_TEN_ON_BLACK_SQUARE = 0x3248;
const char32_t CIRCLED_NUMBER_TWENTY_ON_BLACK_SQUARE = 0x3249;
const char32_t CIRCLED_NUMBER_THIRTY_ON_BLACK_SQUARE = 0x324A;
const char32_t CIRCLED_NUMBER_FORTY_ON_BLACK_SQUARE = 0x324B;
const char32_t CIRCLED_NUMBER_FIFTY_ON_BLACK_SQUARE = 0x324C;
const char32_t CIRCLED_NUMBER_SIXTY_ON_BLACK_SQUARE = 0x324D;
const char32_t CIRCLED_NUMBER_SEVENTY_ON_BLACK_SQUARE = 0x324E;
const char32_t CIRCLED_NUMBER_EIGHTY_ON_BLACK_SQUARE = 0x324F;
const char32_t PARTNERSHIP_SIGN = 0x3250;
const char32_t CIRCLED_NUMBER_TWENTY_ONE = 0x3251;
const char32_t CIRCLED_NUMBER_TWENTY_TWO = 0x3252;
const char32_t CIRCLED_NUMBER_TWENTY_THREE = 0x3253;
const char32_t CIRCLED_NUMBER_TWENTY_FOUR = 0x3254;
const char32_t CIRCLED_NUMBER_TWENTY_FIVE = 0x3255;
const char32_t CIRCLED_NUMBER_TWENTY_SIX = 0x3256;
const char32_t CIRCLED_NUMBER_TWENTY_SEVEN = 0x3257;
const char32_t CIRCLED_NUMBER_TWENTY_EIGHT = 0x3258;
const char32_t CIRCLED_NUMBER_TWENTY_NINE = 0x3259;
const char32_t CIRCLED_NUMBER_THIRTY = 0x325A;
const char32_t CIRCLED_NUMBER_THIRTY_ONE = 0x325B;
const char32_t CIRCLED_NUMBER_THIRTY_TWO = 0x325C;
const char32_t CIRCLED_NUMBER_THIRTY_THREE = 0x325D;
const char32_t CIRCLED_NUMBER_THIRTY_FOUR = 0x325E;
const char32_t CIRCLED_NUMBER_THIRTY_FIVE = 0x325F;
const char32_t CIRCLED_HANGUL_KIYEOK = 0x3260;
const char32_t CIRCLED_HANGUL_NIEUN = 0x3261;
const char32_t CIRCLED_HANGUL_TIKEUT = 0x3262;
const char32_t CIRCLED_HANGUL_RIEUL = 0x3263;
const char32_t CIRCLED_HANGUL_MIEUM = 0x3264;
const char32_t CIRCLED_HANGUL_PIEUP = 0x3265;
const char32_t CIRCLED_HANGUL_SIOS = 0x3266;
const char32_t CIRCLED_HANGUL_IEUNG = 0x3267;
const char32_t CIRCLED_HANGUL_CIEUC = 0x3268;
const char32_t CIRCLED_HANGUL_CHIEUCH = 0x3269;
const char32_t CIRCLED_HANGUL_KHIEUKH = 0x326A;
const char32_t CIRCLED_HANGUL_THIEUTH = 0x326B;
const char32_t CIRCLED_HANGUL_PHIEUPH = 0x326C;
const char32_t CIRCLED_HANGUL_HIEUH = 0x326D;
const char32_t CIRCLED_HANGUL_KIYEOK_A = 0x326E;
const char32_t CIRCLED_HANGUL_NIEUN_A = 0x326F;
const char32_t CIRCLED_HANGUL_TIKEUT_A = 0x3270;
const char32_t CIRCLED_HANGUL_RIEUL_A = 0x3271;
const char32_t CIRCLED_HANGUL_MIEUM_A = 0x3272;
const char32_t CIRCLED_HANGUL_PIEUP_A = 0x3273;
const char32_t CIRCLED_HANGUL_SIOS_A = 0x3274;
const char32_t CIRCLED_HANGUL_IEUNG_A = 0x3275;
const char32_t CIRCLED_HANGUL_CIEUC_A = 0x3276;
const char32_t CIRCLED_HANGUL_CHIEUCH_A = 0x3277;
const char32_t CIRCLED_HANGUL_KHIEUKH_A = 0x3278;
const char32_t CIRCLED_HANGUL_THIEUTH_A = 0x3279;
const char32_t CIRCLED_HANGUL_PHIEUPH_A = 0x327A;
const char32_t CIRCLED_HANGUL_HIEUH_A = 0x327B;
const char32_t CIRCLED_KOREAN_CHARACTER_CHAMKO = 0x327C;
const char32_t CIRCLED_KOREAN_CHARACTER_JUEUI = 0x327D;
const char32_t CIRCLED_HANGUL_IEUNG_U = 0x327E;
const char32_t KOREAN_STANDARD_SYMBOL = 0x327F;
const char32_t CIRCLED_IDEOGRAPH_ONE = 0x3280;
const char32_t CIRCLED_IDEOGRAPH_TWO = 0x3281;
const char32_t CIRCLED_IDEOGRAPH_THREE = 0x3282;
const char32_t CIRCLED_IDEOGRAPH_FOUR = 0x3283;
const char32_t CIRCLED_IDEOGRAPH_FIVE = 0x3284;
const char32_t CIRCLED_IDEOGRAPH_SIX = 0x3285;
const char32_t CIRCLED_IDEOGRAPH_SEVEN = 0x3286;
const char32_t CIRCLED_IDEOGRAPH_EIGHT = 0x3287;
const char32_t CIRCLED_IDEOGRAPH_NINE = 0x3288;
const char32_t CIRCLED_IDEOGRAPH_TEN = 0x3289;
const char32_t CIRCLED_IDEOGRAPH_MOON = 0x328A;
const char32_t CIRCLED_IDEOGRAPH_FIRE = 0x328B;
const char32_t CIRCLED_IDEOGRAPH_WATER = 0x328C;
const char32_t CIRCLED_IDEOGRAPH_WOOD = 0x328D;
const char32_t CIRCLED_IDEOGRAPH_METAL = 0x328E;
const char32_t CIRCLED_IDEOGRAPH_EARTH = 0x328F;
const char32_t CIRCLED_IDEOGRAPH_SUN = 0x3290;
const char32_t CIRCLED_IDEOGRAPH_STOCK = 0x3291;
const char32_t CIRCLED_IDEOGRAPH_HAVE = 0x3292;
const char32_t CIRCLED_IDEOGRAPH_SOCIETY = 0x3293;
const char32_t CIRCLED_IDEOGRAPH_NAME = 0x3294;
const char32_t CIRCLED_IDEOGRAPH_SPECIAL = 0x3295;
const char32_t CIRCLED_IDEOGRAPH_FINANCIAL = 0x3296;
const char32_t CIRCLED_IDEOGRAPH_CONGRATULATION = 0x3297;
const char32_t CIRCLED_IDEOGRAPH_LABOR = 0x3298;
const char32_t CIRCLED_IDEOGRAPH_SECRET = 0x3299;
const char32_t CIRCLED_IDEOGRAPH_MALE = 0x329A;
const char32_t CIRCLED_IDEOGRAPH_FEMALE = 0x329B;
const char32_t CIRCLED_IDEOGRAPH_SUITABLE = 0x329C;
const char32_t CIRCLED_IDEOGRAPH_EXCELLENT = 0x329D;
const char32_t CIRCLED_IDEOGRAPH_PRINT = 0x329E;
const char32_t CIRCLED_IDEOGRAPH_ATTENTION = 0x329F;
const char32_t CIRCLED_IDEOGRAPH_ITEM = 0x32A0;
const char32_t CIRCLED_IDEOGRAPH_REST = 0x32A1;
const char32_t CIRCLED_IDEOGRAPH_COPY = 0x32A2;
const char32_t CIRCLED_IDEOGRAPH_CORRECT = 0x32A3;
const char32_t CIRCLED_IDEOGRAPH_HIGH = 0x32A4;
const char32_t CIRCLED_IDEOGRAPH_CENTRE = 0x32A5;
const char32_t CIRCLED_IDEOGRAPH_LOW = 0x32A6;
const char32_t CIRCLED_IDEOGRAPH_LEFT = 0x32A7;
const char32_t CIRCLED_IDEOGRAPH_RIGHT = 0x32A8;
const char32_t CIRCLED_IDEOGRAPH_MEDICINE = 0x32A9;
const char32_t CIRCLED_IDEOGRAPH_RELIGION = 0x32AA;
const char32_t CIRCLED_IDEOGRAPH_STUDY = 0x32AB;
const char32_t CIRCLED_IDEOGRAPH_SUPERVISE = 0x32AC;
const char32_t CIRCLED_IDEOGRAPH_ENTERPRISE = 0x32AD;
const char32_t CIRCLED_IDEOGRAPH_RESOURCE = 0x32AE;
const char32_t CIRCLED_IDEOGRAPH_ALLIANCE = 0x32AF;
const char32_t CIRCLED_IDEOGRAPH_NIGHT = 0x32B0;
const char32_t CIRCLED_NUMBER_THIRTY_SIX = 0x32B1;
const char32_t CIRCLED_NUMBER_THIRTY_SEVEN = 0x32B2;
const char32_t CIRCLED_NUMBER_THIRTY_EIGHT = 0x32B3;
const char32_t CIRCLED_NUMBER_THIRTY_NINE = 0x32B4;
const char32_t CIRCLED_NUMBER_FORTY = 0x32B5;
const char32_t CIRCLED_NUMBER_FORTY_ONE = 0x32B6;
const char32_t CIRCLED_NUMBER_FORTY_TWO = 0x32B7;
const char32_t CIRCLED_NUMBER_FORTY_THREE = 0x32B8;
const char32_t CIRCLED_NUMBER_FORTY_FOUR = 0x32B9;
const char32_t CIRCLED_NUMBER_FORTY_FIVE = 0x32BA;
const char32_t CIRCLED_NUMBER_FORTY_SIX = 0x32BB;
const char32_t CIRCLED_NUMBER_FORTY_SEVEN = 0x32BC;
const char32_t CIRCLED_NUMBER_FORTY_EIGHT = 0x32BD;
const char32_t CIRCLED_NUMBER_FORTY_NINE = 0x32BE;
const char32_t CIRCLED_NUMBER_FIFTY = 0x32BF;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_JANUARY = 0x32C0;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_FEBRUARY = 0x32C1;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_MARCH = 0x32C2;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_APRIL = 0x32C3;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_MAY = 0x32C4;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_JUNE = 0x32C5;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_JULY = 0x32C6;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_AUGUST = 0x32C7;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_SEPTEMBER = 0x32C8;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_OCTOBER = 0x32C9;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_NOVEMBER = 0x32CA;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DECEMBER = 0x32CB;
const char32_t SQUARE_HG = 0x32CC;
const char32_t SQUARE_ERG = 0x32CD;
const char32_t SQUARE_EV = 0x32CE;
const char32_t LIMITED_LIABILITY_SIGN = 0x32CF;
const char32_t CIRCLED_KATAKANA_A = 0x32D0;
const char32_t CIRCLED_KATAKANA_I = 0x32D1;
const char32_t CIRCLED_KATAKANA_U = 0x32D2;
const char32_t CIRCLED_KATAKANA_E = 0x32D3;
const char32_t CIRCLED_KATAKANA_O = 0x32D4;
const char32_t CIRCLED_KATAKANA_KA = 0x32D5;
const char32_t CIRCLED_KATAKANA_KI = 0x32D6;
const char32_t CIRCLED_KATAKANA_KU = 0x32D7;
const char32_t CIRCLED_KATAKANA_KE = 0x32D8;
const char32_t CIRCLED_KATAKANA_KO = 0x32D9;
const char32_t CIRCLED_KATAKANA_SA = 0x32DA;
const char32_t CIRCLED_KATAKANA_SI = 0x32DB;
const char32_t CIRCLED_KATAKANA_SU = 0x32DC;
const char32_t CIRCLED_KATAKANA_SE = 0x32DD;
const char32_t CIRCLED_KATAKANA_SO = 0x32DE;
const char32_t CIRCLED_KATAKANA_TA = 0x32DF;
const char32_t CIRCLED_KATAKANA_TI = 0x32E0;
const char32_t CIRCLED_KATAKANA_TU = 0x32E1;
const char32_t CIRCLED_KATAKANA_TE = 0x32E2;
const char32_t CIRCLED_KATAKANA_TO = 0x32E3;
const char32_t CIRCLED_KATAKANA_NA = 0x32E4;
const char32_t CIRCLED_KATAKANA_NI = 0x32E5;
const char32_t CIRCLED_KATAKANA_NU = 0x32E6;
const char32_t CIRCLED_KATAKANA_NE = 0x32E7;
const char32_t CIRCLED_KATAKANA_NO = 0x32E8;
const char32_t CIRCLED_KATAKANA_HA = 0x32E9;
const char32_t CIRCLED_KATAKANA_HI = 0x32EA;
const char32_t CIRCLED_KATAKANA_HU = 0x32EB;
const char32_t CIRCLED_KATAKANA_HE = 0x32EC;
const char32_t CIRCLED_KATAKANA_HO = 0x32ED;
const char32_t CIRCLED_KATAKANA_MA = 0x32EE;
const char32_t CIRCLED_KATAKANA_MI = 0x32EF;
const char32_t CIRCLED_KATAKANA_MU = 0x32F0;
const char32_t CIRCLED_KATAKANA_ME = 0x32F1;
const char32_t CIRCLED_KATAKANA_MO = 0x32F2;
const char32_t CIRCLED_KATAKANA_YA = 0x32F3;
const char32_t CIRCLED_KATAKANA_YU = 0x32F4;
const char32_t CIRCLED_KATAKANA_YO = 0x32F5;
const char32_t CIRCLED_KATAKANA_RA = 0x32F6;
const char32_t CIRCLED_KATAKANA_RI = 0x32F7;
const char32_t CIRCLED_KATAKANA_RU = 0x32F8;
const char32_t CIRCLED_KATAKANA_RE = 0x32F9;
const char32_t CIRCLED_KATAKANA_RO = 0x32FA;
const char32_t CIRCLED_KATAKANA_WA = 0x32FB;
const char32_t CIRCLED_KATAKANA_WI = 0x32FC;
const char32_t CIRCLED_KATAKANA_WE = 0x32FD;
const char32_t CIRCLED_KATAKANA_WO = 0x32FE;
const char32_t SQUARE_ERA_NAME_REIWA = 0x32FF;
const char32_t SQUARE_APAATO = 0x3300;
const char32_t SQUARE_ARUHUA = 0x3301;
const char32_t SQUARE_ANPEA = 0x3302;
const char32_t SQUARE_AARU = 0x3303;
const char32_t SQUARE_ININGU = 0x3304;
const char32_t SQUARE_INTI = 0x3305;
const char32_t SQUARE_UON = 0x3306;
const char32_t SQUARE_ESUKUUDO = 0x3307;
const char32_t SQUARE_EEKAA = 0x3308;
const char32_t SQUARE_ONSU = 0x3309;
const char32_t SQUARE_OOMU = 0x330A;
const char32_t SQUARE_KAIRI = 0x330B;
const char32_t SQUARE_KARATTO = 0x330C;
const char32_t SQUARE_KARORII = 0x330D;
const char32_t SQUARE_GARON = 0x330E;
const char32_t SQUARE_GANMA = 0x330F;
const char32_t SQUARE_GIGA = 0x3310;
const char32_t SQUARE_GINII = 0x3311;
const char32_t SQUARE_KYURII = 0x3312;
const char32_t SQUARE_GIRUDAA = 0x3313;
const char32_t SQUARE_KIRO = 0x3314;
const char32_t SQUARE_KIROGURAMU = 0x3315;
const char32_t SQUARE_KIROMEETORU = 0x3316;
const char32_t SQUARE_KIROWATTO = 0x3317;
const char32_t SQUARE_GURAMU = 0x3318;
const char32_t SQUARE_GURAMUTON = 0x3319;
const char32_t SQUARE_KURUZEIRO = 0x331A;
const char32_t SQUARE_KUROONE = 0x331B;
const char32_t SQUARE_KEESU = 0x331C;
const char32_t SQUARE_KORUNA = 0x331D;
const char32_t SQUARE_KOOPO = 0x331E;
const char32_t SQUARE_SAIKURU = 0x331F;
const char32_t SQUARE_SANTIIMU = 0x3320;
const char32_t SQUARE_SIRINGU = 0x3321;
const char32_t SQUARE_SENTI = 0x3322;
const char32_t SQUARE_SENTO = 0x3323;
const char32_t SQUARE_DAASU = 0x3324;
const char32_t SQUARE_DESI = 0x3325;
const char32_t SQUARE_DORU = 0x3326;
const char32_t SQUARE_TON = 0x3327;
const char32_t SQUARE_NANO = 0x3328;
const char32_t SQUARE_NOTTO = 0x3329;
const char32_t SQUARE_HAITU = 0x332A;
const char32_t SQUARE_PAASENTO = 0x332B;
const char32_t SQUARE_PAATU = 0x332C;
const char32_t SQUARE_BAARERU = 0x332D;
const char32_t SQUARE_PIASUTORU = 0x332E;
const char32_t SQUARE_PIKURU = 0x332F;
const char32_t SQUARE_PIKO = 0x3330;
const char32_t SQUARE_BIRU = 0x3331;
const char32_t SQUARE_HUARADDO = 0x3332;
const char32_t SQUARE_HUIITO = 0x3333;
const char32_t SQUARE_BUSSYERU = 0x3334;
const char32_t SQUARE_HURAN = 0x3335;
const char32_t SQUARE_HEKUTAARU = 0x3336;
const char32_t SQUARE_PESO = 0x3337;
const char32_t SQUARE_PENIHI = 0x3338;
const char32_t SQUARE_HERUTU = 0x3339;
const char32_t SQUARE_PENSU = 0x333A;
const char32_t SQUARE_PEEZI = 0x333B;
const char32_t SQUARE_BEETA = 0x333C;
const char32_t SQUARE_POINTO = 0x333D;
const char32_t SQUARE_BORUTO = 0x333E;
const char32_t SQUARE_HON = 0x333F;
const char32_t SQUARE_PONDO = 0x3340;
const char32_t SQUARE_HOORU = 0x3341;
const char32_t SQUARE_HOON = 0x3342;
const char32_t SQUARE_MAIKURO = 0x3343;
const char32_t SQUARE_MAIRU = 0x3344;
const char32_t SQUARE_MAHHA = 0x3345;
const char32_t SQUARE_MARUKU = 0x3346;
const char32_t SQUARE_MANSYON = 0x3347;
const char32_t SQUARE_MIKURON = 0x3348;
const char32_t SQUARE_MIRI = 0x3349;
const char32_t SQUARE_MIRIBAARU = 0x334A;
const char32_t SQUARE_MEGA = 0x334B;
const char32_t SQUARE_MEGATON = 0x334C;
const char32_t SQUARE_MEETORU = 0x334D;
const char32_t SQUARE_YAADO = 0x334E;
const char32_t SQUARE_YAARU = 0x334F;
const char32_t SQUARE_YUAN = 0x3350;
const char32_t SQUARE_RITTORU = 0x3351;
const char32_t SQUARE_RIRA = 0x3352;
const char32_t SQUARE_RUPII = 0x3353;
const char32_t SQUARE_RUUBURU = 0x3354;
const char32_t SQUARE_REMU = 0x3355;
const char32_t SQUARE_RENTOGEN = 0x3356;
const char32_t SQUARE_WATTO = 0x3357;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_ZERO = 0x3358;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_ONE = 0x3359;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWO = 0x335A;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_THREE = 0x335B;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FOUR = 0x335C;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FIVE = 0x335D;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SIX = 0x335E;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SEVEN = 0x335F;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_EIGHT = 0x3360;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_NINE = 0x3361;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TEN = 0x3362;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_ELEVEN = 0x3363;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWELVE = 0x3364;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_THIRTEEN = 0x3365;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FOURTEEN = 0x3366;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FIFTEEN = 0x3367;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SIXTEEN = 0x3368;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SEVENTEEN = 0x3369;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_EIGHTEEN = 0x336A;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_NINETEEN = 0x336B;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY = 0x336C;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_ONE = 0x336D;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_TWO = 0x336E;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_THREE = 0x336F;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_FOUR = 0x3370;
const char32_t SQUARE_HPA = 0x3371;
const char32_t SQUARE_DA = 0x3372;
const char32_t SQUARE_AU = 0x3373;
const char32_t SQUARE_BAR = 0x3374;
const char32_t SQUARE_OV = 0x3375;
const char32_t SQUARE_PC = 0x3376;
const char32_t SQUARE_DM = 0x3377;
const char32_t SQUARE_DM_SQUARED = 0x3378;
const char32_t SQUARE_DM_CUBED = 0x3379;
const char32_t SQUARE_IU = 0x337A;
const char32_t SQUARE_ERA_NAME_HEISEI = 0x337B;
const char32_t SQUARE_ERA_NAME_SYOUWA = 0x337C;
const char32_t SQUARE_ERA_NAME_TAISYOU = 0x337D;
const char32_t SQUARE_ERA_NAME_MEIZI = 0x337E;
const char32_t SQUARE_CORPORATION = 0x337F;
const char32_t SQUARE_PA_AMPS = 0x3380;
const char32_t SQUARE_NA = 0x3381;
const char32_t SQUARE_MU_A = 0x3382;
const char32_t SQUARE_MA = 0x3383;
const char32_t SQUARE_KA = 0x3384;
const char32_t SQUARE_KB = 0x3385;
const char32_t SQUARE_MB = 0x3386;
const char32_t SQUARE_GB = 0x3387;
const char32_t SQUARE_CAL = 0x3388;
const char32_t SQUARE_KCAL = 0x3389;
const char32_t SQUARE_PF = 0x338A;
const char32_t SQUARE_NF = 0x338B;
const char32_t SQUARE_MU_F = 0x338C;
const char32_t SQUARE_MU_G = 0x338D;
const char32_t SQUARE_MG = 0x338E;
const char32_t SQUARE_KG = 0x338F;
const char32_t SQUARE_HZ = 0x3390;
const char32_t SQUARE_KHZ = 0x3391;
const char32_t SQUARE_MHZ = 0x3392;
const char32_t SQUARE_GHZ = 0x3393;
const char32_t SQUARE_THZ = 0x3394;
const char32_t SQUARE_MU_L = 0x3395;
const char32_t SQUARE_ML = 0x3396;
const char32_t SQUARE_DL = 0x3397;
const char32_t SQUARE_KL = 0x3398;
const char32_t SQUARE_FM = 0x3399;
const char32_t SQUARE_NM = 0x339A;
const char32_t SQUARE_MU_M = 0x339B;
const char32_t SQUARE_MM = 0x339C;
const char32_t SQUARE_CM = 0x339D;
const char32_t SQUARE_KM = 0x339E;
const char32_t SQUARE_MM_SQUARED = 0x339F;
const char32_t SQUARE_CM_SQUARED = 0x33A0;
const char32_t SQUARE_M_SQUARED = 0x33A1;
const char32_t SQUARE_KM_SQUARED = 0x33A2;
const char32_t SQUARE_MM_CUBED = 0x33A3;
const char32_t SQUARE_CM_CUBED = 0x33A4;
const char32_t SQUARE_M_CUBED = 0x33A5;
const char32_t SQUARE_KM_CUBED = 0x33A6;
const char32_t SQUARE_M_OVER_S = 0x33A7;
const char32_t SQUARE_M_OVER_S_SQUARED = 0x33A8;
const char32_t SQUARE_PA = 0x33A9;
const char32_t SQUARE_KPA = 0x33AA;
const char32_t SQUARE_MPA = 0x33AB;
const char32_t SQUARE_GPA = 0x33AC;
const char32_t SQUARE_RAD = 0x33AD;
const char32_t SQUARE_RAD_OVER_S = 0x33AE;
const char32_t SQUARE_RAD_OVER_S_SQUARED = 0x33AF;
const char32_t SQUARE_PS = 0x33B0;
const char32_t SQUARE_NS = 0x33B1;
const char32_t SQUARE_MU_S = 0x33B2;
const char32_t SQUARE_MS = 0x33B3;
const char32_t SQUARE_PV = 0x33B4;
const char32_t SQUARE_NV = 0x33B5;
const char32_t SQUARE_MU_V = 0x33B6;
const char32_t SQUARE_MV = 0x33B7;
const char32_t SQUARE_KV = 0x33B8;
const char32_t SQUARE_MV_MEGA = 0x33B9;
const char32_t SQUARE_PW = 0x33BA;
const char32_t SQUARE_NW = 0x33BB;
const char32_t SQUARE_MU_W = 0x33BC;
const char32_t SQUARE_MW = 0x33BD;
const char32_t SQUARE_KW = 0x33BE;
const char32_t SQUARE_MW_MEGA = 0x33BF;
const char32_t SQUARE_K_OHM = 0x33C0;
const char32_t SQUARE_M_OHM = 0x33C1;
const char32_t SQUARE_AM = 0x33C2;
const char32_t SQUARE_BQ = 0x33C3;
const char32_t SQUARE_CC = 0x33C4;
const char32_t SQUARE_CD = 0x33C5;
const char32_t SQUARE_C_OVER_KG = 0x33C6;
const char32_t SQUARE_CO = 0x33C7;
const char32_t SQUARE_DB = 0x33C8;
const char32_t SQUARE_GY = 0x33C9;
const char32_t SQUARE_HA = 0x33CA;
const char32_t SQUARE_HP = 0x33CB;
const char32_t SQUARE_IN = 0x33CC;
const char32_t SQUARE_KK = 0x33CD;
const char32_t SQUARE_KM_CAPITAL = 0x33CE;
const char32_t SQUARE_KT = 0x33CF;
const char32_t SQUARE_LM = 0x33D0;
const char32_t SQUARE_LN = 0x33D1;
const char32_t SQUARE_LOG = 0x33D2;
const char32_t SQUARE_LX = 0x33D3;
const char32_t SQUARE_MB_SMALL = 0x33D4;
const char32_t SQUARE_MIL = 0x33D5;
const char32_t SQUARE_MOL = 0x33D6;
const char32_t SQUARE_PH = 0x33D7;
const char32_t SQUARE_PM = 0x33D8;
const char32_t SQUARE_PPM = 0x33D9;
const char32_t SQUARE_PR = 0x33DA;
const char32_t SQUARE_SR = 0x33DB;
const char32_t SQUARE_SV = 0x33DC;
const char32_t SQUARE_WB = 0x33DD;
const char32_t SQUARE_V_OVER_M = 0x33DE;
const char32_t SQUARE_A_OVER_M = 0x33DF;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_ONE = 0x33E0;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWO = 0x33E1;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THREE = 0x33E2;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FOUR = 0x33E3;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FIVE = 0x33E4;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SIX = 0x33E5;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SEVEN = 0x33E6;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_EIGHT = 0x33E7;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_NINE = 0x33E8;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TEN = 0x33E9;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_ELEVEN = 0x33EA;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWELVE = 0x33EB;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THIRTEEN = 0x33EC;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FOURTEEN = 0x33ED;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FIFTEEN = 0x33EE;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SIXTEEN = 0x33EF;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SEVENTEEN = 0x33F0;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_EIGHTEEN = 0x33F1;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_NINETEEN = 0x33F2;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY = 0x33F3;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_ONE = 0x33F4;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_TWO = 0x33F5;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_THREE = 0x33F6;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_FOUR = 0x33F7;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_FIVE = 0x33F8;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_SIX = 0x33F9;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_SEVEN = 0x33FA;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_EIGHT = 0x33FB;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_NINE = 0x33FC;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THIRTY = 0x33FD;
const char32_t IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THIRTY_ONE = 0x33FE;
const char32_t SQUARE_GAL = 0x33FF;
const char32_t CJK_IDEOGRAPH_EXTENSION_A_FIRST = 0x3400;
const char32_t CJK_IDEOGRAPH_EXTENSION_A_LAST = 0x4DBF;
const char32_t HEXAGRAM_FOR_THE_CREATIVE_HEAVEN = 0x4DC0;
const char32_t HEXAGRAM_FOR_THE_RECEPTIVE_EARTH = 0x4DC1;
const char32_t HEXAGRAM_FOR_DIFFICULTY_AT_THE_BEGINNING = 0x4DC2;
const char32_t HEXAGRAM_FOR_YOUTHFUL_FOLLY = 0x4DC3;
const char32_t HEXAGRAM_FOR_WAITING = 0x4DC4;
const char32_t HEXAGRAM_FOR_CONFLICT = 0x4DC5;
const char32_t HEXAGRAM_FOR_THE_ARMY = 0x4DC6;
const char32_t HEXAGRAM_FOR_HOLDING_TOGETHER = 0x4DC7;
const char32_t HEXAGRAM_FOR_SMALL_TAMING = 0x4DC8;
const char32_t HEXAGRAM_FOR_TREADING = 0x4DC9;
const char32_t HEXAGRAM_FOR_PEACE = 0x4DCA;
const char32_t HEXAGRAM_FOR_STANDSTILL = 0x4DCB;
const char32_t HEXAGRAM_FOR_FELLOWSHIP = 0x4DCC;
const char32_t HEXAGRAM_FOR_GREAT_POSSESSION = 0x4DCD;
const char32_t HEXAGRAM_FOR_MODESTY = 0x4DCE;
const char32_t HEXAGRAM_FOR_ENTHUSIASM = 0x4DCF;
const char32_t HEXAGRAM_FOR_FOLLOWING = 0x4DD0;
const char32_t HEXAGRAM_FOR_WORK_ON_THE_DECAYED = 0x4DD1;
const char32_t HEXAGRAM_FOR_APPROACH = 0x4DD2;
const char32_t HEXAGRAM_FOR_CONTEMPLATION = 0x4DD3;
const char32_t HEXAGRAM_FOR_BITING_THROUGH = 0x4DD4;
const char32_t HEXAGRAM_FOR_GRACE = 0x4DD5;
const char32_t HEXAGRAM_FOR_SPLITTING_APART = 0x4DD6;
const char32_t HEXAGRAM_FOR_RETURN = 0x4DD7;
const char32_t HEXAGRAM_FOR_INNOCENCE = 0x4DD8;
const char32_t HEXAGRAM_FOR_GREAT_TAMING = 0x4DD9;
const char32_t HEXAGRAM_FOR_MOUTH_CORNERS = 0x4DDA;
const char32_t HEXAGRAM_FOR_GREAT_PREPONDERANCE = 0x4DDB;
const char32_t HEXAGRAM_FOR_THE_ABYSMAL_WATER = 0x4DDC;
const char32_t HEXAGRAM_FOR_THE_CLINGING_FIRE = 0x4DDD;
const char32_t HEXAGRAM_FOR_INFLUENCE = 0x4DDE;
const char32_t HEXAGRAM_FOR_DURATION = 0x4DDF;
const char32_t HEXAGRAM_FOR_RETREAT = 0x4DE0;
const char32_t HEXAGRAM_FOR_GREAT_POWER = 0x4DE1;
const char32_t HEXAGRAM_FOR_PROGRESS = 0x4DE2;
const char32_t HEXAGRAM_FOR_DARKENING_OF_THE_LIGHT = 0x4DE3;
const char32_t HEXAGRAM_FOR_THE_FAMILY = 0x4DE4;
const char32_t HEXAGRAM_FOR_OPPOSITION = 0x4DE5;
const char32_t HEXAGRAM_FOR_OBSTRUCTION = 0x4DE6;
const char32_t HEXAGRAM_FOR_DELIVERANCE = 0x4DE7;
const char32_t HEXAGRAM_FOR_DECREASE = 0x4DE8;
const char32_t HEXAGRAM_FOR_INCREASE = 0x4DE9;
const char32_t HEXAGRAM_FOR_BREAKTHROUGH = 0x4DEA;
const char32_t HEXAGRAM_FOR_COMING_TO_MEET = 0x4DEB;
const char32_t HEXAGRAM_FOR_GATHERING_TOGETHER = 0x4DEC;
const char32_t HEXAGRAM_FOR_PUSHING_UPWARD = 0x4DED;
const char32_t HEXAGRAM_FOR_OPPRESSION = 0x4DEE;
const char32_t HEXAGRAM_FOR_THE_WELL = 0x4DEF;
const char32_t HEXAGRAM_FOR_REVOLUTION = 0x4DF0;
const char32_t HEXAGRAM_FOR_THE_CAULDRON = 0x4DF1;
const char32_t HEXAGRAM_FOR_THE_AROUSING_THUNDER = 0x4DF2;
const char32_t HEXAGRAM_FOR_THE_KEEPING_STILL_MOUNTAIN = 0x4DF3;
const char32_t HEXAGRAM_FOR_DEVELOPMENT = 0x4DF4;
const char32_t HEXAGRAM_FOR_THE_MARRYING_MAIDEN = 0x4DF5;
const char32_t HEXAGRAM_FOR_ABUNDANCE = 0x4DF6;
const char32_t HEXAGRAM_FOR_THE_WANDERER = 0x4DF7;
const char32_t HEXAGRAM_FOR_THE_GENTLE_WIND = 0x4DF8;
const char32_t HEXAGRAM_FOR_THE_JOYOUS_LAKE = 0x4DF9;
const char32_t HEXAGRAM_FOR_DISPERSION = 0x4DFA;
const char32_t HEXAGRAM_FOR_LIMITATION = 0x4DFB;
const char32_t HEXAGRAM_FOR_INNER_TRUTH = 0x4DFC;
const char32_t HEXAGRAM_FOR_SMALL_PREPONDERANCE = 0x4DFD;
const char32_t HEXAGRAM_FOR_AFTER_COMPLETION = 0x4DFE;
const char32_t HEXAGRAM_FOR_BEFORE_COMPLETION = 0x4DFF;
const char32_t CJK_IDEOGRAPH_FIRST = 0x4E00;
const char32_t CJK_IDEOGRAPH_LAST = 0x9FFC;
const char32_t YI_SYLLABLE_IT = 0xA000;
const char32_t YI_SYLLABLE_IX = 0xA001;
const char32_t YI_SYLLABLE_I = 0xA002;
const char32_t YI_SYLLABLE_IP = 0xA003;
const char32_t YI_SYLLABLE_IET = 0xA004;
const char32_t YI_SYLLABLE_IEX = 0xA005;
const char32_t YI_SYLLABLE_IE = 0xA006;
const char32_t YI_SYLLABLE_IEP = 0xA007;
const char32_t YI_SYLLABLE_AT = 0xA008;
const char32_t YI_SYLLABLE_AX = 0xA009;
const char32_t YI_SYLLABLE_A = 0xA00A;
const char32_t YI_SYLLABLE_AP = 0xA00B;
const char32_t YI_SYLLABLE_UOX = 0xA00C;
const char32_t YI_SYLLABLE_UO = 0xA00D;
const char32_t YI_SYLLABLE_UOP = 0xA00E;
const char32_t YI_SYLLABLE_OT = 0xA00F;
const char32_t YI_SYLLABLE_OX = 0xA010;
const char32_t YI_SYLLABLE_O = 0xA011;
const char32_t YI_SYLLABLE_OP = 0xA012;
const char32_t YI_SYLLABLE_EX = 0xA013;
const char32_t YI_SYLLABLE_E = 0xA014;
const char32_t YI_SYLLABLE_WU = 0xA015;
const char32_t YI_SYLLABLE_BIT = 0xA016;
const char32_t YI_SYLLABLE_BIX = 0xA017;
const char32_t YI_SYLLABLE_BI = 0xA018;
const char32_t YI_SYLLABLE_BIP = 0xA019;
const char32_t YI_SYLLABLE_BIET = 0xA01A;
const char32_t YI_SYLLABLE_BIEX = 0xA01B;
const char32_t YI_SYLLABLE_BIE = 0xA01C;
const char32_t YI_SYLLABLE_BIEP = 0xA01D;
const char32_t YI_SYLLABLE_BAT = 0xA01E;
const char32_t YI_SYLLABLE_BAX = 0xA01F;
const char32_t YI_SYLLABLE_BA = 0xA020;
const char32_t YI_SYLLABLE_BAP = 0xA021;
const char32_t YI_SYLLABLE_BUOX = 0xA022;
const char32_t YI_SYLLABLE_BUO = 0xA023;
const char32_t YI_SYLLABLE_BUOP = 0xA024;
const char32_t YI_SYLLABLE_BOT = 0xA025;
const char32_t YI_SYLLABLE_BOX = 0xA026;
const char32_t YI_SYLLABLE_BO = 0xA027;
const char32_t YI_SYLLABLE_BOP = 0xA028;
const char32_t YI_SYLLABLE_BEX = 0xA029;
const char32_t YI_SYLLABLE_BE = 0xA02A;
const char32_t YI_SYLLABLE_BEP = 0xA02B;
const char32_t YI_SYLLABLE_BUT = 0xA02C;
const char32_t YI_SYLLABLE_BUX = 0xA02D;
const char32_t YI_SYLLABLE_BU = 0xA02E;
const char32_t YI_SYLLABLE_BUP = 0xA02F;
const char32_t YI_SYLLABLE_BURX = 0xA030;
const char32_t YI_SYLLABLE_BUR = 0xA031;
const char32_t YI_SYLLABLE_BYT = 0xA032;
const char32_t YI_SYLLABLE_BYX = 0xA033;
const char32_t YI_SYLLABLE_BY = 0xA034;
const char32_t YI_SYLLABLE_BYP = 0xA035;
const char32_t YI_SYLLABLE_BYRX = 0xA036;
const char32_t YI_SYLLABLE_BYR = 0xA037;
const char32_t YI_SYLLABLE_PIT = 0xA038;
const char32_t YI_SYLLABLE_PIX = 0xA039;
const char32_t YI_SYLLABLE_PI = 0xA03A;
const char32_t YI_SYLLABLE_PIP = 0xA03B;
const char32_t YI_SYLLABLE_PIEX = 0xA03C;
const char32_t YI_SYLLABLE_PIE = 0xA03D;
const char32_t YI_SYLLABLE_PIEP = 0xA03E;
const char32_t YI_SYLLABLE_PAT = 0xA03F;
const char32_t YI_SYLLABLE_PAX = 0xA040;
const char32_t YI_SYLLABLE_PA = 0xA041;
const char32_t YI_SYLLABLE_PAP = 0xA042;
const char32_t YI_SYLLABLE_PUOX = 0xA043;
const char32_t YI_SYLLABLE_PUO = 0xA044;
const char32_t YI_SYLLABLE_PUOP = 0xA045;
const char32_t YI_SYLLABLE_POT = 0xA046;
const char32_t YI_SYLLABLE_POX = 0xA047;
const char32_t YI_SYLLABLE_PO = 0xA048;
const char32_t YI_SYLLABLE_POP = 0xA049;
const char32_t YI_SYLLABLE_PUT = 0xA04A;
const char32_t YI_SYLLABLE_PUX = 0xA04B;
const char32_t YI_SYLLABLE_PU = 0xA04C;
const char32_t YI_SYLLABLE_PUP = 0xA04D;
const char32_t YI_SYLLABLE_PURX = 0xA04E;
const char32_t YI_SYLLABLE_PUR = 0xA04F;
const char32_t YI_SYLLABLE_PYT = 0xA050;
const char32_t YI_SYLLABLE_PYX = 0xA051;
const char32_t YI_SYLLABLE_PY = 0xA052;
const char32_t YI_SYLLABLE_PYP = 0xA053;
const char32_t YI_SYLLABLE_PYRX = 0xA054;
const char32_t YI_SYLLABLE_PYR = 0xA055;
const char32_t YI_SYLLABLE_BBIT = 0xA056;
const char32_t YI_SYLLABLE_BBIX = 0xA057;
const char32_t YI_SYLLABLE_BBI = 0xA058;
const char32_t YI_SYLLABLE_BBIP = 0xA059;
const char32_t YI_SYLLABLE_BBIET = 0xA05A;
const char32_t YI_SYLLABLE_BBIEX = 0xA05B;
const char32_t YI_SYLLABLE_BBIE = 0xA05C;
const char32_t YI_SYLLABLE_BBIEP = 0xA05D;
const char32_t YI_SYLLABLE_BBAT = 0xA05E;
const char32_t YI_SYLLABLE_BBAX = 0xA05F;
const char32_t YI_SYLLABLE_BBA = 0xA060;
const char32_t YI_SYLLABLE_BBAP = 0xA061;
const char32_t YI_SYLLABLE_BBUOX = 0xA062;
const char32_t YI_SYLLABLE_BBUO = 0xA063;
const char32_t YI_SYLLABLE_BBUOP = 0xA064;
const char32_t YI_SYLLABLE_BBOT = 0xA065;
const char32_t YI_SYLLABLE_BBOX = 0xA066;
const char32_t YI_SYLLABLE_BBO = 0xA067;
const char32_t YI_SYLLABLE_BBOP = 0xA068;
const char32_t YI_SYLLABLE_BBEX = 0xA069;
const char32_t YI_SYLLABLE_BBE = 0xA06A;
const char32_t YI_SYLLABLE_BBEP = 0xA06B;
const char32_t YI_SYLLABLE_BBUT = 0xA06C;
const char32_t YI_SYLLABLE_BBUX = 0xA06D;
const char32_t YI_SYLLABLE_BBU = 0xA06E;
const char32_t YI_SYLLABLE_BBUP = 0xA06F;
const char32_t YI_SYLLABLE_BBURX = 0xA070;
const char32_t YI_SYLLABLE_BBUR = 0xA071;
const char32_t YI_SYLLABLE_BBYT = 0xA072;
const char32_t YI_SYLLABLE_BBYX = 0xA073;
const char32_t YI_SYLLABLE_BBY = 0xA074;
const char32_t YI_SYLLABLE_BBYP = 0xA075;
const char32_t YI_SYLLABLE_NBIT = 0xA076;
const char32_t YI_SYLLABLE_NBIX = 0xA077;
const char32_t YI_SYLLABLE_NBI = 0xA078;
const char32_t YI_SYLLABLE_NBIP = 0xA079;
const char32_t YI_SYLLABLE_NBIEX = 0xA07A;
const char32_t YI_SYLLABLE_NBIE = 0xA07B;
const char32_t YI_SYLLABLE_NBIEP = 0xA07C;
const char32_t YI_SYLLABLE_NBAT = 0xA07D;
const char32_t YI_SYLLABLE_NBAX = 0xA07E;
const char32_t YI_SYLLABLE_NBA = 0xA07F;
const char32_t YI_SYLLABLE_NBAP = 0xA080;
const char32_t YI_SYLLABLE_NBOT = 0xA081;
const char32_t YI_SYLLABLE_NBOX = 0xA082;
const char32_t YI_SYLLABLE_NBO = 0xA083;
const char32_t YI_SYLLABLE_NBOP = 0xA084;
const char32_t YI_SYLLABLE_NBUT = 0xA085;
const char32_t YI_SYLLABLE_NBUX = 0xA086;
const char32_t YI_SYLLABLE_NBU = 0xA087;
const char32_t YI_SYLLABLE_NBUP = 0xA088;
const char32_t YI_SYLLABLE_NBURX = 0xA089;
const char32_t YI_SYLLABLE_NBUR = 0xA08A;
const char32_t YI_SYLLABLE_NBYT = 0xA08B;
const char32_t YI_SYLLABLE_NBYX = 0xA08C;
const char32_t YI_SYLLABLE_NBY = 0xA08D;
const char32_t YI_SYLLABLE_NBYP = 0xA08E;
const char32_t YI_SYLLABLE_NBYRX = 0xA08F;
const char32_t YI_SYLLABLE_NBYR = 0xA090;
const char32_t YI_SYLLABLE_HMIT = 0xA091;
const char32_t YI_SYLLABLE_HMIX = 0xA092;
const char32_t YI_SYLLABLE_HMI = 0xA093;
const char32_t YI_SYLLABLE_HMIP = 0xA094;
const char32_t YI_SYLLABLE_HMIEX = 0xA095;
const char32_t YI_SYLLABLE_HMIE = 0xA096;
const char32_t YI_SYLLABLE_HMIEP = 0xA097;
const char32_t YI_SYLLABLE_HMAT = 0xA098;
const char32_t YI_SYLLABLE_HMAX = 0xA099;
const char32_t YI_SYLLABLE_HMA = 0xA09A;
const char32_t YI_SYLLABLE_HMAP = 0xA09B;
const char32_t YI_SYLLABLE_HMUOX = 0xA09C;
const char32_t YI_SYLLABLE_HMUO = 0xA09D;
const char32_t YI_SYLLABLE_HMUOP = 0xA09E;
const char32_t YI_SYLLABLE_HMOT = 0xA09F;
const char32_t YI_SYLLABLE_HMOX = 0xA0A0;
const char32_t YI_SYLLABLE_HMO = 0xA0A1;
const char32_t YI_SYLLABLE_HMOP = 0xA0A2;
const char32_t YI_SYLLABLE_HMUT = 0xA0A3;
const char32_t YI_SYLLABLE_HMUX = 0xA0A4;
const char32_t YI_SYLLABLE_HMU = 0xA0A5;
const char32_t YI_SYLLABLE_HMUP = 0xA0A6;
const char32_t YI_SYLLABLE_HMURX = 0xA0A7;
const char32_t YI_SYLLABLE_HMUR = 0xA0A8;
const char32_t YI_SYLLABLE_HMYX = 0xA0A9;
const char32_t YI_SYLLABLE_HMY = 0xA0AA;
const char32_t YI_SYLLABLE_HMYP = 0xA0AB;
const char32_t YI_SYLLABLE_HMYRX = 0xA0AC;
const char32_t YI_SYLLABLE_HMYR = 0xA0AD;
const char32_t YI_SYLLABLE_MIT = 0xA0AE;
const char32_t YI_SYLLABLE_MIX = 0xA0AF;
const char32_t YI_SYLLABLE_MI = 0xA0B0;
const char32_t YI_SYLLABLE_MIP = 0xA0B1;
const char32_t YI_SYLLABLE_MIEX = 0xA0B2;
const char32_t YI_SYLLABLE_MIE = 0xA0B3;
const char32_t YI_SYLLABLE_MIEP = 0xA0B4;
const char32_t YI_SYLLABLE_MAT = 0xA0B5;
const char32_t YI_SYLLABLE_MAX = 0xA0B6;
const char32_t YI_SYLLABLE_MA = 0xA0B7;
const char32_t YI_SYLLABLE_MAP = 0xA0B8;
const char32_t YI_SYLLABLE_MUOT = 0xA0B9;
const char32_t YI_SYLLABLE_MUOX = 0xA0BA;
const char32_t YI_SYLLABLE_MUO = 0xA0BB;
const char32_t YI_SYLLABLE_MUOP = 0xA0BC;
const char32_t YI_SYLLABLE_MOT = 0xA0BD;
const char32_t YI_SYLLABLE_MOX = 0xA0BE;
const char32_t YI_SYLLABLE_MO = 0xA0BF;
const char32_t YI_SYLLABLE_MOP = 0xA0C0;
const char32_t YI_SYLLABLE_MEX = 0xA0C1;
const char32_t YI_SYLLABLE_ME = 0xA0C2;
const char32_t YI_SYLLABLE_MUT = 0xA0C3;
const char32_t YI_SYLLABLE_MUX = 0xA0C4;
const char32_t YI_SYLLABLE_MU = 0xA0C5;
const char32_t YI_SYLLABLE_MUP = 0xA0C6;
const char32_t YI_SYLLABLE_MURX = 0xA0C7;
const char32_t YI_SYLLABLE_MUR = 0xA0C8;
const char32_t YI_SYLLABLE_MYT = 0xA0C9;
const char32_t YI_SYLLABLE_MYX = 0xA0CA;
const char32_t YI_SYLLABLE_MY = 0xA0CB;
const char32_t YI_SYLLABLE_MYP = 0xA0CC;
const char32_t YI_SYLLABLE_FIT = 0xA0CD;
const char32_t YI_SYLLABLE_FIX = 0xA0CE;
const char32_t YI_SYLLABLE_FI = 0xA0CF;
const char32_t YI_SYLLABLE_FIP = 0xA0D0;
const char32_t YI_SYLLABLE_FAT = 0xA0D1;
const char32_t YI_SYLLABLE_FAX = 0xA0D2;
const char32_t YI_SYLLABLE_FA = 0xA0D3;
const char32_t YI_SYLLABLE_FAP = 0xA0D4;
const char32_t YI_SYLLABLE_FOX = 0xA0D5;
const char32_t YI_SYLLABLE_FO = 0xA0D6;
const char32_t YI_SYLLABLE_FOP = 0xA0D7;
const char32_t YI_SYLLABLE_FUT = 0xA0D8;
const char32_t YI_SYLLABLE_FUX = 0xA0D9;
const char32_t YI_SYLLABLE_FU = 0xA0DA;
const char32_t YI_SYLLABLE_FUP = 0xA0DB;
const char32_t YI_SYLLABLE_FURX = 0xA0DC;
const char32_t YI_SYLLABLE_FUR = 0xA0DD;
const char32_t YI_SYLLABLE_FYT = 0xA0DE;
const char32_t YI_SYLLABLE_FYX = 0xA0DF;
const char32_t YI_SYLLABLE_FY = 0xA0E0;
const char32_t YI_SYLLABLE_FYP = 0xA0E1;
const char32_t YI_SYLLABLE_VIT = 0xA0E2;
const char32_t YI_SYLLABLE_VIX = 0xA0E3;
const char32_t YI_SYLLABLE_VI = 0xA0E4;
const char32_t YI_SYLLABLE_VIP = 0xA0E5;
const char32_t YI_SYLLABLE_VIET = 0xA0E6;
const char32_t YI_SYLLABLE_VIEX = 0xA0E7;
const char32_t YI_SYLLABLE_VIE = 0xA0E8;
const char32_t YI_SYLLABLE_VIEP = 0xA0E9;
const char32_t YI_SYLLABLE_VAT = 0xA0EA;
const char32_t YI_SYLLABLE_VAX = 0xA0EB;
const char32_t YI_SYLLABLE_VA = 0xA0EC;
const char32_t YI_SYLLABLE_VAP = 0xA0ED;
const char32_t YI_SYLLABLE_VOT = 0xA0EE;
const char32_t YI_SYLLABLE_VOX = 0xA0EF;
const char32_t YI_SYLLABLE_VO = 0xA0F0;
const char32_t YI_SYLLABLE_VOP = 0xA0F1;
const char32_t YI_SYLLABLE_VEX = 0xA0F2;
const char32_t YI_SYLLABLE_VEP = 0xA0F3;
const char32_t YI_SYLLABLE_VUT = 0xA0F4;
const char32_t YI_SYLLABLE_VUX = 0xA0F5;
const char32_t YI_SYLLABLE_VU = 0xA0F6;
const char32_t YI_SYLLABLE_VUP = 0xA0F7;
const char32_t YI_SYLLABLE_VURX = 0xA0F8;
const char32_t YI_SYLLABLE_VUR = 0xA0F9;
const char32_t YI_SYLLABLE_VYT = 0xA0FA;
const char32_t YI_SYLLABLE_VYX = 0xA0FB;
const char32_t YI_SYLLABLE_VY = 0xA0FC;
const char32_t YI_SYLLABLE_VYP = 0xA0FD;
const char32_t YI_SYLLABLE_VYRX = 0xA0FE;
const char32_t YI_SYLLABLE_VYR = 0xA0FF;
const char32_t YI_SYLLABLE_DIT = 0xA100;
const char32_t YI_SYLLABLE_DIX = 0xA101;
const char32_t YI_SYLLABLE_DI = 0xA102;
const char32_t YI_SYLLABLE_DIP = 0xA103;
const char32_t YI_SYLLABLE_DIEX = 0xA104;
const char32_t YI_SYLLABLE_DIE = 0xA105;
const char32_t YI_SYLLABLE_DIEP = 0xA106;
const char32_t YI_SYLLABLE_DAT = 0xA107;
const char32_t YI_SYLLABLE_DAX = 0xA108;
const char32_t YI_SYLLABLE_DA = 0xA109;
const char32_t YI_SYLLABLE_DAP = 0xA10A;
const char32_t YI_SYLLABLE_DUOX = 0xA10B;
const char32_t YI_SYLLABLE_DUO = 0xA10C;
const char32_t YI_SYLLABLE_DOT = 0xA10D;
const char32_t YI_SYLLABLE_DOX = 0xA10E;
const char32_t YI_SYLLABLE_DO = 0xA10F;
const char32_t YI_SYLLABLE_DOP = 0xA110;
const char32_t YI_SYLLABLE_DEX = 0xA111;
const char32_t YI_SYLLABLE_DE = 0xA112;
const char32_t YI_SYLLABLE_DEP = 0xA113;
const char32_t YI_SYLLABLE_DUT = 0xA114;
const char32_t YI_SYLLABLE_DUX = 0xA115;
const char32_t YI_SYLLABLE_DU = 0xA116;
const char32_t YI_SYLLABLE_DUP = 0xA117;
const char32_t YI_SYLLABLE_DURX = 0xA118;
const char32_t YI_SYLLABLE_DUR = 0xA119;
const char32_t YI_SYLLABLE_TIT = 0xA11A;
const char32_t YI_SYLLABLE_TIX = 0xA11B;
const char32_t YI_SYLLABLE_TI = 0xA11C;
const char32_t YI_SYLLABLE_TIP = 0xA11D;
const char32_t YI_SYLLABLE_TIEX = 0xA11E;
const char32_t YI_SYLLABLE_TIE = 0xA11F;
const char32_t YI_SYLLABLE_TIEP = 0xA120;
const char32_t YI_SYLLABLE_TAT = 0xA121;
const char32_t YI_SYLLABLE_TAX = 0xA122;
const char32_t YI_SYLLABLE_TA = 0xA123;
const char32_t YI_SYLLABLE_TAP = 0xA124;
const char32_t YI_SYLLABLE_TUOT = 0xA125;
const char32_t YI_SYLLABLE_TUOX = 0xA126;
const char32_t YI_SYLLABLE_TUO = 0xA127;
const char32_t YI_SYLLABLE_TUOP = 0xA128;
const char32_t YI_SYLLABLE_TOT = 0xA129;
const char32_t YI_SYLLABLE_TOX = 0xA12A;
const char32_t YI_SYLLABLE_TO = 0xA12B;
const char32_t YI_SYLLABLE_TOP = 0xA12C;
const char32_t YI_SYLLABLE_TEX = 0xA12D;
const char32_t YI_SYLLABLE_TE = 0xA12E;
const char32_t YI_SYLLABLE_TEP = 0xA12F;
const char32_t YI_SYLLABLE_TUT = 0xA130;
const char32_t YI_SYLLABLE_TUX = 0xA131;
const char32_t YI_SYLLABLE_TU = 0xA132;
const char32_t YI_SYLLABLE_TUP = 0xA133;
const char32_t YI_SYLLABLE_TURX = 0xA134;
const char32_t YI_SYLLABLE_TUR = 0xA135;
const char32_t YI_SYLLABLE_DDIT = 0xA136;
const char32_t YI_SYLLABLE_DDIX = 0xA137;
const char32_t YI_SYLLABLE_DDI = 0xA138;
const char32_t YI_SYLLABLE_DDIP = 0xA139;
const char32_t YI_SYLLABLE_DDIEX = 0xA13A;
const char32_t YI_SYLLABLE_DDIE = 0xA13B;
const char32_t YI_SYLLABLE_DDIEP = 0xA13C;
const char32_t YI_SYLLABLE_DDAT = 0xA13D;
const char32_t YI_SYLLABLE_DDAX = 0xA13E;
const char32_t YI_SYLLABLE_DDA = 0xA13F;
const char32_t YI_SYLLABLE_DDAP = 0xA140;
const char32_t YI_SYLLABLE_DDUOX = 0xA141;
const char32_t YI_SYLLABLE_DDUO = 0xA142;
const char32_t YI_SYLLABLE_DDUOP = 0xA143;
const char32_t YI_SYLLABLE_DDOT = 0xA144;
const char32_t YI_SYLLABLE_DDOX = 0xA145;
const char32_t YI_SYLLABLE_DDO = 0xA146;
const char32_t YI_SYLLABLE_DDOP = 0xA147;
const char32_t YI_SYLLABLE_DDEX = 0xA148;
const char32_t YI_SYLLABLE_DDE = 0xA149;
const char32_t YI_SYLLABLE_DDEP = 0xA14A;
const char32_t YI_SYLLABLE_DDUT = 0xA14B;
const char32_t YI_SYLLABLE_DDUX = 0xA14C;
const char32_t YI_SYLLABLE_DDU = 0xA14D;
const char32_t YI_SYLLABLE_DDUP = 0xA14E;
const char32_t YI_SYLLABLE_DDURX = 0xA14F;
const char32_t YI_SYLLABLE_DDUR = 0xA150;
const char32_t YI_SYLLABLE_NDIT = 0xA151;
const char32_t YI_SYLLABLE_NDIX = 0xA152;
const char32_t YI_SYLLABLE_NDI = 0xA153;
const char32_t YI_SYLLABLE_NDIP = 0xA154;
const char32_t YI_SYLLABLE_NDIEX = 0xA155;
const char32_t YI_SYLLABLE_NDIE = 0xA156;
const char32_t YI_SYLLABLE_NDAT = 0xA157;
const char32_t YI_SYLLABLE_NDAX = 0xA158;
const char32_t YI_SYLLABLE_NDA = 0xA159;
const char32_t YI_SYLLABLE_NDAP = 0xA15A;
const char32_t YI_SYLLABLE_NDOT = 0xA15B;
const char32_t YI_SYLLABLE_NDOX = 0xA15C;
const char32_t YI_SYLLABLE_NDO = 0xA15D;
const char32_t YI_SYLLABLE_NDOP = 0xA15E;
const char32_t YI_SYLLABLE_NDEX = 0xA15F;
const char32_t YI_SYLLABLE_NDE = 0xA160;
const char32_t YI_SYLLABLE_NDEP = 0xA161;
const char32_t YI_SYLLABLE_NDUT = 0xA162;
const char32_t YI_SYLLABLE_NDUX = 0xA163;
const char32_t YI_SYLLABLE_NDU = 0xA164;
const char32_t YI_SYLLABLE_NDUP = 0xA165;
const char32_t YI_SYLLABLE_NDURX = 0xA166;
const char32_t YI_SYLLABLE_NDUR = 0xA167;
const char32_t YI_SYLLABLE_HNIT = 0xA168;
const char32_t YI_SYLLABLE_HNIX = 0xA169;
const char32_t YI_SYLLABLE_HNI = 0xA16A;
const char32_t YI_SYLLABLE_HNIP = 0xA16B;
const char32_t YI_SYLLABLE_HNIET = 0xA16C;
const char32_t YI_SYLLABLE_HNIEX = 0xA16D;
const char32_t YI_SYLLABLE_HNIE = 0xA16E;
const char32_t YI_SYLLABLE_HNIEP = 0xA16F;
const char32_t YI_SYLLABLE_HNAT = 0xA170;
const char32_t YI_SYLLABLE_HNAX = 0xA171;
const char32_t YI_SYLLABLE_HNA = 0xA172;
const char32_t YI_SYLLABLE_HNAP = 0xA173;
const char32_t YI_SYLLABLE_HNUOX = 0xA174;
const char32_t YI_SYLLABLE_HNUO = 0xA175;
const char32_t YI_SYLLABLE_HNOT = 0xA176;
const char32_t YI_SYLLABLE_HNOX = 0xA177;
const char32_t YI_SYLLABLE_HNOP = 0xA178;
const char32_t YI_SYLLABLE_HNEX = 0xA179;
const char32_t YI_SYLLABLE_HNE = 0xA17A;
const char32_t YI_SYLLABLE_HNEP = 0xA17B;
const char32_t YI_SYLLABLE_HNUT = 0xA17C;
const char32_t YI_SYLLABLE_NIT = 0xA17D;
const char32_t YI_SYLLABLE_NIX = 0xA17E;
const char32_t YI_SYLLABLE_NI = 0xA17F;
const char32_t YI_SYLLABLE_NIP = 0xA180;
const char32_t YI_SYLLABLE_NIEX = 0xA181;
const char32_t YI_SYLLABLE_NIE = 0xA182;
const char32_t YI_SYLLABLE_NIEP = 0xA183;
const char32_t YI_SYLLABLE_NAX = 0xA184;
const char32_t YI_SYLLABLE_NA = 0xA185;
const char32_t YI_SYLLABLE_NAP = 0xA186;
const char32_t YI_SYLLABLE_NUOX = 0xA187;
const char32_t YI_SYLLABLE_NUO = 0xA188;
const char32_t YI_SYLLABLE_NUOP = 0xA189;
const char32_t YI_SYLLABLE_NOT = 0xA18A;
const char32_t YI_SYLLABLE_NOX = 0xA18B;
const char32_t YI_SYLLABLE_NO = 0xA18C;
const char32_t YI_SYLLABLE_NOP = 0xA18D;
const char32_t YI_SYLLABLE_NEX = 0xA18E;
const char32_t YI_SYLLABLE_NE = 0xA18F;
const char32_t YI_SYLLABLE_NEP = 0xA190;
const char32_t YI_SYLLABLE_NUT = 0xA191;
const char32_t YI_SYLLABLE_NUX = 0xA192;
const char32_t YI_SYLLABLE_NU = 0xA193;
const char32_t YI_SYLLABLE_NUP = 0xA194;
const char32_t YI_SYLLABLE_NURX = 0xA195;
const char32_t YI_SYLLABLE_NUR = 0xA196;
const char32_t YI_SYLLABLE_HLIT = 0xA197;
const char32_t YI_SYLLABLE_HLIX = 0xA198;
const char32_t YI_SYLLABLE_HLI = 0xA199;
const char32_t YI_SYLLABLE_HLIP = 0xA19A;
const char32_t YI_SYLLABLE_HLIEX = 0xA19B;
const char32_t YI_SYLLABLE_HLIE = 0xA19C;
const char32_t YI_SYLLABLE_HLIEP = 0xA19D;
const char32_t YI_SYLLABLE_HLAT = 0xA19E;
const char32_t YI_SYLLABLE_HLAX = 0xA19F;
const char32_t YI_SYLLABLE_HLA = 0xA1A0;
const char32_t YI_SYLLABLE_HLAP = 0xA1A1;
const char32_t YI_SYLLABLE_HLUOX = 0xA1A2;
const char32_t YI_SYLLABLE_HLUO = 0xA1A3;
const char32_t YI_SYLLABLE_HLUOP = 0xA1A4;
const char32_t YI_SYLLABLE_HLOX = 0xA1A5;
const char32_t YI_SYLLABLE_HLO = 0xA1A6;
const char32_t YI_SYLLABLE_HLOP = 0xA1A7;
const char32_t YI_SYLLABLE_HLEX = 0xA1A8;
const char32_t YI_SYLLABLE_HLE = 0xA1A9;
const char32_t YI_SYLLABLE_HLEP = 0xA1AA;
const char32_t YI_SYLLABLE_HLUT = 0xA1AB;
const char32_t YI_SYLLABLE_HLUX = 0xA1AC;
const char32_t YI_SYLLABLE_HLU = 0xA1AD;
const char32_t YI_SYLLABLE_HLUP = 0xA1AE;
const char32_t YI_SYLLABLE_HLURX = 0xA1AF;
const char32_t YI_SYLLABLE_HLUR = 0xA1B0;
const char32_t YI_SYLLABLE_HLYT = 0xA1B1;
const char32_t YI_SYLLABLE_HLYX = 0xA1B2;
const char32_t YI_SYLLABLE_HLY = 0xA1B3;
const char32_t YI_SYLLABLE_HLYP = 0xA1B4;
const char32_t YI_SYLLABLE_HLYRX = 0xA1B5;
const char32_t YI_SYLLABLE_HLYR = 0xA1B6;
const char32_t YI_SYLLABLE_LIT = 0xA1B7;
const char32_t YI_SYLLABLE_LIX = 0xA1B8;
const char32_t YI_SYLLABLE_LI = 0xA1B9;
const char32_t YI_SYLLABLE_LIP = 0xA1BA;
const char32_t YI_SYLLABLE_LIET = 0xA1BB;
const char32_t YI_SYLLABLE_LIEX = 0xA1BC;
const char32_t YI_SYLLABLE_LIE = 0xA1BD;
const char32_t YI_SYLLABLE_LIEP = 0xA1BE;
const char32_t YI_SYLLABLE_LAT = 0xA1BF;
const char32_t YI_SYLLABLE_LAX = 0xA1C0;
const char32_t YI_SYLLABLE_LA = 0xA1C1;
const char32_t YI_SYLLABLE_LAP = 0xA1C2;
const char32_t YI_SYLLABLE_LUOT = 0xA1C3;
const char32_t YI_SYLLABLE_LUOX = 0xA1C4;
const char32_t YI_SYLLABLE_LUO = 0xA1C5;
const char32_t YI_SYLLABLE_LUOP = 0xA1C6;
const char32_t YI_SYLLABLE_LOT = 0xA1C7;
const char32_t YI_SYLLABLE_LOX = 0xA1C8;
const char32_t YI_SYLLABLE_LO = 0xA1C9;
const char32_t YI_SYLLABLE_LOP = 0xA1CA;
const char32_t YI_SYLLABLE_LEX = 0xA1CB;
const char32_t YI_SYLLABLE_LE = 0xA1CC;
const char32_t YI_SYLLABLE_LEP = 0xA1CD;
const char32_t YI_SYLLABLE_LUT = 0xA1CE;
const char32_t YI_SYLLABLE_LUX = 0xA1CF;
const char32_t YI_SYLLABLE_LU = 0xA1D0;
const char32_t YI_SYLLABLE_LUP = 0xA1D1;
const char32_t YI_SYLLABLE_LURX = 0xA1D2;
const char32_t YI_SYLLABLE_LUR = 0xA1D3;
const char32_t YI_SYLLABLE_LYT = 0xA1D4;
const char32_t YI_SYLLABLE_LYX = 0xA1D5;
const char32_t YI_SYLLABLE_LY = 0xA1D6;
const char32_t YI_SYLLABLE_LYP = 0xA1D7;
const char32_t YI_SYLLABLE_LYRX = 0xA1D8;
const char32_t YI_SYLLABLE_LYR = 0xA1D9;
const char32_t YI_SYLLABLE_GIT = 0xA1DA;
const char32_t YI_SYLLABLE_GIX = 0xA1DB;
const char32_t YI_SYLLABLE_GI = 0xA1DC;
const char32_t YI_SYLLABLE_GIP = 0xA1DD;
const char32_t YI_SYLLABLE_GIET = 0xA1DE;
const char32_t YI_SYLLABLE_GIEX = 0xA1DF;
const char32_t YI_SYLLABLE_GIE = 0xA1E0;
const char32_t YI_SYLLABLE_GIEP = 0xA1E1;
const char32_t YI_SYLLABLE_GAT = 0xA1E2;
const char32_t YI_SYLLABLE_GAX = 0xA1E3;
const char32_t YI_SYLLABLE_GA = 0xA1E4;
const char32_t YI_SYLLABLE_GAP = 0xA1E5;
const char32_t YI_SYLLABLE_GUOT = 0xA1E6;
const char32_t YI_SYLLABLE_GUOX = 0xA1E7;
const char32_t YI_SYLLABLE_GUO = 0xA1E8;
const char32_t YI_SYLLABLE_GUOP = 0xA1E9;
const char32_t YI_SYLLABLE_GOT = 0xA1EA;
const char32_t YI_SYLLABLE_GOX = 0xA1EB;
const char32_t YI_SYLLABLE_GO = 0xA1EC;
const char32_t YI_SYLLABLE_GOP = 0xA1ED;
const char32_t YI_SYLLABLE_GET = 0xA1EE;
const char32_t YI_SYLLABLE_GEX = 0xA1EF;
const char32_t YI_SYLLABLE_GE = 0xA1F0;
const char32_t YI_SYLLABLE_GEP = 0xA1F1;
const char32_t YI_SYLLABLE_GUT = 0xA1F2;
const char32_t YI_SYLLABLE_GUX = 0xA1F3;
const char32_t YI_SYLLABLE_GU = 0xA1F4;
const char32_t YI_SYLLABLE_GUP = 0xA1F5;
const char32_t YI_SYLLABLE_GURX = 0xA1F6;
const char32_t YI_SYLLABLE_GUR = 0xA1F7;
const char32_t YI_SYLLABLE_KIT = 0xA1F8;
const char32_t YI_SYLLABLE_KIX = 0xA1F9;
const char32_t YI_SYLLABLE_KI = 0xA1FA;
const char32_t YI_SYLLABLE_KIP = 0xA1FB;
const char32_t YI_SYLLABLE_KIEX = 0xA1FC;
const char32_t YI_SYLLABLE_KIE = 0xA1FD;
const char32_t YI_SYLLABLE_KIEP = 0xA1FE;
const char32_t YI_SYLLABLE_KAT = 0xA1FF;
const char32_t YI_SYLLABLE_KAX = 0xA200;
const char32_t YI_SYLLABLE_KA = 0xA201;
const char32_t YI_SYLLABLE_KAP = 0xA202;
const char32_t YI_SYLLABLE_KUOX = 0xA203;
const char32_t YI_SYLLABLE_KUO = 0xA204;
const char32_t YI_SYLLABLE_KUOP = 0xA205;
const char32_t YI_SYLLABLE_KOT = 0xA206;
const char32_t YI_SYLLABLE_KOX = 0xA207;
const char32_t YI_SYLLABLE_KO = 0xA208;
const char32_t YI_SYLLABLE_KOP = 0xA209;
const char32_t YI_SYLLABLE_KET = 0xA20A;
const char32_t YI_SYLLABLE_KEX = 0xA20B;
const char32_t YI_SYLLABLE_KE = 0xA20C;
const char32_t YI_SYLLABLE_KEP = 0xA20D;
const char32_t YI_SYLLABLE_KUT = 0xA20E;
const char32_t YI_SYLLABLE_KUX = 0xA20F;
const char32_t YI_SYLLABLE_KU = 0xA210;
const char32_t YI_SYLLABLE_KUP = 0xA211;
const char32_t YI_SYLLABLE_KURX = 0xA212;
const char32_t YI_SYLLABLE_KUR = 0xA213;
const char32_t YI_SYLLABLE_GGIT = 0xA214;
const char32_t YI_SYLLABLE_GGIX = 0xA215;
const char32_t YI_SYLLABLE_GGI = 0xA216;
const char32_t YI_SYLLABLE_GGIEX = 0xA217;
const char32_t YI_SYLLABLE_GGIE = 0xA218;
const char32_t YI_SYLLABLE_GGIEP = 0xA219;
const char32_t YI_SYLLABLE_GGAT = 0xA21A;
const char32_t YI_SYLLABLE_GGAX = 0xA21B;
const char32_t YI_SYLLABLE_GGA = 0xA21C;
const char32_t YI_SYLLABLE_GGAP = 0xA21D;
const char32_t YI_SYLLABLE_GGUOT = 0xA21E;
const char32_t YI_SYLLABLE_GGUOX = 0xA21F;
const char32_t YI_SYLLABLE_GGUO = 0xA220;
const char32_t YI_SYLLABLE_GGUOP = 0xA221;
const char32_t YI_SYLLABLE_GGOT = 0xA222;
const char32_t YI_SYLLABLE_GGOX = 0xA223;
const char32_t YI_SYLLABLE_GGO = 0xA224;
const char32_t YI_SYLLABLE_GGOP = 0xA225;
const char32_t YI_SYLLABLE_GGET = 0xA226;
const char32_t YI_SYLLABLE_GGEX = 0xA227;
const char32_t YI_SYLLABLE_GGE = 0xA228;
const char32_t YI_SYLLABLE_GGEP = 0xA229;
const char32_t YI_SYLLABLE_GGUT = 0xA22A;
const char32_t YI_SYLLABLE_GGUX = 0xA22B;
const char32_t YI_SYLLABLE_GGU = 0xA22C;
const char32_t YI_SYLLABLE_GGUP = 0xA22D;
const char32_t YI_SYLLABLE_GGURX = 0xA22E;
const char32_t YI_SYLLABLE_GGUR = 0xA22F;
const char32_t YI_SYLLABLE_MGIEX = 0xA230;
const char32_t YI_SYLLABLE_MGIE = 0xA231;
const char32_t YI_SYLLABLE_MGAT = 0xA232;
const char32_t YI_SYLLABLE_MGAX = 0xA233;
const char32_t YI_SYLLABLE_MGA = 0xA234;
const char32_t YI_SYLLABLE_MGAP = 0xA235;
const char32_t YI_SYLLABLE_MGUOX = 0xA236;
const char32_t YI_SYLLABLE_MGUO = 0xA237;
const char32_t YI_SYLLABLE_MGUOP = 0xA238;
const char32_t YI_SYLLABLE_MGOT = 0xA239;
const char32_t YI_SYLLABLE_MGOX = 0xA23A;
const char32_t YI_SYLLABLE_MGO = 0xA23B;
const char32_t YI_SYLLABLE_MGOP = 0xA23C;
const char32_t YI_SYLLABLE_MGEX = 0xA23D;
const char32_t YI_SYLLABLE_MGE = 0xA23E;
const char32_t YI_SYLLABLE_MGEP = 0xA23F;
const char32_t YI_SYLLABLE_MGUT = 0xA240;
const char32_t YI_SYLLABLE_MGUX = 0xA241;
const char32_t YI_SYLLABLE_MGU = 0xA242;
const char32_t YI_SYLLABLE_MGUP = 0xA243;
const char32_t YI_SYLLABLE_MGURX = 0xA244;
const char32_t YI_SYLLABLE_MGUR = 0xA245;
const char32_t YI_SYLLABLE_HXIT = 0xA246;
const char32_t YI_SYLLABLE_HXIX = 0xA247;
const char32_t YI_SYLLABLE_HXI = 0xA248;
const char32_t YI_SYLLABLE_HXIP = 0xA249;
const char32_t YI_SYLLABLE_HXIET = 0xA24A;
const char32_t YI_SYLLABLE_HXIEX = 0xA24B;
const char32_t YI_SYLLABLE_HXIE = 0xA24C;
const char32_t YI_SYLLABLE_HXIEP = 0xA24D;
const char32_t YI_SYLLABLE_HXAT = 0xA24E;
const char32_t YI_SYLLABLE_HXAX = 0xA24F;
const char32_t YI_SYLLABLE_HXA = 0xA250;
const char32_t YI_SYLLABLE_HXAP = 0xA251;
const char32_t YI_SYLLABLE_HXUOT = 0xA252;
const char32_t YI_SYLLABLE_HXUOX = 0xA253;
const char32_t YI_SYLLABLE_HXUO = 0xA254;
const char32_t YI_SYLLABLE_HXUOP = 0xA255;
const char32_t YI_SYLLABLE_HXOT = 0xA256;
const char32_t YI_SYLLABLE_HXOX = 0xA257;
const char32_t YI_SYLLABLE_HXO = 0xA258;
const char32_t YI_SYLLABLE_HXOP = 0xA259;
const char32_t YI_SYLLABLE_HXEX = 0xA25A;
const char32_t YI_SYLLABLE_HXE = 0xA25B;
const char32_t YI_SYLLABLE_HXEP = 0xA25C;
const char32_t YI_SYLLABLE_NGIEX = 0xA25D;
const char32_t YI_SYLLABLE_NGIE = 0xA25E;
const char32_t YI_SYLLABLE_NGIEP = 0xA25F;
const char32_t YI_SYLLABLE_NGAT = 0xA260;
const char32_t YI_SYLLABLE_NGAX = 0xA261;
const char32_t YI_SYLLABLE_NGA = 0xA262;
const char32_t YI_SYLLABLE_NGAP = 0xA263;
const char32_t YI_SYLLABLE_NGUOT = 0xA264;
const char32_t YI_SYLLABLE_NGUOX = 0xA265;
const char32_t YI_SYLLABLE_NGUO = 0xA266;
const char32_t YI_SYLLABLE_NGOT = 0xA267;
const char32_t YI_SYLLABLE_NGOX = 0xA268;
const char32_t YI_SYLLABLE_NGO = 0xA269;
const char32_t YI_SYLLABLE_NGOP = 0xA26A;
const char32_t YI_SYLLABLE_NGEX = 0xA26B;
const char32_t YI_SYLLABLE_NGE = 0xA26C;
const char32_t YI_SYLLABLE_NGEP = 0xA26D;
const char32_t YI_SYLLABLE_HIT = 0xA26E;
const char32_t YI_SYLLABLE_HIEX = 0xA26F;
const char32_t YI_SYLLABLE_HIE = 0xA270;
const char32_t YI_SYLLABLE_HAT = 0xA271;
const char32_t YI_SYLLABLE_HAX = 0xA272;
const char32_t YI_SYLLABLE_HA = 0xA273;
const char32_t YI_SYLLABLE_HAP = 0xA274;
const char32_t YI_SYLLABLE_HUOT = 0xA275;
const char32_t YI_SYLLABLE_HUOX = 0xA276;
const char32_t YI_SYLLABLE_HUO = 0xA277;
const char32_t YI_SYLLABLE_HUOP = 0xA278;
const char32_t YI_SYLLABLE_HOT = 0xA279;
const char32_t YI_SYLLABLE_HOX = 0xA27A;
const char32_t YI_SYLLABLE_HO = 0xA27B;
const char32_t YI_SYLLABLE_HOP = 0xA27C;
const char32_t YI_SYLLABLE_HEX = 0xA27D;
const char32_t YI_SYLLABLE_HE = 0xA27E;
const char32_t YI_SYLLABLE_HEP = 0xA27F;
const char32_t YI_SYLLABLE_WAT = 0xA280;
const char32_t YI_SYLLABLE_WAX = 0xA281;
const char32_t YI_SYLLABLE_WA = 0xA282;
const char32_t YI_SYLLABLE_WAP = 0xA283;
const char32_t YI_SYLLABLE_WUOX = 0xA284;
const char32_t YI_SYLLABLE_WUO = 0xA285;
const char32_t YI_SYLLABLE_WUOP = 0xA286;
const char32_t YI_SYLLABLE_WOX = 0xA287;
const char32_t YI_SYLLABLE_WO = 0xA288;
const char32_t YI_SYLLABLE_WOP = 0xA289;
const char32_t YI_SYLLABLE_WEX = 0xA28A;
const char32_t YI_SYLLABLE_WE = 0xA28B;
const char32_t YI_SYLLABLE_WEP = 0xA28C;
const char32_t YI_SYLLABLE_ZIT = 0xA28D;
const char32_t YI_SYLLABLE_ZIX = 0xA28E;
const char32_t YI_SYLLABLE_ZI = 0xA28F;
const char32_t YI_SYLLABLE_ZIP = 0xA290;
const char32_t YI_SYLLABLE_ZIEX = 0xA291;
const char32_t YI_SYLLABLE_ZIE = 0xA292;
const char32_t YI_SYLLABLE_ZIEP = 0xA293;
const char32_t YI_SYLLABLE_ZAT = 0xA294;
const char32_t YI_SYLLABLE_ZAX = 0xA295;
const char32_t YI_SYLLABLE_ZA = 0xA296;
const char32_t YI_SYLLABLE_ZAP = 0xA297;
const char32_t YI_SYLLABLE_ZUOX = 0xA298;
const char32_t YI_SYLLABLE_ZUO = 0xA299;
const char32_t YI_SYLLABLE_ZUOP = 0xA29A;
const char32_t YI_SYLLABLE_ZOT = 0xA29B;
const char32_t YI_SYLLABLE_ZOX = 0xA29C;
const char32_t YI_SYLLABLE_ZO = 0xA29D;
const char32_t YI_SYLLABLE_ZOP = 0xA29E;
const char32_t YI_SYLLABLE_ZEX = 0xA29F;
const char32_t YI_SYLLABLE_ZE = 0xA2A0;
const char32_t YI_SYLLABLE_ZEP = 0xA2A1;
const char32_t YI_SYLLABLE_ZUT = 0xA2A2;
const char32_t YI_SYLLABLE_ZUX = 0xA2A3;
const char32_t YI_SYLLABLE_ZU = 0xA2A4;
const char32_t YI_SYLLABLE_ZUP = 0xA2A5;
const char32_t YI_SYLLABLE_ZURX = 0xA2A6;
const char32_t YI_SYLLABLE_ZUR = 0xA2A7;
const char32_t YI_SYLLABLE_ZYT = 0xA2A8;
const char32_t YI_SYLLABLE_ZYX = 0xA2A9;
const char32_t YI_SYLLABLE_ZY = 0xA2AA;
const char32_t YI_SYLLABLE_ZYP = 0xA2AB;
const char32_t YI_SYLLABLE_ZYRX = 0xA2AC;
const char32_t YI_SYLLABLE_ZYR = 0xA2AD;
const char32_t YI_SYLLABLE_CIT = 0xA2AE;
const char32_t YI_SYLLABLE_CIX = 0xA2AF;
const char32_t YI_SYLLABLE_CI = 0xA2B0;
const char32_t YI_SYLLABLE_CIP = 0xA2B1;
const char32_t YI_SYLLABLE_CIET = 0xA2B2;
const char32_t YI_SYLLABLE_CIEX = 0xA2B3;
const char32_t YI_SYLLABLE_CIE = 0xA2B4;
const char32_t YI_SYLLABLE_CIEP = 0xA2B5;
const char32_t YI_SYLLABLE_CAT = 0xA2B6;
const char32_t YI_SYLLABLE_CAX = 0xA2B7;
const char32_t YI_SYLLABLE_CA = 0xA2B8;
const char32_t YI_SYLLABLE_CAP = 0xA2B9;
const char32_t YI_SYLLABLE_CUOX = 0xA2BA;
const char32_t YI_SYLLABLE_CUO = 0xA2BB;
const char32_t YI_SYLLABLE_CUOP = 0xA2BC;
const char32_t YI_SYLLABLE_COT = 0xA2BD;
const char32_t YI_SYLLABLE_COX = 0xA2BE;
const char32_t YI_SYLLABLE_CO = 0xA2BF;
const char32_t YI_SYLLABLE_COP = 0xA2C0;
const char32_t YI_SYLLABLE_CEX = 0xA2C1;
const char32_t YI_SYLLABLE_CE = 0xA2C2;
const char32_t YI_SYLLABLE_CEP = 0xA2C3;
const char32_t YI_SYLLABLE_CUT = 0xA2C4;
const char32_t YI_SYLLABLE_CUX = 0xA2C5;
const char32_t YI_SYLLABLE_CU = 0xA2C6;
const char32_t YI_SYLLABLE_CUP = 0xA2C7;
const char32_t YI_SYLLABLE_CURX = 0xA2C8;
const char32_t YI_SYLLABLE_CUR = 0xA2C9;
const char32_t YI_SYLLABLE_CYT = 0xA2CA;
const char32_t YI_SYLLABLE_CYX = 0xA2CB;
const char32_t YI_SYLLABLE_CY = 0xA2CC;
const char32_t YI_SYLLABLE_CYP = 0xA2CD;
const char32_t YI_SYLLABLE_CYRX = 0xA2CE;
const char32_t YI_SYLLABLE_CYR = 0xA2CF;
const char32_t YI_SYLLABLE_ZZIT = 0xA2D0;
const char32_t YI_SYLLABLE_ZZIX = 0xA2D1;
const char32_t YI_SYLLABLE_ZZI = 0xA2D2;
const char32_t YI_SYLLABLE_ZZIP = 0xA2D3;
const char32_t YI_SYLLABLE_ZZIET = 0xA2D4;
const char32_t YI_SYLLABLE_ZZIEX = 0xA2D5;
const char32_t YI_SYLLABLE_ZZIE = 0xA2D6;
const char32_t YI_SYLLABLE_ZZIEP = 0xA2D7;
const char32_t YI_SYLLABLE_ZZAT = 0xA2D8;
const char32_t YI_SYLLABLE_ZZAX = 0xA2D9;
const char32_t YI_SYLLABLE_ZZA = 0xA2DA;
const char32_t YI_SYLLABLE_ZZAP = 0xA2DB;
const char32_t YI_SYLLABLE_ZZOX = 0xA2DC;
const char32_t YI_SYLLABLE_ZZO = 0xA2DD;
const char32_t YI_SYLLABLE_ZZOP = 0xA2DE;
const char32_t YI_SYLLABLE_ZZEX = 0xA2DF;
const char32_t YI_SYLLABLE_ZZE = 0xA2E0;
const char32_t YI_SYLLABLE_ZZEP = 0xA2E1;
const char32_t YI_SYLLABLE_ZZUX = 0xA2E2;
const char32_t YI_SYLLABLE_ZZU = 0xA2E3;
const char32_t YI_SYLLABLE_ZZUP = 0xA2E4;
const char32_t YI_SYLLABLE_ZZURX = 0xA2E5;
const char32_t YI_SYLLABLE_ZZUR = 0xA2E6;
const char32_t YI_SYLLABLE_ZZYT = 0xA2E7;
const char32_t YI_SYLLABLE_ZZYX = 0xA2E8;
const char32_t YI_SYLLABLE_ZZY = 0xA2E9;
const char32_t YI_SYLLABLE_ZZYP = 0xA2EA;
const char32_t YI_SYLLABLE_ZZYRX = 0xA2EB;
const char32_t YI_SYLLABLE_ZZYR = 0xA2EC;
const char32_t YI_SYLLABLE_NZIT = 0xA2ED;
const char32_t YI_SYLLABLE_NZIX = 0xA2EE;
const char32_t YI_SYLLABLE_NZI = 0xA2EF;
const char32_t YI_SYLLABLE_NZIP = 0xA2F0;
const char32_t YI_SYLLABLE_NZIEX = 0xA2F1;
const char32_t YI_SYLLABLE_NZIE = 0xA2F2;
const char32_t YI_SYLLABLE_NZIEP = 0xA2F3;
const char32_t YI_SYLLABLE_NZAT = 0xA2F4;
const char32_t YI_SYLLABLE_NZAX = 0xA2F5;
const char32_t YI_SYLLABLE_NZA = 0xA2F6;
const char32_t YI_SYLLABLE_NZAP = 0xA2F7;
const char32_t YI_SYLLABLE_NZUOX = 0xA2F8;
const char32_t YI_SYLLABLE_NZUO = 0xA2F9;
const char32_t YI_SYLLABLE_NZOX = 0xA2FA;
const char32_t YI_SYLLABLE_NZOP = 0xA2FB;
const char32_t YI_SYLLABLE_NZEX = 0xA2FC;
const char32_t YI_SYLLABLE_NZE = 0xA2FD;
const char32_t YI_SYLLABLE_NZUX = 0xA2FE;
const char32_t YI_SYLLABLE_NZU = 0xA2FF;
const char32_t YI_SYLLABLE_NZUP = 0xA300;
const char32_t YI_SYLLABLE_NZURX = 0xA301;
const char32_t YI_SYLLABLE_NZUR = 0xA302;
const char32_t YI_SYLLABLE_NZYT = 0xA303;
const char32_t YI_SYLLABLE_NZYX = 0xA304;
const char32_t YI_SYLLABLE_NZY = 0xA305;
const char32_t YI_SYLLABLE_NZYP = 0xA306;
const char32_t YI_SYLLABLE_NZYRX = 0xA307;
const char32_t YI_SYLLABLE_NZYR = 0xA308;
const char32_t YI_SYLLABLE_SIT = 0xA309;
const char32_t YI_SYLLABLE_SIX = 0xA30A;
const char32_t YI_SYLLABLE_SI = 0xA30B;
const char32_t YI_SYLLABLE_SIP = 0xA30C;
const char32_t YI_SYLLABLE_SIEX = 0xA30D;
const char32_t YI_SYLLABLE_SIE = 0xA30E;
const char32_t YI_SYLLABLE_SIEP = 0xA30F;
const char32_t YI_SYLLABLE_SAT = 0xA310;
const char32_t YI_SYLLABLE_SAX = 0xA311;
const char32_t YI_SYLLABLE_SA = 0xA312;
const char32_t YI_SYLLABLE_SAP = 0xA313;
const char32_t YI_SYLLABLE_SUOX = 0xA314;
const char32_t YI_SYLLABLE_SUO = 0xA315;
const char32_t YI_SYLLABLE_SUOP = 0xA316;
const char32_t YI_SYLLABLE_SOT = 0xA317;
const char32_t YI_SYLLABLE_SOX = 0xA318;
const char32_t YI_SYLLABLE_SO = 0xA319;
const char32_t YI_SYLLABLE_SOP = 0xA31A;
const char32_t YI_SYLLABLE_SEX = 0xA31B;
const char32_t YI_SYLLABLE_SE = 0xA31C;
const char32_t YI_SYLLABLE_SEP = 0xA31D;
const char32_t YI_SYLLABLE_SUT = 0xA31E;
const char32_t YI_SYLLABLE_SUX = 0xA31F;
const char32_t YI_SYLLABLE_SU = 0xA320;
const char32_t YI_SYLLABLE_SUP = 0xA321;
const char32_t YI_SYLLABLE_SURX = 0xA322;
const char32_t YI_SYLLABLE_SUR = 0xA323;
const char32_t YI_SYLLABLE_SYT = 0xA324;
const char32_t YI_SYLLABLE_SYX = 0xA325;
const char32_t YI_SYLLABLE_SY = 0xA326;
const char32_t YI_SYLLABLE_SYP = 0xA327;
const char32_t YI_SYLLABLE_SYRX = 0xA328;
const char32_t YI_SYLLABLE_SYR = 0xA329;
const char32_t YI_SYLLABLE_SSIT = 0xA32A;
const char32_t YI_SYLLABLE_SSIX = 0xA32B;
const char32_t YI_SYLLABLE_SSI = 0xA32C;
const char32_t YI_SYLLABLE_SSIP = 0xA32D;
const char32_t YI_SYLLABLE_SSIEX = 0xA32E;
const char32_t YI_SYLLABLE_SSIE = 0xA32F;
const char32_t YI_SYLLABLE_SSIEP = 0xA330;
const char32_t YI_SYLLABLE_SSAT = 0xA331;
const char32_t YI_SYLLABLE_SSAX = 0xA332;
const char32_t YI_SYLLABLE_SSA = 0xA333;
const char32_t YI_SYLLABLE_SSAP = 0xA334;
const char32_t YI_SYLLABLE_SSOT = 0xA335;
const char32_t YI_SYLLABLE_SSOX = 0xA336;
const char32_t YI_SYLLABLE_SSO = 0xA337;
const char32_t YI_SYLLABLE_SSOP = 0xA338;
const char32_t YI_SYLLABLE_SSEX = 0xA339;
const char32_t YI_SYLLABLE_SSE = 0xA33A;
const char32_t YI_SYLLABLE_SSEP = 0xA33B;
const char32_t YI_SYLLABLE_SSUT = 0xA33C;
const char32_t YI_SYLLABLE_SSUX = 0xA33D;
const char32_t YI_SYLLABLE_SSU = 0xA33E;
const char32_t YI_SYLLABLE_SSUP = 0xA33F;
const char32_t YI_SYLLABLE_SSYT = 0xA340;
const char32_t YI_SYLLABLE_SSYX = 0xA341;
const char32_t YI_SYLLABLE_SSY = 0xA342;
const char32_t YI_SYLLABLE_SSYP = 0xA343;
const char32_t YI_SYLLABLE_SSYRX = 0xA344;
const char32_t YI_SYLLABLE_SSYR = 0xA345;
const char32_t YI_SYLLABLE_ZHAT = 0xA346;
const char32_t YI_SYLLABLE_ZHAX = 0xA347;
const char32_t YI_SYLLABLE_ZHA = 0xA348;
const char32_t YI_SYLLABLE_ZHAP = 0xA349;
const char32_t YI_SYLLABLE_ZHUOX = 0xA34A;
const char32_t YI_SYLLABLE_ZHUO = 0xA34B;
const char32_t YI_SYLLABLE_ZHUOP = 0xA34C;
const char32_t YI_SYLLABLE_ZHOT = 0xA34D;
const char32_t YI_SYLLABLE_ZHOX = 0xA34E;
const char32_t YI_SYLLABLE_ZHO = 0xA34F;
const char32_t YI_SYLLABLE_ZHOP = 0xA350;
const char32_t YI_SYLLABLE_ZHET = 0xA351;
const char32_t YI_SYLLABLE_ZHEX = 0xA352;
const char32_t YI_SYLLABLE_ZHE = 0xA353;
const char32_t YI_SYLLABLE_ZHEP = 0xA354;
const char32_t YI_SYLLABLE_ZHUT = 0xA355;
const char32_t YI_SYLLABLE_ZHUX = 0xA356;
const char32_t YI_SYLLABLE_ZHU = 0xA357;
const char32_t YI_SYLLABLE_ZHUP = 0xA358;
const char32_t YI_SYLLABLE_ZHURX = 0xA359;
const char32_t YI_SYLLABLE_ZHUR = 0xA35A;
const char32_t YI_SYLLABLE_ZHYT = 0xA35B;
const char32_t YI_SYLLABLE_ZHYX = 0xA35C;
const char32_t YI_SYLLABLE_ZHY = 0xA35D;
const char32_t YI_SYLLABLE_ZHYP = 0xA35E;
const char32_t YI_SYLLABLE_ZHYRX = 0xA35F;
const char32_t YI_SYLLABLE_ZHYR = 0xA360;
const char32_t YI_SYLLABLE_CHAT = 0xA361;
const char32_t YI_SYLLABLE_CHAX = 0xA362;
const char32_t YI_SYLLABLE_CHA = 0xA363;
const char32_t YI_SYLLABLE_CHAP = 0xA364;
const char32_t YI_SYLLABLE_CHUOT = 0xA365;
const char32_t YI_SYLLABLE_CHUOX = 0xA366;
const char32_t YI_SYLLABLE_CHUO = 0xA367;
const char32_t YI_SYLLABLE_CHUOP = 0xA368;
const char32_t YI_SYLLABLE_CHOT = 0xA369;
const char32_t YI_SYLLABLE_CHOX = 0xA36A;
const char32_t YI_SYLLABLE_CHO = 0xA36B;
const char32_t YI_SYLLABLE_CHOP = 0xA36C;
const char32_t YI_SYLLABLE_CHET = 0xA36D;
const char32_t YI_SYLLABLE_CHEX = 0xA36E;
const char32_t YI_SYLLABLE_CHE = 0xA36F;
const char32_t YI_SYLLABLE_CHEP = 0xA370;
const char32_t YI_SYLLABLE_CHUX = 0xA371;
const char32_t YI_SYLLABLE_CHU = 0xA372;
const char32_t YI_SYLLABLE_CHUP = 0xA373;
const char32_t YI_SYLLABLE_CHURX = 0xA374;
const char32_t YI_SYLLABLE_CHUR = 0xA375;
const char32_t YI_SYLLABLE_CHYT = 0xA376;
const char32_t YI_SYLLABLE_CHYX = 0xA377;
const char32_t YI_SYLLABLE_CHY = 0xA378;
const char32_t YI_SYLLABLE_CHYP = 0xA379;
const char32_t YI_SYLLABLE_CHYRX = 0xA37A;
const char32_t YI_SYLLABLE_CHYR = 0xA37B;
const char32_t YI_SYLLABLE_RRAX = 0xA37C;
const char32_t YI_SYLLABLE_RRA = 0xA37D;
const char32_t YI_SYLLABLE_RRUOX = 0xA37E;
const char32_t YI_SYLLABLE_RRUO = 0xA37F;
const char32_t YI_SYLLABLE_RROT = 0xA380;
const char32_t YI_SYLLABLE_RROX = 0xA381;
const char32_t YI_SYLLABLE_RRO = 0xA382;
const char32_t YI_SYLLABLE_RROP = 0xA383;
const char32_t YI_SYLLABLE_RRET = 0xA384;
const char32_t YI_SYLLABLE_RREX = 0xA385;
const char32_t YI_SYLLABLE_RRE = 0xA386;
const char32_t YI_SYLLABLE_RREP = 0xA387;
const char32_t YI_SYLLABLE_RRUT = 0xA388;
const char32_t YI_SYLLABLE_RRUX = 0xA389;
const char32_t YI_SYLLABLE_RRU = 0xA38A;
const char32_t YI_SYLLABLE_RRUP = 0xA38B;
const char32_t YI_SYLLABLE_RRURX = 0xA38C;
const char32_t YI_SYLLABLE_RRUR = 0xA38D;
const char32_t YI_SYLLABLE_RRYT = 0xA38E;
const char32_t YI_SYLLABLE_RRYX = 0xA38F;
const char32_t YI_SYLLABLE_RRY = 0xA390;
const char32_t YI_SYLLABLE_RRYP = 0xA391;
const char32_t YI_SYLLABLE_RRYRX = 0xA392;
const char32_t YI_SYLLABLE_RRYR = 0xA393;
const char32_t YI_SYLLABLE_NRAT = 0xA394;
const char32_t YI_SYLLABLE_NRAX = 0xA395;
const char32_t YI_SYLLABLE_NRA = 0xA396;
const char32_t YI_SYLLABLE_NRAP = 0xA397;
const char32_t YI_SYLLABLE_NROX = 0xA398;
const char32_t YI_SYLLABLE_NRO = 0xA399;
const char32_t YI_SYLLABLE_NROP = 0xA39A;
const char32_t YI_SYLLABLE_NRET = 0xA39B;
const char32_t YI_SYLLABLE_NREX = 0xA39C;
const char32_t YI_SYLLABLE_NRE = 0xA39D;
const char32_t YI_SYLLABLE_NREP = 0xA39E;
const char32_t YI_SYLLABLE_NRUT = 0xA39F;
const char32_t YI_SYLLABLE_NRUX = 0xA3A0;
const char32_t YI_SYLLABLE_NRU = 0xA3A1;
const char32_t YI_SYLLABLE_NRUP = 0xA3A2;
const char32_t YI_SYLLABLE_NRURX = 0xA3A3;
const char32_t YI_SYLLABLE_NRUR = 0xA3A4;
const char32_t YI_SYLLABLE_NRYT = 0xA3A5;
const char32_t YI_SYLLABLE_NRYX = 0xA3A6;
const char32_t YI_SYLLABLE_NRY = 0xA3A7;
const char32_t YI_SYLLABLE_NRYP = 0xA3A8;
const char32_t YI_SYLLABLE_NRYRX = 0xA3A9;
const char32_t YI_SYLLABLE_NRYR = 0xA3AA;
const char32_t YI_SYLLABLE_SHAT = 0xA3AB;
const char32_t YI_SYLLABLE_SHAX = 0xA3AC;
const char32_t YI_SYLLABLE_SHA = 0xA3AD;
const char32_t YI_SYLLABLE_SHAP = 0xA3AE;
const char32_t YI_SYLLABLE_SHUOX = 0xA3AF;
const char32_t YI_SYLLABLE_SHUO = 0xA3B0;
const char32_t YI_SYLLABLE_SHUOP = 0xA3B1;
const char32_t YI_SYLLABLE_SHOT = 0xA3B2;
const char32_t YI_SYLLABLE_SHOX = 0xA3B3;
const char32_t YI_SYLLABLE_SHO = 0xA3B4;
const char32_t YI_SYLLABLE_SHOP = 0xA3B5;
const char32_t YI_SYLLABLE_SHET = 0xA3B6;
const char32_t YI_SYLLABLE_SHEX = 0xA3B7;
const char32_t YI_SYLLABLE_SHE = 0xA3B8;
const char32_t YI_SYLLABLE_SHEP = 0xA3B9;
const char32_t YI_SYLLABLE_SHUT = 0xA3BA;
const char32_t YI_SYLLABLE_SHUX = 0xA3BB;
const char32_t YI_SYLLABLE_SHU = 0xA3BC;
const char32_t YI_SYLLABLE_SHUP = 0xA3BD;
const char32_t YI_SYLLABLE_SHURX = 0xA3BE;
const char32_t YI_SYLLABLE_SHUR = 0xA3BF;
const char32_t YI_SYLLABLE_SHYT = 0xA3C0;
const char32_t YI_SYLLABLE_SHYX = 0xA3C1;
const char32_t YI_SYLLABLE_SHY = 0xA3C2;
const char32_t YI_SYLLABLE_SHYP = 0xA3C3;
const char32_t YI_SYLLABLE_SHYRX = 0xA3C4;
const char32_t YI_SYLLABLE_SHYR = 0xA3C5;
const char32_t YI_SYLLABLE_RAT = 0xA3C6;
const char32_t YI_SYLLABLE_RAX = 0xA3C7;
const char32_t YI_SYLLABLE_RA = 0xA3C8;
const char32_t YI_SYLLABLE_RAP = 0xA3C9;
const char32_t YI_SYLLABLE_RUOX = 0xA3CA;
const char32_t YI_SYLLABLE_RUO = 0xA3CB;
const char32_t YI_SYLLABLE_RUOP = 0xA3CC;
const char32_t YI_SYLLABLE_ROT = 0xA3CD;
const char32_t YI_SYLLABLE_ROX = 0xA3CE;
const char32_t YI_SYLLABLE_RO = 0xA3CF;
const char32_t YI_SYLLABLE_ROP = 0xA3D0;
const char32_t YI_SYLLABLE_REX = 0xA3D1;
const char32_t YI_SYLLABLE_RE = 0xA3D2;
const char32_t YI_SYLLABLE_REP = 0xA3D3;
const char32_t YI_SYLLABLE_RUT = 0xA3D4;
const char32_t YI_SYLLABLE_RUX = 0xA3D5;
const char32_t YI_SYLLABLE_RU = 0xA3D6;
const char32_t YI_SYLLABLE_RUP = 0xA3D7;
const char32_t YI_SYLLABLE_RURX = 0xA3D8;
const char32_t YI_SYLLABLE_RUR = 0xA3D9;
const char32_t YI_SYLLABLE_RYT = 0xA3DA;
const char32_t YI_SYLLABLE_RYX = 0xA3DB;
const char32_t YI_SYLLABLE_RY = 0xA3DC;
const char32_t YI_SYLLABLE_RYP = 0xA3DD;
const char32_t YI_SYLLABLE_RYRX = 0xA3DE;
const char32_t YI_SYLLABLE_RYR = 0xA3DF;
const char32_t YI_SYLLABLE_JIT = 0xA3E0;
const char32_t YI_SYLLABLE_JIX = 0xA3E1;
const char32_t YI_SYLLABLE_JI = 0xA3E2;
const char32_t YI_SYLLABLE_JIP = 0xA3E3;
const char32_t YI_SYLLABLE_JIET = 0xA3E4;
const char32_t YI_SYLLABLE_JIEX = 0xA3E5;
const char32_t YI_SYLLABLE_JIE = 0xA3E6;
const char32_t YI_SYLLABLE_JIEP = 0xA3E7;
const char32_t YI_SYLLABLE_JUOT = 0xA3E8;
const char32_t YI_SYLLABLE_JUOX = 0xA3E9;
const char32_t YI_SYLLABLE_JUO = 0xA3EA;
const char32_t YI_SYLLABLE_JUOP = 0xA3EB;
const char32_t YI_SYLLABLE_JOT = 0xA3EC;
const char32_t YI_SYLLABLE_JOX = 0xA3ED;
const char32_t YI_SYLLABLE_JO = 0xA3EE;
const char32_t YI_SYLLABLE_JOP = 0xA3EF;
const char32_t YI_SYLLABLE_JUT = 0xA3F0;
const char32_t YI_SYLLABLE_JUX = 0xA3F1;
const char32_t YI_SYLLABLE_JU = 0xA3F2;
const char32_t YI_SYLLABLE_JUP = 0xA3F3;
const char32_t YI_SYLLABLE_JURX = 0xA3F4;
const char32_t YI_SYLLABLE_JUR = 0xA3F5;
const char32_t YI_SYLLABLE_JYT = 0xA3F6;
const char32_t YI_SYLLABLE_JYX = 0xA3F7;
const char32_t YI_SYLLABLE_JY = 0xA3F8;
const char32_t YI_SYLLABLE_JYP = 0xA3F9;
const char32_t YI_SYLLABLE_JYRX = 0xA3FA;
const char32_t YI_SYLLABLE_JYR = 0xA3FB;
const char32_t YI_SYLLABLE_QIT = 0xA3FC;
const char32_t YI_SYLLABLE_QIX = 0xA3FD;
const char32_t YI_SYLLABLE_QI = 0xA3FE;
const char32_t YI_SYLLABLE_QIP = 0xA3FF;
const char32_t YI_SYLLABLE_QIET = 0xA400;
const char32_t YI_SYLLABLE_QIEX = 0xA401;
const char32_t YI_SYLLABLE_QIE = 0xA402;
const char32_t YI_SYLLABLE_QIEP = 0xA403;
const char32_t YI_SYLLABLE_QUOT = 0xA404;
const char32_t YI_SYLLABLE_QUOX = 0xA405;
const char32_t YI_SYLLABLE_QUO = 0xA406;
const char32_t YI_SYLLABLE_QUOP = 0xA407;
const char32_t YI_SYLLABLE_QOT = 0xA408;
const char32_t YI_SYLLABLE_QOX = 0xA409;
const char32_t YI_SYLLABLE_QO = 0xA40A;
const char32_t YI_SYLLABLE_QOP = 0xA40B;
const char32_t YI_SYLLABLE_QUT = 0xA40C;
const char32_t YI_SYLLABLE_QUX = 0xA40D;
const char32_t YI_SYLLABLE_QU = 0xA40E;
const char32_t YI_SYLLABLE_QUP = 0xA40F;
const char32_t YI_SYLLABLE_QURX = 0xA410;
const char32_t YI_SYLLABLE_QUR = 0xA411;
const char32_t YI_SYLLABLE_QYT = 0xA412;
const char32_t YI_SYLLABLE_QYX = 0xA413;
const char32_t YI_SYLLABLE_QY = 0xA414;
const char32_t YI_SYLLABLE_QYP = 0xA415;
const char32_t YI_SYLLABLE_QYRX = 0xA416;
const char32_t YI_SYLLABLE_QYR = 0xA417;
const char32_t YI_SYLLABLE_JJIT = 0xA418;
const char32_t YI_SYLLABLE_JJIX = 0xA419;
const char32_t YI_SYLLABLE_JJI = 0xA41A;
const char32_t YI_SYLLABLE_JJIP = 0xA41B;
const char32_t YI_SYLLABLE_JJIET = 0xA41C;
const char32_t YI_SYLLABLE_JJIEX = 0xA41D;
const char32_t YI_SYLLABLE_JJIE = 0xA41E;
const char32_t YI_SYLLABLE_JJIEP = 0xA41F;
const char32_t YI_SYLLABLE_JJUOX = 0xA420;
const char32_t YI_SYLLABLE_JJUO = 0xA421;
const char32_t YI_SYLLABLE_JJUOP = 0xA422;
const char32_t YI_SYLLABLE_JJOT = 0xA423;
const char32_t YI_SYLLABLE_JJOX = 0xA424;
const char32_t YI_SYLLABLE_JJO = 0xA425;
const char32_t YI_SYLLABLE_JJOP = 0xA426;
const char32_t YI_SYLLABLE_JJUT = 0xA427;
const char32_t YI_SYLLABLE_JJUX = 0xA428;
const char32_t YI_SYLLABLE_JJU = 0xA429;
const char32_t YI_SYLLABLE_JJUP = 0xA42A;
const char32_t YI_SYLLABLE_JJURX = 0xA42B;
const char32_t YI_SYLLABLE_JJUR = 0xA42C;
const char32_t YI_SYLLABLE_JJYT = 0xA42D;
const char32_t YI_SYLLABLE_JJYX = 0xA42E;
const char32_t YI_SYLLABLE_JJY = 0xA42F;
const char32_t YI_SYLLABLE_JJYP = 0xA430;
const char32_t YI_SYLLABLE_NJIT = 0xA431;
const char32_t YI_SYLLABLE_NJIX = 0xA432;
const char32_t YI_SYLLABLE_NJI = 0xA433;
const char32_t YI_SYLLABLE_NJIP = 0xA434;
const char32_t YI_SYLLABLE_NJIET = 0xA435;
const char32_t YI_SYLLABLE_NJIEX = 0xA436;
const char32_t YI_SYLLABLE_NJIE = 0xA437;
const char32_t YI_SYLLABLE_NJIEP = 0xA438;
const char32_t YI_SYLLABLE_NJUOX = 0xA439;
const char32_t YI_SYLLABLE_NJUO = 0xA43A;
const char32_t YI_SYLLABLE_NJOT = 0xA43B;
const char32_t YI_SYLLABLE_NJOX = 0xA43C;
const char32_t YI_SYLLABLE_NJO = 0xA43D;
const char32_t YI_SYLLABLE_NJOP = 0xA43E;
const char32_t YI_SYLLABLE_NJUX = 0xA43F;
const char32_t YI_SYLLABLE_NJU = 0xA440;
const char32_t YI_SYLLABLE_NJUP = 0xA441;
const char32_t YI_SYLLABLE_NJURX = 0xA442;
const char32_t YI_SYLLABLE_NJUR = 0xA443;
const char32_t YI_SYLLABLE_NJYT = 0xA444;
const char32_t YI_SYLLABLE_NJYX = 0xA445;
const char32_t YI_SYLLABLE_NJY = 0xA446;
const char32_t YI_SYLLABLE_NJYP = 0xA447;
const char32_t YI_SYLLABLE_NJYRX = 0xA448;
const char32_t YI_SYLLABLE_NJYR = 0xA449;
const char32_t YI_SYLLABLE_NYIT = 0xA44A;
const char32_t YI_SYLLABLE_NYIX = 0xA44B;
const char32_t YI_SYLLABLE_NYI = 0xA44C;
const char32_t YI_SYLLABLE_NYIP = 0xA44D;
const char32_t YI_SYLLABLE_NYIET = 0xA44E;
const char32_t YI_SYLLABLE_NYIEX = 0xA44F;
const char32_t YI_SYLLABLE_NYIE = 0xA450;
const char32_t YI_SYLLABLE_NYIEP = 0xA451;
const char32_t YI_SYLLABLE_NYUOX = 0xA452;
const char32_t YI_SYLLABLE_NYUO = 0xA453;
const char32_t YI_SYLLABLE_NYUOP = 0xA454;
const char32_t YI_SYLLABLE_NYOT = 0xA455;
const char32_t YI_SYLLABLE_NYOX = 0xA456;
const char32_t YI_SYLLABLE_NYO = 0xA457;
const char32_t YI_SYLLABLE_NYOP = 0xA458;
const char32_t YI_SYLLABLE_NYUT = 0xA459;
const char32_t YI_SYLLABLE_NYUX = 0xA45A;
const char32_t YI_SYLLABLE_NYU = 0xA45B;
const char32_t YI_SYLLABLE_NYUP = 0xA45C;
const char32_t YI_SYLLABLE_XIT = 0xA45D;
const char32_t YI_SYLLABLE_XIX = 0xA45E;
const char32_t YI_SYLLABLE_XI = 0xA45F;
const char32_t YI_SYLLABLE_XIP = 0xA460;
const char32_t YI_SYLLABLE_XIET = 0xA461;
const char32_t YI_SYLLABLE_XIEX = 0xA462;
const char32_t YI_SYLLABLE_XIE = 0xA463;
const char32_t YI_SYLLABLE_XIEP = 0xA464;
const char32_t YI_SYLLABLE_XUOX = 0xA465;
const char32_t YI_SYLLABLE_XUO = 0xA466;
const char32_t YI_SYLLABLE_XOT = 0xA467;
const char32_t YI_SYLLABLE_XOX = 0xA468;
const char32_t YI_SYLLABLE_XO = 0xA469;
const char32_t YI_SYLLABLE_XOP = 0xA46A;
const char32_t YI_SYLLABLE_XYT = 0xA46B;
const char32_t YI_SYLLABLE_XYX = 0xA46C;
const char32_t YI_SYLLABLE_XY = 0xA46D;
const char32_t YI_SYLLABLE_XYP = 0xA46E;
const char32_t YI_SYLLABLE_XYRX = 0xA46F;
const char32_t YI_SYLLABLE_XYR = 0xA470;
const char32_t YI_SYLLABLE_YIT = 0xA471;
const char32_t YI_SYLLABLE_YIX = 0xA472;
const char32_t YI_SYLLABLE_YI = 0xA473;
const char32_t YI_SYLLABLE_YIP = 0xA474;
const char32_t YI_SYLLABLE_YIET = 0xA475;
const char32_t YI_SYLLABLE_YIEX = 0xA476;
const char32_t YI_SYLLABLE_YIE = 0xA477;
const char32_t YI_SYLLABLE_YIEP = 0xA478;
const char32_t YI_SYLLABLE_YUOT = 0xA479;
const char32_t YI_SYLLABLE_YUOX = 0xA47A;
const char32_t YI_SYLLABLE_YUO = 0xA47B;
const char32_t YI_SYLLABLE_YUOP = 0xA47C;
const char32_t YI_SYLLABLE_YOT = 0xA47D;
const char32_t YI_SYLLABLE_YOX = 0xA47E;
const char32_t YI_SYLLABLE_YO = 0xA47F;
const char32_t YI_SYLLABLE_YOP = 0xA480;
const char32_t YI_SYLLABLE_YUT = 0xA481;
const char32_t YI_SYLLABLE_YUX = 0xA482;
const char32_t YI_SYLLABLE_YU = 0xA483;
const char32_t YI_SYLLABLE_YUP = 0xA484;
const char32_t YI_SYLLABLE_YURX = 0xA485;
const char32_t YI_SYLLABLE_YUR = 0xA486;
const char32_t YI_SYLLABLE_YYT = 0xA487;
const char32_t YI_SYLLABLE_YYX = 0xA488;
const char32_t YI_SYLLABLE_YY = 0xA489;
const char32_t YI_SYLLABLE_YYP = 0xA48A;
const char32_t YI_SYLLABLE_YYRX = 0xA48B;
const char32_t YI_SYLLABLE_YYR = 0xA48C;
const char32_t YI_RADICAL_QOT = 0xA490;
const char32_t YI_RADICAL_LI = 0xA491;
const char32_t YI_RADICAL_KIT = 0xA492;
const char32_t YI_RADICAL_NYIP = 0xA493;
const char32_t YI_RADICAL_CYP = 0xA494;
const char32_t YI_RADICAL_SSI = 0xA495;
const char32_t YI_RADICAL_GGOP = 0xA496;
const char32_t YI_RADICAL_GEP = 0xA497;
const char32_t YI_RADICAL_MI = 0xA498;
const char32_t YI_RADICAL_HXIT = 0xA499;
const char32_t YI_RADICAL_LYR = 0xA49A;
const char32_t YI_RADICAL_BBUT = 0xA49B;
const char32_t YI_RADICAL_MOP = 0xA49C;
const char32_t YI_RADICAL_YO = 0xA49D;
const char32_t YI_RADICAL_PUT = 0xA49E;
const char32_t YI_RADICAL_HXUO = 0xA49F;
const char32_t YI_RADICAL_TAT = 0xA4A0;
const char32_t YI_RADICAL_GA = 0xA4A1;
const char32_t YI_RADICAL_ZUP = 0xA4A2;
const char32_t YI_RADICAL_CYT = 0xA4A3;
const char32_t YI_RADICAL_DDUR = 0xA4A4;
const char32_t YI_RADICAL_BUR = 0xA4A5;
const char32_t YI_RADICAL_GGUO = 0xA4A6;
const char32_t YI_RADICAL_NYOP = 0xA4A7;
const char32_t YI_RADICAL_TU = 0xA4A8;
const char32_t YI_RADICAL_OP = 0xA4A9;
const char32_t YI_RADICAL_JJUT = 0xA4AA;
const char32_t YI_RADICAL_ZOT = 0xA4AB;
const char32_t YI_RADICAL_PYT = 0xA4AC;
const char32_t YI_RADICAL_HMO = 0xA4AD;
const char32_t YI_RADICAL_YIT = 0xA4AE;
const char32_t YI_RADICAL_VUR = 0xA4AF;
const char32_t YI_RADICAL_SHY = 0xA4B0;
const char32_t YI_RADICAL_VEP = 0xA4B1;
const char32_t YI_RADICAL_ZA = 0xA4B2;
const char32_t YI_RADICAL_JO = 0xA4B3;
const char32_t YI_RADICAL_NZUP = 0xA4B4;
const char32_t YI_RADICAL_JJY = 0xA4B5;
const char32_t YI_RADICAL_GOT = 0xA4B6;
const char32_t YI_RADICAL_JJIE = 0xA4B7;
const char32_t YI_RADICAL_WO = 0xA4B8;
const char32_t YI_RADICAL_DU = 0xA4B9;
const char32_t YI_RADICAL_SHUR = 0xA4BA;
const char32_t YI_RADICAL_LIE = 0xA4BB;
const char32_t YI_RADICAL_CY = 0xA4BC;
const char32_t YI_RADICAL_CUOP = 0xA4BD;
const char32_t YI_RADICAL_CIP = 0xA4BE;
const char32_t YI_RADICAL_HXOP = 0xA4BF;
const char32_t YI_RADICAL_SHAT = 0xA4C0;
const char32_t YI_RADICAL_ZUR = 0xA4C1;
const char32_t YI_RADICAL_SHOP = 0xA4C2;
const char32_t YI_RADICAL_CHE = 0xA4C3;
const char32_t YI_RADICAL_ZZIET = 0xA4C4;
const char32_t YI_RADICAL_NBIE = 0xA4C5;
const char32_t YI_RADICAL_KE = 0xA4C6;
const char32_t LISU_LETTER_BA = 0xA4D0;
const char32_t LISU_LETTER_PA = 0xA4D1;
const char32_t LISU_LETTER_PHA = 0xA4D2;
const char32_t LISU_LETTER_DA = 0xA4D3;
const char32_t LISU_LETTER_TA = 0xA4D4;
const char32_t LISU_LETTER_THA = 0xA4D5;
const char32_t LISU_LETTER_GA = 0xA4D6;
const char32_t LISU_LETTER_KA = 0xA4D7;
const char32_t LISU_LETTER_KHA = 0xA4D8;
const char32_t LISU_LETTER_JA = 0xA4D9;
const char32_t LISU_LETTER_CA = 0xA4DA;
const char32_t LISU_LETTER_CHA = 0xA4DB;
const char32_t LISU_LETTER_DZA = 0xA4DC;
const char32_t LISU_LETTER_TSA = 0xA4DD;
const char32_t LISU_LETTER_TSHA = 0xA4DE;
const char32_t LISU_LETTER_MA = 0xA4DF;
const char32_t LISU_LETTER_NA = 0xA4E0;
const char32_t LISU_LETTER_LA = 0xA4E1;
const char32_t LISU_LETTER_SA = 0xA4E2;
const char32_t LISU_LETTER_ZHA = 0xA4E3;
const char32_t LISU_LETTER_ZA = 0xA4E4;
const char32_t LISU_LETTER_NGA = 0xA4E5;
const char32_t LISU_LETTER_HA = 0xA4E6;
const char32_t LISU_LETTER_XA = 0xA4E7;
const char32_t LISU_LETTER_HHA = 0xA4E8;
const char32_t LISU_LETTER_FA = 0xA4E9;
const char32_t LISU_LETTER_WA = 0xA4EA;
const char32_t LISU_LETTER_SHA = 0xA4EB;
const char32_t LISU_LETTER_YA = 0xA4EC;
const char32_t LISU_LETTER_GHA = 0xA4ED;
const char32_t LISU_LETTER_A = 0xA4EE;
const char32_t LISU_LETTER_AE = 0xA4EF;
const char32_t LISU_LETTER_E = 0xA4F0;
const char32_t LISU_LETTER_EU = 0xA4F1;
const char32_t LISU_LETTER_I = 0xA4F2;
const char32_t LISU_LETTER_O = 0xA4F3;
const char32_t LISU_LETTER_U = 0xA4F4;
const char32_t LISU_LETTER_UE = 0xA4F5;
const char32_t LISU_LETTER_UH = 0xA4F6;
const char32_t LISU_LETTER_OE = 0xA4F7;
const char32_t LISU_LETTER_TONE_MYA_TI = 0xA4F8;
const char32_t LISU_LETTER_TONE_NA_PO = 0xA4F9;
const char32_t LISU_LETTER_TONE_MYA_CYA = 0xA4FA;
const char32_t LISU_LETTER_TONE_MYA_BO = 0xA4FB;
const char32_t LISU_LETTER_TONE_MYA_NA = 0xA4FC;
const char32_t LISU_LETTER_TONE_MYA_JEU = 0xA4FD;
const char32_t LISU_PUNCTUATION_COMMA = 0xA4FE;
const char32_t LISU_PUNCTUATION_FULL_STOP = 0xA4FF;
const char32_t VAI_SYLLABLE_EE = 0xA500;
const char32_t VAI_SYLLABLE_EEN = 0xA501;
const char32_t VAI_SYLLABLE_HEE = 0xA502;
const char32_t VAI_SYLLABLE_WEE = 0xA503;
const char32_t VAI_SYLLABLE_WEEN = 0xA504;
const char32_t VAI_SYLLABLE_PEE = 0xA505;
const char32_t VAI_SYLLABLE_BHEE = 0xA506;
const char32_t VAI_SYLLABLE_BEE = 0xA507;
const char32_t VAI_SYLLABLE_MBEE = 0xA508;
const char32_t VAI_SYLLABLE_KPEE = 0xA509;
const char32_t VAI_SYLLABLE_MGBEE = 0xA50A;
const char32_t VAI_SYLLABLE_GBEE = 0xA50B;
const char32_t VAI_SYLLABLE_FEE = 0xA50C;
const char32_t VAI_SYLLABLE_VEE = 0xA50D;
const char32_t VAI_SYLLABLE_TEE = 0xA50E;
const char32_t VAI_SYLLABLE_THEE = 0xA50F;
const char32_t VAI_SYLLABLE_DHEE = 0xA510;
const char32_t VAI_SYLLABLE_DHHEE = 0xA511;
const char32_t VAI_SYLLABLE_LEE = 0xA512;
const char32_t VAI_SYLLABLE_REE = 0xA513;
const char32_t VAI_SYLLABLE_DEE = 0xA514;
const char32_t VAI_SYLLABLE_NDEE = 0xA515;
const char32_t VAI_SYLLABLE_SEE = 0xA516;
const char32_t VAI_SYLLABLE_SHEE = 0xA517;
const char32_t VAI_SYLLABLE_ZEE = 0xA518;
const char32_t VAI_SYLLABLE_ZHEE = 0xA519;
const char32_t VAI_SYLLABLE_CEE = 0xA51A;
const char32_t VAI_SYLLABLE_JEE = 0xA51B;
const char32_t VAI_SYLLABLE_NJEE = 0xA51C;
const char32_t VAI_SYLLABLE_YEE = 0xA51D;
const char32_t VAI_SYLLABLE_KEE = 0xA51E;
const char32_t VAI_SYLLABLE_NGGEE = 0xA51F;
const char32_t VAI_SYLLABLE_GEE = 0xA520;
const char32_t VAI_SYLLABLE_MEE = 0xA521;
const char32_t VAI_SYLLABLE_NEE = 0xA522;
const char32_t VAI_SYLLABLE_NYEE = 0xA523;
const char32_t VAI_SYLLABLE_I = 0xA524;
const char32_t VAI_SYLLABLE_IN = 0xA525;
const char32_t VAI_SYLLABLE_HI = 0xA526;
const char32_t VAI_SYLLABLE_HIN = 0xA527;
const char32_t VAI_SYLLABLE_WI = 0xA528;
const char32_t VAI_SYLLABLE_WIN = 0xA529;
const char32_t VAI_SYLLABLE_PI = 0xA52A;
const char32_t VAI_SYLLABLE_BHI = 0xA52B;
const char32_t VAI_SYLLABLE_BI = 0xA52C;
const char32_t VAI_SYLLABLE_MBI = 0xA52D;
const char32_t VAI_SYLLABLE_KPI = 0xA52E;
const char32_t VAI_SYLLABLE_MGBI = 0xA52F;
const char32_t VAI_SYLLABLE_GBI = 0xA530;
const char32_t VAI_SYLLABLE_FI = 0xA531;
const char32_t VAI_SYLLABLE_VI = 0xA532;
const char32_t VAI_SYLLABLE_TI = 0xA533;
const char32_t VAI_SYLLABLE_THI = 0xA534;
const char32_t VAI_SYLLABLE_DHI = 0xA535;
const char32_t VAI_SYLLABLE_DHHI = 0xA536;
const char32_t VAI_SYLLABLE_LI = 0xA537;
const char32_t VAI_SYLLABLE_RI = 0xA538;
const char32_t VAI_SYLLABLE_DI = 0xA539;
const char32_t VAI_SYLLABLE_NDI = 0xA53A;
const char32_t VAI_SYLLABLE_SI = 0xA53B;
const char32_t VAI_SYLLABLE_SHI = 0xA53C;
const char32_t VAI_SYLLABLE_ZI = 0xA53D;
const char32_t VAI_SYLLABLE_ZHI = 0xA53E;
const char32_t VAI_SYLLABLE_CI = 0xA53F;
const char32_t VAI_SYLLABLE_JI = 0xA540;
const char32_t VAI_SYLLABLE_NJI = 0xA541;
const char32_t VAI_SYLLABLE_YI = 0xA542;
const char32_t VAI_SYLLABLE_KI = 0xA543;
const char32_t VAI_SYLLABLE_NGGI = 0xA544;
const char32_t VAI_SYLLABLE_GI = 0xA545;
const char32_t VAI_SYLLABLE_MI = 0xA546;
const char32_t VAI_SYLLABLE_NI = 0xA547;
const char32_t VAI_SYLLABLE_NYI = 0xA548;
const char32_t VAI_SYLLABLE_A = 0xA549;
const char32_t VAI_SYLLABLE_AN = 0xA54A;
const char32_t VAI_SYLLABLE_NGAN = 0xA54B;
const char32_t VAI_SYLLABLE_HA = 0xA54C;
const char32_t VAI_SYLLABLE_HAN = 0xA54D;
const char32_t VAI_SYLLABLE_WA = 0xA54E;
const char32_t VAI_SYLLABLE_WAN = 0xA54F;
const char32_t VAI_SYLLABLE_PA = 0xA550;
const char32_t VAI_SYLLABLE_BHA = 0xA551;
const char32_t VAI_SYLLABLE_BA = 0xA552;
const char32_t VAI_SYLLABLE_MBA = 0xA553;
const char32_t VAI_SYLLABLE_KPA = 0xA554;
const char32_t VAI_SYLLABLE_KPAN = 0xA555;
const char32_t VAI_SYLLABLE_MGBA = 0xA556;
const char32_t VAI_SYLLABLE_GBA = 0xA557;
const char32_t VAI_SYLLABLE_FA = 0xA558;
const char32_t VAI_SYLLABLE_VA = 0xA559;
const char32_t VAI_SYLLABLE_TA = 0xA55A;
const char32_t VAI_SYLLABLE_THA = 0xA55B;
const char32_t VAI_SYLLABLE_DHA = 0xA55C;
const char32_t VAI_SYLLABLE_DHHA = 0xA55D;
const char32_t VAI_SYLLABLE_LA = 0xA55E;
const char32_t VAI_SYLLABLE_RA = 0xA55F;
const char32_t VAI_SYLLABLE_DA = 0xA560;
const char32_t VAI_SYLLABLE_NDA = 0xA561;
const char32_t VAI_SYLLABLE_SA = 0xA562;
const char32_t VAI_SYLLABLE_SHA = 0xA563;
const char32_t VAI_SYLLABLE_ZA = 0xA564;
const char32_t VAI_SYLLABLE_ZHA = 0xA565;
const char32_t VAI_SYLLABLE_CA = 0xA566;
const char32_t VAI_SYLLABLE_JA = 0xA567;
const char32_t VAI_SYLLABLE_NJA = 0xA568;
const char32_t VAI_SYLLABLE_YA = 0xA569;
const char32_t VAI_SYLLABLE_KA = 0xA56A;
const char32_t VAI_SYLLABLE_KAN = 0xA56B;
const char32_t VAI_SYLLABLE_NGGA = 0xA56C;
const char32_t VAI_SYLLABLE_GA = 0xA56D;
const char32_t VAI_SYLLABLE_MA = 0xA56E;
const char32_t VAI_SYLLABLE_NA = 0xA56F;
const char32_t VAI_SYLLABLE_NYA = 0xA570;
const char32_t VAI_SYLLABLE_OO = 0xA571;
const char32_t VAI_SYLLABLE_OON = 0xA572;
const char32_t VAI_SYLLABLE_HOO = 0xA573;
const char32_t VAI_SYLLABLE_WOO = 0xA574;
const char32_t VAI_SYLLABLE_WOON = 0xA575;
const char32_t VAI_SYLLABLE_POO = 0xA576;
const char32_t VAI_SYLLABLE_BHOO = 0xA577;
const char32_t VAI_SYLLABLE_BOO = 0xA578;
const char32_t VAI_SYLLABLE_MBOO = 0xA579;
const char32_t VAI_SYLLABLE_KPOO = 0xA57A;
const char32_t VAI_SYLLABLE_MGBOO = 0xA57B;
const char32_t VAI_SYLLABLE_GBOO = 0xA57C;
const char32_t VAI_SYLLABLE_FOO = 0xA57D;
const char32_t VAI_SYLLABLE_VOO = 0xA57E;
const char32_t VAI_SYLLABLE_TOO = 0xA57F;
const char32_t VAI_SYLLABLE_THOO = 0xA580;
const char32_t VAI_SYLLABLE_DHOO = 0xA581;
const char32_t VAI_SYLLABLE_DHHOO = 0xA582;
const char32_t VAI_SYLLABLE_LOO = 0xA583;
const char32_t VAI_SYLLABLE_ROO = 0xA584;
const char32_t VAI_SYLLABLE_DOO = 0xA585;
const char32_t VAI_SYLLABLE_NDOO = 0xA586;
const char32_t VAI_SYLLABLE_SOO = 0xA587;
const char32_t VAI_SYLLABLE_SHOO = 0xA588;
const char32_t VAI_SYLLABLE_ZOO = 0xA589;
const char32_t VAI_SYLLABLE_ZHOO = 0xA58A;
const char32_t VAI_SYLLABLE_COO = 0xA58B;
const char32_t VAI_SYLLABLE_JOO = 0xA58C;
const char32_t VAI_SYLLABLE_NJOO = 0xA58D;
const char32_t VAI_SYLLABLE_YOO = 0xA58E;
const char32_t VAI_SYLLABLE_KOO = 0xA58F;
const char32_t VAI_SYLLABLE_NGGOO = 0xA590;
const char32_t VAI_SYLLABLE_GOO = 0xA591;
const char32_t VAI_SYLLABLE_MOO = 0xA592;
const char32_t VAI_SYLLABLE_NOO = 0xA593;
const char32_t VAI_SYLLABLE_NYOO = 0xA594;
const char32_t VAI_SYLLABLE_U = 0xA595;
const char32_t VAI_SYLLABLE_UN = 0xA596;
const char32_t VAI_SYLLABLE_HU = 0xA597;
const char32_t VAI_SYLLABLE_HUN = 0xA598;
const char32_t VAI_SYLLABLE_WU = 0xA599;
const char32_t VAI_SYLLABLE_WUN = 0xA59A;
const char32_t VAI_SYLLABLE_PU = 0xA59B;
const char32_t VAI_SYLLABLE_BHU = 0xA59C;
const char32_t VAI_SYLLABLE_BU = 0xA59D;
const char32_t VAI_SYLLABLE_MBU = 0xA59E;
const char32_t VAI_SYLLABLE_KPU = 0xA59F;
const char32_t VAI_SYLLABLE_MGBU = 0xA5A0;
const char32_t VAI_SYLLABLE_GBU = 0xA5A1;
const char32_t VAI_SYLLABLE_FU = 0xA5A2;
const char32_t VAI_SYLLABLE_VU = 0xA5A3;
const char32_t VAI_SYLLABLE_TU = 0xA5A4;
const char32_t VAI_SYLLABLE_THU = 0xA5A5;
const char32_t VAI_SYLLABLE_DHU = 0xA5A6;
const char32_t VAI_SYLLABLE_DHHU = 0xA5A7;
const char32_t VAI_SYLLABLE_LU = 0xA5A8;
const char32_t VAI_SYLLABLE_RU = 0xA5A9;
const char32_t VAI_SYLLABLE_DU = 0xA5AA;
const char32_t VAI_SYLLABLE_NDU = 0xA5AB;
const char32_t VAI_SYLLABLE_SU = 0xA5AC;
const char32_t VAI_SYLLABLE_SHU = 0xA5AD;
const char32_t VAI_SYLLABLE_ZU = 0xA5AE;
const char32_t VAI_SYLLABLE_ZHU = 0xA5AF;
const char32_t VAI_SYLLABLE_CU = 0xA5B0;
const char32_t VAI_SYLLABLE_JU = 0xA5B1;
const char32_t VAI_SYLLABLE_NJU = 0xA5B2;
const char32_t VAI_SYLLABLE_YU = 0xA5B3;
const char32_t VAI_SYLLABLE_KU = 0xA5B4;
const char32_t VAI_SYLLABLE_NGGU = 0xA5B5;
const char32_t VAI_SYLLABLE_GU = 0xA5B6;
const char32_t VAI_SYLLABLE_MU = 0xA5B7;
const char32_t VAI_SYLLABLE_NU = 0xA5B8;
const char32_t VAI_SYLLABLE_NYU = 0xA5B9;
const char32_t VAI_SYLLABLE_O = 0xA5BA;
const char32_t VAI_SYLLABLE_ON = 0xA5BB;
const char32_t VAI_SYLLABLE_NGON = 0xA5BC;
const char32_t VAI_SYLLABLE_HO = 0xA5BD;
const char32_t VAI_SYLLABLE_HON = 0xA5BE;
const char32_t VAI_SYLLABLE_WO = 0xA5BF;
const char32_t VAI_SYLLABLE_WON = 0xA5C0;
const char32_t VAI_SYLLABLE_PO = 0xA5C1;
const char32_t VAI_SYLLABLE_BHO = 0xA5C2;
const char32_t VAI_SYLLABLE_BO = 0xA5C3;
const char32_t VAI_SYLLABLE_MBO = 0xA5C4;
const char32_t VAI_SYLLABLE_KPO = 0xA5C5;
const char32_t VAI_SYLLABLE_MGBO = 0xA5C6;
const char32_t VAI_SYLLABLE_GBO = 0xA5C7;
const char32_t VAI_SYLLABLE_GBON = 0xA5C8;
const char32_t VAI_SYLLABLE_FO = 0xA5C9;
const char32_t VAI_SYLLABLE_VO = 0xA5CA;
const char32_t VAI_SYLLABLE_TO = 0xA5CB;
const char32_t VAI_SYLLABLE_THO = 0xA5CC;
const char32_t VAI_SYLLABLE_DHO = 0xA5CD;
const char32_t VAI_SYLLABLE_DHHO = 0xA5CE;
const char32_t VAI_SYLLABLE_LO = 0xA5CF;
const char32_t VAI_SYLLABLE_RO = 0xA5D0;
const char32_t VAI_SYLLABLE_DO = 0xA5D1;
const char32_t VAI_SYLLABLE_NDO = 0xA5D2;
const char32_t VAI_SYLLABLE_SO = 0xA5D3;
const char32_t VAI_SYLLABLE_SHO = 0xA5D4;
const char32_t VAI_SYLLABLE_ZO = 0xA5D5;
const char32_t VAI_SYLLABLE_ZHO = 0xA5D6;
const char32_t VAI_SYLLABLE_CO = 0xA5D7;
const char32_t VAI_SYLLABLE_JO = 0xA5D8;
const char32_t VAI_SYLLABLE_NJO = 0xA5D9;
const char32_t VAI_SYLLABLE_YO = 0xA5DA;
const char32_t VAI_SYLLABLE_KO = 0xA5DB;
const char32_t VAI_SYLLABLE_NGGO = 0xA5DC;
const char32_t VAI_SYLLABLE_GO = 0xA5DD;
const char32_t VAI_SYLLABLE_MO = 0xA5DE;
const char32_t VAI_SYLLABLE_NO = 0xA5DF;
const char32_t VAI_SYLLABLE_NYO = 0xA5E0;
const char32_t VAI_SYLLABLE_E = 0xA5E1;
const char32_t VAI_SYLLABLE_EN = 0xA5E2;
const char32_t VAI_SYLLABLE_NGEN = 0xA5E3;
const char32_t VAI_SYLLABLE_HE = 0xA5E4;
const char32_t VAI_SYLLABLE_HEN = 0xA5E5;
const char32_t VAI_SYLLABLE_WE = 0xA5E6;
const char32_t VAI_SYLLABLE_WEN = 0xA5E7;
const char32_t VAI_SYLLABLE_PE = 0xA5E8;
const char32_t VAI_SYLLABLE_BHE = 0xA5E9;
const char32_t VAI_SYLLABLE_BE = 0xA5EA;
const char32_t VAI_SYLLABLE_MBE = 0xA5EB;
const char32_t VAI_SYLLABLE_KPE = 0xA5EC;
const char32_t VAI_SYLLABLE_KPEN = 0xA5ED;
const char32_t VAI_SYLLABLE_MGBE = 0xA5EE;
const char32_t VAI_SYLLABLE_GBE = 0xA5EF;
const char32_t VAI_SYLLABLE_GBEN = 0xA5F0;
const char32_t VAI_SYLLABLE_FE = 0xA5F1;
const char32_t VAI_SYLLABLE_VE = 0xA5F2;
const char32_t VAI_SYLLABLE_TE = 0xA5F3;
const char32_t VAI_SYLLABLE_THE = 0xA5F4;
const char32_t VAI_SYLLABLE_DHE = 0xA5F5;
const char32_t VAI_SYLLABLE_DHHE = 0xA5F6;
const char32_t VAI_SYLLABLE_LE = 0xA5F7;
const char32_t VAI_SYLLABLE_RE = 0xA5F8;
const char32_t VAI_SYLLABLE_DE = 0xA5F9;
const char32_t VAI_SYLLABLE_NDE = 0xA5FA;
const char32_t VAI_SYLLABLE_SE = 0xA5FB;
const char32_t VAI_SYLLABLE_SHE = 0xA5FC;
const char32_t VAI_SYLLABLE_ZE = 0xA5FD;
const char32_t VAI_SYLLABLE_ZHE = 0xA5FE;
const char32_t VAI_SYLLABLE_CE = 0xA5FF;
const char32_t VAI_SYLLABLE_JE = 0xA600;
const char32_t VAI_SYLLABLE_NJE = 0xA601;
const char32_t VAI_SYLLABLE_YE = 0xA602;
const char32_t VAI_SYLLABLE_KE = 0xA603;
const char32_t VAI_SYLLABLE_NGGE = 0xA604;
const char32_t VAI_SYLLABLE_NGGEN = 0xA605;
const char32_t VAI_SYLLABLE_GE = 0xA606;
const char32_t VAI_SYLLABLE_GEN = 0xA607;
const char32_t VAI_SYLLABLE_ME = 0xA608;
const char32_t VAI_SYLLABLE_NE = 0xA609;
const char32_t VAI_SYLLABLE_NYE = 0xA60A;
const char32_t VAI_SYLLABLE_NG = 0xA60B;
const char32_t VAI_SYLLABLE_LENGTHENER = 0xA60C;
const char32_t VAI_COMMA = 0xA60D;
const char32_t VAI_FULL_STOP = 0xA60E;
const char32_t VAI_QUESTION_MARK = 0xA60F;
const char32_t VAI_SYLLABLE_NDOLE_FA = 0xA610;
const char32_t VAI_SYLLABLE_NDOLE_KA = 0xA611;
const char32_t VAI_SYLLABLE_NDOLE_SOO = 0xA612;
const char32_t VAI_SYMBOL_FEENG = 0xA613;
const char32_t VAI_SYMBOL_KEENG = 0xA614;
const char32_t VAI_SYMBOL_TING = 0xA615;
const char32_t VAI_SYMBOL_NII = 0xA616;
const char32_t VAI_SYMBOL_BANG = 0xA617;
const char32_t VAI_SYMBOL_FAA = 0xA618;
const char32_t VAI_SYMBOL_TAA = 0xA619;
const char32_t VAI_SYMBOL_DANG = 0xA61A;
const char32_t VAI_SYMBOL_DOONG = 0xA61B;
const char32_t VAI_SYMBOL_KUNG = 0xA61C;
const char32_t VAI_SYMBOL_TONG = 0xA61D;
const char32_t VAI_SYMBOL_DO_O = 0xA61E;
const char32_t VAI_SYMBOL_JONG = 0xA61F;
const char32_t VAI_DIGIT_ZERO = 0xA620;
const char32_t VAI_DIGIT_ONE = 0xA621;
const char32_t VAI_DIGIT_TWO = 0xA622;
const char32_t VAI_DIGIT_THREE = 0xA623;
const char32_t VAI_DIGIT_FOUR = 0xA624;
const char32_t VAI_DIGIT_FIVE = 0xA625;
const char32_t VAI_DIGIT_SIX = 0xA626;
const char32_t VAI_DIGIT_SEVEN = 0xA627;
const char32_t VAI_DIGIT_EIGHT = 0xA628;
const char32_t VAI_DIGIT_NINE = 0xA629;
const char32_t VAI_SYLLABLE_NDOLE_MA = 0xA62A;
const char32_t VAI_SYLLABLE_NDOLE_DO = 0xA62B;
const char32_t CYRILLIC_CAPITAL_LETTER_ZEMLYA = 0xA640;
const char32_t CYRILLIC_SMALL_LETTER_ZEMLYA = 0xA641;
const char32_t CYRILLIC_CAPITAL_LETTER_DZELO = 0xA642;
const char32_t CYRILLIC_SMALL_LETTER_DZELO = 0xA643;
const char32_t CYRILLIC_CAPITAL_LETTER_REVERSED_DZE = 0xA644;
const char32_t CYRILLIC_SMALL_LETTER_REVERSED_DZE = 0xA645;
const char32_t CYRILLIC_CAPITAL_LETTER_IOTA = 0xA646;
const char32_t CYRILLIC_SMALL_LETTER_IOTA = 0xA647;
const char32_t CYRILLIC_CAPITAL_LETTER_DJERV = 0xA648;
const char32_t CYRILLIC_SMALL_LETTER_DJERV = 0xA649;
const char32_t CYRILLIC_CAPITAL_LETTER_MONOGRAPH_UK = 0xA64A;
const char32_t CYRILLIC_SMALL_LETTER_MONOGRAPH_UK = 0xA64B;
const char32_t CYRILLIC_CAPITAL_LETTER_BROAD_OMEGA = 0xA64C;
const char32_t CYRILLIC_SMALL_LETTER_BROAD_OMEGA = 0xA64D;
const char32_t CYRILLIC_CAPITAL_LETTER_NEUTRAL_YER = 0xA64E;
const char32_t CYRILLIC_SMALL_LETTER_NEUTRAL_YER = 0xA64F;
const char32_t CYRILLIC_CAPITAL_LETTER_YERU_WITH_BACK_YER = 0xA650;
const char32_t CYRILLIC_SMALL_LETTER_YERU_WITH_BACK_YER = 0xA651;
const char32_t CYRILLIC_CAPITAL_LETTER_IOTIFIED_YAT = 0xA652;
const char32_t CYRILLIC_SMALL_LETTER_IOTIFIED_YAT = 0xA653;
const char32_t CYRILLIC_CAPITAL_LETTER_REVERSED_YU = 0xA654;
const char32_t CYRILLIC_SMALL_LETTER_REVERSED_YU = 0xA655;
const char32_t CYRILLIC_CAPITAL_LETTER_IOTIFIED_A = 0xA656;
const char32_t CYRILLIC_SMALL_LETTER_IOTIFIED_A = 0xA657;
const char32_t CYRILLIC_CAPITAL_LETTER_CLOSED_LITTLE_YUS = 0xA658;
const char32_t CYRILLIC_SMALL_LETTER_CLOSED_LITTLE_YUS = 0xA659;
const char32_t CYRILLIC_CAPITAL_LETTER_BLENDED_YUS = 0xA65A;
const char32_t CYRILLIC_SMALL_LETTER_BLENDED_YUS = 0xA65B;
const char32_t CYRILLIC_CAPITAL_LETTER_IOTIFIED_CLOSED_LITTLE_YUS = 0xA65C;
const char32_t CYRILLIC_SMALL_LETTER_IOTIFIED_CLOSED_LITTLE_YUS = 0xA65D;
const char32_t CYRILLIC_CAPITAL_LETTER_YN = 0xA65E;
const char32_t CYRILLIC_SMALL_LETTER_YN = 0xA65F;
const char32_t CYRILLIC_CAPITAL_LETTER_REVERSED_TSE = 0xA660;
const char32_t CYRILLIC_SMALL_LETTER_REVERSED_TSE = 0xA661;
const char32_t CYRILLIC_CAPITAL_LETTER_SOFT_DE = 0xA662;
const char32_t CYRILLIC_SMALL_LETTER_SOFT_DE = 0xA663;
const char32_t CYRILLIC_CAPITAL_LETTER_SOFT_EL = 0xA664;
const char32_t CYRILLIC_SMALL_LETTER_SOFT_EL = 0xA665;
const char32_t CYRILLIC_CAPITAL_LETTER_SOFT_EM = 0xA666;
const char32_t CYRILLIC_SMALL_LETTER_SOFT_EM = 0xA667;
const char32_t CYRILLIC_CAPITAL_LETTER_MONOCULAR_O = 0xA668;
const char32_t CYRILLIC_SMALL_LETTER_MONOCULAR_O = 0xA669;
const char32_t CYRILLIC_CAPITAL_LETTER_BINOCULAR_O = 0xA66A;
const char32_t CYRILLIC_SMALL_LETTER_BINOCULAR_O = 0xA66B;
const char32_t CYRILLIC_CAPITAL_LETTER_DOUBLE_MONOCULAR_O = 0xA66C;
const char32_t CYRILLIC_SMALL_LETTER_DOUBLE_MONOCULAR_O = 0xA66D;
const char32_t CYRILLIC_LETTER_MULTIOCULAR_O = 0xA66E;
const char32_t COMBINING_CYRILLIC_VZMET = 0xA66F;
const char32_t COMBINING_CYRILLIC_TEN_MILLIONS_SIGN = 0xA670;
const char32_t COMBINING_CYRILLIC_HUNDRED_MILLIONS_SIGN = 0xA671;
const char32_t COMBINING_CYRILLIC_THOUSAND_MILLIONS_SIGN = 0xA672;
const char32_t SLAVONIC_ASTERISK = 0xA673;
const char32_t COMBINING_CYRILLIC_LETTER_UKRAINIAN_IE = 0xA674;
const char32_t COMBINING_CYRILLIC_LETTER_I = 0xA675;
const char32_t COMBINING_CYRILLIC_LETTER_YI = 0xA676;
const char32_t COMBINING_CYRILLIC_LETTER_U = 0xA677;
const char32_t COMBINING_CYRILLIC_LETTER_HARD_SIGN = 0xA678;
const char32_t COMBINING_CYRILLIC_LETTER_YERU = 0xA679;
const char32_t COMBINING_CYRILLIC_LETTER_SOFT_SIGN = 0xA67A;
const char32_t COMBINING_CYRILLIC_LETTER_OMEGA = 0xA67B;
const char32_t COMBINING_CYRILLIC_KAVYKA = 0xA67C;
const char32_t COMBINING_CYRILLIC_PAYEROK = 0xA67D;
const char32_t CYRILLIC_KAVYKA = 0xA67E;
const char32_t CYRILLIC_PAYEROK = 0xA67F;
const char32_t CYRILLIC_CAPITAL_LETTER_DWE = 0xA680;
const char32_t CYRILLIC_SMALL_LETTER_DWE = 0xA681;
const char32_t CYRILLIC_CAPITAL_LETTER_DZWE = 0xA682;
const char32_t CYRILLIC_SMALL_LETTER_DZWE = 0xA683;
const char32_t CYRILLIC_CAPITAL_LETTER_ZHWE = 0xA684;
const char32_t CYRILLIC_SMALL_LETTER_ZHWE = 0xA685;
const char32_t CYRILLIC_CAPITAL_LETTER_CCHE = 0xA686;
const char32_t CYRILLIC_SMALL_LETTER_CCHE = 0xA687;
const char32_t CYRILLIC_CAPITAL_LETTER_DZZE = 0xA688;
const char32_t CYRILLIC_SMALL_LETTER_DZZE = 0xA689;
const char32_t CYRILLIC_CAPITAL_LETTER_TE_WITH_MIDDLE_HOOK = 0xA68A;
const char32_t CYRILLIC_SMALL_LETTER_TE_WITH_MIDDLE_HOOK = 0xA68B;
const char32_t CYRILLIC_CAPITAL_LETTER_TWE = 0xA68C;
const char32_t CYRILLIC_SMALL_LETTER_TWE = 0xA68D;
const char32_t CYRILLIC_CAPITAL_LETTER_TSWE = 0xA68E;
const char32_t CYRILLIC_SMALL_LETTER_TSWE = 0xA68F;
const char32_t CYRILLIC_CAPITAL_LETTER_TSSE = 0xA690;
const char32_t CYRILLIC_SMALL_LETTER_TSSE = 0xA691;
const char32_t CYRILLIC_CAPITAL_LETTER_TCHE = 0xA692;
const char32_t CYRILLIC_SMALL_LETTER_TCHE = 0xA693;
const char32_t CYRILLIC_CAPITAL_LETTER_HWE = 0xA694;
const char32_t CYRILLIC_SMALL_LETTER_HWE = 0xA695;
const char32_t CYRILLIC_CAPITAL_LETTER_SHWE = 0xA696;
const char32_t CYRILLIC_SMALL_LETTER_SHWE = 0xA697;
const char32_t CYRILLIC_CAPITAL_LETTER_DOUBLE_O = 0xA698;
const char32_t CYRILLIC_SMALL_LETTER_DOUBLE_O = 0xA699;
const char32_t CYRILLIC_CAPITAL_LETTER_CROSSED_O = 0xA69A;
const char32_t CYRILLIC_SMALL_LETTER_CROSSED_O = 0xA69B;
const char32_t MODIFIER_LETTER_CYRILLIC_HARD_SIGN = 0xA69C;
const char32_t MODIFIER_LETTER_CYRILLIC_SOFT_SIGN = 0xA69D;
const char32_t COMBINING_CYRILLIC_LETTER_EF = 0xA69E;
const char32_t COMBINING_CYRILLIC_LETTER_IOTIFIED_E = 0xA69F;
const char32_t BAMUM_LETTER_A = 0xA6A0;
const char32_t BAMUM_LETTER_KA = 0xA6A1;
const char32_t BAMUM_LETTER_U = 0xA6A2;
const char32_t BAMUM_LETTER_KU = 0xA6A3;
const char32_t BAMUM_LETTER_EE = 0xA6A4;
const char32_t BAMUM_LETTER_REE = 0xA6A5;
const char32_t BAMUM_LETTER_TAE = 0xA6A6;
const char32_t BAMUM_LETTER_O = 0xA6A7;
const char32_t BAMUM_LETTER_NYI = 0xA6A8;
const char32_t BAMUM_LETTER_I = 0xA6A9;
const char32_t BAMUM_LETTER_LA = 0xA6AA;
const char32_t BAMUM_LETTER_PA = 0xA6AB;
const char32_t BAMUM_LETTER_RII = 0xA6AC;
const char32_t BAMUM_LETTER_RIEE = 0xA6AD;
const char32_t BAMUM_LETTER_LEEEE = 0xA6AE;
const char32_t BAMUM_LETTER_MEEEE = 0xA6AF;
const char32_t BAMUM_LETTER_TAA = 0xA6B0;
const char32_t BAMUM_LETTER_NDAA = 0xA6B1;
const char32_t BAMUM_LETTER_NJAEM = 0xA6B2;
const char32_t BAMUM_LETTER_M = 0xA6B3;
const char32_t BAMUM_LETTER_SUU = 0xA6B4;
const char32_t BAMUM_LETTER_MU = 0xA6B5;
const char32_t BAMUM_LETTER_SHII = 0xA6B6;
const char32_t BAMUM_LETTER_SI = 0xA6B7;
const char32_t BAMUM_LETTER_SHEUX = 0xA6B8;
const char32_t BAMUM_LETTER_SEUX = 0xA6B9;
const char32_t BAMUM_LETTER_KYEE = 0xA6BA;
const char32_t BAMUM_LETTER_KET = 0xA6BB;
const char32_t BAMUM_LETTER_NUAE = 0xA6BC;
const char32_t BAMUM_LETTER_NU = 0xA6BD;
const char32_t BAMUM_LETTER_NJUAE = 0xA6BE;
const char32_t BAMUM_LETTER_YOQ = 0xA6BF;
const char32_t BAMUM_LETTER_SHU = 0xA6C0;
const char32_t BAMUM_LETTER_YUQ = 0xA6C1;
const char32_t BAMUM_LETTER_YA = 0xA6C2;
const char32_t BAMUM_LETTER_NSHA = 0xA6C3;
const char32_t BAMUM_LETTER_KEUX = 0xA6C4;
const char32_t BAMUM_LETTER_PEUX = 0xA6C5;
const char32_t BAMUM_LETTER_NJEE = 0xA6C6;
const char32_t BAMUM_LETTER_NTEE = 0xA6C7;
const char32_t BAMUM_LETTER_PUE = 0xA6C8;
const char32_t BAMUM_LETTER_WUE = 0xA6C9;
const char32_t BAMUM_LETTER_PEE = 0xA6CA;
const char32_t BAMUM_LETTER_FEE = 0xA6CB;
const char32_t BAMUM_LETTER_RU = 0xA6CC;
const char32_t BAMUM_LETTER_LU = 0xA6CD;
const char32_t BAMUM_LETTER_MI = 0xA6CE;
const char32_t BAMUM_LETTER_NI = 0xA6CF;
const char32_t BAMUM_LETTER_REUX = 0xA6D0;
const char32_t BAMUM_LETTER_RAE = 0xA6D1;
const char32_t BAMUM_LETTER_KEN = 0xA6D2;
const char32_t BAMUM_LETTER_NGKWAEN = 0xA6D3;
const char32_t BAMUM_LETTER_NGGA = 0xA6D4;
const char32_t BAMUM_LETTER_NGA = 0xA6D5;
const char32_t BAMUM_LETTER_SHO = 0xA6D6;
const char32_t BAMUM_LETTER_PUAE = 0xA6D7;
const char32_t BAMUM_LETTER_FU = 0xA6D8;
const char32_t BAMUM_LETTER_FOM = 0xA6D9;
const char32_t BAMUM_LETTER_WA = 0xA6DA;
const char32_t BAMUM_LETTER_NA = 0xA6DB;
const char32_t BAMUM_LETTER_LI = 0xA6DC;
const char32_t BAMUM_LETTER_PI = 0xA6DD;
const char32_t BAMUM_LETTER_LOQ = 0xA6DE;
const char32_t BAMUM_LETTER_KO = 0xA6DF;
const char32_t BAMUM_LETTER_MBEN = 0xA6E0;
const char32_t BAMUM_LETTER_REN = 0xA6E1;
const char32_t BAMUM_LETTER_MEN = 0xA6E2;
const char32_t BAMUM_LETTER_MA = 0xA6E3;
const char32_t BAMUM_LETTER_TI = 0xA6E4;
const char32_t BAMUM_LETTER_KI = 0xA6E5;
const char32_t BAMUM_LETTER_MO = 0xA6E6;
const char32_t BAMUM_LETTER_MBAA = 0xA6E7;
const char32_t BAMUM_LETTER_TET = 0xA6E8;
const char32_t BAMUM_LETTER_KPA = 0xA6E9;
const char32_t BAMUM_LETTER_TEN = 0xA6EA;
const char32_t BAMUM_LETTER_NTUU = 0xA6EB;
const char32_t BAMUM_LETTER_SAMBA = 0xA6EC;
const char32_t BAMUM_LETTER_FAAMAE = 0xA6ED;
const char32_t BAMUM_LETTER_KOVUU = 0xA6EE;
const char32_t BAMUM_LETTER_KOGHOM = 0xA6EF;
const char32_t BAMUM_COMBINING_MARK_KOQNDON = 0xA6F0;
const char32_t BAMUM_COMBINING_MARK_TUKWENTIS = 0xA6F1;
const char32_t BAMUM_NJAEMLI = 0xA6F2;
const char32_t BAMUM_FULL_STOP = 0xA6F3;
const char32_t BAMUM_COLON = 0xA6F4;
const char32_t BAMUM_COMMA = 0xA6F5;
const char32_t BAMUM_SEMICOLON = 0xA6F6;
const char32_t BAMUM_QUESTION_MARK = 0xA6F7;
const char32_t MODIFIER_LETTER_CHINESE_TONE_YIN_PING = 0xA700;
const char32_t MODIFIER_LETTER_CHINESE_TONE_YANG_PING = 0xA701;
const char32_t MODIFIER_LETTER_CHINESE_TONE_YIN_SHANG = 0xA702;
const char32_t MODIFIER_LETTER_CHINESE_TONE_YANG_SHANG = 0xA703;
const char32_t MODIFIER_LETTER_CHINESE_TONE_YIN_QU = 0xA704;
const char32_t MODIFIER_LETTER_CHINESE_TONE_YANG_QU = 0xA705;
const char32_t MODIFIER_LETTER_CHINESE_TONE_YIN_RU = 0xA706;
const char32_t MODIFIER_LETTER_CHINESE_TONE_YANG_RU = 0xA707;
const char32_t MODIFIER_LETTER_EXTRA_HIGH_DOTTED_TONE_BAR = 0xA708;
const char32_t MODIFIER_LETTER_HIGH_DOTTED_TONE_BAR = 0xA709;
const char32_t MODIFIER_LETTER_MID_DOTTED_TONE_BAR = 0xA70A;
const char32_t MODIFIER_LETTER_LOW_DOTTED_TONE_BAR = 0xA70B;
const char32_t MODIFIER_LETTER_EXTRA_LOW_DOTTED_TONE_BAR = 0xA70C;
const char32_t MODIFIER_LETTER_EXTRA_HIGH_DOTTED_LEFT_STEM_TONE_BAR = 0xA70D;
const char32_t MODIFIER_LETTER_HIGH_DOTTED_LEFT_STEM_TONE_BAR = 0xA70E;
const char32_t MODIFIER_LETTER_MID_DOTTED_LEFT_STEM_TONE_BAR = 0xA70F;
const char32_t MODIFIER_LETTER_LOW_DOTTED_LEFT_STEM_TONE_BAR = 0xA710;
const char32_t MODIFIER_LETTER_EXTRA_LOW_DOTTED_LEFT_STEM_TONE_BAR = 0xA711;
const char32_t MODIFIER_LETTER_EXTRA_HIGH_LEFT_STEM_TONE_BAR = 0xA712;
const char32_t MODIFIER_LETTER_HIGH_LEFT_STEM_TONE_BAR = 0xA713;
const char32_t MODIFIER_LETTER_MID_LEFT_STEM_TONE_BAR = 0xA714;
const char32_t MODIFIER_LETTER_LOW_LEFT_STEM_TONE_BAR = 0xA715;
const char32_t MODIFIER_LETTER_EXTRA_LOW_LEFT_STEM_TONE_BAR = 0xA716;
const char32_t MODIFIER_LETTER_DOT_VERTICAL_BAR = 0xA717;
const char32_t MODIFIER_LETTER_DOT_SLASH = 0xA718;
const char32_t MODIFIER_LETTER_DOT_HORIZONTAL_BAR = 0xA719;
const char32_t MODIFIER_LETTER_LOWER_RIGHT_CORNER_ANGLE = 0xA71A;
const char32_t MODIFIER_LETTER_RAISED_UP_ARROW = 0xA71B;
const char32_t MODIFIER_LETTER_RAISED_DOWN_ARROW = 0xA71C;
const char32_t MODIFIER_LETTER_RAISED_EXCLAMATION_MARK = 0xA71D;
const char32_t MODIFIER_LETTER_RAISED_INVERTED_EXCLAMATION_MARK = 0xA71E;
const char32_t MODIFIER_LETTER_LOW_INVERTED_EXCLAMATION_MARK = 0xA71F;
const char32_t MODIFIER_LETTER_STRESS_AND_HIGH_TONE = 0xA720;
const char32_t MODIFIER_LETTER_STRESS_AND_LOW_TONE = 0xA721;
const char32_t LATIN_CAPITAL_LETTER_EGYPTOLOGICAL_ALEF = 0xA722;
const char32_t LATIN_SMALL_LETTER_EGYPTOLOGICAL_ALEF = 0xA723;
const char32_t LATIN_CAPITAL_LETTER_EGYPTOLOGICAL_AIN = 0xA724;
const char32_t LATIN_SMALL_LETTER_EGYPTOLOGICAL_AIN = 0xA725;
const char32_t LATIN_CAPITAL_LETTER_HENG = 0xA726;
const char32_t LATIN_SMALL_LETTER_HENG = 0xA727;
const char32_t LATIN_CAPITAL_LETTER_TZ = 0xA728;
const char32_t LATIN_SMALL_LETTER_TZ = 0xA729;
const char32_t LATIN_CAPITAL_LETTER_TRESILLO = 0xA72A;
const char32_t LATIN_SMALL_LETTER_TRESILLO = 0xA72B;
const char32_t LATIN_CAPITAL_LETTER_CUATRILLO = 0xA72C;
const char32_t LATIN_SMALL_LETTER_CUATRILLO = 0xA72D;
const char32_t LATIN_CAPITAL_LETTER_CUATRILLO_WITH_COMMA = 0xA72E;
const char32_t LATIN_SMALL_LETTER_CUATRILLO_WITH_COMMA = 0xA72F;
const char32_t LATIN_LETTER_SMALL_CAPITAL_F = 0xA730;
const char32_t LATIN_LETTER_SMALL_CAPITAL_S = 0xA731;
const char32_t LATIN_CAPITAL_LETTER_AA = 0xA732;
const char32_t LATIN_SMALL_LETTER_AA = 0xA733;
const char32_t LATIN_CAPITAL_LETTER_AO = 0xA734;
const char32_t LATIN_SMALL_LETTER_AO = 0xA735;
const char32_t LATIN_CAPITAL_LETTER_AU = 0xA736;
const char32_t LATIN_SMALL_LETTER_AU = 0xA737;
const char32_t LATIN_CAPITAL_LETTER_AV = 0xA738;
const char32_t LATIN_SMALL_LETTER_AV = 0xA739;
const char32_t LATIN_CAPITAL_LETTER_AV_WITH_HORIZONTAL_BAR = 0xA73A;
const char32_t LATIN_SMALL_LETTER_AV_WITH_HORIZONTAL_BAR = 0xA73B;
const char32_t LATIN_CAPITAL_LETTER_AY = 0xA73C;
const char32_t LATIN_SMALL_LETTER_AY = 0xA73D;
const char32_t LATIN_CAPITAL_LETTER_REVERSED_C_WITH_DOT = 0xA73E;
const char32_t LATIN_SMALL_LETTER_REVERSED_C_WITH_DOT = 0xA73F;
const char32_t LATIN_CAPITAL_LETTER_K_WITH_STROKE = 0xA740;
const char32_t LATIN_SMALL_LETTER_K_WITH_STROKE = 0xA741;
const char32_t LATIN_CAPITAL_LETTER_K_WITH_DIAGONAL_STROKE = 0xA742;
const char32_t LATIN_SMALL_LETTER_K_WITH_DIAGONAL_STROKE = 0xA743;
const char32_t LATIN_CAPITAL_LETTER_K_WITH_STROKE_AND_DIAGONAL_STROKE = 0xA744;
const char32_t LATIN_SMALL_LETTER_K_WITH_STROKE_AND_DIAGONAL_STROKE = 0xA745;
const char32_t LATIN_CAPITAL_LETTER_BROKEN_L = 0xA746;
const char32_t LATIN_SMALL_LETTER_BROKEN_L = 0xA747;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_HIGH_STROKE = 0xA748;
const char32_t LATIN_SMALL_LETTER_L_WITH_HIGH_STROKE = 0xA749;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_LONG_STROKE_OVERLAY = 0xA74A;
const char32_t LATIN_SMALL_LETTER_O_WITH_LONG_STROKE_OVERLAY = 0xA74B;
const char32_t LATIN_CAPITAL_LETTER_O_WITH_LOOP = 0xA74C;
const char32_t LATIN_SMALL_LETTER_O_WITH_LOOP = 0xA74D;
const char32_t LATIN_CAPITAL_LETTER_OO = 0xA74E;
const char32_t LATIN_SMALL_LETTER_OO = 0xA74F;
const char32_t LATIN_CAPITAL_LETTER_P_WITH_STROKE_THROUGH_DESCENDER = 0xA750;
const char32_t LATIN_SMALL_LETTER_P_WITH_STROKE_THROUGH_DESCENDER = 0xA751;
const char32_t LATIN_CAPITAL_LETTER_P_WITH_FLOURISH = 0xA752;
const char32_t LATIN_SMALL_LETTER_P_WITH_FLOURISH = 0xA753;
const char32_t LATIN_CAPITAL_LETTER_P_WITH_SQUIRREL_TAIL = 0xA754;
const char32_t LATIN_SMALL_LETTER_P_WITH_SQUIRREL_TAIL = 0xA755;
const char32_t LATIN_CAPITAL_LETTER_Q_WITH_STROKE_THROUGH_DESCENDER = 0xA756;
const char32_t LATIN_SMALL_LETTER_Q_WITH_STROKE_THROUGH_DESCENDER = 0xA757;
const char32_t LATIN_CAPITAL_LETTER_Q_WITH_DIAGONAL_STROKE = 0xA758;
const char32_t LATIN_SMALL_LETTER_Q_WITH_DIAGONAL_STROKE = 0xA759;
const char32_t LATIN_CAPITAL_LETTER_R_ROTUNDA = 0xA75A;
const char32_t LATIN_SMALL_LETTER_R_ROTUNDA = 0xA75B;
const char32_t LATIN_CAPITAL_LETTER_RUM_ROTUNDA = 0xA75C;
const char32_t LATIN_SMALL_LETTER_RUM_ROTUNDA = 0xA75D;
const char32_t LATIN_CAPITAL_LETTER_V_WITH_DIAGONAL_STROKE = 0xA75E;
const char32_t LATIN_SMALL_LETTER_V_WITH_DIAGONAL_STROKE = 0xA75F;
const char32_t LATIN_CAPITAL_LETTER_VY = 0xA760;
const char32_t LATIN_SMALL_LETTER_VY = 0xA761;
const char32_t LATIN_CAPITAL_LETTER_VISIGOTHIC_Z = 0xA762;
const char32_t LATIN_SMALL_LETTER_VISIGOTHIC_Z = 0xA763;
const char32_t LATIN_CAPITAL_LETTER_THORN_WITH_STROKE = 0xA764;
const char32_t LATIN_SMALL_LETTER_THORN_WITH_STROKE = 0xA765;
const char32_t LATIN_CAPITAL_LETTER_THORN_WITH_STROKE_THROUGH_DESCENDER = 0xA766;
const char32_t LATIN_SMALL_LETTER_THORN_WITH_STROKE_THROUGH_DESCENDER = 0xA767;
const char32_t LATIN_CAPITAL_LETTER_VEND = 0xA768;
const char32_t LATIN_SMALL_LETTER_VEND = 0xA769;
const char32_t LATIN_CAPITAL_LETTER_ET = 0xA76A;
const char32_t LATIN_SMALL_LETTER_ET = 0xA76B;
const char32_t LATIN_CAPITAL_LETTER_IS = 0xA76C;
const char32_t LATIN_SMALL_LETTER_IS = 0xA76D;
const char32_t LATIN_CAPITAL_LETTER_CON = 0xA76E;
const char32_t LATIN_SMALL_LETTER_CON = 0xA76F;
const char32_t MODIFIER_LETTER_US = 0xA770;
const char32_t LATIN_SMALL_LETTER_DUM = 0xA771;
const char32_t LATIN_SMALL_LETTER_LUM = 0xA772;
const char32_t LATIN_SMALL_LETTER_MUM = 0xA773;
const char32_t LATIN_SMALL_LETTER_NUM = 0xA774;
const char32_t LATIN_SMALL_LETTER_RUM = 0xA775;
const char32_t LATIN_LETTER_SMALL_CAPITAL_RUM = 0xA776;
const char32_t LATIN_SMALL_LETTER_TUM = 0xA777;
const char32_t LATIN_SMALL_LETTER_UM = 0xA778;
const char32_t LATIN_CAPITAL_LETTER_INSULAR_D = 0xA779;
const char32_t LATIN_SMALL_LETTER_INSULAR_D = 0xA77A;
const char32_t LATIN_CAPITAL_LETTER_INSULAR_F = 0xA77B;
const char32_t LATIN_SMALL_LETTER_INSULAR_F = 0xA77C;
const char32_t LATIN_CAPITAL_LETTER_INSULAR_G = 0xA77D;
const char32_t LATIN_CAPITAL_LETTER_TURNED_INSULAR_G = 0xA77E;
const char32_t LATIN_SMALL_LETTER_TURNED_INSULAR_G = 0xA77F;
const char32_t LATIN_CAPITAL_LETTER_TURNED_L = 0xA780;
const char32_t LATIN_SMALL_LETTER_TURNED_L = 0xA781;
const char32_t LATIN_CAPITAL_LETTER_INSULAR_R = 0xA782;
const char32_t LATIN_SMALL_LETTER_INSULAR_R = 0xA783;
const char32_t LATIN_CAPITAL_LETTER_INSULAR_S = 0xA784;
const char32_t LATIN_SMALL_LETTER_INSULAR_S = 0xA785;
const char32_t LATIN_CAPITAL_LETTER_INSULAR_T = 0xA786;
const char32_t LATIN_SMALL_LETTER_INSULAR_T = 0xA787;
const char32_t MODIFIER_LETTER_LOW_CIRCUMFLEX_ACCENT = 0xA788;
const char32_t MODIFIER_LETTER_COLON = 0xA789;
const char32_t MODIFIER_LETTER_SHORT_EQUALS_SIGN = 0xA78A;
const char32_t LATIN_CAPITAL_LETTER_SALTILLO = 0xA78B;
const char32_t LATIN_SMALL_LETTER_SALTILLO = 0xA78C;
const char32_t LATIN_CAPITAL_LETTER_TURNED_H = 0xA78D;
const char32_t LATIN_SMALL_LETTER_L_WITH_RETROFLEX_HOOK_AND_BELT = 0xA78E;
const char32_t LATIN_LETTER_SINOLOGICAL_DOT = 0xA78F;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_DESCENDER = 0xA790;
const char32_t LATIN_SMALL_LETTER_N_WITH_DESCENDER = 0xA791;
const char32_t LATIN_CAPITAL_LETTER_C_WITH_BAR = 0xA792;
const char32_t LATIN_SMALL_LETTER_C_WITH_BAR = 0xA793;
const char32_t LATIN_SMALL_LETTER_C_WITH_PALATAL_HOOK = 0xA794;
const char32_t LATIN_SMALL_LETTER_H_WITH_PALATAL_HOOK = 0xA795;
const char32_t LATIN_CAPITAL_LETTER_B_WITH_FLOURISH = 0xA796;
const char32_t LATIN_SMALL_LETTER_B_WITH_FLOURISH = 0xA797;
const char32_t LATIN_CAPITAL_LETTER_F_WITH_STROKE = 0xA798;
const char32_t LATIN_SMALL_LETTER_F_WITH_STROKE = 0xA799;
const char32_t LATIN_CAPITAL_LETTER_VOLAPUK_AE = 0xA79A;
const char32_t LATIN_SMALL_LETTER_VOLAPUK_AE = 0xA79B;
const char32_t LATIN_CAPITAL_LETTER_VOLAPUK_OE = 0xA79C;
const char32_t LATIN_SMALL_LETTER_VOLAPUK_OE = 0xA79D;
const char32_t LATIN_CAPITAL_LETTER_VOLAPUK_UE = 0xA79E;
const char32_t LATIN_SMALL_LETTER_VOLAPUK_UE = 0xA79F;
const char32_t LATIN_CAPITAL_LETTER_G_WITH_OBLIQUE_STROKE = 0xA7A0;
const char32_t LATIN_SMALL_LETTER_G_WITH_OBLIQUE_STROKE = 0xA7A1;
const char32_t LATIN_CAPITAL_LETTER_K_WITH_OBLIQUE_STROKE = 0xA7A2;
const char32_t LATIN_SMALL_LETTER_K_WITH_OBLIQUE_STROKE = 0xA7A3;
const char32_t LATIN_CAPITAL_LETTER_N_WITH_OBLIQUE_STROKE = 0xA7A4;
const char32_t LATIN_SMALL_LETTER_N_WITH_OBLIQUE_STROKE = 0xA7A5;
const char32_t LATIN_CAPITAL_LETTER_R_WITH_OBLIQUE_STROKE = 0xA7A6;
const char32_t LATIN_SMALL_LETTER_R_WITH_OBLIQUE_STROKE = 0xA7A7;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_OBLIQUE_STROKE = 0xA7A8;
const char32_t LATIN_SMALL_LETTER_S_WITH_OBLIQUE_STROKE = 0xA7A9;
const char32_t LATIN_CAPITAL_LETTER_H_WITH_HOOK = 0xA7AA;
const char32_t LATIN_CAPITAL_LETTER_REVERSED_OPEN_E = 0xA7AB;
const char32_t LATIN_CAPITAL_LETTER_SCRIPT_G = 0xA7AC;
const char32_t LATIN_CAPITAL_LETTER_L_WITH_BELT = 0xA7AD;
const char32_t LATIN_CAPITAL_LETTER_SMALL_CAPITAL_I = 0xA7AE;
const char32_t LATIN_LETTER_SMALL_CAPITAL_Q = 0xA7AF;
const char32_t LATIN_CAPITAL_LETTER_TURNED_K = 0xA7B0;
const char32_t LATIN_CAPITAL_LETTER_TURNED_T = 0xA7B1;
const char32_t LATIN_CAPITAL_LETTER_J_WITH_CROSSED_TAIL = 0xA7B2;
const char32_t LATIN_CAPITAL_LETTER_CHI = 0xA7B3;
const char32_t LATIN_CAPITAL_LETTER_BETA = 0xA7B4;
const char32_t LATIN_SMALL_LETTER_BETA = 0xA7B5;
const char32_t LATIN_CAPITAL_LETTER_OMEGA = 0xA7B6;
const char32_t LATIN_SMALL_LETTER_OMEGA = 0xA7B7;
const char32_t LATIN_CAPITAL_LETTER_U_WITH_STROKE = 0xA7B8;
const char32_t LATIN_SMALL_LETTER_U_WITH_STROKE = 0xA7B9;
const char32_t LATIN_CAPITAL_LETTER_GLOTTAL_A = 0xA7BA;
const char32_t LATIN_SMALL_LETTER_GLOTTAL_A = 0xA7BB;
const char32_t LATIN_CAPITAL_LETTER_GLOTTAL_I = 0xA7BC;
const char32_t LATIN_SMALL_LETTER_GLOTTAL_I = 0xA7BD;
const char32_t LATIN_CAPITAL_LETTER_GLOTTAL_U = 0xA7BE;
const char32_t LATIN_SMALL_LETTER_GLOTTAL_U = 0xA7BF;
const char32_t LATIN_CAPITAL_LETTER_ANGLICANA_W = 0xA7C2;
const char32_t LATIN_SMALL_LETTER_ANGLICANA_W = 0xA7C3;
const char32_t LATIN_CAPITAL_LETTER_C_WITH_PALATAL_HOOK = 0xA7C4;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_HOOK = 0xA7C5;
const char32_t LATIN_CAPITAL_LETTER_Z_WITH_PALATAL_HOOK = 0xA7C6;
const char32_t LATIN_CAPITAL_LETTER_D_WITH_SHORT_STROKE_OVERLAY = 0xA7C7;
const char32_t LATIN_SMALL_LETTER_D_WITH_SHORT_STROKE_OVERLAY = 0xA7C8;
const char32_t LATIN_CAPITAL_LETTER_S_WITH_SHORT_STROKE_OVERLAY = 0xA7C9;
const char32_t LATIN_SMALL_LETTER_S_WITH_SHORT_STROKE_OVERLAY = 0xA7CA;
const char32_t LATIN_CAPITAL_LETTER_REVERSED_HALF_H = 0xA7F5;
const char32_t LATIN_SMALL_LETTER_REVERSED_HALF_H = 0xA7F6;
const char32_t LATIN_EPIGRAPHIC_LETTER_SIDEWAYS_I = 0xA7F7;
const char32_t MODIFIER_LETTER_CAPITAL_H_WITH_STROKE = 0xA7F8;
const char32_t MODIFIER_LETTER_SMALL_LIGATURE_OE = 0xA7F9;
const char32_t LATIN_LETTER_SMALL_CAPITAL_TURNED_M = 0xA7FA;
const char32_t LATIN_EPIGRAPHIC_LETTER_REVERSED_F = 0xA7FB;
const char32_t LATIN_EPIGRAPHIC_LETTER_REVERSED_P = 0xA7FC;
const char32_t LATIN_EPIGRAPHIC_LETTER_INVERTED_M = 0xA7FD;
const char32_t LATIN_EPIGRAPHIC_LETTER_I_LONGA = 0xA7FE;
const char32_t LATIN_EPIGRAPHIC_LETTER_ARCHAIC_M = 0xA7FF;
const char32_t SYLOTI_NAGRI_LETTER_A = 0xA800;
const char32_t SYLOTI_NAGRI_LETTER_I = 0xA801;
const char32_t SYLOTI_NAGRI_SIGN_DVISVARA = 0xA802;
const char32_t SYLOTI_NAGRI_LETTER_U = 0xA803;
const char32_t SYLOTI_NAGRI_LETTER_E = 0xA804;
const char32_t SYLOTI_NAGRI_LETTER_O = 0xA805;
const char32_t SYLOTI_NAGRI_SIGN_HASANTA = 0xA806;
const char32_t SYLOTI_NAGRI_LETTER_KO = 0xA807;
const char32_t SYLOTI_NAGRI_LETTER_KHO = 0xA808;
const char32_t SYLOTI_NAGRI_LETTER_GO = 0xA809;
const char32_t SYLOTI_NAGRI_LETTER_GHO = 0xA80A;
const char32_t SYLOTI_NAGRI_SIGN_ANUSVARA = 0xA80B;
const char32_t SYLOTI_NAGRI_LETTER_CO = 0xA80C;
const char32_t SYLOTI_NAGRI_LETTER_CHO = 0xA80D;
const char32_t SYLOTI_NAGRI_LETTER_JO = 0xA80E;
const char32_t SYLOTI_NAGRI_LETTER_JHO = 0xA80F;
const char32_t SYLOTI_NAGRI_LETTER_TTO = 0xA810;
const char32_t SYLOTI_NAGRI_LETTER_TTHO = 0xA811;
const char32_t SYLOTI_NAGRI_LETTER_DDO = 0xA812;
const char32_t SYLOTI_NAGRI_LETTER_DDHO = 0xA813;
const char32_t SYLOTI_NAGRI_LETTER_TO = 0xA814;
const char32_t SYLOTI_NAGRI_LETTER_THO = 0xA815;
const char32_t SYLOTI_NAGRI_LETTER_DO = 0xA816;
const char32_t SYLOTI_NAGRI_LETTER_DHO = 0xA817;
const char32_t SYLOTI_NAGRI_LETTER_NO = 0xA818;
const char32_t SYLOTI_NAGRI_LETTER_PO = 0xA819;
const char32_t SYLOTI_NAGRI_LETTER_PHO = 0xA81A;
const char32_t SYLOTI_NAGRI_LETTER_BO = 0xA81B;
const char32_t SYLOTI_NAGRI_LETTER_BHO = 0xA81C;
const char32_t SYLOTI_NAGRI_LETTER_MO = 0xA81D;
const char32_t SYLOTI_NAGRI_LETTER_RO = 0xA81E;
const char32_t SYLOTI_NAGRI_LETTER_LO = 0xA81F;
const char32_t SYLOTI_NAGRI_LETTER_RRO = 0xA820;
const char32_t SYLOTI_NAGRI_LETTER_SO = 0xA821;
const char32_t SYLOTI_NAGRI_LETTER_HO = 0xA822;
const char32_t SYLOTI_NAGRI_VOWEL_SIGN_A = 0xA823;
const char32_t SYLOTI_NAGRI_VOWEL_SIGN_I = 0xA824;
const char32_t SYLOTI_NAGRI_VOWEL_SIGN_U = 0xA825;
const char32_t SYLOTI_NAGRI_VOWEL_SIGN_E = 0xA826;
const char32_t SYLOTI_NAGRI_VOWEL_SIGN_OO = 0xA827;
const char32_t SYLOTI_NAGRI_POETRY_MARK_1 = 0xA828;
const char32_t SYLOTI_NAGRI_POETRY_MARK_2 = 0xA829;
const char32_t SYLOTI_NAGRI_POETRY_MARK_3 = 0xA82A;
const char32_t SYLOTI_NAGRI_POETRY_MARK_4 = 0xA82B;
const char32_t SYLOTI_NAGRI_SIGN_ALTERNATE_HASANTA = 0xA82C;
const char32_t NORTH_INDIC_FRACTION_ONE_QUARTER = 0xA830;
const char32_t NORTH_INDIC_FRACTION_ONE_HALF = 0xA831;
const char32_t NORTH_INDIC_FRACTION_THREE_QUARTERS = 0xA832;
const char32_t NORTH_INDIC_FRACTION_ONE_SIXTEENTH = 0xA833;
const char32_t NORTH_INDIC_FRACTION_ONE_EIGHTH = 0xA834;
const char32_t NORTH_INDIC_FRACTION_THREE_SIXTEENTHS = 0xA835;
const char32_t NORTH_INDIC_QUARTER_MARK = 0xA836;
const char32_t NORTH_INDIC_PLACEHOLDER_MARK = 0xA837;
const char32_t NORTH_INDIC_RUPEE_MARK = 0xA838;
const char32_t NORTH_INDIC_QUANTITY_MARK = 0xA839;
const char32_t PHAGS_PA_LETTER_KA = 0xA840;
const char32_t PHAGS_PA_LETTER_KHA = 0xA841;
const char32_t PHAGS_PA_LETTER_GA = 0xA842;
const char32_t PHAGS_PA_LETTER_NGA = 0xA843;
const char32_t PHAGS_PA_LETTER_CA = 0xA844;
const char32_t PHAGS_PA_LETTER_CHA = 0xA845;
const char32_t PHAGS_PA_LETTER_JA = 0xA846;
const char32_t PHAGS_PA_LETTER_NYA = 0xA847;
const char32_t PHAGS_PA_LETTER_TA = 0xA848;
const char32_t PHAGS_PA_LETTER_THA = 0xA849;
const char32_t PHAGS_PA_LETTER_DA = 0xA84A;
const char32_t PHAGS_PA_LETTER_NA = 0xA84B;
const char32_t PHAGS_PA_LETTER_PA = 0xA84C;
const char32_t PHAGS_PA_LETTER_PHA = 0xA84D;
const char32_t PHAGS_PA_LETTER_BA = 0xA84E;
const char32_t PHAGS_PA_LETTER_MA = 0xA84F;
const char32_t PHAGS_PA_LETTER_TSA = 0xA850;
const char32_t PHAGS_PA_LETTER_TSHA = 0xA851;
const char32_t PHAGS_PA_LETTER_DZA = 0xA852;
const char32_t PHAGS_PA_LETTER_WA = 0xA853;
const char32_t PHAGS_PA_LETTER_ZHA = 0xA854;
const char32_t PHAGS_PA_LETTER_ZA = 0xA855;
const char32_t PHAGS_PA_LETTER_SMALL_A = 0xA856;
const char32_t PHAGS_PA_LETTER_YA = 0xA857;
const char32_t PHAGS_PA_LETTER_RA = 0xA858;
const char32_t PHAGS_PA_LETTER_LA = 0xA859;
const char32_t PHAGS_PA_LETTER_SHA = 0xA85A;
const char32_t PHAGS_PA_LETTER_SA = 0xA85B;
const char32_t PHAGS_PA_LETTER_HA = 0xA85C;
const char32_t PHAGS_PA_LETTER_A = 0xA85D;
const char32_t PHAGS_PA_LETTER_I = 0xA85E;
const char32_t PHAGS_PA_LETTER_U = 0xA85F;
const char32_t PHAGS_PA_LETTER_E = 0xA860;
const char32_t PHAGS_PA_LETTER_O = 0xA861;
const char32_t PHAGS_PA_LETTER_QA = 0xA862;
const char32_t PHAGS_PA_LETTER_XA = 0xA863;
const char32_t PHAGS_PA_LETTER_FA = 0xA864;
const char32_t PHAGS_PA_LETTER_GGA = 0xA865;
const char32_t PHAGS_PA_LETTER_EE = 0xA866;
const char32_t PHAGS_PA_SUBJOINED_LETTER_WA = 0xA867;
const char32_t PHAGS_PA_SUBJOINED_LETTER_YA = 0xA868;
const char32_t PHAGS_PA_LETTER_TTA = 0xA869;
const char32_t PHAGS_PA_LETTER_TTHA = 0xA86A;
const char32_t PHAGS_PA_LETTER_DDA = 0xA86B;
const char32_t PHAGS_PA_LETTER_NNA = 0xA86C;
const char32_t PHAGS_PA_LETTER_ALTERNATE_YA = 0xA86D;
const char32_t PHAGS_PA_LETTER_VOICELESS_SHA = 0xA86E;
const char32_t PHAGS_PA_LETTER_VOICED_HA = 0xA86F;
const char32_t PHAGS_PA_LETTER_ASPIRATED_FA = 0xA870;
const char32_t PHAGS_PA_SUBJOINED_LETTER_RA = 0xA871;
const char32_t PHAGS_PA_SUPERFIXED_LETTER_RA = 0xA872;
const char32_t PHAGS_PA_LETTER_CANDRABINDU = 0xA873;
const char32_t PHAGS_PA_SINGLE_HEAD_MARK = 0xA874;
const char32_t PHAGS_PA_DOUBLE_HEAD_MARK = 0xA875;
const char32_t PHAGS_PA_MARK_SHAD = 0xA876;
const char32_t PHAGS_PA_MARK_DOUBLE_SHAD = 0xA877;
const char32_t SAURASHTRA_SIGN_ANUSVARA = 0xA880;
const char32_t SAURASHTRA_SIGN_VISARGA = 0xA881;
const char32_t SAURASHTRA_LETTER_A = 0xA882;
const char32_t SAURASHTRA_LETTER_AA = 0xA883;
const char32_t SAURASHTRA_LETTER_I = 0xA884;
const char32_t SAURASHTRA_LETTER_II = 0xA885;
const char32_t SAURASHTRA_LETTER_U = 0xA886;
const char32_t SAURASHTRA_LETTER_UU = 0xA887;
const char32_t SAURASHTRA_LETTER_VOCALIC_R = 0xA888;
const char32_t SAURASHTRA_LETTER_VOCALIC_RR = 0xA889;
const char32_t SAURASHTRA_LETTER_VOCALIC_L = 0xA88A;
const char32_t SAURASHTRA_LETTER_VOCALIC_LL = 0xA88B;
const char32_t SAURASHTRA_LETTER_E = 0xA88C;
const char32_t SAURASHTRA_LETTER_EE = 0xA88D;
const char32_t SAURASHTRA_LETTER_AI = 0xA88E;
const char32_t SAURASHTRA_LETTER_O = 0xA88F;
const char32_t SAURASHTRA_LETTER_OO = 0xA890;
const char32_t SAURASHTRA_LETTER_AU = 0xA891;
const char32_t SAURASHTRA_LETTER_KA = 0xA892;
const char32_t SAURASHTRA_LETTER_KHA = 0xA893;
const char32_t SAURASHTRA_LETTER_GA = 0xA894;
const char32_t SAURASHTRA_LETTER_GHA = 0xA895;
const char32_t SAURASHTRA_LETTER_NGA = 0xA896;
const char32_t SAURASHTRA_LETTER_CA = 0xA897;
const char32_t SAURASHTRA_LETTER_CHA = 0xA898;
const char32_t SAURASHTRA_LETTER_JA = 0xA899;
const char32_t SAURASHTRA_LETTER_JHA = 0xA89A;
const char32_t SAURASHTRA_LETTER_NYA = 0xA89B;
const char32_t SAURASHTRA_LETTER_TTA = 0xA89C;
const char32_t SAURASHTRA_LETTER_TTHA = 0xA89D;
const char32_t SAURASHTRA_LETTER_DDA = 0xA89E;
const char32_t SAURASHTRA_LETTER_DDHA = 0xA89F;
const char32_t SAURASHTRA_LETTER_NNA = 0xA8A0;
const char32_t SAURASHTRA_LETTER_TA = 0xA8A1;
const char32_t SAURASHTRA_LETTER_THA = 0xA8A2;
const char32_t SAURASHTRA_LETTER_DA = 0xA8A3;
const char32_t SAURASHTRA_LETTER_DHA = 0xA8A4;
const char32_t SAURASHTRA_LETTER_NA = 0xA8A5;
const char32_t SAURASHTRA_LETTER_PA = 0xA8A6;
const char32_t SAURASHTRA_LETTER_PHA = 0xA8A7;
const char32_t SAURASHTRA_LETTER_BA = 0xA8A8;
const char32_t SAURASHTRA_LETTER_BHA = 0xA8A9;
const char32_t SAURASHTRA_LETTER_MA = 0xA8AA;
const char32_t SAURASHTRA_LETTER_YA = 0xA8AB;
const char32_t SAURASHTRA_LETTER_RA = 0xA8AC;
const char32_t SAURASHTRA_LETTER_LA = 0xA8AD;
const char32_t SAURASHTRA_LETTER_VA = 0xA8AE;
const char32_t SAURASHTRA_LETTER_SHA = 0xA8AF;
const char32_t SAURASHTRA_LETTER_SSA = 0xA8B0;
const char32_t SAURASHTRA_LETTER_SA = 0xA8B1;
const char32_t SAURASHTRA_LETTER_HA = 0xA8B2;
const char32_t SAURASHTRA_LETTER_LLA = 0xA8B3;
const char32_t SAURASHTRA_CONSONANT_SIGN_HAARU = 0xA8B4;
const char32_t SAURASHTRA_VOWEL_SIGN_AA = 0xA8B5;
const char32_t SAURASHTRA_VOWEL_SIGN_I = 0xA8B6;
const char32_t SAURASHTRA_VOWEL_SIGN_II = 0xA8B7;
const char32_t SAURASHTRA_VOWEL_SIGN_U = 0xA8B8;
const char32_t SAURASHTRA_VOWEL_SIGN_UU = 0xA8B9;
const char32_t SAURASHTRA_VOWEL_SIGN_VOCALIC_R = 0xA8BA;
const char32_t SAURASHTRA_VOWEL_SIGN_VOCALIC_RR = 0xA8BB;
const char32_t SAURASHTRA_VOWEL_SIGN_VOCALIC_L = 0xA8BC;
const char32_t SAURASHTRA_VOWEL_SIGN_VOCALIC_LL = 0xA8BD;
const char32_t SAURASHTRA_VOWEL_SIGN_E = 0xA8BE;
const char32_t SAURASHTRA_VOWEL_SIGN_EE = 0xA8BF;
const char32_t SAURASHTRA_VOWEL_SIGN_AI = 0xA8C0;
const char32_t SAURASHTRA_VOWEL_SIGN_O = 0xA8C1;
const char32_t SAURASHTRA_VOWEL_SIGN_OO = 0xA8C2;
const char32_t SAURASHTRA_VOWEL_SIGN_AU = 0xA8C3;
const char32_t SAURASHTRA_SIGN_VIRAMA = 0xA8C4;
const char32_t SAURASHTRA_SIGN_CANDRABINDU = 0xA8C5;
const char32_t SAURASHTRA_DANDA = 0xA8CE;
const char32_t SAURASHTRA_DOUBLE_DANDA = 0xA8CF;
const char32_t SAURASHTRA_DIGIT_ZERO = 0xA8D0;
const char32_t SAURASHTRA_DIGIT_ONE = 0xA8D1;
const char32_t SAURASHTRA_DIGIT_TWO = 0xA8D2;
const char32_t SAURASHTRA_DIGIT_THREE = 0xA8D3;
const char32_t SAURASHTRA_DIGIT_FOUR = 0xA8D4;
const char32_t SAURASHTRA_DIGIT_FIVE = 0xA8D5;
const char32_t SAURASHTRA_DIGIT_SIX = 0xA8D6;
const char32_t SAURASHTRA_DIGIT_SEVEN = 0xA8D7;
const char32_t SAURASHTRA_DIGIT_EIGHT = 0xA8D8;
const char32_t SAURASHTRA_DIGIT_NINE = 0xA8D9;
const char32_t COMBINING_DEVANAGARI_DIGIT_ZERO = 0xA8E0;
const char32_t COMBINING_DEVANAGARI_DIGIT_ONE = 0xA8E1;
const char32_t COMBINING_DEVANAGARI_DIGIT_TWO = 0xA8E2;
const char32_t COMBINING_DEVANAGARI_DIGIT_THREE = 0xA8E3;
const char32_t COMBINING_DEVANAGARI_DIGIT_FOUR = 0xA8E4;
const char32_t COMBINING_DEVANAGARI_DIGIT_FIVE = 0xA8E5;
const char32_t COMBINING_DEVANAGARI_DIGIT_SIX = 0xA8E6;
const char32_t COMBINING_DEVANAGARI_DIGIT_SEVEN = 0xA8E7;
const char32_t COMBINING_DEVANAGARI_DIGIT_EIGHT = 0xA8E8;
const char32_t COMBINING_DEVANAGARI_DIGIT_NINE = 0xA8E9;
const char32_t COMBINING_DEVANAGARI_LETTER_A = 0xA8EA;
const char32_t COMBINING_DEVANAGARI_LETTER_U = 0xA8EB;
const char32_t COMBINING_DEVANAGARI_LETTER_KA = 0xA8EC;
const char32_t COMBINING_DEVANAGARI_LETTER_NA = 0xA8ED;
const char32_t COMBINING_DEVANAGARI_LETTER_PA = 0xA8EE;
const char32_t COMBINING_DEVANAGARI_LETTER_RA = 0xA8EF;
const char32_t COMBINING_DEVANAGARI_LETTER_VI = 0xA8F0;
const char32_t COMBINING_DEVANAGARI_SIGN_AVAGRAHA = 0xA8F1;
const char32_t DEVANAGARI_SIGN_SPACING_CANDRABINDU = 0xA8F2;
const char32_t DEVANAGARI_SIGN_CANDRABINDU_VIRAMA = 0xA8F3;
const char32_t DEVANAGARI_SIGN_DOUBLE_CANDRABINDU_VIRAMA = 0xA8F4;
const char32_t DEVANAGARI_SIGN_CANDRABINDU_TWO = 0xA8F5;
const char32_t DEVANAGARI_SIGN_CANDRABINDU_THREE = 0xA8F6;
const char32_t DEVANAGARI_SIGN_CANDRABINDU_AVAGRAHA = 0xA8F7;
const char32_t DEVANAGARI_SIGN_PUSHPIKA = 0xA8F8;
const char32_t DEVANAGARI_GAP_FILLER = 0xA8F9;
const char32_t DEVANAGARI_CARET = 0xA8FA;
const char32_t DEVANAGARI_HEADSTROKE = 0xA8FB;
const char32_t DEVANAGARI_SIGN_SIDDHAM = 0xA8FC;
const char32_t DEVANAGARI_JAIN_OM = 0xA8FD;
const char32_t DEVANAGARI_LETTER_AY = 0xA8FE;
const char32_t DEVANAGARI_VOWEL_SIGN_AY = 0xA8FF;
const char32_t KAYAH_LI_DIGIT_ZERO = 0xA900;
const char32_t KAYAH_LI_DIGIT_ONE = 0xA901;
const char32_t KAYAH_LI_DIGIT_TWO = 0xA902;
const char32_t KAYAH_LI_DIGIT_THREE = 0xA903;
const char32_t KAYAH_LI_DIGIT_FOUR = 0xA904;
const char32_t KAYAH_LI_DIGIT_FIVE = 0xA905;
const char32_t KAYAH_LI_DIGIT_SIX = 0xA906;
const char32_t KAYAH_LI_DIGIT_SEVEN = 0xA907;
const char32_t KAYAH_LI_DIGIT_EIGHT = 0xA908;
const char32_t KAYAH_LI_DIGIT_NINE = 0xA909;
const char32_t KAYAH_LI_LETTER_KA = 0xA90A;
const char32_t KAYAH_LI_LETTER_KHA = 0xA90B;
const char32_t KAYAH_LI_LETTER_GA = 0xA90C;
const char32_t KAYAH_LI_LETTER_NGA = 0xA90D;
const char32_t KAYAH_LI_LETTER_SA = 0xA90E;
const char32_t KAYAH_LI_LETTER_SHA = 0xA90F;
const char32_t KAYAH_LI_LETTER_ZA = 0xA910;
const char32_t KAYAH_LI_LETTER_NYA = 0xA911;
const char32_t KAYAH_LI_LETTER_TA = 0xA912;
const char32_t KAYAH_LI_LETTER_HTA = 0xA913;
const char32_t KAYAH_LI_LETTER_NA = 0xA914;
const char32_t KAYAH_LI_LETTER_PA = 0xA915;
const char32_t KAYAH_LI_LETTER_PHA = 0xA916;
const char32_t KAYAH_LI_LETTER_MA = 0xA917;
const char32_t KAYAH_LI_LETTER_DA = 0xA918;
const char32_t KAYAH_LI_LETTER_BA = 0xA919;
const char32_t KAYAH_LI_LETTER_RA = 0xA91A;
const char32_t KAYAH_LI_LETTER_YA = 0xA91B;
const char32_t KAYAH_LI_LETTER_LA = 0xA91C;
const char32_t KAYAH_LI_LETTER_WA = 0xA91D;
const char32_t KAYAH_LI_LETTER_THA = 0xA91E;
const char32_t KAYAH_LI_LETTER_HA = 0xA91F;
const char32_t KAYAH_LI_LETTER_VA = 0xA920;
const char32_t KAYAH_LI_LETTER_CA = 0xA921;
const char32_t KAYAH_LI_LETTER_A = 0xA922;
const char32_t KAYAH_LI_LETTER_OE = 0xA923;
const char32_t KAYAH_LI_LETTER_I = 0xA924;
const char32_t KAYAH_LI_LETTER_OO = 0xA925;
const char32_t KAYAH_LI_VOWEL_UE = 0xA926;
const char32_t KAYAH_LI_VOWEL_E = 0xA927;
const char32_t KAYAH_LI_VOWEL_U = 0xA928;
const char32_t KAYAH_LI_VOWEL_EE = 0xA929;
const char32_t KAYAH_LI_VOWEL_O = 0xA92A;
const char32_t KAYAH_LI_TONE_PLOPHU = 0xA92B;
const char32_t KAYAH_LI_TONE_CALYA = 0xA92C;
const char32_t KAYAH_LI_TONE_CALYA_PLOPHU = 0xA92D;
const char32_t KAYAH_LI_SIGN_CWI = 0xA92E;
const char32_t KAYAH_LI_SIGN_SHYA = 0xA92F;
const char32_t REJANG_LETTER_KA = 0xA930;
const char32_t REJANG_LETTER_GA = 0xA931;
const char32_t REJANG_LETTER_NGA = 0xA932;
const char32_t REJANG_LETTER_TA = 0xA933;
const char32_t REJANG_LETTER_DA = 0xA934;
const char32_t REJANG_LETTER_NA = 0xA935;
const char32_t REJANG_LETTER_PA = 0xA936;
const char32_t REJANG_LETTER_BA = 0xA937;
const char32_t REJANG_LETTER_MA = 0xA938;
const char32_t REJANG_LETTER_CA = 0xA939;
const char32_t REJANG_LETTER_JA = 0xA93A;
const char32_t REJANG_LETTER_NYA = 0xA93B;
const char32_t REJANG_LETTER_SA = 0xA93C;
const char32_t REJANG_LETTER_RA = 0xA93D;
const char32_t REJANG_LETTER_LA = 0xA93E;
const char32_t REJANG_LETTER_YA = 0xA93F;
const char32_t REJANG_LETTER_WA = 0xA940;
const char32_t REJANG_LETTER_HA = 0xA941;
const char32_t REJANG_LETTER_MBA = 0xA942;
const char32_t REJANG_LETTER_NGGA = 0xA943;
const char32_t REJANG_LETTER_NDA = 0xA944;
const char32_t REJANG_LETTER_NYJA = 0xA945;
const char32_t REJANG_LETTER_A = 0xA946;
const char32_t REJANG_VOWEL_SIGN_I = 0xA947;
const char32_t REJANG_VOWEL_SIGN_U = 0xA948;
const char32_t REJANG_VOWEL_SIGN_E = 0xA949;
const char32_t REJANG_VOWEL_SIGN_AI = 0xA94A;
const char32_t REJANG_VOWEL_SIGN_O = 0xA94B;
const char32_t REJANG_VOWEL_SIGN_AU = 0xA94C;
const char32_t REJANG_VOWEL_SIGN_EU = 0xA94D;
const char32_t REJANG_VOWEL_SIGN_EA = 0xA94E;
const char32_t REJANG_CONSONANT_SIGN_NG = 0xA94F;
const char32_t REJANG_CONSONANT_SIGN_N = 0xA950;
const char32_t REJANG_CONSONANT_SIGN_R = 0xA951;
const char32_t REJANG_CONSONANT_SIGN_H = 0xA952;
const char32_t REJANG_VIRAMA = 0xA953;
const char32_t REJANG_SECTION_MARK = 0xA95F;
const char32_t HANGUL_CHOSEONG_TIKEUT_MIEUM = 0xA960;
const char32_t HANGUL_CHOSEONG_TIKEUT_PIEUP = 0xA961;
const char32_t HANGUL_CHOSEONG_TIKEUT_SIOS = 0xA962;
const char32_t HANGUL_CHOSEONG_TIKEUT_CIEUC = 0xA963;
const char32_t HANGUL_CHOSEONG_RIEUL_KIYEOK = 0xA964;
const char32_t HANGUL_CHOSEONG_RIEUL_SSANGKIYEOK = 0xA965;
const char32_t HANGUL_CHOSEONG_RIEUL_TIKEUT = 0xA966;
const char32_t HANGUL_CHOSEONG_RIEUL_SSANGTIKEUT = 0xA967;
const char32_t HANGUL_CHOSEONG_RIEUL_MIEUM = 0xA968;
const char32_t HANGUL_CHOSEONG_RIEUL_PIEUP = 0xA969;
const char32_t HANGUL_CHOSEONG_RIEUL_SSANGPIEUP = 0xA96A;
const char32_t HANGUL_CHOSEONG_RIEUL_KAPYEOUNPIEUP = 0xA96B;
const char32_t HANGUL_CHOSEONG_RIEUL_SIOS = 0xA96C;
const char32_t HANGUL_CHOSEONG_RIEUL_CIEUC = 0xA96D;
const char32_t HANGUL_CHOSEONG_RIEUL_KHIEUKH = 0xA96E;
const char32_t HANGUL_CHOSEONG_MIEUM_KIYEOK = 0xA96F;
const char32_t HANGUL_CHOSEONG_MIEUM_TIKEUT = 0xA970;
const char32_t HANGUL_CHOSEONG_MIEUM_SIOS = 0xA971;
const char32_t HANGUL_CHOSEONG_PIEUP_SIOS_THIEUTH = 0xA972;
const char32_t HANGUL_CHOSEONG_PIEUP_KHIEUKH = 0xA973;
const char32_t HANGUL_CHOSEONG_PIEUP_HIEUH = 0xA974;
const char32_t HANGUL_CHOSEONG_SSANGSIOS_PIEUP = 0xA975;
const char32_t HANGUL_CHOSEONG_IEUNG_RIEUL = 0xA976;
const char32_t HANGUL_CHOSEONG_IEUNG_HIEUH = 0xA977;
const char32_t HANGUL_CHOSEONG_SSANGCIEUC_HIEUH = 0xA978;
const char32_t HANGUL_CHOSEONG_SSANGTHIEUTH = 0xA979;
const char32_t HANGUL_CHOSEONG_PHIEUPH_HIEUH = 0xA97A;
const char32_t HANGUL_CHOSEONG_HIEUH_SIOS = 0xA97B;
const char32_t HANGUL_CHOSEONG_SSANGYEORINHIEUH = 0xA97C;
const char32_t JAVANESE_SIGN_PANYANGGA = 0xA980;
const char32_t JAVANESE_SIGN_CECAK = 0xA981;
const char32_t JAVANESE_SIGN_LAYAR = 0xA982;
const char32_t JAVANESE_SIGN_WIGNYAN = 0xA983;
const char32_t JAVANESE_LETTER_A = 0xA984;
const char32_t JAVANESE_LETTER_I_KAWI = 0xA985;
const char32_t JAVANESE_LETTER_I = 0xA986;
const char32_t JAVANESE_LETTER_II = 0xA987;
const char32_t JAVANESE_LETTER_U = 0xA988;
const char32_t JAVANESE_LETTER_PA_CEREK = 0xA989;
const char32_t JAVANESE_LETTER_NGA_LELET = 0xA98A;
const char32_t JAVANESE_LETTER_NGA_LELET_RASWADI = 0xA98B;
const char32_t JAVANESE_LETTER_E = 0xA98C;
const char32_t JAVANESE_LETTER_AI = 0xA98D;
const char32_t JAVANESE_LETTER_O = 0xA98E;
const char32_t JAVANESE_LETTER_KA = 0xA98F;
const char32_t JAVANESE_LETTER_KA_SASAK = 0xA990;
const char32_t JAVANESE_LETTER_KA_MURDA = 0xA991;
const char32_t JAVANESE_LETTER_GA = 0xA992;
const char32_t JAVANESE_LETTER_GA_MURDA = 0xA993;
const char32_t JAVANESE_LETTER_NGA = 0xA994;
const char32_t JAVANESE_LETTER_CA = 0xA995;
const char32_t JAVANESE_LETTER_CA_MURDA = 0xA996;
const char32_t JAVANESE_LETTER_JA = 0xA997;
const char32_t JAVANESE_LETTER_NYA_MURDA = 0xA998;
const char32_t JAVANESE_LETTER_JA_MAHAPRANA = 0xA999;
const char32_t JAVANESE_LETTER_NYA = 0xA99A;
const char32_t JAVANESE_LETTER_TTA = 0xA99B;
const char32_t JAVANESE_LETTER_TTA_MAHAPRANA = 0xA99C;
const char32_t JAVANESE_LETTER_DDA = 0xA99D;
const char32_t JAVANESE_LETTER_DDA_MAHAPRANA = 0xA99E;
const char32_t JAVANESE_LETTER_NA_MURDA = 0xA99F;
const char32_t JAVANESE_LETTER_TA = 0xA9A0;
const char32_t JAVANESE_LETTER_TA_MURDA = 0xA9A1;
const char32_t JAVANESE_LETTER_DA = 0xA9A2;
const char32_t JAVANESE_LETTER_DA_MAHAPRANA = 0xA9A3;
const char32_t JAVANESE_LETTER_NA = 0xA9A4;
const char32_t JAVANESE_LETTER_PA = 0xA9A5;
const char32_t JAVANESE_LETTER_PA_MURDA = 0xA9A6;
const char32_t JAVANESE_LETTER_BA = 0xA9A7;
const char32_t JAVANESE_LETTER_BA_MURDA = 0xA9A8;
const char32_t JAVANESE_LETTER_MA = 0xA9A9;
const char32_t JAVANESE_LETTER_YA = 0xA9AA;
const char32_t JAVANESE_LETTER_RA = 0xA9AB;
const char32_t JAVANESE_LETTER_RA_AGUNG = 0xA9AC;
const char32_t JAVANESE_LETTER_LA = 0xA9AD;
const char32_t JAVANESE_LETTER_WA = 0xA9AE;
const char32_t JAVANESE_LETTER_SA_MURDA = 0xA9AF;
const char32_t JAVANESE_LETTER_SA_MAHAPRANA = 0xA9B0;
const char32_t JAVANESE_LETTER_SA = 0xA9B1;
const char32_t JAVANESE_LETTER_HA = 0xA9B2;
const char32_t JAVANESE_SIGN_CECAK_TELU = 0xA9B3;
const char32_t JAVANESE_VOWEL_SIGN_TARUNG = 0xA9B4;
const char32_t JAVANESE_VOWEL_SIGN_TOLONG = 0xA9B5;
const char32_t JAVANESE_VOWEL_SIGN_WULU = 0xA9B6;
const char32_t JAVANESE_VOWEL_SIGN_WULU_MELIK = 0xA9B7;
const char32_t JAVANESE_VOWEL_SIGN_SUKU = 0xA9B8;
const char32_t JAVANESE_VOWEL_SIGN_SUKU_MENDUT = 0xA9B9;
const char32_t JAVANESE_VOWEL_SIGN_TALING = 0xA9BA;
const char32_t JAVANESE_VOWEL_SIGN_DIRGA_MURE = 0xA9BB;
const char32_t JAVANESE_VOWEL_SIGN_PEPET = 0xA9BC;
const char32_t JAVANESE_CONSONANT_SIGN_KERET = 0xA9BD;
const char32_t JAVANESE_CONSONANT_SIGN_PENGKAL = 0xA9BE;
const char32_t JAVANESE_CONSONANT_SIGN_CAKRA = 0xA9BF;
const char32_t JAVANESE_PANGKON = 0xA9C0;
const char32_t JAVANESE_LEFT_RERENGGAN = 0xA9C1;
const char32_t JAVANESE_RIGHT_RERENGGAN = 0xA9C2;
const char32_t JAVANESE_PADA_ANDAP = 0xA9C3;
const char32_t JAVANESE_PADA_MADYA = 0xA9C4;
const char32_t JAVANESE_PADA_LUHUR = 0xA9C5;
const char32_t JAVANESE_PADA_WINDU = 0xA9C6;
const char32_t JAVANESE_PADA_PANGKAT = 0xA9C7;
const char32_t JAVANESE_PADA_LINGSA = 0xA9C8;
const char32_t JAVANESE_PADA_LUNGSI = 0xA9C9;
const char32_t JAVANESE_PADA_ADEG = 0xA9CA;
const char32_t JAVANESE_PADA_ADEG_ADEG = 0xA9CB;
const char32_t JAVANESE_PADA_PISELEH = 0xA9CC;
const char32_t JAVANESE_TURNED_PADA_PISELEH = 0xA9CD;
const char32_t JAVANESE_PANGRANGKEP = 0xA9CF;
const char32_t JAVANESE_DIGIT_ZERO = 0xA9D0;
const char32_t JAVANESE_DIGIT_ONE = 0xA9D1;
const char32_t JAVANESE_DIGIT_TWO = 0xA9D2;
const char32_t JAVANESE_DIGIT_THREE = 0xA9D3;
const char32_t JAVANESE_DIGIT_FOUR = 0xA9D4;
const char32_t JAVANESE_DIGIT_FIVE = 0xA9D5;
const char32_t JAVANESE_DIGIT_SIX = 0xA9D6;
const char32_t JAVANESE_DIGIT_SEVEN = 0xA9D7;
const char32_t JAVANESE_DIGIT_EIGHT = 0xA9D8;
const char32_t JAVANESE_DIGIT_NINE = 0xA9D9;
const char32_t JAVANESE_PADA_TIRTA_TUMETES = 0xA9DE;
const char32_t JAVANESE_PADA_ISEN_ISEN = 0xA9DF;
const char32_t MYANMAR_LETTER_SHAN_GHA = 0xA9E0;
const char32_t MYANMAR_LETTER_SHAN_CHA = 0xA9E1;
const char32_t MYANMAR_LETTER_SHAN_JHA = 0xA9E2;
const char32_t MYANMAR_LETTER_SHAN_NNA = 0xA9E3;
const char32_t MYANMAR_LETTER_SHAN_BHA = 0xA9E4;
const char32_t MYANMAR_SIGN_SHAN_SAW = 0xA9E5;
const char32_t MYANMAR_MODIFIER_LETTER_SHAN_REDUPLICATION = 0xA9E6;
const char32_t MYANMAR_LETTER_TAI_LAING_NYA = 0xA9E7;
const char32_t MYANMAR_LETTER_TAI_LAING_FA = 0xA9E8;
const char32_t MYANMAR_LETTER_TAI_LAING_GA = 0xA9E9;
const char32_t MYANMAR_LETTER_TAI_LAING_GHA = 0xA9EA;
const char32_t MYANMAR_LETTER_TAI_LAING_JA = 0xA9EB;
const char32_t MYANMAR_LETTER_TAI_LAING_JHA = 0xA9EC;
const char32_t MYANMAR_LETTER_TAI_LAING_DDA = 0xA9ED;
const char32_t MYANMAR_LETTER_TAI_LAING_DDHA = 0xA9EE;
const char32_t MYANMAR_LETTER_TAI_LAING_NNA = 0xA9EF;
const char32_t MYANMAR_TAI_LAING_DIGIT_ZERO = 0xA9F0;
const char32_t MYANMAR_TAI_LAING_DIGIT_ONE = 0xA9F1;
const char32_t MYANMAR_TAI_LAING_DIGIT_TWO = 0xA9F2;
const char32_t MYANMAR_TAI_LAING_DIGIT_THREE = 0xA9F3;
const char32_t MYANMAR_TAI_LAING_DIGIT_FOUR = 0xA9F4;
const char32_t MYANMAR_TAI_LAING_DIGIT_FIVE = 0xA9F5;
const char32_t MYANMAR_TAI_LAING_DIGIT_SIX = 0xA9F6;
const char32_t MYANMAR_TAI_LAING_DIGIT_SEVEN = 0xA9F7;
const char32_t MYANMAR_TAI_LAING_DIGIT_EIGHT = 0xA9F8;
const char32_t MYANMAR_TAI_LAING_DIGIT_NINE = 0xA9F9;
const char32_t MYANMAR_LETTER_TAI_LAING_LLA = 0xA9FA;
const char32_t MYANMAR_LETTER_TAI_LAING_DA = 0xA9FB;
const char32_t MYANMAR_LETTER_TAI_LAING_DHA = 0xA9FC;
const char32_t MYANMAR_LETTER_TAI_LAING_BA = 0xA9FD;
const char32_t MYANMAR_LETTER_TAI_LAING_BHA = 0xA9FE;
const char32_t CHAM_LETTER_A = 0xAA00;
const char32_t CHAM_LETTER_I = 0xAA01;
const char32_t CHAM_LETTER_U = 0xAA02;
const char32_t CHAM_LETTER_E = 0xAA03;
const char32_t CHAM_LETTER_AI = 0xAA04;
const char32_t CHAM_LETTER_O = 0xAA05;
const char32_t CHAM_LETTER_KA = 0xAA06;
const char32_t CHAM_LETTER_KHA = 0xAA07;
const char32_t CHAM_LETTER_GA = 0xAA08;
const char32_t CHAM_LETTER_GHA = 0xAA09;
const char32_t CHAM_LETTER_NGUE = 0xAA0A;
const char32_t CHAM_LETTER_NGA = 0xAA0B;
const char32_t CHAM_LETTER_CHA = 0xAA0C;
const char32_t CHAM_LETTER_CHHA = 0xAA0D;
const char32_t CHAM_LETTER_JA = 0xAA0E;
const char32_t CHAM_LETTER_JHA = 0xAA0F;
const char32_t CHAM_LETTER_NHUE = 0xAA10;
const char32_t CHAM_LETTER_NHA = 0xAA11;
const char32_t CHAM_LETTER_NHJA = 0xAA12;
const char32_t CHAM_LETTER_TA = 0xAA13;
const char32_t CHAM_LETTER_THA = 0xAA14;
const char32_t CHAM_LETTER_DA = 0xAA15;
const char32_t CHAM_LETTER_DHA = 0xAA16;
const char32_t CHAM_LETTER_NUE = 0xAA17;
const char32_t CHAM_LETTER_NA = 0xAA18;
const char32_t CHAM_LETTER_DDA = 0xAA19;
const char32_t CHAM_LETTER_PA = 0xAA1A;
const char32_t CHAM_LETTER_PPA = 0xAA1B;
const char32_t CHAM_LETTER_PHA = 0xAA1C;
const char32_t CHAM_LETTER_BA = 0xAA1D;
const char32_t CHAM_LETTER_BHA = 0xAA1E;
const char32_t CHAM_LETTER_MUE = 0xAA1F;
const char32_t CHAM_LETTER_MA = 0xAA20;
const char32_t CHAM_LETTER_BBA = 0xAA21;
const char32_t CHAM_LETTER_YA = 0xAA22;
const char32_t CHAM_LETTER_RA = 0xAA23;
const char32_t CHAM_LETTER_LA = 0xAA24;
const char32_t CHAM_LETTER_VA = 0xAA25;
const char32_t CHAM_LETTER_SSA = 0xAA26;
const char32_t CHAM_LETTER_SA = 0xAA27;
const char32_t CHAM_LETTER_HA = 0xAA28;
const char32_t CHAM_VOWEL_SIGN_AA = 0xAA29;
const char32_t CHAM_VOWEL_SIGN_I = 0xAA2A;
const char32_t CHAM_VOWEL_SIGN_II = 0xAA2B;
const char32_t CHAM_VOWEL_SIGN_EI = 0xAA2C;
const char32_t CHAM_VOWEL_SIGN_U = 0xAA2D;
const char32_t CHAM_VOWEL_SIGN_OE = 0xAA2E;
const char32_t CHAM_VOWEL_SIGN_O = 0xAA2F;
const char32_t CHAM_VOWEL_SIGN_AI = 0xAA30;
const char32_t CHAM_VOWEL_SIGN_AU = 0xAA31;
const char32_t CHAM_VOWEL_SIGN_UE = 0xAA32;
const char32_t CHAM_CONSONANT_SIGN_YA = 0xAA33;
const char32_t CHAM_CONSONANT_SIGN_RA = 0xAA34;
const char32_t CHAM_CONSONANT_SIGN_LA = 0xAA35;
const char32_t CHAM_CONSONANT_SIGN_WA = 0xAA36;
const char32_t CHAM_LETTER_FINAL_K = 0xAA40;
const char32_t CHAM_LETTER_FINAL_G = 0xAA41;
const char32_t CHAM_LETTER_FINAL_NG = 0xAA42;
const char32_t CHAM_CONSONANT_SIGN_FINAL_NG = 0xAA43;
const char32_t CHAM_LETTER_FINAL_CH = 0xAA44;
const char32_t CHAM_LETTER_FINAL_T = 0xAA45;
const char32_t CHAM_LETTER_FINAL_N = 0xAA46;
const char32_t CHAM_LETTER_FINAL_P = 0xAA47;
const char32_t CHAM_LETTER_FINAL_Y = 0xAA48;
const char32_t CHAM_LETTER_FINAL_R = 0xAA49;
const char32_t CHAM_LETTER_FINAL_L = 0xAA4A;
const char32_t CHAM_LETTER_FINAL_SS = 0xAA4B;
const char32_t CHAM_CONSONANT_SIGN_FINAL_M = 0xAA4C;
const char32_t CHAM_CONSONANT_SIGN_FINAL_H = 0xAA4D;
const char32_t CHAM_DIGIT_ZERO = 0xAA50;
const char32_t CHAM_DIGIT_ONE = 0xAA51;
const char32_t CHAM_DIGIT_TWO = 0xAA52;
const char32_t CHAM_DIGIT_THREE = 0xAA53;
const char32_t CHAM_DIGIT_FOUR = 0xAA54;
const char32_t CHAM_DIGIT_FIVE = 0xAA55;
const char32_t CHAM_DIGIT_SIX = 0xAA56;
const char32_t CHAM_DIGIT_SEVEN = 0xAA57;
const char32_t CHAM_DIGIT_EIGHT = 0xAA58;
const char32_t CHAM_DIGIT_NINE = 0xAA59;
const char32_t CHAM_PUNCTUATION_SPIRAL = 0xAA5C;
const char32_t CHAM_PUNCTUATION_DANDA = 0xAA5D;
const char32_t CHAM_PUNCTUATION_DOUBLE_DANDA = 0xAA5E;
const char32_t CHAM_PUNCTUATION_TRIPLE_DANDA = 0xAA5F;
const char32_t MYANMAR_LETTER_KHAMTI_GA = 0xAA60;
const char32_t MYANMAR_LETTER_KHAMTI_CA = 0xAA61;
const char32_t MYANMAR_LETTER_KHAMTI_CHA = 0xAA62;
const char32_t MYANMAR_LETTER_KHAMTI_JA = 0xAA63;
const char32_t MYANMAR_LETTER_KHAMTI_JHA = 0xAA64;
const char32_t MYANMAR_LETTER_KHAMTI_NYA = 0xAA65;
const char32_t MYANMAR_LETTER_KHAMTI_TTA = 0xAA66;
const char32_t MYANMAR_LETTER_KHAMTI_TTHA = 0xAA67;
const char32_t MYANMAR_LETTER_KHAMTI_DDA = 0xAA68;
const char32_t MYANMAR_LETTER_KHAMTI_DDHA = 0xAA69;
const char32_t MYANMAR_LETTER_KHAMTI_DHA = 0xAA6A;
const char32_t MYANMAR_LETTER_KHAMTI_NA = 0xAA6B;
const char32_t MYANMAR_LETTER_KHAMTI_SA = 0xAA6C;
const char32_t MYANMAR_LETTER_KHAMTI_HA = 0xAA6D;
const char32_t MYANMAR_LETTER_KHAMTI_HHA = 0xAA6E;
const char32_t MYANMAR_LETTER_KHAMTI_FA = 0xAA6F;
const char32_t MYANMAR_MODIFIER_LETTER_KHAMTI_REDUPLICATION = 0xAA70;
const char32_t MYANMAR_LETTER_KHAMTI_XA = 0xAA71;
const char32_t MYANMAR_LETTER_KHAMTI_ZA = 0xAA72;
const char32_t MYANMAR_LETTER_KHAMTI_RA = 0xAA73;
const char32_t MYANMAR_LOGOGRAM_KHAMTI_OAY = 0xAA74;
const char32_t MYANMAR_LOGOGRAM_KHAMTI_QN = 0xAA75;
const char32_t MYANMAR_LOGOGRAM_KHAMTI_HM = 0xAA76;
const char32_t MYANMAR_SYMBOL_AITON_EXCLAMATION = 0xAA77;
const char32_t MYANMAR_SYMBOL_AITON_ONE = 0xAA78;
const char32_t MYANMAR_SYMBOL_AITON_TWO = 0xAA79;
const char32_t MYANMAR_LETTER_AITON_RA = 0xAA7A;
const char32_t MYANMAR_SIGN_PAO_KAREN_TONE = 0xAA7B;
const char32_t MYANMAR_SIGN_TAI_LAING_TONE_2 = 0xAA7C;
const char32_t MYANMAR_SIGN_TAI_LAING_TONE_5 = 0xAA7D;
const char32_t MYANMAR_LETTER_SHWE_PALAUNG_CHA = 0xAA7E;
const char32_t MYANMAR_LETTER_SHWE_PALAUNG_SHA = 0xAA7F;
const char32_t TAI_VIET_LETTER_LOW_KO = 0xAA80;
const char32_t TAI_VIET_LETTER_HIGH_KO = 0xAA81;
const char32_t TAI_VIET_LETTER_LOW_KHO = 0xAA82;
const char32_t TAI_VIET_LETTER_HIGH_KHO = 0xAA83;
const char32_t TAI_VIET_LETTER_LOW_KHHO = 0xAA84;
const char32_t TAI_VIET_LETTER_HIGH_KHHO = 0xAA85;
const char32_t TAI_VIET_LETTER_LOW_GO = 0xAA86;
const char32_t TAI_VIET_LETTER_HIGH_GO = 0xAA87;
const char32_t TAI_VIET_LETTER_LOW_NGO = 0xAA88;
const char32_t TAI_VIET_LETTER_HIGH_NGO = 0xAA89;
const char32_t TAI_VIET_LETTER_LOW_CO = 0xAA8A;
const char32_t TAI_VIET_LETTER_HIGH_CO = 0xAA8B;
const char32_t TAI_VIET_LETTER_LOW_CHO = 0xAA8C;
const char32_t TAI_VIET_LETTER_HIGH_CHO = 0xAA8D;
const char32_t TAI_VIET_LETTER_LOW_SO = 0xAA8E;
const char32_t TAI_VIET_LETTER_HIGH_SO = 0xAA8F;
const char32_t TAI_VIET_LETTER_LOW_NYO = 0xAA90;
const char32_t TAI_VIET_LETTER_HIGH_NYO = 0xAA91;
const char32_t TAI_VIET_LETTER_LOW_DO = 0xAA92;
const char32_t TAI_VIET_LETTER_HIGH_DO = 0xAA93;
const char32_t TAI_VIET_LETTER_LOW_TO = 0xAA94;
const char32_t TAI_VIET_LETTER_HIGH_TO = 0xAA95;
const char32_t TAI_VIET_LETTER_LOW_THO = 0xAA96;
const char32_t TAI_VIET_LETTER_HIGH_THO = 0xAA97;
const char32_t TAI_VIET_LETTER_LOW_NO = 0xAA98;
const char32_t TAI_VIET_LETTER_HIGH_NO = 0xAA99;
const char32_t TAI_VIET_LETTER_LOW_BO = 0xAA9A;
const char32_t TAI_VIET_LETTER_HIGH_BO = 0xAA9B;
const char32_t TAI_VIET_LETTER_LOW_PO = 0xAA9C;
const char32_t TAI_VIET_LETTER_HIGH_PO = 0xAA9D;
const char32_t TAI_VIET_LETTER_LOW_PHO = 0xAA9E;
const char32_t TAI_VIET_LETTER_HIGH_PHO = 0xAA9F;
const char32_t TAI_VIET_LETTER_LOW_FO = 0xAAA0;
const char32_t TAI_VIET_LETTER_HIGH_FO = 0xAAA1;
const char32_t TAI_VIET_LETTER_LOW_MO = 0xAAA2;
const char32_t TAI_VIET_LETTER_HIGH_MO = 0xAAA3;
const char32_t TAI_VIET_LETTER_LOW_YO = 0xAAA4;
const char32_t TAI_VIET_LETTER_HIGH_YO = 0xAAA5;
const char32_t TAI_VIET_LETTER_LOW_RO = 0xAAA6;
const char32_t TAI_VIET_LETTER_HIGH_RO = 0xAAA7;
const char32_t TAI_VIET_LETTER_LOW_LO = 0xAAA8;
const char32_t TAI_VIET_LETTER_HIGH_LO = 0xAAA9;
const char32_t TAI_VIET_LETTER_LOW_VO = 0xAAAA;
const char32_t TAI_VIET_LETTER_HIGH_VO = 0xAAAB;
const char32_t TAI_VIET_LETTER_LOW_HO = 0xAAAC;
const char32_t TAI_VIET_LETTER_HIGH_HO = 0xAAAD;
const char32_t TAI_VIET_LETTER_LOW_O = 0xAAAE;
const char32_t TAI_VIET_LETTER_HIGH_O = 0xAAAF;
const char32_t TAI_VIET_MAI_KANG = 0xAAB0;
const char32_t TAI_VIET_VOWEL_AA = 0xAAB1;
const char32_t TAI_VIET_VOWEL_I = 0xAAB2;
const char32_t TAI_VIET_VOWEL_UE = 0xAAB3;
const char32_t TAI_VIET_VOWEL_U = 0xAAB4;
const char32_t TAI_VIET_VOWEL_E = 0xAAB5;
const char32_t TAI_VIET_VOWEL_O = 0xAAB6;
const char32_t TAI_VIET_MAI_KHIT = 0xAAB7;
const char32_t TAI_VIET_VOWEL_IA = 0xAAB8;
const char32_t TAI_VIET_VOWEL_UEA = 0xAAB9;
const char32_t TAI_VIET_VOWEL_UA = 0xAABA;
const char32_t TAI_VIET_VOWEL_AUE = 0xAABB;
const char32_t TAI_VIET_VOWEL_AY = 0xAABC;
const char32_t TAI_VIET_VOWEL_AN = 0xAABD;
const char32_t TAI_VIET_VOWEL_AM = 0xAABE;
const char32_t TAI_VIET_TONE_MAI_EK = 0xAABF;
const char32_t TAI_VIET_TONE_MAI_NUENG = 0xAAC0;
const char32_t TAI_VIET_TONE_MAI_THO = 0xAAC1;
const char32_t TAI_VIET_TONE_MAI_SONG = 0xAAC2;
const char32_t TAI_VIET_SYMBOL_KON = 0xAADB;
const char32_t TAI_VIET_SYMBOL_NUENG = 0xAADC;
const char32_t TAI_VIET_SYMBOL_SAM = 0xAADD;
const char32_t TAI_VIET_SYMBOL_HO_HOI = 0xAADE;
const char32_t TAI_VIET_SYMBOL_KOI_KOI = 0xAADF;
const char32_t MEETEI_MAYEK_LETTER_E = 0xAAE0;
const char32_t MEETEI_MAYEK_LETTER_O = 0xAAE1;
const char32_t MEETEI_MAYEK_LETTER_CHA = 0xAAE2;
const char32_t MEETEI_MAYEK_LETTER_NYA = 0xAAE3;
const char32_t MEETEI_MAYEK_LETTER_TTA = 0xAAE4;
const char32_t MEETEI_MAYEK_LETTER_TTHA = 0xAAE5;
const char32_t MEETEI_MAYEK_LETTER_DDA = 0xAAE6;
const char32_t MEETEI_MAYEK_LETTER_DDHA = 0xAAE7;
const char32_t MEETEI_MAYEK_LETTER_NNA = 0xAAE8;
const char32_t MEETEI_MAYEK_LETTER_SHA = 0xAAE9;
const char32_t MEETEI_MAYEK_LETTER_SSA = 0xAAEA;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_II = 0xAAEB;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_UU = 0xAAEC;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_AAI = 0xAAED;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_AU = 0xAAEE;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_AAU = 0xAAEF;
const char32_t MEETEI_MAYEK_CHEIKHAN = 0xAAF0;
const char32_t MEETEI_MAYEK_AHANG_KHUDAM = 0xAAF1;
const char32_t MEETEI_MAYEK_ANJI = 0xAAF2;
const char32_t MEETEI_MAYEK_SYLLABLE_REPETITION_MARK = 0xAAF3;
const char32_t MEETEI_MAYEK_WORD_REPETITION_MARK = 0xAAF4;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_VISARGA = 0xAAF5;
const char32_t MEETEI_MAYEK_VIRAMA = 0xAAF6;
const char32_t ETHIOPIC_SYLLABLE_TTHU = 0xAB01;
const char32_t ETHIOPIC_SYLLABLE_TTHI = 0xAB02;
const char32_t ETHIOPIC_SYLLABLE_TTHAA = 0xAB03;
const char32_t ETHIOPIC_SYLLABLE_TTHEE = 0xAB04;
const char32_t ETHIOPIC_SYLLABLE_TTHE = 0xAB05;
const char32_t ETHIOPIC_SYLLABLE_TTHO = 0xAB06;
const char32_t ETHIOPIC_SYLLABLE_DDHU = 0xAB09;
const char32_t ETHIOPIC_SYLLABLE_DDHI = 0xAB0A;
const char32_t ETHIOPIC_SYLLABLE_DDHAA = 0xAB0B;
const char32_t ETHIOPIC_SYLLABLE_DDHEE = 0xAB0C;
const char32_t ETHIOPIC_SYLLABLE_DDHE = 0xAB0D;
const char32_t ETHIOPIC_SYLLABLE_DDHO = 0xAB0E;
const char32_t ETHIOPIC_SYLLABLE_DZU = 0xAB11;
const char32_t ETHIOPIC_SYLLABLE_DZI = 0xAB12;
const char32_t ETHIOPIC_SYLLABLE_DZAA = 0xAB13;
const char32_t ETHIOPIC_SYLLABLE_DZEE = 0xAB14;
const char32_t ETHIOPIC_SYLLABLE_DZE = 0xAB15;
const char32_t ETHIOPIC_SYLLABLE_DZO = 0xAB16;
const char32_t ETHIOPIC_SYLLABLE_CCHHA = 0xAB20;
const char32_t ETHIOPIC_SYLLABLE_CCHHU = 0xAB21;
const char32_t ETHIOPIC_SYLLABLE_CCHHI = 0xAB22;
const char32_t ETHIOPIC_SYLLABLE_CCHHAA = 0xAB23;
const char32_t ETHIOPIC_SYLLABLE_CCHHEE = 0xAB24;
const char32_t ETHIOPIC_SYLLABLE_CCHHE = 0xAB25;
const char32_t ETHIOPIC_SYLLABLE_CCHHO = 0xAB26;
const char32_t ETHIOPIC_SYLLABLE_BBA = 0xAB28;
const char32_t ETHIOPIC_SYLLABLE_BBU = 0xAB29;
const char32_t ETHIOPIC_SYLLABLE_BBI = 0xAB2A;
const char32_t ETHIOPIC_SYLLABLE_BBAA = 0xAB2B;
const char32_t ETHIOPIC_SYLLABLE_BBEE = 0xAB2C;
const char32_t ETHIOPIC_SYLLABLE_BBE = 0xAB2D;
const char32_t ETHIOPIC_SYLLABLE_BBO = 0xAB2E;
const char32_t LATIN_SMALL_LETTER_BARRED_ALPHA = 0xAB30;
const char32_t LATIN_SMALL_LETTER_A_REVERSED_SCHWA = 0xAB31;
const char32_t LATIN_SMALL_LETTER_BLACKLETTER_E = 0xAB32;
const char32_t LATIN_SMALL_LETTER_BARRED_E = 0xAB33;
const char32_t LATIN_SMALL_LETTER_E_WITH_FLOURISH = 0xAB34;
const char32_t LATIN_SMALL_LETTER_LENIS_F = 0xAB35;
const char32_t LATIN_SMALL_LETTER_SCRIPT_G_WITH_CROSSED_TAIL = 0xAB36;
const char32_t LATIN_SMALL_LETTER_L_WITH_INVERTED_LAZY_S = 0xAB37;
const char32_t LATIN_SMALL_LETTER_L_WITH_DOUBLE_MIDDLE_TILDE = 0xAB38;
const char32_t LATIN_SMALL_LETTER_L_WITH_MIDDLE_RING = 0xAB39;
const char32_t LATIN_SMALL_LETTER_M_WITH_CROSSED_TAIL = 0xAB3A;
const char32_t LATIN_SMALL_LETTER_N_WITH_CROSSED_TAIL = 0xAB3B;
const char32_t LATIN_SMALL_LETTER_ENG_WITH_CROSSED_TAIL = 0xAB3C;
const char32_t LATIN_SMALL_LETTER_BLACKLETTER_O = 0xAB3D;
const char32_t LATIN_SMALL_LETTER_BLACKLETTER_O_WITH_STROKE = 0xAB3E;
const char32_t LATIN_SMALL_LETTER_OPEN_O_WITH_STROKE = 0xAB3F;
const char32_t LATIN_SMALL_LETTER_INVERTED_OE = 0xAB40;
const char32_t LATIN_SMALL_LETTER_TURNED_OE_WITH_STROKE = 0xAB41;
const char32_t LATIN_SMALL_LETTER_TURNED_OE_WITH_HORIZONTAL_STROKE = 0xAB42;
const char32_t LATIN_SMALL_LETTER_TURNED_O_OPEN_O = 0xAB43;
const char32_t LATIN_SMALL_LETTER_TURNED_O_OPEN_O_WITH_STROKE = 0xAB44;
const char32_t LATIN_SMALL_LETTER_STIRRUP_R = 0xAB45;
const char32_t LATIN_LETTER_SMALL_CAPITAL_R_WITH_RIGHT_LEG = 0xAB46;
const char32_t LATIN_SMALL_LETTER_R_WITHOUT_HANDLE = 0xAB47;
const char32_t LATIN_SMALL_LETTER_DOUBLE_R = 0xAB48;
const char32_t LATIN_SMALL_LETTER_R_WITH_CROSSED_TAIL = 0xAB49;
const char32_t LATIN_SMALL_LETTER_DOUBLE_R_WITH_CROSSED_TAIL = 0xAB4A;
const char32_t LATIN_SMALL_LETTER_SCRIPT_R = 0xAB4B;
const char32_t LATIN_SMALL_LETTER_SCRIPT_R_WITH_RING = 0xAB4C;
const char32_t LATIN_SMALL_LETTER_BASELINE_ESH = 0xAB4D;
const char32_t LATIN_SMALL_LETTER_U_WITH_SHORT_RIGHT_LEG = 0xAB4E;
const char32_t LATIN_SMALL_LETTER_U_BAR_WITH_SHORT_RIGHT_LEG = 0xAB4F;
const char32_t LATIN_SMALL_LETTER_UI = 0xAB50;
const char32_t LATIN_SMALL_LETTER_TURNED_UI = 0xAB51;
const char32_t LATIN_SMALL_LETTER_U_WITH_LEFT_HOOK = 0xAB52;
const char32_t LATIN_SMALL_LETTER_CHI = 0xAB53;
const char32_t LATIN_SMALL_LETTER_CHI_WITH_LOW_RIGHT_RING = 0xAB54;
const char32_t LATIN_SMALL_LETTER_CHI_WITH_LOW_LEFT_SERIF = 0xAB55;
const char32_t LATIN_SMALL_LETTER_X_WITH_LOW_RIGHT_RING = 0xAB56;
const char32_t LATIN_SMALL_LETTER_X_WITH_LONG_LEFT_LEG = 0xAB57;
const char32_t LATIN_SMALL_LETTER_X_WITH_LONG_LEFT_LEG_AND_LOW_RIGHT_RING = 0xAB58;
const char32_t LATIN_SMALL_LETTER_X_WITH_LONG_LEFT_LEG_WITH_SERIF = 0xAB59;
const char32_t LATIN_SMALL_LETTER_Y_WITH_SHORT_RIGHT_LEG = 0xAB5A;
const char32_t MODIFIER_BREVE_WITH_INVERTED_BREVE = 0xAB5B;
const char32_t MODIFIER_LETTER_SMALL_HENG = 0xAB5C;
const char32_t MODIFIER_LETTER_SMALL_L_WITH_INVERTED_LAZY_S = 0xAB5D;
const char32_t MODIFIER_LETTER_SMALL_L_WITH_MIDDLE_TILDE = 0xAB5E;
const char32_t MODIFIER_LETTER_SMALL_U_WITH_LEFT_HOOK = 0xAB5F;
const char32_t LATIN_SMALL_LETTER_SAKHA_YAT = 0xAB60;
const char32_t LATIN_SMALL_LETTER_IOTIFIED_E = 0xAB61;
const char32_t LATIN_SMALL_LETTER_OPEN_OE = 0xAB62;
const char32_t LATIN_SMALL_LETTER_UO = 0xAB63;
const char32_t LATIN_SMALL_LETTER_INVERTED_ALPHA = 0xAB64;
const char32_t GREEK_LETTER_SMALL_CAPITAL_OMEGA = 0xAB65;
const char32_t LATIN_SMALL_LETTER_DZ_DIGRAPH_WITH_RETROFLEX_HOOK = 0xAB66;
const char32_t LATIN_SMALL_LETTER_TS_DIGRAPH_WITH_RETROFLEX_HOOK = 0xAB67;
const char32_t LATIN_SMALL_LETTER_TURNED_R_WITH_MIDDLE_TILDE = 0xAB68;
const char32_t MODIFIER_LETTER_SMALL_TURNED_W = 0xAB69;
const char32_t MODIFIER_LETTER_LEFT_TACK = 0xAB6A;
const char32_t MODIFIER_LETTER_RIGHT_TACK = 0xAB6B;
const char32_t CHEROKEE_SMALL_LETTER_A = 0xAB70;
const char32_t CHEROKEE_SMALL_LETTER_E = 0xAB71;
const char32_t CHEROKEE_SMALL_LETTER_I = 0xAB72;
const char32_t CHEROKEE_SMALL_LETTER_O = 0xAB73;
const char32_t CHEROKEE_SMALL_LETTER_U = 0xAB74;
const char32_t CHEROKEE_SMALL_LETTER_V = 0xAB75;
const char32_t CHEROKEE_SMALL_LETTER_GA = 0xAB76;
const char32_t CHEROKEE_SMALL_LETTER_KA = 0xAB77;
const char32_t CHEROKEE_SMALL_LETTER_GE = 0xAB78;
const char32_t CHEROKEE_SMALL_LETTER_GI = 0xAB79;
const char32_t CHEROKEE_SMALL_LETTER_GO = 0xAB7A;
const char32_t CHEROKEE_SMALL_LETTER_GU = 0xAB7B;
const char32_t CHEROKEE_SMALL_LETTER_GV = 0xAB7C;
const char32_t CHEROKEE_SMALL_LETTER_HA = 0xAB7D;
const char32_t CHEROKEE_SMALL_LETTER_HE = 0xAB7E;
const char32_t CHEROKEE_SMALL_LETTER_HI = 0xAB7F;
const char32_t CHEROKEE_SMALL_LETTER_HO = 0xAB80;
const char32_t CHEROKEE_SMALL_LETTER_HU = 0xAB81;
const char32_t CHEROKEE_SMALL_LETTER_HV = 0xAB82;
const char32_t CHEROKEE_SMALL_LETTER_LA = 0xAB83;
const char32_t CHEROKEE_SMALL_LETTER_LE = 0xAB84;
const char32_t CHEROKEE_SMALL_LETTER_LI = 0xAB85;
const char32_t CHEROKEE_SMALL_LETTER_LO = 0xAB86;
const char32_t CHEROKEE_SMALL_LETTER_LU = 0xAB87;
const char32_t CHEROKEE_SMALL_LETTER_LV = 0xAB88;
const char32_t CHEROKEE_SMALL_LETTER_MA = 0xAB89;
const char32_t CHEROKEE_SMALL_LETTER_ME = 0xAB8A;
const char32_t CHEROKEE_SMALL_LETTER_MI = 0xAB8B;
const char32_t CHEROKEE_SMALL_LETTER_MO = 0xAB8C;
const char32_t CHEROKEE_SMALL_LETTER_MU = 0xAB8D;
const char32_t CHEROKEE_SMALL_LETTER_NA = 0xAB8E;
const char32_t CHEROKEE_SMALL_LETTER_HNA = 0xAB8F;
const char32_t CHEROKEE_SMALL_LETTER_NAH = 0xAB90;
const char32_t CHEROKEE_SMALL_LETTER_NE = 0xAB91;
const char32_t CHEROKEE_SMALL_LETTER_NI = 0xAB92;
const char32_t CHEROKEE_SMALL_LETTER_NO = 0xAB93;
const char32_t CHEROKEE_SMALL_LETTER_NU = 0xAB94;
const char32_t CHEROKEE_SMALL_LETTER_NV = 0xAB95;
const char32_t CHEROKEE_SMALL_LETTER_QUA = 0xAB96;
const char32_t CHEROKEE_SMALL_LETTER_QUE = 0xAB97;
const char32_t CHEROKEE_SMALL_LETTER_QUI = 0xAB98;
const char32_t CHEROKEE_SMALL_LETTER_QUO = 0xAB99;
const char32_t CHEROKEE_SMALL_LETTER_QUU = 0xAB9A;
const char32_t CHEROKEE_SMALL_LETTER_QUV = 0xAB9B;
const char32_t CHEROKEE_SMALL_LETTER_SA = 0xAB9C;
const char32_t CHEROKEE_SMALL_LETTER_S = 0xAB9D;
const char32_t CHEROKEE_SMALL_LETTER_SE = 0xAB9E;
const char32_t CHEROKEE_SMALL_LETTER_SI = 0xAB9F;
const char32_t CHEROKEE_SMALL_LETTER_SO = 0xABA0;
const char32_t CHEROKEE_SMALL_LETTER_SU = 0xABA1;
const char32_t CHEROKEE_SMALL_LETTER_SV = 0xABA2;
const char32_t CHEROKEE_SMALL_LETTER_DA = 0xABA3;
const char32_t CHEROKEE_SMALL_LETTER_TA = 0xABA4;
const char32_t CHEROKEE_SMALL_LETTER_DE = 0xABA5;
const char32_t CHEROKEE_SMALL_LETTER_TE = 0xABA6;
const char32_t CHEROKEE_SMALL_LETTER_DI = 0xABA7;
const char32_t CHEROKEE_SMALL_LETTER_TI = 0xABA8;
const char32_t CHEROKEE_SMALL_LETTER_DO = 0xABA9;
const char32_t CHEROKEE_SMALL_LETTER_DU = 0xABAA;
const char32_t CHEROKEE_SMALL_LETTER_DV = 0xABAB;
const char32_t CHEROKEE_SMALL_LETTER_DLA = 0xABAC;
const char32_t CHEROKEE_SMALL_LETTER_TLA = 0xABAD;
const char32_t CHEROKEE_SMALL_LETTER_TLE = 0xABAE;
const char32_t CHEROKEE_SMALL_LETTER_TLI = 0xABAF;
const char32_t CHEROKEE_SMALL_LETTER_TLO = 0xABB0;
const char32_t CHEROKEE_SMALL_LETTER_TLU = 0xABB1;
const char32_t CHEROKEE_SMALL_LETTER_TLV = 0xABB2;
const char32_t CHEROKEE_SMALL_LETTER_TSA = 0xABB3;
const char32_t CHEROKEE_SMALL_LETTER_TSE = 0xABB4;
const char32_t CHEROKEE_SMALL_LETTER_TSI = 0xABB5;
const char32_t CHEROKEE_SMALL_LETTER_TSO = 0xABB6;
const char32_t CHEROKEE_SMALL_LETTER_TSU = 0xABB7;
const char32_t CHEROKEE_SMALL_LETTER_TSV = 0xABB8;
const char32_t CHEROKEE_SMALL_LETTER_WA = 0xABB9;
const char32_t CHEROKEE_SMALL_LETTER_WE = 0xABBA;
const char32_t CHEROKEE_SMALL_LETTER_WI = 0xABBB;
const char32_t CHEROKEE_SMALL_LETTER_WO = 0xABBC;
const char32_t CHEROKEE_SMALL_LETTER_WU = 0xABBD;
const char32_t CHEROKEE_SMALL_LETTER_WV = 0xABBE;
const char32_t CHEROKEE_SMALL_LETTER_YA = 0xABBF;
const char32_t MEETEI_MAYEK_LETTER_KOK = 0xABC0;
const char32_t MEETEI_MAYEK_LETTER_SAM = 0xABC1;
const char32_t MEETEI_MAYEK_LETTER_LAI = 0xABC2;
const char32_t MEETEI_MAYEK_LETTER_MIT = 0xABC3;
const char32_t MEETEI_MAYEK_LETTER_PA = 0xABC4;
const char32_t MEETEI_MAYEK_LETTER_NA = 0xABC5;
const char32_t MEETEI_MAYEK_LETTER_CHIL = 0xABC6;
const char32_t MEETEI_MAYEK_LETTER_TIL = 0xABC7;
const char32_t MEETEI_MAYEK_LETTER_KHOU = 0xABC8;
const char32_t MEETEI_MAYEK_LETTER_NGOU = 0xABC9;
const char32_t MEETEI_MAYEK_LETTER_THOU = 0xABCA;
const char32_t MEETEI_MAYEK_LETTER_WAI = 0xABCB;
const char32_t MEETEI_MAYEK_LETTER_YANG = 0xABCC;
const char32_t MEETEI_MAYEK_LETTER_HUK = 0xABCD;
const char32_t MEETEI_MAYEK_LETTER_UN = 0xABCE;
const char32_t MEETEI_MAYEK_LETTER_I = 0xABCF;
const char32_t MEETEI_MAYEK_LETTER_PHAM = 0xABD0;
const char32_t MEETEI_MAYEK_LETTER_ATIYA = 0xABD1;
const char32_t MEETEI_MAYEK_LETTER_GOK = 0xABD2;
const char32_t MEETEI_MAYEK_LETTER_JHAM = 0xABD3;
const char32_t MEETEI_MAYEK_LETTER_RAI = 0xABD4;
const char32_t MEETEI_MAYEK_LETTER_BA = 0xABD5;
const char32_t MEETEI_MAYEK_LETTER_JIL = 0xABD6;
const char32_t MEETEI_MAYEK_LETTER_DIL = 0xABD7;
const char32_t MEETEI_MAYEK_LETTER_GHOU = 0xABD8;
const char32_t MEETEI_MAYEK_LETTER_DHOU = 0xABD9;
const char32_t MEETEI_MAYEK_LETTER_BHAM = 0xABDA;
const char32_t MEETEI_MAYEK_LETTER_KOK_LONSUM = 0xABDB;
const char32_t MEETEI_MAYEK_LETTER_LAI_LONSUM = 0xABDC;
const char32_t MEETEI_MAYEK_LETTER_MIT_LONSUM = 0xABDD;
const char32_t MEETEI_MAYEK_LETTER_PA_LONSUM = 0xABDE;
const char32_t MEETEI_MAYEK_LETTER_NA_LONSUM = 0xABDF;
const char32_t MEETEI_MAYEK_LETTER_TIL_LONSUM = 0xABE0;
const char32_t MEETEI_MAYEK_LETTER_NGOU_LONSUM = 0xABE1;
const char32_t MEETEI_MAYEK_LETTER_I_LONSUM = 0xABE2;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_ONAP = 0xABE3;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_INAP = 0xABE4;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_ANAP = 0xABE5;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_YENAP = 0xABE6;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_SOUNAP = 0xABE7;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_UNAP = 0xABE8;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_CHEINAP = 0xABE9;
const char32_t MEETEI_MAYEK_VOWEL_SIGN_NUNG = 0xABEA;
const char32_t MEETEI_MAYEK_CHEIKHEI = 0xABEB;
const char32_t MEETEI_MAYEK_LUM_IYEK = 0xABEC;
const char32_t MEETEI_MAYEK_APUN_IYEK = 0xABED;
const char32_t MEETEI_MAYEK_DIGIT_ZERO = 0xABF0;
const char32_t MEETEI_MAYEK_DIGIT_ONE = 0xABF1;
const char32_t MEETEI_MAYEK_DIGIT_TWO = 0xABF2;
const char32_t MEETEI_MAYEK_DIGIT_THREE = 0xABF3;
const char32_t MEETEI_MAYEK_DIGIT_FOUR = 0xABF4;
const char32_t MEETEI_MAYEK_DIGIT_FIVE = 0xABF5;
const char32_t MEETEI_MAYEK_DIGIT_SIX = 0xABF6;
const char32_t MEETEI_MAYEK_DIGIT_SEVEN = 0xABF7;
const char32_t MEETEI_MAYEK_DIGIT_EIGHT = 0xABF8;
const char32_t MEETEI_MAYEK_DIGIT_NINE = 0xABF9;
const char32_t HANGUL_SYLLABLE_FIRST = 0xAC00;
const char32_t HANGUL_SYLLABLE_LAST = 0xD7A3;
const char32_t HANGUL_JUNGSEONG_O_YEO = 0xD7B0;
const char32_t HANGUL_JUNGSEONG_O_O_I = 0xD7B1;
const char32_t HANGUL_JUNGSEONG_YO_A = 0xD7B2;
const char32_t HANGUL_JUNGSEONG_YO_AE = 0xD7B3;
const char32_t HANGUL_JUNGSEONG_YO_EO = 0xD7B4;
const char32_t HANGUL_JUNGSEONG_U_YEO = 0xD7B5;
const char32_t HANGUL_JUNGSEONG_U_I_I = 0xD7B6;
const char32_t HANGUL_JUNGSEONG_YU_AE = 0xD7B7;
const char32_t HANGUL_JUNGSEONG_YU_O = 0xD7B8;
const char32_t HANGUL_JUNGSEONG_EU_A = 0xD7B9;
const char32_t HANGUL_JUNGSEONG_EU_EO = 0xD7BA;
const char32_t HANGUL_JUNGSEONG_EU_E = 0xD7BB;
const char32_t HANGUL_JUNGSEONG_EU_O = 0xD7BC;
const char32_t HANGUL_JUNGSEONG_I_YA_O = 0xD7BD;
const char32_t HANGUL_JUNGSEONG_I_YAE = 0xD7BE;
const char32_t HANGUL_JUNGSEONG_I_YEO = 0xD7BF;
const char32_t HANGUL_JUNGSEONG_I_YE = 0xD7C0;
const char32_t HANGUL_JUNGSEONG_I_O_I = 0xD7C1;
const char32_t HANGUL_JUNGSEONG_I_YO = 0xD7C2;
const char32_t HANGUL_JUNGSEONG_I_YU = 0xD7C3;
const char32_t HANGUL_JUNGSEONG_I_I = 0xD7C4;
const char32_t HANGUL_JUNGSEONG_ARAEA_A = 0xD7C5;
const char32_t HANGUL_JUNGSEONG_ARAEA_E = 0xD7C6;
const char32_t HANGUL_JONGSEONG_NIEUN_RIEUL = 0xD7CB;
const char32_t HANGUL_JONGSEONG_NIEUN_CHIEUCH = 0xD7CC;
const char32_t HANGUL_JONGSEONG_SSANGTIKEUT = 0xD7CD;
const char32_t HANGUL_JONGSEONG_SSANGTIKEUT_PIEUP = 0xD7CE;
const char32_t HANGUL_JONGSEONG_TIKEUT_PIEUP = 0xD7CF;
const char32_t HANGUL_JONGSEONG_TIKEUT_SIOS = 0xD7D0;
const char32_t HANGUL_JONGSEONG_TIKEUT_SIOS_KIYEOK = 0xD7D1;
const char32_t HANGUL_JONGSEONG_TIKEUT_CIEUC = 0xD7D2;
const char32_t HANGUL_JONGSEONG_TIKEUT_CHIEUCH = 0xD7D3;
const char32_t HANGUL_JONGSEONG_TIKEUT_THIEUTH = 0xD7D4;
const char32_t HANGUL_JONGSEONG_RIEUL_SSANGKIYEOK = 0xD7D5;
const char32_t HANGUL_JONGSEONG_RIEUL_KIYEOK_HIEUH = 0xD7D6;
const char32_t HANGUL_JONGSEONG_SSANGRIEUL_KHIEUKH = 0xD7D7;
const char32_t HANGUL_JONGSEONG_RIEUL_MIEUM_HIEUH = 0xD7D8;
const char32_t HANGUL_JONGSEONG_RIEUL_PIEUP_TIKEUT = 0xD7D9;
const char32_t HANGUL_JONGSEONG_RIEUL_PIEUP_PHIEUPH = 0xD7DA;
const char32_t HANGUL_JONGSEONG_RIEUL_YESIEUNG = 0xD7DB;
const char32_t HANGUL_JONGSEONG_RIEUL_YEORINHIEUH_HIEUH = 0xD7DC;
const char32_t HANGUL_JONGSEONG_KAPYEOUNRIEUL = 0xD7DD;
const char32_t HANGUL_JONGSEONG_MIEUM_NIEUN = 0xD7DE;
const char32_t HANGUL_JONGSEONG_MIEUM_SSANGNIEUN = 0xD7DF;
const char32_t HANGUL_JONGSEONG_SSANGMIEUM = 0xD7E0;
const char32_t HANGUL_JONGSEONG_MIEUM_PIEUP_SIOS = 0xD7E1;
const char32_t HANGUL_JONGSEONG_MIEUM_CIEUC = 0xD7E2;
const char32_t HANGUL_JONGSEONG_PIEUP_TIKEUT = 0xD7E3;
const char32_t HANGUL_JONGSEONG_PIEUP_RIEUL_PHIEUPH = 0xD7E4;
const char32_t HANGUL_JONGSEONG_PIEUP_MIEUM = 0xD7E5;
const char32_t HANGUL_JONGSEONG_SSANGPIEUP = 0xD7E6;
const char32_t HANGUL_JONGSEONG_PIEUP_SIOS_TIKEUT = 0xD7E7;
const char32_t HANGUL_JONGSEONG_PIEUP_CIEUC = 0xD7E8;
const char32_t HANGUL_JONGSEONG_PIEUP_CHIEUCH = 0xD7E9;
const char32_t HANGUL_JONGSEONG_SIOS_MIEUM = 0xD7EA;
const char32_t HANGUL_JONGSEONG_SIOS_KAPYEOUNPIEUP = 0xD7EB;
const char32_t HANGUL_JONGSEONG_SSANGSIOS_KIYEOK = 0xD7EC;
const char32_t HANGUL_JONGSEONG_SSANGSIOS_TIKEUT = 0xD7ED;
const char32_t HANGUL_JONGSEONG_SIOS_PANSIOS = 0xD7EE;
const char32_t HANGUL_JONGSEONG_SIOS_CIEUC = 0xD7EF;
const char32_t HANGUL_JONGSEONG_SIOS_CHIEUCH = 0xD7F0;
const char32_t HANGUL_JONGSEONG_SIOS_THIEUTH = 0xD7F1;
const char32_t HANGUL_JONGSEONG_SIOS_HIEUH = 0xD7F2;
const char32_t HANGUL_JONGSEONG_PANSIOS_PIEUP = 0xD7F3;
const char32_t HANGUL_JONGSEONG_PANSIOS_KAPYEOUNPIEUP = 0xD7F4;
const char32_t HANGUL_JONGSEONG_YESIEUNG_MIEUM = 0xD7F5;
const char32_t HANGUL_JONGSEONG_YESIEUNG_HIEUH = 0xD7F6;
const char32_t HANGUL_JONGSEONG_CIEUC_PIEUP = 0xD7F7;
const char32_t HANGUL_JONGSEONG_CIEUC_SSANGPIEUP = 0xD7F8;
const char32_t HANGUL_JONGSEONG_SSANGCIEUC = 0xD7F9;
const char32_t HANGUL_JONGSEONG_PHIEUPH_SIOS = 0xD7FA;
const char32_t HANGUL_JONGSEONG_PHIEUPH_THIEUTH = 0xD7FB;
const char32_t NON_PRIVATE_USE_HIGH_SURROGATE_FIRST = 0xD800;
const char32_t NON_PRIVATE_USE_HIGH_SURROGATE_LAST = 0xDB7F;
const char32_t PRIVATE_USE_HIGH_SURROGATE_FIRST = 0xDB80;
const char32_t PRIVATE_USE_HIGH_SURROGATE_LAST = 0xDBFF;
const char32_t LOW_SURROGATE_FIRST = 0xDC00;
const char32_t LOW_SURROGATE_LAST = 0xDFFF;
const char32_t PRIVATE_USE_FIRST = 0xE000;
const char32_t PRIVATE_USE_LAST = 0xF8FF;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F900 = 0xF900;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F901 = 0xF901;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F902 = 0xF902;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F903 = 0xF903;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F904 = 0xF904;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F905 = 0xF905;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F906 = 0xF906;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F907 = 0xF907;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F908 = 0xF908;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F909 = 0xF909;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F90A = 0xF90A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F90B = 0xF90B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F90C = 0xF90C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F90D = 0xF90D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F90E = 0xF90E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F90F = 0xF90F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F910 = 0xF910;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F911 = 0xF911;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F912 = 0xF912;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F913 = 0xF913;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F914 = 0xF914;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F915 = 0xF915;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F916 = 0xF916;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F917 = 0xF917;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F918 = 0xF918;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F919 = 0xF919;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F91A = 0xF91A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F91B = 0xF91B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F91C = 0xF91C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F91D = 0xF91D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F91E = 0xF91E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F91F = 0xF91F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F920 = 0xF920;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F921 = 0xF921;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F922 = 0xF922;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F923 = 0xF923;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F924 = 0xF924;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F925 = 0xF925;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F926 = 0xF926;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F927 = 0xF927;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F928 = 0xF928;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F929 = 0xF929;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F92A = 0xF92A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F92B = 0xF92B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F92C = 0xF92C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F92D = 0xF92D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F92E = 0xF92E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F92F = 0xF92F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F930 = 0xF930;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F931 = 0xF931;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F932 = 0xF932;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F933 = 0xF933;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F934 = 0xF934;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F935 = 0xF935;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F936 = 0xF936;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F937 = 0xF937;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F938 = 0xF938;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F939 = 0xF939;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F93A = 0xF93A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F93B = 0xF93B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F93C = 0xF93C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F93D = 0xF93D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F93E = 0xF93E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F93F = 0xF93F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F940 = 0xF940;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F941 = 0xF941;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F942 = 0xF942;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F943 = 0xF943;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F944 = 0xF944;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F945 = 0xF945;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F946 = 0xF946;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F947 = 0xF947;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F948 = 0xF948;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F949 = 0xF949;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F94A = 0xF94A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F94B = 0xF94B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F94C = 0xF94C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F94D = 0xF94D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F94E = 0xF94E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F94F = 0xF94F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F950 = 0xF950;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F951 = 0xF951;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F952 = 0xF952;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F953 = 0xF953;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F954 = 0xF954;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F955 = 0xF955;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F956 = 0xF956;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F957 = 0xF957;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F958 = 0xF958;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F959 = 0xF959;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F95A = 0xF95A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F95B = 0xF95B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F95C = 0xF95C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F95D = 0xF95D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F95E = 0xF95E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F95F = 0xF95F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F960 = 0xF960;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F961 = 0xF961;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F962 = 0xF962;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F963 = 0xF963;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F964 = 0xF964;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F965 = 0xF965;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F966 = 0xF966;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F967 = 0xF967;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F968 = 0xF968;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F969 = 0xF969;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F96A = 0xF96A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F96B = 0xF96B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F96C = 0xF96C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F96D = 0xF96D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F96E = 0xF96E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F96F = 0xF96F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F970 = 0xF970;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F971 = 0xF971;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F972 = 0xF972;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F973 = 0xF973;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F974 = 0xF974;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F975 = 0xF975;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F976 = 0xF976;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F977 = 0xF977;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F978 = 0xF978;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F979 = 0xF979;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F97A = 0xF97A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F97B = 0xF97B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F97C = 0xF97C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F97D = 0xF97D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F97E = 0xF97E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F97F = 0xF97F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F980 = 0xF980;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F981 = 0xF981;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F982 = 0xF982;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F983 = 0xF983;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F984 = 0xF984;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F985 = 0xF985;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F986 = 0xF986;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F987 = 0xF987;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F988 = 0xF988;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F989 = 0xF989;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F98A = 0xF98A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F98B = 0xF98B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F98C = 0xF98C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F98D = 0xF98D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F98E = 0xF98E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F98F = 0xF98F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F990 = 0xF990;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F991 = 0xF991;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F992 = 0xF992;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F993 = 0xF993;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F994 = 0xF994;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F995 = 0xF995;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F996 = 0xF996;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F997 = 0xF997;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F998 = 0xF998;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F999 = 0xF999;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F99A = 0xF99A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F99B = 0xF99B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F99C = 0xF99C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F99D = 0xF99D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F99E = 0xF99E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F99F = 0xF99F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9A0 = 0xF9A0;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9A1 = 0xF9A1;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9A2 = 0xF9A2;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9A3 = 0xF9A3;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9A4 = 0xF9A4;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9A5 = 0xF9A5;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9A6 = 0xF9A6;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9A7 = 0xF9A7;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9A8 = 0xF9A8;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9A9 = 0xF9A9;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9AA = 0xF9AA;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9AB = 0xF9AB;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9AC = 0xF9AC;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9AD = 0xF9AD;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9AE = 0xF9AE;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9AF = 0xF9AF;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9B0 = 0xF9B0;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9B1 = 0xF9B1;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9B2 = 0xF9B2;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9B3 = 0xF9B3;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9B4 = 0xF9B4;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9B5 = 0xF9B5;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9B6 = 0xF9B6;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9B7 = 0xF9B7;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9B8 = 0xF9B8;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9B9 = 0xF9B9;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9BA = 0xF9BA;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9BB = 0xF9BB;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9BC = 0xF9BC;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9BD = 0xF9BD;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9BE = 0xF9BE;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9BF = 0xF9BF;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9C0 = 0xF9C0;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9C1 = 0xF9C1;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9C2 = 0xF9C2;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9C3 = 0xF9C3;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9C4 = 0xF9C4;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9C5 = 0xF9C5;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9C6 = 0xF9C6;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9C7 = 0xF9C7;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9C8 = 0xF9C8;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9C9 = 0xF9C9;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9CA = 0xF9CA;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9CB = 0xF9CB;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9CC = 0xF9CC;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9CD = 0xF9CD;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9CE = 0xF9CE;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9CF = 0xF9CF;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9D0 = 0xF9D0;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9D1 = 0xF9D1;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9D2 = 0xF9D2;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9D3 = 0xF9D3;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9D4 = 0xF9D4;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9D5 = 0xF9D5;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9D6 = 0xF9D6;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9D7 = 0xF9D7;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9D8 = 0xF9D8;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9D9 = 0xF9D9;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9DA = 0xF9DA;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9DB = 0xF9DB;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9DC = 0xF9DC;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9DD = 0xF9DD;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9DE = 0xF9DE;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9DF = 0xF9DF;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9E0 = 0xF9E0;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9E1 = 0xF9E1;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9E2 = 0xF9E2;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9E3 = 0xF9E3;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9E4 = 0xF9E4;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9E5 = 0xF9E5;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9E6 = 0xF9E6;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9E7 = 0xF9E7;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9E8 = 0xF9E8;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9E9 = 0xF9E9;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9EA = 0xF9EA;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9EB = 0xF9EB;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9EC = 0xF9EC;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9ED = 0xF9ED;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9EE = 0xF9EE;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9EF = 0xF9EF;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9F0 = 0xF9F0;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9F1 = 0xF9F1;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9F2 = 0xF9F2;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9F3 = 0xF9F3;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9F4 = 0xF9F4;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9F5 = 0xF9F5;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9F6 = 0xF9F6;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9F7 = 0xF9F7;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9F8 = 0xF9F8;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9F9 = 0xF9F9;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9FA = 0xF9FA;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9FB = 0xF9FB;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9FC = 0xF9FC;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9FD = 0xF9FD;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9FE = 0xF9FE;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_F9FF = 0xF9FF;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA00 = 0xFA00;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA01 = 0xFA01;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA02 = 0xFA02;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA03 = 0xFA03;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA04 = 0xFA04;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA05 = 0xFA05;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA06 = 0xFA06;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA07 = 0xFA07;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA08 = 0xFA08;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA09 = 0xFA09;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA0A = 0xFA0A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA0B = 0xFA0B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA0C = 0xFA0C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA0D = 0xFA0D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA0E = 0xFA0E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA0F = 0xFA0F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA10 = 0xFA10;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA11 = 0xFA11;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA12 = 0xFA12;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA13 = 0xFA13;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA14 = 0xFA14;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA15 = 0xFA15;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA16 = 0xFA16;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA17 = 0xFA17;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA18 = 0xFA18;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA19 = 0xFA19;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA1A = 0xFA1A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA1B = 0xFA1B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA1C = 0xFA1C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA1D = 0xFA1D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA1E = 0xFA1E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA1F = 0xFA1F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA20 = 0xFA20;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA21 = 0xFA21;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA22 = 0xFA22;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA23 = 0xFA23;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA24 = 0xFA24;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA25 = 0xFA25;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA26 = 0xFA26;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA27 = 0xFA27;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA28 = 0xFA28;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA29 = 0xFA29;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA2A = 0xFA2A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA2B = 0xFA2B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA2C = 0xFA2C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA2D = 0xFA2D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA2E = 0xFA2E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA2F = 0xFA2F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA30 = 0xFA30;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA31 = 0xFA31;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA32 = 0xFA32;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA33 = 0xFA33;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA34 = 0xFA34;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA35 = 0xFA35;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA36 = 0xFA36;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA37 = 0xFA37;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA38 = 0xFA38;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA39 = 0xFA39;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA3A = 0xFA3A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA3B = 0xFA3B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA3C = 0xFA3C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA3D = 0xFA3D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA3E = 0xFA3E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA3F = 0xFA3F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA40 = 0xFA40;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA41 = 0xFA41;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA42 = 0xFA42;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA43 = 0xFA43;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA44 = 0xFA44;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA45 = 0xFA45;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA46 = 0xFA46;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA47 = 0xFA47;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA48 = 0xFA48;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA49 = 0xFA49;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA4A = 0xFA4A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA4B = 0xFA4B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA4C = 0xFA4C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA4D = 0xFA4D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA4E = 0xFA4E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA4F = 0xFA4F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA50 = 0xFA50;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA51 = 0xFA51;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA52 = 0xFA52;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA53 = 0xFA53;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA54 = 0xFA54;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA55 = 0xFA55;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA56 = 0xFA56;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA57 = 0xFA57;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA58 = 0xFA58;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA59 = 0xFA59;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA5A = 0xFA5A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA5B = 0xFA5B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA5C = 0xFA5C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA5D = 0xFA5D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA5E = 0xFA5E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA5F = 0xFA5F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA60 = 0xFA60;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA61 = 0xFA61;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA62 = 0xFA62;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA63 = 0xFA63;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA64 = 0xFA64;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA65 = 0xFA65;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA66 = 0xFA66;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA67 = 0xFA67;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA68 = 0xFA68;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA69 = 0xFA69;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA6A = 0xFA6A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA6B = 0xFA6B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA6C = 0xFA6C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA6D = 0xFA6D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA70 = 0xFA70;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA71 = 0xFA71;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA72 = 0xFA72;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA73 = 0xFA73;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA74 = 0xFA74;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA75 = 0xFA75;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA76 = 0xFA76;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA77 = 0xFA77;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA78 = 0xFA78;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA79 = 0xFA79;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA7A = 0xFA7A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA7B = 0xFA7B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA7C = 0xFA7C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA7D = 0xFA7D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA7E = 0xFA7E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA7F = 0xFA7F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA80 = 0xFA80;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA81 = 0xFA81;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA82 = 0xFA82;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA83 = 0xFA83;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA84 = 0xFA84;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA85 = 0xFA85;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA86 = 0xFA86;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA87 = 0xFA87;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA88 = 0xFA88;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA89 = 0xFA89;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA8A = 0xFA8A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA8B = 0xFA8B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA8C = 0xFA8C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA8D = 0xFA8D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA8E = 0xFA8E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA8F = 0xFA8F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA90 = 0xFA90;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA91 = 0xFA91;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA92 = 0xFA92;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA93 = 0xFA93;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA94 = 0xFA94;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA95 = 0xFA95;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA96 = 0xFA96;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA97 = 0xFA97;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA98 = 0xFA98;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA99 = 0xFA99;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA9A = 0xFA9A;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA9B = 0xFA9B;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA9C = 0xFA9C;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA9D = 0xFA9D;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA9E = 0xFA9E;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FA9F = 0xFA9F;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAA0 = 0xFAA0;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAA1 = 0xFAA1;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAA2 = 0xFAA2;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAA3 = 0xFAA3;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAA4 = 0xFAA4;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAA5 = 0xFAA5;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAA6 = 0xFAA6;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAA7 = 0xFAA7;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAA8 = 0xFAA8;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAA9 = 0xFAA9;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAAA = 0xFAAA;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAAB = 0xFAAB;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAAC = 0xFAAC;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAAD = 0xFAAD;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAAE = 0xFAAE;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAAF = 0xFAAF;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAB0 = 0xFAB0;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAB1 = 0xFAB1;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAB2 = 0xFAB2;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAB3 = 0xFAB3;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAB4 = 0xFAB4;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAB5 = 0xFAB5;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAB6 = 0xFAB6;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAB7 = 0xFAB7;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAB8 = 0xFAB8;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAB9 = 0xFAB9;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FABA = 0xFABA;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FABB = 0xFABB;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FABC = 0xFABC;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FABD = 0xFABD;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FABE = 0xFABE;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FABF = 0xFABF;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAC0 = 0xFAC0;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAC1 = 0xFAC1;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAC2 = 0xFAC2;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAC3 = 0xFAC3;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAC4 = 0xFAC4;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAC5 = 0xFAC5;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAC6 = 0xFAC6;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAC7 = 0xFAC7;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAC8 = 0xFAC8;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAC9 = 0xFAC9;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FACA = 0xFACA;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FACB = 0xFACB;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FACC = 0xFACC;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FACD = 0xFACD;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FACE = 0xFACE;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FACF = 0xFACF;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAD0 = 0xFAD0;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAD1 = 0xFAD1;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAD2 = 0xFAD2;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAD3 = 0xFAD3;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAD4 = 0xFAD4;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAD5 = 0xFAD5;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAD6 = 0xFAD6;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAD7 = 0xFAD7;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAD8 = 0xFAD8;
const char32_t CJK_COMPATIBILITY_IDEOGRAPH_FAD9 = 0xFAD9;
const char32_t LATIN_SMALL_LIGATURE_FF = 0xFB00;
const char32_t LATIN_SMALL_LIGATURE_FI = 0xFB01;
const char32_t LATIN_SMALL_LIGATURE_FL = 0xFB02;
const char32_t LATIN_SMALL_LIGATURE_FFI = 0xFB03;
const char32_t LATIN_SMALL_LIGATURE_FFL = 0xFB04;
const char32_t LATIN_SMALL_LIGATURE_LONG_S_T = 0xFB05;
const char32_t LATIN_SMALL_LIGATURE_ST = 0xFB06;
const char32_t ARMENIAN_SMALL_LIGATURE_MEN_NOW = 0xFB13;
const char32_t ARMENIAN_SMALL_LIGATURE_MEN_ECH = 0xFB14;
const char32_t ARMENIAN_SMALL_LIGATURE_MEN_INI = 0xFB15;
const char32_t ARMENIAN_SMALL_LIGATURE_VEW_NOW = 0xFB16;
const char32_t ARMENIAN_SMALL_LIGATURE_MEN_XEH = 0xFB17;
const char32_t HEBREW_LETTER_YOD_WITH_HIRIQ = 0xFB1D;
const char32_t HEBREW_POINT_JUDEO_SPANISH_VARIKA = 0xFB1E;
const char32_t HEBREW_LIGATURE_YIDDISH_YOD_YOD_PATAH = 0xFB1F;
const char32_t HEBREW_LETTER_ALTERNATIVE_AYIN = 0xFB20;
const char32_t HEBREW_LETTER_WIDE_ALEF = 0xFB21;
const char32_t HEBREW_LETTER_WIDE_DALET = 0xFB22;
const char32_t HEBREW_LETTER_WIDE_HE = 0xFB23;
const char32_t HEBREW_LETTER_WIDE_KAF = 0xFB24;
const char32_t HEBREW_LETTER_WIDE_LAMED = 0xFB25;
const char32_t HEBREW_LETTER_WIDE_FINAL_MEM = 0xFB26;
const char32_t HEBREW_LETTER_WIDE_RESH = 0xFB27;
const char32_t HEBREW_LETTER_WIDE_TAV = 0xFB28;
const char32_t HEBREW_LETTER_ALTERNATIVE_PLUS_SIGN = 0xFB29;
const char32_t HEBREW_LETTER_SHIN_WITH_SHIN_DOT = 0xFB2A;
const char32_t HEBREW_LETTER_SHIN_WITH_SIN_DOT = 0xFB2B;
const char32_t HEBREW_LETTER_SHIN_WITH_DAGESH_AND_SHIN_DOT = 0xFB2C;
const char32_t HEBREW_LETTER_SHIN_WITH_DAGESH_AND_SIN_DOT = 0xFB2D;
const char32_t HEBREW_LETTER_ALEF_WITH_PATAH = 0xFB2E;
const char32_t HEBREW_LETTER_ALEF_WITH_QAMATS = 0xFB2F;
const char32_t HEBREW_LETTER_ALEF_WITH_MAPIQ = 0xFB30;
const char32_t HEBREW_LETTER_BET_WITH_DAGESH = 0xFB31;
const char32_t HEBREW_LETTER_GIMEL_WITH_DAGESH = 0xFB32;
const char32_t HEBREW_LETTER_DALET_WITH_DAGESH = 0xFB33;
const char32_t HEBREW_LETTER_HE_WITH_MAPIQ = 0xFB34;
const char32_t HEBREW_LETTER_VAV_WITH_DAGESH = 0xFB35;
const char32_t HEBREW_LETTER_ZAYIN_WITH_DAGESH = 0xFB36;
const char32_t HEBREW_LETTER_TET_WITH_DAGESH = 0xFB38;
const char32_t HEBREW_LETTER_YOD_WITH_DAGESH = 0xFB39;
const char32_t HEBREW_LETTER_FINAL_KAF_WITH_DAGESH = 0xFB3A;
const char32_t HEBREW_LETTER_KAF_WITH_DAGESH = 0xFB3B;
const char32_t HEBREW_LETTER_LAMED_WITH_DAGESH = 0xFB3C;
const char32_t HEBREW_LETTER_MEM_WITH_DAGESH = 0xFB3E;
const char32_t HEBREW_LETTER_NUN_WITH_DAGESH = 0xFB40;
const char32_t HEBREW_LETTER_SAMEKH_WITH_DAGESH = 0xFB41;
const char32_t HEBREW_LETTER_FINAL_PE_WITH_DAGESH = 0xFB43;
const char32_t HEBREW_LETTER_PE_WITH_DAGESH = 0xFB44;
const char32_t HEBREW_LETTER_TSADI_WITH_DAGESH = 0xFB46;
const char32_t HEBREW_LETTER_QOF_WITH_DAGESH = 0xFB47;
const char32_t HEBREW_LETTER_RESH_WITH_DAGESH = 0xFB48;
const char32_t HEBREW_LETTER_SHIN_WITH_DAGESH = 0xFB49;
const char32_t HEBREW_LETTER_TAV_WITH_DAGESH = 0xFB4A;
const char32_t HEBREW_LETTER_VAV_WITH_HOLAM = 0xFB4B;
const char32_t HEBREW_LETTER_BET_WITH_RAFE = 0xFB4C;
const char32_t HEBREW_LETTER_KAF_WITH_RAFE = 0xFB4D;
const char32_t HEBREW_LETTER_PE_WITH_RAFE = 0xFB4E;
const char32_t HEBREW_LIGATURE_ALEF_LAMED = 0xFB4F;
const char32_t ARABIC_LETTER_ALEF_WASLA_ISOLATED_FORM = 0xFB50;
const char32_t ARABIC_LETTER_ALEF_WASLA_FINAL_FORM = 0xFB51;
const char32_t ARABIC_LETTER_BEEH_ISOLATED_FORM = 0xFB52;
const char32_t ARABIC_LETTER_BEEH_FINAL_FORM = 0xFB53;
const char32_t ARABIC_LETTER_BEEH_INITIAL_FORM = 0xFB54;
const char32_t ARABIC_LETTER_BEEH_MEDIAL_FORM = 0xFB55;
const char32_t ARABIC_LETTER_PEH_ISOLATED_FORM = 0xFB56;
const char32_t ARABIC_LETTER_PEH_FINAL_FORM = 0xFB57;
const char32_t ARABIC_LETTER_PEH_INITIAL_FORM = 0xFB58;
const char32_t ARABIC_LETTER_PEH_MEDIAL_FORM = 0xFB59;
const char32_t ARABIC_LETTER_BEHEH_ISOLATED_FORM = 0xFB5A;
const char32_t ARABIC_LETTER_BEHEH_FINAL_FORM = 0xFB5B;
const char32_t ARABIC_LETTER_BEHEH_INITIAL_FORM = 0xFB5C;
const char32_t ARABIC_LETTER_BEHEH_MEDIAL_FORM = 0xFB5D;
const char32_t ARABIC_LETTER_TTEHEH_ISOLATED_FORM = 0xFB5E;
const char32_t ARABIC_LETTER_TTEHEH_FINAL_FORM = 0xFB5F;
const char32_t ARABIC_LETTER_TTEHEH_INITIAL_FORM = 0xFB60;
const char32_t ARABIC_LETTER_TTEHEH_MEDIAL_FORM = 0xFB61;
const char32_t ARABIC_LETTER_TEHEH_ISOLATED_FORM = 0xFB62;
const char32_t ARABIC_LETTER_TEHEH_FINAL_FORM = 0xFB63;
const char32_t ARABIC_LETTER_TEHEH_INITIAL_FORM = 0xFB64;
const char32_t ARABIC_LETTER_TEHEH_MEDIAL_FORM = 0xFB65;
const char32_t ARABIC_LETTER_TTEH_ISOLATED_FORM = 0xFB66;
const char32_t ARABIC_LETTER_TTEH_FINAL_FORM = 0xFB67;
const char32_t ARABIC_LETTER_TTEH_INITIAL_FORM = 0xFB68;
const char32_t ARABIC_LETTER_TTEH_MEDIAL_FORM = 0xFB69;
const char32_t ARABIC_LETTER_VEH_ISOLATED_FORM = 0xFB6A;
const char32_t ARABIC_LETTER_VEH_FINAL_FORM = 0xFB6B;
const char32_t ARABIC_LETTER_VEH_INITIAL_FORM = 0xFB6C;
const char32_t ARABIC_LETTER_VEH_MEDIAL_FORM = 0xFB6D;
const char32_t ARABIC_LETTER_PEHEH_ISOLATED_FORM = 0xFB6E;
const char32_t ARABIC_LETTER_PEHEH_FINAL_FORM = 0xFB6F;
const char32_t ARABIC_LETTER_PEHEH_INITIAL_FORM = 0xFB70;
const char32_t ARABIC_LETTER_PEHEH_MEDIAL_FORM = 0xFB71;
const char32_t ARABIC_LETTER_DYEH_ISOLATED_FORM = 0xFB72;
const char32_t ARABIC_LETTER_DYEH_FINAL_FORM = 0xFB73;
const char32_t ARABIC_LETTER_DYEH_INITIAL_FORM = 0xFB74;
const char32_t ARABIC_LETTER_DYEH_MEDIAL_FORM = 0xFB75;
const char32_t ARABIC_LETTER_NYEH_ISOLATED_FORM = 0xFB76;
const char32_t ARABIC_LETTER_NYEH_FINAL_FORM = 0xFB77;
const char32_t ARABIC_LETTER_NYEH_INITIAL_FORM = 0xFB78;
const char32_t ARABIC_LETTER_NYEH_MEDIAL_FORM = 0xFB79;
const char32_t ARABIC_LETTER_TCHEH_ISOLATED_FORM = 0xFB7A;
const char32_t ARABIC_LETTER_TCHEH_FINAL_FORM = 0xFB7B;
const char32_t ARABIC_LETTER_TCHEH_INITIAL_FORM = 0xFB7C;
const char32_t ARABIC_LETTER_TCHEH_MEDIAL_FORM = 0xFB7D;
const char32_t ARABIC_LETTER_TCHEHEH_ISOLATED_FORM = 0xFB7E;
const char32_t ARABIC_LETTER_TCHEHEH_FINAL_FORM = 0xFB7F;
const char32_t ARABIC_LETTER_TCHEHEH_INITIAL_FORM = 0xFB80;
const char32_t ARABIC_LETTER_TCHEHEH_MEDIAL_FORM = 0xFB81;
const char32_t ARABIC_LETTER_DDAHAL_ISOLATED_FORM = 0xFB82;
const char32_t ARABIC_LETTER_DDAHAL_FINAL_FORM = 0xFB83;
const char32_t ARABIC_LETTER_DAHAL_ISOLATED_FORM = 0xFB84;
const char32_t ARABIC_LETTER_DAHAL_FINAL_FORM = 0xFB85;
const char32_t ARABIC_LETTER_DUL_ISOLATED_FORM = 0xFB86;
const char32_t ARABIC_LETTER_DUL_FINAL_FORM = 0xFB87;
const char32_t ARABIC_LETTER_DDAL_ISOLATED_FORM = 0xFB88;
const char32_t ARABIC_LETTER_DDAL_FINAL_FORM = 0xFB89;
const char32_t ARABIC_LETTER_JEH_ISOLATED_FORM = 0xFB8A;
const char32_t ARABIC_LETTER_JEH_FINAL_FORM = 0xFB8B;
const char32_t ARABIC_LETTER_RREH_ISOLATED_FORM = 0xFB8C;
const char32_t ARABIC_LETTER_RREH_FINAL_FORM = 0xFB8D;
const char32_t ARABIC_LETTER_KEHEH_ISOLATED_FORM = 0xFB8E;
const char32_t ARABIC_LETTER_KEHEH_FINAL_FORM = 0xFB8F;
const char32_t ARABIC_LETTER_KEHEH_INITIAL_FORM = 0xFB90;
const char32_t ARABIC_LETTER_KEHEH_MEDIAL_FORM = 0xFB91;
const char32_t ARABIC_LETTER_GAF_ISOLATED_FORM = 0xFB92;
const char32_t ARABIC_LETTER_GAF_FINAL_FORM = 0xFB93;
const char32_t ARABIC_LETTER_GAF_INITIAL_FORM = 0xFB94;
const char32_t ARABIC_LETTER_GAF_MEDIAL_FORM = 0xFB95;
const char32_t ARABIC_LETTER_GUEH_ISOLATED_FORM = 0xFB96;
const char32_t ARABIC_LETTER_GUEH_FINAL_FORM = 0xFB97;
const char32_t ARABIC_LETTER_GUEH_INITIAL_FORM = 0xFB98;
const char32_t ARABIC_LETTER_GUEH_MEDIAL_FORM = 0xFB99;
const char32_t ARABIC_LETTER_NGOEH_ISOLATED_FORM = 0xFB9A;
const char32_t ARABIC_LETTER_NGOEH_FINAL_FORM = 0xFB9B;
const char32_t ARABIC_LETTER_NGOEH_INITIAL_FORM = 0xFB9C;
const char32_t ARABIC_LETTER_NGOEH_MEDIAL_FORM = 0xFB9D;
const char32_t ARABIC_LETTER_NOON_GHUNNA_ISOLATED_FORM = 0xFB9E;
const char32_t ARABIC_LETTER_NOON_GHUNNA_FINAL_FORM = 0xFB9F;
const char32_t ARABIC_LETTER_RNOON_ISOLATED_FORM = 0xFBA0;
const char32_t ARABIC_LETTER_RNOON_FINAL_FORM = 0xFBA1;
const char32_t ARABIC_LETTER_RNOON_INITIAL_FORM = 0xFBA2;
const char32_t ARABIC_LETTER_RNOON_MEDIAL_FORM = 0xFBA3;
const char32_t ARABIC_LETTER_HEH_WITH_YEH_ABOVE_ISOLATED_FORM = 0xFBA4;
const char32_t ARABIC_LETTER_HEH_WITH_YEH_ABOVE_FINAL_FORM = 0xFBA5;
const char32_t ARABIC_LETTER_HEH_GOAL_ISOLATED_FORM = 0xFBA6;
const char32_t ARABIC_LETTER_HEH_GOAL_FINAL_FORM = 0xFBA7;
const char32_t ARABIC_LETTER_HEH_GOAL_INITIAL_FORM = 0xFBA8;
const char32_t ARABIC_LETTER_HEH_GOAL_MEDIAL_FORM = 0xFBA9;
const char32_t ARABIC_LETTER_HEH_DOACHASHMEE_ISOLATED_FORM = 0xFBAA;
const char32_t ARABIC_LETTER_HEH_DOACHASHMEE_FINAL_FORM = 0xFBAB;
const char32_t ARABIC_LETTER_HEH_DOACHASHMEE_INITIAL_FORM = 0xFBAC;
const char32_t ARABIC_LETTER_HEH_DOACHASHMEE_MEDIAL_FORM = 0xFBAD;
const char32_t ARABIC_LETTER_YEH_BARREE_ISOLATED_FORM = 0xFBAE;
const char32_t ARABIC_LETTER_YEH_BARREE_FINAL_FORM = 0xFBAF;
const char32_t ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE_ISOLATED_FORM = 0xFBB0;
const char32_t ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE_FINAL_FORM = 0xFBB1;
const char32_t ARABIC_SYMBOL_DOT_ABOVE = 0xFBB2;
const char32_t ARABIC_SYMBOL_DOT_BELOW = 0xFBB3;
const char32_t ARABIC_SYMBOL_TWO_DOTS_ABOVE = 0xFBB4;
const char32_t ARABIC_SYMBOL_TWO_DOTS_BELOW = 0xFBB5;
const char32_t ARABIC_SYMBOL_THREE_DOTS_ABOVE = 0xFBB6;
const char32_t ARABIC_SYMBOL_THREE_DOTS_BELOW = 0xFBB7;
const char32_t ARABIC_SYMBOL_THREE_DOTS_POINTING_DOWNWARDS_ABOVE = 0xFBB8;
const char32_t ARABIC_SYMBOL_THREE_DOTS_POINTING_DOWNWARDS_BELOW = 0xFBB9;
const char32_t ARABIC_SYMBOL_FOUR_DOTS_ABOVE = 0xFBBA;
const char32_t ARABIC_SYMBOL_FOUR_DOTS_BELOW = 0xFBBB;
const char32_t ARABIC_SYMBOL_DOUBLE_VERTICAL_BAR_BELOW = 0xFBBC;
const char32_t ARABIC_SYMBOL_TWO_DOTS_VERTICALLY_ABOVE = 0xFBBD;
const char32_t ARABIC_SYMBOL_TWO_DOTS_VERTICALLY_BELOW = 0xFBBE;
const char32_t ARABIC_SYMBOL_RING = 0xFBBF;
const char32_t ARABIC_SYMBOL_SMALL_TAH_ABOVE = 0xFBC0;
const char32_t ARABIC_SYMBOL_SMALL_TAH_BELOW = 0xFBC1;
const char32_t ARABIC_LETTER_NG_ISOLATED_FORM = 0xFBD3;
const char32_t ARABIC_LETTER_NG_FINAL_FORM = 0xFBD4;
const char32_t ARABIC_LETTER_NG_INITIAL_FORM = 0xFBD5;
const char32_t ARABIC_LETTER_NG_MEDIAL_FORM = 0xFBD6;
const char32_t ARABIC_LETTER_U_ISOLATED_FORM = 0xFBD7;
const char32_t ARABIC_LETTER_U_FINAL_FORM = 0xFBD8;
const char32_t ARABIC_LETTER_OE_ISOLATED_FORM = 0xFBD9;
const char32_t ARABIC_LETTER_OE_FINAL_FORM = 0xFBDA;
const char32_t ARABIC_LETTER_YU_ISOLATED_FORM = 0xFBDB;
const char32_t ARABIC_LETTER_YU_FINAL_FORM = 0xFBDC;
const char32_t ARABIC_LETTER_U_WITH_HAMZA_ABOVE_ISOLATED_FORM = 0xFBDD;
const char32_t ARABIC_LETTER_VE_ISOLATED_FORM = 0xFBDE;
const char32_t ARABIC_LETTER_VE_FINAL_FORM = 0xFBDF;
const char32_t ARABIC_LETTER_KIRGHIZ_OE_ISOLATED_FORM = 0xFBE0;
const char32_t ARABIC_LETTER_KIRGHIZ_OE_FINAL_FORM = 0xFBE1;
const char32_t ARABIC_LETTER_KIRGHIZ_YU_ISOLATED_FORM = 0xFBE2;
const char32_t ARABIC_LETTER_KIRGHIZ_YU_FINAL_FORM = 0xFBE3;
const char32_t ARABIC_LETTER_E_ISOLATED_FORM = 0xFBE4;
const char32_t ARABIC_LETTER_E_FINAL_FORM = 0xFBE5;
const char32_t ARABIC_LETTER_E_INITIAL_FORM = 0xFBE6;
const char32_t ARABIC_LETTER_E_MEDIAL_FORM = 0xFBE7;
const char32_t ARABIC_LETTER_UIGHUR_KAZAKH_KIRGHIZ_ALEF_MAKSURA_INITIAL_FORM = 0xFBE8;
const char32_t ARABIC_LETTER_UIGHUR_KAZAKH_KIRGHIZ_ALEF_MAKSURA_MEDIAL_FORM = 0xFBE9;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_ISOLATED_FORM = 0xFBEA;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_FINAL_FORM = 0xFBEB;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_AE_ISOLATED_FORM = 0xFBEC;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_AE_FINAL_FORM = 0xFBED;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_WAW_ISOLATED_FORM = 0xFBEE;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_WAW_FINAL_FORM = 0xFBEF;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_U_ISOLATED_FORM = 0xFBF0;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_U_FINAL_FORM = 0xFBF1;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_OE_ISOLATED_FORM = 0xFBF2;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_OE_FINAL_FORM = 0xFBF3;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YU_ISOLATED_FORM = 0xFBF4;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YU_FINAL_FORM = 0xFBF5;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_E_ISOLATED_FORM = 0xFBF6;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_E_FINAL_FORM = 0xFBF7;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_E_INITIAL_FORM = 0xFBF8;
const char32_t ARABIC_LIGATURE_UIGHUR_KIRGHIZ_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFBF9;
const char32_t ARABIC_LIGATURE_UIGHUR_KIRGHIZ_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFBFA;
const char32_t ARABIC_LIGATURE_UIGHUR_KIRGHIZ_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_INITIAL_FORM = 0xFBFB;
const char32_t ARABIC_LETTER_FARSI_YEH_ISOLATED_FORM = 0xFBFC;
const char32_t ARABIC_LETTER_FARSI_YEH_FINAL_FORM = 0xFBFD;
const char32_t ARABIC_LETTER_FARSI_YEH_INITIAL_FORM = 0xFBFE;
const char32_t ARABIC_LETTER_FARSI_YEH_MEDIAL_FORM = 0xFBFF;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_JEEM_ISOLATED_FORM = 0xFC00;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HAH_ISOLATED_FORM = 0xFC01;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_ISOLATED_FORM = 0xFC02;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFC03;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YEH_ISOLATED_FORM = 0xFC04;
const char32_t ARABIC_LIGATURE_BEH_WITH_JEEM_ISOLATED_FORM = 0xFC05;
const char32_t ARABIC_LIGATURE_BEH_WITH_HAH_ISOLATED_FORM = 0xFC06;
const char32_t ARABIC_LIGATURE_BEH_WITH_KHAH_ISOLATED_FORM = 0xFC07;
const char32_t ARABIC_LIGATURE_BEH_WITH_MEEM_ISOLATED_FORM = 0xFC08;
const char32_t ARABIC_LIGATURE_BEH_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFC09;
const char32_t ARABIC_LIGATURE_BEH_WITH_YEH_ISOLATED_FORM = 0xFC0A;
const char32_t ARABIC_LIGATURE_TEH_WITH_JEEM_ISOLATED_FORM = 0xFC0B;
const char32_t ARABIC_LIGATURE_TEH_WITH_HAH_ISOLATED_FORM = 0xFC0C;
const char32_t ARABIC_LIGATURE_TEH_WITH_KHAH_ISOLATED_FORM = 0xFC0D;
const char32_t ARABIC_LIGATURE_TEH_WITH_MEEM_ISOLATED_FORM = 0xFC0E;
const char32_t ARABIC_LIGATURE_TEH_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFC0F;
const char32_t ARABIC_LIGATURE_TEH_WITH_YEH_ISOLATED_FORM = 0xFC10;
const char32_t ARABIC_LIGATURE_THEH_WITH_JEEM_ISOLATED_FORM = 0xFC11;
const char32_t ARABIC_LIGATURE_THEH_WITH_MEEM_ISOLATED_FORM = 0xFC12;
const char32_t ARABIC_LIGATURE_THEH_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFC13;
const char32_t ARABIC_LIGATURE_THEH_WITH_YEH_ISOLATED_FORM = 0xFC14;
const char32_t ARABIC_LIGATURE_JEEM_WITH_HAH_ISOLATED_FORM = 0xFC15;
const char32_t ARABIC_LIGATURE_JEEM_WITH_MEEM_ISOLATED_FORM = 0xFC16;
const char32_t ARABIC_LIGATURE_HAH_WITH_JEEM_ISOLATED_FORM = 0xFC17;
const char32_t ARABIC_LIGATURE_HAH_WITH_MEEM_ISOLATED_FORM = 0xFC18;
const char32_t ARABIC_LIGATURE_KHAH_WITH_JEEM_ISOLATED_FORM = 0xFC19;
const char32_t ARABIC_LIGATURE_KHAH_WITH_HAH_ISOLATED_FORM = 0xFC1A;
const char32_t ARABIC_LIGATURE_KHAH_WITH_MEEM_ISOLATED_FORM = 0xFC1B;
const char32_t ARABIC_LIGATURE_SEEN_WITH_JEEM_ISOLATED_FORM = 0xFC1C;
const char32_t ARABIC_LIGATURE_SEEN_WITH_HAH_ISOLATED_FORM = 0xFC1D;
const char32_t ARABIC_LIGATURE_SEEN_WITH_KHAH_ISOLATED_FORM = 0xFC1E;
const char32_t ARABIC_LIGATURE_SEEN_WITH_MEEM_ISOLATED_FORM = 0xFC1F;
const char32_t ARABIC_LIGATURE_SAD_WITH_HAH_ISOLATED_FORM = 0xFC20;
const char32_t ARABIC_LIGATURE_SAD_WITH_MEEM_ISOLATED_FORM = 0xFC21;
const char32_t ARABIC_LIGATURE_DAD_WITH_JEEM_ISOLATED_FORM = 0xFC22;
const char32_t ARABIC_LIGATURE_DAD_WITH_HAH_ISOLATED_FORM = 0xFC23;
const char32_t ARABIC_LIGATURE_DAD_WITH_KHAH_ISOLATED_FORM = 0xFC24;
const char32_t ARABIC_LIGATURE_DAD_WITH_MEEM_ISOLATED_FORM = 0xFC25;
const char32_t ARABIC_LIGATURE_TAH_WITH_HAH_ISOLATED_FORM = 0xFC26;
const char32_t ARABIC_LIGATURE_TAH_WITH_MEEM_ISOLATED_FORM = 0xFC27;
const char32_t ARABIC_LIGATURE_ZAH_WITH_MEEM_ISOLATED_FORM = 0xFC28;
const char32_t ARABIC_LIGATURE_AIN_WITH_JEEM_ISOLATED_FORM = 0xFC29;
const char32_t ARABIC_LIGATURE_AIN_WITH_MEEM_ISOLATED_FORM = 0xFC2A;
const char32_t ARABIC_LIGATURE_GHAIN_WITH_JEEM_ISOLATED_FORM = 0xFC2B;
const char32_t ARABIC_LIGATURE_GHAIN_WITH_MEEM_ISOLATED_FORM = 0xFC2C;
const char32_t ARABIC_LIGATURE_FEH_WITH_JEEM_ISOLATED_FORM = 0xFC2D;
const char32_t ARABIC_LIGATURE_FEH_WITH_HAH_ISOLATED_FORM = 0xFC2E;
const char32_t ARABIC_LIGATURE_FEH_WITH_KHAH_ISOLATED_FORM = 0xFC2F;
const char32_t ARABIC_LIGATURE_FEH_WITH_MEEM_ISOLATED_FORM = 0xFC30;
const char32_t ARABIC_LIGATURE_FEH_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFC31;
const char32_t ARABIC_LIGATURE_FEH_WITH_YEH_ISOLATED_FORM = 0xFC32;
const char32_t ARABIC_LIGATURE_QAF_WITH_HAH_ISOLATED_FORM = 0xFC33;
const char32_t ARABIC_LIGATURE_QAF_WITH_MEEM_ISOLATED_FORM = 0xFC34;
const char32_t ARABIC_LIGATURE_QAF_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFC35;
const char32_t ARABIC_LIGATURE_QAF_WITH_YEH_ISOLATED_FORM = 0xFC36;
const char32_t ARABIC_LIGATURE_KAF_WITH_ALEF_ISOLATED_FORM = 0xFC37;
const char32_t ARABIC_LIGATURE_KAF_WITH_JEEM_ISOLATED_FORM = 0xFC38;
const char32_t ARABIC_LIGATURE_KAF_WITH_HAH_ISOLATED_FORM = 0xFC39;
const char32_t ARABIC_LIGATURE_KAF_WITH_KHAH_ISOLATED_FORM = 0xFC3A;
const char32_t ARABIC_LIGATURE_KAF_WITH_LAM_ISOLATED_FORM = 0xFC3B;
const char32_t ARABIC_LIGATURE_KAF_WITH_MEEM_ISOLATED_FORM = 0xFC3C;
const char32_t ARABIC_LIGATURE_KAF_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFC3D;
const char32_t ARABIC_LIGATURE_KAF_WITH_YEH_ISOLATED_FORM = 0xFC3E;
const char32_t ARABIC_LIGATURE_LAM_WITH_JEEM_ISOLATED_FORM = 0xFC3F;
const char32_t ARABIC_LIGATURE_LAM_WITH_HAH_ISOLATED_FORM = 0xFC40;
const char32_t ARABIC_LIGATURE_LAM_WITH_KHAH_ISOLATED_FORM = 0xFC41;
const char32_t ARABIC_LIGATURE_LAM_WITH_MEEM_ISOLATED_FORM = 0xFC42;
const char32_t ARABIC_LIGATURE_LAM_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFC43;
const char32_t ARABIC_LIGATURE_LAM_WITH_YEH_ISOLATED_FORM = 0xFC44;
const char32_t ARABIC_LIGATURE_MEEM_WITH_JEEM_ISOLATED_FORM = 0xFC45;
const char32_t ARABIC_LIGATURE_MEEM_WITH_HAH_ISOLATED_FORM = 0xFC46;
const char32_t ARABIC_LIGATURE_MEEM_WITH_KHAH_ISOLATED_FORM = 0xFC47;
const char32_t ARABIC_LIGATURE_MEEM_WITH_MEEM_ISOLATED_FORM = 0xFC48;
const char32_t ARABIC_LIGATURE_MEEM_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFC49;
const char32_t ARABIC_LIGATURE_MEEM_WITH_YEH_ISOLATED_FORM = 0xFC4A;
const char32_t ARABIC_LIGATURE_NOON_WITH_JEEM_ISOLATED_FORM = 0xFC4B;
const char32_t ARABIC_LIGATURE_NOON_WITH_HAH_ISOLATED_FORM = 0xFC4C;
const char32_t ARABIC_LIGATURE_NOON_WITH_KHAH_ISOLATED_FORM = 0xFC4D;
const char32_t ARABIC_LIGATURE_NOON_WITH_MEEM_ISOLATED_FORM = 0xFC4E;
const char32_t ARABIC_LIGATURE_NOON_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFC4F;
const char32_t ARABIC_LIGATURE_NOON_WITH_YEH_ISOLATED_FORM = 0xFC50;
const char32_t ARABIC_LIGATURE_HEH_WITH_JEEM_ISOLATED_FORM = 0xFC51;
const char32_t ARABIC_LIGATURE_HEH_WITH_MEEM_ISOLATED_FORM = 0xFC52;
const char32_t ARABIC_LIGATURE_HEH_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFC53;
const char32_t ARABIC_LIGATURE_HEH_WITH_YEH_ISOLATED_FORM = 0xFC54;
const char32_t ARABIC_LIGATURE_YEH_WITH_JEEM_ISOLATED_FORM = 0xFC55;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAH_ISOLATED_FORM = 0xFC56;
const char32_t ARABIC_LIGATURE_YEH_WITH_KHAH_ISOLATED_FORM = 0xFC57;
const char32_t ARABIC_LIGATURE_YEH_WITH_MEEM_ISOLATED_FORM = 0xFC58;
const char32_t ARABIC_LIGATURE_YEH_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFC59;
const char32_t ARABIC_LIGATURE_YEH_WITH_YEH_ISOLATED_FORM = 0xFC5A;
const char32_t ARABIC_LIGATURE_THAL_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM = 0xFC5B;
const char32_t ARABIC_LIGATURE_REH_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM = 0xFC5C;
const char32_t ARABIC_LIGATURE_ALEF_MAKSURA_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM = 0xFC5D;
const char32_t ARABIC_LIGATURE_SHADDA_WITH_DAMMATAN_ISOLATED_FORM = 0xFC5E;
const char32_t ARABIC_LIGATURE_SHADDA_WITH_KASRATAN_ISOLATED_FORM = 0xFC5F;
const char32_t ARABIC_LIGATURE_SHADDA_WITH_FATHA_ISOLATED_FORM = 0xFC60;
const char32_t ARABIC_LIGATURE_SHADDA_WITH_DAMMA_ISOLATED_FORM = 0xFC61;
const char32_t ARABIC_LIGATURE_SHADDA_WITH_KASRA_ISOLATED_FORM = 0xFC62;
const char32_t ARABIC_LIGATURE_SHADDA_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM = 0xFC63;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_REH_FINAL_FORM = 0xFC64;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ZAIN_FINAL_FORM = 0xFC65;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_FINAL_FORM = 0xFC66;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_NOON_FINAL_FORM = 0xFC67;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFC68;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YEH_FINAL_FORM = 0xFC69;
const char32_t ARABIC_LIGATURE_BEH_WITH_REH_FINAL_FORM = 0xFC6A;
const char32_t ARABIC_LIGATURE_BEH_WITH_ZAIN_FINAL_FORM = 0xFC6B;
const char32_t ARABIC_LIGATURE_BEH_WITH_MEEM_FINAL_FORM = 0xFC6C;
const char32_t ARABIC_LIGATURE_BEH_WITH_NOON_FINAL_FORM = 0xFC6D;
const char32_t ARABIC_LIGATURE_BEH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFC6E;
const char32_t ARABIC_LIGATURE_BEH_WITH_YEH_FINAL_FORM = 0xFC6F;
const char32_t ARABIC_LIGATURE_TEH_WITH_REH_FINAL_FORM = 0xFC70;
const char32_t ARABIC_LIGATURE_TEH_WITH_ZAIN_FINAL_FORM = 0xFC71;
const char32_t ARABIC_LIGATURE_TEH_WITH_MEEM_FINAL_FORM = 0xFC72;
const char32_t ARABIC_LIGATURE_TEH_WITH_NOON_FINAL_FORM = 0xFC73;
const char32_t ARABIC_LIGATURE_TEH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFC74;
const char32_t ARABIC_LIGATURE_TEH_WITH_YEH_FINAL_FORM = 0xFC75;
const char32_t ARABIC_LIGATURE_THEH_WITH_REH_FINAL_FORM = 0xFC76;
const char32_t ARABIC_LIGATURE_THEH_WITH_ZAIN_FINAL_FORM = 0xFC77;
const char32_t ARABIC_LIGATURE_THEH_WITH_MEEM_FINAL_FORM = 0xFC78;
const char32_t ARABIC_LIGATURE_THEH_WITH_NOON_FINAL_FORM = 0xFC79;
const char32_t ARABIC_LIGATURE_THEH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFC7A;
const char32_t ARABIC_LIGATURE_THEH_WITH_YEH_FINAL_FORM = 0xFC7B;
const char32_t ARABIC_LIGATURE_FEH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFC7C;
const char32_t ARABIC_LIGATURE_FEH_WITH_YEH_FINAL_FORM = 0xFC7D;
const char32_t ARABIC_LIGATURE_QAF_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFC7E;
const char32_t ARABIC_LIGATURE_QAF_WITH_YEH_FINAL_FORM = 0xFC7F;
const char32_t ARABIC_LIGATURE_KAF_WITH_ALEF_FINAL_FORM = 0xFC80;
const char32_t ARABIC_LIGATURE_KAF_WITH_LAM_FINAL_FORM = 0xFC81;
const char32_t ARABIC_LIGATURE_KAF_WITH_MEEM_FINAL_FORM = 0xFC82;
const char32_t ARABIC_LIGATURE_KAF_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFC83;
const char32_t ARABIC_LIGATURE_KAF_WITH_YEH_FINAL_FORM = 0xFC84;
const char32_t ARABIC_LIGATURE_LAM_WITH_MEEM_FINAL_FORM = 0xFC85;
const char32_t ARABIC_LIGATURE_LAM_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFC86;
const char32_t ARABIC_LIGATURE_LAM_WITH_YEH_FINAL_FORM = 0xFC87;
const char32_t ARABIC_LIGATURE_MEEM_WITH_ALEF_FINAL_FORM = 0xFC88;
const char32_t ARABIC_LIGATURE_MEEM_WITH_MEEM_FINAL_FORM = 0xFC89;
const char32_t ARABIC_LIGATURE_NOON_WITH_REH_FINAL_FORM = 0xFC8A;
const char32_t ARABIC_LIGATURE_NOON_WITH_ZAIN_FINAL_FORM = 0xFC8B;
const char32_t ARABIC_LIGATURE_NOON_WITH_MEEM_FINAL_FORM = 0xFC8C;
const char32_t ARABIC_LIGATURE_NOON_WITH_NOON_FINAL_FORM = 0xFC8D;
const char32_t ARABIC_LIGATURE_NOON_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFC8E;
const char32_t ARABIC_LIGATURE_NOON_WITH_YEH_FINAL_FORM = 0xFC8F;
const char32_t ARABIC_LIGATURE_ALEF_MAKSURA_WITH_SUPERSCRIPT_ALEF_FINAL_FORM = 0xFC90;
const char32_t ARABIC_LIGATURE_YEH_WITH_REH_FINAL_FORM = 0xFC91;
const char32_t ARABIC_LIGATURE_YEH_WITH_ZAIN_FINAL_FORM = 0xFC92;
const char32_t ARABIC_LIGATURE_YEH_WITH_MEEM_FINAL_FORM = 0xFC93;
const char32_t ARABIC_LIGATURE_YEH_WITH_NOON_FINAL_FORM = 0xFC94;
const char32_t ARABIC_LIGATURE_YEH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFC95;
const char32_t ARABIC_LIGATURE_YEH_WITH_YEH_FINAL_FORM = 0xFC96;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_JEEM_INITIAL_FORM = 0xFC97;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HAH_INITIAL_FORM = 0xFC98;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_KHAH_INITIAL_FORM = 0xFC99;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_INITIAL_FORM = 0xFC9A;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HEH_INITIAL_FORM = 0xFC9B;
const char32_t ARABIC_LIGATURE_BEH_WITH_JEEM_INITIAL_FORM = 0xFC9C;
const char32_t ARABIC_LIGATURE_BEH_WITH_HAH_INITIAL_FORM = 0xFC9D;
const char32_t ARABIC_LIGATURE_BEH_WITH_KHAH_INITIAL_FORM = 0xFC9E;
const char32_t ARABIC_LIGATURE_BEH_WITH_MEEM_INITIAL_FORM = 0xFC9F;
const char32_t ARABIC_LIGATURE_BEH_WITH_HEH_INITIAL_FORM = 0xFCA0;
const char32_t ARABIC_LIGATURE_TEH_WITH_JEEM_INITIAL_FORM = 0xFCA1;
const char32_t ARABIC_LIGATURE_TEH_WITH_HAH_INITIAL_FORM = 0xFCA2;
const char32_t ARABIC_LIGATURE_TEH_WITH_KHAH_INITIAL_FORM = 0xFCA3;
const char32_t ARABIC_LIGATURE_TEH_WITH_MEEM_INITIAL_FORM = 0xFCA4;
const char32_t ARABIC_LIGATURE_TEH_WITH_HEH_INITIAL_FORM = 0xFCA5;
const char32_t ARABIC_LIGATURE_THEH_WITH_MEEM_INITIAL_FORM = 0xFCA6;
const char32_t ARABIC_LIGATURE_JEEM_WITH_HAH_INITIAL_FORM = 0xFCA7;
const char32_t ARABIC_LIGATURE_JEEM_WITH_MEEM_INITIAL_FORM = 0xFCA8;
const char32_t ARABIC_LIGATURE_HAH_WITH_JEEM_INITIAL_FORM = 0xFCA9;
const char32_t ARABIC_LIGATURE_HAH_WITH_MEEM_INITIAL_FORM = 0xFCAA;
const char32_t ARABIC_LIGATURE_KHAH_WITH_JEEM_INITIAL_FORM = 0xFCAB;
const char32_t ARABIC_LIGATURE_KHAH_WITH_MEEM_INITIAL_FORM = 0xFCAC;
const char32_t ARABIC_LIGATURE_SEEN_WITH_JEEM_INITIAL_FORM = 0xFCAD;
const char32_t ARABIC_LIGATURE_SEEN_WITH_HAH_INITIAL_FORM = 0xFCAE;
const char32_t ARABIC_LIGATURE_SEEN_WITH_KHAH_INITIAL_FORM = 0xFCAF;
const char32_t ARABIC_LIGATURE_SEEN_WITH_MEEM_INITIAL_FORM = 0xFCB0;
const char32_t ARABIC_LIGATURE_SAD_WITH_HAH_INITIAL_FORM = 0xFCB1;
const char32_t ARABIC_LIGATURE_SAD_WITH_KHAH_INITIAL_FORM = 0xFCB2;
const char32_t ARABIC_LIGATURE_SAD_WITH_MEEM_INITIAL_FORM = 0xFCB3;
const char32_t ARABIC_LIGATURE_DAD_WITH_JEEM_INITIAL_FORM = 0xFCB4;
const char32_t ARABIC_LIGATURE_DAD_WITH_HAH_INITIAL_FORM = 0xFCB5;
const char32_t ARABIC_LIGATURE_DAD_WITH_KHAH_INITIAL_FORM = 0xFCB6;
const char32_t ARABIC_LIGATURE_DAD_WITH_MEEM_INITIAL_FORM = 0xFCB7;
const char32_t ARABIC_LIGATURE_TAH_WITH_HAH_INITIAL_FORM = 0xFCB8;
const char32_t ARABIC_LIGATURE_ZAH_WITH_MEEM_INITIAL_FORM = 0xFCB9;
const char32_t ARABIC_LIGATURE_AIN_WITH_JEEM_INITIAL_FORM = 0xFCBA;
const char32_t ARABIC_LIGATURE_AIN_WITH_MEEM_INITIAL_FORM = 0xFCBB;
const char32_t ARABIC_LIGATURE_GHAIN_WITH_JEEM_INITIAL_FORM = 0xFCBC;
const char32_t ARABIC_LIGATURE_GHAIN_WITH_MEEM_INITIAL_FORM = 0xFCBD;
const char32_t ARABIC_LIGATURE_FEH_WITH_JEEM_INITIAL_FORM = 0xFCBE;
const char32_t ARABIC_LIGATURE_FEH_WITH_HAH_INITIAL_FORM = 0xFCBF;
const char32_t ARABIC_LIGATURE_FEH_WITH_KHAH_INITIAL_FORM = 0xFCC0;
const char32_t ARABIC_LIGATURE_FEH_WITH_MEEM_INITIAL_FORM = 0xFCC1;
const char32_t ARABIC_LIGATURE_QAF_WITH_HAH_INITIAL_FORM = 0xFCC2;
const char32_t ARABIC_LIGATURE_QAF_WITH_MEEM_INITIAL_FORM = 0xFCC3;
const char32_t ARABIC_LIGATURE_KAF_WITH_JEEM_INITIAL_FORM = 0xFCC4;
const char32_t ARABIC_LIGATURE_KAF_WITH_HAH_INITIAL_FORM = 0xFCC5;
const char32_t ARABIC_LIGATURE_KAF_WITH_KHAH_INITIAL_FORM = 0xFCC6;
const char32_t ARABIC_LIGATURE_KAF_WITH_LAM_INITIAL_FORM = 0xFCC7;
const char32_t ARABIC_LIGATURE_KAF_WITH_MEEM_INITIAL_FORM = 0xFCC8;
const char32_t ARABIC_LIGATURE_LAM_WITH_JEEM_INITIAL_FORM = 0xFCC9;
const char32_t ARABIC_LIGATURE_LAM_WITH_HAH_INITIAL_FORM = 0xFCCA;
const char32_t ARABIC_LIGATURE_LAM_WITH_KHAH_INITIAL_FORM = 0xFCCB;
const char32_t ARABIC_LIGATURE_LAM_WITH_MEEM_INITIAL_FORM = 0xFCCC;
const char32_t ARABIC_LIGATURE_LAM_WITH_HEH_INITIAL_FORM = 0xFCCD;
const char32_t ARABIC_LIGATURE_MEEM_WITH_JEEM_INITIAL_FORM = 0xFCCE;
const char32_t ARABIC_LIGATURE_MEEM_WITH_HAH_INITIAL_FORM = 0xFCCF;
const char32_t ARABIC_LIGATURE_MEEM_WITH_KHAH_INITIAL_FORM = 0xFCD0;
const char32_t ARABIC_LIGATURE_MEEM_WITH_MEEM_INITIAL_FORM = 0xFCD1;
const char32_t ARABIC_LIGATURE_NOON_WITH_JEEM_INITIAL_FORM = 0xFCD2;
const char32_t ARABIC_LIGATURE_NOON_WITH_HAH_INITIAL_FORM = 0xFCD3;
const char32_t ARABIC_LIGATURE_NOON_WITH_KHAH_INITIAL_FORM = 0xFCD4;
const char32_t ARABIC_LIGATURE_NOON_WITH_MEEM_INITIAL_FORM = 0xFCD5;
const char32_t ARABIC_LIGATURE_NOON_WITH_HEH_INITIAL_FORM = 0xFCD6;
const char32_t ARABIC_LIGATURE_HEH_WITH_JEEM_INITIAL_FORM = 0xFCD7;
const char32_t ARABIC_LIGATURE_HEH_WITH_MEEM_INITIAL_FORM = 0xFCD8;
const char32_t ARABIC_LIGATURE_HEH_WITH_SUPERSCRIPT_ALEF_INITIAL_FORM = 0xFCD9;
const char32_t ARABIC_LIGATURE_YEH_WITH_JEEM_INITIAL_FORM = 0xFCDA;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAH_INITIAL_FORM = 0xFCDB;
const char32_t ARABIC_LIGATURE_YEH_WITH_KHAH_INITIAL_FORM = 0xFCDC;
const char32_t ARABIC_LIGATURE_YEH_WITH_MEEM_INITIAL_FORM = 0xFCDD;
const char32_t ARABIC_LIGATURE_YEH_WITH_HEH_INITIAL_FORM = 0xFCDE;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_MEDIAL_FORM = 0xFCDF;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HEH_MEDIAL_FORM = 0xFCE0;
const char32_t ARABIC_LIGATURE_BEH_WITH_MEEM_MEDIAL_FORM = 0xFCE1;
const char32_t ARABIC_LIGATURE_BEH_WITH_HEH_MEDIAL_FORM = 0xFCE2;
const char32_t ARABIC_LIGATURE_TEH_WITH_MEEM_MEDIAL_FORM = 0xFCE3;
const char32_t ARABIC_LIGATURE_TEH_WITH_HEH_MEDIAL_FORM = 0xFCE4;
const char32_t ARABIC_LIGATURE_THEH_WITH_MEEM_MEDIAL_FORM = 0xFCE5;
const char32_t ARABIC_LIGATURE_THEH_WITH_HEH_MEDIAL_FORM = 0xFCE6;
const char32_t ARABIC_LIGATURE_SEEN_WITH_MEEM_MEDIAL_FORM = 0xFCE7;
const char32_t ARABIC_LIGATURE_SEEN_WITH_HEH_MEDIAL_FORM = 0xFCE8;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_MEEM_MEDIAL_FORM = 0xFCE9;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_HEH_MEDIAL_FORM = 0xFCEA;
const char32_t ARABIC_LIGATURE_KAF_WITH_LAM_MEDIAL_FORM = 0xFCEB;
const char32_t ARABIC_LIGATURE_KAF_WITH_MEEM_MEDIAL_FORM = 0xFCEC;
const char32_t ARABIC_LIGATURE_LAM_WITH_MEEM_MEDIAL_FORM = 0xFCED;
const char32_t ARABIC_LIGATURE_NOON_WITH_MEEM_MEDIAL_FORM = 0xFCEE;
const char32_t ARABIC_LIGATURE_NOON_WITH_HEH_MEDIAL_FORM = 0xFCEF;
const char32_t ARABIC_LIGATURE_YEH_WITH_MEEM_MEDIAL_FORM = 0xFCF0;
const char32_t ARABIC_LIGATURE_YEH_WITH_HEH_MEDIAL_FORM = 0xFCF1;
const char32_t ARABIC_LIGATURE_SHADDA_WITH_FATHA_MEDIAL_FORM = 0xFCF2;
const char32_t ARABIC_LIGATURE_SHADDA_WITH_DAMMA_MEDIAL_FORM = 0xFCF3;
const char32_t ARABIC_LIGATURE_SHADDA_WITH_KASRA_MEDIAL_FORM = 0xFCF4;
const char32_t ARABIC_LIGATURE_TAH_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFCF5;
const char32_t ARABIC_LIGATURE_TAH_WITH_YEH_ISOLATED_FORM = 0xFCF6;
const char32_t ARABIC_LIGATURE_AIN_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFCF7;
const char32_t ARABIC_LIGATURE_AIN_WITH_YEH_ISOLATED_FORM = 0xFCF8;
const char32_t ARABIC_LIGATURE_GHAIN_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFCF9;
const char32_t ARABIC_LIGATURE_GHAIN_WITH_YEH_ISOLATED_FORM = 0xFCFA;
const char32_t ARABIC_LIGATURE_SEEN_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFCFB;
const char32_t ARABIC_LIGATURE_SEEN_WITH_YEH_ISOLATED_FORM = 0xFCFC;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFCFD;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_YEH_ISOLATED_FORM = 0xFCFE;
const char32_t ARABIC_LIGATURE_HAH_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFCFF;
const char32_t ARABIC_LIGATURE_HAH_WITH_YEH_ISOLATED_FORM = 0xFD00;
const char32_t ARABIC_LIGATURE_JEEM_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFD01;
const char32_t ARABIC_LIGATURE_JEEM_WITH_YEH_ISOLATED_FORM = 0xFD02;
const char32_t ARABIC_LIGATURE_KHAH_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFD03;
const char32_t ARABIC_LIGATURE_KHAH_WITH_YEH_ISOLATED_FORM = 0xFD04;
const char32_t ARABIC_LIGATURE_SAD_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFD05;
const char32_t ARABIC_LIGATURE_SAD_WITH_YEH_ISOLATED_FORM = 0xFD06;
const char32_t ARABIC_LIGATURE_DAD_WITH_ALEF_MAKSURA_ISOLATED_FORM = 0xFD07;
const char32_t ARABIC_LIGATURE_DAD_WITH_YEH_ISOLATED_FORM = 0xFD08;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_JEEM_ISOLATED_FORM = 0xFD09;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_HAH_ISOLATED_FORM = 0xFD0A;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_KHAH_ISOLATED_FORM = 0xFD0B;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_MEEM_ISOLATED_FORM = 0xFD0C;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_REH_ISOLATED_FORM = 0xFD0D;
const char32_t ARABIC_LIGATURE_SEEN_WITH_REH_ISOLATED_FORM = 0xFD0E;
const char32_t ARABIC_LIGATURE_SAD_WITH_REH_ISOLATED_FORM = 0xFD0F;
const char32_t ARABIC_LIGATURE_DAD_WITH_REH_ISOLATED_FORM = 0xFD10;
const char32_t ARABIC_LIGATURE_TAH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD11;
const char32_t ARABIC_LIGATURE_TAH_WITH_YEH_FINAL_FORM = 0xFD12;
const char32_t ARABIC_LIGATURE_AIN_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD13;
const char32_t ARABIC_LIGATURE_AIN_WITH_YEH_FINAL_FORM = 0xFD14;
const char32_t ARABIC_LIGATURE_GHAIN_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD15;
const char32_t ARABIC_LIGATURE_GHAIN_WITH_YEH_FINAL_FORM = 0xFD16;
const char32_t ARABIC_LIGATURE_SEEN_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD17;
const char32_t ARABIC_LIGATURE_SEEN_WITH_YEH_FINAL_FORM = 0xFD18;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD19;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_YEH_FINAL_FORM = 0xFD1A;
const char32_t ARABIC_LIGATURE_HAH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD1B;
const char32_t ARABIC_LIGATURE_HAH_WITH_YEH_FINAL_FORM = 0xFD1C;
const char32_t ARABIC_LIGATURE_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD1D;
const char32_t ARABIC_LIGATURE_JEEM_WITH_YEH_FINAL_FORM = 0xFD1E;
const char32_t ARABIC_LIGATURE_KHAH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD1F;
const char32_t ARABIC_LIGATURE_KHAH_WITH_YEH_FINAL_FORM = 0xFD20;
const char32_t ARABIC_LIGATURE_SAD_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD21;
const char32_t ARABIC_LIGATURE_SAD_WITH_YEH_FINAL_FORM = 0xFD22;
const char32_t ARABIC_LIGATURE_DAD_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD23;
const char32_t ARABIC_LIGATURE_DAD_WITH_YEH_FINAL_FORM = 0xFD24;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_JEEM_FINAL_FORM = 0xFD25;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_HAH_FINAL_FORM = 0xFD26;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_KHAH_FINAL_FORM = 0xFD27;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_MEEM_FINAL_FORM = 0xFD28;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_REH_FINAL_FORM = 0xFD29;
const char32_t ARABIC_LIGATURE_SEEN_WITH_REH_FINAL_FORM = 0xFD2A;
const char32_t ARABIC_LIGATURE_SAD_WITH_REH_FINAL_FORM = 0xFD2B;
const char32_t ARABIC_LIGATURE_DAD_WITH_REH_FINAL_FORM = 0xFD2C;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_JEEM_INITIAL_FORM = 0xFD2D;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_HAH_INITIAL_FORM = 0xFD2E;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_KHAH_INITIAL_FORM = 0xFD2F;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_MEEM_INITIAL_FORM = 0xFD30;
const char32_t ARABIC_LIGATURE_SEEN_WITH_HEH_INITIAL_FORM = 0xFD31;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_HEH_INITIAL_FORM = 0xFD32;
const char32_t ARABIC_LIGATURE_TAH_WITH_MEEM_INITIAL_FORM = 0xFD33;
const char32_t ARABIC_LIGATURE_SEEN_WITH_JEEM_MEDIAL_FORM = 0xFD34;
const char32_t ARABIC_LIGATURE_SEEN_WITH_HAH_MEDIAL_FORM = 0xFD35;
const char32_t ARABIC_LIGATURE_SEEN_WITH_KHAH_MEDIAL_FORM = 0xFD36;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_JEEM_MEDIAL_FORM = 0xFD37;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_HAH_MEDIAL_FORM = 0xFD38;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_KHAH_MEDIAL_FORM = 0xFD39;
const char32_t ARABIC_LIGATURE_TAH_WITH_MEEM_MEDIAL_FORM = 0xFD3A;
const char32_t ARABIC_LIGATURE_ZAH_WITH_MEEM_MEDIAL_FORM = 0xFD3B;
const char32_t ARABIC_LIGATURE_ALEF_WITH_FATHATAN_FINAL_FORM = 0xFD3C;
const char32_t ARABIC_LIGATURE_ALEF_WITH_FATHATAN_ISOLATED_FORM = 0xFD3D;
const char32_t ORNATE_LEFT_PARENTHESIS = 0xFD3E;
const char32_t ORNATE_RIGHT_PARENTHESIS = 0xFD3F;
const char32_t ARABIC_LIGATURE_TEH_WITH_JEEM_WITH_MEEM_INITIAL_FORM = 0xFD50;
const char32_t ARABIC_LIGATURE_TEH_WITH_HAH_WITH_JEEM_FINAL_FORM = 0xFD51;
const char32_t ARABIC_LIGATURE_TEH_WITH_HAH_WITH_JEEM_INITIAL_FORM = 0xFD52;
const char32_t ARABIC_LIGATURE_TEH_WITH_HAH_WITH_MEEM_INITIAL_FORM = 0xFD53;
const char32_t ARABIC_LIGATURE_TEH_WITH_KHAH_WITH_MEEM_INITIAL_FORM = 0xFD54;
const char32_t ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_JEEM_INITIAL_FORM = 0xFD55;
const char32_t ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_HAH_INITIAL_FORM = 0xFD56;
const char32_t ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_KHAH_INITIAL_FORM = 0xFD57;
const char32_t ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_HAH_FINAL_FORM = 0xFD58;
const char32_t ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_HAH_INITIAL_FORM = 0xFD59;
const char32_t ARABIC_LIGATURE_HAH_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFD5A;
const char32_t ARABIC_LIGATURE_HAH_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD5B;
const char32_t ARABIC_LIGATURE_SEEN_WITH_HAH_WITH_JEEM_INITIAL_FORM = 0xFD5C;
const char32_t ARABIC_LIGATURE_SEEN_WITH_JEEM_WITH_HAH_INITIAL_FORM = 0xFD5D;
const char32_t ARABIC_LIGATURE_SEEN_WITH_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD5E;
const char32_t ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_HAH_FINAL_FORM = 0xFD5F;
const char32_t ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_HAH_INITIAL_FORM = 0xFD60;
const char32_t ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_JEEM_INITIAL_FORM = 0xFD61;
const char32_t ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_MEEM_FINAL_FORM = 0xFD62;
const char32_t ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_MEEM_INITIAL_FORM = 0xFD63;
const char32_t ARABIC_LIGATURE_SAD_WITH_HAH_WITH_HAH_FINAL_FORM = 0xFD64;
const char32_t ARABIC_LIGATURE_SAD_WITH_HAH_WITH_HAH_INITIAL_FORM = 0xFD65;
const char32_t ARABIC_LIGATURE_SAD_WITH_MEEM_WITH_MEEM_FINAL_FORM = 0xFD66;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_HAH_WITH_MEEM_FINAL_FORM = 0xFD67;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_HAH_WITH_MEEM_INITIAL_FORM = 0xFD68;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_JEEM_WITH_YEH_FINAL_FORM = 0xFD69;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_KHAH_FINAL_FORM = 0xFD6A;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_KHAH_INITIAL_FORM = 0xFD6B;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_MEEM_FINAL_FORM = 0xFD6C;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_MEEM_INITIAL_FORM = 0xFD6D;
const char32_t ARABIC_LIGATURE_DAD_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD6E;
const char32_t ARABIC_LIGATURE_DAD_WITH_KHAH_WITH_MEEM_FINAL_FORM = 0xFD6F;
const char32_t ARABIC_LIGATURE_DAD_WITH_KHAH_WITH_MEEM_INITIAL_FORM = 0xFD70;
const char32_t ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_HAH_FINAL_FORM = 0xFD71;
const char32_t ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_HAH_INITIAL_FORM = 0xFD72;
const char32_t ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_MEEM_INITIAL_FORM = 0xFD73;
const char32_t ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFD74;
const char32_t ARABIC_LIGATURE_AIN_WITH_JEEM_WITH_MEEM_FINAL_FORM = 0xFD75;
const char32_t ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_MEEM_FINAL_FORM = 0xFD76;
const char32_t ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_MEEM_INITIAL_FORM = 0xFD77;
const char32_t ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD78;
const char32_t ARABIC_LIGATURE_GHAIN_WITH_MEEM_WITH_MEEM_FINAL_FORM = 0xFD79;
const char32_t ARABIC_LIGATURE_GHAIN_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFD7A;
const char32_t ARABIC_LIGATURE_GHAIN_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD7B;
const char32_t ARABIC_LIGATURE_FEH_WITH_KHAH_WITH_MEEM_FINAL_FORM = 0xFD7C;
const char32_t ARABIC_LIGATURE_FEH_WITH_KHAH_WITH_MEEM_INITIAL_FORM = 0xFD7D;
const char32_t ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_HAH_FINAL_FORM = 0xFD7E;
const char32_t ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_MEEM_FINAL_FORM = 0xFD7F;
const char32_t ARABIC_LIGATURE_LAM_WITH_HAH_WITH_MEEM_FINAL_FORM = 0xFD80;
const char32_t ARABIC_LIGATURE_LAM_WITH_HAH_WITH_YEH_FINAL_FORM = 0xFD81;
const char32_t ARABIC_LIGATURE_LAM_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD82;
const char32_t ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_JEEM_INITIAL_FORM = 0xFD83;
const char32_t ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_JEEM_FINAL_FORM = 0xFD84;
const char32_t ARABIC_LIGATURE_LAM_WITH_KHAH_WITH_MEEM_FINAL_FORM = 0xFD85;
const char32_t ARABIC_LIGATURE_LAM_WITH_KHAH_WITH_MEEM_INITIAL_FORM = 0xFD86;
const char32_t ARABIC_LIGATURE_LAM_WITH_MEEM_WITH_HAH_FINAL_FORM = 0xFD87;
const char32_t ARABIC_LIGATURE_LAM_WITH_MEEM_WITH_HAH_INITIAL_FORM = 0xFD88;
const char32_t ARABIC_LIGATURE_MEEM_WITH_HAH_WITH_JEEM_INITIAL_FORM = 0xFD89;
const char32_t ARABIC_LIGATURE_MEEM_WITH_HAH_WITH_MEEM_INITIAL_FORM = 0xFD8A;
const char32_t ARABIC_LIGATURE_MEEM_WITH_HAH_WITH_YEH_FINAL_FORM = 0xFD8B;
const char32_t ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_HAH_INITIAL_FORM = 0xFD8C;
const char32_t ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_MEEM_INITIAL_FORM = 0xFD8D;
const char32_t ARABIC_LIGATURE_MEEM_WITH_KHAH_WITH_JEEM_INITIAL_FORM = 0xFD8E;
const char32_t ARABIC_LIGATURE_MEEM_WITH_KHAH_WITH_MEEM_INITIAL_FORM = 0xFD8F;
const char32_t ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_KHAH_INITIAL_FORM = 0xFD92;
const char32_t ARABIC_LIGATURE_HEH_WITH_MEEM_WITH_JEEM_INITIAL_FORM = 0xFD93;
const char32_t ARABIC_LIGATURE_HEH_WITH_MEEM_WITH_MEEM_INITIAL_FORM = 0xFD94;
const char32_t ARABIC_LIGATURE_NOON_WITH_HAH_WITH_MEEM_INITIAL_FORM = 0xFD95;
const char32_t ARABIC_LIGATURE_NOON_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD96;
const char32_t ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_MEEM_FINAL_FORM = 0xFD97;
const char32_t ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_MEEM_INITIAL_FORM = 0xFD98;
const char32_t ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD99;
const char32_t ARABIC_LIGATURE_NOON_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFD9A;
const char32_t ARABIC_LIGATURE_NOON_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFD9B;
const char32_t ARABIC_LIGATURE_YEH_WITH_MEEM_WITH_MEEM_FINAL_FORM = 0xFD9C;
const char32_t ARABIC_LIGATURE_YEH_WITH_MEEM_WITH_MEEM_INITIAL_FORM = 0xFD9D;
const char32_t ARABIC_LIGATURE_BEH_WITH_KHAH_WITH_YEH_FINAL_FORM = 0xFD9E;
const char32_t ARABIC_LIGATURE_TEH_WITH_JEEM_WITH_YEH_FINAL_FORM = 0xFD9F;
const char32_t ARABIC_LIGATURE_TEH_WITH_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFDA0;
const char32_t ARABIC_LIGATURE_TEH_WITH_KHAH_WITH_YEH_FINAL_FORM = 0xFDA1;
const char32_t ARABIC_LIGATURE_TEH_WITH_KHAH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFDA2;
const char32_t ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFDA3;
const char32_t ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFDA4;
const char32_t ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFDA5;
const char32_t ARABIC_LIGATURE_JEEM_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFDA6;
const char32_t ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFDA7;
const char32_t ARABIC_LIGATURE_SEEN_WITH_KHAH_WITH_ALEF_MAKSURA_FINAL_FORM = 0xFDA8;
const char32_t ARABIC_LIGATURE_SAD_WITH_HAH_WITH_YEH_FINAL_FORM = 0xFDA9;
const char32_t ARABIC_LIGATURE_SHEEN_WITH_HAH_WITH_YEH_FINAL_FORM = 0xFDAA;
const char32_t ARABIC_LIGATURE_DAD_WITH_HAH_WITH_YEH_FINAL_FORM = 0xFDAB;
const char32_t ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_YEH_FINAL_FORM = 0xFDAC;
const char32_t ARABIC_LIGATURE_LAM_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFDAD;
const char32_t ARABIC_LIGATURE_YEH_WITH_HAH_WITH_YEH_FINAL_FORM = 0xFDAE;
const char32_t ARABIC_LIGATURE_YEH_WITH_JEEM_WITH_YEH_FINAL_FORM = 0xFDAF;
const char32_t ARABIC_LIGATURE_YEH_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFDB0;
const char32_t ARABIC_LIGATURE_MEEM_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFDB1;
const char32_t ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFDB2;
const char32_t ARABIC_LIGATURE_NOON_WITH_HAH_WITH_YEH_FINAL_FORM = 0xFDB3;
const char32_t ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_HAH_INITIAL_FORM = 0xFDB4;
const char32_t ARABIC_LIGATURE_LAM_WITH_HAH_WITH_MEEM_INITIAL_FORM = 0xFDB5;
const char32_t ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFDB6;
const char32_t ARABIC_LIGATURE_KAF_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFDB7;
const char32_t ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_HAH_INITIAL_FORM = 0xFDB8;
const char32_t ARABIC_LIGATURE_MEEM_WITH_KHAH_WITH_YEH_FINAL_FORM = 0xFDB9;
const char32_t ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_MEEM_INITIAL_FORM = 0xFDBA;
const char32_t ARABIC_LIGATURE_KAF_WITH_MEEM_WITH_MEEM_FINAL_FORM = 0xFDBB;
const char32_t ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_MEEM_FINAL_FORM = 0xFDBC;
const char32_t ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_HAH_FINAL_FORM = 0xFDBD;
const char32_t ARABIC_LIGATURE_JEEM_WITH_HAH_WITH_YEH_FINAL_FORM = 0xFDBE;
const char32_t ARABIC_LIGATURE_HAH_WITH_JEEM_WITH_YEH_FINAL_FORM = 0xFDBF;
const char32_t ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_YEH_FINAL_FORM = 0xFDC0;
const char32_t ARABIC_LIGATURE_FEH_WITH_MEEM_WITH_YEH_FINAL_FORM = 0xFDC1;
const char32_t ARABIC_LIGATURE_BEH_WITH_HAH_WITH_YEH_FINAL_FORM = 0xFDC2;
const char32_t ARABIC_LIGATURE_KAF_WITH_MEEM_WITH_MEEM_INITIAL_FORM = 0xFDC3;
const char32_t ARABIC_LIGATURE_AIN_WITH_JEEM_WITH_MEEM_INITIAL_FORM = 0xFDC4;
const char32_t ARABIC_LIGATURE_SAD_WITH_MEEM_WITH_MEEM_INITIAL_FORM = 0xFDC5;
const char32_t ARABIC_LIGATURE_SEEN_WITH_KHAH_WITH_YEH_FINAL_FORM = 0xFDC6;
const char32_t ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_YEH_FINAL_FORM = 0xFDC7;
const char32_t ARABIC_LIGATURE_SALLA_USED_AS_KORANIC_STOP_SIGN_ISOLATED_FORM = 0xFDF0;
const char32_t ARABIC_LIGATURE_QALA_USED_AS_KORANIC_STOP_SIGN_ISOLATED_FORM = 0xFDF1;
const char32_t ARABIC_LIGATURE_ALLAH_ISOLATED_FORM = 0xFDF2;
const char32_t ARABIC_LIGATURE_AKBAR_ISOLATED_FORM = 0xFDF3;
const char32_t ARABIC_LIGATURE_MOHAMMAD_ISOLATED_FORM = 0xFDF4;
const char32_t ARABIC_LIGATURE_SALAM_ISOLATED_FORM = 0xFDF5;
const char32_t ARABIC_LIGATURE_RASOUL_ISOLATED_FORM = 0xFDF6;
const char32_t ARABIC_LIGATURE_ALAYHE_ISOLATED_FORM = 0xFDF7;
const char32_t ARABIC_LIGATURE_WASALLAM_ISOLATED_FORM = 0xFDF8;
const char32_t ARABIC_LIGATURE_SALLA_ISOLATED_FORM = 0xFDF9;
const char32_t ARABIC_LIGATURE_SALLALLAHOU_ALAYHE_WASALLAM = 0xFDFA;
const char32_t ARABIC_LIGATURE_JALLAJALALOUHOU = 0xFDFB;
const char32_t RIAL_SIGN = 0xFDFC;
const char32_t ARABIC_LIGATURE_BISMILLAH_AR_RAHMAN_AR_RAHEEM = 0xFDFD;
const char32_t VARIATION_SELECTOR_1 = 0xFE00;
const char32_t VARIATION_SELECTOR_2 = 0xFE01;
const char32_t VARIATION_SELECTOR_3 = 0xFE02;
const char32_t VARIATION_SELECTOR_4 = 0xFE03;
const char32_t VARIATION_SELECTOR_5 = 0xFE04;
const char32_t VARIATION_SELECTOR_6 = 0xFE05;
const char32_t VARIATION_SELECTOR_7 = 0xFE06;
const char32_t VARIATION_SELECTOR_8 = 0xFE07;
const char32_t VARIATION_SELECTOR_9 = 0xFE08;
const char32_t VARIATION_SELECTOR_10 = 0xFE09;
const char32_t VARIATION_SELECTOR_11 = 0xFE0A;
const char32_t VARIATION_SELECTOR_12 = 0xFE0B;
const char32_t VARIATION_SELECTOR_13 = 0xFE0C;
const char32_t VARIATION_SELECTOR_14 = 0xFE0D;
const char32_t VARIATION_SELECTOR_15 = 0xFE0E;
const char32_t VARIATION_SELECTOR_16 = 0xFE0F;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_COMMA = 0xFE10;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_IDEOGRAPHIC_COMMA = 0xFE11;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_IDEOGRAPHIC_FULL_STOP = 0xFE12;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_COLON = 0xFE13;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_SEMICOLON = 0xFE14;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_EXCLAMATION_MARK = 0xFE15;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_QUESTION_MARK = 0xFE16;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_LEFT_WHITE_LENTICULAR_BRACKET = 0xFE17;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_RIGHT_WHITE_LENTICULAR_BRAKCET = 0xFE18;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_HORIZONTAL_ELLIPSIS = 0xFE19;
const char32_t COMBINING_LIGATURE_LEFT_HALF = 0xFE20;
const char32_t COMBINING_LIGATURE_RIGHT_HALF = 0xFE21;
const char32_t COMBINING_DOUBLE_TILDE_LEFT_HALF = 0xFE22;
const char32_t COMBINING_DOUBLE_TILDE_RIGHT_HALF = 0xFE23;
const char32_t COMBINING_MACRON_LEFT_HALF = 0xFE24;
const char32_t COMBINING_MACRON_RIGHT_HALF = 0xFE25;
const char32_t COMBINING_CONJOINING_MACRON = 0xFE26;
const char32_t COMBINING_LIGATURE_LEFT_HALF_BELOW = 0xFE27;
const char32_t COMBINING_LIGATURE_RIGHT_HALF_BELOW = 0xFE28;
const char32_t COMBINING_TILDE_LEFT_HALF_BELOW = 0xFE29;
const char32_t COMBINING_TILDE_RIGHT_HALF_BELOW = 0xFE2A;
const char32_t COMBINING_MACRON_LEFT_HALF_BELOW = 0xFE2B;
const char32_t COMBINING_MACRON_RIGHT_HALF_BELOW = 0xFE2C;
const char32_t COMBINING_CONJOINING_MACRON_BELOW = 0xFE2D;
const char32_t COMBINING_CYRILLIC_TITLO_LEFT_HALF = 0xFE2E;
const char32_t COMBINING_CYRILLIC_TITLO_RIGHT_HALF = 0xFE2F;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_TWO_DOT_LEADER = 0xFE30;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_EM_DASH = 0xFE31;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_EN_DASH = 0xFE32;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_LOW_LINE = 0xFE33;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_WAVY_LOW_LINE = 0xFE34;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_LEFT_PARENTHESIS = 0xFE35;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_RIGHT_PARENTHESIS = 0xFE36;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_LEFT_CURLY_BRACKET = 0xFE37;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_RIGHT_CURLY_BRACKET = 0xFE38;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_LEFT_TORTOISE_SHELL_BRACKET = 0xFE39;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_RIGHT_TORTOISE_SHELL_BRACKET = 0xFE3A;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_LEFT_BLACK_LENTICULAR_BRACKET = 0xFE3B;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_RIGHT_BLACK_LENTICULAR_BRACKET = 0xFE3C;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_LEFT_DOUBLE_ANGLE_BRACKET = 0xFE3D;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_RIGHT_DOUBLE_ANGLE_BRACKET = 0xFE3E;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_LEFT_ANGLE_BRACKET = 0xFE3F;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_RIGHT_ANGLE_BRACKET = 0xFE40;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_LEFT_CORNER_BRACKET = 0xFE41;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_RIGHT_CORNER_BRACKET = 0xFE42;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_LEFT_WHITE_CORNER_BRACKET = 0xFE43;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_RIGHT_WHITE_CORNER_BRACKET = 0xFE44;
const char32_t SESAME_DOT = 0xFE45;
const char32_t WHITE_SESAME_DOT = 0xFE46;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_LEFT_SQUARE_BRACKET = 0xFE47;
const char32_t PRESENTATION_FORM_FOR_VERTICAL_RIGHT_SQUARE_BRACKET = 0xFE48;
const char32_t DASHED_OVERLINE = 0xFE49;
const char32_t CENTRELINE_OVERLINE = 0xFE4A;
const char32_t WAVY_OVERLINE = 0xFE4B;
const char32_t DOUBLE_WAVY_OVERLINE = 0xFE4C;
const char32_t DASHED_LOW_LINE = 0xFE4D;
const char32_t CENTRELINE_LOW_LINE = 0xFE4E;
const char32_t WAVY_LOW_LINE = 0xFE4F;
const char32_t SMALL_COMMA = 0xFE50;
const char32_t SMALL_IDEOGRAPHIC_COMMA = 0xFE51;
const char32_t SMALL_FULL_STOP = 0xFE52;
const char32_t SMALL_SEMICOLON = 0xFE54;
const char32_t SMALL_COLON = 0xFE55;
const char32_t SMALL_QUESTION_MARK = 0xFE56;
const char32_t SMALL_EXCLAMATION_MARK = 0xFE57;
const char32_t SMALL_EM_DASH = 0xFE58;
const char32_t SMALL_LEFT_PARENTHESIS = 0xFE59;
const char32_t SMALL_RIGHT_PARENTHESIS = 0xFE5A;
const char32_t SMALL_LEFT_CURLY_BRACKET = 0xFE5B;
const char32_t SMALL_RIGHT_CURLY_BRACKET = 0xFE5C;
const char32_t SMALL_LEFT_TORTOISE_SHELL_BRACKET = 0xFE5D;
const char32_t SMALL_RIGHT_TORTOISE_SHELL_BRACKET = 0xFE5E;
const char32_t SMALL_NUMBER_SIGN = 0xFE5F;
const char32_t SMALL_AMPERSAND = 0xFE60;
const char32_t SMALL_ASTERISK = 0xFE61;
const char32_t SMALL_PLUS_SIGN = 0xFE62;
const char32_t SMALL_HYPHEN_MINUS = 0xFE63;
const char32_t SMALL_LESS_THAN_SIGN = 0xFE64;
const char32_t SMALL_GREATER_THAN_SIGN = 0xFE65;
const char32_t SMALL_EQUALS_SIGN = 0xFE66;
const char32_t SMALL_REVERSE_SOLIDUS = 0xFE68;
const char32_t SMALL_DOLLAR_SIGN = 0xFE69;
const char32_t SMALL_PERCENT_SIGN = 0xFE6A;
const char32_t SMALL_COMMERCIAL_AT = 0xFE6B;
const char32_t ARABIC_FATHATAN_ISOLATED_FORM = 0xFE70;
const char32_t ARABIC_TATWEEL_WITH_FATHATAN_ABOVE = 0xFE71;
const char32_t ARABIC_DAMMATAN_ISOLATED_FORM = 0xFE72;
const char32_t ARABIC_TAIL_FRAGMENT = 0xFE73;
const char32_t ARABIC_KASRATAN_ISOLATED_FORM = 0xFE74;
const char32_t ARABIC_FATHA_ISOLATED_FORM = 0xFE76;
const char32_t ARABIC_FATHA_MEDIAL_FORM = 0xFE77;
const char32_t ARABIC_DAMMA_ISOLATED_FORM = 0xFE78;
const char32_t ARABIC_DAMMA_MEDIAL_FORM = 0xFE79;
const char32_t ARABIC_KASRA_ISOLATED_FORM = 0xFE7A;
const char32_t ARABIC_KASRA_MEDIAL_FORM = 0xFE7B;
const char32_t ARABIC_SHADDA_ISOLATED_FORM = 0xFE7C;
const char32_t ARABIC_SHADDA_MEDIAL_FORM = 0xFE7D;
const char32_t ARABIC_SUKUN_ISOLATED_FORM = 0xFE7E;
const char32_t ARABIC_SUKUN_MEDIAL_FORM = 0xFE7F;
const char32_t ARABIC_LETTER_HAMZA_ISOLATED_FORM = 0xFE80;
const char32_t ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE_ISOLATED_FORM = 0xFE81;
const char32_t ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE_FINAL_FORM = 0xFE82;
const char32_t ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE_ISOLATED_FORM = 0xFE83;
const char32_t ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE_FINAL_FORM = 0xFE84;
const char32_t ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE_ISOLATED_FORM = 0xFE85;
const char32_t ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE_FINAL_FORM = 0xFE86;
const char32_t ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW_ISOLATED_FORM = 0xFE87;
const char32_t ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW_FINAL_FORM = 0xFE88;
const char32_t ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_ISOLATED_FORM = 0xFE89;
const char32_t ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_FINAL_FORM = 0xFE8A;
const char32_t ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_INITIAL_FORM = 0xFE8B;
const char32_t ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_MEDIAL_FORM = 0xFE8C;
const char32_t ARABIC_LETTER_ALEF_ISOLATED_FORM = 0xFE8D;
const char32_t ARABIC_LETTER_ALEF_FINAL_FORM = 0xFE8E;
const char32_t ARABIC_LETTER_BEH_ISOLATED_FORM = 0xFE8F;
const char32_t ARABIC_LETTER_BEH_FINAL_FORM = 0xFE90;
const char32_t ARABIC_LETTER_BEH_INITIAL_FORM = 0xFE91;
const char32_t ARABIC_LETTER_BEH_MEDIAL_FORM = 0xFE92;
const char32_t ARABIC_LETTER_TEH_MARBUTA_ISOLATED_FORM = 0xFE93;
const char32_t ARABIC_LETTER_TEH_MARBUTA_FINAL_FORM = 0xFE94;
const char32_t ARABIC_LETTER_TEH_ISOLATED_FORM = 0xFE95;
const char32_t ARABIC_LETTER_TEH_FINAL_FORM = 0xFE96;
const char32_t ARABIC_LETTER_TEH_INITIAL_FORM = 0xFE97;
const char32_t ARABIC_LETTER_TEH_MEDIAL_FORM = 0xFE98;
const char32_t ARABIC_LETTER_THEH_ISOLATED_FORM = 0xFE99;
const char32_t ARABIC_LETTER_THEH_FINAL_FORM = 0xFE9A;
const char32_t ARABIC_LETTER_THEH_INITIAL_FORM = 0xFE9B;
const char32_t ARABIC_LETTER_THEH_MEDIAL_FORM = 0xFE9C;
const char32_t ARABIC_LETTER_JEEM_ISOLATED_FORM = 0xFE9D;
const char32_t ARABIC_LETTER_JEEM_FINAL_FORM = 0xFE9E;
const char32_t ARABIC_LETTER_JEEM_INITIAL_FORM = 0xFE9F;
const char32_t ARABIC_LETTER_JEEM_MEDIAL_FORM = 0xFEA0;
const char32_t ARABIC_LETTER_HAH_ISOLATED_FORM = 0xFEA1;
const char32_t ARABIC_LETTER_HAH_FINAL_FORM = 0xFEA2;
const char32_t ARABIC_LETTER_HAH_INITIAL_FORM = 0xFEA3;
const char32_t ARABIC_LETTER_HAH_MEDIAL_FORM = 0xFEA4;
const char32_t ARABIC_LETTER_KHAH_ISOLATED_FORM = 0xFEA5;
const char32_t ARABIC_LETTER_KHAH_FINAL_FORM = 0xFEA6;
const char32_t ARABIC_LETTER_KHAH_INITIAL_FORM = 0xFEA7;
const char32_t ARABIC_LETTER_KHAH_MEDIAL_FORM = 0xFEA8;
const char32_t ARABIC_LETTER_DAL_ISOLATED_FORM = 0xFEA9;
const char32_t ARABIC_LETTER_DAL_FINAL_FORM = 0xFEAA;
const char32_t ARABIC_LETTER_THAL_ISOLATED_FORM = 0xFEAB;
const char32_t ARABIC_LETTER_THAL_FINAL_FORM = 0xFEAC;
const char32_t ARABIC_LETTER_REH_ISOLATED_FORM = 0xFEAD;
const char32_t ARABIC_LETTER_REH_FINAL_FORM = 0xFEAE;
const char32_t ARABIC_LETTER_ZAIN_ISOLATED_FORM = 0xFEAF;
const char32_t ARABIC_LETTER_ZAIN_FINAL_FORM = 0xFEB0;
const char32_t ARABIC_LETTER_SEEN_ISOLATED_FORM = 0xFEB1;
const char32_t ARABIC_LETTER_SEEN_FINAL_FORM = 0xFEB2;
const char32_t ARABIC_LETTER_SEEN_INITIAL_FORM = 0xFEB3;
const char32_t ARABIC_LETTER_SEEN_MEDIAL_FORM = 0xFEB4;
const char32_t ARABIC_LETTER_SHEEN_ISOLATED_FORM = 0xFEB5;
const char32_t ARABIC_LETTER_SHEEN_FINAL_FORM = 0xFEB6;
const char32_t ARABIC_LETTER_SHEEN_INITIAL_FORM = 0xFEB7;
const char32_t ARABIC_LETTER_SHEEN_MEDIAL_FORM = 0xFEB8;
const char32_t ARABIC_LETTER_SAD_ISOLATED_FORM = 0xFEB9;
const char32_t ARABIC_LETTER_SAD_FINAL_FORM = 0xFEBA;
const char32_t ARABIC_LETTER_SAD_INITIAL_FORM = 0xFEBB;
const char32_t ARABIC_LETTER_SAD_MEDIAL_FORM = 0xFEBC;
const char32_t ARABIC_LETTER_DAD_ISOLATED_FORM = 0xFEBD;
const char32_t ARABIC_LETTER_DAD_FINAL_FORM = 0xFEBE;
const char32_t ARABIC_LETTER_DAD_INITIAL_FORM = 0xFEBF;
const char32_t ARABIC_LETTER_DAD_MEDIAL_FORM = 0xFEC0;
const char32_t ARABIC_LETTER_TAH_ISOLATED_FORM = 0xFEC1;
const char32_t ARABIC_LETTER_TAH_FINAL_FORM = 0xFEC2;
const char32_t ARABIC_LETTER_TAH_INITIAL_FORM = 0xFEC3;
const char32_t ARABIC_LETTER_TAH_MEDIAL_FORM = 0xFEC4;
const char32_t ARABIC_LETTER_ZAH_ISOLATED_FORM = 0xFEC5;
const char32_t ARABIC_LETTER_ZAH_FINAL_FORM = 0xFEC6;
const char32_t ARABIC_LETTER_ZAH_INITIAL_FORM = 0xFEC7;
const char32_t ARABIC_LETTER_ZAH_MEDIAL_FORM = 0xFEC8;
const char32_t ARABIC_LETTER_AIN_ISOLATED_FORM = 0xFEC9;
const char32_t ARABIC_LETTER_AIN_FINAL_FORM = 0xFECA;
const char32_t ARABIC_LETTER_AIN_INITIAL_FORM = 0xFECB;
const char32_t ARABIC_LETTER_AIN_MEDIAL_FORM = 0xFECC;
const char32_t ARABIC_LETTER_GHAIN_ISOLATED_FORM = 0xFECD;
const char32_t ARABIC_LETTER_GHAIN_FINAL_FORM = 0xFECE;
const char32_t ARABIC_LETTER_GHAIN_INITIAL_FORM = 0xFECF;
const char32_t ARABIC_LETTER_GHAIN_MEDIAL_FORM = 0xFED0;
const char32_t ARABIC_LETTER_FEH_ISOLATED_FORM = 0xFED1;
const char32_t ARABIC_LETTER_FEH_FINAL_FORM = 0xFED2;
const char32_t ARABIC_LETTER_FEH_INITIAL_FORM = 0xFED3;
const char32_t ARABIC_LETTER_FEH_MEDIAL_FORM = 0xFED4;
const char32_t ARABIC_LETTER_QAF_ISOLATED_FORM = 0xFED5;
const char32_t ARABIC_LETTER_QAF_FINAL_FORM = 0xFED6;
const char32_t ARABIC_LETTER_QAF_INITIAL_FORM = 0xFED7;
const char32_t ARABIC_LETTER_QAF_MEDIAL_FORM = 0xFED8;
const char32_t ARABIC_LETTER_KAF_ISOLATED_FORM = 0xFED9;
const char32_t ARABIC_LETTER_KAF_FINAL_FORM = 0xFEDA;
const char32_t ARABIC_LETTER_KAF_INITIAL_FORM = 0xFEDB;
const char32_t ARABIC_LETTER_KAF_MEDIAL_FORM = 0xFEDC;
const char32_t ARABIC_LETTER_LAM_ISOLATED_FORM = 0xFEDD;
const char32_t ARABIC_LETTER_LAM_FINAL_FORM = 0xFEDE;
const char32_t ARABIC_LETTER_LAM_INITIAL_FORM = 0xFEDF;
const char32_t ARABIC_LETTER_LAM_MEDIAL_FORM = 0xFEE0;
const char32_t ARABIC_LETTER_MEEM_ISOLATED_FORM = 0xFEE1;
const char32_t ARABIC_LETTER_MEEM_FINAL_FORM = 0xFEE2;
const char32_t ARABIC_LETTER_MEEM_INITIAL_FORM = 0xFEE3;
const char32_t ARABIC_LETTER_MEEM_MEDIAL_FORM = 0xFEE4;
const char32_t ARABIC_LETTER_NOON_ISOLATED_FORM = 0xFEE5;
const char32_t ARABIC_LETTER_NOON_FINAL_FORM = 0xFEE6;
const char32_t ARABIC_LETTER_NOON_INITIAL_FORM = 0xFEE7;
const char32_t ARABIC_LETTER_NOON_MEDIAL_FORM = 0xFEE8;
const char32_t ARABIC_LETTER_HEH_ISOLATED_FORM = 0xFEE9;
const char32_t ARABIC_LETTER_HEH_FINAL_FORM = 0xFEEA;
const char32_t ARABIC_LETTER_HEH_INITIAL_FORM = 0xFEEB;
const char32_t ARABIC_LETTER_HEH_MEDIAL_FORM = 0xFEEC;
const char32_t ARABIC_LETTER_WAW_ISOLATED_FORM = 0xFEED;
const char32_t ARABIC_LETTER_WAW_FINAL_FORM = 0xFEEE;
const char32_t ARABIC_LETTER_ALEF_MAKSURA_ISOLATED_FORM = 0xFEEF;
const char32_t ARABIC_LETTER_ALEF_MAKSURA_FINAL_FORM = 0xFEF0;
const char32_t ARABIC_LETTER_YEH_ISOLATED_FORM = 0xFEF1;
const char32_t ARABIC_LETTER_YEH_FINAL_FORM = 0xFEF2;
const char32_t ARABIC_LETTER_YEH_INITIAL_FORM = 0xFEF3;
const char32_t ARABIC_LETTER_YEH_MEDIAL_FORM = 0xFEF4;
const char32_t ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_MADDA_ABOVE_ISOLATED_FORM = 0xFEF5;
const char32_t ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_MADDA_ABOVE_FINAL_FORM = 0xFEF6;
const char32_t ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_ABOVE_ISOLATED_FORM = 0xFEF7;
const char32_t ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_ABOVE_FINAL_FORM = 0xFEF8;
const char32_t ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_BELOW_ISOLATED_FORM = 0xFEF9;
const char32_t ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_BELOW_FINAL_FORM = 0xFEFA;
const char32_t ARABIC_LIGATURE_LAM_WITH_ALEF_ISOLATED_FORM = 0xFEFB;
const char32_t ARABIC_LIGATURE_LAM_WITH_ALEF_FINAL_FORM = 0xFEFC;
const char32_t ZERO_WIDTH_NO_BREAK_SPACE = 0xFEFF;
const char32_t FULLWIDTH_EXCLAMATION_MARK = 0xFF01;
const char32_t FULLWIDTH_QUOTATION_MARK = 0xFF02;
const char32_t FULLWIDTH_NUMBER_SIGN = 0xFF03;
const char32_t FULLWIDTH_DOLLAR_SIGN = 0xFF04;
const char32_t FULLWIDTH_PERCENT_SIGN = 0xFF05;
const char32_t FULLWIDTH_AMPERSAND = 0xFF06;
const char32_t FULLWIDTH_APOSTROPHE = 0xFF07;
const char32_t FULLWIDTH_LEFT_PARENTHESIS = 0xFF08;
const char32_t FULLWIDTH_RIGHT_PARENTHESIS = 0xFF09;
const char32_t FULLWIDTH_ASTERISK = 0xFF0A;
const char32_t FULLWIDTH_PLUS_SIGN = 0xFF0B;
const char32_t FULLWIDTH_COMMA = 0xFF0C;
const char32_t FULLWIDTH_HYPHEN_MINUS = 0xFF0D;
const char32_t FULLWIDTH_FULL_STOP = 0xFF0E;
const char32_t FULLWIDTH_SOLIDUS = 0xFF0F;
const char32_t FULLWIDTH_DIGIT_ZERO = 0xFF10;
const char32_t FULLWIDTH_DIGIT_ONE = 0xFF11;
const char32_t FULLWIDTH_DIGIT_TWO = 0xFF12;
const char32_t FULLWIDTH_DIGIT_THREE = 0xFF13;
const char32_t FULLWIDTH_DIGIT_FOUR = 0xFF14;
const char32_t FULLWIDTH_DIGIT_FIVE = 0xFF15;
const char32_t FULLWIDTH_DIGIT_SIX = 0xFF16;
const char32_t FULLWIDTH_DIGIT_SEVEN = 0xFF17;
const char32_t FULLWIDTH_DIGIT_EIGHT = 0xFF18;
const char32_t FULLWIDTH_DIGIT_NINE = 0xFF19;
const char32_t FULLWIDTH_COLON = 0xFF1A;
const char32_t FULLWIDTH_SEMICOLON = 0xFF1B;
const char32_t FULLWIDTH_LESS_THAN_SIGN = 0xFF1C;
const char32_t FULLWIDTH_EQUALS_SIGN = 0xFF1D;
const char32_t FULLWIDTH_GREATER_THAN_SIGN = 0xFF1E;
const char32_t FULLWIDTH_QUESTION_MARK = 0xFF1F;
const char32_t FULLWIDTH_COMMERCIAL_AT = 0xFF20;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_A = 0xFF21;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_B = 0xFF22;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_C = 0xFF23;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_D = 0xFF24;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_E = 0xFF25;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_F = 0xFF26;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_G = 0xFF27;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_H = 0xFF28;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_I = 0xFF29;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_J = 0xFF2A;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_K = 0xFF2B;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_L = 0xFF2C;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_M = 0xFF2D;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_N = 0xFF2E;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_O = 0xFF2F;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_P = 0xFF30;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_Q = 0xFF31;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_R = 0xFF32;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_S = 0xFF33;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_T = 0xFF34;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_U = 0xFF35;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_V = 0xFF36;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_W = 0xFF37;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_X = 0xFF38;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_Y = 0xFF39;
const char32_t FULLWIDTH_LATIN_CAPITAL_LETTER_Z = 0xFF3A;
const char32_t FULLWIDTH_LEFT_SQUARE_BRACKET = 0xFF3B;
const char32_t FULLWIDTH_REVERSE_SOLIDUS = 0xFF3C;
const char32_t FULLWIDTH_RIGHT_SQUARE_BRACKET = 0xFF3D;
const char32_t FULLWIDTH_CIRCUMFLEX_ACCENT = 0xFF3E;
const char32_t FULLWIDTH_LOW_LINE = 0xFF3F;
const char32_t FULLWIDTH_GRAVE_ACCENT = 0xFF40;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_A = 0xFF41;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_B = 0xFF42;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_C = 0xFF43;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_D = 0xFF44;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_E = 0xFF45;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_F = 0xFF46;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_G = 0xFF47;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_H = 0xFF48;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_I = 0xFF49;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_J = 0xFF4A;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_K = 0xFF4B;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_L = 0xFF4C;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_M = 0xFF4D;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_N = 0xFF4E;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_O = 0xFF4F;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_P = 0xFF50;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_Q = 0xFF51;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_R = 0xFF52;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_S = 0xFF53;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_T = 0xFF54;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_U = 0xFF55;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_V = 0xFF56;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_W = 0xFF57;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_X = 0xFF58;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_Y = 0xFF59;
const char32_t FULLWIDTH_LATIN_SMALL_LETTER_Z = 0xFF5A;
const char32_t FULLWIDTH_LEFT_CURLY_BRACKET = 0xFF5B;
const char32_t FULLWIDTH_VERTICAL_LINE = 0xFF5C;
const char32_t FULLWIDTH_RIGHT_CURLY_BRACKET = 0xFF5D;
const char32_t FULLWIDTH_TILDE = 0xFF5E;
const char32_t FULLWIDTH_LEFT_WHITE_PARENTHESIS = 0xFF5F;
const char32_t FULLWIDTH_RIGHT_WHITE_PARENTHESIS = 0xFF60;
const char32_t HALFWIDTH_IDEOGRAPHIC_FULL_STOP = 0xFF61;
const char32_t HALFWIDTH_LEFT_CORNER_BRACKET = 0xFF62;
const char32_t HALFWIDTH_RIGHT_CORNER_BRACKET = 0xFF63;
const char32_t HALFWIDTH_IDEOGRAPHIC_COMMA = 0xFF64;
const char32_t HALFWIDTH_KATAKANA_MIDDLE_DOT = 0xFF65;
const char32_t HALFWIDTH_KATAKANA_LETTER_WO = 0xFF66;
const char32_t HALFWIDTH_KATAKANA_LETTER_SMALL_A = 0xFF67;
const char32_t HALFWIDTH_KATAKANA_LETTER_SMALL_I = 0xFF68;
const char32_t HALFWIDTH_KATAKANA_LETTER_SMALL_U = 0xFF69;
const char32_t HALFWIDTH_KATAKANA_LETTER_SMALL_E = 0xFF6A;
const char32_t HALFWIDTH_KATAKANA_LETTER_SMALL_O = 0xFF6B;
const char32_t HALFWIDTH_KATAKANA_LETTER_SMALL_YA = 0xFF6C;
const char32_t HALFWIDTH_KATAKANA_LETTER_SMALL_YU = 0xFF6D;
const char32_t HALFWIDTH_KATAKANA_LETTER_SMALL_YO = 0xFF6E;
const char32_t HALFWIDTH_KATAKANA_LETTER_SMALL_TU = 0xFF6F;
const char32_t HALFWIDTH_KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK = 0xFF70;
const char32_t HALFWIDTH_KATAKANA_LETTER_A = 0xFF71;
const char32_t HALFWIDTH_KATAKANA_LETTER_I = 0xFF72;
const char32_t HALFWIDTH_KATAKANA_LETTER_U = 0xFF73;
const char32_t HALFWIDTH_KATAKANA_LETTER_E = 0xFF74;
const char32_t HALFWIDTH_KATAKANA_LETTER_O = 0xFF75;
const char32_t HALFWIDTH_KATAKANA_LETTER_KA = 0xFF76;
const char32_t HALFWIDTH_KATAKANA_LETTER_KI = 0xFF77;
const char32_t HALFWIDTH_KATAKANA_LETTER_KU = 0xFF78;
const char32_t HALFWIDTH_KATAKANA_LETTER_KE = 0xFF79;
const char32_t HALFWIDTH_KATAKANA_LETTER_KO = 0xFF7A;
const char32_t HALFWIDTH_KATAKANA_LETTER_SA = 0xFF7B;
const char32_t HALFWIDTH_KATAKANA_LETTER_SI = 0xFF7C;
const char32_t HALFWIDTH_KATAKANA_LETTER_SU = 0xFF7D;
const char32_t HALFWIDTH_KATAKANA_LETTER_SE = 0xFF7E;
const char32_t HALFWIDTH_KATAKANA_LETTER_SO = 0xFF7F;
const char32_t HALFWIDTH_KATAKANA_LETTER_TA = 0xFF80;
const char32_t HALFWIDTH_KATAKANA_LETTER_TI = 0xFF81;
const char32_t HALFWIDTH_KATAKANA_LETTER_TU = 0xFF82;
const char32_t HALFWIDTH_KATAKANA_LETTER_TE = 0xFF83;
const char32_t HALFWIDTH_KATAKANA_LETTER_TO = 0xFF84;
const char32_t HALFWIDTH_KATAKANA_LETTER_NA = 0xFF85;
const char32_t HALFWIDTH_KATAKANA_LETTER_NI = 0xFF86;
const char32_t HALFWIDTH_KATAKANA_LETTER_NU = 0xFF87;
const char32_t HALFWIDTH_KATAKANA_LETTER_NE = 0xFF88;
const char32_t HALFWIDTH_KATAKANA_LETTER_NO = 0xFF89;
const char32_t HALFWIDTH_KATAKANA_LETTER_HA = 0xFF8A;
const char32_t HALFWIDTH_KATAKANA_LETTER_HI = 0xFF8B;
const char32_t HALFWIDTH_KATAKANA_LETTER_HU = 0xFF8C;
const char32_t HALFWIDTH_KATAKANA_LETTER_HE = 0xFF8D;
const char32_t HALFWIDTH_KATAKANA_LETTER_HO = 0xFF8E;
const char32_t HALFWIDTH_KATAKANA_LETTER_MA = 0xFF8F;
const char32_t HALFWIDTH_KATAKANA_LETTER_MI = 0xFF90;
const char32_t HALFWIDTH_KATAKANA_LETTER_MU = 0xFF91;
const char32_t HALFWIDTH_KATAKANA_LETTER_ME = 0xFF92;
const char32_t HALFWIDTH_KATAKANA_LETTER_MO = 0xFF93;
const char32_t HALFWIDTH_KATAKANA_LETTER_YA = 0xFF94;
const char32_t HALFWIDTH_KATAKANA_LETTER_YU = 0xFF95;
const char32_t HALFWIDTH_KATAKANA_LETTER_YO = 0xFF96;
const char32_t HALFWIDTH_KATAKANA_LETTER_RA = 0xFF97;
const char32_t HALFWIDTH_KATAKANA_LETTER_RI = 0xFF98;
const char32_t HALFWIDTH_KATAKANA_LETTER_RU = 0xFF99;
const char32_t HALFWIDTH_KATAKANA_LETTER_RE = 0xFF9A;
const char32_t HALFWIDTH_KATAKANA_LETTER_RO = 0xFF9B;
const char32_t HALFWIDTH_KATAKANA_LETTER_WA = 0xFF9C;
const char32_t HALFWIDTH_KATAKANA_LETTER_N = 0xFF9D;
const char32_t HALFWIDTH_KATAKANA_VOICED_SOUND_MARK = 0xFF9E;
const char32_t HALFWIDTH_KATAKANA_SEMI_VOICED_SOUND_MARK = 0xFF9F;
const char32_t HALFWIDTH_HANGUL_FILLER = 0xFFA0;
const char32_t HALFWIDTH_HANGUL_LETTER_KIYEOK = 0xFFA1;
const char32_t HALFWIDTH_HANGUL_LETTER_SSANGKIYEOK = 0xFFA2;
const char32_t HALFWIDTH_HANGUL_LETTER_KIYEOK_SIOS = 0xFFA3;
const char32_t HALFWIDTH_HANGUL_LETTER_NIEUN = 0xFFA4;
const char32_t HALFWIDTH_HANGUL_LETTER_NIEUN_CIEUC = 0xFFA5;
const char32_t HALFWIDTH_HANGUL_LETTER_NIEUN_HIEUH = 0xFFA6;
const char32_t HALFWIDTH_HANGUL_LETTER_TIKEUT = 0xFFA7;
const char32_t HALFWIDTH_HANGUL_LETTER_SSANGTIKEUT = 0xFFA8;
const char32_t HALFWIDTH_HANGUL_LETTER_RIEUL = 0xFFA9;
const char32_t HALFWIDTH_HANGUL_LETTER_RIEUL_KIYEOK = 0xFFAA;
const char32_t HALFWIDTH_HANGUL_LETTER_RIEUL_MIEUM = 0xFFAB;
const char32_t HALFWIDTH_HANGUL_LETTER_RIEUL_PIEUP = 0xFFAC;
const char32_t HALFWIDTH_HANGUL_LETTER_RIEUL_SIOS = 0xFFAD;
const char32_t HALFWIDTH_HANGUL_LETTER_RIEUL_THIEUTH = 0xFFAE;
const char32_t HALFWIDTH_HANGUL_LETTER_RIEUL_PHIEUPH = 0xFFAF;
const char32_t HALFWIDTH_HANGUL_LETTER_RIEUL_HIEUH = 0xFFB0;
const char32_t HALFWIDTH_HANGUL_LETTER_MIEUM = 0xFFB1;
const char32_t HALFWIDTH_HANGUL_LETTER_PIEUP = 0xFFB2;
const char32_t HALFWIDTH_HANGUL_LETTER_SSANGPIEUP = 0xFFB3;
const char32_t HALFWIDTH_HANGUL_LETTER_PIEUP_SIOS = 0xFFB4;
const char32_t HALFWIDTH_HANGUL_LETTER_SIOS = 0xFFB5;
const char32_t HALFWIDTH_HANGUL_LETTER_SSANGSIOS = 0xFFB6;
const char32_t HALFWIDTH_HANGUL_LETTER_IEUNG = 0xFFB7;
const char32_t HALFWIDTH_HANGUL_LETTER_CIEUC = 0xFFB8;
const char32_t HALFWIDTH_HANGUL_LETTER_SSANGCIEUC = 0xFFB9;
const char32_t HALFWIDTH_HANGUL_LETTER_CHIEUCH = 0xFFBA;
const char32_t HALFWIDTH_HANGUL_LETTER_KHIEUKH = 0xFFBB;
const char32_t HALFWIDTH_HANGUL_LETTER_THIEUTH = 0xFFBC;
const char32_t HALFWIDTH_HANGUL_LETTER_PHIEUPH = 0xFFBD;
const char32_t HALFWIDTH_HANGUL_LETTER_HIEUH = 0xFFBE;
const char32_t HALFWIDTH_HANGUL_LETTER_A = 0xFFC2;
const char32_t HALFWIDTH_HANGUL_LETTER_AE = 0xFFC3;
const char32_t HALFWIDTH_HANGUL_LETTER_YA = 0xFFC4;
const char32_t HALFWIDTH_HANGUL_LETTER_YAE = 0xFFC5;
const char32_t HALFWIDTH_HANGUL_LETTER_EO = 0xFFC6;
const char32_t HALFWIDTH_HANGUL_LETTER_E = 0xFFC7;
const char32_t HALFWIDTH_HANGUL_LETTER_YEO = 0xFFCA;
const char32_t HALFWIDTH_HANGUL_LETTER_YE = 0xFFCB;
const char32_t HALFWIDTH_HANGUL_LETTER_O = 0xFFCC;
const char32_t HALFWIDTH_HANGUL_LETTER_WA = 0xFFCD;
const char32_t HALFWIDTH_HANGUL_LETTER_WAE = 0xFFCE;
const char32_t HALFWIDTH_HANGUL_LETTER_OE = 0xFFCF;
const char32_t HALFWIDTH_HANGUL_LETTER_YO = 0xFFD2;
const char32_t HALFWIDTH_HANGUL_LETTER_U = 0xFFD3;
const char32_t HALFWIDTH_HANGUL_LETTER_WEO = 0xFFD4;
const char32_t HALFWIDTH_HANGUL_LETTER_WE = 0xFFD5;
const char32_t HALFWIDTH_HANGUL_LETTER_WI = 0xFFD6;
const char32_t HALFWIDTH_HANGUL_LETTER_YU = 0xFFD7;
const char32_t HALFWIDTH_HANGUL_LETTER_EU = 0xFFDA;
const char32_t HALFWIDTH_HANGUL_LETTER_YI = 0xFFDB;
const char32_t HALFWIDTH_HANGUL_LETTER_I = 0xFFDC;
const char32_t FULLWIDTH_CENT_SIGN = 0xFFE0;
const char32_t FULLWIDTH_POUND_SIGN = 0xFFE1;
const char32_t FULLWIDTH_NOT_SIGN = 0xFFE2;
const char32_t FULLWIDTH_MACRON = 0xFFE3;
const char32_t FULLWIDTH_BROKEN_BAR = 0xFFE4;
const char32_t FULLWIDTH_YEN_SIGN = 0xFFE5;
const char32_t FULLWIDTH_WON_SIGN = 0xFFE6;
const char32_t HALFWIDTH_FORMS_LIGHT_VERTICAL = 0xFFE8;
const char32_t HALFWIDTH_LEFTWARDS_ARROW = 0xFFE9;
const char32_t HALFWIDTH_UPWARDS_ARROW = 0xFFEA;
const char32_t HALFWIDTH_RIGHTWARDS_ARROW = 0xFFEB;
const char32_t HALFWIDTH_DOWNWARDS_ARROW = 0xFFEC;
const char32_t HALFWIDTH_BLACK_SQUARE = 0xFFED;
const char32_t HALFWIDTH_WHITE_CIRCLE = 0xFFEE;
const char32_t INTERLINEAR_ANNOTATION_ANCHOR = 0xFFF9;
const char32_t INTERLINEAR_ANNOTATION_SEPARATOR = 0xFFFA;
const char32_t INTERLINEAR_ANNOTATION_TERMINATOR = 0xFFFB;
const char32_t OBJECT_REPLACEMENT_CHARACTER = 0xFFFC;
const char32_t REPLACEMENT_CHARACTER = 0xFFFD;
const char32_t LINEAR_B_SYLLABLE_B008_A = 0x00010000;
const char32_t LINEAR_B_SYLLABLE_B038_E = 0x00010001;
const char32_t LINEAR_B_SYLLABLE_B028_I = 0x00010002;
const char32_t LINEAR_B_SYLLABLE_B061_O = 0x00010003;
const char32_t LINEAR_B_SYLLABLE_B010_U = 0x00010004;
const char32_t LINEAR_B_SYLLABLE_B001_DA = 0x00010005;
const char32_t LINEAR_B_SYLLABLE_B045_DE = 0x00010006;
const char32_t LINEAR_B_SYLLABLE_B007_DI = 0x00010007;
const char32_t LINEAR_B_SYLLABLE_B014_DO = 0x00010008;
const char32_t LINEAR_B_SYLLABLE_B051_DU = 0x00010009;
const char32_t LINEAR_B_SYLLABLE_B057_JA = 0x0001000A;
const char32_t LINEAR_B_SYLLABLE_B046_JE = 0x0001000B;
const char32_t LINEAR_B_SYLLABLE_B036_JO = 0x0001000D;
const char32_t LINEAR_B_SYLLABLE_B065_JU = 0x0001000E;
const char32_t LINEAR_B_SYLLABLE_B077_KA = 0x0001000F;
const char32_t LINEAR_B_SYLLABLE_B044_KE = 0x00010010;
const char32_t LINEAR_B_SYLLABLE_B067_KI = 0x00010011;
const char32_t LINEAR_B_SYLLABLE_B070_KO = 0x00010012;
const char32_t LINEAR_B_SYLLABLE_B081_KU = 0x00010013;
const char32_t LINEAR_B_SYLLABLE_B080_MA = 0x00010014;
const char32_t LINEAR_B_SYLLABLE_B013_ME = 0x00010015;
const char32_t LINEAR_B_SYLLABLE_B073_MI = 0x00010016;
const char32_t LINEAR_B_SYLLABLE_B015_MO = 0x00010017;
const char32_t LINEAR_B_SYLLABLE_B023_MU = 0x00010018;
const char32_t LINEAR_B_SYLLABLE_B006_NA = 0x00010019;
const char32_t LINEAR_B_SYLLABLE_B024_NE = 0x0001001A;
const char32_t LINEAR_B_SYLLABLE_B030_NI = 0x0001001B;
const char32_t LINEAR_B_SYLLABLE_B052_NO = 0x0001001C;
const char32_t LINEAR_B_SYLLABLE_B055_NU = 0x0001001D;
const char32_t LINEAR_B_SYLLABLE_B003_PA = 0x0001001E;
const char32_t LINEAR_B_SYLLABLE_B072_PE = 0x0001001F;
const char32_t LINEAR_B_SYLLABLE_B039_PI = 0x00010020;
const char32_t LINEAR_B_SYLLABLE_B011_PO = 0x00010021;
const char32_t LINEAR_B_SYLLABLE_B050_PU = 0x00010022;
const char32_t LINEAR_B_SYLLABLE_B016_QA = 0x00010023;
const char32_t LINEAR_B_SYLLABLE_B078_QE = 0x00010024;
const char32_t LINEAR_B_SYLLABLE_B021_QI = 0x00010025;
const char32_t LINEAR_B_SYLLABLE_B032_QO = 0x00010026;
const char32_t LINEAR_B_SYLLABLE_B060_RA = 0x00010028;
const char32_t LINEAR_B_SYLLABLE_B027_RE = 0x00010029;
const char32_t LINEAR_B_SYLLABLE_B053_RI = 0x0001002A;
const char32_t LINEAR_B_SYLLABLE_B002_RO = 0x0001002B;
const char32_t LINEAR_B_SYLLABLE_B026_RU = 0x0001002C;
const char32_t LINEAR_B_SYLLABLE_B031_SA = 0x0001002D;
const char32_t LINEAR_B_SYLLABLE_B009_SE = 0x0001002E;
const char32_t LINEAR_B_SYLLABLE_B041_SI = 0x0001002F;
const char32_t LINEAR_B_SYLLABLE_B012_SO = 0x00010030;
const char32_t LINEAR_B_SYLLABLE_B058_SU = 0x00010031;
const char32_t LINEAR_B_SYLLABLE_B059_TA = 0x00010032;
const char32_t LINEAR_B_SYLLABLE_B004_TE = 0x00010033;
const char32_t LINEAR_B_SYLLABLE_B037_TI = 0x00010034;
const char32_t LINEAR_B_SYLLABLE_B005_TO = 0x00010035;
const char32_t LINEAR_B_SYLLABLE_B069_TU = 0x00010036;
const char32_t LINEAR_B_SYLLABLE_B054_WA = 0x00010037;
const char32_t LINEAR_B_SYLLABLE_B075_WE = 0x00010038;
const char32_t LINEAR_B_SYLLABLE_B040_WI = 0x00010039;
const char32_t LINEAR_B_SYLLABLE_B042_WO = 0x0001003A;
const char32_t LINEAR_B_SYLLABLE_B017_ZA = 0x0001003C;
const char32_t LINEAR_B_SYLLABLE_B074_ZE = 0x0001003D;
const char32_t LINEAR_B_SYLLABLE_B020_ZO = 0x0001003F;
const char32_t LINEAR_B_SYLLABLE_B025_A2 = 0x00010040;
const char32_t LINEAR_B_SYLLABLE_B043_A3 = 0x00010041;
const char32_t LINEAR_B_SYLLABLE_B085_AU = 0x00010042;
const char32_t LINEAR_B_SYLLABLE_B071_DWE = 0x00010043;
const char32_t LINEAR_B_SYLLABLE_B090_DWO = 0x00010044;
const char32_t LINEAR_B_SYLLABLE_B048_NWA = 0x00010045;
const char32_t LINEAR_B_SYLLABLE_B029_PU2 = 0x00010046;
const char32_t LINEAR_B_SYLLABLE_B062_PTE = 0x00010047;
const char32_t LINEAR_B_SYLLABLE_B076_RA2 = 0x00010048;
const char32_t LINEAR_B_SYLLABLE_B033_RA3 = 0x00010049;
const char32_t LINEAR_B_SYLLABLE_B068_RO2 = 0x0001004A;
const char32_t LINEAR_B_SYLLABLE_B066_TA2 = 0x0001004B;
const char32_t LINEAR_B_SYLLABLE_B087_TWE = 0x0001004C;
const char32_t LINEAR_B_SYLLABLE_B091_TWO = 0x0001004D;
const char32_t LINEAR_B_SYMBOL_B018 = 0x00010050;
const char32_t LINEAR_B_SYMBOL_B019 = 0x00010051;
const char32_t LINEAR_B_SYMBOL_B022 = 0x00010052;
const char32_t LINEAR_B_SYMBOL_B034 = 0x00010053;
const char32_t LINEAR_B_SYMBOL_B047 = 0x00010054;
const char32_t LINEAR_B_SYMBOL_B049 = 0x00010055;
const char32_t LINEAR_B_SYMBOL_B056 = 0x00010056;
const char32_t LINEAR_B_SYMBOL_B063 = 0x00010057;
const char32_t LINEAR_B_SYMBOL_B064 = 0x00010058;
const char32_t LINEAR_B_SYMBOL_B079 = 0x00010059;
const char32_t LINEAR_B_SYMBOL_B082 = 0x0001005A;
const char32_t LINEAR_B_SYMBOL_B083 = 0x0001005B;
const char32_t LINEAR_B_SYMBOL_B086 = 0x0001005C;
const char32_t LINEAR_B_SYMBOL_B089 = 0x0001005D;
const char32_t LINEAR_B_IDEOGRAM_B100_MAN = 0x00010080;
const char32_t LINEAR_B_IDEOGRAM_B102_WOMAN = 0x00010081;
const char32_t LINEAR_B_IDEOGRAM_B104_DEER = 0x00010082;
const char32_t LINEAR_B_IDEOGRAM_B105_EQUID = 0x00010083;
const char32_t LINEAR_B_IDEOGRAM_B105F_MARE = 0x00010084;
const char32_t LINEAR_B_IDEOGRAM_B105M_STALLION = 0x00010085;
const char32_t LINEAR_B_IDEOGRAM_B106F_EWE = 0x00010086;
const char32_t LINEAR_B_IDEOGRAM_B106M_RAM = 0x00010087;
const char32_t LINEAR_B_IDEOGRAM_B107F_SHE_GOAT = 0x00010088;
const char32_t LINEAR_B_IDEOGRAM_B107M_HE_GOAT = 0x00010089;
const char32_t LINEAR_B_IDEOGRAM_B108F_SOW = 0x0001008A;
const char32_t LINEAR_B_IDEOGRAM_B108M_BOAR = 0x0001008B;
const char32_t LINEAR_B_IDEOGRAM_B109F_COW = 0x0001008C;
const char32_t LINEAR_B_IDEOGRAM_B109M_BULL = 0x0001008D;
const char32_t LINEAR_B_IDEOGRAM_B120_WHEAT = 0x0001008E;
const char32_t LINEAR_B_IDEOGRAM_B121_BARLEY = 0x0001008F;
const char32_t LINEAR_B_IDEOGRAM_B122_OLIVE = 0x00010090;
const char32_t LINEAR_B_IDEOGRAM_B123_SPICE = 0x00010091;
const char32_t LINEAR_B_IDEOGRAM_B125_CYPERUS = 0x00010092;
const char32_t LINEAR_B_MONOGRAM_B127_KAPO = 0x00010093;
const char32_t LINEAR_B_MONOGRAM_B128_KANAKO = 0x00010094;
const char32_t LINEAR_B_IDEOGRAM_B130_OIL = 0x00010095;
const char32_t LINEAR_B_IDEOGRAM_B131_WINE = 0x00010096;
const char32_t LINEAR_B_IDEOGRAM_B132 = 0x00010097;
const char32_t LINEAR_B_MONOGRAM_B133_AREPA = 0x00010098;
const char32_t LINEAR_B_MONOGRAM_B135_MERI = 0x00010099;
const char32_t LINEAR_B_IDEOGRAM_B140_BRONZE = 0x0001009A;
const char32_t LINEAR_B_IDEOGRAM_B141_GOLD = 0x0001009B;
const char32_t LINEAR_B_IDEOGRAM_B142 = 0x0001009C;
const char32_t LINEAR_B_IDEOGRAM_B145_WOOL = 0x0001009D;
const char32_t LINEAR_B_IDEOGRAM_B146 = 0x0001009E;
const char32_t LINEAR_B_IDEOGRAM_B150 = 0x0001009F;
const char32_t LINEAR_B_IDEOGRAM_B151_HORN = 0x000100A0;
const char32_t LINEAR_B_IDEOGRAM_B152 = 0x000100A1;
const char32_t LINEAR_B_IDEOGRAM_B153 = 0x000100A2;
const char32_t LINEAR_B_IDEOGRAM_B154 = 0x000100A3;
const char32_t LINEAR_B_MONOGRAM_B156_TURO2 = 0x000100A4;
const char32_t LINEAR_B_IDEOGRAM_B157 = 0x000100A5;
const char32_t LINEAR_B_IDEOGRAM_B158 = 0x000100A6;
const char32_t LINEAR_B_IDEOGRAM_B159_CLOTH = 0x000100A7;
const char32_t LINEAR_B_IDEOGRAM_B160 = 0x000100A8;
const char32_t LINEAR_B_IDEOGRAM_B161 = 0x000100A9;
const char32_t LINEAR_B_IDEOGRAM_B162_GARMENT = 0x000100AA;
const char32_t LINEAR_B_IDEOGRAM_B163_ARMOUR = 0x000100AB;
const char32_t LINEAR_B_IDEOGRAM_B164 = 0x000100AC;
const char32_t LINEAR_B_IDEOGRAM_B165 = 0x000100AD;
const char32_t LINEAR_B_IDEOGRAM_B166 = 0x000100AE;
const char32_t LINEAR_B_IDEOGRAM_B167 = 0x000100AF;
const char32_t LINEAR_B_IDEOGRAM_B168 = 0x000100B0;
const char32_t LINEAR_B_IDEOGRAM_B169 = 0x000100B1;
const char32_t LINEAR_B_IDEOGRAM_B170 = 0x000100B2;
const char32_t LINEAR_B_IDEOGRAM_B171 = 0x000100B3;
const char32_t LINEAR_B_IDEOGRAM_B172 = 0x000100B4;
const char32_t LINEAR_B_IDEOGRAM_B173_MONTH = 0x000100B5;
const char32_t LINEAR_B_IDEOGRAM_B174 = 0x000100B6;
const char32_t LINEAR_B_IDEOGRAM_B176_TREE = 0x000100B7;
const char32_t LINEAR_B_IDEOGRAM_B177 = 0x000100B8;
const char32_t LINEAR_B_IDEOGRAM_B178 = 0x000100B9;
const char32_t LINEAR_B_IDEOGRAM_B179 = 0x000100BA;
const char32_t LINEAR_B_IDEOGRAM_B180 = 0x000100BB;
const char32_t LINEAR_B_IDEOGRAM_B181 = 0x000100BC;
const char32_t LINEAR_B_IDEOGRAM_B182 = 0x000100BD;
const char32_t LINEAR_B_IDEOGRAM_B183 = 0x000100BE;
const char32_t LINEAR_B_IDEOGRAM_B184 = 0x000100BF;
const char32_t LINEAR_B_IDEOGRAM_B185 = 0x000100C0;
const char32_t LINEAR_B_IDEOGRAM_B189 = 0x000100C1;
const char32_t LINEAR_B_IDEOGRAM_B190 = 0x000100C2;
const char32_t LINEAR_B_IDEOGRAM_B191_HELMET = 0x000100C3;
const char32_t LINEAR_B_IDEOGRAM_B220_FOOTSTOOL = 0x000100C4;
const char32_t LINEAR_B_IDEOGRAM_B225_BATHTUB = 0x000100C5;
const char32_t LINEAR_B_IDEOGRAM_B230_SPEAR = 0x000100C6;
const char32_t LINEAR_B_IDEOGRAM_B231_ARROW = 0x000100C7;
const char32_t LINEAR_B_IDEOGRAM_B232 = 0x000100C8;
const char32_t LINEAR_B_IDEOGRAM_B233_SWORD = 0x000100C9;
const char32_t LINEAR_B_IDEOGRAM_B234 = 0x000100CA;
const char32_t LINEAR_B_IDEOGRAM_B236 = 0x000100CB;
const char32_t LINEAR_B_IDEOGRAM_B240_WHEELED_CHARIOT = 0x000100CC;
const char32_t LINEAR_B_IDEOGRAM_B241_CHARIOT = 0x000100CD;
const char32_t LINEAR_B_IDEOGRAM_B242_CHARIOT_FRAME = 0x000100CE;
const char32_t LINEAR_B_IDEOGRAM_B243_WHEEL = 0x000100CF;
const char32_t LINEAR_B_IDEOGRAM_B245 = 0x000100D0;
const char32_t LINEAR_B_IDEOGRAM_B246 = 0x000100D1;
const char32_t LINEAR_B_MONOGRAM_B247_DIPTE = 0x000100D2;
const char32_t LINEAR_B_IDEOGRAM_B248 = 0x000100D3;
const char32_t LINEAR_B_IDEOGRAM_B249 = 0x000100D4;
const char32_t LINEAR_B_IDEOGRAM_B251 = 0x000100D5;
const char32_t LINEAR_B_IDEOGRAM_B252 = 0x000100D6;
const char32_t LINEAR_B_IDEOGRAM_B253 = 0x000100D7;
const char32_t LINEAR_B_IDEOGRAM_B254_DART = 0x000100D8;
const char32_t LINEAR_B_IDEOGRAM_B255 = 0x000100D9;
const char32_t LINEAR_B_IDEOGRAM_B256 = 0x000100DA;
const char32_t LINEAR_B_IDEOGRAM_B257 = 0x000100DB;
const char32_t LINEAR_B_IDEOGRAM_B258 = 0x000100DC;
const char32_t LINEAR_B_IDEOGRAM_B259 = 0x000100DD;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B155 = 0x000100DE;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B200 = 0x000100DF;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B201 = 0x000100E0;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B202 = 0x000100E1;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B203 = 0x000100E2;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B204 = 0x000100E3;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B205 = 0x000100E4;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B206 = 0x000100E5;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B207 = 0x000100E6;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B208 = 0x000100E7;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B209 = 0x000100E8;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B210 = 0x000100E9;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B211 = 0x000100EA;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B212 = 0x000100EB;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B213 = 0x000100EC;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B214 = 0x000100ED;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B215 = 0x000100EE;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B216 = 0x000100EF;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B217 = 0x000100F0;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B218 = 0x000100F1;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B219 = 0x000100F2;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B221 = 0x000100F3;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B222 = 0x000100F4;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B226 = 0x000100F5;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B227 = 0x000100F6;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B228 = 0x000100F7;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B229 = 0x000100F8;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B250 = 0x000100F9;
const char32_t LINEAR_B_IDEOGRAM_VESSEL_B305 = 0x000100FA;
const char32_t AEGEAN_WORD_SEPARATOR_LINE = 0x00010100;
const char32_t AEGEAN_WORD_SEPARATOR_DOT = 0x00010101;
const char32_t AEGEAN_CHECK_MARK = 0x00010102;
const char32_t AEGEAN_NUMBER_ONE = 0x00010107;
const char32_t AEGEAN_NUMBER_TWO = 0x00010108;
const char32_t AEGEAN_NUMBER_THREE = 0x00010109;
const char32_t AEGEAN_NUMBER_FOUR = 0x0001010A;
const char32_t AEGEAN_NUMBER_FIVE = 0x0001010B;
const char32_t AEGEAN_NUMBER_SIX = 0x0001010C;
const char32_t AEGEAN_NUMBER_SEVEN = 0x0001010D;
const char32_t AEGEAN_NUMBER_EIGHT = 0x0001010E;
const char32_t AEGEAN_NUMBER_NINE = 0x0001010F;
const char32_t AEGEAN_NUMBER_TEN = 0x00010110;
const char32_t AEGEAN_NUMBER_TWENTY = 0x00010111;
const char32_t AEGEAN_NUMBER_THIRTY = 0x00010112;
const char32_t AEGEAN_NUMBER_FORTY = 0x00010113;
const char32_t AEGEAN_NUMBER_FIFTY = 0x00010114;
const char32_t AEGEAN_NUMBER_SIXTY = 0x00010115;
const char32_t AEGEAN_NUMBER_SEVENTY = 0x00010116;
const char32_t AEGEAN_NUMBER_EIGHTY = 0x00010117;
const char32_t AEGEAN_NUMBER_NINETY = 0x00010118;
const char32_t AEGEAN_NUMBER_ONE_HUNDRED = 0x00010119;
const char32_t AEGEAN_NUMBER_TWO_HUNDRED = 0x0001011A;
const char32_t AEGEAN_NUMBER_THREE_HUNDRED = 0x0001011B;
const char32_t AEGEAN_NUMBER_FOUR_HUNDRED = 0x0001011C;
const char32_t AEGEAN_NUMBER_FIVE_HUNDRED = 0x0001011D;
const char32_t AEGEAN_NUMBER_SIX_HUNDRED = 0x0001011E;
const char32_t AEGEAN_NUMBER_SEVEN_HUNDRED = 0x0001011F;
const char32_t AEGEAN_NUMBER_EIGHT_HUNDRED = 0x00010120;
const char32_t AEGEAN_NUMBER_NINE_HUNDRED = 0x00010121;
const char32_t AEGEAN_NUMBER_ONE_THOUSAND = 0x00010122;
const char32_t AEGEAN_NUMBER_TWO_THOUSAND = 0x00010123;
const char32_t AEGEAN_NUMBER_THREE_THOUSAND = 0x00010124;
const char32_t AEGEAN_NUMBER_FOUR_THOUSAND = 0x00010125;
const char32_t AEGEAN_NUMBER_FIVE_THOUSAND = 0x00010126;
const char32_t AEGEAN_NUMBER_SIX_THOUSAND = 0x00010127;
const char32_t AEGEAN_NUMBER_SEVEN_THOUSAND = 0x00010128;
const char32_t AEGEAN_NUMBER_EIGHT_THOUSAND = 0x00010129;
const char32_t AEGEAN_NUMBER_NINE_THOUSAND = 0x0001012A;
const char32_t AEGEAN_NUMBER_TEN_THOUSAND = 0x0001012B;
const char32_t AEGEAN_NUMBER_TWENTY_THOUSAND = 0x0001012C;
const char32_t AEGEAN_NUMBER_THIRTY_THOUSAND = 0x0001012D;
const char32_t AEGEAN_NUMBER_FORTY_THOUSAND = 0x0001012E;
const char32_t AEGEAN_NUMBER_FIFTY_THOUSAND = 0x0001012F;
const char32_t AEGEAN_NUMBER_SIXTY_THOUSAND = 0x00010130;
const char32_t AEGEAN_NUMBER_SEVENTY_THOUSAND = 0x00010131;
const char32_t AEGEAN_NUMBER_EIGHTY_THOUSAND = 0x00010132;
const char32_t AEGEAN_NUMBER_NINETY_THOUSAND = 0x00010133;
const char32_t AEGEAN_WEIGHT_BASE_UNIT = 0x00010137;
const char32_t AEGEAN_WEIGHT_FIRST_SUBUNIT = 0x00010138;
const char32_t AEGEAN_WEIGHT_SECOND_SUBUNIT = 0x00010139;
const char32_t AEGEAN_WEIGHT_THIRD_SUBUNIT = 0x0001013A;
const char32_t AEGEAN_WEIGHT_FOURTH_SUBUNIT = 0x0001013B;
const char32_t AEGEAN_DRY_MEASURE_FIRST_SUBUNIT = 0x0001013C;
const char32_t AEGEAN_LIQUID_MEASURE_FIRST_SUBUNIT = 0x0001013D;
const char32_t AEGEAN_MEASURE_SECOND_SUBUNIT = 0x0001013E;
const char32_t AEGEAN_MEASURE_THIRD_SUBUNIT = 0x0001013F;
const char32_t GREEK_ACROPHONIC_ATTIC_ONE_QUARTER = 0x00010140;
const char32_t GREEK_ACROPHONIC_ATTIC_ONE_HALF = 0x00010141;
const char32_t GREEK_ACROPHONIC_ATTIC_ONE_DRACHMA = 0x00010142;
const char32_t GREEK_ACROPHONIC_ATTIC_FIVE = 0x00010143;
const char32_t GREEK_ACROPHONIC_ATTIC_FIFTY = 0x00010144;
const char32_t GREEK_ACROPHONIC_ATTIC_FIVE_HUNDRED = 0x00010145;
const char32_t GREEK_ACROPHONIC_ATTIC_FIVE_THOUSAND = 0x00010146;
const char32_t GREEK_ACROPHONIC_ATTIC_FIFTY_THOUSAND = 0x00010147;
const char32_t GREEK_ACROPHONIC_ATTIC_FIVE_TALENTS = 0x00010148;
const char32_t GREEK_ACROPHONIC_ATTIC_TEN_TALENTS = 0x00010149;
const char32_t GREEK_ACROPHONIC_ATTIC_FIFTY_TALENTS = 0x0001014A;
const char32_t GREEK_ACROPHONIC_ATTIC_ONE_HUNDRED_TALENTS = 0x0001014B;
const char32_t GREEK_ACROPHONIC_ATTIC_FIVE_HUNDRED_TALENTS = 0x0001014C;
const char32_t GREEK_ACROPHONIC_ATTIC_ONE_THOUSAND_TALENTS = 0x0001014D;
const char32_t GREEK_ACROPHONIC_ATTIC_FIVE_THOUSAND_TALENTS = 0x0001014E;
const char32_t GREEK_ACROPHONIC_ATTIC_FIVE_STATERS = 0x0001014F;
const char32_t GREEK_ACROPHONIC_ATTIC_TEN_STATERS = 0x00010150;
const char32_t GREEK_ACROPHONIC_ATTIC_FIFTY_STATERS = 0x00010151;
const char32_t GREEK_ACROPHONIC_ATTIC_ONE_HUNDRED_STATERS = 0x00010152;
const char32_t GREEK_ACROPHONIC_ATTIC_FIVE_HUNDRED_STATERS = 0x00010153;
const char32_t GREEK_ACROPHONIC_ATTIC_ONE_THOUSAND_STATERS = 0x00010154;
const char32_t GREEK_ACROPHONIC_ATTIC_TEN_THOUSAND_STATERS = 0x00010155;
const char32_t GREEK_ACROPHONIC_ATTIC_FIFTY_THOUSAND_STATERS = 0x00010156;
const char32_t GREEK_ACROPHONIC_ATTIC_TEN_MNAS = 0x00010157;
const char32_t GREEK_ACROPHONIC_HERAEUM_ONE_PLETHRON = 0x00010158;
const char32_t GREEK_ACROPHONIC_THESPIAN_ONE = 0x00010159;
const char32_t GREEK_ACROPHONIC_HERMIONIAN_ONE = 0x0001015A;
const char32_t GREEK_ACROPHONIC_EPIDAUREAN_TWO = 0x0001015B;
const char32_t GREEK_ACROPHONIC_THESPIAN_TWO = 0x0001015C;
const char32_t GREEK_ACROPHONIC_CYRENAIC_TWO_DRACHMAS = 0x0001015D;
const char32_t GREEK_ACROPHONIC_EPIDAUREAN_TWO_DRACHMAS = 0x0001015E;
const char32_t GREEK_ACROPHONIC_TROEZENIAN_FIVE = 0x0001015F;
const char32_t GREEK_ACROPHONIC_TROEZENIAN_TEN = 0x00010160;
const char32_t GREEK_ACROPHONIC_TROEZENIAN_TEN_ALTERNATE_FORM = 0x00010161;
const char32_t GREEK_ACROPHONIC_HERMIONIAN_TEN = 0x00010162;
const char32_t GREEK_ACROPHONIC_MESSENIAN_TEN = 0x00010163;
const char32_t GREEK_ACROPHONIC_THESPIAN_TEN = 0x00010164;
const char32_t GREEK_ACROPHONIC_THESPIAN_THIRTY = 0x00010165;
const char32_t GREEK_ACROPHONIC_TROEZENIAN_FIFTY = 0x00010166;
const char32_t GREEK_ACROPHONIC_TROEZENIAN_FIFTY_ALTERNATE_FORM = 0x00010167;
const char32_t GREEK_ACROPHONIC_HERMIONIAN_FIFTY = 0x00010168;
const char32_t GREEK_ACROPHONIC_THESPIAN_FIFTY = 0x00010169;
const char32_t GREEK_ACROPHONIC_THESPIAN_ONE_HUNDRED = 0x0001016A;
const char32_t GREEK_ACROPHONIC_THESPIAN_THREE_HUNDRED = 0x0001016B;
const char32_t GREEK_ACROPHONIC_EPIDAUREAN_FIVE_HUNDRED = 0x0001016C;
const char32_t GREEK_ACROPHONIC_TROEZENIAN_FIVE_HUNDRED = 0x0001016D;
const char32_t GREEK_ACROPHONIC_THESPIAN_FIVE_HUNDRED = 0x0001016E;
const char32_t GREEK_ACROPHONIC_CARYSTIAN_FIVE_HUNDRED = 0x0001016F;
const char32_t GREEK_ACROPHONIC_NAXIAN_FIVE_HUNDRED = 0x00010170;
const char32_t GREEK_ACROPHONIC_THESPIAN_ONE_THOUSAND = 0x00010171;
const char32_t GREEK_ACROPHONIC_THESPIAN_FIVE_THOUSAND = 0x00010172;
const char32_t GREEK_ACROPHONIC_DELPHIC_FIVE_MNAS = 0x00010173;
const char32_t GREEK_ACROPHONIC_STRATIAN_FIFTY_MNAS = 0x00010174;
const char32_t GREEK_ONE_HALF_SIGN = 0x00010175;
const char32_t GREEK_ONE_HALF_SIGN_ALTERNATE_FORM = 0x00010176;
const char32_t GREEK_TWO_THIRDS_SIGN = 0x00010177;
const char32_t GREEK_THREE_QUARTERS_SIGN = 0x00010178;
const char32_t GREEK_YEAR_SIGN = 0x00010179;
const char32_t GREEK_TALENT_SIGN = 0x0001017A;
const char32_t GREEK_DRACHMA_SIGN = 0x0001017B;
const char32_t GREEK_OBOL_SIGN = 0x0001017C;
const char32_t GREEK_TWO_OBOLS_SIGN = 0x0001017D;
const char32_t GREEK_THREE_OBOLS_SIGN = 0x0001017E;
const char32_t GREEK_FOUR_OBOLS_SIGN = 0x0001017F;
const char32_t GREEK_FIVE_OBOLS_SIGN = 0x00010180;
const char32_t GREEK_METRETES_SIGN = 0x00010181;
const char32_t GREEK_KYATHOS_BASE_SIGN = 0x00010182;
const char32_t GREEK_LITRA_SIGN = 0x00010183;
const char32_t GREEK_OUNKIA_SIGN = 0x00010184;
const char32_t GREEK_XESTES_SIGN = 0x00010185;
const char32_t GREEK_ARTABE_SIGN = 0x00010186;
const char32_t GREEK_AROURA_SIGN = 0x00010187;
const char32_t GREEK_GRAMMA_SIGN = 0x00010188;
const char32_t GREEK_TRYBLION_BASE_SIGN = 0x00010189;
const char32_t GREEK_ZERO_SIGN = 0x0001018A;
const char32_t GREEK_ONE_QUARTER_SIGN = 0x0001018B;
const char32_t GREEK_SINUSOID_SIGN = 0x0001018C;
const char32_t GREEK_INDICTION_SIGN = 0x0001018D;
const char32_t NOMISMA_SIGN = 0x0001018E;
const char32_t ROMAN_SEXTANS_SIGN = 0x00010190;
const char32_t ROMAN_UNCIA_SIGN = 0x00010191;
const char32_t ROMAN_SEMUNCIA_SIGN = 0x00010192;
const char32_t ROMAN_SEXTULA_SIGN = 0x00010193;
const char32_t ROMAN_DIMIDIA_SEXTULA_SIGN = 0x00010194;
const char32_t ROMAN_SILIQUA_SIGN = 0x00010195;
const char32_t ROMAN_DENARIUS_SIGN = 0x00010196;
const char32_t ROMAN_QUINARIUS_SIGN = 0x00010197;
const char32_t ROMAN_SESTERTIUS_SIGN = 0x00010198;
const char32_t ROMAN_DUPONDIUS_SIGN = 0x00010199;
const char32_t ROMAN_AS_SIGN = 0x0001019A;
const char32_t ROMAN_CENTURIAL_SIGN = 0x0001019B;
const char32_t ASCIA_SYMBOL = 0x0001019C;
const char32_t GREEK_SYMBOL_TAU_RHO = 0x000101A0;
const char32_t PHAISTOS_DISC_SIGN_PEDESTRIAN = 0x000101D0;
const char32_t PHAISTOS_DISC_SIGN_PLUMED_HEAD = 0x000101D1;
const char32_t PHAISTOS_DISC_SIGN_TATTOOED_HEAD = 0x000101D2;
const char32_t PHAISTOS_DISC_SIGN_CAPTIVE = 0x000101D3;
const char32_t PHAISTOS_DISC_SIGN_CHILD = 0x000101D4;
const char32_t PHAISTOS_DISC_SIGN_WOMAN = 0x000101D5;
const char32_t PHAISTOS_DISC_SIGN_HELMET = 0x000101D6;
const char32_t PHAISTOS_DISC_SIGN_GAUNTLET = 0x000101D7;
const char32_t PHAISTOS_DISC_SIGN_TIARA = 0x000101D8;
const char32_t PHAISTOS_DISC_SIGN_ARROW = 0x000101D9;
const char32_t PHAISTOS_DISC_SIGN_BOW = 0x000101DA;
const char32_t PHAISTOS_DISC_SIGN_SHIELD = 0x000101DB;
const char32_t PHAISTOS_DISC_SIGN_CLUB = 0x000101DC;
const char32_t PHAISTOS_DISC_SIGN_MANACLES = 0x000101DD;
const char32_t PHAISTOS_DISC_SIGN_MATTOCK = 0x000101DE;
const char32_t PHAISTOS_DISC_SIGN_SAW = 0x000101DF;
const char32_t PHAISTOS_DISC_SIGN_LID = 0x000101E0;
const char32_t PHAISTOS_DISC_SIGN_BOOMERANG = 0x000101E1;
const char32_t PHAISTOS_DISC_SIGN_CARPENTRY_PLANE = 0x000101E2;
const char32_t PHAISTOS_DISC_SIGN_DOLIUM = 0x000101E3;
const char32_t PHAISTOS_DISC_SIGN_COMB = 0x000101E4;
const char32_t PHAISTOS_DISC_SIGN_SLING = 0x000101E5;
const char32_t PHAISTOS_DISC_SIGN_COLUMN = 0x000101E6;
const char32_t PHAISTOS_DISC_SIGN_BEEHIVE = 0x000101E7;
const char32_t PHAISTOS_DISC_SIGN_SHIP = 0x000101E8;
const char32_t PHAISTOS_DISC_SIGN_HORN = 0x000101E9;
const char32_t PHAISTOS_DISC_SIGN_HIDE = 0x000101EA;
const char32_t PHAISTOS_DISC_SIGN_BULLS_LEG = 0x000101EB;
const char32_t PHAISTOS_DISC_SIGN_CAT = 0x000101EC;
const char32_t PHAISTOS_DISC_SIGN_RAM = 0x000101ED;
const char32_t PHAISTOS_DISC_SIGN_EAGLE = 0x000101EE;
const char32_t PHAISTOS_DISC_SIGN_DOVE = 0x000101EF;
const char32_t PHAISTOS_DISC_SIGN_TUNNY = 0x000101F0;
const char32_t PHAISTOS_DISC_SIGN_BEE = 0x000101F1;
const char32_t PHAISTOS_DISC_SIGN_PLANE_TREE = 0x000101F2;
const char32_t PHAISTOS_DISC_SIGN_VINE = 0x000101F3;
const char32_t PHAISTOS_DISC_SIGN_PAPYRUS = 0x000101F4;
const char32_t PHAISTOS_DISC_SIGN_ROSETTE = 0x000101F5;
const char32_t PHAISTOS_DISC_SIGN_LILY = 0x000101F6;
const char32_t PHAISTOS_DISC_SIGN_OX_BACK = 0x000101F7;
const char32_t PHAISTOS_DISC_SIGN_FLUTE = 0x000101F8;
const char32_t PHAISTOS_DISC_SIGN_GRATER = 0x000101F9;
const char32_t PHAISTOS_DISC_SIGN_STRAINER = 0x000101FA;
const char32_t PHAISTOS_DISC_SIGN_SMALL_AXE = 0x000101FB;
const char32_t PHAISTOS_DISC_SIGN_WAVY_BAND = 0x000101FC;
const char32_t PHAISTOS_DISC_SIGN_COMBINING_OBLIQUE_STROKE = 0x000101FD;
const char32_t LYCIAN_LETTER_A = 0x00010280;
const char32_t LYCIAN_LETTER_E = 0x00010281;
const char32_t LYCIAN_LETTER_B = 0x00010282;
const char32_t LYCIAN_LETTER_BH = 0x00010283;
const char32_t LYCIAN_LETTER_G = 0x00010284;
const char32_t LYCIAN_LETTER_D = 0x00010285;
const char32_t LYCIAN_LETTER_I = 0x00010286;
const char32_t LYCIAN_LETTER_W = 0x00010287;
const char32_t LYCIAN_LETTER_Z = 0x00010288;
const char32_t LYCIAN_LETTER_TH = 0x00010289;
const char32_t LYCIAN_LETTER_J = 0x0001028A;
const char32_t LYCIAN_LETTER_K = 0x0001028B;
const char32_t LYCIAN_LETTER_Q = 0x0001028C;
const char32_t LYCIAN_LETTER_L = 0x0001028D;
const char32_t LYCIAN_LETTER_M = 0x0001028E;
const char32_t LYCIAN_LETTER_N = 0x0001028F;
const char32_t LYCIAN_LETTER_MM = 0x00010290;
const char32_t LYCIAN_LETTER_NN = 0x00010291;
const char32_t LYCIAN_LETTER_U = 0x00010292;
const char32_t LYCIAN_LETTER_P = 0x00010293;
const char32_t LYCIAN_LETTER_KK = 0x00010294;
const char32_t LYCIAN_LETTER_R = 0x00010295;
const char32_t LYCIAN_LETTER_S = 0x00010296;
const char32_t LYCIAN_LETTER_T = 0x00010297;
const char32_t LYCIAN_LETTER_TT = 0x00010298;
const char32_t LYCIAN_LETTER_AN = 0x00010299;
const char32_t LYCIAN_LETTER_EN = 0x0001029A;
const char32_t LYCIAN_LETTER_H = 0x0001029B;
const char32_t LYCIAN_LETTER_X = 0x0001029C;
const char32_t CARIAN_LETTER_A = 0x000102A0;
const char32_t CARIAN_LETTER_P2 = 0x000102A1;
const char32_t CARIAN_LETTER_D = 0x000102A2;
const char32_t CARIAN_LETTER_L = 0x000102A3;
const char32_t CARIAN_LETTER_UUU = 0x000102A4;
const char32_t CARIAN_LETTER_R = 0x000102A5;
const char32_t CARIAN_LETTER_LD = 0x000102A6;
const char32_t CARIAN_LETTER_A2 = 0x000102A7;
const char32_t CARIAN_LETTER_Q = 0x000102A8;
const char32_t CARIAN_LETTER_B = 0x000102A9;
const char32_t CARIAN_LETTER_M = 0x000102AA;
const char32_t CARIAN_LETTER_O = 0x000102AB;
const char32_t CARIAN_LETTER_D2 = 0x000102AC;
const char32_t CARIAN_LETTER_T = 0x000102AD;
const char32_t CARIAN_LETTER_SH = 0x000102AE;
const char32_t CARIAN_LETTER_SH2 = 0x000102AF;
const char32_t CARIAN_LETTER_S = 0x000102B0;
const char32_t CARIAN_LETTER_C_18 = 0x000102B1;
const char32_t CARIAN_LETTER_U = 0x000102B2;
const char32_t CARIAN_LETTER_NN = 0x000102B3;
const char32_t CARIAN_LETTER_X = 0x000102B4;
const char32_t CARIAN_LETTER_N = 0x000102B5;
const char32_t CARIAN_LETTER_TT2 = 0x000102B6;
const char32_t CARIAN_LETTER_P = 0x000102B7;
const char32_t CARIAN_LETTER_SS = 0x000102B8;
const char32_t CARIAN_LETTER_I = 0x000102B9;
const char32_t CARIAN_LETTER_E = 0x000102BA;
const char32_t CARIAN_LETTER_UUUU = 0x000102BB;
const char32_t CARIAN_LETTER_K = 0x000102BC;
const char32_t CARIAN_LETTER_K2 = 0x000102BD;
const char32_t CARIAN_LETTER_ND = 0x000102BE;
const char32_t CARIAN_LETTER_UU = 0x000102BF;
const char32_t CARIAN_LETTER_G = 0x000102C0;
const char32_t CARIAN_LETTER_G2 = 0x000102C1;
const char32_t CARIAN_LETTER_ST = 0x000102C2;
const char32_t CARIAN_LETTER_ST2 = 0x000102C3;
const char32_t CARIAN_LETTER_NG = 0x000102C4;
const char32_t CARIAN_LETTER_II = 0x000102C5;
const char32_t CARIAN_LETTER_C_39 = 0x000102C6;
const char32_t CARIAN_LETTER_TT = 0x000102C7;
const char32_t CARIAN_LETTER_UUU2 = 0x000102C8;
const char32_t CARIAN_LETTER_RR = 0x000102C9;
const char32_t CARIAN_LETTER_MB = 0x000102CA;
const char32_t CARIAN_LETTER_MB2 = 0x000102CB;
const char32_t CARIAN_LETTER_MB3 = 0x000102CC;
const char32_t CARIAN_LETTER_MB4 = 0x000102CD;
const char32_t CARIAN_LETTER_LD2 = 0x000102CE;
const char32_t CARIAN_LETTER_E2 = 0x000102CF;
const char32_t CARIAN_LETTER_UUU3 = 0x000102D0;
const char32_t COPTIC_EPACT_THOUSANDS_MARK = 0x000102E0;
const char32_t COPTIC_EPACT_DIGIT_ONE = 0x000102E1;
const char32_t COPTIC_EPACT_DIGIT_TWO = 0x000102E2;
const char32_t COPTIC_EPACT_DIGIT_THREE = 0x000102E3;
const char32_t COPTIC_EPACT_DIGIT_FOUR = 0x000102E4;
const char32_t COPTIC_EPACT_DIGIT_FIVE = 0x000102E5;
const char32_t COPTIC_EPACT_DIGIT_SIX = 0x000102E6;
const char32_t COPTIC_EPACT_DIGIT_SEVEN = 0x000102E7;
const char32_t COPTIC_EPACT_DIGIT_EIGHT = 0x000102E8;
const char32_t COPTIC_EPACT_DIGIT_NINE = 0x000102E9;
const char32_t COPTIC_EPACT_NUMBER_TEN = 0x000102EA;
const char32_t COPTIC_EPACT_NUMBER_TWENTY = 0x000102EB;
const char32_t COPTIC_EPACT_NUMBER_THIRTY = 0x000102EC;
const char32_t COPTIC_EPACT_NUMBER_FORTY = 0x000102ED;
const char32_t COPTIC_EPACT_NUMBER_FIFTY = 0x000102EE;
const char32_t COPTIC_EPACT_NUMBER_SIXTY = 0x000102EF;
const char32_t COPTIC_EPACT_NUMBER_SEVENTY = 0x000102F0;
const char32_t COPTIC_EPACT_NUMBER_EIGHTY = 0x000102F1;
const char32_t COPTIC_EPACT_NUMBER_NINETY = 0x000102F2;
const char32_t COPTIC_EPACT_NUMBER_ONE_HUNDRED = 0x000102F3;
const char32_t COPTIC_EPACT_NUMBER_TWO_HUNDRED = 0x000102F4;
const char32_t COPTIC_EPACT_NUMBER_THREE_HUNDRED = 0x000102F5;
const char32_t COPTIC_EPACT_NUMBER_FOUR_HUNDRED = 0x000102F6;
const char32_t COPTIC_EPACT_NUMBER_FIVE_HUNDRED = 0x000102F7;
const char32_t COPTIC_EPACT_NUMBER_SIX_HUNDRED = 0x000102F8;
const char32_t COPTIC_EPACT_NUMBER_SEVEN_HUNDRED = 0x000102F9;
const char32_t COPTIC_EPACT_NUMBER_EIGHT_HUNDRED = 0x000102FA;
const char32_t COPTIC_EPACT_NUMBER_NINE_HUNDRED = 0x000102FB;
const char32_t OLD_ITALIC_LETTER_A = 0x00010300;
const char32_t OLD_ITALIC_LETTER_BE = 0x00010301;
const char32_t OLD_ITALIC_LETTER_KE = 0x00010302;
const char32_t OLD_ITALIC_LETTER_DE = 0x00010303;
const char32_t OLD_ITALIC_LETTER_E = 0x00010304;
const char32_t OLD_ITALIC_LETTER_VE = 0x00010305;
const char32_t OLD_ITALIC_LETTER_ZE = 0x00010306;
const char32_t OLD_ITALIC_LETTER_HE = 0x00010307;
const char32_t OLD_ITALIC_LETTER_THE = 0x00010308;
const char32_t OLD_ITALIC_LETTER_I = 0x00010309;
const char32_t OLD_ITALIC_LETTER_KA = 0x0001030A;
const char32_t OLD_ITALIC_LETTER_EL = 0x0001030B;
const char32_t OLD_ITALIC_LETTER_EM = 0x0001030C;
const char32_t OLD_ITALIC_LETTER_EN = 0x0001030D;
const char32_t OLD_ITALIC_LETTER_ESH = 0x0001030E;
const char32_t OLD_ITALIC_LETTER_O = 0x0001030F;
const char32_t OLD_ITALIC_LETTER_PE = 0x00010310;
const char32_t OLD_ITALIC_LETTER_SHE = 0x00010311;
const char32_t OLD_ITALIC_LETTER_KU = 0x00010312;
const char32_t OLD_ITALIC_LETTER_ER = 0x00010313;
const char32_t OLD_ITALIC_LETTER_ES = 0x00010314;
const char32_t OLD_ITALIC_LETTER_TE = 0x00010315;
const char32_t OLD_ITALIC_LETTER_U = 0x00010316;
const char32_t OLD_ITALIC_LETTER_EKS = 0x00010317;
const char32_t OLD_ITALIC_LETTER_PHE = 0x00010318;
const char32_t OLD_ITALIC_LETTER_KHE = 0x00010319;
const char32_t OLD_ITALIC_LETTER_EF = 0x0001031A;
const char32_t OLD_ITALIC_LETTER_ERS = 0x0001031B;
const char32_t OLD_ITALIC_LETTER_CHE = 0x0001031C;
const char32_t OLD_ITALIC_LETTER_II = 0x0001031D;
const char32_t OLD_ITALIC_LETTER_UU = 0x0001031E;
const char32_t OLD_ITALIC_LETTER_ESS = 0x0001031F;
const char32_t OLD_ITALIC_NUMERAL_ONE = 0x00010320;
const char32_t OLD_ITALIC_NUMERAL_FIVE = 0x00010321;
const char32_t OLD_ITALIC_NUMERAL_TEN = 0x00010322;
const char32_t OLD_ITALIC_NUMERAL_FIFTY = 0x00010323;
const char32_t OLD_ITALIC_LETTER_YE = 0x0001032D;
const char32_t OLD_ITALIC_LETTER_NORTHERN_TSE = 0x0001032E;
const char32_t OLD_ITALIC_LETTER_SOUTHERN_TSE = 0x0001032F;
const char32_t GOTHIC_LETTER_AHSA = 0x00010330;
const char32_t GOTHIC_LETTER_BAIRKAN = 0x00010331;
const char32_t GOTHIC_LETTER_GIBA = 0x00010332;
const char32_t GOTHIC_LETTER_DAGS = 0x00010333;
const char32_t GOTHIC_LETTER_AIHVUS = 0x00010334;
const char32_t GOTHIC_LETTER_QAIRTHRA = 0x00010335;
const char32_t GOTHIC_LETTER_IUJA = 0x00010336;
const char32_t GOTHIC_LETTER_HAGL = 0x00010337;
const char32_t GOTHIC_LETTER_THIUTH = 0x00010338;
const char32_t GOTHIC_LETTER_EIS = 0x00010339;
const char32_t GOTHIC_LETTER_KUSMA = 0x0001033A;
const char32_t GOTHIC_LETTER_LAGUS = 0x0001033B;
const char32_t GOTHIC_LETTER_MANNA = 0x0001033C;
const char32_t GOTHIC_LETTER_NAUTHS = 0x0001033D;
const char32_t GOTHIC_LETTER_JER = 0x0001033E;
const char32_t GOTHIC_LETTER_URUS = 0x0001033F;
const char32_t GOTHIC_LETTER_PAIRTHRA = 0x00010340;
const char32_t GOTHIC_LETTER_NINETY = 0x00010341;
const char32_t GOTHIC_LETTER_RAIDA = 0x00010342;
const char32_t GOTHIC_LETTER_SAUIL = 0x00010343;
const char32_t GOTHIC_LETTER_TEIWS = 0x00010344;
const char32_t GOTHIC_LETTER_WINJA = 0x00010345;
const char32_t GOTHIC_LETTER_FAIHU = 0x00010346;
const char32_t GOTHIC_LETTER_IGGWS = 0x00010347;
const char32_t GOTHIC_LETTER_HWAIR = 0x00010348;
const char32_t GOTHIC_LETTER_OTHAL = 0x00010349;
const char32_t GOTHIC_LETTER_NINE_HUNDRED = 0x0001034A;
const char32_t OLD_PERMIC_LETTER_AN = 0x00010350;
const char32_t OLD_PERMIC_LETTER_BUR = 0x00010351;
const char32_t OLD_PERMIC_LETTER_GAI = 0x00010352;
const char32_t OLD_PERMIC_LETTER_DOI = 0x00010353;
const char32_t OLD_PERMIC_LETTER_E = 0x00010354;
const char32_t OLD_PERMIC_LETTER_ZHOI = 0x00010355;
const char32_t OLD_PERMIC_LETTER_DZHOI = 0x00010356;
const char32_t OLD_PERMIC_LETTER_ZATA = 0x00010357;
const char32_t OLD_PERMIC_LETTER_DZITA = 0x00010358;
const char32_t OLD_PERMIC_LETTER_I = 0x00010359;
const char32_t OLD_PERMIC_LETTER_KOKE = 0x0001035A;
const char32_t OLD_PERMIC_LETTER_LEI = 0x0001035B;
const char32_t OLD_PERMIC_LETTER_MENOE = 0x0001035C;
const char32_t OLD_PERMIC_LETTER_NENOE = 0x0001035D;
const char32_t OLD_PERMIC_LETTER_VOOI = 0x0001035E;
const char32_t OLD_PERMIC_LETTER_PEEI = 0x0001035F;
const char32_t OLD_PERMIC_LETTER_REI = 0x00010360;
const char32_t OLD_PERMIC_LETTER_SII = 0x00010361;
const char32_t OLD_PERMIC_LETTER_TAI = 0x00010362;
const char32_t OLD_PERMIC_LETTER_U = 0x00010363;
const char32_t OLD_PERMIC_LETTER_CHERY = 0x00010364;
const char32_t OLD_PERMIC_LETTER_SHOOI = 0x00010365;
const char32_t OLD_PERMIC_LETTER_SHCHOOI = 0x00010366;
const char32_t OLD_PERMIC_LETTER_YRY = 0x00010367;
const char32_t OLD_PERMIC_LETTER_YERU = 0x00010368;
const char32_t OLD_PERMIC_LETTER_O = 0x00010369;
const char32_t OLD_PERMIC_LETTER_OO = 0x0001036A;
const char32_t OLD_PERMIC_LETTER_EF = 0x0001036B;
const char32_t OLD_PERMIC_LETTER_HA = 0x0001036C;
const char32_t OLD_PERMIC_LETTER_TSIU = 0x0001036D;
const char32_t OLD_PERMIC_LETTER_VER = 0x0001036E;
const char32_t OLD_PERMIC_LETTER_YER = 0x0001036F;
const char32_t OLD_PERMIC_LETTER_YERI = 0x00010370;
const char32_t OLD_PERMIC_LETTER_YAT = 0x00010371;
const char32_t OLD_PERMIC_LETTER_IE = 0x00010372;
const char32_t OLD_PERMIC_LETTER_YU = 0x00010373;
const char32_t OLD_PERMIC_LETTER_YA = 0x00010374;
const char32_t OLD_PERMIC_LETTER_IA = 0x00010375;
const char32_t COMBINING_OLD_PERMIC_LETTER_AN = 0x00010376;
const char32_t COMBINING_OLD_PERMIC_LETTER_DOI = 0x00010377;
const char32_t COMBINING_OLD_PERMIC_LETTER_ZATA = 0x00010378;
const char32_t COMBINING_OLD_PERMIC_LETTER_NENOE = 0x00010379;
const char32_t COMBINING_OLD_PERMIC_LETTER_SII = 0x0001037A;
const char32_t UGARITIC_LETTER_ALPA = 0x00010380;
const char32_t UGARITIC_LETTER_BETA = 0x00010381;
const char32_t UGARITIC_LETTER_GAMLA = 0x00010382;
const char32_t UGARITIC_LETTER_KHA = 0x00010383;
const char32_t UGARITIC_LETTER_DELTA = 0x00010384;
const char32_t UGARITIC_LETTER_HO = 0x00010385;
const char32_t UGARITIC_LETTER_WO = 0x00010386;
const char32_t UGARITIC_LETTER_ZETA = 0x00010387;
const char32_t UGARITIC_LETTER_HOTA = 0x00010388;
const char32_t UGARITIC_LETTER_TET = 0x00010389;
const char32_t UGARITIC_LETTER_YOD = 0x0001038A;
const char32_t UGARITIC_LETTER_KAF = 0x0001038B;
const char32_t UGARITIC_LETTER_SHIN = 0x0001038C;
const char32_t UGARITIC_LETTER_LAMDA = 0x0001038D;
const char32_t UGARITIC_LETTER_MEM = 0x0001038E;
const char32_t UGARITIC_LETTER_DHAL = 0x0001038F;
const char32_t UGARITIC_LETTER_NUN = 0x00010390;
const char32_t UGARITIC_LETTER_ZU = 0x00010391;
const char32_t UGARITIC_LETTER_SAMKA = 0x00010392;
const char32_t UGARITIC_LETTER_AIN = 0x00010393;
const char32_t UGARITIC_LETTER_PU = 0x00010394;
const char32_t UGARITIC_LETTER_SADE = 0x00010395;
const char32_t UGARITIC_LETTER_QOPA = 0x00010396;
const char32_t UGARITIC_LETTER_RASHA = 0x00010397;
const char32_t UGARITIC_LETTER_THANNA = 0x00010398;
const char32_t UGARITIC_LETTER_GHAIN = 0x00010399;
const char32_t UGARITIC_LETTER_TO = 0x0001039A;
const char32_t UGARITIC_LETTER_I = 0x0001039B;
const char32_t UGARITIC_LETTER_U = 0x0001039C;
const char32_t UGARITIC_LETTER_SSU = 0x0001039D;
const char32_t UGARITIC_WORD_DIVIDER = 0x0001039F;
const char32_t OLD_PERSIAN_SIGN_A = 0x000103A0;
const char32_t OLD_PERSIAN_SIGN_I = 0x000103A1;
const char32_t OLD_PERSIAN_SIGN_U = 0x000103A2;
const char32_t OLD_PERSIAN_SIGN_KA = 0x000103A3;
const char32_t OLD_PERSIAN_SIGN_KU = 0x000103A4;
const char32_t OLD_PERSIAN_SIGN_GA = 0x000103A5;
const char32_t OLD_PERSIAN_SIGN_GU = 0x000103A6;
const char32_t OLD_PERSIAN_SIGN_XA = 0x000103A7;
const char32_t OLD_PERSIAN_SIGN_CA = 0x000103A8;
const char32_t OLD_PERSIAN_SIGN_JA = 0x000103A9;
const char32_t OLD_PERSIAN_SIGN_JI = 0x000103AA;
const char32_t OLD_PERSIAN_SIGN_TA = 0x000103AB;
const char32_t OLD_PERSIAN_SIGN_TU = 0x000103AC;
const char32_t OLD_PERSIAN_SIGN_DA = 0x000103AD;
const char32_t OLD_PERSIAN_SIGN_DI = 0x000103AE;
const char32_t OLD_PERSIAN_SIGN_DU = 0x000103AF;
const char32_t OLD_PERSIAN_SIGN_THA = 0x000103B0;
const char32_t OLD_PERSIAN_SIGN_PA = 0x000103B1;
const char32_t OLD_PERSIAN_SIGN_BA = 0x000103B2;
const char32_t OLD_PERSIAN_SIGN_FA = 0x000103B3;
const char32_t OLD_PERSIAN_SIGN_NA = 0x000103B4;
const char32_t OLD_PERSIAN_SIGN_NU = 0x000103B5;
const char32_t OLD_PERSIAN_SIGN_MA = 0x000103B6;
const char32_t OLD_PERSIAN_SIGN_MI = 0x000103B7;
const char32_t OLD_PERSIAN_SIGN_MU = 0x000103B8;
const char32_t OLD_PERSIAN_SIGN_YA = 0x000103B9;
const char32_t OLD_PERSIAN_SIGN_VA = 0x000103BA;
const char32_t OLD_PERSIAN_SIGN_VI = 0x000103BB;
const char32_t OLD_PERSIAN_SIGN_RA = 0x000103BC;
const char32_t OLD_PERSIAN_SIGN_RU = 0x000103BD;
const char32_t OLD_PERSIAN_SIGN_LA = 0x000103BE;
const char32_t OLD_PERSIAN_SIGN_SA = 0x000103BF;
const char32_t OLD_PERSIAN_SIGN_ZA = 0x000103C0;
const char32_t OLD_PERSIAN_SIGN_SHA = 0x000103C1;
const char32_t OLD_PERSIAN_SIGN_SSA = 0x000103C2;
const char32_t OLD_PERSIAN_SIGN_HA = 0x000103C3;
const char32_t OLD_PERSIAN_SIGN_AURAMAZDAA = 0x000103C8;
const char32_t OLD_PERSIAN_SIGN_AURAMAZDAA_2 = 0x000103C9;
const char32_t OLD_PERSIAN_SIGN_AURAMAZDAAHA = 0x000103CA;
const char32_t OLD_PERSIAN_SIGN_XSHAAYATHIYA = 0x000103CB;
const char32_t OLD_PERSIAN_SIGN_DAHYAAUSH = 0x000103CC;
const char32_t OLD_PERSIAN_SIGN_DAHYAAUSH_2 = 0x000103CD;
const char32_t OLD_PERSIAN_SIGN_BAGA = 0x000103CE;
const char32_t OLD_PERSIAN_SIGN_BUUMISH = 0x000103CF;
const char32_t OLD_PERSIAN_WORD_DIVIDER = 0x000103D0;
const char32_t OLD_PERSIAN_NUMBER_ONE = 0x000103D1;
const char32_t OLD_PERSIAN_NUMBER_TWO = 0x000103D2;
const char32_t OLD_PERSIAN_NUMBER_TEN = 0x000103D3;
const char32_t OLD_PERSIAN_NUMBER_TWENTY = 0x000103D4;
const char32_t OLD_PERSIAN_NUMBER_HUNDRED = 0x000103D5;
const char32_t DESERET_CAPITAL_LETTER_LONG_I = 0x00010400;
const char32_t DESERET_CAPITAL_LETTER_LONG_E = 0x00010401;
const char32_t DESERET_CAPITAL_LETTER_LONG_A = 0x00010402;
const char32_t DESERET_CAPITAL_LETTER_LONG_AH = 0x00010403;
const char32_t DESERET_CAPITAL_LETTER_LONG_O = 0x00010404;
const char32_t DESERET_CAPITAL_LETTER_LONG_OO = 0x00010405;
const char32_t DESERET_CAPITAL_LETTER_SHORT_I = 0x00010406;
const char32_t DESERET_CAPITAL_LETTER_SHORT_E = 0x00010407;
const char32_t DESERET_CAPITAL_LETTER_SHORT_A = 0x00010408;
const char32_t DESERET_CAPITAL_LETTER_SHORT_AH = 0x00010409;
const char32_t DESERET_CAPITAL_LETTER_SHORT_O = 0x0001040A;
const char32_t DESERET_CAPITAL_LETTER_SHORT_OO = 0x0001040B;
const char32_t DESERET_CAPITAL_LETTER_AY = 0x0001040C;
const char32_t DESERET_CAPITAL_LETTER_OW = 0x0001040D;
const char32_t DESERET_CAPITAL_LETTER_WU = 0x0001040E;
const char32_t DESERET_CAPITAL_LETTER_YEE = 0x0001040F;
const char32_t DESERET_CAPITAL_LETTER_H = 0x00010410;
const char32_t DESERET_CAPITAL_LETTER_PEE = 0x00010411;
const char32_t DESERET_CAPITAL_LETTER_BEE = 0x00010412;
const char32_t DESERET_CAPITAL_LETTER_TEE = 0x00010413;
const char32_t DESERET_CAPITAL_LETTER_DEE = 0x00010414;
const char32_t DESERET_CAPITAL_LETTER_CHEE = 0x00010415;
const char32_t DESERET_CAPITAL_LETTER_JEE = 0x00010416;
const char32_t DESERET_CAPITAL_LETTER_KAY = 0x00010417;
const char32_t DESERET_CAPITAL_LETTER_GAY = 0x00010418;
const char32_t DESERET_CAPITAL_LETTER_EF = 0x00010419;
const char32_t DESERET_CAPITAL_LETTER_VEE = 0x0001041A;
const char32_t DESERET_CAPITAL_LETTER_ETH = 0x0001041B;
const char32_t DESERET_CAPITAL_LETTER_THEE = 0x0001041C;
const char32_t DESERET_CAPITAL_LETTER_ES = 0x0001041D;
const char32_t DESERET_CAPITAL_LETTER_ZEE = 0x0001041E;
const char32_t DESERET_CAPITAL_LETTER_ESH = 0x0001041F;
const char32_t DESERET_CAPITAL_LETTER_ZHEE = 0x00010420;
const char32_t DESERET_CAPITAL_LETTER_ER = 0x00010421;
const char32_t DESERET_CAPITAL_LETTER_EL = 0x00010422;
const char32_t DESERET_CAPITAL_LETTER_EM = 0x00010423;
const char32_t DESERET_CAPITAL_LETTER_EN = 0x00010424;
const char32_t DESERET_CAPITAL_LETTER_ENG = 0x00010425;
const char32_t DESERET_CAPITAL_LETTER_OI = 0x00010426;
const char32_t DESERET_CAPITAL_LETTER_EW = 0x00010427;
const char32_t DESERET_SMALL_LETTER_LONG_I = 0x00010428;
const char32_t DESERET_SMALL_LETTER_LONG_E = 0x00010429;
const char32_t DESERET_SMALL_LETTER_LONG_A = 0x0001042A;
const char32_t DESERET_SMALL_LETTER_LONG_AH = 0x0001042B;
const char32_t DESERET_SMALL_LETTER_LONG_O = 0x0001042C;
const char32_t DESERET_SMALL_LETTER_LONG_OO = 0x0001042D;
const char32_t DESERET_SMALL_LETTER_SHORT_I = 0x0001042E;
const char32_t DESERET_SMALL_LETTER_SHORT_E = 0x0001042F;
const char32_t DESERET_SMALL_LETTER_SHORT_A = 0x00010430;
const char32_t DESERET_SMALL_LETTER_SHORT_AH = 0x00010431;
const char32_t DESERET_SMALL_LETTER_SHORT_O = 0x00010432;
const char32_t DESERET_SMALL_LETTER_SHORT_OO = 0x00010433;
const char32_t DESERET_SMALL_LETTER_AY = 0x00010434;
const char32_t DESERET_SMALL_LETTER_OW = 0x00010435;
const char32_t DESERET_SMALL_LETTER_WU = 0x00010436;
const char32_t DESERET_SMALL_LETTER_YEE = 0x00010437;
const char32_t DESERET_SMALL_LETTER_H = 0x00010438;
const char32_t DESERET_SMALL_LETTER_PEE = 0x00010439;
const char32_t DESERET_SMALL_LETTER_BEE = 0x0001043A;
const char32_t DESERET_SMALL_LETTER_TEE = 0x0001043B;
const char32_t DESERET_SMALL_LETTER_DEE = 0x0001043C;
const char32_t DESERET_SMALL_LETTER_CHEE = 0x0001043D;
const char32_t DESERET_SMALL_LETTER_JEE = 0x0001043E;
const char32_t DESERET_SMALL_LETTER_KAY = 0x0001043F;
const char32_t DESERET_SMALL_LETTER_GAY = 0x00010440;
const char32_t DESERET_SMALL_LETTER_EF = 0x00010441;
const char32_t DESERET_SMALL_LETTER_VEE = 0x00010442;
const char32_t DESERET_SMALL_LETTER_ETH = 0x00010443;
const char32_t DESERET_SMALL_LETTER_THEE = 0x00010444;
const char32_t DESERET_SMALL_LETTER_ES = 0x00010445;
const char32_t DESERET_SMALL_LETTER_ZEE = 0x00010446;
const char32_t DESERET_SMALL_LETTER_ESH = 0x00010447;
const char32_t DESERET_SMALL_LETTER_ZHEE = 0x00010448;
const char32_t DESERET_SMALL_LETTER_ER = 0x00010449;
const char32_t DESERET_SMALL_LETTER_EL = 0x0001044A;
const char32_t DESERET_SMALL_LETTER_EM = 0x0001044B;
const char32_t DESERET_SMALL_LETTER_EN = 0x0001044C;
const char32_t DESERET_SMALL_LETTER_ENG = 0x0001044D;
const char32_t DESERET_SMALL_LETTER_OI = 0x0001044E;
const char32_t DESERET_SMALL_LETTER_EW = 0x0001044F;
const char32_t SHAVIAN_LETTER_PEEP = 0x00010450;
const char32_t SHAVIAN_LETTER_TOT = 0x00010451;
const char32_t SHAVIAN_LETTER_KICK = 0x00010452;
const char32_t SHAVIAN_LETTER_FEE = 0x00010453;
const char32_t SHAVIAN_LETTER_THIGH = 0x00010454;
const char32_t SHAVIAN_LETTER_SO = 0x00010455;
const char32_t SHAVIAN_LETTER_SURE = 0x00010456;
const char32_t SHAVIAN_LETTER_CHURCH = 0x00010457;
const char32_t SHAVIAN_LETTER_YEA = 0x00010458;
const char32_t SHAVIAN_LETTER_HUNG = 0x00010459;
const char32_t SHAVIAN_LETTER_BIB = 0x0001045A;
const char32_t SHAVIAN_LETTER_DEAD = 0x0001045B;
const char32_t SHAVIAN_LETTER_GAG = 0x0001045C;
const char32_t SHAVIAN_LETTER_VOW = 0x0001045D;
const char32_t SHAVIAN_LETTER_THEY = 0x0001045E;
const char32_t SHAVIAN_LETTER_ZOO = 0x0001045F;
const char32_t SHAVIAN_LETTER_MEASURE = 0x00010460;
const char32_t SHAVIAN_LETTER_JUDGE = 0x00010461;
const char32_t SHAVIAN_LETTER_WOE = 0x00010462;
const char32_t SHAVIAN_LETTER_HA_HA = 0x00010463;
const char32_t SHAVIAN_LETTER_LOLL = 0x00010464;
const char32_t SHAVIAN_LETTER_MIME = 0x00010465;
const char32_t SHAVIAN_LETTER_IF = 0x00010466;
const char32_t SHAVIAN_LETTER_EGG = 0x00010467;
const char32_t SHAVIAN_LETTER_ASH = 0x00010468;
const char32_t SHAVIAN_LETTER_ADO = 0x00010469;
const char32_t SHAVIAN_LETTER_ON = 0x0001046A;
const char32_t SHAVIAN_LETTER_WOOL = 0x0001046B;
const char32_t SHAVIAN_LETTER_OUT = 0x0001046C;
const char32_t SHAVIAN_LETTER_AH = 0x0001046D;
const char32_t SHAVIAN_LETTER_ROAR = 0x0001046E;
const char32_t SHAVIAN_LETTER_NUN = 0x0001046F;
const char32_t SHAVIAN_LETTER_EAT = 0x00010470;
const char32_t SHAVIAN_LETTER_AGE = 0x00010471;
const char32_t SHAVIAN_LETTER_ICE = 0x00010472;
const char32_t SHAVIAN_LETTER_UP = 0x00010473;
const char32_t SHAVIAN_LETTER_OAK = 0x00010474;
const char32_t SHAVIAN_LETTER_OOZE = 0x00010475;
const char32_t SHAVIAN_LETTER_OIL = 0x00010476;
const char32_t SHAVIAN_LETTER_AWE = 0x00010477;
const char32_t SHAVIAN_LETTER_ARE = 0x00010478;
const char32_t SHAVIAN_LETTER_OR = 0x00010479;
const char32_t SHAVIAN_LETTER_AIR = 0x0001047A;
const char32_t SHAVIAN_LETTER_ERR = 0x0001047B;
const char32_t SHAVIAN_LETTER_ARRAY = 0x0001047C;
const char32_t SHAVIAN_LETTER_EAR = 0x0001047D;
const char32_t SHAVIAN_LETTER_IAN = 0x0001047E;
const char32_t SHAVIAN_LETTER_YEW = 0x0001047F;
const char32_t OSMANYA_LETTER_ALEF = 0x00010480;
const char32_t OSMANYA_LETTER_BA = 0x00010481;
const char32_t OSMANYA_LETTER_TA = 0x00010482;
const char32_t OSMANYA_LETTER_JA = 0x00010483;
const char32_t OSMANYA_LETTER_XA = 0x00010484;
const char32_t OSMANYA_LETTER_KHA = 0x00010485;
const char32_t OSMANYA_LETTER_DEEL = 0x00010486;
const char32_t OSMANYA_LETTER_RA = 0x00010487;
const char32_t OSMANYA_LETTER_SA = 0x00010488;
const char32_t OSMANYA_LETTER_SHIIN = 0x00010489;
const char32_t OSMANYA_LETTER_DHA = 0x0001048A;
const char32_t OSMANYA_LETTER_CAYN = 0x0001048B;
const char32_t OSMANYA_LETTER_GA = 0x0001048C;
const char32_t OSMANYA_LETTER_FA = 0x0001048D;
const char32_t OSMANYA_LETTER_QAAF = 0x0001048E;
const char32_t OSMANYA_LETTER_KAAF = 0x0001048F;
const char32_t OSMANYA_LETTER_LAAN = 0x00010490;
const char32_t OSMANYA_LETTER_MIIN = 0x00010491;
const char32_t OSMANYA_LETTER_NUUN = 0x00010492;
const char32_t OSMANYA_LETTER_WAW = 0x00010493;
const char32_t OSMANYA_LETTER_HA = 0x00010494;
const char32_t OSMANYA_LETTER_YA = 0x00010495;
const char32_t OSMANYA_LETTER_A = 0x00010496;
const char32_t OSMANYA_LETTER_E = 0x00010497;
const char32_t OSMANYA_LETTER_I = 0x00010498;
const char32_t OSMANYA_LETTER_O = 0x00010499;
const char32_t OSMANYA_LETTER_U = 0x0001049A;
const char32_t OSMANYA_LETTER_AA = 0x0001049B;
const char32_t OSMANYA_LETTER_EE = 0x0001049C;
const char32_t OSMANYA_LETTER_OO = 0x0001049D;
const char32_t OSMANYA_DIGIT_ZERO = 0x000104A0;
const char32_t OSMANYA_DIGIT_ONE = 0x000104A1;
const char32_t OSMANYA_DIGIT_TWO = 0x000104A2;
const char32_t OSMANYA_DIGIT_THREE = 0x000104A3;
const char32_t OSMANYA_DIGIT_FOUR = 0x000104A4;
const char32_t OSMANYA_DIGIT_FIVE = 0x000104A5;
const char32_t OSMANYA_DIGIT_SIX = 0x000104A6;
const char32_t OSMANYA_DIGIT_SEVEN = 0x000104A7;
const char32_t OSMANYA_DIGIT_EIGHT = 0x000104A8;
const char32_t OSMANYA_DIGIT_NINE = 0x000104A9;
const char32_t OSAGE_CAPITAL_LETTER_A = 0x000104B0;
const char32_t OSAGE_CAPITAL_LETTER_AI = 0x000104B1;
const char32_t OSAGE_CAPITAL_LETTER_AIN = 0x000104B2;
const char32_t OSAGE_CAPITAL_LETTER_AH = 0x000104B3;
const char32_t OSAGE_CAPITAL_LETTER_BRA = 0x000104B4;
const char32_t OSAGE_CAPITAL_LETTER_CHA = 0x000104B5;
const char32_t OSAGE_CAPITAL_LETTER_EHCHA = 0x000104B6;
const char32_t OSAGE_CAPITAL_LETTER_E = 0x000104B7;
const char32_t OSAGE_CAPITAL_LETTER_EIN = 0x000104B8;
const char32_t OSAGE_CAPITAL_LETTER_HA = 0x000104B9;
const char32_t OSAGE_CAPITAL_LETTER_HYA = 0x000104BA;
const char32_t OSAGE_CAPITAL_LETTER_I = 0x000104BB;
const char32_t OSAGE_CAPITAL_LETTER_KA = 0x000104BC;
const char32_t OSAGE_CAPITAL_LETTER_EHKA = 0x000104BD;
const char32_t OSAGE_CAPITAL_LETTER_KYA = 0x000104BE;
const char32_t OSAGE_CAPITAL_LETTER_LA = 0x000104BF;
const char32_t OSAGE_CAPITAL_LETTER_MA = 0x000104C0;
const char32_t OSAGE_CAPITAL_LETTER_NA = 0x000104C1;
const char32_t OSAGE_CAPITAL_LETTER_O = 0x000104C2;
const char32_t OSAGE_CAPITAL_LETTER_OIN = 0x000104C3;
const char32_t OSAGE_CAPITAL_LETTER_PA = 0x000104C4;
const char32_t OSAGE_CAPITAL_LETTER_EHPA = 0x000104C5;
const char32_t OSAGE_CAPITAL_LETTER_SA = 0x000104C6;
const char32_t OSAGE_CAPITAL_LETTER_SHA = 0x000104C7;
const char32_t OSAGE_CAPITAL_LETTER_TA = 0x000104C8;
const char32_t OSAGE_CAPITAL_LETTER_EHTA = 0x000104C9;
const char32_t OSAGE_CAPITAL_LETTER_TSA = 0x000104CA;
const char32_t OSAGE_CAPITAL_LETTER_EHTSA = 0x000104CB;
const char32_t OSAGE_CAPITAL_LETTER_TSHA = 0x000104CC;
const char32_t OSAGE_CAPITAL_LETTER_DHA = 0x000104CD;
const char32_t OSAGE_CAPITAL_LETTER_U = 0x000104CE;
const char32_t OSAGE_CAPITAL_LETTER_WA = 0x000104CF;
const char32_t OSAGE_CAPITAL_LETTER_KHA = 0x000104D0;
const char32_t OSAGE_CAPITAL_LETTER_GHA = 0x000104D1;
const char32_t OSAGE_CAPITAL_LETTER_ZA = 0x000104D2;
const char32_t OSAGE_CAPITAL_LETTER_ZHA = 0x000104D3;
const char32_t OSAGE_SMALL_LETTER_A = 0x000104D8;
const char32_t OSAGE_SMALL_LETTER_AI = 0x000104D9;
const char32_t OSAGE_SMALL_LETTER_AIN = 0x000104DA;
const char32_t OSAGE_SMALL_LETTER_AH = 0x000104DB;
const char32_t OSAGE_SMALL_LETTER_BRA = 0x000104DC;
const char32_t OSAGE_SMALL_LETTER_CHA = 0x000104DD;
const char32_t OSAGE_SMALL_LETTER_EHCHA = 0x000104DE;
const char32_t OSAGE_SMALL_LETTER_E = 0x000104DF;
const char32_t OSAGE_SMALL_LETTER_EIN = 0x000104E0;
const char32_t OSAGE_SMALL_LETTER_HA = 0x000104E1;
const char32_t OSAGE_SMALL_LETTER_HYA = 0x000104E2;
const char32_t OSAGE_SMALL_LETTER_I = 0x000104E3;
const char32_t OSAGE_SMALL_LETTER_KA = 0x000104E4;
const char32_t OSAGE_SMALL_LETTER_EHKA = 0x000104E5;
const char32_t OSAGE_SMALL_LETTER_KYA = 0x000104E6;
const char32_t OSAGE_SMALL_LETTER_LA = 0x000104E7;
const char32_t OSAGE_SMALL_LETTER_MA = 0x000104E8;
const char32_t OSAGE_SMALL_LETTER_NA = 0x000104E9;
const char32_t OSAGE_SMALL_LETTER_O = 0x000104EA;
const char32_t OSAGE_SMALL_LETTER_OIN = 0x000104EB;
const char32_t OSAGE_SMALL_LETTER_PA = 0x000104EC;
const char32_t OSAGE_SMALL_LETTER_EHPA = 0x000104ED;
const char32_t OSAGE_SMALL_LETTER_SA = 0x000104EE;
const char32_t OSAGE_SMALL_LETTER_SHA = 0x000104EF;
const char32_t OSAGE_SMALL_LETTER_TA = 0x000104F0;
const char32_t OSAGE_SMALL_LETTER_EHTA = 0x000104F1;
const char32_t OSAGE_SMALL_LETTER_TSA = 0x000104F2;
const char32_t OSAGE_SMALL_LETTER_EHTSA = 0x000104F3;
const char32_t OSAGE_SMALL_LETTER_TSHA = 0x000104F4;
const char32_t OSAGE_SMALL_LETTER_DHA = 0x000104F5;
const char32_t OSAGE_SMALL_LETTER_U = 0x000104F6;
const char32_t OSAGE_SMALL_LETTER_WA = 0x000104F7;
const char32_t OSAGE_SMALL_LETTER_KHA = 0x000104F8;
const char32_t OSAGE_SMALL_LETTER_GHA = 0x000104F9;
const char32_t OSAGE_SMALL_LETTER_ZA = 0x000104FA;
const char32_t OSAGE_SMALL_LETTER_ZHA = 0x000104FB;
const char32_t ELBASAN_LETTER_A = 0x00010500;
const char32_t ELBASAN_LETTER_BE = 0x00010501;
const char32_t ELBASAN_LETTER_CE = 0x00010502;
const char32_t ELBASAN_LETTER_CHE = 0x00010503;
const char32_t ELBASAN_LETTER_DE = 0x00010504;
const char32_t ELBASAN_LETTER_NDE = 0x00010505;
const char32_t ELBASAN_LETTER_DHE = 0x00010506;
const char32_t ELBASAN_LETTER_EI = 0x00010507;
const char32_t ELBASAN_LETTER_E = 0x00010508;
const char32_t ELBASAN_LETTER_FE = 0x00010509;
const char32_t ELBASAN_LETTER_GE = 0x0001050A;
const char32_t ELBASAN_LETTER_GJE = 0x0001050B;
const char32_t ELBASAN_LETTER_HE = 0x0001050C;
const char32_t ELBASAN_LETTER_I = 0x0001050D;
const char32_t ELBASAN_LETTER_JE = 0x0001050E;
const char32_t ELBASAN_LETTER_KE = 0x0001050F;
const char32_t ELBASAN_LETTER_LE = 0x00010510;
const char32_t ELBASAN_LETTER_LLE = 0x00010511;
const char32_t ELBASAN_LETTER_ME = 0x00010512;
const char32_t ELBASAN_LETTER_NE = 0x00010513;
const char32_t ELBASAN_LETTER_NA = 0x00010514;
const char32_t ELBASAN_LETTER_NJE = 0x00010515;
const char32_t ELBASAN_LETTER_O = 0x00010516;
const char32_t ELBASAN_LETTER_PE = 0x00010517;
const char32_t ELBASAN_LETTER_QE = 0x00010518;
const char32_t ELBASAN_LETTER_RE = 0x00010519;
const char32_t ELBASAN_LETTER_RRE = 0x0001051A;
const char32_t ELBASAN_LETTER_SE = 0x0001051B;
const char32_t ELBASAN_LETTER_SHE = 0x0001051C;
const char32_t ELBASAN_LETTER_TE = 0x0001051D;
const char32_t ELBASAN_LETTER_THE = 0x0001051E;
const char32_t ELBASAN_LETTER_U = 0x0001051F;
const char32_t ELBASAN_LETTER_VE = 0x00010520;
const char32_t ELBASAN_LETTER_XE = 0x00010521;
const char32_t ELBASAN_LETTER_Y = 0x00010522;
const char32_t ELBASAN_LETTER_ZE = 0x00010523;
const char32_t ELBASAN_LETTER_ZHE = 0x00010524;
const char32_t ELBASAN_LETTER_GHE = 0x00010525;
const char32_t ELBASAN_LETTER_GHAMMA = 0x00010526;
const char32_t ELBASAN_LETTER_KHE = 0x00010527;
const char32_t CAUCASIAN_ALBANIAN_LETTER_ALT = 0x00010530;
const char32_t CAUCASIAN_ALBANIAN_LETTER_BET = 0x00010531;
const char32_t CAUCASIAN_ALBANIAN_LETTER_GIM = 0x00010532;
const char32_t CAUCASIAN_ALBANIAN_LETTER_DAT = 0x00010533;
const char32_t CAUCASIAN_ALBANIAN_LETTER_EB = 0x00010534;
const char32_t CAUCASIAN_ALBANIAN_LETTER_ZARL = 0x00010535;
const char32_t CAUCASIAN_ALBANIAN_LETTER_EYN = 0x00010536;
const char32_t CAUCASIAN_ALBANIAN_LETTER_ZHIL = 0x00010537;
const char32_t CAUCASIAN_ALBANIAN_LETTER_TAS = 0x00010538;
const char32_t CAUCASIAN_ALBANIAN_LETTER_CHA = 0x00010539;
const char32_t CAUCASIAN_ALBANIAN_LETTER_YOWD = 0x0001053A;
const char32_t CAUCASIAN_ALBANIAN_LETTER_ZHA = 0x0001053B;
const char32_t CAUCASIAN_ALBANIAN_LETTER_IRB = 0x0001053C;
const char32_t CAUCASIAN_ALBANIAN_LETTER_SHA = 0x0001053D;
const char32_t CAUCASIAN_ALBANIAN_LETTER_LAN = 0x0001053E;
const char32_t CAUCASIAN_ALBANIAN_LETTER_INYA = 0x0001053F;
const char32_t CAUCASIAN_ALBANIAN_LETTER_XEYN = 0x00010540;
const char32_t CAUCASIAN_ALBANIAN_LETTER_DYAN = 0x00010541;
const char32_t CAUCASIAN_ALBANIAN_LETTER_CAR = 0x00010542;
const char32_t CAUCASIAN_ALBANIAN_LETTER_JHOX = 0x00010543;
const char32_t CAUCASIAN_ALBANIAN_LETTER_KAR = 0x00010544;
const char32_t CAUCASIAN_ALBANIAN_LETTER_LYIT = 0x00010545;
const char32_t CAUCASIAN_ALBANIAN_LETTER_HEYT = 0x00010546;
const char32_t CAUCASIAN_ALBANIAN_LETTER_QAY = 0x00010547;
const char32_t CAUCASIAN_ALBANIAN_LETTER_AOR = 0x00010548;
const char32_t CAUCASIAN_ALBANIAN_LETTER_CHOY = 0x00010549;
const char32_t CAUCASIAN_ALBANIAN_LETTER_CHI = 0x0001054A;
const char32_t CAUCASIAN_ALBANIAN_LETTER_CYAY = 0x0001054B;
const char32_t CAUCASIAN_ALBANIAN_LETTER_MAQ = 0x0001054C;
const char32_t CAUCASIAN_ALBANIAN_LETTER_QAR = 0x0001054D;
const char32_t CAUCASIAN_ALBANIAN_LETTER_NOWC = 0x0001054E;
const char32_t CAUCASIAN_ALBANIAN_LETTER_DZYAY = 0x0001054F;
const char32_t CAUCASIAN_ALBANIAN_LETTER_SHAK = 0x00010550;
const char32_t CAUCASIAN_ALBANIAN_LETTER_JAYN = 0x00010551;
const char32_t CAUCASIAN_ALBANIAN_LETTER_ON = 0x00010552;
const char32_t CAUCASIAN_ALBANIAN_LETTER_TYAY = 0x00010553;
const char32_t CAUCASIAN_ALBANIAN_LETTER_FAM = 0x00010554;
const char32_t CAUCASIAN_ALBANIAN_LETTER_DZAY = 0x00010555;
const char32_t CAUCASIAN_ALBANIAN_LETTER_CHAT = 0x00010556;
const char32_t CAUCASIAN_ALBANIAN_LETTER_PEN = 0x00010557;
const char32_t CAUCASIAN_ALBANIAN_LETTER_GHEYS = 0x00010558;
const char32_t CAUCASIAN_ALBANIAN_LETTER_RAT = 0x00010559;
const char32_t CAUCASIAN_ALBANIAN_LETTER_SEYK = 0x0001055A;
const char32_t CAUCASIAN_ALBANIAN_LETTER_VEYZ = 0x0001055B;
const char32_t CAUCASIAN_ALBANIAN_LETTER_TIWR = 0x0001055C;
const char32_t CAUCASIAN_ALBANIAN_LETTER_SHOY = 0x0001055D;
const char32_t CAUCASIAN_ALBANIAN_LETTER_IWN = 0x0001055E;
const char32_t CAUCASIAN_ALBANIAN_LETTER_CYAW = 0x0001055F;
const char32_t CAUCASIAN_ALBANIAN_LETTER_CAYN = 0x00010560;
const char32_t CAUCASIAN_ALBANIAN_LETTER_YAYD = 0x00010561;
const char32_t CAUCASIAN_ALBANIAN_LETTER_PIWR = 0x00010562;
const char32_t CAUCASIAN_ALBANIAN_LETTER_KIW = 0x00010563;
const char32_t CAUCASIAN_ALBANIAN_CITATION_MARK = 0x0001056F;
const char32_t LINEAR_A_SIGN_AB001 = 0x00010600;
const char32_t LINEAR_A_SIGN_AB002 = 0x00010601;
const char32_t LINEAR_A_SIGN_AB003 = 0x00010602;
const char32_t LINEAR_A_SIGN_AB004 = 0x00010603;
const char32_t LINEAR_A_SIGN_AB005 = 0x00010604;
const char32_t LINEAR_A_SIGN_AB006 = 0x00010605;
const char32_t LINEAR_A_SIGN_AB007 = 0x00010606;
const char32_t LINEAR_A_SIGN_AB008 = 0x00010607;
const char32_t LINEAR_A_SIGN_AB009 = 0x00010608;
const char32_t LINEAR_A_SIGN_AB010 = 0x00010609;
const char32_t LINEAR_A_SIGN_AB011 = 0x0001060A;
const char32_t LINEAR_A_SIGN_AB013 = 0x0001060B;
const char32_t LINEAR_A_SIGN_AB016 = 0x0001060C;
const char32_t LINEAR_A_SIGN_AB017 = 0x0001060D;
const char32_t LINEAR_A_SIGN_AB020 = 0x0001060E;
const char32_t LINEAR_A_SIGN_AB021 = 0x0001060F;
const char32_t LINEAR_A_SIGN_AB021F = 0x00010610;
const char32_t LINEAR_A_SIGN_AB021M = 0x00010611;
const char32_t LINEAR_A_SIGN_AB022 = 0x00010612;
const char32_t LINEAR_A_SIGN_AB022F = 0x00010613;
const char32_t LINEAR_A_SIGN_AB022M = 0x00010614;
const char32_t LINEAR_A_SIGN_AB023 = 0x00010615;
const char32_t LINEAR_A_SIGN_AB023M = 0x00010616;
const char32_t LINEAR_A_SIGN_AB024 = 0x00010617;
const char32_t LINEAR_A_SIGN_AB026 = 0x00010618;
const char32_t LINEAR_A_SIGN_AB027 = 0x00010619;
const char32_t LINEAR_A_SIGN_AB028 = 0x0001061A;
const char32_t LINEAR_A_SIGN_A028B = 0x0001061B;
const char32_t LINEAR_A_SIGN_AB029 = 0x0001061C;
const char32_t LINEAR_A_SIGN_AB030 = 0x0001061D;
const char32_t LINEAR_A_SIGN_AB031 = 0x0001061E;
const char32_t LINEAR_A_SIGN_AB034 = 0x0001061F;
const char32_t LINEAR_A_SIGN_AB037 = 0x00010620;
const char32_t LINEAR_A_SIGN_AB038 = 0x00010621;
const char32_t LINEAR_A_SIGN_AB039 = 0x00010622;
const char32_t LINEAR_A_SIGN_AB040 = 0x00010623;
const char32_t LINEAR_A_SIGN_AB041 = 0x00010624;
const char32_t LINEAR_A_SIGN_AB044 = 0x00010625;
const char32_t LINEAR_A_SIGN_AB045 = 0x00010626;
const char32_t LINEAR_A_SIGN_AB046 = 0x00010627;
const char32_t LINEAR_A_SIGN_AB047 = 0x00010628;
const char32_t LINEAR_A_SIGN_AB048 = 0x00010629;
const char32_t LINEAR_A_SIGN_AB049 = 0x0001062A;
const char32_t LINEAR_A_SIGN_AB050 = 0x0001062B;
const char32_t LINEAR_A_SIGN_AB051 = 0x0001062C;
const char32_t LINEAR_A_SIGN_AB053 = 0x0001062D;
const char32_t LINEAR_A_SIGN_AB054 = 0x0001062E;
const char32_t LINEAR_A_SIGN_AB055 = 0x0001062F;
const char32_t LINEAR_A_SIGN_AB056 = 0x00010630;
const char32_t LINEAR_A_SIGN_AB057 = 0x00010631;
const char32_t LINEAR_A_SIGN_AB058 = 0x00010632;
const char32_t LINEAR_A_SIGN_AB059 = 0x00010633;
const char32_t LINEAR_A_SIGN_AB060 = 0x00010634;
const char32_t LINEAR_A_SIGN_AB061 = 0x00010635;
const char32_t LINEAR_A_SIGN_AB065 = 0x00010636;
const char32_t LINEAR_A_SIGN_AB066 = 0x00010637;
const char32_t LINEAR_A_SIGN_AB067 = 0x00010638;
const char32_t LINEAR_A_SIGN_AB069 = 0x00010639;
const char32_t LINEAR_A_SIGN_AB070 = 0x0001063A;
const char32_t LINEAR_A_SIGN_AB073 = 0x0001063B;
const char32_t LINEAR_A_SIGN_AB074 = 0x0001063C;
const char32_t LINEAR_A_SIGN_AB076 = 0x0001063D;
const char32_t LINEAR_A_SIGN_AB077 = 0x0001063E;
const char32_t LINEAR_A_SIGN_AB078 = 0x0001063F;
const char32_t LINEAR_A_SIGN_AB079 = 0x00010640;
const char32_t LINEAR_A_SIGN_AB080 = 0x00010641;
const char32_t LINEAR_A_SIGN_AB081 = 0x00010642;
const char32_t LINEAR_A_SIGN_AB082 = 0x00010643;
const char32_t LINEAR_A_SIGN_AB085 = 0x00010644;
const char32_t LINEAR_A_SIGN_AB086 = 0x00010645;
const char32_t LINEAR_A_SIGN_AB087 = 0x00010646;
const char32_t LINEAR_A_SIGN_A100_102 = 0x00010647;
const char32_t LINEAR_A_SIGN_AB118 = 0x00010648;
const char32_t LINEAR_A_SIGN_AB120 = 0x00010649;
const char32_t LINEAR_A_SIGN_A120B = 0x0001064A;
const char32_t LINEAR_A_SIGN_AB122 = 0x0001064B;
const char32_t LINEAR_A_SIGN_AB123 = 0x0001064C;
const char32_t LINEAR_A_SIGN_AB131A = 0x0001064D;
const char32_t LINEAR_A_SIGN_AB131B = 0x0001064E;
const char32_t LINEAR_A_SIGN_A131C = 0x0001064F;
const char32_t LINEAR_A_SIGN_AB164 = 0x00010650;
const char32_t LINEAR_A_SIGN_AB171 = 0x00010651;
const char32_t LINEAR_A_SIGN_AB180 = 0x00010652;
const char32_t LINEAR_A_SIGN_AB188 = 0x00010653;
const char32_t LINEAR_A_SIGN_AB191 = 0x00010654;
const char32_t LINEAR_A_SIGN_A301 = 0x00010655;
const char32_t LINEAR_A_SIGN_A302 = 0x00010656;
const char32_t LINEAR_A_SIGN_A303 = 0x00010657;
const char32_t LINEAR_A_SIGN_A304 = 0x00010658;
const char32_t LINEAR_A_SIGN_A305 = 0x00010659;
const char32_t LINEAR_A_SIGN_A306 = 0x0001065A;
const char32_t LINEAR_A_SIGN_A307 = 0x0001065B;
const char32_t LINEAR_A_SIGN_A308 = 0x0001065C;
const char32_t LINEAR_A_SIGN_A309A = 0x0001065D;
const char32_t LINEAR_A_SIGN_A309B = 0x0001065E;
const char32_t LINEAR_A_SIGN_A309C = 0x0001065F;
const char32_t LINEAR_A_SIGN_A310 = 0x00010660;
const char32_t LINEAR_A_SIGN_A311 = 0x00010661;
const char32_t LINEAR_A_SIGN_A312 = 0x00010662;
const char32_t LINEAR_A_SIGN_A313A = 0x00010663;
const char32_t LINEAR_A_SIGN_A313B = 0x00010664;
const char32_t LINEAR_A_SIGN_A313C = 0x00010665;
const char32_t LINEAR_A_SIGN_A314 = 0x00010666;
const char32_t LINEAR_A_SIGN_A315 = 0x00010667;
const char32_t LINEAR_A_SIGN_A316 = 0x00010668;
const char32_t LINEAR_A_SIGN_A317 = 0x00010669;
const char32_t LINEAR_A_SIGN_A318 = 0x0001066A;
const char32_t LINEAR_A_SIGN_A319 = 0x0001066B;
const char32_t LINEAR_A_SIGN_A320 = 0x0001066C;
const char32_t LINEAR_A_SIGN_A321 = 0x0001066D;
const char32_t LINEAR_A_SIGN_A322 = 0x0001066E;
const char32_t LINEAR_A_SIGN_A323 = 0x0001066F;
const char32_t LINEAR_A_SIGN_A324 = 0x00010670;
const char32_t LINEAR_A_SIGN_A325 = 0x00010671;
const char32_t LINEAR_A_SIGN_A326 = 0x00010672;
const char32_t LINEAR_A_SIGN_A327 = 0x00010673;
const char32_t LINEAR_A_SIGN_A328 = 0x00010674;
const char32_t LINEAR_A_SIGN_A329 = 0x00010675;
const char32_t LINEAR_A_SIGN_A330 = 0x00010676;
const char32_t LINEAR_A_SIGN_A331 = 0x00010677;
const char32_t LINEAR_A_SIGN_A332 = 0x00010678;
const char32_t LINEAR_A_SIGN_A333 = 0x00010679;
const char32_t LINEAR_A_SIGN_A334 = 0x0001067A;
const char32_t LINEAR_A_SIGN_A335 = 0x0001067B;
const char32_t LINEAR_A_SIGN_A336 = 0x0001067C;
const char32_t LINEAR_A_SIGN_A337 = 0x0001067D;
const char32_t LINEAR_A_SIGN_A338 = 0x0001067E;
const char32_t LINEAR_A_SIGN_A339 = 0x0001067F;
const char32_t LINEAR_A_SIGN_A340 = 0x00010680;
const char32_t LINEAR_A_SIGN_A341 = 0x00010681;
const char32_t LINEAR_A_SIGN_A342 = 0x00010682;
const char32_t LINEAR_A_SIGN_A343 = 0x00010683;
const char32_t LINEAR_A_SIGN_A344 = 0x00010684;
const char32_t LINEAR_A_SIGN_A345 = 0x00010685;
const char32_t LINEAR_A_SIGN_A346 = 0x00010686;
const char32_t LINEAR_A_SIGN_A347 = 0x00010687;
const char32_t LINEAR_A_SIGN_A348 = 0x00010688;
const char32_t LINEAR_A_SIGN_A349 = 0x00010689;
const char32_t LINEAR_A_SIGN_A350 = 0x0001068A;
const char32_t LINEAR_A_SIGN_A351 = 0x0001068B;
const char32_t LINEAR_A_SIGN_A352 = 0x0001068C;
const char32_t LINEAR_A_SIGN_A353 = 0x0001068D;
const char32_t LINEAR_A_SIGN_A354 = 0x0001068E;
const char32_t LINEAR_A_SIGN_A355 = 0x0001068F;
const char32_t LINEAR_A_SIGN_A356 = 0x00010690;
const char32_t LINEAR_A_SIGN_A357 = 0x00010691;
const char32_t LINEAR_A_SIGN_A358 = 0x00010692;
const char32_t LINEAR_A_SIGN_A359 = 0x00010693;
const char32_t LINEAR_A_SIGN_A360 = 0x00010694;
const char32_t LINEAR_A_SIGN_A361 = 0x00010695;
const char32_t LINEAR_A_SIGN_A362 = 0x00010696;
const char32_t LINEAR_A_SIGN_A363 = 0x00010697;
const char32_t LINEAR_A_SIGN_A364 = 0x00010698;
const char32_t LINEAR_A_SIGN_A365 = 0x00010699;
const char32_t LINEAR_A_SIGN_A366 = 0x0001069A;
const char32_t LINEAR_A_SIGN_A367 = 0x0001069B;
const char32_t LINEAR_A_SIGN_A368 = 0x0001069C;
const char32_t LINEAR_A_SIGN_A369 = 0x0001069D;
const char32_t LINEAR_A_SIGN_A370 = 0x0001069E;
const char32_t LINEAR_A_SIGN_A371 = 0x0001069F;
const char32_t LINEAR_A_SIGN_A400_VAS = 0x000106A0;
const char32_t LINEAR_A_SIGN_A401_VAS = 0x000106A1;
const char32_t LINEAR_A_SIGN_A402_VAS = 0x000106A2;
const char32_t LINEAR_A_SIGN_A403_VAS = 0x000106A3;
const char32_t LINEAR_A_SIGN_A404_VAS = 0x000106A4;
const char32_t LINEAR_A_SIGN_A405_VAS = 0x000106A5;
const char32_t LINEAR_A_SIGN_A406_VAS = 0x000106A6;
const char32_t LINEAR_A_SIGN_A407_VAS = 0x000106A7;
const char32_t LINEAR_A_SIGN_A408_VAS = 0x000106A8;
const char32_t LINEAR_A_SIGN_A409_VAS = 0x000106A9;
const char32_t LINEAR_A_SIGN_A410_VAS = 0x000106AA;
const char32_t LINEAR_A_SIGN_A411_VAS = 0x000106AB;
const char32_t LINEAR_A_SIGN_A412_VAS = 0x000106AC;
const char32_t LINEAR_A_SIGN_A413_VAS = 0x000106AD;
const char32_t LINEAR_A_SIGN_A414_VAS = 0x000106AE;
const char32_t LINEAR_A_SIGN_A415_VAS = 0x000106AF;
const char32_t LINEAR_A_SIGN_A416_VAS = 0x000106B0;
const char32_t LINEAR_A_SIGN_A417_VAS = 0x000106B1;
const char32_t LINEAR_A_SIGN_A418_VAS = 0x000106B2;
const char32_t LINEAR_A_SIGN_A501 = 0x000106B3;
const char32_t LINEAR_A_SIGN_A502 = 0x000106B4;
const char32_t LINEAR_A_SIGN_A503 = 0x000106B5;
const char32_t LINEAR_A_SIGN_A504 = 0x000106B6;
const char32_t LINEAR_A_SIGN_A505 = 0x000106B7;
const char32_t LINEAR_A_SIGN_A506 = 0x000106B8;
const char32_t LINEAR_A_SIGN_A508 = 0x000106B9;
const char32_t LINEAR_A_SIGN_A509 = 0x000106BA;
const char32_t LINEAR_A_SIGN_A510 = 0x000106BB;
const char32_t LINEAR_A_SIGN_A511 = 0x000106BC;
const char32_t LINEAR_A_SIGN_A512 = 0x000106BD;
const char32_t LINEAR_A_SIGN_A513 = 0x000106BE;
const char32_t LINEAR_A_SIGN_A515 = 0x000106BF;
const char32_t LINEAR_A_SIGN_A516 = 0x000106C0;
const char32_t LINEAR_A_SIGN_A520 = 0x000106C1;
const char32_t LINEAR_A_SIGN_A521 = 0x000106C2;
const char32_t LINEAR_A_SIGN_A523 = 0x000106C3;
const char32_t LINEAR_A_SIGN_A524 = 0x000106C4;
const char32_t LINEAR_A_SIGN_A525 = 0x000106C5;
const char32_t LINEAR_A_SIGN_A526 = 0x000106C6;
const char32_t LINEAR_A_SIGN_A527 = 0x000106C7;
const char32_t LINEAR_A_SIGN_A528 = 0x000106C8;
const char32_t LINEAR_A_SIGN_A529 = 0x000106C9;
const char32_t LINEAR_A_SIGN_A530 = 0x000106CA;
const char32_t LINEAR_A_SIGN_A531 = 0x000106CB;
const char32_t LINEAR_A_SIGN_A532 = 0x000106CC;
const char32_t LINEAR_A_SIGN_A534 = 0x000106CD;
const char32_t LINEAR_A_SIGN_A535 = 0x000106CE;
const char32_t LINEAR_A_SIGN_A536 = 0x000106CF;
const char32_t LINEAR_A_SIGN_A537 = 0x000106D0;
const char32_t LINEAR_A_SIGN_A538 = 0x000106D1;
const char32_t LINEAR_A_SIGN_A539 = 0x000106D2;
const char32_t LINEAR_A_SIGN_A540 = 0x000106D3;
const char32_t LINEAR_A_SIGN_A541 = 0x000106D4;
const char32_t LINEAR_A_SIGN_A542 = 0x000106D5;
const char32_t LINEAR_A_SIGN_A545 = 0x000106D6;
const char32_t LINEAR_A_SIGN_A547 = 0x000106D7;
const char32_t LINEAR_A_SIGN_A548 = 0x000106D8;
const char32_t LINEAR_A_SIGN_A549 = 0x000106D9;
const char32_t LINEAR_A_SIGN_A550 = 0x000106DA;
const char32_t LINEAR_A_SIGN_A551 = 0x000106DB;
const char32_t LINEAR_A_SIGN_A552 = 0x000106DC;
const char32_t LINEAR_A_SIGN_A553 = 0x000106DD;
const char32_t LINEAR_A_SIGN_A554 = 0x000106DE;
const char32_t LINEAR_A_SIGN_A555 = 0x000106DF;
const char32_t LINEAR_A_SIGN_A556 = 0x000106E0;
const char32_t LINEAR_A_SIGN_A557 = 0x000106E1;
const char32_t LINEAR_A_SIGN_A559 = 0x000106E2;
const char32_t LINEAR_A_SIGN_A563 = 0x000106E3;
const char32_t LINEAR_A_SIGN_A564 = 0x000106E4;
const char32_t LINEAR_A_SIGN_A565 = 0x000106E5;
const char32_t LINEAR_A_SIGN_A566 = 0x000106E6;
const char32_t LINEAR_A_SIGN_A568 = 0x000106E7;
const char32_t LINEAR_A_SIGN_A569 = 0x000106E8;
const char32_t LINEAR_A_SIGN_A570 = 0x000106E9;
const char32_t LINEAR_A_SIGN_A571 = 0x000106EA;
const char32_t LINEAR_A_SIGN_A572 = 0x000106EB;
const char32_t LINEAR_A_SIGN_A573 = 0x000106EC;
const char32_t LINEAR_A_SIGN_A574 = 0x000106ED;
const char32_t LINEAR_A_SIGN_A575 = 0x000106EE;
const char32_t LINEAR_A_SIGN_A576 = 0x000106EF;
const char32_t LINEAR_A_SIGN_A577 = 0x000106F0;
const char32_t LINEAR_A_SIGN_A578 = 0x000106F1;
const char32_t LINEAR_A_SIGN_A579 = 0x000106F2;
const char32_t LINEAR_A_SIGN_A580 = 0x000106F3;
const char32_t LINEAR_A_SIGN_A581 = 0x000106F4;
const char32_t LINEAR_A_SIGN_A582 = 0x000106F5;
const char32_t LINEAR_A_SIGN_A583 = 0x000106F6;
const char32_t LINEAR_A_SIGN_A584 = 0x000106F7;
const char32_t LINEAR_A_SIGN_A585 = 0x000106F8;
const char32_t LINEAR_A_SIGN_A586 = 0x000106F9;
const char32_t LINEAR_A_SIGN_A587 = 0x000106FA;
const char32_t LINEAR_A_SIGN_A588 = 0x000106FB;
const char32_t LINEAR_A_SIGN_A589 = 0x000106FC;
const char32_t LINEAR_A_SIGN_A591 = 0x000106FD;
const char32_t LINEAR_A_SIGN_A592 = 0x000106FE;
const char32_t LINEAR_A_SIGN_A594 = 0x000106FF;
const char32_t LINEAR_A_SIGN_A595 = 0x00010700;
const char32_t LINEAR_A_SIGN_A596 = 0x00010701;
const char32_t LINEAR_A_SIGN_A598 = 0x00010702;
const char32_t LINEAR_A_SIGN_A600 = 0x00010703;
const char32_t LINEAR_A_SIGN_A601 = 0x00010704;
const char32_t LINEAR_A_SIGN_A602 = 0x00010705;
const char32_t LINEAR_A_SIGN_A603 = 0x00010706;
const char32_t LINEAR_A_SIGN_A604 = 0x00010707;
const char32_t LINEAR_A_SIGN_A606 = 0x00010708;
const char32_t LINEAR_A_SIGN_A608 = 0x00010709;
const char32_t LINEAR_A_SIGN_A609 = 0x0001070A;
const char32_t LINEAR_A_SIGN_A610 = 0x0001070B;
const char32_t LINEAR_A_SIGN_A611 = 0x0001070C;
const char32_t LINEAR_A_SIGN_A612 = 0x0001070D;
const char32_t LINEAR_A_SIGN_A613 = 0x0001070E;
const char32_t LINEAR_A_SIGN_A614 = 0x0001070F;
const char32_t LINEAR_A_SIGN_A615 = 0x00010710;
const char32_t LINEAR_A_SIGN_A616 = 0x00010711;
const char32_t LINEAR_A_SIGN_A617 = 0x00010712;
const char32_t LINEAR_A_SIGN_A618 = 0x00010713;
const char32_t LINEAR_A_SIGN_A619 = 0x00010714;
const char32_t LINEAR_A_SIGN_A620 = 0x00010715;
const char32_t LINEAR_A_SIGN_A621 = 0x00010716;
const char32_t LINEAR_A_SIGN_A622 = 0x00010717;
const char32_t LINEAR_A_SIGN_A623 = 0x00010718;
const char32_t LINEAR_A_SIGN_A624 = 0x00010719;
const char32_t LINEAR_A_SIGN_A626 = 0x0001071A;
const char32_t LINEAR_A_SIGN_A627 = 0x0001071B;
const char32_t LINEAR_A_SIGN_A628 = 0x0001071C;
const char32_t LINEAR_A_SIGN_A629 = 0x0001071D;
const char32_t LINEAR_A_SIGN_A634 = 0x0001071E;
const char32_t LINEAR_A_SIGN_A637 = 0x0001071F;
const char32_t LINEAR_A_SIGN_A638 = 0x00010720;
const char32_t LINEAR_A_SIGN_A640 = 0x00010721;
const char32_t LINEAR_A_SIGN_A642 = 0x00010722;
const char32_t LINEAR_A_SIGN_A643 = 0x00010723;
const char32_t LINEAR_A_SIGN_A644 = 0x00010724;
const char32_t LINEAR_A_SIGN_A645 = 0x00010725;
const char32_t LINEAR_A_SIGN_A646 = 0x00010726;
const char32_t LINEAR_A_SIGN_A648 = 0x00010727;
const char32_t LINEAR_A_SIGN_A649 = 0x00010728;
const char32_t LINEAR_A_SIGN_A651 = 0x00010729;
const char32_t LINEAR_A_SIGN_A652 = 0x0001072A;
const char32_t LINEAR_A_SIGN_A653 = 0x0001072B;
const char32_t LINEAR_A_SIGN_A654 = 0x0001072C;
const char32_t LINEAR_A_SIGN_A655 = 0x0001072D;
const char32_t LINEAR_A_SIGN_A656 = 0x0001072E;
const char32_t LINEAR_A_SIGN_A657 = 0x0001072F;
const char32_t LINEAR_A_SIGN_A658 = 0x00010730;
const char32_t LINEAR_A_SIGN_A659 = 0x00010731;
const char32_t LINEAR_A_SIGN_A660 = 0x00010732;
const char32_t LINEAR_A_SIGN_A661 = 0x00010733;
const char32_t LINEAR_A_SIGN_A662 = 0x00010734;
const char32_t LINEAR_A_SIGN_A663 = 0x00010735;
const char32_t LINEAR_A_SIGN_A664 = 0x00010736;
const char32_t LINEAR_A_SIGN_A701_A = 0x00010740;
const char32_t LINEAR_A_SIGN_A702_B = 0x00010741;
const char32_t LINEAR_A_SIGN_A703_D = 0x00010742;
const char32_t LINEAR_A_SIGN_A704_E = 0x00010743;
const char32_t LINEAR_A_SIGN_A705_F = 0x00010744;
const char32_t LINEAR_A_SIGN_A706_H = 0x00010745;
const char32_t LINEAR_A_SIGN_A707_J = 0x00010746;
const char32_t LINEAR_A_SIGN_A708_K = 0x00010747;
const char32_t LINEAR_A_SIGN_A709_L = 0x00010748;
const char32_t LINEAR_A_SIGN_A709_2_L2 = 0x00010749;
const char32_t LINEAR_A_SIGN_A709_3_L3 = 0x0001074A;
const char32_t LINEAR_A_SIGN_A709_4_L4 = 0x0001074B;
const char32_t LINEAR_A_SIGN_A709_6_L6 = 0x0001074C;
const char32_t LINEAR_A_SIGN_A710_W = 0x0001074D;
const char32_t LINEAR_A_SIGN_A711_X = 0x0001074E;
const char32_t LINEAR_A_SIGN_A712_Y = 0x0001074F;
const char32_t LINEAR_A_SIGN_A713_OMEGA = 0x00010750;
const char32_t LINEAR_A_SIGN_A714_ABB = 0x00010751;
const char32_t LINEAR_A_SIGN_A715_BB = 0x00010752;
const char32_t LINEAR_A_SIGN_A717_DD = 0x00010753;
const char32_t LINEAR_A_SIGN_A726_EYYY = 0x00010754;
const char32_t LINEAR_A_SIGN_A732_JE = 0x00010755;
const char32_t LINEAR_A_SIGN_A800 = 0x00010760;
const char32_t LINEAR_A_SIGN_A801 = 0x00010761;
const char32_t LINEAR_A_SIGN_A802 = 0x00010762;
const char32_t LINEAR_A_SIGN_A803 = 0x00010763;
const char32_t LINEAR_A_SIGN_A804 = 0x00010764;
const char32_t LINEAR_A_SIGN_A805 = 0x00010765;
const char32_t LINEAR_A_SIGN_A806 = 0x00010766;
const char32_t LINEAR_A_SIGN_A807 = 0x00010767;
const char32_t CYPRIOT_SYLLABLE_A = 0x00010800;
const char32_t CYPRIOT_SYLLABLE_E = 0x00010801;
const char32_t CYPRIOT_SYLLABLE_I = 0x00010802;
const char32_t CYPRIOT_SYLLABLE_O = 0x00010803;
const char32_t CYPRIOT_SYLLABLE_U = 0x00010804;
const char32_t CYPRIOT_SYLLABLE_JA = 0x00010805;
const char32_t CYPRIOT_SYLLABLE_JO = 0x00010808;
const char32_t CYPRIOT_SYLLABLE_KA = 0x0001080A;
const char32_t CYPRIOT_SYLLABLE_KE = 0x0001080B;
const char32_t CYPRIOT_SYLLABLE_KI = 0x0001080C;
const char32_t CYPRIOT_SYLLABLE_KO = 0x0001080D;
const char32_t CYPRIOT_SYLLABLE_KU = 0x0001080E;
const char32_t CYPRIOT_SYLLABLE_LA = 0x0001080F;
const char32_t CYPRIOT_SYLLABLE_LE = 0x00010810;
const char32_t CYPRIOT_SYLLABLE_LI = 0x00010811;
const char32_t CYPRIOT_SYLLABLE_LO = 0x00010812;
const char32_t CYPRIOT_SYLLABLE_LU = 0x00010813;
const char32_t CYPRIOT_SYLLABLE_MA = 0x00010814;
const char32_t CYPRIOT_SYLLABLE_ME = 0x00010815;
const char32_t CYPRIOT_SYLLABLE_MI = 0x00010816;
const char32_t CYPRIOT_SYLLABLE_MO = 0x00010817;
const char32_t CYPRIOT_SYLLABLE_MU = 0x00010818;
const char32_t CYPRIOT_SYLLABLE_NA = 0x00010819;
const char32_t CYPRIOT_SYLLABLE_NE = 0x0001081A;
const char32_t CYPRIOT_SYLLABLE_NI = 0x0001081B;
const char32_t CYPRIOT_SYLLABLE_NO = 0x0001081C;
const char32_t CYPRIOT_SYLLABLE_NU = 0x0001081D;
const char32_t CYPRIOT_SYLLABLE_PA = 0x0001081E;
const char32_t CYPRIOT_SYLLABLE_PE = 0x0001081F;
const char32_t CYPRIOT_SYLLABLE_PI = 0x00010820;
const char32_t CYPRIOT_SYLLABLE_PO = 0x00010821;
const char32_t CYPRIOT_SYLLABLE_PU = 0x00010822;
const char32_t CYPRIOT_SYLLABLE_RA = 0x00010823;
const char32_t CYPRIOT_SYLLABLE_RE = 0x00010824;
const char32_t CYPRIOT_SYLLABLE_RI = 0x00010825;
const char32_t CYPRIOT_SYLLABLE_RO = 0x00010826;
const char32_t CYPRIOT_SYLLABLE_RU = 0x00010827;
const char32_t CYPRIOT_SYLLABLE_SA = 0x00010828;
const char32_t CYPRIOT_SYLLABLE_SE = 0x00010829;
const char32_t CYPRIOT_SYLLABLE_SI = 0x0001082A;
const char32_t CYPRIOT_SYLLABLE_SO = 0x0001082B;
const char32_t CYPRIOT_SYLLABLE_SU = 0x0001082C;
const char32_t CYPRIOT_SYLLABLE_TA = 0x0001082D;
const char32_t CYPRIOT_SYLLABLE_TE = 0x0001082E;
const char32_t CYPRIOT_SYLLABLE_TI = 0x0001082F;
const char32_t CYPRIOT_SYLLABLE_TO = 0x00010830;
const char32_t CYPRIOT_SYLLABLE_TU = 0x00010831;
const char32_t CYPRIOT_SYLLABLE_WA = 0x00010832;
const char32_t CYPRIOT_SYLLABLE_WE = 0x00010833;
const char32_t CYPRIOT_SYLLABLE_WI = 0x00010834;
const char32_t CYPRIOT_SYLLABLE_WO = 0x00010835;
const char32_t CYPRIOT_SYLLABLE_XA = 0x00010837;
const char32_t CYPRIOT_SYLLABLE_XE = 0x00010838;
const char32_t CYPRIOT_SYLLABLE_ZA = 0x0001083C;
const char32_t CYPRIOT_SYLLABLE_ZO = 0x0001083F;
const char32_t IMPERIAL_ARAMAIC_LETTER_ALEPH = 0x00010840;
const char32_t IMPERIAL_ARAMAIC_LETTER_BETH = 0x00010841;
const char32_t IMPERIAL_ARAMAIC_LETTER_GIMEL = 0x00010842;
const char32_t IMPERIAL_ARAMAIC_LETTER_DALETH = 0x00010843;
const char32_t IMPERIAL_ARAMAIC_LETTER_HE = 0x00010844;
const char32_t IMPERIAL_ARAMAIC_LETTER_WAW = 0x00010845;
const char32_t IMPERIAL_ARAMAIC_LETTER_ZAYIN = 0x00010846;
const char32_t IMPERIAL_ARAMAIC_LETTER_HETH = 0x00010847;
const char32_t IMPERIAL_ARAMAIC_LETTER_TETH = 0x00010848;
const char32_t IMPERIAL_ARAMAIC_LETTER_YODH = 0x00010849;
const char32_t IMPERIAL_ARAMAIC_LETTER_KAPH = 0x0001084A;
const char32_t IMPERIAL_ARAMAIC_LETTER_LAMEDH = 0x0001084B;
const char32_t IMPERIAL_ARAMAIC_LETTER_MEM = 0x0001084C;
const char32_t IMPERIAL_ARAMAIC_LETTER_NUN = 0x0001084D;
const char32_t IMPERIAL_ARAMAIC_LETTER_SAMEKH = 0x0001084E;
const char32_t IMPERIAL_ARAMAIC_LETTER_AYIN = 0x0001084F;
const char32_t IMPERIAL_ARAMAIC_LETTER_PE = 0x00010850;
const char32_t IMPERIAL_ARAMAIC_LETTER_SADHE = 0x00010851;
const char32_t IMPERIAL_ARAMAIC_LETTER_QOPH = 0x00010852;
const char32_t IMPERIAL_ARAMAIC_LETTER_RESH = 0x00010853;
const char32_t IMPERIAL_ARAMAIC_LETTER_SHIN = 0x00010854;
const char32_t IMPERIAL_ARAMAIC_LETTER_TAW = 0x00010855;
const char32_t IMPERIAL_ARAMAIC_SECTION_SIGN = 0x00010857;
const char32_t IMPERIAL_ARAMAIC_NUMBER_ONE = 0x00010858;
const char32_t IMPERIAL_ARAMAIC_NUMBER_TWO = 0x00010859;
const char32_t IMPERIAL_ARAMAIC_NUMBER_THREE = 0x0001085A;
const char32_t IMPERIAL_ARAMAIC_NUMBER_TEN = 0x0001085B;
const char32_t IMPERIAL_ARAMAIC_NUMBER_TWENTY = 0x0001085C;
const char32_t IMPERIAL_ARAMAIC_NUMBER_ONE_HUNDRED = 0x0001085D;
const char32_t IMPERIAL_ARAMAIC_NUMBER_ONE_THOUSAND = 0x0001085E;
const char32_t IMPERIAL_ARAMAIC_NUMBER_TEN_THOUSAND = 0x0001085F;
const char32_t PALMYRENE_LETTER_ALEPH = 0x00010860;
const char32_t PALMYRENE_LETTER_BETH = 0x00010861;
const char32_t PALMYRENE_LETTER_GIMEL = 0x00010862;
const char32_t PALMYRENE_LETTER_DALETH = 0x00010863;
const char32_t PALMYRENE_LETTER_HE = 0x00010864;
const char32_t PALMYRENE_LETTER_WAW = 0x00010865;
const char32_t PALMYRENE_LETTER_ZAYIN = 0x00010866;
const char32_t PALMYRENE_LETTER_HETH = 0x00010867;
const char32_t PALMYRENE_LETTER_TETH = 0x00010868;
const char32_t PALMYRENE_LETTER_YODH = 0x00010869;
const char32_t PALMYRENE_LETTER_KAPH = 0x0001086A;
const char32_t PALMYRENE_LETTER_LAMEDH = 0x0001086B;
const char32_t PALMYRENE_LETTER_MEM = 0x0001086C;
const char32_t PALMYRENE_LETTER_FINAL_NUN = 0x0001086D;
const char32_t PALMYRENE_LETTER_NUN = 0x0001086E;
const char32_t PALMYRENE_LETTER_SAMEKH = 0x0001086F;
const char32_t PALMYRENE_LETTER_AYIN = 0x00010870;
const char32_t PALMYRENE_LETTER_PE = 0x00010871;
const char32_t PALMYRENE_LETTER_SADHE = 0x00010872;
const char32_t PALMYRENE_LETTER_QOPH = 0x00010873;
const char32_t PALMYRENE_LETTER_RESH = 0x00010874;
const char32_t PALMYRENE_LETTER_SHIN = 0x00010875;
const char32_t PALMYRENE_LETTER_TAW = 0x00010876;
const char32_t PALMYRENE_LEFT_POINTING_FLEURON = 0x00010877;
const char32_t PALMYRENE_RIGHT_POINTING_FLEURON = 0x00010878;
const char32_t PALMYRENE_NUMBER_ONE = 0x00010879;
const char32_t PALMYRENE_NUMBER_TWO = 0x0001087A;
const char32_t PALMYRENE_NUMBER_THREE = 0x0001087B;
const char32_t PALMYRENE_NUMBER_FOUR = 0x0001087C;
const char32_t PALMYRENE_NUMBER_FIVE = 0x0001087D;
const char32_t PALMYRENE_NUMBER_TEN = 0x0001087E;
const char32_t PALMYRENE_NUMBER_TWENTY = 0x0001087F;
const char32_t NABATAEAN_LETTER_FINAL_ALEPH = 0x00010880;
const char32_t NABATAEAN_LETTER_ALEPH = 0x00010881;
const char32_t NABATAEAN_LETTER_FINAL_BETH = 0x00010882;
const char32_t NABATAEAN_LETTER_BETH = 0x00010883;
const char32_t NABATAEAN_LETTER_GIMEL = 0x00010884;
const char32_t NABATAEAN_LETTER_DALETH = 0x00010885;
const char32_t NABATAEAN_LETTER_FINAL_HE = 0x00010886;
const char32_t NABATAEAN_LETTER_HE = 0x00010887;
const char32_t NABATAEAN_LETTER_WAW = 0x00010888;
const char32_t NABATAEAN_LETTER_ZAYIN = 0x00010889;
const char32_t NABATAEAN_LETTER_HETH = 0x0001088A;
const char32_t NABATAEAN_LETTER_TETH = 0x0001088B;
const char32_t NABATAEAN_LETTER_FINAL_YODH = 0x0001088C;
const char32_t NABATAEAN_LETTER_YODH = 0x0001088D;
const char32_t NABATAEAN_LETTER_FINAL_KAPH = 0x0001088E;
const char32_t NABATAEAN_LETTER_KAPH = 0x0001088F;
const char32_t NABATAEAN_LETTER_FINAL_LAMEDH = 0x00010890;
const char32_t NABATAEAN_LETTER_LAMEDH = 0x00010891;
const char32_t NABATAEAN_LETTER_FINAL_MEM = 0x00010892;
const char32_t NABATAEAN_LETTER_MEM = 0x00010893;
const char32_t NABATAEAN_LETTER_FINAL_NUN = 0x00010894;
const char32_t NABATAEAN_LETTER_NUN = 0x00010895;
const char32_t NABATAEAN_LETTER_SAMEKH = 0x00010896;
const char32_t NABATAEAN_LETTER_AYIN = 0x00010897;
const char32_t NABATAEAN_LETTER_PE = 0x00010898;
const char32_t NABATAEAN_LETTER_SADHE = 0x00010899;
const char32_t NABATAEAN_LETTER_QOPH = 0x0001089A;
const char32_t NABATAEAN_LETTER_RESH = 0x0001089B;
const char32_t NABATAEAN_LETTER_FINAL_SHIN = 0x0001089C;
const char32_t NABATAEAN_LETTER_SHIN = 0x0001089D;
const char32_t NABATAEAN_LETTER_TAW = 0x0001089E;
const char32_t NABATAEAN_NUMBER_ONE = 0x000108A7;
const char32_t NABATAEAN_NUMBER_TWO = 0x000108A8;
const char32_t NABATAEAN_NUMBER_THREE = 0x000108A9;
const char32_t NABATAEAN_NUMBER_FOUR = 0x000108AA;
const char32_t NABATAEAN_CRUCIFORM_NUMBER_FOUR = 0x000108AB;
const char32_t NABATAEAN_NUMBER_FIVE = 0x000108AC;
const char32_t NABATAEAN_NUMBER_TEN = 0x000108AD;
const char32_t NABATAEAN_NUMBER_TWENTY = 0x000108AE;
const char32_t NABATAEAN_NUMBER_ONE_HUNDRED = 0x000108AF;
const char32_t HATRAN_LETTER_ALEPH = 0x000108E0;
const char32_t HATRAN_LETTER_BETH = 0x000108E1;
const char32_t HATRAN_LETTER_GIMEL = 0x000108E2;
const char32_t HATRAN_LETTER_DALETH_RESH = 0x000108E3;
const char32_t HATRAN_LETTER_HE = 0x000108E4;
const char32_t HATRAN_LETTER_WAW = 0x000108E5;
const char32_t HATRAN_LETTER_ZAYN = 0x000108E6;
const char32_t HATRAN_LETTER_HETH = 0x000108E7;
const char32_t HATRAN_LETTER_TETH = 0x000108E8;
const char32_t HATRAN_LETTER_YODH = 0x000108E9;
const char32_t HATRAN_LETTER_KAPH = 0x000108EA;
const char32_t HATRAN_LETTER_LAMEDH = 0x000108EB;
const char32_t HATRAN_LETTER_MEM = 0x000108EC;
const char32_t HATRAN_LETTER_NUN = 0x000108ED;
const char32_t HATRAN_LETTER_SAMEKH = 0x000108EE;
const char32_t HATRAN_LETTER_AYN = 0x000108EF;
const char32_t HATRAN_LETTER_PE = 0x000108F0;
const char32_t HATRAN_LETTER_SADHE = 0x000108F1;
const char32_t HATRAN_LETTER_QOPH = 0x000108F2;
const char32_t HATRAN_LETTER_SHIN = 0x000108F4;
const char32_t HATRAN_LETTER_TAW = 0x000108F5;
const char32_t HATRAN_NUMBER_ONE = 0x000108FB;
const char32_t HATRAN_NUMBER_FIVE = 0x000108FC;
const char32_t HATRAN_NUMBER_TEN = 0x000108FD;
const char32_t HATRAN_NUMBER_TWENTY = 0x000108FE;
const char32_t HATRAN_NUMBER_ONE_HUNDRED = 0x000108FF;
const char32_t PHOENICIAN_LETTER_ALF = 0x00010900;
const char32_t PHOENICIAN_LETTER_BET = 0x00010901;
const char32_t PHOENICIAN_LETTER_GAML = 0x00010902;
const char32_t PHOENICIAN_LETTER_DELT = 0x00010903;
const char32_t PHOENICIAN_LETTER_HE = 0x00010904;
const char32_t PHOENICIAN_LETTER_WAU = 0x00010905;
const char32_t PHOENICIAN_LETTER_ZAI = 0x00010906;
const char32_t PHOENICIAN_LETTER_HET = 0x00010907;
const char32_t PHOENICIAN_LETTER_TET = 0x00010908;
const char32_t PHOENICIAN_LETTER_YOD = 0x00010909;
const char32_t PHOENICIAN_LETTER_KAF = 0x0001090A;
const char32_t PHOENICIAN_LETTER_LAMD = 0x0001090B;
const char32_t PHOENICIAN_LETTER_MEM = 0x0001090C;
const char32_t PHOENICIAN_LETTER_NUN = 0x0001090D;
const char32_t PHOENICIAN_LETTER_SEMK = 0x0001090E;
const char32_t PHOENICIAN_LETTER_AIN = 0x0001090F;
const char32_t PHOENICIAN_LETTER_PE = 0x00010910;
const char32_t PHOENICIAN_LETTER_SADE = 0x00010911;
const char32_t PHOENICIAN_LETTER_QOF = 0x00010912;
const char32_t PHOENICIAN_LETTER_ROSH = 0x00010913;
const char32_t PHOENICIAN_LETTER_SHIN = 0x00010914;
const char32_t PHOENICIAN_LETTER_TAU = 0x00010915;
const char32_t PHOENICIAN_NUMBER_ONE = 0x00010916;
const char32_t PHOENICIAN_NUMBER_TEN = 0x00010917;
const char32_t PHOENICIAN_NUMBER_TWENTY = 0x00010918;
const char32_t PHOENICIAN_NUMBER_ONE_HUNDRED = 0x00010919;
const char32_t PHOENICIAN_NUMBER_TWO = 0x0001091A;
const char32_t PHOENICIAN_NUMBER_THREE = 0x0001091B;
const char32_t PHOENICIAN_WORD_SEPARATOR = 0x0001091F;
const char32_t LYDIAN_LETTER_A = 0x00010920;
const char32_t LYDIAN_LETTER_B = 0x00010921;
const char32_t LYDIAN_LETTER_G = 0x00010922;
const char32_t LYDIAN_LETTER_D = 0x00010923;
const char32_t LYDIAN_LETTER_E = 0x00010924;
const char32_t LYDIAN_LETTER_V = 0x00010925;
const char32_t LYDIAN_LETTER_I = 0x00010926;
const char32_t LYDIAN_LETTER_Y = 0x00010927;
const char32_t LYDIAN_LETTER_K = 0x00010928;
const char32_t LYDIAN_LETTER_L = 0x00010929;
const char32_t LYDIAN_LETTER_M = 0x0001092A;
const char32_t LYDIAN_LETTER_N = 0x0001092B;
const char32_t LYDIAN_LETTER_O = 0x0001092C;
const char32_t LYDIAN_LETTER_R = 0x0001092D;
const char32_t LYDIAN_LETTER_SS = 0x0001092E;
const char32_t LYDIAN_LETTER_T = 0x0001092F;
const char32_t LYDIAN_LETTER_U = 0x00010930;
const char32_t LYDIAN_LETTER_F = 0x00010931;
const char32_t LYDIAN_LETTER_Q = 0x00010932;
const char32_t LYDIAN_LETTER_S = 0x00010933;
const char32_t LYDIAN_LETTER_TT = 0x00010934;
const char32_t LYDIAN_LETTER_AN = 0x00010935;
const char32_t LYDIAN_LETTER_EN = 0x00010936;
const char32_t LYDIAN_LETTER_LY = 0x00010937;
const char32_t LYDIAN_LETTER_NN = 0x00010938;
const char32_t LYDIAN_LETTER_C = 0x00010939;
const char32_t LYDIAN_TRIANGULAR_MARK = 0x0001093F;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_A = 0x00010980;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_E = 0x00010981;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_I = 0x00010982;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_O = 0x00010983;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_YA = 0x00010984;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_WA = 0x00010985;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_BA = 0x00010986;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_BA_2 = 0x00010987;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_PA = 0x00010988;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_MA = 0x00010989;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_NA = 0x0001098A;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_NA_2 = 0x0001098B;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_NE = 0x0001098C;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_NE_2 = 0x0001098D;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_RA = 0x0001098E;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_RA_2 = 0x0001098F;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_LA = 0x00010990;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_KHA = 0x00010991;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_HHA = 0x00010992;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_SA = 0x00010993;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_SA_2 = 0x00010994;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_SE = 0x00010995;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_KA = 0x00010996;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_QA = 0x00010997;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_TA = 0x00010998;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_TA_2 = 0x00010999;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_TE = 0x0001099A;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_TE_2 = 0x0001099B;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_TO = 0x0001099C;
const char32_t MEROITIC_HIEROGLYPHIC_LETTER_DA = 0x0001099D;
const char32_t MEROITIC_HIEROGLYPHIC_SYMBOL_VIDJ = 0x0001099E;
const char32_t MEROITIC_HIEROGLYPHIC_SYMBOL_VIDJ_2 = 0x0001099F;
const char32_t MEROITIC_CURSIVE_LETTER_A = 0x000109A0;
const char32_t MEROITIC_CURSIVE_LETTER_E = 0x000109A1;
const char32_t MEROITIC_CURSIVE_LETTER_I = 0x000109A2;
const char32_t MEROITIC_CURSIVE_LETTER_O = 0x000109A3;
const char32_t MEROITIC_CURSIVE_LETTER_YA = 0x000109A4;
const char32_t MEROITIC_CURSIVE_LETTER_WA = 0x000109A5;
const char32_t MEROITIC_CURSIVE_LETTER_BA = 0x000109A6;
const char32_t MEROITIC_CURSIVE_LETTER_PA = 0x000109A7;
const char32_t MEROITIC_CURSIVE_LETTER_MA = 0x000109A8;
const char32_t MEROITIC_CURSIVE_LETTER_NA = 0x000109A9;
const char32_t MEROITIC_CURSIVE_LETTER_NE = 0x000109AA;
const char32_t MEROITIC_CURSIVE_LETTER_RA = 0x000109AB;
const char32_t MEROITIC_CURSIVE_LETTER_LA = 0x000109AC;
const char32_t MEROITIC_CURSIVE_LETTER_KHA = 0x000109AD;
const char32_t MEROITIC_CURSIVE_LETTER_HHA = 0x000109AE;
const char32_t MEROITIC_CURSIVE_LETTER_SA = 0x000109AF;
const char32_t MEROITIC_CURSIVE_LETTER_ARCHAIC_SA = 0x000109B0;
const char32_t MEROITIC_CURSIVE_LETTER_SE = 0x000109B1;
const char32_t MEROITIC_CURSIVE_LETTER_KA = 0x000109B2;
const char32_t MEROITIC_CURSIVE_LETTER_QA = 0x000109B3;
const char32_t MEROITIC_CURSIVE_LETTER_TA = 0x000109B4;
const char32_t MEROITIC_CURSIVE_LETTER_TE = 0x000109B5;
const char32_t MEROITIC_CURSIVE_LETTER_TO = 0x000109B6;
const char32_t MEROITIC_CURSIVE_LETTER_DA = 0x000109B7;
const char32_t MEROITIC_CURSIVE_FRACTION_ELEVEN_TWELFTHS = 0x000109BC;
const char32_t MEROITIC_CURSIVE_FRACTION_ONE_HALF = 0x000109BD;
const char32_t MEROITIC_CURSIVE_LOGOGRAM_RMT = 0x000109BE;
const char32_t MEROITIC_CURSIVE_LOGOGRAM_IMN = 0x000109BF;
const char32_t MEROITIC_CURSIVE_NUMBER_ONE = 0x000109C0;
const char32_t MEROITIC_CURSIVE_NUMBER_TWO = 0x000109C1;
const char32_t MEROITIC_CURSIVE_NUMBER_THREE = 0x000109C2;
const char32_t MEROITIC_CURSIVE_NUMBER_FOUR = 0x000109C3;
const char32_t MEROITIC_CURSIVE_NUMBER_FIVE = 0x000109C4;
const char32_t MEROITIC_CURSIVE_NUMBER_SIX = 0x000109C5;
const char32_t MEROITIC_CURSIVE_NUMBER_SEVEN = 0x000109C6;
const char32_t MEROITIC_CURSIVE_NUMBER_EIGHT = 0x000109C7;
const char32_t MEROITIC_CURSIVE_NUMBER_NINE = 0x000109C8;
const char32_t MEROITIC_CURSIVE_NUMBER_TEN = 0x000109C9;
const char32_t MEROITIC_CURSIVE_NUMBER_TWENTY = 0x000109CA;
const char32_t MEROITIC_CURSIVE_NUMBER_THIRTY = 0x000109CB;
const char32_t MEROITIC_CURSIVE_NUMBER_FORTY = 0x000109CC;
const char32_t MEROITIC_CURSIVE_NUMBER_FIFTY = 0x000109CD;
const char32_t MEROITIC_CURSIVE_NUMBER_SIXTY = 0x000109CE;
const char32_t MEROITIC_CURSIVE_NUMBER_SEVENTY = 0x000109CF;
const char32_t MEROITIC_CURSIVE_NUMBER_ONE_HUNDRED = 0x000109D2;
const char32_t MEROITIC_CURSIVE_NUMBER_TWO_HUNDRED = 0x000109D3;
const char32_t MEROITIC_CURSIVE_NUMBER_THREE_HUNDRED = 0x000109D4;
const char32_t MEROITIC_CURSIVE_NUMBER_FOUR_HUNDRED = 0x000109D5;
const char32_t MEROITIC_CURSIVE_NUMBER_FIVE_HUNDRED = 0x000109D6;
const char32_t MEROITIC_CURSIVE_NUMBER_SIX_HUNDRED = 0x000109D7;
const char32_t MEROITIC_CURSIVE_NUMBER_SEVEN_HUNDRED = 0x000109D8;
const char32_t MEROITIC_CURSIVE_NUMBER_EIGHT_HUNDRED = 0x000109D9;
const char32_t MEROITIC_CURSIVE_NUMBER_NINE_HUNDRED = 0x000109DA;
const char32_t MEROITIC_CURSIVE_NUMBER_ONE_THOUSAND = 0x000109DB;
const char32_t MEROITIC_CURSIVE_NUMBER_TWO_THOUSAND = 0x000109DC;
const char32_t MEROITIC_CURSIVE_NUMBER_THREE_THOUSAND = 0x000109DD;
const char32_t MEROITIC_CURSIVE_NUMBER_FOUR_THOUSAND = 0x000109DE;
const char32_t MEROITIC_CURSIVE_NUMBER_FIVE_THOUSAND = 0x000109DF;
const char32_t MEROITIC_CURSIVE_NUMBER_SIX_THOUSAND = 0x000109E0;
const char32_t MEROITIC_CURSIVE_NUMBER_SEVEN_THOUSAND = 0x000109E1;
const char32_t MEROITIC_CURSIVE_NUMBER_EIGHT_THOUSAND = 0x000109E2;
const char32_t MEROITIC_CURSIVE_NUMBER_NINE_THOUSAND = 0x000109E3;
const char32_t MEROITIC_CURSIVE_NUMBER_TEN_THOUSAND = 0x000109E4;
const char32_t MEROITIC_CURSIVE_NUMBER_TWENTY_THOUSAND = 0x000109E5;
const char32_t MEROITIC_CURSIVE_NUMBER_THIRTY_THOUSAND = 0x000109E6;
const char32_t MEROITIC_CURSIVE_NUMBER_FORTY_THOUSAND = 0x000109E7;
const char32_t MEROITIC_CURSIVE_NUMBER_FIFTY_THOUSAND = 0x000109E8;
const char32_t MEROITIC_CURSIVE_NUMBER_SIXTY_THOUSAND = 0x000109E9;
const char32_t MEROITIC_CURSIVE_NUMBER_SEVENTY_THOUSAND = 0x000109EA;
const char32_t MEROITIC_CURSIVE_NUMBER_EIGHTY_THOUSAND = 0x000109EB;
const char32_t MEROITIC_CURSIVE_NUMBER_NINETY_THOUSAND = 0x000109EC;
const char32_t MEROITIC_CURSIVE_NUMBER_ONE_HUNDRED_THOUSAND = 0x000109ED;
const char32_t MEROITIC_CURSIVE_NUMBER_TWO_HUNDRED_THOUSAND = 0x000109EE;
const char32_t MEROITIC_CURSIVE_NUMBER_THREE_HUNDRED_THOUSAND = 0x000109EF;
const char32_t MEROITIC_CURSIVE_NUMBER_FOUR_HUNDRED_THOUSAND = 0x000109F0;
const char32_t MEROITIC_CURSIVE_NUMBER_FIVE_HUNDRED_THOUSAND = 0x000109F1;
const char32_t MEROITIC_CURSIVE_NUMBER_SIX_HUNDRED_THOUSAND = 0x000109F2;
const char32_t MEROITIC_CURSIVE_NUMBER_SEVEN_HUNDRED_THOUSAND = 0x000109F3;
const char32_t MEROITIC_CURSIVE_NUMBER_EIGHT_HUNDRED_THOUSAND = 0x000109F4;
const char32_t MEROITIC_CURSIVE_NUMBER_NINE_HUNDRED_THOUSAND = 0x000109F5;
const char32_t MEROITIC_CURSIVE_FRACTION_ONE_TWELFTH = 0x000109F6;
const char32_t MEROITIC_CURSIVE_FRACTION_TWO_TWELFTHS = 0x000109F7;
const char32_t MEROITIC_CURSIVE_FRACTION_THREE_TWELFTHS = 0x000109F8;
const char32_t MEROITIC_CURSIVE_FRACTION_FOUR_TWELFTHS = 0x000109F9;
const char32_t MEROITIC_CURSIVE_FRACTION_FIVE_TWELFTHS = 0x000109FA;
const char32_t MEROITIC_CURSIVE_FRACTION_SIX_TWELFTHS = 0x000109FB;
const char32_t MEROITIC_CURSIVE_FRACTION_SEVEN_TWELFTHS = 0x000109FC;
const char32_t MEROITIC_CURSIVE_FRACTION_EIGHT_TWELFTHS = 0x000109FD;
const char32_t MEROITIC_CURSIVE_FRACTION_NINE_TWELFTHS = 0x000109FE;
const char32_t MEROITIC_CURSIVE_FRACTION_TEN_TWELFTHS = 0x000109FF;
const char32_t KHAROSHTHI_LETTER_A = 0x00010A00;
const char32_t KHAROSHTHI_VOWEL_SIGN_I = 0x00010A01;
const char32_t KHAROSHTHI_VOWEL_SIGN_U = 0x00010A02;
const char32_t KHAROSHTHI_VOWEL_SIGN_VOCALIC_R = 0x00010A03;
const char32_t KHAROSHTHI_VOWEL_SIGN_E = 0x00010A05;
const char32_t KHAROSHTHI_VOWEL_SIGN_O = 0x00010A06;
const char32_t KHAROSHTHI_VOWEL_LENGTH_MARK = 0x00010A0C;
const char32_t KHAROSHTHI_SIGN_DOUBLE_RING_BELOW = 0x00010A0D;
const char32_t KHAROSHTHI_SIGN_ANUSVARA = 0x00010A0E;
const char32_t KHAROSHTHI_SIGN_VISARGA = 0x00010A0F;
const char32_t KHAROSHTHI_LETTER_KA = 0x00010A10;
const char32_t KHAROSHTHI_LETTER_KHA = 0x00010A11;
const char32_t KHAROSHTHI_LETTER_GA = 0x00010A12;
const char32_t KHAROSHTHI_LETTER_GHA = 0x00010A13;
const char32_t KHAROSHTHI_LETTER_CA = 0x00010A15;
const char32_t KHAROSHTHI_LETTER_CHA = 0x00010A16;
const char32_t KHAROSHTHI_LETTER_JA = 0x00010A17;
const char32_t KHAROSHTHI_LETTER_NYA = 0x00010A19;
const char32_t KHAROSHTHI_LETTER_TTA = 0x00010A1A;
const char32_t KHAROSHTHI_LETTER_TTHA = 0x00010A1B;
const char32_t KHAROSHTHI_LETTER_DDA = 0x00010A1C;
const char32_t KHAROSHTHI_LETTER_DDHA = 0x00010A1D;
const char32_t KHAROSHTHI_LETTER_NNA = 0x00010A1E;
const char32_t KHAROSHTHI_LETTER_TA = 0x00010A1F;
const char32_t KHAROSHTHI_LETTER_THA = 0x00010A20;
const char32_t KHAROSHTHI_LETTER_DA = 0x00010A21;
const char32_t KHAROSHTHI_LETTER_DHA = 0x00010A22;
const char32_t KHAROSHTHI_LETTER_NA = 0x00010A23;
const char32_t KHAROSHTHI_LETTER_PA = 0x00010A24;
const char32_t KHAROSHTHI_LETTER_PHA = 0x00010A25;
const char32_t KHAROSHTHI_LETTER_BA = 0x00010A26;
const char32_t KHAROSHTHI_LETTER_BHA = 0x00010A27;
const char32_t KHAROSHTHI_LETTER_MA = 0x00010A28;
const char32_t KHAROSHTHI_LETTER_YA = 0x00010A29;
const char32_t KHAROSHTHI_LETTER_RA = 0x00010A2A;
const char32_t KHAROSHTHI_LETTER_LA = 0x00010A2B;
const char32_t KHAROSHTHI_LETTER_VA = 0x00010A2C;
const char32_t KHAROSHTHI_LETTER_SHA = 0x00010A2D;
const char32_t KHAROSHTHI_LETTER_SSA = 0x00010A2E;
const char32_t KHAROSHTHI_LETTER_SA = 0x00010A2F;
const char32_t KHAROSHTHI_LETTER_ZA = 0x00010A30;
const char32_t KHAROSHTHI_LETTER_HA = 0x00010A31;
const char32_t KHAROSHTHI_LETTER_KKA = 0x00010A32;
const char32_t KHAROSHTHI_LETTER_TTTHA = 0x00010A33;
const char32_t KHAROSHTHI_LETTER_TTTA = 0x00010A34;
const char32_t KHAROSHTHI_LETTER_VHA = 0x00010A35;
const char32_t KHAROSHTHI_SIGN_BAR_ABOVE = 0x00010A38;
const char32_t KHAROSHTHI_SIGN_CAUDA = 0x00010A39;
const char32_t KHAROSHTHI_SIGN_DOT_BELOW = 0x00010A3A;
const char32_t KHAROSHTHI_VIRAMA = 0x00010A3F;
const char32_t KHAROSHTHI_DIGIT_ONE = 0x00010A40;
const char32_t KHAROSHTHI_DIGIT_TWO = 0x00010A41;
const char32_t KHAROSHTHI_DIGIT_THREE = 0x00010A42;
const char32_t KHAROSHTHI_DIGIT_FOUR = 0x00010A43;
const char32_t KHAROSHTHI_NUMBER_TEN = 0x00010A44;
const char32_t KHAROSHTHI_NUMBER_TWENTY = 0x00010A45;
const char32_t KHAROSHTHI_NUMBER_ONE_HUNDRED = 0x00010A46;
const char32_t KHAROSHTHI_NUMBER_ONE_THOUSAND = 0x00010A47;
const char32_t KHAROSHTHI_FRACTION_ONE_HALF = 0x00010A48;
const char32_t KHAROSHTHI_PUNCTUATION_DOT = 0x00010A50;
const char32_t KHAROSHTHI_PUNCTUATION_SMALL_CIRCLE = 0x00010A51;
const char32_t KHAROSHTHI_PUNCTUATION_CIRCLE = 0x00010A52;
const char32_t KHAROSHTHI_PUNCTUATION_CRESCENT_BAR = 0x00010A53;
const char32_t KHAROSHTHI_PUNCTUATION_MANGALAM = 0x00010A54;
const char32_t KHAROSHTHI_PUNCTUATION_LOTUS = 0x00010A55;
const char32_t KHAROSHTHI_PUNCTUATION_DANDA = 0x00010A56;
const char32_t KHAROSHTHI_PUNCTUATION_DOUBLE_DANDA = 0x00010A57;
const char32_t KHAROSHTHI_PUNCTUATION_LINES = 0x00010A58;
const char32_t OLD_SOUTH_ARABIAN_LETTER_HE = 0x00010A60;
const char32_t OLD_SOUTH_ARABIAN_LETTER_LAMEDH = 0x00010A61;
const char32_t OLD_SOUTH_ARABIAN_LETTER_HETH = 0x00010A62;
const char32_t OLD_SOUTH_ARABIAN_LETTER_MEM = 0x00010A63;
const char32_t OLD_SOUTH_ARABIAN_LETTER_QOPH = 0x00010A64;
const char32_t OLD_SOUTH_ARABIAN_LETTER_WAW = 0x00010A65;
const char32_t OLD_SOUTH_ARABIAN_LETTER_SHIN = 0x00010A66;
const char32_t OLD_SOUTH_ARABIAN_LETTER_RESH = 0x00010A67;
const char32_t OLD_SOUTH_ARABIAN_LETTER_BETH = 0x00010A68;
const char32_t OLD_SOUTH_ARABIAN_LETTER_TAW = 0x00010A69;
const char32_t OLD_SOUTH_ARABIAN_LETTER_SAT = 0x00010A6A;
const char32_t OLD_SOUTH_ARABIAN_LETTER_KAPH = 0x00010A6B;
const char32_t OLD_SOUTH_ARABIAN_LETTER_NUN = 0x00010A6C;
const char32_t OLD_SOUTH_ARABIAN_LETTER_KHETH = 0x00010A6D;
const char32_t OLD_SOUTH_ARABIAN_LETTER_SADHE = 0x00010A6E;
const char32_t OLD_SOUTH_ARABIAN_LETTER_SAMEKH = 0x00010A6F;
const char32_t OLD_SOUTH_ARABIAN_LETTER_FE = 0x00010A70;
const char32_t OLD_SOUTH_ARABIAN_LETTER_ALEF = 0x00010A71;
const char32_t OLD_SOUTH_ARABIAN_LETTER_AYN = 0x00010A72;
const char32_t OLD_SOUTH_ARABIAN_LETTER_DHADHE = 0x00010A73;
const char32_t OLD_SOUTH_ARABIAN_LETTER_GIMEL = 0x00010A74;
const char32_t OLD_SOUTH_ARABIAN_LETTER_DALETH = 0x00010A75;
const char32_t OLD_SOUTH_ARABIAN_LETTER_GHAYN = 0x00010A76;
const char32_t OLD_SOUTH_ARABIAN_LETTER_TETH = 0x00010A77;
const char32_t OLD_SOUTH_ARABIAN_LETTER_ZAYN = 0x00010A78;
const char32_t OLD_SOUTH_ARABIAN_LETTER_DHALETH = 0x00010A79;
const char32_t OLD_SOUTH_ARABIAN_LETTER_YODH = 0x00010A7A;
const char32_t OLD_SOUTH_ARABIAN_LETTER_THAW = 0x00010A7B;
const char32_t OLD_SOUTH_ARABIAN_LETTER_THETH = 0x00010A7C;
const char32_t OLD_SOUTH_ARABIAN_NUMBER_ONE = 0x00010A7D;
const char32_t OLD_SOUTH_ARABIAN_NUMBER_FIFTY = 0x00010A7E;
const char32_t OLD_SOUTH_ARABIAN_NUMERIC_INDICATOR = 0x00010A7F;
const char32_t OLD_NORTH_ARABIAN_LETTER_HEH = 0x00010A80;
const char32_t OLD_NORTH_ARABIAN_LETTER_LAM = 0x00010A81;
const char32_t OLD_NORTH_ARABIAN_LETTER_HAH = 0x00010A82;
const char32_t OLD_NORTH_ARABIAN_LETTER_MEEM = 0x00010A83;
const char32_t OLD_NORTH_ARABIAN_LETTER_QAF = 0x00010A84;
const char32_t OLD_NORTH_ARABIAN_LETTER_WAW = 0x00010A85;
const char32_t OLD_NORTH_ARABIAN_LETTER_ES_2 = 0x00010A86;
const char32_t OLD_NORTH_ARABIAN_LETTER_REH = 0x00010A87;
const char32_t OLD_NORTH_ARABIAN_LETTER_BEH = 0x00010A88;
const char32_t OLD_NORTH_ARABIAN_LETTER_TEH = 0x00010A89;
const char32_t OLD_NORTH_ARABIAN_LETTER_ES_1 = 0x00010A8A;
const char32_t OLD_NORTH_ARABIAN_LETTER_KAF = 0x00010A8B;
const char32_t OLD_NORTH_ARABIAN_LETTER_NOON = 0x00010A8C;
const char32_t OLD_NORTH_ARABIAN_LETTER_KHAH = 0x00010A8D;
const char32_t OLD_NORTH_ARABIAN_LETTER_SAD = 0x00010A8E;
const char32_t OLD_NORTH_ARABIAN_LETTER_ES_3 = 0x00010A8F;
const char32_t OLD_NORTH_ARABIAN_LETTER_FEH = 0x00010A90;
const char32_t OLD_NORTH_ARABIAN_LETTER_ALEF = 0x00010A91;
const char32_t OLD_NORTH_ARABIAN_LETTER_AIN = 0x00010A92;
const char32_t OLD_NORTH_ARABIAN_LETTER_DAD = 0x00010A93;
const char32_t OLD_NORTH_ARABIAN_LETTER_GEEM = 0x00010A94;
const char32_t OLD_NORTH_ARABIAN_LETTER_DAL = 0x00010A95;
const char32_t OLD_NORTH_ARABIAN_LETTER_GHAIN = 0x00010A96;
const char32_t OLD_NORTH_ARABIAN_LETTER_TAH = 0x00010A97;
const char32_t OLD_NORTH_ARABIAN_LETTER_ZAIN = 0x00010A98;
const char32_t OLD_NORTH_ARABIAN_LETTER_THAL = 0x00010A99;
const char32_t OLD_NORTH_ARABIAN_LETTER_YEH = 0x00010A9A;
const char32_t OLD_NORTH_ARABIAN_LETTER_THEH = 0x00010A9B;
const char32_t OLD_NORTH_ARABIAN_LETTER_ZAH = 0x00010A9C;
const char32_t OLD_NORTH_ARABIAN_NUMBER_ONE = 0x00010A9D;
const char32_t OLD_NORTH_ARABIAN_NUMBER_TEN = 0x00010A9E;
const char32_t OLD_NORTH_ARABIAN_NUMBER_TWENTY = 0x00010A9F;
const char32_t MANICHAEAN_LETTER_ALEPH = 0x00010AC0;
const char32_t MANICHAEAN_LETTER_BETH = 0x00010AC1;
const char32_t MANICHAEAN_LETTER_BHETH = 0x00010AC2;
const char32_t MANICHAEAN_LETTER_GIMEL = 0x00010AC3;
const char32_t MANICHAEAN_LETTER_GHIMEL = 0x00010AC4;
const char32_t MANICHAEAN_LETTER_DALETH = 0x00010AC5;
const char32_t MANICHAEAN_LETTER_HE = 0x00010AC6;
const char32_t MANICHAEAN_LETTER_WAW = 0x00010AC7;
const char32_t MANICHAEAN_SIGN_UD = 0x00010AC8;
const char32_t MANICHAEAN_LETTER_ZAYIN = 0x00010AC9;
const char32_t MANICHAEAN_LETTER_ZHAYIN = 0x00010ACA;
const char32_t MANICHAEAN_LETTER_JAYIN = 0x00010ACB;
const char32_t MANICHAEAN_LETTER_JHAYIN = 0x00010ACC;
const char32_t MANICHAEAN_LETTER_HETH = 0x00010ACD;
const char32_t MANICHAEAN_LETTER_TETH = 0x00010ACE;
const char32_t MANICHAEAN_LETTER_YODH = 0x00010ACF;
const char32_t MANICHAEAN_LETTER_KAPH = 0x00010AD0;
const char32_t MANICHAEAN_LETTER_XAPH = 0x00010AD1;
const char32_t MANICHAEAN_LETTER_KHAPH = 0x00010AD2;
const char32_t MANICHAEAN_LETTER_LAMEDH = 0x00010AD3;
const char32_t MANICHAEAN_LETTER_DHAMEDH = 0x00010AD4;
const char32_t MANICHAEAN_LETTER_THAMEDH = 0x00010AD5;
const char32_t MANICHAEAN_LETTER_MEM = 0x00010AD6;
const char32_t MANICHAEAN_LETTER_NUN = 0x00010AD7;
const char32_t MANICHAEAN_LETTER_SAMEKH = 0x00010AD8;
const char32_t MANICHAEAN_LETTER_AYIN = 0x00010AD9;
const char32_t MANICHAEAN_LETTER_AAYIN = 0x00010ADA;
const char32_t MANICHAEAN_LETTER_PE = 0x00010ADB;
const char32_t MANICHAEAN_LETTER_FE = 0x00010ADC;
const char32_t MANICHAEAN_LETTER_SADHE = 0x00010ADD;
const char32_t MANICHAEAN_LETTER_QOPH = 0x00010ADE;
const char32_t MANICHAEAN_LETTER_XOPH = 0x00010ADF;
const char32_t MANICHAEAN_LETTER_QHOPH = 0x00010AE0;
const char32_t MANICHAEAN_LETTER_RESH = 0x00010AE1;
const char32_t MANICHAEAN_LETTER_SHIN = 0x00010AE2;
const char32_t MANICHAEAN_LETTER_SSHIN = 0x00010AE3;
const char32_t MANICHAEAN_LETTER_TAW = 0x00010AE4;
const char32_t MANICHAEAN_ABBREVIATION_MARK_ABOVE = 0x00010AE5;
const char32_t MANICHAEAN_ABBREVIATION_MARK_BELOW = 0x00010AE6;
const char32_t MANICHAEAN_NUMBER_ONE = 0x00010AEB;
const char32_t MANICHAEAN_NUMBER_FIVE = 0x00010AEC;
const char32_t MANICHAEAN_NUMBER_TEN = 0x00010AED;
const char32_t MANICHAEAN_NUMBER_TWENTY = 0x00010AEE;
const char32_t MANICHAEAN_NUMBER_ONE_HUNDRED = 0x00010AEF;
const char32_t MANICHAEAN_PUNCTUATION_STAR = 0x00010AF0;
const char32_t MANICHAEAN_PUNCTUATION_FLEURON = 0x00010AF1;
const char32_t MANICHAEAN_PUNCTUATION_DOUBLE_DOT_WITHIN_DOT = 0x00010AF2;
const char32_t MANICHAEAN_PUNCTUATION_DOT_WITHIN_DOT = 0x00010AF3;
const char32_t MANICHAEAN_PUNCTUATION_DOT = 0x00010AF4;
const char32_t MANICHAEAN_PUNCTUATION_TWO_DOTS = 0x00010AF5;
const char32_t MANICHAEAN_PUNCTUATION_LINE_FILLER = 0x00010AF6;
const char32_t AVESTAN_LETTER_A = 0x00010B00;
const char32_t AVESTAN_LETTER_AA = 0x00010B01;
const char32_t AVESTAN_LETTER_AO = 0x00010B02;
const char32_t AVESTAN_LETTER_AAO = 0x00010B03;
const char32_t AVESTAN_LETTER_AN = 0x00010B04;
const char32_t AVESTAN_LETTER_AAN = 0x00010B05;
const char32_t AVESTAN_LETTER_AE = 0x00010B06;
const char32_t AVESTAN_LETTER_AEE = 0x00010B07;
const char32_t AVESTAN_LETTER_E = 0x00010B08;
const char32_t AVESTAN_LETTER_EE = 0x00010B09;
const char32_t AVESTAN_LETTER_O = 0x00010B0A;
const char32_t AVESTAN_LETTER_OO = 0x00010B0B;
const char32_t AVESTAN_LETTER_I = 0x00010B0C;
const char32_t AVESTAN_LETTER_II = 0x00010B0D;
const char32_t AVESTAN_LETTER_U = 0x00010B0E;
const char32_t AVESTAN_LETTER_UU = 0x00010B0F;
const char32_t AVESTAN_LETTER_KE = 0x00010B10;
const char32_t AVESTAN_LETTER_XE = 0x00010B11;
const char32_t AVESTAN_LETTER_XYE = 0x00010B12;
const char32_t AVESTAN_LETTER_XVE = 0x00010B13;
const char32_t AVESTAN_LETTER_GE = 0x00010B14;
const char32_t AVESTAN_LETTER_GGE = 0x00010B15;
const char32_t AVESTAN_LETTER_GHE = 0x00010B16;
const char32_t AVESTAN_LETTER_CE = 0x00010B17;
const char32_t AVESTAN_LETTER_JE = 0x00010B18;
const char32_t AVESTAN_LETTER_TE = 0x00010B19;
const char32_t AVESTAN_LETTER_THE = 0x00010B1A;
const char32_t AVESTAN_LETTER_DE = 0x00010B1B;
const char32_t AVESTAN_LETTER_DHE = 0x00010B1C;
const char32_t AVESTAN_LETTER_TTE = 0x00010B1D;
const char32_t AVESTAN_LETTER_PE = 0x00010B1E;
const char32_t AVESTAN_LETTER_FE = 0x00010B1F;
const char32_t AVESTAN_LETTER_BE = 0x00010B20;
const char32_t AVESTAN_LETTER_BHE = 0x00010B21;
const char32_t AVESTAN_LETTER_NGE = 0x00010B22;
const char32_t AVESTAN_LETTER_NGYE = 0x00010B23;
const char32_t AVESTAN_LETTER_NGVE = 0x00010B24;
const char32_t AVESTAN_LETTER_NE = 0x00010B25;
const char32_t AVESTAN_LETTER_NYE = 0x00010B26;
const char32_t AVESTAN_LETTER_NNE = 0x00010B27;
const char32_t AVESTAN_LETTER_ME = 0x00010B28;
const char32_t AVESTAN_LETTER_HME = 0x00010B29;
const char32_t AVESTAN_LETTER_YYE = 0x00010B2A;
const char32_t AVESTAN_LETTER_YE = 0x00010B2B;
const char32_t AVESTAN_LETTER_VE = 0x00010B2C;
const char32_t AVESTAN_LETTER_RE = 0x00010B2D;
const char32_t AVESTAN_LETTER_LE = 0x00010B2E;
const char32_t AVESTAN_LETTER_SE = 0x00010B2F;
const char32_t AVESTAN_LETTER_ZE = 0x00010B30;
const char32_t AVESTAN_LETTER_SHE = 0x00010B31;
const char32_t AVESTAN_LETTER_ZHE = 0x00010B32;
const char32_t AVESTAN_LETTER_SHYE = 0x00010B33;
const char32_t AVESTAN_LETTER_SSHE = 0x00010B34;
const char32_t AVESTAN_LETTER_HE = 0x00010B35;
const char32_t AVESTAN_ABBREVIATION_MARK = 0x00010B39;
const char32_t TINY_TWO_DOTS_OVER_ONE_DOT_PUNCTUATION = 0x00010B3A;
const char32_t SMALL_TWO_DOTS_OVER_ONE_DOT_PUNCTUATION = 0x00010B3B;
const char32_t LARGE_TWO_DOTS_OVER_ONE_DOT_PUNCTUATION = 0x00010B3C;
const char32_t LARGE_ONE_DOT_OVER_TWO_DOTS_PUNCTUATION = 0x00010B3D;
const char32_t LARGE_TWO_RINGS_OVER_ONE_RING_PUNCTUATION = 0x00010B3E;
const char32_t LARGE_ONE_RING_OVER_TWO_RINGS_PUNCTUATION = 0x00010B3F;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_ALEPH = 0x00010B40;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_BETH = 0x00010B41;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_GIMEL = 0x00010B42;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_DALETH = 0x00010B43;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_HE = 0x00010B44;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_WAW = 0x00010B45;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_ZAYIN = 0x00010B46;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_HETH = 0x00010B47;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_TETH = 0x00010B48;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_YODH = 0x00010B49;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_KAPH = 0x00010B4A;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_LAMEDH = 0x00010B4B;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_MEM = 0x00010B4C;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_NUN = 0x00010B4D;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_SAMEKH = 0x00010B4E;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_AYIN = 0x00010B4F;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_PE = 0x00010B50;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_SADHE = 0x00010B51;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_QOPH = 0x00010B52;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_RESH = 0x00010B53;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_SHIN = 0x00010B54;
const char32_t INSCRIPTIONAL_PARTHIAN_LETTER_TAW = 0x00010B55;
const char32_t INSCRIPTIONAL_PARTHIAN_NUMBER_ONE = 0x00010B58;
const char32_t INSCRIPTIONAL_PARTHIAN_NUMBER_TWO = 0x00010B59;
const char32_t INSCRIPTIONAL_PARTHIAN_NUMBER_THREE = 0x00010B5A;
const char32_t INSCRIPTIONAL_PARTHIAN_NUMBER_FOUR = 0x00010B5B;
const char32_t INSCRIPTIONAL_PARTHIAN_NUMBER_TEN = 0x00010B5C;
const char32_t INSCRIPTIONAL_PARTHIAN_NUMBER_TWENTY = 0x00010B5D;
const char32_t INSCRIPTIONAL_PARTHIAN_NUMBER_ONE_HUNDRED = 0x00010B5E;
const char32_t INSCRIPTIONAL_PARTHIAN_NUMBER_ONE_THOUSAND = 0x00010B5F;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_ALEPH = 0x00010B60;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_BETH = 0x00010B61;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_GIMEL = 0x00010B62;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_DALETH = 0x00010B63;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_HE = 0x00010B64;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_WAW_AYIN_RESH = 0x00010B65;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_ZAYIN = 0x00010B66;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_HETH = 0x00010B67;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_TETH = 0x00010B68;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_YODH = 0x00010B69;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_KAPH = 0x00010B6A;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_LAMEDH = 0x00010B6B;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_MEM_QOPH = 0x00010B6C;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_NUN = 0x00010B6D;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_SAMEKH = 0x00010B6E;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_PE = 0x00010B6F;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_SADHE = 0x00010B70;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_SHIN = 0x00010B71;
const char32_t INSCRIPTIONAL_PAHLAVI_LETTER_TAW = 0x00010B72;
const char32_t INSCRIPTIONAL_PAHLAVI_NUMBER_ONE = 0x00010B78;
const char32_t INSCRIPTIONAL_PAHLAVI_NUMBER_TWO = 0x00010B79;
const char32_t INSCRIPTIONAL_PAHLAVI_NUMBER_THREE = 0x00010B7A;
const char32_t INSCRIPTIONAL_PAHLAVI_NUMBER_FOUR = 0x00010B7B;
const char32_t INSCRIPTIONAL_PAHLAVI_NUMBER_TEN = 0x00010B7C;
const char32_t INSCRIPTIONAL_PAHLAVI_NUMBER_TWENTY = 0x00010B7D;
const char32_t INSCRIPTIONAL_PAHLAVI_NUMBER_ONE_HUNDRED = 0x00010B7E;
const char32_t INSCRIPTIONAL_PAHLAVI_NUMBER_ONE_THOUSAND = 0x00010B7F;
const char32_t PSALTER_PAHLAVI_LETTER_ALEPH = 0x00010B80;
const char32_t PSALTER_PAHLAVI_LETTER_BETH = 0x00010B81;
const char32_t PSALTER_PAHLAVI_LETTER_GIMEL = 0x00010B82;
const char32_t PSALTER_PAHLAVI_LETTER_DALETH = 0x00010B83;
const char32_t PSALTER_PAHLAVI_LETTER_HE = 0x00010B84;
const char32_t PSALTER_PAHLAVI_LETTER_WAW_AYIN_RESH = 0x00010B85;
const char32_t PSALTER_PAHLAVI_LETTER_ZAYIN = 0x00010B86;
const char32_t PSALTER_PAHLAVI_LETTER_HETH = 0x00010B87;
const char32_t PSALTER_PAHLAVI_LETTER_YODH = 0x00010B88;
const char32_t PSALTER_PAHLAVI_LETTER_KAPH = 0x00010B89;
const char32_t PSALTER_PAHLAVI_LETTER_LAMEDH = 0x00010B8A;
const char32_t PSALTER_PAHLAVI_LETTER_MEM_QOPH = 0x00010B8B;
const char32_t PSALTER_PAHLAVI_LETTER_NUN = 0x00010B8C;
const char32_t PSALTER_PAHLAVI_LETTER_SAMEKH = 0x00010B8D;
const char32_t PSALTER_PAHLAVI_LETTER_PE = 0x00010B8E;
const char32_t PSALTER_PAHLAVI_LETTER_SADHE = 0x00010B8F;
const char32_t PSALTER_PAHLAVI_LETTER_SHIN = 0x00010B90;
const char32_t PSALTER_PAHLAVI_LETTER_TAW = 0x00010B91;
const char32_t PSALTER_PAHLAVI_SECTION_MARK = 0x00010B99;
const char32_t PSALTER_PAHLAVI_TURNED_SECTION_MARK = 0x00010B9A;
const char32_t PSALTER_PAHLAVI_FOUR_DOTS_WITH_CROSS = 0x00010B9B;
const char32_t PSALTER_PAHLAVI_FOUR_DOTS_WITH_DOT = 0x00010B9C;
const char32_t PSALTER_PAHLAVI_NUMBER_ONE = 0x00010BA9;
const char32_t PSALTER_PAHLAVI_NUMBER_TWO = 0x00010BAA;
const char32_t PSALTER_PAHLAVI_NUMBER_THREE = 0x00010BAB;
const char32_t PSALTER_PAHLAVI_NUMBER_FOUR = 0x00010BAC;
const char32_t PSALTER_PAHLAVI_NUMBER_TEN = 0x00010BAD;
const char32_t PSALTER_PAHLAVI_NUMBER_TWENTY = 0x00010BAE;
const char32_t PSALTER_PAHLAVI_NUMBER_ONE_HUNDRED = 0x00010BAF;
const char32_t OLD_TURKIC_LETTER_ORKHON_A = 0x00010C00;
const char32_t OLD_TURKIC_LETTER_YENISEI_A = 0x00010C01;
const char32_t OLD_TURKIC_LETTER_YENISEI_AE = 0x00010C02;
const char32_t OLD_TURKIC_LETTER_ORKHON_I = 0x00010C03;
const char32_t OLD_TURKIC_LETTER_YENISEI_I = 0x00010C04;
const char32_t OLD_TURKIC_LETTER_YENISEI_E = 0x00010C05;
const char32_t OLD_TURKIC_LETTER_ORKHON_O = 0x00010C06;
const char32_t OLD_TURKIC_LETTER_ORKHON_OE = 0x00010C07;
const char32_t OLD_TURKIC_LETTER_YENISEI_OE = 0x00010C08;
const char32_t OLD_TURKIC_LETTER_ORKHON_AB = 0x00010C09;
const char32_t OLD_TURKIC_LETTER_YENISEI_AB = 0x00010C0A;
const char32_t OLD_TURKIC_LETTER_ORKHON_AEB = 0x00010C0B;
const char32_t OLD_TURKIC_LETTER_YENISEI_AEB = 0x00010C0C;
const char32_t OLD_TURKIC_LETTER_ORKHON_AG = 0x00010C0D;
const char32_t OLD_TURKIC_LETTER_YENISEI_AG = 0x00010C0E;
const char32_t OLD_TURKIC_LETTER_ORKHON_AEG = 0x00010C0F;
const char32_t OLD_TURKIC_LETTER_YENISEI_AEG = 0x00010C10;
const char32_t OLD_TURKIC_LETTER_ORKHON_AD = 0x00010C11;
const char32_t OLD_TURKIC_LETTER_YENISEI_AD = 0x00010C12;
const char32_t OLD_TURKIC_LETTER_ORKHON_AED = 0x00010C13;
const char32_t OLD_TURKIC_LETTER_ORKHON_EZ = 0x00010C14;
const char32_t OLD_TURKIC_LETTER_YENISEI_EZ = 0x00010C15;
const char32_t OLD_TURKIC_LETTER_ORKHON_AY = 0x00010C16;
const char32_t OLD_TURKIC_LETTER_YENISEI_AY = 0x00010C17;
const char32_t OLD_TURKIC_LETTER_ORKHON_AEY = 0x00010C18;
const char32_t OLD_TURKIC_LETTER_YENISEI_AEY = 0x00010C19;
const char32_t OLD_TURKIC_LETTER_ORKHON_AEK = 0x00010C1A;
const char32_t OLD_TURKIC_LETTER_YENISEI_AEK = 0x00010C1B;
const char32_t OLD_TURKIC_LETTER_ORKHON_OEK = 0x00010C1C;
const char32_t OLD_TURKIC_LETTER_YENISEI_OEK = 0x00010C1D;
const char32_t OLD_TURKIC_LETTER_ORKHON_AL = 0x00010C1E;
const char32_t OLD_TURKIC_LETTER_YENISEI_AL = 0x00010C1F;
const char32_t OLD_TURKIC_LETTER_ORKHON_AEL = 0x00010C20;
const char32_t OLD_TURKIC_LETTER_ORKHON_ELT = 0x00010C21;
const char32_t OLD_TURKIC_LETTER_ORKHON_EM = 0x00010C22;
const char32_t OLD_TURKIC_LETTER_ORKHON_AN = 0x00010C23;
const char32_t OLD_TURKIC_LETTER_ORKHON_AEN = 0x00010C24;
const char32_t OLD_TURKIC_LETTER_YENISEI_AEN = 0x00010C25;
const char32_t OLD_TURKIC_LETTER_ORKHON_ENT = 0x00010C26;
const char32_t OLD_TURKIC_LETTER_YENISEI_ENT = 0x00010C27;
const char32_t OLD_TURKIC_LETTER_ORKHON_ENC = 0x00010C28;
const char32_t OLD_TURKIC_LETTER_YENISEI_ENC = 0x00010C29;
const char32_t OLD_TURKIC_LETTER_ORKHON_ENY = 0x00010C2A;
const char32_t OLD_TURKIC_LETTER_YENISEI_ENY = 0x00010C2B;
const char32_t OLD_TURKIC_LETTER_YENISEI_ANG = 0x00010C2C;
const char32_t OLD_TURKIC_LETTER_ORKHON_ENG = 0x00010C2D;
const char32_t OLD_TURKIC_LETTER_YENISEI_AENG = 0x00010C2E;
const char32_t OLD_TURKIC_LETTER_ORKHON_EP = 0x00010C2F;
const char32_t OLD_TURKIC_LETTER_ORKHON_OP = 0x00010C30;
const char32_t OLD_TURKIC_LETTER_ORKHON_IC = 0x00010C31;
const char32_t OLD_TURKIC_LETTER_ORKHON_EC = 0x00010C32;
const char32_t OLD_TURKIC_LETTER_YENISEI_EC = 0x00010C33;
const char32_t OLD_TURKIC_LETTER_ORKHON_AQ = 0x00010C34;
const char32_t OLD_TURKIC_LETTER_YENISEI_AQ = 0x00010C35;
const char32_t OLD_TURKIC_LETTER_ORKHON_IQ = 0x00010C36;
const char32_t OLD_TURKIC_LETTER_YENISEI_IQ = 0x00010C37;
const char32_t OLD_TURKIC_LETTER_ORKHON_OQ = 0x00010C38;
const char32_t OLD_TURKIC_LETTER_YENISEI_OQ = 0x00010C39;
const char32_t OLD_TURKIC_LETTER_ORKHON_AR = 0x00010C3A;
const char32_t OLD_TURKIC_LETTER_YENISEI_AR = 0x00010C3B;
const char32_t OLD_TURKIC_LETTER_ORKHON_AER = 0x00010C3C;
const char32_t OLD_TURKIC_LETTER_ORKHON_AS = 0x00010C3D;
const char32_t OLD_TURKIC_LETTER_ORKHON_AES = 0x00010C3E;
const char32_t OLD_TURKIC_LETTER_ORKHON_ASH = 0x00010C3F;
const char32_t OLD_TURKIC_LETTER_YENISEI_ASH = 0x00010C40;
const char32_t OLD_TURKIC_LETTER_ORKHON_ESH = 0x00010C41;
const char32_t OLD_TURKIC_LETTER_YENISEI_ESH = 0x00010C42;
const char32_t OLD_TURKIC_LETTER_ORKHON_AT = 0x00010C43;
const char32_t OLD_TURKIC_LETTER_YENISEI_AT = 0x00010C44;
const char32_t OLD_TURKIC_LETTER_ORKHON_AET = 0x00010C45;
const char32_t OLD_TURKIC_LETTER_YENISEI_AET = 0x00010C46;
const char32_t OLD_TURKIC_LETTER_ORKHON_OT = 0x00010C47;
const char32_t OLD_TURKIC_LETTER_ORKHON_BASH = 0x00010C48;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_A = 0x00010C80;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_AA = 0x00010C81;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EB = 0x00010C82;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_AMB = 0x00010C83;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EC = 0x00010C84;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ENC = 0x00010C85;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ECS = 0x00010C86;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ED = 0x00010C87;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_AND = 0x00010C88;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_E = 0x00010C89;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_CLOSE_E = 0x00010C8A;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EE = 0x00010C8B;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EF = 0x00010C8C;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EG = 0x00010C8D;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EGY = 0x00010C8E;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EH = 0x00010C8F;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_I = 0x00010C90;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_II = 0x00010C91;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EJ = 0x00010C92;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EK = 0x00010C93;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_AK = 0x00010C94;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_UNK = 0x00010C95;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EL = 0x00010C96;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ELY = 0x00010C97;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EM = 0x00010C98;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EN = 0x00010C99;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ENY = 0x00010C9A;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_O = 0x00010C9B;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_OO = 0x00010C9C;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_NIKOLSBURG_OE = 0x00010C9D;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_RUDIMENTA_OE = 0x00010C9E;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_OEE = 0x00010C9F;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EP = 0x00010CA0;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EMP = 0x00010CA1;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ER = 0x00010CA2;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_SHORT_ER = 0x00010CA3;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ES = 0x00010CA4;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ESZ = 0x00010CA5;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ET = 0x00010CA6;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ENT = 0x00010CA7;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ETY = 0x00010CA8;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ECH = 0x00010CA9;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_U = 0x00010CAA;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_UU = 0x00010CAB;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_NIKOLSBURG_UE = 0x00010CAC;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_RUDIMENTA_UE = 0x00010CAD;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EV = 0x00010CAE;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EZ = 0x00010CAF;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_EZS = 0x00010CB0;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_ENT_SHAPED_SIGN = 0x00010CB1;
const char32_t OLD_HUNGARIAN_CAPITAL_LETTER_US = 0x00010CB2;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_A = 0x00010CC0;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_AA = 0x00010CC1;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EB = 0x00010CC2;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_AMB = 0x00010CC3;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EC = 0x00010CC4;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ENC = 0x00010CC5;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ECS = 0x00010CC6;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ED = 0x00010CC7;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_AND = 0x00010CC8;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_E = 0x00010CC9;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_CLOSE_E = 0x00010CCA;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EE = 0x00010CCB;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EF = 0x00010CCC;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EG = 0x00010CCD;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EGY = 0x00010CCE;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EH = 0x00010CCF;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_I = 0x00010CD0;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_II = 0x00010CD1;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EJ = 0x00010CD2;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EK = 0x00010CD3;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_AK = 0x00010CD4;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_UNK = 0x00010CD5;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EL = 0x00010CD6;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ELY = 0x00010CD7;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EM = 0x00010CD8;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EN = 0x00010CD9;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ENY = 0x00010CDA;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_O = 0x00010CDB;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_OO = 0x00010CDC;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_NIKOLSBURG_OE = 0x00010CDD;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_RUDIMENTA_OE = 0x00010CDE;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_OEE = 0x00010CDF;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EP = 0x00010CE0;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EMP = 0x00010CE1;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ER = 0x00010CE2;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_SHORT_ER = 0x00010CE3;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ES = 0x00010CE4;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ESZ = 0x00010CE5;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ET = 0x00010CE6;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ENT = 0x00010CE7;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ETY = 0x00010CE8;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ECH = 0x00010CE9;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_U = 0x00010CEA;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_UU = 0x00010CEB;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_NIKOLSBURG_UE = 0x00010CEC;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_RUDIMENTA_UE = 0x00010CED;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EV = 0x00010CEE;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EZ = 0x00010CEF;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_EZS = 0x00010CF0;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_ENT_SHAPED_SIGN = 0x00010CF1;
const char32_t OLD_HUNGARIAN_SMALL_LETTER_US = 0x00010CF2;
const char32_t OLD_HUNGARIAN_NUMBER_ONE = 0x00010CFA;
const char32_t OLD_HUNGARIAN_NUMBER_FIVE = 0x00010CFB;
const char32_t OLD_HUNGARIAN_NUMBER_TEN = 0x00010CFC;
const char32_t OLD_HUNGARIAN_NUMBER_FIFTY = 0x00010CFD;
const char32_t OLD_HUNGARIAN_NUMBER_ONE_HUNDRED = 0x00010CFE;
const char32_t OLD_HUNGARIAN_NUMBER_ONE_THOUSAND = 0x00010CFF;
const char32_t HANIFI_ROHINGYA_LETTER_A = 0x00010D00;
const char32_t HANIFI_ROHINGYA_LETTER_BA = 0x00010D01;
const char32_t HANIFI_ROHINGYA_LETTER_PA = 0x00010D02;
const char32_t HANIFI_ROHINGYA_LETTER_TA = 0x00010D03;
const char32_t HANIFI_ROHINGYA_LETTER_TTA = 0x00010D04;
const char32_t HANIFI_ROHINGYA_LETTER_JA = 0x00010D05;
const char32_t HANIFI_ROHINGYA_LETTER_CA = 0x00010D06;
const char32_t HANIFI_ROHINGYA_LETTER_HA = 0x00010D07;
const char32_t HANIFI_ROHINGYA_LETTER_KHA = 0x00010D08;
const char32_t HANIFI_ROHINGYA_LETTER_FA = 0x00010D09;
const char32_t HANIFI_ROHINGYA_LETTER_DA = 0x00010D0A;
const char32_t HANIFI_ROHINGYA_LETTER_DDA = 0x00010D0B;
const char32_t HANIFI_ROHINGYA_LETTER_RA = 0x00010D0C;
const char32_t HANIFI_ROHINGYA_LETTER_RRA = 0x00010D0D;
const char32_t HANIFI_ROHINGYA_LETTER_ZA = 0x00010D0E;
const char32_t HANIFI_ROHINGYA_LETTER_SA = 0x00010D0F;
const char32_t HANIFI_ROHINGYA_LETTER_SHA = 0x00010D10;
const char32_t HANIFI_ROHINGYA_LETTER_KA = 0x00010D11;
const char32_t HANIFI_ROHINGYA_LETTER_GA = 0x00010D12;
const char32_t HANIFI_ROHINGYA_LETTER_LA = 0x00010D13;
const char32_t HANIFI_ROHINGYA_LETTER_MA = 0x00010D14;
const char32_t HANIFI_ROHINGYA_LETTER_NA = 0x00010D15;
const char32_t HANIFI_ROHINGYA_LETTER_WA = 0x00010D16;
const char32_t HANIFI_ROHINGYA_LETTER_KINNA_WA = 0x00010D17;
const char32_t HANIFI_ROHINGYA_LETTER_YA = 0x00010D18;
const char32_t HANIFI_ROHINGYA_LETTER_KINNA_YA = 0x00010D19;
const char32_t HANIFI_ROHINGYA_LETTER_NGA = 0x00010D1A;
const char32_t HANIFI_ROHINGYA_LETTER_NYA = 0x00010D1B;
const char32_t HANIFI_ROHINGYA_LETTER_VA = 0x00010D1C;
const char32_t HANIFI_ROHINGYA_VOWEL_A = 0x00010D1D;
const char32_t HANIFI_ROHINGYA_VOWEL_I = 0x00010D1E;
const char32_t HANIFI_ROHINGYA_VOWEL_U = 0x00010D1F;
const char32_t HANIFI_ROHINGYA_VOWEL_E = 0x00010D20;
const char32_t HANIFI_ROHINGYA_VOWEL_O = 0x00010D21;
const char32_t HANIFI_ROHINGYA_MARK_SAKIN = 0x00010D22;
const char32_t HANIFI_ROHINGYA_MARK_NA_KHONNA = 0x00010D23;
const char32_t HANIFI_ROHINGYA_SIGN_HARBAHAY = 0x00010D24;
const char32_t HANIFI_ROHINGYA_SIGN_TAHALA = 0x00010D25;
const char32_t HANIFI_ROHINGYA_SIGN_TANA = 0x00010D26;
const char32_t HANIFI_ROHINGYA_SIGN_TASSI = 0x00010D27;
const char32_t HANIFI_ROHINGYA_DIGIT_ZERO = 0x00010D30;
const char32_t HANIFI_ROHINGYA_DIGIT_ONE = 0x00010D31;
const char32_t HANIFI_ROHINGYA_DIGIT_TWO = 0x00010D32;
const char32_t HANIFI_ROHINGYA_DIGIT_THREE = 0x00010D33;
const char32_t HANIFI_ROHINGYA_DIGIT_FOUR = 0x00010D34;
const char32_t HANIFI_ROHINGYA_DIGIT_FIVE = 0x00010D35;
const char32_t HANIFI_ROHINGYA_DIGIT_SIX = 0x00010D36;
const char32_t HANIFI_ROHINGYA_DIGIT_SEVEN = 0x00010D37;
const char32_t HANIFI_ROHINGYA_DIGIT_EIGHT = 0x00010D38;
const char32_t HANIFI_ROHINGYA_DIGIT_NINE = 0x00010D39;
const char32_t RUMI_DIGIT_ONE = 0x00010E60;
const char32_t RUMI_DIGIT_TWO = 0x00010E61;
const char32_t RUMI_DIGIT_THREE = 0x00010E62;
const char32_t RUMI_DIGIT_FOUR = 0x00010E63;
const char32_t RUMI_DIGIT_FIVE = 0x00010E64;
const char32_t RUMI_DIGIT_SIX = 0x00010E65;
const char32_t RUMI_DIGIT_SEVEN = 0x00010E66;
const char32_t RUMI_DIGIT_EIGHT = 0x00010E67;
const char32_t RUMI_DIGIT_NINE = 0x00010E68;
const char32_t RUMI_NUMBER_TEN = 0x00010E69;
const char32_t RUMI_NUMBER_TWENTY = 0x00010E6A;
const char32_t RUMI_NUMBER_THIRTY = 0x00010E6B;
const char32_t RUMI_NUMBER_FORTY = 0x00010E6C;
const char32_t RUMI_NUMBER_FIFTY = 0x00010E6D;
const char32_t RUMI_NUMBER_SIXTY = 0x00010E6E;
const char32_t RUMI_NUMBER_SEVENTY = 0x00010E6F;
const char32_t RUMI_NUMBER_EIGHTY = 0x00010E70;
const char32_t RUMI_NUMBER_NINETY = 0x00010E71;
const char32_t RUMI_NUMBER_ONE_HUNDRED = 0x00010E72;
const char32_t RUMI_NUMBER_TWO_HUNDRED = 0x00010E73;
const char32_t RUMI_NUMBER_THREE_HUNDRED = 0x00010E74;
const char32_t RUMI_NUMBER_FOUR_HUNDRED = 0x00010E75;
const char32_t RUMI_NUMBER_FIVE_HUNDRED = 0x00010E76;
const char32_t RUMI_NUMBER_SIX_HUNDRED = 0x00010E77;
const char32_t RUMI_NUMBER_SEVEN_HUNDRED = 0x00010E78;
const char32_t RUMI_NUMBER_EIGHT_HUNDRED = 0x00010E79;
const char32_t RUMI_NUMBER_NINE_HUNDRED = 0x00010E7A;
const char32_t RUMI_FRACTION_ONE_HALF = 0x00010E7B;
const char32_t RUMI_FRACTION_ONE_QUARTER = 0x00010E7C;
const char32_t RUMI_FRACTION_ONE_THIRD = 0x00010E7D;
const char32_t RUMI_FRACTION_TWO_THIRDS = 0x00010E7E;
const char32_t YEZIDI_LETTER_ELIF = 0x00010E80;
const char32_t YEZIDI_LETTER_BE = 0x00010E81;
const char32_t YEZIDI_LETTER_PE = 0x00010E82;
const char32_t YEZIDI_LETTER_PHE = 0x00010E83;
const char32_t YEZIDI_LETTER_THE = 0x00010E84;
const char32_t YEZIDI_LETTER_SE = 0x00010E85;
const char32_t YEZIDI_LETTER_CIM = 0x00010E86;
const char32_t YEZIDI_LETTER_CHIM = 0x00010E87;
const char32_t YEZIDI_LETTER_CHHIM = 0x00010E88;
const char32_t YEZIDI_LETTER_HHA = 0x00010E89;
const char32_t YEZIDI_LETTER_XA = 0x00010E8A;
const char32_t YEZIDI_LETTER_DAL = 0x00010E8B;
const char32_t YEZIDI_LETTER_ZAL = 0x00010E8C;
const char32_t YEZIDI_LETTER_RA = 0x00010E8D;
const char32_t YEZIDI_LETTER_RHA = 0x00010E8E;
const char32_t YEZIDI_LETTER_ZA = 0x00010E8F;
const char32_t YEZIDI_LETTER_JA = 0x00010E90;
const char32_t YEZIDI_LETTER_SIN = 0x00010E91;
const char32_t YEZIDI_LETTER_SHIN = 0x00010E92;
const char32_t YEZIDI_LETTER_SAD = 0x00010E93;
const char32_t YEZIDI_LETTER_DAD = 0x00010E94;
const char32_t YEZIDI_LETTER_TA = 0x00010E95;
const char32_t YEZIDI_LETTER_ZE = 0x00010E96;
const char32_t YEZIDI_LETTER_EYN = 0x00010E97;
const char32_t YEZIDI_LETTER_XHEYN = 0x00010E98;
const char32_t YEZIDI_LETTER_FA = 0x00010E99;
const char32_t YEZIDI_LETTER_VA = 0x00010E9A;
const char32_t YEZIDI_LETTER_VA_ALTERNATE_FORM = 0x00010E9B;
const char32_t YEZIDI_LETTER_QAF = 0x00010E9C;
const char32_t YEZIDI_LETTER_KAF = 0x00010E9D;
const char32_t YEZIDI_LETTER_KHAF = 0x00010E9E;
const char32_t YEZIDI_LETTER_GAF = 0x00010E9F;
const char32_t YEZIDI_LETTER_LAM = 0x00010EA0;
const char32_t YEZIDI_LETTER_MIM = 0x00010EA1;
const char32_t YEZIDI_LETTER_NUN = 0x00010EA2;
const char32_t YEZIDI_LETTER_UM = 0x00010EA3;
const char32_t YEZIDI_LETTER_WAW = 0x00010EA4;
const char32_t YEZIDI_LETTER_OW = 0x00010EA5;
const char32_t YEZIDI_LETTER_EW = 0x00010EA6;
const char32_t YEZIDI_LETTER_HAY = 0x00010EA7;
const char32_t YEZIDI_LETTER_YOT = 0x00010EA8;
const char32_t YEZIDI_LETTER_ET = 0x00010EA9;
const char32_t YEZIDI_COMBINING_HAMZA_MARK = 0x00010EAB;
const char32_t YEZIDI_COMBINING_MADDA_MARK = 0x00010EAC;
const char32_t YEZIDI_HYPHENATION_MARK = 0x00010EAD;
const char32_t YEZIDI_LETTER_LAM_WITH_DOT_ABOVE = 0x00010EB0;
const char32_t YEZIDI_LETTER_YOT_WITH_CIRCUMFLEX_ABOVE = 0x00010EB1;
const char32_t OLD_SOGDIAN_LETTER_ALEPH = 0x00010F00;
const char32_t OLD_SOGDIAN_LETTER_FINAL_ALEPH = 0x00010F01;
const char32_t OLD_SOGDIAN_LETTER_BETH = 0x00010F02;
const char32_t OLD_SOGDIAN_LETTER_FINAL_BETH = 0x00010F03;
const char32_t OLD_SOGDIAN_LETTER_GIMEL = 0x00010F04;
const char32_t OLD_SOGDIAN_LETTER_HE = 0x00010F05;
const char32_t OLD_SOGDIAN_LETTER_FINAL_HE = 0x00010F06;
const char32_t OLD_SOGDIAN_LETTER_WAW = 0x00010F07;
const char32_t OLD_SOGDIAN_LETTER_ZAYIN = 0x00010F08;
const char32_t OLD_SOGDIAN_LETTER_HETH = 0x00010F09;
const char32_t OLD_SOGDIAN_LETTER_YODH = 0x00010F0A;
const char32_t OLD_SOGDIAN_LETTER_KAPH = 0x00010F0B;
const char32_t OLD_SOGDIAN_LETTER_LAMEDH = 0x00010F0C;
const char32_t OLD_SOGDIAN_LETTER_MEM = 0x00010F0D;
const char32_t OLD_SOGDIAN_LETTER_NUN = 0x00010F0E;
const char32_t OLD_SOGDIAN_LETTER_FINAL_NUN = 0x00010F0F;
const char32_t OLD_SOGDIAN_LETTER_FINAL_NUN_WITH_VERTICAL_TAIL = 0x00010F10;
const char32_t OLD_SOGDIAN_LETTER_SAMEKH = 0x00010F11;
const char32_t OLD_SOGDIAN_LETTER_AYIN = 0x00010F12;
const char32_t OLD_SOGDIAN_LETTER_ALTERNATE_AYIN = 0x00010F13;
const char32_t OLD_SOGDIAN_LETTER_PE = 0x00010F14;
const char32_t OLD_SOGDIAN_LETTER_SADHE = 0x00010F15;
const char32_t OLD_SOGDIAN_LETTER_FINAL_SADHE = 0x00010F16;
const char32_t OLD_SOGDIAN_LETTER_FINAL_SADHE_WITH_VERTICAL_TAIL = 0x00010F17;
const char32_t OLD_SOGDIAN_LETTER_RESH_AYIN_DALETH = 0x00010F18;
const char32_t OLD_SOGDIAN_LETTER_SHIN = 0x00010F19;
const char32_t OLD_SOGDIAN_LETTER_TAW = 0x00010F1A;
const char32_t OLD_SOGDIAN_LETTER_FINAL_TAW = 0x00010F1B;
const char32_t OLD_SOGDIAN_LETTER_FINAL_TAW_WITH_VERTICAL_TAIL = 0x00010F1C;
const char32_t OLD_SOGDIAN_NUMBER_ONE = 0x00010F1D;
const char32_t OLD_SOGDIAN_NUMBER_TWO = 0x00010F1E;
const char32_t OLD_SOGDIAN_NUMBER_THREE = 0x00010F1F;
const char32_t OLD_SOGDIAN_NUMBER_FOUR = 0x00010F20;
const char32_t OLD_SOGDIAN_NUMBER_FIVE = 0x00010F21;
const char32_t OLD_SOGDIAN_NUMBER_TEN = 0x00010F22;
const char32_t OLD_SOGDIAN_NUMBER_TWENTY = 0x00010F23;
const char32_t OLD_SOGDIAN_NUMBER_THIRTY = 0x00010F24;
const char32_t OLD_SOGDIAN_NUMBER_ONE_HUNDRED = 0x00010F25;
const char32_t OLD_SOGDIAN_FRACTION_ONE_HALF = 0x00010F26;
const char32_t OLD_SOGDIAN_LIGATURE_AYIN_DALETH = 0x00010F27;
const char32_t SOGDIAN_LETTER_ALEPH = 0x00010F30;
const char32_t SOGDIAN_LETTER_BETH = 0x00010F31;
const char32_t SOGDIAN_LETTER_GIMEL = 0x00010F32;
const char32_t SOGDIAN_LETTER_HE = 0x00010F33;
const char32_t SOGDIAN_LETTER_WAW = 0x00010F34;
const char32_t SOGDIAN_LETTER_ZAYIN = 0x00010F35;
const char32_t SOGDIAN_LETTER_HETH = 0x00010F36;
const char32_t SOGDIAN_LETTER_YODH = 0x00010F37;
const char32_t SOGDIAN_LETTER_KAPH = 0x00010F38;
const char32_t SOGDIAN_LETTER_LAMEDH = 0x00010F39;
const char32_t SOGDIAN_LETTER_MEM = 0x00010F3A;
const char32_t SOGDIAN_LETTER_NUN = 0x00010F3B;
const char32_t SOGDIAN_LETTER_SAMEKH = 0x00010F3C;
const char32_t SOGDIAN_LETTER_AYIN = 0x00010F3D;
const char32_t SOGDIAN_LETTER_PE = 0x00010F3E;
const char32_t SOGDIAN_LETTER_SADHE = 0x00010F3F;
const char32_t SOGDIAN_LETTER_RESH_AYIN = 0x00010F40;
const char32_t SOGDIAN_LETTER_SHIN = 0x00010F41;
const char32_t SOGDIAN_LETTER_TAW = 0x00010F42;
const char32_t SOGDIAN_LETTER_FETH = 0x00010F43;
const char32_t SOGDIAN_LETTER_LESH = 0x00010F44;
const char32_t SOGDIAN_INDEPENDENT_SHIN = 0x00010F45;
const char32_t SOGDIAN_COMBINING_DOT_BELOW = 0x00010F46;
const char32_t SOGDIAN_COMBINING_TWO_DOTS_BELOW = 0x00010F47;
const char32_t SOGDIAN_COMBINING_DOT_ABOVE = 0x00010F48;
const char32_t SOGDIAN_COMBINING_TWO_DOTS_ABOVE = 0x00010F49;
const char32_t SOGDIAN_COMBINING_CURVE_ABOVE = 0x00010F4A;
const char32_t SOGDIAN_COMBINING_CURVE_BELOW = 0x00010F4B;
const char32_t SOGDIAN_COMBINING_HOOK_ABOVE = 0x00010F4C;
const char32_t SOGDIAN_COMBINING_HOOK_BELOW = 0x00010F4D;
const char32_t SOGDIAN_COMBINING_LONG_HOOK_BELOW = 0x00010F4E;
const char32_t SOGDIAN_COMBINING_RESH_BELOW = 0x00010F4F;
const char32_t SOGDIAN_COMBINING_STROKE_BELOW = 0x00010F50;
const char32_t SOGDIAN_NUMBER_ONE = 0x00010F51;
const char32_t SOGDIAN_NUMBER_TEN = 0x00010F52;
const char32_t SOGDIAN_NUMBER_TWENTY = 0x00010F53;
const char32_t SOGDIAN_NUMBER_ONE_HUNDRED = 0x00010F54;
const char32_t SOGDIAN_PUNCTUATION_TWO_VERTICAL_BARS = 0x00010F55;
const char32_t SOGDIAN_PUNCTUATION_TWO_VERTICAL_BARS_WITH_DOTS = 0x00010F56;
const char32_t SOGDIAN_PUNCTUATION_CIRCLE_WITH_DOT = 0x00010F57;
const char32_t SOGDIAN_PUNCTUATION_TWO_CIRCLES_WITH_DOTS = 0x00010F58;
const char32_t SOGDIAN_PUNCTUATION_HALF_CIRCLE_WITH_DOT = 0x00010F59;
const char32_t CHORASMIAN_LETTER_ALEPH = 0x00010FB0;
const char32_t CHORASMIAN_LETTER_SMALL_ALEPH = 0x00010FB1;
const char32_t CHORASMIAN_LETTER_BETH = 0x00010FB2;
const char32_t CHORASMIAN_LETTER_GIMEL = 0x00010FB3;
const char32_t CHORASMIAN_LETTER_DALETH = 0x00010FB4;
const char32_t CHORASMIAN_LETTER_HE = 0x00010FB5;
const char32_t CHORASMIAN_LETTER_WAW = 0x00010FB6;
const char32_t CHORASMIAN_LETTER_CURLED_WAW = 0x00010FB7;
const char32_t CHORASMIAN_LETTER_ZAYIN = 0x00010FB8;
const char32_t CHORASMIAN_LETTER_HETH = 0x00010FB9;
const char32_t CHORASMIAN_LETTER_YODH = 0x00010FBA;
const char32_t CHORASMIAN_LETTER_KAPH = 0x00010FBB;
const char32_t CHORASMIAN_LETTER_LAMEDH = 0x00010FBC;
const char32_t CHORASMIAN_LETTER_MEM = 0x00010FBD;
const char32_t CHORASMIAN_LETTER_NUN = 0x00010FBE;
const char32_t CHORASMIAN_LETTER_SAMEKH = 0x00010FBF;
const char32_t CHORASMIAN_LETTER_AYIN = 0x00010FC0;
const char32_t CHORASMIAN_LETTER_PE = 0x00010FC1;
const char32_t CHORASMIAN_LETTER_RESH = 0x00010FC2;
const char32_t CHORASMIAN_LETTER_SHIN = 0x00010FC3;
const char32_t CHORASMIAN_LETTER_TAW = 0x00010FC4;
const char32_t CHORASMIAN_NUMBER_ONE = 0x00010FC5;
const char32_t CHORASMIAN_NUMBER_TWO = 0x00010FC6;
const char32_t CHORASMIAN_NUMBER_THREE = 0x00010FC7;
const char32_t CHORASMIAN_NUMBER_FOUR = 0x00010FC8;
const char32_t CHORASMIAN_NUMBER_TEN = 0x00010FC9;
const char32_t CHORASMIAN_NUMBER_TWENTY = 0x00010FCA;
const char32_t CHORASMIAN_NUMBER_ONE_HUNDRED = 0x00010FCB;
const char32_t ELYMAIC_LETTER_ALEPH = 0x00010FE0;
const char32_t ELYMAIC_LETTER_BETH = 0x00010FE1;
const char32_t ELYMAIC_LETTER_GIMEL = 0x00010FE2;
const char32_t ELYMAIC_LETTER_DALETH = 0x00010FE3;
const char32_t ELYMAIC_LETTER_HE = 0x00010FE4;
const char32_t ELYMAIC_LETTER_WAW = 0x00010FE5;
const char32_t ELYMAIC_LETTER_ZAYIN = 0x00010FE6;
const char32_t ELYMAIC_LETTER_HETH = 0x00010FE7;
const char32_t ELYMAIC_LETTER_TETH = 0x00010FE8;
const char32_t ELYMAIC_LETTER_YODH = 0x00010FE9;
const char32_t ELYMAIC_LETTER_KAPH = 0x00010FEA;
const char32_t ELYMAIC_LETTER_LAMEDH = 0x00010FEB;
const char32_t ELYMAIC_LETTER_MEM = 0x00010FEC;
const char32_t ELYMAIC_LETTER_NUN = 0x00010FED;
const char32_t ELYMAIC_LETTER_SAMEKH = 0x00010FEE;
const char32_t ELYMAIC_LETTER_AYIN = 0x00010FEF;
const char32_t ELYMAIC_LETTER_PE = 0x00010FF0;
const char32_t ELYMAIC_LETTER_SADHE = 0x00010FF1;
const char32_t ELYMAIC_LETTER_QOPH = 0x00010FF2;
const cha