; Script originally generated by the HM NIS Edit Script Wizard.

; Define the DLL dir and the installer filename on the command line, e.g. like his:
; Usage: "C:\Program Files (x86)\NSIS\makensis.exe" /DDLL_DIR="C:\msys64\mingw64\bin" ValyriaTear.nsi

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Valyria Tear"
!define PRODUCT_VERSION "Episode I - v1.1.0"
!define PRODUCT_PUBLISHER "Bertram"
!define PRODUCT_WEB_SITE "https://github.com/Bertram25/ValyriaTear/wiki"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\ValyriaTear.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"


!define LICENSE_FILE "license-file"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "data/icons/program_icon.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page (not needed)
; !insertmacro MUI_PAGE_LICENSE $LICENSE_FILE
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\$0.exe"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile ValyriaTear-Installer.exe
InstallDir "$PROGRAMFILES\ValyriaTear"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "MainSection" SEC01
  StrCpy $0 "ValyriaTear"
  SetOverwrite ifnewer

  SetOutPath "$INSTDIR\data"
  File /r data\*

; The offline manual
  SetOutPath "$INSTDIR\doc"
  File /r doc\*

  SetOutPath "$INSTDIR"
  File "src\valyriatear.exe"
  ; Load DLLs. We use wildcards because the names can change slightly depending
  ; on the MSys installation.
  File "${DLL_DIR}\glew32.dll"
  File "${DLL_DIR}\libbz2-?.dll"
  File "${DLL_DIR}\libfreetype-?.dll"
  File "${DLL_DIR}\libgcc_?_*.dll"
  File "${DLL_DIR}\libglib-2.0-?.dll"
  File "${DLL_DIR}\libgraphite2.dll"
  File "${DLL_DIR}\libharfbuzz-?.dll"
  File "${DLL_DIR}\libiconv-?.dll"
  File "${DLL_DIR}\libintl-?.dll"
  File "${DLL_DIR}\libjpeg-?.dll"
  File "${DLL_DIR}\liblzma-?.dll"
  File "${DLL_DIR}\libogg-?.dll"
  File "${DLL_DIR}\libopenal-?.dll"
  File "${DLL_DIR}\libpcre-?.dll"
  File "${DLL_DIR}\libpng16-??.dll"
  File "${DLL_DIR}\libstdc++-?.dll"
  File "${DLL_DIR}\libtiff-?.dll"
  File "${DLL_DIR}\libvorbis-?.dll"
  File "${DLL_DIR}\libvorbisfile-?.dll"
  File "${DLL_DIR}\libwebp-?.dll"
  File "${DLL_DIR}\libwinpthread-?.dll"
  File "${DLL_DIR}\lua5?.dll"
  File "${DLL_DIR}\SDL2.dll"
  File "${DLL_DIR}\SDL2_image.dll"
  File "${DLL_DIR}\SDL2_ttf.dll"
  File "${DLL_DIR}\zlib1.dll"
  File "${DLL_DIR}\libzstd.dll"

  CreateDirectory "$SMPROGRAMS\ValyriaTear"
  CreateShortCut "$SMPROGRAMS\ValyriaTear\$0.lnk" "$INSTDIR\valyriatear.exe"
  CreateShortCut "$SMPROGRAMS\ValyriaTear\Manual.lnk" "$INSTDIR\doc\manual\index.htm"
SectionEnd

Section -AdditionalIcons
  CreateShortCut "$SMPROGRAMS\ValyriaTear\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\${PRODUCT_NAME}.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\${PRODUCT_NAME}.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
;  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  StrCpy $0 "ValyriaTear"

  Delete "$SMPROGRAMS\ValyriaTear\Uninstall.lnk"
  Delete "$SMPROGRAMS\ValyriaTear\$0.lnk"
  Delete "$SMPROGRAMS\ValyriaTear\Manual.lnk"

  RMDir "$SMPROGRAMS\ValyriaTear"
  RMDir /r "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
