#include "Tower.h"

#include "UtilityClass.h"

towerclass::towerclass()
{
	minitowermode = false;
	//We init the lookup table:
	for (int i = 0; i < 700; i++)
	{
		vmult.push_back(int(i * 40));
	}
	//We create a blank map
	for (int j = 0; j < 700; j++)
	{
		for (int i = 0; i < 40; i++)
		{
			contents.push_back(0);
		}
	}
	for (int j = 0; j < 120; j++)
	{
		for (int i = 0; i < 40; i++)
		{
			back.push_back(0);
			minitower.push_back(0);
		}
	}

	loadbackground();
	loadmap();
}

int towerclass::backat(int xp, int yp, int yoff)
{
	yp = yp * 8;
	yp += yoff;
	yoff = yp % 8;
	yp = (yp - yoff) / 8;

	if (xp >= 0 && xp < 40)
	{
		while (yp < 0) yp += 120;
		while (yp >= 120) yp -= 120;
		return back[xp + vmult[yp]];
	}
	return 0;
}

int towerclass::at(int xp, int yp, int yoff)
{
	if (minitowermode)
	{
		return miniat(xp, yp, yoff);
	}
	else
	{
		yp = yp * 8;
		yp += yoff;
		yoff = yp % 8;
		yp = (yp - yoff) / 8;

		while (yp < 0) yp += 700;
		while (yp >= 700) yp -= 700;
		if (xp >= 0 && xp < 40)
		{
			return contents[xp + vmult[yp]];
		}
		else if (xp == -1)
		{
			return contents[vmult[yp]];
		}
		else if (xp == 40)
		{
			return contents[39 + vmult[yp]];
		}
		return 0;
	}
}

int towerclass::miniat(int xp, int yp, int yoff)
{
	yp = yp * 8;
	yp += yoff;
	yoff = yp % 8;
	yp = (yp - yoff) / 8;

	while (yp < 0) yp += 100;
	while (yp >= 100) yp -= 100;
	if (xp >= 0 && xp < 40)
	{
		return minitower[xp + vmult[yp]];
	}
	else if (xp == -1)
	{
		return minitower[vmult[yp]];
	}
	else if (xp == 40)
	{
		return minitower[39 + vmult[yp]];
	}
	return 0;
}

void towerclass::fillbackground(std::vector<std::string>& tmap)
{
	for (int j = 0; j < 120; j++)
	{
		std::vector<std::string> maprow = split(tmap[j], ',');
		for (int i = 0; i < 40; i++)
		{
			back[i + vmult[j]] = atoi(maprow[i].c_str());
		}
	}
}

void towerclass::fillminitower(std::vector<std::string>& tmap)
{


	for (int j = 0; j < 100; j++)
	{
		std::vector<std::string> maprow = split(tmap[j], ',');
		for (int i = 0; i < 40; i++)
		{
			minitower[i + vmult[j]] = atoi(maprow[i].c_str());
		}
	}
}

void towerclass::loadminitower1()
{
	std::vector<std::string> tmap;
	//Loads the first minitower into the array.
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,14,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,22,14,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,22,14,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,28,22,14,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,28,28,28,28,22,14,12,12,12,12,12");
	tmap.push_back("23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("6,6,6,6,6,6,6,6,28,28,28,28,28,28,28,28,28,28,28,28,6,6,6,6,6,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("18,18,18,18,18,18,18,19,28,28,28,28,28,28,28,28,28,28,28,28,17,18,18,18,19,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,15,19,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,15,19,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,15,19,28,28,28,28,28,28,17,18,16,12,12,12,12,12,12,15,19,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,15,19,28,28,28,17,18,16,12,12,12,12,12,12,12,12,12,15,19,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,15,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,12,15,19,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,22,14,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,22,14,12,12,12");
	tmap.push_back("12,12,13,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,7,7,28,28,28,28,28,28,20,12,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,13,23,24,7,7,28,28,28,28,28,28,28,28,20,12,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,13,23,24,7,7,28,28,28,28,28,28,28,28,28,28,20,12,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,13,23,24,7,7,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,28,28,20,12,12,12,12,12,13,23,24,7,7,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,28,28,20,12,12,12,13,23,24,7,7,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12");
	tmap.push_back("12,12,21,28,28,28,17,19,28,28,28,22,23,23,23,24,7,7,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,20,21,28,28,28,7,7,7,7,7,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,20,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,20,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,20,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,20,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,13,23,23,23,23,14,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,20,21,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,13,23,24,7,7,7,7,20,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,20,15,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,13,23,24,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,19,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,21,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,21,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,13,23,24,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,24,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,18,18,18,16,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,23,14,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,17,19,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,22,24,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,23,23,23,23,23,23,23,23");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,6,6,6,6,6,6");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,18,18,18,18");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,17,19,28,28,28,28,28,0,0,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,22,24,28,28,28,28,28,0,0,28,28,28,28,28,28,28,28,28,0,0,0,20,13,23,23,23,23");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,20,21,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,20,21,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,20,21,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,20,21,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,20,21,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,20,21,28,28,17,18");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,20,21,28,28,20,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,17,19,0,0,0,20,21,28,28,22,23");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,22,24,0,0,0,20,21,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,21,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,21,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,21,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,21,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,15,18,18,18,18");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");

	fillminitower(tmap);
}

void towerclass::loadminitower2()
{
	std::vector<std::string> tmap;
	tmap.push_back("12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,20,21,28,28,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,20,21,28,28,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,20,21,28,28,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,20,21,28,28,20,13,23,23,23,23,23,23,23,23,23");
	tmap.push_back("12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,20,21,28,28,22,24,28,28,0,0,0,0,0,0,0");
	tmap.push_back("12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,20,21,28,28,28,28,28,28,0,0,0,0,0,0,0");
	tmap.push_back("12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,22,24,28,28,28,28,28,28,0,0,0,0,0,0,0");
	tmap.push_back("12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0");
	tmap.push_back("12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,22,24,28,28,28,28,28,28,28,28,28,28,0,17,18,18,18,18,18");
	tmap.push_back("12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,28,28,28,28,28,28,28,28,28,28,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,28,28,28,28,28,28,28,28,28,28,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("23,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,11,22,24,10,0,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("18,18,18,18,18,18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("23,23,23,23,23,23,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,19,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("18,18,18,18,18,19,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,21,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,21,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,21,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,21,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,13,23,23,23,23,23,23,14,13,23,23,23,23,23,23,23,14,12,12,12,12,21,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,9,9,9,9,9,9,22,24,9,9,9,9,9,9,9,22,23,23,23,23,24,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,8,8,0,0,0,0,0,0,0,28,28,28,28,28,6,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,25,27,0,0,0,0,0,0,0,28,28,28,28,28,26,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,9,9,0,0,0,0,0,0,0,28,28,28,28,28,7,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,21,8,8,8,8,8,8,17,18,18,18,19,8,8,8,6,17,18,18,18,18,19,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,15,18,18,18,18,18,18,16,12,12,12,15,18,18,18,18,16,12,12,12,12,21,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,6,6,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,19,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,14,13,23,23,23,24,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,21,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,21,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,22,24,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,25,27,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,17,19,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,20,21,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,20,21,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,21,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,24,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,0,0,28,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,28,28,28,28,28,17,19,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,13,24,0,28,28,28,28,28,28,28,20,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,13,24,0,0,28,28,28,28,28,28,17,16,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,13,24,0,0,0,28,28,28,28,28,28,20,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,13,24,0,0,0,0,28,28,28,28,28,17,16,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,13,24,0,0,0,0,0,28,28,28,28,28,20,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,13,24,0,0,0,0,0,0,28,28,28,28,17,16,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,13,24,0,0,0,0,0,28,28,28,28,28,28,20,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,13,24,0,0,0,0,0,0,28,28,28,28,28,17,16,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,13,24,0,0,0,0,0,0,0,28,28,28,28,28,20,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,13,24,0,0,0,0,0,0,0,0,28,28,28,28,17,16,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("23,23,24,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,17,16,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,20,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,28,28,17,16,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,21,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,21,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12");

	fillminitower(tmap);
}


void towerclass::loadbackground()
{
	//Loads the background into the array.
	std::vector<std::string> tmap;
	tmap.push_back("1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,2,0,0,0,0,0,0,0,0,0,0,0,0,5,4,0,0");
	tmap.push_back("2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,2,0,0,0,0,0,0,0,0,0,0,0,0,5,1,1,4,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,2,0,0,0,0,0,0,0,0,0,0,0,0,5,1,1,1,1,4");
	tmap.push_back("0,5,4,0,0,0,0,0,0,5,4,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,2");
	tmap.push_back("5,1,1,4,0,0,0,0,5,1,1,4,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,2,0");
	tmap.push_back("1,1,1,1,4,0,0,5,1,1,1,1,4,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,0,5,1,1,1,1,1,2,0,0");
	tmap.push_back("1,1,1,1,1,4,5,1,1,1,1,1,1,4,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,3,1,1,1,1,1,4,0,0");
	tmap.push_back("1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,3,1,1,1,1,1,4,0");
	tmap.push_back("1,1,1,1,1,1,1,1,2,3,1,1,2,3,1,4,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,3,1,1,1,1,1,4");
	tmap.push_back("1,1,1,1,1,1,1,2,0,0,3,2,0,0,3,2,0,0,0,0,0,0,5,4,5,1,1,4,0,0,0,0,0,0,3,1,1,1,1,1");
	tmap.push_back("1,1,1,1,1,1,2,0,5,4,0,0,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,4,0,0,0,0,0,0,3,1,1,1,1");
	tmap.push_back("1,1,1,1,1,1,4,5,1,2,0,0,0,0,0,0,0,0,0,0,0,3,1,1,1,2,3,1,1,4,0,0,0,0,0,0,3,1,1,1");
	tmap.push_back("1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,1,4,0,3,1,1,4,0,0,0,0,0,0,3,1,1");
	tmap.push_back("3,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,1,2,0,5,1,1,1,4,0,0,0,0,0,0,3,1");
	tmap.push_back("0,3,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,5,4,5,1,1,2,0,0,3,1,1,1,2,0,0,0,0,0,0,0,3");
	tmap.push_back("0,0,3,1,1,1,4,0,0,0,0,0,5,4,0,0,0,0,5,1,1,1,1,2,0,0,0,0,3,1,2,0,5,4,0,0,0,0,0,0");
	tmap.push_back("0,0,0,3,1,1,1,4,0,0,0,5,1,2,0,0,0,0,3,1,1,1,1,4,5,4,0,0,5,1,4,5,1,1,4,0,0,0,0,0");
	tmap.push_back("0,0,0,0,3,1,1,1,4,0,0,3,1,4,0,0,0,0,5,1,1,1,1,1,1,1,4,5,1,1,1,1,1,1,2,0,0,0,0,0");
	tmap.push_back("0,0,0,0,5,1,1,1,1,4,0,0,3,1,4,5,4,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0");
	tmap.push_back("0,0,0,5,1,1,1,1,1,1,4,0,0,3,1,1,1,1,1,1,1,1,2,3,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,5");
	tmap.push_back("0,0,5,1,1,1,2,3,1,1,1,4,0,0,3,1,1,1,1,1,1,2,0,0,3,1,1,1,1,1,1,1,4,0,0,0,0,0,5,1");
	tmap.push_back("0,0,3,1,1,2,0,0,3,1,1,1,4,0,0,3,1,1,1,1,1,4,0,0,0,3,2,3,1,1,1,1,1,4,0,0,0,0,3,1");
	tmap.push_back("0,0,0,3,2,0,0,0,0,3,2,3,1,4,0,0,3,1,1,1,1,1,4,0,0,0,0,0,3,1,1,2,3,1,4,0,0,0,0,3");
	tmap.push_back("0,0,0,0,0,0,5,4,0,0,0,0,3,1,4,0,0,3,2,3,1,1,1,4,0,0,0,0,0,3,2,0,0,3,1,4,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,3,1,4,0,0,0,0,3,1,4,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,0,0,3,2,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,5,1,1,4,5,4,0,0,3,2,0,0,0,3,1,1,2,0,0,5,4,0,0,0,0,5,4,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,5,1,1,1,1,1,2,0,0,0,0,0,0,0,0,3,1,4,0,0,3,1,4,0,0,5,1,1,4,0,0,5,4,0,0");
	tmap.push_back("0,0,0,0,5,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,3,1,4,0,0,3,1,4,5,1,2,3,1,4,5,1,1,4,0");
	tmap.push_back("0,0,0,5,1,1,1,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,3,1,4,0,0,3,1,1,2,0,0,3,1,1,1,1,1,4");
	tmap.push_back("0,0,0,3,1,1,2,3,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,3,1,4,0,0,3,2,0,0,0,0,3,1,1,1,1,1");
	tmap.push_back("4,0,0,0,3,2,0,0,3,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,0,5,1,1,1,1,1");
	tmap.push_back("1,4,0,0,0,0,0,0,5,1,1,1,1,4,0,0,0,0,5,4,0,0,0,0,0,3,1,4,0,5,4,0,0,5,1,1,1,1,1,1");
	tmap.push_back("3,1,4,0,0,0,0,5,1,1,1,1,1,1,4,0,0,0,3,1,4,5,4,0,0,5,1,2,0,3,1,4,5,1,1,1,2,3,1,1");
	tmap.push_back("0,3,1,4,0,0,5,1,1,1,2,3,1,1,2,0,0,0,0,3,1,1,1,4,5,1,2,0,0,0,3,1,1,1,1,2,0,5,1,1");
	tmap.push_back("0,5,1,1,4,5,1,1,1,2,0,0,3,2,0,0,0,0,0,5,1,1,1,1,1,2,0,0,0,0,0,3,1,1,2,0,5,1,1,1");
	tmap.push_back("5,1,1,1,1,1,1,1,1,4,5,4,0,0,0,0,0,0,0,3,1,1,1,1,1,4,0,0,0,0,0,5,1,2,0,0,3,1,1,1");
	tmap.push_back("1,1,1,2,3,1,1,1,1,1,1,1,4,5,4,0,0,5,4,0,3,1,1,1,1,1,4,0,0,0,5,1,2,0,0,0,0,3,1,1");
	tmap.push_back("1,1,2,0,0,3,1,1,1,1,1,1,1,1,1,4,5,1,2,0,5,1,1,1,2,3,2,0,0,0,3,1,4,0,0,0,0,0,3,1");
	tmap.push_back("1,2,0,0,0,0,3,1,1,2,3,1,1,1,1,1,1,2,0,5,1,1,1,1,4,0,0,5,4,0,0,3,1,4,0,0,0,0,0,3");
	tmap.push_back("2,0,0,0,0,0,5,1,2,0,0,3,1,1,1,1,2,0,5,1,1,1,1,1,1,4,5,1,1,4,0,0,3,1,4,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,5,1,2,0,0,0,0,3,1,1,1,4,5,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,3,2,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,3,2,0,0,0,0,0,0,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,5,4,0,0,0,0,5,4,0,0,0,0,0,3,1,1,1,1,2,3,1,1,1,1,1,1,2,0,0,5,4,0,0,5,4,0,0,0,5");
	tmap.push_back("5,1,1,4,0,0,5,1,2,0,0,0,0,0,0,3,1,1,2,0,0,3,1,1,1,1,2,0,0,5,1,1,4,5,1,2,0,0,5,1");
	tmap.push_back("1,1,1,1,4,5,1,2,0,0,0,0,0,0,0,0,3,2,0,0,0,0,3,1,1,2,0,0,5,1,1,1,1,1,2,0,0,5,1,1");
	tmap.push_back("1,1,1,1,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,1,4,0,0,3,1,1,1,1,2,0,0,5,1,1,1");
	tmap.push_back("1,1,1,1,1,1,1,2,0,5,4,0,0,0,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,3,1,1,2,0,0,5,1,1,1,1");
	tmap.push_back("1,1,1,1,1,1,1,4,5,1,2,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,4,0,0,3,1,4,0,0,3,1,1,1,1");
	tmap.push_back("1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,1,2,0,0,5,1,1,4,0,0,3,1,1,1");
	tmap.push_back("1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,1,2,0,0,5,1,1,1,2,0,0,5,1,1,1");
	tmap.push_back("3,1,1,1,1,1,1,2,0,0,0,0,0,5,4,0,0,5,1,1,1,1,1,1,1,2,0,0,5,1,1,1,2,0,0,5,1,1,1,1");
	tmap.push_back("0,3,1,1,1,1,1,4,0,0,5,4,5,1,1,4,5,1,1,1,1,1,1,1,2,0,0,5,1,1,1,2,0,0,5,1,1,1,1,1");
	tmap.push_back("0,0,3,1,1,1,1,1,4,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,0,0,3,1,1,2,0,0,5,1,1,1,1,1,1");
	tmap.push_back("0,0,0,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,0,0,3,2,0,0,5,1,1,1,1,1,1,1");
	tmap.push_back("0,0,0,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,0,0,0,0,0,3,1,1,1,1,1,1,1");
	tmap.push_back("0,0,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,1,4,0,0,0,0,0,3,1,1,1,1,1,1");
	tmap.push_back("0,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,1,1,1,1,1,1,2,0,0,3,1,4,0,0,0,0,5,1,2,3,1,1,1");
	tmap.push_back("5,1,1,1,1,1,1,1,1,1,1,1,2,3,2,0,0,3,1,1,1,1,2,0,0,0,0,3,1,4,0,0,5,1,2,0,0,3,1,1");
	tmap.push_back("1,1,1,1,1,1,1,1,1,1,1,1,4,0,0,5,4,0,3,1,1,2,0,0,0,0,0,0,3,1,4,5,1,2,0,0,0,0,3,1");
	tmap.push_back("1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,1,1,4,0,3,1,4,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,3");
	tmap.push_back("3,1,1,1,1,2,3,1,1,2,3,1,1,1,1,1,1,1,4,0,3,1,4,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0");
	tmap.push_back("0,3,1,1,2,0,0,3,2,0,0,3,1,1,1,1,1,1,2,0,0,3,2,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,3,2,0,0,0,0,0,0,0,0,3,1,1,1,1,2,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,5,1,2,3,1,1,1,4,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,0,0,0,0,5,1,2,0,0,3,1,1,1,4,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,5,1,1,1,2,3,1,4,0,0,0,0,0,3,2,0,0,0,0,3,1,1,1,4,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,5,1,1,1,2,0,0,3,1,4,0,0,0,0,0,0,0,0,0,0,0,3,1,1,1,4,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,3,1,4,0,0,0,0,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,0,5,1,1,4,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,4,5,1,1,1,2,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,5,1,1,1,1,4,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,5,1,1,1,2,3,1,4,0,0,0,0,0,0,5,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("5,1,1,1,2,0,0,3,1,4,0,0,0,0,5,1,1,1,2,3,2,3,2,3,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("1,1,1,2,0,0,0,5,1,2,0,0,0,5,1,1,1,2,0,0,0,0,0,0,3,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("1,1,2,0,0,0,5,1,2,0,0,0,5,1,1,1,1,4,0,0,0,0,0,0,0,3,1,1,1,4,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("1,2,0,0,0,0,3,1,4,0,0,5,1,1,1,1,1,2,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,0,0,0,0,0,0,0");
	tmap.push_back("2,0,0,0,0,0,0,3,1,4,5,1,1,1,1,1,1,4,0,0,0,0,0,0,5,1,2,3,1,1,1,4,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,3,1,1,1,1,1,1,1,1,1,4,5,4,0,0,0,3,2,0,0,3,1,1,1,4,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,5,1,2,3,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,5,1,1,1,1,1,1,4,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,5,1,1,4,0,3,1,1,1,1,1,1,2,0,0,0,0,0,0,0,5,1,1,1,1,1,1,1,2,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,3,1,1,1,4,0,3,1,1,1,1,2,0,0,0,5,4,0,0,5,1,1,1,1,1,1,1,2,0,5,4,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,3,1,1,2,0,5,1,1,1,1,4,0,0,5,1,2,0,5,1,1,1,1,1,1,1,2,0,5,1,1,4,0,0");
	tmap.push_back("0,0,0,0,0,0,0,5,1,2,0,5,1,1,1,1,1,1,4,0,3,1,4,5,1,1,1,1,1,1,1,2,0,5,1,1,1,1,4,0");
	tmap.push_back("0,0,0,0,0,0,5,1,2,0,5,1,1,1,1,1,1,1,1,4,0,3,1,1,1,1,1,1,1,1,2,0,5,1,1,1,1,1,1,4");
	tmap.push_back("0,0,0,0,0,0,3,2,0,0,3,1,1,1,1,2,3,1,1,1,4,0,3,1,1,1,1,1,1,1,4,0,3,1,1,1,1,1,1,1");
	tmap.push_back("0,0,5,4,0,0,0,0,0,0,0,3,1,1,2,0,5,1,1,1,2,0,0,3,1,1,1,1,1,1,1,4,0,3,1,1,1,1,1,1");
	tmap.push_back("0,5,1,1,4,0,0,0,0,0,0,0,3,2,0,5,1,1,1,1,4,0,0,0,3,1,1,1,1,1,1,1,4,0,3,1,1,1,1,2");
	tmap.push_back("0,3,1,1,1,4,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,4,0,0,0,3,1,1,1,1,1,1,1,4,5,1,1,1,2,0");
	tmap.push_back("0,0,3,1,1,1,4,0,0,0,0,0,0,0,3,1,1,1,1,1,1,2,0,5,4,0,3,1,1,1,1,1,1,1,1,1,1,2,0,0");
	tmap.push_back("0,0,0,3,1,1,1,4,0,0,0,0,0,0,0,3,1,1,1,1,2,0,5,1,2,0,5,1,1,1,1,1,1,1,1,1,2,0,0,0");
	tmap.push_back("0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,5,1,1,1,1,4,5,1,2,0,5,1,2,3,1,1,1,1,1,1,1,4,0,0,0");
	tmap.push_back("0,0,5,1,1,1,2,0,5,4,0,0,0,0,5,1,1,1,1,1,1,1,2,0,0,3,2,0,5,1,1,1,1,1,1,1,1,4,0,0");
	tmap.push_back("0,5,1,1,1,2,0,0,3,1,4,0,0,5,1,1,1,1,1,1,1,2,0,5,4,0,0,0,3,1,1,1,1,1,1,1,1,1,4,0");
	tmap.push_back("5,1,1,1,2,0,5,4,0,3,1,4,0,3,1,1,1,1,1,1,2,0,5,1,1,4,5,4,0,3,1,1,1,1,2,3,1,1,1,4");
	tmap.push_back("1,1,1,2,0,5,1,1,4,0,3,1,4,0,3,1,1,1,1,2,0,5,1,1,1,1,1,1,4,5,1,1,1,2,0,0,3,1,1,1");
	tmap.push_back("1,1,1,4,5,1,1,1,1,4,5,1,1,4,0,3,1,1,1,4,0,3,1,1,1,1,1,1,1,1,1,1,1,4,0,0,0,3,1,1");
	tmap.push_back("1,1,1,1,1,1,2,3,1,1,1,1,1,1,4,0,3,1,1,1,4,0,3,1,1,1,1,1,1,1,1,1,1,1,4,0,0,5,1,1");
	tmap.push_back("3,1,1,1,1,1,4,0,3,1,1,1,1,1,1,4,0,3,1,1,1,4,0,3,1,1,1,1,1,2,3,1,1,1,2,0,5,1,1,1");
	tmap.push_back("0,3,1,1,1,1,1,4,0,3,1,1,1,1,1,1,4,0,3,1,1,2,0,5,1,1,1,1,1,4,0,3,1,1,4,5,1,1,1,1");
	tmap.push_back("0,0,3,1,1,1,1,1,4,0,3,1,1,1,1,1,1,4,0,3,2,0,5,1,1,1,1,1,1,1,4,0,3,1,1,1,1,1,1,2");
	tmap.push_back("0,0,0,3,1,1,1,1,1,4,0,3,1,1,1,1,1,1,4,0,0,5,1,1,1,1,1,1,1,1,2,0,5,1,1,1,1,1,2,0");
	tmap.push_back("0,0,0,0,3,1,1,1,1,2,0,0,3,1,1,1,1,1,1,4,5,1,1,1,1,1,1,1,1,2,0,5,1,1,1,1,1,2,0,0");
	tmap.push_back("4,0,0,0,0,3,1,1,2,0,5,4,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,5,1,1,1,1,1,2,0,0,0");
	tmap.push_back("1,4,0,0,0,0,3,2,0,5,1,1,1,2,3,1,1,1,1,1,1,1,1,2,3,1,1,2,0,5,1,1,1,1,1,2,0,0,0,0");
	tmap.push_back("1,1,4,0,0,0,0,0,5,1,1,1,2,0,5,1,1,1,1,1,1,1,1,4,0,3,2,0,5,1,1,1,1,1,2,0,0,0,0,0");
	tmap.push_back("1,1,1,4,0,0,0,5,1,1,1,2,0,5,1,2,3,2,3,1,1,1,1,1,4,0,0,0,3,1,1,1,1,2,0,0,0,0,0,0");
	tmap.push_back("1,1,1,2,0,0,5,1,1,1,2,0,5,1,2,0,0,0,0,3,1,1,1,1,1,4,0,0,0,3,1,1,2,0,0,0,0,0,0,5");
	tmap.push_back("1,1,2,0,0,5,1,1,1,1,4,0,3,2,0,0,0,0,0,5,1,1,1,1,1,1,4,0,0,0,3,2,0,0,0,0,0,0,5,1");
	tmap.push_back("1,2,0,0,5,1,1,1,1,1,1,4,0,0,0,0,0,0,5,1,2,3,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,5,1,1");
	tmap.push_back("1,4,0,0,3,1,1,1,1,1,1,1,4,0,0,0,0,5,1,2,0,0,3,1,1,2,0,0,5,4,0,0,0,0,0,0,5,1,1,1");
	tmap.push_back("1,1,4,0,0,3,1,1,1,1,1,1,1,4,0,0,5,1,2,0,0,0,0,3,2,0,0,5,1,1,4,0,0,0,0,5,1,1,1,1");
	tmap.push_back("1,1,1,4,0,0,3,1,1,1,1,2,3,1,4,5,1,2,0,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,5,1,1,1,1,1");
	tmap.push_back("1,1,1,1,4,0,0,3,1,1,2,0,0,3,1,1,2,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,4,5,1,1,1,2,3,1");
	tmap.push_back("1,1,1,1,2,0,0,0,3,2,0,0,0,0,3,2,0,0,0,0,0,0,0,0,5,1,2,3,1,1,1,1,1,1,1,1,2,0,0,3");
	tmap.push_back("1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,2,0,0,3,1,1,2,3,1,1,2,0,0,0,0");
	tmap.push_back("1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,2,0,0,0,0,3,2,0,0,3,2,0,0,0,0,0");
	fillbackground(tmap);
}

void towerclass::fillcontents(std::vector<std::string>& tmap)
{
	for (int j = 0; j < 700; j++)
	{
		std::vector<std::string> maprow = split(tmap[j], ',');
		for (int i = 0; i < 40; i++)
		{
			contents[i + vmult[j]] = atoi(maprow[i].c_str());
		}
	}
}

void towerclass::loadmap()
{
	std::vector<std::string> tmap;
	//Loads the map into the array.
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,19,28,28,28,28,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,24,28,28,28,28,22,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,28,28,28,28,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,28,28,28,28,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,0,28,28,0,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,13,23,23,24,28,0,0,17,18,18,19,0,0,28,22,23,23,14,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,22,23,23,24,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,19,0,0,28,28,0,0,17,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,24,0,0,28,28,0,0,22,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,17,18,18,19,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,22,14,13,24,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,22,24,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,19,10,0,28,28,0,11,17,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,24,0,0,28,28,0,0,22,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,19,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,24,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,17,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,22,23,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,19,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,24,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,17,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,22,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,19,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,10,28,28,0,11,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,10,0,28,28,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,28,28,0,11,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,24,0,0,0,28,28,0,0,22,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,11,17,18,18,18,18,19,10,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,22,23,23,23,23,24,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,19,10,0,28,28,0,11,17,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,24,0,0,28,28,0,0,22,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,17,18,18,19,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,22,23,23,24,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,15,18,18,19,28,0,0,0,28,28,0,0,0,28,17,18,18,16,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,0,28,28,0,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,0,28,28,0,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,0,28,28,0,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,0,28,28,0,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,28,28,28,28,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,19,28,28,28,28,17,18,18,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,24,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,17,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,20,12,12,12,12,13,23,23,24,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,20,12,12,12,12,21,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,20,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,20,12,12,12,12,21,0,0,0,0,0,0,0,8,8,0,0,28,28,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,21,28,28,28,20,12,13,23,23,24,0,0,0,0,0,0,8,17,19,0,0,28,28,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("23,23,23,23,23,24,28,28,28,20,12,21,28,28,28,0,0,0,0,0,8,17,16,21,0,0,28,28,22,23,23,23,23,23,23,23,23,23,23,23");
	tmap.push_back("28,28,28,28,28,28,28,28,28,20,12,21,28,28,28,0,0,0,0,8,17,16,12,21,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,28,28,28,28,20,12,21,28,28,28,0,0,0,8,17,16,12,12,21,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,28,28,28,28,20,12,21,28,28,28,0,0,8,17,16,12,12,12,21,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("18,18,18,18,18,18,18,18,18,16,12,21,28,28,28,0,0,17,16,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,7,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,7,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,9,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,22,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,28,28,0,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,28,28,0,28,28,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,28,28,0,28,28,7,22,14,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,28,28,0,28,28,28,7,22,14,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,28,28,0,28,28,28,28,7,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,6,28,28,0,0,28,28,0,28,28,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,15,19,6,28,0,0,17,18,19,28,28,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,15,19,6,0,0,20,12,21,28,28,0,28,28,28,28,28,22,23,23,23,23,14,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,8,0,20,12,21,28,28,0,28,28,28,28,28,28,28,0,0,0,20,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,8,20,12,21,28,28,0,28,28,28,28,28,28,28,0,0,0,20,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,16,12,21,28,28,0,28,28,28,0,0,0,0,0,0,0,22,14,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,0,28,28,28,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,6,28,0,28,28,28,0,0,0,0,0,0,0,0,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,6,0,17,18,18,19,0,0,0,0,0,0,0,22,14,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,8,20,12,12,21,0,0,0,0,0,0,0,28,20,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,16,12,12,21,10,0,0,0,0,0,0,28,22,14,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,10,0,0,0,0,0,28,28,22,14,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,28,28,28,20,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,10,0,0,0,0,28,28,28,20,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,20,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,20,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,10,0,0,0,28,28,28,28,20,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,20,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,10,0,0,0,28,28,28,28,17,16,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,10,0,0,0,28,28,28,28,17,16,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,20,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,24,0,0,0,0,28,28,28,28,17,16,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,0,0,0,28,28,28,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,7,0,0,0,28,28,28,0,0,0,0,28,28,28,28,28,17,16,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,7,28,0,0,0,28,28,28,0,0,0,0,28,28,28,28,28,20,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,7,28,28,0,0,0,28,28,28,0,0,0,0,28,28,28,28,17,16,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,13,24,9,28,28,28,0,0,0,28,28,28,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,9,0,28,28,28,0,0,0,28,28,28,0,0,0,0,28,28,28,17,16,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,28,28,28,0,0,0,28,28,28,0,0,0,0,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,13,23,23,23,24,0,0,28,28,28,0,0,0,28,28,28,0,0,0,17,18,18,18,16,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,28,28,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,28,28,0,0,8,20,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,28,28,0,8,17,16,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,28,28,8,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,28,6,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,6,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,17,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,0,8,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,8,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("23,23,23,23,23,14,12,12,21,28,28,28,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23");
	tmap.push_back("28,28,28,28,28,20,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,20,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,20,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,20,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("18,19,28,28,28,20,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18");
	tmap.push_back("12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("23,24,28,28,28,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23");
	tmap.push_back("7,7,28,28,28,28,28,28,28,28,28,28,28,28,28,28,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28");
	tmap.push_back("28,28,0,0,0,0,0,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28");
	tmap.push_back("28,28,0,0,0,0,0,17,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28");
	tmap.push_back("0,0,0,0,0,0,0,22,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,8,8,8,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,17,18,19,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,22,23,24,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,28,28,28,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,28,28,28,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,28,28,28,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,28,28,28,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,0,0");
	tmap.push_back("0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,19,0,0");
	tmap.push_back("0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,23,24,0,0");
	tmap.push_back("0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0");
	tmap.push_back("0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0");
	tmap.push_back("0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0");
	tmap.push_back("0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,0,0,0,28,28,28,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,19,0,0,0,0,28,28,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,23,24,0,0,0,0,28,28,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,28,28,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,28,28,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,28,28,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,28,28,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,17,18,18,18,18,18,18,19,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,22,23,23,23,23,23,23,24,10,0,0,0,0,0,0,0,0,0,0,28,28,0,0,28,28,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,7,7,7,7,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,28,28,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,28,28,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,28,28,28,28,28,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,17,18,18,18,18,18,18,18,19,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,22,23,23,23,23,23,23,23,24,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,19,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,23,24,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,8,8,8,8,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,17,18,18,19,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,22,23,23,24,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,8,8,8,8,8,8,8,8");
	tmap.push_back("18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,17,18,18,18,18,18,18,18");
	tmap.push_back("12,21,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,22,23,23,23,23,23,14,12");
	tmap.push_back("12,15,18,18,18,18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,28,28,28,28,28,28,20,12");
	tmap.push_back("12,12,12,12,12,12,12,21,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,28,28,28,28,28,28,20,12");
	tmap.push_back("12,12,12,12,12,12,12,15,18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,28,28,28,28,28,28,20,12");
	tmap.push_back("23,23,14,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,28,28,28,28,28,28,22,23");
	tmap.push_back("28,28,20,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,28,28,28,28,28,28");
	tmap.push_back("28,28,22,23,23,23,23,14,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,28,28,20,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,28,28,28,28");
	tmap.push_back("28,28,28,28,28,28,28,20,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,28,28,28,28");
	tmap.push_back("28,28,28,28,28,28,28,20,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,28,28");
	tmap.push_back("28,28,28,28,28,28,28,22,23,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,28,28");
	tmap.push_back("0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
	tmap.push_back("8,8,8,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8");
	tmap.push_back("18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,18");
	tmap.push_back("12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,20,12,12");
	tmap.push_back("12,12,21,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,18,18,18,18,19,0,0,0,0,0,0,0,0,0,0,0,20,12,12");
	tmap.push_back("12,12,21,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,23,23,23,23,23,24,0,0,0,0,0,0,0,0,0,0,0,20,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12");
	tmap.push_back("12,12,21,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12");
	tmap.push_back("12,12,21,6,6,6,6,6,6,28,28,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12");
	tmap.push_back("12,12,15,18,18,18,18,18,19,28,28,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,0,0,8,8,8,8,8,8,20,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,17,18,18,18,18,18,16,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,17,18,16,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,22,23,14,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,15,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,13,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,8,8,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,15,18,19,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,13,23,24,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,8,8,8,8,8,6,6,6,6,6,6,6,6,6,6,6,6,20,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,8,8,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,15,18,19,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,13,23,24,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,8,8,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,17,18,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,13,23,23,23,23,23,14,21,0,0,0,20,12,12,12,13,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,21,9,9,9,9,9,20,21,0,0,0,20,12,12,12,21,9,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,21,0,0,0,0,0,20,21,0,0,0,20,12,12,12,21,0,9,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,21,0,0,0,0,0,20,21,0,0,0,22,23,23,23,24,0,0,9,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,21,0,0,0,0,0,20,21,0,0,0,0,0,0,0,0,0,0,0,9,20,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,14,12");
	tmap.push_back("23,24,0,0,0,0,0,20,21,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,22,23");
	tmap.push_back("0,0,0,0,0,0,0,20,21,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,22,24,0,0,0,0,0,0,0,0,0,0,0,0,22,23,23,23,23,14,12,12,12,12,12,12,21,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,21,0,0,0,0,0,0");
	tmap.push_back("18,18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,15,19,0,0,17,18,18");
	tmap.push_back("12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,13,24,0,0,20,12,12");
	tmap.push_back("12,12,12,15,18,18,18,18,18,18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,21,0,0,0,20,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,21,0,0,0,20,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,21,8,0,0,0,0,0,0,0,0,0,0,0,0,0,22,23,23,23,23,14,12,21,0,0,0,20,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,15,19,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,21,0,0,17,16,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,15,19,8,0,0,17,18,18,18,19,0,0,0,0,0,0,0,0,11,20,12,21,0,0,22,23,23,14");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,8,0,20,12,12,12,21,0,0,0,0,0,0,0,0,11,20,12,21,0,0,0,0,0,20");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,8,20,12,12,12,21,8,8,8,8,0,0,0,0,11,20,12,21,0,0,0,0,0,20");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,16,12,12,12,15,18,18,18,19,10,0,0,0,11,20,12,21,0,0,0,0,0,20");
	tmap.push_back("23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,11,20,12,21,0,0,0,0,0,22");
	tmap.push_back("9,9,9,9,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,11,20,12,21,0,0,0,0,0,9");
	tmap.push_back("0,0,0,0,11,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,11,20,12,21,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,11,20,12,15,18,18,19,0,0,0");
	tmap.push_back("0,0,0,0,0,11,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,11,20,12,12,12,13,24,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,13,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,21,10,0,0,0,11,20,12,12,13,24,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,13,24,9,9,9,9,9,9,9,9,20,12,12,12,12,12,12,21,10,0,0,0,11,20,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,21,10,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,21,10,0,0,0,11,20,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,21,10,0,0,0,0,0,0,0,0,22,23,23,23,23,23,23,24,10,0,0,0,11,20,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,21,10,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,11,20,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,21,10,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,17,16,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,21,10,0,28,28,28,28,28,28,28,28,28,0,0,17,18,18,18,18,18,18,18,16,12,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,17,16,21,10,0,28,28,28,28,28,28,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,17,16,12,21,10,0,28,28,28,28,28,28,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,22,14,12,15,19,8,6,6,6,6,6,6,6,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,22,14,12,15,18,18,18,18,18,18,18,19,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,12,12,21,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,12,12,21,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,12,12,21,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,12,12,21,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,12,12,21,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,12,12,12,12,13,23,23,23,24,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,13,23,23,23,24,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,15,19,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,21,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,15,18,19,0,0");
	tmap.push_back("18,18,19,0,0,0,11,20,12,21,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,13,23,23,23,23,14,12,12,15,18,18");
	tmap.push_back("12,12,21,0,0,0,11,20,12,21,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,12,21,28,28,28,28,22,23,23,23,14,12");
	tmap.push_back("23,23,24,0,0,0,11,20,12,21,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,22,23");
	tmap.push_back("0,0,0,0,0,0,11,20,12,21,28,28,28,28,17,18,18,19,0,0,0,0,20,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,21,28,28,28,28,20,12,12,15,18,18,18,18,16,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,21,28,28,28,28,22,23,23,23,14,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,21,28,28,28,28,28,28,28,28,22,23,23,23,14,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,11,20,12,21,28,28,28,28,28,28,28,28,28,28,0,0,22,23,23,23,14,12,12,21,28,28,28,28,17,18,18,19,0,0");
	tmap.push_back("18,19,0,0,0,0,11,20,12,21,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,21,28,28,28,28,20,12,12,15,18,18");
	tmap.push_back("12,15,18,18,18,18,18,16,12,21,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,21,28,28,28,28,20,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,21,28,28,28,28,22,23,23,23,14,12");
	tmap.push_back("23,23,14,12,12,12,12,12,12,15,18,18,18,19,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,21,28,28,28,28,0,0,0,0,22,23");
	tmap.push_back("0,0,22,23,23,23,14,12,12,12,12,12,12,21,28,28,28,28,6,6,8,8,0,0,0,0,20,12,12,21,28,28,28,28,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,22,23,23,23,14,12,12,21,28,28,28,28,17,18,18,19,0,0,0,0,20,12,12,21,28,28,28,28,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,28,28,22,23,23,24,28,28,28,28,20,12,12,21,0,0,0,0,20,12,12,21,28,28,28,28,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,21,0,0,0,0,20,12,12,21,6,6,6,6,0,0,0,0,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,21,28,28,0,0,20,12,12,15,18,18,18,19,8,8,8,8,0,0");
	tmap.push_back("8,8,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,21,28,28,0,0,20,12,12,12,12,12,12,15,18,18,18,19,8,8");
	tmap.push_back("18,19,8,8,8,8,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,21,28,28,0,0,22,23,23,23,14,12,12,12,12,12,12,15,18,18");
	tmap.push_back("12,15,18,18,18,19,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,21,28,28,0,0,0,0,0,0,22,23,23,23,14,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,15,18,18,18,19,28,28,28,28,28,28,28,28,20,12,12,21,28,28,0,0,0,0,0,0,28,28,28,28,22,23,23,23,14,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,15,18,18,18,19,28,28,28,28,20,12,12,21,28,28,0,0,0,0,0,0,28,28,28,28,28,28,28,28,20,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,16,12,12,21,28,28,0,0,0,0,0,0,0,0,28,28,28,28,28,28,20,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,6,6,8,8,0,0,0,0,0,0,28,28,28,28,28,28,20,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,19,8,8,8,8,0,0,28,28,28,28,28,28,20,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,19,0,0,28,28,28,28,28,28,20,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,19,28,28,28,28,20,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12");
	tmap.push_back("23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,14,21,28,28,28,28,22,23");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,11,20,21,28,28,28,28,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,11,20,21,28,28,28,28,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,11,20,21,28,28,28,28,0,0");
	tmap.push_back("0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,11,20,21,28,28,28,28,0,0");
	tmap.push_back("18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,28,28,0,0,11,20,15,18,18,18,18,18,18");
	tmap.push_back("12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,28,28,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,21,10,0,0,0,0,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,21,10,0,0,0,0,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,22,23,23,23,23,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,24,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,17,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,22,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,22,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,23,23,14,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,13,23,23,23,23,23,23,23,23,23,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,6,6,6,6,6,6,6,6,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,17,18,18,18,18,18,18,18,18,18,19,0,0,0,0,0,0,17,18,18,19,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,22,23,23,24,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,13,23,23,23,23,23,23,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,17,18,16,12,12,12,12,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,22,23,23,23,23,23,14,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,6,6,6,6,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,17,18,18,19,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,22,23,23,24,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12");
	tmap.push_back("12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12");
	tmap.push_back("12,21,28,28,28,28,22,23,24,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,17,18,19,0,0,0,20,12,12,12");
	tmap.push_back("12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,22,23,24,0,0,0,20,12,12,12");
	tmap.push_back("12,21,28,28,28,28,28,28,28,28,28,28,28,17,19,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,20,12,12,12");
	tmap.push_back("12,21,28,28,28,28,28,28,28,28,28,28,28,20,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,20,12,12,12");
	tmap.push_back("12,15,18,18,18,18,18,18,18,18,18,18,18,16,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,6,6,6,6,6,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,19,28,28,28,28,28,17,19,28,28,28,28,28,28,28,0,0,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,6,6,6,6,6,20,21,28,28,28,28,28,28,28,0,0,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,16,21,28,28,28,28,28,28,28,0,0,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,17,18,18,18,18,18,16,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,22,23,14,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,20,12,12,12,12,12,12,12");
	tmap.push_back("23,23,23,23,23,14,13,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,22,14,13,23,23,23,23,23");
	tmap.push_back("28,28,28,28,28,22,24,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,22,24,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,7,7,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,7,7,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28");
	tmap.push_back("18,18,18,18,18,18,18,18,19,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,22,23,23,23,23,23,14,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,14,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,22,24,28,28,28,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,7,7,28,28,28,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,6,6,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,28,28,28,28,28,17,19,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,15,18,18,18,18,18,16,15,18,18,18,18,18,18,19,10,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,10,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,10,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,11,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,17,18,18,18,16,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,10,0,0,0,0,0,22,23,23,23,14,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,13,23,23,23,14,12,13,23,23,23,23,23,23,23,23,23,24,10,0,0,0,0,0,0,0,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,13,24,9,9,9,20,12,21,7,7,7,7,7,7,7,7,9,9,0,0,0,0,0,0,0,0,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,22,23,24,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,22,23,23,23,23,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,22,14,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,10,0,0,0,17,18,19,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,15,19,8,8,8,20,12,21,6,6,6,6,6,6,6,6,8,8,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,15,18,18,18,16,12,15,18,18,18,18,18,18,18,18,18,19,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,24,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,24,7,7,7,7,7,9,9,9,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,13,24,0,0,0,0,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,17,16,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,17,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,28,6,6,6,6,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,28,17,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,28,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,15,19,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,22,23,23,23,23,14,13,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,28,28,20,21,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,28,28,22,24,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,14,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,15,18,18,18,18,19,0,0,0,0,0,0,0,0,0,0,17,19,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,20,21,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,16,21,0,0,0,0,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,0,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,0,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,0,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,22,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,22,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,22,23,23,23,14,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,15,18,18,18,19,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,19,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,19,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,14,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,22,23,23,14,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,22,23,23,14,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,28,28,28,28,28,28,28,22,23,23,24,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("23,23,23,23,23,14,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,20,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,22,23,23,23,23,23,24,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12");
	tmap.push_back("18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");
	tmap.push_back("12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12");

	fillcontents(tmap);
}
