#! /usr/bin/env python
# -*- coding: utf-8 -*-

from manipulation import *

M = Schrift("UnifrakturMaguntia21", "UnifrakturMaguntia.sfdir")

M.PUA_durch_Verknuepfungen_ersetzen()

M.ersetzen("longs", "s.noswash")

for glyph in M.glyphs():
	# Moderne Varianten zum Standard machen:
	if glyph.endswith(".modern"):
		M.ersetzen(glyph[:-7], glyph)
	
	# Glyphen löschen, die nur über nicht-automatische Features erreicht werden können:
	elif (
				(glyph.endswith(".alt") and glyph!="c.alt")
				or glyph.endswith(".alt2")
				or glyph.endswith(".swash")
				or glyph.endswith(".upper")
				or glyph.endswith(".long")
				or glyph.endswith(".hist")
				or glyph.endswith(".modern2")
				or glyph.startswith("longs_")
			):
		M.loeschen(glyph)

# Kontextuelles s ohne Schwung im Wortinnern standardmäßig aktivieren.
M.feature_aendern("'cv20' Swashless s", "cv20", "liga")

# Sonstige Glyphen löschen, die nur für historische Zwecke benötigt werden
M.loeschen("Aslash")
M.loeschen("aslash")
M.loeschen("longsslash")
M.loeschen("rrot")
M.loeschen("r.round")
M.loeschen("e_t")
M.loeschen("Gslash")
M.loeschen("gslash")
M.loeschen("Kslash")
M.loeschen("kslash")
M.loeschen("Nslash")
M.loeschen("nslash")
M.loeschen("Rslash")
M.loeschen("rslash")
M.loeschen("Sslash")
M.loeschen("sslash")
M.loeschen("wstroke")
M.loeschen("Wstroke")
M.loeschen("m_macroncomb")
M.loeschen("n_macroncomb")
M.loeschen("Z_macroncomb")
M.loeschen("z_macroncomb")
M.loeschen("Odieresis_gravecomb")
M.loeschen("odieresis_gravecomb")
M.loeschen("Udieresisgrave")
M.loeschen("udieresisgrave")
M.loeschen("b_acutecomb")
M.loeschen("h_acutecomb")
M.loeschen("u_dotcomb")
M.loeschen("l_dotcomb")
M.loeschen("r_tildecomb")
M.loeschen("z_tildecomb")
M.loeschen("a_dotcomb_dotcomb")
M.loeschen("lslash_lslash")
M.loeschen("longsslash_longsslash")
M.loeschen("Bdotaccent")
M.loeschen("bdotaccent")
M.loeschen("kacute")
M.loeschen("macute")
M.loeschen("mdotaccent")
M.loeschen("Mdotaccent")
M.loeschen("Ndotaccent")
M.loeschen("ndotaccent")
M.loeschen("pacute")
M.loeschen("Pdotaccent")
M.loeschen("pdotaccent")
M.loeschen("Rdotaccent")
M.loeschen("rdotaccent")
M.loeschen("sdotaccent")
M.loeschen("Wdotaccent")
M.loeschen("wdotaccent")
M.loeschen("adotaccent")
M.loeschen("odotaccent")
M.loeschen("ydotaccent")
M.loeschen("etilde")
M.loeschen("Sdotaccent")
M.loeschen("Gcaron")
M.loeschen("gcaron")
M.loeschen("s_dieresiscomb")
#M.loeschen("uniFB05")

# Nicht-automatisch aktive Features löschen

M.feature_loeschen("'cv16' Alternate sdieresis composition")
M.feature_loeschen("'aalt' Access All Alternates")
M.feature_loeschen("'pnum' Proportional Numbers")
M.feature_loeschen("'tnum' Tabular Numbers")
M.feature_loeschen("'onum' Lowercase Numbers")
M.feature_loeschen("'lnum' Uppercase Numbers")
M.feature_loeschen("'ss01' Modern variants")
M.feature_loeschen("'ss02' Uvu to Vuv")
M.feature_loeschen("'ss03' Iji to Jij")
M.feature_loeschen("'cv00/40' No long s")
M.feature_loeschen("'cv01' Modern k")
M.feature_loeschen("'cv02' Modern x")
M.feature_loeschen("'cv03' Modern y")
M.feature_loeschen("'cv04' Modern A")
M.feature_loeschen("'cv05' Modern G")
M.feature_loeschen("'cv06' Modern K")
M.feature_loeschen("'cv07' Modern N")
M.feature_loeschen("'cv08' Modern S")
M.feature_loeschen("'cv09' Modern V")
M.feature_loeschen("'cv10' Modern Y")
M.feature_loeschen("'cv11' long s")
M.feature_loeschen("'cv12' rrotunda")
M.feature_loeschen("'xxxx' Historical variants")
M.feature_loeschen("'cv13' I to J")
M.feature_loeschen("'cv14' Ae, Oe, Ue")
M.feature_loeschen("'cv15' a^e, o^e, u^e")
M.feature_loeschen("'cv16' s diacritcs with swash")
M.feature_loeschen("'cv17' s diacritics with long s")
M.feature_loeschen("'cv18' Alternative d and t with caron")
M.feature_loeschen("'cv19' en dash to em dash")
M.feature_loeschen("'cv21' sacute alternates")
M.feature_loeschen("'cv22' scircumflex alternates")
M.feature_loeschen("'cv23' scaron alternates")
M.feature_loeschen("'cv24' sdotaccent alternate")
M.feature_loeschen("'cv25' sdiaeresis alternate")
M.feature_loeschen("'cv26' Alternative d with caron")
M.feature_loeschen("'cv27' Alternative t with caron")
M.feature_loeschen("'cv28' Double lslash and longsslash ligatures")
M.feature_loeschen("'hlig' etc to et-rrot")
M.feature_loeschen("'xxxx' et to rrot")
M.feature_loeschen("'dlig' Double m/n to m/n with macron")
M.feature_loeschen("'calt' Plan B for contextuals 1")
M.feature_loeschen("'calt' Plan B for contextuals 2")
M.feature_loeschen("'xxxx' hist to non-hist")
M.feature_loeschen("'xxxx' Round r and long s")


M.props_schliessen()
