#pragma once

#include "util.h"

#define PHD_ONE 0x10000
#define PHD_DEGREE (PHD_ONE / 360) // = 182
#define PHD_360 (PHD_ONE) // = 65536 = 0x10000
#define PHD_180 (PHD_ONE / 2) // = 32768 = 0x8000
#define PHD_90 (PHD_ONE / 4) // = 16384 = 0x4000
#define PHD_45 (PHD_ONE / 8) // = 8192 = 0x2000
#define PHD_135 (PHD_45 * 3) // = 24576 = 0x6000

#define MIN_TEXT_SCALE 0.5
#define MAX_TEXT_SCALE 2.0
#define MIN_BAR_SCALE 0.5
#define MAX_BAR_SCALE 1.5
#define DEFAULT_UI_SCALE 1.0

#define MIN_BRIGHTNESS 0.1f
#define MAX_BRIGHTNESS 2.0f
#define DEFAULT_BRIGHTNESS 1.0f

#define LOGIC_FPS 30

#define MAX_MATRICES 40
#define MAX_NESTED_MATRICES 32
#define MAX_REQLINES 18
#define MAX_SAMPLES 256
#define MAX_LEVEL_NAME_LENGTH 48
#define NUM_SLOTS 32
#define MAX_FRAMES 10
#define MAX_CD_TRACKS 64
#define MAX_TEXTURES 8192
#define MAX_TEXTPAGES 128
#define MAX_SPRITES 512
#define MAX_FLIP_MAPS 10
#define MAX_ROOMS_TO_DRAW 100
#define DEMO_COUNT_MAX 9000
#define MAX_ITEMS 10240
#define MAX_SECRETS 16
#define GRAVITY 6
#define FASTFALL_SPEED 128
#define LARA_HITPOINTS 1000
#define LARA_AIR 1800
#define LARA_TURN_UNDO (2 * PHD_DEGREE) // = 364
#define LARA_TURN_RATE ((PHD_DEGREE / 4) + LARA_TURN_UNDO) // = 409
#define LARA_SLOW_TURN ((PHD_DEGREE * 2) + LARA_TURN_UNDO) // = 728
#define LARA_JUMP_TURN ((PHD_DEGREE * 1) + LARA_TURN_UNDO) // = 546
#define LARA_MED_TURN ((PHD_DEGREE * 4) + LARA_TURN_UNDO) // = 1092
#define LARA_FAST_TURN ((PHD_DEGREE * 6) + LARA_TURN_UNDO) // = 1456
#define LARA_LEAN_UNDO PHD_DEGREE
#define LARA_DEF_ADD_EDGE (5 * PHD_DEGREE) // = 910
#define LARA_LEAN_RATE 273
#define LARA_LEAN_MAX ((10 * PHD_DEGREE) + LARA_LEAN_UNDO) // = 2002
#define LARA_LEAN_MAX_UW (LARA_LEAN_MAX * 2)
#define LARA_FASTFALL_SPEED (FASTFALL_SPEED + 3) // = 131
#define LARA_SWING_FASTFALL_SPEED (LARA_FASTFALL_SPEED + 2) // = 133
#define LARA_RAD 100 // global radius of g_Lara
#define LARA_HEIGHT 762 // global height of g_Lara - less than 3/4 block
#define UW_MAXSPEED 200
#define UW_RADIUS 300
#define UW_HEIGHT 400
#define UW_WALLDEFLECT (2 * PHD_DEGREE) // = 364
#define SURF_MAXSPEED 60
#define SURF_RADIUS 100
#define SURF_HEIGHT 700
#define WATER_FRICTION 6
#define DAMAGE_START 140
#define DAMAGE_LENGTH 14
#define NO_ITEM (-1)
#define NO_CAMERA (-1)
#define PELLET_SCATTER (20 * PHD_DEGREE)
#define NUM_SG_SHELLS 2
#define GUN_AMMO_CLIP 16
#define MAGNUM_AMMO_CLIP 25
#define UZI_AMMO_CLIP 50
#define SHOTGUN_AMMO_CLIP 6
#define GUN_AMMO_QTY (GUN_AMMO_CLIP * 2)
#define MAGNUM_AMMO_QTY (MAGNUM_AMMO_CLIP * 2)
#define UZI_AMMO_QTY (UZI_AMMO_CLIP * 2)
#define SHOTGUN_AMMO_QTY (SHOTGUN_AMMO_CLIP * NUM_SG_SHELLS)
#define NUM_EFFECTS 1000
#define DEATH_WAIT (10 * LOGIC_FPS)
#define DEATH_WAIT_MIN (2 * LOGIC_FPS)
#define MAX_HEAD_ROTATION (50 * PHD_DEGREE) // = 9100
#define MAX_HEAD_TILT_LOOK (22 * PHD_DEGREE) // = 4004
#define MIN_HEAD_TILT_LOOK (-42 * PHD_DEGREE) // = -7644
#define MAX_HEAD_TILT_CAM (85 * PHD_DEGREE) // = 15470
#define MIN_HEAD_TILT_CAM (-85 * PHD_DEGREE) // = 15470
#define HEAD_TURN (4 * PHD_DEGREE) // = 728
#define HEAD_TURN_SURF (3 * PHD_DEGREE) // = 546
#define MAX_HEAD_ROTATION_SURF (50 * PHD_DEGREE) // = 9100
#define MAX_HEAD_TILT_SURF (40 * PHD_DEGREE) // = 7280
#define MIN_HEAD_TILT_SURF (-40 * PHD_DEGREE) // = -7280
#define DIVE_WAIT 10
#define WALL_L 1024
#define WALL_SHIFT 10
#define STEP_L 256
#define NO_ROOM 0xFF
#define STEPUP_HEIGHT ((STEP_L * 3) / 2) // = 384
#define FRONT_ARC PHD_90
#define MAX_HEAD_CHANGE (PHD_DEGREE * 5) // = 910
#define MAX_TILT (PHD_DEGREE * 3) // = 546
#define CAM_A_HANG 0
#define CAM_E_HANG (-60 * PHD_DEGREE) // = -10920
#define W2V_SHIFT 14
#define W2V_SCALE (1 << W2V_SHIFT)
#define FOLLOW_CENTRE 1
#define NO_CHUNKY 2
#define CHASE_OBJECT 3
#define LOOK_SPEED 4
#define COMBAT_SPEED 8
#define CHASE_SPEED 12
#define MOVE_ANG (2 * PHD_DEGREE) // = 364
#define COMBAT_DISTANCE (WALL_L * 5 / 2) // = 2560
#define MAX_ELEVATION (85 * PHD_DEGREE) // = 15470
#define DEFAULT_RADIUS 10
#define DONT_TARGET (-16384)
#define UNIT_SHADOW 256
#define NO_HEIGHT (-32512)
#define NO_BAD_POS (-NO_HEIGHT)
#define NO_BAD_NEG NO_HEIGHT
#define BAD_JUMP_CEILING ((STEP_L * 3) / 4) // = 192
#define WIBBLE_SIZE 32
#define MAX_WIBBLE 2
#define MAX_SHADE 0x300
#define MAX_EXPANSION 5
#define NO_BOX (-1)
#define BOX_NUMBER 0x7FFF
#define BLOCKABLE 0x8000
#define BLOCKED 0x4000
#define OVERLAP_INDEX 0x3FFF
#define SEARCH_NUMBER 0x7FFF
#define BLOCKED_SEARCH 0x8000
#define CLIP_LEFT 1
#define CLIP_RIGHT 2
#define CLIP_TOP 4
#define CLIP_BOTTOM 8
#define ALL_CLIP (CLIP_LEFT | CLIP_RIGHT | CLIP_TOP | CLIP_BOTTOM)
#define SECONDARY_CLIP 16
#define STALK_DIST (WALL_L * 3) // = 3072
#define TARGET_DIST (WALL_L * 4) // = 4096
#define ESCAPE_DIST (WALL_L * 5) // = 5120
#define ATTACK_RANGE SQUARE(WALL_L * 3) // = 9437184
#define ESCAPE_CHANCE 2048
#define RECOVER_CHANCE 256
#define PASSPORT_FOV 65
#define PICKUPS_FOV 65

#define PASS_MESH (PFRONT | PSPINE | PBACK)

#define BIFF (WALL_L >> 1)

#define SLOPE_DIF 60
#define VAULT_ANGLE (30 * PHD_DEGREE)
#define HANG_ANGLE (35 * PHD_DEGREE)
#define END_BIT 0x8000
#define DATA_TYPE 0x00FF
#define VALUE_BITS 0x03FF
#define TRIG_BITS(T) ((T & 0x3C00) >> 10)
#define TRIG_TYPE(T) ((T & 0x3F00) >> 8)

#define MIN_SQUARE SQUARE(WALL_L / 4) // = 65536
#define GROUND_SHIFT (STEP_L)

#define DEFAULT_RADIUS 10

#define OPEN_FRAMES (64 / 2)
#define CLOSE_FRAMES (64 / 2)
#define RINGSWITCH_FRAMES (96 / 2)
#define SELECTING_FRAMES (32 / 2)
#define ROTATE_DURATION (48 / 2)
#define OPEN_ROTATION (-0x8000) // = -32768
#define CLOSE_ROTATION (-0x8000) // = -32768
#define OPTION_RING_OBJECTS 4
#define TITLE_RING_OBJECTS 5
#define RING_RADIUS 688
#define CAMERA_STARTHEIGHT (-0x600) // = -1536
#define CAMERA_YOFFSET (-96)
#define CAMERA_HEIGHT (-0x100) // = -256
#define CAMERA_2_RING 598
#define LOW_LIGHT 0x1400 // = 5120
#define HIGH_LIGHT 0x1000 // = 4096

#define PAGE_WIDTH 256
#define PAGE_HEIGHT 256
#define PAGE_SIZE (PAGE_WIDTH * PAGE_HEIGHT)

#if _MSC_VER > 0x500
    #define strdup _strdup // fixes error about POSIX function
#endif
