/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef MAINSYNTH
#define MAINSYNTH

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.H>
#include <strstream>
#include "GUI/OscillatorGUI.h"
#include "GUI/EnvelopeGUI.h"
#include "GUI/FilterGUI.h"
#include "GUI/MixerGUI.h"
#include "GUI/DelayGUI.h"
#include "GUI/OutputGUI.h"
#include "GUI/ScopeGUI.h"
#include "GUI/PatchBankGUI.h"
#include "GUI/RouteGUI.h"
#include "SpiralSound/Amp.h"
#include "SpiralSound/Midi.h"
#include "SpiralSound/SpiralInfo.h"

const int NUM_PATCHES=100;
const int PATCH_STRINGSIZE=1024;

class Synth
{
public:
	Synth();
	~Synth();
	
	Fl_Window *CreateWindow();
	void       DoIdle();
	
	Fl_Window 	  *Window;
	
private:
	
	void Trigger(int note, float vol);
	void UnTrigger(int note);
	void PitchBend(int amount);
	void ChangeParameter(int CC,int amount);

	int m_Oct;
	int m_CurrentVoice;
	
	// list of keys currently pressed down
	char *m_KeyVoice;
	
	// list of notes being played by each voice
	int *m_VoiceNote;

	// These buffers require malloc'ing
	Sample m_Databuf;
	Sample m_Databuf2;
	Sample m_Databuf3;
	Sample m_OscControlbuf1;
	Sample m_OscControlbuf2;
	Sample m_OscControlbuf3;
	Sample m_EnvControlbuf;
    Sample m_LFOControlbuf;
	Sample m_BothControlbuf;
	
	// One per voice needed
	Sample *m_XModbuf1;
	Sample *m_XModbuf2;
	
	Oscillator	  m_Osc1;
	OscillatorGUI m_Osc1GUI;
	Oscillator	  m_Osc2;
	OscillatorGUI m_Osc2GUI;
	Oscillator	  m_Osc3;
	OscillatorGUI m_Osc3GUI;
	Envelope	  m_Env1;
	EnvelopeGUI   m_Env1GUI;
	Amp			  m_OscAmp1;
	Envelope	  m_Env2;
	EnvelopeGUI   m_Env2GUI;
	Amp		      m_OscAmp2;
	Envelope	  m_Env3;
	EnvelopeGUI   m_Env3GUI;
	Amp			  m_OscAmp3;
	Filter		  m_Filter;
	FilterGUI     m_FilterGUI;
	Mixer		  m_Mixer;
	MixerGUI      m_MixerGUI;
	Mixer		  m_Mixer2;
	MixerGUI      m_Mixer2GUI;
	Delay		  m_Delay;
	DelayGUI      m_DelayGUI;
	Envelope	  m_FilterEnv;
	EnvelopeGUI   m_FilterEnvGUI;
	Oscillator	  m_LFO;
	LFOGUI 		  m_LFOGUI;
	RouteGUI 	  m_LFORouteGUI;
	RouteGUI 	  m_EnvRouteGUI;
	PatchBankGUI  m_PatchBank;	
	OutputGUI     m_OutGUI;
	ScopeGUI	  m_Scope;
	
	MidiEvent m_CurrentEvent;

	int m_CurrentPatch;
	
	void SavePatch(int n);
	void LoadPatch(int n);
		
	void WritePatch(int n, char *in);
	int  ReadPatch(int n, char *out);
	
	void Randomise();
	
	void UpdateValues();

	void Route();
	
	friend istream &operator>>(istream &s, Synth &o);
	friend ostream &operator<<(ostream &s, Synth &o);

	
};

istream &operator>>(istream &s, Synth &o);
ostream &operator<<(ostream &s, Synth &o);

#endif
