/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <sys/types.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#if defined (__FreeBSD__)
	#include <machine/soundcard.h>
#else
#if defined (__NetBSD__) || defined (__OpenBSD__)
	#include <soundcard.h>            /* OSS emulation */
#undef ioctl
#else 	                              /* BSDI, Linux, Solaris */
	#include <sys/soundcard.h>
#endif                                /* __NetBSD__ or __OpenBSD__ */
#endif                                /* __FreeBSD__ */
#include <sys/ioctl.h>
#include <limits.h>

#include "Sample.h"
#include "SpiralInfo.h"
#include "RiffWav.h"

#ifndef SOUND_MANAGER
#define SOUND_MANAGER


class OSSOutput
{
public:
	static OSSOutput *Get()       { if(!m_Singleton) m_Singleton=new OSSOutput; return m_Singleton; }
	static void PackUpAndGoHome() { if(m_Singleton)  { delete m_Singleton; m_Singleton=NULL; } }
	~OSSOutput(); 
	
	void    AllocateBuffer();
	void    SendStereo(const Sample *ldata,const Sample *rdata);
	void    GetStereo(Sample *ldata,Sample *rdata);
	void    SetVolume(float s) {m_Amp=s;}
	void    SetNumChannels(int s) {m_Channels=s;}
	float   GetVolume() {return m_Amp;}
	void    Play();
	void    Read();
	void    WavOpen(char* name) {m_Wav.Open(name,WavFile::WRITE, WavFile::STEREO);}
	void    WavClose() {m_Wav.Close();}
	short  *GetBuffer() {return m_Buffer[m_WriteBufferNum];}
	
	void 	OpenReadWrite();
	void    OpenWrite();
	void    OpenRead();
	void    Close();
	
private:
	static OSSOutput* m_Singleton;

 	OSSOutput(); 
	
	short  *m_Buffer[2];
	short  *m_InBuffer[2];
	int     m_BufSizeBytes;
	int     m_Dspfd;
	float   m_Amp;
	int     m_Channels;
	WavFile m_Wav;
	int    	m_ReadBufferNum;
	int     m_WriteBufferNum;
	bool    m_OutputOk;
};

#endif
