/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <math.h>
#include "NoteTable.h"
#include "SpiralInfo.h"
#include "Sample.h"

#ifndef ENV
#define ENV


class Envelope
{
public:
	Envelope();
	~Envelope();

	void Execute(int V, Sample &data);
	
	void Trigger(int V) {m_t[V]=0.0f; m_Trigger[V]=true;}
	void UnTrigger(int V) {m_Trigger[V]=false;}
	void Zero(short *data);
	void SetAttack(float s) {m_Attack=s;}
	void SetDecay(float s) {m_Decay=s;}	
	void SetSustain(float s) {m_Sustain=s;}	
	void SetRelease(float s) {m_Release=s;}	
	void SetVolume(float s) {m_Volume=s;}	
	float GetAttack() {return m_Attack;}
	float GetDecay() {return m_Decay;}	
	float GetSustain() {return m_Sustain;}	
	float GetRelease() {return m_Release;}	
	float GetVolume() {return m_Volume;}	
	void Randomise();
	
	bool IsOperating(int V) { return ((m_t[V]>=0)&&(m_t[V]<=m_Attack+m_Decay+m_Release+1)); }

private:
	
	// Voice specific parameters
	bool  *m_Trigger;
	double *m_t;
	
	// Common voice parameters
	float m_Attack;
	float m_Decay;
	float m_Sustain;
	float m_Release;
	float m_Volume;
	double m_SampleTime;
	
	friend istream &operator>>(istream &s, Envelope &o);
	friend ostream &operator<<(ostream &s, Envelope &o);
};

istream &operator>>(istream &s, Envelope &o);
ostream &operator<<(ostream &s, Envelope &o);

#endif
