/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Group.H>
#include "Widgets/Fl_Knob.H"
#include <FL/Fl_Button.H>
#include "Widgets/Fl_PawfalSlider.H"

#include "GUIBase.h"
#include "../SpiralSound/Output.h"

#ifndef ROUTEGUI
#define ROUTEGUI

class RouteGUI : public GUIBase
{
public:
	enum ROUTE
	{
		OSC1FREQ = 0x0001,
		OSC1PW   = 0x0002,
		OSC2FREQ = 0x0004,
		OSC2PW   = 0x0008,
		FILTERC  = 0x0010,
		FILTERR  = 0x0020,
		LAST = FILTERR
	};


	RouteGUI();
	
	virtual void CreateGUI(int xoff, int yoff, char *name);	
	virtual void UpdateValues();
	int GetOutput() {return m_Button;}
	bool Query(ROUTE r) {return (r & m_Button);}
	void Randomise();

private:

	int m_Button;

	Fl_Group *m_RoutingGroup;

	Fl_Button *m_Osc1Freq;
	Fl_Button *m_Osc1PW;
	Fl_Button *m_Osc2Freq;
	Fl_Button *m_Osc2PW;
	Fl_Button *m_FilterC;
	Fl_Button *m_FilterR;
		
	//// Callbacks ////
	inline void cb_Osc1Freq_i(Fl_Knob* o, void* v);
	static void cb_Osc1Freq(Fl_Knob* o, void* v); 
	inline void cb_Osc1PW_i(Fl_Knob* o, void* v); 
	static void cb_Osc1PW(Fl_Knob* o, void* v); 
	inline void cb_Osc2Freq_i(Fl_Knob* o, void* v); 
	static void cb_Osc2Freq(Fl_Knob* o, void* v); 
	inline void cb_Osc2PW_i(Fl_Knob* o, void* v); 
	static void cb_Osc2PW(Fl_Knob* o, void* v); 
	inline void cb_FilterC_i(Fl_Knob* o, void* v); 
	static void cb_FilterC(Fl_Knob* o, void* v); 
	inline void cb_FilterR_i(Fl_Knob* o, void* v); 
	static void cb_FilterR(Fl_Knob* o, void* v); 
	
	friend istream &operator>>(istream &s, RouteGUI &o);
	friend ostream &operator<<(ostream &s, RouteGUI &o);
};

istream &operator>>(istream &s, RouteGUI &o);
ostream &operator<<(ostream &s, RouteGUI &o);

#endif
