/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "PatchBankGUI.h"
#include "../SpiralSound/Output.h"

PatchBankGUI::PatchBankGUI() : m_CurrentPatch(0)
{
	// bit of a hack
	for (int n=0; n<NPSEL; n++)
		m_PatchList[n]=n;
}
		
void PatchBankGUI::CreateGUI(int xoff, int yoff, char *name)
{
	 Fl_Group* o = GUIPatchBankGroup = new Fl_Group(xoff, yoff, 755, 40, name);
      o->type(1);
	  o->box(FL_UP_BOX);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
	  o->user_data((void*)(this));
       	  
	  for(int n=0; n<NPSEL; n++)
	  {
		 Patch[n] = new Fl_Button(85+xoff+(31*n), 5+yoff, 29, 29);
     	 Patch[n]->type(0);
		 Patch[n]->color(SpiralInfo::GUI_COLOUR+(n%5-2));
      	 Patch[n]->selection_color(SpiralInfo::GUI_COLOUR);		 
	  	 Patch[n]->callback((Fl_Callback*)cb_Patch,(void*)&m_PatchList[n]);
	  }
	  
	  Num = new Fl_Value_Output(xoff+5, yoff+18, 25, 20);
      Num->value(0);   
	  
  	  Select = new Fl_Knob(xoff+708, yoff+1, 37, 37);
      Select->color(SpiralInfo::GUI_COLOUR);
	  Select->type(Fl_Knob::LINELIN);
	  Select->cursor(50);
      Select->labelsize(10);
      Select->maximum(4);
      Select->step(1);
      Select->value(0);
	  Select->scaleticks(5);   
	  Select->callback((Fl_Callback*)cb_Select);
	  
	  Save = new Fl_Button(35+xoff, 18+yoff, 40, 10, "Save");
      Save->type(1);
      Save->labelsize(10);
      Save->selection_color(SpiralInfo::GUI_COLOUR);		 
	  Save->callback((Fl_Callback*)cb_Save);
	 
	  Rand = new Fl_Button(35+xoff, 28+yoff, 40, 10, "Rand");
      Rand->labelsize(10);
      Rand->selection_color(SpiralInfo::GUI_COLOUR);		 
	  Rand->callback((Fl_Callback*)cb_Rand);
	 
      o->end();
    
}

int PatchBankGUI::GetOutput()
{
	static int Last=-1;
	
	if (Last!=m_CurrentPatch)
	{
		Last=m_CurrentPatch;
		if (m_CurrentPatch>-1) Num->value(m_CurrentPatch);
		int t=m_CurrentPatch;
		if (m_CurrentPatch==-2) m_CurrentPatch=-1;
		return t;		
	}
	
	return -1;
}
	
bool PatchBankGUI::IsSaving()
{
	int t=Save->value();
	if (t) 
	{
		Save->value(0);
	}
	return t;
}
	
//// Callbacks ////

inline void PatchBankGUI::cb_Patch_i(Fl_Button* o, void* v)
{ m_CurrentPatch=(*(int*)(v))+(int)(Select->value()*20); }
void PatchBankGUI::cb_Patch(Fl_Button* o, void* v)
{ ((PatchBankGUI*)(o->parent()->user_data()))->cb_Patch_i(o,v); }

inline void PatchBankGUI::cb_Select_i(Fl_Knob* o, void* v)
{}
void PatchBankGUI::cb_Select(Fl_Knob* o, void* v)
{ ((PatchBankGUI*)(o->parent()->user_data()))->cb_Select_i(o,v); }

inline void PatchBankGUI::cb_Save_i(Fl_Button* o, void* v)
{m_CurrentPatch=-1;}
void PatchBankGUI::cb_Save(Fl_Button* o, void* v)
{ ((PatchBankGUI*)(o->parent()->user_data()))->cb_Save_i(o,v); }

inline void PatchBankGUI::cb_Rand_i(Fl_Button* o, void* v)
{m_CurrentPatch=-2;}
void PatchBankGUI::cb_Rand(Fl_Button* o, void* v)
{ ((PatchBankGUI*)(o->parent()->user_data()))->cb_Rand_i(o,v); }
