/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Check_Button.H>
#include "Widgets/Fl_Knob.H"

#include "GUIBase.h"
#include "../SpiralSound/Output.h"

#ifndef OUTGUI
#define OUTGUI

class OutputGUI : public GUIBase
{
public:
	OutputGUI(OSSOutput *o);
	
	virtual void CreateGUI(int xoff=0, int yoff=0, char *name="");	
	virtual void UpdateValues();

	OSSOutput *m_out;	
	
private:

	Fl_Group 		*GUIMixGroup;	
	Fl_Knob 		*Volume;
	Fl_Button		*Record;
		
	//// Callbacks ////
	
	inline void cb_Volume_i(Fl_Knob* o, void* v);
    static void cb_Volume(Fl_Knob*, void*);
	inline void cb_Record_i(Fl_Button* o, void* v);
	static void cb_Record(Fl_Button* o, void* v);

};

#endif
