/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "OutputGUI.h"

#include <FL/fl_file_chooser.h>

OutputGUI::OutputGUI(OSSOutput *o)
{
	m_out=o;
	if (!m_out) cerr<<"WARNING: Output not correctly set up"<<endl;
}
		
void OutputGUI::CreateGUI(int xoff=0, int yoff=0, char *name)
{
	 Fl_Group* o = GUIMixGroup = new Fl_Group(xoff, yoff, 85, 110, name);
      o->type(1);
	  o->box(FL_UP_BOX);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
	  o->user_data((void*)(this));
       	  
	  Volume = new Fl_Knob(xoff+20, yoff+22, 40, 40, "Volume");
      Volume->color(SpiralInfo::GUI_COLOUR);
	  Volume->type(Fl_Knob::DOTLIN);
      Volume->labelsize(10);
      Volume->maximum(1);
      Volume->step(0.001);
      Volume->value(0.5);   
	  Volume->callback((Fl_Callback*)cb_Volume);

	  Record = new Fl_Button(xoff+20, yoff+80, 40, 25, "Record");
      Record->type(1);
      Record->down_box(FL_DOWN_BOX);
      Record->labelsize(10);
      Record->callback((Fl_Callback*)cb_Record);   
	 
      o->end();
    
}

void OutputGUI::UpdateValues()
{
	Volume->value(m_out->GetVolume());
}

//// Callbacks ////

inline void OutputGUI::cb_Volume_i(Fl_Knob* o, void* v)
{ m_out->SetVolume(o->value()); }
void OutputGUI::cb_Volume(Fl_Knob* o, void* v)
{ ((OutputGUI*)(o->parent()->user_data()))->cb_Volume_i(o,v); }

inline void OutputGUI::cb_Record_i(Fl_Button* o, void* v)
{ 
	if (o->value())
	{
		char *fn=fl_file_chooser("Pick a Wav file to save to", "*.wav", NULL);
		
		if (fn && fn!="")
		{
			m_out->WavOpen(fn);
		}
		else
		{
			m_out->WavClose();
			o->value(false);
		}
	}
	else
	{
		m_out->WavClose();
	}
}
void OutputGUI::cb_Record(Fl_Button* o, void* v)
{ ((OutputGUI*)(o->parent()->user_data()))->cb_Record_i(o,v); }
