/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "EnvelopeGUI.h"

static const float TIMED_SLIDER_MAX = 3.0f;

EnvelopeGUI::EnvelopeGUI(Envelope *o)
{
	m_env=o;
	if (!m_env) cerr<<"WARNING: Envelope not correctly set up"<<endl;
}
		
void EnvelopeGUI::CreateGUI(int xoff, int yoff, char *name)
{
	 Fl_Group* o = GUIEnvGroup = new Fl_Group(xoff, yoff, 120, 110, name);
      o->type(1);
	  o->box(FL_UP_BOX);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
	  o->user_data((void*)(this));
       	  
	  Attack = new Fl_PawfalSlider(xoff+10, yoff+20, 20, 70, "A");
	  Attack->type(4);
	  Attack->selection_color(SpiralInfo::GUI_COLOUR);
      Attack->labelsize(10);
	  Attack->maximum(TIMED_SLIDER_MAX);
      Attack->step(0.01);
      Attack->value(1.0f);
      Attack->callback((Fl_Callback*)cb_Attack);
	  
	  Decay = new Fl_PawfalSlider(xoff+30, yoff+20, 20, 70, "D");
	  Decay->type(4);
	  Decay->selection_color(SpiralInfo::GUI_COLOUR);
      Decay->labelsize(10);
	  Decay->maximum(TIMED_SLIDER_MAX);
      Decay->step(0.01);
      Decay->value(0.1);
      Decay->callback((Fl_Callback*)cb_Decay);
	  
	  Sustain = new Fl_PawfalSlider(xoff+50, yoff+20, 20, 70, "S");
	  Sustain->type(4);	  
	  Sustain->selection_color(SpiralInfo::GUI_COLOUR);
      Sustain->labelsize(10);
	  Sustain->maximum(1);
      Sustain->step(0.01);
      Sustain->value(0.5);
      Sustain->callback((Fl_Callback*)cb_Sustain);
	  
	  Release = new Fl_PawfalSlider(xoff+70, yoff+20, 20, 70, "R");
	  Release->type(4);
	  Release->selection_color(SpiralInfo::GUI_COLOUR);
      Release->labelsize(10);
	  Release->maximum(TIMED_SLIDER_MAX);
      Release->step(0.01);
      Release->value(0.5);
      Release->callback((Fl_Callback*)cb_Release);	  
      
	  Volume = new Fl_PawfalSlider(xoff+90, yoff+20, 20, 70, "V");
	  Volume->type(4);
	  Volume->selection_color(SpiralInfo::GUI_COLOUR);
      Volume->labelsize(10);
	  Volume->maximum(1);
      Volume->step(0.01);
      Volume->value(0.5f);
      Volume->callback((Fl_Callback*)cb_Volume);	  
      
      o->end();
    
}

void EnvelopeGUI::UpdateValues()
{		 
	Attack->value(TIMED_SLIDER_MAX-sqrt(m_env->GetAttack()));
	Decay->value(TIMED_SLIDER_MAX-sqrt(m_env->GetDecay()));
	Sustain->value(1.0f-m_env->GetSustain());
	Release->value(TIMED_SLIDER_MAX-sqrt(m_env->GetRelease()));
	Volume->value(1.0f-m_env->GetVolume());
}

//// Callbacks ////

inline void EnvelopeGUI::cb_Attack_i(Fl_PawfalSlider* o, void* v) 
{ 
	float value=TIMED_SLIDER_MAX-o->value();
	m_env->SetAttack(value*value); 
}
void EnvelopeGUI::cb_Attack(Fl_PawfalSlider* o, void* v) 
{ ((EnvelopeGUI*)(o->parent()->user_data()))->cb_Attack_i(o,v); }

inline void EnvelopeGUI::cb_Decay_i(Fl_PawfalSlider* o, void* v) 
{ 
	float value=TIMED_SLIDER_MAX-o->value();
	m_env->SetDecay(value*value); 
}
void EnvelopeGUI::cb_Decay(Fl_PawfalSlider* o, void* v) 
{ ((EnvelopeGUI*)(o->parent()->user_data()))->cb_Decay_i(o,v); }

inline void EnvelopeGUI::cb_Sustain_i(Fl_PawfalSlider* o, void* v) 
{ m_env->SetSustain(1.0f-o->value()); }
void EnvelopeGUI::cb_Sustain(Fl_PawfalSlider* o, void* v) 
{ ((EnvelopeGUI*)(o->parent()->user_data()))->cb_Sustain_i(o,v); }

inline void EnvelopeGUI::cb_Release_i(Fl_PawfalSlider* o, void* v) 
{ 
	float value=TIMED_SLIDER_MAX-o->value();
	m_env->SetRelease(value*value); 
}
void EnvelopeGUI::cb_Release(Fl_PawfalSlider* o, void* v) 
{ ((EnvelopeGUI*)(o->parent()->user_data()))->cb_Release_i(o,v); }

inline void EnvelopeGUI::cb_Volume_i(Fl_PawfalSlider* o, void* v) 
{ m_env->SetVolume(1.0f-o->value()); }
void EnvelopeGUI::cb_Volume(Fl_PawfalSlider* o, void* v) 
{ ((EnvelopeGUI*)(o->parent()->user_data()))->cb_Volume_i(o,v); }


