/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <string>

#ifndef WAVFILE
#define WAVFILE

#include <stdio.h>
#include "Sample.h"

class WavFile
{
public:
	WavFile() : m_Stream(NULL), m_TotalLength(0) {}
	~WavFile() {Close();}	
	
	enum Mode{READ,WRITE};
	enum Channels{MONO,STEREO};

	class HeaderInfo
	{
	public:
		HeaderInfo();
	
		string RiffStr1;
		int  RiffSize;
		string RiffStr2;

		string FrmtStr;
		char Length;
		char Unknown;
		char Channels;
		int  SampleRate;
		int  BytesPerSec;
		char BytesPerSample;
		char BitsPerSample;		
	
		string DataStr;
		int  DataLength;
		char Zero;
	};
	
	int Open(string FileName, Mode mode, Channels channels=MONO);
	int Close();
	int Save(Sample &data);
	int Load(Sample &data);
	int GetSize();
	
	bool Recording() {return (m_Stream!=NULL);}
	
private:

	FILE *m_Stream;
	int m_TotalLength;
	bool m_Stereo;
};

#endif
