/*  TriggerWidget
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "Fl_Trigger.h"
#include <iostream.h>
#include <FL/fl_draw.H>
#include <math.h>
#include <stdio.h>
#include "Fl_Loop.h"

/////////////////////////////////////////////////////////////////////////////

static const float RADCONV = 0.017453292;

Fl_Trigger::Fl_Trigger(int x, int y, int w, int h, const char* label=0) : 
Fl_Widget(x,y,w,h,label),
m_CentreX(0),
m_CentreY(0),
m_CentreRadius(0),
m_Dragging(false),
m_Loop(0),
m_Passes(0),
m_Count(0),
m_Angle(0),
m_MaxLoops(10),
m_MaxPasses(10),
m_Snap(false),
m_SnapDegrees(45)
{
}

void Fl_Trigger::draw()
{	
	x(((sin(m_Angle*RADCONV)*m_CentreRadius)+m_CentreX)-(w()/2));
	y(((cos(m_Angle*RADCONV)*m_CentreRadius)+m_CentreY)-(h()/2));						
						
	fl_color(255,255,255);
	fl_arc(x(), y(), w(), h(), 0, 360);
 	
	int cx=x()+w()/2;
	int cy=y()+h()/2;
	
	char loop[32];
	sprintf(loop,"%d",m_Loop);
	fl_draw(loop, cx-2, cy-h()+5); 

	char pass[32];
	sprintf(pass,"%d",m_Passes);
	fl_draw(pass, cx+w()-5, cy+3);
	
	//char t[32];
	//sprintf(t,"%d",m_Count);
	//fl_draw(t, cx+w()+5, cy+3);
}

int Fl_Trigger::handle(int  event)
{
	static int LastButtonPushed=0;

	// call base
	if (!Fl_Widget::handle(event))
	{
	int ww,hh;
	
	ww = w();
	hh = h();
	
	int mx = Fl::event_x();
	int my = Fl::event_y();
	
	switch (event) 
	{
  		case FL_PUSH:
			LastButtonPushed=Fl::event_button();			
			
			if (LastButtonPushed==1)			
			{
				if (sqrt(mx-x()*my-y())<w())
				{
					m_Dragging=true;					
				}
			}
			
			if (LastButtonPushed==2)			
			{
				m_Loop++;
				if (m_Loop>m_MaxLoops)
				{
					m_Loop=0;
				}
				redraw();
				Fl_Loop *p=(Fl_Loop*)parent();
				p->DrawEveryThing();
				p->redraw();
			}
			
			if (LastButtonPushed==3)			
			{
				m_Passes++;
				if (m_Passes>m_MaxPasses)
				{
					m_Passes=0;
				}
				redraw();
				Fl_Loop *p=(Fl_Loop*)parent();
				p->DrawEveryThing();
				p->redraw();
			}
			
			// fall through
			
		case FL_DRAG:
    		{				
				if (LastButtonPushed==2)
				{
					
				}
				else if (LastButtonPushed==1)			
				{	
					if (m_Dragging)
					{
						int px = mx-m_CentreX;
						int py = my-m_CentreY;
						
						double angle = 90+atan2((float)-py, (float)px)*180/M_PI;
						while (angle < m_Angle-180) angle += 360;
						while (angle > m_Angle+180) angle -= 360;
					
						while (angle < 0) angle += 360;
						while (angle > 360) angle -= 360;
					
						m_Angle=angle;
							
						// snap
						if (m_Snap)
						{
							m_Angle-=(int)m_Angle%m_SnapDegrees;
						}
															
						redraw();
					}					
				}
				else if (LastButtonPushed==3)			
				{
				
				}
			} 
			break;
		
		case FL_RELEASE:
			{
				m_Dragging=false;
				Fl_Loop *p=(Fl_Loop*)parent();
				p->DrawEveryThing();
				p->redraw();
			}
			break;
		
		default:
			return 0;
  		}
	
	}
	return 1;
}

istream &operator>>(istream &s, Fl_Trigger &o)
{	
	s>>o.m_CentreX>>o.m_CentreY>>o.m_CentreRadius>>o.m_Dragging>>o.m_Loop>>o.m_Passes>>
		o.m_Count>>o.m_Angle>>o.m_MaxLoops>>o.m_MaxPasses;
		
	return s;
}

ostream &operator<<(ostream &s, Fl_Trigger &o)
{
	s<<o.m_CentreX<<" "<<o.m_CentreY<<" "<<o.m_CentreRadius<<" "<<o.m_Dragging<<" "<<
		o.m_Loop<<" "<<o.m_Passes<<" "<<o.m_Count<<" "<<o.m_Angle<<" "<<
		o.m_MaxLoops<<" "<<o.m_MaxPasses<<" ";
		
	return s;
}
