/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

// Stereo module

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.H>

#include "GUIBase.h"

#ifndef SCOPEGUI
#define SCOPEGUI

class ScopeWidget : public Fl_Widget 
{
public:
    ScopeWidget(int x,int y,int w,int h,const char *l=0);
	
    void draw(); 
	void SetNumChannels(int s) {m_Channels=s;}
	
	const short *m_Data;
	int    m_Channels;
private:

};



class ScopeGUI : public GUIBase
{
public:
	ScopeGUI();
	
	virtual void CreateGUI(int xoff=0, int yoff=0, char *name="");
	void Display(const short *data);
	void SetNumChannels(int s) {m_Scope->SetNumChannels(s);}

private:

	bool m_Bypass;

	Fl_Group 		*GUIScopeGroup;	
	Fl_Button       *Bypass;
	ScopeWidget		*m_Scope;	
  
    inline void cb_Bypass_i(Fl_Button* o, void* v);
    static void cb_Bypass(Fl_Button* o, void* v);
	
};

#endif
