set(FIND_SSVMENUSYSTEM_LIB_PATHS
  "${PROJECT_SOURCE_DIR}/../SSVMenuSystem/"
  "${PROJECT_SOURCE_DIR}/extlibs/SSVMenuSystem/"
  ${SSVMENUSYSTEM_ROOT}
  $ENV{SSVMENUSYSTEM_ROOT}
  ~/Library/Frameworks
  /Library/Frameworks
  /usr/local
  /usr/
  /sw/
  /opt/local
  /opt/csw
  /opt
)

FIND_PATH(SSVMENUSYSTEM_INCLUDE_DIR
  NAMES SSVMenuSystem/SSVMenuSystem.h
  PATH_SUFFIXES include/
  PATHS ${FIND_SSVMENUSYSTEM_LIB_PATHS}
)
MESSAGE("\nFound SSVMenuSystem include at: ${SSVMENUSYSTEM_INCLUDE_DIR}.\n")

FIND_LIBRARY(SSVMENUSYSTEM_LIBRARY_RELEASE
  NAMES SSVMenuSystem SSVMenuSystem-s
  PATH_SUFFIXES lib/ lib64/
  PATHS ${FIND_SSVMENUSYSTEM_LIB_PATHS}
)
MESSAGE("\nFound SSVMenuSystem release library at: ${SSVMENUSYSTEM_LIBRARY_RELEASE}.\n")

FIND_LIBRARY(SSVMENUSYSTEM_LIBRARY_DEBUG
  NAMES SSVMenuSystem-d SSVMenuSystem-s-d
  PATH_SUFFIXES lib/ lib64/
  PATHS ${FIND_SSVMENUSYSTEM_LIB_PATHS}
)
MESSAGE("\nFound SSVMenuSystem debug library at: ${SSVMENUSYSTEM_LIBRARY_DEBUG}.\n")

if(SSVMENUSYSTEM_LIBRARY_DEBUG OR SSVMENUSYSTEM_LIBRARY_RELEASE)
  set(SSVMENUSYSTEM_FOUND TRUE)
  if(SSVMENUSYSTEM_LIBRARY_DEBUG AND SSVMENUSYSTEM_LIBRARY_RELEASE)
    SET(SSVMENUSYSTEM_LIBRARY debug ${SSVMENUSYSTEM_LIBRARY_DEBUG} optimized ${SSVMENUSYSTEM_LIBRARY_RELEASE})
  endif()
  if(SSVMENUSYSTEM_LIBRARY_DEBUG AND NOT SSVMENUSYSTEM_LIBRARY_RELEASE)
    set(SSVMENUSYSTEM_LIBRARY_RELEASE ${SSVMENUSYSTEM_LIBRARY_DEBUG})
    set(SSVMENUSYSTEM_LIBRARY         ${SSVMENUSYSTEM_LIBRARY_DEBUG})
  endif()
  if(SSVMENUSYSTEM_LIBRARY_RELEASE AND NOT SSVMENUSYSTEM_LIBRARY_DEBUG)
    set(SSVMENUSYSTEM_LIBRARY_DEBUG ${SSVMENUSYSTEM_LIBRARY_RELEASE})
    set(SSVMENUSYSTEM_LIBRARY       ${SSVMENUSYSTEM_LIBRARY_RELEASE})
  endif()
else()
  set(SSVMENUSYSTEM_FOUND FALSE)
  set(SSVMENUSYSTEM_LIBRARY "")
endif()

IF(SSVMENUSYSTEM_FOUND)
  MESSAGE(STATUS "\nFound SSVMENUSYSTEM: ${SSVMENUSYSTEM_LIBRARY}\n")
ELSE()
  IF(SSVMENUSYSTEM_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "\nCould not find SSVMenuSystem library\n")
  ENDIF(SSVMENUSYSTEM_FIND_REQUIRED)
  set(SSVMENUSYSTEM_ROOT "" CACHE PATH "SSVMenuSystem top-level directory")
  message("\n-> SSVMenuSystem directory not found. Set SSVMENUSYSTEM_ROOT to SSVMenuSystem' top-level path (containing both \"include\" and \"lib\" directories).")
ENDIF()

MARK_AS_ADVANCED(
  SSVMENUSYSTEM_LIBRARY_DEBUG
  SSVMENUSYSTEM_LIBRARY_RELEASE
  SSVMENUSYSTEM_LIBRARY
  SSVMENUSYSTEM_INCLUDE_DIR
)
