set(FIND_SSVJSONCPP_LIB_PATHS
	"${PROJECT_SOURCE_DIR}/../SSVJsonCpp/"
	"${PROJECT_SOURCE_DIR}/extlibs/SSVJsonCpp/"
	${SSVJSONCPP_ROOT}
	$ENV{SSVJSONCPP_ROOT}
	~/Library/Frameworks
	/Library/Frameworks
	/usr/local
	/usr/
	/sw/
	/opt/local
	/opt/csw
	/opt
)

FIND_PATH(SSVJSONCPP_INCLUDE_DIR
	NAMES SSVJsonCpp/SSVJsonCpp.h
	PATH_SUFFIXES include/
	PATHS ${FIND_SSVJSONCPP_LIB_PATHS}
)
MESSAGE("\nFound SSVJsonCpp include at: ${SSVJSONCPP_INCLUDE_DIR}.\n")

FIND_LIBRARY(SSVJSONCPP_LIBRARY_RELEASE
	NAMES SSVJsonCpp SSVJsonCpp-s
	PATH_SUFFIXES lib/ lib64/
	PATHS ${FIND_SSVJSONCPP_LIB_PATHS}
)
MESSAGE("\nFound SSVJsonCpp release library at: ${SSVJSONCPP_LIBRARY_RELEASE}.\n")

FIND_LIBRARY(SSVJSONCPP_LIBRARY_DEBUG
	NAMES SSVJsonCpp-d SSVJsonCpp-s-d
	PATH_SUFFIXES lib/ lib64/
	PATHS ${FIND_SSVJSONCPP_LIB_PATHS}
)
MESSAGE("\nFound SSVJsonCpp debug library at: ${SSVJSONCPP_LIBRARY_DEBUG}.\n")

if(SSVJSONCPP_LIBRARY_DEBUG OR SSVJSONCPP_LIBRARY_RELEASE)
	set(SSVJSONCPP_FOUND TRUE)
	if(SSVJSONCPP_LIBRARY_DEBUG AND SSVJSONCPP_LIBRARY_RELEASE)
		SET(SSVJSONCPP_LIBRARY debug ${SSVJSONCPP_LIBRARY_DEBUG} optimized ${SSVJSONCPP_LIBRARY_RELEASE})
	endif()
	if(SSVJSONCPP_LIBRARY_DEBUG AND NOT SSVJSONCPP_LIBRARY_RELEASE)
		set(SSVJSONCPP_LIBRARY_RELEASE ${SSVJSONCPP_LIBRARY_DEBUG})
		set(SSVJSONCPP_LIBRARY         ${SSVJSONCPP_LIBRARY_DEBUG})
	endif()
	if(SSVJSONCPP_LIBRARY_RELEASE AND NOT SSVJSONCPP_LIBRARY_DEBUG)
		set(SSVJSONCPP_LIBRARY_DEBUG ${SSVJSONCPP_LIBRARY_RELEASE})
		set(SSVJSONCPP_LIBRARY       ${SSVJSONCPP_LIBRARY_RELEASE})
	endif()
else()
	set(SSVJSONCPP_FOUND FALSE)
	set(SSVJSONCPP_LIBRARY "")
endif()

IF(SSVJSONCPP_FOUND)
	MESSAGE(STATUS "\nFound SSVJSONCPP: ${SSVJSONCPP_LIBRARY}\n")
ELSE()
	IF(SSVJSONCPP_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "\nCould not find SSVJsonCpp library\n")
	ENDIF(SSVJSONCPP_FIND_REQUIRED)
	set(SSVJSONCPP_ROOT "" CACHE PATH "SSVJsonCpp top-level directory")
	message("\n-> SSVJsonCpp directory not found. Set SSVJSONCPP_ROOT to SSVJsonCpp' top-level path (containing both \"include\" and \"lib\" directories).")
ENDIF()

MARK_AS_ADVANCED(
	SSVJSONCPP_LIBRARY_DEBUG
	SSVJSONCPP_LIBRARY_RELEASE
	SSVJSONCPP_LIBRARY
	SSVJSONCPP_INCLUDE_DIR
)
