
/*
 * REminiscence - Flashback interpreter
 * Copyright (C) 2005-2019 Gregory Montoir (cyx@users.sourceforge.net)
 */

#include "game.h"
#include "resource.h"


const Cutscene::OpcodeStub Cutscene::_opcodeTable[] = {
	/* 0x00 */
	&Cutscene::op_markCurPos,
	&Cutscene::op_refreshScreen,
	&Cutscene::op_waitForSync,
	&Cutscene::op_drawShape,
	/* 0x04 */
	&Cutscene::op_setPalette,
	&Cutscene::op_markCurPos,
	&Cutscene::op_drawCaptionText,
	&Cutscene::op_nop,
	/* 0x08 */
	&Cutscene::op_skip3,
	&Cutscene::op_refreshAll,
	&Cutscene::op_drawShapeScale,
	&Cutscene::op_drawShapeScaleRotate,
	/* 0x0C */
	&Cutscene::op_copyScreen,
	&Cutscene::op_drawTextAtPos,
	&Cutscene::op_handleKeys
};

const char *Cutscene::_namesTableDOS[] = {
	"DEBUT",
	"OBJET",
	"CARTE",
	"GEN",
	"CHUTE",
	"CODE",
	"DESINTEG",
	"INTRO1",
	"STREM",
	"HOLOSEQ",
	"CARTEID",
	"PONT",
	"ASC",
	"MAP",
	"METRO",
	"MISSIONS",
	"GENMIS",
	"MEMO",
	"TAXI",
	"ACCROCHE",
	"VOYAGE",
	"TELEPORT",
	"LIFT",
	"ESPIONS",
	"LOG",
	"FIN",
	"GENEXP",
	"LOGOS",
	"OVER",
	"SCORE",
	"INTRO2",
	"SERRURE",
	"HOLOCUBE",
	"CHUTE2",
	"LOGOSSSI",
};

const uint16_t Cutscene::_offsetsTableDOS[] = {
	0x0000, 0x0000, 0x0001, 0x0003, 0x0001, 0x0004, 0xFFFF, 0x0000, 0x0001, 0x0002,
	0x0003, 0x0000, 0x0004, 0x0000, 0xFFFF, 0x0100, 0xFFFF, 0x0000, 0x0006, 0x0000,
	0x0001, 0x0001, 0xFFFF, 0x0000, 0xFFFF, 0x0200, 0x8007, 0x0000, 0x0003, 0x0001,
	0x0001, 0x000B, 0x0001, 0x0005, 0x0009, 0x0000, 0x0001, 0x0006, 0xFFFF, 0x0000,
	0x000B, 0x0000, 0x0001, 0x000A, 0xFFFF, 0x0001, 0xFFFF, 0x0002, 0xFFFF, 0x0000,
	0x000D, 0x0004, 0x000D, 0x0000, 0x000D, 0x0001, 0x000D, 0x0002, 0x000D, 0x0003,
	0xFFFF, 0x0000, 0xFFFF, 0x0001, 0x0001, 0x000C, 0x0001, 0x000D, 0x0001, 0x000E,
	0x0001, 0x000F, 0x0001, 0x0010, 0x000F, 0x0000, 0x000F, 0x0001, 0x000F, 0x0001,
	0x000F, 0x0003, 0x000F, 0x0002, 0x000F, 0x0004, 0x0001, 0x0008, 0x0001, 0x0007,
	0x000F, 0x0005, 0xFFFF, 0x0000, 0x0004, 0x0001, 0x0011, 0x0000, 0x0001, 0x0009,
	0x0012, 0x0000, 0xFFFF, 0x0000, 0x0014, 0x0000, 0x0015, 0x0000, 0x0016, 0x0000,
	0x0016, 0x0001, 0xFFFF, 0x0012, 0x0017, 0x0000, 0x0001, 0x0011, 0x0018, 0x0000,
	0x0001, 0x0013, 0x0019, 0x0000, 0x001A, 0x0000, 0x0019, 0x0001, 0x001B, 0x0000,
	0x001C, 0x0000, 0x000F, 0x0006, 0x000F, 0x0006, 0x000F, 0x0007, 0x000F, 0x0008,
	0x000F, 0x0009, 0x000F, 0x000A, 0x001D, 0x0000, 0x001B, 0x0001, 0x001E, 0x0000,
	0xFFFF, 0x0000
};

const uint16_t Cutscene::_offsetsTableAmiga[] = {
	0x0000,  0, 0x0001,  3, 0x0001,  4, 0x0002,  0, 0x0001,  2, 0x0003,  0, 0x0004,  0, 0xFFFF,  0,
	0xFFFF,  0, 0x0006,  0, 0x0001,  1, 0xFFFF,  0, 0xFFFF,  0, 0x0007,  0, 0x0003,  1, 0x0001, 11,
	0x0001,  5, 0x0009,  0, 0x0001,  6, 0x000A,  0, 0x000B,  0, 0x0001, 10, 0x000C,  1, 0xFFFF,  2,
	0xFFFF,  0, 0x000D,  4, 0x000D,  0, 0x000D,  1, 0x000D,  2, 0x000D,  3, 0xFFFF,  0, 0xFFFF,  1,
	0x0001, 12, 0x0001, 13, 0x0001, 14, 0x0001, 15, 0x0001, 16, 0x000F,  0, 0x000F,  1, 0x000F,  1,
	0x000F,  3, 0x000F,  2, 0x000F,  4, 0x0001,  8, 0x0001,  7, 0x000F,  5, 0xFFFF,  0, 0x0004,  1,
	0x0011,  0, 0x0001,  9, 0x0012,  0, 0xFFFF,  0, 0x0014,  0, 0x0015,  0, 0x0016,  0, 0x0016,  1,
	0xFFFF, 18, 0x0017,  0, 0x0001, 17, 0x0018,  0, 0x0001, 19, 0x0019,  0, 0x001A,  0, 0x0019,  1,
	0x001B,  0, 0x001C,  0, 0x000F,  6, 0x000F,  6, 0x000F,  7, 0x000F,  8, 0x000F,  9, 0x000F, 10,
	0x001D,  0, 0x001B,  1
};

const uint8_t Cutscene::_amigaDemoOffsetsTable[] = {
	1, 32, 0, /* HOLOCUBE */
	6, 33, 0, /* CHUTE2 */
	255
};

const uint8_t Cutscene::_ssiOffsetsTable[] = {
	64, 34, 0, /* LOGOSSSI */
	255
};

const uint16_t Cutscene::_cosTable[] = {
	0x0100, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FE, 0x00FE,
	0x00FD, 0x00FC, 0x00FC, 0x00FB, 0x00FA, 0x00F9, 0x00F8, 0x00F7,
	0x00F6, 0x00F4, 0x00F3, 0x00F2, 0x00F0, 0x00EE, 0x00ED, 0x00EB,
	0x00E9, 0x00E8, 0x00E6, 0x00E4, 0x00E2, 0x00DF, 0x00DD, 0x00DB,
	0x00D9, 0x00D6, 0x00D4, 0x00D1, 0x00CF, 0x00CC, 0x00C9, 0x00C6,
	0x00C4, 0x00C1, 0x00BE, 0x00BB, 0x00B8, 0x00B5, 0x00B1, 0x00AE,
	0x00AB, 0x00A7, 0x00A4, 0x00A1, 0x009D, 0x009A, 0x0096, 0x0092,
	0x008F, 0x008B, 0x0087, 0x0083, 0x007F, 0x007C, 0x0078, 0x0074,
	0x0070, 0x006C, 0x0068, 0x0064, 0x005F, 0x005B, 0x0057, 0x0053,
	0x004F, 0x004A, 0x0046, 0x0042, 0x003D, 0x0039, 0x0035, 0x0030,
	0x002C, 0x0028, 0x0023, 0x001F, 0x001A, 0x0016, 0x0011, 0x000D,
	0x0008, 0x0004, 0x0000, 0xFFFC, 0xFFF8, 0xFFF3, 0xFFEF, 0xFFEA,
	0xFFE6, 0xFFE1, 0xFFDD, 0xFFD8, 0xFFD4, 0xFFD0, 0xFFCB, 0xFFC7,
	0xFFC3, 0xFFBE, 0xFFBA, 0xFFB6, 0xFFB1, 0xFFAD, 0xFFA9, 0xFFA5,
	0xFFA1, 0xFF9C, 0xFF98, 0xFF94, 0xFF90, 0xFF8C, 0xFF88, 0xFF84,
	0xFF80, 0xFF7D, 0xFF79, 0xFF75, 0xFF71, 0xFF6E, 0xFF6A, 0xFF66,
	0xFF63, 0xFF5F, 0xFF5C, 0xFF59, 0xFF55, 0xFF52, 0xFF4F, 0xFF4B,
	0xFF48, 0xFF45, 0xFF42, 0xFF3F, 0xFF3C, 0xFF3A, 0xFF37, 0xFF34,
	0xFF31, 0xFF2F, 0xFF2C, 0xFF2A, 0xFF27, 0xFF25, 0xFF23, 0xFF21,
	0xFF1E, 0xFF1C, 0xFF1A, 0xFF18, 0xFF17, 0xFF15, 0xFF13, 0xFF12,
	0xFF10, 0xFF0E, 0xFF0D, 0xFF0C, 0xFF0A, 0xFF09, 0xFF08, 0xFF07,
	0xFF06, 0xFF05, 0xFF04, 0xFF04, 0xFF03, 0xFF02, 0xFF02, 0xFF01,
	0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF00, 0xFF01, 0xFF01, 0xFF01,
	0xFF01, 0xFF01, 0xFF02, 0xFF02, 0xFF03, 0xFF04, 0xFF04, 0xFF05,
	0xFF06, 0xFF07, 0xFF08, 0xFF09, 0xFF0A, 0xFF0C, 0xFF0D, 0xFF0E,
	0xFF10, 0xFF12, 0xFF13, 0xFF15, 0xFF17, 0xFF18, 0xFF1A, 0xFF1C,
	0xFF1E, 0xFF21, 0xFF23, 0xFF25, 0xFF27, 0xFF2A, 0xFF2C, 0xFF2F,
	0xFF31, 0xFF34, 0xFF37, 0xFF3A, 0xFF3C, 0xFF3F, 0xFF42, 0xFF45,
	0xFF48, 0xFF4B, 0xFF4F, 0xFF52, 0xFF55, 0xFF59, 0xFF5C, 0xFF5F,
	0xFF63, 0xFF66, 0xFF6A, 0xFF6E, 0xFF71, 0xFF75, 0xFF79, 0xFF7D,
	0xFF81, 0xFF84, 0xFF88, 0xFF8C, 0xFF90, 0xFF94, 0xFF98, 0xFF9C,
	0xFFA1, 0xFFA5, 0xFFA9, 0xFFAD, 0xFFB1, 0xFFB6, 0xFFBA, 0xFFBE,
	0xFFC3, 0xFFC7, 0xFFCB, 0xFFD0, 0xFFD4, 0xFFD8, 0xFFDD, 0xFFE1,
	0xFFE6, 0xFFEA, 0xFFEF, 0xFFF3, 0xFFF8, 0xFFFC, 0x0000, 0x0004,
	0x0008, 0x000D, 0x0011, 0x0016, 0x001A, 0x001F, 0x0023, 0x0028,
	0x002C, 0x0030, 0x0035, 0x0039, 0x003D, 0x0042, 0x0046, 0x004A,
	0x004F, 0x0053, 0x0057, 0x005B, 0x005F, 0x0064, 0x0068, 0x006C,
	0x0070, 0x0074, 0x0078, 0x007C, 0x0080, 0x0083, 0x0087, 0x008B,
	0x008F, 0x0092, 0x0096, 0x009A, 0x009D, 0x00A1, 0x00A4, 0x00A7,
	0x00AB, 0x00AE, 0x00B1, 0x00B5, 0x00B8, 0x00BB, 0x00BE, 0x00C1,
	0x00C4, 0x00C6, 0x00C9, 0x00CC, 0x00CF, 0x00D1, 0x00D4, 0x00D6,
	0x00D9, 0x00DB, 0x00DD, 0x00DF, 0x00E2, 0x00E4, 0x00E6, 0x00E8,
	0x00E9, 0x00EB, 0x00ED, 0x00EE, 0x00F0, 0x00F2, 0x00F3, 0x00F4,
	0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FC,
	0x00FD, 0x00FE, 0x00FE, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF
};

const uint16_t Cutscene::_sinTable[] = {
	0x0000, 0x0004, 0x0008, 0x000D, 0x0011, 0x0016, 0x001A, 0x001F,
	0x0023, 0x0028, 0x002C, 0x0030, 0x0035, 0x0039, 0x003D, 0x0042,
	0x0046, 0x004A, 0x004F, 0x0053, 0x0057, 0x005B, 0x005F, 0x0064,
	0x0068, 0x006C, 0x0070, 0x0074, 0x0078, 0x007C, 0x007F, 0x0083,
	0x0087, 0x008B, 0x008F, 0x0092, 0x0096, 0x009A, 0x009D, 0x00A1,
	0x00A4, 0x00A7, 0x00AB, 0x00AE, 0x00B1, 0x00B5, 0x00B8, 0x00BB,
	0x00BE, 0x00C1, 0x00C4, 0x00C6, 0x00C9, 0x00CC, 0x00CF, 0x00D1,
	0x00D4, 0x00D6, 0x00D9, 0x00DB, 0x00DD, 0x00DF, 0x00E2, 0x00E4,
	0x00E6, 0x00E8, 0x00E9, 0x00EB, 0x00ED, 0x00EE, 0x00F0, 0x00F2,
	0x00F3, 0x00F4, 0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB,
	0x00FC, 0x00FC, 0x00FD, 0x00FE, 0x00FE, 0x00FF, 0x00FF, 0x00FF,
	0x00FF, 0x00FF, 0x0100, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF,
	0x00FE, 0x00FE, 0x00FD, 0x00FC, 0x00FC, 0x00FB, 0x00FA, 0x00F9,
	0x00F8, 0x00F7, 0x00F6, 0x00F4, 0x00F3, 0x00F2, 0x00F0, 0x00EE,
	0x00ED, 0x00EB, 0x00E9, 0x00E8, 0x00E6, 0x00E4, 0x00E2, 0x00DF,
	0x00DD, 0x00DB, 0x00D9, 0x00D6, 0x00D4, 0x00D1, 0x00CF, 0x00CC,
	0x00C9, 0x00C6, 0x00C4, 0x00C1, 0x00BE, 0x00BB, 0x00B8, 0x00B5,
	0x00B1, 0x00AE, 0x00AB, 0x00A7, 0x00A4, 0x00A1, 0x009D, 0x009A,
	0x0096, 0x0092, 0x008F, 0x008B, 0x0087, 0x0083, 0x007F, 0x007C,
	0x0078, 0x0074, 0x0070, 0x006C, 0x0068, 0x0064, 0x005F, 0x005B,
	0x0057, 0x0053, 0x004F, 0x004A, 0x0046, 0x0042, 0x003D, 0x0039,
	0x0035, 0x0030, 0x002C, 0x0028, 0x0023, 0x001F, 0x001A, 0x0016,
	0x0011, 0x000D, 0x0008, 0x0004, 0x0000, 0xFFFC, 0xFFF8, 0xFFF3,
	0xFFEF, 0xFFEA, 0xFFE6, 0xFFE1, 0xFFDD, 0xFFD8, 0xFFD4, 0xFFD0,
	0xFFCB, 0xFFC7, 0xFFC3, 0xFFBE, 0xFFBA, 0xFFB6, 0xFFB1, 0xFFAD,
	0xFFA9, 0xFFA5, 0xFFA1, 0xFF9C, 0xFF98, 0xFF94, 0xFF90, 0xFF8C,
	0xFF88, 0xFF84, 0xFF80, 0xFF7D, 0xFF79, 0xFF75, 0xFF71, 0xFF6E,
	0xFF6A, 0xFF66, 0xFF63, 0xFF5F, 0xFF5C, 0xFF59, 0xFF55, 0xFF52,
	0xFF4F, 0xFF4B, 0xFF48, 0xFF45, 0xFF42, 0xFF3F, 0xFF3C, 0xFF3A,
	0xFF37, 0xFF34, 0xFF31, 0xFF2F, 0xFF2C, 0xFF2A, 0xFF27, 0xFF25,
	0xFF23, 0xFF21, 0xFF1E, 0xFF1C, 0xFF1A, 0xFF18, 0xFF17, 0xFF15,
	0xFF13, 0xFF12, 0xFF10, 0xFF0E, 0xFF0D, 0xFF0C, 0xFF0A, 0xFF09,
	0xFF08, 0xFF07, 0xFF06, 0xFF05, 0xFF04, 0xFF04, 0xFF03, 0xFF02,
	0xFF02, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF00, 0xFF01,
	0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF02, 0xFF02, 0xFF03, 0xFF04,
	0xFF04, 0xFF05, 0xFF06, 0xFF07, 0xFF08, 0xFF09, 0xFF0A, 0xFF0C,
	0xFF0D, 0xFF0E, 0xFF10, 0xFF12, 0xFF13, 0xFF15, 0xFF17, 0xFF18,
	0xFF1A, 0xFF1C, 0xFF1E, 0xFF21, 0xFF23, 0xFF25, 0xFF27, 0xFF2A,
	0xFF2C, 0xFF2F, 0xFF31, 0xFF34, 0xFF37, 0xFF3A, 0xFF3C, 0xFF3F,
	0xFF42, 0xFF45, 0xFF48, 0xFF4B, 0xFF4F, 0xFF52, 0xFF55, 0xFF59,
	0xFF5C, 0xFF5F, 0xFF63, 0xFF66, 0xFF6A, 0xFF6E, 0xFF71, 0xFF75,
	0xFF79, 0xFF7D, 0xFF81, 0xFF84, 0xFF88, 0xFF8C, 0xFF90, 0xFF94,
	0xFF98, 0xFF9C, 0xFFA1, 0xFFA5, 0xFFA9, 0xFFAD, 0xFFB1, 0xFFB6,
	0xFFBA, 0xFFBE, 0xFFC3, 0xFFC7, 0xFFCB, 0xFFD0, 0xFFD4, 0xFFD8,
	0xFFDD, 0xFFE1, 0xFFE6, 0xFFEA, 0xFFEF, 0xFFF3, 0xFFF8, 0xFFFC
};

const uint8_t Cutscene::_creditsDataDOS[] = {
	0xFE, 0x14, 0x00, 0x01, 0x00, 0x04, 0x20, 0x20, 0x54, 0x68, 0x65, 0x20, 0x46, 0x6C, 0x61, 0x73,
	0x68, 0x42, 0x61, 0x63, 0x6B, 0x20, 0x54, 0x65, 0x61, 0x6D, 0x20, 0x69, 0x73, 0x2E, 0x2E, 0x2E,
	0xFE, 0x32, 0xFE, 0x14, 0x00, 0x01, 0x00, 0x07, 0x00, 0x01, 0x00, 0x05, 0x20, 0x20, 0x49, 0x6E,
	0x69, 0x74, 0x69, 0x61, 0x6C, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x72,
	0x6F, 0x67, 0x72, 0x61, 0x6D, 0x6D, 0x65, 0x72, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x42, 0x65, 0x6E, 0x6F, 0x69,
	0x73, 0x74, 0x20, 0x41, 0x72, 0x6F, 0x6E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x68, 0x69, 0x6C,
	0x69, 0x70, 0x70, 0x65, 0x20, 0x43, 0x68, 0x61, 0x73, 0x74, 0x65, 0x6C, 0x20, 0x20, 0x20, 0x7C,
	0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20,
	0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x46, 0x72, 0x65, 0x64, 0x65, 0x72, 0x69, 0x63, 0x20, 0x53, 0x61, 0x76, 0x6F, 0x69, 0x72, 0x20,
	0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x05, 0x20, 0x20, 0x47, 0x72,
	0x61, 0x70, 0x68, 0x69, 0x63, 0x20, 0x41, 0x72, 0x74, 0x69, 0x73, 0x74, 0x73, 0x3A, 0x7C, 0x7C,
	0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50,
	0x61, 0x74, 0x72, 0x69, 0x63, 0x6B, 0x20, 0x44, 0x61, 0x68, 0x65, 0x72, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x4C, 0x65, 0x76, 0x61, 0x73, 0x74, 0x72,
	0x65, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65, 0x72, 0x63, 0x69,
	0x65, 0x72, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x50, 0x65, 0x72,
	0x72, 0x65, 0x61, 0x75, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61, 0x6E, 0x20, 0x52,
	0x6F, 0x62, 0x65, 0x72, 0x74, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x65,
	0x20, 0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E,
	0x00, 0x01, 0x00, 0x07, 0x20, 0x20, 0x50, 0x43, 0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E,
	0x20, 0x50, 0x72, 0x6F, 0x67, 0x72, 0x61, 0x6D, 0x6D, 0x65, 0x72, 0x73, 0x3A, 0x7C, 0x7C, 0xFE,
	0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x68, 0x69,
	0x6C, 0x69, 0x70, 0x70, 0x65, 0x20, 0x43, 0x68, 0x61, 0x73, 0x74, 0x65, 0x6C, 0x20, 0x20, 0x20,
	0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20,
	0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x47, 0x61, 0x65, 0x72, 0x74, 0x68,
	0x6E, 0x65, 0x72, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x6C, 0x61, 0x69, 0x6E, 0x20, 0x52, 0x61, 0x6D, 0x6F,
	0x6E, 0x64, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0xB4, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x05, 0x20,
	0x20, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50, 0x43, 0x20, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x7C, 0x7C, 0xFE, 0x1E,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69,
	0x65, 0x72, 0x72, 0x79, 0x20, 0x4C, 0x65, 0x76, 0x61, 0x73, 0x74, 0x72, 0x65, 0x20, 0x20, 0x7C,
	0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65, 0x72, 0x63, 0x69, 0x65, 0x72, 0x20, 0x20,
	0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x50, 0x65, 0x72, 0x72, 0x65, 0x61, 0x75,
	0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x05, 0x20, 0x20, 0x53, 0x74,
	0x6F, 0x72, 0x79, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69,
	0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x05,
	0x20, 0x20, 0x4C, 0x65, 0x76, 0x65, 0x6C, 0x20, 0x44, 0x65, 0x73, 0x69, 0x67, 0x6E, 0x3A, 0x7C,
	0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20,
	0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x50, 0x61, 0x74, 0x72, 0x69, 0x63, 0x6B, 0x20, 0x44, 0x61, 0x68, 0x65, 0x72, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65, 0x72, 0x63,
	0x69, 0x65, 0x72, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x72, 0x65, 0x64, 0x65, 0x72, 0x69, 0x63, 0x20, 0x53, 0x61,
	0x76, 0x6F, 0x69, 0x72, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x65, 0x20,
	0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00,
	0x01, 0x00, 0x05, 0x20, 0x20, 0x4D, 0x75, 0x73, 0x69, 0x63, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4A,
	0x65, 0x61, 0x6E, 0x20, 0x42, 0x61, 0x75, 0x64, 0x6C, 0x6F, 0x74, 0x20, 0x20, 0x20, 0x7C, 0xFE,
	0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61,
	0x62, 0x72, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20,
	0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x08, 0x20, 0x20, 0x53, 0x6F, 0x75, 0x6E, 0x64,
	0x20, 0x66, 0x78, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x42, 0x65, 0x6E, 0x6F, 0x69, 0x73, 0x74, 0x20, 0x41, 0x72, 0x6F,
	0x6E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x68, 0x69, 0x6C, 0x69, 0x70, 0x70, 0x65, 0x20, 0x43,
	0x68, 0x61, 0x73, 0x74, 0x65, 0x6C, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C,
	0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69,
	0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE, 0x50,
	0xFE, 0x1E, 0x00, 0x01, 0x00, 0x06, 0x20, 0x20, 0x41, 0x63, 0x74, 0x6F, 0x72, 0x73, 0x3A, 0x7C,
	0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x42, 0x65, 0x6E, 0x6F, 0x69, 0x73, 0x74, 0x20, 0x41, 0x72, 0x6F, 0x6E, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x50, 0x61, 0x74, 0x72, 0x69, 0x63, 0x6B, 0x20, 0x44, 0x61, 0x68, 0x65, 0x72, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x4C, 0x65, 0x76, 0x61,
	0x73, 0x74, 0x72, 0x65, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65,
	0x72, 0x63, 0x69, 0x65, 0x72, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20,
	0x50, 0x65, 0x72, 0x72, 0x65, 0x61, 0x75, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61,
	0x6E, 0x20, 0x52, 0x6F, 0x62, 0x65, 0x72, 0x74, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72,
	0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE,
	0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x06, 0x20, 0x20, 0x53, 0x74, 0x75, 0x6E, 0x74, 0x6D, 0x61,
	0x6E, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65, 0x72, 0x63, 0x69,
	0x65, 0x72, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x06, 0x20, 0x20,
	0x56, 0x69, 0x64, 0x65, 0x6F, 0x20, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6F, 0x72, 0x73, 0x3A,
	0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x50, 0x61, 0x74, 0x72, 0x69, 0x63, 0x6B, 0x20, 0x44, 0x61, 0x68, 0x65, 0x72, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x50, 0x65, 0x72, 0x72, 0x65,
	0x61, 0x75, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73,
	0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x06,
	0x20, 0x20, 0x56, 0x69, 0x64, 0x65, 0x6F, 0x20, 0x43, 0x6F, 0x2D, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6F, 0x72, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x4C, 0x65,
	0x76, 0x61, 0x73, 0x74, 0x72, 0x65, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20,
	0x4D, 0x65, 0x72, 0x63, 0x69, 0x65, 0x72, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61,
	0x6E, 0x20, 0x52, 0x6F, 0x62, 0x65, 0x72, 0x74, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE,
	0x1E, 0x00, 0x01, 0x00, 0x06, 0x20, 0x20, 0x56, 0x69, 0x64, 0x65, 0x6F, 0x20, 0x73, 0x66, 0x78,
	0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65,
	0x74, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x50, 0x65, 0x72, 0x72,
	0x65, 0x61, 0x75, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69,
	0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00,
	0x07, 0x20, 0x20, 0x54, 0x65, 0x73, 0x74, 0x65, 0x72, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50,
	0x68, 0x69, 0x6C, 0x20, 0x42, 0x72, 0x61, 0x64, 0x6C, 0x65, 0x79, 0x20, 0x20, 0x20, 0x7C, 0xFE,
	0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x74,
	0x72, 0x69, 0x63, 0x69, 0x61, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x20,
	0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x53, 0x69, 0x6D, 0x6F, 0x6E, 0x20, 0x48, 0x61, 0x64, 0x6C, 0x69, 0x6E, 0x67, 0x74,
	0x6F, 0x6E, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x44, 0x61, 0x6E, 0x69, 0x65, 0x6C, 0x20, 0x4C, 0x6C, 0x65, 0x77, 0x65, 0x6C,
	0x6C, 0x79, 0x6E, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x4A, 0x65, 0x61, 0x6E, 0x2D, 0x50, 0x69, 0x65, 0x72, 0x72, 0x65, 0x20, 0x4C, 0x75, 0x63, 0x6B,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4D, 0x61, 0x72, 0x74, 0x69, 0x6E, 0x20, 0x53, 0x6D,
	0x69, 0x74, 0x68, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00,
	0x08, 0x20, 0x20, 0x4D, 0x61, 0x6E, 0x79, 0x20, 0x74, 0x68, 0x61, 0x6E, 0x6B, 0x73, 0x20, 0x74,
	0x6F, 0x2E, 0x2E, 0x2E, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4C, 0x6F, 0x72, 0x69, 0x20, 0x43, 0x68, 0x72, 0x69,
	0x73, 0x74, 0x65, 0x6E, 0x73, 0x65, 0x6E, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x74, 0x72, 0x69, 0x63, 0x69, 0x61, 0x20, 0x43, 0x75,
	0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x6E, 0x6E, 0x65, 0x2D, 0x4D, 0x61, 0x72, 0x69, 0x65, 0x20,
	0x4A, 0x6F, 0x61, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4A, 0x65, 0x61, 0x6E, 0x2D, 0x50, 0x69, 0x65, 0x72, 0x72,
	0x65, 0x20, 0x4C, 0x75, 0x63, 0x6B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4D,
	0x61, 0x72, 0x63, 0x20, 0x4D, 0x69, 0x6E, 0x69, 0x65, 0x72, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C,
	0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x05, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x20, 0x62, 0x79, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00,
	0x03, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x72, 0x6F, 0x64, 0x75,
	0x63, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x7C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6C,
	0x70, 0x68, 0x69, 0x6E, 0x65, 0x20, 0x53, 0x6F, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x55, 0x53, 0x20, 0x47, 0x4F, 0x4C, 0x44, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x7C, 0x20, 0x7C,
	0x20, 0x7C, 0x20, 0x7C, 0x20, 0x7C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x28, 0x63, 0x29, 0x4D, 0x43, 0x4D, 0x58, 0x43, 0x49, 0x49, 0x49, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0xFF, 0x00, 0xFF
};

const uint8_t Cutscene::_creditsDataAmiga[] = {
	0xFE, 0x14, 0x00, 0x01, 0x00, 0x08, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x65, 0x20, 0x46,
	0x6C, 0x61, 0x73, 0x68, 0x42, 0x61, 0x63, 0x6B, 0x20, 0x54, 0x65, 0x61, 0x6D, 0x20, 0x69, 0x73,
	0x2E, 0x2E, 0x2E, 0xFE, 0x32, 0x00, 0x01, 0x00, 0x08, 0x20, 0x20, 0x41, 0x6D, 0x69, 0x67, 0x61,
	0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x3A, 0x7C, 0xFE, 0x14, 0x7C, 0x7C, 0xFE, 0x14,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x42,
	0x65, 0x6E, 0x6F, 0x69, 0x73, 0x74, 0x20, 0x41, 0x72, 0x6F, 0x6E, 0x20, 0x20, 0x20, 0x20, 0x7C,
	0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x4C, 0x65, 0x76, 0x61, 0x73, 0x74, 0x72,
	0x65, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x50, 0x65, 0x72, 0x72,
	0x65, 0x61, 0x75, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0xFE, 0x14, 0x00, 0x01, 0x00, 0x07, 0x00, 0x01,
	0x00, 0x09, 0x20, 0x20, 0x50, 0x72, 0x6F, 0x67, 0x72, 0x61, 0x6D, 0x6D, 0x65, 0x72, 0x73, 0x3A,
	0x7C, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x42, 0x65, 0x6E, 0x6F, 0x69, 0x73, 0x74, 0x20, 0x41, 0x72, 0x6F, 0x6E,
	0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x68, 0x69, 0x6C, 0x69, 0x70, 0x70, 0x65, 0x20, 0x43,
	0x68, 0x61, 0x73, 0x74, 0x65, 0x6C, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x75,
	0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x72, 0x65, 0x64,
	0x65, 0x72, 0x69, 0x63, 0x20, 0x53, 0x61, 0x76, 0x6F, 0x69, 0x72, 0x20, 0x20, 0x7C, 0xFE, 0x14,
	0xFE, 0x14, 0x00, 0x01, 0x00, 0x07, 0x20, 0x20, 0x47, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x20,
	0x41, 0x72, 0x74, 0x69, 0x73, 0x74, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x74, 0x72, 0x69,
	0x63, 0x6B, 0x20, 0x44, 0x61, 0x68, 0x65, 0x72, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68,
	0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x4C, 0x65, 0x76, 0x61, 0x73, 0x74, 0x72, 0x65, 0x20, 0x7C,
	0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65, 0x72, 0x63, 0x69, 0x65, 0x72,
	0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x50, 0x65, 0x72, 0x72,
	0x65, 0x61, 0x75, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61, 0x6E, 0x20, 0x52,
	0x6F, 0x62, 0x65, 0x72, 0x74, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63,
	0x65, 0x20, 0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x7C, 0xFE, 0x14, 0xFE, 0x14,
	0x00, 0x01, 0x00, 0x07, 0x20, 0x20, 0x48, 0x61, 0x72, 0x64, 0x77, 0x61, 0x72, 0x65, 0x20, 0x45,
	0x6E, 0x67, 0x69, 0x6E, 0x65, 0x65, 0x72, 0x3A, 0x7C, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72,
	0x79, 0x20, 0x47, 0x61, 0x65, 0x72, 0x74, 0x68, 0x6E, 0x65, 0x72, 0x20, 0x7C, 0xFE, 0x14, 0x00,
	0x01, 0x00, 0x07, 0x20, 0x20, 0x53, 0x74, 0x6F, 0x72, 0x79, 0x3A, 0x7C, 0x7C, 0xFE, 0x14, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x7C,
	0xFE, 0x14, 0x00, 0x01, 0x00, 0x08, 0x20, 0x20, 0x4C, 0x65, 0x76, 0x65, 0x6C, 0x20, 0x44, 0x65,
	0x73, 0x69, 0x67, 0x6E, 0x3A, 0x7C, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20,
	0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x74, 0x72, 0x69,
	0x63, 0x6B, 0x20, 0x44, 0x61, 0x68, 0x65, 0x72, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65, 0x72, 0x63, 0x69, 0x65, 0x72, 0x20, 0x20, 0x7C,
	0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x46, 0x72, 0x65, 0x64, 0x65, 0x72, 0x69, 0x63, 0x20, 0x53, 0x61, 0x76, 0x6F, 0x69, 0x72, 0x20,
	0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x73,
	0x65, 0x72, 0x6F, 0x74, 0x20, 0x7C, 0xFE, 0x14, 0xFE, 0x14, 0x00, 0x01, 0x00, 0x08, 0x20, 0x20,
	0x4D, 0x75, 0x73, 0x69, 0x63, 0x3A, 0x7C, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4A, 0x65, 0x61, 0x6E,
	0x20, 0x42, 0x61, 0x75, 0x64, 0x6C, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x52, 0x61, 0x70, 0x68,
	0x61, 0x65, 0x6C, 0x20, 0x47, 0x65, 0x73, 0x71, 0x75, 0x61, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46,
	0x61, 0x62, 0x72, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20,
	0x7C, 0xFE, 0x14, 0xFE, 0x14, 0x00, 0x01, 0x00, 0x08, 0x20, 0x20, 0x53, 0x6F, 0x75, 0x6E, 0x64,
	0x20, 0x66, 0x78, 0x3A, 0x7C, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x42, 0x65, 0x6E, 0x6F, 0x69, 0x73, 0x74, 0x20, 0x41,
	0x72, 0x6F, 0x6E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x68, 0x69, 0x6C, 0x69, 0x70, 0x70,
	0x65, 0x20, 0x43, 0x68, 0x61, 0x73, 0x74, 0x65, 0x6C, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x7C, 0xFE,
	0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74,
	0x20, 0x7C, 0xFE, 0x14, 0xFE, 0x14, 0x00, 0x01, 0x00, 0x06, 0x20, 0x20, 0x41, 0x63, 0x74, 0x6F,
	0x72, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x42, 0x65, 0x6E, 0x6F, 0x69, 0x73, 0x74, 0x20, 0x41, 0x72,
	0x6F, 0x6E, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x74, 0x72, 0x69, 0x63, 0x6B, 0x20,
	0x44, 0x61, 0x68, 0x65, 0x72, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72,
	0x72, 0x79, 0x20, 0x4C, 0x65, 0x76, 0x61, 0x73, 0x74, 0x72, 0x65, 0x20, 0x7C, 0xFE, 0x14, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65, 0x72, 0x63, 0x69, 0x65, 0x72, 0x20, 0x20, 0x7C,
	0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x50, 0x65, 0x72, 0x72, 0x65, 0x61, 0x75,
	0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61, 0x6E, 0x20, 0x52, 0x6F, 0x62, 0x65,
	0x72, 0x74, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x65, 0x20, 0x56,
	0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x7C, 0xFE, 0x14, 0xFE, 0x14, 0x00, 0x01, 0x00,
	0x0A, 0x20, 0x20, 0x56, 0x69, 0x64, 0x65, 0x6F, 0x20, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6F,
	0x72, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x09, 0x20, 0x20, 0x20, 0x50, 0x61, 0x74, 0x72, 0x69, 0x63, 0x6B, 0x20, 0x44,
	0x61, 0x68, 0x65, 0x72, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72,
	0x79, 0x20, 0x50, 0x65, 0x72, 0x72, 0x65, 0x61, 0x75, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62,
	0x72, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x7C, 0xFE,
	0x14, 0xFE, 0x14, 0x00, 0x01, 0x00, 0x0A, 0x20, 0x20, 0x56, 0x69, 0x64, 0x65, 0x6F, 0x20, 0x43,
	0x6F, 0x2D, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6F, 0x72, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x14,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54,
	0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x4C, 0x65, 0x76, 0x61, 0x73, 0x74, 0x72, 0x65, 0x20,
	0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65, 0x72, 0x63, 0x69, 0x65,
	0x72, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61, 0x6E, 0x20, 0x52, 0x6F, 0x62,
	0x65, 0x72, 0x74, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0xFE, 0x14, 0x00, 0x01, 0x00, 0x0A, 0x20,
	0x20, 0x56, 0x69, 0x64, 0x65, 0x6F, 0x20, 0x73, 0x66, 0x78, 0x3A, 0x7C, 0x7C, 0xFE, 0x14, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x7C,
	0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x50, 0x65, 0x72, 0x72, 0x65, 0x61, 0x75,
	0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x73,
	0x65, 0x72, 0x6F, 0x74, 0x20, 0x7C, 0xFE, 0x14, 0xFE, 0x14, 0x00, 0x01, 0x00, 0x07, 0x20, 0x20,
	0x54, 0x65, 0x73, 0x74, 0x65, 0x72, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x68, 0x69, 0x6C,
	0x20, 0x42, 0x72, 0x61, 0x64, 0x6C, 0x65, 0x79, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x74, 0x72, 0x69,
	0x63, 0x69, 0x61, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x20, 0x20, 0x7C,
	0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x53, 0x69, 0x6D, 0x6F, 0x6E, 0x20, 0x48, 0x61, 0x64, 0x6C, 0x69, 0x6E, 0x67, 0x74, 0x6F,
	0x6E, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x44, 0x61, 0x6E, 0x69, 0x65, 0x6C, 0x20, 0x4C, 0x6C, 0x65, 0x77, 0x65, 0x6C,
	0x6C, 0x79, 0x6E, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x4A, 0x65, 0x61, 0x6E, 0x2D, 0x50, 0x69, 0x65, 0x72, 0x72, 0x65, 0x20, 0x4C, 0x75, 0x63,
	0x6B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4D, 0x61, 0x72, 0x74, 0x69, 0x6E, 0x20,
	0x53, 0x6D, 0x69, 0x74, 0x68, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0xFE, 0x14,
	0x00, 0x01, 0x00, 0x08, 0x20, 0x20, 0x4D, 0x61, 0x6E, 0x79, 0x20, 0x74, 0x68, 0x61, 0x6E, 0x6B,
	0x73, 0x20, 0x74, 0x6F, 0x2E, 0x2E, 0x2E, 0x7C, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4C, 0x6F, 0x72, 0x69, 0x20, 0x43,
	0x68, 0x72, 0x69, 0x73, 0x74, 0x65, 0x6E, 0x73, 0x65, 0x6E, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x74, 0x72, 0x69, 0x63, 0x69,
	0x61, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE,
	0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x6E, 0x6E, 0x65, 0x2D, 0x4D,
	0x61, 0x72, 0x69, 0x65, 0x20, 0x4A, 0x6F, 0x61, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4A, 0x65, 0x61, 0x6E,
	0x2D, 0x50, 0x69, 0x65, 0x72, 0x72, 0x65, 0x20, 0x4C, 0x75, 0x63, 0x6B, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4D, 0x61, 0x72, 0x63, 0x20, 0x4D, 0x69, 0x6E, 0x69, 0x65,
	0x72, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0xFE, 0x14, 0x00, 0x01, 0x00, 0x05,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x7C, 0x7C, 0xFE, 0x14, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61,
	0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x14, 0xFE, 0x14, 0x00, 0x01, 0x00, 0x05, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x72, 0x6F, 0x64, 0x75, 0x63, 0x65, 0x64, 0x20,
	0x62, 0x79, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0x7C, 0xFE,
	0x14, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6C, 0x70, 0x68, 0x69, 0x6E, 0x65, 0x20, 0x53, 0x6F, 0x66,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x20, 0x2F, 0x20, 0x55, 0x53, 0x20, 0x47, 0x4F, 0x4C, 0x44, 0x20,
	0x20, 0x7C, 0xFE, 0x14, 0x20, 0x7C, 0x20, 0x7C, 0x20, 0x7C, 0x20, 0x7C, 0x20, 0x7C, 0x20, 0x7C,
	0x20, 0x7C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x28, 0x63, 0x29, 0x4D,
	0x43, 0x4D, 0x58, 0x43, 0x49, 0x49, 0x49, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x7C, 0xFE, 0x14, 0xFE, 0x28, 0x00, 0xFF
};

const uint16_t Cutscene::_creditsCutSeq[] =  {
	0x00, 0x05, 0x2F, 0x32, 0x36, 0x3E, 0x30, 0x39, 0x3F, 0x14, 0x34, 0xFFFF
};

const uint8_t Cutscene::_musicTableDOS[] = {
	0x10, 0x15, 0x15, 0xFF, 0x15, 0x19, 0x0F, 0xFF, 0x15, 0x04, 0x15, 0xFF, 0xFF, 0x00, 0x19, 0x15,
	0x15, 0x0D, 0x15, 0x0D, 0x18, 0x13, 0xFF, 0xFF, 0xFF, 0x14, 0x14, 0x14, 0x14, 0x14, 0xFF, 0xFF,
	0x13, 0x13, 0x13, 0x13, 0x15, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x13, 0x11, 0xFF, 0x03,
	0x0E, 0x13, 0x12, 0xFF, 0x06, 0x07, 0x0A, 0x0A, 0x15, 0x05, 0x13, 0x02, 0x15, 0x09, 0x17, 0x08,
	0x0B, 0x0C, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0xFF, 0xFF, 0xFF
};

const uint8_t Cutscene::_musicTableAmiga[] = {
	0x10, 0x7D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x7D, 0xFF, 0xFF,
	0xFF, 0xFF, 0x04, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x6B, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0x0D, 0x7D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x7D, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x13, 0x7D, 0x13, 0x7D, 0x13, 0x7D, 0x13, 0x7D, 0xFF, 0xFF, 0x14, 0x7D, 0x14, 0x7D, 0x14, 0x7D,
	0x14, 0x7D, 0x14, 0x7D, 0x14, 0x7D, 0x13, 0x9B, 0x13, 0x9B, 0x11, 0x7D, 0xFF, 0xFF, 0x03, 0x78,
	0x0E, 0x7D, 0x13, 0x7D, 0x12, 0x6E, 0xFF, 0xFF, 0x06, 0x87, 0x07, 0x7D, 0x0A, 0x7D, 0x0A, 0x7D,
	0xFF, 0xFF, 0x05, 0x7D, 0x13, 0x7D, 0x02, 0x7D, 0xFF, 0xFF, 0x09, 0x7D, 0xFF, 0xFF, 0x08, 0x7D,
	0x0B, 0x7D, 0x0C, 0x7D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0x3D, 0x25, 0x27, 0x28
};

const uint8_t Cutscene::_protectionShapeData[] = {
	0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x06, 0xD4, 0x00, 0x00, 0x00, 0x92,
	0x00, 0x00, 0x08, 0x24, 0x00, 0x00, 0x00, 0x02, 0x00, 0x28, 0x00, 0x54, 0x00, 0x8C, 0x00, 0xB2,
	0x00, 0xDE, 0x01, 0x21, 0x01, 0x54, 0x01, 0x7B, 0x01, 0x9D, 0x01, 0xC2, 0x01, 0xF0, 0x02, 0x2C,
	0x02, 0x66, 0x02, 0x9F, 0x02, 0xBF, 0x02, 0xF7, 0x03, 0x35, 0x03, 0x75, 0x03, 0xA4, 0x03, 0xFE,
	0x04, 0x3B, 0x04, 0x7B, 0x04, 0xB6, 0x04, 0xF8, 0x05, 0x3B, 0x05, 0x66, 0x05, 0x9E, 0x05, 0xD2,
	0x06, 0x10, 0x00, 0x00, 0x0F, 0xFF, 0x02, 0x22, 0x03, 0x33, 0x04, 0x44, 0x05, 0x55, 0x06, 0x66,
	0x07, 0x77, 0x08, 0x88, 0x09, 0x99, 0x0A, 0xAA, 0x0B, 0xBB, 0x0C, 0xCC, 0x0D, 0xDD, 0x0E, 0xEE,
	0x0F, 0xFF, 0x00, 0x00, 0x04, 0x05, 0x05, 0x05, 0x00, 0x00, 0x04, 0x44, 0x05, 0x55, 0x06, 0x66,
	0x07, 0x77, 0x08, 0x88, 0x09, 0x99, 0x0A, 0xAA, 0x0B, 0xBB, 0x0C, 0xCC, 0x0D, 0xDD, 0x0E, 0xEE,
	0x0F, 0xFF, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x02, 0x00, 0x01, 0x01, 0x00, 0x02, 0x02, 0x00,
	0x03, 0x01, 0x00, 0x04, 0x02, 0x00, 0x05, 0x01, 0x00, 0x06, 0x02, 0x00, 0x07, 0x02, 0x00, 0x08,
	0x02, 0x00, 0x09, 0x01, 0x00, 0x0A, 0x02, 0x00, 0x0B, 0x02, 0x00, 0x0A, 0x00, 0x0C, 0x02, 0x00,
	0x0D, 0x01, 0x00, 0x0E, 0x02, 0x00, 0x0F, 0x01, 0x80, 0x0A, 0x00, 0x61, 0x00, 0x00, 0x02, 0x00,
	0x10, 0x01, 0x80, 0x02, 0xFF, 0xC9, 0xFF, 0xFF, 0x02, 0x80, 0x04, 0xFF, 0xB1, 0xFF, 0xFF, 0x02,
	0x00, 0x11, 0x01, 0x00, 0x12, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x02, 0x80, 0x0D, 0x00, 0x00, 0x00,
	0x0E, 0x01, 0x80, 0x0E, 0x00, 0x00, 0x00, 0x0E, 0x02, 0x00, 0x13, 0x01, 0x00, 0x14, 0x02, 0x00,
	0x15, 0x01, 0x00, 0x16, 0x02, 0x80, 0x0B, 0xFF, 0xEE, 0x00, 0x4C, 0x02, 0x00, 0x17, 0x01, 0x00,
	0x18, 0x01, 0x00, 0x19, 0x02, 0x00, 0x1A, 0x02, 0x00, 0x1B, 0x02, 0x00, 0x1C, 0x02, 0x00, 0x08,
	0x00, 0x00, 0x02, 0x00, 0x18, 0x01, 0x00, 0x19, 0x02, 0x80, 0x0D, 0x00, 0x00, 0x00, 0x46, 0x01,
	0x80, 0x0E, 0x00, 0x00, 0x00, 0x46, 0x02, 0x00, 0x1D, 0x01, 0x00, 0x1E, 0x02, 0x80, 0x0B, 0x00,
	0x08, 0x00, 0x4D, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x02, 0x00, 0x1F, 0x01, 0x00, 0x20, 0x02, 0x00,
	0x21, 0x02, 0x00, 0x22, 0x02, 0x00, 0x23, 0x01, 0x00, 0x24, 0x02, 0x00, 0x25, 0x01, 0x00, 0x26,
	0x01, 0x00, 0x27, 0x02, 0x00, 0x28, 0x01, 0x00, 0x29, 0x02, 0x00, 0x2A, 0x01, 0x00, 0x2B, 0x01,
	0x00, 0x0F, 0x00, 0x00, 0x02, 0x00, 0x2C, 0x01, 0x00, 0x2D, 0x01, 0x00, 0x2E, 0x02, 0x00, 0x2F,
	0x01, 0x00, 0x30, 0x02, 0x80, 0x18, 0x00, 0x00, 0x00, 0x7F, 0x01, 0x80, 0x19, 0x00, 0x00, 0x00,
	0x7F, 0x02, 0x80, 0x0A, 0x00, 0x03, 0xFF, 0xB2, 0x01, 0x80, 0x0A, 0x00, 0x03, 0xFF, 0xDB, 0x01,
	0x00, 0x31, 0x01, 0x00, 0x32, 0x01, 0x00, 0x33, 0x01, 0x80, 0x31, 0x00, 0x10, 0x00, 0x22, 0x02,
	0x00, 0x34, 0x02, 0x00, 0x0F, 0x00, 0x00, 0x02, 0x00, 0x14, 0x02, 0x00, 0x15, 0x01, 0x00, 0x16,
	0x02, 0x80, 0x0B, 0xFF, 0xEE, 0x00, 0x4C, 0x02, 0x00, 0x18, 0x01, 0x00, 0x19, 0x02, 0x00, 0x25,
	0x01, 0x00, 0x26, 0x01, 0x00, 0x27, 0x02, 0x00, 0x28, 0x01, 0x00, 0x29, 0x02, 0x00, 0x2A, 0x01,
	0x00, 0x35, 0x01, 0x00, 0x36, 0x02, 0x00, 0x0B, 0x00, 0x00, 0x02, 0x00, 0x37, 0x01, 0x00, 0x38,
	0x02, 0x00, 0x39, 0x01, 0x00, 0x3A, 0x02, 0x00, 0x3B, 0x02, 0x80, 0x28, 0xFF, 0xC8, 0x00, 0x0B,
	0x01, 0x00, 0x3C, 0x02, 0x00, 0x3D, 0x01, 0x00, 0x3E, 0x01, 0x00, 0x3F, 0x02, 0x00, 0x08, 0x00,
	0x00, 0x02, 0x00, 0x40, 0x01, 0x00, 0x41, 0x02, 0x00, 0x42, 0x01, 0x80, 0x2D, 0x00, 0x00, 0x00,
	0x7E, 0x01, 0x80, 0x2E, 0x00, 0x00, 0x00, 0x36, 0x02, 0x00, 0x43, 0x01, 0x00, 0x44, 0x02, 0x00,
	0x09, 0x00, 0x00, 0x02, 0x00, 0x45, 0x01, 0x00, 0x46, 0x02, 0x00, 0x47, 0x01, 0x00, 0x48, 0x02,
	0x00, 0x49, 0x01, 0x80, 0x2D, 0xFF, 0xDA, 0x00, 0x7D, 0x01, 0x80, 0x2E, 0xFF, 0xE5, 0x00, 0x36,
	0x02, 0x00, 0x4A, 0x01, 0x00, 0x0C, 0x00, 0x00, 0x02, 0x00, 0x25, 0x01, 0x00, 0x26, 0x01, 0x00,
	0x27, 0x02, 0x00, 0x28, 0x01, 0x00, 0x29, 0x02, 0x00, 0x2A, 0x01, 0x00, 0x10, 0x01, 0x80, 0x02,
	0xFF, 0xC9, 0xFF, 0xFF, 0x02, 0x80, 0x04, 0xFF, 0xB1, 0xFF, 0xFF, 0x02, 0x00, 0x11, 0x01, 0x00,
	0x12, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x02, 0x00, 0x4B, 0x01, 0x00, 0x4C, 0x02, 0x80, 0x14, 0x00,
	0x34, 0xFF, 0xDF, 0x02, 0x00, 0x4D, 0x01, 0x00, 0x4E, 0x02, 0x00, 0x4F, 0x01, 0x00, 0x50, 0x02,
	0x00, 0x51, 0x02, 0x00, 0x52, 0x02, 0x80, 0x18, 0x00, 0x7F, 0x00, 0x7F, 0x01, 0x80, 0x19, 0x00,
	0x7F, 0x00, 0x7F, 0x02, 0x00, 0x53, 0x03, 0x80, 0x2B, 0xFF, 0xF9, 0x00, 0x05, 0x01, 0x00, 0x0C,
	0x00, 0x00, 0x02, 0x00, 0x40, 0x01, 0x00, 0x41, 0x02, 0x00, 0x54, 0x01, 0x80, 0x38, 0xFF, 0xF3,
	0x00, 0x00, 0x02, 0x80, 0x2E, 0x00, 0x00, 0x00, 0x36, 0x02, 0x80, 0x47, 0x00, 0x00, 0x00, 0x2C,
	0x01, 0x00, 0x55, 0x02, 0x80, 0x47, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x80, 0x55, 0x00, 0x00, 0xFF,
	0xE1, 0x02, 0x00, 0x43, 0x01, 0x00, 0x44, 0x02, 0x00, 0x0D, 0x00, 0x00, 0x02, 0x00, 0x39, 0x01,
	0x00, 0x3A, 0x02, 0x00, 0x3B, 0x02, 0x80, 0x28, 0xFF, 0xC8, 0x00, 0x0B, 0x01, 0x00, 0x3C, 0x02,
	0x80, 0x15, 0x00, 0x00, 0xFF, 0xF1, 0x01, 0x80, 0x16, 0x00, 0x00, 0xFF, 0xF1, 0x02, 0x80, 0x0B,
	0xFF, 0xEE, 0x00, 0x3D, 0x02, 0x00, 0x56, 0x01, 0x00, 0x57, 0x02, 0x00, 0x58, 0x01, 0x00, 0x59,
	0x02, 0x00, 0x0A, 0x00, 0x00, 0x02, 0x00, 0x5A, 0x01, 0x00, 0x5B, 0x02, 0x00, 0x5C, 0x01, 0x00,
	0x5D, 0x02, 0x00, 0x5E, 0x01, 0x00, 0x5F, 0x01, 0x00, 0x60, 0x02, 0x00, 0x61, 0x02, 0x00, 0x62,
	0x01, 0x00, 0x0A, 0x00, 0x00, 0x02, 0x00, 0x63, 0x01, 0x80, 0x41, 0x00, 0x3B, 0x00, 0x1F, 0x02,
	0x80, 0x56, 0x00, 0x00, 0xFF, 0xCB, 0x01, 0x80, 0x57, 0x00, 0x00, 0xFF, 0xCB, 0x02, 0x00, 0x64,
	0x01, 0x00, 0x65, 0x02, 0x80, 0x28, 0x00, 0x05, 0xFF, 0xF3, 0x01, 0x80, 0x18, 0x00, 0x00, 0x00,
	0x7F, 0x01, 0x80, 0x19, 0x00, 0x00, 0x00, 0x7F, 0x02, 0x00, 0x0C, 0x00, 0x00, 0x02, 0x00, 0x39,
	0x01, 0x00, 0x3A, 0x02, 0x00, 0x3B, 0x02, 0x80, 0x28, 0xFF, 0xC8, 0x00, 0x0B, 0x01, 0x00, 0x3C,
	0x02, 0x80, 0x15, 0x00, 0x00, 0xFF, 0xDF, 0x01, 0x80, 0x16, 0x00, 0x00, 0xFF, 0xDF, 0x02, 0x80,
	0x0B, 0xFF, 0xEE, 0x00, 0x2B, 0x02, 0x00, 0x66, 0x01, 0x80, 0x5B, 0x00, 0x2F, 0x00, 0x00, 0x02,
	0x80, 0x62, 0x00, 0x2F, 0x00, 0x00, 0x01, 0x00, 0x0A, 0x00, 0x00, 0x02, 0x80, 0x18, 0x00, 0x00,
	0x00, 0x7F, 0x01, 0x80, 0x19, 0x00, 0x00, 0x00, 0x7F, 0x02, 0x80, 0x5A, 0x00, 0x00, 0xFF, 0xA3,
	0x01, 0x80, 0x5B, 0x00, 0x00, 0xFF, 0xC5, 0x02, 0x80, 0x62, 0x00, 0x00, 0xFF, 0xC5, 0x01, 0x80,
	0x47, 0x00, 0x00, 0x00, 0x2C, 0x01, 0x00, 0x55, 0x02, 0x80, 0x47, 0x00, 0x00, 0x00, 0x0D, 0x01,
	0x80, 0x55, 0x00, 0x00, 0xFF, 0xE1, 0x02, 0x00, 0x0B, 0x00, 0x00, 0x02, 0x00, 0x67, 0x01, 0x00,
	0x68, 0x02, 0x00, 0x69, 0x01, 0x00, 0x6A, 0x01, 0x00, 0x6B, 0x02, 0x00, 0x6C, 0x02, 0x80, 0x58,
	0xFF, 0xD2, 0xFF, 0xE0, 0x01, 0x80, 0x59, 0xFF, 0xD2, 0xFF, 0xE0, 0x02, 0x00, 0x6D, 0x01, 0x80,
	0x14, 0xFF, 0xDB, 0x00, 0x16, 0x01, 0x00, 0x10, 0x00, 0x00, 0x02, 0x00, 0x42, 0x01, 0x80, 0x2D,
	0x00, 0x00, 0x00, 0x7E, 0x01, 0x80, 0x2E, 0x00, 0x00, 0x00, 0x36, 0x02, 0x00, 0x10, 0x01, 0x80,
	0x02, 0xFF, 0xC9, 0xFF, 0xFF, 0x02, 0x80, 0x04, 0xFF, 0xB1, 0xFF, 0xFF, 0x02, 0x00, 0x11, 0x01,
	0x00, 0x12, 0x02, 0x80, 0x31, 0x00, 0x04, 0xFF, 0xED, 0x01, 0x00, 0x6E, 0x01, 0x80, 0x33, 0x00,
	0x04, 0xFF, 0x97, 0x01, 0x80, 0x31, 0x00, 0x14, 0xFF, 0xCB, 0x02, 0x80, 0x34, 0x00, 0x04, 0xFF,
	0xEC, 0x02, 0x80, 0x47, 0x00, 0x00, 0x00, 0x04, 0x01, 0x80, 0x55, 0x00, 0x00, 0xFF, 0xD8, 0x02,
	0x00, 0x0D, 0x00, 0x00, 0x02, 0x80, 0x31, 0xFF, 0xBB, 0xFF, 0xFF, 0x01, 0x80, 0x32, 0xFF, 0xBB,
	0xFF, 0xFF, 0x01, 0x00, 0x6F, 0x01, 0x80, 0x31, 0xFF, 0xCB, 0x00, 0x21, 0x02, 0x80, 0x34, 0xFF,
	0xBB, 0xFF, 0xFF, 0x02, 0x00, 0x18, 0x01, 0x00, 0x19, 0x02, 0x00, 0x70, 0x01, 0x00, 0x71, 0x02,
	0x00, 0x72, 0x02, 0x00, 0x73, 0x02, 0x80, 0x28, 0xFF, 0xEE, 0x00, 0x2B, 0x01, 0x00, 0x0E, 0x00,
	0x00, 0x02, 0x00, 0x74, 0x01, 0x80, 0x2D, 0xFF, 0xF1, 0x00, 0x7D, 0x01, 0x80, 0x2E, 0x00, 0x00,
	0x00, 0x36, 0x02, 0x80, 0x31, 0xFF, 0xFB, 0xFF, 0xBF, 0x01, 0x00, 0x75, 0x01, 0x00, 0x76, 0x01,
	0x80, 0x31, 0x00, 0x1D, 0xFF, 0xCF, 0x02, 0x00, 0x77, 0x02, 0x00, 0x40, 0x01, 0x00, 0x41, 0x02,
	0x00, 0x78, 0x01, 0x00, 0x79, 0x01, 0x80, 0x28, 0xFF, 0xF8, 0x00, 0x05, 0x01, 0x00, 0x0F, 0x00,
	0x00, 0x02, 0x00, 0x4D, 0x01, 0x00, 0x4B, 0x01, 0x00, 0x7A, 0x02, 0x80, 0x14, 0x00, 0x33, 0xFF,
	0xDC, 0x02, 0x00, 0x4E, 0x02, 0x00, 0x7B, 0x01, 0x00, 0x7C, 0x02, 0x80, 0x15, 0x00, 0x66, 0xFF,
	0xD5, 0x01, 0x00, 0x7D, 0x02, 0x80, 0x0B, 0x00, 0x43, 0x00, 0x21, 0x02, 0x00, 0x7E, 0x01, 0x00,
	0x7F, 0x01, 0x00, 0x80, 0x01, 0x00, 0x81, 0x02, 0x00, 0x0C, 0x00, 0x00, 0x02, 0x80, 0x54, 0x00,
	0x00, 0xFF, 0xBA, 0x01, 0x80, 0x38, 0xFF, 0xF3, 0xFF, 0xF3, 0x02, 0x00, 0x56, 0x01, 0x00, 0x57,
	0x02, 0x00, 0x58, 0x01, 0x00, 0x59, 0x02, 0x80, 0x47, 0x00, 0x00, 0xFF, 0xEA, 0x01, 0x80, 0x55,
	0x00, 0x00, 0xFF, 0xBE, 0x02, 0x80, 0x47, 0x00, 0x00, 0xFF, 0xCB, 0x01, 0x80, 0x55, 0x00, 0x00,
	0xFF, 0x9F, 0x02, 0x80, 0x2B, 0x00, 0x0A, 0xFF, 0xC0, 0x01, 0x00, 0x0F, 0x00, 0x00, 0x02, 0x00,
	0x82, 0x01, 0x00, 0x83, 0x01, 0x80, 0x18, 0x00, 0x7F, 0x00, 0x00, 0x01, 0x80, 0x19, 0x00, 0x7F,
	0x00, 0x00, 0x02, 0x00, 0x53, 0x03, 0x00, 0x84, 0x01, 0x00, 0x85, 0x02, 0x00, 0x86, 0x02, 0x80,
	0x31, 0x00, 0x1D, 0x00, 0x1D, 0x02, 0x00, 0x87, 0x01, 0x80, 0x0A, 0x00, 0x16, 0xFF, 0xF6, 0x02,
	0x00, 0x88, 0x02, 0x80, 0x31, 0xFF, 0xFB, 0x00, 0x2D, 0x01, 0x00, 0x89, 0x01, 0x00, 0x0B, 0x00,
	0x00, 0x02, 0x00, 0x8A, 0x01, 0x80, 0x46, 0x00, 0x01, 0xFF, 0xE9, 0x02, 0x00, 0x8B, 0x01, 0x80,
	0x78, 0xFF, 0xDF, 0x00, 0x0B, 0x02, 0x00, 0x8C, 0x01, 0x00, 0x8D, 0x01, 0x00, 0x8E, 0x02, 0x00,
	0x8F, 0x01, 0x00, 0x90, 0x02, 0x00, 0x91, 0x01, 0x00, 0x0E, 0x00, 0x00, 0x02, 0x00, 0x92, 0x01,
	0x80, 0x02, 0xFF, 0xA7, 0x00, 0x58, 0x02, 0x00, 0x93, 0x01, 0x00, 0x94, 0x02, 0x00, 0x95, 0x02,
	0x00, 0x96, 0x01, 0x00, 0x97, 0x02, 0x00, 0x98, 0x01, 0x00, 0x99, 0x02, 0x00, 0x9A, 0x01, 0x00,
	0x9B, 0x02, 0x80, 0x9A, 0xFF, 0xE1, 0x00, 0x00, 0x01, 0x80, 0x9B, 0xFF, 0xE1, 0x00, 0x00, 0x02,
	0x00, 0x0A, 0x00, 0x00, 0x02, 0x80, 0x02, 0xFF, 0xA7, 0x00, 0x58, 0x02, 0x00, 0x9C, 0x01, 0x00,
	0x9D, 0x02, 0x00, 0x9E, 0x02, 0x80, 0x73, 0xFF, 0xBF, 0x00, 0x7F, 0x02, 0x80, 0x28, 0xFF, 0xAB,
	0x00, 0x2C, 0x01, 0x80, 0x18, 0x00, 0x7F, 0x00, 0x7F, 0x01, 0x80, 0x19, 0x00, 0x7F, 0x00, 0x7F,
	0x02, 0x00, 0x53, 0x03, 0x00, 0x0C, 0x00, 0x00, 0x02, 0x80, 0x17, 0x00, 0x01, 0x00, 0x00, 0x01,
	0x00, 0x9F, 0x01, 0x00, 0xA0, 0x02, 0x80, 0x14, 0x00, 0x02, 0x00, 0x03, 0x02, 0x80, 0x4E, 0x00,
	0x39, 0xFF, 0xF0, 0x02, 0x00, 0xA1, 0x01, 0x80, 0x7F, 0x00, 0x3B, 0x00, 0x26, 0x01, 0x00, 0xA2,
	0x01, 0x80, 0x78, 0x00, 0x01, 0xFF, 0xB4, 0x02, 0x00, 0xA3, 0x02, 0x80, 0x28, 0xFF, 0xF4, 0xFF,
	0xF6, 0x01, 0x00, 0x0D, 0x00, 0x00, 0x02, 0x00, 0x25, 0x01, 0x00, 0x26, 0x01, 0x00, 0x27, 0x02,
	0x00, 0x28, 0x01, 0x00, 0x29, 0x02, 0x00, 0x2A, 0x01, 0x00, 0xA4, 0x01, 0x00, 0xA5, 0x02, 0x00,
	0xA6, 0x01, 0x00, 0xA7, 0x02, 0x80, 0xA6, 0xFF, 0xE1, 0x00, 0x00, 0x01, 0x80, 0xA7, 0xFF, 0xE1,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x26, 0x00, 0x2F, 0x00, 0x3A, 0x00, 0x43,
	0x00, 0x54, 0x00, 0x65, 0x00, 0x6E, 0x00, 0x7F, 0x00, 0x8E, 0x00, 0x97, 0x00, 0xA0, 0x00, 0xAB,
	0x00, 0xC6, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0x0B, 0x01, 0x1C, 0x01, 0x25, 0x01, 0x30, 0x01, 0x39,
	0x01, 0x44, 0x01, 0x55, 0x01, 0x5E, 0x01, 0x67, 0x01, 0x70, 0x01, 0x7B, 0x01, 0x86, 0x01, 0x8F,
	0x01, 0x9A, 0x01, 0xAB, 0x01, 0xB4, 0x01, 0xC1, 0x01, 0xCA, 0x01, 0xD3, 0x01, 0xF8, 0x02, 0x11,
	0x02, 0x1C, 0x02, 0x25, 0x02, 0x2E, 0x02, 0x37, 0x02, 0x40, 0x02, 0x4F, 0x02, 0x5A, 0x02, 0x65,
	0x02, 0x6E, 0x02, 0x77, 0x02, 0x90, 0x02, 0xA7, 0x02, 0xB0, 0x02, 0xBB, 0x02, 0xC6, 0x02, 0xD1,
	0x02, 0xF6, 0x03, 0x0F, 0x03, 0x1A, 0x03, 0x23, 0x03, 0x2E, 0x03, 0x37, 0x03, 0x48, 0x03, 0x51,
	0x03, 0x6A, 0x03, 0x75, 0x03, 0x8E, 0x03, 0x99, 0x03, 0xA2, 0x03, 0xAD, 0x03, 0xCE, 0x03, 0xE9,
	0x03, 0xF4, 0x03, 0xFD, 0x04, 0x16, 0x04, 0x2D, 0x04, 0x38, 0x04, 0x41, 0x04, 0x4C, 0x04, 0x57,
	0x04, 0x60, 0x04, 0x69, 0x04, 0x72, 0x04, 0x7F, 0x04, 0x88, 0x04, 0x99, 0x04, 0xA6, 0x04, 0xB1,
	0x04, 0xC2, 0x04, 0xCD, 0x04, 0xE2, 0x04, 0xFB, 0x05, 0x0C, 0x05, 0x17, 0x05, 0x20, 0x05, 0x2B,
	0x05, 0x34, 0x05, 0x4D, 0x05, 0x58, 0x05, 0x71, 0x05, 0x84, 0x05, 0x8D, 0x05, 0x98, 0x05, 0xB3,
	0x05, 0xC4, 0x05, 0xCF, 0x05, 0xDA, 0x05, 0xE3, 0x05, 0xEE, 0x05, 0xF7, 0x06, 0x02, 0x06, 0x0F,
	0x06, 0x1A, 0x06, 0x25, 0x06, 0x30, 0x06, 0x3B, 0x06, 0x4C, 0x06, 0x55, 0x06, 0x5E, 0x06, 0x69,
	0x06, 0x74, 0x06, 0x7F, 0x06, 0x8A, 0x06, 0x93, 0x06, 0x9C, 0x06, 0xAB, 0x06, 0xB6, 0x06, 0xBF,
	0x06, 0xD0, 0x06, 0xD9, 0x06, 0xE2, 0x06, 0xFB, 0x07, 0x0C, 0x07, 0x17, 0x07, 0x22, 0x07, 0x2D,
	0x07, 0x3E, 0x07, 0x4F, 0x07, 0x58, 0x07, 0x63, 0x07, 0x6C, 0x07, 0x77, 0x07, 0x86, 0x07, 0x91,
	0x07, 0x9A, 0x07, 0xA3, 0x07, 0xAC, 0x07, 0xB5, 0x07, 0xBE, 0x07, 0xD9, 0x07, 0xEA, 0x07, 0xF3,
	0x07, 0xFC, 0x08, 0x07, 0x08, 0x1C, 0x08, 0x35, 0x08, 0x46, 0x08, 0x5F, 0x08, 0x70, 0x08, 0x7B,
	0x08, 0x8C, 0x08, 0x95, 0x08, 0xA0, 0x08, 0xAF, 0x08, 0xB6, 0x08, 0xBF, 0x08, 0xCA, 0x08, 0xEF,
	0x09, 0x08, 0x09, 0x21, 0x03, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x7F, 0x81, 0x00, 0x0B,
	0x00, 0x7F, 0x00, 0x00, 0x00, 0x7F, 0xFA, 0x00, 0xF8, 0xFE, 0xFA, 0xFD, 0xF7, 0xF7, 0xFC, 0xF9,
	0xFE, 0xF8, 0xFF, 0xFA, 0x00, 0xFC, 0x00, 0xA8, 0x1C, 0x00, 0xFF, 0x00, 0x5B, 0x00, 0x03, 0x00,
	0x1E, 0x00, 0x1E, 0x03, 0x00, 0x00, 0x00, 0x00, 0x53, 0x00, 0x00, 0x19, 0xAD, 0x00, 0xFF, 0x00,
	0x67, 0x00, 0x4A, 0x00, 0x0F, 0x00, 0x16, 0x06, 0x00, 0x5B, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x03,
	0xFE, 0x06, 0xFC, 0x04, 0xFC, 0x01, 0xFD, 0x00, 0x06, 0x00, 0x53, 0x00, 0x01, 0x00, 0x18, 0xEB,
	0x00, 0x01, 0xF9, 0x03, 0xF9, 0x06, 0xFA, 0x06, 0xFD, 0x02, 0x00, 0x5B, 0x00, 0x23, 0x17, 0x17,
	0xE9, 0x06, 0x06, 0x00, 0x00, 0x00, 0x02, 0x06, 0x03, 0x06, 0x06, 0x03, 0x07, 0x02, 0x0A, 0xEB,
	0x00, 0x00, 0xE5, 0x05, 0x00, 0x00, 0x00, 0x1A, 0x65, 0x65, 0x9B, 0x00, 0x00, 0xDE, 0x1E, 0xFA,
	0x01, 0x00, 0xFF, 0x00, 0x0F, 0x00, 0x5D, 0x00, 0x0F, 0x00, 0x0F, 0xFF, 0x00, 0x27, 0x00, 0x19,
	0x00, 0x15, 0x00, 0x18, 0x03, 0x00, 0x7F, 0x00, 0x7F, 0x82, 0x00, 0x00, 0x81, 0x7E, 0x00, 0x0B,
	0x00, 0x7F, 0x00, 0x11, 0xE6, 0x0D, 0x00, 0xFB, 0x01, 0xFB, 0x03, 0xF9, 0x04, 0xFA, 0x03, 0xFD,
	0x06, 0xFD, 0x02, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x05, 0x00, 0x0B, 0x00, 0x7F, 0x00, 0x22, 0xE3,
	0x0D, 0x00, 0xFB, 0x01, 0xFB, 0x03, 0xF9, 0x04, 0xFA, 0x03, 0xFD, 0x06, 0xFD, 0x02, 0x00, 0x00,
	0x00, 0x02, 0xFF, 0x08, 0x00, 0x05, 0x00, 0x60, 0x00, 0x57, 0x01, 0x00, 0x1E, 0x06, 0x00, 0x22,
	0x9B, 0x00, 0x65, 0x9B, 0x0B, 0x00, 0x08, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x57, 0x00, 0x04, 0xFF,
	0x06, 0xFE, 0x08, 0xFC, 0x07, 0xF7, 0x09, 0xFA, 0x03, 0xF8, 0x03, 0xFA, 0x00, 0x00, 0x81, 0x06,
	0x00, 0x24, 0x00, 0x0D, 0xFD, 0x00, 0xFC, 0xFF, 0xFC, 0xFC, 0xFE, 0xFA, 0x00, 0xFE, 0x0D, 0x00,
	0x02, 0x00, 0x24, 0x00, 0x3F, 0xE9, 0xFA, 0x17, 0xE9, 0x03, 0x00, 0x7F, 0x00, 0x2D, 0x00, 0x52,
	0x81, 0x00, 0x00, 0xEE, 0xFF, 0x00, 0x25, 0x00, 0x50, 0x00, 0x19, 0x00, 0x19, 0x03, 0x00, 0x00,
	0x00, 0x69, 0x00, 0xD0, 0x19, 0x00, 0x00, 0x30, 0x06, 0x00, 0x01, 0x00, 0x39, 0x18, 0x00, 0x00,
	0x15, 0xF9, 0xFF, 0xF9, 0xFD, 0xFA, 0xFA, 0xFD, 0xFA, 0x02, 0x00, 0x01, 0x00, 0x7F, 0x32, 0xE7,
	0x00, 0x19, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x00, 0x2A, 0xFF, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x00, 0x18, 0x03, 0x00, 0x7E, 0x00, 0x2D, 0xE9, 0x2D, 0xEE, 0xE5, 0x2A, 0xEB, 0x03,
	0x00, 0x31, 0x00, 0x66, 0xCF, 0x18, 0x00, 0xDF, 0x2A, 0xF5, 0xFF, 0x00, 0x56, 0x00, 0x4C, 0x00,
	0x16, 0x00, 0x16, 0x03, 0x00, 0x2F, 0x00, 0x66, 0x2C, 0x00, 0x00, 0x19, 0xD4, 0x00, 0x06, 0x00,
	0x56, 0x00, 0x7D, 0xFA, 0xFD, 0xFA, 0xFA, 0xFD, 0xF9, 0xFF, 0xF9, 0x15, 0x00, 0x00, 0x18, 0x02,
	0x00, 0x2C, 0x00, 0x7F, 0xD4, 0x00, 0x00, 0xAA, 0x04, 0x00, 0x11, 0x00, 0x70, 0xFE, 0xFC, 0x14,
	0x00, 0x0B, 0x13, 0xF2, 0x00, 0xFF, 0x00, 0x1C, 0x00, 0x69, 0x00, 0x0D, 0x00, 0x0B, 0xFF, 0x00,
	0x19, 0x00, 0x26, 0x00, 0x19, 0x00, 0x36, 0x10, 0x00, 0x2F, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x0A,
	0xFE, 0x0F, 0xFE, 0x09, 0xFD, 0x0A, 0xFB, 0x0A, 0xF8, 0x0A, 0xF9, 0x07, 0xF4, 0x08, 0xFC, 0x02,
	0xF9, 0x01, 0x00, 0xE9, 0x08, 0xF9, 0x06, 0xF5, 0x03, 0xF3, 0x02, 0xF3, 0x0A, 0x00, 0x17, 0x00,
	0x3C, 0x08, 0xFF, 0x0A, 0xFD, 0x05, 0xFC, 0x05, 0xFB, 0x06, 0xF7, 0xFE, 0x09, 0xFE, 0x06, 0xF7,
	0x0F, 0xF6, 0x0A, 0xF5, 0x09, 0x03, 0x00, 0x6F, 0x00, 0x1F, 0x10, 0x00, 0x00, 0x60, 0xF0, 0x00,
	0xFF, 0x00, 0x6B, 0x00, 0x2E, 0x00, 0x14, 0x00, 0x27, 0xFF, 0x00, 0x71, 0x00, 0x16, 0x00, 0x0E,
	0x00, 0x17, 0xFF, 0x00, 0x73, 0x00, 0x14, 0x00, 0x07, 0x00, 0x07, 0x02, 0x00, 0x6E, 0x00, 0x4D,
	0x00, 0x09, 0xF8, 0xFF, 0x05, 0x00, 0x6F, 0x00, 0x4D, 0x00, 0x32, 0xE1, 0x00, 0x0E, 0xF2, 0x08,
	0xF6, 0x06, 0xF5, 0x03, 0x00, 0x24, 0x00, 0x68, 0x2D, 0x00, 0x00, 0x07, 0xD3, 0x00, 0x03, 0x00,
	0x51, 0x00, 0x00, 0x2E, 0x00, 0x00, 0x27, 0xD2, 0x00, 0xFF, 0x00, 0x51, 0x00, 0x00, 0x00, 0x2B,
	0x00, 0x26, 0xFF, 0x00, 0x67, 0x00, 0x24, 0x00, 0x17, 0x00, 0x17, 0x0A, 0x00, 0x7F, 0x00, 0x4B,
	0xFB, 0x00, 0xFB, 0xFE, 0x01, 0x00, 0xFA, 0xFD, 0xFD, 0xFD, 0xFD, 0xFC, 0xFC, 0xF7, 0xFF, 0xFB,
	0x00, 0xFB, 0x1A, 0x0D, 0x09, 0x00, 0x7F, 0x00, 0x39, 0xF8, 0x00, 0xFC, 0xFF, 0xFA, 0xFD, 0xFD,
	0xFD, 0xFC, 0xFA, 0xFD, 0xF9, 0xFF, 0xFB, 0x00, 0xFC, 0x1D, 0x0C, 0xFF, 0x00, 0x4E, 0x00, 0x49,
	0x00, 0x13, 0x00, 0x13, 0x03, 0x00, 0x45, 0x00, 0x36, 0x0C, 0x00, 0x04, 0x47, 0xF0, 0x00, 0x03,
	0x00, 0x45, 0x00, 0x69, 0x1B, 0x00, 0x00, 0x16, 0xE5, 0x00, 0x03, 0x00, 0x38, 0x00, 0x36, 0x0C,
	0x00, 0x00, 0x27, 0xF4, 0x00, 0x10, 0x00, 0x3F, 0x00, 0x7F, 0xE2, 0x00, 0x00, 0xF5, 0x01, 0xF1,
	0x02, 0xF7, 0x03, 0xF6, 0x05, 0xF6, 0x08, 0xF6, 0x07, 0xF9, 0x0C, 0xF8, 0x04, 0xFE, 0x07, 0xFF,
	0x00, 0x17, 0xF8, 0x07, 0xFA, 0x0B, 0xFD, 0x0D, 0xFE, 0x0D, 0x0A, 0x00, 0x54, 0x00, 0x43, 0xF8,
	0x00, 0xF9, 0x03, 0xFB, 0x04, 0xFB, 0x05, 0xFA, 0x09, 0x02, 0xF7, 0x02, 0xFA, 0x09, 0xF1, 0x09,
	0xF7, 0x08, 0xF9, 0x03, 0x00, 0x46, 0x00, 0x46, 0x39, 0x00, 0x00, 0x39, 0xC7, 0x00, 0xFF, 0x00,
	0x46, 0x00, 0x46, 0x00, 0x2F, 0x00, 0x2F, 0x03, 0x00, 0x20, 0x00, 0x00, 0x5F, 0x00, 0x00, 0x2E,
	0xA1, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x21, 0x00, 0x49, 0x00, 0x24, 0x06, 0x00, 0x51, 0x00, 0x2E,
	0x09, 0xFE, 0x0F, 0xFE, 0x0A, 0x00, 0x0C, 0x02, 0x00, 0x04, 0xD0, 0x00, 0x02, 0x00, 0x43, 0x00,
	0x2A, 0x0C, 0x06, 0xF4, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC5, 0x19, 0x00, 0x0F, 0xFE,
	0x0D, 0xFC, 0x0E, 0x1A, 0xFB, 0x0C, 0xF8, 0x09, 0xF0, 0x0A, 0xF4, 0x04, 0xF1, 0x04, 0x03, 0x00,
	0x00, 0x00, 0x3D, 0x07, 0x04, 0x0C, 0x03, 0xED, 0x01, 0x0A, 0x00, 0x36, 0x00, 0x3D, 0x0D, 0x1A,
	0xF4, 0x07, 0xF3, 0x02, 0xF9, 0xFF, 0xFA, 0xFF, 0xFB, 0xFC, 0x06, 0xFF, 0x0A, 0xFB, 0x08, 0xF8,
	0x04, 0xF9, 0x03, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x21, 0xDF, 0x00, 0xFF, 0x00, 0x21,
	0x00, 0x30, 0x00, 0x23, 0x00, 0x23, 0x03, 0x00, 0x51, 0x00, 0x57, 0x2E, 0x00, 0x00, 0x28, 0xD2,
	0x00, 0x0E, 0x00, 0x60, 0x00, 0x0C, 0xFA, 0x0A, 0xFB, 0x0D, 0xFE, 0x0B, 0x01, 0x0A, 0xF0, 0x11,
	0xFC, 0xFA, 0xFE, 0xFC, 0xFD, 0xF2, 0x00, 0xF6, 0x01, 0xF3, 0x03, 0xF6, 0x05, 0xF7, 0x04, 0xF9,
	0x24, 0x00, 0x0B, 0x00, 0x43, 0x00, 0x4B, 0xFE, 0xF2, 0x01, 0xF7, 0x01, 0xF8, 0x03, 0xF7, 0x03,
	0xFA, 0x03, 0xFA, 0x00, 0x09, 0x00, 0x07, 0x01, 0x06, 0x03, 0x07, 0x05, 0x05, 0x03, 0x00, 0x00,
	0x00, 0x1B, 0x34, 0x00, 0x00, 0x2F, 0xCC, 0x00, 0xFF, 0x00, 0x34, 0x00, 0x4A, 0x00, 0x33, 0x00,
	0x21, 0x0A, 0x00, 0x7F, 0x00, 0x46, 0xE6, 0x0D, 0x00, 0xFB, 0x01, 0xFB, 0x04, 0xF7, 0x03, 0xFC,
	0x03, 0xFD, 0x06, 0xFD, 0xFF, 0x00, 0x05, 0xFF, 0x05, 0x00, 0x09, 0x00, 0x7F, 0x00, 0x57, 0xE3,
	0x0D, 0x00, 0xFB, 0x01, 0xFB, 0x03, 0xF9, 0x04, 0xFA, 0x03, 0xFD, 0x06, 0xFD, 0x04, 0xFF, 0x08,
	0x00, 0x03, 0x00, 0x30, 0x00, 0x57, 0x34, 0x00, 0x00, 0x28, 0xCC, 0x00, 0xFF, 0x00, 0x34, 0x00,
	0x00, 0x00, 0x0E, 0x00, 0x0E, 0x03, 0x00, 0x00, 0x00, 0x52, 0x00, 0xAE, 0x7F, 0x00, 0x00, 0x12,
	0x03, 0x00, 0x4D, 0x00, 0x19, 0x32, 0xE8, 0x00, 0x21, 0xD5, 0x0B, 0x02, 0x00, 0x7D, 0x00, 0x00,
	0xCE, 0x19, 0x00, 0xE7, 0xFF, 0x00, 0x22, 0x00, 0x4F, 0x00, 0x24, 0x00, 0x32, 0x02, 0x00, 0x25,
	0x00, 0x7F, 0xDB, 0x00, 0x00, 0xB7, 0x04, 0x00, 0x0E, 0x00, 0x72, 0xFF, 0xFD, 0x10, 0x00, 0x0A,
	0x10, 0xF4, 0x00, 0xFF, 0x00, 0x18, 0x00, 0x6C, 0x00, 0x0B, 0x00, 0x09, 0x06, 0x00, 0x01, 0x00,
	0x3D, 0x01, 0xFB, 0x15, 0x29, 0xF5, 0xFC, 0xFC, 0xFB, 0xFB, 0xF7, 0xFE, 0xF4, 0x04, 0x00, 0x80,
	0x00, 0x00, 0x29, 0x00, 0x00, 0x7F, 0x00, 0x2A, 0xD7, 0x00, 0x03, 0x00, 0x39, 0x00, 0x7F, 0xC7,
	0x00, 0x00, 0xC7, 0x39, 0x00, 0x06, 0x00, 0x7F, 0x00, 0x7F, 0xE7, 0x00, 0x04, 0xFA, 0x03, 0xFD,
	0x06, 0xFD, 0x04, 0xFF, 0x08, 0x00, 0x03, 0x00, 0x44, 0x00, 0x4C, 0x3B, 0x00, 0x00, 0x33, 0xC5,
	0x00, 0x08, 0x00, 0x7F, 0x00, 0x5A, 0x00, 0x25, 0xD1, 0x00, 0x01, 0xF6, 0x07, 0xF5, 0x07, 0xF9,
	0x08, 0xFB, 0x06, 0xFE, 0x0A, 0xFE, 0x0A, 0x00, 0x48, 0x00, 0x5C, 0xFB, 0x00, 0xFB, 0xFF, 0x01,
	0x00, 0xFA, 0xFD, 0xFD, 0xFD, 0xFD, 0xFC, 0xFC, 0xF7, 0xFF, 0xFB, 0x00, 0xFB, 0x1A, 0x0D, 0x06,
	0x00, 0x48, 0x00, 0x4B, 0xF8, 0x00, 0xFC, 0xFF, 0xFA, 0xFD, 0xFD, 0xFD, 0xFC, 0xFA, 0x19, 0x00,
	0x03, 0x00, 0x2F, 0x00, 0x5D, 0x50, 0x00, 0x00, 0x22, 0xB0, 0x00, 0xFF, 0x00, 0x2F, 0x00, 0x5D,
	0x00, 0x21, 0x00, 0x21, 0x03, 0x00, 0x00, 0x00, 0x1A, 0x21, 0x00, 0x00, 0x65, 0xDF, 0x00, 0xFF,
	0x00, 0x21, 0x00, 0x1A, 0x00, 0x20, 0x00, 0x20, 0x0A, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x39, 0xDC,
	0x02, 0xF7, 0x02, 0xF7, 0x04, 0xF3, 0xE6, 0x04, 0xF4, 0x08, 0xF7, 0x10, 0xF6, 0x0C, 0xFC, 0x0F,
	0xFC, 0x03, 0x00, 0x7F, 0x00, 0x42, 0xF7, 0xFA, 0xF6, 0xFE, 0x13, 0x00, 0x0A, 0x00, 0x48, 0x00,
	0x42, 0xF4, 0xE6, 0x0B, 0xF9, 0x0D, 0xFE, 0x07, 0x01, 0x06, 0x01, 0x05, 0x04, 0xFA, 0x01, 0xF5,
	0x06, 0xF9, 0x07, 0xFC, 0x07, 0x07, 0x00, 0x21, 0x00, 0x7F, 0xE6, 0x00, 0x00, 0xF2, 0x02, 0xF2,
	0x04, 0xF3, 0x04, 0xF5, 0x07, 0xF7, 0x09, 0xF9, 0xFF, 0x00, 0x2F, 0x00, 0x5D, 0x00, 0x0D, 0x00,
	0x0D, 0x03, 0x00, 0x7F, 0x00, 0x7F, 0xDF, 0x00, 0x00, 0xD9, 0x21, 0x00, 0x0B, 0x00, 0x48, 0x00,
	0x27, 0xFB, 0x00, 0xFB, 0xFF, 0x01, 0x00, 0xFA, 0xFD, 0xFD, 0xFD, 0xFD, 0xFC, 0xFC, 0xF7, 0xFF,
	0xFB, 0xFF, 0xFB, 0x00, 0xF9, 0x1B, 0x14, 0x06, 0x00, 0x47, 0x00, 0x10, 0x03, 0x06, 0xF4, 0xFD,
	0xF7, 0xF9, 0xFD, 0xFD, 0xFC, 0xFA, 0x19, 0x00, 0x03, 0x00, 0x5E, 0x00, 0x7F, 0xA2, 0x00, 0x00,
	0xDE, 0x5E, 0x00, 0x03, 0x00, 0x3F, 0x00, 0x3F, 0x40, 0x00, 0x00, 0x40, 0xC0, 0x00, 0xFF, 0x00,
	0x3F, 0x00, 0x3F, 0x00, 0x37, 0x00, 0x37, 0x03, 0x00, 0x3F, 0x00, 0x00, 0x1D, 0x00, 0x00, 0x4A,
	0xE3, 0x00, 0xFF, 0x00, 0x3F, 0x00, 0x4A, 0x00, 0x1D, 0x00, 0x1D, 0x03, 0x00, 0x22, 0x00, 0x2C,
	0x1C, 0x00, 0x00, 0x3E, 0xE4, 0x00, 0x04, 0x00, 0x5C, 0x00, 0x47, 0xF8, 0x00, 0x00, 0xED, 0x02,
	0xEA, 0x06, 0xE2, 0x03, 0x00, 0x00, 0x00, 0x66, 0x1A, 0x00, 0x00, 0x19, 0xE6, 0x00, 0x03, 0x00,
	0x49, 0x00, 0x02, 0x10, 0x00, 0xFC, 0x47, 0xF4, 0x00, 0x03, 0x00, 0x00, 0x00, 0x68, 0x1B, 0x00,
	0x00, 0x17, 0xE5, 0x00, 0x03, 0x00, 0x7F, 0x00, 0x14, 0x00, 0x6B, 0xD2, 0x00, 0x00, 0x95, 0x06,
	0x00, 0x51, 0x00, 0x51, 0x02, 0x09, 0x02, 0x0F, 0x00, 0x0A, 0xFE, 0x0C, 0xFC, 0x00, 0x00, 0xD0,
	0x02, 0x00, 0x55, 0x00, 0x43, 0xFA, 0x0C, 0x00, 0xF4, 0xFF, 0x00, 0x60, 0x00, 0x00, 0x00, 0x1F,
	0x00, 0x4D, 0x03, 0x00, 0x43, 0x00, 0x57, 0x3C, 0x00, 0x00, 0x28, 0xC4, 0x00, 0x03, 0x00, 0x7D,
	0xFF, 0xFF, 0x00, 0x10, 0xB9, 0xFC, 0x00, 0xF4, 0x03, 0x00, 0x7F, 0xFF, 0xFF, 0x00, 0x1B, 0xEA,
	0x00, 0x00, 0xE5, 0x03, 0x00, 0x5D, 0xFF, 0xF2, 0x00, 0x0C, 0xD9, 0x00, 0x00, 0xF4, 0xFF, 0x00,
	0x67, 0x00, 0x58, 0x00, 0x0C, 0x00, 0x0C, 0xFF, 0x00, 0x1A, 0x00, 0x2C, 0x00, 0x0A, 0x00, 0x0A,
	0x05, 0x00, 0x48, 0x00, 0x19, 0x0C, 0xF7, 0x12, 0xF7, 0x19, 0xFA, 0x00, 0x21, 0xD5, 0x0B, 0x03,
	0x00, 0x2E, 0x00, 0x53, 0x51, 0x00, 0x00, 0x2C, 0xAF, 0x00, 0xFF, 0x00, 0x1A, 0x00, 0x53, 0x00,
	0x64, 0x00, 0x20, 0x06, 0x00, 0x7D, 0x00, 0x13, 0xFD, 0x06, 0xFA, 0x06, 0xF9, 0x03, 0xF9, 0x01,
	0x00, 0xEB, 0x18, 0x00, 0x02, 0x00, 0x07, 0x00, 0x27, 0xF9, 0x15, 0x00, 0xF7, 0xFF, 0x00, 0x1F,
	0x00, 0x34, 0x00, 0x0B, 0x00, 0x0B, 0x0A, 0x00, 0x00, 0x00, 0x57, 0x1A, 0xF3, 0x00, 0x05, 0xFF,
	0x05, 0xFC, 0x09, 0xFD, 0x04, 0xFD, 0x03, 0xFA, 0x03, 0x01, 0x00, 0xFB, 0x01, 0xFB, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x4A, 0x19, 0x00, 0xFC, 0x06, 0xFD, 0x03, 0xFA, 0x03, 0xFC, 0x01, 0xF8, 0x00,
	0x03, 0x00, 0x69, 0x00, 0x7F, 0x00, 0xE5, 0x16, 0x00, 0x00, 0x1B, 0x03, 0x00, 0x36, 0x00, 0x7F,
	0x00, 0xF4, 0x47, 0xFC, 0x00, 0x10, 0x03, 0x00, 0x49, 0x00, 0x19, 0xD2, 0x00, 0x00, 0xE7, 0x2E,
	0x00, 0x06, 0x00, 0x21, 0x00, 0x02, 0x06, 0x03, 0x06, 0x06, 0x03, 0x07, 0x01, 0x07, 0xEA, 0x00,
	0x00, 0xE8, 0x06, 0x00, 0x49, 0x00, 0x01, 0x00, 0x18, 0xEA, 0x00, 0x01, 0xF9, 0x03, 0xF9, 0x06,
	0xFA, 0x06, 0xFD, 0x02, 0x00, 0x00, 0x00, 0x5E, 0x00, 0xA2, 0x5E, 0x5E, 0x03, 0x00, 0x2E, 0x00,
	0x47, 0x3D, 0x1E, 0xBE, 0x00, 0xFF, 0xE2, 0xFF, 0x00, 0x03, 0x00, 0x7D, 0x00, 0x11, 0x00, 0x11,
	0x03, 0x00, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x36, 0xCC, 0x00, 0x05, 0x00, 0x39, 0x00, 0x5E,
	0x01, 0x00, 0x19, 0x05, 0x00, 0x1C, 0xAD, 0x00, 0x53, 0xAD, 0x03, 0x00, 0x71, 0x00, 0x2E, 0x0E,
	0x00, 0x00, 0x51, 0xF2, 0x00, 0xFF, 0x00, 0x6E, 0x00, 0x3B, 0x00, 0x11, 0x00, 0x21, 0xFF, 0x00,
	0x73, 0x00, 0x26, 0x00, 0x0C, 0x00, 0x13, 0xFF, 0x00, 0x74, 0x00, 0x25, 0x00, 0x06, 0x00, 0x06,
	0x02, 0x00, 0x70, 0x00, 0x55, 0x00, 0x07, 0xF9, 0x00, 0x02, 0x00, 0x71, 0x00, 0x55, 0x00, 0x2A,
	0xEB, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x77, 0x00, 0xE4, 0x57, 0x00, 0x04, 0x00, 0x06, 0x01, 0x08,
	0x02, 0x07, 0x04, 0x09, 0x09, 0x03, 0x06, 0x03, 0x08, 0x00, 0x06, 0x81, 0x00, 0x06, 0x00, 0x0D,
	0x00, 0x5B, 0x00, 0x03, 0xFF, 0x04, 0xFC, 0x04, 0xFA, 0x02, 0xFE, 0x00, 0x00, 0xF3, 0x02, 0x00,
	0x3F, 0x00, 0x5B, 0xFA, 0x17, 0xE9, 0xE9, 0xFF, 0x00, 0x48, 0x00, 0x68, 0x00, 0x14, 0x00, 0x0F,
	0x03, 0x00, 0x4C, 0x00, 0x3B, 0x00, 0xC5, 0x33, 0x00, 0x00, 0x3B, 0x08, 0x00, 0x5A, 0x00, 0x00,
	0x25, 0x00, 0x00, 0x2F, 0xF6, 0xFF, 0xF5, 0xF9, 0xF9, 0xF9, 0xFB, 0xF8, 0xFE, 0xFA, 0xFE, 0xF6,
	0x0A, 0x00, 0x5C, 0x00, 0x37, 0x00, 0x05, 0xFF, 0x05, 0x00, 0xFF, 0xFD, 0x06, 0xFD, 0x03, 0xFC,
	0x03, 0xF7, 0x04, 0xFB, 0x01, 0xFB, 0x00, 0x0D, 0xE6, 0x06, 0x00, 0x4B, 0x00, 0x37, 0x00, 0x08,
	0xFF, 0x04, 0xFD, 0x06, 0xFD, 0x03, 0xFA, 0x04, 0x00, 0xE7, 0x0A, 0x00, 0x30, 0x00, 0x00, 0x0D,
	0x1A, 0xFB, 0x00, 0xFB, 0xFF, 0xF7, 0xFC, 0xFC, 0xFD, 0xFD, 0xFD, 0xFD, 0xFA, 0x00, 0x01, 0xFF,
	0xFB, 0x00, 0xFB, 0x06, 0x00, 0x3D, 0x00, 0x00, 0x00, 0x19, 0xFA, 0xFC, 0xFD, 0xFD, 0xFD, 0xFA,
	0xFF, 0xFC, 0x00, 0xF8, 0x03, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x94, 0x2E, 0x00, 0x00, 0x6C, 0x06,
	0x00, 0x2E, 0x00, 0x2E, 0xFE, 0xF7, 0xFE, 0xF1, 0x00, 0xF6, 0x02, 0xF4, 0x04, 0x00, 0x00, 0x30,
	0x02, 0x00, 0x2A, 0x00, 0x3C, 0x06, 0xF4, 0x00, 0x0C, 0x03, 0x00, 0x7F, 0x00, 0x3F, 0x00, 0x40,
	0x82, 0x00, 0x00, 0xEE, 0x05, 0x00, 0x37, 0x00, 0x66, 0xF4, 0x09, 0xEE, 0x09, 0xE8, 0x06, 0x00,
	0xDF, 0x2A, 0xF5, 0x01, 0x00, 0x7F, 0x00, 0x43, 0x00, 0x09, 0x02, 0x00, 0x7F, 0x00, 0x00, 0x00,
	0x4C, 0xB4, 0xB4, 0x03, 0x00, 0x33, 0x00, 0x00, 0x35, 0x00, 0x02, 0x17, 0xFA, 0x01, 0x10, 0x00,
	0x1E, 0x00, 0x0F, 0x02, 0x0D, 0x03, 0x0D, 0x06, 0x0B, 0x08, 0x07, 0x00, 0x17, 0xF9, 0xFF, 0xFC,
	0xFE, 0xF4, 0xF8, 0xF9, 0xF9, 0xF8, 0xF6, 0xFB, 0xF6, 0xFD, 0xF6, 0xFE, 0xF7, 0xFF, 0xF1, 0x00,
	0xF6, 0x1E, 0x00, 0x0A, 0x00, 0x37, 0x00, 0x57, 0xF4, 0xF7, 0xF6, 0xF6, 0xF7, 0xF1, 0xFE, 0xFA,
	0xFE, 0xF7, 0x06, 0x09, 0x05, 0x05, 0x05, 0x04, 0x0A, 0x03, 0x09, 0x01, 0x0A, 0x00, 0x2C, 0x00,
	0x7F, 0x00, 0xFB, 0x01, 0xFB, 0x00, 0x01, 0x03, 0xFA, 0x03, 0xFD, 0x04, 0xFD, 0x09, 0xFC, 0x05,
	0xFF, 0x05, 0x00, 0xF3, 0x1A, 0x06, 0x00, 0x3D, 0x00, 0x7F, 0x00, 0xF8, 0x01, 0xFC, 0x03, 0xFA,
	0x03, 0xFD, 0x06, 0xFC, 0x00, 0x19
};

const Cutscene::Text Cutscene::_frTextsTable[] = {
	{  1, "VOUS RAMASSEZ L'HOLOCUBE" },
	{  2, "VOUS RAMASSEZ LA CLE" },
	{  4, "VOUS RAMASSEZ LE PISTOLET" },
	{  5, "VOTRE BOUCLIER EST RECHARGE" },
	{ 10, "VOUS RAMASSEZ||LA CARTE DE CREDITS" },
	{ 14, "LA PILE EST RECHARGEE" },
	{ 15, "VOUS RAMASSEZ LA PILE" },
	{ 16, "VOUS RAMASSEZ LE TELEPORTEUR" },
	{ 18, "VOUS RAMASSEZ LA CARTE ID" },
	{ 21, "VOUS LUI DONNEZ LE TELEPORTEUR" },
	{ 32, "LA RECEPTIONNISTE VOUS DONNE||UN PAQUET" },
	{ 33, "VOUS DONNEZ LE COLIS" },
	{ 34, "LE GOUVERNEUR VOUS DONNE||LA CARTE DE TRAVAIL" },
	{ 35, "LE FAUSSAIRE VOUS DONNE||LA FAUSSE CARTE ID" },
	{ 36, "VOUS RAMASSEZ LE FUSIBLE" },
	{ 43, "VOUS LUI TENDEZ||VOS PAPIERS" },
	{ 44, "VOUS LUI DONNEZ L'ARGENT" },
	{ 49, "IL VOUS DONNE||UNE CEINTURE ANTI-G" },
	{ 60, "VOUS RAMASSEZ LE TELE RECEPTEUR" },
	{ -1, 0 }
};

const Cutscene::Text Cutscene::_enTextsTable[] = {
	{  1, "YOU PICK UP THE HOLOCUBE" },
	{  2, "YOU PICK UP THE KEY" },
	{  3, "YOU PICK UP THE GUN" },
	{  5, "YOUR SHIELD IS RECHARGED" },
	{ 10, "YOU PICK UP THE CREDIT CARD" },
	{ 14, "THE CARTRIDGE IS RECHARGED" },
	{ 15, "YOU PICK UP THE CARTRIDGE" },
	{ 16, "YOU PICK UP THE TELEPORTER" },
	{ 18, "YOU PICK UP THE I.D. CARD" },
	{ 21, "YOU GIVE HIM THE TELEPORTER" },
	{ 32, "THE RECEPTIONIST GIVES YOU||A PACKAGE" },
	{ 33, "YOU GIVE THE PARCEL" },
	{ 34, "THE GOVERNOR GIVES YOU||A WORKING PERMIT" },
	{ 35, "THE FORGER GIVES YOU||A FAKE I.D. CARD" },
	{ 36, "YOU PICK UP THE FUSE" },
	{ 43, "YOU GIVE HIM||YOUR PAPERS" },
	{ 44, "YOU GIVE HIM MONEY" },
	{ 49, "HE GIVES YOU||AN ANTI-G BELT" },
	{ 60, "YOU PICK UP THE TELE RECEPTER" },
	{ -1, 0}
};

const Demo Game::_demoInputs[] = {
	{ "demo1.bin",  0, 0x33, 0x60, 0x46 },
	{ "demo51.bin", 5, 0x00, 0x60, 0xD6 },
	{ "demo3.bin" , 2, 0xFF, 0x00, 0x00 }
};

const Level Game::_gameLevels[] = {
	{ "level1", "level1", "level1", 0x00, 1, 3 },
	{ "level2", "level2", "level2", 0x2F, 1, 4 },
	{ "level3", "level3", "dt", 0xFFFF, 3, 5 },
	{ "level4", "level4_1", "level3_1", 0x34, 3, 6 },
	{ "level4", "level4_2", "level3_2", 0x39, 3, 6 },
	{ "level5", "level5_1", "level4_1", 0x35, 4, 7 },
	{ "level5", "level5_2", "level4_2", 0xFFFF, 4, 7 }
};

const uint16_t Game::_scoreTable[] = {
	0, 200, 300, 400, 500, 800, 1000, 1200, 1500, 2000, 2200, 2500, 3000, 3200, 3500, 5000
};

const uint8_t Game::_monsterListLevel1[] = {
	0x22, 0, 0x23, 0, 0xFF
};

const uint8_t Game::_monsterListLevel2[] = {
	0x22, 0, 0x23, 0, 0x4B, 0, 0x49, 1, 0x4D, 1, 0x76, 2, 0xFF
};

const uint8_t Game::_monsterListLevel3[] = {
	0x76, 2, 0xFF
};

const uint8_t Game::_monsterListLevel4_1[] = {
	0x4D, 1, 0x76, 2, 0xFF
};

const uint8_t Game::_monsterListLevel4_2[] = {
	0x76, 2, 0xAC, 2, 0xD7, 3, 0xFF
};

const uint8_t Game::_monsterListLevel5_1[] = {
	0xB0, 3, 0xD7, 3, 0xFF
};

const uint8_t Game::_monsterListLevel5_2[] = {
	0xB0, 3, 0xD7, 3, 0xD8, 3, 0xFF
};

const uint8_t *Game::_monsterListLevels[] = {
	_monsterListLevel1,
	_monsterListLevel2,
	_monsterListLevel3,
	_monsterListLevel4_1,
	_monsterListLevel4_2,
	_monsterListLevel5_1,
	_monsterListLevel5_2
};

const uint8_t Game::_monsterPals[4][32] = {
	{ // junkie
		0x00, 0x00, 0xAA, 0x0A, 0x65, 0x0A, 0x44, 0x08, 0x22, 0x06, 0x20, 0x03, 0x40, 0x05, 0x87, 0x0C,
		0x76, 0x0B, 0x34, 0x03, 0x55, 0x09, 0x30, 0x04, 0x60, 0x07, 0x55, 0x04, 0x77, 0x07, 0xFF, 0x0F
	},
	{ // mercenaire
		0x00, 0x00, 0x86, 0x0C, 0x66, 0x09, 0x44, 0x08, 0xFC, 0x05, 0xA2, 0x02, 0x49, 0x05, 0x02, 0x00,
		0x14, 0x02, 0x37, 0x04, 0x25, 0x03, 0x38, 0x06, 0xAF, 0x0C, 0x6F, 0x09, 0x4C, 0x07, 0xFF, 0x0F
	},
	{ // replicant
		0x00, 0x00, 0x79, 0x08, 0x44, 0x05, 0x55, 0x06, 0x66, 0x0B, 0x46, 0x05, 0x57, 0x06, 0x22, 0x03,
		0x44, 0x08, 0x33, 0x04, 0xAC, 0x08, 0x8A, 0x06, 0x68, 0x04, 0x56, 0x02, 0x35, 0x02, 0xCE, 0x0A
	},
	{ // glue
		0x00, 0x00, 0x6C, 0x00, 0x39, 0x02, 0x4C, 0x02, 0x27, 0x02, 0x10, 0x07, 0x15, 0x01, 0x00, 0x04,
		0x10, 0x05, 0x20, 0x08, 0x00, 0x02, 0x30, 0x09, 0x55, 0x0B, 0xFF, 0x0F, 0x33, 0x0A, 0xFF, 0x0F
	}
};

const char *Game::_monsterNames[2][4] = {
	{ // PC
		"junky",
		"mercenai",
		"replican",
		"glue"
	},
	{ // Amiga
		"junky",
		"garde",
		"replicant",
		"glue"
	}
};

const uint8_t LocaleData::_stringsTableFR[] = {
	0x5A, 0x00, 0x71, 0x00, 0x90, 0x00, 0x97, 0x01, 0x58, 0x02, 0x7B, 0x02, 0xC5, 0x02, 0xEA, 0x02,
	0x50, 0x03, 0x6C, 0x03, 0xA8, 0x03, 0xF7, 0x03, 0x46, 0x04, 0x98, 0x04, 0x1C, 0x05, 0x57, 0x05,
	0x69, 0x05, 0xE1, 0x05, 0xF4, 0x05, 0x19, 0x06, 0xB5, 0x06, 0x9C, 0x08, 0x11, 0x09, 0x2B, 0x09,
	0x8D, 0x09, 0xA6, 0x09, 0xB9, 0x09, 0xDC, 0x09, 0xEF, 0x09, 0x13, 0x0A, 0x15, 0x0A, 0x17, 0x0A,
	0x7F, 0x0A, 0x90, 0x0A, 0x21, 0x0B, 0x4A, 0x0B, 0x08, 0x0C, 0x20, 0x0C, 0x44, 0x0C, 0x77, 0x0C,
	0x0E, 0x0D, 0x55, 0x0D, 0x93, 0x0D, 0xBB, 0x0D, 0xF5, 0x0D, 0x4C, 0x45, 0x20, 0x46, 0x55, 0x53,
	0x49, 0x42, 0x4C, 0x45, 0x20, 0x45, 0x53, 0x54, 0x0A, 0x47, 0x52, 0x49, 0x4C, 0x4C, 0x45, 0x2E,
	0x00, 0x4D, 0x41, 0x49, 0x4E, 0x54, 0x45, 0x4E, 0x41, 0x4E, 0x54, 0x20, 0x43, 0x41, 0x0A, 0x44,
	0x4F, 0x49, 0x54, 0x20, 0x46, 0x4F, 0x4E, 0x43, 0x54, 0x49, 0x4F, 0x4E, 0x4E, 0x45, 0x52, 0x00,
	0xFF, 0xEB, 0xEC, 0x4A, 0x27, 0x53, 0x55, 0x49, 0x53, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x2E, 0x0A,
	0x54, 0x55, 0x20, 0x56, 0x45, 0x55, 0x58, 0x20, 0x44, 0x45, 0x53, 0x20, 0x46, 0x41, 0x55, 0x58,
	0x0A, 0x50, 0x41, 0x50, 0x49, 0x45, 0x52, 0x53, 0x3F, 0x0B, 0xFF, 0xE9, 0xEA, 0x4F, 0x55, 0x49,
	0x2C, 0x45, 0x54, 0x20, 0x4C, 0x45, 0x20, 0x50, 0x4C, 0x55, 0x53, 0x0A, 0x56, 0x49, 0x54, 0x45,
	0x20, 0x50, 0x4F, 0x53, 0x53, 0x49, 0x42, 0x4C, 0x45, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x31, 0x35,
	0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x53, 0x21, 0x0B, 0xFF, 0xE9, 0xEA, 0x31,
	0x35, 0x30, 0x30, 0x3F, 0x3F, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x55, 0x41, 0x49, 0x53, 0x2C,
	0x4A, 0x27, 0x50, 0x52, 0x45, 0x4E, 0x44, 0x53, 0x0A, 0x55, 0x4E, 0x20, 0x47, 0x52, 0x4F, 0x53,
	0x20, 0x52, 0x49, 0x53, 0x51, 0x55, 0x45, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x4D, 0x41, 0x49, 0x53,
	0x20, 0x4A, 0x45, 0x20, 0x4E, 0x27, 0x41, 0x49, 0x20, 0x50, 0x41, 0x53, 0x0A, 0x41, 0x53, 0x53,
	0x45, 0x5A, 0x2E, 0x2E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x56, 0x41, 0x20, 0x41, 0x20, 0x4C, 0x27,
	0x41, 0x47, 0x45, 0x4E, 0x43, 0x45, 0x0A, 0x50, 0x4F, 0x55, 0x52, 0x20, 0x4C, 0x27, 0x45, 0x4D,
	0x50, 0x4C, 0x4F, 0x49, 0x20, 0x45, 0x54, 0x0A, 0x54, 0x55, 0x20, 0x41, 0x55, 0x52, 0x41, 0x53,
	0x20, 0x55, 0x4E, 0x20, 0x4A, 0x4F, 0x42, 0x2E, 0x0B, 0x45, 0x54, 0x20, 0x52, 0x45, 0x56, 0x49,
	0x45, 0x4E, 0x53, 0x20, 0x4D, 0x45, 0x0A, 0x56, 0x4F, 0x49, 0x52, 0x20, 0x51, 0x55, 0x41, 0x4E,
	0x44, 0x20, 0x54, 0x55, 0x0A, 0x41, 0x55, 0x52, 0x41, 0x53, 0x20, 0x44, 0x45, 0x0A, 0x4C, 0x27,
	0x41, 0x52, 0x47, 0x45, 0x4E, 0x54, 0x00, 0xFF, 0xEB, 0xEC, 0x4A, 0x27, 0x43, 0x4F, 0x4E, 0x4E,
	0x41, 0x49, 0x53, 0x20, 0x43, 0x45, 0x0A, 0x47, 0x41, 0x52, 0x53, 0x20, 0x4C, 0x41, 0x2E, 0x20,
	0x49, 0x4C, 0x20, 0x41, 0x0A, 0x55, 0x4E, 0x20, 0x41, 0x4D, 0x49, 0x20, 0x51, 0x55, 0x49, 0x20,
	0x45, 0x53, 0x54, 0x0A, 0x55, 0x4E, 0x20, 0x52, 0x4F, 0x42, 0x4F, 0x54, 0x2D, 0x46, 0x4C, 0x49,
	0x43, 0x2E, 0x0B, 0x4F, 0x55, 0x20, 0x50, 0x55, 0x49, 0x53, 0x2D, 0x4A, 0x45, 0x0A, 0x54, 0x52,
	0x4F, 0x55, 0x56, 0x45, 0x52, 0x20, 0x43, 0x45, 0x54, 0x20, 0x41, 0x4D, 0x49, 0x3F, 0x0B, 0x56,
	0x41, 0x20, 0x56, 0x4F, 0x49, 0x52, 0x20, 0x41, 0x20, 0x4C, 0x41, 0x0A, 0x52, 0x45, 0x53, 0x54,
	0x52, 0x49, 0x43, 0x54, 0x45, 0x44, 0x20, 0x41, 0x52, 0x45, 0x41, 0x0A, 0x31, 0x2E, 0x4A, 0x45,
	0x20, 0x43, 0x52, 0x4F, 0x49, 0x53, 0x20, 0x51, 0x55, 0x27, 0x49, 0x4C, 0x0A, 0x45, 0x53, 0x54,
	0x20, 0x44, 0x45, 0x20, 0x47, 0x41, 0x52, 0x44, 0x45, 0x0B, 0x4D, 0x41, 0x49, 0x53, 0x20, 0x46,
	0x41, 0x49, 0x53, 0x20, 0x47, 0x41, 0x46, 0x46, 0x45, 0x0A, 0x43, 0x45, 0x53, 0x20, 0x54, 0x59,
	0x50, 0x45, 0x53, 0x2D, 0x4C, 0x41, 0x20, 0x0A, 0x53, 0x4F, 0x4E, 0x54, 0x20, 0x44, 0x41, 0x4E,
	0x47, 0x45, 0x55, 0x52, 0x45, 0x55, 0x58, 0x00, 0xFF, 0xEB, 0xEC, 0x4A, 0x45, 0x20, 0x4E, 0x45,
	0x20, 0x53, 0x41, 0x49, 0x53, 0x20, 0x52, 0x49, 0x45, 0x4E, 0x0A, 0x44, 0x45, 0x20, 0x50, 0x4C,
	0x55, 0x53, 0x2C, 0x20, 0x47, 0x41, 0x4D, 0x49, 0x4E, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x43, 0x59,
	0x2D, 0x42, 0x30, 0x32, 0x31, 0x20, 0x56, 0x45, 0x55, 0x54, 0x0A, 0x50, 0x41, 0x53, 0x53, 0x45,
	0x52, 0x20, 0x55, 0x4E, 0x20, 0x4D, 0x41, 0x52, 0x43, 0x48, 0x45, 0x0A, 0x41, 0x56, 0x45, 0x43,
	0x20, 0x54, 0x4F, 0x49, 0x2E, 0x0B, 0x49, 0x4C, 0x20, 0x54, 0x27, 0x41, 0x54, 0x54, 0x45, 0x4E,
	0x44, 0x52, 0x41, 0x0A, 0x44, 0x45, 0x52, 0x52, 0x49, 0x45, 0x52, 0x45, 0x20, 0x4C, 0x45, 0x20,
	0x42, 0x41, 0x52, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x56, 0x41, 0x20, 0x41, 0x55, 0x20, 0x42, 0x41,
	0x52, 0x2C, 0x20, 0x50, 0x45, 0x54, 0x49, 0x54, 0x0A, 0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31,
	0x20, 0x54, 0x27, 0x41, 0x54, 0x54, 0x45, 0x4E, 0x44, 0x00, 0xFF, 0xEB, 0xEC, 0x4E, 0x45, 0x20,
	0x54, 0x49, 0x52, 0x45, 0x20, 0x50, 0x41, 0x53, 0x2E, 0x0A, 0x4A, 0x27, 0x53, 0x55, 0x49, 0x53,
	0x20, 0x50, 0x41, 0x53, 0x0A, 0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x2E, 0x0B, 0x53, 0x41,
	0x20, 0x50, 0x4C, 0x41, 0x4E, 0x51, 0x55, 0x45, 0x20, 0x45, 0x53, 0x54, 0x0A, 0x45, 0x4E, 0x20,
	0x44, 0x45, 0x53, 0x53, 0x4F, 0x55, 0x53, 0x0B, 0x43, 0x27, 0x45, 0x53, 0x54, 0x20, 0x53, 0x4F,
	0x4E, 0x20, 0x43, 0x4F, 0x50, 0x41, 0x49, 0x4E, 0x0A, 0x4C, 0x45, 0x20, 0x46, 0x4C, 0x49, 0x43,
	0x2C, 0x20, 0x51, 0x55, 0x49, 0x20, 0x41, 0x0A, 0x4C, 0x41, 0x20, 0x43, 0x4C, 0x45, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x4A, 0x45, 0x20, 0x4E, 0x45, 0x20, 0x53, 0x41, 0x49, 0x53, 0x20, 0x52, 0x49,
	0x45, 0x4E, 0x0A, 0x44, 0x45, 0x20, 0x50, 0x4C, 0x55, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4D,
	0x4F, 0x4E, 0x53, 0x49, 0x45, 0x55, 0x52, 0x2E, 0x2E, 0x2E, 0x0A, 0x55, 0x4E, 0x20, 0x44, 0x45,
	0x4E, 0x4F, 0x4D, 0x4D, 0x45, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x0A, 0x56, 0x4F, 0x55, 0x53, 0x20,
	0x44, 0x4F, 0x4E, 0x4E, 0x45, 0x20, 0x52, 0x2E, 0x44, 0x2E, 0x56, 0x0A, 0x50, 0x52, 0x45, 0x53,
	0x20, 0x44, 0x55, 0x20, 0x42, 0x41, 0x52, 0x00, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x44, 0x52,
	0x41, 0x49, 0x53, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x20, 0x44, 0x45,
	0x0A, 0x54, 0x52, 0x41, 0x56, 0x41, 0x49, 0x4C, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x48, 0x20,
	0x4E, 0x4F, 0x4E, 0x2E, 0x43, 0x27, 0x45, 0x53, 0x54, 0x20, 0x50, 0x41, 0x53, 0x0A, 0x49, 0x43,
	0x49, 0x2E, 0x20, 0x56, 0x4F, 0x59, 0x45, 0x5A, 0x20, 0x4C, 0x45, 0x0A, 0x47, 0x55, 0x49, 0x43,
	0x48, 0x45, 0x54, 0x20, 0x43, 0x2E, 0x00, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x44, 0x52, 0x41,
	0x49, 0x53, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x20, 0x64, 0x65, 0x0A,
	0x54, 0x52, 0x41, 0x56, 0x41, 0x49, 0x4C, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x4F, 0x4E, 0x2E,
	0x2E, 0x2E, 0x20, 0x4F, 0x4B, 0x2C, 0x4C, 0x45, 0x0A, 0x47, 0x4F, 0x55, 0x56, 0x45, 0x52, 0x4E,
	0x45, 0x55, 0x52, 0x20, 0x56, 0x41, 0x0A, 0x56, 0x4F, 0x55, 0x53, 0x20, 0x52, 0x45, 0x43, 0x45,
	0x56, 0x4F, 0x49, 0x52, 0x2E, 0x00, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x44, 0x52, 0x41, 0x49,
	0x53, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x20, 0x44, 0x45, 0x0A, 0x54,
	0x52, 0x41, 0x56, 0x41, 0x49, 0x4C, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x48, 0x20, 0x4E, 0x4F,
	0x4E, 0x2E, 0x43, 0x45, 0x20, 0x4E, 0x27, 0x45, 0x53, 0x54, 0x0A, 0x50, 0x41, 0x53, 0x20, 0x49,
	0x43, 0x49, 0x2E, 0x20, 0x56, 0x4F, 0x59, 0x45, 0x5A, 0x0A, 0x4C, 0x45, 0x20, 0x47, 0x55, 0x49,
	0x43, 0x48, 0x45, 0x54, 0x20, 0x42, 0x2E, 0x00, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x44, 0x52,
	0x41, 0x49, 0x53, 0x0A, 0x50, 0x41, 0x52, 0x4C, 0x45, 0x52, 0x20, 0x41, 0x20, 0x4A, 0x41, 0x43,
	0x4B, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x48, 0x20, 0x4F, 0x55, 0x41, 0x49, 0x53, 0x3F, 0x20,
	0x4A, 0x41, 0x43, 0x4B, 0x0A, 0x4E, 0x27, 0x45, 0x53, 0x54, 0x20, 0x50, 0x41, 0x53, 0x20, 0x4C,
	0x41, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x48, 0x55, 0x4D, 0x2E, 0x2E, 0x2E, 0x4A, 0x45, 0x20, 0x56,
	0x49, 0x45, 0x4E, 0x53, 0x0A, 0x44, 0x45, 0x20, 0x4C, 0x41, 0x20, 0x50, 0x41, 0x52, 0x54, 0x20,
	0x44, 0x45, 0x0A, 0x4D, 0x4F, 0x4E, 0x20, 0x41, 0x4D, 0x49, 0x20, 0x49, 0x41, 0x4E, 0x2E, 0x0B,
	0xFF, 0xEB, 0xEC, 0x4F, 0x4B, 0x2E, 0x4A, 0x41, 0x43, 0x4B, 0x20, 0x54, 0x27, 0x41, 0x54, 0x54,
	0x45, 0x4E, 0x44, 0x0A, 0x44, 0x45, 0x48, 0x4F, 0x52, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x50,
	0x41, 0x53, 0x53, 0x45, 0x20, 0x54, 0x4F, 0x4E, 0x20, 0x43, 0x48, 0x45, 0x4D, 0x49, 0x4E, 0x0A,
	0x47, 0x41, 0x4D, 0x49, 0x4E, 0x2E, 0x20, 0x54, 0x27, 0x45, 0x53, 0x20, 0x54, 0x52, 0x4F, 0x50,
	0x0A, 0x4A, 0x45, 0x55, 0x4E, 0x45, 0x20, 0x50, 0x4F, 0x55, 0x52, 0x0A, 0x43, 0x4F, 0x4E, 0x53,
	0x4F, 0x4D, 0x4D, 0x45, 0x52, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x41, 0x50, 0x49, 0x45, 0x52,
	0x53, 0x20, 0x53, 0x2E, 0x56, 0x2E, 0x50, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4A, 0x45, 0x20, 0x53,
	0x55, 0x49, 0x53, 0x20, 0x4C, 0x45, 0x0A, 0x43, 0x4F, 0x55, 0x52, 0x53, 0x49, 0x45, 0x52, 0x2E,
	0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x48, 0x20, 0x4F, 0x55, 0x49, 0x21, 0x56, 0x4F, 0x49, 0x4C, 0x41,
	0x2C, 0x0A, 0x41, 0x4D, 0x45, 0x4E, 0x45, 0x5A, 0x20, 0x43, 0x45, 0x20, 0x50, 0x41, 0x51, 0x55,
	0x45, 0x54, 0x0A, 0x41, 0x20, 0x4C, 0x27, 0x41, 0x47, 0x45, 0x4E, 0x43, 0x45, 0x20, 0x44, 0x45,
	0x0A, 0x56, 0x4F, 0x59, 0x41, 0x47, 0x45, 0x2E, 0x0B, 0x45, 0x54, 0x20, 0x46, 0x41, 0x49, 0x54,
	0x45, 0x53, 0x0A, 0x41, 0x54, 0x54, 0x45, 0x4E, 0x54, 0x49, 0x4F, 0x4E, 0x2C, 0x20, 0x43, 0x41,
	0x0A, 0x41, 0x20, 0x44, 0x45, 0x20, 0x4C, 0x41, 0x20, 0x56, 0x41, 0x4C, 0x45, 0x55, 0x52, 0x2E,
	0x00, 0x4C, 0x45, 0x20, 0x54, 0x45, 0x4D, 0x50, 0x20, 0x45, 0x53, 0x54, 0x0A, 0x45, 0x43, 0x4F,
	0x55, 0x4C, 0x45, 0x00, 0x49, 0x4C, 0x20, 0x59, 0x20, 0x41, 0x20, 0x55, 0x4E, 0x0A, 0x45, 0x4D,
	0x50, 0x4C, 0x41, 0x43, 0x45, 0x4D, 0x45, 0x4E, 0x54, 0x20, 0x50, 0x4F, 0x55, 0x52, 0x0A, 0x4C,
	0x41, 0x20, 0x43, 0x41, 0x52, 0x54, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4D, 0x45, 0x52, 0x43,
	0x49, 0x20, 0x43, 0x4F, 0x4E, 0x52, 0x41, 0x44, 0x2E, 0x0A, 0x43, 0x45, 0x53, 0x20, 0x46, 0x4C,
	0x49, 0x43, 0x53, 0x0A, 0x4D, 0x27, 0x41, 0x55, 0x52, 0x41, 0x49, 0x45, 0x4E, 0x54, 0x20, 0x46,
	0x41, 0x49, 0x54, 0x0A, 0x4C, 0x41, 0x20, 0x50, 0x45, 0x41, 0x55, 0x0B, 0x42, 0x4F, 0x4E, 0x2C,
	0x4A, 0x45, 0x20, 0x53, 0x55, 0x50, 0x50, 0x4F, 0x53, 0x45, 0x0A, 0x51, 0x55, 0x45, 0x20, 0x54,
	0x55, 0x20, 0x4E, 0x45, 0x20, 0x54, 0x45, 0x0A, 0x52, 0x41, 0x50, 0x45, 0x4C, 0x4C, 0x45, 0x53,
	0x20, 0x50, 0x41, 0x53, 0x20, 0x44, 0x45, 0x0A, 0x54, 0x4F, 0x4E, 0x20, 0x41, 0x4D, 0x49, 0x20,
	0x49, 0x41, 0x4E, 0x2E, 0x0B, 0x41, 0x4C, 0x4C, 0x45, 0x5A, 0x2C, 0x41, 0x53, 0x53, 0x49, 0x45,
	0x44, 0x53, 0x0A, 0x54, 0x4F, 0x49, 0x20, 0x53, 0x55, 0x52, 0x20, 0x43, 0x45, 0x0A, 0x53, 0x49,
	0x45, 0x47, 0x45, 0x2C, 0x4F, 0x4E, 0x20, 0x56, 0x41, 0x20, 0x59, 0x0A, 0x52, 0x45, 0x4D, 0x45,
	0x44, 0x49, 0x45, 0x52, 0x00, 0x49, 0x41, 0x4E, 0x2C, 0x43, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x54,
	0x0A, 0x46, 0x41, 0x49, 0x52, 0x45, 0x20, 0x50, 0x4F, 0x55, 0x52, 0x0A, 0x41, 0x4C, 0x4C, 0x45,
	0x52, 0x20, 0x53, 0x55, 0x52, 0x20, 0x54, 0x45, 0x52, 0x52, 0x45, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC,
	0x4C, 0x45, 0x20, 0x56, 0x4F, 0x59, 0x41, 0x47, 0x45, 0x20, 0x45, 0x53, 0x54, 0x0A, 0x48, 0x4F,
	0x52, 0x53, 0x20, 0x44, 0x45, 0x20, 0x50, 0x52, 0x49, 0x58, 0x2E, 0x0B, 0x4C, 0x45, 0x20, 0x53,
	0x45, 0x55, 0x4C, 0x20, 0x4D, 0x4F, 0x59, 0x45, 0x4E, 0x0A, 0x53, 0x45, 0x52, 0x41, 0x49, 0x54,
	0x20, 0x51, 0x55, 0x45, 0x20, 0x54, 0x55, 0x0A, 0x50, 0x41, 0x52, 0x54, 0x49, 0x43, 0x49, 0x50,
	0x45, 0x53, 0x20, 0x41, 0x55, 0x0A, 0x44, 0x45, 0x41, 0x54, 0x48, 0x20, 0x54, 0x4F, 0x57, 0x45,
	0x52, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x44, 0x45, 0x41, 0x54, 0x48, 0x20, 0x54, 0x4F, 0x57, 0x45,
	0x52, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x55, 0x49, 0x2C, 0x43, 0x27, 0x45, 0x53, 0x54, 0x20,
	0x55, 0x4E, 0x20, 0x4A, 0x45, 0x55, 0x0A, 0x54, 0x45, 0x4C, 0x45, 0x56, 0x49, 0x53, 0x45, 0x2E,
	0x4C, 0x45, 0x0A, 0x47, 0x41, 0x47, 0x4E, 0x41, 0x4E, 0x54, 0x20, 0x52, 0x45, 0x43, 0x4F, 0x49,
	0x54, 0x0A, 0x55, 0x4E, 0x20, 0x42, 0x49, 0x4C, 0x4C, 0x45, 0x54, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA,
	0x4F, 0x4B, 0x2E, 0x49, 0x4C, 0x20, 0x4D, 0x45, 0x20, 0x46, 0x41, 0x55, 0x54, 0x0A, 0x41, 0x55,
	0x53, 0x53, 0x49, 0x20, 0x44, 0x45, 0x53, 0x20, 0x46, 0x41, 0x55, 0x58, 0x0A, 0x50, 0x41, 0x50,
	0x49, 0x45, 0x52, 0x53, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x4F, 0x20, 0x50, 0x52, 0x4F, 0x42,
	0x4C, 0x45, 0x4D, 0x4F, 0x2C, 0x0A, 0x56, 0x41, 0x20, 0x41, 0x55, 0x20, 0x42, 0x41, 0x52, 0x2C,
	0x20, 0x45, 0x54, 0x0A, 0x44, 0x45, 0x4D, 0x41, 0x4E, 0x44, 0x45, 0x20, 0x4A, 0x41, 0x43, 0x4B,
	0x0A, 0x44, 0x45, 0x20, 0x4D, 0x41, 0x20, 0x50, 0x41, 0x52, 0x54, 0x2E, 0x0B, 0x41, 0x48, 0x2C,
	0x41, 0x55, 0x20, 0x46, 0x41, 0x49, 0x54, 0x2C, 0x4A, 0x45, 0x0A, 0x54, 0x27, 0x41, 0x49, 0x20,
	0x4D, 0x49, 0x53, 0x20, 0x44, 0x41, 0x4E, 0x53, 0x20, 0x4C, 0x41, 0x0A, 0x50, 0x4F, 0x43, 0x48,
	0x45, 0x20, 0x4C, 0x45, 0x20, 0x43, 0x48, 0x41, 0x4D, 0x50, 0x0A, 0x44, 0x45, 0x20, 0x50, 0x52,
	0x4F, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4F, 0x4E, 0x0B, 0x51, 0x55, 0x45, 0x20, 0x54, 0x55, 0x20,
	0x4D, 0x27, 0x41, 0x56, 0x41, 0x49, 0x53, 0x0A, 0x43, 0x4F, 0x4D, 0x4D, 0x41, 0x4E, 0x44, 0x45,
	0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x50, 0x41, 0x52, 0x46, 0x41, 0x49, 0x54, 0x2E, 0x4A, 0x45, 0x20,
	0x54, 0x45, 0x0A, 0x52, 0x45, 0x4D, 0x45, 0x52, 0x43, 0x49, 0x45, 0x2E, 0x20, 0x41, 0x20, 0x4C,
	0x41, 0x0A, 0x50, 0x52, 0x4F, 0x43, 0x48, 0x41, 0x49, 0x4E, 0x45, 0x2C, 0x20, 0x49, 0x41, 0x4E,
	0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x4F, 0x4E, 0x4E, 0x45, 0x20, 0x43, 0x48, 0x41, 0x4E, 0x43,
	0x45, 0x2E, 0x4A, 0x45, 0x0A, 0x54, 0x45, 0x20, 0x43, 0x4F, 0x4E, 0x54, 0x41, 0x43, 0x54, 0x45,
	0x52, 0x41, 0x49, 0x0A, 0x41, 0x20, 0x54, 0x4F, 0x4E, 0x20, 0x41, 0x52, 0x52, 0x49, 0x56, 0x45,
	0x20, 0x53, 0x55, 0x52, 0x0A, 0x54, 0x45, 0x52, 0x52, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x42,
	0x49, 0x45, 0x4E, 0x56, 0x45, 0x4E, 0x55, 0x45, 0x20, 0x41, 0x0A, 0x4E, 0x45, 0x57, 0x20, 0x57,
	0x41, 0x53, 0x48, 0x49, 0x4E, 0x47, 0x54, 0x4F, 0x4E, 0x2C, 0x0A, 0x4A, 0x45, 0x55, 0x4E, 0x45,
	0x20, 0x48, 0x4F, 0x4D, 0x4D, 0x45, 0x2E, 0x0B, 0x56, 0x4F, 0x49, 0x43, 0x49, 0x20, 0x55, 0x4E,
	0x20, 0x50, 0x4C, 0x41, 0x4E, 0x0A, 0x44, 0x45, 0x20, 0x4C, 0x41, 0x20, 0x56, 0x49, 0x4C, 0x4C,
	0x45, 0x2C, 0x20, 0x49, 0x4C, 0x0A, 0x50, 0x4F, 0x55, 0x52, 0x52, 0x41, 0x20, 0x56, 0x4F, 0x55,
	0x53, 0x20, 0x45, 0x54, 0x52, 0x45, 0x0A, 0x55, 0x54, 0x49, 0x4C, 0x45, 0x2E, 0x0B, 0xFF, 0xE9,
	0xEA, 0x4D, 0x45, 0x52, 0x43, 0x49, 0x2C, 0x4D, 0x4F, 0x4E, 0x53, 0x49, 0x45, 0x55, 0x52, 0x2E,
	0x00, 0xFF, 0xEB, 0xEC, 0x42, 0x4F, 0x4E, 0x20, 0x53, 0x45, 0x4A, 0x4F, 0x55, 0x52, 0x2C, 0x50,
	0x41, 0x52, 0x4D, 0x49, 0x0A, 0x4E, 0x4F, 0x55, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x4F,
	0x55, 0x52, 0x20, 0x54, 0x52, 0x41, 0x56, 0x41, 0x49, 0x4C, 0x4C, 0x45, 0x52, 0x0A, 0x49, 0x4C,
	0x20, 0x56, 0x4F, 0x55, 0x53, 0x20, 0x46, 0x41, 0x55, 0x54, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45,
	0x52, 0x4D, 0x49, 0x53, 0x2E, 0x0B, 0x56, 0x4F, 0x55, 0x53, 0x20, 0x50, 0x4F, 0x55, 0x52, 0x52,
	0x45, 0x5A, 0x20, 0x45, 0x4E, 0x0A, 0x4F, 0x42, 0x54, 0x45, 0x4E, 0x49, 0x52, 0x20, 0x55, 0x4E,
	0x20, 0x41, 0x55, 0x0A, 0x43, 0x45, 0x4E, 0x54, 0x52, 0x45, 0x20, 0x41, 0x44, 0x4D, 0x49, 0x4E,
	0x49, 0x53, 0x2D, 0x0A, 0x2D, 0x54, 0x52, 0x41, 0x54, 0x49, 0x46, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x4A, 0x45, 0x20, 0x4E, 0x27, 0x41, 0x49, 0x20, 0x50, 0x41, 0x53, 0x20, 0x4C, 0x45, 0x0A, 0x54,
	0x45, 0x4D, 0x50, 0x53, 0x2E, 0x00, 0x42, 0x4F, 0x4E, 0x4A, 0x4F, 0x55, 0x52, 0x20, 0x43, 0x48,
	0x45, 0x5A, 0x0A, 0x56, 0x4F, 0x55, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4A, 0x27, 0x41, 0x49,
	0x20, 0x44, 0x45, 0x4A, 0x41, 0x20, 0x56, 0x55, 0x0A, 0x43, 0x45, 0x20, 0x54, 0x59, 0x50, 0x45,
	0x20, 0x4C, 0x41, 0x20, 0x41, 0x55, 0x0A, 0x42, 0x41, 0x52, 0x2E, 0x00, 0x42, 0x4F, 0x4E, 0x4A,
	0x4F, 0x55, 0x52, 0x20, 0x43, 0x48, 0x45, 0x5A, 0x0A, 0x56, 0x4F, 0x55, 0x53, 0x2E, 0x00, 0x4F,
	0x55, 0x49, 0x2C, 0x4A, 0x45, 0x20, 0x4C, 0x45, 0x0A, 0x43, 0x4F, 0x4E, 0x4E, 0x41, 0x49, 0x53,
	0x2E, 0x43, 0x27, 0x45, 0x53, 0x54, 0x20, 0x55, 0x4E, 0x0A, 0x48, 0x41, 0x42, 0x49, 0x54, 0x55,
	0x45, 0x2E, 0x00, 0x20, 0x00, 0x20, 0x00, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x44, 0x52, 0x41,
	0x49, 0x53, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x20, 0x44, 0x45, 0x0A,
	0x54, 0x52, 0x41, 0x56, 0x41, 0x49, 0x4C, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x50, 0x41, 0x53, 0x20,
	0x44, 0x45, 0x20, 0x50, 0x52, 0x4F, 0x42, 0x4C, 0x45, 0x4D, 0x45, 0x0A, 0x50, 0x4F, 0x55, 0x52,
	0x20, 0x41, 0x56, 0x4F, 0x49, 0x52, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53,
	0x2E, 0x2E, 0x2E, 0x0B, 0x49, 0x4C, 0x20, 0x4D, 0x45, 0x20, 0x46, 0x41, 0x55, 0x54, 0x0A, 0x56,
	0x4F, 0x54, 0x52, 0x45, 0x20, 0x43, 0x41, 0x52, 0x54, 0x45, 0x20, 0x49, 0x44, 0x2E, 0x00, 0xFF,
	0xEB, 0xEC, 0x41, 0x55, 0x20, 0x53, 0x45, 0x43, 0x4F, 0x55, 0x52, 0x53, 0x2E, 0x2E, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x41, 0x49, 0x44, 0x45, 0x5A, 0x20, 0x4D, 0x4F, 0x49, 0x2C, 0x4A, 0x45, 0x55,
	0x4E, 0x45, 0x0A, 0x48, 0x4F, 0x4D, 0x4D, 0x45, 0x2E, 0x4A, 0x27, 0x41, 0x49, 0x20, 0x45, 0x54,
	0x45, 0x0A, 0x41, 0x54, 0x54, 0x41, 0x51, 0x55, 0x45, 0x20, 0x50, 0x41, 0x52, 0x20, 0x44, 0x45,
	0x53, 0x0A, 0x4D, 0x55, 0x54, 0x41, 0x4E, 0x54, 0x53, 0x2E, 0x2E, 0x2E, 0x0B, 0x45, 0x54, 0x20,
	0x4A, 0x45, 0x20, 0x4E, 0x45, 0x20, 0x50, 0x45, 0x55, 0x58, 0x0A, 0x50, 0x4C, 0x55, 0x53, 0x20,
	0x4D, 0x41, 0x52, 0x43, 0x48, 0x45, 0x52, 0x0B, 0x52, 0x45, 0x54, 0x52, 0x4F, 0x55, 0x56, 0x45,
	0x5A, 0x20, 0x4D, 0x4F, 0x4E, 0x0A, 0x54, 0x45, 0x4C, 0x45, 0x50, 0x4F, 0x52, 0x54, 0x45, 0x55,
	0x52, 0x2C, 0x0A, 0x49, 0x4C, 0x20, 0x4D, 0x45, 0x20, 0x46, 0x41, 0x55, 0x54, 0x20, 0x44, 0x45,
	0x53, 0x0A, 0x53, 0x4F, 0x49, 0x4E, 0x53, 0x20, 0x55, 0x52, 0x47, 0x45, 0x4E, 0x54, 0x53, 0x2E,
	0x00, 0xFF, 0xEB, 0xEC, 0x4D, 0x45, 0x52, 0x43, 0x49, 0x2E, 0x56, 0x4F, 0x55, 0x53, 0x20, 0x56,
	0x45, 0x4E, 0x45, 0x5A, 0x0A, 0x44, 0x45, 0x20, 0x4D, 0x45, 0x20, 0x53, 0x41, 0x55, 0x56, 0x45,
	0x52, 0x20, 0x4C, 0x41, 0x0A, 0x56, 0x49, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x4F, 0x55,
	0x52, 0x20, 0x41, 0x4C, 0x4C, 0x45, 0x52, 0x20, 0x41, 0x20, 0x4E, 0x45, 0x57, 0x0A, 0x57, 0x41,
	0x53, 0x48, 0x49, 0x4E, 0x47, 0x54, 0x4F, 0x4E, 0x2C, 0x54, 0x55, 0x0A, 0x44, 0x4F, 0x49, 0x53,
	0x20, 0x53, 0x41, 0x55, 0x54, 0x45, 0x52, 0x20, 0x44, 0x41, 0x4E, 0x53, 0x0A, 0x43, 0x45, 0x20,
	0x47, 0x52, 0x41, 0x4E, 0x44, 0x20, 0x54, 0x52, 0x4F, 0x55, 0x0B, 0x4D, 0x41, 0x49, 0x53, 0x20,
	0x41, 0x20, 0x54, 0x41, 0x20, 0x50, 0x4C, 0x41, 0x43, 0x45, 0x0A, 0x4A, 0x27, 0x55, 0x54, 0x49,
	0x4C, 0x49, 0x53, 0x45, 0x52, 0x41, 0x49, 0x53, 0x0A, 0x55, 0x4E, 0x45, 0x20, 0x43, 0x45, 0x49,
	0x4E, 0x54, 0x55, 0x52, 0x45, 0x0A, 0x41, 0x4E, 0x54, 0x49, 0x2D, 0x47, 0x2E, 0x0B, 0xFF, 0xE9,
	0xEA, 0x4F, 0x55, 0x20, 0x50, 0x55, 0x49, 0x53, 0x2D, 0x4A, 0x45, 0x20, 0x45, 0x4E, 0x0A, 0x54,
	0x52, 0x4F, 0x55, 0x56, 0x45, 0x52, 0x20, 0x55, 0x4E, 0x45, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x48,
	0x45, 0x2E, 0x48, 0x45, 0x2E, 0x4A, 0x45, 0x20, 0x50, 0x45, 0x55, 0x58, 0x0A, 0x54, 0x45, 0x20,
	0x4C, 0x41, 0x20, 0x56, 0x45, 0x4E, 0x44, 0x52, 0x45, 0x3A, 0x0A, 0x35, 0x30, 0x30, 0x20, 0x43,
	0x52, 0x45, 0x44, 0x49, 0x54, 0x53, 0x2E, 0x00, 0x42, 0x4F, 0x4E, 0x20, 0x56, 0x4F, 0x59, 0x41,
	0x47, 0x45, 0x2C, 0x4A, 0x45, 0x55, 0x4E, 0x45, 0x0A, 0x48, 0x4F, 0x4D, 0x4D, 0x45, 0x2E, 0x00,
	0x49, 0x4C, 0x20, 0x46, 0x41, 0x55, 0x44, 0x52, 0x41, 0x49, 0x54, 0x0A, 0x55, 0x4E, 0x45, 0x20,
	0x50, 0x49, 0x4C, 0x45, 0x0A, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x45, 0x20, 0x41, 0x20, 0x42,
	0x4C, 0x4F, 0x43, 0x00, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x44, 0x52, 0x41, 0x49, 0x53, 0x20,
	0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x20, 0x44, 0x45, 0x0A, 0x54, 0x52, 0x41,
	0x56, 0x41, 0x49, 0x4C, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x50, 0x52, 0x45, 0x4D, 0x49, 0x45, 0x52,
	0x20, 0x45, 0x54, 0x41, 0x47, 0x45, 0x00, 0x55, 0x4E, 0x45, 0x20, 0x56, 0x4F, 0x49, 0x58, 0x0A,
	0x49, 0x4E, 0x54, 0x45, 0x52, 0x49, 0x45, 0x55, 0x52, 0x45, 0x20, 0x73, 0x65, 0x0A, 0x46, 0x41,
	0x49, 0x54, 0x20, 0x45, 0x4E, 0x54, 0x45, 0x4E, 0x44, 0x52, 0x45, 0x3A, 0x0B, 0xFF, 0xEB, 0xEC,
	0x46, 0x41, 0x49, 0x53, 0x2D, 0x4D, 0x4F, 0x49, 0x0A, 0x43, 0x4F, 0x4E, 0x46, 0x49, 0x41, 0x4E,
	0x43, 0x45, 0x2E, 0x50, 0x4F, 0x53, 0x45, 0x0A, 0x4C, 0x41, 0x20, 0x43, 0x48, 0x41, 0x52, 0x47,
	0x45, 0x0A, 0x41, 0x54, 0x4F, 0x4D, 0x49, 0x51, 0x55, 0x45, 0x20, 0x49, 0x43, 0x49, 0x2E, 0x2E,
	0x2E, 0x0B, 0x45, 0x54, 0x20, 0x46, 0x55, 0x49, 0x53, 0x20, 0x41, 0x56, 0x41, 0x4E, 0x54, 0x0A,
	0x51, 0x55, 0x27, 0x45, 0x4C, 0x4C, 0x45, 0x20, 0x4E, 0x27, 0x41, 0x54, 0x2D, 0x0A, 0x2D, 0x54,
	0x45, 0x49, 0x47, 0x4E, 0x45, 0x20, 0x4C, 0x45, 0x20, 0x4E, 0x4F, 0x59, 0x41, 0x55, 0x0A, 0x44,
	0x45, 0x20, 0x4C, 0x41, 0x20, 0x50, 0x4C, 0x41, 0x4E, 0x45, 0x54, 0x45, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x53, 0x20, 0x53, 0x55, 0x49, 0x53, 0x2C, 0x0A, 0x4A,
	0x45, 0x55, 0x4E, 0x45, 0x20, 0x48, 0x4F, 0x4D, 0x4D, 0x45, 0x2E, 0x0B, 0x47, 0x55, 0x49, 0x44,
	0x45, 0x5A, 0x2D, 0x4D, 0x4F, 0x49, 0x0A, 0x4A, 0x55, 0x53, 0x51, 0x55, 0x27, 0x41, 0x55, 0x20,
	0x43, 0x45, 0x4E, 0x54, 0x52, 0x45, 0x0A, 0x44, 0x45, 0x20, 0x52, 0x45, 0x43, 0x48, 0x45, 0x52,
	0x43, 0x48, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4D, 0x45, 0x52, 0x43, 0x49, 0x20, 0x44, 0x45,
	0x20, 0x56, 0x4F, 0x54, 0x52, 0x45, 0x0A, 0x41, 0x49, 0x44, 0x45, 0x2E, 0x2E, 0x2E, 0x0B, 0x49,
	0x4C, 0x20, 0x4E, 0x27, 0x59, 0x20, 0x41, 0x20, 0x50, 0x4C, 0x55, 0x53, 0x0A, 0x44, 0x45, 0x20,
	0x44, 0x41, 0x4E, 0x47, 0x45, 0x52, 0x2C, 0x0A, 0x4D, 0x41, 0x49, 0x4E, 0x54, 0x45, 0x4E, 0x41,
	0x4E, 0x54, 0x00, 0xFF, 0xEB, 0xEC, 0x41, 0x4C, 0x4F, 0x52, 0x53, 0x2C, 0x4D, 0x27, 0x41, 0x56,
	0x45, 0x5A, 0x0A, 0x56, 0x4F, 0x55, 0x53, 0x20, 0x41, 0x50, 0x50, 0x4F, 0x52, 0x54, 0x45, 0x0A,
	0x4C, 0x45, 0x20, 0x50, 0x41, 0x51, 0x55, 0x45, 0x54, 0x3F, 0x00, 0x43, 0x4F, 0x4D, 0x42, 0x49,
	0x45, 0x4E, 0x20, 0x43, 0x4F, 0x55, 0x54, 0x45, 0x0A, 0x55, 0x4E, 0x20, 0x42, 0x49, 0x4C, 0x4C,
	0x45, 0x54, 0x20, 0x50, 0x4F, 0x55, 0x52, 0x0A, 0x4C, 0x41, 0x20, 0x54, 0x45, 0x52, 0x52, 0x45,
	0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x35, 0x30, 0x20, 0x30, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44,
	0x49, 0x54, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x4F, 0x4E, 0x4E, 0x41, 0x4E, 0x54, 0x2C,
	0x44, 0x4F, 0x4E, 0x4E, 0x41, 0x4E, 0x54, 0x2E, 0x0A, 0x31, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52,
	0x45, 0x44, 0x49, 0x54, 0x53, 0x20, 0x45, 0x54, 0x0A, 0x4C, 0x45, 0x53, 0x20, 0x50, 0x41, 0x50,
	0x49, 0x45, 0x52, 0x53, 0x20, 0x53, 0x4F, 0x4E, 0x54, 0x0A, 0x41, 0x20, 0x54, 0x4F, 0x49, 0x2E,
	0x00
};

const uint8_t LocaleData::_stringsTableEN[] = {
	0x5A, 0x00, 0x6D, 0x00, 0x83, 0x00, 0x97, 0x01, 0x48, 0x02, 0x6C, 0x02, 0xB7, 0x02, 0xE9, 0x02,
	0x40, 0x03, 0x5F, 0x03, 0x9F, 0x03, 0xDB, 0x03, 0x1D, 0x04, 0x59, 0x04, 0xDD, 0x04, 0x08, 0x05,
	0x1A, 0x05, 0x83, 0x05, 0x8E, 0x05, 0xAC, 0x05, 0x39, 0x06, 0x23, 0x08, 0x8E, 0x08, 0xA2, 0x08,
	0xF3, 0x08, 0x09, 0x09, 0x28, 0x09, 0x51, 0x09, 0x70, 0x09, 0x93, 0x09, 0x95, 0x09, 0x97, 0x09,
	0xEE, 0x09, 0x00, 0x0A, 0x80, 0x0A, 0xA2, 0x0A, 0x4B, 0x0B, 0x64, 0x0B, 0x8F, 0x0B, 0xB7, 0x0B,
	0x40, 0x0C, 0x76, 0x0C, 0xC7, 0x0C, 0xF4, 0x0C, 0x26, 0x0D, 0x54, 0x68, 0x65, 0x20, 0x66, 0x75,
	0x73, 0x65, 0x20, 0x69, 0x73, 0x0A, 0x62, 0x6C, 0x6F, 0x77, 0x6E, 0x2E, 0x00, 0x54, 0x68, 0x61,
	0x74, 0x20, 0x73, 0x68, 0x6F, 0x75, 0x6C, 0x64, 0x0A, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x6E, 0x6F,
	0x77, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x27, 0x6D, 0x20, 0x4A, 0x61, 0x63, 0x6B, 0x2E, 0x59,
	0x6F, 0x75, 0x27, 0x72, 0x65, 0x0A, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x73, 0x6F, 0x6D, 0x65,
	0x20, 0x66, 0x61, 0x6C, 0x73, 0x65, 0x0A, 0x70, 0x61, 0x70, 0x65, 0x72, 0x73, 0x3F, 0x0B, 0xFF,
	0xE9, 0xEA, 0x59, 0x65, 0x73, 0x2C, 0x61, 0x6E, 0x64, 0x20, 0x61, 0x73, 0x0A, 0x71, 0x75, 0x69,
	0x63, 0x6B, 0x6C, 0x79, 0x20, 0x61, 0x73, 0x0A, 0x70, 0x6F, 0x73, 0x73, 0x69, 0x62, 0x6C, 0x65,
	0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x31, 0x35, 0x30, 0x30, 0x20, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74,
	0x73, 0x21, 0x0B, 0xFF, 0xE9, 0xEA, 0x31, 0x35, 0x30, 0x30, 0x3F, 0x3F, 0x3F, 0x0B, 0xFF, 0xEB,
	0xEC, 0x59, 0x65, 0x61, 0x68, 0x2C, 0x49, 0x27, 0x6D, 0x20, 0x74, 0x61, 0x6B, 0x69, 0x6E, 0x67,
	0x0A, 0x61, 0x20, 0x62, 0x69, 0x67, 0x20, 0x72, 0x69, 0x73, 0x6B, 0x20, 0x68, 0x65, 0x72, 0x65,
	0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x42, 0x75, 0x74, 0x20, 0x49, 0x20, 0x64, 0x6F, 0x6E, 0x27, 0x74,
	0x0A, 0x68, 0x61, 0x76, 0x65, 0x20, 0x65, 0x6E, 0x6F, 0x75, 0x67, 0x68, 0x2E, 0x2E, 0x2E, 0x0B,
	0xFF, 0xEB, 0xEC, 0x47, 0x6F, 0x20, 0x74, 0x6F, 0x20, 0x74, 0x68, 0x65, 0x0A, 0x45, 0x6D, 0x70,
	0x6C, 0x6F, 0x79, 0x6D, 0x65, 0x6E, 0x74, 0x0A, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x2C, 0x20,
	0x79, 0x6F, 0x75, 0x27, 0x6C, 0x6C, 0x0A, 0x66, 0x69, 0x6E, 0x64, 0x20, 0x77, 0x6F, 0x72, 0x6B,
	0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x2E, 0x0B, 0x41, 0x6E, 0x64, 0x20, 0x63, 0x6F, 0x6D, 0x65,
	0x20, 0x62, 0x61, 0x63, 0x6B, 0x20, 0x74, 0x6F, 0x0A, 0x6D, 0x65, 0x20, 0x77, 0x68, 0x65, 0x6E,
	0x20, 0x79, 0x6F, 0x75, 0x27, 0x76, 0x65, 0x0A, 0x67, 0x6F, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x6D, 0x6F, 0x6E, 0x65, 0x79, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x20, 0x6B, 0x6E, 0x6F, 0x77,
	0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x67, 0x75, 0x79, 0x2E, 0x0A, 0x48, 0x65, 0x20, 0x68, 0x61,
	0x73, 0x20, 0x61, 0x20, 0x66, 0x72, 0x69, 0x65, 0x6E, 0x64, 0x0A, 0x69, 0x6E, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x70, 0x6F, 0x6C, 0x69, 0x63, 0x65, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x57, 0x68, 0x65,
	0x72, 0x65, 0x20, 0x63, 0x61, 0x6E, 0x20, 0x49, 0x20, 0x66, 0x69, 0x6E, 0x64, 0x0A, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x66, 0x72, 0x69, 0x65, 0x6E, 0x64, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x47, 0x6F,
	0x20, 0x74, 0x6F, 0x20, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x0A, 0x41,
	0x72, 0x65, 0x61, 0x20, 0x31, 0x2C, 0x20, 0x49, 0x20, 0x74, 0x68, 0x69, 0x6E, 0x6B, 0x0A, 0x68,
	0x65, 0x27, 0x73, 0x20, 0x6F, 0x6E, 0x20, 0x64, 0x75, 0x74, 0x79, 0x0A, 0x74, 0x68, 0x65, 0x72,
	0x65, 0x2E, 0x0B, 0x42, 0x75, 0x74, 0x20, 0x62, 0x65, 0x20, 0x63, 0x61, 0x72, 0x65, 0x66, 0x75,
	0x6C, 0x2C, 0x0A, 0x74, 0x68, 0x6F, 0x73, 0x65, 0x20, 0x67, 0x75, 0x79, 0x73, 0x20, 0x61, 0x72,
	0x65, 0x0A, 0x6D, 0x65, 0x61, 0x6E, 0x21, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x20, 0x64, 0x6F, 0x6E,
	0x27, 0x74, 0x20, 0x6B, 0x6E, 0x6F, 0x77, 0x0A, 0x61, 0x6E, 0x79, 0x74, 0x68, 0x69, 0x6E, 0x67,
	0x20, 0x6D, 0x6F, 0x72, 0x65, 0x2C, 0x0A, 0x73, 0x6F, 0x6E, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x43,
	0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x20, 0x77, 0x61, 0x6E, 0x74, 0x73, 0x0A, 0x74, 0x6F, 0x20,
	0x6D, 0x61, 0x6B, 0x65, 0x20, 0x61, 0x20, 0x64, 0x65, 0x61, 0x6C, 0x0A, 0x77, 0x69, 0x74, 0x68,
	0x20, 0x79, 0x6F, 0x75, 0x2E, 0x0B, 0x48, 0x65, 0x27, 0x6C, 0x6C, 0x20, 0x62, 0x65, 0x20, 0x77,
	0x61, 0x69, 0x74, 0x69, 0x6E, 0x67, 0x0A, 0x62, 0x65, 0x68, 0x69, 0x6E, 0x64, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x62, 0x61, 0x72, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x47, 0x6F, 0x20, 0x74, 0x6F, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x72, 0x2C, 0x0A, 0x73, 0x6F, 0x6E, 0x2C, 0x20, 0x43, 0x59,
	0x2D, 0x42, 0x30, 0x32, 0x31, 0x27, 0x73, 0x0A, 0x77, 0x61, 0x69, 0x74, 0x69, 0x6E, 0x67, 0x20,
	0x66, 0x6F, 0x72, 0x20, 0x79, 0x6F, 0x75, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x6F, 0x6E, 0x27,
	0x74, 0x20, 0x73, 0x68, 0x6F, 0x6F, 0x74, 0x2C, 0x49, 0x27, 0x6D, 0x0A, 0x6E, 0x6F, 0x74, 0x20,
	0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x21, 0x0B, 0x48, 0x69, 0x73, 0x20, 0x68, 0x69, 0x64,
	0x65, 0x6F, 0x75, 0x74, 0x27, 0x73, 0x0A, 0x64, 0x6F, 0x77, 0x6E, 0x20, 0x62, 0x65, 0x6C, 0x6F,
	0x77, 0x2E, 0x0B, 0x48, 0x69, 0x73, 0x20, 0x70, 0x61, 0x6C, 0x2C, 0x74, 0x68, 0x65, 0x20, 0x63,
	0x6F, 0x70, 0x0A, 0x68, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6B, 0x65, 0x79, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x49, 0x20, 0x64, 0x6F, 0x6E, 0x27, 0x74, 0x20, 0x6B, 0x6E, 0x6F, 0x77, 0x0A,
	0x61, 0x6E, 0x79, 0x74, 0x68, 0x69, 0x6E, 0x67, 0x20, 0x65, 0x6C, 0x73, 0x65, 0x2E, 0x00, 0xFF,
	0xEB, 0xEC, 0x53, 0x69, 0x72, 0x2E, 0x2E, 0x2E, 0x20, 0x73, 0x6F, 0x6D, 0x65, 0x20, 0x67, 0x75,
	0x79, 0x0B, 0x63, 0x61, 0x6C, 0x6C, 0x65, 0x64, 0x20, 0x4A, 0x61, 0x63, 0x6B, 0x0A, 0x61, 0x72,
	0x72, 0x61, 0x6E, 0x67, 0x65, 0x64, 0x20, 0x74, 0x6F, 0x20, 0x6D, 0x65, 0x65, 0x74, 0x0A, 0x79,
	0x6F, 0x75, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x72, 0x2E, 0x00, 0x49,
	0x27, 0x64, 0x20, 0x6C, 0x69, 0x6B, 0x65, 0x20, 0x61, 0x0A, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x70,
	0x65, 0x72, 0x6D, 0x69, 0x74, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F, 0x2C, 0x20, 0x69, 0x74,
	0x27, 0x73, 0x20, 0x6E, 0x6F, 0x74, 0x0A, 0x68, 0x65, 0x72, 0x65, 0x2E, 0x20, 0x53, 0x65, 0x65,
	0x20, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x0A, 0x43, 0x2E, 0x00, 0x49, 0x27, 0x64, 0x20, 0x6C,
	0x69, 0x6B, 0x65, 0x20, 0x61, 0x0A, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x70, 0x65, 0x72, 0x6D, 0x69,
	0x74, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x47, 0x6F, 0x6F, 0x64, 0x2E, 0x2E, 0x2E, 0x4F, 0x2E, 0x6B,
	0x2E, 0x2C, 0x74, 0x68, 0x65, 0x0A, 0x62, 0x6F, 0x73, 0x73, 0x20, 0x77, 0x69, 0x6C, 0x6C, 0x20,
	0x73, 0x65, 0x65, 0x0A, 0x79, 0x6F, 0x75, 0x20, 0x6E, 0x6F, 0x77, 0x2E, 0x00, 0x49, 0x27, 0x64,
	0x20, 0x6C, 0x69, 0x6B, 0x65, 0x20, 0x61, 0x0A, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x70, 0x65, 0x72,
	0x6D, 0x69, 0x74, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F, 0x2C, 0x20, 0x69, 0x74, 0x27, 0x73,
	0x20, 0x6E, 0x6F, 0x74, 0x0A, 0x68, 0x65, 0x72, 0x65, 0x2E, 0x20, 0x53, 0x65, 0x65, 0x20, 0x57,
	0x69, 0x6E, 0x64, 0x6F, 0x77, 0x0A, 0x42, 0x2E, 0x00, 0x49, 0x27, 0x64, 0x20, 0x6C, 0x69, 0x6B,
	0x65, 0x20, 0x74, 0x6F, 0x0A, 0x73, 0x70, 0x65, 0x61, 0x6B, 0x20, 0x74, 0x6F, 0x20, 0x4A, 0x61,
	0x63, 0x6B, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x68, 0x20, 0x79, 0x65, 0x61, 0x68, 0x3F, 0x20,
	0x4A, 0x61, 0x63, 0x6B, 0x27, 0x73, 0x0A, 0x6E, 0x6F, 0x74, 0x20, 0x68, 0x65, 0x72, 0x65, 0x2E,
	0x0B, 0xFF, 0xE9, 0xEA, 0x49, 0x27, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6E, 0x20, 0x73, 0x65,
	0x6E, 0x74, 0x0A, 0x62, 0x79, 0x20, 0x6D, 0x79, 0x20, 0x66, 0x72, 0x69, 0x65, 0x6E, 0x64, 0x0A,
	0x49, 0x61, 0x6E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x2E, 0x6B, 0x2E, 0x20, 0x4A, 0x61, 0x63,
	0x6B, 0x27, 0x73, 0x0A, 0x77, 0x61, 0x69, 0x74, 0x69, 0x6E, 0x67, 0x20, 0x66, 0x6F, 0x72, 0x20,
	0x79, 0x6F, 0x75, 0x0A, 0x6F, 0x75, 0x74, 0x73, 0x69, 0x64, 0x65, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x42, 0x65, 0x61, 0x74, 0x20, 0x69, 0x74, 0x20, 0x73, 0x6F, 0x6E, 0x2E, 0x0A, 0x59, 0x6F, 0x75,
	0x27, 0x72, 0x65, 0x20, 0x74, 0x6F, 0x6F, 0x20, 0x79, 0x6F, 0x75, 0x6E, 0x67, 0x0A, 0x74, 0x6F,
	0x20, 0x64, 0x72, 0x69, 0x6E, 0x6B, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x61, 0x70, 0x65, 0x72,
	0x73, 0x20, 0x70, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x2E, 0x00, 0x49, 0x27, 0x6D, 0x20, 0x74, 0x68,
	0x65, 0x0A, 0x6D, 0x65, 0x73, 0x73, 0x65, 0x6E, 0x67, 0x65, 0x72, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC,
	0x4F, 0x68, 0x20, 0x79, 0x65, 0x73, 0x21, 0x20, 0x48, 0x65, 0x72, 0x65, 0x2C, 0x0A, 0x74, 0x61,
	0x6B, 0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x70, 0x61, 0x72, 0x63, 0x65, 0x6C, 0x0A, 0x74,
	0x6F, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6C, 0x0A, 0x61, 0x67, 0x65,
	0x6E, 0x63, 0x79, 0x2E, 0x0B, 0x41, 0x6E, 0x64, 0x20, 0x62, 0x65, 0x20, 0x63, 0x61, 0x72, 0x65,
	0x66, 0x75, 0x6C, 0x0A, 0x69, 0x74, 0x27, 0x73, 0x20, 0x76, 0x61, 0x6C, 0x75, 0x61, 0x62, 0x6C,
	0x65, 0x2E, 0x00, 0x54, 0x49, 0x4D, 0x45, 0x20, 0x49, 0x53, 0x20, 0x55, 0x50, 0x00, 0x54, 0x68,
	0x65, 0x72, 0x65, 0x27, 0x73, 0x20, 0x61, 0x20, 0x70, 0x6C, 0x61, 0x63, 0x65, 0x0A, 0x66, 0x6F,
	0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x61, 0x72, 0x64, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x54,
	0x68, 0x61, 0x6E, 0x6B, 0x73, 0x2C, 0x20, 0x43, 0x6F, 0x6E, 0x72, 0x61, 0x64, 0x2E, 0x0A, 0x54,
	0x68, 0x6F, 0x73, 0x65, 0x20, 0x63, 0x6F, 0x70, 0x73, 0x0A, 0x77, 0x6F, 0x75, 0x6C, 0x64, 0x27,
	0x76, 0x65, 0x20, 0x68, 0x61, 0x64, 0x20, 0x6D, 0x79, 0x0A, 0x68, 0x69, 0x64, 0x65, 0x21, 0x0B,
	0x57, 0x65, 0x6C, 0x6C, 0x2C, 0x49, 0x20, 0x73, 0x75, 0x70, 0x70, 0x6F, 0x73, 0x65, 0x0A, 0x79,
	0x6F, 0x75, 0x20, 0x64, 0x6F, 0x6E, 0x27, 0x74, 0x0A, 0x72, 0x65, 0x6D, 0x65, 0x6D, 0x62, 0x65,
	0x72, 0x20, 0x79, 0x6F, 0x75, 0x72, 0x0A, 0x6F, 0x6C, 0x64, 0x20, 0x70, 0x61, 0x6C, 0x20, 0x49,
	0x61, 0x6E, 0x2E, 0x0B, 0x54, 0x61, 0x6B, 0x65, 0x20, 0x61, 0x20, 0x73, 0x65, 0x61, 0x74, 0x2C,
	0x0A, 0x77, 0x65, 0x27, 0x6C, 0x6C, 0x20, 0x66, 0x69, 0x78, 0x20, 0x74, 0x68, 0x61, 0x74, 0x0A,
	0x73, 0x68, 0x6F, 0x72, 0x74, 0x6C, 0x79, 0x2E, 0x00, 0x49, 0x61, 0x6E, 0x2C, 0x77, 0x68, 0x61,
	0x74, 0x20, 0x64, 0x6F, 0x20, 0x79, 0x6F, 0x75, 0x0A, 0x68, 0x61, 0x76, 0x65, 0x20, 0x74, 0x6F,
	0x20, 0x64, 0x6F, 0x20, 0x74, 0x6F, 0x0A, 0x67, 0x65, 0x74, 0x20, 0x74, 0x6F, 0x20, 0x45, 0x41,
	0x52, 0x54, 0x48, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x54, 0x68, 0x65, 0x20, 0x63, 0x6F, 0x73, 0x74,
	0x20, 0x6F, 0x66, 0x20, 0x74, 0x68, 0x65, 0x0A, 0x74, 0x69, 0x63, 0x6B, 0x65, 0x74, 0x20, 0x69,
	0x73, 0x0A, 0x61, 0x73, 0x74, 0x72, 0x6F, 0x6E, 0x6F, 0x6D, 0x69, 0x63, 0x61, 0x6C, 0x2E, 0x0B,
	0x54, 0x68, 0x65, 0x20, 0x6F, 0x6E, 0x6C, 0x79, 0x20, 0x77, 0x61, 0x79, 0x0A, 0x77, 0x6F, 0x75,
	0x6C, 0x64, 0x20, 0x62, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x79, 0x6F, 0x75, 0x0A, 0x74, 0x6F,
	0x20, 0x74, 0x61, 0x6B, 0x65, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x69, 0x6E, 0x0A, 0x44, 0x65,
	0x61, 0x74, 0x68, 0x20, 0x54, 0x6F, 0x77, 0x65, 0x72, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x44, 0x65,
	0x61, 0x74, 0x68, 0x20, 0x54, 0x6F, 0x77, 0x65, 0x72, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x59, 0x65,
	0x73, 0x2C, 0x69, 0x74, 0x27, 0x73, 0x20, 0x61, 0x0A, 0x74, 0x65, 0x6C, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6F, 0x6E, 0x20, 0x67, 0x61, 0x6D, 0x65, 0x2E, 0x0A, 0x54, 0x68, 0x65, 0x20, 0x77, 0x69,
	0x6E, 0x6E, 0x65, 0x72, 0x20, 0x67, 0x65, 0x74, 0x73, 0x0A, 0x61, 0x20, 0x74, 0x69, 0x63, 0x6B,
	0x65, 0x74, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x4F, 0x2E, 0x6B, 0x2E, 0x43, 0x61, 0x6E, 0x20, 0x79,
	0x6F, 0x75, 0x0A, 0x73, 0x75, 0x70, 0x70, 0x6C, 0x79, 0x20, 0x66, 0x61, 0x6C, 0x73, 0x65, 0x0A,
	0x70, 0x61, 0x70, 0x65, 0x72, 0x73, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F, 0x20, 0x70, 0x72,
	0x6F, 0x62, 0x6C, 0x65, 0x6D, 0x2E, 0x0A, 0x47, 0x6F, 0x20, 0x74, 0x6F, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x62, 0x61, 0x72, 0x0A, 0x61, 0x6E, 0x64, 0x20, 0x61, 0x73, 0x6B, 0x20, 0x66, 0x6F, 0x72,
	0x0A, 0x4A, 0x61, 0x63, 0x6B, 0x2E, 0x0B, 0x53, 0x61, 0x79, 0x20, 0x49, 0x20, 0x73, 0x65, 0x6E,
	0x74, 0x20, 0x79, 0x6F, 0x75, 0x2E, 0x0A, 0x4F, 0x68, 0x2C, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x77, 0x61, 0x79, 0x2E, 0x2E, 0x2E, 0x0B, 0x49, 0x20, 0x70, 0x75, 0x74, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x66, 0x6F, 0x72, 0x63, 0x65, 0x0A, 0x66, 0x69, 0x65, 0x6C, 0x64, 0x20, 0x79, 0x6F,
	0x75, 0x20, 0x61, 0x73, 0x6B, 0x65, 0x64, 0x0A, 0x6D, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x69,
	0x6E, 0x20, 0x79, 0x6F, 0x75, 0x72, 0x0A, 0x70, 0x6F, 0x63, 0x6B, 0x65, 0x74, 0x2E, 0x0B, 0xFF,
	0xE9, 0xEA, 0x47, 0x72, 0x65, 0x61, 0x74, 0x2E, 0x54, 0x68, 0x61, 0x6E, 0x6B, 0x0A, 0x79, 0x6F,
	0x75, 0x2C, 0x20, 0x49, 0x61, 0x6E, 0x2E, 0x27, 0x54, 0x69, 0x6C, 0x6C, 0x0A, 0x74, 0x68, 0x65,
	0x20, 0x6E, 0x65, 0x78, 0x74, 0x20, 0x74, 0x69, 0x6D, 0x65, 0x2E, 0x2E, 0x2E, 0x0B, 0xFF, 0xEB,
	0xEC, 0x47, 0x6F, 0x6F, 0x64, 0x20, 0x6C, 0x75, 0x63, 0x6B, 0x2E, 0x49, 0x27, 0x6C, 0x6C, 0x0A,
	0x62, 0x65, 0x20, 0x69, 0x6E, 0x20, 0x74, 0x6F, 0x75, 0x63, 0x68, 0x20, 0x77, 0x68, 0x65, 0x6E,
	0x0A, 0x79, 0x6F, 0x75, 0x20, 0x67, 0x65, 0x74, 0x20, 0x74, 0x6F, 0x0A, 0x45, 0x61, 0x72, 0x74,
	0x68, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x57, 0x65, 0x6C, 0x63, 0x6F, 0x6D, 0x65, 0x20, 0x74, 0x6F,
	0x0A, 0x4E, 0x65, 0x77, 0x20, 0x57, 0x61, 0x73, 0x68, 0x69, 0x6E, 0x67, 0x74, 0x6F, 0x6E, 0x2C,
	0x0A, 0x79, 0x6F, 0x75, 0x6E, 0x67, 0x20, 0x6D, 0x61, 0x6E, 0x2E, 0x0B, 0x48, 0x65, 0x72, 0x65,
	0x27, 0x73, 0x20, 0x61, 0x20, 0x6D, 0x61, 0x70, 0x20, 0x6F, 0x66, 0x0A, 0x74, 0x68, 0x65, 0x20,
	0x63, 0x69, 0x74, 0x79, 0x2C, 0x77, 0x68, 0x69, 0x63, 0x68, 0x0A, 0x79, 0x6F, 0x75, 0x20, 0x6D,
	0x61, 0x79, 0x20, 0x66, 0x69, 0x6E, 0x64, 0x0A, 0x75, 0x73, 0x65, 0x66, 0x75, 0x6C, 0x2E, 0x0B,
	0xFF, 0xE9, 0xEA, 0x54, 0x68, 0x61, 0x6E, 0x6B, 0x20, 0x79, 0x6F, 0x75, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x48, 0x61, 0x76, 0x65, 0x20, 0x61, 0x20, 0x6E, 0x69, 0x63, 0x65, 0x0A, 0x64, 0x61, 0x79,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x59, 0x6F, 0x75, 0x20, 0x6D, 0x75, 0x73, 0x74, 0x20, 0x68, 0x61,
	0x76, 0x65, 0x20, 0x61, 0x0A, 0x70, 0x65, 0x72, 0x6D, 0x69, 0x74, 0x20, 0x69, 0x6E, 0x20, 0x6F,
	0x72, 0x64, 0x65, 0x72, 0x0A, 0x74, 0x6F, 0x20, 0x77, 0x6F, 0x72, 0x6B, 0x2E, 0x0B, 0x59, 0x6F,
	0x75, 0x20, 0x63, 0x61, 0x6E, 0x20, 0x67, 0x65, 0x74, 0x20, 0x6F, 0x6E, 0x65, 0x0A, 0x61, 0x74,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x64, 0x6D, 0x69, 0x6E, 0x0A, 0x43, 0x65, 0x6E, 0x74, 0x65,
	0x72, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x20, 0x64, 0x6F, 0x6E, 0x27, 0x74, 0x20, 0x68, 0x61,
	0x76, 0x65, 0x0A, 0x74, 0x69, 0x6D, 0x65, 0x2E, 0x00, 0x47, 0x6F, 0x6F, 0x64, 0x20, 0x6D, 0x6F,
	0x72, 0x6E, 0x69, 0x6E, 0x67, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x47, 0x6F, 0x6F, 0x64, 0x20, 0x6D,
	0x6F, 0x72, 0x6E, 0x69, 0x6E, 0x67, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x27, 0x76, 0x65, 0x20,
	0x73, 0x65, 0x65, 0x6E, 0x20, 0x74, 0x68, 0x61, 0x74, 0x0A, 0x67, 0x75, 0x79, 0x20, 0x62, 0x65,
	0x66, 0x6F, 0x72, 0x65, 0x20, 0x69, 0x6E, 0x0A, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x72, 0x2E,
	0x00, 0x47, 0x6F, 0x6F, 0x64, 0x20, 0x6D, 0x6F, 0x72, 0x6E, 0x69, 0x6E, 0x67, 0x2E, 0x0B, 0xFF,
	0xEB, 0xEC, 0x47, 0x6F, 0x6F, 0x64, 0x20, 0x6D, 0x6F, 0x72, 0x6E, 0x69, 0x6E, 0x67, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x59, 0x65, 0x73, 0x2C, 0x49, 0x20, 0x6B, 0x6E, 0x6F, 0x77, 0x20, 0x68, 0x69,
	0x6D, 0x2E, 0x0A, 0x48, 0x65, 0x27, 0x73, 0x20, 0x61, 0x20, 0x72, 0x65, 0x67, 0x75, 0x6C, 0x61,
	0x72, 0x2E, 0x00, 0x20, 0x00, 0x20, 0x00, 0x49, 0x27, 0x64, 0x20, 0x6C, 0x69, 0x6B, 0x65, 0x20,
	0x61, 0x0A, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x70, 0x65, 0x72, 0x6D, 0x69, 0x74, 0x2E, 0x0B, 0xFF,
	0xEB, 0xEC, 0x54, 0x68, 0x65, 0x72, 0x65, 0x27, 0x73, 0x20, 0x6E, 0x6F, 0x0A, 0x70, 0x72, 0x6F,
	0x62, 0x6C, 0x65, 0x6D, 0x20, 0x67, 0x65, 0x74, 0x74, 0x69, 0x6E, 0x67, 0x0A, 0x61, 0x20, 0x70,
	0x65, 0x72, 0x6D, 0x69, 0x74, 0x2E, 0x2E, 0x2E, 0x0B, 0x49, 0x20, 0x6E, 0x65, 0x65, 0x64, 0x20,
	0x79, 0x6F, 0x75, 0x72, 0x20, 0x49, 0x44, 0x0A, 0x63, 0x61, 0x72, 0x64, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x48, 0x45, 0x4C, 0x50, 0x2E, 0x2E, 0x2E, 0x48, 0x45, 0x4C, 0x50, 0x2E, 0x2E, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x48, 0x65, 0x6C, 0x70, 0x20, 0x6D, 0x65, 0x20, 0x79, 0x6F, 0x75, 0x6E, 0x67,
	0x0A, 0x6D, 0x61, 0x6E, 0x2E, 0x20, 0x49, 0x27, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6E, 0x0A,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x6B, 0x65, 0x64, 0x20, 0x62, 0x79, 0x0A, 0x6D, 0x75, 0x74, 0x61,
	0x6E, 0x74, 0x73, 0x2E, 0x2E, 0x2E, 0x0B, 0x61, 0x6E, 0x64, 0x20, 0x49, 0x20, 0x63, 0x61, 0x6E,
	0x27, 0x74, 0x0A, 0x77, 0x61, 0x6C, 0x6B, 0x2E, 0x0B, 0x46, 0x69, 0x6E, 0x64, 0x20, 0x6D, 0x79,
	0x0A, 0x74, 0x65, 0x6C, 0x65, 0x70, 0x6F, 0x72, 0x74, 0x65, 0x72, 0x2C, 0x49, 0x0A, 0x6E, 0x65,
	0x65, 0x64, 0x20, 0x75, 0x72, 0x67, 0x65, 0x6E, 0x74, 0x20, 0x6D, 0x65, 0x64, 0x2D, 0x0A, 0x69,
	0x63, 0x61, 0x6C, 0x20, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6E, 0x63, 0x65, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x54, 0x68, 0x61, 0x6E, 0x6B, 0x73, 0x2E, 0x59, 0x6F, 0x75, 0x20, 0x6A, 0x75,
	0x73, 0x74, 0x0A, 0x73, 0x61, 0x76, 0x65, 0x64, 0x20, 0x6D, 0x79, 0x20, 0x6C, 0x69, 0x66, 0x65,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x54, 0x6F, 0x20, 0x67, 0x65, 0x74, 0x20, 0x74, 0x6F, 0x20, 0x4E,
	0x65, 0x77, 0x0A, 0x57, 0x61, 0x73, 0x68, 0x69, 0x6E, 0x67, 0x74, 0x6F, 0x6E, 0x2C, 0x79, 0x6F,
	0x75, 0x0A, 0x68, 0x61, 0x76, 0x65, 0x20, 0x74, 0x6F, 0x20, 0x6A, 0x75, 0x6D, 0x70, 0x0A, 0x69,
	0x6E, 0x74, 0x6F, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x68, 0x6F, 0x6C, 0x65, 0x2C, 0x0B, 0x62,
	0x75, 0x74, 0x20, 0x69, 0x66, 0x20, 0x49, 0x20, 0x77, 0x65, 0x72, 0x65, 0x0A, 0x79, 0x6F, 0x75,
	0x20, 0x49, 0x27, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20, 0x61, 0x6E, 0x0A, 0x41, 0x6E, 0x74, 0x69,
	0x2D, 0x47, 0x20, 0x62, 0x65, 0x6C, 0x74, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x57, 0x68, 0x65, 0x72,
	0x65, 0x20, 0x63, 0x61, 0x6E, 0x20, 0x49, 0x20, 0x66, 0x69, 0x6E, 0x64, 0x0A, 0x6F, 0x6E, 0x65,
	0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F, 0x77, 0x2C, 0x20, 0x49, 0x20, 0x63, 0x61, 0x6E, 0x0A,
	0x73, 0x65, 0x6C, 0x6C, 0x20, 0x79, 0x6F, 0x75, 0x20, 0x6F, 0x6E, 0x65, 0x3A, 0x0A, 0x35, 0x30,
	0x30, 0x20, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x73, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x42, 0x6F,
	0x6E, 0x20, 0x76, 0x6F, 0x79, 0x61, 0x67, 0x65, 0x2C, 0x79, 0x6F, 0x75, 0x6E, 0x67, 0x0A, 0x6D,
	0x61, 0x6E, 0x2E, 0x00, 0x49, 0x20, 0x6E, 0x65, 0x65, 0x64, 0x20, 0x61, 0x20, 0x66, 0x75, 0x6C,
	0x6C, 0x79, 0x0A, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x64, 0x20, 0x6D, 0x61, 0x67, 0x6E, 0x65,
	0x74, 0x69, 0x63, 0x0A, 0x63, 0x61, 0x72, 0x74, 0x72, 0x69, 0x64, 0x67, 0x65, 0x2E, 0x00, 0x49,
	0x27, 0x64, 0x20, 0x6C, 0x69, 0x6B, 0x65, 0x20, 0x61, 0x0A, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x70,
	0x65, 0x72, 0x6D, 0x69, 0x74, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x46, 0x69, 0x72, 0x73, 0x74, 0x20,
	0x66, 0x6C, 0x6F, 0x6F, 0x72, 0x2E, 0x00, 0x41, 0x6E, 0x20, 0x69, 0x6E, 0x6E, 0x65, 0x72, 0x20,
	0x76, 0x6F, 0x69, 0x63, 0x65, 0x0A, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x73,
	0x20, 0x79, 0x6F, 0x75, 0x72, 0x0A, 0x74, 0x68, 0x6F, 0x75, 0x67, 0x68, 0x74, 0x73, 0x2E, 0x0B,
	0xFF, 0xEB, 0xEC, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x6D, 0x65, 0x2C, 0x73, 0x6F, 0x6E, 0x2C,
	0x70, 0x75, 0x74, 0x0A, 0x74, 0x68, 0x65, 0x20, 0x61, 0x74, 0x6F, 0x6D, 0x69, 0x63, 0x0A, 0x63,
	0x68, 0x61, 0x72, 0x67, 0x65, 0x20, 0x68, 0x65, 0x72, 0x65, 0x2E, 0x2E, 0x2E, 0x0B, 0x61, 0x6E,
	0x64, 0x20, 0x66, 0x6C, 0x65, 0x65, 0x20, 0x61, 0x73, 0x0A, 0x73, 0x6F, 0x6F, 0x6E, 0x20, 0x61,
	0x73, 0x20, 0x69, 0x74, 0x0A, 0x72, 0x65, 0x61, 0x63, 0x68, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65,
	0x0A, 0x70, 0x6C, 0x61, 0x6E, 0x65, 0x74, 0x27, 0x73, 0x20, 0x63, 0x6F, 0x72, 0x65, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x4C, 0x65, 0x61, 0x64, 0x20, 0x6F, 0x6E, 0x2C, 0x79, 0x6F, 0x75, 0x6E, 0x67,
	0x0A, 0x6D, 0x61, 0x6E, 0x2E, 0x0B, 0x54, 0x61, 0x6B, 0x65, 0x20, 0x6D, 0x65, 0x20, 0x74, 0x6F,
	0x20, 0x74, 0x68, 0x65, 0x0A, 0x52, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x20, 0x43, 0x65,
	0x6E, 0x74, 0x65, 0x72, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x54, 0x68, 0x61, 0x6E, 0x6B, 0x20, 0x79,
	0x6F, 0x75, 0x20, 0x66, 0x6F, 0x72, 0x0A, 0x79, 0x6F, 0x75, 0x72, 0x20, 0x68, 0x65, 0x6C, 0x70,
	0x2E, 0x2E, 0x2E, 0x0B, 0x49, 0x20, 0x61, 0x72, 0x72, 0x69, 0x76, 0x65, 0x64, 0x20, 0x73, 0x61,
	0x66, 0x65, 0x6C, 0x79, 0x0A, 0x61, 0x6E, 0x64, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x27, 0x73,
	0x20, 0x6E, 0x6F, 0x0A, 0x6C, 0x6F, 0x6E, 0x67, 0x65, 0x72, 0x20, 0x61, 0x6E, 0x79, 0x0A, 0x64,
	0x61, 0x6E, 0x67, 0x65, 0x72, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x57, 0x65, 0x6C, 0x6C, 0x20, 0x74,
	0x68, 0x65, 0x6E, 0x2C, 0x68, 0x61, 0x76, 0x65, 0x0A, 0x79, 0x6F, 0x75, 0x20, 0x62, 0x72, 0x6F,
	0x75, 0x67, 0x68, 0x74, 0x20, 0x6D, 0x65, 0x0A, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x72, 0x63,
	0x65, 0x6C, 0x3F, 0x00, 0x48, 0x6F, 0x77, 0x20, 0x6D, 0x75, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20,
	0x61, 0x0A, 0x74, 0x69, 0x63, 0x6B, 0x65, 0x74, 0x20, 0x74, 0x6F, 0x20, 0x45, 0x61, 0x72, 0x74,
	0x68, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x35, 0x30, 0x2C, 0x30, 0x30, 0x30, 0x20, 0x63, 0x72, 0x65,
	0x64, 0x69, 0x74, 0x73, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x20, 0x73, 0x63, 0x72, 0x61, 0x74,
	0x63, 0x68, 0x20, 0x79, 0x6F, 0x75, 0x72, 0x0A, 0x62, 0x61, 0x63, 0x6B, 0x2C, 0x79, 0x6F, 0x75,
	0x20, 0x73, 0x63, 0x72, 0x61, 0x74, 0x63, 0x68, 0x0A, 0x6D, 0x69, 0x6E, 0x65, 0x3A, 0x0B, 0x31,
	0x35, 0x30, 0x30, 0x20, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x73, 0x20, 0x61, 0x6E, 0x64, 0x0A,
	0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x70, 0x65, 0x72, 0x73, 0x20, 0x61, 0x72, 0x65, 0x0A, 0x79,
	0x6F, 0x75, 0x72, 0x73, 0x2E, 0x00
};

const uint8_t LocaleData::_stringsTableDE[] = {
	0x5A, 0x00, 0x7B, 0x00, 0x9B, 0x00, 0xB0, 0x01, 0x63, 0x02, 0x87, 0x02, 0xD3, 0x02, 0x04, 0x03,
	0x6D, 0x03, 0x86, 0x03, 0xBF, 0x03, 0x0E, 0x04, 0x5E, 0x04, 0xAD, 0x04, 0x30, 0x05, 0x60, 0x05,
	0x73, 0x05, 0xDD, 0x05, 0xEE, 0x05, 0x09, 0x06, 0xC0, 0x06, 0xBB, 0x08, 0x24, 0x09, 0x39, 0x09,
	0x87, 0x09, 0x9F, 0x09, 0xBE, 0x09, 0xEF, 0x09, 0x0E, 0x0A, 0x30, 0x0A, 0x32, 0x0A, 0x34, 0x0A,
	0x9D, 0x0A, 0xB2, 0x0A, 0x42, 0x0B, 0x66, 0x0B, 0x1F, 0x0C, 0x3B, 0x0C, 0x6C, 0x0C, 0x9D, 0x0C,
	0x39, 0x0D, 0x74, 0x0D, 0xC5, 0x0D, 0xED, 0x0D, 0x20, 0x0E, 0x44, 0x49, 0x45, 0x20, 0x53, 0x49,
	0x43, 0x48, 0x45, 0x52, 0x55, 0x4E, 0x47, 0x0A, 0x49, 0x53, 0x54, 0x0A, 0x44, 0x55, 0x52, 0x43,
	0x48, 0x47, 0x45, 0x42, 0x52, 0x41, 0x4E, 0x4E, 0x54, 0x2E, 0x00, 0x44, 0x41, 0x53, 0x20, 0x4D,
	0x5B, 0x53, 0x53, 0x54, 0x45, 0x20, 0x4A, 0x45, 0x54, 0x5A, 0x54, 0x0A, 0x46, 0x55, 0x4E, 0x4B,
	0x54, 0x49, 0x4F, 0x4E, 0x49, 0x45, 0x52, 0x45, 0x4E, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x43,
	0x48, 0x20, 0x42, 0x49, 0x4E, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x2E, 0x0A, 0x53, 0x49, 0x45, 0x20,
	0x57, 0x4F, 0x4C, 0x4C, 0x45, 0x4E, 0x0A, 0x47, 0x45, 0x46, 0x5C, 0x4C, 0x53, 0x43, 0x48, 0x54,
	0x45, 0x0A, 0x50, 0x41, 0x50, 0x49, 0x45, 0x52, 0x45, 0x3F, 0x0B, 0xFF, 0xE9, 0xEA, 0x4A, 0x41,
	0x2C, 0x20, 0x55, 0x4E, 0x44, 0x20, 0x53, 0x4F, 0x0A, 0x53, 0x43, 0x48, 0x4E, 0x45, 0x4C, 0x4C,
	0x20, 0x57, 0x49, 0x45, 0x0A, 0x4D, 0x5D, 0x47, 0x4C, 0x49, 0x43, 0x48, 0x2E, 0x0B, 0xFF, 0xEB,
	0xEC, 0x31, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x53, 0x21, 0x0B, 0xFF,
	0xE9, 0xEA, 0x31, 0x35, 0x30, 0x30, 0x3F, 0x3F, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4A, 0x41, 0x2C,
	0x20, 0x45, 0x53, 0x20, 0x49, 0x53, 0x54, 0x20, 0x45, 0x49, 0x4E, 0x0A, 0x47, 0x52, 0x4F, 0x53,
	0x53, 0x45, 0x53, 0x20, 0x52, 0x49, 0x53, 0x49, 0x4B, 0x4F, 0x0B, 0xFF, 0xE9, 0xEA, 0x41, 0x42,
	0x45, 0x52, 0x20, 0x49, 0x43, 0x48, 0x20, 0x48, 0x41, 0x42, 0x45, 0x0A, 0x4E, 0x49, 0x43, 0x48,
	0x54, 0x20, 0x47, 0x45, 0x4E, 0x55, 0x47, 0x2E, 0x2E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x47, 0x45,
	0x48, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x20, 0x5A, 0x55, 0x4D, 0x0A, 0x41, 0x52, 0x42, 0x45,
	0x49, 0x54, 0x53, 0x41, 0x4D, 0x54, 0x2C, 0x20, 0x44, 0x4F, 0x52, 0x54, 0x0A, 0x46, 0x49, 0x4E,
	0x44, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x0A, 0x41, 0x52, 0x42, 0x45, 0x49, 0x54, 0x2E, 0x0B,
	0x55, 0x4E, 0x44, 0x20, 0x4B, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x0A, 0x5A,
	0x55, 0x52, 0x5B, 0x43, 0x4B, 0x2C, 0x20, 0x57, 0x45, 0x4E, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x0A,
	0x44, 0x41, 0x53, 0x20, 0x47, 0x45, 0x4C, 0x44, 0x20, 0x48, 0x41, 0x42, 0x45, 0x4E, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x49, 0x43, 0x48, 0x20, 0x4B, 0x45, 0x4E, 0x4E, 0x45, 0x0A, 0x43, 0x59, 0x2D,
	0x42, 0x30, 0x32, 0x31, 0x2E, 0x0A, 0x53, 0x45, 0x49, 0x4E, 0x20, 0x46, 0x52, 0x45, 0x55, 0x4E,
	0x44, 0x20, 0x49, 0x53, 0x54, 0x0A, 0x42, 0x45, 0x49, 0x20, 0x44, 0x45, 0x52, 0x20, 0x50, 0x4F,
	0x4C, 0x49, 0x5A, 0x45, 0x49, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x57, 0x4F, 0x20, 0x4B, 0x41, 0x4E,
	0x4E, 0x20, 0x49, 0x43, 0x48, 0x0A, 0x44, 0x45, 0x4E, 0x20, 0x46, 0x49, 0x4E, 0x44, 0x45, 0x4E,
	0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x49, 0x4E, 0x20, 0x44, 0x45, 0x52, 0x20, 0x56, 0x45, 0x52, 0x42,
	0x4F, 0x2D, 0x0A, 0x54, 0x45, 0x4E, 0x45, 0x4E, 0x20, 0x5A, 0x4F, 0x4E, 0x45, 0x2E, 0x20, 0x45,
	0x52, 0x0A, 0x49, 0x53, 0x54, 0x20, 0x44, 0x4F, 0x52, 0x54, 0x0A, 0x41, 0x4E, 0x47, 0x45, 0x53,
	0x54, 0x45, 0x4C, 0x4C, 0x54, 0x2E, 0x0B, 0x41, 0x42, 0x45, 0x52, 0x2C, 0x20, 0x50, 0x41, 0x53,
	0x53, 0x20, 0x41, 0x55, 0x46, 0x21, 0x0A, 0x44, 0x49, 0x45, 0x53, 0x45, 0x20, 0x4C, 0x45, 0x55,
	0x54, 0x45, 0x20, 0x53, 0x49, 0x4E, 0x44, 0x0A, 0x47, 0x45, 0x46, 0x5C, 0x48, 0x52, 0x4C, 0x49,
	0x43, 0x48, 0x00, 0xFF, 0xEB, 0xEC, 0x4D, 0x45, 0x48, 0x52, 0x20, 0x57, 0x45, 0x49, 0x53, 0x53,
	0x20, 0x49, 0x43, 0x48, 0x0A, 0x4E, 0x49, 0x43, 0x48, 0x54, 0x2C, 0x20, 0x4D, 0x45, 0x49, 0x4E,
	0x0A, 0x53, 0x4F, 0x48, 0x4E, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x43, 0x59, 0x2D, 0x42, 0x4F, 0x32,
	0x31, 0x20, 0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x0A, 0x45, 0x49, 0x4E, 0x20, 0x47, 0x45, 0x53,
	0x43, 0x48, 0x5C, 0x46, 0x54, 0x0A, 0x4D, 0x49, 0x54, 0x20, 0x44, 0x49, 0x52, 0x20, 0x4D, 0x41,
	0x43, 0x48, 0x45, 0x4E, 0x2E, 0x0B, 0x45, 0x52, 0x20, 0x57, 0x41, 0x52, 0x54, 0x45, 0x54, 0x20,
	0x48, 0x49, 0x4E, 0x54, 0x45, 0x52, 0x0A, 0x44, 0x45, 0x52, 0x20, 0x4B, 0x4E, 0x45, 0x49, 0x50,
	0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x47, 0x45, 0x48, 0x20, 0x5A, 0x55, 0x52, 0x20, 0x4B, 0x4E,
	0x45, 0x49, 0x50, 0x45, 0x2C, 0x0A, 0x43, 0x59, 0x2D, 0x42, 0x4F, 0x32, 0x31, 0x20, 0x57, 0x41,
	0x52, 0x54, 0x45, 0x54, 0x0A, 0x44, 0x4F, 0x52, 0x54, 0x20, 0x41, 0x55, 0x46, 0x20, 0x44, 0x49,
	0x43, 0x48, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4E, 0x49, 0x43, 0x48, 0x54, 0x20, 0x53, 0x43, 0x48,
	0x49, 0x45, 0x53, 0x53, 0x45, 0x4E, 0x2C, 0x0A, 0x49, 0x43, 0x48, 0x20, 0x42, 0x49, 0x4E, 0x20,
	0x4E, 0x49, 0x43, 0x48, 0x54, 0x0A, 0x43, 0x59, 0x2D, 0x42, 0x4F, 0x32, 0x31, 0x21, 0x0B, 0x53,
	0x45, 0x49, 0x4E, 0x20, 0x56, 0x45, 0x52, 0x53, 0x54, 0x45, 0x43, 0x4B, 0x0A, 0x49, 0x53, 0x54,
	0x20, 0x47, 0x41, 0x4E, 0x5A, 0x20, 0x55, 0x4E, 0x54, 0x45, 0x4E, 0x2E, 0x0B, 0x44, 0x45, 0x52,
	0x20, 0x50, 0x4F, 0x4C, 0x49, 0x5A, 0x49, 0x53, 0x54, 0x20, 0x48, 0x41, 0x54, 0x0A, 0x44, 0x45,
	0x4E, 0x20, 0x53, 0x43, 0x48, 0x4C, 0x5B, 0x53, 0x53, 0x45, 0x4C, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x4D, 0x45, 0x48, 0x52, 0x20, 0x57, 0x45, 0x49, 0x53, 0x53, 0x0A, 0x49, 0x43, 0x48, 0x20, 0x4E,
	0x49, 0x43, 0x48, 0x54, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x53, 0x49, 0x52, 0x2E, 0x2E, 0x2E, 0x20,
	0x4A, 0x41, 0x43, 0x4B, 0x20, 0x48, 0x41, 0x54, 0x0A, 0x45, 0x49, 0x4E, 0x20, 0x54, 0x52, 0x45,
	0x46, 0x46, 0x45, 0x4E, 0x0A, 0x42, 0x45, 0x49, 0x20, 0x44, 0x45, 0x52, 0x20, 0x4B, 0x4E, 0x45,
	0x49, 0x50, 0x45, 0x0A, 0x41, 0x52, 0x52, 0x41, 0x4E, 0x47, 0x49, 0x45, 0x52, 0x54, 0x00, 0x49,
	0x43, 0x48, 0x20, 0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x20, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x41,
	0x52, 0x42, 0x45, 0x49, 0x54, 0x53, 0x45, 0x52, 0x4C, 0x41, 0x55, 0x42, 0x4E, 0x49, 0x53, 0x0B,
	0xFF, 0xEB, 0xEC, 0x4E, 0x45, 0x49, 0x4E, 0x2C, 0x20, 0x4E, 0x49, 0x43, 0x48, 0x54, 0x0A, 0x48,
	0x49, 0x45, 0x52, 0x2E, 0x20, 0x47, 0x45, 0x48, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x0A, 0x5A,
	0x55, 0x20, 0x53, 0x43, 0x48, 0x41, 0x4C, 0x54, 0x45, 0x52, 0x20, 0x43, 0x2E, 0x00, 0x49, 0x43,
	0x48, 0x20, 0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x20, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x41, 0x52,
	0x42, 0x45, 0x49, 0x54, 0x53, 0x45, 0x52, 0x4C, 0x41, 0x55, 0x42, 0x4E, 0x49, 0x53, 0x0B, 0xFF,
	0xEB, 0xEC, 0x47, 0x55, 0x54, 0x2E, 0x2E, 0x2E, 0x20, 0x4F, 0x2E, 0x4B, 0x2E, 0x2C, 0x20, 0x44,
	0x45, 0x52, 0x0A, 0x43, 0x48, 0x45, 0x46, 0x20, 0x57, 0x49, 0x4C, 0x4C, 0x20, 0x53, 0x49, 0x45,
	0x0A, 0x4A, 0x45, 0x54, 0x5A, 0x54, 0x20, 0x53, 0x45, 0x48, 0x45, 0x4E, 0x2E, 0x00, 0x49, 0x43,
	0x48, 0x20, 0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x20, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x41, 0x52,
	0x42, 0x45, 0x49, 0x54, 0x53, 0x45, 0x52, 0x4C, 0x41, 0x55, 0x42, 0x4E, 0x49, 0x53, 0x0B, 0xFF,
	0xEB, 0xEC, 0x4E, 0x45, 0x49, 0x4E, 0x2C, 0x20, 0x4E, 0x49, 0x43, 0x48, 0x54, 0x0A, 0x48, 0x49,
	0x45, 0x52, 0x2E, 0x20, 0x47, 0x45, 0x48, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x0A, 0x5A, 0x55,
	0x20, 0x53, 0x43, 0x48, 0x41, 0x4C, 0x54, 0x45, 0x52, 0x20, 0x42, 0x2E, 0x00, 0x49, 0x43, 0x48,
	0x20, 0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x0A, 0x4A, 0x41, 0x43, 0x4B, 0x20, 0x53, 0x50, 0x52,
	0x45, 0x43, 0x48, 0x45, 0x4E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x43, 0x48, 0x20, 0x4A, 0x41,
	0x3F, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x0A, 0x49, 0x53, 0x54, 0x20, 0x4E, 0x49, 0x43, 0x48, 0x54,
	0x20, 0x44, 0x41, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x49, 0x43, 0x48, 0x20, 0x4B, 0x4F, 0x4D, 0x4D,
	0x45, 0x20, 0x56, 0x4F, 0x4E, 0x0A, 0x4D, 0x45, 0x49, 0x4E, 0x45, 0x4D, 0x20, 0x46, 0x52, 0x45,
	0x55, 0x4E, 0x44, 0x0A, 0x49, 0x41, 0x4E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x2E, 0x4B, 0x2E,
	0x20, 0x4A, 0x41, 0x43, 0x4B, 0x20, 0x57, 0x41, 0x52, 0x54, 0x45, 0x54, 0x0A, 0x44, 0x52, 0x41,
	0x55, 0x53, 0x53, 0x45, 0x4E, 0x20, 0x41, 0x55, 0x46, 0x0A, 0x44, 0x49, 0x43, 0x48, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x4E, 0x45, 0x45, 0x2C, 0x20, 0x4D, 0x45, 0x49, 0x4E, 0x20, 0x53, 0x4F, 0x48,
	0x4E, 0x2E, 0x0A, 0x44, 0x55, 0x20, 0x42, 0x49, 0x53, 0x54, 0x20, 0x5A, 0x55, 0x20, 0x4A, 0x55,
	0x4E, 0x47, 0x0A, 0x5A, 0x55, 0x4D, 0x20, 0x54, 0x52, 0x49, 0x4E, 0x4B, 0x45, 0x4E, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x50, 0x41, 0x50, 0x49, 0x45, 0x52, 0x45, 0x2C, 0x20, 0x42, 0x49, 0x54, 0x54,
	0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x43, 0x48, 0x20, 0x42, 0x49, 0x4E, 0x20, 0x44, 0x45,
	0x52, 0x0A, 0x42, 0x4F, 0x54, 0x45, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x48, 0x20, 0x4A, 0x41,
	0x21, 0x0A, 0x44, 0x49, 0x45, 0x53, 0x45, 0x53, 0x20, 0x50, 0x41, 0x4B, 0x45, 0x54, 0x0A, 0x4D,
	0x55, 0x53, 0x53, 0x20, 0x5A, 0x55, 0x4D, 0x0A, 0x52, 0x45, 0x49, 0x53, 0x45, 0x42, 0x5B, 0x52,
	0x4F, 0x0B, 0x53, 0x45, 0x49, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x0A, 0x56, 0x4F, 0x52, 0x53,
	0x49, 0x43, 0x48, 0x54, 0x49, 0x47, 0x2C, 0x0A, 0x45, 0x53, 0x20, 0x49, 0x53, 0x54, 0x20, 0x53,
	0x45, 0x48, 0x52, 0x0A, 0x57, 0x45, 0x52, 0x54, 0x56, 0x4F, 0x4C, 0x4C, 0x00, 0x5A, 0x45, 0x49,
	0x54, 0x20, 0x41, 0x42, 0x47, 0x45, 0x4C, 0x41, 0x55, 0x46, 0x45, 0x4E, 0x2E, 0x00, 0x44, 0x49,
	0x45, 0x20, 0x4B, 0x41, 0x52, 0x54, 0x45, 0x20, 0x48, 0x41, 0x54, 0x0A, 0x45, 0x49, 0x4E, 0x45,
	0x4E, 0x20, 0x50, 0x4C, 0x41, 0x54, 0x5A, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x41, 0x4E, 0x4B,
	0x45, 0x2C, 0x20, 0x43, 0x4F, 0x4E, 0x52, 0x41, 0x44, 0x2E, 0x0A, 0x44, 0x49, 0x45, 0x20, 0x50,
	0x4F, 0x4C, 0x49, 0x5A, 0x49, 0x53, 0x54, 0x45, 0x4E, 0x0A, 0x48, 0x5C, 0x54, 0x54, 0x45, 0x4E,
	0x20, 0x4D, 0x45, 0x49, 0x4E, 0x20, 0x56, 0x45, 0x52, 0x2D, 0x0A, 0x53, 0x54, 0x45, 0x43, 0x4B,
	0x20, 0x47, 0x45, 0x46, 0x55, 0x4E, 0x44, 0x45, 0x4E, 0x2E, 0x0B, 0x44, 0x55, 0x20, 0x45, 0x52,
	0x49, 0x4E, 0x4E, 0x45, 0x52, 0x53, 0x54, 0x0A, 0x44, 0x49, 0x43, 0x48, 0x20, 0x57, 0x4F, 0x48,
	0x4C, 0x20, 0x4E, 0x49, 0x43, 0x48, 0x54, 0x0A, 0x41, 0x4E, 0x20, 0x44, 0x45, 0x49, 0x4E, 0x45,
	0x4E, 0x20, 0x41, 0x4C, 0x54, 0x45, 0x4E, 0x0A, 0x4B, 0x55, 0x4D, 0x50, 0x45, 0x4C, 0x20, 0x49,
	0x41, 0x4E, 0x2E, 0x0B, 0x53, 0x45, 0x54, 0x5A, 0x20, 0x44, 0x49, 0x43, 0x48, 0x2C, 0x20, 0x57,
	0x49, 0x52, 0x0A, 0x42, 0x52, 0x49, 0x4E, 0x47, 0x45, 0x4E, 0x20, 0x44, 0x45, 0x49, 0x4E, 0x20,
	0x47, 0x45, 0x2D, 0x0A, 0x44, 0x5C, 0x43, 0x48, 0x54, 0x4E, 0x49, 0x53, 0x20, 0x57, 0x49, 0x45,
	0x44, 0x45, 0x52, 0x0A, 0x49, 0x4E, 0x20, 0x4F, 0x52, 0x44, 0x4E, 0x55, 0x4E, 0x47, 0x2E, 0x00,
	0x49, 0x41, 0x4E, 0x2C, 0x20, 0x57, 0x41, 0x53, 0x20, 0x4D, 0x55, 0x53, 0x53, 0x0A, 0x49, 0x43,
	0x48, 0x20, 0x4D, 0x41, 0x43, 0x48, 0x45, 0x4E, 0x2C, 0x20, 0x55, 0x4D, 0x0A, 0x5A, 0x55, 0x52,
	0x20, 0x45, 0x52, 0x44, 0x45, 0x20, 0x5A, 0x55, 0x0A, 0x4B, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x3F,
	0x0B, 0x44, 0x45, 0x52, 0x20, 0x50, 0x52, 0x45, 0x49, 0x53, 0x20, 0x46, 0x5B, 0x52, 0x0A, 0x44,
	0x41, 0x53, 0x20, 0x54, 0x49, 0x43, 0x4B, 0x45, 0x54, 0x20, 0x49, 0x53, 0x54, 0x0A, 0x41, 0x53,
	0x54, 0x52, 0x4F, 0x4E, 0x4F, 0x4D, 0x49, 0x53, 0x43, 0x48, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x44,
	0x45, 0x52, 0x20, 0x45, 0x49, 0x4E, 0x5A, 0x49, 0x47, 0x45, 0x20, 0x57, 0x45, 0x47, 0x0A, 0x57,
	0x5C, 0x52, 0x45, 0x20, 0x44, 0x49, 0x45, 0x0A, 0x54, 0x45, 0x49, 0x4C, 0x4E, 0x41, 0x48, 0x4D,
	0x45, 0x0A, 0x41, 0x4D, 0x20, 0x54, 0x4F, 0x44, 0x45, 0x53, 0x54, 0x55, 0x52, 0x4D, 0x2E, 0x0B,
	0xFF, 0xE9, 0xEA, 0x54, 0x4F, 0x44, 0x45, 0x53, 0x54, 0x55, 0x52, 0x4D, 0x3F, 0x0B, 0xFF, 0xEB,
	0xEC, 0x44, 0x41, 0x53, 0x20, 0x49, 0x53, 0x54, 0x20, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x46, 0x45,
	0x52, 0x4E, 0x53, 0x45, 0x48, 0x53, 0x48, 0x4F, 0x57, 0x2E, 0x0A, 0x44, 0x45, 0x52, 0x20, 0x47,
	0x45, 0x57, 0x49, 0x4E, 0x4E, 0x45, 0x52, 0x20, 0x42, 0x45, 0x2D, 0x0A, 0x4B, 0x4F, 0x4D, 0x4D,
	0x54, 0x20, 0x45, 0x49, 0x4E, 0x20, 0x54, 0x49, 0x43, 0x4B, 0x45, 0x54, 0x0B, 0xFF, 0xE9, 0xEA,
	0x4B, 0x41, 0x4E, 0x4E, 0x53, 0x54, 0x20, 0x44, 0x55, 0x20, 0x4D, 0x49, 0x52, 0x0A, 0x46, 0x41,
	0x4C, 0x53, 0x43, 0x48, 0x45, 0x20, 0x50, 0x41, 0x50, 0x49, 0x45, 0x52, 0x45, 0x0A, 0x42, 0x45,
	0x53, 0x4F, 0x52, 0x47, 0x45, 0x4E, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4B, 0x45, 0x49, 0x4E, 0x20,
	0x50, 0x52, 0x4F, 0x42, 0x4C, 0x45, 0x4D, 0x2E, 0x0A, 0x47, 0x45, 0x48, 0x20, 0x5A, 0x55, 0x52,
	0x20, 0x4B, 0x4E, 0x45, 0x49, 0x50, 0x45, 0x2C, 0x0A, 0x55, 0x4E, 0x44, 0x20, 0x46, 0x52, 0x41,
	0x47, 0x0A, 0x4E, 0x41, 0x43, 0x48, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x2E, 0x0B, 0x53, 0x41, 0x47,
	0x2C, 0x20, 0x44, 0x41, 0x53, 0x53, 0x20, 0x44, 0x55, 0x20, 0x56, 0x4F, 0x4E, 0x0A, 0x4D, 0x49,
	0x52, 0x20, 0x4B, 0x4F, 0x4D, 0x4D, 0x53, 0x54, 0x2E, 0x0A, 0x41, 0x43, 0x48, 0x2E, 0x2E, 0x2E,
	0x0B, 0x2E, 0x2E, 0x49, 0x43, 0x48, 0x20, 0x48, 0x41, 0x42, 0x45, 0x20, 0x5B, 0x42, 0x52, 0x49,
	0x2D, 0x0A, 0x47, 0x45, 0x4E, 0x53, 0x20, 0x45, 0x49, 0x4E, 0x20, 0x53, 0x43, 0x48, 0x55, 0x54,
	0x5A, 0x2D, 0x0A, 0x46, 0x45, 0x4C, 0x44, 0x2C, 0x20, 0x49, 0x4E, 0x20, 0x44, 0x45, 0x49, 0x4E,
	0x45, 0x0A, 0x54, 0x41, 0x53, 0x43, 0x48, 0x45, 0x20, 0x47, 0x45, 0x53, 0x54, 0x45, 0x43, 0x4B,
	0x54, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x47, 0x52, 0x4F, 0x53, 0x53, 0x41, 0x52, 0x54, 0x49, 0x47,
	0x2E, 0x0A, 0x44, 0x41, 0x4E, 0x4B, 0x45, 0x2C, 0x20, 0x49, 0x41, 0x4E, 0x2E, 0x20, 0x42, 0x49,
	0x53, 0x0A, 0x44, 0x45, 0x4D, 0x4E, 0x5C, 0x43, 0x48, 0x53, 0x54, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC,
	0x49, 0x43, 0x48, 0x20, 0x4D, 0x45, 0x4C, 0x44, 0x45, 0x20, 0x4D, 0x49, 0x43, 0x48, 0x2C, 0x0A,
	0x57, 0x45, 0x4E, 0x4E, 0x20, 0x44, 0x55, 0x20, 0x41, 0x55, 0x46, 0x0A, 0x44, 0x45, 0x52, 0x20,
	0x45, 0x52, 0x44, 0x45, 0x20, 0x42, 0x49, 0x53, 0x54, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x57, 0x49,
	0x4C, 0x4C, 0x4B, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x20, 0x49, 0x4E, 0x0A, 0x4E, 0x45, 0x57, 0x20,
	0x57, 0x41, 0x53, 0x48, 0x49, 0x4E, 0x47, 0x54, 0x4F, 0x4E, 0x2C, 0x0A, 0x4A, 0x55, 0x4E, 0x47,
	0x45, 0x52, 0x20, 0x4D, 0x41, 0x4E, 0x4E, 0x2E, 0x0B, 0x48, 0x49, 0x45, 0x52, 0x20, 0x49, 0x53,
	0x54, 0x20, 0x45, 0x49, 0x4E, 0x0A, 0x53, 0x54, 0x41, 0x44, 0x54, 0x50, 0x4C, 0x41, 0x4E, 0x2C,
	0x0A, 0x53, 0x49, 0x45, 0x20, 0x57, 0x45, 0x52, 0x44, 0x45, 0x4E, 0x20, 0x49, 0x48, 0x4E, 0x0A,
	0x42, 0x52, 0x41, 0x55, 0x43, 0x48, 0x45, 0x4E, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x44, 0x41, 0x4E,
	0x4B, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x53, 0x43, 0x48, 0x5D, 0x4E, 0x45, 0x4E, 0x20, 0x54,
	0x41, 0x47, 0x0A, 0x4E, 0x4F, 0x43, 0x48, 0x21, 0x00, 0xFF, 0xEB, 0xEC, 0x53, 0x49, 0x45, 0x20,
	0x42, 0x52, 0x41, 0x55, 0x43, 0x48, 0x45, 0x4E, 0x0A, 0x45, 0x49, 0x4E, 0x45, 0x20, 0x41, 0x52,
	0x42, 0x45, 0x49, 0x54, 0x53, 0x2D, 0x0A, 0x45, 0x52, 0x4C, 0x41, 0x55, 0x42, 0x4E, 0x49, 0x53,
	0x2E, 0x0B, 0x53, 0x49, 0x45, 0x20, 0x42, 0x45, 0x4B, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x0A, 0x45,
	0x49, 0x4E, 0x45, 0x20, 0x49, 0x4E, 0x20, 0x44, 0x45, 0x52, 0x0A, 0x56, 0x45, 0x52, 0x57, 0x41,
	0x4C, 0x54, 0x55, 0x4E, 0x47, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x43, 0x48, 0x20, 0x48, 0x41,
	0x42, 0x45, 0x20, 0x4B, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x5A, 0x45, 0x49, 0x54, 0x2E, 0x00, 0x47,
	0x55, 0x54, 0x45, 0x4E, 0x20, 0x4D, 0x4F, 0x52, 0x47, 0x45, 0x4E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC,
	0x47, 0x55, 0x54, 0x45, 0x4E, 0x20, 0x4D, 0x4F, 0x52, 0x47, 0x45, 0x4E, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x49, 0x43, 0x48, 0x20, 0x53, 0x41, 0x48, 0x20, 0x44, 0x49, 0x45, 0x53, 0x45, 0x4E, 0x0A,
	0x54, 0x59, 0x50, 0x45, 0x4E, 0x20, 0x53, 0x43, 0x48, 0x4F, 0x4E, 0x20, 0x4D, 0x41, 0x4C, 0x0A,
	0x49, 0x4E, 0x20, 0x44, 0x45, 0x52, 0x20, 0x4B, 0x4E, 0x45, 0x49, 0x50, 0x45, 0x2E, 0x00, 0x47,
	0x55, 0x54, 0x45, 0x4E, 0x20, 0x4D, 0x4F, 0x52, 0x47, 0x45, 0x4E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC,
	0x47, 0x55, 0x54, 0x45, 0x4E, 0x20, 0x4D, 0x4F, 0x52, 0x47, 0x45, 0x4E, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x49, 0x43, 0x48, 0x20, 0x4B, 0x45, 0x4E, 0x4E, 0x45, 0x20, 0x49, 0x48, 0x4E, 0x2E, 0x0A,
	0x49, 0x53, 0x54, 0x20, 0x53, 0x54, 0x41, 0x4D, 0x4D, 0x4B, 0x55, 0x4E, 0x44, 0x45, 0x2E, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x49, 0x43, 0x48, 0x20, 0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x20, 0x45,
	0x49, 0x4E, 0x45, 0x0A, 0x41, 0x52, 0x42, 0x45, 0x49, 0x54, 0x53, 0x45, 0x52, 0x4C, 0x41, 0x55,
	0x42, 0x4E, 0x49, 0x53, 0x0B, 0xFF, 0xEB, 0xEC, 0x4B, 0x45, 0x49, 0x4E, 0x20, 0x50, 0x52, 0x4F,
	0x42, 0x4C, 0x45, 0x4D, 0x2C, 0x0A, 0x45, 0x49, 0x4E, 0x45, 0x20, 0x45, 0x52, 0x4C, 0x41, 0x55,
	0x42, 0x4E, 0x49, 0x53, 0x0A, 0x5A, 0x55, 0x20, 0x42, 0x45, 0x4B, 0x4F, 0x4D, 0x4D, 0x45, 0x4E,
	0x2E, 0x2E, 0x2E, 0x0B, 0x49, 0x43, 0x48, 0x20, 0x42, 0x45, 0x4E, 0x5D, 0x54, 0x49, 0x47, 0x45,
	0x0A, 0x49, 0x48, 0x52, 0x45, 0x20, 0x4B, 0x41, 0x52, 0x54, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x48, 0x49, 0x4C, 0x46, 0x45, 0x2E, 0x2E, 0x2E, 0x0A, 0x48, 0x49, 0x4C, 0x46, 0x45, 0x2E, 0x2E,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x48, 0x45, 0x4C, 0x46, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x20,
	0x4D, 0x49, 0x52, 0x2E, 0x0A, 0x49, 0x43, 0x48, 0x20, 0x57, 0x55, 0x52, 0x44, 0x45, 0x20, 0x56,
	0x4F, 0x4E, 0x0A, 0x4D, 0x55, 0x54, 0x41, 0x4E, 0x54, 0x45, 0x4E, 0x0A, 0x41, 0x4E, 0x47, 0x45,
	0x47, 0x52, 0x49, 0x46, 0x46, 0x45, 0x4E, 0x2E, 0x2E, 0x2E, 0x0B, 0x55, 0x4E, 0x44, 0x20, 0x49,
	0x43, 0x48, 0x20, 0x4B, 0x41, 0x4E, 0x4E, 0x0A, 0x4E, 0x49, 0x43, 0x48, 0x54, 0x20, 0x4C, 0x41,
	0x55, 0x46, 0x45, 0x4E, 0x2E, 0x0B, 0x48, 0x4F, 0x4C, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x20,
	0x4D, 0x45, 0x49, 0x4E, 0x45, 0x4E, 0x0A, 0x54, 0x45, 0x4C, 0x45, 0x50, 0x4F, 0x52, 0x54, 0x45,
	0x52, 0x2C, 0x20, 0x49, 0x43, 0x48, 0x0A, 0x42, 0x52, 0x41, 0x55, 0x43, 0x48, 0x45, 0x20, 0x5C,
	0x52, 0x5A, 0x54, 0x2D, 0x0A, 0x4C, 0x49, 0x43, 0x48, 0x45, 0x20, 0x48, 0x49, 0x4C, 0x46, 0x45,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x41, 0x4E, 0x4B, 0x45, 0x2E, 0x20, 0x53, 0x49, 0x45, 0x20,
	0x52, 0x45, 0x54, 0x2D, 0x0A, 0x54, 0x45, 0x54, 0x45, 0x4E, 0x20, 0x4D, 0x45, 0x49, 0x4E, 0x20,
	0x4C, 0x45, 0x42, 0x45, 0x4E, 0x00, 0xFF, 0xEB, 0xEC, 0x53, 0x50, 0x52, 0x49, 0x4E, 0x47, 0x45,
	0x4E, 0x20, 0x53, 0x49, 0x45, 0x20, 0x49, 0x4E, 0x0A, 0x44, 0x49, 0x45, 0x53, 0x45, 0x53, 0x20,
	0x4C, 0x4F, 0x43, 0x48, 0x2C, 0x0B, 0x55, 0x4D, 0x20, 0x4E, 0x41, 0x43, 0x48, 0x20, 0x4E, 0x45,
	0x57, 0x0A, 0x57, 0x41, 0x53, 0x48, 0x49, 0x4E, 0x47, 0x54, 0x4F, 0x4E, 0x0A, 0x5A, 0x55, 0x20,
	0x4B, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x2E, 0x0B, 0x41, 0x42, 0x45, 0x52, 0x2C, 0x20, 0x49, 0x43,
	0x48, 0x20, 0x57, 0x5B, 0x52, 0x44, 0x45, 0x0A, 0x45, 0x49, 0x4E, 0x45, 0x4E, 0x20, 0x41, 0x4E,
	0x54, 0x49, 0x2D, 0x47, 0x2D, 0x0A, 0x47, 0x5B, 0x52, 0x54, 0x45, 0x4C, 0x20, 0x42, 0x45, 0x4E,
	0x55, 0x54, 0x5A, 0x45, 0x4E, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x57, 0x4F, 0x20, 0x4B, 0x41, 0x4E,
	0x4E, 0x20, 0x49, 0x43, 0x48, 0x0A, 0x45, 0x49, 0x4E, 0x45, 0x4E, 0x20, 0x42, 0x45, 0x4B, 0x4F,
	0x4D, 0x4D, 0x45, 0x4E, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x55, 0x4E, 0x2C, 0x20, 0x49, 0x43,
	0x48, 0x0A, 0x56, 0x45, 0x52, 0x4B, 0x41, 0x55, 0x46, 0x45, 0x20, 0x45, 0x49, 0x4E, 0x45, 0x4E,
	0x3A, 0x0A, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x53, 0x2E, 0x00, 0xFF,
	0xEB, 0xEC, 0x47, 0x55, 0x54, 0x45, 0x20, 0x52, 0x45, 0x49, 0x53, 0x45, 0x2C, 0x0A, 0x4A, 0x55,
	0x4E, 0x47, 0x45, 0x52, 0x20, 0x4D, 0x41, 0x4E, 0x4E, 0x2E, 0x00, 0x49, 0x43, 0x48, 0x20, 0x42,
	0x52, 0x41, 0x55, 0x43, 0x48, 0x45, 0x20, 0x45, 0x49, 0x4E, 0x0A, 0x41, 0x55, 0x46, 0x47, 0x45,
	0x4C, 0x41, 0x44, 0x45, 0x4E, 0x45, 0x53, 0x20, 0x4D, 0x41, 0x2D, 0x0A, 0x47, 0x4E, 0x45, 0x54,
	0x2D, 0x43, 0x41, 0x52, 0x54, 0x52, 0x49, 0x44, 0x47, 0x45, 0x2E, 0x00, 0x49, 0x43, 0x48, 0x20,
	0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x20, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x41, 0x52, 0x42, 0x45,
	0x49, 0x54, 0x53, 0x45, 0x52, 0x4C, 0x41, 0x55, 0x42, 0x4E, 0x49, 0x53, 0x0B, 0xFF, 0xEB, 0xEC,
	0x45, 0x52, 0x53, 0x54, 0x45, 0x20, 0x45, 0x54, 0x41, 0x47, 0x45, 0x2E, 0x00, 0x45, 0x49, 0x4E,
	0x45, 0x20, 0x49, 0x4E, 0x4E, 0x45, 0x52, 0x45, 0x0A, 0x53, 0x54, 0x49, 0x4D, 0x4D, 0x45, 0x0A,
	0x55, 0x4E, 0x54, 0x45, 0x52, 0x42, 0x52, 0x49, 0x43, 0x48, 0x54, 0x0A, 0x44, 0x45, 0x49, 0x4E,
	0x45, 0x20, 0x47, 0x45, 0x44, 0x41, 0x4E, 0x4B, 0x45, 0x4E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x56,
	0x45, 0x52, 0x54, 0x52, 0x41, 0x55, 0x20, 0x4D, 0x49, 0x52, 0x2C, 0x0A, 0x42, 0x52, 0x49, 0x4E,
	0x47, 0x20, 0x44, 0x49, 0x45, 0x20, 0x41, 0x54, 0x4F, 0x4D, 0x2D, 0x0A, 0x4C, 0x41, 0x44, 0x55,
	0x4E, 0x47, 0x20, 0x48, 0x49, 0x45, 0x52, 0x20, 0x41, 0x4E, 0x2E, 0x2E, 0x0B, 0x55, 0x4E, 0x44,
	0x20, 0x46, 0x4C, 0x49, 0x45, 0x48, 0x45, 0x2C, 0x20, 0x42, 0x45, 0x2D, 0x0A, 0x56, 0x4F, 0x52,
	0x20, 0x53, 0x49, 0x45, 0x20, 0x44, 0x41, 0x53, 0x20, 0x48, 0x45, 0x52, 0x5A, 0x0A, 0x44, 0x45,
	0x53, 0x20, 0x50, 0x4C, 0x41, 0x4E, 0x45, 0x54, 0x45, 0x4E, 0x0A, 0x45, 0x52, 0x52, 0x45, 0x49,
	0x43, 0x48, 0x54, 0x20, 0x48, 0x41, 0x54, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x5A, 0x55, 0x4D, 0x20,
	0x46, 0x4F, 0x52, 0x53, 0x43, 0x48, 0x55, 0x4E, 0x47, 0x53, 0x2D, 0x0A, 0x5A, 0x45, 0x4E, 0x54,
	0x52, 0x55, 0x4D, 0x2C, 0x20, 0x42, 0x49, 0x54, 0x54, 0x45, 0x2E, 0x0B, 0x4E, 0x41, 0x43, 0x48,
	0x20, 0x49, 0x48, 0x4E, 0x45, 0x4E, 0x2C, 0x0A, 0x4A, 0x55, 0x4E, 0x47, 0x45, 0x52, 0x20, 0x4D,
	0x41, 0x4E, 0x4E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x41, 0x4E, 0x4B, 0x45, 0x20, 0x46, 0x5B, 0x52,
	0x0A, 0x49, 0x48, 0x52, 0x45, 0x20, 0x48, 0x49, 0x4C, 0x46, 0x45, 0x0B, 0x49, 0x43, 0x48, 0x20,
	0x42, 0x49, 0x4E, 0x20, 0x53, 0x49, 0x43, 0x48, 0x45, 0x52, 0x0A, 0x41, 0x4E, 0x47, 0x45, 0x4B,
	0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x2E, 0x20, 0x45, 0x53, 0x0A, 0x42, 0x45, 0x53, 0x54, 0x45, 0x48,
	0x54, 0x20, 0x4B, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x47, 0x45, 0x46, 0x41, 0x48, 0x52, 0x20, 0x4D,
	0x45, 0x48, 0x52, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x48, 0x41, 0x42, 0x45, 0x4E, 0x20, 0x53, 0x49,
	0x45, 0x20, 0x4D, 0x49, 0x52, 0x0A, 0x44, 0x41, 0x53, 0x20, 0x50, 0x41, 0x4B, 0x45, 0x54, 0x0A,
	0x4D, 0x49, 0x54, 0x47, 0x45, 0x42, 0x52, 0x41, 0x43, 0x48, 0x54, 0x3F, 0x00, 0x57, 0x41, 0x53,
	0x20, 0x4B, 0x4F, 0x53, 0x54, 0x45, 0x54, 0x20, 0x45, 0x49, 0x4E, 0x0A, 0x54, 0x49, 0x43, 0x4B,
	0x45, 0x54, 0x20, 0x5A, 0x55, 0x52, 0x0A, 0x45, 0x52, 0x44, 0x45, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC,
	0x35, 0x30, 0x2E, 0x30, 0x30, 0x30, 0x20, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x73, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x45, 0x49, 0x4E, 0x45, 0x20, 0x48, 0x41, 0x4E, 0x44, 0x0A, 0x57, 0x5C, 0x53,
	0x43, 0x48, 0x54, 0x0A, 0x44, 0x49, 0x45, 0x20, 0x41, 0x4E, 0x44, 0x45, 0x52, 0x45, 0x2E, 0x0B,
	0x31, 0x2E, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x53, 0x0A, 0x55, 0x4E,
	0x44, 0x20, 0x44, 0x49, 0x45, 0x20, 0x50, 0x41, 0x50, 0x49, 0x45, 0x52, 0x45, 0x0A, 0x47, 0x45,
	0x48, 0x5D, 0x52, 0x45, 0x4E, 0x20, 0x44, 0x49, 0x52, 0x2E, 0x00
};

const uint8_t LocaleData::_stringsTableSP[] = {
	0x5A, 0x00, 0x71, 0x00, 0x8F, 0x00, 0xA7, 0x01, 0x71, 0x02, 0x8D, 0x02, 0xD8, 0x02, 0x09, 0x03,
	0x6E, 0x03, 0x84, 0x03, 0xBE, 0x03, 0x08, 0x04, 0x51, 0x04, 0x9B, 0x04, 0x18, 0x05, 0x49, 0x05,
	0x60, 0x05, 0xC3, 0x05, 0xD4, 0x05, 0xF2, 0x05, 0x8D, 0x06, 0x9B, 0x08, 0x10, 0x09, 0x2A, 0x09,
	0x89, 0x09, 0x9D, 0x09, 0xBA, 0x09, 0xE1, 0x09, 0xFE, 0x09, 0x21, 0x0A, 0x23, 0x0A, 0x25, 0x0A,
	0x8D, 0x0A, 0xA1, 0x0A, 0x2A, 0x0B, 0x51, 0x0B, 0x05, 0x0C, 0x1F, 0x0C, 0x48, 0x0C, 0x7A, 0x0C,
	0x06, 0x0D, 0x40, 0x0D, 0x89, 0x0D, 0xAD, 0x0D, 0xE8, 0x0D, 0x48, 0x41, 0x20, 0x53, 0x41, 0x4C,
	0x54, 0x41, 0x44, 0x4F, 0x0A, 0x45, 0x4C, 0x20, 0x46, 0x55, 0x53, 0x49, 0x42, 0x4C, 0x45, 0x2E,
	0x00, 0x45, 0x53, 0x54, 0x4F, 0x20, 0x44, 0x45, 0x42, 0x45, 0x52, 0x49, 0x41, 0x0A, 0x46, 0x55,
	0x4E, 0x43, 0x49, 0x4F, 0x4E, 0x41, 0x52, 0x20, 0x41, 0x48, 0x4F, 0x52, 0x41, 0x2E, 0x00, 0xFF,
	0xEB, 0xEC, 0x53, 0x4F, 0x59, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x2E, 0x40, 0x45, 0x53, 0x54, 0x41,
	0x53, 0x0A, 0x42, 0x55, 0x53, 0x43, 0x41, 0x4E, 0x44, 0x4F, 0x0A, 0x44, 0x4F, 0x43, 0x55, 0x4D,
	0x45, 0x4E, 0x54, 0x41, 0x43, 0x49, 0x4F, 0x4E, 0x0A, 0x46, 0x41, 0x4C, 0x53, 0x41, 0x3F, 0x0B,
	0xFF, 0xE9, 0xEA, 0x53, 0x49, 0x2C, 0x20, 0x59, 0x20, 0x4C, 0x4F, 0x0A, 0x4D, 0x41, 0x53, 0x20,
	0x52, 0x41, 0x50, 0x49, 0x44, 0x4F, 0x0A, 0x50, 0x4F, 0x53, 0x49, 0x42, 0x4C, 0x45, 0x2E, 0x0B,
	0xFF, 0xEB, 0xEC, 0x7B, 0x31, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x4F,
	0x53, 0x21, 0x0B, 0xFF, 0xE9, 0xEA, 0x40, 0x40, 0x40, 0x31, 0x35, 0x30, 0x30, 0x3F, 0x3F, 0x3F,
	0x0B, 0xFF, 0xEB, 0xEC, 0x53, 0x49, 0x49, 0x49, 0x2C, 0x20, 0x43, 0x4F, 0x52, 0x52, 0x4F, 0x20,
	0x55, 0x4E, 0x0A, 0x47, 0x52, 0x41, 0x4E, 0x20, 0x50, 0x45, 0x4C, 0x49, 0x47, 0x52, 0x4F, 0x0A,
	0x41, 0x51, 0x55, 0x49, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x50, 0x45, 0x52, 0x4F, 0x2C, 0x20, 0x59,
	0x4F, 0x20, 0x4E, 0x4F, 0x0A, 0x54, 0x45, 0x4E, 0x47, 0x4F, 0x20, 0x53, 0x55, 0x46, 0x49, 0x43,
	0x49, 0x45, 0x4E, 0x54, 0x45, 0x0B, 0xFF, 0xEB, 0xEC, 0x56, 0x45, 0x20, 0x41, 0x20, 0x4C, 0x41,
	0x20, 0x4F, 0x46, 0x49, 0x43, 0x49, 0x4E, 0x41, 0x0A, 0x44, 0x45, 0x20, 0x45, 0x4D, 0x50, 0x4C,
	0x45, 0x4F, 0x2C, 0x0A, 0x41, 0x4C, 0x4C, 0x49, 0x20, 0x45, 0x4E, 0x43, 0x4F, 0x4E, 0x54, 0x52,
	0x41, 0x52, 0x41, 0x53, 0x0A, 0x54, 0x52, 0x41, 0x42, 0x41, 0x4A, 0x4F, 0x2E, 0x0B, 0x59, 0x20,
	0x56, 0x55, 0x45, 0x4C, 0x56, 0x45, 0x20, 0x41, 0x20, 0x56, 0x45, 0x52, 0x4D, 0x45, 0x0A, 0x43,
	0x55, 0x41, 0x4E, 0x44, 0x4F, 0x20, 0x54, 0x45, 0x4E, 0x47, 0x41, 0x53, 0x0A, 0x4C, 0x41, 0x20,
	0x50, 0x41, 0x53, 0x54, 0x41, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x43, 0x4F, 0x4E, 0x4F, 0x5A, 0x43,
	0x4F, 0x20, 0x41, 0x20, 0x45, 0x53, 0x45, 0x0A, 0x54, 0x49, 0x4F, 0x2E, 0x20, 0x54, 0x49, 0x45,
	0x4E, 0x45, 0x20, 0x55, 0x4E, 0x0A, 0x41, 0x4D, 0x49, 0x47, 0x4F, 0x20, 0x45, 0x4E, 0x20, 0x4C,
	0x41, 0x0A, 0x50, 0x4F, 0x4C, 0x49, 0x43, 0x49, 0x41, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x40, 0x44,
	0x4F, 0x4E, 0x44, 0x45, 0x20, 0x50, 0x55, 0x45, 0x44, 0x4F, 0x0A, 0x45, 0x4E, 0x43, 0x4F, 0x4E,
	0x54, 0x52, 0x41, 0x52, 0x20, 0x41, 0x0A, 0x45, 0x53, 0x45, 0x20, 0x41, 0x4D, 0x49, 0x47, 0x4F,
	0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x56, 0x45, 0x20, 0x41, 0x4C, 0x20, 0x41, 0x52, 0x45, 0x41, 0x0A,
	0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x4E, 0x47, 0x49, 0x44, 0x41, 0x20, 0x31, 0x2C, 0x0A, 0x43,
	0x52, 0x45, 0x4F, 0x20, 0x51, 0x55, 0x45, 0x20, 0x45, 0x53, 0x54, 0x41, 0x20, 0x44, 0x45, 0x0A,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x49, 0x4F, 0x20, 0x41, 0x4C, 0x4C, 0x49, 0x2E, 0x0B, 0x50,
	0x45, 0x52, 0x4F, 0x20, 0x54, 0x45, 0x4E, 0x20, 0x43, 0x55, 0x49, 0x44, 0x41, 0x44, 0x4F, 0x2C,
	0x0A, 0x7B, 0x45, 0x53, 0x4F, 0x53, 0x20, 0x54, 0x49, 0x4F, 0x53, 0x20, 0x53, 0x4F, 0x4E, 0x0A,
	0x55, 0x4E, 0x4F, 0x53, 0x20, 0x4D, 0x49, 0x53, 0x45, 0x52, 0x41, 0x42, 0x4C, 0x45, 0x53, 0x21,
	0x00, 0xFF, 0xEB, 0xEC, 0x59, 0x4F, 0x20, 0x4E, 0x4F, 0x20, 0x53, 0x45, 0x0A, 0x4E, 0x41, 0x44,
	0x41, 0x20, 0x4D, 0x41, 0x53, 0x2C, 0x0A, 0x48, 0x49, 0x4A, 0x4F, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x20, 0x51, 0x55, 0x49, 0x45, 0x52, 0x45, 0x0A, 0x48,
	0x41, 0x43, 0x45, 0x52, 0x20, 0x55, 0x4E, 0x20, 0x54, 0x52, 0x41, 0x54, 0x4F, 0x0A, 0x43, 0x4F,
	0x4E, 0x54, 0x49, 0x47, 0x4F, 0x2E, 0x0B, 0x45, 0x53, 0x54, 0x41, 0x52, 0x41, 0x20, 0x45, 0x53,
	0x50, 0x45, 0x52, 0x41, 0x4E, 0x44, 0x4F, 0x0A, 0x44, 0x45, 0x54, 0x52, 0x41, 0x53, 0x20, 0x44,
	0x45, 0x4C, 0x20, 0x42, 0x41, 0x52, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x56, 0x45, 0x54, 0x45, 0x20,
	0x41, 0x4C, 0x20, 0x42, 0x41, 0x52, 0x2C, 0x0A, 0x48, 0x49, 0x4A, 0x4F, 0x2C, 0x20, 0x43, 0x59,
	0x2D, 0x42, 0x30, 0x32, 0x31, 0x20, 0x54, 0x45, 0x0A, 0x45, 0x53, 0x54, 0x41, 0x20, 0x45, 0x53,
	0x50, 0x45, 0x52, 0x41, 0x4E, 0x44, 0x4F, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x7B, 0x4E, 0x4F, 0x20,
	0x44, 0x49, 0x53, 0x50, 0x41, 0x52, 0x45, 0x53, 0x2C, 0x20, 0x59, 0x4F, 0x0A, 0x4E, 0x4F, 0x20,
	0x53, 0x4F, 0x59, 0x20, 0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x21, 0x0B, 0x53, 0x55, 0x20,
	0x45, 0x53, 0x43, 0x4F, 0x4E, 0x44, 0x52, 0x49, 0x4A, 0x4F, 0x0A, 0x45, 0x53, 0x54, 0x41, 0x20,
	0x41, 0x48, 0x49, 0x20, 0x41, 0x42, 0x41, 0x4A, 0x4F, 0x2E, 0x0B, 0x53, 0x55, 0x20, 0x43, 0x4F,
	0x4C, 0x45, 0x47, 0x41, 0x2C, 0x0A, 0x45, 0x4C, 0x20, 0x50, 0x4F, 0x4C, 0x49, 0x0A, 0x54, 0x49,
	0x45, 0x4E, 0x45, 0x20, 0x4C, 0x41, 0x20, 0x4C, 0x4C, 0x41, 0x56, 0x45, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x59, 0x4F, 0x20, 0x4E, 0x4F, 0x20, 0x53, 0x45, 0x0A, 0x4E, 0x41, 0x44, 0x41, 0x20, 0x4D,
	0x41, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x55, 0x4E, 0x20, 0x54, 0x49, 0x4F, 0x20, 0x4C, 0x4C,
	0x41, 0x4D, 0x41, 0x44, 0x4F, 0x0B, 0x4A, 0x41, 0x43, 0x4B, 0x20, 0x41, 0x43, 0x4F, 0x52, 0x44,
	0x4F, 0x0A, 0x52, 0x45, 0x55, 0x4E, 0x49, 0x52, 0x53, 0x45, 0x20, 0x43, 0x4F, 0x4E, 0x20, 0x55,
	0x44, 0x2E, 0x0A, 0x45, 0x4E, 0x20, 0x45, 0x4C, 0x20, 0x42, 0x41, 0x52, 0x2E, 0x00, 0x51, 0x55,
	0x45, 0x52, 0x52, 0x49, 0x41, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x4F,
	0x20, 0x44, 0x45, 0x0A, 0x54, 0x52, 0x41, 0x42, 0x41, 0x4A, 0x4F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC,
	0x4E, 0x4F, 0x2C, 0x20, 0x4E, 0x4F, 0x20, 0x45, 0x53, 0x20, 0x41, 0x51, 0x55, 0x49, 0x2E, 0x0A,
	0x56, 0x41, 0x59, 0x41, 0x20, 0x41, 0x20, 0x4C, 0x41, 0x0A, 0x56, 0x45, 0x4E, 0x54, 0x41, 0x4E,
	0x49, 0x4C, 0x4C, 0x41, 0x20, 0x43, 0x2E, 0x00, 0x51, 0x55, 0x45, 0x52, 0x52, 0x49, 0x41, 0x20,
	0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x4F, 0x20, 0x44, 0x45, 0x0A, 0x54, 0x52,
	0x41, 0x42, 0x41, 0x4A, 0x4F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x49, 0x45, 0x4E, 0x20, 0x2E,
	0x2E, 0x4F, 0x2E, 0x4B, 0x2E, 0x2C, 0x0A, 0x45, 0x4C, 0x20, 0x4A, 0x45, 0x46, 0x45, 0x20, 0x4C,
	0x45, 0x0A, 0x52, 0x45, 0x43, 0x49, 0x42, 0x49, 0x52, 0x41, 0x20, 0x41, 0x48, 0x4F, 0x52, 0x41,
	0x00, 0x51, 0x55, 0x45, 0x52, 0x52, 0x49, 0x41, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D,
	0x49, 0x53, 0x4F, 0x20, 0x44, 0x45, 0x0A, 0x54, 0x52, 0x41, 0x42, 0x41, 0x4A, 0x4F, 0x2E, 0x0B,
	0xFF, 0xEB, 0xEC, 0x4E, 0x4F, 0x2C, 0x20, 0x4E, 0x4F, 0x20, 0x45, 0x53, 0x20, 0x41, 0x51, 0x55,
	0x49, 0x2E, 0x0A, 0x56, 0x41, 0x59, 0x41, 0x20, 0x41, 0x20, 0x4C, 0x41, 0x0A, 0x56, 0x45, 0x4E,
	0x54, 0x41, 0x4E, 0x49, 0x4C, 0x4C, 0x41, 0x20, 0x42, 0x2E, 0x00, 0x51, 0x55, 0x49, 0x45, 0x52,
	0x4F, 0x20, 0x48, 0x41, 0x42, 0x4C, 0x41, 0x52, 0x0A, 0x43, 0x4F, 0x4E, 0x20, 0x4A, 0x41, 0x43,
	0x4B, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x40, 0x41, 0x48, 0x20, 0x53, 0x49, 0x3F, 0x20, 0x4A, 0x41,
	0x43, 0x4B, 0x20, 0x4E, 0x4F, 0x0A, 0x45, 0x53, 0x54, 0x41, 0x20, 0x41, 0x51, 0x55, 0x49, 0x20,
	0x41, 0x48, 0x4F, 0x52, 0x41, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x4D, 0x45, 0x20, 0x45, 0x4E, 0x56,
	0x49, 0x41, 0x0A, 0x4D, 0x49, 0x20, 0x41, 0x4D, 0x49, 0x47, 0x4F, 0x20, 0x49, 0x41, 0x4E, 0x2E,
	0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x2E, 0x4B, 0x2E, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x20, 0x54, 0x45,
	0x0A, 0x45, 0x53, 0x54, 0x41, 0x20, 0x45, 0x53, 0x50, 0x45, 0x52, 0x41, 0x4E, 0x44, 0x4F, 0x0A,
	0x41, 0x46, 0x55, 0x45, 0x52, 0x41, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x54, 0x49, 0x52, 0x41, 0x4C,
	0x4F, 0x2C, 0x20, 0x48, 0x49, 0x4A, 0x4F, 0x2E, 0x0A, 0x45, 0x52, 0x45, 0x53, 0x20, 0x44, 0x45,
	0x4D, 0x41, 0x53, 0x49, 0x41, 0x44, 0x4F, 0x0A, 0x4A, 0x4F, 0x56, 0x45, 0x4E, 0x20, 0x50, 0x41,
	0x52, 0x41, 0x20, 0x42, 0x45, 0x42, 0x45, 0x52, 0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x41, 0x50, 0x45,
	0x4C, 0x45, 0x53, 0x2C, 0x0A, 0x50, 0x4F, 0x52, 0x20, 0x46, 0x41, 0x56, 0x4F, 0x52, 0x2E, 0x00,
	0x53, 0x4F, 0x59, 0x20, 0x45, 0x4C, 0x0A, 0x4D, 0x45, 0x4E, 0x53, 0x41, 0x4A, 0x45, 0x52, 0x4F,
	0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x7B, 0x41, 0x48, 0x20, 0x53, 0x49, 0x21, 0x20, 0x4C, 0x4C, 0x45,
	0x56, 0x41, 0x0A, 0x45, 0x53, 0x54, 0x45, 0x20, 0x50, 0x41, 0x51, 0x55, 0x45, 0x54, 0x45, 0x20,
	0x41, 0x0A, 0x4C, 0x41, 0x20, 0x41, 0x47, 0x45, 0x4E, 0x43, 0x49, 0x41, 0x20, 0x44, 0x45, 0x0A,
	0x56, 0x49, 0x41, 0x4A, 0x45, 0x53, 0x2E, 0x0B, 0x59, 0x20, 0x54, 0x45, 0x4E, 0x20, 0x43, 0x55,
	0x49, 0x44, 0x41, 0x44, 0x4F, 0x2C, 0x0A, 0x45, 0x53, 0x20, 0x56, 0x41, 0x4C, 0x49, 0x4F, 0x53,
	0x4F, 0x2E, 0x00, 0x54, 0x49, 0x45, 0x4D, 0x50, 0x4F, 0x20, 0x43, 0x4F, 0x4E, 0x43, 0x4C, 0x55,
	0x49, 0x44, 0x4F, 0x00, 0x48, 0x41, 0x59, 0x20, 0x55, 0x4E, 0x20, 0x4C, 0x55, 0x47, 0x41, 0x52,
	0x0A, 0x50, 0x41, 0x52, 0x41, 0x20, 0x4C, 0x41, 0x20, 0x54, 0x41, 0x52, 0x4A, 0x45, 0x54, 0x41,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x47, 0x52, 0x41, 0x43, 0x49, 0x41, 0x53, 0x2C, 0x20, 0x43, 0x4F,
	0x4E, 0x52, 0x41, 0x44, 0x2E, 0x0A, 0x7B, 0x45, 0x53, 0x54, 0x4F, 0x53, 0x20, 0x50, 0x4F, 0x4C,
	0x49, 0x53, 0x0A, 0x48, 0x41, 0x42, 0x52, 0x49, 0x41, 0x4E, 0x20, 0x43, 0x4F, 0x4E, 0x53, 0x45,
	0x47, 0x55, 0x49, 0x44, 0x4F, 0x0A, 0x4D, 0x49, 0x20, 0x50, 0x45, 0x4C, 0x4C, 0x45, 0x4A, 0x4F,
	0x21, 0x0B, 0x42, 0x49, 0x45, 0x4E, 0x2C, 0x53, 0x55, 0x50, 0x4F, 0x4E, 0x47, 0x4F, 0x20, 0x51,
	0x55, 0x45, 0x0A, 0x4E, 0x4F, 0x20, 0x52, 0x45, 0x43, 0x55, 0x45, 0x52, 0x44, 0x41, 0x53, 0x20,
	0x41, 0x0A, 0x54, 0x55, 0x20, 0x56, 0x49, 0x45, 0x4A, 0x4F, 0x0A, 0x41, 0x4D, 0x49, 0x47, 0x4F,
	0x20, 0x49, 0x41, 0x4E, 0x2E, 0x0B, 0x53, 0x49, 0x45, 0x4E, 0x54, 0x41, 0x54, 0x45, 0x2C, 0x0A,
	0x41, 0x52, 0x52, 0x45, 0x47, 0x4C, 0x41, 0x52, 0x45, 0x4D, 0x4F, 0x53, 0x0A, 0x45, 0x53, 0x54,
	0x4F, 0x20, 0x45, 0x4E, 0x53, 0x45, 0x47, 0x55, 0x49, 0x44, 0x41, 0x2E, 0x00, 0x49, 0x41, 0x4E,
	0x2C, 0x20, 0x40, 0x51, 0x55, 0x45, 0x20, 0x54, 0x49, 0x45, 0x4E, 0x45, 0x0A, 0x55, 0x4E, 0x4F,
	0x20, 0x51, 0x55, 0x45, 0x20, 0x48, 0x41, 0x43, 0x45, 0x52, 0x20, 0x0A, 0x50, 0x41, 0x52, 0x41,
	0x20, 0x49, 0x52, 0x20, 0x41, 0x0A, 0x4C, 0x41, 0x20, 0x54, 0x49, 0x45, 0x52, 0x52, 0x41, 0x3F,
	0x0B, 0xFF, 0xEB, 0xEC, 0x45, 0x4C, 0x20, 0x50, 0x52, 0x45, 0x43, 0x49, 0x4F, 0x20, 0x44, 0x45,
	0x4C, 0x0A, 0x42, 0x49, 0x4C, 0x4C, 0x45, 0x54, 0x45, 0x20, 0x45, 0x53, 0x0A, 0x41, 0x53, 0x54,
	0x52, 0x4F, 0x4E, 0x4F, 0x4D, 0x49, 0x43, 0x4F, 0x2E, 0x0B, 0x53, 0x4F, 0x4C, 0x4F, 0x20, 0x54,
	0x45, 0x20, 0x51, 0x55, 0x45, 0x44, 0x41, 0x0A, 0x50, 0x41, 0x52, 0x54, 0x49, 0x43, 0x49, 0x50,
	0x41, 0x52, 0x20, 0x45, 0x4E, 0x20, 0x4C, 0x41, 0x0A, 0x54, 0x4F, 0x52, 0x52, 0x45, 0x20, 0x44,
	0x45, 0x20, 0x4C, 0x41, 0x0A, 0x4D, 0x55, 0x45, 0x52, 0x54, 0x45, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA,
	0x40, 0x4C, 0x41, 0x20, 0x54, 0x4F, 0x52, 0x52, 0x45, 0x0A, 0x44, 0x45, 0x20, 0x4C, 0x41, 0x20,
	0x4D, 0x55, 0x45, 0x52, 0x54, 0x45, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x45, 0x53, 0x20, 0x55, 0x4E,
	0x20, 0x43, 0x4F, 0x4E, 0x43, 0x55, 0x52, 0x53, 0x4F, 0x0A, 0x44, 0x45, 0x20, 0x4C, 0x41, 0x20,
	0x54, 0x45, 0x4C, 0x45, 0x2E, 0x20, 0x45, 0x4C, 0x0A, 0x47, 0x41, 0x4E, 0x41, 0x44, 0x4F, 0x52,
	0x20, 0x4F, 0x42, 0x54, 0x49, 0x45, 0x4E, 0x45, 0x0A, 0x55, 0x4E, 0x20, 0x42, 0x49, 0x4C, 0x4C,
	0x45, 0x54, 0x45, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x4F, 0x2E, 0x4B, 0x2E, 0x20, 0x40, 0x50, 0x55,
	0x45, 0x44, 0x45, 0x53, 0x0A, 0x43, 0x4F, 0x4E, 0x53, 0x45, 0x47, 0x55, 0x49, 0x52, 0x4D, 0x45,
	0x0A, 0x44, 0x4F, 0x43, 0x55, 0x4D, 0x45, 0x4E, 0x54, 0x41, 0x43, 0x49, 0x4F, 0x4E, 0x0A, 0x46,
	0x41, 0x4C, 0x53, 0x41, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x53, 0x49, 0x4E, 0x20, 0x50, 0x52, 0x4F,
	0x42, 0x4C, 0x45, 0x4D, 0x41, 0x53, 0x2E, 0x0A, 0x56, 0x45, 0x20, 0x41, 0x4C, 0x20, 0x42, 0x41,
	0x52, 0x20, 0x59, 0x0A, 0x50, 0x52, 0x45, 0x47, 0x55, 0x4E, 0x54, 0x41, 0x20, 0x50, 0x4F, 0x52,
	0x0A, 0x4A, 0x41, 0x43, 0x4B, 0x2E, 0x0B, 0x44, 0x49, 0x4C, 0x45, 0x20, 0x51, 0x55, 0x45, 0x20,
	0x54, 0x45, 0x0A, 0x45, 0x4E, 0x56, 0x49, 0x4F, 0x20, 0x59, 0x4F, 0x2E, 0x20, 0x41, 0x48, 0x2C,
	0x0A, 0x50, 0x4F, 0x52, 0x20, 0x43, 0x49, 0x45, 0x52, 0x54, 0x4F, 0x2E, 0x2E, 0x2E, 0x0B, 0x50,
	0x55, 0x53, 0x45, 0x20, 0x45, 0x4C, 0x20, 0x43, 0x41, 0x4D, 0x50, 0x4F, 0x20, 0x44, 0x45, 0x0A,
	0x46, 0x55, 0x45, 0x52, 0x5A, 0x41, 0x20, 0x51, 0x55, 0x45, 0x20, 0x4D, 0x45, 0x0A, 0x50, 0x45,
	0x44, 0x49, 0x53, 0x54, 0x45, 0x20, 0x45, 0x4E, 0x20, 0x54, 0x55, 0x0A, 0x42, 0x4F, 0x4C, 0x53,
	0x49, 0x4C, 0x4C, 0x4F, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x43, 0x48, 0x41, 0x43, 0x48, 0x49, 0x2E,
	0x20, 0x47, 0x52, 0x41, 0x43, 0x49, 0x41, 0x53, 0x0A, 0x49, 0x41, 0x4E, 0x2E, 0x20, 0x48, 0x41,
	0x53, 0x54, 0x41, 0x20, 0x4C, 0x41, 0x0A, 0x50, 0x52, 0x4F, 0x58, 0x49, 0x4D, 0x41, 0x2E, 0x2E,
	0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x55, 0x45, 0x4E, 0x41, 0x20, 0x53, 0x55, 0x45, 0x52, 0x54,
	0x45, 0x2E, 0x0A, 0x43, 0x4F, 0x4E, 0x54, 0x41, 0x43, 0x54, 0x41, 0x52, 0x45, 0x4D, 0x4F, 0x53,
	0x0A, 0x41, 0x20, 0x54, 0x55, 0x20, 0x4C, 0x4C, 0x45, 0x47, 0x41, 0x44, 0x41, 0x20, 0x41, 0x0A,
	0x4C, 0x41, 0x20, 0x54, 0x49, 0x45, 0x52, 0x52, 0x41, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x42, 0x49,
	0x45, 0x4E, 0x56, 0x45, 0x4E, 0x49, 0x44, 0x4F, 0x20, 0x41, 0x0A, 0x4E, 0x45, 0x57, 0x20, 0x57,
	0x41, 0x53, 0x48, 0x49, 0x4E, 0x47, 0x54, 0x4F, 0x4E, 0x2C, 0x0A, 0x4A, 0x4F, 0x56, 0x45, 0x4E,
	0x43, 0x49, 0x54, 0x4F, 0x2E, 0x0B, 0x41, 0x51, 0x55, 0x49, 0x20, 0x54, 0x49, 0x45, 0x4E, 0x45,
	0x53, 0x20, 0x55, 0x4E, 0x0A, 0x4D, 0x41, 0x50, 0x41, 0x20, 0x44, 0x45, 0x20, 0x4C, 0x41, 0x0A,
	0x43, 0x49, 0x55, 0x44, 0x41, 0x44, 0x20, 0x51, 0x55, 0x45, 0x20, 0x54, 0x45, 0x0A, 0x53, 0x45,
	0x52, 0x41, 0x20, 0x4D, 0x55, 0x59, 0x20, 0x55, 0x54, 0x49, 0x4C, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA,
	0x4D, 0x55, 0x43, 0x48, 0x41, 0x53, 0x20, 0x47, 0x52, 0x41, 0x43, 0x49, 0x41, 0x53, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x51, 0x55, 0x45, 0x20, 0x54, 0x45, 0x4E, 0x47, 0x41, 0x20, 0x55, 0x4E, 0x0A,
	0x42, 0x55, 0x45, 0x4E, 0x20, 0x44, 0x49, 0x41, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x45, 0x42,
	0x45, 0x20, 0x54, 0x45, 0x4E, 0x45, 0x52, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49,
	0x53, 0x4F, 0x20, 0x50, 0x41, 0x52, 0x41, 0x0A, 0x50, 0x4F, 0x44, 0x45, 0x52, 0x20, 0x54, 0x52,
	0x41, 0x42, 0x41, 0x4A, 0x41, 0x52, 0x2E, 0x0B, 0x50, 0x55, 0x45, 0x44, 0x45, 0x20, 0x43, 0x4F,
	0x4E, 0x53, 0x45, 0x47, 0x55, 0x49, 0x52, 0x0A, 0x55, 0x4E, 0x4F, 0x20, 0x45, 0x4E, 0x20, 0x45,
	0x4C, 0x20, 0x43, 0x45, 0x4E, 0x54, 0x52, 0x4F, 0x0A, 0x41, 0x44, 0x4D, 0x49, 0x4E, 0x49, 0x53,
	0x54, 0x52, 0x41, 0x54, 0x49, 0x56, 0x4F, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4E, 0x4F, 0x20, 0x54,
	0x45, 0x4E, 0x47, 0x4F, 0x0A, 0x54, 0x49, 0x45, 0x4D, 0x50, 0x4F, 0x2E, 0x00, 0x42, 0x55, 0x45,
	0x4E, 0x4F, 0x53, 0x20, 0x44, 0x49, 0x41, 0x53, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x55, 0x45,
	0x4E, 0x4F, 0x53, 0x20, 0x44, 0x49, 0x41, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x48, 0x45, 0x20,
	0x56, 0x49, 0x53, 0x54, 0x4F, 0x20, 0x41, 0x20, 0x45, 0x53, 0x45, 0x0A, 0x54, 0x49, 0x4F, 0x20,
	0x41, 0x4E, 0x54, 0x45, 0x53, 0x20, 0x45, 0x4E, 0x0A, 0x45, 0x4C, 0x20, 0x42, 0x41, 0x52, 0x2E,
	0x00, 0x42, 0x55, 0x45, 0x4E, 0x4F, 0x53, 0x20, 0x44, 0x49, 0x41, 0x53, 0x2E, 0x0B, 0xFF, 0xEB,
	0xEC, 0x42, 0x55, 0x45, 0x4E, 0x4F, 0x53, 0x20, 0x44, 0x49, 0x41, 0x53, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x53, 0x49, 0x2C, 0x20, 0x4C, 0x45, 0x20, 0x43, 0x4F, 0x4E, 0x4F, 0x5A, 0x43, 0x4F, 0x2E,
	0x0A, 0x45, 0x53, 0x20, 0x55, 0x4E, 0x20, 0x48, 0x41, 0x42, 0x49, 0x54, 0x55, 0x41, 0x4C, 0x2E,
	0x00, 0x20, 0x00, 0x20, 0x00, 0x51, 0x55, 0x45, 0x52, 0x52, 0x49, 0x41, 0x20, 0x55, 0x4E, 0x0A,
	0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x4F, 0x20, 0x44, 0x45, 0x0A, 0x54, 0x52, 0x41, 0x42, 0x41,
	0x4A, 0x4F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x4F, 0x20, 0x48, 0x41, 0x59, 0x20, 0x50, 0x52,
	0x4F, 0x42, 0x4C, 0x45, 0x4D, 0x41, 0x2E, 0x0A, 0x50, 0x41, 0x52, 0x41, 0x20, 0x43, 0x4F, 0x4E,
	0x53, 0x45, 0x47, 0x55, 0x49, 0x52, 0x0A, 0x55, 0x4E, 0x20, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53,
	0x4F, 0x2E, 0x2E, 0x2E, 0x0B, 0x4E, 0x45, 0x43, 0x45, 0x53, 0x49, 0x54, 0x4F, 0x20, 0x53, 0x55,
	0x0A, 0x54, 0x41, 0x52, 0x4A, 0x45, 0x54, 0x41, 0x20, 0x49, 0x44, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x41, 0x59, 0x55, 0x44, 0x41, 0x2E, 0x2E, 0x2E, 0x41, 0x59, 0x55, 0x44, 0x41, 0x2E, 0x2E, 0x2E,
	0x00, 0xFF, 0xEB, 0xEC, 0x41, 0x59, 0x55, 0x44, 0x45, 0x4D, 0x45, 0x2C, 0x20, 0x4A, 0x4F, 0x56,
	0x45, 0x4E, 0x2E, 0x0A, 0x48, 0x45, 0x20, 0x53, 0x49, 0x44, 0x4F, 0x20, 0x41, 0x54, 0x41, 0x43,
	0x41, 0x44, 0x4F, 0x0A, 0x50, 0x4F, 0x52, 0x20, 0x55, 0x4E, 0x4F, 0x53, 0x20, 0x0A, 0x4D, 0x55,
	0x54, 0x41, 0x4E, 0x54, 0x45, 0x53, 0x2E, 0x2E, 0x2E, 0x0B, 0x59, 0x20, 0x4E, 0x4F, 0x20, 0x50,
	0x55, 0x45, 0x44, 0x4F, 0x0A, 0x43, 0x41, 0x4D, 0x49, 0x4E, 0x41, 0x52, 0x2E, 0x0B, 0x42, 0x55,
	0x53, 0x51, 0x55, 0x45, 0x20, 0x4D, 0x49, 0x0A, 0x54, 0x45, 0x4C, 0x45, 0x50, 0x4F, 0x52, 0x54,
	0x41, 0x44, 0x4F, 0x52, 0x2E, 0x0B, 0x4E, 0x45, 0x43, 0x45, 0x53, 0x49, 0x54, 0x4F, 0x0A, 0x41,
	0x53, 0x49, 0x53, 0x54, 0x45, 0x4E, 0x43, 0x49, 0x41, 0x0A, 0x4D, 0x45, 0x44, 0x49, 0x43, 0x41,
	0x20, 0x55, 0x52, 0x47, 0x45, 0x4E, 0x54, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x47, 0x52, 0x41,
	0x43, 0x49, 0x41, 0x53, 0x2E, 0x41, 0x43, 0x41, 0x42, 0x41, 0x53, 0x0A, 0x44, 0x45, 0x20, 0x53,
	0x41, 0x4C, 0x56, 0x41, 0x52, 0x4D, 0x45, 0x0A, 0x4C, 0x41, 0x20, 0x56, 0x49, 0x44, 0x41, 0x2E,
	0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x41, 0x52, 0x41, 0x20, 0x49, 0x52, 0x20, 0x41, 0x20, 0x4E, 0x45,
	0x57, 0x0A, 0x57, 0x41, 0x53, 0x48, 0x49, 0x4E, 0x47, 0x54, 0x4F, 0x4E, 0x2C, 0x0A, 0x54, 0x49,
	0x45, 0x4E, 0x45, 0x20, 0x51, 0x55, 0x45, 0x20, 0x53, 0x41, 0x4C, 0x54, 0x41, 0x52, 0x0A, 0x50,
	0x4F, 0x52, 0x20, 0x45, 0x53, 0x54, 0x45, 0x20, 0x41, 0x47, 0x55, 0x4A, 0x45, 0x52, 0x4F, 0x0B,
	0x50, 0x45, 0x52, 0x4F, 0x20, 0x59, 0x4F, 0x20, 0x51, 0x55, 0x45, 0x20, 0x54, 0x55, 0x0A, 0x55,
	0x53, 0x41, 0x52, 0x49, 0x41, 0x20, 0x55, 0x4E, 0x0A, 0x43, 0x49, 0x4E, 0x54, 0x55, 0x52, 0x4F,
	0x4E, 0x20, 0x41, 0x4E, 0x54, 0x49, 0x2D, 0x47, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x40, 0x44, 0x4F,
	0x4E, 0x44, 0x45, 0x20, 0x50, 0x55, 0x45, 0x44, 0x4F, 0x0A, 0x45, 0x4E, 0x43, 0x4F, 0x4E, 0x54,
	0x52, 0x41, 0x52, 0x20, 0x55, 0x4E, 0x4F, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x48, 0x4F, 0x52,
	0x41, 0x2C, 0x20, 0x50, 0x55, 0x45, 0x44, 0x4F, 0x0A, 0x56, 0x45, 0x4E, 0x44, 0x45, 0x52, 0x54,
	0x45, 0x20, 0x55, 0x4E, 0x4F, 0x3A, 0x0A, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49,
	0x54, 0x4F, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x42, 0x4F, 0x4E, 0x20, 0x56, 0x4F, 0x59, 0x41,
	0x47, 0x45, 0x2C, 0x0A, 0x4A, 0x4F, 0x56, 0x45, 0x4E, 0x43, 0x49, 0x54, 0x4F, 0x2E, 0x00, 0x4E,
	0x45, 0x43, 0x45, 0x53, 0x49, 0x54, 0x4F, 0x20, 0x55, 0x4E, 0x0A, 0x43, 0x41, 0x52, 0x54, 0x55,
	0x43, 0x48, 0x4F, 0x0A, 0x4D, 0x41, 0x47, 0x4E, 0x45, 0x54, 0x49, 0x43, 0x4F, 0x0A, 0x52, 0x45,
	0x43, 0x41, 0x52, 0x47, 0x41, 0x44, 0x4F, 0x00, 0x51, 0x55, 0x45, 0x52, 0x52, 0x49, 0x41, 0x20,
	0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x4F, 0x20, 0x44, 0x45, 0x0A, 0x54, 0x52,
	0x41, 0x42, 0x41, 0x4A, 0x4F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x50, 0x52, 0x49, 0x4D, 0x45, 0x52,
	0x41, 0x20, 0x50, 0x4C, 0x41, 0x4E, 0x54, 0x41, 0x2E, 0x00, 0x55, 0x4E, 0x41, 0x20, 0x56, 0x4F,
	0x5A, 0x20, 0x49, 0x4E, 0x54, 0x45, 0x52, 0x49, 0x4F, 0x52, 0x0A, 0x49, 0x4E, 0x54, 0x45, 0x52,
	0x52, 0x55, 0x4D, 0x50, 0x45, 0x20, 0x54, 0x55, 0x53, 0x0A, 0x50, 0x45, 0x4E, 0x53, 0x41, 0x4D,
	0x49, 0x45, 0x4E, 0x54, 0x4F, 0x53, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x43, 0x52, 0x45, 0x45, 0x4D,
	0x45, 0x2C, 0x20, 0x48, 0x49, 0x4A, 0x4F, 0x2C, 0x0A, 0x50, 0x4F, 0x4E, 0x20, 0x4C, 0x41, 0x20,
	0x43, 0x41, 0x52, 0x47, 0x41, 0x0A, 0x41, 0x54, 0x4F, 0x4D, 0x49, 0x43, 0x41, 0x20, 0x41, 0x51,
	0x55, 0x49, 0x2E, 0x2E, 0x2E, 0x0B, 0x59, 0x20, 0x48, 0x55, 0x59, 0x45, 0x20, 0x45, 0x4E, 0x20,
	0x43, 0x55, 0x41, 0x4E, 0x54, 0x4F, 0x0A, 0x41, 0x4C, 0x43, 0x41, 0x4E, 0x43, 0x45, 0x20, 0x45,
	0x4C, 0x0A, 0x4E, 0x55, 0x43, 0x4C, 0x45, 0x4F, 0x20, 0x44, 0x45, 0x4C, 0x0A, 0x50, 0x4C, 0x41,
	0x4E, 0x45, 0x54, 0x41, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x47, 0x55, 0x49, 0x41, 0x4D, 0x45, 0x2C,
	0x0A, 0x4A, 0x4F, 0x56, 0x45, 0x4E, 0x43, 0x49, 0x54, 0x4F, 0x2E, 0x0B, 0x4C, 0x4C, 0x45, 0x56,
	0x41, 0x4D, 0x45, 0x20, 0x41, 0x4C, 0x20, 0x0A, 0x43, 0x45, 0x4E, 0x54, 0x52, 0x4F, 0x20, 0x44,
	0x45, 0x0A, 0x49, 0x4E, 0x56, 0x45, 0x53, 0x54, 0x49, 0x47, 0x41, 0x43, 0x49, 0x4F, 0x4E, 0x00,
	0xFF, 0xEB, 0xEC, 0x47, 0x52, 0x41, 0x43, 0x49, 0x41, 0x53, 0x20, 0x50, 0x4F, 0x52, 0x0A, 0x54,
	0x55, 0x20, 0x41, 0x59, 0x55, 0x44, 0x41, 0x2E, 0x2E, 0x2E, 0x0B, 0x48, 0x45, 0x20, 0x4C, 0x4C,
	0x45, 0x47, 0x41, 0x44, 0x4F, 0x0A, 0x53, 0x49, 0x4E, 0x20, 0x50, 0x52, 0x4F, 0x42, 0x4C, 0x45,
	0x4D, 0x41, 0x53, 0x0A, 0x59, 0x20, 0x59, 0x41, 0x20, 0x4E, 0x4F, 0x20, 0x48, 0x41, 0x59, 0x0A,
	0x50, 0x45, 0x4C, 0x49, 0x47, 0x52, 0x4F, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x42, 0x49, 0x45, 0x4E,
	0x2C, 0x20, 0x40, 0x4D, 0x45, 0x20, 0x48, 0x41, 0x53, 0x0A, 0x54, 0x52, 0x41, 0x49, 0x44, 0x4F,
	0x20, 0x45, 0x4C, 0x0A, 0x50, 0x41, 0x51, 0x55, 0x45, 0x54, 0x45, 0x3F, 0x00, 0x40, 0x43, 0x55,
	0x41, 0x4E, 0x54, 0x4F, 0x20, 0x43, 0x55, 0x45, 0x53, 0x54, 0x41, 0x0A, 0x55, 0x4E, 0x20, 0x42,
	0x49, 0x4C, 0x4C, 0x45, 0x54, 0x45, 0x20, 0x41, 0x0A, 0x4C, 0x41, 0x20, 0x54, 0x49, 0x45, 0x52,
	0x52, 0x41, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x35, 0x30, 0x2E, 0x30, 0x30, 0x30, 0x20, 0x43, 0x52,
	0x45, 0x44, 0x49, 0x54, 0x4F, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x46, 0x41, 0x56, 0x4F, 0x52,
	0x2C, 0x20, 0x43, 0x4F, 0x4E, 0x0A, 0x46, 0x41, 0x56, 0x4F, 0x52, 0x20, 0x53, 0x45, 0x0A, 0x50,
	0x41, 0x47, 0x41, 0x3A, 0x0B, 0x31, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54,
	0x4F, 0x53, 0x20, 0x59, 0x0A, 0x4C, 0x4F, 0x53, 0x20, 0x50, 0x41, 0x50, 0x45, 0x4C, 0x45, 0x53,
	0x0A, 0x53, 0x4F, 0x4E, 0x20, 0x54, 0x55, 0x59, 0x4F, 0x53, 0x2E, 0x00
};

const uint8_t LocaleData::_stringsTableIT[] = {
	0x5A, 0x00, 0x71, 0x00, 0x8A, 0x00, 0xA2, 0x01, 0x56, 0x02, 0x75, 0x02, 0xBB, 0x02, 0xEE, 0x02,
	0x59, 0x03, 0x72, 0x03, 0xA8, 0x03, 0xF3, 0x03, 0x3F, 0x04, 0x8A, 0x04, 0x0C, 0x05, 0x3E, 0x05,
	0x52, 0x05, 0xB6, 0x05, 0xC4, 0x05, 0xE3, 0x05, 0x7D, 0x06, 0x8D, 0x08, 0xF7, 0x08, 0x0A, 0x09,
	0x5E, 0x09, 0x6F, 0x09, 0x8A, 0x09, 0xAE, 0x09, 0xC9, 0x09, 0xED, 0x09, 0xEF, 0x09, 0xF1, 0x09,
	0x5E, 0x0A, 0x72, 0x0A, 0xF8, 0x0A, 0x1B, 0x0B, 0xCB, 0x0B, 0xEA, 0x0B, 0x17, 0x0C, 0x47, 0x0C,
	0xD7, 0x0C, 0x10, 0x0D, 0x61, 0x0D, 0x86, 0x0D, 0xC1, 0x0D, 0x49, 0x6C, 0x20, 0x66, 0x75, 0x73,
	0x69, 0x62, 0x69, 0x6C, 0x65, 0x20, 0x5C, 0x0A, 0x73, 0x61, 0x6C, 0x74, 0x61, 0x74, 0x6F, 0x2E,
	0x00, 0x4F, 0x72, 0x61, 0x20, 0x64, 0x6F, 0x76, 0x72, 0x65, 0x62, 0x62, 0x65, 0x0A, 0x66, 0x75,
	0x6E, 0x7A, 0x69, 0x6F, 0x6E, 0x61, 0x72, 0x65, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x53, 0x6F, 0x6E,
	0x6F, 0x20, 0x4A, 0x61, 0x63, 0x6B, 0x2E, 0x20, 0x53, 0x74, 0x61, 0x69, 0x0A, 0x63, 0x65, 0x72,
	0x63, 0x61, 0x6E, 0x64, 0x6F, 0x20, 0x64, 0x65, 0x69, 0x0A, 0x64, 0x6F, 0x63, 0x75, 0x6D, 0x65,
	0x6E, 0x74, 0x69, 0x0A, 0x66, 0x61, 0x6C, 0x73, 0x69, 0x3F, 0x0B, 0xFF, 0xE9, 0xEA, 0x53, 0x69,
	0x2C, 0x20, 0x65, 0x20, 0x69, 0x6C, 0x20, 0x70, 0x69, 0x5F, 0x0A, 0x70, 0x72, 0x65, 0x73, 0x74,
	0x6F, 0x0A, 0x70, 0x6F, 0x73, 0x73, 0x69, 0x62, 0x69, 0x6C, 0x65, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC,
	0x31, 0x35, 0x30, 0x30, 0x20, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x69, 0x21, 0x0B, 0xFF, 0xE9,
	0xEA, 0x31, 0x35, 0x30, 0x30, 0x3F, 0x3F, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x43, 0x65, 0x72, 0x74,
	0x6F, 0x2C, 0x20, 0x73, 0x74, 0x6F, 0x0A, 0x70, 0x72, 0x65, 0x6E, 0x64, 0x65, 0x6E, 0x64, 0x6F,
	0x20, 0x75, 0x6E, 0x0A, 0x67, 0x72, 0x6F, 0x73, 0x73, 0x6F, 0x20, 0x72, 0x69, 0x73, 0x63, 0x68,
	0x69, 0x6F, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x4D, 0x61, 0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x6E, 0x65,
	0x20, 0x68, 0x6F, 0x0A, 0x61, 0x62, 0x62, 0x61, 0x73, 0x74, 0x61, 0x6E, 0x7A, 0x61, 0x2E, 0x2E,
	0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x56, 0x61, 0x69, 0x20, 0x61, 0x6C, 0x6C, 0x27, 0x55, 0x66, 0x66,
	0x69, 0x63, 0x69, 0x6F, 0x0A, 0x64, 0x69, 0x20, 0x43, 0x6F, 0x6C, 0x6C, 0x6F, 0x63, 0x61, 0x6D,
	0x65, 0x6E, 0x74, 0x6F, 0x2E, 0x0A, 0x4C, 0x5B, 0x20, 0x74, 0x72, 0x6F, 0x76, 0x65, 0x72, 0x61,
	0x69, 0x0A, 0x64, 0x65, 0x6C, 0x20, 0x6C, 0x61, 0x76, 0x6F, 0x72, 0x6F, 0x2E, 0x0B, 0x45, 0x20,
	0x74, 0x6F, 0x72, 0x6E, 0x61, 0x20, 0x64, 0x61, 0x20, 0x6D, 0x65, 0x0A, 0x71, 0x75, 0x61, 0x6E,
	0x64, 0x6F, 0x20, 0x61, 0x76, 0x72, 0x61, 0x69, 0x0A, 0x69, 0x20, 0x73, 0x6F, 0x6C, 0x64, 0x69,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x43, 0x6F, 0x6E, 0x6F, 0x73, 0x63, 0x6F, 0x20, 0x71, 0x75, 0x65,
	0x6C, 0x20, 0x74, 0x69, 0x70, 0x6F, 0x2E, 0x0A, 0x48, 0x61, 0x20, 0x75, 0x6E, 0x20, 0x61, 0x6D,
	0x69, 0x63, 0x6F, 0x0A, 0x6E, 0x65, 0x6C, 0x6C, 0x61, 0x20, 0x70, 0x6F, 0x6C, 0x69, 0x7A, 0x69,
	0x61, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x44, 0x6F, 0x76, 0x65, 0x20, 0x70, 0x6F, 0x73, 0x73, 0x6F,
	0x0A, 0x74, 0x72, 0x6F, 0x76, 0x61, 0x72, 0x65, 0x20, 0x6C, 0x27, 0x61, 0x6D, 0x69, 0x63, 0x6F,
	0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x56, 0x61, 0x69, 0x20, 0x61, 0x20, 0x52, 0x65, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x65, 0x64, 0x0A, 0x41, 0x72, 0x65, 0x61, 0x20, 0x31, 0x2C, 0x20, 0x70, 0x65,
	0x6E, 0x73, 0x6F, 0x0A, 0x63, 0x68, 0x65, 0x20, 0x73, 0x69, 0x61, 0x20, 0x64, 0x69, 0x0A, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x7A, 0x69, 0x6F, 0x20, 0x6C, 0x5B, 0x2E, 0x0B, 0x4D, 0x61, 0x20, 0x73,
	0x74, 0x61, 0x69, 0x20, 0x61, 0x74, 0x74, 0x65, 0x6E, 0x74, 0x6F, 0x2C, 0x0A, 0x71, 0x75, 0x65,
	0x69, 0x20, 0x74, 0x69, 0x70, 0x69, 0x20, 0x73, 0x6F, 0x6E, 0x6F, 0x0A, 0x64, 0x65, 0x69, 0x20,
	0x64, 0x75, 0x72, 0x69, 0x21, 0x00, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F, 0x6E, 0x20, 0x73, 0x6F, 0x0A,
	0x6E, 0x69, 0x65, 0x6E, 0x74, 0x61, 0x6C, 0x74, 0x72, 0x6F, 0x2C, 0x0A, 0x72, 0x61, 0x67, 0x61,
	0x7A, 0x7A, 0x6F, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x20,
	0x76, 0x75, 0x6F, 0x6C, 0x65, 0x0A, 0x66, 0x61, 0x72, 0x74, 0x69, 0x20, 0x75, 0x6E, 0x61, 0x0A,
	0x70, 0x72, 0x6F, 0x70, 0x6F, 0x73, 0x74, 0x61, 0x2E, 0x0B, 0x54, 0x69, 0x20, 0x73, 0x74, 0x61,
	0x0A, 0x61, 0x73, 0x70, 0x65, 0x74, 0x74, 0x61, 0x6E, 0x64, 0x6F, 0x0A, 0x64, 0x69, 0x65, 0x74,
	0x72, 0x6F, 0x20, 0x61, 0x6C, 0x20, 0x62, 0x61, 0x72, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x56, 0x61,
	0x69, 0x20, 0x61, 0x6C, 0x20, 0x62, 0x61, 0x72, 0x2C, 0x0A, 0x72, 0x61, 0x67, 0x61, 0x7A, 0x7A,
	0x6F, 0x2C, 0x20, 0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x0A, 0x74, 0x69, 0x20, 0x73, 0x74,
	0x61, 0x0A, 0x61, 0x73, 0x70, 0x65, 0x74, 0x74, 0x61, 0x6E, 0x64, 0x6F, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x4E, 0x6F, 0x6E, 0x20, 0x73, 0x70, 0x61, 0x72, 0x61, 0x72, 0x65, 0x2C, 0x20, 0x6E, 0x6F,
	0x6E, 0x0A, 0x73, 0x6F, 0x6E, 0x6F, 0x20, 0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x21, 0x0B,
	0x49, 0x6C, 0x20, 0x73, 0x75, 0x6F, 0x20, 0x72, 0x69, 0x66, 0x75, 0x67, 0x69, 0x6F, 0x0A, 0x5C,
	0x20, 0x64, 0x69, 0x20, 0x73, 0x6F, 0x74, 0x74, 0x6F, 0x2E, 0x0B, 0x49, 0x6C, 0x20, 0x73, 0x75,
	0x6F, 0x20, 0x63, 0x6F, 0x6D, 0x70, 0x61, 0x67, 0x6E, 0x6F, 0x2C, 0x0A, 0x69, 0x6C, 0x20, 0x70,
	0x6F, 0x6C, 0x69, 0x7A, 0x69, 0x6F, 0x74, 0x74, 0x6F, 0x2C, 0x0A, 0x68, 0x61, 0x20, 0x6C, 0x61,
	0x20, 0x63, 0x68, 0x69, 0x61, 0x76, 0x65, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F, 0x6E, 0x20,
	0x73, 0x6F, 0x20, 0x6E, 0x69, 0x65, 0x6E, 0x74, 0x65, 0x0A, 0x64, 0x69, 0x20, 0x70, 0x69, 0x5F,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x53, 0x69, 0x67, 0x6E, 0x6F, 0x72, 0x65, 0x2E, 0x2E, 0x2E, 0x20,
	0x75, 0x6E, 0x0A, 0x63, 0x65, 0x72, 0x74, 0x6F, 0x20, 0x4A, 0x61, 0x63, 0x6B, 0x0A, 0x76, 0x69,
	0x20, 0x61, 0x73, 0x70, 0x65, 0x74, 0x74, 0x61, 0x0A, 0x76, 0x69, 0x63, 0x69, 0x6E, 0x6F, 0x20,
	0x61, 0x6C, 0x20, 0x62, 0x61, 0x72, 0x2E, 0x00, 0x56, 0x6F, 0x72, 0x72, 0x65, 0x69, 0x20, 0x75,
	0x6E, 0x20, 0x70, 0x65, 0x72, 0x2D, 0x0A, 0x6D, 0x65, 0x73, 0x73, 0x6F, 0x20, 0x64, 0x69, 0x20,
	0x6C, 0x61, 0x76, 0x6F, 0x72, 0x6F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F, 0x2C, 0x20, 0x6E,
	0x6F, 0x6E, 0x20, 0x71, 0x75, 0x69, 0x2E, 0x0A, 0x43, 0x68, 0x69, 0x65, 0x64, 0x65, 0x74, 0x65,
	0x20, 0x61, 0x6C, 0x6C, 0x6F, 0x0A, 0x73, 0x70, 0x6F, 0x72, 0x74, 0x65, 0x6C, 0x6C, 0x6F, 0x20,
	0x43, 0x2E, 0x00, 0x56, 0x6F, 0x72, 0x72, 0x65, 0x69, 0x20, 0x75, 0x6E, 0x20, 0x70, 0x65, 0x72,
	0x2D, 0x0A, 0x6D, 0x65, 0x73, 0x73, 0x6F, 0x20, 0x64, 0x69, 0x20, 0x6C, 0x61, 0x76, 0x6F, 0x72,
	0x6F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x65, 0x6E, 0x65, 0x2E, 0x2E, 0x2E, 0x4F, 0x2E, 0x6B,
	0x2E, 0x2C, 0x20, 0x69, 0x6C, 0x0A, 0x63, 0x61, 0x70, 0x6F, 0x20, 0x76, 0x69, 0x20, 0x72, 0x69,
	0x63, 0x65, 0x76, 0x65, 0x72, 0x5B, 0x0A, 0x61, 0x64, 0x65, 0x73, 0x73, 0x6F, 0x2E, 0x00, 0x56,
	0x6F, 0x72, 0x72, 0x65, 0x69, 0x20, 0x75, 0x6E, 0x20, 0x70, 0x65, 0x72, 0x2D, 0x0A, 0x6D, 0x65,
	0x73, 0x73, 0x6F, 0x20, 0x64, 0x69, 0x20, 0x6C, 0x61, 0x76, 0x6F, 0x72, 0x6F, 0x2E, 0x0B, 0xFF,
	0xEB, 0xEC, 0x4E, 0x6F, 0x2C, 0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x71, 0x75, 0x69, 0x2E, 0x0A, 0x43,
	0x68, 0x69, 0x65, 0x64, 0x65, 0x74, 0x65, 0x20, 0x61, 0x6C, 0x6C, 0x6F, 0x0A, 0x73, 0x70, 0x6F,
	0x72, 0x74, 0x65, 0x6C, 0x6C, 0x6F, 0x20, 0x42, 0x2E, 0x00, 0x56, 0x6F, 0x72, 0x72, 0x65, 0x69,
	0x20, 0x70, 0x61, 0x72, 0x6C, 0x61, 0x72, 0x65, 0x0A, 0x63, 0x6F, 0x6E, 0x20, 0x4A, 0x61, 0x63,
	0x6B, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x68, 0x20, 0x73, 0x69, 0x3F, 0x20, 0x4A, 0x61, 0x63,
	0x6B, 0x0A, 0x6E, 0x6F, 0x6E, 0x20, 0x63, 0x27, 0x5C, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x53, 0x6F,
	0x6E, 0x6F, 0x20, 0x73, 0x74, 0x61, 0x74, 0x6F, 0x0A, 0x6D, 0x61, 0x6E, 0x64, 0x61, 0x74, 0x6F,
	0x20, 0x64, 0x61, 0x6C, 0x20, 0x6D, 0x69, 0x6F, 0x0A, 0x61, 0x6D, 0x69, 0x63, 0x6F, 0x20, 0x49,
	0x61, 0x6E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x2E, 0x6B, 0x2E, 0x20, 0x4A, 0x61, 0x63, 0x6B,
	0x0A, 0x74, 0x69, 0x20, 0x73, 0x74, 0x61, 0x20, 0x61, 0x73, 0x70, 0x65, 0x74, 0x2D, 0x0A, 0x74,
	0x61, 0x6E, 0x64, 0x6F, 0x20, 0x66, 0x75, 0x6F, 0x72, 0x69, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4E,
	0x69, 0x65, 0x6E, 0x74, 0x65, 0x20, 0x64, 0x61, 0x20, 0x66, 0x61, 0x72, 0x65, 0x2E, 0x0A, 0x53,
	0x65, 0x69, 0x20, 0x74, 0x72, 0x6F, 0x70, 0x70, 0x6F, 0x20, 0x67, 0x69, 0x6F, 0x2D, 0x0A, 0x76,
	0x61, 0x6E, 0x65, 0x20, 0x70, 0x65, 0x72, 0x20, 0x62, 0x65, 0x72, 0x65, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x44, 0x6F, 0x63, 0x75, 0x6D, 0x65, 0x6E, 0x74, 0x69, 0x20, 0x70, 0x72, 0x65, 0x67, 0x6F,
	0x2E, 0x00, 0x53, 0x6F, 0x6E, 0x6F, 0x20, 0x69, 0x6C, 0x0A, 0x63, 0x6F, 0x72, 0x72, 0x69, 0x65,
	0x72, 0x65, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x68, 0x20, 0x62, 0x65, 0x6E, 0x65, 0x21, 0x20,
	0x45, 0x63, 0x63, 0x6F, 0x2C, 0x0A, 0x70, 0x6F, 0x72, 0x74, 0x61, 0x20, 0x69, 0x6C, 0x20, 0x70,
	0x61, 0x63, 0x63, 0x6F, 0x0A, 0x61, 0x6C, 0x6C, 0x27, 0x61, 0x67, 0x65, 0x6E, 0x7A, 0x69, 0x61,
	0x0A, 0x76, 0x69, 0x61, 0x67, 0x67, 0x69, 0x2E, 0x0B, 0x45, 0x20, 0x66, 0x61, 0x69, 0x20, 0x61,
	0x74, 0x74, 0x65, 0x6E, 0x7A, 0x69, 0x6F, 0x6E, 0x65, 0x0A, 0x5C, 0x20, 0x70, 0x72, 0x65, 0x7A,
	0x69, 0x6F, 0x73, 0x6F, 0x2E, 0x00, 0x54, 0x45, 0x4D, 0x50, 0x4F, 0x20, 0x53, 0x43, 0x41, 0x44,
	0x55, 0x54, 0x4F, 0x00, 0x43, 0x27, 0x5C, 0x20, 0x75, 0x6E, 0x61, 0x20, 0x66, 0x65, 0x73, 0x73,
	0x75, 0x72, 0x61, 0x0A, 0x70, 0x65, 0x72, 0x20, 0x6C, 0x61, 0x20, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x61, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x47, 0x72, 0x61, 0x7A, 0x69, 0x65, 0x2C, 0x20, 0x43, 0x6F,
	0x6E, 0x72, 0x61, 0x64, 0x2E, 0x0A, 0x51, 0x75, 0x65, 0x69, 0x20, 0x70, 0x6F, 0x6C, 0x69, 0x7A,
	0x69, 0x6F, 0x74, 0x74, 0x69, 0x0A, 0x6D, 0x69, 0x20, 0x73, 0x74, 0x61, 0x76, 0x61, 0x6E, 0x6F,
	0x20, 0x70, 0x65, 0x72, 0x0A, 0x73, 0x63, 0x6F, 0x70, 0x72, 0x69, 0x72, 0x65, 0x21, 0x0B, 0x42,
	0x65, 0x68, 0x2C, 0x20, 0x69, 0x6D, 0x6D, 0x61, 0x67, 0x69, 0x6E, 0x6F, 0x0A, 0x63, 0x68, 0x65,
	0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x74, 0x69, 0x0A, 0x72, 0x69, 0x63, 0x6F, 0x72, 0x64, 0x69, 0x20,
	0x64, 0x65, 0x6C, 0x20, 0x74, 0x75, 0x6F, 0x0A, 0x63, 0x61, 0x72, 0x6F, 0x20, 0x61, 0x6D, 0x69,
	0x63, 0x6F, 0x20, 0x49, 0x61, 0x6E, 0x2E, 0x0B, 0x53, 0x69, 0x65, 0x64, 0x69, 0x74, 0x69, 0x2C,
	0x0A, 0x72, 0x69, 0x73, 0x6F, 0x6C, 0x76, 0x65, 0x72, 0x65, 0x6D, 0x6F, 0x0A, 0x74, 0x75, 0x74,
	0x74, 0x6F, 0x20, 0x66, 0x72, 0x61, 0x20, 0x70, 0x6F, 0x63, 0x6F, 0x2E, 0x00, 0x49, 0x61, 0x6E,
	0x2C, 0x20, 0x63, 0x6F, 0x73, 0x61, 0x20, 0x64, 0x65, 0x76, 0x6F, 0x0A, 0x66, 0x61, 0x72, 0x65,
	0x20, 0x70, 0x65, 0x72, 0x20, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x65, 0x0A, 0x73, 0x75, 0x6C, 0x6C,
	0x61, 0x20, 0x54, 0x45, 0x52, 0x52, 0x41, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x49, 0x6C, 0x20, 0x63,
	0x6F, 0x73, 0x74, 0x6F, 0x20, 0x64, 0x69, 0x20, 0x75, 0x6E, 0x0A, 0x62, 0x69, 0x67, 0x6C, 0x69,
	0x65, 0x74, 0x74, 0x6F, 0x20, 0x5C, 0x0A, 0x61, 0x73, 0x74, 0x72, 0x6F, 0x6E, 0x6F, 0x6D, 0x69,
	0x63, 0x6F, 0x2E, 0x0B, 0x4C, 0x27, 0x75, 0x6E, 0x69, 0x63, 0x6F, 0x20, 0x6D, 0x6F, 0x64, 0x6F,
	0x0A, 0x73, 0x61, 0x72, 0x65, 0x62, 0x62, 0x65, 0x20, 0x71, 0x75, 0x65, 0x6C, 0x6C, 0x6F, 0x0A,
	0x64, 0x69, 0x20, 0x70, 0x61, 0x72, 0x74, 0x65, 0x63, 0x69, 0x70, 0x61, 0x72, 0x65, 0x20, 0x61,
	0x6C, 0x0A, 0x44, 0x65, 0x61, 0x74, 0x68, 0x20, 0x54, 0x6F, 0x77, 0x65, 0x72, 0x2E, 0x0B, 0xFF,
	0xE9, 0xEA, 0x44, 0x65, 0x61, 0x74, 0x68, 0x20, 0x54, 0x6F, 0x77, 0x65, 0x72, 0x3F, 0x0B, 0xFF,
	0xEB, 0xEC, 0x53, 0x69, 0x2C, 0x5C, 0x20, 0x75, 0x6E, 0x20, 0x67, 0x69, 0x6F, 0x63, 0x6F, 0x0A,
	0x74, 0x65, 0x6C, 0x65, 0x76, 0x69, 0x73, 0x69, 0x76, 0x6F, 0x2E, 0x20, 0x49, 0x6C, 0x0A, 0x76,
	0x69, 0x6E, 0x63, 0x69, 0x74, 0x6F, 0x72, 0x65, 0x20, 0x72, 0x69, 0x63, 0x65, 0x76, 0x65, 0x0A,
	0x75, 0x6E, 0x20, 0x62, 0x69, 0x67, 0x6C, 0x69, 0x65, 0x74, 0x74, 0x6F, 0x2E, 0x0B, 0xFF, 0xE9,
	0xEA, 0x4F, 0x2E, 0x6B, 0x2E, 0x20, 0x4D, 0x69, 0x20, 0x70, 0x75, 0x6F, 0x69, 0x0A, 0x66, 0x6F,
	0x72, 0x6E, 0x69, 0x72, 0x65, 0x20, 0x64, 0x65, 0x69, 0x0A, 0x64, 0x6F, 0x63, 0x75, 0x6D, 0x65,
	0x6E, 0x74, 0x69, 0x20, 0x66, 0x61, 0x6C, 0x73, 0x69, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F,
	0x20, 0x70, 0x72, 0x6F, 0x62, 0x6C, 0x65, 0x6D, 0x6F, 0x2E, 0x0A, 0x56, 0x61, 0x69, 0x20, 0x61,
	0x6C, 0x20, 0x62, 0x61, 0x72, 0x0A, 0x65, 0x20, 0x63, 0x68, 0x69, 0x65, 0x64, 0x69, 0x20, 0x64,
	0x69, 0x0A, 0x4A, 0x61, 0x63, 0x6B, 0x2E, 0x0B, 0x44, 0x69, 0x67, 0x6C, 0x69, 0x20, 0x63, 0x68,
	0x65, 0x20, 0x74, 0x69, 0x20, 0x68, 0x6F, 0x0A, 0x6D, 0x61, 0x6E, 0x64, 0x61, 0x74, 0x6F, 0x20,
	0x69, 0x6F, 0x2E, 0x0A, 0x4F, 0x68, 0x2C, 0x61, 0x20, 0x70, 0x72, 0x6F, 0x70, 0x6F, 0x73, 0x69,
	0x74, 0x6F, 0x2E, 0x2E, 0x0B, 0x54, 0x69, 0x20, 0x68, 0x6F, 0x20, 0x6D, 0x65, 0x73, 0x73, 0x6F,
	0x0A, 0x6E, 0x65, 0x6C, 0x6C, 0x65, 0x20, 0x74, 0x61, 0x73, 0x63, 0x68, 0x65, 0x20, 0x69, 0x6C,
	0x0A, 0x63, 0x61, 0x6D, 0x70, 0x6F, 0x20, 0x64, 0x69, 0x20, 0x66, 0x6F, 0x72, 0x7A, 0x61, 0x0A,
	0x63, 0x68, 0x65, 0x20, 0x76, 0x6F, 0x6C, 0x65, 0x76, 0x69, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x4F,
	0x74, 0x74, 0x69, 0x6D, 0x6F, 0x2E, 0x20, 0x47, 0x72, 0x61, 0x7A, 0x69, 0x65, 0x0A, 0x49, 0x61,
	0x6E, 0x2E, 0x20, 0x43, 0x69, 0x20, 0x76, 0x65, 0x64, 0x69, 0x61, 0x6D, 0x6F, 0x0A, 0x61, 0x6C,
	0x6C, 0x61, 0x20, 0x70, 0x72, 0x6F, 0x73, 0x73, 0x69, 0x6D, 0x61, 0x2E, 0x2E, 0x2E, 0x00, 0xFF,
	0xEB, 0xEC, 0x42, 0x75, 0x6F, 0x6E, 0x61, 0x20, 0x66, 0x6F, 0x72, 0x74, 0x75, 0x6E, 0x61, 0x2E,
	0x0A, 0x74, 0x69, 0x20, 0x63, 0x6F, 0x6E, 0x74, 0x61, 0x74, 0x74, 0x65, 0x72, 0x5E, 0x0A, 0x71,
	0x75, 0x61, 0x6E, 0x64, 0x6F, 0x20, 0x61, 0x72, 0x72, 0x69, 0x76, 0x65, 0x72, 0x61, 0x69, 0x0A,
	0x73, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x74, 0x65, 0x72, 0x72, 0x61, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x42, 0x65, 0x6E, 0x76, 0x65, 0x6E, 0x75, 0x74, 0x6F, 0x20, 0x61, 0x0A, 0x4E, 0x65, 0x77, 0x20,
	0x57, 0x61, 0x73, 0x68, 0x69, 0x6E, 0x67, 0x74, 0x6F, 0x6E, 0x2C, 0x0A, 0x67, 0x69, 0x6F, 0x76,
	0x61, 0x6E, 0x6F, 0x74, 0x74, 0x6F, 0x2E, 0x0B, 0x45, 0x63, 0x63, 0x6F, 0x20, 0x75, 0x6E, 0x61,
	0x20, 0x6D, 0x61, 0x70, 0x70, 0x61, 0x0A, 0x64, 0x65, 0x6C, 0x6C, 0x61, 0x20, 0x63, 0x69, 0x74,
	0x74, 0x5B, 0x20, 0x63, 0x68, 0x65, 0x0A, 0x70, 0x6F, 0x74, 0x72, 0x5B, 0x20, 0x65, 0x73, 0x73,
	0x65, 0x72, 0x74, 0x69, 0x0A, 0x75, 0x74, 0x69, 0x6C, 0x65, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x47,
	0x72, 0x61, 0x7A, 0x69, 0x65, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x42, 0x75, 0x6F, 0x6E, 0x61, 0x0A,
	0x67, 0x69, 0x6F, 0x72, 0x6E, 0x61, 0x74, 0x61, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x65, 0x76,
	0x69, 0x20, 0x61, 0x76, 0x65, 0x72, 0x65, 0x20, 0x75, 0x6E, 0x0A, 0x70, 0x65, 0x72, 0x6D, 0x65,
	0x73, 0x73, 0x6F, 0x20, 0x70, 0x65, 0x72, 0x0A, 0x6C, 0x61, 0x76, 0x6F, 0x72, 0x61, 0x72, 0x65,
	0x0B, 0x50, 0x75, 0x6F, 0x69, 0x20, 0x6F, 0x74, 0x74, 0x65, 0x6E, 0x65, 0x72, 0x6E, 0x65, 0x0A,
	0x75, 0x6E, 0x6F, 0x20, 0x61, 0x6C, 0x20, 0x43, 0x65, 0x6E, 0x74, 0x72, 0x6F, 0x0A, 0x41, 0x6D,
	0x6D, 0x69, 0x6E, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x76, 0x6F, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x4E, 0x6F, 0x6E, 0x20, 0x68, 0x6F, 0x0A, 0x74, 0x65, 0x6D, 0x70, 0x6F, 0x2E, 0x00, 0x42,
	0x75, 0x6F, 0x6E, 0x67, 0x69, 0x6F, 0x72, 0x6E, 0x6F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x75,
	0x6F, 0x6E, 0x67, 0x69, 0x6F, 0x72, 0x6E, 0x6F, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x48, 0x6F, 0x20,
	0x76, 0x69, 0x73, 0x74, 0x6F, 0x20, 0x71, 0x75, 0x65, 0x6C, 0x0A, 0x74, 0x69, 0x70, 0x6F, 0x20,
	0x70, 0x72, 0x69, 0x6D, 0x61, 0x0A, 0x61, 0x6C, 0x20, 0x62, 0x61, 0x72, 0x2E, 0x00, 0x42, 0x75,
	0x6F, 0x6E, 0x67, 0x69, 0x6F, 0x72, 0x6E, 0x6F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x75, 0x6F,
	0x6E, 0x67, 0x69, 0x6F, 0x72, 0x6E, 0x6F, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x53, 0x69, 0x2C, 0x20,
	0x6C, 0x6F, 0x20, 0x63, 0x6F, 0x6E, 0x6F, 0x73, 0x63, 0x6F, 0x2E, 0x0A, 0x45, 0x27, 0x20, 0x63,
	0x6C, 0x69, 0x65, 0x6E, 0x74, 0x65, 0x20, 0x66, 0x69, 0x73, 0x73, 0x6F, 0x00, 0x20, 0x00, 0x20,
	0x00, 0x56, 0x6F, 0x72, 0x72, 0x65, 0x69, 0x20, 0x75, 0x6E, 0x20, 0x70, 0x65, 0x72, 0x2D, 0x0A,
	0x6D, 0x65, 0x73, 0x73, 0x6F, 0x20, 0x64, 0x69, 0x20, 0x6C, 0x61, 0x76, 0x6F, 0x72, 0x6F, 0x2E,
	0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F, 0x6E, 0x20, 0x63, 0x27, 0x5C, 0x20, 0x70, 0x72, 0x6F, 0x62,
	0x6C, 0x65, 0x6D, 0x61, 0x0A, 0x61, 0x64, 0x20, 0x61, 0x76, 0x65, 0x72, 0x65, 0x20, 0x75, 0x6E,
	0x0A, 0x70, 0x65, 0x72, 0x6D, 0x65, 0x73, 0x73, 0x6F, 0x2E, 0x2E, 0x2E, 0x0B, 0x4C, 0x61, 0x20,
	0x73, 0x75, 0x61, 0x20, 0x63, 0x61, 0x72, 0x74, 0x61, 0x20, 0x64, 0x69, 0x0A, 0x69, 0x64, 0x65,
	0x6E, 0x74, 0x69, 0x74, 0x5B, 0x2C, 0x20, 0x70, 0x72, 0x65, 0x67, 0x6F, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x41, 0x49, 0x55, 0x54, 0x4F, 0x2E, 0x2E, 0x2E, 0x41, 0x49, 0x55, 0x54, 0x4F, 0x2E, 0x2E,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x41, 0x69, 0x75, 0x74, 0x61, 0x6D, 0x69, 0x20, 0x67, 0x69, 0x6F,
	0x76, 0x61, 0x6E, 0x65, 0x2E, 0x0A, 0x53, 0x6F, 0x6E, 0x6F, 0x20, 0x73, 0x74, 0x61, 0x74, 0x6F,
	0x0A, 0x61, 0x74, 0x74, 0x61, 0x63, 0x63, 0x61, 0x74, 0x6F, 0x20, 0x64, 0x61, 0x69, 0x0A, 0x6D,
	0x75, 0x74, 0x61, 0x6E, 0x74, 0x69, 0x2E, 0x2E, 0x2E, 0x0B, 0x65, 0x20, 0x6E, 0x6F, 0x6E, 0x20,
	0x70, 0x6F, 0x73, 0x73, 0x6F, 0x0A, 0x63, 0x61, 0x6D, 0x6D, 0x69, 0x6E, 0x61, 0x72, 0x65, 0x2E,
	0x0B, 0x54, 0x72, 0x6F, 0x76, 0x61, 0x20, 0x69, 0x6C, 0x20, 0x6D, 0x69, 0x6F, 0x0A, 0x74, 0x65,
	0x6C, 0x65, 0x74, 0x72, 0x61, 0x73, 0x70, 0x6F, 0x72, 0x74, 0x6F, 0x2C, 0x68, 0x6F, 0x0A, 0x62,
	0x69, 0x73, 0x6F, 0x67, 0x6E, 0x6F, 0x20, 0x64, 0x69, 0x0A, 0x63, 0x75, 0x72, 0x65, 0x20, 0x75,
	0x72, 0x67, 0x65, 0x6E, 0x74, 0x69, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x47, 0x72, 0x61, 0x7A, 0x69,
	0x65, 0x2E, 0x20, 0x4D, 0x69, 0x20, 0x68, 0x61, 0x69, 0x0A, 0x73, 0x61, 0x6C, 0x76, 0x61, 0x74,
	0x6F, 0x20, 0x6C, 0x61, 0x20, 0x76, 0x69, 0x74, 0x61, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x65,
	0x72, 0x20, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x65, 0x20, 0x61, 0x20, 0x4E, 0x65, 0x77, 0x0A, 0x57,
	0x61, 0x73, 0x68, 0x69, 0x6E, 0x67, 0x74, 0x6F, 0x6E, 0x2C, 0x20, 0x64, 0x65, 0x76, 0x69, 0x0A,
	0x73, 0x61, 0x6C, 0x74, 0x61, 0x72, 0x65, 0x20, 0x69, 0x6E, 0x0A, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x6F, 0x20, 0x62, 0x75, 0x63, 0x6F, 0x2C, 0x0B, 0x6D, 0x61, 0x20, 0x73, 0x65, 0x20, 0x66, 0x6F,
	0x73, 0x73, 0x69, 0x20, 0x69, 0x6E, 0x0A, 0x74, 0x65, 0x2C, 0x20, 0x75, 0x73, 0x65, 0x72, 0x65,
	0x69, 0x20, 0x75, 0x6E, 0x61, 0x0A, 0x63, 0x69, 0x6E, 0x74, 0x75, 0x72, 0x61, 0x20, 0x41, 0x6E,
	0x74, 0x69, 0x2D, 0x47, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x44, 0x6F, 0x76, 0x65, 0x20, 0x70, 0x6F,
	0x73, 0x73, 0x6F, 0x0A, 0x74, 0x72, 0x6F, 0x76, 0x61, 0x72, 0x6E, 0x65, 0x20, 0x75, 0x6E, 0x61,
	0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x53, 0x75, 0x62, 0x69, 0x74, 0x6F, 0x2C, 0x20, 0x74, 0x65, 0x20,
	0x6E, 0x65, 0x0A, 0x76, 0x65, 0x6E, 0x64, 0x6F, 0x20, 0x75, 0x6E, 0x61, 0x3A, 0x0A, 0x35, 0x30,
	0x30, 0x20, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x69, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x42, 0x75,
	0x6F, 0x6E, 0x20, 0x76, 0x69, 0x61, 0x67, 0x67, 0x69, 0x6F, 0x2C, 0x0A, 0x67, 0x69, 0x6F, 0x76,
	0x61, 0x6E, 0x65, 0x20, 0x75, 0x6F, 0x6D, 0x6F, 0x2E, 0x00, 0x48, 0x6F, 0x20, 0x62, 0x69, 0x73,
	0x6F, 0x67, 0x6E, 0x6F, 0x20, 0x64, 0x69, 0x0A, 0x75, 0x6E, 0x61, 0x20, 0x63, 0x61, 0x72, 0x74,
	0x75, 0x63, 0x63, 0x69, 0x61, 0x0A, 0x6D, 0x61, 0x67, 0x6E, 0x65, 0x74, 0x69, 0x63, 0x61, 0x20,
	0x63, 0x61, 0x72, 0x69, 0x63, 0x61, 0x00, 0x56, 0x6F, 0x72, 0x72, 0x65, 0x69, 0x20, 0x75, 0x6E,
	0x20, 0x70, 0x65, 0x72, 0x2D, 0x0A, 0x6D, 0x65, 0x73, 0x73, 0x6F, 0x20, 0x64, 0x69, 0x20, 0x6C,
	0x61, 0x76, 0x6F, 0x72, 0x6F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x50, 0x72, 0x69, 0x6D, 0x6F, 0x20,
	0x70, 0x69, 0x61, 0x6E, 0x6F, 0x2E, 0x00, 0x55, 0x6E, 0x61, 0x20, 0x76, 0x6F, 0x63, 0x65, 0x20,
	0x69, 0x6E, 0x74, 0x65, 0x2D, 0x0A, 0x72, 0x69, 0x6F, 0x72, 0x65, 0x20, 0x69, 0x6E, 0x74, 0x65,
	0x72, 0x72, 0x6F, 0x6D, 0x70, 0x65, 0x0A, 0x69, 0x20, 0x74, 0x75, 0x6F, 0x69, 0x20, 0x70, 0x65,
	0x6E, 0x73, 0x69, 0x65, 0x72, 0x69, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x46, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x2C, 0x20, 0x6D, 0x65, 0x74, 0x74, 0x69, 0x0A, 0x6C, 0x61, 0x20, 0x63, 0x61, 0x72, 0x69,
	0x63, 0x61, 0x0A, 0x61, 0x74, 0x6F, 0x6D, 0x69, 0x63, 0x61, 0x20, 0x71, 0x75, 0x69, 0x2E, 0x2E,
	0x2E, 0x0B, 0x65, 0x20, 0x73, 0x63, 0x61, 0x70, 0x70, 0x61, 0x20, 0x6E, 0x6F, 0x6E, 0x0A, 0x61,
	0x70, 0x70, 0x65, 0x6E, 0x61, 0x20, 0x72, 0x61, 0x67, 0x67, 0x69, 0x75, 0x6E, 0x67, 0x65, 0x0A,
	0x69, 0x6C, 0x20, 0x6E, 0x75, 0x63, 0x6C, 0x65, 0x6F, 0x0A, 0x64, 0x65, 0x6C, 0x20, 0x70, 0x69,
	0x61, 0x6E, 0x65, 0x74, 0x61, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x46, 0x61, 0x69, 0x20, 0x73, 0x74,
	0x72, 0x61, 0x64, 0x61, 0x2C, 0x0A, 0x67, 0x69, 0x6F, 0x76, 0x61, 0x6E, 0x65, 0x20, 0x75, 0x6F,
	0x6D, 0x6F, 0x2E, 0x0B, 0x50, 0x6F, 0x72, 0x74, 0x61, 0x6D, 0x69, 0x20, 0x61, 0x6C, 0x0A, 0x43,
	0x65, 0x6E, 0x74, 0x72, 0x6F, 0x20, 0x52, 0x69, 0x63, 0x65, 0x72, 0x63, 0x68, 0x65, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x47, 0x72, 0x61, 0x7A, 0x69, 0x65, 0x20, 0x70, 0x65, 0x72, 0x20, 0x69, 0x6C,
	0x0A, 0x74, 0x75, 0x6F, 0x20, 0x61, 0x69, 0x75, 0x74, 0x6F, 0x2E, 0x2E, 0x2E, 0x0B, 0x53, 0x6F,
	0x6E, 0x6F, 0x20, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61, 0x74, 0x6F, 0x0A, 0x73, 0x61, 0x6E, 0x6F,
	0x20, 0x65, 0x20, 0x73, 0x61, 0x6C, 0x76, 0x6F, 0x0A, 0x65, 0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x63,
	0x27, 0x5C, 0x20, 0x70, 0x69, 0x5F, 0x0A, 0x70, 0x65, 0x72, 0x69, 0x63, 0x6F, 0x6C, 0x6F, 0x2E,
	0x00, 0xFF, 0xEB, 0xEC, 0x41, 0x6C, 0x6C, 0x6F, 0x72, 0x61, 0x2C, 0x20, 0x68, 0x61, 0x69, 0x0A,
	0x70, 0x6F, 0x72, 0x74, 0x61, 0x74, 0x6F, 0x20, 0x69, 0x6C, 0x0A, 0x70, 0x61, 0x63, 0x63, 0x68,
	0x65, 0x74, 0x74, 0x6F, 0x3F, 0x00, 0x51, 0x75, 0x61, 0x6E, 0x74, 0x6F, 0x20, 0x63, 0x6F, 0x73,
	0x74, 0x61, 0x20, 0x75, 0x6E, 0x0A, 0x62, 0x69, 0x67, 0x6C, 0x69, 0x65, 0x74, 0x74, 0x6F, 0x20,
	0x70, 0x65, 0x72, 0x0A, 0x6C, 0x61, 0x20, 0x74, 0x65, 0x72, 0x72, 0x61, 0x3F, 0x0B, 0xFF, 0xEB,
	0xEC, 0x35, 0x30, 0x2E, 0x30, 0x30, 0x30, 0x20, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x69, 0x2E,
	0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x6F, 0x20, 0x64, 0x5E, 0x20, 0x75, 0x6E, 0x61, 0x20, 0x6D, 0x61,
	0x6E, 0x6F, 0x20, 0x61, 0x0A, 0x74, 0x65, 0x20, 0x65, 0x20, 0x74, 0x75, 0x20, 0x6E, 0x65, 0x20,
	0x64, 0x61, 0x69, 0x0A, 0x75, 0x6E, 0x61, 0x20, 0x61, 0x20, 0x6D, 0x65, 0x3A, 0x0B, 0x31, 0x35,
	0x30, 0x30, 0x20, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x69, 0x20, 0x65, 0x0A, 0x69, 0x20, 0x64,
	0x6F, 0x63, 0x75, 0x6D, 0x65, 0x6E, 0x74, 0x69, 0x0A, 0x73, 0x6F, 0x6E, 0x6F, 0x20, 0x74, 0x75,
	0x6F, 0x69, 0x2E, 0x00
};

const uint8_t LocaleData::_stringsTableJP[] = {
	0x5a, 0x00, 0x69, 0x00, 0x7d, 0x00, 0x58, 0x01, 0xce, 0x01, 0xe2, 0x01, 0x1a, 0x02, 0x3b, 0x02,
	0x85, 0x02, 0x98, 0x02, 0xc2, 0x02, 0xfb, 0x02, 0x2d, 0x03, 0x66, 0x03, 0xbf, 0x03, 0xdb, 0x03,
	0xec, 0x03, 0x47, 0x04, 0x54, 0x04, 0x68, 0x04, 0xc9, 0x04, 0x34, 0x06, 0x82, 0x06, 0x95, 0x06,
	0xd1, 0x06, 0xe2, 0x06, 0xf3, 0x06, 0x12, 0x07, 0x30, 0x07, 0x4b, 0x07, 0x4c, 0x07, 0x4d, 0x07,
	0x81, 0x07, 0x90, 0x07, 0x0a, 0x08, 0x2a, 0x08, 0xa4, 0x08, 0xb3, 0x08, 0xd4, 0x08, 0xfa, 0x08,
	0x66, 0x09, 0x8f, 0x09, 0xbf, 0x09, 0xd6, 0x09, 0xff, 0x09, 0xb0, 0xca, 0x2d, 0xa2, 0xcf, 0x60,
	0xcf, 0x20, 0x6e, 0x88, 0x6d, 0xcf, 0x5c, 0x83, 0x00, 0x80, 0x66, 0x92, 0x0a, 0x64, 0x84, 0x6d,
	0xcf, 0x93, 0x5d, 0x64, 0xcf, 0x62, 0x74, 0x67, 0xcf, 0x6a, 0xcf, 0x92, 0x00, 0xff, 0x01, 0x9a,
	0xbf, 0x60, 0xcf, 0x20, 0xa1, 0xcf, 0xc9, 0xcc, 0x9d, 0x6a, 0xcf, 0x92, 0x0a, 0xab, 0xa3, 0x73,
	0xaf, 0xd0, 0xa2, 0xb3, 0xd0, 0x2d, 0xa9, 0x60, 0xcf, 0x0a, 0x78, 0x66, 0x5c, 0x88, 0x6a, 0xcf,
	0x91, 0x6d, 0x3f, 0x0b, 0xff, 0x00, 0x5b, 0x5b, 0x92, 0x6d, 0xcf, 0x61, 0x83, 0x6a, 0xcf, 0x63,
	0x20, 0x74, 0x7e, 0x62, 0x6f, 0x92, 0x0b, 0xff, 0x01, 0x31, 0x35, 0x30, 0x30, 0x9d, 0xbf, 0xa1,
	0xcf, 0xcc, 0xa9, 0x6a, 0xcf, 0x6f, 0x21, 0x0b, 0xff, 0x00, 0x31, 0x35, 0x30, 0x30, 0x9d, 0xbf,
	0xa1, 0xcf, 0xcc, 0xa9, 0x6a, 0xcf, 0x91, 0x6d, 0x3f, 0x0b, 0xff, 0x01, 0x5b, 0x5b, 0x93, 0x6c,
	0x62, 0x83, 0x70, 0x74, 0x20, 0x5c, 0x85, 0x5c, 0x85, 0x0a, 0x6d, 0x79, 0x60, 0xcf, 0x20, 0x60,
	0x60, 0x91, 0x6d, 0x72, 0x2e, 0x2e, 0x2e, 0x92, 0x0b, 0xff, 0x00, 0x6a, 0xcf, 0x63, 0x6e, 0xcf,
	0x2e, 0x2e, 0x2e, 0x0a, 0x69, 0x88, 0x6f, 0x70, 0x20, 0x7d, 0x91, 0x6d, 0x6f, 0x5c, 0x68, 0xcf,
	0x2e, 0x2e, 0x2e, 0x92, 0x0b, 0xff, 0x01, 0x66, 0x90, 0x62, 0x61, 0xcf, 0x90, 0x5d, 0x0a, 0x5b,
	0x88, 0x6f, 0x5c, 0x66, 0xcf, 0x90, 0x70, 0x20, 0x5c, 0x63, 0x92, 0x0b, 0x69, 0x64, 0x6d, 0xcf,
	0x93, 0x66, 0x64, 0xcf, 0x6e, 0x87, 0x0a, 0x65, 0x60, 0xcf, 0x67, 0x88, 0x6a, 0xcf, 0x6f, 0x92,
	0x0b, 0x9b, 0xad, 0x60, 0xcf, 0x20, 0x6d, 0xcf, 0x61, 0x6d, 0x60, 0x81, 0x93, 0x0a, 0x6e, 0x82,
	0x75, 0x61, 0x20, 0x66, 0x80, 0x5d, 0x92, 0x00, 0xff, 0x01, 0xb9, 0xa7, 0x6f, 0x81, 0x20, 0x66,
	0x91, 0x6d, 0x83, 0x68, 0xcf, 0x92, 0x0a, 0x63, 0x5c, 0x66, 0xcf, 0x73, 0x20, 0x66, 0x82, 0x5b,
	0x5c, 0x60, 0xcf, 0x0a, 0x5c, 0x83, 0x88, 0x6a, 0xcf, 0x91, 0x6d, 0x80, 0x92, 0x0b, 0xff, 0x00,
	0x69, 0x73, 0x63, 0x5c, 0x66, 0xcf, 0x74, 0x93, 0x0a, 0x6e, 0xcf, 0x64, 0x70, 0x20, 0x5c, 0x83,
	0x88, 0x6a, 0xcf, 0x3f, 0x0b, 0xff, 0x01, 0x41, 0x52, 0x45, 0x41, 0x31, 0x70, 0x20, 0x5c, 0x91,
	0x6d, 0x7a, 0x6f, 0x92, 0x0a, 0x6a, 0x76, 0xcf, 0x88, 0x93, 0x69, 0x64, 0x6d, 0xcf, 0x0a, 0x74,
	0x6a, 0x81, 0x5c, 0x6d, 0x83, 0x68, 0xcf, 0x92, 0x0b, 0x61, 0x87, 0x6c, 0x63, 0x6f, 0x92, 0x0a,
	0xb9, 0xa7, 0x81, 0x74, 0x20, 0x61, 0x6a, 0x72, 0x8c, 0x60, 0x81, 0x6f, 0x92, 0x00, 0xff, 0x01,
	0x7d, 0x5d, 0x93, 0x69, 0x84, 0x5c, 0x66, 0xcf, 0x90, 0x5d, 0x0a, 0x66, 0x81, 0x72, 0x8c, 0x80,
	0x92, 0x00, 0xff, 0x01, 0xa0, 0x97, 0xb3, 0xcf, 0x2d, 0x9d, 0xcf, 0x32, 0x31, 0x60, 0xcf, 0x93,
	0x9c, 0xb5, 0x6e, 0x20, 0x0a, 0x6e, 0x82, 0x75, 0x61, 0x20, 0x66, 0x6a, 0x60, 0xcf, 0x91, 0x6d,
	0x5c, 0x83, 0x92, 0x0b, 0xaf, 0xcf, 0x2d, 0x73, 0x20, 0x5d, 0x81, 0x6d, 0xcf, 0x0a, 0x79, 0x91,
	0x6d, 0x5c, 0x83, 0x20, 0x69, 0x5d, 0x6a, 0xcf, 0x92, 0x00, 0xff, 0x01, 0xaf, 0xcf, 0x2d, 0x70,
	0x20, 0x5c, 0x61, 0x6f, 0x93, 0x0a, 0xa0, 0x97, 0xb3, 0xcf, 0x2d, 0x9d, 0xcf, 0x32, 0x31, 0x60,
	0xcf, 0x0a, 0x79, 0x91, 0x6d, 0x5c, 0x83, 0x68, 0xcf, 0x92, 0x00, 0xff, 0x01, 0x5d, 0x6c, 0x6f,
	0x21, 0x9a, 0xbf, 0x74, 0x93, 0x0a, 0xa0, 0x97, 0xb3, 0xcf, 0x2d, 0x9d, 0xcf, 0x32, 0x31, 0x66,
	0xcf, 0x8e, 0x6f, 0x5c, 0x21, 0x0b, 0xb9, 0xa7, 0x73, 0x20, 0x60, 0x62, 0x84, 0x60, 0xcf, 0x74,
	0x0a, 0x64, 0x73, 0x20, 0x66, 0x6a, 0x6a, 0xcf, 0x92, 0x0b, 0xb9, 0xa7, 0x73, 0x20, 0x6f, 0x60,
	0x79, 0x73, 0x20, 0x63, 0x5c, 0x66, 0xcf, 0x60, 0xcf, 0x0a, 0x9c, 0x2d, 0x87, 0x20, 0x7d, 0x91,
	0x6d, 0x5c, 0x83, 0x92, 0x00, 0xff, 0x01, 0x78, 0x60, 0x70, 0x74, 0x93, 0x0a, 0x6f, 0x70, 0x7d,
	0x20, 0x66, 0x81, 0x6f, 0x5c, 0x80, 0x92, 0x00, 0xff, 0x01, 0x66, 0x6c, 0x84, 0x5c, 0x6d, 0xcf,
	0x67, 0x60, 0xcf, 0x93, 0x0b, 0xa1, 0xcf, 0xc9, 0xcc, 0x9d, 0x6e, 0x5c, 0x5d, 0x20, 0x60, 0x6a,
	0x60, 0xcf, 0x0a, 0xaf, 0xcf, 0x2d, 0x6d, 0xcf, 0x20, 0x5b, 0x5c, 0x6a, 0x5c, 0x6e, 0x2e, 0x2e,
	0x2e, 0x00, 0x22, 0x61, 0x90, 0x60, 0x66, 0x90, 0x5d, 0x22, 0x60, 0xcf, 0x93, 0x0a, 0x78, 0x66,
	0x5c, 0x88, 0x6a, 0xcf, 0x60, 0xcf, 0x92, 0x0b, 0xff, 0x01, 0x64, 0x64, 0x74, 0x20, 0x6b, 0x60,
	0xcf, 0x5c, 0x79, 0x67, 0x92, 0x0a, 0x43, 0x73, 0x79, 0x6e, 0xcf, 0x62, 0xcf, 0x6b, 0x70, 0x93,
	0x0a, 0x5c, 0x91, 0x6d, 0x62, 0x6a, 0xcf, 0x65, 0x5c, 0x92, 0x00, 0x22, 0x61, 0x90, 0x60, 0x66,
	0x90, 0x5d, 0x22, 0x60, 0xcf, 0x93, 0x0a, 0x78, 0x66, 0x5c, 0x88, 0x6a, 0xcf, 0x60, 0xcf, 0x92,
	0x0b, 0xff, 0x01, 0x69, 0x84, 0x6d, 0xcf, 0x74, 0x2e, 0x2e, 0x2e, 0x0a, 0x66, 0x90, 0x6b, 0x90,
	0x5d, 0x70, 0x0a, 0x5b, 0x91, 0x6d, 0x62, 0x6a, 0xcf, 0x65, 0x5c, 0x92, 0x00, 0x22, 0x61, 0x90,
	0x60, 0x66, 0x90, 0x5d, 0x22, 0x60, 0xcf, 0x93, 0x0a, 0x78, 0x66, 0x5c, 0x88, 0x6a, 0xcf, 0x60,
	0xcf, 0x92, 0x0b, 0xff, 0x01, 0x64, 0x64, 0x74, 0x20, 0x6b, 0x60, 0xcf, 0x5c, 0x79, 0x67, 0x92,
	0x0a, 0x42, 0x73, 0x79, 0x6e, 0xcf, 0x62, 0xcf, 0x6b, 0x70, 0x93, 0x0a, 0x5c, 0x91, 0x6d, 0x62,
	0x6a, 0xcf, 0x65, 0x5c, 0x92, 0x00, 0xa1, 0xcf, 0xc9, 0xcc, 0x9d, 0x91, 0x6d, 0x20, 0xb9, 0xa7,
	0x74, 0x93, 0x0a, 0x5c, 0x83, 0x60, 0x5c, 0x3f, 0x0b, 0xff, 0x01, 0xa1, 0xcf, 0xc9, 0xcc, 0x9d,
	0x60, 0x3f, 0x0a, 0x64, 0x64, 0x70, 0x74, 0x20, 0x5c, 0x6f, 0x5c, 0x72, 0x92, 0x0b, 0xff, 0x00,
	0x97, 0x96, 0xc3, 0x60, 0x81, 0x0a, 0x61, 0x5c, 0x6d, 0x20, 0x61, 0x6a, 0x88, 0x6a, 0xcf, 0x60,
	0xcf, 0x92, 0x0b, 0xff, 0x01, 0x4f, 0x2e, 0x4b, 0x2e, 0x0a, 0xa1, 0xcf, 0xc9, 0xcc, 0x9d, 0x74,
	0x20, 0x69, 0x6e, 0x6d, 0xcf, 0x0a, 0x79, 0x91, 0x6d, 0x5c, 0x83, 0x68, 0xcf, 0x92, 0x00, 0xff,
	0x01, 0x66, 0xcf, 0x8e, 0x79, 0x6a, 0xcf, 0x92, 0x0a, 0x9b, 0xcf, 0x9c, 0x70, 0x20, 0x73, 0x79,
	0x68, 0x83, 0x0a, 0x65, 0x63, 0x74, 0x72, 0x8c, 0x80, 0x92, 0x00, 0xff, 0x01, 0xaf, 0xd0, 0xa2,
	0xb3, 0xd0, 0x2d, 0xa9, 0x87, 0x20, 0x6a, 0xcf, 0x66, 0x6d, 0x92, 0x00, 0x6c, 0x60, 0x5c, 0x73,
	0x20, 0x7d, 0x73, 0x6a, 0xcf, 0x60, 0xcf, 0x92, 0x0b, 0xff, 0x01, 0x69, 0x5d, 0x6d, 0xcf, 0x67,
	0x60, 0x21, 0x0a, 0x6d, 0xcf, 0x74, 0x93, 0x64, 0x64, 0x70, 0x5b, 0x83, 0x20, 0x64, 0x6c, 0xcf,
	0x6c, 0x7a, 0x87, 0x0a, 0x96, 0xb1, 0xbd, 0x9b, 0x66, 0x6d, 0x88, 0x70, 0x0a, 0x7d, 0x91, 0x6d,
	0x5c, 0x91, 0x6d, 0x20, 0x62, 0x6a, 0xcf, 0x65, 0x5c, 0x92, 0x0b, 0x61, 0x87, 0x6c, 0x63, 0x6d,
	0x20, 0x62, 0x6a, 0xcf, 0x65, 0x5c, 0x72, 0x93, 0x0a, 0x64, 0x5d, 0x60, 0x6f, 0x7d, 0x73, 0x20,
	0x6d, 0xcf, 0x67, 0x60, 0x81, 0x92, 0x00, 0xa5, 0x97, 0xb6, 0x9a, 0x2d, 0xaf, 0xcf, 0x2d, 0x6d,
	0xcf, 0x67, 0x92, 0x00, 0x9b, 0x2d, 0xa9, 0xcf, 0x73, 0x0a, 0x65, 0x66, 0x64, 0x7a, 0x62, 0xcf,
	0x6b, 0x60, 0xcf, 0x20, 0x5b, 0x83, 0x92, 0x00, 0xff, 0x01, 0x6a, 0x67, 0x60, 0x91, 0x6a, 0x93,
	0x9f, 0xc3, 0xbc, 0xcc, 0xa9, 0xcf, 0x92, 0x0a, 0xb9, 0xa7, 0x81, 0x70, 0x20, 0x6c, 0x83, 0x66,
	0x5b, 0x63, 0xcf, 0x81, 0x84, 0x83, 0x0a, 0x6e, 0x64, 0x85, 0x6a, 0xcf, 0x91, 0x6a, 0x68, 0xcf,
	0x92, 0x0b, 0x5b, 0x91, 0x93, 0x69, 0x91, 0x60, 0x92, 0x9a, 0xbf, 0x73, 0x64, 0x6e, 0x74, 0x0a,
	0x24, 0x78, 0xcf, 0x5e, 0x6d, 0x20, 0x5c, 0x6f, 0x5c, 0x88, 0x6a, 0xcf, 0x91, 0x6a, 0x6f, 0x92,
	0x0b, 0x79, 0x89, 0x20, 0x67, 0x86, 0x84, 0x80, 0x92, 0x0a, 0x6d, 0x7a, 0x66, 0xcf, 0x60, 0x70,
	0x20, 0x24, 0x86, 0x81, 0x68, 0x80, 0x5d, 0x92, 0x00, 0x97, 0x96, 0xc3, 0x93, 0x0a, 0x6b, 0x61,
	0x8f, 0x5d, 0x70, 0x20, 0x60, 0x5e, 0x83, 0x70, 0x74, 0x93, 0x0a, 0x6e, 0xcf, 0x5d, 0x66, 0x6a,
	0x81, 0x20, 0x5c, 0x5c, 0x88, 0x6a, 0xcf, 0x3f, 0x0b, 0xff, 0x01, 0x6b, 0x61, 0x8f, 0x5d, 0x5c,
	0x61, 0x73, 0x20, 0xa6, 0x9e, 0xcc, 0xa9, 0x74, 0x0a, 0x74, 0xcf, 0x60, 0x20, 0x6a, 0x60, 0x5c,
	0x60, 0x81, 0x6f, 0x92, 0x0b, 0x69, 0x5d, 0x6a, 0xcf, 0x6f, 0x2e, 0x2e, 0x2e, 0x0a, 0x78, 0x5d,
	0x78, 0x5d, 0x74, 0x20, 0x6a, 0x6a, 0xcf, 0x75, 0x6e, 0x6c, 0x93, 0x0a, 0xa8, 0xcf, 0xa2, 0xa5,
	0xc1, 0x2d, 0x70, 0x0a, 0x6b, 0x90, 0x5d, 0x68, 0x88, 0x66, 0x85, 0x80, 0x92, 0x0b, 0xff, 0x00,
	0xa8, 0xcf, 0xa2, 0xa5, 0xc1, 0x2d, 0x3f, 0x0b, 0xff, 0x01, 0x69, 0x5d, 0x93, 0x0a, 0xa8, 0xbf,
	0xb0, 0xcf, 0x73, 0x20, 0x9e, 0xcf, 0x2d, 0xb6, 0xa1, 0xcb, 0x2d, 0x6a, 0xcf, 0x92, 0x0a, 0x9e,
	0xcf, 0x2d, 0xb6, 0x70, 0x20, 0x60, 0x6d, 0x74, 0xcf, 0x93, 0x0a, 0xa6, 0x9e, 0xcc, 0xa9, 0x60,
	0xcf, 0x20, 0x6d, 0x70, 0x74, 0x5c, 0x83, 0x92, 0x0b, 0xff, 0x00, 0x86, 0x60, 0x91, 0x6a, 0x80,
	0x92, 0x0a, 0x70, 0x68, 0x73, 0x20, 0xaf, 0xd0, 0xa2, 0xb3, 0xd0, 0x2d, 0xa9, 0x87, 0x0a, 0x6c,
	0x62, 0x84, 0x83, 0x60, 0x5c, 0x3f, 0x0b, 0xff, 0x01, 0x7d, 0x6b, 0x85, 0x88, 0x65, 0x92, 0x0a,
	0xaf, 0xcf, 0x2d, 0x70, 0x20, 0xa1, 0xcf, 0xc9, 0xcc, 0x9d, 0x6e, 0x5c, 0x5d, 0x0a, 0xb9, 0xa7,
	0x60, 0xcf, 0x5c, 0x83, 0x92, 0x0a, 0x69, 0x5c, 0x6c, 0x70, 0x20, 0x61, 0x62, 0x6e, 0x5c, 0x5c,
	0x92, 0x0b, 0x9a, 0xbf, 0x70, 0x20, 0x61, 0x5c, 0x6a, 0x6e, 0x20, 0x5c, 0x5e, 0x74, 0xcf, 0x5c,
	0x5c, 0x92, 0x0a, 0x6e, 0x64, 0x85, 0x6d, 0xcf, 0x2e, 0x2e, 0x2e, 0x0b, 0x6a, 0x73, 0x79, 0x84,
	0x6d, 0x5c, 0x6a, 0x0a, 0xb1, 0xc8, 0x2d, 0xa2, 0xb1, 0xc5, 0x2d, 0xbe, 0xa9, 0xcf, 0x87, 0x93,
	0x0a, 0x9c, 0xb5, 0x73, 0x20, 0xb3, 0xd0, 0x9e, 0xcc, 0xa9, 0x70, 0x0a, 0x5c, 0x84, 0x6d, 0x20,
	0x24, 0x5c, 0x6a, 0x60, 0x81, 0x6f, 0x92, 0x0b, 0xff, 0x00, 0x69, 0x5d, 0x60, 0x93, 0x5b, 0x82,
	0x60, 0xcf, 0x6e, 0x5d, 0x92, 0x0a, 0x97, 0x96, 0xc3, 0x93, 0x79, 0x6a, 0x5b, 0x24, 0x5d, 0x2e,
	0x2e, 0x2e, 0x0b, 0xff, 0x01, 0x60, 0xcf, 0x88, 0x74, 0xcf, 0x84, 0x80, 0x92, 0x0a, 0x6b, 0x61,
	0x8f, 0x5d, 0x70, 0x20, 0x6c, 0x5c, 0x6a, 0x81, 0x0a, 0x84, 0x88, 0x81, 0x62, 0x20, 0x66, 0x6d,
	0x62, 0x84, 0x92, 0x00, 0xff, 0x01, 0xab, 0xca, 0x2d, 0xc1, 0xa1, 0xc3, 0xa9, 0xc3, 0x77, 0x0a,
	0x80, 0x5d, 0x64, 0x69, 0x20, 0x5c, 0x81, 0x91, 0x66, 0x8e, 0x5c, 0x79, 0x66, 0x6a, 0x92, 0x0b,
	0x64, 0x73, 0x6b, 0x67, 0xcf, 0x87, 0x20, 0x6e, 0xcf, 0x5d, 0x69, 0xcf, 0x92, 0x0a, 0x5c, 0x61,
	0x6a, 0x5c, 0x20, 0x74, 0xcf, 0x66, 0x90, 0x60, 0xcf, 0x93, 0x0a, 0x67, 0x62, 0xcf, 0x70, 0x20,
	0x86, 0x60, 0x82, 0x79, 0x67, 0x80, 0x92, 0x0b, 0xff, 0x00, 0x5b, 0x82, 0x60, 0xcf, 0x6e, 0x5d,
	0x92, 0x00, 0xff, 0x01, 0x61, 0x87, 0x6c, 0x63, 0x6d, 0x93, 0x0a, 0x5c, 0x91, 0x6d, 0x81, 0x91,
	0x66, 0x8e, 0x5c, 0x92, 0x00, 0xff, 0x01, 0x74, 0x6a, 0x81, 0x62, 0x73, 0x6f, 0x81, 0x0a, 0x61,
	0x90, 0x60, 0x60, 0xcf, 0x20, 0x75, 0x6c, 0x80, 0x5d, 0x6a, 0xcf, 0x92, 0x0b, 0x66, 0x90, 0x62,
	0x61, 0xcf, 0x90, 0x5d, 0x20, 0x5b, 0x88, 0x6f, 0x5c, 0x66, 0xcf, 0x90, 0x73, 0x0a, 0x22, 0x61,
	0x90, 0x60, 0x66, 0x90, 0x5d, 0x22, 0x74, 0x0a, 0x7d, 0x91, 0x6d, 0x5c, 0x79, 0x67, 0x60, 0x3f,
	0x00, 0xff, 0x01, 0x74, 0x6f, 0x66, 0x6d, 0x5c, 0x83, 0x20, 0xb0, 0xb4, 0x74, 0x6f, 0x5c, 0x80,
	0x92, 0x00, 0x7e, 0x89, 0x93, 0x24, 0x74, 0x80, 0x5d, 0x92, 0x0b, 0xff, 0x01, 0x24, 0x74, 0x80,
	0x5d, 0x92, 0x00, 0xff, 0x01, 0x69, 0x5c, 0x6c, 0x6f, 0x81, 0x93, 0x0a, 0x79, 0x5e, 0x70, 0x20,
	0xaf, 0xcf, 0x2d, 0x6d, 0xcf, 0x0a, 0x7a, 0x6a, 0x64, 0x6e, 0x60, 0xcf, 0x20, 0x5b, 0x83, 0x80,
	0x92, 0x00, 0x5c, 0x5c, 0x6d, 0x88, 0x61, 0x6d, 0xcf, 0x67, 0x72, 0x92, 0x0b, 0xff, 0x01, 0x79,
	0x91, 0x6a, 0x62, 0x6a, 0xcf, 0x93, 0x74, 0x84, 0x74, 0xcf, 0x84, 0x67, 0x83, 0x80, 0x92, 0x00,
	0xff, 0x01, 0x69, 0x5c, 0x6c, 0x6f, 0x81, 0x20, 0x66, 0x91, 0x6d, 0x83, 0x68, 0xcf, 0x93, 0x0a,
	0x80, 0x62, 0x7a, 0x83, 0x20, 0xb9, 0xa7, 0x6a, 0xcf, 0x92, 0x00, 0x00, 0x00, 0x22, 0x61, 0x90,
	0x60, 0x66, 0x90, 0x5d, 0x22, 0x60, 0xcf, 0x93, 0x0a, 0x78, 0x66, 0x5c, 0x88, 0x6a, 0xcf, 0x60,
	0xcf, 0x92, 0x0b, 0xff, 0x01, 0x5c, 0x5c, 0x6d, 0xcf, 0x67, 0x80, 0x92, 0x0a, 0x49, 0x44, 0x9b,
	0x2d, 0xa9, 0xcf, 0x87, 0x93, 0x0a, 0x7a, 0x68, 0x6d, 0x20, 0x62, 0x6a, 0xcf, 0x65, 0x5c, 0x92,
	0x00, 0xff, 0x01, 0x6a, 0x2e, 0x2e, 0x6a, 0x67, 0x63, 0x6d, 0x62, 0x84, 0x2e, 0x2e, 0x2e, 0x00,
	0xff, 0x01, 0x24, 0x86, 0x60, 0x5c, 0x73, 0x20, 0x6a, 0x67, 0x63, 0x6d, 0x62, 0x84, 0x88, 0x60,
	0x92, 0x0a, 0x86, 0x66, 0x74, 0x93, 0x0a, 0xb5, 0xca, 0x2d, 0xa5, 0xc3, 0xa9, 0x70, 0x20, 0x7e,
	0x81, 0x84, 0x6d, 0x2e, 0x2e, 0x2e, 0x0b, 0x5b, 0x83, 0x63, 0x6f, 0x62, 0x20, 0x6f, 0x91, 0x6d,
	0x93, 0x0a, 0x66, 0x79, 0x91, 0x6a, 0x88, 0x66, 0xcf, 0x8e, 0x92, 0x0b, 0x67, 0x62, 0xcf, 0x70,
	0x20, 0x5c, 0x66, 0x8e, 0x73, 0x20, 0x6d, 0x5b, 0x6d, 0x60, 0xcf, 0x93, 0x0a, 0x75, 0x6c, 0x80,
	0x5d, 0x20, 0x6f, 0x88, 0x66, 0xcf, 0x8e, 0x60, 0xcf, 0x93, 0x0a, 0x6e, 0xcf, 0x5d, 0x60, 0x20,
	0x86, 0x66, 0x73, 0xa8, 0xbf, 0xb3, 0xd0, 0x2d, 0xa5, 0x2d, 0x87, 0x0a, 0x65, 0x60, 0xcf, 0x66,
	0x6d, 0x74, 0x20, 0x62, 0x84, 0x88, 0x60, 0x72, 0x92, 0x00, 0xff, 0x01, 0x5b, 0x82, 0x60, 0xcf,
	0x6e, 0x5d, 0x92, 0x0a, 0x5b, 0x88, 0x6a, 0x74, 0x20, 0x5c, 0x73, 0x6b, 0x73, 0x0a, 0x24, 0x88,
	0x66, 0xcf, 0x88, 0x20, 0x66, 0xcf, 0x8e, 0x80, 0x92, 0x00, 0xff, 0x01, 0x64, 0x73, 0x5b, 0x6f,
	0x70, 0x20, 0x6e, 0x75, 0xcf, 0x64, 0x79, 0x6f, 0x63, 0x84, 0x74, 0xcf, 0x0a, 0xab, 0xca, 0x2d,
	0xc1, 0xa1, 0xc3, 0xa9, 0xc3, 0x70, 0x74, 0x0a, 0x5c, 0x63, 0x88, 0x73, 0x66, 0xcf, 0x8e, 0x92,
	0x0b, 0x79, 0x89, 0x93, 0x86, 0x66, 0x6f, 0x81, 0x0a, 0x96, 0xc3, 0xa6, 0x47, 0xb2, 0xcf, 0xbe,
	0xa9, 0x87, 0x0a, 0x6c, 0x60, 0x5d, 0x60, 0xcf, 0x73, 0x92, 0x0b, 0xff, 0x00, 0x69, 0x84, 0x74,
	0x20, 0x6e, 0xcf, 0x64, 0x70, 0x5b, 0x83, 0x88, 0x6a, 0xcf, 0x5c, 0x3f, 0x0b, 0xff, 0x01, 0x5c,
	0x79, 0x93, 0x86, 0x66, 0x60, 0xcf, 0x20, 0x7d, 0x91, 0x6e, 0x83, 0x92, 0x0a, 0x31, 0x6c, 0x20,
	0x35, 0x30, 0x30, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x6d, 0xcf, 0x0a, 0x6e, 0xcf, 0x5d, 0x66,
	0xcf, 0x8e, 0x92, 0x00, 0xff, 0x01, 0x86, 0x60, 0x5c, 0x73, 0x20, 0x61, 0x87, 0x6c, 0x63, 0x6d,
	0x6f, 0x21, 0x00, 0x66, 0xcf, 0x8f, 0x5d, 0x6d, 0xcf, 0x88, 0x67, 0xcf, 0x7a, 0x73, 0x0a, 0x9b,
	0x2d, 0xa9, 0xbd, 0xcc, 0xa1, 0xcf, 0x9c, 0x2d, 0x60, 0xcf, 0x0a, 0x75, 0x6c, 0x80, 0x5d, 0x6d,
	0xcf, 0x67, 0x92, 0x00, 0x22, 0x61, 0x90, 0x60, 0x66, 0x90, 0x5d, 0x22, 0x60, 0xcf, 0x93, 0x0a,
	0x78, 0x66, 0x5c, 0x88, 0x6a, 0xcf, 0x60, 0xcf, 0x92, 0x0b, 0xff, 0x01, 0x5d, 0x5e, 0x77, 0x20,
	0x5c, 0x91, 0x6d, 0x62, 0x6a, 0xcf, 0x65, 0x5c, 0x92, 0x00, 0x6f, 0x70, 0x7d, 0x73, 0x60, 0x73,
	0x20, 0x64, 0x5e, 0x60, 0xcf, 0x93, 0x0a, 0x61, 0x7a, 0x73, 0x20, 0x64, 0x64, 0x85, 0x70, 0x0a,
	0x60, 0x6a, 0x82, 0x60, 0x63, 0x6d, 0x62, 0x83, 0x92, 0x0b, 0xff, 0x01, 0x86, 0x6a, 0x66, 0x87,
	0x20, 0x66, 0x88, 0x66, 0xcf, 0x6d, 0x93, 0x64, 0x64, 0x70, 0x0a, 0x96, 0xa9, 0xb5, 0xcc, 0x9d,
	0xa6, 0xc9, 0x2d, 0xa1, 0xcf, 0x87, 0x0a, 0x24, 0x62, 0x73, 0x6a, 0xcf, 0xcd, 0xcd, 0xcd, 0x0b,
	0x69, 0x66, 0x6d, 0x93, 0x69, 0x84, 0x60, 0xcf, 0x0a, 0x86, 0x62, 0x68, 0x5c, 0x73, 0x20, 0x60,
	0x62, 0x70, 0x20, 0x24, 0x6b, 0x6a, 0x81, 0x93, 0x0a, 0x67, 0x62, 0xcf, 0x20, 0x70, 0x63, 0xcf,
	0x6d, 0x62, 0x84, 0x21, 0x21, 0x00, 0xff, 0x01, 0x61, 0x7a, 0x60, 0xcf, 0x93, 0x6c, 0x84, 0x6d,
	0x5c, 0x91, 0x6d, 0x0a, 0x62, 0x84, 0x83, 0x73, 0x60, 0x92, 0x0b, 0xbd, 0xa0, 0x2d, 0xa6, 0xa3,
	0xc3, 0xa5, 0x2d, 0x79, 0x6d, 0xcf, 0x93, 0x0a, 0x6a, 0x73, 0x7b, 0x69, 0xcf, 0x92, 0x00, 0xff,
	0x01, 0x5b, 0x82, 0x60, 0xcf, 0x6e, 0x5d, 0x92, 0x6a, 0x67, 0x60, 0x91, 0x6a, 0x80, 0x92, 0x0b,
	0x76, 0xcf, 0x66, 0xcf, 0x70, 0x20, 0x6a, 0x6e, 0xcf, 0x82, 0x6c, 0x63, 0x6a, 0x92, 0x0a, 0x64,
	0x64, 0x74, 0x20, 0x7d, 0x5d, 0x93, 0x5b, 0x88, 0x68, 0xcf, 0x88, 0x6a, 0xcf, 0x92, 0x00, 0xff,
	0x01, 0x64, 0x6c, 0xcf, 0x6c, 0x7a, 0x87, 0x93, 0x0a, 0x7d, 0x91, 0x6d, 0x61, 0x6d, 0x20, 0x62,
	0x84, 0x6a, 0x73, 0x60, 0x3f, 0x00, 0x6b, 0x61, 0x8f, 0x5d, 0x79, 0x6d, 0xcf, 0x73, 0x0a, 0xa6,
	0x9e, 0xcc, 0xa9, 0x74, 0x20, 0x5c, 0x62, 0x81, 0x6a, 0xcf, 0x5c, 0x3f, 0x0b, 0xff, 0x01, 0x35,
	0x30, 0x30, 0x30, 0x30, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x6d, 0xcf, 0x67, 0x92, 0x00, 0xff,
	0x01, 0x24, 0x6a, 0x60, 0xcf, 0x5c, 0x65, 0x79, 0x20, 0x6a, 0xcf, 0x6f, 0x92, 0x0b, 0x31, 0x35,
	0x30, 0x30, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x87, 0x0a, 0x5c, 0x6a, 0x6a, 0xcf, 0x64, 0x5d,
	0x60, 0x92, 0x0b, 0x61, 0xcf, 0x69, 0xcf, 0x5d, 0xaf, 0xd0, 0xa2, 0xb3, 0xd0, 0x2d, 0xa9, 0x74,
	0x0a, 0x61, 0x7a, 0x73, 0x20, 0x7d, 0x73, 0x6a, 0xcf, 0x92, 0x00
};

const char *LocaleData::_textsTableFR[LocaleData::LI_NUM] = {
	"CONTINUER OU ABANDONNER ?",
	"TEMPS",
	"CONTINUER",
	"ABANDONNER",
	"TERMINEE",
	"NIVEAU",
	"START",
	"DIFFICULTE",
	"MOT DE PASSE",
	"INFO",
	"QUITTER",
	"NIVEAU DE DIFFICULTE :",
	"FACILE",
	"NORMAL",
	"EXPERT",
	"ENTREZ LE MOT DE PASSE POUR",
	"ACCEDER AU NIVEAU SOUHAITE:",
	"REPRENDRE",
	"ABANDONNER",
	"CHARGER",
	"SAUVEGARDER",
	"PARTIE",
	"DEMO"
};

const char *LocaleData::_textsTableEN[LocaleData::LI_NUM] = {
	"CONTINUE OR ABORT THIS GAME ?",
	"TIME",
	"CONTINUE",
	"ABORT",
	"COMPLETED",
	"LEVEL",
	"START",
	"SKILL",
	"PASSWORD",
	"INFO",
	"QUIT",
	"SKILL LEVEL :",
	"EASY",
	"NORMAL",
	"EXPERT",
	"Enter password for desired",
	"level :",
	"RESUME GAME",
	"ABORT GAME",
	"LOAD GAME",
	"SAVE GAME",
	"SLOT",
	"DEMO"
};

const char *LocaleData::_textsTableDE[LocaleData::LI_NUM] = {
	"WEITERSPIELEN ODER ABBRECHEN ?",
	"ZEIT : ",
	"WEITERSPIELEN",
	"ABBRECHEN",
	"FERTIG",
	"LEVEL",
	"START",
	"SKILL",
	"PASSWORD",
	"INFO",
	"END",
	"SKILL LEVEL :",
	"LEICHT",
	"NORMAL",
	"PROFI",
	"GEBEN SIE DAS PASSWORT F[R",
	"DAS GEW[NSCHTE LEVEL EIN :",
	"WEITERSPIELEN",
	"SPIEL ABBRECHEN",
	"LADEN",
	"SPEICHERN",
	"SPIEL",
	"DEMO"
};

const char *LocaleData::_textsTableSP[LocaleData::LI_NUM] = {
	"CONTINUAR O TERMINAR JUEGO ?",
	"TIEMPO",
	"SEGUIR",
	"PARAR",
	"PUNTOS",
	"NIVEL",
	"EMPEZAR",
	"DIFICULTAD",
	"CONTRASE}A",
	"INFO",
	"SALIR",
	"NIVEL DE DIFICULTAD :",
	"SENCILLO",
	"NORMAL",
	"EXPERTO",
	"ESCRIBA LA CONTRASE}A",
	"PARA EL NIVEL DESEADO :",
	"REANUDAR JUEGO",
	"PARAR JUEGO",
	"CARGAR DATOS",
	"GUARDAR DATOS",
	"JUEGO",
	"DEMO"
};

const char *LocaleData::_textsTableIT[LocaleData::LI_NUM] = {
	"CONTINUA O ABBANDONA GIOCO",
	"TEMPO",
	"CONTINUA",
	"ESCI",
	"ABBANDONA",
	"LIVELLO",
	"INIZIO",
	"ABILITA",
	"PASSWORD",
	"INFORMAZIONI",
	"ESCI",
	"LIVELLO ABILITA :",
	"FACILE",
	"NORMAL",
	"EXPERTO",
	"INSERISCI LA PASSWORD PER",
	"IL LIVELLO DESIDERATO :",
	"RIPRENDI GIOCO",
	"ESCI DAL GIOCO",
	"CARICA IL GIOCO",
	"SALVA IL GIOCO",
	"SLOT",
	"DEMO"
};

const uint8_t LocaleData::_level1TbnJP[] = {
	0x2e, 0x00, 0x2f, 0x00, 0x35, 0x00, 0x3d, 0x00, 0x48, 0x00, 0x52, 0x00, 0x56, 0x00, 0x5e, 0x00,
	0x64, 0x00, 0x72, 0x00, 0x7a, 0x00, 0x7f, 0x00, 0x85, 0x00, 0x8f, 0x00, 0x98, 0x00, 0xa1, 0x00,
	0xab, 0x00, 0xb5, 0x00, 0xbd, 0x00, 0xc4, 0x00, 0xce, 0x00, 0xd4, 0x00, 0xdd, 0x00, 0x00, 0xb0,
	0xa2, 0xa9, 0xae, 0xbf, 0x00, 0xb3, 0xc0, 0x9c, 0xca, 0x2d, 0xb1, 0xcf, 0x00, 0x9b, 0x2d, 0xa9,
	0xbd, 0xcc, 0xa1, 0xcf, 0xc0, 0xcc, 0x9d, 0x00, 0x9b, 0x2d, 0xa9, 0xbd, 0xcc, 0xa1, 0xcf, 0x9c,
	0x2d, 0x00, 0x64, 0x5c, 0x66, 0x00, 0xa8, 0xbf, 0xb3, 0xd0, 0x2d, 0xa5, 0x2d, 0x00, 0x9c, 0x2d,
	0xc0, 0xcc, 0x9d, 0x00, 0x99, 0xad, 0xbe, 0x9c, 0xcf, 0x2d, 0xa6, 0xc9, 0x2d, 0xa1, 0xcf, 0xc9,
	0x2d, 0x00, 0x9d, 0xbd, 0xa2, 0xa5, 0xbe, 0x9c, 0x2d, 0x00, 0xa2, 0x97, 0xcc, 0xa6, 0x00, 0xa1,
	0x2d, 0xbe, 0xa9, 0xcf, 0x00, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x9e, 0x2d, 0xa2, 0x00, 0x31,
	0x30, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x00, 0x35, 0x30, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9,
	0x00, 0x35, 0x30, 0x30, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x00, 0x31, 0x30, 0x30, 0x9d, 0xbf,
	0xa1, 0xcf, 0xcc, 0xa9, 0x00, 0x9b, 0x2d, 0xa9, 0xcf, 0xc0, 0xcc, 0x9d, 0x00, 0x49, 0x44, 0x9b,
	0x2d, 0xa9, 0xcf, 0x00, 0xa3, 0x2d, 0xb1, 0xcf, 0xa2, 0xa5, 0xc3, 0xa9, 0xcf, 0x00, 0x85, 0x5d,
	0x66, 0xcf, 0x88, 0x00, 0x96, 0xc3, 0xa6, 0x47, 0xb2, 0xcf, 0xbe, 0xa9, 0x00, 0x63, 0x60, 0xcf,
	0x70, 0x88, 0x00
};

const uint8_t LocaleData::_level2TbnJP[] = {
	0x4c, 0x00, 0x4d, 0x00, 0x53, 0x00, 0x5a, 0x00, 0x60, 0x00, 0x6e, 0x00, 0x72, 0x00, 0x78, 0x00,
	0x7d, 0x00, 0x85, 0x00, 0x8a, 0x00, 0x94, 0x00, 0x9f, 0x00, 0xa9, 0x00, 0xb2, 0x00, 0xbf, 0x00,
	0xc7, 0x00, 0xcf, 0x00, 0xd7, 0x00, 0xdd, 0x00, 0xe3, 0x00, 0xe9, 0x00, 0xf1, 0x00, 0xf7, 0x00,
	0xfb, 0x00, 0x05, 0x01, 0x0a, 0x01, 0x10, 0x01, 0x18, 0x01, 0x1d, 0x01, 0x22, 0x01, 0x26, 0x01,
	0x30, 0x01, 0x38, 0x01, 0x41, 0x01, 0x4b, 0x01, 0x56, 0x01, 0x5a, 0x01, 0x00, 0xb0, 0xa2, 0xa9,
	0xae, 0xbf, 0x00, 0x49, 0x44, 0x9b, 0x2d, 0xa9, 0xcf, 0x00, 0xa1, 0x2d, 0xbe, 0xa9, 0xcf, 0x00,
	0x99, 0xad, 0xbe, 0x9c, 0xcf, 0x2d, 0xa6, 0xc9, 0x2d, 0xa1, 0xcf, 0xc9, 0x2d, 0x00, 0x97, 0x96,
	0xc3, 0x00, 0xb0, 0xca, 0x2d, 0xa2, 0xcf, 0x00, 0xa2, 0x97, 0xcc, 0xa6, 0x00, 0xaf, 0xd0, 0xa2,
	0xb3, 0xd0, 0x2d, 0xa9, 0x00, 0xb3, 0xcf, 0x2d, 0x97, 0x00, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9,
	0x9e, 0x2d, 0xa2, 0x00, 0x66, 0xcf, 0x76, 0xcf, 0x88, 0x73, 0x66, 0x8e, 0x66, 0x88, 0x00, 0x97,
	0xc3, 0xa2, 0xa5, 0xc3, 0xa9, 0xb1, 0xc8, 0xa9, 0x00, 0x6c, 0x5d, 0x66, 0x88, 0xb8, 0xab, 0xa5,
	0x2d, 0x00, 0x85, 0x5d, 0x6e, 0xcf, 0x5d, 0x20, 0x61, 0x90, 0x60, 0x66, 0x90, 0x5d, 0x00, 0x79,
	0x6e, 0xcf, 0x62, 0xcf, 0x6b, 0x41, 0x00, 0x79, 0x6e, 0xcf, 0x62, 0xcf, 0x6b, 0x42, 0x00, 0x79,
	0x6e, 0xcf, 0x62, 0xcf, 0x6b, 0x43, 0x00, 0x66, 0x90, 0x6b, 0x90, 0x5d, 0x00, 0xaf, 0xcf, 0x2d,
	0xa8, 0xc3, 0x00, 0xa1, 0xcf, 0xc9, 0xcc, 0x9d, 0x00, 0x9d, 0xbd, 0xa2, 0xa5, 0xbe, 0x9c, 0x2d,
	0x00, 0x9c, 0x2d, 0xc0, 0xcc, 0x9d, 0x00, 0x64, 0x5c, 0x66, 0x00, 0x31, 0x30, 0x30, 0x9d, 0xbf,
	0xa1, 0xcf, 0xcc, 0xa9, 0x00, 0x5d, 0x63, 0x6c, 0x63, 0x00, 0x64, 0x6c, 0xcf, 0x6c, 0x7a, 0x00,
	0xb8, 0xc3, 0xa5, 0x2d, 0xa1, 0xcf, 0xca, 0x00, 0x63, 0x5c, 0x66, 0xcf, 0x00, 0x9e, 0xb5, 0x9b,
	0xbe, 0x00, 0x56, 0x49, 0x50, 0x00, 0xa3, 0x2d, 0xb1, 0xcf, 0xa2, 0xa5, 0xc3, 0xa9, 0xcf, 0x00,
	0x73, 0x64, 0x82, 0x66, 0xcf, 0x60, 0x88, 0x00, 0x68, 0x5c, 0x61, 0xcf, 0x90, 0x69, 0x5d, 0x6b,
	0x00, 0x68, 0x5c, 0x61, 0xcf, 0x90, 0x61, 0x74, 0xcf, 0x88, 0x00, 0xb1, 0xc8, 0x2d, 0xa2, 0xb1,
	0xc5, 0x2d, 0xbe, 0xa9, 0xcf, 0x00, 0xa1, 0x2d, 0xa9, 0x00, 0xb4, 0xcc, 0xb1, 0xd0, 0x00
};

const uint8_t LocaleData::_level3TbnJP[] = {
	0x10, 0x00, 0x11, 0x00, 0x17, 0x00, 0x1d, 0x00, 0x27, 0x00, 0x32, 0x00, 0x37, 0x00, 0x41, 0x00,
	0x00, 0xb0, 0xa2, 0xa9, 0xae, 0xbf, 0x00, 0xa1, 0x2d, 0xbe, 0xa9, 0xcf, 0x00, 0x9d, 0xbf, 0xa1,
	0xcf, 0xcc, 0xa9, 0x9e, 0x2d, 0xa2, 0x00, 0xb1, 0xc8, 0x2d, 0xa2, 0xb1, 0xc5, 0x2d, 0xbe, 0xa9,
	0xcf, 0x00, 0xa2, 0x97, 0xcc, 0xa6, 0x00, 0xa3, 0x2d, 0xb1, 0xcf, 0xa2, 0xa5, 0xc3, 0xa9, 0xcf,
	0x00, 0x99, 0xad, 0xbe, 0x9c, 0xcf, 0x2d, 0xa6, 0xc9, 0x2d, 0xa1, 0xcf, 0xc9, 0x2d, 0x00
};

const uint8_t LocaleData::_level41TbnJP[] = {
	0x1a, 0x00, 0x1b, 0x00, 0x21, 0x00, 0x27, 0x00, 0x31, 0x00, 0x3c, 0x00, 0x44, 0x00, 0x49, 0x00,
	0x4f, 0x00, 0x57, 0x00, 0x5c, 0x00, 0x66, 0x00, 0x74, 0x00, 0x00, 0xb0, 0xa2, 0xa9, 0xae, 0xbf,
	0x00, 0xa1, 0x2d, 0xbe, 0xa9, 0xcf, 0x00, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x9e, 0x2d, 0xa2,
	0x00, 0xb1, 0xc8, 0x2d, 0xa2, 0xb1, 0xc5, 0x2d, 0xbe, 0xa9, 0xcf, 0x00, 0xaf, 0xd0, 0xa2, 0xb3,
	0xd0, 0x2d, 0xa9, 0x00, 0xb3, 0xcf, 0x2d, 0x97, 0x00, 0x9c, 0x2d, 0xc0, 0xcc, 0x9d, 0x00, 0x9d,
	0xbd, 0xa2, 0xa5, 0xbe, 0x9c, 0x2d, 0x00, 0xa2, 0x97, 0xcc, 0xa6, 0x00, 0xa3, 0x2d, 0xb1, 0xcf,
	0xa2, 0xa5, 0xc3, 0xa9, 0xcf, 0x00, 0x99, 0xad, 0xbe, 0x9c, 0xcf, 0x2d, 0xa6, 0xc9, 0x2d, 0xa1,
	0xcf, 0xc9, 0x2d, 0x00, 0xa5, 0x9d, 0xa1, 0x2d, 0xa2, 0xa8, 0x2d, 0xa1, 0xcb, 0xc3, 0x00
};

const uint8_t LocaleData::_level42TbnJP[] = {
	0x18, 0x00, 0x19, 0x00, 0x1f, 0x00, 0x25, 0x00, 0x2f, 0x00, 0x3a, 0x00, 0x42, 0x00, 0x48, 0x00,
	0x4d, 0x00, 0x55, 0x00, 0x5d, 0x00, 0x67, 0x00, 0x00, 0xb0, 0xa2, 0xa9, 0xae, 0xbf, 0x00, 0xa1,
	0x2d, 0xbe, 0xa9, 0xcf, 0x00, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x9e, 0x2d, 0xa2, 0x00, 0xb1,
	0xc8, 0x2d, 0xa2, 0xb1, 0xc5, 0x2d, 0xbe, 0xa9, 0xcf, 0x00, 0x9d, 0xbd, 0xa2, 0xa5, 0xbe, 0x9c,
	0x2d, 0x00, 0x9c, 0x2d, 0xc0, 0xcc, 0x9d, 0x00, 0xa2, 0x97, 0xcc, 0xa6, 0x00, 0xa8, 0xbf, 0xb3,
	0xd0, 0x2d, 0xa5, 0x2d, 0x00, 0xa8, 0xbf, 0xa1, 0x2d, 0xaf, 0xcf, 0x2d, 0x00, 0xa3, 0x2d, 0xb1,
	0xcf, 0xa2, 0xa5, 0xc3, 0xa9, 0xcf, 0x00, 0x99, 0xad, 0xbe, 0x9c, 0xcf, 0x2d, 0xa6, 0xc9, 0x2d,
	0xa1, 0xcf, 0xc9, 0x2d, 0x00
};

const uint8_t LocaleData::_level51TbnJP[] = {
	0x22, 0x00, 0x23, 0x00, 0x29, 0x00, 0x30, 0x00, 0x36, 0x00, 0x40, 0x00, 0x45, 0x00, 0x53, 0x00,
	0x57, 0x00, 0x60, 0x00, 0x68, 0x00, 0x70, 0x00, 0x78, 0x00, 0x83, 0x00, 0x8d, 0x00, 0x93, 0x00,
	0x9e, 0x00, 0x00, 0xb0, 0xa2, 0xa9, 0xae, 0xbf, 0x00, 0x49, 0x44, 0x9b, 0x2d, 0xa9, 0xcf, 0x00,
	0xa1, 0x2d, 0xbe, 0xa9, 0xcf, 0x00, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x9e, 0x2d, 0xa2, 0x00,
	0xa2, 0x97, 0xcc, 0xa6, 0x00, 0x99, 0xad, 0xbe, 0x9c, 0xcf, 0x2d, 0xa6, 0xc9, 0x2d, 0xa1, 0xcf,
	0xc9, 0x2d, 0x00, 0x64, 0x5c, 0x66, 0x00, 0xb7, 0x9b, 0xab, 0x9b, 0xbe, 0xb4, 0x98, 0xa2, 0x00,
	0x9d, 0xbd, 0xa2, 0xa5, 0xbe, 0x9c, 0x2d, 0x00, 0xa8, 0xbf, 0xb3, 0xd0, 0x2d, 0xa5, 0x2d, 0x00,
	0xa8, 0xbf, 0xa1, 0x2d, 0xaf, 0xcf, 0x2d, 0x00, 0x96, 0xa9, 0xb5, 0xcc, 0x9d, 0xa6, 0xc9, 0x2d,
	0xa1, 0xcf, 0x00, 0xa3, 0x2d, 0xb1, 0xcf, 0xa2, 0xa5, 0xc3, 0xa9, 0xcf, 0x00, 0x9c, 0x2d, 0xc0,
	0xcc, 0x9d, 0x00, 0xa5, 0xcf, 0x97, 0x96, 0xbd, 0x2d, 0xba, 0xab, 0xcc, 0xa9, 0x00, 0xb1, 0xc8,
	0x2d, 0xa2, 0xb1, 0xc5, 0x2d, 0xbe, 0xa9, 0xcf, 0x00
};

const uint8_t LocaleData::_level52TbnJP[] = {
	0x22, 0x00, 0x23, 0x00, 0x29, 0x00, 0x30, 0x00, 0x36, 0x00, 0x40, 0x00, 0x4e, 0x00, 0x53, 0x00,
	0x5a, 0x00, 0x60, 0x00, 0x68, 0x00, 0x71, 0x00, 0x79, 0x00, 0x81, 0x00, 0x8c, 0x00, 0x96, 0x00,
	0xa1, 0x00, 0x00, 0xb0, 0xa2, 0xa9, 0xae, 0xbf, 0x00, 0x49, 0x44, 0x9b, 0x2d, 0xa9, 0xcf, 0x00,
	0xa1, 0x2d, 0xbe, 0xa9, 0xcf, 0x00, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x9e, 0x2d, 0xa2, 0x00,
	0x99, 0xad, 0xbe, 0x9c, 0xcf, 0x2d, 0xa6, 0xc9, 0x2d, 0xa1, 0xcf, 0xc9, 0x2d, 0x00, 0xa2, 0x97,
	0xcc, 0xa6, 0x00, 0xb4, 0x98, 0xa2, 0xb3, 0xcf, 0xb6, 0x00, 0x9c, 0x2d, 0xc0, 0xcc, 0x9d, 0x00,
	0x9d, 0xbd, 0xa2, 0xa5, 0xbe, 0x9c, 0x2d, 0x00, 0xb7, 0x9b, 0xab, 0x9b, 0xbe, 0xb4, 0x98, 0xa2,
	0x00, 0xa8, 0xbf, 0xb3, 0xd0, 0x2d, 0xa5, 0x2d, 0x00, 0xa8, 0xbf, 0xa1, 0x2d, 0xaf, 0xcf, 0x2d,
	0x00, 0x96, 0xa9, 0xb5, 0xcc, 0x9d, 0xa6, 0xc9, 0x2d, 0xa1, 0xcf, 0x00, 0xa3, 0x2d, 0xb1, 0xcf,
	0xa2, 0xa5, 0xc3, 0xa9, 0xcf, 0x00, 0xb1, 0xc8, 0x2d, 0xa2, 0xb1, 0xc5, 0x2d, 0xbe, 0xa9, 0xcf,
	0x00, 0xa5, 0xcf, 0x97, 0x96, 0xbd, 0x2d, 0xba, 0xab, 0xcc, 0xa9, 0x00
};

const uint8_t LocaleData::_cineBinJP[] = {
	0x00, 0x00, 0x00, 0x23, 0x00, 0x54, 0x00, 0x8e, 0x00, 0xc0, 0x00, 0xcb, 0x00, 0xd3, 0x00, 0xdd,
	0x00, 0xe4, 0x00, 0xe8, 0x00, 0xf1, 0x00, 0xfe, 0x01, 0x41, 0x01, 0x4b, 0x01, 0x54, 0x01, 0x63,
	0x01, 0x95, 0x01, 0xae, 0x01, 0xb8, 0x01, 0xc2, 0x01, 0xcc, 0x02, 0x01, 0x02, 0x43, 0x02, 0x6e,
	0x02, 0x79, 0x02, 0x83, 0x02, 0x95, 0x02, 0xb4, 0x02, 0xf1, 0x03, 0x48, 0x03, 0x75, 0x03, 0x80,
	0x03, 0x89, 0x03, 0x96, 0x03, 0xe7, 0x04, 0x02, 0x04, 0x0c, 0x04, 0x1f, 0x04, 0x5c, 0x04, 0x9f,
	0x04, 0xc8, 0x05, 0x03, 0x05, 0x41, 0x05, 0x5e, 0x05, 0x7d, 0x05, 0xa3, 0x05, 0xc1, 0x05, 0xde,
	0x05, 0xf7, 0x06, 0x10, 0x06, 0x23, 0x06, 0x30, 0x06, 0x46, 0x06, 0x4b, 0x06, 0x51, 0x06, 0x5a,
	0x06, 0x73, 0x06, 0x81, 0x06, 0xb9, 0x06, 0xca, 0x06, 0xec, 0x07, 0x06, 0x07, 0x34, 0x07, 0x4f,
	0x07, 0x58, 0x07, 0x60, 0x07, 0x7c, 0x07, 0x8f, 0x07, 0xbf, 0x07, 0xf9, 0x08, 0x2a, 0x08, 0x34,
	0x08, 0x8b, 0x08, 0x95, 0x08, 0xd0, 0x08, 0xda, 0x09, 0x33, 0x09, 0x3d, 0x09, 0x80, 0x09, 0x8a,
	0x09, 0xe3, 0x09, 0xed, 0x0a, 0x33, 0x0a, 0x98, 0x0a, 0xa2, 0x0a, 0xe2, 0x0b, 0x08, 0x0b, 0x13,
	0x0b, 0x5e, 0x0b, 0x8d, 0x0b, 0x9f, 0x0b, 0xa2, 0x0b, 0xa5, 0x0b, 0xa8, 0x0b, 0xab, 0x0b, 0xae,
	0x0b, 0xb1, 0x0b, 0xb4, 0x0b, 0xb7, 0x0b, 0xba, 0x0b, 0xbd, 0x0b, 0xc0, 0x0b, 0xc3, 0x0b, 0xc6,
	0x0b, 0xc9, 0x0b, 0xcc, 0x0b, 0xcf, 0x0b, 0xd2, 0x0b, 0xe4, 0x0c, 0x2f, 0x0c, 0x3c, 0x0c, 0x42,
	0x0c, 0x46, 0x0c, 0x4a, 0x0c, 0x4e, 0x0c, 0x52, 0x0c, 0x56, 0x0c, 0x5d
};

const uint8_t LocaleData::_cineTxtJP[] = {
	0x64, 0x84, 0x60, 0xcf, 0x93, 0x86, 0x6a, 0x66, 0x60, 0xcf, 0x20, 0x60, 0x6c, 0x6d, 0x20, 0x63,
	0x5c, 0x63, 0x88, 0x66, 0x6a, 0x93, 0xd1, 0x7d, 0x73, 0x60, 0xcf, 0x6a, 0x82, 0x6d, 0xcf, 0x5b,
	0x83, 0x92, 0x0a, 0x64, 0x73, 0x76, 0x72, 0x73, 0x20, 0xaa, 0xb0, 0xcf, 0x9e, 0xcf, 0x2d, 0xa1,
	0xcb, 0xc3, 0xd1, 0xa1, 0xa2, 0xa8, 0xb6, 0x74, 0x93, 0x64, 0x73, 0x61, 0xcf, 0x88, 0x60, 0xcf,
	0x73, 0x20, 0x6b, 0x67, 0xcf, 0x87, 0xd1, 0x61, 0x24, 0x62, 0x66, 0x6d, 0x20, 0x5c, 0x6f, 0x60,
	0x91, 0x6a, 0x92, 0x0a, 0x86, 0x6a, 0x66, 0x60, 0xcf, 0x93, 0x6b, 0x61, 0x8f, 0x5d, 0x73, 0x20,
	0x61, 0x6e, 0xcf, 0x5d, 0x70, 0xd1, 0x7d, 0x6e, 0xcf, 0x83, 0x64, 0x6e, 0x87, 0x20, 0x5c, 0x79,
	0x60, 0x81, 0x20, 0x63, 0x5c, 0x65, 0x88, 0xd1, 0x67, 0x83, 0x73, 0x74, 0x20, 0x6e, 0x5d, 0x6d,
	0x5c, 0x20, 0x76, 0x60, 0x73, 0x5d, 0x6f, 0xd1, 0x64, 0x6e, 0x6a, 0xcf, 0x92, 0x0a, 0x6a, 0x76,
	0xcf, 0x88, 0x93, 0x64, 0x84, 0x60, 0x81, 0x65, 0x61, 0x7d, 0x20, 0x67, 0xcf, 0x91, 0x6e, 0x93,
	0x6f, 0x60, 0xcf, 0x5c, 0x5b, 0x5c, 0x6a, 0xcf, 0xd1, 0x5d, 0x6b, 0x8f, 0x5d, 0x87, 0x20, 0x65,
	0x67, 0x81, 0x5d, 0x64, 0x6e, 0x70, 0x20, 0x6f, 0x83, 0x73, 0x6a, 0xcf, 0x85, 0x5d, 0x92, 0x0a,
	0xb1, 0xc4, 0x97, 0xbe, 0xaa, 0xc3, 0xaf, 0xcf, 0x2d, 0x3b, 0x0a, 0x20, 0x5c, 0x81, 0x5c, 0x70,
	0x88, 0x3b, 0x0a, 0x66, 0x64, 0xcf, 0x6e, 0x6f, 0x5c, 0x80, 0x5d, 0x3b, 0x0a, 0x78, 0x5d, 0x66,
	0x8f, 0x5d, 0x3b, 0x0a, 0xb7, 0xb8, 0x3b, 0x0a, 0x34, 0x33, 0x32, 0x34, 0x58, 0x42, 0x33, 0x35,
	0x0a, 0xa5, 0x97, 0xa5, 0xc3, 0xa2, 0xb2, 0xd0, 0x2d, 0xa2, 0xbc, 0x97, 0xc3, 0x0a, 0x64, 0x6c,
	0xcf, 0x6c, 0x7a, 0x87, 0x20, 0xa5, 0x97, 0xa5, 0xc3, 0xa9, 0xbc, 0xb2, 0xcf, 0xbe, 0x20, 0x96,
	0xa1, 0xcf, 0x96, 0x66, 0x6d, 0x88, 0x6d, 0xcf, 0xd1, 0x5d, 0x63, 0x6e, 0x82, 0x93, 0x69, 0x84,
	0x87, 0x20, 0xa5, 0x97, 0xa5, 0xc3, 0xa9, 0xbc, 0xb2, 0xcf, 0xbe, 0x20, 0x96, 0xb1, 0xbd, 0x9b,
	0x66, 0x6d, 0x88, 0x79, 0x6d, 0xcf, 0xd1, 0x74, 0x64, 0x88, 0x6d, 0xcf, 0x78, 0x66, 0x5c, 0x92,
	0x0a, 0x31, 0x30, 0x30, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x0a, 0x34, 0x33, 0x32, 0x34, 0x58,
	0x42, 0x34, 0x30, 0x0a, 0xaf, 0xcf, 0x97, 0xa5, 0xbe, 0x9f, 0x2d, 0xb3, 0xd0, 0xbf, 0x2d, 0xa1,
	0xcb, 0xc3, 0x0a, 0x56, 0x49, 0x50, 0x87, 0x20, 0xbd, 0xa0, 0x2d, 0xa6, 0xa3, 0xc3, 0xa5, 0x2d,
	0x79, 0x6d, 0xcf, 0x20, 0x68, 0x88, 0x6e, 0xcf, 0x5d, 0x66, 0x6d, 0x20, 0x78, 0x66, 0x5c, 0x92,
	0xd1, 0x56, 0x49, 0x50, 0x74, 0x20, 0x41, 0x52, 0x45, 0x41, 0x32, 0x6d, 0xcf, 0x20, 0x79, 0x91,
	0x6d, 0x5c, 0x83, 0x92, 0x0a, 0x41, 0x52, 0x45, 0x41, 0x32, 0x74, 0x20, 0x61, 0x63, 0x88, 0x6a,
	0xcf, 0x93, 0x76, 0xcf, 0x61, 0x87, 0x7d, 0x91, 0x6d, 0x5c, 0x63, 0x80, 0x92, 0x0a, 0x33, 0x30,
	0x30, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x0a, 0x34, 0x33, 0x33, 0x34, 0x4b, 0x52, 0x34, 0x32,
	0xd1, 0x0a, 0xa5, 0x97, 0xa5, 0xc3, 0xa8, 0xbf, 0xb0, 0xcf, 0xd1, 0x0a, 0xa0, 0x97, 0xb3, 0xcf,
	0x2d, 0x9d, 0xcf, 0x32, 0x31, 0x73, 0x20, 0x76, 0x62, 0x68, 0x5c, 0x61, 0x60, 0xcf, 0x93, 0x70,
	0x63, 0xcf, 0x6a, 0x92, 0xd1, 0x24, 0x69, 0x81, 0x62, 0x93, 0x60, 0xcf, 0x5c, 0x76, 0xcf, 0x70,
	0x20, 0x6f, 0x60, 0x79, 0x60, 0xcf, 0x20, 0x5c, 0x83, 0x74, 0x67, 0xcf, 0x6a, 0xcf, 0x92, 0xd1,
	0x0a, 0x61, 0x7a, 0x73, 0x20, 0x70, 0x88, 0x7b, 0x74, 0x93, 0xa0, 0x97, 0xb3, 0xcf, 0x2d, 0x9d,
	0xcf, 0x32, 0x31, 0x73, 0x20, 0xaf, 0xcf, 0x97, 0x9a, 0xd1, 0x9f, 0xc3, 0xb0, 0xd0, 0xca, 0x2d,
	0xa5, 0x60, 0xcf, 0x20, 0x98, 0xc5, 0xbe, 0xa2, 0x70, 0x20, 0x66, 0x74, 0x5c, 0x65, 0x84, 0x83,
	0x20, 0x79, 0x5e, 0x70, 0x93, 0xd1, 0x79, 0x91, 0x65, 0x6c, 0x67, 0x83, 0x20, 0x64, 0x6e, 0x6a,
	0xcf, 0x92, 0x0a, 0x64, 0x84, 0x60, 0xcf, 0x20, 0xa0, 0x97, 0xb3, 0xcf, 0x2d, 0x9d, 0xcf, 0x32,
	0x31, 0x73, 0x20, 0x66, 0x8e, 0x66, 0x88, 0x6a, 0xcf, 0x92, 0xd1, 0x61, 0x87, 0x6c, 0x63, 0x85,
	0x93, 0x6d, 0x64, 0xcf, 0x86, 0x5c, 0x20, 0x5b, 0x5c, 0x6d, 0x6a, 0xcf, 0x92, 0x0a, 0x34, 0x30,
	0x30, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0xd1, 0x0a, 0x34, 0x33, 0x33, 0x54, 0x58, 0x31, 0x30,
	0x32, 0xd1, 0x0a, 0xa5, 0x97, 0xa5, 0xc3, 0x20, 0x66, 0x7d, 0x88, 0x20, 0x61, 0x90, 0x5d, 0x61,
	0xcf, 0x60, 0x5c, 0xd1, 0x0a, 0xab, 0xca, 0x2d, 0xc1, 0xa1, 0xc3, 0xa9, 0xc3, 0x73, 0x20, 0x74,
	0x6c, 0x6d, 0xcf, 0x88, 0x61, 0x60, 0xcf, 0x20, 0x64, 0x66, 0x90, 0x5d, 0x20, 0x66, 0x6d, 0x5c,
	0x83, 0x92, 0xd1, 0x0a, 0x60, 0x88, 0x82, 0x70, 0x88, 0x74, 0x93, 0xb7, 0x97, 0xc3, 0x9f, 0xc3,
	0xb0, 0xd0, 0xca, 0x2d, 0xa5, 0x2d, 0x73, 0x6f, 0x60, 0x73, 0x20, 0x33, 0x79, 0x5c, 0x73, 0xd1,
	0x68, 0x5c, 0x61, 0xcf, 0x90, 0x61, 0x74, 0xcf, 0x88, 0x60, 0xcf, 0x20, 0x6e, 0x82, 0x60, 0x5e,
	0x81, 0x84, 0x6d, 0x5c, 0x6a, 0x20, 0x64, 0x6e, 0x70, 0xd1, 0x61, 0x6c, 0xcf, 0x5c, 0x6a, 0x92,
	0x0a, 0x61, 0x7a, 0x73, 0x70, 0x88, 0x7b, 0x74, 0x93, 0x69, 0x73, 0xb3, 0xcf, 0x2d, 0xa9, 0xcf,
	0x87, 0x20, 0x6e, 0x82, 0x60, 0x5e, 0x83, 0x64, 0x6e, 0x6a, 0xcf, 0x92, 0xd1, 0x66, 0x60, 0x66,
	0x93, 0x68, 0x5c, 0x63, 0xcf, 0x88, 0x66, 0xcf, 0x60, 0x88, 0x74, 0x20, 0x31, 0x76, 0xd0, 0x88,
	0x33, 0x30, 0x75, 0xcf, 0x90, 0x5d, 0x6a, 0xcf, 0x92, 0xd1, 0x69, 0x84, 0x87, 0x20, 0x67, 0x61,
	0xcf, 0x83, 0x6e, 0x93, 0x74, 0x6c, 0x6d, 0xcf, 0x88, 0x61, 0x74, 0x20, 0x66, 0xcf, 0x74, 0xcf,
	0x62, 0x66, 0x6d, 0x66, 0x79, 0x5d, 0x92, 0x0a, 0x66, 0x6a, 0x73, 0x60, 0x5c, 0x73, 0x20, 0xa8,
	0xbf, 0xb3, 0xd0, 0x2d, 0xa9, 0x60, 0xcf, 0x93, 0x7d, 0x88, 0x6a, 0xcf, 0x5c, 0x73, 0x20, 0x74,
	0xcf, 0x66, 0x90, 0x77, 0xd1, 0x6c, 0x84, 0x6d, 0x5c, 0x91, 0x6d, 0x20, 0x62, 0x84, 0x83, 0x6a,
	0xcf, 0x85, 0x5d, 0x92, 0x0a, 0x35, 0x30, 0x30, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0xd1, 0x0a,
	0x34, 0x33, 0x34, 0x54, 0x58, 0x31, 0x30, 0x33, 0x0a, 0xab, 0xca, 0x2d, 0xc1, 0xa1, 0xc3, 0xa9,
	0xc3, 0xa1, 0xa8, 0xc5, 0x2d, 0x0a, 0x64, 0x88, 0x7e, 0x93, 0x41, 0x52, 0x45, 0x41, 0x33, 0x60,
	0xcf, 0x20, 0xb5, 0xca, 0x2d, 0xa5, 0xc3, 0xa9, 0x70, 0x20, 0x80, 0x91, 0x6d, 0xd1, 0x66, 0x88,
	0x82, 0x8e, 0x62, 0x65, 0x84, 0x6a, 0x92, 0x86, 0x84, 0x86, 0x84, 0x74, 0x93, 0xb5, 0xca, 0x2d,
	0xa5, 0xc3, 0xa9, 0x60, 0xcf, 0x20, 0x75, 0x6e, 0x75, 0xcf, 0x6e, 0x70, 0xd1, 0x64, 0x5d, 0x63,
	0xcf, 0x61, 0x20, 0x67, 0x83, 0x73, 0x6d, 0xcf, 0x74, 0x20, 0x6f, 0x5c, 0x60, 0x6e, 0x20, 0x24,
	0x69, 0x84, 0x6d, 0x5c, 0x83, 0x92, 0x0a, 0x61, 0x7a, 0x73, 0x70, 0x88, 0x7b, 0x74, 0x93, 0xb5,
	0xca, 0x2d, 0xa5, 0xc3, 0xa9, 0x87, 0x20, 0x66, 0x79, 0x6c, 0x67, 0x83, 0x64, 0x6e, 0x6a, 0xcf,
	0x92, 0x0a, 0x36, 0x30, 0x30, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x0a, 0x9a, 0xbf, 0x60, 0xcf,
	0x93, 0x5d, 0x6c, 0x91, 0x6d, 0x83, 0x66, 0xcf, 0x8e, 0x6f, 0x5c, 0x60, 0x21, 0x3f, 0x0a, 0x7e,
	0x5b, 0x93, 0x9f, 0xc3, 0xbc, 0xcc, 0xa9, 0xcf, 0x92, 0x61, 0x24, 0x62, 0x87, 0x20, 0x6f, 0x62,
	0x66, 0x6a, 0x20, 0x61, 0x7a, 0x74, 0x93, 0x6e, 0xcf, 0x5d, 0x7e, 0x91, 0x6d, 0xd1, 0x64, 0x73,
	0xb7, 0xcc, 0xa3, 0x2d, 0xa1, 0xcf, 0x87, 0x20, 0x78, 0x69, 0xcf, 0x88, 0x66, 0x6a, 0x73, 0x60,
	0x93, 0x86, 0x60, 0x81, 0x6f, 0x5c, 0x6a, 0xcf, 0x85, 0x5d, 0x92, 0x0a, 0x5c, 0x5c, 0x20, 0x66,
	0x6c, 0x7d, 0x88, 0x6a, 0xcf, 0x92, 0x6a, 0xcf, 0x60, 0xcf, 0x93, 0x68, 0x6c, 0x7c, 0x5c, 0x66,
	0x6d, 0x5c, 0x83, 0x20, 0x66, 0xcf, 0x60, 0x88, 0x74, 0xd1, 0x6f, 0x5c, 0x88, 0x6a, 0xcf, 0x92,
	0x9a, 0xbf, 0x93, 0x6c, 0x79, 0x82, 0x20, 0x61, 0x7a, 0x73, 0x20, 0x5c, 0x73, 0x6b, 0x70, 0x20,
	0x60, 0x60, 0x86, 0x83, 0x64, 0x6e, 0xd1, 0x6a, 0xcf, 0x60, 0x81, 0xcd, 0xcd, 0xcd, 0x0a, 0xab,
	0xca, 0x2d, 0xc1, 0xa1, 0xc3, 0xa9, 0xc3, 0x70, 0x5c, 0x83, 0x93, 0x61, 0x7a, 0x73, 0x20, 0x76,
	0x83, 0x62, 0x60, 0x81, 0x73, 0x20, 0x6e, 0x7d, 0x6a, 0xcf, 0x6b, 0x93, 0xd1, 0x97, 0x96, 0xc3,
	0x70, 0x5b, 0x5d, 0x88, 0x6a, 0xcf, 0x92, 0x0a, 0x60, 0x84, 0x60, 0xcf, 0x93, 0x68, 0xcf, 0x88,
	0x76, 0xcf, 0x20, 0x68, 0x6c, 0x7c, 0x5c, 0x66, 0x6d, 0x62, 0x84, 0x83, 0x92, 0x60, 0xcf, 0x88,
	0x74, 0xcf, 0x91, 0x6d, 0xd1, 0x62, 0x84, 0x80, 0x92, 0x64, 0x84, 0x74, 0x93, 0x9a, 0xbf, 0x73,
	0x20, 0x6a, 0x6a, 0x60, 0x5c, 0x6d, 0xcf, 0x7d, 0x20, 0x5b, 0x83, 0x88, 0x6a, 0xcf, 0x60, 0x81,
	0x6f, 0x92, 0x0a, 0x22, 0x61, 0x24, 0x62, 0x20, 0x64, 0x5d, 0x68, 0x5c, 0x61, 0x22, 0x60, 0x81,
	0x73, 0x20, 0x75, 0x60, 0x82, 0x60, 0xcf, 0x93, 0x9f, 0xc3, 0xbc, 0xcc, 0xa9, 0xcf, 0x73, 0xd1,
	0x5d, 0x66, 0x6f, 0x86, 0x84, 0x6a, 0x20, 0x61, 0x24, 0x62, 0x87, 0x93, 0x5c, 0x79, 0x20, 0x7f,
	0x91, 0x62, 0x82, 0x6e, 0xd1, 0x80, 0x7a, 0x60, 0xcf, 0x5e, 0x81, 0x68, 0x6d, 0x5c, 0x62, 0x92,
	0x0a, 0x5b, 0x84, 0x74, 0x93, 0x6a, 0xcf, 0x5c, 0x60, 0xcf, 0x62, 0x87, 0x20, 0x69, 0x6c, 0x61,
	0xcf, 0x90, 0x5d, 0x67, 0x83, 0x20, 0x6e, 0x66, 0x6a, 0xcf, 0x91, 0x6a, 0x92, 0x0a, 0x64, 0x84,
	0x74, 0x93, 0x76, 0xcf, 0x88, 0x66, 0xbf, 0xb2, 0xcf, 0xbe, 0x60, 0xcf, 0x20, 0x63, 0x5c, 0x69,
	0x62, 0x60, 0x73, 0x5d, 0x6f, 0x20, 0xa2, 0x9f, 0x2d, 0xb1, 0xd0, 0x92, 0x0a, 0x7e, 0x6c, 0x81,
	0x74, 0x93, 0x70, 0x88, 0x63, 0xcf, 0x88, 0x73, 0x20, 0x76, 0xcf, 0x88, 0x66, 0x73, 0x5d, 0x6e,
	0xcf, 0xbf, 0xb2, 0xcf, 0xbe, 0x73, 0x93, 0xd1, 0x7e, 0x62, 0x31, 0x30, 0x30, 0x30, 0x74, 0xcf,
	0x5c, 0x92, 0x0a, 0x69, 0x5d, 0x93, 0x7e, 0x6c, 0x81, 0x74, 0x20, 0x70, 0x88, 0x63, 0xcf, 0x88,
	0x66, 0x8e, 0x60, 0x5c, 0x70, 0x20, 0x75, 0x69, 0x7b, 0x20, 0x99, 0x97, 0xbd, 0x96, 0xc3, 0x92,
	0x0a, 0x9a, 0xbf, 0x73, 0x20, 0x6b, 0x90, 0x5d, 0x65, 0x74, 0x93, 0x60, 0x84, 0x81, 0x70, 0x20,
	0x60, 0x88, 0x6c, 0xcf, 0x60, 0x84, 0x6d, 0x20, 0x66, 0x79, 0x91, 0x6a, 0x92, 0x0a, 0x69, 0x66,
	0x6d, 0x93, 0x61, 0x63, 0x88, 0x6f, 0x20, 0x66, 0xcf, 0x90, 0x5d, 0x61, 0x90, 0x5d, 0x70, 0x20,
	0x24, 0x6b, 0x5c, 0x91, 0x6a, 0x92, 0x0a, 0x9a, 0xbf, 0x74, 0x93, 0xb3, 0xc0, 0x9d, 0xcf, 0xbc,
	0xb6, 0x70, 0x20, 0x61, 0x24, 0x62, 0x87, 0x20, 0x78, 0x69, 0xcf, 0x88, 0x66, 0x6a, 0x92, 0x0a,
	0x69, 0x66, 0x6d, 0x93, 0x69, 0x84, 0x87, 0x20, 0x97, 0x96, 0xc3, 0x70, 0x20, 0x6a, 0x62, 0x66,
	0x6a, 0x92, 0x0a, 0x6c, 0x5c, 0x70, 0x20, 0x6e, 0x81, 0x5e, 0x81, 0x84, 0xcd, 0xcd, 0xcd, 0x0a,
	0x94, 0x7e, 0x6c, 0x73, 0x20, 0x61, 0x24, 0x62, 0x74, 0x93, 0x63, 0x66, 0x6d, 0x20, 0x24, 0x5c,
	0x6a, 0x69, 0xcf, 0x92, 0x95, 0x0a, 0x88, 0xcd, 0xcd, 0xcd, 0x0a, 0x5c, 0x79, 0x6a, 0xcf, 0x93,
	0x0a, 0x70, 0x63, 0xcf, 0x80, 0x5d, 0xcd, 0xcd, 0xcd, 0x0a, 0x5b, 0x89, 0x91, 0x21, 0x6e, 0xcf,
	0x5d, 0x7e, 0x81, 0x20, 0x75, 0x7a, 0x6c, 0x60, 0x5c, 0x61, 0xcf, 0x73, 0x20, 0x80, 0x5d, 0x6a,
	0xcf, 0x92, 0x0a, 0x6e, 0x7d, 0x80, 0x93, 0x80, 0x62, 0x7e, 0x91, 0x6d, 0x62, 0x84, 0x6a, 0x92,
	0x0a, 0x86, 0x84, 0x86, 0x84, 0x73, 0x20, 0x6b, 0x66, 0x61, 0x73, 0x20, 0x24, 0x60, 0x63, 0xcf,
	0x6d, 0xcf, 0x93, 0x63, 0xcf, 0x88, 0x65, 0xcf, 0x5c, 0x93, 0xd1, 0x70, 0x88, 0x63, 0xcf, 0x88,
	0x6e, 0xcf, 0x7d, 0x74, 0x20, 0x86, 0x84, 0x86, 0x84, 0x73, 0x20, 0x75, 0x6c, 0x80, 0x5d, 0x6e,
	0x67, 0x83, 0x20, 0xaf, 0xd0, 0xc1, 0x2d, 0x87, 0x0a, 0x6c, 0x62, 0x82, 0x6a, 0xcf, 0x67, 0x64,
	0x6e, 0x60, 0xcf, 0x20, 0x6d, 0xcf, 0x61, 0x83, 0x92, 0x0a, 0x79, 0x7d, 0x6f, 0x62, 0x93, 0x86,
	0x84, 0x86, 0x84, 0x73, 0x20, 0x68, 0x88, 0x66, 0x6a, 0x6b, 0x60, 0xcf, 0x20, 0xa8, 0xbf, 0xb3,
	0xd0, 0x2d, 0xa9, 0xd1, 0x66, 0x6d, 0x61, 0x6d, 0x2e, 0x2e, 0x2e, 0x0a, 0x24, 0x85, 0x60, 0x6f,
	0x20, 0x70, 0x88, 0x63, 0xcf, 0x88, 0x6e, 0xcf, 0x7d, 0x87, 0x20, 0x78, 0x85, 0x78, 0xcf, 0x67,
	0x6a, 0xcf, 0x85, 0x5d, 0x92, 0x0a, 0x74, 0x83, 0x60, 0x7b, 0x60, 0x66, 0x70, 0x20, 0x66, 0x6d,
	0x5c, 0x6a, 0x80, 0x5d, 0x70, 0x93, 0x86, 0x84, 0x86, 0x84, 0x74, 0x93, 0x79, 0x7d, 0x6f, 0x62,
	0xd1, 0x64, 0x73, 0x5d, 0x6b, 0x8f, 0x5d, 0x87, 0x20, 0x66, 0x74, 0x5c, 0x20, 0x67, 0x83, 0x73,
	0x6a, 0xcf, 0x92, 0x0a, 0x86, 0x84, 0x86, 0x84, 0x73, 0x20, 0x66, 0x90, 0x5d, 0x82, 0x74, 0x93,
	0x66, 0xcf, 0x60, 0x88, 0x73, 0x20, 0x7d, 0x88, 0x6a, 0xcf, 0x5c, 0xcd, 0xcd, 0xcd, 0x0a, 0x5b,
	0x5b, 0x89, 0x89, 0x89, 0x89, 0x2d, 0x21, 0x0a, 0x6f, 0x93, 0x6f, 0x88, 0x6a, 0xcf, 0x3f, 0x0a,
	0xa2, 0xaf, 0xd0, 0x97, 0x6a, 0xcf, 0xcd, 0xcd, 0xcd, 0x85, 0x5d, 0x7e, 0x70, 0x6d, 0xcf, 0x7d,
	0x20, 0x78, 0x5d, 0x82, 0x64, 0x88, 0x6d, 0xcf, 0x24, 0x63, 0x92, 0x0a, 0x5b, 0x6e, 0x6d, 0xcf,
	0x93, 0x66, 0xcf, 0x88, 0x7d, 0x88, 0x20, 0x67, 0x83, 0x6e, 0x66, 0x80, 0x5d, 0x92, 0x0a, 0x66,
	0x90, 0x5d, 0x66, 0x8e, 0x73, 0x20, 0x6e, 0x5d, 0x66, 0xcf, 0x90, 0x5d, 0x6d, 0xcf, 0x67, 0x21,
	0x20, 0x86, 0x6a, 0x66, 0x60, 0x81, 0xd1, 0x9f, 0xc3, 0xbc, 0xcc, 0xa9, 0xcf, 0x62, 0x88, 0x70,
	0x93, 0x66, 0x90, 0x5d, 0x75, 0x88, 0x87, 0x20, 0x86, 0x6a, 0x66, 0x79, 0x67, 0x92, 0x0a, 0x9f,
	0xc3, 0xbc, 0xcc, 0xa9, 0xcf, 0x62, 0x88, 0x93, 0xa5, 0x97, 0xa5, 0xc3, 0xa9, 0xbc, 0xb2, 0xcf,
	0xbe, 0x80, 0x82, 0x93, 0x67, 0x74, 0xcf, 0x81, 0x66, 0x5c, 0xd1, 0x6b, 0x61, 0x8f, 0x5d, 0x73,
	0x6a, 0x75, 0xcf, 0x87, 0x20, 0xb1, 0xd0, 0xbf, 0xa3, 0xcf, 0xc3, 0xa9, 0x66, 0x79, 0x67, 0x92,
	0x24, 0x7c, 0x6d, 0xcf, 0x6e, 0x5d, 0x21, 0x21, 0x0a, 0x67, 0x5d, 0x66, 0xcf, 0x60, 0x88, 0x64,
	0xcf, 0x93, 0x9f, 0xc3, 0xbc, 0xcc, 0xa9, 0xcf, 0x74, 0x93, 0x6b, 0x61, 0x8f, 0x5d, 0x7f, 0x61,
	0x73, 0xd1, 0x22, 0xa2, 0xa5, 0x2d, 0xb1, 0xd0, 0xc0, 0xb0, 0xcf, 0xa8, 0xcf, 0xc3, 0xa2, 0x64,
	0xcf, 0x5d, 0x22, 0x70, 0x20, 0x73, 0x91, 0x6a, 0x92, 0x0a, 0x34, 0x33, 0x37, 0x70, 0x6b, 0x7c,
	0xcd, 0xcd, 0xcd, 0x0a, 0x60, 0x84, 0x81, 0x74, 0x20, 0x86, 0x6a, 0x66, 0x70, 0x93, 0x75, 0x6e,
	0xcf, 0x5c, 0x66, 0x64, 0xcf, 0x6e, 0x87, 0x20, 0x65, 0x68, 0x6a, 0x92, 0xd1, 0x69, 0x73, 0x93,
	0x6f, 0x82, 0x7f, 0x61, 0x70, 0x20, 0x6c, 0x5c, 0x6d, 0x74, 0x93, 0x74, 0x6f, 0x66, 0x6a, 0x62,
	0x6f, 0x5c, 0x92, 0xd1, 0x69, 0x84, 0x74, 0x93, 0x86, 0x6a, 0x66, 0x73, 0x20, 0x69, 0x5d, 0x69,
	0xcf, 0x5d, 0x87, 0x20, 0x74, 0x83, 0x60, 0x70, 0x20, 0x64, 0x5e, 0x83, 0xd1, 0x24, 0x69, 0x85,
	0x66, 0x5c, 0x7d, 0x73, 0x20, 0x6a, 0xcf, 0x91, 0x6a, 0x92, 0x0a, 0x35, 0x31, 0x39, 0x70, 0x6b,
	0x7c, 0xcd, 0xcd, 0xcd, 0x0a, 0x60, 0x84, 0x81, 0x74, 0x93, 0x86, 0x84, 0x86, 0x84, 0x20, 0x70,
	0x88, 0x63, 0xcf, 0x88, 0x87, 0x93, 0x78, 0x85, 0x78, 0xcf, 0x69, 0x5d, 0x6e, 0x20, 0x66, 0x6d,
	0x5c, 0x83, 0x21, 0xd1, 0x6b, 0x61, 0x8f, 0x5d, 0x70, 0x20, 0x63, 0x5c, 0x64, 0x62, 0x67, 0x83,
	0x6a, 0x7c, 0x93, 0x6f, 0x70, 0x60, 0x20, 0x66, 0x6f, 0x62, 0x6d, 0x74, 0xcd, 0xcd, 0xcd, 0x0a,
	0x36, 0x38, 0x33, 0x70, 0x6b, 0x7c, 0xcd, 0xcd, 0xcd, 0x0a, 0x61, 0x90, 0x5d, 0x93, 0xa5, 0x97,
	0xa5, 0xc3, 0x9f, 0xc3, 0xb0, 0xd0, 0xca, 0x2d, 0xa5, 0x2d, 0x70, 0x93, 0x22, 0x76, 0xcf, 0x88,
	0x66, 0x73, 0x63, 0x88, 0x61, 0x8f, 0x5d, 0x22, 0xd1, 0x70, 0x6c, 0x5c, 0x6d, 0x73, 0x20, 0x66,
	0x90, 0x5d, 0x60, 0x5c, 0x87, 0x66, 0x6a, 0x92, 0x86, 0x6a, 0x66, 0x74, 0x93, 0x6a, 0x6a, 0xcf,
	0x20, 0x6a, 0xcf, 0x84, 0x60, 0x60, 0xcf, 0xd1, 0x69, 0x84, 0x70, 0x20, 0x61, 0x90, 0x5d, 0x7a,
	0x87, 0x7d, 0x6c, 0x20, 0x64, 0x6e, 0x87, 0x93, 0x5c, 0x73, 0x83, 0x74, 0xcf, 0x60, 0x82, 0x6a,
	0xcf, 0x92, 0x0a, 0x36, 0x39, 0x30, 0x70, 0x6b, 0x7c, 0xcd, 0xcd, 0xcd, 0x0a, 0xb4, 0xa2, 0xa5,
	0x2d, 0xb1, 0xcf, 0xbf, 0x97, 0xc3, 0x6a, 0xcf, 0x21, 0x69, 0x84, 0x60, 0xcf, 0x20, 0x7e, 0x6c,
	0x81, 0x70, 0x20, 0x7c, 0x5c, 0x84, 0x5c, 0x66, 0x6d, 0xd1, 0x5c, 0x83, 0x73, 0x6a, 0xcf, 0xcd,
	0xcd, 0xcd, 0x5b, 0x67, 0x93, 0x69, 0x84, 0x60, 0xcf, 0x20, 0x6e, 0xcf, 0x64, 0x70, 0x5b, 0x83,
	0x73, 0x60, 0x93, 0xd1, 0x7a, 0x6c, 0x63, 0x80, 0x5d, 0x6e, 0x20, 0x24, 0x7d, 0x5d, 0x92, 0x0a,
	0x37, 0x32, 0x30, 0x70, 0x6b, 0x7c, 0xcd, 0xcd, 0xcd, 0x0a, 0xb4, 0xa2, 0xa5, 0x2d, 0xb1, 0xcf,
	0xbf, 0x97, 0xc3, 0x87, 0x20, 0x7a, 0x6c, 0x63, 0x83, 0x73, 0x74, 0x20, 0x76, 0x60, 0x73, 0x5d,
	0x6a, 0xcf, 0x92, 0xd1, 0x5b, 0x84, 0x74, 0x93, 0x5d, 0x6b, 0x8f, 0x5d, 0x73, 0x20, 0x6b, 0x8f,
	0x5d, 0x66, 0x88, 0x70, 0x93, 0x69, 0x6f, 0x5e, 0x6c, 0x63, 0x81, 0x84, 0x6d, 0x5c, 0x83, 0x92,
	0xd1, 0x69, 0x73, 0x5d, 0x5e, 0x93, 0x67, 0x77, 0xcf, 0x6d, 0x73, 0x20, 0x6c, 0x5d, 0x66, 0x88,
	0x60, 0x5c, 0x68, 0x88, 0x74, 0x93, 0x61, 0x81, 0x84, 0x6d, 0xd1, 0x66, 0x79, 0x91, 0x6d, 0x5c,
	0x83, 0x92, 0x0a, 0x38, 0x33, 0x30, 0x70, 0x6b, 0x7c, 0xcd, 0xcd, 0xcd, 0x0a, 0x86, 0x60, 0x91,
	0x6a, 0x21, 0x21, 0x20, 0x80, 0x75, 0xcf, 0x73, 0xb1, 0xcf, 0xbf, 0x97, 0xc3, 0x60, 0xcf, 0x20,
	0x64, 0x73, 0x86, 0x62, 0x68, 0x5c, 0x87, 0xd1, 0x66, 0x74, 0x5c, 0x66, 0x6d, 0x5c, 0x83, 0x88,
	0x6a, 0xcf, 0x92, 0xd1, 0xb4, 0xa2, 0xa5, 0x2d, 0xb1, 0xcf, 0xbf, 0x97, 0xc3, 0x74, 0x93, 0x67,
	0x64, 0x66, 0x73, 0x5b, 0x5c, 0x6a, 0xcf, 0x20, 0x72, 0x7b, 0x91, 0x6d, 0x5c, 0x83, 0x73, 0x6a,
	0xcf, 0x92, 0x0a, 0x80, 0x75, 0xcf, 0x73, 0xb1, 0xcf, 0xbf, 0x97, 0xc3, 0x87, 0x93, 0x74, 0x60,
	0x5c, 0x67, 0x84, 0x74, 0xcf, 0x93, 0xd1, 0xb4, 0xa2, 0xa5, 0x2d, 0xb1, 0xcf, 0xbf, 0x97, 0xc3,
	0x60, 0xcf, 0x93, 0x79, 0x6a, 0x20, 0x5d, 0x64, 0xcf, 0x61, 0x6a, 0xcf, 0x67, 0x92, 0xd1, 0x96,
	0xa9, 0xb5, 0xcc, 0x9d, 0xa6, 0xc9, 0x2d, 0xa1, 0xcf, 0x87, 0x20, 0x64, 0x73, 0x86, 0x62, 0x68,
	0x5c, 0x73, 0x20, 0x22, 0x60, 0x62, 0x22, 0x70, 0x24, 0x63, 0x74, 0xcf, 0xd1, 0x6c, 0x5d, 0x66,
	0x88, 0x60, 0x5c, 0x68, 0x88, 0x87, 0x20, 0x75, 0x81, 0x62, 0x64, 0x6e, 0x60, 0xcf, 0x20, 0x6d,
	0xcf, 0x61, 0x83, 0x73, 0x6a, 0xcf, 0x92, 0x0a, 0x39, 0x30, 0x30, 0x70, 0x6b, 0x7c, 0xcd, 0xcd,
	0xcd, 0x0a, 0x86, 0x6a, 0x66, 0x74, 0x93, 0xb1, 0xcf, 0xbf, 0x97, 0xc3, 0x73, 0x20, 0x84, 0x88,
	0x65, 0x74, 0x88, 0x73, 0x5d, 0x87, 0x20, 0x74, 0x60, 0x5c, 0x66, 0x93, 0xd1, 0x64, 0x73, 0x86,
	0x62, 0x68, 0x5c, 0x87, 0x20, 0x74, 0x7c, 0x6c, 0x65, 0x68, 0x83, 0x20, 0x6b, 0x60, 0x81, 0x73,
	0x5b, 0x83, 0x20, 0x74, 0xcf, 0x62, 0x6a, 0xcf, 0x88, 0x87, 0xd1, 0x62, 0x7a, 0x6a, 0x6d, 0x6a,
	0x92, 0x0a, 0x5b, 0x6e, 0x74, 0x93, 0x63, 0x5c, 0x60, 0x62, 0x87, 0x20, 0x66, 0xcf, 0x91, 0x64,
	0x5d, 0x67, 0x83, 0x6a, 0x7c, 0x73, 0x93, 0x7f, 0x5d, 0x61, 0x60, 0xcf, 0xd1, 0x5c, 0x83, 0x6a,
	0xcf, 0x63, 0x6a, 0xcf, 0x2e, 0x2e, 0x2e, 0x0a, 0x31, 0x32, 0x30, 0x30, 0x70, 0x6b, 0x7c, 0xcd,
	0xcd, 0xcd, 0x0a, 0x86, 0x6a, 0x66, 0x74, 0x20, 0x64, 0x88, 0x7e, 0x93, 0x66, 0xcf, 0x91, 0x64,
	0x5d, 0x67, 0x83, 0x64, 0x6e, 0x87, 0x20, 0x63, 0x91, 0x66, 0x88, 0x66, 0x6a, 0x92, 0xd1, 0x67,
	0x77, 0xcf, 0x6d, 0x60, 0xcf, 0x20, 0x74, 0x60, 0x5c, 0x65, 0x84, 0x83, 0x20, 0x79, 0x5e, 0x70,
	0x20, 0xaf, 0xc3, 0x9b, 0xcf, 0x2d, 0x70, 0x5b, 0x83, 0xd1, 0x5d, 0x6b, 0x8f, 0x5d, 0x68, 0x88,
	0x70, 0x93, 0x73, 0x81, 0x6f, 0x63, 0x84, 0x74, 0xcf, 0xcd, 0xcd, 0xcd, 0x92, 0x0a, 0x64, 0x84,
	0x60, 0xcf, 0x93, 0x86, 0x6a, 0x66, 0x73, 0x20, 0x65, 0x5c, 0x64, 0xcf, 0x73, 0xb7, 0xcc, 0xa3,
	0x2d, 0xa1, 0xcf, 0x6a, 0xcf, 0x92, 0xd1, 0x60, 0x7a, 0x80, 0x93, 0x6e, 0xcf, 0x5d, 0x60, 0x20,
	0x86, 0x6a, 0x66, 0x87, 0x20, 0x79, 0x7d, 0x91, 0x6d, 0x62, 0x84, 0x92, 0x0a, 0xb1, 0xc5, 0xbd,
	0xcc, 0xb1, 0xd0, 0x20, 0xaf, 0xc1, 0x2d, 0xa9, 0xcf, 0x20, 0x9d, 0xbc, 0x2d, 0x9d, 0x0a, 0x31,
	0x32, 0x0a, 0x31, 0x32, 0x0a, 0x31, 0x32, 0x0a, 0x31, 0x32, 0x0a, 0x31, 0x32, 0x0a, 0x31, 0x32,
	0x0a, 0x31, 0x32, 0x0a, 0x31, 0x32, 0x0a, 0x31, 0x32, 0x0a, 0x31, 0x32, 0x0a, 0x31, 0x32, 0x0a,
	0x31, 0x32, 0x0a, 0x31, 0x32, 0x0a, 0x31, 0x32, 0x0a, 0x31, 0x32, 0x0a, 0x31, 0x32, 0x0a, 0x31,
	0x32, 0x0a, 0x99, 0xc3, 0xa9, 0xbd, 0x2d, 0x87, 0x20, 0x60, 0x62, 0x70, 0x88, 0x20, 0x66, 0x79,
	0x66, 0x6a, 0x92, 0x0a, 0x64, 0x73, 0x66, 0x7c, 0x5c, 0x87, 0x20, 0x5d, 0x63, 0x83, 0x7d, 0x73,
	0x74, 0x93, 0xd1, 0x22, 0x85, 0x5d, 0x6e, 0xcf, 0x5d, 0x20, 0x61, 0x90, 0x60, 0x66, 0x90, 0x5d,
	0x22, 0x87, 0x20, 0x69, 0x5d, 0x70, 0x8f, 0x5d, 0x68, 0x80, 0x92, 0xd1, 0x69, 0x5d, 0x70, 0x8f,
	0x5d, 0x67, 0x83, 0x20, 0x64, 0x6e, 0x6d, 0xcf, 0x93, 0xd1, 0x64, 0x73, 0x66, 0x64, 0xcf, 0x6e,
	0x87, 0x20, 0x5d, 0x63, 0x24, 0x5d, 0x7d, 0x73, 0x6e, 0x20, 0x7a, 0x6f, 0x67, 0x92, 0x0a, 0x66,
	0x7c, 0x5c, 0x20, 0x6a, 0x91, 0x68, 0x5c, 0x6d, 0xcf, 0x67, 0x92, 0x0a, 0x78, 0x5d, 0x66, 0x8f,
	0x5d, 0x0a, 0x31, 0x30, 0x30, 0x0a, 0x33, 0x30, 0x30, 0x0a, 0x34, 0x30, 0x30, 0x0a, 0x35, 0x30,
	0x30, 0x0a, 0x36, 0x30, 0x30, 0x0a, 0x9d, 0xbf, 0xa1, 0xcf, 0xcc, 0xa9, 0x0a
};

const uint16_t Resource::_voicesOffsetsTable[] = {
	0x0064, 0x006A, 0x0070, 0x0084, 0x0090, 0x0096, 0x009E, 0x00A4, 0x00AE, 0x00B4,
	0x00BC, 0x00C4, 0x00CC, 0x00D4, 0x00E0, 0x00E6, 0x00EC, 0x00F6, 0x00FC, 0x0102,
	0x010C, 0x0126, 0x0130, 0x0136, 0x013E, 0x0144, 0x014C, 0x0152, 0x015A, 0x0160,
	0x0166, 0x016C, 0x0176, 0x017C, 0x0186, 0x018C, 0x0198, 0x019E, 0x01A4, 0x01AC,
	0x01B6, 0x01BE, 0x01C6, 0x01CC, 0x01D4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	0x0000, 0x0001, 0x0073, 0x0073, 0x0001, 0x0050, 0x00C3, 0x0008, 0x00D7, 0x007D,
	0x0078, 0x007D, 0x0087, 0x005A, 0x00E1, 0x0087, 0x0555, 0x0004, 0x00D7, 0x0069,
	0x00EB, 0x00A5, 0x0825, 0x0001, 0x008C, 0x08B1, 0x0002, 0x00CD, 0x0073, 0x09F1,
	0x0001, 0x0113, 0x0B04, 0x0003, 0x0113, 0x008C, 0x00B9, 0x0D5C, 0x0001, 0x0096,
	0x0DF2, 0x0002, 0x00AF, 0x0082, 0x0F23, 0x0002, 0x0069, 0x009B, 0x1027, 0x0002,
	0x0069, 0x00EB, 0x117B, 0x0002, 0x0069, 0x00C3, 0x12A7, 0x0004, 0x0064, 0x00AA,
	0x0078, 0x00DC, 0x1509, 0x0001, 0x00B4, 0x15BD, 0x0001, 0x0046, 0x1603, 0x0003,
	0x0050, 0x0118, 0x00A5, 0x1810, 0x0001, 0x0041, 0x1851, 0x0001, 0x0082, 0x18D3,
	0x0003, 0x0104, 0x00D7, 0x00AF, 0x1B5D, 0x000B, 0x00AA, 0x00BE, 0x0127, 0x005A,
	0x00F5, 0x00AA, 0x0104, 0x00BE, 0x00DC, 0x00B9, 0x00D7, 0x2413, 0x0003, 0x00C3,
	0x00E6, 0x003C, 0x25F8, 0x0001, 0x0069, 0x2661, 0x0002, 0x00BE, 0x00AF, 0x27CE,
	0x0001, 0x0050, 0x281E, 0x0002, 0x0041, 0x0037, 0x2896, 0x0001, 0x011D, 0x29B3,
	0x0002, 0x0041, 0x003C, 0x2A30, 0x0001, 0x00A5, 0x2AD5, 0x0001, 0x0000, 0x2AD5,
	0x0001, 0x0000, 0x2AD5, 0x0003, 0x005A, 0x00B9, 0x0073, 0x2C5B, 0x0001, 0x005F,
	0x2CBA, 0x0003, 0x00DC, 0x0064, 0x00F0, 0x2EEA, 0x0001, 0x00B9, 0x2FA3, 0x0004,
	0x0181, 0x013B, 0x005F, 0x0154, 0x3412, 0x0001, 0x00AF, 0x34C1, 0x0001, 0x00A0,
	0x3561, 0x0002, 0x0069, 0x003C, 0x3606, 0x0003, 0x0000, 0x00FA, 0x00F0, 0x37F0,
	0x0002, 0x006E, 0x00A0, 0x38FE, 0x0002, 0x0064, 0x00E6, 0x3A48, 0x0001, 0x00A5,
	0x3AED, 0x0002, 0x0078, 0x0087, 0x3BEC, 0x0002, 0x00AA, 0x00F0
};

const uint32_t Resource::_spmOffsetsTable[1287] = {
	0x00000, 0x000C5, 0x001AC, 0x00299, 0x00383, 0x00454, 0x0053B, 0x00627,
	0x00713, 0x007EA, 0x008C8, 0x009AE, 0x00A9B, 0x00B80, 0x00D39, 0x00EF5,
	0x00FE1, 0x010C2, 0x011AD, 0x01362, 0x01513, 0x016BA, 0x017A1, 0x0188A,
	0x0198C, 0x01A62, 0x01B2C, 0x01BD4, 0x01C78, 0x01D04, 0x01D9F, 0x01E40,
	0x01EFF, 0x01FD2, 0x0209C, 0x02167, 0x02232, 0x022EB, 0x02397, 0x02433,
	0x024CC, 0x02558, 0x025D3, 0x02662, 0x02739, 0x027C1, 0x0285E, 0x0290D,
	0x029E6, 0x02AC4, 0x02BA7, 0x02C8A, 0x02E09, 0x02ECF, 0x02FA2, 0x0313E,
	0x032F3, 0x03499, 0x0363A, 0x037BA, 0x0393F, 0x03AD4, 0x03C63, 0x03D24,
	0x03DF5, 0x03F99, 0x0413F, 0x042DA, 0x04472, 0x045FA, 0x0477D, 0x048F0,
	0x049DA, 0x04AC2, 0x04BA6, 0x04C88, 0x04E2B, 0x04FC0, 0x0514D, 0x052D6,
	0x0544D, 0x055D7, 0x0569F, 0x05854, 0x059CC, 0x05B57, 0x05CE4, 0x05E49,
	0x05F9E, 0x060F8, 0x061BA, 0x0628A, 0x0636B, 0x0643E, 0x06505, 0x065D6,
	0x0674A, 0x068D1, 0x06A5E, 0x06BC3, 0x06D10, 0x06E5B, 0x06FA3, 0x070DD,
	0x07219, 0x0734C, 0x0749A, 0x075F9, 0x0776A, 0x078FB, 0x07A8B, 0x07B60,
	0x07C25, 0x07CEB, 0x07DC8, 0x07E9F, 0x0803F, 0x081DD, 0x08371, 0x08444,
	0x0852C, 0x085EF, 0x086BA, 0x08839, 0x08992, 0x08AE7, 0x08C58, 0x08D27,
	0x08DED, 0x08EAF, 0x08F71, 0x0901F, 0x090D1, 0x09189, 0x09239, 0x092E5,
	0x0938F, 0x094D7, 0x09608, 0x0969B, 0x09724, 0x0979B, 0x09816, 0x0989F,
	0x0995B, 0x09AC8, 0x09C4A, 0x09DD5, 0x09F61, 0x0A020, 0x0A0DF, 0x0A184,
	0x0A218, 0x0A2BD, 0x0A3EE, 0x0A509, 0x0A633, 0x0A755, 0x0A86D, 0x0A8FF,
	0x0A99B, 0x0AA38, 0x0AB65, 0x0AC9E, 0x0ADFF, 0x0AF7A, 0x0B051, 0x0B121,
	0x0B1F6, 0x0B2CF, 0x0B3B6, 0x0B49D, 0x0B596, 0x0B681, 0x0B744, 0x0B801,
	0x0B8B2, 0x0B954, 0x0B9F5, 0x0BAA1, 0x0BBFF, 0x0BD69, 0x0BED3, 0x0C03A,
	0x0C188, 0x0C2DD, 0x0C422, 0x0C4C8, 0x0C55C, 0x0C5EF, 0x0C683, 0x0C734,
	0x0C7FC, 0x0C8D1, 0x0CA54, 0x0CBC0, 0x0CD36, 0x0CEA7, 0x0CF5A, 0x0D0C2,
	0x0D188, 0x0D272, 0x0D3C2, 0x0D503, 0x0D631, 0x0D75C, 0x0D87E, 0x0D933,
	0x0D9E2, 0x0DA9D, 0x0DB5C, 0x0DC96, 0x0DD51, 0x0DE39, 0x0DF3E, 0x0E041,
	0x0E129, 0x0E211, 0x0E383, 0x0E4E5, 0x0E619, 0x0E732, 0x0E848, 0x0E944,
	0x0EA47, 0x0EB52, 0x0EC5F, 0x0ED6F, 0x0EE6F, 0x0EF59, 0x0EFD4, 0x0F04A,
	0x0F119, 0x0F1DF, 0x0F2B1, 0x0F38F, 0x0F462, 0x0F57A, 0x0F6B1, 0x0F807,
	0x0F8D2, 0x0F9B5, 0x0FA9E, 0x0FBA3, 0x0FC4B, 0x0FD2C, 0x0FD92, 0x0FE5B,
	0x0FEC6, 0x0FF2B, 0x0FF8B, 0x0FFFB, 0x10078, 0x10101, 0x1019D, 0x1024D,
	0x10320, 0x103FA, 0x1057D, 0x106FC, 0x1087B, 0x10945, 0x10A14, 0x10AE7,
	0x10BC3, 0x10C92, 0x10D63, 0x10E3A, 0x10F12, 0x10FF6, 0x111AA, 0x1133F,
	0x114DA, 0x11672, 0x11814, 0x119BA, 0x11B60, 0x11CF3, 0x11E7D, 0x12015,
	0x121C3, 0x12368, 0x1250D, 0x126AB, 0x1284D, 0x129E7, 0x12B85, 0x12D39,
	0x12EC8, 0x1303F, 0x1319E, 0x132E5, 0x13410, 0x1352C, 0x135C5, 0x13669,
	0x13711, 0x13841, 0x1395D, 0x13A69, 0x13C00, 0x13CDB, 0x13DAF, 0x13E81,
	0x13F53, 0x14076, 0x14196, 0x1422F, 0x142C7, 0x14360, 0x143F7, 0x144CF,
	0x145A8, 0x14680, 0x14757, 0x1482F, 0x14907, 0x149E1, 0x14AB3, 0x14B89,
	0x14C5D, 0x14D3D, 0x14E1E, 0x14F05, 0x14FF1, 0x150D7, 0x1527C, 0x153BD,
	0x15478, 0x15561, 0x1566D, 0x15772, 0x15862, 0x1596B, 0x15A7C, 0x15B83,
	0x15C81, 0x15D80, 0x15E7F, 0x15F7F, 0x16072, 0x1613D, 0x16211, 0x162EA,
	0x163A0, 0x16438, 0x164B9, 0x1652A, 0x16604, 0x166E4, 0x167BE, 0x16948,
	0x16AE2, 0x16C57, 0x16D17, 0x16DF1, 0x16F96, 0x17083, 0x17168, 0x17249,
	0x1732F, 0x17411, 0x174F1, 0x175BC, 0x176A9, 0x17791, 0x17870, 0x17952,
	0x17AF2, 0x17C96, 0x17E2F, 0x17F04, 0x17FD9, 0x180AE, 0x18183, 0x18253,
	0x1831D, 0x183F2, 0x18583, 0x18703, 0x18884, 0x18A01, 0x18B7C, 0x18CFD,
	0x18E8A, 0x1900D, 0x1919F, 0x19348, 0x194EA, 0x1967D, 0x197FA, 0x19989,
	0x19B14, 0x19BE9, 0x19CC0, 0x19DA9, 0x19E77, 0x19F49, 0x1A01B, 0x1A0FA,
	0x1A1C0, 0x1A298, 0x1A37E, 0x1A3F7, 0x1A574, 0x1A6CD, 0x1A812, 0x1A94A,
	0x1AA80, 0x1AB98, 0x1ACA3, 0x1ADD8, 0x1AEC3, 0x1AF9C, 0x1B071, 0x1B125,
	0x1B1E1, 0x1B2A7, 0x1B339, 0x1B39F, 0x1B411, 0x1B54D, 0x1B6A1, 0x1B814,
	0x1B9A9, 0x1BA87, 0x1BB73, 0x1BCE7, 0x1BE2C, 0x1BF22, 0x1BFD9, 0x1C04E,
	0x1C0B2, 0x1C10C, 0x1C166, 0x1C1C0, 0x1C363, 0x1C454, 0x1C534, 0x1C616,
	0x1C706, 0x1C7EC, 0x1C8D3, 0x1C9B7, 0x1CAA4, 0x1CC5C, 0x1CDB4, 0x1CF00,
	0x1D044, 0x1D1A2, 0x1D2ED, 0x1D3F7, 0x1D49F, 0x1D540, 0x1D5FD, 0x1D703,
	0x1D80A, 0x1D91E, 0x1DA48, 0x1DB58, 0x1DC63, 0x1DD2D, 0x1DDB2, 0x1DE1D,
	0x1DE74, 0x1DEBB, 0x1DFD0, 0x1E0C0, 0x1E177, 0x1E2CF, 0x1E402, 0x1E505,
	0x1E5C1, 0x1E627, 0x1E705, 0x1E7A8, 0x1E81A, 0x1E874, 0x1E8CE, 0x1E928,
	0x1E982, 0x1E9E5, 0x1EA64, 0x1EB07, 0x1EBB6, 0x1EC81, 0x1ED58, 0x1EE30,
	0x1EF08, 0x1F01D, 0x1F0C0, 0x1F170, 0x1F233, 0x1F3D3, 0x1F5BD, 0x1F6C3,
	0x1F7B7, 0x1F89C, 0x1FA67, 0x1FC0B, 0x1FD7D, 0x1FEAB, 0x1FFBD, 0x2019E,
	0x20354, 0x20511, 0x206C1, 0x2089E, 0x20A66, 0x20B44, 0x20C87, 0x20D0D,
	0x20D8B, 0x20E0D, 0x20E7F, 0x20ED9, 0x20F4B, 0x20FD3, 0x21059, 0x210DF,
	0x21179, 0x21223, 0x212E4, 0x2139E, 0x21458, 0x2151F, 0x215D2, 0x216A0,
	0x21770, 0x2182D, 0x218EB, 0x219AD, 0x21A1B, 0x21A9D, 0x21B37, 0x21BE4,
	0x21C9E, 0x21D5E, 0x21E1C, 0x21EE3, 0x21FAF, 0x22067, 0x2211E, 0x22210,
	0x22321, 0x2244D, 0x22516, 0x225D5, 0x2269C, 0x2280B, 0x229A3, 0x22B6B,
	0x22C45, 0x22DE5, 0x22F76, 0x2310E, 0x232A7, 0x2345B, 0x23623, 0x2B9D7,
	0x2BB9B, 0x2BD57, 0x2BF22, 0x2C0ED, 0x2C2AD, 0x2C46C, 0x2C631, 0x2C7F8,
	0x2C9B4, 0x2CB6F, 0x2CD2A, 0x2CEE7, 0x2D0B0, 0x2D284, 0x2D458, 0x2D622,
	0x2D7E8, 0x2D9AF, 0x2DB6F, 0x2DD41, 0x2DF14, 0x2E104, 0x2E309, 0x2E517,
	0x2E71C, 0x2E92F, 0x2EB47, 0x2ED4C, 0x2EF2E, 0x2F0FF, 0x2F2D5, 0x2F4A7,
	0x2F670, 0x2F827, 0x2F9D3, 0x2FB73, 0x2FD28, 0x2FEDD, 0x300AD, 0x3029A,
	0x30487, 0x3065D, 0x30833, 0x30A08, 0x30BDF, 0x30DB5, 0x30F8E, 0x30F93,
	0x31168, 0x3133D, 0x31512, 0x316E7, 0x318BC, 0x31A91, 0x31C5E, 0x31E22,
	0x31FE1, 0x32194, 0x3232E, 0x3249F, 0x325E5, 0x3270A, 0x32835, 0x3297C,
	0x32B67, 0x32D5D, 0x32F34, 0x330EC, 0x33299, 0x33428, 0x335B5, 0x33714,
	0x3382E, 0x3393B, 0x339FF, 0x33A95, 0x33B50, 0x33C13, 0x33CA2, 0x33D21,
	0x33D8F, 0x33DE7, 0x33E35, 0x3402E, 0x341EF, 0x34343, 0x344AE, 0x345D6,
	0x346DF, 0x347E7, 0x348D1, 0x34967, 0x349FD, 0x34A7B, 0x23726, 0x237A3,
	0x23826, 0x238AD, 0x23936, 0x23A3A, 0x23B3E, 0x23BC8, 0x23CD9, 0x23DEF,
	0x23F0B, 0x240C2, 0x241AD, 0x24295, 0x2443F, 0x245E5, 0x2478B, 0x24933,
	0x24ACD, 0x24C66, 0x24E09, 0x24FD1, 0x251A7, 0x2537F, 0x25483, 0x255E7,
	0x256DA, 0x257C6, 0x25837, 0x258B9, 0x25953, 0x25A00, 0x25AC1, 0x25B9C,
	0x25C7D, 0x25D5C, 0x25E3C, 0x25F14, 0x26029, 0x260D7, 0x261FA, 0x262A0,
	0x26348, 0x263F8, 0x264AD, 0x26557, 0x265FF, 0x266A7, 0x26752, 0x2687D,
	0x26922, 0x269C2, 0x26A74, 0x26BE6, 0x26D86, 0x26E49, 0x26F08, 0x26FEA,
	0x270CC, 0x271AC, 0x2728E, 0x27370, 0x27451, 0x2751C, 0x275EB, 0x276B5,
	0x27792, 0x2792E, 0x27ABD, 0x27C55, 0x27D33, 0x27E06, 0x27F00, 0x2800C,
	0x280A3, 0x281CD, 0x282E7, 0x283FE, 0x284A6, 0x28572, 0x2863D, 0x286FD,
	0x287A8, 0x28849, 0x288E2, 0x2896D, 0x289F4, 0x28A75, 0x28AF7, 0x28B80,
	0x28C1B, 0x28CD2, 0x2B9D7, 0x2BBB2, 0x2BD81, 0x2BF42, 0x2C105, 0x2C2CA,
	0x2C47D, 0x2C645, 0x2C817, 0x2C9F2, 0x2CBB2, 0x2CD68, 0x2CF20, 0x2D0CA,
	0x2D265, 0x2D420, 0x2D5F4, 0x2D6D6, 0x2D7C2, 0x2D97B, 0x2DA59, 0x2DB2E,
	0x2DC07, 0x2DCF3, 0x2DDDB, 0x2DEC6, 0x2E091, 0x2E256, 0x2E41A, 0x2E5DE,
	0x2E7B7, 0x2E956, 0x2EAFE, 0x2ECA7, 0x2EE55, 0x2F035, 0x2F215, 0x2F3E5,
	0x2F4D2, 0x2F5C1, 0x2F786, 0x2F953, 0x2FB21, 0x2FD03, 0x2FEEA, 0x300CE,
	0x302CB, 0x304D5, 0x306DF, 0x308C9, 0x30AB3, 0x30C87, 0x30E5B, 0x3102F,
	0x31203, 0x313D7, 0x315BB, 0x31787, 0x3195B, 0x31B2F, 0x31D03, 0x31EE9,
	0x320CC, 0x322AC, 0x3247B, 0x3265B, 0x3283B, 0x32A2D, 0x32C1F, 0x32E11,
	0x33003, 0x331D3, 0x33379, 0x3351E, 0x336BF, 0x33883, 0x33A44, 0x33C05,
	0x33DD8, 0x33F9C, 0x3415C, 0x34341, 0x34514, 0x34608, 0x346EF, 0x347D6,
	0x348CE, 0x34AA5, 0x34C78, 0x34E6A, 0x3505C, 0x3524E, 0x35440, 0x35632,
	0x35824, 0x3590C, 0x35AB2, 0x35C7D, 0x35E3A, 0x35FF0, 0x36184, 0x36313,
	0x36470, 0x36597, 0x36662, 0x3672A, 0x367C4, 0x3682B, 0x36878, 0x368B1,
	0x368D5, 0x368E7, 0x36AAE, 0x36C67, 0x36E0A, 0x36F74, 0x3708E, 0x37163,
	0x3723A, 0x37332, 0x37456, 0x375A7, 0x3771B, 0x37893, 0x379EE, 0x37B39,
	0x37C54, 0x37CD8, 0x37D08, 0x37D0F, 0x37EBC, 0x3804C, 0x3823E, 0x38404,
	0x385BF, 0x387B2, 0x38997, 0x38B7E, 0x38D55, 0x38F2C, 0x39103, 0x392DB,
	0x394B0, 0x3967B, 0x3983C, 0x39A03, 0x39B8C, 0x39CF6, 0x39E55, 0x39F90,
	0x3A0CB, 0x3A209, 0x3A353, 0x3A49B, 0x3A5D6, 0x3A711, 0x28D70, 0x2B9D7,
	0x2BBAD, 0x2BD84, 0x2BF5A, 0x2C127, 0x2C2F5, 0x2C4C2, 0x2C683, 0x2C856,
	0x2CA2D, 0x2CBFF, 0x2CDD9, 0x2CFA6, 0x2D173, 0x2D341, 0x2D50F, 0x2D6E9,
	0x2D8C4, 0x2DA9E, 0x2DC74, 0x2DE4E, 0x2DF33, 0x2E006, 0x2E180, 0x2E2D6,
	0x2E408, 0x2E524, 0x2E63F, 0x2E75A, 0x2E875, 0x2E99C, 0x2EABE, 0x2EB90,
	0x2ECE8, 0x2EEA1, 0x2F029, 0x2F16D, 0x2F298, 0x2F3B0, 0x2F58A, 0x2F67B,
	0x2F76C, 0x2F85C, 0x2F94B, 0x2FA3A, 0x2FB2B, 0x2FC1B, 0x2FD0C, 0x2FEE6,
	0x300B9, 0x30288, 0x30447, 0x305F6, 0x306FC, 0x308CB, 0x30AA5, 0x30C5A,
	0x30DE0, 0x30F36, 0x31074, 0x3119A, 0x3123D, 0x313AB, 0x31555, 0x3176D,
	0x319A0, 0x31AC3, 0x31BD2, 0x31CE3, 0x31ECA, 0x320A8, 0x3226E, 0x323FE,
	0x32580, 0x326F4, 0x32860, 0x329BE, 0x32B37, 0x32CAB, 0x32E3A, 0x32FFC,
	0x331D6, 0x333B0, 0x3358A, 0x33764, 0x3393E, 0x33B18, 0x33CF3, 0x33ECD,
	0x340A7, 0x34281, 0x3445B, 0x34635, 0x34810, 0x349EB, 0x34AD6, 0x34C9B,
	0x34E56, 0x35010, 0x351C3, 0x35375, 0x354C5, 0x355C5, 0x35653, 0x35726,
	0x35840, 0x35990, 0x35B2B, 0x35CF4, 0x35DE4, 0x35ED5, 0x360AB, 0x36279,
	0x36427, 0x365A6, 0x366D2, 0x36780, 0x36819, 0x3687D, 0x368D6, 0x36948,
	0x369F6, 0x36AC8, 0x36BA6, 0x36C90, 0x36D92, 0x36EB8, 0x3701A, 0x371AC,
	0x37363, 0x3752D, 0x37704, 0x3789D, 0x379FF, 0x37B42, 0x37C69, 0x37D38,
	0x37DDB, 0x37E63, 0x37EED, 0x37F8E, 0x38054, 0x3813E, 0x3824C, 0x3837E,
	0x383D7, 0x38431, 0x3848B, 0x384E5, 0x3853E, 0x38598, 0x385F2, 0x3864C,
	0x386D4, 0x3875E, 0x387E6, 0x38870, 0x388F7, 0x38969, 0x389CF, 0x38A32,
	0x38A95, 0x38AF8, 0x38B49, 0x38B6F, 0x38D4A, 0x38E4C, 0x38F6D, 0x3915D,
	0x2B9D7, 0x2BACB, 0x2BBC0, 0x2BD7C, 0x2BF38, 0x2C106, 0x2C1F8, 0x2C2E9,
	0x2C3DC, 0x2C4D0, 0x2C5C2, 0x2C788, 0x2C942, 0x2CAFF, 0x2CCCA, 0x2CE9B,
	0x2CF91, 0x2D083, 0x2D24D, 0x2D40E, 0x2D5CF, 0x2D795, 0x2D966, 0x2DA59,
	0x2DB4E, 0x2DC39, 0x2DD18, 0x2DDDB, 0x2DE7D, 0x2DF0A, 0x2DFD9, 0x2E094,
	0x2E0D6, 0x2E130, 0x2E170, 0x2E1B9, 0x2E214, 0x2E293, 0x2E308, 0x2E36E,
	0x2E3B9, 0x2E401, 0x2E443, 0x2E48E, 0x2E4E9, 0x2E569, 0x2E5DF, 0x2E645,
	0x2E692, 0x2E6DC, 0x2E763, 0x2E7E1, 0x2E867, 0x2E8C6, 0x2E972, 0x2EA3A,
	0x2EAAF, 0x2EB2F, 0x2EBDB, 0x2EC43, 0x2EC8B, 0x2ECD3, 0x2ED1A, 0x2ED60,
	0x2EDA8, 0x2EE32, 0x2EF19, 0x2EFD5, 0x2F069, 0x2F0B2, 0x2F11D, 0x2F1B9,
	0x2F285, 0x2F30A, 0x2F39E, 0x2F431, 0x2F4D1, 0x2F54E, 0x2F5B9, 0x2F61C,
	0x2F68C, 0x2F705, 0x2F796, 0x2F839, 0x2F8CA, 0x2F962, 0x2F9EC, 0x2FA7C,
	0x2FB0D, 0x2FC08, 0x2FCE8, 0x2FD61, 0x2FDD4, 0x2FE48, 0x2FEBA, 0x2FF26,
	0x2FFAF, 0x30040, 0x300BA, 0x3012E, 0x301AF, 0x3027A, 0x30321, 0x30372,
	0x303B9, 0x303F8, 0x3043A, 0x304C2, 0x30541, 0x30578, 0x30601, 0x30690,
	0x30707, 0x30750, 0x30794, 0x30811, 0x308FA, 0x309F0, 0x30A74, 0x30AE9,
	0x30B5C, 0x30BCC, 0x30C38, 0x30CC0, 0x30D4F, 0x30DC8, 0x30E3B, 0x31015,
	0x311CE, 0x3137B, 0x31512, 0x3169F, 0x31807, 0x31921, 0x319C2, 0x31A27,
	0x31A82, 0x31ABE, 0x31C9B, 0x31E7F, 0x32040, 0x321D6, 0x322F6, 0x3238A,
	0x323D4, 0x32420, 0x32474, 0x324D9, 0x3254B, 0x325CF, 0x32659, 0x326C1,
	0x326CF, 0x32897, 0x32A64, 0x32B5B, 0x32C53, 0x32D4C, 0x32E3F, 0x32F2C,
	0x33013, 0x330F9, 0x331D9, 0x332BC, 0x333AD, 0x3359C, 0x3376B, 0x33854,
	0x33932, 0x339FF, 0x33AC0, 0x33B72, 0x33C1F, 0x33CBE, 0x33DFD, 0x33F3B,
	0x34070, 0x341A4, 0x342D2, 0x343FC, 0x34522, 0x34654, 0x34700, 0x34855,
	0x34991, 0x28D75, 0x2903C, 0x292F0, 0x29562, 0x297CB, 0x298EF, 0x299F6,
	0x29AE4, 0x29B54, 0x29CEA, 0x29E90, 0x2A03A, 0x2A1E4, 0x2A39E, 0x2A578,
	0x2A67C, 0x2A84B, 0x2A9D1, 0x2AB7E, 0x2AD36, 0x2AEF3, 0x2B08C, 0x2B223,
	0x2B3DE, 0x2B595, 0x2B74A, 0x2B7C6, 0x2B847, 0x2B8CE, 0x2B952
};

const char *Resource::_splNames[] = {
	"pneuma05.spl",
	"bip00105.spl",
	"bip00205.spl",
	"laser205.spl",
	"tir2",
	"explo.spl",
	"mort0105.spl",
	"mort0310.spl",
	"bouclier.spl",
	"asc_debut",
	"asc_milieu",
	"asc_fin",
	"verre_casse",
	"chalu110.spl",
	"saut.spl",
	"trappe.spl",
	"impact_shield.spl",
	"stby0105.spl",
	"teletower.spl",
	"desint.spl",
	"recharge.spl",
	"mitrail.spl",
	"touche.spl",
	"coup",
	"chenille.spl",
	"robot",
	"tombe.spl",
	"porte_ferme.spl",
	"canon_down",
	"elec.spl",
	"mater210.spl",
	"mater07.spl",
	"mur_bouge.spl",
	"taxi.spl",
	"souris.spl",
	"et.spl",
	"et_touche.spl",
	"et_transform.spl",
	"alien_move.spl",
	"jungle2",
	"jungle1",
	"piaf2",
	"goute_eau",
	"piaf1",
	"pas1",
	"pas2",
	"croa",
	"alien1",
	"alien2",
	"alien3",
	"ventilo",
	"poussiere",
	"bip",
	"electri",
	"machine",
	"alarme2",
	"cerveau",
	"reflet",
	"roule_boule",
	"hehe3",
	"recept",
	"bestiole",
	"lampe",
	"mine",
	"effort",
	"frappe",
	0
};

const uint8_t Resource::_gameSavedSoundData[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x06, 0x06, 0xfd, 0x00, 0xff, 0xfc, 0x00, 0xff, 0xfd, 0x00,
	0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff,
	0x00, 0xff, 0xfd, 0xfe, 0xfa, 0xfd, 0xfc, 0xfd, 0x07, 0x09, 0x07, 0x00, 0x04, 0x01, 0x02, 0x05,
	0x01, 0x04, 0xfe, 0x02, 0x04, 0x06, 0x03, 0x02, 0x02, 0x00, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xfb,
	0xfe, 0xfc, 0xfd, 0xfe, 0xfd, 0xfd, 0xff, 0xff, 0xfe, 0x01, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xff, 0x00, 0xff, 0x01, 0x02,
	0x00, 0x01, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00, 0x01, 0x03, 0x00, 0x02, 0x00, 0x00, 0x01, 0xff,
	0x00, 0x00, 0xff, 0xfe, 0xff, 0xfd, 0xfe, 0xff, 0xfb, 0xfc, 0xf9, 0xf8, 0xf7, 0xf5, 0xf5, 0xf5,
	0xf2, 0xf3, 0xf3, 0xf3, 0xf6, 0xf5, 0xf7, 0xfd, 0xfa, 0xfc, 0x05, 0x00, 0x02, 0x07, 0x06, 0x04,
	0x06, 0x08, 0x02, 0x04, 0x00, 0x00, 0xfe, 0xf8, 0xfd, 0xfb, 0xf4, 0xfa, 0x01, 0xf8, 0xfe, 0x0a,
	0x02, 0x04, 0x0e, 0x0d, 0x07, 0x0e, 0x0e, 0x08, 0x06, 0x07, 0x02, 0xfe, 0xfc, 0xf9, 0xf3, 0xef,
	0xf2, 0xee, 0xeb, 0xed, 0xec, 0xe7, 0xe6, 0xe9, 0xe3, 0xde, 0xdf, 0xdf, 0xd9, 0xea, 0xf1, 0xda,
	0x00, 0x02, 0xf0, 0x0c, 0x0c, 0x0c, 0x02, 0x15, 0x0c, 0x01, 0x08, 0xfb, 0x01, 0xee, 0xf1, 0xf3,
	0xe9, 0xe7, 0xe8, 0xf3, 0xe7, 0xf1, 0xfc, 0xfa, 0xff, 0x02, 0x0d, 0x07, 0x0f, 0x18, 0x0e, 0x13,
	0x14, 0x0e, 0x09, 0x0b, 0x02, 0x01, 0x00, 0xfd, 0x00, 0xff, 0x00, 0x01, 0x03, 0xff, 0x01, 0x00,
	0xfc, 0xf9, 0xf8, 0xf2, 0xec, 0xee, 0xe0, 0xd8, 0xda, 0xd6, 0xca, 0xd2, 0xd6, 0xed, 0xf6, 0xe7,
	0x1a, 0x1d, 0x0f, 0x23, 0x31, 0x26, 0x10, 0x22, 0x0f, 0xff, 0xf8, 0xed, 0xee, 0xdd, 0xdf, 0xe4,
	0xed, 0xed, 0xf4, 0x0d, 0x0b, 0x13, 0x1e, 0x24, 0x1f, 0x1c, 0x24, 0x17, 0x10, 0x0c, 0x08, 0xfe,
	0xfc, 0xfb, 0xfb, 0xfe, 0x00, 0x09, 0x0d, 0x13, 0x17, 0x1b, 0x18, 0x15, 0x0f, 0x07, 0x00, 0xf7,
	0xf0, 0xe8, 0xe4, 0xdf, 0xd6, 0xd6, 0xd4, 0xd2, 0xdd, 0xd3, 0xe1, 0xf5, 0x19, 0x09, 0x03, 0x4b,
	0x21, 0x18, 0x26, 0x20, 0x0b, 0xf0, 0xff, 0xe2, 0xe9, 0xdc, 0xd8, 0xf5, 0xf0, 0xf8, 0x05, 0x1f,
	0x18, 0x19, 0x2b, 0x1c, 0x1a, 0x0e, 0x05, 0xfb, 0xf3, 0xfa, 0xf1, 0xf6, 0x04, 0x08, 0x09, 0x1b,
	0x21, 0x1c, 0x21, 0x21, 0x1b, 0x15, 0x0f, 0x07, 0x04, 0xfd, 0xf6, 0xf5, 0xf2, 0xed, 0xef, 0xf1,
	0xf5, 0xf4, 0xf1, 0xf5, 0xe9, 0xe9, 0xee, 0xd7, 0xcb, 0xdf, 0xf6, 0x09, 0xef, 0x0b, 0x3b, 0x1a,
	0x18, 0x1e, 0x24, 0x0b, 0xf6, 0xf9, 0xea, 0xf0, 0xdd, 0xe0, 0xf9, 0xfc, 0x00, 0x07, 0x21, 0x1d,
	0x19, 0x1d, 0x14, 0x11, 0x00, 0xf7, 0xf2, 0xfa, 0xf9, 0xfe, 0x0c, 0x11, 0x19, 0x1f, 0x24, 0x1d,
	0x1d, 0x17, 0x0e, 0x08, 0x03, 0x00, 0xfd, 0xfc, 0xfa, 0xfa, 0xf8, 0xf7, 0xf4, 0xf2, 0xf5, 0xf5,
	0xf0, 0xee, 0xe5, 0xdc, 0xe4, 0xd3, 0xc3, 0xcf, 0xfb, 0x26, 0xef, 0x16, 0x46, 0x23, 0x20, 0x0a,
	0x14, 0xfc, 0xec, 0xdf, 0xcb, 0xf3, 0xe7, 0xe1, 0x00, 0x15, 0x1d, 0x16, 0x28, 0x20, 0x16, 0x12,
	0xf4, 0xf4, 0xeb, 0xe9, 0xeb, 0xf8, 0x03, 0x0f, 0x25, 0x22, 0x2a, 0x2f, 0x24, 0x11, 0x10, 0x05,
	0xf8, 0xf9, 0xf9, 0xfa, 0xfe, 0x01, 0x00, 0x03, 0x00, 0xf7, 0xf5, 0xf8, 0xed, 0xe5, 0xe7, 0xdf,
	0xd0, 0xd7, 0xcc, 0xc8, 0xc7, 0xee, 0x55, 0x0b, 0xf4, 0x4a, 0x3a, 0x13, 0xec, 0x00, 0xf3, 0xdc,
	0xde, 0xbd, 0xec, 0x0f, 0xf3, 0x01, 0x24, 0x3a, 0x18, 0x15, 0x19, 0xfd, 0x00, 0xe1, 0xd7, 0xe1,
	0xf7, 0xf5, 0xfd, 0x22, 0x2b, 0x30, 0x29, 0x2a, 0x21, 0x17, 0xfe, 0xf5, 0xfd, 0xf9, 0xf7, 0xff,
	0x0d, 0x0a, 0x0b, 0x01, 0xfd, 0xf7, 0xea, 0xe8, 0xe8, 0xe3, 0xdd, 0xdf, 0xd2, 0xcf, 0xd4, 0xc9,
	0xba, 0x1b, 0x4f, 0xe6, 0x15, 0x52, 0x26, 0x02, 0xf3, 0xfc, 0xe1, 0xe3, 0xd6, 0xbe, 0x00, 0x10,
	0xf2, 0x0f, 0x2f, 0x31, 0x10, 0x17, 0x0a, 0xf3, 0xfb, 0xd9, 0xd6, 0xea, 0xfc, 0xfb, 0x0c, 0x29,
	0x2c, 0x31, 0x29, 0x23, 0x1a, 0x0e, 0xf8, 0xf5, 0xfc, 0xfa, 0xfd, 0x07, 0x11, 0x0e, 0x0f, 0x05,
	0xfe, 0xf4, 0xe6, 0xd9, 0xda, 0xdd, 0xd2, 0xd3, 0xd7, 0xcc, 0xca, 0xe2, 0xd9, 0x2c, 0x45, 0xea,
	0x25, 0x43, 0x19, 0xec, 0xea, 0xfd, 0xd5, 0xdd, 0xdd, 0xd5, 0x0d, 0x11, 0x00, 0x19, 0x31, 0x2b,
	0x00, 0x10, 0x00, 0xec, 0xed, 0xda, 0xe3, 0xf0, 0x08, 0x08, 0x18, 0x2c, 0x2f, 0x29, 0x21, 0x1a,
	0x0c, 0x05, 0xf9, 0xf8, 0xfc, 0x01, 0x04, 0x0b, 0x10, 0x0d, 0x08, 0x00, 0xf8, 0xea, 0xe2, 0xdb,
	0xdc, 0xd4, 0xd8, 0xe1, 0xcf, 0xcd, 0xe2, 0xca, 0xdf, 0x5f, 0x11, 0xdc, 0x4c, 0x3c, 0x00, 0xe6,
	0x03, 0xf3, 0xd2, 0xea, 0xcc, 0xe4, 0x1c, 0xf9, 0xfd, 0x24, 0x37, 0x11, 0x04, 0x1d, 0xf6, 0xf6,
	0xea, 0xdc, 0xeb, 0xf8, 0xfe, 0x02, 0x23, 0x29, 0x27, 0x28, 0x29, 0x18, 0x0e, 0x04, 0xf8, 0xfd,
	0xfd, 0xfb, 0x01, 0x10, 0x0b, 0x08, 0x06, 0x01, 0xf8, 0xea, 0xdf, 0xe1, 0xe0, 0xd1, 0xd1, 0xd7,
	0xd6, 0xc4, 0xcc, 0xc7, 0x16, 0x46, 0xe1, 0x1b, 0x5a, 0x26, 0xfc, 0xf8, 0x0d, 0xe5, 0xd4, 0xd5,
	0xcb, 0xfe, 0xfc, 0xe7, 0x13, 0x2f, 0x2a, 0x0b, 0x22, 0x1a, 0xff, 0xf9, 0xdf, 0xe9, 0xee, 0xeb,
	0xef, 0x0b, 0x1e, 0x1e, 0x26, 0x2d, 0x2e, 0x1f, 0x10, 0x07, 0x04, 0xfc, 0xf3, 0xf9, 0x03, 0x05,
	0x01, 0x04, 0x06, 0x01, 0xf2, 0xe6, 0xe9, 0xe9, 0xda, 0xd4, 0xdf, 0xd4, 0xcf, 0xd4, 0xd5, 0xb4,
	0x0a, 0x54, 0xd3, 0x10, 0x67, 0x23, 0xfe, 0x05, 0x16, 0xe4, 0xe0, 0xda, 0xc4, 0x00, 0xf1, 0xd8,
	0x0e, 0x2e, 0x1b, 0x07, 0x33, 0x1e, 0x06, 0x06, 0xec, 0xf3, 0xf2, 0xe6, 0xe8, 0x09, 0x0d, 0x0f,
	0x25, 0x2f, 0x28, 0x24, 0x1e, 0x0e, 0x0b, 0x00, 0xf4, 0xfa, 0x00, 0xfb, 0xfc, 0x01, 0xff, 0xfc,
	0xf0, 0xf1, 0xf3, 0xe7, 0xdc, 0xdd, 0xe0, 0xd5, 0xc8, 0xc8, 0xc8, 0xc0, 0x2e, 0x1d, 0xd1, 0x4d,
	0x54, 0x0c, 0x04, 0x25, 0x0b, 0xda, 0xe8, 0xd1, 0xdc, 0xf4, 0xd0, 0xea, 0x1a, 0x19, 0x04, 0x24,
	0x38, 0x0f, 0x16, 0x0b, 0xff, 0xfc, 0xee, 0xe6, 0xf3, 0x00, 0xf8, 0x11, 0x24, 0x1f, 0x23, 0x2b,
	0x1e, 0x16, 0x11, 0x02, 0x00, 0x00, 0xfa, 0xf8, 0xfb, 0xf4, 0xf7, 0xf1, 0xea, 0xf1, 0xe9, 0xdc,
	0xe8, 0xec, 0xd5, 0xd7, 0xde, 0xca, 0xae, 0x18, 0x1a, 0xba, 0x2c, 0x4d, 0x02, 0x07, 0x32, 0x17,
	0xf0, 0x00, 0xe6, 0xea, 0xf9, 0xcf, 0xe5, 0x0e, 0xfe, 0xef, 0x1f, 0x28, 0x03, 0x1d, 0x1b, 0x0a,
	0x0b, 0x02, 0xf9, 0x01, 0xff, 0xf5, 0x0c, 0x10, 0x07, 0x14, 0x1e, 0x13, 0x15, 0x16, 0x11, 0x10,
	0x08, 0x05, 0x06, 0xfc, 0xf2, 0xf7, 0xee, 0xe3, 0xe5, 0xe6, 0xdc, 0xdd, 0xdf, 0xe0, 0xe8, 0xd4,
	0xc6, 0xcd, 0x23, 0xf9, 0xb9, 0x41, 0x36, 0xee, 0x0a, 0x3a, 0x15, 0xea, 0x06, 0xfb, 0x00, 0xe8,
	0xd9, 0x07, 0x00, 0xe4, 0xfb, 0x28, 0x06, 0xfa, 0x23, 0x18, 0x08, 0x0a, 0x0e, 0x0c, 0x07, 0xfa,
	0x05, 0x10, 0xfe, 0x02, 0x14, 0x0e, 0x08, 0x16, 0x16, 0x10, 0x0f, 0x10, 0x10, 0x07, 0xfc, 0xfe,
	0xfa, 0xe9, 0xe8, 0xe9, 0xdd, 0xda, 0xe2, 0xdf, 0xd9, 0xde, 0xd1, 0xcf, 0xcb, 0x00, 0x06, 0xce,
	0x25, 0x2d, 0xff, 0x12, 0x2c, 0x15, 0xfc, 0x10, 0xfc, 0xff, 0xf4, 0xe6, 0xff, 0xfb, 0xeb, 0xfc,
	0x15, 0x00, 0x00, 0x1c, 0x10, 0x09, 0x14, 0x0f, 0x09, 0x0a, 0x03, 0x04, 0x04, 0x00, 0x05, 0x08,
	0x06, 0x0c, 0x11, 0x0f, 0x13, 0x15, 0x12, 0x11, 0x0d, 0x07, 0x03, 0xfc, 0xf4, 0xf0, 0xe8, 0xe0,
	0xde, 0xdb, 0xd6, 0xd4, 0xd4, 0xce, 0xd4, 0xc3, 0xf4, 0x0a, 0xca, 0x1e, 0x2d, 0xf3, 0x17, 0x32,
	0x0f, 0x00, 0x20, 0x04, 0x00, 0x00, 0xf2, 0x03, 0xf6, 0xec, 0x00, 0x08, 0xf1, 0x03, 0x15, 0xfe,
	0x09, 0x18, 0x0a, 0x07, 0x13, 0x0b, 0x05, 0x06, 0x08, 0x07, 0x02, 0x07, 0x0d, 0x08, 0x0a, 0x15,
	0x11, 0x0f, 0x15, 0x11, 0x0a, 0x0a, 0x03, 0xfd, 0xf7, 0xf0, 0xea, 0xe4, 0xda, 0xdb, 0xd7, 0xcb,
	0xce, 0xd2, 0xc2, 0xda, 0x06, 0xc9, 0xff, 0x2b, 0xea, 0x11, 0x2c, 0x11, 0x0a, 0x26, 0x0e, 0x0b,
	0x0f, 0xfc, 0x0d, 0xfc, 0xf1, 0x05, 0xfe, 0xeb, 0x02, 0x06, 0xef, 0x03, 0x0d, 0x01, 0x04, 0x0f,
	0x0f, 0x07, 0x0d, 0x11, 0x0a, 0x06, 0x0e, 0x0b, 0x06, 0x0e, 0x10, 0x0b, 0x0f, 0x13, 0x0c, 0x0b,
	0x0c, 0x06, 0xff, 0xfb, 0xf8, 0xef, 0xe7, 0xe2, 0xdf, 0xd6, 0xd5, 0xcf, 0xcd, 0xc7, 0xde, 0xee,
	0xc3, 0x04, 0x06, 0xe2, 0x15, 0x14, 0x08, 0x13, 0x21, 0x11, 0x17, 0x12, 0x11, 0x14, 0xfe, 0x0c,
	0x0b, 0xf7, 0xff, 0x06, 0xf3, 0xf9, 0x02, 0xfa, 0xfe, 0x02, 0x02, 0x05, 0x04, 0x09, 0x0a, 0x06,
	0x0d, 0x0c, 0x08, 0x0f, 0x0f, 0x0b, 0x12, 0x12, 0x0e, 0x10, 0x0d, 0x0a, 0x09, 0x04, 0xff, 0xfb,
	0xf8, 0xef, 0xe9, 0xe4, 0xe4, 0xd8, 0xd9, 0xd5, 0xd1, 0xcd, 0xe7, 0xde, 0xce, 0x0e, 0xe7, 0xf0,
	0x15, 0x00, 0x0b, 0x15, 0x15, 0x14, 0x19, 0x0f, 0x1d, 0x0c, 0x08, 0x18, 0x02, 0x02, 0x0c, 0xfd,
	0xfb, 0x03, 0xfa, 0xfd, 0x00, 0xfe, 0x00, 0x00, 0x03, 0x06, 0x02, 0x09, 0x09, 0x06, 0x0e, 0x0c,
	0x0a, 0x11, 0x10, 0x0e, 0x12, 0x0d, 0x0b, 0x0c, 0x08, 0x02, 0xff, 0xfe, 0xf8, 0xee, 0xef, 0xe9,
	0xe3, 0xe1, 0xde, 0xd9, 0xd8, 0xd3, 0xe1, 0xe1, 0xd1, 0x01, 0xe7, 0xe8, 0x0e, 0xf9, 0x06, 0x0e,
	0x10, 0x0f, 0x15, 0x11, 0x1a, 0x0e, 0x0d, 0x1a, 0x05, 0x0a, 0x0e, 0x00, 0x00, 0x05, 0xfa, 0xff,
	0x00, 0xfb, 0xfe, 0xff, 0x00, 0x00, 0x02, 0x04, 0x04, 0x04, 0x0a, 0x08, 0x09, 0x0f, 0x0c, 0x0c,
	0x10, 0x0b, 0x09, 0x0c, 0x07, 0x02, 0x00, 0xff, 0xf9, 0xf3, 0xf1, 0xec, 0xe9, 0xe5, 0xe1, 0xdf,
	0xdc, 0xd9, 0xdd, 0xe4, 0xdb, 0xee, 0xf3, 0xe8, 0xff, 0xff, 0x00, 0x08, 0x0e, 0x0b, 0x0e, 0x15,
	0x0f, 0x11, 0x0f, 0x12, 0x0d, 0x0a, 0x0c, 0x07, 0x03, 0x03, 0x03, 0xff, 0x00, 0x00, 0xfe, 0xff,
	0x01, 0x00, 0x00, 0x03, 0x02, 0x04, 0x07, 0x08, 0x09, 0x0b, 0x0c, 0x0d, 0x0d, 0x0c, 0x0c, 0x0b,
	0x09, 0x06, 0x03, 0x02, 0xfc, 0xf8, 0xf8, 0xf4, 0xee, 0xeb, 0xeb, 0xe7, 0xe4, 0xe2, 0xe1, 0xe4,
	0xe8, 0xe8, 0xee, 0xf5, 0xf5, 0xf9, 0x00, 0x04, 0x06, 0x08, 0x0c, 0x0e, 0x0e, 0x0e, 0x10, 0x0f,
	0x0e, 0x0d, 0x0c, 0x0a, 0x08, 0x06, 0x05, 0x04, 0x03, 0x01, 0x00, 0x01, 0x02, 0x01, 0x02, 0x04,
	0x05, 0x06, 0x07, 0x09, 0x0a, 0x0a, 0x0c, 0x0c, 0x0a, 0x0b, 0x0c, 0x09, 0x07, 0x07, 0x07, 0x01,
	0x00, 0x00, 0xfc, 0xf9, 0xf6, 0xf4, 0xf2, 0xee, 0xeb, 0xea, 0xe9, 0xe6, 0xe6, 0xeb, 0xed, 0xec,
	0xef, 0xf2, 0xf5, 0xf9, 0xfe, 0x00, 0x04, 0x08, 0x09, 0x0b, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0a,
	0x08, 0x07, 0x05, 0x04, 0x03, 0x02, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03, 0x05, 0x07, 0x09, 0x0a,
	0x0d, 0x10, 0x10, 0x10, 0x12, 0x12, 0x0f, 0x0e, 0x0e, 0x0d, 0x07, 0x06, 0x06, 0x01, 0xfe, 0xfc,
	0xfa, 0xf6, 0xf3, 0xf0, 0xef, 0xec, 0xe9, 0xea, 0xec, 0xef, 0xf0, 0xf3, 0xf6, 0xf8, 0xfc, 0x00,
	0x03, 0x04, 0x07, 0x09, 0x09, 0x09, 0x09, 0x0a, 0x09, 0x08, 0x07, 0x05, 0x04, 0x03, 0x02, 0x01,
	0x00, 0xfe, 0xfe, 0xfe, 0xfd, 0xfd, 0xfc, 0xfd, 0xfe, 0xfd, 0xfe, 0xff, 0x00, 0x00, 0xff, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfd, 0xfc, 0xfc, 0xf8, 0xf6, 0xf4, 0xf1, 0xee, 0xec, 0xea, 0xe8,
	0xe5, 0xe2, 0xe5, 0xe7, 0xe8, 0xea, 0xee, 0xf1, 0xf4, 0xfa, 0xfd, 0x00, 0x03, 0x04, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x09, 0x08, 0x08, 0x07, 0x06, 0x05, 0x05, 0x04, 0x02, 0x01, 0x01, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02, 0x00, 0x01, 0x00, 0x00,
	0xfd, 0xfc, 0xfb, 0xf7, 0xf5, 0xf2, 0xf0, 0xec, 0xe9, 0xe8, 0xe5, 0xe2, 0xe0, 0xe4, 0xe4, 0xe5,
	0xe9, 0xec, 0xf0, 0xf4, 0xfa, 0xfd, 0x00, 0x03, 0x04, 0x05, 0x08, 0x08, 0x08, 0x0a, 0x09, 0x08,
	0x08, 0x07, 0x07, 0x06, 0x05, 0x05, 0x04, 0x01, 0x01, 0x02, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01,
	0x02, 0x02, 0x02, 0x03, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0xfd, 0xfc, 0xfc, 0xf8, 0xf5,
	0xf3, 0xf1, 0xed, 0xeb, 0xe9, 0xe7, 0xe4, 0xe3, 0xe7, 0xe7, 0xe7, 0xec, 0xef, 0xf2, 0xf7, 0xfb,
	0xfe, 0x01, 0x04, 0x06, 0x07, 0x09, 0x0a, 0x0a, 0x0b, 0x0b, 0x0a, 0x09, 0x08, 0x08, 0x07, 0x06,
	0x06, 0x05, 0x03, 0x03, 0x03, 0x02, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x02, 0x02, 0x02, 0x00, 0xff, 0xff, 0xfd, 0xfa, 0xf8, 0xf6, 0xf4, 0xf1, 0xef, 0xed,
	0xeb, 0xe9, 0xe7, 0xe8, 0xe8, 0xe9, 0xec, 0xee, 0xf2, 0xf5, 0xf9, 0xfd, 0x00, 0x02, 0x06, 0x08,
	0x09, 0x0a, 0x0c, 0x0c, 0x0c, 0x0b, 0x0a, 0x09, 0x09, 0x08, 0x07, 0x06, 0x06, 0x04, 0x03, 0x03,
	0x03, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x04, 0x03,
	0x02, 0x02, 0x00, 0xff, 0xfe, 0xfb, 0xfa, 0xf7, 0xf5, 0xf3, 0xf1, 0xef, 0xee, 0xec, 0xea, 0xea,
	0xe9, 0xeb, 0xed, 0xee, 0xf0, 0xf3, 0xf8, 0xfb, 0xfe, 0x00, 0x04, 0x06, 0x07, 0x09, 0x0a, 0x0b,
	0x0b, 0x0a, 0x0a, 0x09, 0x08, 0x07, 0x06, 0x06, 0x05, 0x03, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfd,
	0xfc, 0xfa, 0xf9, 0xf7, 0xf6, 0xf4, 0xf2, 0xf1, 0xf0, 0xef, 0xee, 0xed, 0xec, 0xec, 0xee, 0xee,
	0xf0, 0xf2, 0xf4, 0xf6, 0xfa, 0xfe, 0x00, 0x03, 0x06, 0x08, 0x0a, 0x0b, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0a, 0x0a, 0x0a, 0x0a, 0x08, 0x08, 0x07, 0x06, 0x06, 0x06, 0x06, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x05, 0x05, 0x04, 0x03, 0x02, 0x00, 0x00, 0xfe,
	0xfd, 0xfb, 0xf9, 0xf8, 0xf7, 0xf5, 0xf4, 0xf3, 0xf1, 0xf0, 0xef, 0xee, 0xee, 0xef, 0xf0, 0xf2,
	0xf4, 0xf6, 0xfa, 0xfe, 0x00, 0x02, 0x05, 0x06, 0x08, 0x0a, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0a,
	0x08, 0x09, 0x09, 0x08, 0x07, 0x07, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x05, 0x06, 0x06, 0x06,
	0x07, 0x06, 0x07, 0x07, 0x07, 0x07, 0x06, 0x05, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0xff, 0xfd,
	0xfc, 0xfb, 0xfa, 0xf9, 0xf8, 0xf7, 0xf6, 0xf6, 0xf5, 0xf5, 0xf5, 0xf4, 0xf5, 0xf6, 0xf6, 0xf7,
	0xf9, 0xfb, 0xfc, 0xfd, 0xff, 0x01, 0x02, 0x04, 0x05, 0x07, 0x08, 0x08, 0x09, 0x09, 0x09, 0x09,
	0x08, 0x07, 0x07, 0x08, 0x08, 0x07, 0x07, 0x07, 0x07, 0x07, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x02, 0x02, 0x01, 0x00,
	0x00, 0xff, 0xfd, 0xfc, 0xfb, 0xfb, 0xfa, 0xf9, 0xf8, 0xf8, 0xf7, 0xf6, 0xf6, 0xf5, 0xf4, 0xf4,
	0xf4, 0xf3, 0xf2, 0xf2, 0xf3, 0xf4, 0xf3, 0xf4, 0xf5, 0xf6, 0xf8, 0xfa, 0xfa, 0xfc, 0xfd, 0xfe,
	0xff, 0x00, 0x01, 0x03, 0x05, 0x07, 0x08, 0x0b, 0x0c, 0x0d, 0x0f, 0x0f, 0x10, 0x10, 0x10, 0x10,
	0x0e, 0x0d, 0x0c, 0x0a, 0x09, 0x08, 0x07, 0x07, 0x05, 0x05, 0x05, 0x03, 0x01, 0x00, 0xff, 0xfc,
	0xfc, 0xf9, 0xfa, 0xf9, 0xf9, 0xfb, 0xf8, 0xfb, 0xf9, 0xfb, 0xf9, 0xfc, 0xf9, 0xfc, 0xfc, 0xf9,
	0xfc, 0xf8, 0xfe, 0xf6, 0xf9, 0xf6, 0xf8, 0xf7, 0xf5, 0xf7, 0xf5, 0xf8, 0xf5, 0xf8, 0xf5, 0xf9,
	0xf6, 0xf8, 0xf8, 0xf6, 0xfa, 0xf7, 0xfa, 0xf8, 0xf9, 0xfa, 0xf8, 0xf8, 0xf8, 0xf9, 0xf8, 0xf7,
	0xf8, 0xf7, 0xf8, 0xf8, 0xf7, 0xf9, 0xfa, 0xfb, 0xfb, 0xfd, 0xfd, 0xff, 0xff, 0x00, 0x03, 0x05,
	0x04, 0x05, 0x07, 0x09, 0x0a, 0x09, 0x0a, 0x0b, 0x0a, 0x0a, 0x0b, 0x0a, 0x0a, 0x09, 0x0a, 0x09,
	0x07, 0x06, 0x05, 0x03, 0x03, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x01, 0x03, 0x02, 0x04, 0x05, 0x05, 0x05, 0x05, 0x06, 0x05, 0x04, 0x04, 0x03,
	0x03, 0x00, 0x00, 0xff, 0xfe, 0xfe, 0xfd, 0xfd, 0xfc, 0xfc, 0xfb, 0xfc, 0xfb, 0xfb, 0xfb, 0xfb,
	0xfb, 0xfa, 0xfa, 0xf9, 0xfb, 0xf9, 0xf9, 0xf9, 0xfa, 0xfa, 0xf8, 0xfa, 0xfa, 0xfa, 0xf9, 0xfa,
	0xf9, 0xfa, 0xfa, 0xfa, 0xf9, 0xf8, 0xf9, 0xf7, 0xf9, 0xf9, 0xf9, 0xf8, 0xf9, 0xf8, 0xf9, 0xf8,
	0xf9, 0xf8, 0xf8, 0xf8, 0xf8, 0xf9, 0xf6, 0xf8, 0xf7, 0xf7, 0xf8, 0xf7, 0xf9, 0xf9, 0xf9, 0xfa,
	0xfb, 0xfb, 0xfa, 0xfc, 0xfc, 0xfd, 0xfc, 0xfc, 0xfe, 0xfc, 0xfe, 0xfd, 0xff, 0xfe, 0xff, 0xfe,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xfd, 0xff, 0x00, 0xff, 0xfe, 0xff, 0xff, 0x00,
	0xfe, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x01, 0x01, 0x00, 0x03, 0x01, 0x02, 0x00, 0x02, 0x01,
	0x00, 0x01, 0x01, 0x02, 0x00, 0x01, 0x01, 0x02, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfe, 0x01, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0xfe, 0x00, 0xff, 0xff, 0xfe, 0xff,
	0xff, 0xff, 0xff, 0xfe, 0x00, 0xff, 0x00, 0xfe, 0x00, 0xff, 0xfe, 0xff, 0xfe, 0x01, 0xff, 0xff,
	0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x00, 0xff, 0xfe, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0xff, 0xff, 0x00, 0xfe, 0xfe,
	0xff, 0xff, 0x00, 0xff, 0xfe, 0x00, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0xfd, 0xff, 0xfe, 0xfe,
	0xfe, 0xfd, 0xfe, 0xfd, 0xfe, 0xfe, 0xfd, 0xfd, 0xff, 0xfd, 0xfe, 0xfd, 0xff, 0x00, 0xfe, 0xff,
	0xfe, 0x00, 0xfd, 0xff, 0xff, 0x00, 0x00, 0xfd, 0x00, 0xfe, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
	0xfe, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xfe, 0x00, 0x01, 0x00, 0x00, 0xff, 0x01,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,
	0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xfe, 0xff, 0x00,
	0xfe, 0xfe, 0xfe, 0xfe, 0xff, 0xff, 0xfe, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xfe, 0xfd, 0xff, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xfe,
	0xfe, 0xfe, 0xff, 0xff, 0xfe, 0xff, 0xff, 0x00, 0xfe, 0x00, 0xff, 0x00, 0x01, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0xfd,
	0xff, 0xff, 0xfd, 0xff, 0xfe, 0xff, 0x00, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xfe, 0x00, 0xff, 0xff,
	0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xfe, 0xff,
	0xff, 0xff, 0xff, 0xfe, 0x00, 0xfe, 0xfe, 0xfe, 0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0xfd, 0xfd, 0xfe,
	0xfd, 0xfd, 0xfc, 0xfe, 0xfd, 0xfc, 0xfc, 0xfd, 0xfb, 0xfb, 0xfb, 0xfb, 0xfd, 0xfc, 0xfb, 0xfc,
	0xfc, 0xfc, 0xfc, 0xfb, 0xff, 0xfc, 0xfd, 0xfc, 0xfc, 0xfd, 0xfc, 0xfd, 0xfb, 0xfd, 0xfd, 0xfc,
	0xfb, 0xfc, 0xfd, 0xfc, 0xfb, 0xfd, 0xfb, 0xfb, 0xfc, 0xfb, 0xfd, 0xfc, 0xfc, 0xfc, 0xfb, 0xfb,
	0xfd, 0xfd, 0xfc, 0xfc, 0xfb, 0xfd, 0xfc, 0xfd, 0xfc, 0xfd, 0xfe, 0xfd, 0xfd, 0xfc, 0xfe, 0xfc,
	0xfd, 0xfc, 0xfd, 0xfe, 0xfc, 0xfd, 0xfe, 0xfe, 0xfc, 0xfd, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xfe, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xfe, 0xff, 0x00, 0xfe, 0x00, 0xfe,
	0xff, 0x00, 0xfe, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x01,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0xff, 0x02, 0x01, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00,
	0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff,
	0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x00, 0xff,
	0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x02, 0x00, 0x04, 0x05, 0x02,
	0x03, 0x02, 0x04, 0x02, 0x00, 0xff, 0x02, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,
	0xfd, 0xfd, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfd, 0xfd, 0xfe, 0xff, 0xfe, 0xfd, 0xfd,
	0xfd, 0xfd, 0xfb, 0xfb, 0xfb, 0xf9, 0xf8, 0xf7, 0xf7, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf1, 0xef,
	0xed, 0xef, 0xf8, 0xfc, 0xfc, 0x00, 0x04, 0x08, 0x0a, 0x09, 0x08, 0x0b, 0x0b, 0x06, 0x03, 0x03,
	0x04, 0x02, 0x01, 0x02, 0x03, 0x06, 0x06, 0x05, 0x08, 0x0a, 0x0a, 0x0a, 0x0a, 0x0b, 0x0b, 0x08,
	0x04, 0x03, 0x02, 0x00, 0xfd, 0xfb, 0xfb, 0xfa, 0xf9, 0xf7, 0xf6, 0xf4, 0xf1, 0xee, 0xe9, 0xe3,
	0xdd, 0xd7, 0xd5, 0xef, 0xfb, 0xf1, 0xfd, 0x0b, 0x11, 0x15, 0x11, 0x09, 0x10, 0x12, 0x02, 0xfa,
	0xf8, 0xf4, 0xf1, 0xed, 0xe8, 0xee, 0xf9, 0xfb, 0xfb, 0x03, 0x0c, 0x11, 0x13, 0x11, 0x13, 0x18,
	0x14, 0x0c, 0x0a, 0x08, 0x04, 0x00, 0xfb, 0xfc, 0x00, 0x00, 0x00, 0x04, 0x09, 0x0c, 0x0c, 0x09,
	0x08, 0x07, 0x01, 0xfb, 0xf6, 0xf2, 0xee, 0xe8, 0xe2, 0xdd, 0xdc, 0xd6, 0xd2, 0xcc, 0xeb, 0x0f,
	0xff, 0x05, 0x1c, 0x23, 0x26, 0x1e, 0x0b, 0x0a, 0x12, 0xfd, 0xe7, 0xe5, 0xe6, 0xeb, 0xef, 0xe9,
	0xf0, 0x09, 0x17, 0x12, 0x15, 0x1f, 0x21, 0x1f, 0x10, 0x03, 0x04, 0x01, 0xf2, 0xe9, 0xf3, 0xfc,
	0x01, 0x05, 0x0b, 0x18, 0x20, 0x1b, 0x15, 0x17, 0x16, 0x0e, 0x05, 0x00, 0x01, 0x01, 0xfa, 0xf6,
	0xf9, 0xfb, 0xf9, 0xf7, 0xf7, 0xf9, 0xf7, 0xf0, 0xea, 0xe7, 0xde, 0xd9, 0xce, 0xd2, 0x0a, 0x06,
	0xf2, 0x13, 0x1e, 0x22, 0x22, 0x10, 0x02, 0x0d, 0x0a, 0xe5, 0xdf, 0xee, 0xeb, 0xf0, 0xf3, 0xf1,
	0x07, 0x1e, 0x14, 0x0b, 0x1b, 0x1b, 0x10, 0x07, 0xf6, 0xf2, 0xfa, 0xf2, 0xe1, 0xec, 0xfc, 0x01,
	0x0d, 0x12, 0x1c, 0x2a, 0x23, 0x14, 0x14, 0x0f, 0x04, 0xfc, 0xf6, 0xf9, 0x00, 0xff, 0xfc, 0x05,
	0x0b, 0x09, 0x04, 0x00, 0x00, 0x00, 0xf6, 0xed, 0xeb, 0xe7, 0xe0, 0xda, 0xd6, 0xd4, 0xd6, 0xd6,
	0x09, 0x20, 0x01, 0x1e, 0x2d, 0x22, 0x1e, 0x08, 0xf5, 0xf4, 0xf8, 0xdd, 0xce, 0xed, 0xf2, 0xf8,
	0x08, 0x07, 0x17, 0x29, 0x20, 0x09, 0x0c, 0x0d, 0xf6, 0xee, 0xe4, 0xde, 0xef, 0xf4, 0xee, 0xfa,
	0x14, 0x16, 0x14, 0x17, 0x14, 0x1b, 0x15, 0x03, 0xfd, 0x04, 0x01, 0xfb, 0xfb, 0x01, 0x0d, 0x10,
	0x09, 0x0b, 0x14, 0x0f, 0x05, 0x00, 0xff, 0xfc, 0xf5, 0xeb, 0xed, 0xf2, 0xee, 0xea, 0xeb, 0xee,
	0xed, 0xe4, 0xda, 0xdc, 0xd7, 0x08, 0x28, 0xf7, 0x0d, 0x28, 0x16, 0x11, 0x00, 0xf1, 0xf3, 0xfd,
	0xe8, 0xd1, 0xf9, 0x05, 0xfc, 0x0b, 0x09, 0x13, 0x21, 0x14, 0xfb, 0xfb, 0x08, 0xf1, 0xe7, 0xed,
	0xea, 0xfc, 0x02, 0xfa, 0x01, 0x17, 0x18, 0x05, 0x08, 0x03, 0x01, 0x07, 0xf8, 0xf9, 0x09, 0x0a,
	0x04, 0x0b, 0x0e, 0x12, 0x16, 0x09, 0x04, 0x0c, 0x06, 0xfa, 0xfc, 0xfd, 0xfd, 0xff, 0xfc, 0xfb,
	0x00, 0xfd, 0xf4, 0xf4, 0xf1, 0xef, 0xec, 0xe8, 0xe2, 0xe1, 0xda, 0xd1, 0xd4, 0x00, 0x2c, 0x01,
	0x08, 0x33, 0x1f, 0x18, 0x03, 0xe8, 0xf0, 0xf7, 0xe4, 0xcc, 0xeb, 0x0a, 0x00, 0x0c, 0x11, 0x14,
	0x28, 0x17, 0xfa, 0xf4, 0x00, 0xf2, 0xdd, 0xe6, 0xea, 0xfb, 0x0a, 0x00, 0x06, 0x1c, 0x20, 0x0a,
	0x01, 0x01, 0xfa, 0xf7, 0xf8, 0xf6, 0xfe, 0x0e, 0x0c, 0x0d, 0x17, 0x17, 0x0f, 0x0d, 0x07, 0x01,
	0x02, 0xfd, 0xfa, 0x01, 0x03, 0x00, 0x03, 0x03, 0x01, 0x00, 0xfb, 0xf4, 0xf4, 0xf1, 0xe9, 0xea,
	0xec, 0xea, 0xe9, 0xe4, 0xe3, 0xe1, 0xdc, 0xdb, 0x12, 0x2f, 0xf8, 0x12, 0x2f, 0x0f, 0x0e, 0xf8,
	0xe0, 0xed, 0xf5, 0xe4, 0xd3, 0xfd, 0x14, 0x03, 0x16, 0x14, 0x12, 0x21, 0x08, 0xed, 0xec, 0xf9,
	0xea, 0xdd, 0xf0, 0xf5, 0x05, 0x13, 0x06, 0x0d, 0x1d, 0x16, 0xfd, 0xf6, 0xf9, 0xef, 0xf0, 0xfd,
	0xfa, 0x03, 0x18, 0x13, 0x10, 0x18, 0x12, 0x06, 0x05, 0xfd, 0xfb, 0x00, 0xfd, 0xfd, 0x06, 0x07,
	0x03, 0x05, 0x01, 0xff, 0xff, 0xf7, 0xf2, 0xf5, 0xf5, 0xef, 0xee, 0xef, 0xf1, 0xf2, 0xec, 0xe9,
	0xea, 0xe6, 0xdc, 0xd7, 0xea, 0x2c, 0x15, 0xef, 0x29, 0x23, 0x0c, 0x08, 0xe8, 0xe8, 0xf7, 0xef,
	0xd8, 0xde, 0x10, 0x0d, 0x01, 0x17, 0x0f, 0x1b, 0x19, 0xf7, 0xeb, 0xf6, 0xfa, 0xe1, 0xe2, 0xf9,
	0xfd, 0x0d, 0x0d, 0x03, 0x16, 0x1b, 0x08, 0xf3, 0xf8, 0xf9, 0xf1, 0xfe, 0xfa, 0xff, 0x15, 0x16,
	0x0b, 0x13, 0x15, 0x09, 0x04, 0xfe, 0xfb, 0x02, 0x01, 0xfb, 0x05, 0x0c, 0x05, 0x03, 0x03, 0x00,
	0xff, 0xfc, 0xf3, 0xf4, 0xf9, 0xf3, 0xf1, 0xf1, 0xf3, 0xf3, 0xef, 0xed, 0xef, 0xee, 0xe7, 0xe2,
	0xe0, 0xd8, 0xfb, 0x33, 0x00, 0xf9, 0x34, 0x19, 0x05, 0x01, 0xe9, 0xec, 0xf5, 0xeb, 0xd7, 0xed,
	0x1a, 0x04, 0x04, 0x1c, 0x11, 0x18, 0x0e, 0xf3, 0xee, 0xf9, 0xf4, 0xdc, 0xeb, 0x01, 0xfe, 0x0c,
	0x0b, 0x09, 0x17, 0x14, 0xff, 0xf2, 0xfd, 0xf9, 0xfb, 0xfd, 0xfa, 0x0b, 0x16, 0x0c, 0x0a, 0x15,
	0x0f, 0x06, 0x02, 0x00, 0x02, 0x04, 0xfd, 0xff, 0x0a, 0x07, 0x01, 0x01, 0x02, 0x00, 0xfd, 0xf7,
	0xf6, 0xf9, 0xf7, 0xf0, 0xf2, 0xf4, 0xf2, 0xf1, 0xef, 0xef, 0xf3, 0xee, 0xe5, 0xe8, 0xe7, 0xdd,
	0xe5, 0x25, 0x1f, 0xec, 0x22, 0x2a, 0x03, 0x08, 0xf4, 0xe6, 0xf2, 0xf2, 0xe0, 0xde, 0x0c, 0x13,
	0xfb, 0x16, 0x17, 0x10, 0x14, 0xfd, 0xee, 0xf4, 0xfa, 0xe6, 0xe0, 0xff, 0x00, 0x02, 0x0f, 0x0a,
	0x12, 0x17, 0x0a, 0xf7, 0xf9, 0x03, 0x00, 0xf7, 0xfc, 0x0a, 0x0f, 0x0c, 0x09, 0x0f, 0x13, 0x0c,
	0x02, 0x02, 0x06, 0x02, 0xfd, 0xff, 0x05, 0x05, 0x00, 0xff, 0x02, 0x03, 0xfe, 0xfa, 0xfb, 0xfb,
	0xf7, 0xf2, 0xf4, 0xf6, 0xf3, 0xee, 0xef, 0xf3, 0xf4, 0xed, 0xed, 0xee, 0xed, 0xeb, 0xe7, 0xe7,
	0x08, 0x29, 0xfc, 0x00, 0x2a, 0x10, 0x00, 0xfb, 0xf0, 0xf5, 0xf6, 0xee, 0xe4, 0xfa, 0x17, 0x00,
	0x01, 0x18, 0x11, 0x0e, 0x03, 0xf8, 0xf7, 0xfb, 0xf4, 0xe3, 0xf4, 0x06, 0xfd, 0x03, 0x09, 0x0e,
	0x10, 0x0a, 0x00, 0xfd, 0x14, 0x02, 0xf2, 0x03, 0x0b, 0x02, 0x01, 0x08, 0x09, 0x12, 0x09, 0x02,
	0x0b, 0x0f, 0xff, 0xfd, 0x03, 0x01, 0xfe, 0xfc, 0xfd, 0x02, 0x05, 0xfb, 0xfd, 0x01, 0xfc, 0xf3,
	0xf3, 0xf3, 0xf2, 0xef, 0xeb, 0xf2, 0xf5, 0xf0, 0xed, 0xf0, 0xf2, 0xec, 0xe8, 0xed, 0xef, 0x11,
	0x1f, 0xf2, 0x0d, 0x28, 0x06, 0xfd, 0xfa, 0xf7, 0xf6, 0xef, 0xec, 0xe9, 0x02, 0x10, 0xf6, 0x08,
	0x1b, 0x0f, 0x08, 0x00, 0x00, 0xfc, 0xf9, 0xef, 0xe7, 0xfd, 0x00, 0xf5, 0x02, 0x0b, 0x10, 0x0a,
	0x09, 0x05, 0x06, 0x16, 0xfd, 0xfa, 0x0a, 0x06, 0xf9, 0x01, 0x09, 0x06, 0x0c, 0x08, 0x0b, 0x11,
	0x0c, 0x00, 0x05, 0x06, 0xfe, 0xfa, 0xfd, 0xfe, 0xff, 0xfe, 0xfc, 0x01, 0x00, 0xf9, 0xf7, 0xfb,
	0xf4, 0xf0, 0xee, 0xeb, 0xf2, 0xef, 0xe7, 0xef, 0xf5, 0xea, 0xe9, 0xf4, 0xf1, 0xff, 0x22, 0x03,
	0xfb, 0x27, 0x13, 0xf8, 0xfe, 0xfd, 0xf5, 0xee, 0xf0, 0xec, 0xf4, 0x0c, 0xfd, 0xfc, 0x1a, 0x13,
	0x06, 0x06, 0x07, 0x00, 0xf8, 0xf6, 0xed, 0xf3, 0xff, 0xf1, 0xf9, 0x0a, 0x0b, 0x07, 0x09, 0x0f,
	0x07, 0x14, 0x08, 0xfc, 0x0b, 0x07, 0xf8, 0xfe, 0x09, 0x00, 0x05, 0x09, 0x09, 0x0e, 0x0f, 0x04,
	0x06, 0x0b, 0x00, 0xfb, 0x00, 0xfe, 0xf9, 0xfd, 0xfc, 0xff, 0x00, 0xfa, 0xfa, 0xff, 0xfa, 0xf1,
	0xf4, 0xf4, 0xef, 0xf0, 0xee, 0xee, 0xf0, 0xee, 0xea, 0xec, 0xee, 0xe9, 0xf0, 0x1b, 0x12, 0xed,
	0x20, 0x24, 0xfe, 0x02, 0x02, 0xfb, 0xf4, 0xee, 0xea, 0xec, 0x02, 0xfd, 0xee, 0x14, 0x17, 0x05,
	0x0c, 0x10, 0x0b, 0x00, 0xfc, 0xf4, 0xf2, 0xfc, 0xed, 0xed, 0x04, 0x02, 0x00, 0x06, 0x12, 0x0e,
	0x11, 0x13, 0x08, 0x0e, 0x09, 0xfb, 0xfd, 0x04, 0xfb, 0xfc, 0x06, 0x07, 0x0b, 0x0c, 0x0a, 0x0d,
	0x0e, 0x02, 0x01, 0x04, 0xfe, 0xf9, 0xfc, 0xfd, 0xfc, 0xfd, 0xfa, 0xfc, 0xfe, 0xf9, 0xf7, 0xf8,
	0xf5, 0xf7, 0xf0, 0xed, 0xf3, 0xed, 0xe6, 0xe9, 0xef, 0xe7, 0xe9, 0xed, 0xfe, 0x1e, 0x00, 0xfe,
	0x2e, 0x16, 0xfe, 0x05, 0x05, 0xfe, 0xeb, 0xeb, 0xef, 0xf2, 0xfd, 0xee, 0xfd, 0x1b, 0x09, 0x05,
	0x13, 0x16, 0x09, 0xfd, 0x00, 0xfb, 0xf7, 0xf2, 0xe8, 0xfa, 0xfd, 0xf4, 0xfd, 0x09, 0x0e, 0x04,
	0x14, 0x1a, 0x0e, 0x0c, 0x0c, 0x06, 0x00, 0xfe, 0xf8, 0x00, 0x00, 0xfe, 0x04, 0x0c, 0x0a, 0x0a,
	0x0e, 0x0b, 0x09, 0x04, 0x00, 0xff, 0xfc, 0xf6, 0xf8, 0xfa, 0xf6, 0xf6, 0xf9, 0xf9, 0xf8, 0xf6,
	0xf7, 0xf9, 0xf3, 0xf3, 0xf4, 0xf1, 0xef, 0xef, 0xed, 0xec, 0xef, 0xeb, 0xed, 0xfc, 0x12, 0xff,
	0xfd, 0x26, 0x11, 0xfe, 0x0e, 0x0a, 0xfe, 0xf6, 0xf4, 0xf5, 0xf3, 0xf5, 0xee, 0xfb, 0x0c, 0xfc,
	0x01, 0x14, 0x0f, 0x07, 0x06, 0x0b, 0x04, 0xfd, 0xfa, 0xf5, 0xfc, 0xf5, 0xed, 0xfc, 0x02, 0x00,
	0x02, 0x11, 0x12, 0x0f, 0x10, 0x11, 0x0e, 0x07, 0x02, 0x02, 0x01, 0xfb, 0xfd, 0x02, 0x02, 0x01,
	0x05, 0x09, 0x0a, 0x07, 0x06, 0x08, 0x05, 0x00, 0xfe, 0xfe, 0xf9, 0xf5, 0xf4, 0xf6, 0xf5, 0xf2,
	0xf5, 0xf8, 0xf8, 0xf5, 0xf9, 0xf8, 0xf6, 0xf3, 0xf3, 0xf2, 0xed, 0xea, 0xe8, 0xec, 0xec, 0x06,
	0x00, 0xef, 0x1f, 0x18, 0xfc, 0x14, 0x17, 0x06, 0xff, 0xfe, 0xff, 0xf3, 0xf2, 0xee, 0xf0, 0x00,
	0xf0, 0xf6, 0x0d, 0x05, 0x03, 0x0d, 0x12, 0x0a, 0x05, 0x08, 0x00, 0x00, 0xf9, 0xf0, 0xfb, 0xf5,
	0xee, 0xf8, 0xff, 0x0a, 0x03, 0x07, 0x1c, 0x13, 0x09, 0x11, 0x14, 0x04, 0x03, 0x03, 0x00, 0xfc,
	0xfa, 0xfe, 0x00, 0xfe, 0xff, 0x09, 0x06, 0x02, 0x07, 0x09, 0x03, 0x01, 0x00, 0xfd, 0xf9, 0xf4,
	0xf4, 0xf3, 0xf0, 0xef, 0xf1, 0xf2, 0xf3, 0xf5, 0xf7, 0xf8, 0xf7, 0xf8, 0xf7, 0xf5, 0xf1, 0xf1,
	0xef, 0xec, 0x05, 0xfb, 0xe7, 0x18, 0x0d, 0xf3, 0x14, 0x12, 0x03, 0x05, 0x07, 0x05, 0xfd, 0xfb,
	0xf8, 0xf8, 0xfe, 0xeb, 0xf8, 0x05, 0xf4, 0xfc, 0x08, 0x04, 0x02, 0x07, 0x0d, 0x04, 0x05, 0x04,
	0x00, 0x03, 0xf7, 0xf9, 0xff, 0xf8, 0xf5, 0x09, 0x01, 0xfa, 0x14, 0x0b, 0x05, 0x11, 0x11, 0x07,
	0x0d, 0x08, 0x05, 0x07, 0xfe, 0x00, 0x02, 0xfc, 0xfb, 0x03, 0xfc, 0xfe, 0x04, 0x00, 0x00, 0x03,
	0x01, 0x00, 0xff, 0xfb, 0xfe, 0xf9, 0xf4, 0xf7, 0xf6, 0xf0, 0xf4, 0xf6, 0xf2, 0xf4, 0xf7, 0xf6,
	0xf6, 0xf8, 0xf5, 0xf7, 0xf5, 0xf3, 0xf4, 0xf9, 0x02, 0xf7, 0xfb, 0x12, 0xff, 0xfe, 0x12, 0x06,
	0x02, 0x07, 0x05, 0x04, 0xfe, 0xfe, 0xff, 0xfc, 0xf7, 0xf6, 0x00, 0xf9, 0xf4, 0x02, 0x00, 0xfd,
	0x03, 0x06, 0x05, 0x03, 0x06, 0x05, 0x02, 0x01, 0xff, 0x01, 0xfb, 0xfb, 0x06, 0xfa, 0xfc, 0x0a,
	0x01, 0x00, 0x0c, 0x08, 0x04, 0x0a, 0x08, 0x07, 0x06, 0x03, 0x05, 0x02, 0xfe, 0x01, 0x00, 0xfa,
	0x00, 0x00, 0xfd, 0xff, 0x00, 0xff, 0x00, 0x00, 0xfe, 0xff, 0xfc, 0xfc, 0xfc, 0xf8, 0xf7, 0xfa,
	0xf6, 0xf4, 0xf9, 0xf7, 0xf4, 0xfa, 0xf8, 0xf5, 0xfa, 0xf7, 0xf4, 0xf7, 0xf4, 0xf3, 0xf5, 0xf4,
	0x02, 0xf7, 0xf7, 0x14, 0xfc, 0xff, 0x16, 0x03, 0x04, 0x0b, 0x05, 0x05, 0xff, 0x00, 0x00, 0xf9,
	0xf8, 0xf9, 0xfe, 0xf4, 0xf6, 0x02, 0xf8, 0xfb, 0x03, 0x00, 0x01, 0x02, 0x06, 0x05, 0x01, 0x05,
	0x04, 0x02, 0xfd, 0x02, 0x07, 0xf6, 0x02, 0x09, 0xfa, 0x01, 0x0a, 0x00, 0x01, 0x0a, 0x04, 0x05,
	0x05, 0x06, 0x06, 0x01, 0x03, 0x05, 0xff, 0x00, 0x04, 0xfd, 0xfe, 0x01, 0xfe, 0xfd, 0x00, 0xfe,
	0xfe, 0xfe, 0xfd, 0xff, 0xfc, 0xfc, 0xfd, 0xfb, 0xf9, 0xfb, 0xf8, 0xf6, 0xf9, 0xf6, 0xf6, 0xf8,
	0xf7, 0xf8, 0xf7, 0xf8, 0xf9, 0xf5, 0xf5, 0xf8, 0xf1, 0x00, 0xfd, 0xe9, 0x13, 0x01, 0xed, 0x1a,
	0x03, 0xfb, 0x12, 0x03, 0x05, 0x07, 0xfe, 0x09, 0xfe, 0xfa, 0x00, 0xfe, 0xf6, 0xf6, 0x01, 0xf4,
	0xf7, 0x03, 0xf9, 0xfd, 0x02, 0x00, 0x05, 0x00, 0x04, 0x07, 0x00, 0x02, 0x03, 0x01, 0xfa, 0x08,
	0x00, 0xf9, 0x0b, 0x00, 0xff, 0x07, 0x05, 0x00, 0x08, 0x04, 0x04, 0x05, 0x03, 0x07, 0x01, 0x03,
	0x05, 0x01, 0x00, 0x05, 0x00, 0xff, 0x03, 0xff, 0xfe, 0x00, 0xff, 0xfd, 0xff, 0xfd, 0xfd, 0xfc,
	0xfd, 0xfd, 0xfa, 0xfc, 0xfd, 0xf9, 0xf9, 0xfc, 0xf8, 0xf9, 0xf9, 0xf8, 0xf9, 0xf8, 0xf8, 0xf8,
	0xf8, 0xf7, 0xf6, 0xf7, 0xf4, 0x00, 0xfb, 0xef, 0x10, 0xfd, 0xf4, 0x16, 0xff, 0xff, 0x10, 0x00,
	0x08, 0x06, 0xff, 0x0b, 0xfe, 0xfd, 0x04, 0xfb, 0xf8, 0xfd, 0xfd, 0xf5, 0xfa, 0x00, 0xf7, 0xfd,
	0x00, 0xff, 0x02, 0xfe, 0x05, 0x03, 0xff, 0x05, 0x04, 0xff, 0x01, 0x02, 0x03, 0x00, 0xfe, 0x0b,
	0xff, 0x00, 0x0a, 0x01, 0x00, 0x09, 0x04, 0x00, 0x08, 0x03, 0x03, 0x03, 0x04, 0x03, 0x00, 0x02,
	0x02, 0xff, 0x00, 0x01, 0xfd, 0x00, 0x00, 0xfd, 0xfd, 0xff, 0xfc, 0xfb, 0xfc, 0xfb, 0xfa, 0xf9,
	0xfc, 0xfb, 0xfa, 0xfb, 0xfc, 0xf9, 0xfb, 0xfd, 0xf8, 0xfb, 0xfa, 0xf7, 0xf8, 0xf6, 0xf6, 0xf4,
	0xf1, 0xf7, 0xff, 0xef, 0xf9, 0x0d, 0xf0, 0x00, 0x11, 0xf8, 0x06, 0x0b, 0x00, 0x0b, 0x01, 0x03,
	0x0b, 0xf9, 0x02, 0x05, 0xf7, 0xfd, 0x00, 0xf9, 0xf7, 0xfd, 0xfb, 0xf7, 0xfd, 0xfd, 0xfd, 0xfd,
	0xfe, 0x03, 0xfe, 0x00, 0x07, 0x00, 0x00, 0x05, 0x01, 0x00, 0x00, 0x07, 0xff, 0xfe, 0x0b, 0xfd,
	0xff, 0x08, 0x00, 0xff, 0x08, 0x03, 0x00, 0x07, 0x04, 0x03, 0x02, 0x06, 0x02, 0x00, 0x03, 0x01,
	0xfd, 0x00, 0x01, 0xfa, 0xff, 0x00, 0xfc, 0xfc, 0xff, 0xfc, 0xfb, 0xfe, 0xfc, 0xfc, 0xfb, 0xfd,
	0xfb, 0xfa, 0xfd, 0xfb, 0xf8, 0xfc, 0xfc, 0xf8, 0xfc, 0xfb, 0xf9, 0xfa, 0xf9, 0xf8, 0xf7, 0xf5,
	0xf5, 0xf4, 0xfb, 0xf7, 0xef, 0x08, 0xfa, 0xf2, 0x10, 0xfd, 0xfd, 0x0f, 0x00, 0x06, 0x09, 0xff,
	0x0c, 0x00, 0xfe, 0x0a, 0xfa, 0xfb, 0x01, 0xfa, 0xf8, 0xfc, 0xfc, 0xf8, 0xfb, 0xfe, 0xfb, 0xfd,
	0xfe, 0x00, 0x00, 0xfd, 0x05, 0x01, 0xff, 0x06, 0x02, 0x02, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x02, 0x03, 0x01, 0x03, 0x02, 0x00, 0x03, 0x03, 0x00, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfd, 0xfd, 0xfd, 0xfd, 0xfc, 0xfd, 0xfd,
	0xfc, 0xfc, 0xfd, 0xfd, 0xfc, 0xfe, 0xfd, 0xfd, 0xfd, 0xfc, 0xfc, 0xfb, 0xfc, 0xfa, 0xf9, 0xfa,
	0xf8, 0xf8, 0xf7, 0xf5, 0xf8, 0xfe, 0xf0, 0xfb, 0x08, 0xed, 0x02, 0x0c, 0xf4, 0x07, 0x0a, 0xfe,
	0x0a, 0x04, 0x05, 0x0b, 0xfd, 0x08, 0x06, 0xfa, 0x03, 0x01, 0xfb, 0xfc, 0x00, 0xfb, 0xf9, 0x00,
	0xfd, 0xfa, 0x00, 0xff, 0xff, 0xff, 0x00, 0x04, 0x00, 0x01, 0x06, 0x02, 0x02, 0x08, 0x04, 0x03,
	0x08, 0x04, 0x03, 0x06, 0x05, 0x02, 0x04, 0x03, 0x01, 0x02, 0x02, 0x01, 0x00, 0x02, 0x02, 0x00,
	0x02, 0x03, 0x01, 0x01, 0x02, 0x00, 0x00, 0x01, 0x00, 0xff, 0x00, 0xff, 0xfd, 0xfe, 0xfe, 0xfc,
	0xfc, 0xfd, 0xfc, 0xfc, 0xfd, 0xfc, 0xfc, 0xfd, 0xfd, 0xfc, 0xfe, 0xfc, 0xfc, 0xfc, 0xfc, 0xfa,
	0xfb, 0xfa, 0xf8, 0xf8, 0xf6, 0xf6, 0xf9, 0xfc, 0xf1, 0xfd, 0x04, 0xee, 0x02, 0x08, 0xf5, 0x05,
	0x09, 0xfe, 0x06, 0x06, 0x03, 0x05, 0x00, 0x07, 0x01, 0xfd, 0x02, 0xff, 0xfc, 0xfb, 0x00, 0xfc,
	0xf7, 0xff, 0xfd, 0xf7, 0xff, 0xfe, 0xfa, 0xfe, 0xff, 0x00, 0xfc, 0x03, 0x03, 0xfd, 0x08, 0x04,
	0x00, 0x06, 0x07, 0x00, 0x04, 0x07, 0x00, 0x03, 0x04, 0x01, 0x00, 0x03, 0x00, 0xff, 0x01, 0x00,
	0xff, 0x00, 0x00, 0xff, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xfd, 0xfc, 0xfd,
	0xfc, 0xfa, 0xfc, 0xfb, 0xfa, 0xfb, 0xfb, 0xfa, 0xfb, 0xfc, 0xfb, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
	0xfb, 0xfa, 0xfb, 0xfa, 0xf9, 0xf8, 0xf7, 0xf6, 0xfb, 0xfc, 0xf1, 0x00, 0x01, 0xf1, 0x03, 0x06,
	0xf7, 0x01, 0x09, 0xff, 0x00, 0x07, 0x05, 0xfe, 0x02, 0x08, 0xfd, 0x00, 0x03, 0xfd, 0xfd, 0xfe,
	0xff, 0xfb, 0xf9, 0xfe, 0xfc, 0xf9, 0xfe, 0xff, 0xfc, 0xfd, 0x00, 0x01, 0xfc, 0x01, 0x04, 0xff,
	0x01, 0x05, 0x01, 0x00, 0x06, 0x03, 0x00, 0x05, 0x03, 0x00, 0x02, 0x03, 0x00, 0x00, 0x02, 0x00,
	0xff, 0x00, 0x00, 0xfe, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfd, 0xfd,
	0xfd, 0xfc, 0xfb, 0xfb, 0xfb, 0xfa, 0xfb, 0xfb, 0xfa, 0xfb, 0xfb, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
	0xfc, 0xfc, 0xfb, 0xfa, 0xfa, 0xfa, 0xf9, 0xf8, 0xf8, 0xf7, 0xf7, 0xfc, 0xf9, 0xf4, 0x00, 0x00,
	0xf6, 0x00, 0x05, 0xfe, 0xfe, 0x06, 0x06, 0xff, 0x02, 0x09, 0x00, 0xff, 0x06, 0x01, 0xfd, 0x00,
	0x00, 0xfd, 0xfb, 0xff, 0xfd, 0xfa, 0xfe, 0xfd, 0xfc, 0xfd, 0xfe, 0xfd, 0xfe, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x05, 0x00, 0x01, 0x05, 0x03, 0x01, 0x04, 0x05, 0x01, 0x03, 0x04, 0x01, 0x01,
	0x02, 0x00, 0x00, 0x01, 0xff, 0xff, 0x00, 0xff, 0xfe, 0x00, 0x00, 0xfd, 0x00, 0x00, 0xfe, 0xff,
	0xff, 0xfd, 0xfd, 0xfe, 0xfc, 0xfd, 0xfd, 0xfb, 0xfb, 0xfd, 0xfc, 0xfb, 0xfd, 0xfd, 0xfc, 0xfd,
	0xfd, 0xfc, 0xfd, 0xfd, 0xfc, 0xfc, 0xfd, 0xfc, 0xfb, 0xfb, 0xfb, 0xfa, 0xfa, 0xf9, 0xfa, 0xfd,
	0xfb, 0xf9, 0xfe, 0x00, 0xfd, 0xfe, 0x01, 0x01, 0x00, 0x02, 0x03, 0x01, 0x02, 0x03, 0x01, 0x01,
	0x02, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfe, 0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x01, 0x02, 0x02, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfd, 0xfe, 0xfe,
	0xfd, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfd, 0xfd, 0xfd, 0xfd, 0xfc, 0xfc, 0xfc,
	0xfc, 0xfc, 0xfc, 0xfc, 0xfb, 0xfb, 0xfc, 0xfc, 0xfb, 0xfc, 0xfc, 0xfd, 0xff, 0xfe, 0xff, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xfd, 0xfe, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,
	0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x04, 0x04,
	0x05, 0x05, 0x05, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x05, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x03, 0x03, 0x03, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfe, 0xfe,
	0xfd, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfd, 0xfd, 0xfd, 0xfe, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfe, 0xfe, 0xfd, 0xfd, 0xfd,
	0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfc, 0xfc, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb,
	0xfb, 0xfb, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb,
	0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfa, 0xfa, 0xfa, 0xf9, 0xf9,
	0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9,
	0xf9, 0xf9, 0xfa, 0xf9, 0xf9, 0xf9, 0xfa, 0xf9, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa,
	0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfb, 0xfa, 0xfa, 0xfa, 0xfa, 0xfb,
	0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfd, 0xfd, 0xfd, 0xfd,
	0xfd, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02, 0x02, 0x02,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe,
	0xfe, 0xff, 0xfe, 0xfd, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfd,
	0xfd, 0xfe, 0xfd, 0xfc, 0xfc, 0xfd, 0xfd, 0xfc, 0xfc, 0xfc, 0xfd, 0xfd, 0xfd, 0xfd, 0xfe, 0xff,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfe,
	0xff, 0xff, 0xfe, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xfe, 0xfe,
	0xff, 0xfe, 0xfd, 0xfe, 0xfe, 0xff, 0xfe, 0xfd, 0xfe, 0xfe, 0xfe, 0xfe, 0xfd, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xff, 0xfd, 0xfd, 0xfe, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfc, 0xfc,
	0xfd, 0xfd, 0xfc, 0xfd, 0xfd, 0xfd, 0xfc, 0xfc, 0xfc, 0xfe, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
	0xfc, 0xfc, 0xfd, 0xfc, 0xfd, 0xfd, 0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
	0xfe, 0xfe, 0xfd, 0xfc, 0xfc, 0xfc, 0xfb, 0xfc, 0xfb, 0xf9, 0xfc, 0xf9, 0xfa, 0xf9, 0xf9, 0xfc,
	0xf8, 0xf9, 0xf9, 0xf9, 0xf8, 0xfa, 0xf6, 0xf8, 0xfb, 0xf6, 0xf9, 0xf7, 0xf9, 0xfa, 0xf7, 0xfa,
	0xf9, 0xfa, 0xfb, 0xfa, 0xfb, 0xfd, 0xfd, 0xfc, 0xff, 0xff, 0xfe, 0x00, 0x00, 0xfe, 0xff, 0x00,
	0xfe, 0xfd, 0xff, 0xff, 0xff, 0x00, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x02,
	0x02, 0x03, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
	0xff, 0xff, 0xff, 0xfe, 0xff, 0x05, 0x02, 0x00, 0x01, 0xfd, 0x01, 0x00, 0xfc, 0x01, 0xff, 0xff,
	0x00, 0xff, 0x00, 0xff, 0xfe, 0x05, 0x07, 0x01, 0x03, 0x06, 0x03, 0x01, 0x00, 0xff, 0xff, 0xfc,
	0xfe, 0x00, 0x00, 0x00, 0x02, 0x03, 0x02, 0x01, 0xff, 0x01, 0x00, 0x00, 0xff, 0x00, 0x01, 0x01,
	0x02, 0x00, 0x00, 0xfd, 0xff, 0xfe, 0xfd, 0x00, 0xfe, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
	0xfe, 0xfe, 0xfd, 0xfe, 0xfe, 0xfd, 0xff, 0xfe, 0xff, 0xfe, 0xfd, 0xff, 0xfd, 0xfe, 0xfc, 0xfe,
	0xfe, 0xfe, 0xff, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0xff, 0xfe, 0xfc, 0xff, 0xfa, 0x00, 0xfa, 0xfe,
	0xfb, 0xfd, 0xfe, 0xfa, 0xff, 0xfb, 0xfe, 0xfc, 0xfd, 0xfd, 0x00, 0x00, 0xff, 0x01, 0xff, 0xff,
	0xfa, 0xfb, 0xfc, 0xfd, 0xfa, 0xfc, 0xfe, 0xfd, 0xfe, 0xfc, 0xfe, 0xfe, 0xff, 0xfc, 0xfe, 0xfe,
	0xfd, 0xfd, 0xfb, 0xfc, 0xfa, 0xfc, 0xfa, 0xfd, 0xfc, 0xfe, 0xfd, 0xfc, 0xfe, 0xfc, 0xfe, 0xfb,
	0xfe, 0xfb, 0xfc, 0xfb, 0xfc, 0xfd, 0xfb, 0xfd, 0xfb, 0xfd, 0xfc, 0xfc, 0xfc, 0xfd, 0xfd, 0xfc,
	0xff, 0xfb, 0xfe, 0xfd, 0xfd, 0xfd, 0xfd, 0xfe, 0xfc, 0xfe, 0xfc, 0xfd, 0xfd, 0xfc, 0xfe, 0xfe,
	0xfe, 0xfd, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0xfe, 0xff, 0xfe, 0xfc, 0xff, 0xfc, 0xfd,
	0xfd, 0xff, 0xfe, 0xfc, 0xfe, 0xfc, 0xff, 0xfb, 0xfe, 0xfe, 0xfd, 0xff, 0xfc, 0xff, 0xfd, 0xfe,
	0xfc, 0xfe, 0xfe, 0xfd, 0xfe, 0xfc, 0xff, 0xfd, 0xfe, 0xfc, 0xfe, 0xfe, 0xfd, 0xfd, 0xfc, 0xfe,
	0xfb, 0xfc, 0xfb, 0xfe, 0xfc, 0xfc, 0xfe, 0xfd, 0xfe, 0xfb, 0xfe, 0xfd, 0xfd, 0xfc, 0xfd, 0xff,
	0xfd, 0xff, 0xfe, 0x00, 0xfe, 0xff, 0xfe, 0x00, 0xff, 0xfe, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xff, 0x00, 0x00, 0x00, 0x01, 0xff,
	0x01, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00,
	0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xfe, 0xfe, 0xff,
	0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xfe, 0xff, 0xfe, 0xff, 0xfd, 0xfe,
	0xfd, 0xfd, 0xfd, 0xfd, 0xfe, 0xfd, 0xfe, 0xfe, 0xfe, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x03, 0x02, 0x02, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0x00, 0x01, 0x01, 0x01, 0x00,
	0x01, 0x00, 0x00, 0xff, 0x00, 0xff, 0xfe, 0xfe, 0xfd, 0xfd, 0xfd, 0xfd, 0xfc, 0xfd, 0xfe, 0xfd,
	0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04,
	0x04, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x05, 0x06, 0x06, 0x05, 0x05, 0x06, 0x06, 0x05, 0x05,
	0x05, 0x05, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x03,
	0x03, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfe, 0xfe, 0xfd, 0xfc,
	0xfc, 0xfc, 0xfb, 0xfb, 0xfa, 0xfa, 0xf9, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
	0xf8, 0xf9, 0xf9, 0xfa, 0xfa, 0xfa, 0xfb, 0xfb, 0xfb, 0xfc, 0xfc, 0xfd, 0xfd, 0xfd, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfd, 0xfd, 0xfd, 0xfe, 0xfe, 0xfd, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfd, 0xfd, 0xfd, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xff, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00, 0x00
};

const uint16_t Resource::_gameSavedSoundLen = 8005;

const Game::pge_OpcodeProc Game::_pge_opcodeTable[] = {
	/* 0x00 */
	0,
	&Game::pge_op_isInpUp,
	&Game::pge_op_isInpBackward,
	&Game::pge_op_isInpDown,
	/* 0x04 */
	&Game::pge_op_isInpForward,
	&Game::pge_op_isInpUpMod,
	&Game::pge_op_isInpBackwardMod,
	&Game::pge_op_isInpDownMod,
	/* 0x08 */
	&Game::pge_op_isInpForwardMod,
	&Game::pge_op_isInpIdle,
	&Game::pge_op_isInpNoMod,
	&Game::pge_op_getCollision0u,
	/* 0x0C */
	&Game::pge_op_getCollision00,
	&Game::pge_op_getCollision0d,
	&Game::pge_op_getCollision1u,
	&Game::pge_op_getCollision10,
	/* 0x10 */
	&Game::pge_op_getCollision1d,
	&Game::pge_op_getCollision2u,
	&Game::pge_op_getCollision20,
	&Game::pge_op_getCollision2d,
	/* 0x14 */
	&Game::pge_op_doesNotCollide0u,
	&Game::pge_op_doesNotCollide00,
	&Game::pge_op_doesNotCollide0d,
	&Game::pge_op_doesNotCollide1u,
	/* 0x18 */
	&Game::pge_op_doesNotCollide10,
	&Game::pge_op_doesNotCollide1d,
	&Game::pge_op_doesNotCollide2u,
	&Game::pge_op_doesNotCollide20,
	/* 0x1C */
	&Game::pge_op_doesNotCollide2d,
	&Game::pge_op_collides0o0d,
	&Game::pge_op_collides2o2d,
	&Game::pge_op_collides0o0u,
	/* 0x20 */
	&Game::pge_op_collides2o2u,
	&Game::pge_op_collides2u2o,
	&Game::pge_hasPiegeSentMessage,
	&Game::pge_op_sendMessageData0,
	/* 0x24 */
	&Game::pge_op_sendMessageData1,
	&Game::pge_op_sendMessageData2,
	&Game::pge_op_sendMessageData3,
	&Game::pge_op_isPiegeDead,
	/* 0x28 */
	&Game::pge_op_collides1u2o,
	&Game::pge_op_collides1u1o,
	&Game::pge_op_collides1o1u,
	&Game::pge_o_unk0x2B,
	/* 0x2C */
	&Game::pge_o_unk0x2C,
	&Game::pge_o_unk0x2D,
	&Game::pge_op_nop,
	&Game::pge_op_pickupObject,
	/* 0x30 */
	&Game::pge_op_addItemToInventory,
	&Game::pge_op_copyPiege,
	&Game::pge_op_canUseCurrentInventoryItem,
	&Game::pge_op_removeItemFromInventory,
	/* 0x34 */
	&Game::pge_o_unk0x34,
	&Game::pge_op_isInpMod,
	&Game::pge_op_setCollisionState1,
	&Game::pge_op_setCollisionState0,
	/* 0x38 */
	&Game::pge_hasMessageData0,
	&Game::pge_hasMessageData1,
	&Game::pge_hasMessageData2,
	&Game::pge_hasMessageData3,
	/* 0x3C */
	&Game::pge_o_unk0x3C,
	&Game::pge_o_unk0x3D,
	&Game::pge_op_setPiegeCounter,
	&Game::pge_op_decPiegeCounter,
	/* 0x40 */
	&Game::pge_o_unk0x40,
	&Game::pge_op_wakeUpPiege,
	&Game::pge_op_removePiege,
	&Game::pge_op_removePiegeIfNotNear,
	/* 0x44 */
	&Game::pge_op_loadPiegeCounter,
	&Game::pge_o_unk0x45,
	&Game::pge_o_unk0x46,
	&Game::pge_o_unk0x47,
	/* 0x48 */
	&Game::pge_o_unk0x48,
	&Game::pge_o_unk0x49,
	&Game::pge_op_killInventoryPiege,
	&Game::pge_op_killPiege,
	/* 0x4C */
	&Game::pge_op_isInCurrentRoom,
	&Game::pge_op_isNotInCurrentRoom,
	&Game::pge_op_scrollPosY,
	&Game::pge_op_playDefaultDeathCutscene,
	/* 0x50 */
	&Game::pge_o_unk0x50,
	0,
	&Game::pge_o_unk0x52,
	&Game::pge_o_unk0x53,
	/* 0x54 */
	&Game::pge_op_isPiegeNear,
	&Game::pge_op_setLife,
	&Game::pge_op_incLife,
	&Game::pge_op_setPiegeDefaultAnim,
	/* 0x58 */
	&Game::pge_op_setLifeCounter,
	&Game::pge_op_decLifeCounter,
	&Game::pge_op_playCutscene,
	&Game::pge_op_compareUnkVar,
	/* 0x5C */
	&Game::pge_op_playDeathCutscene,
	&Game::pge_o_unk0x5D,
	&Game::pge_o_unk0x5E,
	&Game::pge_o_unk0x5F,
	/* 0x60 */
	&Game::pge_op_findAndCopyPiege,
	&Game::pge_op_isInRandomRange,
	&Game::pge_o_unk0x62,
	&Game::pge_o_unk0x63,
	/* 0x64 */
	&Game::pge_o_unk0x64,
	&Game::pge_op_addToCredits,
	&Game::pge_op_subFromCredits,
	&Game::pge_o_unk0x67,
	/* 0x68 */
	&Game::pge_op_setCollisionState2,
	&Game::pge_op_saveState,
	&Game::pge_o_unk0x6A,
	&Game::pge_isToggleable,
	/* 0x6C */
	&Game::pge_o_unk0x6C,
	&Game::pge_op_isCollidingObject,
	&Game::pge_o_unk0x6E,
	&Game::pge_o_unk0x6F,
	/* 0x70 */
	&Game::pge_o_unk0x70,
	&Game::pge_o_unk0x71,
	&Game::pge_o_unk0x72,
	&Game::pge_o_unk0x73,
	/* 0x74 */
	&Game::pge_op_collides4u,
	&Game::pge_op_doesNotCollide4u,
	&Game::pge_op_isBelowConrad,
	&Game::pge_op_isAboveConrad,
	/* 0x78 */
	&Game::pge_op_isNotFacingConrad,
	&Game::pge_op_isFacingConrad,
	&Game::pge_op_collides2u1u,
	&Game::pge_op_displayText,
	/* 0x7C */
	&Game::pge_o_unk0x7C,
	&Game::pge_op_playSound,
	&Game::pge_o_unk0x7E,
	&Game::pge_o_unk0x7F,
	/* 0x80 */
	&Game::pge_op_setPiegePosX,
	&Game::pge_op_setPiegePosModX,
	&Game::pge_op_changeRoom,
	&Game::pge_op_hasInventoryItem,
	/* 0x84 */
	&Game::pge_op_changeLevel,
	&Game::pge_op_shakeScreen,
	&Game::pge_o_unk0x86,
	&Game::pge_op_playSoundGroup,
	/* 0x88 */
	&Game::pge_op_adjustPos,
	0,
	&Game::pge_op_setGunVar,
	&Game::pge_op_compareGunVar
};

const uint8_t Game::_pge_modKeysTable[] = {
	0x40, 0x10, 0x20
};

const uint8_t Game::_protectionCodeData[] = {
	0xF9, 0x77, 0x79, 0xF9, 0xF7, 0x39, 0x79, 0x97, 0x39, 0xF9, 0x19, 0x59, 0xB9, 0x59, 0x39, 0xC9,
	0xB9, 0x19, 0xB9, 0x47, 0xB7, 0x49, 0xC9, 0xF9, 0xB9, 0x77, 0xD9, 0x07, 0x77, 0x47, 0xC9, 0x79,
	0x47, 0xF9, 0xD9, 0x19, 0x39, 0xD9, 0xB9, 0x79, 0x39, 0xD9, 0x39, 0xB9, 0x39, 0xF9, 0x19, 0x59,
	0xF9, 0xB7, 0xB9, 0x39, 0x27, 0x79, 0xB9, 0x49, 0x39, 0xD9, 0xB7, 0x07, 0xF9, 0x37, 0x99, 0x07,
	0x37, 0xD9, 0x39, 0xF9, 0xB9, 0x99, 0xB9, 0x79, 0x19, 0x59, 0xB9, 0xF9, 0x39, 0xF7, 0x39, 0x07,
	0xF9, 0x39, 0xD9, 0xD9, 0x99, 0x17, 0xD9, 0xB9, 0x77, 0xD7, 0x47, 0x77, 0x87, 0x39, 0xF9, 0x77,
	0x19, 0x59, 0xB9, 0x79, 0xB9, 0x19, 0x49, 0xD7, 0xB9, 0x99, 0x19, 0x59, 0x47, 0xF9, 0x37, 0x59,
	0x87, 0x37, 0x49, 0xC9, 0xD7, 0x77, 0xB9, 0x17, 0xD9, 0xD9, 0x17, 0x19, 0x79, 0xB7, 0xB9, 0x39,
	0x39, 0xC9, 0x39, 0x97, 0x39, 0xD9, 0x39, 0xC9, 0x39, 0xF7, 0xF9, 0x17, 0xD9, 0xC9, 0xF9, 0x99,
	0xF9, 0xB7, 0x39, 0x17, 0x37, 0x99, 0xF9, 0x97, 0x27, 0x39, 0x19, 0x99, 0x19, 0x59, 0x39, 0x79,
	0x49, 0x19, 0x39, 0x39, 0x39, 0xD9, 0xB9, 0xF9, 0x0F, 0x1F, 0xDF, 0x17, 0x19, 0xD9, 0x49, 0x49,
	0x79, 0x17, 0x39, 0xD9, 0x79, 0x19, 0x97, 0x27, 0x87, 0x67, 0xB9, 0x79, 0x19, 0x59, 0x19, 0xD9,
	0x59, 0x59, 0x79, 0x99, 0xB9, 0x19, 0x19, 0x39, 0x97, 0x99, 0x3F, 0x17, 0x17, 0x97, 0x3F, 0x39,
	0xF9, 0x99, 0xF9, 0xB7, 0x17, 0x79, 0x39, 0xC9, 0x39, 0xD9, 0x39, 0x99, 0x39, 0x17, 0x39, 0xF9,
	0xB9, 0x19, 0x19, 0x59, 0xD9, 0x19, 0xB7, 0x99, 0xC9, 0xC9, 0xD9, 0xB7, 0x19, 0x79, 0x1F, 0x7F,
	0x79, 0xD9, 0x37, 0x99, 0xF7, 0xF9, 0xB9, 0xF9, 0x39, 0xF7, 0x19, 0x59, 0xB9, 0x99, 0x39, 0x37,
	0x39, 0x39, 0xC9, 0x19, 0xC9, 0x37, 0xF9, 0xD9, 0xE7, 0x4F, 0xD9, 0xF9, 0x9F, 0x19, 0xD9, 0xD9,
	0x19, 0x79, 0x99, 0x19, 0xB9, 0x79, 0x19, 0x59, 0x39, 0xF7, 0x19, 0xB9, 0x39, 0xD9, 0x19, 0x59,
	0x99, 0x37, 0x79, 0xF9, 0x39, 0xF7, 0x39, 0x49, 0x59, 0x99, 0x59, 0xF7, 0xD9, 0x87, 0xB7, 0x39,
	0xF9, 0xB9, 0xB9, 0x19, 0x39, 0xC9, 0x39, 0xF9, 0x39, 0xF7, 0x19, 0x59, 0x39, 0x79, 0x97, 0x1F,
	0xF9, 0x77, 0x39, 0x19, 0x39, 0x99, 0x1F, 0xC9, 0x49, 0xB9, 0xD9, 0xD9, 0xF9, 0xB7, 0x49, 0xF9,
	0x39, 0xF9, 0x19, 0x59, 0x39, 0xB9, 0x39, 0x97, 0x39, 0x37, 0xB9, 0x19, 0xD9, 0x47, 0x67, 0xE7,
	0x37, 0xC9, 0x19, 0x99, 0x27, 0x39, 0x47, 0xF9, 0x87, 0x87, 0x17, 0x37, 0xD9, 0x19, 0x39, 0xC9,
	0x39, 0xF9, 0xB9, 0xF9, 0xB9, 0x49, 0x19, 0x97, 0x19, 0x59, 0x67, 0xE7, 0x47, 0xC9, 0xF9, 0x37,
	0xD9, 0x17, 0x19, 0x99, 0xC9, 0xF9, 0x79, 0x79, 0x39, 0x9F, 0xB7, 0x19, 0x39, 0x99, 0x19, 0xB9,
	0x39, 0xF9, 0xB9, 0x99, 0xB9, 0x79, 0x19, 0x59, 0xC9, 0x47, 0x79, 0x39, 0x7F, 0xFF, 0xF9, 0xB7,
	0x37, 0x79, 0x39, 0xD9, 0xB9, 0x99, 0x47, 0xD9, 0x99, 0x19, 0x39, 0x99, 0x39, 0x37, 0x39, 0x77,
	0x39, 0x77, 0x39, 0xF9, 0x19, 0x59, 0xC9, 0x79, 0xF9, 0xB7, 0x99, 0xD9, 0xC9, 0x17, 0xF9, 0x39,
	0x37, 0xE7, 0xD9, 0xF9, 0x0F, 0x77, 0xC9, 0x39, 0xB9, 0x99, 0x39, 0xF9, 0x19, 0x59, 0xB9, 0x39,
	0x39, 0xD9, 0x39, 0xF7, 0x39, 0xB7, 0x1F, 0x99, 0x19, 0xD9, 0x79, 0x77, 0x99, 0x99, 0xC9, 0x39,
	0x19, 0x99, 0x9F, 0x17, 0xD9, 0x19, 0xB9, 0x79, 0x39, 0xF9, 0xB9, 0x19, 0x19, 0x59, 0x39, 0x79,
	0x39, 0xF9, 0xD9, 0xF9, 0xC9, 0x4F, 0xBF, 0x9F, 0xB9, 0xB9, 0x17, 0x1F, 0xC9, 0x99, 0x19, 0x79,
	0x37, 0x77, 0x77, 0xD9, 0x19, 0x59, 0xB9, 0x99, 0x39, 0xD9, 0xB9, 0x39, 0x39, 0x37, 0x39, 0xC9,
	0x39, 0x3F, 0x37, 0xF9, 0x39, 0x99, 0xC9, 0xC9, 0x17, 0xB7, 0x79, 0x19, 0xC9, 0xB9, 0x7F, 0x37,
	0x39, 0x79, 0xB9, 0x19, 0x19, 0x59, 0x39, 0x39, 0x39, 0xD9, 0x39, 0xC9, 0xB9, 0x19, 0xD9, 0xD9,
	0x19, 0x39, 0x49, 0x19, 0x17, 0x37, 0x77, 0x79, 0x39, 0xD9, 0x39, 0x37, 0xF9, 0xC9, 0xF9, 0x79,
	0x39, 0xF9, 0x19, 0x59, 0x39, 0x79, 0xB9, 0xF9, 0x19, 0x59, 0xB9, 0x39, 0xC9, 0xB9, 0x79, 0x77,
	0xB7, 0x9F, 0xF7, 0x0F, 0x49, 0xF9, 0x39, 0xD9, 0xF9, 0x79, 0xB7, 0x7F, 0xC7, 0xD7, 0x49, 0x19,
	0x39, 0x97, 0x39, 0x37, 0x19, 0xF7, 0x59, 0x59, 0x79, 0xF9, 0xF7, 0x39, 0x7F, 0x49, 0x9F, 0xF9,
	0x39, 0x9F, 0x47, 0x19, 0x59, 0xF9, 0xC9, 0xC9, 0x39, 0x37, 0xF9, 0x39, 0xB9, 0x79, 0x19, 0x59,
	0x39, 0x99, 0x19, 0xB9, 0x39, 0xF9, 0xB9, 0x99, 0x79, 0x9F, 0xE7, 0xD9, 0x19, 0x79, 0x87, 0x87,
	0xC9, 0xF9, 0x39, 0x99, 0xC9, 0x39, 0x39, 0x37, 0xF7, 0x99, 0xB9, 0x79, 0x19, 0x59, 0x39, 0xD9,
	0xB9, 0x39, 0x39, 0xD9, 0x39, 0xF7, 0xC9, 0x37, 0x77, 0x79, 0x39, 0x19, 0xD9, 0x37, 0xF9, 0x77,
	0x39, 0x19, 0x1F, 0x7F, 0xC9, 0x39, 0xF9, 0x37, 0xB9, 0x79, 0x19, 0x59, 0xB9, 0x79, 0x39, 0x37,
	0xB9, 0xF9, 0xB9, 0x79, 0xF9, 0x37, 0x37, 0xD7, 0x9F, 0xF9, 0x5F, 0xE7, 0x9F, 0xC9, 0x39, 0x99,
	0x39, 0x9F, 0x9F, 0x79, 0xF9, 0x19, 0x19, 0x59, 0xB9, 0x59, 0x39, 0xD9, 0xB9, 0x19, 0x39, 0x39,
	0x39, 0xD9, 0xC9, 0x77, 0x9F, 0x07, 0x99, 0x99, 0xC9, 0x37, 0x77, 0x79, 0x39, 0x19, 0xF7, 0x39,
	0x7F, 0x49, 0x9F, 0xF9, 0x39, 0xC9, 0xB9, 0x79, 0x39, 0xF9, 0x39, 0x77, 0x39, 0xF9, 0x39, 0xF7,
	0xD7, 0x79, 0xF9, 0x39, 0x9F, 0xF7, 0x79, 0xF9, 0x0F, 0x39, 0x49, 0xB9, 0xD9, 0x77, 0x39, 0xDF,
	0x07, 0x19, 0xB9, 0x79, 0x19, 0x59, 0x39, 0xC9, 0xB9, 0x19, 0xB9, 0x19, 0x39, 0xF9, 0xD9, 0xB7,
	0x37, 0x39, 0x37, 0x19, 0x39, 0x47, 0xF9, 0x39, 0x39, 0xB7, 0x19, 0xD9, 0xE7, 0x87, 0x07, 0xB7,
	0xB9, 0x99, 0xB9, 0x59, 0x39, 0x37, 0x39, 0xF7, 0xB9, 0x99, 0x39, 0xD9, 0xD9, 0x99, 0x99, 0x79,
	0xF9, 0x39, 0x79, 0xD9, 0x19, 0x79, 0xB9, 0x87, 0xD7, 0x1F, 0x77, 0xF9, 0x79, 0xB9, 0x39, 0x19,
	0x39, 0x97, 0x39, 0xF9, 0x99, 0x79, 0xE7, 0x07, 0xA7, 0x5F, 0xD9, 0x79, 0xF9, 0x39, 0x17, 0x3F,
	0x39, 0x79, 0x5F, 0xFF, 0x27, 0xF9, 0x99, 0x99, 0x47, 0xB7, 0x37, 0x27, 0xF9, 0x79, 0x87, 0x3F,
	0x97, 0x99, 0x47, 0xB7, 0x59, 0x99, 0xB9, 0xD9, 0xC9, 0x49, 0xB7, 0x39, 0x37, 0xD9, 0xF9, 0xB7,
	0x37, 0x37, 0x39, 0xF9
};

const uint8_t Game::_protectionWordData[] = {
	0x01, 0x01, 0x02, 0x05, 0xD7, 0x77, 0x3F, 0xF7, 0x27, 0x7F, 0xFF, 0x1F, 0xF7, 0x51, 0x51, 0x51,
	0x51, 0x00, 0x01, 0x01, 0x05, 0x03, 0xDF, 0xFF, 0xF7, 0x9F, 0x7F, 0x51, 0x51, 0x51, 0x51, 0x51,
	0x51, 0x51, 0x51, 0x00, 0x01, 0x01, 0x05, 0x06, 0x97, 0x67, 0xF7, 0x3F, 0xF7, 0x1F, 0x51, 0x51,
	0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x01, 0x02, 0x02, 0x07, 0x17, 0xD7, 0x97, 0x87, 0xFF, 0x5F,
	0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x01, 0x02, 0x07, 0x01, 0x87, 0xF7, 0xCF, 0x17,
	0xA7, 0xD7, 0x1F, 0x77, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x02, 0x01, 0x03, 0x01, 0x5F, 0xA7,
	0xBF, 0xF7, 0x1F, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x02, 0x01, 0x05, 0x01,
	0xA7, 0x1F, 0xB7, 0xD7, 0x27, 0xC7, 0x0F, 0xD7, 0x7F, 0xC7, 0xA7, 0x27, 0x51, 0x00, 0x02, 0x02,
	0x01, 0x05, 0x97, 0xA7, 0x67, 0xA7, 0x27, 0xCF, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00,
	0x02, 0x02, 0x02, 0x01, 0xE7, 0xA7, 0xA7, 0x27, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
	0x51, 0x00, 0x02, 0x02, 0x05, 0x01, 0x1F, 0xF7, 0x37, 0xFF, 0xB7, 0xF7, 0xF7, 0x9F, 0x51, 0x51,
	0x51, 0x51, 0x51, 0x00, 0x02, 0x03, 0x02, 0x04, 0x5F, 0x1F, 0xC7, 0x9F, 0xA7, 0x27, 0x51, 0x51,
	0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x03, 0x01, 0x01, 0x04, 0x7F, 0xC7, 0x7F, 0xD7, 0x27, 0xB1,
	0x9F, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x03, 0x01, 0x04, 0x01, 0xD7, 0x97, 0x97, 0xC7,
	0x77, 0xF7, 0x27, 0x7F, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x03, 0x02, 0x01, 0x01, 0x5F, 0x1F,
	0xA7, 0x37, 0xF7, 0x9F, 0x9F, 0xA7, 0x1F, 0x51, 0x51, 0x51, 0x51, 0x00, 0x03, 0x02, 0x02, 0x05,
	0x7F, 0xF7, 0x67, 0xF7, 0x5F, 0xA7, 0x1F, 0x7F, 0xF7, 0x1F, 0x51, 0x51, 0x51, 0x00, 0x03, 0x02,
	0x04, 0x02, 0x97, 0x1F, 0xC7, 0xE7, 0xC7, 0x27, 0xD7, 0x67, 0x9F, 0x51, 0x51, 0x51, 0x51, 0x00,
	0x03, 0x03, 0x01, 0x01, 0x9F, 0x97, 0xC7, 0xF7, 0x27, 0x7F, 0xC7, 0x9F, 0x7F, 0x9F, 0x51, 0x51,
	0x51, 0x00, 0x03, 0x03, 0x02, 0x03, 0xB7, 0xF7, 0x27, 0xF7, 0x7F, 0xC7, 0x97, 0x51, 0x51, 0x51,
	0x51, 0x51, 0x51, 0x00, 0x03, 0x03, 0x04, 0x01, 0xE7, 0xFF, 0x7F, 0xD7, 0x7F, 0xC7, 0xA7, 0x27,
	0x9F, 0x51, 0x51, 0x51, 0x51, 0x00, 0x04, 0x01, 0x01, 0x05, 0xF7, 0xCF, 0xF7, 0x9F, 0x51, 0x51,
	0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x04, 0x01, 0x02, 0x01, 0x9F, 0xFF, 0x1F, 0x1F,
	0xA7, 0xFF, 0x27, 0x77, 0xC7, 0x27, 0xB7, 0x51, 0x51, 0x00, 0x04, 0x01, 0x03, 0x05, 0x17, 0x1F,
	0xD7, 0xC7, 0x27, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x04, 0x01, 0x04, 0x06,
	0xB7, 0x1F, 0xF7, 0xD7, 0x7F, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x05, 0x01,
	0x01, 0x03, 0xC7, 0x27, 0x7F, 0x1F, 0xA7, 0x77, 0xFF, 0x97, 0x7F, 0xC7, 0xA7, 0x27, 0x51, 0x00,
	0x05, 0x01, 0x05, 0x07, 0xA7, 0x5F, 0x7F, 0xC7, 0xA7, 0x27, 0x9F, 0x51, 0x51, 0x51, 0x51, 0x51,
	0x51, 0x00, 0x05, 0x01, 0x06, 0x06, 0xD7, 0x1F, 0x1F, 0xA7, 0xBF, 0x51, 0x51, 0x51, 0x51, 0x51,
	0x51, 0x51, 0x51, 0x00, 0x05, 0x02, 0x02, 0x05, 0x9F, 0x87, 0xC7, 0x67, 0x67, 0x51, 0x51, 0x51,
	0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x05, 0x02, 0x03, 0x06, 0xB7, 0xD7, 0xE7, 0xF7, 0x51, 0x51,
	0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x06, 0x01, 0x03, 0x02, 0x9F, 0xFF, 0x1F, 0x3F,
	0xC7, 0x3F, 0xD7, 0x67, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x06, 0x01, 0x06, 0x06, 0xC7, 0x27,
	0x3F, 0xC7, 0x9F, 0xC7, 0x17, 0x67, 0xF7, 0x51, 0x51, 0x51, 0x51, 0x00, 0x06, 0x01, 0x07, 0x01,
	0x9F, 0x47, 0xC7, 0xF7, 0x67, 0x77, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x06, 0x02,
	0x05, 0x06, 0x9F, 0xC7, 0x7F, 0xFF, 0xD7, 0x7F, 0xC7, 0xA7, 0x27, 0x9F, 0x51, 0x51, 0x51, 0x00,
	0x06, 0x02, 0x06, 0x05, 0x77, 0xF7, 0xD7, 0x7F, 0x47, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
	0x51, 0x00, 0x07, 0x01, 0x02, 0x03, 0x5F, 0x1F, 0xF7, 0x97, 0xC7, 0x9F, 0xF7, 0x51, 0x51, 0x51,
	0x51, 0x51, 0x51, 0x00, 0x07, 0x02, 0x07, 0x05, 0x97, 0xD7, 0x1F, 0x77, 0x51, 0x51, 0x51, 0x51,
	0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x08, 0x01, 0x0A, 0x02, 0x97, 0xC7, 0x27, 0xF7, 0xE7, 0xD7,
	0x7F, 0xC7, 0x97, 0x51, 0x51, 0x51, 0x51, 0x00, 0x08, 0x02, 0x04, 0x06, 0xC7, 0x27, 0x3F, 0xF7,
	0x27, 0x7F, 0xA7, 0x1F, 0xCF, 0x51, 0x51, 0x51, 0x51, 0x00, 0x08, 0x01, 0x10, 0x02, 0x77, 0xF7,
	0x3F, 0xC7, 0x97, 0xF7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x09, 0x01, 0x01, 0x04,
	0x7F, 0xD7, 0x4F, 0xC7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x09, 0x01,
	0x03, 0x04, 0x9F, 0xFF, 0x17, 0xBF, 0xD7, 0xCF, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00
};

const uint8_t Game::_protectionNumberDataAmiga[] = {
	0xE5, 0xE3, 0x91, 0xE2, 0xE1, 0x91, 0xE6, 0xEF, 0xE3, 0x8D, 0xE1, 0xE5, 0xE3, 0x85, 0xE2, 0xE1,
	0x83, 0xE3, 0xEE, 0xE2, 0xE1, 0x93, 0xE2, 0xE1, 0xEE, 0xE1, 0xE1, 0xE2, 0x93, 0xE5, 0xE4, 0xE1,
	0xE2, 0x9D, 0xE1, 0x8E, 0xEE, 0x90, 0xEF, 0xEE, 0xE1, 0x91, 0xE4, 0xE3, 0xEF, 0xE2, 0xE3, 0x90,
	0xE6, 0x95, 0xE5, 0xE2, 0x83, 0xE3, 0xE2, 0x9F, 0xE3, 0xE1, 0x90, 0xE6, 0xEE, 0xE6, 0xE4, 0xE3,
	0x93, 0xE1, 0x9C, 0x9B, 0xE4, 0xE0, 0xEF, 0x99, 0xE1, 0x9B, 0x91, 0xE3, 0x81, 0xE4, 0xE0, 0xE0,
	0x81, 0xEE, 0xE1, 0x93, 0xEE, 0x91, 0xE3, 0xEE, 0xE5, 0xE5, 0x83, 0x8E, 0xE2, 0xE3, 0xE1, 0x93,
	0xE6, 0x9C, 0xE5, 0xE4, 0x82, 0x91, 0xE4, 0xE4, 0xE6, 0xE5, 0x99, 0x87, 0x9F, 0x93, 0x9D, 0xE1,
	0xE3, 0xE2, 0xE3, 0x9B, 0xE2, 0xE1, 0x96, 0xE3, 0x87, 0xEF, 0x86, 0xE3, 0xE4, 0xE5, 0xE4, 0x90,
	0xE6, 0xE2, 0xE4, 0x93, 0xE6, 0x81, 0xE1, 0x94, 0xE2, 0x93, 0xE6, 0x91, 0xE5, 0xE4, 0x90, 0xE2,
	0xE6, 0x95, 0xEE, 0xE2, 0xE4, 0xE5, 0x90, 0xE6, 0xE2, 0x95, 0xE4, 0x96, 0xE6, 0x90, 0xE4, 0xE5,
	0xE6, 0x91, 0x9C, 0xE1, 0xE2, 0xE0, 0xE0, 0xE4, 0xEF, 0x94, 0xE3, 0xE2, 0xE1, 0x93, 0xE6, 0x91,
	0xE5, 0xE4, 0xE1, 0xE3, 0xE3, 0xE2, 0xE1, 0x85, 0x83, 0x95, 0xE6, 0xE5, 0xE5, 0x91, 0xE2, 0xE1,
	0xEE, 0x91, 0xE3, 0x90, 0xE1, 0xE2, 0x9D, 0x99, 0xE4, 0xE6, 0xEE, 0xE3, 0xE6, 0x95, 0xE5, 0xE4,
	0x91, 0xEE, 0xE3, 0xE3, 0x90, 0x91, 0xE2, 0xE1, 0xE6, 0xE1, 0xE4, 0x91, 0xEE, 0xE2, 0xE6, 0x94,
	0xE2, 0x93, 0xE1, 0xE0, 0xE6, 0xE4, 0x9D, 0xE5, 0xE6, 0x8E, 0xE3, 0xE3, 0x90, 0xE2, 0xE1, 0x85,
	0x9D, 0x91, 0xE3, 0xE1, 0xE2, 0xE6, 0xE3, 0x91, 0xE2, 0xE2, 0x92, 0xE3, 0xE2, 0x93, 0xE3, 0xE1,
	0x9A, 0x80, 0xEF, 0xE3, 0x93, 0xE4, 0x92, 0xE3, 0xEE, 0xEE, 0x91, 0xE2, 0xE1, 0x85, 0x85, 0x96,
	0xE2, 0xE1, 0xEE, 0xEF, 0xEF, 0x95, 0xE2, 0xE3, 0x93, 0x96, 0xE2, 0x9F, 0xE6, 0xE5, 0x9F, 0x9A,
	0xE6, 0x94, 0xE5, 0xE4, 0x93, 0xE3, 0xE5, 0xEE, 0x81, 0xE3, 0xE1, 0xE3, 0xE1, 0x8F, 0xE5, 0x94,
	0xE2, 0xE1, 0xE4, 0x80, 0xE1, 0x93, 0xE2, 0xE3, 0x92, 0xE2, 0xE1, 0x91, 0xE6, 0xE4, 0xE6, 0x94,
	0xE4, 0xE5, 0x93, 0xE2, 0xE3, 0x91, 0xE1, 0xE2, 0x90, 0x99, 0xE4, 0xE5, 0xE3, 0xEE, 0x93, 0xE2,
	0xE4, 0x8F, 0xE1, 0x84, 0x92, 0xEE, 0xE0, 0x91, 0x91, 0xE2, 0xE6, 0xE4, 0x99, 0x9C, 0x93, 0x9B,
	0x9D, 0xEF, 0xE2, 0x9C, 0xE6, 0xE4, 0xEE, 0x85, 0x9B, 0xE2, 0x93, 0xE3, 0xE2, 0xE2, 0x83, 0x8E,
	0x93, 0xEE, 0xE2, 0xE4, 0x90, 0x95, 0xE3, 0x84, 0x83, 0xE2, 0xE1, 0xE1, 0xE4, 0xEE, 0xEF, 0xE5,
	0xE0, 0xE1, 0xE2, 0x84, 0x91, 0x9F, 0xE6, 0xE5, 0x9F, 0xE4, 0x90, 0xE2, 0xE6, 0xE4, 0x90, 0xE5,
	0xE3, 0xE2, 0x90, 0x9A, 0x99, 0xEE, 0xEE, 0xE1, 0xE2, 0x90, 0x85, 0xE1, 0xE6, 0xE5, 0xE6, 0x95,
	0xEE, 0xE2, 0x91, 0xE4, 0x9A, 0xE2, 0xE1, 0xE2, 0x91, 0xE4, 0xEE, 0x81, 0xE4, 0xE2, 0x93, 0xE4,
	0xEE, 0x95, 0xE4, 0x91, 0x90, 0xE4, 0xE6, 0x92, 0xE4, 0xE2, 0x84, 0xE1, 0xE6, 0x91, 0xE5, 0x92,
	0xE4, 0x92, 0xE3, 0x90, 0x9F, 0x87, 0x9A, 0xE6, 0xE5, 0xE5, 0xE1, 0xE4, 0xE6, 0xE1, 0xEE, 0x93,
	0xE2, 0xE1, 0xE0, 0xE5, 0xE1, 0x91, 0xE5, 0xE4, 0x93, 0xE6, 0xE2, 0x92, 0xE3, 0xE1, 0xE7, 0x84,
	0xE3, 0xE2, 0x91, 0x92, 0xE1, 0xE6, 0xE3, 0xE3, 0x91, 0xE2, 0xE1, 0x93, 0xE2, 0x85, 0xE3, 0xE1,
	0x92, 0xE6, 0xE6, 0xEE, 0x93, 0xEF, 0xE1, 0xE1, 0xEF, 0x8D, 0xE3, 0xE1, 0x93, 0xE4, 0xE3, 0xE2,
	0x91, 0xE4, 0xE6, 0x93, 0xEE, 0x84, 0x96, 0xE1, 0xE6, 0xE5, 0xE3, 0x8D, 0xE1, 0x94, 0x94, 0xE2,
	0xE6, 0xE6, 0x93, 0xE5, 0xEE, 0xEE, 0xE6, 0x91, 0xE5, 0xE4, 0x93, 0xE2, 0x81, 0x9E, 0x98, 0xE6,
	0xE5, 0x84, 0xE6, 0x91, 0xE4, 0x83, 0x92, 0x85, 0x86, 0x9B, 0xE2, 0x93, 0xEE, 0xE4, 0xEE, 0x94,
	0xE1, 0xE5, 0xE5, 0xE4, 0x93, 0xE2, 0xE3, 0x84, 0xE1, 0xE4, 0xE6, 0x93, 0xE5, 0x84, 0xE4, 0xE4,
	0x84, 0xE3, 0xE2, 0x84, 0x86, 0xE1, 0x93, 0x93, 0xE2, 0xE3, 0x84, 0xE4, 0x85, 0x90, 0xE3, 0xE2,
	0xE1, 0x9A, 0xE6, 0x84, 0xE1, 0x84, 0xE2, 0xEE, 0xE2, 0xE3, 0x9D, 0x9F, 0xE1, 0xE6, 0xEF, 0x91,
	0xE3, 0xE1, 0x93, 0xE2, 0x85, 0xEE, 0x92, 0xE3, 0xE2, 0xE1, 0x90, 0xE2, 0x91, 0xE1, 0x91, 0xE6,
	0xEE, 0x90, 0xE1, 0x91, 0xE4, 0xE5, 0xE1, 0x91, 0xE3, 0xE4, 0x93, 0xE2, 0x91, 0xE6, 0xE4, 0x93,
	0xE1, 0xE4, 0x96, 0xEE, 0x9D, 0x9F, 0x90, 0x9A, 0x9C, 0x9A, 0x93, 0xE1, 0xE2, 0xE4, 0xEF, 0xE3,
	0xE1, 0xE2, 0xE6, 0xE5, 0xE0, 0xE0, 0xEE, 0xE4, 0xE6, 0x96, 0xE2, 0x8D, 0xE1, 0xE4, 0xE6, 0xEE,
	0x9D, 0x9F, 0x94, 0xE2, 0xE1, 0xE6, 0xE4, 0x8D, 0xE2, 0xE4, 0x91, 0xE6, 0xE1, 0x84, 0xE3, 0xE4,
	0xE2, 0xE5, 0xE6, 0x95, 0xE4, 0x91, 0xE5, 0xE4, 0xEE, 0x91, 0xE2, 0x93, 0xE4, 0xE6, 0xE4, 0x91,
	0xE6, 0xE6, 0x93, 0xE4, 0xEF, 0x91, 0xE3, 0x93, 0xE1, 0xE5, 0x80, 0x85, 0x95, 0xE2, 0xE1, 0xE5,
	0xE2, 0x84, 0xE3, 0xE6, 0x94, 0xE5, 0xE4, 0x86, 0xE6, 0xE2, 0x84, 0xE1, 0x93, 0x93, 0x84, 0x91,
	0xE1, 0xE2, 0x91, 0x93, 0x90, 0x93, 0x84, 0xE1, 0xE5, 0xE4, 0x84, 0xE3, 0x86, 0xE1, 0xE6, 0x96,
	0x90, 0xE5, 0xE4, 0xE6, 0x85, 0xE6, 0x96, 0xE3, 0xE2, 0xE1, 0xE5, 0xE3, 0x93, 0xE2, 0xE1, 0x96,
	0xE5, 0x84, 0xE3, 0xE1, 0x96, 0xE2, 0xE5, 0xE6, 0x93, 0xE2, 0xE1, 0x92, 0x90, 0x91, 0x93, 0xE2,
	0xE3, 0xE1, 0xEE, 0x93, 0xE3, 0x84, 0xE1, 0xE5, 0xEE, 0x9F, 0x90, 0x9D, 0xE4, 0xE6, 0xE4, 0xE6,
	0xE5, 0xE4, 0x93, 0x86, 0xEE, 0x8E, 0x83, 0x8E, 0xE5, 0xE5, 0xE2, 0xE2, 0xE3, 0x9D, 0x9C, 0x9B,
	0xEE, 0xE0, 0x8E, 0x92, 0x83, 0x85, 0xE3, 0xE3, 0x92, 0x8D, 0x96, 0xE6, 0xE1, 0xE3, 0xE3, 0xE2,
	0x96, 0x92, 0xE1, 0xE3, 0xE2, 0xE2, 0xE0, 0x9A, 0xE3, 0xE3, 0x9C, 0x9B, 0x9D, 0xE4, 0xE3, 0xE3,
	0xE2, 0xE6, 0xE4, 0x9C, 0xE1, 0xE4, 0xE6, 0xE5, 0x92, 0x84, 0xEE, 0xE0, 0xE2, 0xE2, 0x9C, 0x9D,
	0xE6, 0xE6, 0xE4, 0xE5, 0xE1, 0x93, 0xE2, 0xE3, 0x9C, 0x9D, 0xEE, 0xEF, 0xE2, 0xE3, 0x92, 0x85,
	0x83, 0xEE, 0x92, 0x85, 0x8E, 0x95, 0xE1, 0xE5, 0x93, 0x84, 0x94, 0xE6, 0xE5, 0xE4, 0xE2, 0x91,
	0xE3, 0x93, 0xE1, 0xE4
};

const uint8_t Game::_protectionCodeDataAmiga[] = {
	0xE2, 0x93, 0xE3, 0xE2, 0x92, 0xE1, 0xE3, 0xE2, 0x84, 0xE1, 0x92, 0x85, 0xEF, 0xE0, 0x85, 0xEE,
	0xE2, 0xE3, 0xE0, 0xE0, 0xEF, 0x91, 0xEE, 0xE2, 0xE0, 0x93, 0xE6, 0x9D, 0x93, 0x9F, 0xEE, 0xE3,
	0x9F, 0xE2, 0xE6, 0xE5, 0x9F, 0x9B, 0xE5, 0xE3, 0xE1, 0x92, 0xE2, 0xE3, 0x99, 0xE1, 0x90, 0xE3,
	0xE2, 0x90, 0xE0, 0xE1, 0x99, 0xE3, 0xE0, 0xEF, 0xE1, 0xE6, 0x90, 0x9A, 0xE2, 0x91, 0xE4, 0x9D,
	0x91, 0xE6, 0x90, 0xE2, 0xE3, 0x9F, 0xE5, 0xE5, 0xE6, 0x95, 0xE4, 0xE1, 0x91, 0xE2, 0xE1, 0x9D,
	0xE2, 0xE1, 0xE6, 0xE6, 0xE4, 0x95, 0xE6, 0xE0, 0xEF, 0x96, 0x9F, 0x93, 0x9C, 0xE1, 0xE2, 0x93,
	0xE6, 0xE2, 0x9C, 0xE1, 0x82, 0xE6, 0xE0, 0xEF, 0x8F, 0xE6, 0xE2, 0x94, 0x9F, 0xE2, 0x91, 0xE5,
	0x9C, 0x91, 0xEF, 0xEE, 0x96, 0x93, 0xE0, 0x95, 0xE6, 0xE6, 0x95, 0xE5, 0xE3, 0x90, 0xE1, 0x9B,
	0xE2, 0x93, 0xE3, 0xE1, 0xE0, 0xE2, 0x90, 0xE3, 0x91, 0x93, 0xE2, 0x95, 0xE6, 0xEE, 0xE2, 0xE4,
	0xE2, 0x90, 0xE1, 0xE6, 0x91, 0xE4, 0xE2, 0xE2, 0x99, 0xE1, 0xE5, 0xE4, 0xE2, 0xE6, 0x95, 0xEE,
	0xE2, 0x93, 0x9B, 0x9C, 0xE1, 0x90, 0xE2, 0x95, 0x8D, 0x85, 0x86, 0x95, 0xE5, 0xE5, 0xEF, 0xEF,
	0xE3, 0x95, 0xE1, 0xE6, 0xE3, 0xE5, 0x94, 0x99, 0x9C, 0x9B, 0xE6, 0x91, 0xE2, 0x9F, 0x94, 0xEE,
	0xE1, 0xE2, 0xE1, 0x91, 0xE6, 0xE6, 0xE5, 0xE1, 0x94, 0xE4, 0x81, 0x95, 0x95, 0x94, 0x99, 0xE1,
	0xE2, 0xE4, 0xE2, 0x90, 0x95, 0xE3, 0xE1, 0x90, 0xE3, 0xEE, 0xE2, 0xE3, 0xE4, 0xE6, 0xE2, 0x90,
	0xE6, 0xE4, 0x85, 0xE5, 0xE6, 0xE5, 0x90, 0xE4, 0xEE, 0xEE, 0xE6, 0x90, 0xE5, 0xE4, 0x85, 0x92,
	0xE5, 0xE6, 0x91, 0xE4, 0x92, 0xE2, 0xE2, 0x90, 0xE6, 0x99, 0x99, 0x92, 0x84, 0xE5, 0xE6, 0xE4,
	0x84, 0x92, 0xEE, 0xEF, 0xEE, 0x91, 0xE2, 0xE6, 0x9A, 0x8F, 0xE6, 0xE2, 0x84, 0xE5, 0xE6, 0xE6,
	0xE5, 0xE3, 0xE4, 0xE5, 0xE6, 0xE4, 0xE3, 0xE5, 0x85, 0x91, 0xE6, 0xE3, 0x81, 0xE2, 0x91, 0xE3,
	0xE4, 0x91, 0xE3, 0xE2, 0xE1, 0x92, 0xE0, 0xE3, 0x91, 0xE1, 0xE2, 0xE6, 0xE6, 0x9C, 0x90, 0xE1,
	0xE2, 0xE0, 0xE6, 0x91, 0xE5, 0xE4, 0x92, 0xE1, 0x87, 0x9B, 0xE2, 0x93, 0xE1, 0xE3, 0x94, 0x85,
	0xE2, 0x93, 0xE1, 0xE5, 0xE1, 0xE4, 0x85, 0xEE, 0xEF, 0xE0, 0xE6, 0xE6, 0xE2, 0x90, 0xEF, 0xE2,
	0x9F, 0x91, 0x91, 0xE3, 0xE2, 0xE4, 0xE6, 0xE2, 0x95, 0xE1, 0x90, 0x9B, 0xE6, 0x9F, 0x9B, 0x9A,
	0x91, 0xEE, 0xE5, 0xE4, 0x99, 0xE1, 0x9F, 0xE2, 0x9C, 0x9C, 0x95, 0x91, 0xE6, 0xE5, 0xE3, 0x91,
	0xE2, 0x92, 0xE1, 0x94, 0xE6, 0x93, 0xE5, 0xEE, 0x92, 0x9D, 0x9B, 0x9A, 0x9F, 0xEE, 0xE2, 0x91,
	0xE6, 0x95, 0xE5, 0xE4, 0xEE, 0xE2, 0xE3, 0xE3, 0xEE, 0xE1, 0x90, 0xE5, 0xE3, 0x9F, 0xE2, 0x83,
	0xE1, 0xE2, 0x9B, 0x99, 0xE1, 0xE4, 0xE5, 0xE6, 0xEE, 0x9F, 0xE3, 0xE1, 0x83, 0xE4, 0xE2, 0x90,
	0x91, 0xE3, 0xE1, 0xE6, 0xE0, 0xE4, 0x9F, 0xE6, 0xE4, 0xE5, 0xEE, 0x81, 0xE6, 0xE5, 0xE4, 0x93,
	0xE2, 0x81, 0xE4, 0xEE, 0x84, 0xE3, 0xEE, 0xE3, 0xE2, 0x90, 0xE4, 0xE6, 0xEE, 0x95, 0xE2, 0xE1,
	0x91, 0xE5, 0xE6, 0xE2, 0x8D, 0xEE, 0xE1, 0x93, 0xE6, 0x91, 0xE2, 0x92, 0xE1, 0xE0, 0xE0, 0x91,
	0xE3, 0xE2, 0x92, 0xE5, 0xE1, 0x90, 0x85, 0xE4, 0xE5, 0xE6, 0xE3, 0x93, 0xE4, 0xE4, 0xEE, 0xE2,
	0xE5, 0xE4, 0x84, 0xE3, 0xE6, 0xE5, 0xE6, 0xE5, 0x90, 0xE4, 0xE5, 0x91, 0xEE, 0xEE, 0x94, 0xE1,
	0xE4, 0x93, 0xE6, 0xE2, 0x84, 0x8F, 0x80, 0xEE, 0xE0, 0xE0, 0x95, 0xEE, 0x85, 0xE4, 0xE5, 0xE3,
	0x91, 0x93, 0x93, 0xE6, 0xE1, 0x94, 0xE3, 0x93, 0x84, 0xE1, 0x9B, 0x91, 0x9A, 0xEE, 0xE2, 0xE1,
	0xE1, 0x81, 0xE2, 0x91, 0xE1, 0xE4, 0xEE, 0xEE, 0x95, 0x90, 0xE3, 0xE5, 0xEE, 0xE0, 0x83, 0xE3,
	0xE1, 0x91, 0xE4, 0x90, 0x9F, 0xE2, 0x95, 0xEE, 0xE1, 0x95, 0xE3, 0x84, 0xE1, 0x83, 0xE6, 0xE6,
	0xE5, 0xE1, 0xEF, 0xE5, 0x95, 0x91, 0xE3, 0x93, 0xE1, 0xE6, 0xE1, 0x91, 0xE2, 0xEE, 0xE2, 0xE3,
	0xEE, 0x91, 0xE3, 0xE2, 0x93, 0xE4, 0xE2, 0x93, 0xE3, 0xE2, 0x84, 0x9B, 0xEE, 0x91, 0xE3, 0x93,
	0xE2, 0x84, 0x92, 0x8D, 0xEF, 0xE2, 0xE1, 0xE6, 0xE2, 0x83, 0xE3, 0xE5, 0x90, 0xE4, 0xE3, 0x90,
	0xEE, 0xEE, 0x90, 0xE3, 0xE6, 0xE6, 0x90, 0xE4, 0x91, 0xE3, 0xEE, 0xEE, 0x99, 0xE6, 0xE5, 0x90,
	0xE1, 0x84, 0xE5, 0xE4, 0xE3, 0xE2, 0xEE, 0xEE, 0xE1, 0x91, 0xE2, 0xE1, 0x9D, 0x9C, 0x9B, 0xE2,
	0xE1, 0xE5, 0x83, 0x93, 0xE5, 0x83, 0x93, 0xE4, 0xE3, 0x91, 0xE1, 0x93, 0xE5, 0x99, 0x9C, 0x9C,
	0xEE, 0xE2, 0xE1, 0xE4, 0xEE, 0xE1, 0xE1, 0x91, 0x92, 0xE4, 0xE3, 0x91, 0xE2, 0x92, 0xE1, 0xE1,
	0xE1, 0x93, 0xE2, 0xE3, 0xE5, 0xE6, 0xEE, 0x91, 0x93, 0xE3, 0xE1, 0xE5, 0xE6, 0x91, 0xE2, 0x93,
	0xE1, 0xE5, 0x85, 0x83, 0xEE, 0xE1, 0xE2, 0x91, 0xE1, 0x91, 0xE1, 0x91, 0xE6, 0xE5, 0xEE, 0x91,
	0xEF, 0xE1, 0x93, 0xE4, 0xE2, 0x91, 0x91, 0x96, 0x84, 0xE2, 0x87, 0x9A, 0x84, 0xEE, 0xE1, 0xE4,
	0xE1, 0x84, 0x84, 0xE3, 0xE2, 0x93, 0xE4, 0xE6, 0x93, 0xE5, 0xE4, 0x84, 0x9D, 0x91, 0xE1, 0xE6,
	0xE5, 0xE4, 0xEE, 0x93, 0xE3, 0x84, 0xE1, 0xE5, 0xE1, 0x93, 0xE2, 0x84, 0xE1, 0x99, 0x92, 0xE1,
	0x83, 0xEF, 0x84, 0xE2, 0x92, 0xE2, 0xE3, 0xEF, 0xE1, 0x93, 0x91, 0xE6, 0xE2, 0xE5, 0x92, 0xE1,
	0x96, 0xE3, 0xE2, 0xE1, 0x84, 0x92, 0xE3, 0xE2, 0x8D, 0xE1, 0xEF, 0xE0, 0xE6, 0x93, 0xE1, 0x86,
	0x9D, 0xE5, 0xE4, 0x91, 0xE6, 0xEE, 0xE1, 0xE1, 0xEE, 0x91, 0xE3, 0x93, 0xE3, 0xE3, 0xE6, 0x90,
	0x91, 0xE1, 0x91, 0xE5, 0xE1, 0x9F, 0xE2, 0xE1, 0xE1, 0x90, 0xE5, 0xE6, 0x9A, 0x9C, 0x9D, 0x90,
	0xE1, 0xE3, 0x90, 0x90, 0x9F, 0x99, 0xE1, 0xE3, 0x9C, 0x9D, 0x9F, 0x9B, 0xE6, 0xE4, 0xE4, 0xE3,
	0xE2, 0xE1, 0xE3, 0xE6, 0xE5, 0xE3, 0xE0, 0x9C, 0x96, 0x85, 0x93, 0xE2, 0xE3, 0x81, 0xE0, 0xEF,
	0xE2, 0x82, 0x83, 0xE5, 0xE4, 0xE3, 0x9A, 0x9D, 0x98, 0x87, 0xE6, 0xE3, 0xE2, 0xE1, 0x95, 0x81,
	0xE1, 0xE3, 0x87, 0x82, 0x99, 0xE2, 0xE4, 0xE4, 0x9F, 0x90, 0x91, 0x99, 0xE2, 0xE3, 0x9C, 0x81,
	0x94, 0xE4, 0x9F, 0x90, 0xE2, 0xE3, 0x93, 0xE6, 0xEE, 0xEF, 0x90, 0xE1, 0x91, 0xE6, 0xE2, 0x90,
	0xE3, 0x91, 0xE1, 0x8E
};

const uint8_t Game::_protectionPal[] = {
	// DOS
	0x00, 0x00, 0x00, 0x42, 0x00, 0x63, 0x00, 0x00, 0x0F, 0xFF, 0x0F, 0xF0, 0x07, 0x77, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Amiga
	0x00, 0x00, 0x03, 0x04, 0x06, 0x05, 0x00, 0x00, 0x04, 0x44, 0x05, 0x55, 0x06, 0x66, 0x07, 0x77,
	0x08, 0x88, 0x09, 0x99, 0x0A, 0xAA, 0x0B, 0xBB, 0x0C, 0xCC, 0x0D, 0xDD, 0x0E, 0xEE, 0x0F, 0xFF
};

const char *Menu::_levelNames[] = {
	"Titan / The Jungle",
	"Titan / New Washington",
	"Titan / Death Tower Show",
	"Earth / Surface",
	"Earth / Paradise Club",
	"Planet Morphs / Surface",
	"Planet Morphs / Inner Core"
};

const char *Menu::_passwordsDOS[] = {
	"JAGUAR", "COMBEL", "ANTIC",  "NOLAN",  "ARTHUR", "SHIRYU", "RENDER", "BELUGA", // easy
	"BANTHA", "SHIVA",  "KASYYK", "SARLAC", "MAENOC", "SULUST", "NEPTUN", "BELUGA", // normal
	"TOHOLD", "PICOLO", "FUGU",   "CAPSUL", "ZZZAP",  "MANIAC", "NO WAY", "BELUGA", // hard
};

const char *Menu::_passwordsFrAmiga[] = {
	"BACK", "LOUP", "CINE", "GOOD", "SPIZ", "BIOS", "HALL", // easy
	"PLAY", "TOIT", "ZAPP", "LYNX", "SCSI", "GARY", "PONT", // normal
	"CLOP", "CARA", "CALE", "FONT", "HASH", "FIBO", "TIPS", // hard
};

const char *Menu::_passwordsEnAmiga[] = {
	"WIND", "SPIN", "KAVA", "HIRO", "TEST", "GOLD", "WALL", // easy
	"FIRE", "BURN", "EGGS", "GURT", "CHIP", "TREE", "BOLD", // normal
	"MINE", "YOUR", "NEST", "LINE", "LISA", "MARY", "MICE", // hard
};

const char *Menu::_passwordsMac[] = {
	"QUENCH",  "GHOST",  "LEGEND", "SPHERE",  "BULLET", "DISRUPT", "TRAUMA", "OPAQUE", // easy
	"HICK",    "FRGO",   "JERK",   "KOIK",    "KIMO",   "LEDUX",   "MORDO",  "OPAQUE", // normal
	"CURIOUS", "IMPACT", "LETHAL", "PERSIST", "MORTAL", "VERDICT", "KNIGHT", "OPAQUE", // hard
};

const uint8_t Video::_conradPal1[] = {
	0x00, 0x00, 0xCC, 0x0C, 0x8F, 0x08, 0x7E, 0x07, 0x6C, 0x06, 0x5B, 0x05, 0x4A, 0x04, 0x63, 0x09,
	0x52, 0x07, 0x41, 0x06, 0x30, 0x06, 0x76, 0x0C, 0x14, 0x09, 0x25, 0x0B, 0x88, 0x08, 0xFF, 0x0F
};

const uint8_t Video::_conradPal2[] = {
	0x00, 0x00, 0x7C, 0x0B, 0x04, 0x03, 0x03, 0x03, 0x03, 0x02, 0x02, 0x02, 0x01, 0x01, 0x26, 0x0A,
	0x14, 0x08, 0x03, 0x06, 0x02, 0x04, 0x43, 0x09, 0x02, 0x06, 0x02, 0x07, 0x6A, 0x0A, 0xFF, 0x0F
};

const uint8_t Video::_textPal[] = {
	0x00, 0x00, 0x11, 0x01, 0x22, 0x02, 0xEF, 0x0E, 0x00, 0x0F, 0xF0, 0x0F, 0xA0, 0x0E, 0xB0, 0x0F,
	0xA0, 0x0E, 0xA0, 0x0E, 0xAA, 0x0A, 0xF0, 0x00, 0xCC, 0x0C, 0xDF, 0x0D, 0xEE, 0x0E, 0xEE, 0x0E
};

const uint8_t Video::_palSlot0xF[] = {
	0x00, 0x00, 0x00, 0x1F, 0x17, 0x2B, 0x2B, 0x1F, 0x37, 0x37, 0x2B, 0x47, 0x43, 0x37, 0x53, 0x4F,
	0x43, 0x63, 0x5F, 0x53, 0x6F, 0x6F, 0x63, 0x7F, 0x7F, 0x73, 0x8B, 0x8F, 0x87, 0x9B, 0x9F, 0x97,
	0xA7, 0xAF, 0xA7, 0xB3, 0xBF, 0xBB, 0xBF, 0xCF, 0xCF, 0xCF, 0x00, 0x33, 0x00, 0x17, 0x0F, 0x1F
};

const uint8_t Video::_font8Jp[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFF, 0x20, 0x00, 0x00, 0xFF, 0x20, 0x00, 0x00, 0xFF, 0x20, 0x00, 0x00, 0xFF, 0x20, 0x00,
	0x00, 0xFF, 0x20, 0x00, 0x00, 0x22, 0x20, 0x00, 0x00, 0xFF, 0x20, 0x00, 0x00, 0x22, 0x20, 0x00,
	0x0F, 0xF0, 0xFF, 0x00, 0x0F, 0xF2, 0xFF, 0x20, 0x00, 0x22, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xF0, 0xFF, 0x00, 0x0F, 0xF2, 0xFF, 0x20, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xF2, 0xFF, 0x22,
	0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xF2, 0xFF, 0x22, 0x0F, 0xF2, 0xFF, 0x20, 0x00, 0x22, 0x02, 0x20,
	0x00, 0xF2, 0x00, 0xF2, 0xFF, 0xFF, 0xF2, 0xF2, 0x02, 0xF2, 0x22, 0x02, 0x0F, 0xFF, 0xFF, 0x20,
	0xF2, 0xF2, 0x22, 0xF2, 0xF2, 0xF2, 0x00, 0xF2, 0x0F, 0xF2, 0x0F, 0x22, 0x00, 0x22, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x0F, 0xF0, 0xFF, 0x20, 0xFF, 0x22, 0x02, 0x2F, 0xF2, 0x20,
	0x00, 0xFF, 0x22, 0x00, 0x0F, 0xF2, 0x2F, 0xF0, 0xFF, 0x22, 0x0F, 0xF2, 0x02, 0x20, 0x00, 0x22,
	0x00, 0xFF, 0xF0, 0x00, 0x0F, 0xF2, 0xFF, 0x00, 0x0F, 0xF2, 0xF2, 0x20, 0x0F, 0xFF, 0x0F, 0xF0,
	0xFF, 0x2F, 0xFF, 0x22, 0xFF, 0x20, 0xFF, 0x20, 0x0F, 0xFF, 0x0F, 0xF0, 0x00, 0x22, 0x20, 0x22,
	0x00, 0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF2, 0x00, 0x00, 0xFF, 0x22, 0x00, 0x00, 0x02, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xFF, 0x00, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0xFF, 0x22, 0x00, 0x00, 0xFF, 0x20, 0x00,
	0x00, 0xFF, 0x20, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x02, 0x20,
	0x00, 0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x20,
	0x00, 0x00, 0xFF, 0x20, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0xFF, 0x22, 0x00, 0x00, 0x02, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x0F, 0xF0, 0x00, 0xFF, 0xFF, 0x22, 0xFF, 0xFF, 0xFF, 0xFF,
	0x02, 0xFF, 0xFF, 0x22, 0x0F, 0xF2, 0x2F, 0xF0, 0x00, 0x22, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF2, 0x00, 0x0F, 0xFF, 0xFF, 0xF0,
	0x20, 0x2F, 0xF2, 0x22, 0x00, 0x0F, 0xF2, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF2, 0x00, 0x00, 0xFF, 0x22, 0x00, 0x00, 0x02, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xF0,
	0x00, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF2, 0x00, 0x00, 0x02, 0x22, 0x00,
	0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x0F, 0xF2, 0x00, 0x00, 0xFF, 0x22, 0x00, 0x0F, 0xF2, 0x20,
	0x00, 0xFF, 0x22, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0xFF, 0x22, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x00, 0xFF, 0x22, 0x2F, 0xF0, 0xFF, 0x20, 0xF0, 0xF2, 0xFF, 0x2F, 0x02, 0xF2,
	0xFF, 0xF0, 0x20, 0xF2, 0x0F, 0xFF, 0xFF, 0x22, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0xF2, 0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00, 0x0F, 0xF2, 0x00,
	0x00, 0x0F, 0xF2, 0x00, 0x00, 0x0F, 0xF2, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x00, 0xFF, 0x22, 0x2F, 0xF0, 0x02, 0x20, 0xFF, 0x22, 0x00, 0xFF, 0x22, 0x20,
	0x0F, 0xF2, 0x22, 0x00, 0xFF, 0xFF, 0xFF, 0xF0, 0x02, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x00, 0xFF, 0x22, 0x22, 0xF0, 0x02, 0x2F, 0xFF, 0xF2, 0x00, 0x00, 0x22, 0xF2,
	0xFF, 0x00, 0x00, 0xF2, 0x0F, 0xFF, 0xFF, 0x22, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0F, 0xFF, 0x00, 0x00, 0xFF, 0x2F, 0x20, 0x0F, 0xF2, 0x2F, 0x20, 0xFF, 0x22, 0x0F, 0x20,
	0xFF, 0xFF, 0xFF, 0xF0, 0x02, 0x22, 0x2F, 0x22, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0x22, 0x22, 0x22, 0xFF, 0xFF, 0xFF, 0x00, 0x02, 0x22, 0x22, 0xF0,
	0xFF, 0x20, 0x00, 0xF2, 0x0F, 0xFF, 0xFF, 0x22, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x00, 0xFF, 0x22, 0x22, 0xF0, 0xFF, 0xFF, 0xFF, 0x02, 0xFF, 0x22, 0x22, 0xF0,
	0xFF, 0x20, 0x00, 0xF2, 0x0F, 0xFF, 0xFF, 0x22, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0x22, 0x22, 0xF2, 0x02, 0x20, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20,
	0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x00, 0xFF, 0x22, 0x22, 0xF0, 0x0F, 0xFF, 0xFF, 0x02, 0xFF, 0x22, 0x22, 0xF0,
	0xFF, 0x20, 0x00, 0xF2, 0x0F, 0xFF, 0xFF, 0x22, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x00, 0xFF, 0x22, 0x22, 0xF0, 0x0F, 0xFF, 0xFF, 0xF2, 0x00, 0x22, 0x22, 0xF2,
	0xFF, 0x00, 0x00, 0xF2, 0x0F, 0xFF, 0xFF, 0x22, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0F, 0xFF, 0x00, 0x00, 0x0F, 0xFF, 0x20, 0x00, 0x00, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0F, 0xFF, 0x00, 0x00, 0x0F, 0xFF, 0x20, 0x00, 0x00, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF2, 0x00, 0x00, 0x02, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF2, 0x00, 0x00, 0x02, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xFF, 0x00, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0xFF, 0x22, 0x00, 0x00, 0xFF, 0x20, 0x00,
	0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0xF2, 0x00, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0xF2, 0x00, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x20,
	0x00, 0x0F, 0xF2, 0x20, 0x00, 0xFF, 0x22, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFF, 0xFF, 0x00, 0x0F, 0xF2, 0x2F, 0xF0, 0x00, 0x22, 0x0F, 0xF2, 0x00, 0x00, 0xFF, 0x22,
	0x00, 0x0F, 0xF2, 0x20, 0x00, 0x00, 0x22, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x22, 0x00,
	0x0F, 0xFF, 0xFF, 0x00, 0xFF, 0x22, 0x22, 0xF0, 0xFF, 0x2F, 0xF0, 0xF2, 0xFF, 0x2F, 0x22, 0xF2,
	0xFF, 0x2F, 0xFF, 0xF2, 0xFF, 0x20, 0x22, 0x22, 0x0F, 0xFF, 0xFF, 0x00, 0x00, 0x22, 0x22, 0x20,
	0x0F, 0xFF, 0xFF, 0x20, 0xFF, 0x22, 0x22, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0xFF, 0xFF, 0xF2,
	0xFF, 0x22, 0x22, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0x02, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xF2, 0x00, 0xFF, 0x22, 0x2F, 0x20, 0xFF, 0x20, 0x0F, 0x20, 0xFF, 0xFF, 0xFF, 0x20,
	0xFF, 0x22, 0x22, 0xF2, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x20, 0xFF, 0x22, 0x22, 0xF2, 0xFF, 0x20, 0x00, 0x02, 0xFF, 0x20, 0x00, 0x00,
	0xFF, 0x20, 0x00, 0xF2, 0x0F, 0xFF, 0xFF, 0x22, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xF2, 0x00, 0xFF, 0x22, 0x2F, 0x20, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2,
	0xFF, 0x20, 0x0F, 0x22, 0xFF, 0xFF, 0xF2, 0x20, 0x02, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFF, 0xF2, 0xFF, 0x22, 0x22, 0x22, 0xFF, 0x20, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20,
	0xFF, 0x22, 0x22, 0x20, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFF, 0xF2, 0xFF, 0x22, 0x22, 0x22, 0xFF, 0x20, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20,
	0xFF, 0x22, 0x22, 0x20, 0xFF, 0x20, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0xF2, 0xFF, 0x22, 0x22, 0x22, 0xFF, 0x20, 0x00, 0x00, 0xFF, 0x20, 0xFF, 0xF2,
	0xFF, 0x20, 0x02, 0xF2, 0x0F, 0xFF, 0xFF, 0x22, 0x02, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0xFF, 0xFF, 0xF2,
	0xFF, 0x22, 0x22, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0x02, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFF, 0xFF, 0x20, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0x0F, 0xF2, 0x00, 0x00, 0x0F, 0xF2, 0x00,
	0x00, 0x0F, 0xF2, 0x00, 0x00, 0xFF, 0xFF, 0x20, 0x00, 0x02, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0xF2,
	0xFF, 0x20, 0x00, 0xF2, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x0F, 0x20, 0xFF, 0xFF, 0xF2, 0x00,
	0xFF, 0x22, 0x2F, 0x20, 0xFF, 0x20, 0x00, 0xF2, 0x02, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0x20, 0x00, 0x00, 0xFF, 0x20, 0x00, 0x00, 0xFF, 0x20, 0x00, 0x00, 0xFF, 0x20, 0x00, 0x00,
	0xFF, 0x20, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFF, 0x20, 0xFF, 0x2F, 0xF2, 0xF2, 0xFF, 0x2F, 0xF2, 0xF2, 0xFF, 0x2F, 0xF2, 0xF2,
	0xFF, 0x2F, 0xF2, 0xF2, 0xFF, 0x2F, 0xF2, 0xF2, 0x02, 0x20, 0x22, 0x02, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFF, 0x20, 0xFF, 0x22, 0x22, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2,
	0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0x02, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x20, 0xFF, 0x22, 0x22, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2,
	0xFF, 0x20, 0x00, 0xF2, 0x0F, 0xFF, 0xFF, 0x22, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x20, 0xFF, 0x22, 0x22, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0xFF, 0xFF, 0x22,
	0xFF, 0x22, 0x22, 0x20, 0xFF, 0x20, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x20, 0xFF, 0x22, 0x22, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0xF2, 0xF2,
	0xFF, 0x20, 0xFF, 0x22, 0x0F, 0xFF, 0xFF, 0xF2, 0x00, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x20, 0xFF, 0x22, 0x22, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0xFF, 0xFF, 0x20,
	0xFF, 0x22, 0x2F, 0x20, 0xFF, 0x20, 0x00, 0xF2, 0x02, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x20, 0xFF, 0x22, 0x22, 0xF2, 0xFF, 0x20, 0x00, 0x22, 0x0F, 0xFF, 0xFF, 0x20,
	0xF2, 0x22, 0x22, 0xF2, 0x0F, 0xFF, 0xFF, 0x22, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFF, 0x20, 0x02, 0xFF, 0x22, 0x20, 0x00, 0xFF, 0x20, 0x00, 0x00, 0xFF, 0x20, 0x00,
	0x00, 0xFF, 0x20, 0x00, 0x00, 0xFF, 0x20, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2,
	0xFF, 0x20, 0x00, 0xF2, 0x0F, 0xFF, 0xFF, 0x22, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0x0F, 0x20, 0x00, 0xF2,
	0x00, 0xF2, 0x0F, 0x22, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0xF2, 0xF2, 0xFF, 0x20, 0xF2, 0xF2, 0xFF, 0x20, 0xF2, 0xF2,
	0x0F, 0xF2, 0xF2, 0xF2, 0x00, 0xFF, 0x2F, 0x22, 0x00, 0x02, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0x0F, 0xF2, 0x0F, 0x20, 0x00, 0xFF, 0xF2, 0x00,
	0x0F, 0xF2, 0x2F, 0x20, 0xFF, 0x22, 0x00, 0xF2, 0x02, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0xFF, 0xFF, 0xFF, 0xF2,
	0x02, 0x22, 0x22, 0xF2, 0xFF, 0xFF, 0xFF, 0x22, 0x02, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x22, 0xFF, 0x22, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0xFF, 0x22, 0x00,
	0x0F, 0xF2, 0x20, 0x00, 0xFF, 0xFF, 0xFF, 0xF0, 0x02, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xF2, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0xF2, 0x22, 0x20, 0x00, 0xFF, 0xFF, 0x20,
	0x0F, 0xF2, 0xF2, 0xF2, 0xF2, 0xFF, 0x22, 0xF2, 0xFF, 0xF2, 0x2F, 0x22, 0x02, 0x22, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x0F, 0x20, 0xF2, 0x00, 0x00, 0xF2,
	0xF2, 0x00, 0x00, 0xF2, 0xF2, 0xF2, 0x00, 0xF2, 0x0F, 0x22, 0x00, 0x02, 0x00, 0x20, 0x00, 0x00,
	0x0F, 0xFF, 0xF2, 0x00, 0x00, 0x22, 0x22, 0x00, 0x0F, 0xFF, 0xF2, 0x00, 0xF2, 0x22, 0x2F, 0x20,
	0x02, 0x00, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0x0F, 0xFF, 0x22, 0x00, 0x00, 0x22, 0x20, 0x00,
	0x00, 0xFF, 0xF2, 0x00, 0x00, 0x02, 0x22, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x2F, 0x22, 0x20,
	0x00, 0xFF, 0x20, 0x00, 0x0F, 0x22, 0xF2, 0x00, 0xF2, 0x20, 0xFF, 0xF2, 0x02, 0x00, 0x02, 0x22,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x22, 0x22, 0x22,
	0x0F, 0x20, 0x0F, 0x20, 0xFF, 0xFF, 0x20, 0xF2, 0x0F, 0x22, 0xF2, 0xF2, 0x0F, 0x20, 0xF2, 0xF2,
	0x0F, 0x20, 0xF2, 0x02, 0xF2, 0x20, 0xF2, 0x00, 0xF2, 0x0F, 0xF2, 0x00, 0x02, 0x00, 0x22, 0x00,
	0x00, 0xF2, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x2F, 0x22, 0x20, 0xFF, 0xFF, 0xFF, 0xF2,
	0x02, 0x22, 0xF2, 0x22, 0xF2, 0x00, 0x02, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x22, 0x20,
	0x00, 0x0F, 0xF2, 0x00, 0x00, 0x0F, 0x22, 0x00, 0x00, 0xF2, 0x20, 0x00, 0x0F, 0x22, 0x00, 0x00,
	0x00, 0xF2, 0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0xF2, 0x00, 0x00, 0x00, 0x22, 0x00,
	0xF2, 0x00, 0x0F, 0x20, 0xF2, 0xFF, 0xFF, 0xF2, 0xF2, 0x02, 0x2F, 0x22, 0xF2, 0x00, 0x0F, 0x20,
	0xF2, 0x00, 0x0F, 0x20, 0xF2, 0x00, 0x0F, 0x20, 0x0F, 0x20, 0xF2, 0x20, 0x00, 0x20, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xF2, 0x00, 0x22, 0x22, 0x22,
	0x00, 0xF2, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x2F, 0x22, 0x20, 0x00, 0x00, 0xF2, 0x00,
	0xF2, 0x00, 0x02, 0x00, 0xF2, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x22, 0x20,
	0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00,
	0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x0F, 0x20, 0x00, 0xFF, 0xF2, 0x20, 0x00, 0x02, 0x22, 0x00,
	0x00, 0x00, 0x0F, 0x20, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x2F, 0xFF, 0x22, 0x00, 0xF2, 0x2F, 0x20,
	0x00, 0x0F, 0xFF, 0x20, 0x00, 0x00, 0x2F, 0x20, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0x00, 0x22, 0x00,
	0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0xFF, 0xFF, 0xFF, 0xF2, 0x0F, 0x22, 0x2F, 0x22,
	0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x00, 0x20, 0x00, 0xFF, 0xFF, 0x20, 0x00, 0x02, 0x22, 0x20,
	0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x2F, 0xF2, 0x20, 0x00, 0xF2, 0x22, 0x00, 0xFF, 0xFF, 0xFF, 0xF2,
	0x02, 0x2F, 0x22, 0x22, 0x00, 0xF2, 0x20, 0x00, 0x00, 0xFF, 0xFF, 0x20, 0x00, 0x02, 0x22, 0x20,
	0x0F, 0x20, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x0F, 0x22, 0x22, 0x20, 0x0F, 0x2F, 0xFF, 0xF2,
	0x0F, 0x20, 0x22, 0x22, 0xF2, 0x2F, 0x20, 0x00, 0xF2, 0x00, 0xFF, 0xF2, 0x02, 0x00, 0x02, 0x22,
	0x00, 0xF2, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0xF2, 0x22, 0x22, 0x00, 0xFF, 0xFF, 0x20,
	0x0F, 0x22, 0x22, 0xF2, 0x00, 0x20, 0x00, 0xF2, 0x0F, 0xFF, 0xFF, 0x22, 0x00, 0x22, 0x22, 0x20,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xF2, 0x00, 0x02, 0x22, 0x2F, 0x20, 0x00, 0x00, 0x0F, 0x20,
	0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0x00, 0xFF, 0x22, 0x00, 0x00, 0x02, 0x20, 0x00,
	0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x2F, 0xF2, 0x20, 0x00, 0xF2, 0x22, 0x00, 0x0F, 0x22, 0x00, 0x00,
	0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0xFF, 0xF2, 0x00, 0x00, 0x02, 0x22, 0x00,
	0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0xFF, 0x20, 0x00, 0xFF, 0x22, 0x20, 0x0F, 0x22, 0x20, 0x00,
	0xF2, 0x20, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x22, 0x20,
	0x00, 0xF2, 0x00, 0x00, 0xFF, 0xFF, 0xF2, 0x00, 0x0F, 0x22, 0x2F, 0xF2, 0x0F, 0x20, 0x0F, 0x22,
	0xF2, 0xFF, 0xFF, 0x20, 0x02, 0xF2, 0x2F, 0xF2, 0x00, 0x0F, 0xF2, 0x22, 0x00, 0x00, 0x22, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xF2, 0x0F, 0xFF, 0xF2, 0xF2, 0x00, 0x22, 0x22, 0xF2, 0x00, 0x00, 0x00,
	0xF2, 0xF2, 0x00, 0x00, 0xF2, 0xF2, 0x00, 0x00, 0x0F, 0x2F, 0xFF, 0xF2, 0x00, 0x20, 0x22, 0x22,
	0x0F, 0x20, 0x0F, 0x20, 0x0F, 0xFF, 0xFF, 0x20, 0x0F, 0x22, 0xFF, 0xF2, 0xF2, 0xF2, 0xF2, 0xF2,
	0xF2, 0xFF, 0x22, 0xF2, 0xF2, 0xF2, 0xFF, 0xF2, 0x0F, 0x22, 0xFF, 0x22, 0x00, 0x20, 0x02, 0x20,
	0x0F, 0x20, 0x00, 0x00, 0xFF, 0x2F, 0xFF, 0x20, 0x0F, 0xF2, 0x22, 0xF2, 0x0F, 0x22, 0x00, 0xF2,
	0x0F, 0x20, 0xFF, 0xF2, 0xFF, 0x2F, 0x22, 0xF2, 0x0F, 0x20, 0xFF, 0x22, 0x00, 0x20, 0x02, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0xFF, 0x2F, 0x2F, 0xF2, 0xF2, 0x2F, 0x20, 0xF2,
	0xF2, 0x0F, 0x20, 0xF2, 0xF2, 0x0F, 0x20, 0xF2, 0x0F, 0xF2, 0x2F, 0x22, 0x00, 0x22, 0x00, 0x20,
	0x00, 0x00, 0x0F, 0x20, 0xF2, 0x0F, 0xFF, 0xF2, 0xF2, 0x00, 0x2F, 0x22, 0xF2, 0x00, 0x0F, 0x20,
	0xF2, 0x0F, 0xFF, 0xF2, 0xF2, 0xF2, 0x2F, 0x22, 0x0F, 0x2F, 0xFF, 0x20, 0x00, 0x20, 0x22, 0x20,
	0xFF, 0xF2, 0x00, 0x00, 0x02, 0xF2, 0x0F, 0x20, 0x0F, 0x22, 0x0F, 0xF2, 0xF2, 0x20, 0x0F, 0x22,
	0xF2, 0x00, 0x0F, 0x20, 0xF2, 0x00, 0xF2, 0x20, 0x0F, 0xFF, 0x22, 0x00, 0x00, 0x22, 0x20, 0x00,
	0x00, 0xFF, 0x20, 0x00, 0x00, 0x02, 0xF2, 0x00, 0x00, 0x00, 0x02, 0x00, 0x0F, 0x2F, 0x20, 0xF2,
	0x0F, 0x20, 0xF2, 0xF2, 0xF2, 0x20, 0xF2, 0xF2, 0x02, 0xFF, 0x22, 0x02, 0x00, 0x02, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x20, 0x00, 0x0F, 0x22, 0xF2, 0x00,
	0xF2, 0x20, 0x0F, 0x20, 0x02, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0xF2, 0xFF, 0xFF, 0xF2, 0xF2, 0x02, 0x2F, 0x22, 0xF2, 0xFF, 0xFF, 0xF2, 0xF2, 0x02, 0x2F, 0x22,
	0xF2, 0x0F, 0xFF, 0x20, 0xF2, 0xF2, 0x2F, 0xF2, 0x0F, 0x2F, 0xF2, 0xF2, 0x00, 0x20, 0x22, 0x02,
	0x00, 0x0F, 0x20, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x2F, 0x22, 0x20, 0xFF, 0xFF, 0xFF, 0x20,
	0x02, 0x2F, 0x22, 0x20, 0x0F, 0xFF, 0xF2, 0x00, 0x0F, 0xFF, 0x2F, 0x20, 0x00, 0x22, 0x20, 0x20,
	0x0F, 0xFF, 0x20, 0x00, 0x00, 0x2F, 0x20, 0x00, 0x00, 0x0F, 0x2F, 0x20, 0x0F, 0xFF, 0xFF, 0xF2,
	0xF2, 0x2F, 0x2F, 0x22, 0xF2, 0xF2, 0x2F, 0x20, 0xFF, 0xF2, 0xF2, 0x20, 0x02, 0x22, 0x02, 0x00,
	0x00, 0xF2, 0x00, 0x00, 0xFF, 0xFF, 0x2F, 0x20, 0x02, 0xF2, 0x20, 0xF2, 0x0F, 0xF2, 0x00, 0x02,
	0xF2, 0xF2, 0x00, 0xF2, 0x0F, 0xF2, 0x00, 0xF2, 0x00, 0xFF, 0xFF, 0x22, 0x00, 0x02, 0x22, 0x20,
	0x0F, 0x20, 0x0F, 0x20, 0x0F, 0xFF, 0xFF, 0x20, 0xFF, 0xF2, 0xFF, 0xF2, 0xF2, 0xF2, 0xF2, 0xF2,
	0xF2, 0xFF, 0xF2, 0xF2, 0xF2, 0xFF, 0x22, 0xF2, 0x0F, 0x2F, 0x2F, 0x22, 0x00, 0x20, 0x20, 0x20,
	0x00, 0xF2, 0x00, 0x00, 0xFF, 0xFF, 0xF2, 0x00, 0x02, 0xF2, 0x22, 0x00, 0xFF, 0xFF, 0xF2, 0x00,
	0x0F, 0x22, 0x22, 0xF2, 0x0F, 0x20, 0x00, 0xF2, 0x00, 0xFF, 0xFF, 0x22, 0x00, 0x02, 0x22, 0x20,
	0x0F, 0x20, 0xF2, 0x00, 0x0F, 0x2F, 0xFF, 0x20, 0xFF, 0xF2, 0xF2, 0xF2, 0x02, 0xF2, 0xF2, 0xF2,
	0x00, 0xF2, 0x02, 0xF2, 0x00, 0xF2, 0xFF, 0x22, 0x00, 0xF2, 0x02, 0x20, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0xF2, 0x00, 0xF2, 0xFF, 0xFF, 0x20, 0xFF, 0x22, 0xF2, 0xF2, 0xF2, 0x20, 0xF2, 0xF2,
	0xF2, 0xFF, 0xFF, 0x22, 0x02, 0x02, 0xF2, 0x20, 0x00, 0x0F, 0x22, 0x00, 0x00, 0x00, 0x20, 0x00,
	0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0xFF, 0xF2, 0x00, 0x00, 0xF2, 0x22, 0x00, 0x00, 0xF2, 0x00,
	0x0F, 0xFF, 0xFF, 0x20, 0xF2, 0x22, 0xF2, 0xF2, 0x0F, 0xFF, 0x22, 0x02, 0x00, 0x22, 0x20, 0x00,
	0x00, 0xFF, 0xF2, 0x00, 0x00, 0x02, 0x2F, 0x20, 0xF2, 0x00, 0x00, 0x20, 0xF2, 0xFF, 0xFF, 0x20,
	0x0F, 0x22, 0x22, 0xF2, 0x00, 0x20, 0x00, 0xF2, 0x00, 0xFF, 0xFF, 0x22, 0x00, 0x02, 0x22, 0x20,
	0x0F, 0x20, 0x00, 0xF2, 0x0F, 0x20, 0x00, 0xF2, 0x0F, 0x20, 0x00, 0xF2, 0x0F, 0x2F, 0x20, 0xF2,
	0x00, 0xF2, 0x20, 0xF2, 0x00, 0x02, 0x0F, 0x22, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0x00, 0x22, 0x00,
	0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x2F, 0x22, 0x20, 0x00, 0xFF, 0xFF, 0x20, 0x0F, 0x22, 0x22, 0xF2,
	0xF2, 0x2F, 0x20, 0xF2, 0x02, 0xF2, 0xF2, 0xF2, 0x00, 0xFF, 0xFF, 0x22, 0x00, 0x02, 0x22, 0x20,
	0x0F, 0x20, 0x00, 0x00, 0xFF, 0x2F, 0xFF, 0x20, 0x0F, 0xF2, 0x22, 0xF2, 0x0F, 0x22, 0x00, 0xF2,
	0x0F, 0x20, 0x0F, 0x22, 0xFF, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x00, 0xF2, 0x00, 0x20, 0x00, 0x02,
	0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x2F, 0xF2, 0x20, 0x00, 0xF2, 0x22, 0x00, 0x0F, 0xFF, 0xFF, 0x20,
	0xF2, 0x22, 0x22, 0xF2, 0x02, 0x00, 0x00, 0xF2, 0x00, 0xFF, 0xFF, 0x22, 0x00, 0x02, 0x22, 0x20,
	0x0F, 0x20, 0x00, 0x00, 0xFF, 0x2F, 0xFF, 0x20, 0x0F, 0xF2, 0x22, 0xF2, 0x0F, 0x22, 0x00, 0xF2,
	0x0F, 0x20, 0x00, 0xF2, 0xFF, 0x20, 0x00, 0xF2, 0x0F, 0x20, 0x0F, 0x22, 0x00, 0x20, 0x00, 0x20,
	0x00, 0x0F, 0x20, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0xF2, 0x22, 0x20, 0x00, 0x0F, 0xFF, 0xF2,
	0x0F, 0xF2, 0xF2, 0x22, 0x0F, 0x22, 0x02, 0x00, 0x00, 0xFF, 0xFF, 0xF2, 0x00, 0x02, 0x22, 0x22,
	0x00, 0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x0F, 0x22, 0x00, 0x00, 0x0F, 0xFF, 0x20, 0x00,
	0x0F, 0x2F, 0x20, 0xF2, 0xF2, 0x2F, 0x20, 0xF2, 0xF2, 0x00, 0xFF, 0x22, 0x02, 0x00, 0x02, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x2F, 0x22, 0x20,
	0x00, 0xFF, 0xFF, 0x20, 0x0F, 0x2F, 0xF2, 0xF2, 0x0F, 0xFF, 0x2F, 0xF2, 0x00, 0x22, 0x20, 0x22,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x0F, 0x20,
	0x0F, 0x20, 0x00, 0xF2, 0x0F, 0x20, 0x00, 0xF2, 0x00, 0xF2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF2, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0xFF, 0xFF, 0x20,
	0x00, 0x02, 0x2F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0x00, 0x22, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF2, 0x00, 0x00, 0x02, 0x22, 0x00, 0x0F, 0xFF, 0xFF, 0x20,
	0x00, 0x22, 0xF2, 0x20, 0x00, 0x0F, 0x22, 0x00, 0x0F, 0xF2, 0xFF, 0x20, 0x00, 0x22, 0x02, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x0F, 0xFF, 0x2F, 0x20, 0x00, 0xF2, 0x2F, 0x20,
	0x00, 0xFF, 0xF2, 0x20, 0x0F, 0xF2, 0x2F, 0x20, 0x0F, 0xF2, 0xFF, 0x20, 0x00, 0x22, 0x02, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF2, 0xF2, 0x00, 0x0F, 0xFF, 0xFF, 0x20,
	0x00, 0xF2, 0x2F, 0x20, 0x00, 0xF2, 0xF2, 0x20, 0x00, 0xF2, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x2F, 0x20, 0x00, 0x0F, 0xFF, 0xF2, 0x00,
	0x0F, 0x2F, 0x2F, 0x20, 0x00, 0x2F, 0xF2, 0x20, 0x00, 0xF2, 0x22, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0xFF, 0x20,
	0x00, 0x0F, 0x22, 0x20, 0x0F, 0xFF, 0xFF, 0x20, 0x0F, 0xFF, 0x22, 0x20, 0x00, 0x22, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF2, 0x00,
	0x00, 0x22, 0x2F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0x00, 0x22, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFF, 0xF2, 0x00, 0x00, 0xF2, 0xF2, 0x00, 0x00, 0xFF, 0xF2, 0x00, 0x00, 0x02, 0x22, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xF2, 0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x0F, 0xFF, 0xF2, 0x00, 0x0F, 0x22, 0x22, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x0F, 0xFF, 0xF2, 0x00,
	0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x22, 0x2F, 0x20, 0x00, 0xF2, 0x0F, 0x20, 0x00, 0xFF, 0xF2, 0x20,
	0x00, 0xF2, 0x22, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x0F, 0x22, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0xFF, 0xFF, 0x22, 0x00,
	0x02, 0x2F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
	0x00, 0x0F, 0x20, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0xF2, 0x22, 0x2F, 0x20, 0x02, 0x00, 0x0F, 0x20,
	0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0x0F, 0xFF, 0x22, 0x00, 0x00, 0x22, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x2F, 0x22, 0x20, 0x00, 0x0F, 0x20, 0x00,
	0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x22, 0x22, 0x22,
	0x00, 0x00, 0xF2, 0x00, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x2F, 0xF2, 0x22, 0x00, 0x0F, 0xF2, 0x00,
	0x00, 0xF2, 0xF2, 0x00, 0x0F, 0x22, 0xF2, 0x00, 0xF2, 0x2F, 0xF2, 0x00, 0x02, 0x00, 0x22, 0x00,
	0x00, 0xF2, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0xF2, 0x2F, 0x20, 0x00, 0xF2, 0x0F, 0x20,
	0x0F, 0x22, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0xF2, 0x20, 0xF2, 0x20, 0x02, 0x00, 0x02, 0x00,
	0x00, 0xF2, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x2F, 0x22, 0x20, 0x00, 0x0F, 0x20, 0x00,
	0x0F, 0xFF, 0xFF, 0xF2, 0x00, 0x22, 0xF2, 0x22, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0xFF, 0xFF, 0x20, 0x00, 0xF2, 0x2F, 0x20, 0x0F, 0x22, 0x0F, 0x20, 0x00, 0x20, 0x0F, 0x20,
	0x00, 0x00, 0xF2, 0x20, 0x00, 0x0F, 0x22, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0x00, 0x22, 0x00, 0x00,
	0x00, 0xF2, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xF2, 0x0F, 0x22, 0xF2, 0x22, 0xF2, 0x20, 0xF2, 0x00,
	0x02, 0x00, 0xF2, 0x00, 0x00, 0x0F, 0x22, 0x00, 0x00, 0xF2, 0x20, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x22, 0x2F, 0x20, 0x00, 0x00, 0x0F, 0x20,
	0x00, 0x00, 0x0F, 0x20, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0x20, 0xF2, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x0F, 0x22, 0xF2, 0x20, 0x0F, 0x20, 0xF2, 0x00,
	0x00, 0x20, 0xF2, 0x00, 0x00, 0x0F, 0x22, 0x00, 0x00, 0xF2, 0x20, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x0F, 0x20, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0xF2, 0x02, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20,
	0x00, 0x20, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0xFF, 0xFF, 0x22, 0x00, 0x02, 0x22, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x22, 0xF2, 0x20, 0x00, 0x0F, 0x22, 0x00,
	0x00, 0xFF, 0x20, 0x00, 0x0F, 0x22, 0xF2, 0x00, 0xF2, 0x20, 0x0F, 0x20, 0x02, 0x00, 0x00, 0x20,
	0x00, 0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0xF2, 0x22, 0xF2,
	0x00, 0xF2, 0x0F, 0x22, 0x00, 0xF2, 0x00, 0x20, 0x00, 0x0F, 0xFF, 0xF2, 0x00, 0x00, 0x22, 0x22,
	0xF2, 0x00, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x00, 0x20, 0x0F, 0x20,
	0x00, 0x00, 0xF2, 0x20, 0x00, 0x0F, 0x22, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0x00, 0x22, 0x00, 0x00,
	0x00, 0xF2, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0xF2, 0x22, 0x2F, 0x20, 0x02, 0xF2, 0x0F, 0x20,
	0x00, 0x0F, 0xF2, 0x20, 0x00, 0x0F, 0x22, 0x00, 0xFF, 0xF2, 0x20, 0x00, 0x02, 0x22, 0x00, 0x00,
	0x00, 0x0F, 0xF2, 0x00, 0x0F, 0xFF, 0x22, 0x00, 0x00, 0x2F, 0x20, 0x00, 0xFF, 0xFF, 0xFF, 0xF2,
	0x02, 0x2F, 0x22, 0x22, 0x00, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xF2, 0xF2, 0x0F, 0x20, 0xF2, 0xF2, 0x0F, 0x20, 0x02, 0x02, 0x0F, 0x20,
	0x00, 0x00, 0xF2, 0x20, 0x00, 0x0F, 0x22, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0x00, 0x22, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x22, 0x20, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x2F, 0x22, 0x22,
	0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0xFF, 0xF2, 0x00,
	0x00, 0xF2, 0x2F, 0x20, 0x00, 0xF2, 0x00, 0x20, 0x00, 0xF2, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x2F, 0x22, 0x22,
	0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x2F, 0x20, 0x00, 0xF2, 0xF2, 0x20,
	0x00, 0x0F, 0x22, 0x00, 0x00, 0xF2, 0xF2, 0x00, 0xFF, 0x22, 0x0F, 0x20, 0x02, 0x20, 0x00, 0x20,
	0x00, 0x0F, 0x20, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x2F, 0x20, 0x00, 0x00, 0xF2, 0x20,
	0x00, 0xFF, 0x2F, 0x20, 0xFF, 0x2F, 0x20, 0xF2, 0x02, 0x2F, 0x20, 0x02, 0x00, 0x00, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x0F, 0x22, 0x00,
	0x00, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0x00, 0x0F, 0x22, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x20, 0xF2, 0x00, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20,
	0x0F, 0x20, 0x00, 0xF2, 0xF2, 0x20, 0x00, 0xF2, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xF2, 0x00, 0xF2, 0x22, 0x22, 0x00,
	0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x22, 0x20,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x22, 0x2F, 0x20, 0x00, 0x00, 0x0F, 0x20,
	0x00, 0x00, 0xF2, 0x20, 0x00, 0x0F, 0x22, 0x00, 0x0F, 0xF2, 0x20, 0x00, 0x00, 0x22, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x0F, 0x2F, 0x20, 0x00, 0xF2, 0x20, 0xF2, 0x00,
	0x02, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0F, 0x20, 0x00, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x2F, 0x22, 0x22, 0x0F, 0x2F, 0x2F, 0x20,
	0x0F, 0x2F, 0x20, 0xF2, 0xF2, 0x2F, 0x20, 0xF2, 0x02, 0xFF, 0x20, 0x02, 0x00, 0x02, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x22, 0x2F, 0x22, 0x0F, 0x20, 0xF2, 0x20,
	0x00, 0xFF, 0x22, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0xFF, 0x20, 0x00, 0x00, 0x02, 0xFF, 0x20, 0x00, 0xF2, 0x02, 0x20, 0x00, 0x0F, 0xFF, 0x20,
	0x0F, 0x20, 0x22, 0x20, 0x00, 0xFF, 0x20, 0x00, 0x00, 0x02, 0xFF, 0xF2, 0x00, 0x00, 0x02, 0x22,
	0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0x00, 0x00, 0xF2, 0x0F, 0x20,
	0x0F, 0x22, 0x0F, 0x20, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x22, 0x22, 0xF2, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0xF2, 0xF2, 0x20, 0x00, 0x0F, 0xF2, 0x00,
	0x00, 0x0F, 0xF2, 0x00, 0x00, 0xF2, 0x2F, 0x20, 0xFF, 0x22, 0x00, 0x20, 0x02, 0x20, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x20, 0x00, 0xF2, 0x22, 0x20, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0xF2, 0x22, 0x22,
	0x00, 0xF2, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF2, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xF2, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0xF2, 0x22, 0xF2, 0x00, 0xF2, 0x0F, 0x22,
	0x00, 0x0F, 0x20, 0x20, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF2, 0x00, 0x00, 0x22, 0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00,
	0x00, 0x00, 0xF2, 0x00, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x2F, 0x20, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x2F, 0x20,
	0x00, 0x00, 0x0F, 0x20, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x22, 0x20, 0xFF, 0xFF, 0xFF, 0xF2, 0x02, 0x22, 0x22, 0xF2,
	0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x0F, 0x22, 0x00, 0xFF, 0xF2, 0x20, 0x00, 0x02, 0x22, 0x00,
	0x0F, 0x22, 0x2F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20, 0x0F, 0x20,
	0x00, 0x20, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0x00, 0x0F, 0x22, 0x00, 0x00, 0x00, 0x20, 0x00,
	0x00, 0x0F, 0x20, 0x00, 0x0F, 0x2F, 0x20, 0x00, 0x0F, 0x2F, 0x20, 0x00, 0x0F, 0x2F, 0x20, 0x00,
	0x0F, 0x2F, 0x20, 0xF2, 0x0F, 0x2F, 0x2F, 0x22, 0xF2, 0x2F, 0xF2, 0x20, 0x02, 0x00, 0x22, 0x00,
	0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0xF2,
	0x0F, 0x20, 0x0F, 0x22, 0x0F, 0x20, 0xF2, 0x20, 0x0F, 0xFF, 0x22, 0x00, 0x00, 0x22, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0xF2, 0x22, 0x2F, 0x20, 0xF2, 0x00, 0x0F, 0x20,
	0xF2, 0x00, 0x0F, 0x20, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFF, 0x20, 0xF2, 0x22, 0x2F, 0x20, 0xF2, 0x00, 0x0F, 0x20, 0x02, 0x00, 0x0F, 0x20,
	0x00, 0x00, 0xF2, 0x20, 0x00, 0x00, 0xF2, 0x00, 0x00, 0xFF, 0x22, 0x00, 0x00, 0x02, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x20, 0x02, 0x22, 0x2F, 0x20, 0xFF, 0xFF, 0xFF, 0x20,
	0x02, 0x22, 0x2F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0x0F, 0xFF, 0x22, 0x00, 0x00, 0x22, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0xF2, 0x00, 0x00, 0x02, 0x22, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20,
	0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20, 0xFF, 0xFF, 0x22, 0x00, 0x02, 0x22, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x2F, 0x2F, 0x20,
	0x00, 0x0F, 0xF2, 0x20, 0x00, 0x0F, 0x22, 0x00, 0x00, 0xF2, 0x20, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0xF2, 0x20,
	0x0F, 0xFF, 0x22, 0x00, 0x00, 0x2F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x0F, 0xFF, 0xFF, 0x20,
	0x0F, 0x22, 0x2F, 0x20, 0x00, 0x20, 0x0F, 0x20, 0x00, 0xFF, 0xF2, 0x20, 0x00, 0x02, 0x22, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x2F, 0x22, 0x20,
	0x00, 0x0F, 0x20, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x22, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x0F, 0xFF, 0xFF, 0x20,
	0x00, 0x2F, 0xF2, 0x20, 0x00, 0xF2, 0xF2, 0x00, 0x0F, 0x22, 0xF2, 0x00, 0x00, 0x20, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x20,
	0x00, 0xF2, 0x2F, 0x20, 0x00, 0xF2, 0xF2, 0x20, 0x00, 0xF2, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF2, 0x00,
	0x00, 0x02, 0xF2, 0x00, 0x00, 0x00, 0xF2, 0x00, 0x0F, 0xFF, 0xFF, 0x20, 0x00, 0x22, 0x22, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x20, 0x00, 0x02, 0x2F, 0x20,
	0x00, 0xFF, 0xFF, 0x20, 0x00, 0x02, 0x2F, 0x20, 0x00, 0xFF, 0xFF, 0x20, 0x00, 0x02, 0x22, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x2F, 0x2F, 0x20,
	0x0F, 0x2F, 0x2F, 0x20, 0x00, 0x20, 0x2F, 0x20, 0x00, 0xFF, 0xF2, 0x20, 0x00, 0x02, 0x22, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF2, 0x00,
	0x00, 0x0F, 0xF2, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF2, 0x0F, 0xF2,
	0x0F, 0xF2, 0x0F, 0xF2, 0x00, 0x22, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xF2, 0x00, 0x00, 0xF2, 0x0F, 0x20, 0x00, 0x0F, 0x20, 0x20, 0x00, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xF2, 0x00, 0x00, 0xF2, 0xF2, 0x00, 0x00, 0xFF, 0xF2, 0x00, 0x00, 0x02, 0x22, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint16_t ModPlayer::_periodTable[] = {
	856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453, // C-1 to B-1 Finetune 0
	428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226, // C-2 to B-2 Finetune 0
	214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113, // C-3 to B-3 Finetune 0
	850, 802, 757, 715, 674, 637, 601, 567, 535, 505, 477, 450, // C-1 to B-1 Finetune +1
	425, 401, 379, 357, 337, 318, 300, 284, 268, 253, 239, 225, // C-2 to B-2 Finetune +1
	213, 201, 189, 179, 169, 159, 150, 142, 134, 126, 119, 113, // C-3 to B-3 Finetune +1
	844, 796, 752, 709, 670, 632, 597, 563, 532, 502, 474, 447, // C-1 to B-1 Finetune +2
	422, 398, 376, 355, 335, 316, 298, 282, 266, 251, 237, 224, // C-2 to B-2 Finetune +2
	211, 199, 188, 177, 167, 158, 149, 141, 133, 125, 118, 112, // C-3 to B-3 Finetune +2
	838, 791, 746, 704, 665, 628, 592, 559, 528, 498, 470, 444, // C-1 to B-1 Finetune +3
	419, 395, 373, 352, 332, 314, 296, 280, 264, 249, 235, 222, // C-2 to B-2 Finetune +3
	209, 198, 187, 176, 166, 157, 148, 140, 132, 125, 118, 111, // C-3 to B-3 Finetune +3
	832, 785, 741, 699, 660, 623, 588, 555, 524, 495, 467, 441, // C-1 to B-1 Finetune +4
	416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233, 220, // C-2 to B-2 Finetune +4
	208, 196, 185, 175, 165, 156, 147, 139, 131, 124, 117, 110, // C-3 to B-3 Finetune +4
	826, 779, 736, 694, 655, 619, 584, 551, 520, 491, 463, 437, // C-1 to B-1 Finetune +5
	413, 390, 368, 347, 328, 309, 292, 276, 260, 245, 232, 219, // C-2 to B-2 Finetune +5
	206, 195, 184, 174, 164, 155, 146, 138, 130, 123, 116, 109, // C-3 to B-3 Finetune +5
	820, 774, 730, 689, 651, 614, 580, 547, 516, 487, 460, 434, // C-1 to B-1 Finetune +6
	410, 387, 365, 345, 325, 307, 290, 274, 258, 244, 230, 217, // C-2 to B-2 Finetune +6
	205, 193, 183, 172, 163, 154, 145, 137, 129, 122, 115, 109, // C-3 to B-3 Finetune +6
	814, 768, 725, 684, 646, 610, 575, 543, 513, 484, 457, 431, // C-1 to B-1 Finetune +7
	407, 384, 363, 342, 323, 305, 288, 272, 256, 242, 228, 216, // C-2 to B-2 Finetune +7
	204, 192, 181, 171, 161, 152, 144, 136, 128, 121, 114, 108, // C-3 to B-3 Finetune +7
	907, 856, 808, 762, 720, 678, 640, 604, 570, 538, 504, 480, // C-1 to B-1 Finetune -8
	453, 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, // C-2 to B-2 Finetune -8
	226, 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, // C-3 to B-3 Finetune -8
	900, 850, 802, 757, 715, 675, 636, 601, 567, 535, 505, 477, // C-1 to B-1 Finetune -7
	450, 425, 401, 379, 357, 337, 318, 300, 284, 268, 253, 238, // C-2 to B-2 Finetune -7
	225, 212, 200, 189, 179, 169, 159, 150, 142, 134, 126, 119, // C-3 to B-3 Finetune -7
	894, 844, 796, 752, 709, 670, 632, 597, 563, 532, 502, 474, // C-1 to B-1 Finetune -6
	447, 422, 398, 376, 355, 335, 316, 298, 282, 266, 251, 237, // C-2 to B-2 Finetune -6
	223, 211, 199, 188, 177, 167, 158, 149, 141, 133, 125, 118, // C-3 to B-3 Finetune -6
	887, 838, 791, 746, 704, 665, 628, 592, 559, 528, 498, 470, // C-1 to B-1 Finetune -5
	444, 419, 395, 373, 352, 332, 314, 296, 280, 264, 249, 235, // C-2 to B-2 Finetune -5
	222, 209, 198, 187, 176, 166, 157, 148, 140, 132, 125, 118, // C-3 to B-3 Finetune -5
	881, 832, 785, 741, 699, 660, 623, 588, 555, 524, 494, 467, // C-1 to B-1 Finetune -4
	441, 416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233, // C-2 to B-2 Finetune -4
	220, 208, 196, 185, 175, 165, 156, 147, 139, 131, 123, 117, // C-3 to B-3 Finetune -4
	875, 826, 779, 736, 694, 655, 619, 584, 551, 520, 491, 463, // C-1 to B-1 Finetune -3
	437, 413, 390, 368, 347, 338, 309, 292, 276, 260, 245, 232, // C-2 to B-2 Finetune -3
	219, 206, 195, 184, 174, 164, 155, 146, 138, 130, 123, 116, // C-3 to B-3 Finetune -3
	868, 820, 774, 730, 689, 651, 614, 580, 547, 516, 487, 460, // C-1 to B-1 Finetune -2
	434, 410, 387, 365, 345, 325, 307, 290, 274, 258, 244, 230, // C-2 to B-2 Finetune -2
	217, 205, 193, 183, 172, 163, 154, 145, 137, 129, 122, 115, // C-3 to B-3 Finetune -2
	862, 814, 768, 725, 684, 646, 610, 575, 543, 513, 484, 457, // C-1 to B-1 Finetune -1
	431, 407, 384, 363, 342, 323, 305, 288, 272, 256, 242, 228, // C-2 to B-2 Finetune -1
	216, 203, 192, 181, 171, 161, 152, 144, 136, 128, 121, 114  // C-3 to B-3 Finetune -1
};

const char *ModPlayer::_names[] = {
	"intro",       "introb",
	"options",     "options2",
	"journal",     "options1",
	"ceinture",    "ceinturea",
	"desinteg",    "desintegr",
	"reunion",     0,
	"voyage",      0,
	"level4",      "teleporta",
	"planetexplo", "teleport2",
	"fin",         0,
	"ascenseur",   0,
	"logo",        0,
	"game_over",   0,
	"holocube",    0,
	"memoire",     0,
	"chute",       0,
	"debut",       "jungle",
	"missions",    "missionca",
	"taxi",        0,
	"donneobj",    "donneobjt",
	"missions2",   "fin2",
};

const int ModPlayer::_namesCount = ARRAYSIZE(_names);

const char *SeqPlayer::_namesTable[] = {
	/* 0x00 */
	"WAKEUP", // 'DEBUT' (0x0000) num 0
	"TKHOLOCB", // 'OBJET' (0x0001) num 3
	"TAKEKEY0", // 'OBJET' (0x0001) num 4
	0,
	/* 0x04 */
	"TKGUN", // 'OBJET' (0x0001) num 2
	"RECHARG0", // 'GEN' (0x0003) num 0
	"FALLJUNG", // 'CHUTE' (0x0004) num 0
	0,
	/* 0x08 */
	0,
	"DISINTEG", // 'DESINTEG' (0x0006) num 0
	"TKCRED0", // 'OBJET' (0x0001) num 1
	0,
	/* 0x0C */
	0,
	"INTRO", // 'INTRO1' (0x8007) num 0
	"RCHGBATT", // 'GEN' (0x0003) num 1
	"TAKEBATT", // 'OBJET' (0x0001) num 11
	/* 0x10 */
	"TKTELER0", // 'OBJET' (0x0001) num 5
	"HOLOCUBE", // 'HOLOSEQ' (0x0009) num 0
	"TKCARD", // 'OBJET' (0x0001) num 6
	0,
	/* 0x14 */
	"BRIDGE", // 'PONT' (0x000B) num 0
	"GVTELER", // 'OBJET' (0x0001) num 10
	0,
	0,
	/* 0x18 */
	0,
	"HOLOMAP", // 'MAP' (0x000D) num 4
	"MAP1", // 'MAP' (0x000D) num 0
	"MAP2", // 'MAP' (0x000D) num 1
	/* 0x1C */
	"MAP3", // 'MAP' (0x000D) num 2
	"MAP4", // 'MAP' (0x000D) num 3
	0,
	0,
	/* 0x20 */
	"GIVEPACK", // 'OBJET' (0x0001) num 12
	"GIVEPACK", // 'OBJET' (0x0001) num 13
	"GETWORKP", // 'OBJET' (0x0001) num 14
	"GETID", // 'OBJET' (0x0001) num 15
	/* 0x24 */
	"TKFUSE", // 'OBJET' (0x0001) num 16
	"MISSION1", // 'MISSIONS' (0x000F) num 0
	"MISSION2", // 'MISSIONS' (0x000F) num 1
	"MISSION2", // 'MISSIONS' (0x000F) num 1
	/* 0x28 */
	"MISSION3", // 'MISSIONS' (0x000F) num 3
	"MISSION4", // 'MISSIONS' (0x000F) num 2
	"MISSION5", // 'MISSIONS' (0x000F) num 4
	"GIVEID1", // 'OBJET' (0x0001) num 8
	/* 0x2C */
	"GVCREDS1", // 'OBJET' (0x0001) num 7
	"MISSVALD", // 'MISSIONS' (0x000F) num 5
	0,
	"ANTIG", // 'CHUTE' (0x0004) num 1
	/* 0x30 */
	"MEMORY", // 'MEMO' (0x0011) num 0
	"GETANTIG", // 'OBJET' (0x0001) num 9
	"TAXI", // 'TAXI' (0x0012) num 0
	0,
	/* 0x34 */
	"VOYAGE", // 'VOYAGE' (0x0014) num 0
	"TELEPORT", // 'TELEPORT' (0x0015) num 0
	"LIFTUP", // 'LIFT' (0x0016) num 0
	"LIFTDOWN", // 'LIFT' (0x0016) num 1
	/* 0x38 */
	0,
	"SPY", // 'ESPIONS' (0x0017) num 0
	"GETDYNAM", // 'OBJET' (0x0001) num 17
	"JOURNAL", // 'LOG' (0x0018) num 0
	/* 0x3C */
	"TKTELEX0", // 'OBJET' (0x0001) num 19
	"END", // 'FIN' (0x0019) num 0
	"GENEXPL", // 'GENEXP' (0x001A) num 0
	"BADEND", // 'FIN' (0x0019) num 1
	/* 0x40 */
	0, // 'LOGOS' (0x001B) num 0
	"GAMEOVER", // 'OVER' (0x001C) num 0
	"MISSEND1", // 'MISSIONS' (0x000F) num 6
	"MISSEND1", // 'MISSIONS' (0x000F) num 6
	/* 0x44 */
	"MISSEND2", // 'MISSIONS' (0x000F) num 7
	"MISSEND3", // 'MISSIONS' (0x000F) num 8
	"MISSEND4", // 'MISSIONS' (0x000F) num 9
	"MISSEND5", // 'MISSIONS' (0x000F) num 10
	/* 0x48 */
	0, // 'SCORE' (0x001D) num 0
	0, // 'LOGOS' (0x001B) num 1
	0, // 'INTRO2' (0x001E) num 0
};

const uint8_t SfxPlayer::_musicData68[] = {
	0x00, 0x1B, 0x00, 0x07, 0x00, 0x0C, 0x00, 0x18, 0xFF, 0xF4, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0A,
	0x02, 0x01, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x0A, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x0D, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x14, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x16, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x0F
};

const uint8_t SfxPlayer::_musicData70[] = {
	0x00, 0x12, 0x00, 0x07, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0A, 0x02, 0x01, 0x00, 0x00, 0x01, 0x0D,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0A, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x03, 0x16, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00
};

const uint8_t SfxPlayer::_musicData72[] = {
	0x00, 0x4F, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x24, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x05, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x05,
	0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1B,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0D, 0x00, 0x00,
	0x04, 0x1D, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0F, 0x02, 0x01, 0x04, 0x1D, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x11, 0x02, 0x01, 0x04, 0x1B,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x10, 0x02, 0x01, 0x04, 0x1B, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1D, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1B,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x10, 0x03, 0x01,
	0x04, 0x1D, 0x01, 0x0F, 0x03, 0x01, 0x04, 0x1B, 0x01, 0x0D, 0x02, 0x01, 0x04, 0x1D, 0x01, 0x0F,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x0D, 0x02, 0x01, 0x04, 0x1D, 0x01, 0x0A, 0x03, 0x01, 0x04, 0x1B,
	0x01, 0x08, 0x03, 0x01, 0x04, 0x1D, 0x01, 0x08, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00,
	0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x00, 0x00,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x02, 0x01,
	0x04, 0x1D, 0x00, 0x00, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x0D, 0x00, 0x00, 0x04, 0x1B,
	0x01, 0x0F, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00,
	0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x00, 0x00,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x02, 0x01,
	0x04, 0x1D, 0x00, 0x00, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x03, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x05, 0x00, 0x00, 0x04, 0x1B,
	0x01, 0x08, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00,
	0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x00, 0x00,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x02, 0x01,
	0x04, 0x1D, 0x00, 0x00, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x03, 0x01, 0x04, 0x1D, 0x01, 0x0D, 0x03, 0x01, 0x04, 0x1B,
	0x01, 0x0F, 0x03, 0x01, 0x04, 0x1D, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x1B
};

const uint8_t SfxPlayer::_musicData73[] = {
	0x00, 0x41, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x0C, 0xFF, 0xF4, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x12, 0x00, 0x00, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x05, 0x00, 0x00,
	0x04, 0x11, 0x01, 0x08, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x12, 0x00, 0x00, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x05, 0x00, 0x00,
	0x04, 0x11, 0x01, 0x08, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x12, 0x00, 0x00, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x0D, 0x00, 0x00,
	0x04, 0x11, 0x00, 0x00, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0F, 0x02, 0x01, 0x04, 0x11, 0x01, 0x0C,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0D, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x05, 0x02, 0x01, 0x04, 0x12, 0x01, 0x08, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x0D, 0x00, 0x00,
	0x04, 0x11, 0x01, 0x08, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x12, 0x00, 0x00, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x05, 0x00, 0x00,
	0x04, 0x11, 0x01, 0x08, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x12, 0x00, 0x00, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x05, 0x00, 0x00,
	0x04, 0x11, 0x01, 0x08, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x12, 0x00, 0x00, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x0D, 0x00, 0x00,
	0x04, 0x11, 0x00, 0x00, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0F, 0x02, 0x01, 0x04, 0x11, 0x01, 0x0C,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0D, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x05, 0x02, 0x01, 0x04, 0x12, 0x01, 0x08, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x0D, 0x03, 0x01,
	0x04, 0x11, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A
};

const uint8_t SfxPlayer::_musicData74[] = {
	0x00, 0x41, 0x00, 0x07, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x24, 0x00, 0x0C, 0x00, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x0B, 0x02, 0x01, 0x00, 0x00,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0B, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x08, 0x01, 0x08,
	0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x08,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27,
	0x04, 0x08, 0x01, 0x06, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08,
	0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x0B, 0x02, 0x01, 0x00, 0x00,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00, 0x01, 0x0B, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x08, 0x01, 0x08,
	0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x08,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27,
	0x04, 0x08, 0x01, 0x06, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08,
	0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x0B, 0x02, 0x01, 0x00, 0x00,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00, 0x01, 0x0B, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x08, 0x01, 0x08,
	0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x08,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27,
	0x04, 0x08, 0x01, 0x06, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08,
	0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x0B, 0x03, 0x01, 0x00, 0x00, 0x01, 0x0D, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00
};

const uint8_t SfxPlayer::_musicData75[] = {
	0x00, 0x41, 0x00, 0x05, 0x00, 0x0C, 0x00, 0x24, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x04, 0x12,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x12, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x04, 0x12,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x04, 0x12, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x06, 0x03, 0x01, 0x04, 0x11,
	0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x05, 0x27, 0x04, 0x12, 0x01, 0x06, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x04, 0x12,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x12, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x04, 0x12,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x06, 0x03, 0x01, 0x00, 0x00,
	0x01, 0x06, 0x03, 0x01, 0x00, 0x00, 0x01, 0x05, 0x03, 0x01, 0x00, 0x00, 0x01, 0x06, 0x03, 0x01,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00
};

const uint8_t SfxPlayer::_musicDataSample1[] = {
	0x08, 0x2C, 0x00, 0x40, 0x07, 0x2A, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04,
	0x03, 0x05, 0x07, 0x08, 0x08, 0x0B, 0x0E, 0x0F, 0x11, 0x14, 0x14, 0x16, 0x18, 0x1C, 0x20, 0x1E,
	0x1A, 0x1A, 0x1F, 0x22, 0x1F, 0x19, 0x16, 0x27, 0x1C, 0xC8, 0x0F, 0x7F, 0x30, 0xA0, 0x97, 0x0F,
	0x73, 0x50, 0xC4, 0x96, 0xE7, 0x15, 0xFC, 0xFD, 0x12, 0x0C, 0xE6, 0xEF, 0x0F, 0xF8, 0xE3, 0xFF,
	0x47, 0x4E, 0x08, 0xD2, 0xEA, 0x27, 0x3B, 0x22, 0x09, 0x03, 0xFF, 0xF2, 0xF3, 0x03, 0x00, 0xEA,
	0xDE, 0xD4, 0xC7, 0xC2, 0xBC, 0xB4, 0xB6, 0xB8, 0xA8, 0x96, 0x95, 0x99, 0x9C, 0x9F, 0xA0, 0xA0,
	0xA3, 0xA4, 0xA4, 0xB3, 0xCB, 0xD7, 0xDB, 0xDF, 0xEA, 0xFD, 0x0F, 0x1C, 0x26, 0x37, 0x4B, 0x57,
	0x5F, 0x6A, 0x73, 0x78, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x78, 0x6C, 0x64, 0x5E, 0x58, 0x4B, 0x40, 0x3A, 0x2E, 0x1E, 0x16, 0x11, 0x0B, 0x06, 0xFE,
	0xF3, 0xE9, 0xE2, 0xDD, 0xDE, 0xE3, 0xE0, 0xD7, 0xCE, 0xCC, 0xCE, 0xD3, 0xD4, 0xCF, 0xCB, 0xCF,
	0xD2, 0xCF, 0xCD, 0xCF, 0xD1, 0xD6, 0xD9, 0xD3, 0xCD, 0xD3, 0xDE, 0xDF, 0xDA, 0xD8, 0xD9, 0xDF,
	0xE5, 0xE4, 0xDE, 0xDF, 0xE4, 0xEA, 0xED, 0xEE, 0xF2, 0xF4, 0xF7, 0xF5, 0xF5, 0xFE, 0x0B, 0x0C,
	0x0B, 0x0F, 0x13, 0x13, 0x11, 0x13, 0x1B, 0x26, 0x23, 0x1B, 0x1D, 0x1C, 0x1E, 0x20, 0x1E, 0x1F,
	0x1E, 0x15, 0x17, 0x20, 0x10, 0x07, 0x15, 0x14, 0x0B, 0x0B, 0x08, 0x04, 0x07, 0x04, 0xFA, 0xFB,
	0xFE, 0xFB, 0xFB, 0xFB, 0xF6, 0xF1, 0xF4, 0xF9, 0xFC, 0x00, 0x01, 0xFE, 0xF8, 0xF7, 0xFB, 0x03,
	0x0C, 0x11, 0x0F, 0x08, 0xFE, 0xFE, 0x0B, 0x1B, 0x1E, 0x11, 0x04, 0x04, 0x09, 0x0C, 0x0D, 0x08,
	0x08, 0x0C, 0x09, 0x00, 0xF4, 0xF2, 0xFB, 0x03, 0x02, 0xFA, 0xF6, 0xF5, 0xF4, 0xF6, 0xF9, 0xFA,
	0xF9, 0xFD, 0x01, 0x02, 0x01, 0xFE, 0x01, 0x0C, 0x10, 0x0D, 0x0A, 0x08, 0x0B, 0x14, 0x19, 0x1A,
	0x1B, 0x19, 0x15, 0x17, 0x18, 0x15, 0x17, 0x1E, 0x1C, 0x16, 0x11, 0x11, 0x14, 0x19, 0x19, 0x17,
	0x15, 0x13, 0x15, 0x1A, 0x1C, 0x1E, 0x23, 0x28, 0x28, 0x24, 0x23, 0x28, 0x2D, 0x2F, 0x2E, 0x2E,
	0x2C, 0x28, 0x24, 0x20, 0x1C, 0x16, 0x0B, 0x02, 0xFF, 0xF9, 0xEB, 0xE0, 0xD6, 0xCC, 0xC3, 0xBA,
	0xB0, 0xA6, 0xA0, 0x99, 0x92, 0x8C, 0x88, 0x88, 0x88, 0x85, 0x83, 0x85, 0x89, 0x8C, 0x91, 0x9A,
	0xA2, 0xAB, 0xB2, 0xBB, 0xC7, 0xD6, 0xE3, 0xF1, 0xFF, 0x0C, 0x17, 0x23, 0x2D, 0x39, 0x45, 0x50,
	0x5A, 0x63, 0x67, 0x6A, 0x6E, 0x72, 0x76, 0x7A, 0x7A, 0x76, 0x73, 0x72, 0x6E, 0x6B, 0x6A, 0x66,
	0x61, 0x5D, 0x53, 0x4B, 0x48, 0x45, 0x40, 0x3C, 0x3A, 0x33, 0x2D, 0x2A, 0x24, 0x20, 0x20, 0x20,
	0x1C, 0x1B, 0x1A, 0x16, 0x13, 0x12, 0x11, 0x12, 0x12, 0x10, 0x0D, 0x0B, 0x0B, 0x09, 0x07, 0x07,
	0x06, 0x05, 0x04, 0x02, 0x01, 0xFE, 0xFC, 0xFC, 0xFF, 0x00, 0xFE, 0xFB, 0xFA, 0xFA, 0xFC, 0xFD,
	0xFC, 0xFD, 0x01, 0x02, 0x00, 0x00, 0x04, 0x08, 0x0C, 0x0E, 0x0D, 0x10, 0x13, 0x16, 0x19, 0x1B,
	0x1D, 0x1E, 0x21, 0x23, 0x23, 0x23, 0x24, 0x26, 0x28, 0x26, 0x23, 0x21, 0x21, 0x23, 0x23, 0x1F,
	0x1C, 0x1C, 0x1B, 0x1A, 0x18, 0x16, 0x15, 0x14, 0x13, 0x11, 0x0F, 0x0E, 0x0C, 0x0A, 0x08, 0x03,
	0xFD, 0xFA, 0xFA, 0xF9, 0xF6, 0xF3, 0xF1, 0xEF, 0xEF, 0xEF, 0xF0, 0xF3, 0xF4, 0xF2, 0xF4, 0xF9,
	0xFD, 0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x08, 0x05, 0x01, 0xFD, 0xF9, 0xF5, 0xF1,
	0xED, 0xE6, 0xDE, 0xD9, 0xD7, 0xD5, 0xD3, 0xD0, 0xCD, 0xCB, 0xCA, 0xC8, 0xC8, 0xCB, 0xCC, 0xCE,
	0xD1, 0xD4, 0xD4, 0xD6, 0xDD, 0xE4, 0xE9, 0xEB, 0xEC, 0xEF, 0xF6, 0xFC, 0xFD, 0xFB, 0xFB, 0xFC,
	0xFC, 0xFC, 0xF9, 0xF6, 0xF5, 0xF3, 0xEE, 0xEB, 0xE9, 0xE7, 0xE7, 0xE7, 0xE6, 0xE5, 0xE5, 0xE6,
	0xEA, 0xEE, 0xF2, 0xF6, 0xFA, 0xFE, 0x03, 0x0A, 0x10, 0x15, 0x1A, 0x1D, 0x20, 0x23, 0x25, 0x25,
	0x26, 0x26, 0x24, 0x20, 0x1A, 0x15, 0x0F, 0x09, 0x02, 0xF8, 0xEE, 0xE4, 0xD9, 0xCF, 0xC8, 0xC1,
	0xB8, 0xAF, 0xA7, 0xA0, 0x9A, 0x97, 0x94, 0x92, 0x92, 0x92, 0x94, 0x97, 0x99, 0x9D, 0xA5, 0xAD,
	0xB6, 0xBF, 0xC7, 0xD1, 0xDC, 0xE7, 0xF3, 0xFF, 0x0B, 0x16, 0x1F, 0x29, 0x33, 0x3B, 0x44, 0x4D,
	0x55, 0x5A, 0x5E, 0x62, 0x64, 0x66, 0x67, 0x68, 0x68, 0x68, 0x66, 0x63, 0x60, 0x5D, 0x5B, 0x59,
	0x56, 0x52, 0x4F, 0x4B, 0x48, 0x46, 0x44, 0x42, 0x40, 0x3F, 0x3E, 0x3D, 0x3A, 0x39, 0x39, 0x3A,
	0x39, 0x37, 0x36, 0x35, 0x35, 0x35, 0x35, 0x34, 0x32, 0x31, 0x30, 0x2E, 0x2D, 0x2B, 0x2A, 0x29,
	0x27, 0x26, 0x25, 0x24, 0x22, 0x21, 0x20, 0x20, 0x1F, 0x1D, 0x1D, 0x1F, 0x20, 0x1F, 0x1F, 0x1F,
	0x20, 0x23, 0x25, 0x26, 0x26, 0x29, 0x2B, 0x2C, 0x2D, 0x2E, 0x30, 0x32, 0x33, 0x34, 0x34, 0x35,
	0x35, 0x35, 0x36, 0x36, 0x35, 0x34, 0x33, 0x33, 0x32, 0x31, 0x30, 0x2F, 0x2E, 0x2B, 0x29, 0x29,
	0x29, 0x28, 0x27, 0x27, 0x27, 0x26, 0x26, 0x26, 0x28, 0x28, 0x28, 0x27, 0x27, 0x26, 0x24, 0x22,
	0x20, 0x1D, 0x1A, 0x15, 0x0F, 0x0A, 0x05, 0x01, 0xFE, 0xFA, 0xF5, 0xF2, 0xF0, 0xED, 0xEC, 0xEB,
	0xEA, 0xE9, 0xE9, 0xE9, 0xEA, 0xEB, 0xEB, 0xEB, 0xEB, 0xEA, 0xE9, 0xE6, 0xE3, 0xE1, 0xDC, 0xD8,
	0xD4, 0xCE, 0xC8, 0xC3, 0xBF, 0xBA, 0xB6, 0xB1, 0xAE, 0xAB, 0xAA, 0xA8, 0xA7, 0xA6, 0xA6, 0xA7,
	0xA9, 0xAB, 0xAE, 0xAF, 0xB1, 0xB3, 0xB8, 0xBC, 0xC0, 0xC3, 0xC5, 0xC7, 0xCA, 0xCD, 0xCE, 0xCF,
	0xD0, 0xD2, 0xD3, 0xD2, 0xD1, 0xCF, 0xD0, 0xD0, 0xD0, 0xCF, 0xCF, 0xCF, 0xCF, 0xD1, 0xD3, 0xD5,
	0xD8, 0xDB, 0xDF, 0xE3, 0xE7, 0xEB, 0xF0, 0xF6, 0xFB, 0xFF, 0x03, 0x08, 0x0C, 0x0E, 0x11, 0x12,
	0x13, 0x14, 0x13, 0x11, 0x0E, 0x0A, 0x05, 0x00, 0xFA, 0xF4, 0xED, 0xE5, 0xDE, 0xD6, 0xCE, 0xC6,
	0xC0, 0xBA, 0xB4, 0xAF, 0xAA, 0xA7, 0xA5, 0xA4, 0xA4, 0xA4, 0xA6, 0xA9, 0xAE, 0xB3, 0xB8, 0xBF,
	0xC7, 0xCF, 0xD7, 0xDF, 0xE9, 0xF4, 0xFE, 0x08, 0x11, 0x1B, 0x24, 0x2D, 0x35, 0x3D, 0x45, 0x4B,
	0x50, 0x55, 0x58, 0x5B, 0x5E, 0x60, 0x60, 0x60, 0x5F, 0x5E, 0x5D, 0x5B, 0x59, 0x58, 0x57, 0x54,
	0x52, 0x4F, 0x4E, 0x4D, 0x4C, 0x4A, 0x48, 0x47, 0x46, 0x46, 0x46, 0x46, 0x46, 0x45, 0x44, 0x44,
	0x44, 0x45, 0x44, 0x44, 0x43, 0x43, 0x43, 0x43, 0x42, 0x41, 0x41, 0x40, 0x3F, 0x3D, 0x3C, 0x3C,
	0x3B, 0x3A, 0x39, 0x38, 0x36, 0x36, 0x35, 0x34, 0x34, 0x34, 0x33, 0x32, 0x32, 0x33, 0x34, 0x35,
	0x34, 0x34, 0x34, 0x36, 0x36, 0x36, 0x36, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x36, 0x34,
	0x35, 0x34, 0x33, 0x32, 0x32, 0x32, 0x32, 0x31, 0x30, 0x30, 0x30, 0x2F, 0x2F, 0x30, 0x30, 0x30,
	0x31, 0x31, 0x32, 0x32, 0x33, 0x34, 0x35, 0x36, 0x36, 0x36, 0x37, 0x38, 0x38, 0x38, 0x37, 0x35,
	0x32, 0x2F, 0x2D, 0x29, 0x24, 0x20, 0x1A, 0x14, 0x0E, 0x08, 0x03, 0xFE, 0xF8, 0xF3, 0xEE, 0xEA,
	0xE6, 0xE2, 0xE0, 0xDE, 0xDB, 0xD9, 0xD8, 0xD6, 0xD5, 0xD3, 0xD1, 0xD0, 0xCD, 0xCA, 0xC7, 0xC4,
	0xC1, 0xBD, 0xBA, 0xB6, 0xB3, 0xB0, 0xAC, 0xA9, 0xA7, 0xA5, 0xA3, 0xA1, 0xA0, 0xA0, 0xA0, 0xA0,
	0xA1, 0xA1, 0xA2, 0xA2, 0xA4, 0xA6, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAC, 0xAD, 0xAE,
	0xAF, 0xB0, 0xB1, 0xB2, 0xB3, 0xB5, 0xB7, 0xB9, 0xBB, 0xBE, 0xC0, 0xC4, 0xC8, 0xCC, 0xD1, 0xD5,
	0xDA, 0xDF, 0xE5, 0xEA, 0xEF, 0xF5, 0xFA, 0xFF, 0x04, 0x08, 0x0B, 0x0D, 0x10, 0x12, 0x12, 0x11,
	0x10, 0x0E, 0x0B, 0x08, 0x03, 0xFE, 0xF8, 0xF1, 0xEB, 0xE4, 0xDD, 0xD6, 0xD0, 0xC9, 0xC3, 0xBD,
	0xB8, 0xB4, 0xB1, 0xAE, 0xAC, 0xAB, 0xAA, 0xAB, 0xAD, 0xB0, 0xB3, 0xB8, 0xBD, 0xC3, 0xCA, 0xD2,
	0xD9, 0xE1, 0xE9, 0xF2, 0xFA, 0x02, 0x0B, 0x13, 0x1C, 0x23, 0x2A, 0x31, 0x36, 0x3B, 0x40, 0x45,
	0x48, 0x4B, 0x4D, 0x4F, 0x50, 0x50, 0x50, 0x50, 0x50, 0x4F, 0x4E, 0x4C, 0x4C, 0x4B, 0x4B, 0x4A,
	0x49, 0x49, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x49, 0x48, 0x49, 0x49, 0x4A, 0x4B, 0x4B, 0x4B,
	0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4A, 0x4A, 0x49, 0x48, 0x47, 0x46, 0x44, 0x44, 0x43, 0x41,
	0x40, 0x3F, 0x3E, 0x3D, 0x3C, 0x3B, 0x3B, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x39, 0x3A, 0x3B, 0x3C,
	0x3C, 0x3C, 0x3C, 0x3D, 0x3E, 0x3E, 0x3E, 0x3F, 0x3F, 0x3E, 0x3E, 0x3E, 0x3E, 0x3D, 0x3D, 0x3C,
	0x3B, 0x39, 0x38, 0x38, 0x37, 0x36, 0x34, 0x33, 0x32, 0x32, 0x31, 0x30, 0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x31, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3A, 0x3B,
	0x3A, 0x3A, 0x38, 0x37, 0x34, 0x31, 0x2E, 0x2B, 0x27, 0x22, 0x1D, 0x18, 0x13, 0x0D, 0x08, 0x01,
	0xFC, 0xF7, 0xF2, 0xED, 0xE9, 0xE4, 0xE0, 0xDC, 0xD8, 0xD4, 0xD0, 0xCB, 0xC7, 0xC3, 0xBF, 0xBA,
	0xB6, 0xB2, 0xAF, 0xAB, 0xA8, 0xA5, 0xA3, 0xA0, 0x9F, 0x9E, 0x9D, 0x9D, 0x9D, 0x9C, 0x9D, 0x9D,
	0x9E, 0x9E, 0x9F, 0x9F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA1, 0xA1, 0xA1, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2,
	0xA3, 0xA5, 0xA5, 0xA7, 0xA8, 0xAB, 0xAD, 0xB0, 0xB2, 0xB6, 0xBA, 0xBF, 0xC3, 0xC8, 0xCE, 0xD3,
	0xD9, 0xDF, 0xE5, 0xEB, 0xF1, 0xF6, 0xFB, 0x00, 0x04, 0x08, 0x0B, 0x0D, 0x0E, 0x0E, 0x0E, 0x0C,
	0x0A, 0x08, 0x04, 0x00, 0xFA, 0xF5, 0xEF, 0xE8, 0xE2, 0xDC, 0xD6, 0xCF, 0xC9, 0xC3, 0xBE, 0xBA,
	0xB6, 0xB3, 0xB0, 0xAE, 0xAD, 0xAE, 0xAF, 0xB0, 0xB3, 0xB7, 0xBB, 0xBF, 0xC5, 0xCB, 0xD2, 0xD9,
	0xE1, 0xE8, 0xF0, 0xF9, 0x01, 0x09, 0x11, 0x18, 0x1F, 0x26, 0x2D, 0x32, 0x37, 0x3C, 0x40, 0x43,
	0x46, 0x48, 0x49, 0x4A, 0x4B, 0x4B, 0x4B, 0x4A, 0x4A, 0x49, 0x48, 0x47, 0x47, 0x46, 0x46, 0x45,
	0x45, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x45, 0x45, 0x46, 0x47, 0x47, 0x47, 0x48, 0x49,
	0x49, 0x49, 0x49, 0x4A, 0x49, 0x49, 0x49, 0x48, 0x48, 0x47, 0x46, 0x45, 0x45, 0x44, 0x43, 0x42,
	0x41, 0x41, 0x40, 0x40, 0x3F, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3F, 0x3F, 0x3F, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x3F, 0x3F, 0x3E, 0x3E, 0x3D, 0x3C, 0x3B, 0x3A, 0x39,
	0x38, 0x37, 0x36, 0x35, 0x34, 0x33, 0x32, 0x31, 0x31, 0x30, 0x30, 0x30, 0x2F, 0x2F, 0x30, 0x30,
	0x30, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x3A, 0x3B, 0x3D, 0x3D, 0x3E, 0x3F,
	0x3F, 0x3F, 0x3E, 0x3E, 0x3C, 0x3B, 0x38, 0x36, 0x33, 0x30, 0x2B, 0x27, 0x22, 0x1E, 0x19, 0x14,
	0x0E, 0x09, 0x04, 0xFE, 0xF8, 0xF3, 0xED, 0xE8, 0xE2, 0xDC, 0xD6, 0xD1, 0xCB, 0xC6, 0xC0, 0xBC,
	0xB7, 0xB2, 0xAE, 0xAB, 0xA8, 0xA5, 0xA2, 0xA0, 0x9F, 0x9E, 0x9C, 0x9B, 0x9B, 0x9A, 0x9A, 0x99,
	0x99, 0x99, 0x98, 0x98, 0x97, 0x97, 0x96, 0x95, 0x95, 0x95, 0x94, 0x94, 0x94, 0x94, 0x94, 0x95,
	0x96, 0x97, 0x99, 0x9B, 0x9E, 0xA0, 0xA4, 0xA8, 0xAD, 0xB2, 0xB7, 0xBD, 0xC3, 0xCA, 0xD1, 0xD7,
	0xDF, 0xE5, 0xEC, 0xF3, 0xF9, 0xFF, 0x04, 0x09, 0x0C, 0x0F, 0x11, 0x12, 0x12, 0x11, 0x10, 0x0D,
	0x09, 0x05, 0x00, 0xFB, 0xF5, 0xEF, 0xE9, 0xE2, 0xDC, 0xD6, 0xD0, 0xC9, 0xC4, 0xBF, 0xBB, 0xB7,
	0xB4, 0xB1, 0xB0, 0xAF, 0xAF, 0xAF, 0xB1, 0xB4, 0xB7, 0xBB, 0xBF, 0xC5, 0xCA, 0xD1, 0xD7, 0xDE,
	0xE5, 0xED, 0xF4, 0xFC, 0x03, 0x0B, 0x12, 0x19, 0x1F, 0x24, 0x29, 0x2E, 0x33, 0x36, 0x39, 0x3C,
	0x3E, 0x40, 0x41, 0x42, 0x42, 0x43, 0x43, 0x43, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x41, 0x41,
	0x41, 0x41, 0x41, 0x42, 0x42, 0x43, 0x43, 0x44, 0x44, 0x44, 0x45, 0x46, 0x47, 0x47, 0x47, 0x48,
	0x48, 0x48, 0x48, 0x48, 0x48, 0x47, 0x47, 0x46, 0x46, 0x45, 0x44, 0x43, 0x43, 0x42, 0x41, 0x40,
	0x40, 0x3F, 0x3F, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3F, 0x3F, 0x3F, 0x3F, 0x40, 0x40, 0x41, 0x41,
	0x41, 0x41, 0x41, 0x41, 0x41, 0x40, 0x40, 0x40, 0x3F, 0x3E, 0x3D, 0x3C, 0x3B, 0x3A, 0x39, 0x38,
	0x37, 0x35, 0x34, 0x33, 0x32, 0x31, 0x30, 0x30, 0x2F, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
	0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x35, 0x36, 0x37, 0x39, 0x3A, 0x3C, 0x3D, 0x3E, 0x3F, 0x40,
	0x41, 0x42, 0x42, 0x42, 0x41, 0x40, 0x3F, 0x3E, 0x3C, 0x39, 0x37, 0x34, 0x31, 0x2D, 0x29, 0x24,
	0x20, 0x1B, 0x16, 0x10, 0x0A, 0x05, 0xFE, 0xF8, 0xF2, 0xEC, 0xE6, 0xE0, 0xDA, 0xD4, 0xCE, 0xC9,
	0xC4, 0xBF, 0xBB, 0xB7, 0xB3, 0xB0, 0xAD, 0xAA, 0xA8, 0xA6, 0xA4, 0xA2, 0xA0, 0x9F, 0x9D, 0x9B,
	0x9A, 0x98, 0x96, 0x95, 0x93, 0x91, 0x8F, 0x8E, 0x8C, 0x8B, 0x89, 0x88, 0x88, 0x87, 0x87, 0x87,
	0x88, 0x89, 0x8A, 0x8C, 0x8F, 0x92, 0x96, 0x9B, 0xA0, 0xA6, 0xAC, 0xB3, 0xB9, 0xC1, 0xC8, 0xD0,
	0xD8, 0xDF, 0xE7, 0xEE, 0xF5, 0xFB, 0xFF, 0x04, 0x08, 0x0B, 0x0D, 0x0E, 0x0E, 0x0E, 0x0C, 0x09,
	0x06, 0x03, 0xFE, 0xFA, 0xF4, 0xEF, 0xE9, 0xE3, 0xDD, 0xD8, 0xD2, 0xCD, 0xC8, 0xC4, 0xC0, 0xBC,
	0xBA, 0xB8, 0xB7, 0xB6, 0xB6, 0xB7, 0xB9, 0xBC, 0xBF, 0xC2, 0xC7, 0xCB, 0xD0, 0xD6, 0xDC, 0xE2,
	0xE8, 0xEF, 0xF5, 0xFB, 0x01, 0x07, 0x0D, 0x12, 0x17, 0x1B, 0x1F, 0x23, 0x27, 0x29, 0x2C, 0x2E,
	0x30, 0x32, 0x33, 0x34, 0x35, 0x36, 0x36, 0x37, 0x38, 0x38, 0x39, 0x39, 0x3A, 0x3B, 0x3B, 0x3C,
	0x3C, 0x3D, 0x3E, 0x3F, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x47, 0x48, 0x48, 0x49,
	0x49, 0x49, 0x49, 0x49, 0x48, 0x48, 0x47, 0x46, 0x46, 0x45, 0x44, 0x44, 0x43, 0x42, 0x42, 0x41,
	0x41, 0x41, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x41, 0x41, 0x40, 0x40, 0x3F, 0x3E, 0x3E, 0x3D, 0x3B, 0x3A, 0x39, 0x38, 0x37, 0x36,
	0x35, 0x34, 0x33, 0x32, 0x31, 0x30, 0x2F, 0x2E, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2E, 0x2F,
	0x2F, 0x30, 0x31, 0x33, 0x34, 0x35, 0x36, 0x38, 0x39, 0x3B, 0x3C, 0x3D, 0x3F, 0x40, 0x41, 0x42,
	0x43, 0x44, 0x45, 0x45, 0x45, 0x45, 0x44, 0x43, 0x42, 0x40, 0x3E, 0x3C, 0x39, 0x36, 0x32, 0x2E,
	0x2A, 0x26, 0x21, 0x1C, 0x16, 0x10, 0x0A, 0x04, 0xFE, 0xF8, 0xF2, 0xEC, 0xE6, 0xE0, 0xDB, 0xD6,
	0xD1, 0xCC, 0xC8, 0xC4, 0xC0, 0xBD, 0xB9, 0xB6, 0xB3, 0xB1, 0xAE, 0xAB, 0xA8, 0xA5, 0xA3, 0xA0,
	0x9D, 0x9A, 0x98, 0x95, 0x92, 0x8F, 0x8D, 0x8A, 0x88, 0x86, 0x84, 0x83, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x83, 0x84, 0x86
};

const uint8_t SfxPlayer::_musicDataSample2[] = {
	0x0D, 0x90, 0x00, 0x40, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x22, 0x1E, 0x18, 0x14, 0x10, 0x10,
	0x12, 0x16, 0x18, 0x1E, 0x22, 0x22, 0x1E, 0x20, 0x24, 0x22, 0x28, 0x38, 0x30, 0x36, 0x38, 0x2A,
	0x38, 0x32, 0x48, 0x30, 0x36, 0x58, 0x2E, 0x78, 0x24, 0x1A, 0x60, 0x1A, 0x78, 0xF6, 0x7F, 0x80,
	0x7F, 0x00, 0xFE, 0x7F, 0xB8, 0x7E, 0xE8, 0x0A, 0x7C, 0x28, 0x80, 0x9A, 0x7F, 0x6C, 0x60, 0xE4,
	0x5E, 0x6C, 0x7F, 0x7F, 0x76, 0x7F, 0x7C, 0x7F, 0x7F, 0x42, 0x7E, 0x48, 0x9E, 0x7F, 0xE8, 0x6C,
	0x08, 0x1A, 0x7F, 0x20, 0xEC, 0xFE, 0x7F, 0x32, 0x1C, 0xD8, 0x3E, 0x18, 0xCA, 0x48, 0xE0, 0xD8,
	0x4C, 0x24, 0xDC, 0x80, 0x80, 0x02, 0xA0, 0xCA, 0xD8, 0x94, 0xF2, 0xE6, 0x80, 0xAE, 0xA0, 0x80,
	0xCA, 0xA2, 0x82, 0x88, 0xAE, 0x80, 0x80, 0xB8, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x8E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x96, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x90, 0x80, 0x8E, 0x9A, 0x84, 0xD6, 0xB8, 0x82, 0x98, 0x80, 0x96, 0x90, 0xFE, 0x18,
	0xE4, 0xFE, 0x50, 0x90, 0xBE, 0x4C, 0x00, 0xE8, 0xFE, 0x18, 0xDA, 0x7F, 0x60, 0x46, 0x60, 0x3C,
	0x50, 0x34, 0x7F, 0x7A, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x70, 0x54,
	0x58, 0x60, 0x3C, 0x3A, 0x40, 0x1C, 0x12, 0x08, 0x00, 0xE4, 0xCC, 0xCA, 0xC0, 0xE2, 0xD6, 0xBA,
	0x96, 0x80, 0x9A, 0x82, 0x80, 0x9C, 0x8E, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82,
	0x88, 0x90, 0x8E, 0x92, 0x9E, 0xAE, 0xD8, 0xE0, 0xC2, 0xB0, 0xA8, 0xBA, 0xD8, 0xFC, 0x10, 0x02,
	0xF0, 0xEA, 0x0C, 0x3A, 0x48, 0x34, 0x24, 0x16, 0x1E, 0x3E, 0x6C, 0x7F, 0x7F, 0x62, 0x46, 0x3C,
	0x54, 0x76, 0x7E, 0x74, 0x7A, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7A, 0x78, 0x72, 0x66, 0x6E, 0x6E, 0x6C, 0x70, 0x72, 0x66, 0x60,
	0x60, 0x58, 0x52, 0x5C, 0x54, 0x54, 0x50, 0x4A, 0x48, 0x4A, 0x40, 0x42, 0x3A, 0x2A, 0x2E, 0x30,
	0x34, 0x34, 0x28, 0x22, 0x1E, 0x1A, 0x18, 0x16, 0x14, 0x0E, 0x06, 0x0A, 0x0E, 0x0A, 0x00, 0xF4,
	0xF6, 0xF0, 0xF8, 0xF8, 0xF0, 0xE8, 0xD8, 0xD0, 0xCE, 0xD0, 0xD0, 0xCE, 0xCE, 0xCC, 0xCE, 0xC2,
	0xB2, 0xB0, 0xB4, 0xBA, 0xB4, 0xAE, 0xAE, 0xA8, 0xA6, 0xA8, 0x9A, 0x98, 0x94, 0x8E, 0x8E, 0x8E,
	0x8E, 0x88, 0x8C, 0x8A, 0x84, 0x86, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x84, 0x8E, 0x9A, 0x92, 0x90, 0x90, 0x9A, 0x98, 0x9E, 0xB6, 0xBA, 0xC0, 0xC0, 0xA8, 0xB0, 0xC0,
	0xCC, 0xE2, 0xE4, 0xD8, 0xDC, 0xD4, 0xE2, 0xF2, 0xF0, 0x00, 0x06, 0x02, 0x00, 0x06, 0x06, 0x0E,
	0x14, 0x16, 0x22, 0x30, 0x2A, 0x22, 0x28, 0x34, 0x3A, 0x4A, 0x4E, 0x52, 0x54, 0x4A, 0x56, 0x54,
	0x52, 0x5E, 0x5E, 0x64, 0x68, 0x6E, 0x78, 0x7F, 0x7A, 0x7C, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C, 0x78, 0x76,
	0x72, 0x6E, 0x6C, 0x68, 0x64, 0x60, 0x5C, 0x58, 0x56, 0x52, 0x50, 0x4C, 0x44, 0x46, 0x3E, 0x38,
	0x38, 0x2E, 0x2A, 0x1C, 0x1E, 0x18, 0x0E, 0x16, 0x02, 0xF0, 0xFA, 0xFC, 0xEC, 0xEC, 0xDC, 0xE2,
	0xD4, 0xDA, 0xCC, 0xC8, 0xCC, 0xBE, 0xC6, 0xC0, 0xBA, 0xBC, 0xB6, 0xB0, 0xA2, 0xA6, 0x9E, 0x94,
	0x96, 0x8C, 0x98, 0x80, 0x92, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x86, 0x8E, 0x8C, 0x8C, 0x94, 0x90,
	0x98, 0xA0, 0xA6, 0xB4, 0xBA, 0xB8, 0xC4, 0xC4, 0xD0, 0xCE, 0xD2, 0xD8, 0xDC, 0xE2, 0xE4, 0xEA,
	0xEA, 0xEC, 0xF6, 0xFE, 0xFE, 0x04, 0x0E, 0x06, 0x0E, 0x1E, 0x1E, 0x24, 0x2A, 0x32, 0x30, 0x3C,
	0x42, 0x3E, 0x46, 0x46, 0x48, 0x4C, 0x54, 0x5C, 0x64, 0x66, 0x6C, 0x6E, 0x72, 0x76, 0x72, 0x76,
	0x7A, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7A, 0x78, 0x78, 0x72, 0x72, 0x68, 0x68,
	0x68, 0x68, 0x64, 0x64, 0x60, 0x5A, 0x5E, 0x58, 0x56, 0x58, 0x58, 0x54, 0x56, 0x52, 0x50, 0x52,
	0x4A, 0x4E, 0x4A, 0x48, 0x4C, 0x46, 0x44, 0x3E, 0x3C, 0x34, 0x36, 0x38, 0x34, 0x36, 0x30, 0x34,
	0x2E, 0x30, 0x2C, 0x26, 0x32, 0x26, 0x26, 0x26, 0x24, 0x26, 0x22, 0x22, 0x1E, 0x20, 0x20, 0x22,
	0x1E, 0x1A, 0x18, 0x18, 0x1C, 0x18, 0x18, 0x1A, 0x10, 0x14, 0x12, 0x10, 0x14, 0x14, 0x18, 0x16,
	0x1A, 0x14, 0x14, 0x12, 0x18, 0x16, 0x0E, 0x16, 0x0C, 0x0C, 0x10, 0x04, 0x10, 0x04, 0x0E, 0x00,
	0x06, 0x0E, 0x06, 0x04, 0x04, 0x06, 0x0A, 0x08, 0xFC, 0x06, 0x0E, 0x0A, 0x0C, 0x04, 0x06, 0x08,
	0x10, 0x0A, 0x06, 0x08, 0x04, 0x04, 0x06, 0x02, 0x06, 0x00, 0xFE, 0x06, 0xFE, 0xFC, 0xFA, 0x02,
	0x02, 0x00, 0xF6, 0xF6, 0x00, 0xF6, 0xF8, 0xF4, 0xFA, 0xF8, 0xF2, 0xF6, 0xF0, 0xEC, 0xF4, 0xF0,
	0xE6, 0xEA, 0xEC, 0xF0, 0xF0, 0xE4, 0xEA, 0xEC, 0xEC, 0xF0, 0xE0, 0xE4, 0xE4, 0xDE, 0xE2, 0xE2,
	0xE4, 0xE0, 0xE4, 0xDE, 0xDA, 0xE6, 0xDA, 0xDC, 0xD6, 0xCE, 0xD8, 0xDA, 0xD4, 0xCE, 0xD8, 0xD4,
	0xD8, 0xDA, 0xD0, 0xD2, 0xD0, 0xCE, 0xCC, 0xD0, 0xD2, 0xCE, 0xD4, 0xCC, 0xCA, 0xCC, 0xC6, 0xC8,
	0xC6, 0xC2, 0xC6, 0xCE, 0xC6, 0xCE, 0xCC, 0xC0, 0xCA, 0xC4, 0xCC, 0xCC, 0xCA, 0xCC, 0xCA, 0xCC,
	0xCA, 0xC6, 0xC6, 0xC6, 0xC6, 0xC0, 0xC2, 0xC6, 0xC0, 0xC8, 0xCC, 0xCC, 0xD0, 0xD0, 0xCC, 0xCC,
	0xCA, 0xCE, 0xD8, 0xD2, 0xDC, 0xDC, 0xD8, 0xDC, 0xD4, 0xD2, 0xD2, 0xD4, 0xD8, 0xDA, 0xE0, 0xDA,
	0xE0, 0xEE, 0xEE, 0xF8, 0xF4, 0xEE, 0xF6, 0xFE, 0xF8, 0xFC, 0x00, 0x02, 0x04, 0x00, 0xFE, 0xFE,
	0x06, 0x08, 0x0E, 0x0C, 0x0C, 0x0E, 0x0E, 0x10, 0x18, 0x12, 0x14, 0x18, 0x20, 0x20, 0x24, 0x2A,
	0x2A, 0x2C, 0x28, 0x26, 0x2A, 0x32, 0x34, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x36, 0x38, 0x42, 0x46,
	0x48, 0x4A, 0x48, 0x4E, 0x50, 0x4C, 0x52, 0x4E, 0x50, 0x58, 0x52, 0x54, 0x54, 0x5A, 0x56, 0x5A,
	0x5A, 0x5C, 0x62, 0x64, 0x62, 0x60, 0x68, 0x64, 0x6A, 0x6C, 0x6E, 0x72, 0x66, 0x6C, 0x68, 0x6C,
	0x72, 0x6E, 0x72, 0x6E, 0x72, 0x78, 0x70, 0x70, 0x72, 0x74, 0x7A, 0x74, 0x74, 0x74, 0x74, 0x76,
	0x7A, 0x7A, 0x7C, 0x7F, 0x78, 0x7C, 0x78, 0x70, 0x78, 0x78, 0x7A, 0x7F, 0x78, 0x7A, 0x7F, 0x78,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C, 0x7E,
	0x7C, 0x7C, 0x7F, 0x7F, 0x7A, 0x7C, 0x70, 0x72, 0x7C, 0x74, 0x70, 0x6E, 0x6E, 0x6E, 0x6E, 0x68,
	0x6E, 0x6A, 0x64, 0x64, 0x5C, 0x5E, 0x5A, 0x56, 0x50, 0x48, 0x48, 0x4E, 0x4A, 0x44, 0x3A, 0x38,
	0x32, 0x2A, 0x36, 0x34, 0x24, 0x26, 0x20, 0x1C, 0x1E, 0x1E, 0x1C, 0x18, 0x12, 0x0C, 0x06, 0xFC,
	0x02, 0xFA, 0xF6, 0xF8, 0xEE, 0xEE, 0xF0, 0xEE, 0xEA, 0xE0, 0xDE, 0xE0, 0xDE, 0xCE, 0xD6, 0xD0,
	0xC8, 0xD2, 0xC4, 0xBA, 0xC8, 0xBA, 0xB8, 0xC0, 0xAC, 0xB0, 0xB0, 0xA8, 0xB4, 0xAA, 0xA8, 0xA8,
	0xA0, 0x9A, 0xA2, 0xA0, 0x9C, 0x9C, 0x9C, 0x98, 0x94, 0x98, 0x8C, 0x92, 0x94, 0x8A, 0x8A, 0x88,
	0x80, 0x86, 0x84, 0x82, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x82, 0x80, 0x86, 0x80,
	0x82, 0x88, 0x82, 0x8E, 0x88, 0x8A, 0x8E, 0x8E, 0x96, 0x92, 0x96, 0x9A, 0x98, 0x9A, 0x9E, 0x9E,
	0xAA, 0xB0, 0xB0, 0xB0, 0xB8, 0xB2, 0xB8, 0xC4, 0xC2, 0xCC, 0xC6, 0xCC, 0xD6, 0xD0, 0xD0, 0xD6,
	0xDE, 0xE2, 0xE4, 0xF0, 0xEE, 0xE4, 0xF4, 0xF4, 0xF6, 0xFE, 0x00, 0x0A, 0x10, 0x10, 0x14, 0x1E,
	0x1A, 0x22, 0x2A, 0x22, 0x32, 0x36, 0x34, 0x3E, 0x3E, 0x3C, 0x40, 0x46, 0x4A, 0x50, 0x50, 0x56,
	0x54, 0x60, 0x6A, 0x6A, 0x6E, 0x6A, 0x6C, 0x76, 0x78, 0x7A, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C, 0x78, 0x74,
	0x76, 0x76, 0x6A, 0x72, 0x62, 0x62, 0x68, 0x5C, 0x58, 0x52, 0x50, 0x44, 0x48, 0x4A, 0x42, 0x48,
	0x3A, 0x32, 0x3E, 0x34, 0x30, 0x38, 0x30, 0x2E, 0x2A, 0x2A, 0x26, 0x1E, 0x1A, 0x16, 0x10, 0x0C,
	0x0C, 0x00, 0xF0, 0xF4, 0xFA, 0xF8, 0xF6, 0xF2, 0xF0, 0xF0, 0xF0, 0xEA, 0xDC, 0xE2, 0xDE, 0xDC,
	0xE0, 0xD2, 0xCA, 0xDA, 0xCC, 0xD2, 0xD6, 0xCA, 0xDC, 0xD0, 0xC8, 0xD6, 0xC6, 0xC6, 0xC0, 0xBC,
	0xB8, 0xBA, 0xBA, 0xC0, 0xC2, 0xB8, 0xB8, 0xB4, 0xB0, 0xB4, 0xB0, 0xB2, 0xAE, 0xAC, 0xB2, 0xB2,
	0xAC, 0xA6, 0xAC, 0xAA, 0xAC, 0xAA, 0xAC, 0xA8, 0xA2, 0xA4, 0xA6, 0x9E, 0xA2, 0xA4, 0xA6, 0xA8,
	0x9E, 0xAC, 0xA4, 0xA6, 0xAC, 0xA4, 0xA8, 0xA6, 0xA2, 0xA0, 0xA2, 0xA4, 0xA0, 0xA0, 0x9C, 0x9C,
	0x98, 0x9C, 0x94, 0x9A, 0x9E, 0x9A, 0x9E, 0xA2, 0xA0, 0x9A, 0x98, 0x9A, 0x94, 0x98, 0x96, 0x8C,
	0x9E, 0x98, 0x9E, 0xA4, 0xA8, 0xA4, 0xA6, 0xA4, 0xA2, 0xAA, 0xA6, 0xAA, 0xAA, 0xA6, 0xAE, 0xB2,
	0xB2, 0xBA, 0xB0, 0xAA, 0xB2, 0xB8, 0xB2, 0xB6, 0xC2, 0xC8, 0xCE, 0xC8, 0xC8, 0xCA, 0xCA, 0xCC,
	0xD4, 0xD2, 0xD4, 0xD6, 0xE6, 0xE8, 0xE6, 0xE8, 0xE0, 0xE6, 0xEC, 0xEE, 0xF8, 0xF6, 0xF2, 0xFA,
	0xFC, 0xF6, 0xFE, 0x08, 0x08, 0x10, 0x10, 0x12, 0x18, 0x1C, 0x24, 0x22, 0x24, 0x2E, 0x2A, 0x34,
	0x34, 0x40, 0x42, 0x3E, 0x42, 0x3E, 0x46, 0x42, 0x46, 0x50, 0x4E, 0x56, 0x50, 0x4E, 0x5C, 0x5E,
	0x56, 0x5E, 0x60, 0x68, 0x62, 0x66, 0x60, 0x62, 0x6C, 0x66, 0x6C, 0x66, 0x60, 0x6A, 0x66, 0x6A,
	0x70, 0x68, 0x5E, 0x64, 0x68, 0x62, 0x6C, 0x68, 0x64, 0x68, 0x60, 0x66, 0x60, 0x5A, 0x58, 0x58,
	0x58, 0x50, 0x50, 0x4A, 0x46, 0x42, 0x44, 0x44, 0x48, 0x40, 0x3E, 0x42, 0x38, 0x3C, 0x30, 0x30,
	0x30, 0x2C, 0x34, 0x28, 0x28, 0x26, 0x1C, 0x28, 0x22, 0x1A, 0x16, 0x12, 0x0E, 0x0C, 0x0C, 0x0C,
	0x0C, 0x02, 0x06, 0x06, 0x00, 0x00, 0x00, 0xFA, 0xFA, 0xFC, 0xF2, 0xF6, 0xFA, 0xF6, 0xF4, 0xF0,
	0xF0, 0xE8, 0xE8, 0xF2, 0xF0, 0xF0, 0xE6, 0xE4, 0xE6, 0xEC, 0xEE, 0xEE, 0xE2, 0xE6, 0xEE, 0xE4,
	0xF0, 0xEC, 0xE6, 0xEC, 0xEA, 0xEC, 0xF0, 0xF0, 0xEA, 0xE8, 0xEA, 0xEC, 0xFA, 0xF0, 0xE8, 0xEE,
	0xEA, 0xF4, 0xFC, 0xFE, 0xFA, 0x00, 0xF8, 0xF8, 0xF8, 0xFC, 0x00, 0xFC, 0x02, 0x00, 0x06, 0x0A,
	0x0A, 0x0C, 0x10, 0x0C, 0x0E, 0x08, 0x0C, 0x10, 0x0E, 0x18, 0x14, 0x1E, 0x1C, 0x20, 0x1E, 0x1C,
	0x1E, 0x1E, 0x20, 0x26, 0x22, 0x1E, 0x20, 0x22, 0x28, 0x20, 0x26, 0x2A, 0x26, 0x2C, 0x26, 0x26,
	0x26, 0x28, 0x30, 0x38, 0x2E, 0x2E, 0x30, 0x2A, 0x34, 0x30, 0x32, 0x2E, 0x26, 0x2C, 0x2C, 0x26,
	0x26, 0x2A, 0x28, 0x2A, 0x28, 0x26, 0x2A, 0x24, 0x20, 0x28, 0x26, 0x28, 0x26, 0x22, 0x1E, 0x20,
	0x24, 0x1C, 0x12, 0x1C, 0x0E, 0x14, 0x14, 0x0E, 0x18, 0x12, 0x10, 0x12, 0x0C, 0x0C, 0x04, 0x0C,
	0x0A, 0x0C, 0x08, 0x02, 0x0C, 0x10, 0x0E, 0x0A, 0x02, 0xFE, 0x06, 0x06, 0x06, 0x04, 0xFC, 0x06,
	0x08, 0x02, 0x00, 0xF8, 0xFC, 0xFC, 0xF4, 0xFC, 0x00, 0x00, 0xFE, 0xF8, 0xF0, 0xF6, 0xFC, 0xF6,
	0xF4, 0xF2, 0xF6, 0xFA, 0xF2, 0xF8, 0xF8, 0xFA, 0xF6, 0xFC, 0xFC, 0xF6, 0xFC, 0xF2, 0xFC, 0xFA,
	0xFE, 0xFC, 0xFE, 0x00, 0xFC, 0xFE, 0x00, 0xFE, 0x06, 0x02, 0x04, 0x10, 0x0E, 0x12, 0x0C, 0x0E,
	0x0E, 0x0C, 0x0E, 0x10, 0x10, 0x1A, 0x0E, 0x08, 0x16, 0x1A, 0x20, 0x20, 0x22, 0x2C, 0x2C, 0x30,
	0x30, 0x38, 0x3E, 0x34, 0x36, 0x3E, 0x40, 0x3C, 0x42, 0x3C, 0x44, 0x46, 0x46, 0x4A, 0x4C, 0x4A,
	0x4A, 0x52, 0x50, 0x56, 0x5E, 0x5E, 0x60, 0x60, 0x62, 0x60, 0x62, 0x64, 0x60, 0x64, 0x64, 0x6A,
	0x72, 0x68, 0x66, 0x6C, 0x6E, 0x6E, 0x74, 0x70, 0x6C, 0x6C, 0x66, 0x70, 0x7A, 0x7A, 0x7A, 0x78,
	0x74, 0x72, 0x72, 0x78, 0x72, 0x76, 0x76, 0x74, 0x78, 0x72, 0x76, 0x72, 0x70, 0x74, 0x70, 0x72,
	0x70, 0x76, 0x74, 0x6E, 0x6A, 0x66, 0x68, 0x64, 0x64, 0x60, 0x64, 0x64, 0x64, 0x68, 0x60, 0x5A,
	0x5C, 0x58, 0x56, 0x54, 0x58, 0x4C, 0x50, 0x4E, 0x4A, 0x4A, 0x46, 0x46, 0x42, 0x42, 0x46, 0x46,
	0x42, 0x40, 0x40, 0x3C, 0x3A, 0x3A, 0x3A, 0x36, 0x3A, 0x36, 0x34, 0x30, 0x2E, 0x30, 0x28, 0x24,
	0x26, 0x1E, 0x26, 0x1E, 0x18, 0x1A, 0x14, 0x16, 0x1C, 0x12, 0x08, 0x02, 0x04, 0x04, 0x08, 0x04,
	0x00, 0x00, 0xFA, 0xF8, 0xF2, 0xF2, 0xEC, 0xE8, 0xEA, 0xE4, 0xE2, 0xE0, 0xDA, 0xDE, 0xDC, 0xD6,
	0xD2, 0xD2, 0xCE, 0xCC, 0xC4, 0xC0, 0xC4, 0xBC, 0xC0, 0xC0, 0xB8, 0xAE, 0xAA, 0xAC, 0xAE, 0xA4,
	0xA0, 0x9C, 0x9C, 0xA6, 0x9E, 0xA0, 0x9A, 0x9C, 0x9A, 0x94, 0x98, 0x94, 0x98, 0x96, 0x9C, 0x92,
	0x8E, 0x8E, 0x8E, 0x90, 0x8A, 0x84, 0x82, 0x82, 0x84, 0x80, 0x86, 0x86, 0x86, 0x8A, 0x88, 0x90,
	0x96, 0x94, 0x98, 0x8E, 0x90, 0x98, 0x9A, 0x9A, 0x98, 0x90, 0x9A, 0xA0, 0xA0, 0xAC, 0xA8, 0xAE,
	0xB2, 0xB0, 0xB2, 0xBE, 0xBC, 0xBC, 0xC2, 0xC4, 0xCC, 0xCC, 0xCE, 0xD4, 0xD8, 0xDA, 0xDC, 0xEA,
	0xEA, 0xEC, 0xF2, 0xF4, 0xFC, 0xFA, 0x00, 0x06, 0x0A, 0x12, 0x14, 0x16, 0x16, 0x2A, 0x36, 0x34,
	0x34, 0x3A, 0x3A, 0x46, 0x4C, 0x52, 0x5A, 0x5A, 0x60, 0x5C, 0x5E, 0x68, 0x6A, 0x66, 0x72, 0x76,
	0x78, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C,
	0x76, 0x76, 0x72, 0x74, 0x70, 0x68, 0x68, 0x60, 0x5E, 0x5E, 0x56, 0x58, 0x56, 0x4C, 0x4C, 0x46,
	0x44, 0x46, 0x3C, 0x3A, 0x30, 0x30, 0x2A, 0x2C, 0x26, 0x20, 0x1E, 0x1E, 0x1E, 0x18, 0x16, 0x14,
	0x0E, 0x10, 0x08, 0x08, 0x06, 0x04, 0x00, 0xFC, 0xFA, 0xF6, 0xEE, 0xF0, 0xEE, 0xEA, 0xE4, 0xE6,
	0xE6, 0xE2, 0xDE, 0xE0, 0xE0, 0xDE, 0xE2, 0xDA, 0xD8, 0xD8, 0xD8, 0xD6, 0xDA, 0xD6, 0xD4, 0xD4,
	0xCE, 0xCA, 0xC8, 0xCA, 0xD0, 0xCE, 0xCA, 0xCC, 0xC6, 0xC2, 0xC6, 0xC8, 0xC8, 0xCE, 0xCA, 0xCA,
	0xC6, 0xCC, 0xC0, 0xC0, 0xC4, 0xC2, 0xC6, 0xC0, 0xBE, 0xC2, 0xC2, 0xBC, 0xB8, 0xBC, 0xC0, 0xC0,
	0xC0, 0xC0, 0xC0, 0xC8, 0xC6, 0xC4, 0xC2, 0xC6, 0xC2, 0xC2, 0xC4, 0xC6, 0xC0, 0xBC, 0xC4, 0xC2,
	0xC6, 0xC6, 0xC6, 0xC6, 0xC4, 0xC0, 0xC6, 0xCE, 0xC6, 0xC8, 0xC8, 0xC6, 0xC0, 0xC2, 0xC8, 0xCC,
	0xCA, 0xCC, 0xCA, 0xC4, 0xCC, 0xCE, 0xC8, 0xCC, 0xC8, 0xC6, 0xC6, 0xC6, 0xD0, 0xCA, 0xC8, 0xC6,
	0xC8, 0xD2, 0xD0, 0xCC, 0xCA, 0xCE, 0xD0, 0xD4, 0xD4, 0xD6, 0xD4, 0xD6, 0xD6, 0xD6, 0xD4, 0xD2,
	0xD4, 0xD8, 0xD2, 0xD6, 0xD8, 0xD6, 0xDA, 0xD4, 0xD4, 0xD2, 0xD8, 0xE0, 0xE0, 0xE0, 0xDC, 0xDE,
	0xDE, 0xE2, 0xE0, 0xDC, 0xE2, 0xE0, 0xE0, 0xE4, 0xE6, 0xE6, 0xE4, 0xE4, 0xE2, 0xE0, 0xE6, 0xEC,
	0xE8, 0xE6, 0xE8, 0xE8, 0xEA, 0xEC, 0xEE, 0xF0, 0xEC, 0xEA, 0xEA, 0xEC, 0xF4, 0xF2, 0xF2, 0xEC,
	0xEE, 0xF0, 0xEE, 0xF2, 0xF2, 0xF2, 0xF6, 0xF8, 0xF4, 0xF6, 0xFA, 0xF8, 0xF8, 0xF8, 0xFC, 0xFC,
	0xF8, 0xF8, 0xFA, 0x00, 0x00, 0x04, 0x08, 0x04, 0x02, 0x02, 0x04, 0x10, 0x14, 0x10, 0x12, 0x0C,
	0x0C, 0x12, 0x12, 0x14, 0x16, 0x16, 0x18, 0x1A, 0x1E, 0x20, 0x20, 0x22, 0x20, 0x1E, 0x22, 0x28,
	0x28, 0x2A, 0x2C, 0x2E, 0x30, 0x32, 0x34, 0x38, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x42, 0x42, 0x42,
	0x42, 0x46, 0x48, 0x48, 0x4E, 0x4A, 0x54, 0x58, 0x58, 0x5A, 0x5A, 0x5C, 0x62, 0x62, 0x5E, 0x68,
	0x66, 0x6A, 0x70, 0x6E, 0x70, 0x72, 0x72, 0x76, 0x7A, 0x76, 0x74, 0x78, 0x78, 0x7C, 0x7F, 0x7A,
	0x7C, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7A, 0x7C,
	0x7C, 0x7C, 0x74, 0x6A, 0x6C, 0x6E, 0x6E, 0x6C, 0x60, 0x60, 0x5E, 0x5E, 0x5C, 0x56, 0x54, 0x56,
	0x54, 0x52, 0x54, 0x4C, 0x46, 0x44, 0x42, 0x40, 0x3C, 0x3C, 0x3C, 0x38, 0x32, 0x32, 0x2C, 0x2C,
	0x26, 0x24, 0x26, 0x20, 0x22, 0x1E, 0x1C, 0x18, 0x10, 0x18, 0x10, 0x10, 0x0C, 0x0C, 0x08, 0x0C,
	0x0C, 0x02, 0x00, 0xFC, 0x00, 0xFC, 0xF8, 0xF2, 0xF2, 0xEA, 0xEA, 0xEE, 0xF0, 0xF2, 0xE6, 0xE4,
	0xE4, 0xE6, 0xE8, 0xEA, 0xE6, 0xE2, 0xE4, 0xE0, 0xE2, 0xE0, 0xDC, 0xD2, 0xD6, 0xD8, 0xDA, 0xDA,
	0xD0, 0xD4, 0xD6, 0xD0, 0xCE, 0xD2, 0xD0, 0xCC, 0xCA, 0xCC, 0xCC, 0xCA, 0xCC, 0xCC, 0xCC, 0xCA,
	0xC6, 0xC6, 0xC4, 0xC4, 0xC4, 0xC4, 0xC0, 0xC6, 0xC2, 0xC6, 0xC8, 0xC2, 0xC2, 0xC2, 0xC0, 0xC6,
	0xC6, 0xC2, 0xC4, 0xC6, 0xC2, 0xC2, 0xC4, 0xC8, 0xC6, 0xC4, 0xC0, 0xC0, 0xBC, 0xBE, 0xBE, 0xC0,
	0xC2, 0xC0, 0xC4, 0xC0, 0xC0, 0xC2, 0xBE, 0xC2, 0xC6, 0xCA, 0xC6, 0xC4, 0xC0, 0xC0, 0xC0, 0xC2,
	0xC6, 0xC8, 0xC6, 0xC8, 0xC8, 0xC6, 0xC6, 0xCA, 0xCA, 0xCC, 0xCE, 0xCC, 0xCC, 0xD6, 0xDA, 0xDC,
	0xDC, 0xDE, 0xDA, 0xDA, 0xE2, 0xE2, 0xE8, 0xE6, 0xE6, 0xE6, 0xEC, 0xF0, 0xF2, 0xF2, 0xF2, 0xF4,
	0xF8, 0xFC, 0xFC, 0x02, 0x04, 0x04, 0x06, 0x0C, 0x0E, 0x10, 0x10, 0x16, 0x1A, 0x1A, 0x1E, 0x20,
	0x24, 0x24, 0x24, 0x26, 0x2A, 0x30, 0x2E, 0x32, 0x36, 0x38, 0x40, 0x3E, 0x3E, 0x3E, 0x42, 0x42,
	0x44, 0x4C, 0x50, 0x54, 0x54, 0x52, 0x50, 0x54, 0x5C, 0x5A, 0x5C, 0x5E, 0x5C, 0x5E, 0x62, 0x64,
	0x66, 0x64, 0x64, 0x66, 0x66, 0x66, 0x68, 0x6C, 0x6E, 0x6E, 0x6C, 0x6A, 0x6C, 0x6A, 0x6E, 0x6A,
	0x6E, 0x6A, 0x70, 0x70, 0x6A, 0x6C, 0x68, 0x6A, 0x6E, 0x6C, 0x6C, 0x64, 0x62, 0x64, 0x66, 0x6C,
	0x68, 0x62, 0x60, 0x5E, 0x64, 0x66, 0x60, 0x5E, 0x5C, 0x5C, 0x5C, 0x58, 0x54, 0x56, 0x50, 0x52,
	0x4C, 0x46, 0x48, 0x42, 0x46, 0x4A, 0x40, 0x3A, 0x38, 0x3A, 0x36, 0x30, 0x2A, 0x26, 0x2C, 0x30,
	0x2A, 0x26, 0x2A, 0x2A, 0x22, 0x1C, 0x18, 0x1C, 0x16, 0x14, 0x16, 0x0E, 0x12, 0x14, 0x0A, 0x06,
	0x08, 0x00, 0x04, 0x02, 0x00, 0xFC, 0xFC, 0xFE, 0xF8, 0xF6, 0xF2, 0xF0, 0xF2, 0xF0, 0xEC, 0xEA,
	0xEA, 0xEA, 0xEE, 0xEA, 0xE6, 0xE8, 0xE2, 0xE6, 0xE8, 0xE6, 0xEA, 0xE4, 0xE2, 0xE0, 0xE0, 0xE0,
	0xDE, 0xE2, 0xE4, 0xE0, 0xE0, 0xE0, 0xE2, 0xE2, 0xE0, 0xE2, 0xE4, 0xE0, 0xE0, 0xE2, 0xE2, 0xE4,
	0xE6, 0xE6, 0xE6, 0xE6, 0xEE, 0xE8, 0xE6, 0xE8, 0xE6, 0xE6, 0xEC, 0xF0, 0xEE, 0xEE, 0xEC, 0xEE,
	0xF2, 0xF4, 0xF8, 0xF4, 0xF8, 0xF8, 0xF8, 0xFA, 0xFE, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04,
	0x08, 0x0A, 0x08, 0x0C, 0x0A, 0x0E, 0x0E, 0x0C, 0x0C, 0x10, 0x10, 0x12, 0x16, 0x18, 0x1A, 0x18,
	0x16, 0x18, 0x18, 0x16, 0x1A, 0x1E, 0x1E, 0x1E, 0x18, 0x1C, 0x1E, 0x1E, 0x1C, 0x1A, 0x20, 0x1E,
	0x24, 0x24, 0x24, 0x22, 0x20, 0x22, 0x22, 0x26, 0x22, 0x20, 0x20, 0x26, 0x26, 0x20, 0x1E, 0x1E,
	0x1E, 0x1C, 0x1A, 0x1C, 0x20, 0x20, 0x22, 0x22, 0x24, 0x20, 0x1E, 0x20, 0x22, 0x26, 0x20, 0x22,
	0x24, 0x24, 0x1E, 0x1C, 0x1C, 0x22, 0x22, 0x1C, 0x20, 0x20, 0x1E, 0x1C, 0x1C, 0x1A, 0x1A, 0x1C,
	0x1E, 0x1C, 0x1A, 0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1E, 0x18, 0x1C, 0x14, 0x12, 0x12, 0x16, 0x10,
	0x0E, 0x16, 0x14, 0x16, 0x10, 0x0E, 0x12, 0x16, 0x16, 0x14, 0x18, 0x10, 0x10, 0x10, 0x12, 0x10,
	0x10, 0x08, 0x08, 0x06, 0x08, 0x08, 0x06, 0x0C, 0x08, 0x08, 0x06, 0x08, 0x08, 0x0A, 0x08, 0x0A,
	0x0C, 0x06, 0x04, 0x04, 0x06, 0x04, 0x04, 0x06, 0x04, 0x02, 0x06, 0x06, 0x02, 0x04, 0x04, 0x06,
	0x08, 0x06, 0x04, 0x04, 0x06, 0x0C, 0x0A, 0x02
};

const uint8_t SfxPlayer::_musicDataSample3[] = {
	0x11, 0x8C, 0x00, 0x20, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x42, 0x50, 0x43, 0x18, 0xF6, 0xEE,
	0xE5, 0xCF, 0xC7, 0xB7, 0xAC, 0xAA, 0xAB, 0xD9, 0x2E, 0x7B, 0x7F, 0x79, 0x27, 0xEC, 0xCD, 0xE6,
	0x03, 0xFC, 0xE9, 0xE1, 0xE2, 0xF5, 0xFF, 0x0E, 0x23, 0x29, 0x13, 0xD5, 0x98, 0x8B, 0xA1, 0xBB,
	0xDF, 0xE9, 0x03, 0x36, 0x65, 0x72, 0x55, 0x23, 0x01, 0xDF, 0xC2, 0xA0, 0x85, 0x90, 0xC3, 0xEF,
	0x18, 0x40, 0x53, 0x55, 0x26, 0xDB, 0x9E, 0x90, 0xC1, 0x0A, 0x3D, 0x59, 0x58, 0x54, 0x62, 0x68,
	0x57, 0x4A, 0x2B, 0xF3, 0xB5, 0x8C, 0x94, 0xC3, 0x02, 0x20, 0x04, 0xCD, 0xAF, 0xAC, 0xD9, 0x03,
	0x0D, 0x0D, 0x0F, 0x01, 0xFA, 0x06, 0x30, 0x5C, 0x75, 0x6F, 0x3A, 0x00, 0xF1, 0xFF, 0xFA, 0xE2,
	0xB2, 0xA3, 0xBC, 0xD8, 0xD7, 0xCD, 0xC5, 0xC6, 0xCA, 0xCE, 0xC7, 0xC1, 0xE8, 0x29, 0x46, 0x47,
	0x58, 0x73, 0x7F, 0x5F, 0x0E, 0xBE, 0xAC, 0xDA, 0x23, 0x50, 0x4F, 0x1F, 0xFE, 0xFB, 0xED, 0xCC,
	0xC6, 0xCB, 0xC0, 0xAB, 0xAB, 0xD6, 0x23, 0x7F, 0x7F, 0x7F, 0x3E, 0xEB, 0xCA, 0xE6, 0xFF, 0xF6,
	0xE8, 0xEB, 0xE7, 0xE5, 0xF6, 0x14, 0x22, 0x24, 0x17, 0xDC, 0x9D, 0x91, 0xB2, 0xDC, 0xED, 0xE2,
	0xEE, 0x21, 0x5A, 0x6E, 0x62, 0x3A, 0xFE, 0xCA, 0xBD, 0xAD, 0x93, 0x9D, 0xC7, 0xE8, 0xFF, 0x24,
	0x50, 0x60, 0x3A, 0xF1, 0xA9, 0x9A, 0xBE, 0x00, 0x48, 0x6D, 0x59, 0x48, 0x58, 0x5C, 0x4A, 0x38,
	0x24, 0xE7, 0x95, 0x84, 0x85, 0xC4, 0x13, 0x36, 0x1F, 0xE2, 0xA4, 0xA2, 0xD8, 0x02, 0x06, 0x01,
	0x0F, 0x15, 0x0E, 0x2E, 0x62, 0x73, 0x6A, 0x53, 0x19, 0xE0, 0xD2, 0xE4, 0xF1, 0xD0, 0xA6, 0xA6,
	0xCF, 0xF7, 0xEB, 0xD2, 0xC4, 0xB1, 0xA9, 0xC6, 0xD4, 0xD3, 0xFB, 0x3A, 0x56, 0x50, 0x4F, 0x6E,
	0x7C, 0x52, 0xFC, 0xA7, 0x9A, 0xC6, 0x0A, 0x44, 0x49, 0x18, 0x00, 0x0F, 0x09, 0xDF, 0xC4, 0xCB,
	0xCE, 0xB9, 0xC2, 0xE8, 0x26, 0x76, 0x7F, 0x7F, 0x3A, 0xD7, 0xBB, 0xE4, 0x01, 0xED, 0xCB, 0xCD,
	0xD8, 0xD9, 0xF2, 0x1C, 0x1F, 0x1B, 0x1E, 0xF2, 0xBF, 0xAC, 0xC6, 0xF6, 0xFD, 0xEC, 0xF0, 0x1B,
	0x58, 0x68, 0x58, 0x3E, 0xFE, 0xC5, 0xBA, 0xAD, 0x90, 0x98, 0xC2, 0xE7, 0xF7, 0x06, 0x39, 0x57,
	0x4A, 0x11, 0xBD, 0xA4, 0xC7, 0x03, 0x59, 0x7E, 0x5A, 0x3B, 0x41, 0x48, 0x37, 0x24, 0x18, 0xEA,
	0x95, 0x84, 0x8E, 0xC9, 0x20, 0x3F, 0x1F, 0xDE, 0x99, 0xAC, 0xFD, 0x3B, 0x42, 0x25, 0x23, 0x1D,
	0xFA, 0x05, 0x3E, 0x54, 0x57, 0x46, 0x0C, 0xDC, 0xD7, 0xF5, 0x11, 0xDA, 0x8A, 0x84, 0x8B, 0xDC,
	0xFB, 0xF1, 0xEF, 0xD7, 0xC5, 0xE5, 0xFB, 0xF2, 0xFA, 0x1F, 0x38, 0x35, 0x33, 0x6C, 0x7F, 0x78,
	0x1F, 0xA6, 0x84, 0x98, 0xD6, 0x23, 0x3B, 0x08, 0xE7, 0x02, 0x1A, 0x02, 0xE2, 0xE3, 0xE4, 0xB9,
	0xB1, 0xDA, 0x22, 0x7B, 0x7F, 0x7F, 0x34, 0xD3, 0xC7, 0x0C, 0x33, 0x0C, 0xC9, 0xB3, 0xC1, 0xC1,
	0xDD, 0x1D, 0x2E, 0x20, 0x14, 0xEF, 0xCB, 0xD0, 0xF7, 0x26, 0x0C, 0xC3, 0xA6, 0xD6, 0x36, 0x67,
	0x68, 0x59, 0x1B, 0xCD, 0xBA, 0xB8, 0x9C, 0x8F, 0xA6, 0xC2, 0xD0, 0xEC, 0x3B, 0x77, 0x6D, 0x29,
	0xC6, 0xA2, 0xC6, 0x07, 0x59, 0x7F, 0x5C, 0x2B, 0x2D, 0x41, 0x35, 0x25, 0x1F, 0xF5, 0x95, 0x84,
	0x8B, 0xD6, 0x2E, 0x43, 0x0E, 0xBC, 0x84, 0x84, 0xED, 0x3B, 0x41, 0x21, 0x22, 0x2A, 0x17, 0x24,
	0x64, 0x73, 0x4F, 0x29, 0xF5, 0xD7, 0xE9, 0x12, 0x29, 0xE5, 0x86, 0x84, 0x84, 0xDE, 0x06, 0xF9,
	0xF1, 0xD5, 0xB0, 0xC7, 0xE4, 0xDF, 0xE0, 0x01, 0x1B, 0x22, 0x32, 0x76, 0x7F, 0x7F, 0x3B, 0xB7,
	0x85, 0x9A, 0xD0, 0x17, 0x32, 0x01, 0xE2, 0xFB, 0x1A, 0x0B, 0xF1, 0xF0, 0xE4, 0xA0, 0x87, 0xAF,
	0xFE, 0x62, 0x7F, 0x79, 0x35, 0xE1, 0xDA, 0x26, 0x4E, 0x2B, 0xE4, 0xC8, 0xC8, 0xBA, 0xC8, 0x0A,
	0x1F, 0x13, 0x0E, 0xFB, 0xEB, 0xF8, 0x1A, 0x3F, 0x11, 0xB7, 0x95, 0xBD, 0x1C, 0x4E, 0x57, 0x53,
	0x21, 0xD8, 0xCB, 0xD1, 0xBA, 0xA7, 0xA8, 0xAC, 0xA7, 0xBA, 0x1E, 0x76, 0x7E, 0x45, 0xDC, 0xAA,
	0xBB, 0xEE, 0x44, 0x78, 0x5B, 0x36, 0x3A, 0x4A, 0x37, 0x27, 0x2D, 0x15, 0xBB, 0x86, 0x92, 0xC7,
	0x0C, 0x27, 0x04, 0xC7, 0x8F, 0x9D, 0xF8, 0x37, 0x2E, 0x05, 0x08, 0x15, 0x0D, 0x1C, 0x58, 0x67,
	0x4C, 0x2E, 0x12, 0x01, 0x0D, 0x2A, 0x35, 0xE7, 0x8A, 0x84, 0x84, 0xDA, 0x08, 0x11, 0x0D, 0xEC,
	0xBC, 0xBE, 0xD5, 0xD4, 0xD3, 0xED, 0xFF, 0x00, 0x13, 0x68, 0x7F, 0x7F, 0x61, 0xE1, 0x90, 0x83,
	0xA4, 0xEC, 0x1F, 0x0D, 0xF6, 0x0C, 0x2B, 0x1F, 0x0F, 0x14, 0x09, 0xC4, 0x98, 0xA9, 0xEC, 0x41,
	0x7C, 0x78, 0x39, 0xE8, 0xD8, 0x16, 0x46, 0x27, 0xE1, 0xC0, 0xAF, 0xA0, 0xB5, 0xFB, 0x23, 0x1F,
	0x16, 0x06, 0xF8, 0x05, 0x2D, 0x4E, 0x27, 0xC9, 0x8E, 0xAD, 0x05, 0x46, 0x68, 0x6A, 0x36, 0xE8,
	0xCA, 0xCA, 0xB8, 0xA4, 0xA5, 0xA4, 0x9A, 0xAE, 0x05, 0x66, 0x7F, 0x55, 0xF0, 0xAE, 0xA6, 0xD4,
	0x2A, 0x66, 0x55, 0x29, 0x2E, 0x49, 0x47, 0x40, 0x3D, 0x18, 0xC2, 0x86, 0x85, 0xBC, 0x06, 0x31,
	0x28, 0xE5, 0x9A, 0x8D, 0xD5, 0x2C, 0x37, 0x15, 0x04, 0x00, 0xFA, 0x18, 0x60, 0x7E, 0x6B, 0x3C,
	0x11, 0xF2, 0xF2, 0x16, 0x2B, 0xF8, 0x99, 0x84, 0x84, 0xC1, 0xFA, 0x10, 0x0D, 0xE7, 0xBC, 0xB6,
	0xD1, 0xDE, 0xDA, 0xE9, 0xFA, 0xFD, 0x15, 0x5A, 0x7F, 0x7F, 0x76, 0x0C, 0xB9, 0x91, 0xA5, 0xE1,
	0x0F, 0x01, 0xDE, 0xE6, 0x09, 0x13, 0x18, 0x25, 0x18, 0xE0, 0xB4, 0xB2, 0xE4, 0x28, 0x5E, 0x70,
	0x47, 0x05, 0xEE, 0x15, 0x46, 0x3A, 0x01, 0xD8, 0xBE, 0xA5, 0xAD, 0xDF, 0x0A, 0x17, 0x09, 0xF8,
	0xEC, 0xF5, 0x21, 0x45, 0x34, 0xEB, 0xA7, 0xB4, 0xF9, 0x34, 0x5E, 0x63, 0x35, 0xEF, 0xC2, 0xBB,
	0xBF, 0xB9, 0xB5, 0xAD, 0x94, 0x99, 0xD0, 0x1D, 0x58, 0x44, 0x03, 0xD5, 0xC5, 0xEA, 0x3A, 0x73,
	0x73, 0x42, 0x30, 0x3A, 0x3C, 0x3B, 0x43, 0x2B, 0xEC, 0xB2, 0x9C, 0xBF, 0xF4, 0x14, 0x14, 0xE0,
	0x9B, 0x89, 0xC1, 0x1E, 0x3F, 0x29, 0x14, 0x03, 0xF8, 0x17, 0x4C, 0x6C, 0x5F, 0x33, 0x0F, 0xFF,
	0xFC, 0x13, 0x1F, 0xFA, 0xB2, 0x84, 0x84, 0xB0, 0xE5, 0x10, 0x1B, 0xF5, 0xC3, 0xA8, 0xC0, 0xE6,
	0xF8, 0x04, 0x09, 0xFC, 0x0C, 0x3F, 0x79, 0x7F, 0x62, 0x08, 0xC2, 0x95, 0x98, 0xCF, 0x04, 0x19,
	0x03, 0xF9, 0x04, 0x0E, 0x1B, 0x30, 0x27, 0xFE, 0xD1, 0xC1, 0xED, 0x24, 0x45, 0x58, 0x3E, 0x0E,
	0xFA, 0x10, 0x3E, 0x3A, 0x0F, 0xE6, 0xBB, 0x94, 0x9A, 0xC0, 0xF3, 0x0B, 0x03, 0xF6, 0xFA, 0x0C,
	0x36, 0x52, 0x38, 0xEF, 0xA2, 0xA3, 0xDC, 0x1A, 0x51, 0x68, 0x3F, 0x03, 0xD3, 0xC8, 0xCD, 0xCE,
	0xC4, 0xB0, 0x8C, 0x86, 0xB6, 0x06, 0x4F, 0x4F, 0x23, 0xF8, 0xDD, 0xEF, 0x2F, 0x5B, 0x5B, 0x31,
	0x1B, 0x1D, 0x22, 0x2D, 0x3F, 0x2C, 0x05, 0xDE, 0xC0, 0xCA, 0xE7, 0xF6, 0xFA, 0xD9, 0xA8, 0xA2,
	0xD1, 0x22, 0x44, 0x38, 0x1F, 0x02, 0xF0, 0x11, 0x38, 0x4D, 0x48, 0x27, 0x0A, 0x03, 0x01, 0x15,
	0x1C, 0xFC, 0xBE, 0x85, 0x84, 0xA8, 0xE0, 0x18, 0x2C, 0x04, 0xD7, 0xC2, 0xD1, 0xED, 0xFF, 0x02,
	0x02, 0xFC, 0x19, 0x44, 0x6B, 0x7F, 0x5D, 0x1B, 0xDD, 0xA8, 0x9B, 0xBB, 0xD9, 0xE5, 0xD8, 0xDA,
	0xEC, 0x08, 0x29, 0x41, 0x2C, 0x08, 0xE9, 0xDB, 0xF9, 0x22, 0x37, 0x41, 0x32, 0x1A, 0x22, 0x3C,
	0x5F, 0x4E, 0x18, 0xDE, 0xA1, 0x84, 0x86, 0xA4, 0xC8, 0xE9, 0xF6, 0xFF, 0x0E, 0x21, 0x42, 0x4E,
	0x35, 0xFF, 0xC1, 0xC0, 0xED, 0x20, 0x55, 0x67, 0x3E, 0x14, 0xED, 0xD9, 0xCC, 0xC2, 0xB5, 0xA9,
	0x94, 0x9C, 0xBA, 0xE7, 0x20, 0x2B, 0x13, 0xF6, 0xDC, 0xF1, 0x32, 0x57, 0x5F, 0x3F, 0x2C, 0x2A,
	0x2A, 0x2A, 0x1F, 0xF7, 0xDE, 0xD8, 0xCD, 0xDC, 0xEF, 0xF7, 0xFB, 0xE1, 0xBC, 0xB7, 0xD7, 0x15,
	0x31, 0x26, 0x0B, 0xEE, 0xF8, 0x35, 0x5F, 0x64, 0x53, 0x33, 0x15, 0x03, 0xF6, 0xF1, 0xE7, 0xD3,
	0xB8, 0x8E, 0x89, 0xA8, 0xDE, 0x26, 0x40, 0x1A, 0xED, 0xCC, 0xC6, 0xD9, 0xEE, 0xFB, 0x01, 0x0B,
	0x2E, 0x4A, 0x58, 0x6C, 0x53, 0x27, 0xF5, 0xBC, 0xA0, 0xAF, 0xC2, 0xD6, 0xDC, 0xEC, 0x05, 0x1D,
	0x3D, 0x42, 0x20, 0x0B, 0xFD, 0xEF, 0xFE, 0x12, 0x1F, 0x22, 0x0F, 0xFB, 0x05, 0x23, 0x4F, 0x55,
	0x31, 0xF6, 0xAF, 0x8C, 0x9B, 0xB1, 0xD0, 0xF2, 0xFF, 0x01, 0x03, 0x1E, 0x4A, 0x66, 0x60, 0x2E,
	0xD5, 0xAB, 0xAE, 0xD9, 0x1F, 0x38, 0x1E, 0x07, 0xF3, 0xE6, 0xDD, 0xD4, 0xCE, 0xBC, 0xAD, 0xAC,
	0xAD, 0xC4, 0x02, 0x26, 0x2E, 0x25, 0x0B, 0x13, 0x38, 0x49, 0x41, 0x25, 0x17, 0x1B, 0x23, 0x2B,
	0x15, 0xE7, 0xDE, 0xEB, 0xEB, 0xF7, 0xFE, 0x01, 0x04, 0xE6, 0xC4, 0xBD, 0xD6, 0x16, 0x36, 0x31,
	0x12, 0xE6, 0xF1, 0x34, 0x5C, 0x55, 0x3A, 0x0F, 0xEF, 0xE1, 0xE6, 0xF8, 0x03, 0x01, 0xEB, 0xB7,
	0xA2, 0xAB, 0xD9, 0x2A, 0x4A, 0x24, 0xF5, 0xDB, 0xD8, 0xE2, 0xEC, 0xF2, 0xE3, 0xE2, 0xFA, 0x09,
	0x15, 0x2F, 0x36, 0x31, 0x19, 0xE5, 0xC7, 0xC3, 0xCA, 0xD2, 0xD8, 0xEB, 0x08, 0x29, 0x55, 0x5F,
	0x3A, 0x23, 0x1B, 0x0B, 0x0B, 0x0A, 0x04, 0xF8, 0xDC, 0xCF, 0xDF, 0x08, 0x3C, 0x47, 0x2F, 0x00,
	0xBA, 0xA5, 0xC7, 0xDE, 0xE0, 0xE3, 0xDE, 0xE0, 0xEF, 0x1B, 0x56, 0x77, 0x76, 0x48, 0xFA, 0xCB,
	0xBD, 0xD0, 0x02, 0x0D, 0xF0, 0xE0, 0xE9, 0xFB, 0x04, 0x01, 0xFE, 0xE6, 0xD3, 0xCD, 0xB8, 0xB3,
	0xD3, 0xF0, 0x0A, 0x13, 0x03, 0x13, 0x3B, 0x50, 0x3F, 0x1C, 0x08, 0x08, 0x12, 0x23, 0x0B, 0xD5,
	0xCF, 0xF1, 0x0A, 0x1F, 0x23, 0x1B, 0x10, 0xEE, 0xCD, 0xC3, 0xDB, 0x0C, 0x29, 0x27, 0x0A, 0xD6,
	0xDB, 0x25, 0x51, 0x4D, 0x32, 0x0A, 0xEE, 0xE6, 0xF4, 0x07, 0x0A, 0x04, 0xEF, 0xC7, 0xB0, 0xAE,
	0xCB, 0x13, 0x39, 0x22, 0x05, 0xF8, 0xF7, 0xFB, 0xFA, 0xEF, 0xD5, 0xD0, 0xF3, 0x08, 0x14, 0x2B,
	0x33, 0x30, 0x24, 0xFC, 0xE0, 0xD5, 0xCA, 0xBD, 0xB8, 0xC9, 0xE9, 0x15, 0x4D, 0x5B, 0x30, 0x1A,
	0x1A, 0x17, 0x1A, 0x18, 0x07, 0xF2, 0xD6, 0xCF, 0xEB, 0x18, 0x44, 0x50, 0x40, 0x1A, 0xD6, 0xB8,
	0xD0, 0xD8, 0xCC, 0xC9, 0xC8, 0xD1, 0xE6, 0x10, 0x47, 0x67, 0x71, 0x4F, 0x09, 0xD3, 0xBA, 0xBF,
	0xEC, 0x04, 0xF2, 0xEA, 0xFB, 0x0A, 0x0E, 0x05, 0xF7, 0xDC, 0xCB, 0xCB, 0xBA, 0xB4, 0xD5, 0xFB,
	0x1C, 0x29, 0x1C, 0x20, 0x3B, 0x48, 0x31, 0x13, 0x01, 0x02, 0x14, 0x2F, 0x22, 0xE9, 0xD4, 0xE6,
	0xF5, 0x01, 0x07, 0x06, 0x00, 0xED, 0xD6, 0xCE, 0xE6, 0x12, 0x2F, 0x31, 0x15, 0xDF, 0xD9, 0x16,
	0x42, 0x3F, 0x2A, 0x0E, 0xF8, 0xED, 0xF5, 0xFF, 0x01, 0x04, 0xF0, 0xC7, 0xA8, 0xA1, 0xC0, 0x09,
	0x37, 0x29, 0x0B, 0x01, 0xFD, 0xFE, 0xFF, 0xF4, 0xD9, 0xD1, 0xE9, 0xFA, 0x07, 0x21, 0x31, 0x34,
	0x29, 0x07, 0xE9, 0xDF, 0xD5, 0xC2, 0xB9, 0xC6, 0xE2, 0x0D, 0x47, 0x5B, 0x3C, 0x28, 0x28, 0x1E,
	0x0F, 0x05, 0xFA, 0xEF, 0xE2, 0xD7, 0xE2, 0x0D, 0x3A, 0x51, 0x4B, 0x24, 0xE0, 0xC0, 0xD6, 0xE0,
	0xCE, 0xC2, 0xC8, 0xDB, 0xF5, 0x19, 0x39, 0x51, 0x60, 0x48, 0x14, 0xDE, 0xBA, 0xBE, 0xE8, 0x01,
	0xEF, 0xE3, 0xF7, 0x0E, 0x17, 0x16, 0x06, 0xE8, 0xD8, 0xD1, 0xBA, 0xAC, 0xBC, 0xE7, 0x12, 0x29,
	0x24, 0x1D, 0x31, 0x3F, 0x2C, 0x11, 0xFF, 0xF5, 0xFC, 0x15, 0x14, 0xF2, 0xEF, 0x0B, 0x1A, 0x14,
	0x03, 0xFB, 0xFB, 0xFC, 0xED, 0xDD, 0xE7, 0xFE, 0x18, 0x28, 0x1D, 0xF6, 0xE3, 0x0D, 0x2E, 0x28,
	0x18, 0x0E, 0x02, 0xFC, 0xFE, 0xFF, 0xFC, 0x01, 0xEE, 0xD0, 0xB3, 0xA8, 0xBF, 0xFC, 0x27, 0x1D,
	0xFF, 0xF3, 0xF1, 0xEA, 0xF0, 0xF6, 0xEB, 0xE8, 0xF2, 0xF3, 0xFD, 0x12, 0x30, 0x40, 0x39, 0x19,
	0xF4, 0xE3, 0xDD, 0xCC, 0xC8, 0xDD, 0xEE, 0x0A, 0x2E, 0x3C, 0x28, 0x20, 0x26, 0x26, 0x11, 0xFA,
	0xF1, 0xEB, 0xEA, 0xEA, 0xF3, 0x19, 0x3A, 0x46, 0x45, 0x23, 0xEC, 0xCC, 0xD6, 0xDE, 0xD1, 0xC6,
	0xD6, 0xE7, 0xF8, 0x10, 0x21, 0x32, 0x46, 0x37, 0x14, 0xE8, 0xC5, 0xC2, 0xE3, 0x01, 0xFD, 0xF5,
	0xFD, 0x0A, 0x04, 0x02, 0xFE, 0xEC, 0xE2, 0xDD, 0xC2, 0xB2, 0xBA, 0xE2, 0x0F, 0x23, 0x20, 0x13,
	0x18, 0x2B, 0x29, 0x1E, 0x18, 0x08, 0x02, 0x0D, 0x0A, 0xF6, 0xFC, 0x13, 0x27, 0x17, 0xFF, 0xF3,
	0xEF, 0xF8, 0xF8, 0xE5, 0xE4, 0xF0, 0xFF, 0x15, 0x13, 0xFB, 0xF1, 0x09, 0x24, 0x28, 0x19, 0x17,
	0x0E, 0x01, 0xFD, 0xF6, 0xF5, 0x06, 0x00, 0xEC, 0xD1, 0xBC, 0xCC, 0xF9, 0x1E, 0x1C, 0xFF, 0xEB,
	0xE6, 0xDE, 0xE9, 0xF3, 0xF1, 0xF0, 0xF5, 0xED, 0xF1, 0x03, 0x27, 0x40, 0x37, 0x16, 0xEE, 0xDE,
	0xE1, 0xDE, 0xD6, 0xDC, 0xE5, 0xFA, 0x1F, 0x30, 0x2A, 0x2B, 0x2F, 0x30, 0x15, 0xF6, 0xEB, 0xEB,
	0xF5, 0xFF, 0xFD, 0x10, 0x2C, 0x3E, 0x43, 0x2A, 0xFA, 0xDA, 0xD8, 0xDD, 0xD1, 0xC1, 0xCD, 0xE1,
	0xF6, 0x12, 0x1F, 0x29, 0x39, 0x32, 0x18, 0xEF, 0xCB, 0xC8, 0xE0, 0xF8, 0xFA, 0xF3, 0xFF, 0x19,
	0x1F, 0x1C, 0x10, 0xF3, 0xE2, 0xD9, 0xBC, 0xA2, 0x9D, 0xBF, 0xF6, 0x1A, 0x29, 0x25, 0x20, 0x26,
	0x24, 0x16, 0x0C, 0xFE, 0xFA, 0x07, 0x0A, 0x01, 0x0C, 0x25, 0x3F, 0x38, 0x1B, 0x02, 0xEA, 0xE6,
	0xEA, 0xE2, 0xE1, 0xED, 0xFD, 0x12, 0x13, 0x04, 0xFE, 0x0A, 0x19, 0x18, 0x05, 0x00, 0xFF, 0xFA,
	0x01, 0xFD, 0xF7, 0x04, 0x0A, 0xFF, 0xE6, 0xCA, 0xCE, 0xE4, 0xFE, 0x09, 0x00, 0xFB, 0x02, 0xFE,
	0xFC, 0xFE, 0xF1, 0xF5, 0xFB, 0xEF, 0xE4, 0xE5, 0x02, 0x27, 0x32, 0x2C, 0x12, 0xF7, 0xEB, 0xE0,
	0xD1, 0xD3, 0xD9, 0xED, 0x0E, 0x1B, 0x1A, 0x21, 0x32, 0x44, 0x38, 0x14, 0xF7, 0xDD, 0xDE, 0xF1,
	0xFD, 0x11, 0x2A, 0x37, 0x3B, 0x23, 0xFF, 0xEF, 0xEF, 0xED, 0xD6, 0xB4, 0xAD, 0xC6, 0xE6, 0x12,
	0x20, 0x1E, 0x2A, 0x32, 0x2B, 0x0C, 0xE3, 0xD6, 0xD8, 0xE2, 0xEF, 0xF2, 0xFE, 0x18, 0x20, 0x1A,
	0x0A, 0xF0, 0xEB, 0xEC, 0xD7, 0xB8, 0xA4, 0xB3, 0xE6, 0x12, 0x30, 0x33, 0x21, 0x1D, 0x19, 0x10,
	0x14, 0x13, 0x0D, 0x0C, 0xFB, 0xEF, 0xF4, 0x0C, 0x2D, 0x31, 0x15, 0xFF, 0xE9, 0xED, 0xFE, 0xFD,
	0xF7, 0xF3, 0xF2, 0xFD, 0x01, 0x00, 0x0A, 0x16, 0x24, 0x25, 0x12, 0x0B, 0x06, 0xFA, 0xF9, 0xE9,
	0xE1, 0xEF, 0xFE, 0x00, 0xF2, 0xDC, 0xE0, 0xEB, 0xF5, 0xFB, 0xF3, 0xF0, 0xFF, 0xFB, 0xF7, 0xF8,
	0xF3, 0x03, 0x0C, 0xFE, 0xEF, 0xE8, 0xF8, 0x1C, 0x23, 0x21, 0x10, 0xFA, 0xF3, 0xE6, 0xCE, 0xD1,
	0xE1, 0xFF, 0x1C, 0x1A, 0x0F, 0x0B, 0x19, 0x34, 0x36, 0x17, 0xFD, 0xE1, 0xE2, 0xF8, 0x05, 0x14,
	0x2B, 0x33, 0x30, 0x14, 0xF7, 0xF3, 0xF9, 0x01, 0xF2, 0xC9, 0xB8, 0xC6, 0xE0, 0x07, 0x11, 0x0C,
	0x14, 0x23, 0x26, 0x18, 0xF9, 0xE8, 0xE0, 0xD9, 0xDA, 0xDB, 0xEE, 0x12, 0x21, 0x1A, 0x0C, 0xFB,
	0xFE, 0x03, 0xF2, 0xD0, 0xAD, 0xAA, 0xD1, 0xFB, 0x20, 0x2E, 0x22, 0x1B, 0x15, 0x08, 0x07, 0x0D,
	0x10, 0x14, 0x02, 0xF5, 0xF5, 0x09, 0x28, 0x32, 0x1C, 0x08, 0xF4, 0xF7, 0x08, 0x08, 0xFA, 0xF6,
	0xF2, 0xF3, 0xF1, 0xED, 0xFC, 0x08, 0x18, 0x1E, 0x0B, 0xFF, 0x00, 0x01, 0x04, 0xF7, 0xEA, 0xEC,
	0xFB, 0x00, 0xF8, 0xEF, 0xF0, 0xF7, 0xF7, 0xF7, 0xEB, 0xEC, 0xFF, 0x0B, 0x04, 0xF8, 0xE9, 0xEE,
	0xF7, 0xF7, 0xEE, 0xEB, 0xF7, 0x10, 0x1D, 0x22, 0x1E, 0x0E, 0x04, 0xF8, 0xDE, 0xD0, 0xE0, 0xFF,
	0x1D, 0x20, 0x17, 0x10, 0x14, 0x28, 0x2F, 0x18, 0xF8, 0xDD, 0xDA, 0xF3, 0x08, 0x0F, 0x1F, 0x26,
	0x1C, 0x07, 0xF6, 0xF8, 0x02, 0x0B, 0x02, 0xDE, 0xC2, 0xC9, 0xE6, 0x08, 0x10, 0x02, 0xFE, 0x0D,
	0x18, 0x17, 0x06, 0xF1, 0xE2, 0xD6, 0xDB, 0xE2, 0xEB, 0x09, 0x25, 0x27, 0x1A, 0x09, 0x03, 0x05,
	0xF9, 0xDD, 0xC1, 0xB7, 0xCC, 0xF1, 0x15, 0x25, 0x15, 0x06, 0x05, 0x00, 0xFB, 0x02, 0x07, 0x07,
	0xFC, 0xF7, 0xFF, 0x0F, 0x24, 0x34, 0x2C, 0x15, 0x04, 0x03, 0x13, 0x17, 0x01, 0xF1, 0xEC, 0xEA,
	0xED, 0xF5, 0x05, 0x0C, 0x12, 0x17, 0x0F, 0xFB, 0xF2, 0xF1, 0xF3, 0xEE, 0xE8, 0xEF, 0x05, 0x10,
	0x0A, 0x02, 0xFA, 0xF4, 0xEC, 0xED, 0xE9, 0xE3, 0xEC, 0x01, 0x0B, 0x08, 0x01, 0xFB, 0xF5, 0xED,
	0xE5, 0xEA, 0xF8, 0x07, 0x16, 0x1B, 0x1B, 0x0E, 0x05, 0x02, 0xED, 0xD5, 0xD6, 0xEF, 0x0D, 0x1A,
	0x1E, 0x1A, 0x15, 0x17, 0x1D, 0x18, 0x04, 0xF1, 0xEC, 0xFA, 0x0B, 0x0B, 0x15, 0x23, 0x1C, 0x08,
	0xF8, 0xF6, 0x00, 0x0A, 0x09, 0xF6, 0xD6, 0xCA, 0xDF, 0xFC, 0x09, 0x04, 0xFB, 0x06, 0x10, 0x10,
	0x0D, 0x02, 0xEE, 0xDB, 0xD5, 0xD7, 0xDE, 0xF6, 0x19, 0x2D, 0x24, 0x12, 0x03, 0xFB, 0xF4, 0xDF,
	0xCB, 0xC3, 0xCA, 0xE9, 0x0C, 0x21, 0x1E, 0x11, 0x10, 0x0B, 0xFE, 0xF9, 0xFF, 0xFF, 0xFB, 0xFF,
	0x06, 0x13, 0x1C, 0x25, 0x2A, 0x1B, 0x0D, 0x09, 0x15, 0x1B, 0x0A, 0xF9, 0xF3, 0xEE, 0xE9, 0xF0,
	0xFC, 0x03, 0x07, 0x0C, 0x0D, 0x04, 0xF3, 0xF4, 0xF6, 0xEF, 0xE6, 0xE2, 0xF3, 0x03, 0x06, 0x0D,
	0x11, 0x0B, 0x00, 0xF6, 0xEE, 0xE9, 0xEB, 0xFB, 0x09, 0x03, 0xFA, 0xF2, 0xEA, 0xE9, 0xE7, 0xEF,
	0xFD, 0xFF, 0x01, 0x03, 0x06, 0x08, 0x07, 0x06, 0xFB, 0xE6, 0xDF, 0xF2, 0x07, 0x17, 0x20, 0x1D,
	0x1B, 0x16, 0x10, 0x0D, 0xFC, 0xEC, 0xED, 0xF9, 0x08, 0x0D, 0x0D, 0x17, 0x18, 0x0E, 0x0B, 0x0E,
	0x12, 0x10, 0x04, 0xF3, 0xE0, 0xD5, 0xE7, 0xFE, 0x08, 0x04, 0xF6, 0xF5, 0xFE, 0x01, 0x03, 0x01,
	0xEF, 0xD9, 0xCE, 0xD1, 0xE7, 0x01, 0x1F, 0x33, 0x2B, 0x16, 0x03, 0xF5, 0xF4, 0xEA, 0xE0, 0xDE,
	0xDD, 0xEC, 0xFE, 0x0D, 0x11, 0x0A, 0x04, 0x03, 0xFB, 0xEE, 0xED, 0xF0, 0xFC, 0x0C, 0x17, 0x1F,
	0x20, 0x1A, 0x1F, 0x19, 0x11, 0x0D, 0x10, 0x17, 0x11, 0xFE, 0xF6, 0xF4, 0xF2, 0xF6, 0xFF, 0xFE,
	0xF9, 0xF5, 0xF9, 0xFF, 0xF5, 0xF4, 0xFA, 0xFC, 0xFE, 0xFB, 0xFF, 0x0B, 0x0C, 0x0A, 0x0B, 0x02,
	0xF5, 0xEC, 0xEB, 0xED, 0xEF, 0xF7, 0x0A, 0x0A, 0xFC, 0xEA, 0xDB, 0xDC, 0xE6, 0xF3, 0x04, 0x08,
	0x07, 0x0B, 0x10, 0x13, 0x11, 0x09, 0x03, 0xF4, 0xE1, 0xE3, 0xF0, 0x07, 0x1E, 0x25, 0x1F, 0x0D,
	0xFB, 0xFC, 0xFA, 0xF3, 0xF6, 0xFC, 0x0A, 0x10, 0x10, 0x10, 0x15, 0x13, 0x15, 0x13, 0x0E, 0x02,
	0xF7, 0xF3, 0xF0, 0xE3, 0xE9, 0xFA, 0x04, 0x02, 0xF5, 0xEF, 0xF5, 0xFF, 0x08, 0x0B, 0xFD, 0xEA,
	0xE1, 0xE2, 0xED, 0xF9, 0x09, 0x23, 0x24, 0x13, 0xFC, 0xE9, 0xE5, 0xE9, 0xEC, 0xEE, 0xE8, 0xE8,
	0xF1, 0xFA, 0x00, 0x00, 0x01, 0x08, 0x0B, 0xFB, 0xF3, 0xF1, 0xFE, 0x15, 0x24, 0x27, 0x1B, 0x0B,
	0x09, 0x06, 0x05, 0x0C, 0x14, 0x18, 0x0F, 0xFA, 0xE9, 0xEA, 0xF3, 0x01, 0x05, 0xFF, 0xF7, 0xF7,
	0x05, 0x0E, 0x05, 0x00, 0x03, 0x03, 0xFE, 0xF3, 0xED, 0xF2, 0x01, 0x0B, 0x11, 0x07, 0xF7, 0xEB,
	0xE5, 0xE4, 0xE3, 0xEA, 0x03, 0x11, 0x07, 0xF1, 0xE0, 0xE0, 0xF4, 0x0B, 0x15, 0x0D, 0x01, 0xFD,
	0x01, 0x06, 0x09, 0x09, 0x09, 0x04, 0xF1, 0xE5, 0xE9, 0xFC, 0x11, 0x19, 0x11, 0xFF, 0xF7, 0x00,
	0x04, 0x02, 0x01, 0x09, 0x17, 0x1F, 0x1B, 0x0A, 0x03, 0x01, 0x07, 0x0A, 0x09, 0x05, 0x01, 0xFF,
	0xF9, 0xE7, 0xE5, 0xF5, 0x01, 0xFD, 0xEF, 0xE3, 0xE5, 0xFD, 0x13, 0x19, 0x0B, 0xF7, 0xEA, 0xE9,
	0xF1, 0xF9, 0x01, 0x15, 0x1E, 0x0F, 0xF9, 0xE9, 0xE8, 0xF3, 0xFB, 0xF4, 0xE8, 0xE5, 0xEE, 0xF8,
	0xFE, 0xFF, 0xFF, 0x06, 0x0D, 0x04, 0xF7, 0xF8, 0x09, 0x1F, 0x29, 0x23, 0x12, 0x09, 0x09, 0x07,
	0xFD, 0xFD, 0x06, 0x10, 0x14, 0x03, 0xE9, 0xE2, 0xEE, 0x00, 0x09, 0x04, 0xFF, 0x00, 0x09, 0x0F,
	0x01, 0xF7, 0xFF, 0x06, 0x05, 0xF9, 0xEB, 0xEC, 0x03, 0x13, 0x13, 0x04, 0xF1, 0xE5, 0xDD, 0xDD,
	0xDD, 0xE7, 0x03, 0x1A, 0x11, 0xF7, 0xE1, 0xE5, 0xFD, 0x15, 0x13, 0x01, 0xF5, 0xF6, 0xFD, 0x05,
	0x0A, 0x08, 0x08, 0x09, 0xF9, 0xE7, 0xEA, 0x01, 0x1A, 0x23, 0x16, 0xFE, 0xF6, 0x00, 0x07, 0x04,
	0x04, 0x0E, 0x1C, 0x27, 0x22, 0x06, 0xF7, 0xF9, 0xFE, 0x02, 0x00, 0xFC, 0xFA, 0xFF, 0xFE, 0xF2,
	0xEB, 0xF9, 0x06, 0x03, 0xF3, 0xE1, 0xDD, 0xF8, 0x12, 0x16, 0x0B, 0xFC, 0xEF, 0xE9, 0xEF, 0xF4,
	0xFD, 0x10, 0x1B, 0x0B, 0xE9, 0xD6, 0xD5, 0xE8, 0xFD, 0xFA, 0xF2, 0xF1, 0xFC, 0x04, 0x09, 0x0B,
	0x05, 0x06, 0x0B, 0x01, 0xED, 0xEE, 0x0B, 0x23, 0x30, 0x27, 0x11, 0x05, 0x04, 0x00, 0xF8, 0xF4,
	0xFE, 0x0C, 0x15, 0x0F, 0xF5, 0xED, 0xFD, 0x0A, 0x0B, 0x04, 0x01, 0x01, 0x0B, 0x0E, 0xFE, 0xEF,
	0xF4, 0x03, 0x07, 0xFE, 0xE8, 0xE1, 0xF8, 0x0F, 0x11, 0x05, 0xF4, 0xE5, 0xDC, 0xDF, 0xE1, 0xEA,
	0x04, 0x1D, 0x18, 0xFC, 0xE7, 0xE6, 0xFC, 0x12, 0x0B, 0xFA, 0xEE, 0xF0, 0xFA, 0x03, 0x09, 0x03,
	0x01, 0x06, 0xFD, 0xE9, 0xEB, 0x05, 0x1D, 0x23, 0x16, 0xFC, 0xF2, 0xF9, 0x07, 0x0D, 0x0D, 0x12,
	0x1B, 0x27, 0x27, 0x0B, 0xF7, 0xF9, 0xF8, 0xF7, 0xF3, 0xF6, 0xF7, 0x01, 0x03, 0xFB, 0xF3, 0xFD,
	0x0B, 0x0A, 0xF8, 0xDF, 0xD4, 0xEE, 0x0C, 0x13, 0x11, 0x07, 0xF9, 0xF1, 0xF3, 0xF7, 0xFF, 0x0D,
	0x1B, 0x06, 0xE1, 0xCD, 0xCF, 0xE6, 0x00, 0x01, 0xF5, 0xF3, 0xFA, 0x03, 0x05, 0x05, 0xFD, 0xF9,
	0x01, 0xFD, 0xEA, 0xF3, 0x12, 0x2C, 0x35, 0x28, 0x10, 0x04, 0x03, 0x06, 0xFF, 0xF7, 0xFA, 0x06,
	0x15, 0x15, 0xFD, 0xEE, 0xFF, 0x09, 0x06, 0x00, 0xFC, 0xFE, 0x08, 0x09, 0xFB, 0xEE, 0xF3, 0x05,
	0x0A, 0x01, 0xEC, 0xE5, 0xFD, 0x13, 0x10, 0x02, 0xF3, 0xE9, 0xE2, 0xE2, 0xE0, 0xE5, 0xFD, 0x1C,
	0x1C, 0xFE, 0xE8, 0xE6, 0xFC, 0x14, 0x11, 0xFD, 0xF4, 0xF3, 0xF9, 0xFB, 0xFD, 0xF8, 0xF9, 0x04,
	0x02, 0xEA, 0xEC, 0x07, 0x1E, 0x25, 0x16, 0xF8, 0xEB, 0xF3, 0x00, 0x0A, 0x11, 0x1E, 0x28, 0x33,
	0x2E, 0x0F, 0xF8, 0xFE, 0x01, 0xF7, 0xEE, 0xEB, 0xF2, 0x03, 0x09, 0x01, 0xF3, 0xF3, 0xFC, 0xFA,
	0xEF, 0xDC, 0xD5, 0xED, 0x0C, 0x10, 0x0D, 0x0A, 0x08, 0x02, 0xFC, 0xF6, 0xF4, 0x03, 0x1B, 0x15,
	0xF0, 0xD7, 0xCE, 0xE2, 0xFE, 0x03, 0xF7, 0xF5, 0xF3, 0xF5, 0xF6, 0xFE, 0x03, 0x08, 0x10, 0x03,
	0xE5, 0xE5, 0x06, 0x27, 0x37, 0x2B, 0x0C, 0xFE, 0xFE, 0x04, 0x09, 0x06, 0x07, 0x08, 0x0B, 0x08,
	0xF4, 0xEB, 0x04, 0x15, 0x0D, 0x01, 0xF9, 0x02, 0x11, 0x14, 0x04, 0xF0, 0xED, 0xFF, 0x07, 0x03,
	0xEE, 0xE2, 0xF6, 0x11, 0x0D, 0x01, 0xF7, 0xED, 0xE1, 0xD8, 0xD5, 0xDD, 0xF9, 0x1C, 0x1F, 0x00,
	0xE7, 0xE1, 0xF9, 0x1B, 0x1E, 0x0B, 0xFC, 0xF4, 0xF0, 0xF1, 0xFA, 0x01, 0x0A, 0x10, 0x06, 0xE5,
	0xDB, 0xF6, 0x14, 0x24, 0x17, 0xF8, 0xE8, 0xED, 0xFD, 0x0D, 0x16, 0x1F, 0x23, 0x26, 0x23, 0x0A,
	0xF7, 0x03, 0x0C, 0xFF, 0xF2, 0xEC, 0xF3, 0x04, 0x10, 0x0B, 0xFD, 0xF7, 0xFE, 0x00, 0xF9, 0xE8,
	0xDA, 0xEA, 0x03, 0x07, 0x04, 0x0B, 0x0D, 0x08, 0xFB, 0xEE, 0xE9, 0xF8, 0x10, 0x11, 0xED, 0xD3,
	0xC9, 0xE0, 0x04, 0x13, 0x0C, 0x03, 0xF8, 0xEC, 0xE7, 0xEE, 0xFC, 0x08, 0x12, 0x09, 0xEA, 0xE2,
	0x02, 0x27, 0x3C, 0x31, 0x11, 0xF9, 0xF2, 0xF8, 0x01, 0x07, 0x10, 0x11, 0x10, 0x09, 0xF7, 0xEF,
	0x05, 0x15, 0x09, 0xFA, 0xF2, 0xF9, 0x07, 0x0F, 0x07, 0xF6, 0xF1, 0x01, 0x0C, 0x0F, 0xFD, 0xEC,
	0xF3, 0x07, 0x0A, 0x03, 0x01, 0xFB, 0xF2, 0xE5, 0xDD, 0xDE, 0xF3, 0x14, 0x1B, 0xFE, 0xE2, 0xD4,
	0xE6, 0x07, 0x17, 0x0E, 0x00, 0xF2, 0xE8, 0xE6, 0xEF, 0x01, 0x11, 0x1B, 0x14, 0xF3, 0xE3, 0xF7,
	0x10, 0x21, 0x1A, 0xFD, 0xE6, 0xE4, 0xF4, 0x09, 0x19, 0x25, 0x28, 0x26, 0x1C, 0x02, 0xF2, 0xFF,
	0x0D, 0x08, 0xFC, 0xF1, 0xF4, 0x05, 0x15, 0x15, 0x04, 0xF6, 0xF7, 0xF7, 0xF6, 0xE9, 0xDE, 0xE3,
	0xF6, 0xFC, 0xFB, 0x03, 0x0A, 0x0D, 0x05, 0xF9, 0xF1, 0xFA, 0x13, 0x18, 0xFC, 0xDF, 0xCD, 0xD4,
	0xF4, 0x0F, 0x13, 0x0B, 0xFB, 0xEA, 0xE2, 0xE4, 0xF4, 0x02, 0x0D, 0x05, 0xE6, 0xDB, 0xF6, 0x1E,
	0x3D, 0x40, 0x26, 0x08, 0xF7, 0xFA, 0x04, 0x0D, 0x11, 0x0E, 0x08, 0x01, 0xF5, 0xF2, 0x07, 0x1A,
	0x14, 0x02, 0xF0, 0xEE, 0xF9, 0x07, 0x04, 0xF5, 0xEE, 0xF7, 0x06, 0x12, 0x0E, 0xFE, 0xFB, 0x02,
	0x04, 0xFD, 0xFB, 0xFA, 0xF3, 0xE9, 0xE2, 0xDE, 0xEF, 0x0D, 0x19, 0x08, 0xEE, 0xDB, 0xE2, 0xFE,
	0x11, 0x13, 0x05, 0xF6, 0xE9, 0xE5, 0xEC, 0xFD, 0x0E, 0x1A, 0x16, 0xF9, 0xE5, 0xEE, 0x02, 0x17,
	0x13, 0xFF, 0xE9, 0xE2, 0xF1, 0x06, 0x19, 0x27, 0x2A, 0x25, 0x1E, 0x0A, 0xFC, 0x04, 0x11, 0x0D,
	0xFD, 0xEF, 0xF1, 0xFE, 0x10, 0x18, 0x0B, 0xFD, 0xF6, 0xF5, 0xF6, 0xEE, 0xE0, 0xDE, 0xE7, 0xEF,
	0xF5, 0x02, 0x12, 0x19, 0x13, 0x09, 0xFB, 0xF8, 0x08, 0x0B, 0xF7, 0xDB, 0xCB, 0xD4, 0xF2, 0x11,
	0x1E, 0x19, 0x0A, 0xF1, 0xE2, 0xDE, 0xE7, 0xF2, 0xFE, 0xFD, 0xEA, 0xE2, 0xF6, 0x1C, 0x37, 0x39,
	0x24, 0x07, 0xF3, 0xF2, 0xF8, 0x05, 0x0D, 0x0C, 0x0B, 0x0E, 0x06, 0x01, 0x0C, 0x1C, 0x18, 0x06,
	0xF6, 0xF2, 0xF5, 0xFB, 0xFE, 0xF4, 0xF1, 0xF9, 0x09, 0x14, 0x13, 0x03, 0xFE, 0xFE, 0xFD, 0xF4,
	0xF1, 0xF1, 0xF2, 0xEB, 0xE7, 0xE6, 0xEF, 0x05, 0x15, 0x0E, 0xF8, 0xE3, 0xE3, 0xF2, 0x02, 0x09,
	0x05, 0xFF, 0xF2, 0xE9, 0xE9, 0xF4, 0x04, 0x13, 0x19, 0x07, 0xF3, 0xEF, 0xFF, 0x10, 0x12, 0x03,
	0xF0, 0xE3, 0xE8, 0xF8, 0x11, 0x27, 0x30, 0x2E, 0x26, 0x12, 0x00, 0x00, 0x09, 0x09, 0xFB, 0xEC,
	0xEB, 0xF9, 0x0C, 0x1B, 0x17, 0x0A, 0xFC, 0xF5, 0xF3, 0xEF, 0xE4, 0xDF, 0xE2, 0xE7, 0xEC, 0xFD,
	0x14, 0x22, 0x1F, 0x10, 0x00, 0xF6, 0xFC, 0x01, 0xF7, 0xDE, 0xCB, 0xCC, 0xE5, 0x04, 0x17, 0x1B,
	0x13, 0xFF, 0xE9, 0xE0, 0xE2, 0xEA, 0xF4, 0xF7, 0xEE, 0xE7, 0xF5, 0x17, 0x37, 0x40, 0x2F, 0x15,
	0xFC, 0xF4, 0xF6, 0x00, 0x06, 0x09, 0x05, 0x06, 0x06, 0x06, 0x10, 0x1C, 0x1E, 0x0E, 0xF9, 0xF0,
	0xF1, 0xF9, 0x01, 0xFE, 0xFA, 0xF9, 0x00, 0x0A, 0x10, 0x08, 0x01, 0xFE, 0xFA, 0xF0, 0xEB, 0xED,
	0xF2, 0xF2, 0xED, 0xE9, 0xE9, 0xFD, 0x0E, 0x13, 0x06, 0xF3, 0xEA, 0xF2, 0xFE, 0x05, 0x01, 0xFB,
	0xF1, 0xEA, 0xE9, 0xF2, 0xFD, 0x0B, 0x13, 0x0B, 0xFA, 0xEE, 0xF2, 0x03, 0x0C, 0x07, 0xF8, 0xE9,
	0xED, 0xFD, 0x18, 0x2A, 0x30, 0x2B, 0x22, 0x16, 0x09, 0x07, 0x0A, 0x0A, 0xFF, 0xEF, 0xEA, 0xF6,
	0x0A, 0x1C, 0x1A, 0x0B, 0xFB, 0xF3, 0xF3, 0xF7, 0xEE, 0xE4, 0xDF, 0xE3, 0xEB, 0xFA, 0x0D, 0x1D,
	0x1E, 0x14, 0x03, 0xF5, 0xF2, 0xF7, 0xFA, 0xEB, 0xD7, 0xD0, 0xDF, 0xFB, 0x14, 0x1B, 0x13, 0x02,
	0xF3, 0xE8, 0xE8, 0xED, 0xF1, 0xF2, 0xEE, 0xE9, 0xF0, 0x0A, 0x26, 0x32, 0x2A, 0x14, 0xFE, 0xF7,
	0xFD, 0x05, 0x07, 0x01, 0xFB, 0xFF, 0x08, 0x12, 0x1A, 0x22, 0x23, 0x17, 0x03, 0xF7, 0xF7, 0xFE,
	0x04, 0xFF, 0xF6, 0xF0, 0xF8, 0x06, 0x10, 0x0E, 0x05, 0xFD, 0xF9, 0xF5, 0xEC, 0xE9, 0xEB, 0xEE,
	0xEE, 0xED, 0xEF, 0xFA, 0x08, 0x12, 0x0D, 0xFD, 0xF0, 0xEF, 0xF8, 0xFE, 0xFA, 0xF3, 0xEB, 0xE9,
	0xEA, 0xF3, 0xFF, 0x06, 0x0D, 0x0A, 0x00, 0xF3, 0xF4, 0x02, 0x0C, 0x0A, 0xFB, 0xEE, 0xF1, 0x03,
	0x19, 0x28, 0x2A, 0x24, 0x19, 0x11, 0x09, 0x06, 0x03, 0x05, 0xFC, 0xED, 0xE7, 0xF4, 0x0B, 0x22,
	0x26, 0x17, 0x00, 0xF3, 0xF6, 0xFD, 0xFF, 0xF0, 0xE3, 0xDE, 0xE7, 0xF6, 0x0B, 0x1B, 0x20, 0x13,
	0xFF, 0xF0, 0xE8, 0xEB, 0xF1, 0xED, 0xDC, 0xD4, 0xDA, 0xF5, 0x10, 0x1F, 0x1B, 0x0D, 0xFA, 0xEE,
	0xEB, 0xEF, 0xF1, 0xF0, 0xEF, 0xF1, 0xF6, 0x09, 0x22, 0x2D, 0x29, 0x12, 0xFB, 0xF1, 0xF4, 0xFC,
	0x03, 0x00, 0xFE, 0xFD, 0x07, 0x17, 0x21, 0x24, 0x24, 0x15, 0xFD, 0xF1, 0xF1, 0xFB, 0x03, 0x02,
	0xF9, 0xF0, 0xF4, 0x04, 0x11, 0x17, 0x0B, 0xFA, 0xF0, 0xEC, 0xEA, 0xF1, 0xF9, 0xFD, 0xF9, 0xF1,
	0xEF, 0xF5, 0x02, 0x14, 0x12, 0xFD, 0xEB, 0xE3, 0xEC, 0xFB, 0x00, 0xFB, 0xF3, 0xE8, 0xE7, 0xEC,
	0xF8, 0x04, 0x08, 0x0B, 0x03, 0xF3, 0xF3, 0x02, 0x10, 0x13, 0x04, 0xF4, 0xF1, 0x00, 0x17, 0x28,
	0x28, 0x1F, 0x12, 0x0B, 0x0D, 0x0B, 0x08, 0x06, 0xF8, 0xE8, 0xE3, 0xEC, 0x07, 0x1F, 0x26, 0x19,
	0xFF, 0xF2, 0xF6, 0xFE, 0x04, 0xF8, 0xE4, 0xDC, 0xE0, 0xF1, 0x0B, 0x1D, 0x23, 0x17, 0x01, 0xF1,
	0xE7, 0xE8, 0xF3, 0xEF, 0xDF, 0xD3, 0xD5, 0xEF, 0x0F, 0x21, 0x1F, 0x0D, 0xF7, 0xEC, 0xEB, 0xF2,
	0xF6, 0xF1, 0xED, 0xEE, 0xF0, 0x01, 0x1B, 0x2A, 0x2B, 0x14, 0xFD, 0xF2, 0xF6, 0x00, 0x07, 0x00,
	0xFB, 0xF7, 0x02, 0x18, 0x28, 0x2D, 0x2A, 0x1A, 0x05, 0xF6, 0xF1, 0xFB, 0x01, 0xFF, 0xF3, 0xE7,
	0xEB, 0x01, 0x14, 0x1F, 0x19, 0x00, 0xEC, 0xE4, 0xE2, 0xEA, 0xF3, 0xF8, 0xF8, 0xF3, 0xF3, 0xFB,
	0x09, 0x1B, 0x1C, 0x07, 0xF1, 0xE0, 0xE2, 0xF2, 0xFA, 0xF8, 0xF1, 0xE8, 0xE7, 0xEE, 0xF9, 0x06,
	0x09, 0x09, 0x06, 0xF7, 0xF1, 0xFD, 0x08, 0x0F, 0x04, 0xF6, 0xF3, 0x03, 0x1A, 0x29, 0x26, 0x19,
	0x09, 0x03, 0x0A, 0x0F, 0x09, 0x04, 0xF8, 0xEB, 0xE8, 0xF2, 0x09, 0x1E, 0x25, 0x17, 0xFB, 0xEB,
	0xF2, 0x01, 0x0C, 0x05, 0xEB, 0xD8, 0xDA, 0xEC, 0x06, 0x1B, 0x1F, 0x13, 0xFF, 0xF1, 0xE7, 0xE7,
	0xF2, 0xF7, 0xE8, 0xDA, 0xD5, 0xE9, 0x0C, 0x23, 0x25, 0x15, 0xFC, 0xF1, 0xED, 0xF1, 0xF4, 0xE8,
	0xE4, 0xE9, 0xEF, 0xFB, 0x12, 0x1F, 0x23, 0x15, 0x02, 0xF7, 0xFC, 0x05, 0x0D, 0x04, 0xF9, 0xF3,
	0xFB, 0x16, 0x2A, 0x30, 0x2A, 0x1B, 0x05, 0xF8, 0xF4, 0xFD, 0x03, 0x02, 0xF5, 0xE7, 0xE3, 0xF8,
	0x11, 0x21, 0x1E, 0x05, 0xED, 0xE4, 0xE3, 0xEC, 0xF6, 0xFD, 0xFC, 0xF4, 0xF3, 0xF3, 0xFB, 0x0E,
	0x18, 0x0B, 0xF5, 0xE4, 0xE5, 0xF5, 0xFF, 0xFB, 0xF0, 0xE5, 0xE6, 0xF1, 0xFF, 0x0A, 0x09, 0x09,
	0x08, 0xFD, 0xF4, 0xFA, 0x05, 0x0A, 0x00, 0xF1, 0xEC, 0xFD, 0x19, 0x2D, 0x2A, 0x18, 0x03, 0xFC,
	0x0A, 0x13, 0x12, 0x0B, 0x02, 0xF6, 0xF0, 0xF5, 0x08, 0x19, 0x21, 0x14, 0xF8, 0xE6, 0xEC, 0x01,
	0x10, 0x0A, 0xEC, 0xD5, 0xD8, 0xE9, 0x03, 0x13, 0x19, 0x11, 0x03, 0xF7, 0xEF, 0xED, 0xF6, 0xFC,
	0xEE, 0xDC, 0xD6, 0xE3, 0x01, 0x1A, 0x1B, 0x0A, 0xF5, 0xED, 0xEE, 0xF2, 0xF4, 0xEA, 0xE7, 0xED,
	0xF5, 0xFF, 0x11, 0x20, 0x25, 0x1B, 0x0A, 0x02, 0x03, 0x0C, 0x10, 0x03, 0xF4, 0xEC, 0xF5, 0x0F,
	0x25, 0x27, 0x21, 0x17, 0x09, 0xFB, 0xF7, 0xFD, 0x01, 0x01, 0xF9, 0xEC, 0xEA, 0xFD, 0x17, 0x26,
	0x22, 0x07, 0xEC, 0xE3, 0xE2, 0xE7, 0xEE, 0xF8, 0xFD, 0xF9, 0xF7, 0xF3, 0xF7, 0x07, 0x15, 0x0D,
	0xF7, 0xE5, 0xE1, 0xEF, 0xFD, 0xFF, 0xF8, 0xF3, 0xF3, 0xF5, 0xF8, 0xFD, 0xFD, 0x00, 0x03, 0xFC,
	0xF1, 0xEF, 0xFD, 0x06, 0x04, 0xF8, 0xF4, 0x01, 0x19, 0x27, 0x25, 0x15, 0x05, 0x01, 0x0F, 0x18,
	0x15, 0x0D, 0x07, 0x02, 0xFA, 0xF9, 0x03, 0x10, 0x19, 0x13, 0xFB, 0xE7, 0xE9, 0xFD, 0x0F, 0x0F,
	0xF4, 0xDC, 0xD7, 0xE6, 0xF9, 0x09, 0x12, 0x13, 0x08, 0xFD, 0xF3, 0xEE, 0xF8, 0x04, 0xFF, 0xEA,
	0xDB, 0xDD, 0xF4, 0x0D, 0x14, 0x0A, 0xFD, 0xF5, 0xF3, 0xF3, 0xF3, 0xEA, 0xE7, 0xEF, 0xF6, 0xF9,
	0x00, 0x0F, 0x19, 0x19, 0x10, 0x06, 0x04, 0x0D, 0x11, 0x06, 0xF6, 0xEF, 0xF4, 0x0D, 0x21, 0x27,
	0x22, 0x1A, 0x11, 0x04, 0xFB, 0xFB, 0x01, 0x02, 0xFB, 0xEC, 0xE5, 0xF3, 0x0D, 0x21, 0x22, 0x0E,
	0xF5, 0xE8, 0xE7, 0xEB, 0xEF, 0xF7, 0xFB, 0xF9, 0xF4, 0xF0, 0xF2, 0x02, 0x13, 0x13, 0xFD, 0xE8,
	0xE0, 0xE8, 0xF6, 0xFD, 0xFA, 0xF7, 0xF8, 0xFB, 0xFE, 0xFF, 0xFE, 0x00, 0x05, 0x02, 0xF4, 0xED,
	0xF5, 0x01, 0x05, 0xFE, 0xF9, 0xFF, 0x0F, 0x1B, 0x19, 0x0B, 0x00, 0x00, 0x0D, 0x1A, 0x1A, 0x13,
	0x0E, 0x09, 0xFF, 0xFB, 0x01, 0x10, 0x1C, 0x1A, 0x04, 0xEB, 0xE8, 0xFB, 0x0C, 0x0E, 0xF8, 0xE0,
	0xD8, 0xE3, 0xF5, 0x05, 0x11, 0x14, 0x0E, 0xFF, 0xF3, 0xE9, 0xF0, 0xFE, 0x03, 0xF3, 0xE3, 0xE1,
	0xF0, 0x03, 0x0E, 0x09, 0xFD, 0xF6, 0xF1, 0xED, 0xEA, 0xE7, 0xE9, 0xF6, 0xFD, 0xFD, 0xFF, 0x0B,
	0x16, 0x18, 0x11, 0x08
};

const uint8_t SfxPlayer::_musicDataSample4[] = {
	0x01, 0xF8, 0x00, 0x40, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x0E, 0x0D, 0xF4, 0x0F, 0xFF, 0x0C,
	0x10, 0xE1, 0xC9, 0xD5, 0xF2, 0x17, 0x2C, 0x05, 0x1B, 0x50, 0x1D, 0x1F, 0x40, 0x1B, 0x09, 0x2B,
	0xFE, 0xE0, 0x0A, 0x27, 0xDF, 0xEB, 0x1F, 0x41, 0x56, 0x2E, 0x06, 0xEC, 0xC0, 0xA7, 0xCF, 0xE5,
	0x24, 0x2C, 0x2B, 0x53, 0x36, 0x2C, 0x15, 0x1F, 0x1E, 0x18, 0x18, 0x15, 0xD9, 0xD6, 0x03, 0xEE,
	0xEF, 0x3F, 0x38, 0x36, 0x36, 0x0F, 0xE8, 0xC9, 0xC6, 0xE0, 0x21, 0xF7, 0x08, 0x3C, 0x45, 0x14,
	0x33, 0x37, 0x2A, 0x17, 0x03, 0x21, 0x10, 0x15, 0xFC, 0xCD, 0xD5, 0xF6, 0x12, 0x46, 0x24, 0xFC,
	0xF3, 0x22, 0x0A, 0xD7, 0xE8, 0x02, 0xF9, 0x0C, 0x3D, 0x46, 0x25, 0x16, 0x30, 0x0C, 0xF2, 0x16,
	0x35, 0xF8, 0xF1, 0x01, 0x03, 0x07, 0xF6, 0x11, 0x08, 0x0E, 0x14, 0x1F, 0x0F, 0xF5, 0xFD, 0x03,
	0x0E, 0xE3, 0x11, 0x2B, 0x26, 0x23, 0x21, 0x18, 0xFF, 0x11, 0x0C, 0x08, 0x07, 0x05, 0x06, 0x0A,
	0x18, 0x0F, 0x0F, 0x0E, 0x0C, 0x05, 0x12, 0x2C, 0x01, 0xFD, 0x05, 0xF6, 0xF6, 0x15, 0x29, 0x1B,
	0x0C, 0x09, 0x2A, 0x12, 0x08, 0x14, 0x00, 0xF8, 0x03, 0x26, 0x14, 0x11, 0x0C, 0x1E, 0x00, 0xFA,
	0x14, 0x15, 0x0A, 0x04, 0x07, 0x05, 0x08, 0x09, 0x18, 0x03, 0x09, 0x1A, 0x1A, 0x21, 0x12, 0x11,
	0x06, 0x01, 0x0C, 0xF3, 0x1D, 0x1F, 0x15, 0x10, 0x11, 0x10, 0x05, 0x06, 0x15, 0x02, 0xF7, 0x0C,
	0x17, 0x16, 0x01, 0xFB, 0x09, 0x01, 0x13, 0x2D, 0x28, 0x0E, 0x07, 0x1C, 0xFB, 0x01, 0x17, 0x19,
	0x02, 0x07, 0x15, 0x14, 0x0D, 0x14, 0xFD, 0xF6, 0x05, 0x16, 0x23, 0x10, 0x0E, 0x08, 0xFD, 0x09,
	0x0B, 0x16, 0x1A, 0x11, 0x13, 0x07, 0x10, 0x18, 0x0B, 0x02, 0x0D, 0x0E, 0x13, 0x1E, 0x23, 0x0C,
	0xF8, 0x00, 0x05, 0x09, 0x06, 0x1A, 0x1B, 0x01, 0x0C, 0x0C, 0x08, 0x0C, 0x17, 0x18, 0x08, 0x0C,
	0x19, 0x13, 0x06, 0x06, 0x04, 0x04, 0x11, 0x23, 0x21, 0x14, 0x0C, 0x09, 0x03, 0x08, 0x0E, 0x12,
	0x08, 0x0A, 0x0A, 0x02, 0x10, 0x15, 0x0C, 0x0A, 0x0F, 0x16, 0x1F, 0x1C, 0x14, 0x05, 0xF5, 0x02,
	0x16, 0x14, 0x17, 0x1C, 0x1B, 0x08, 0x06, 0x0F, 0x0A, 0x03, 0x0C, 0x14, 0x09, 0x0E, 0x1B, 0x09,
	0xFB, 0x05, 0x0F, 0x10, 0x1D, 0x21, 0x1B, 0x09, 0x09, 0x02, 0x06, 0x07, 0x0E, 0x16, 0x10, 0x15,
	0x17, 0x0E, 0x0D, 0x0A, 0x08, 0x02, 0x0F, 0x21, 0x16, 0x0C, 0x09, 0x03, 0xFC, 0x07, 0x19, 0x19,
	0x0F, 0x22, 0x17, 0x06, 0x03, 0x0C, 0x0D, 0xFE, 0x11, 0x1C, 0x13, 0x14, 0x17, 0x0D, 0xFC, 0xFD,
	0x16, 0x16, 0x14, 0x19, 0x10, 0x02, 0x00, 0x0A, 0x0C, 0x0A, 0x17, 0x15, 0x16, 0x11, 0x12, 0x14,
	0x04, 0xFF, 0x0C, 0x10, 0x11, 0x1D, 0x1A, 0x0A, 0x06, 0x0E, 0x00, 0x07, 0x16, 0x12, 0x0F, 0x0F,
	0x12, 0x07, 0x02, 0x13, 0x0A, 0x09, 0x15, 0x1B, 0x19, 0x0D, 0x0C, 0x07, 0x00, 0x07, 0x15, 0x17,
	0x10, 0x14, 0x19, 0x06, 0x02, 0x10, 0x0C, 0x0A, 0x0F, 0x15, 0x11, 0x0C, 0x12, 0x0D, 0x06, 0x06,
	0x0E, 0x17, 0x13, 0x12, 0x16, 0x0A, 0x06, 0x0E, 0x12, 0x0C, 0x13, 0x1C, 0x0C, 0x0C, 0x14, 0x0C,
	0x07, 0x0F, 0x0D, 0x07, 0x0F, 0x19, 0x11, 0x0F, 0x10, 0x0D, 0x09, 0x0B, 0x13, 0x14, 0x10, 0x0E,
	0x11, 0x0A, 0x07, 0x0B, 0x17, 0x0F, 0x0D, 0x17, 0x14, 0x0B, 0x10, 0x11, 0x06, 0x06, 0x10, 0x13,
	0x0F, 0x10, 0x13, 0x0E, 0x07, 0x0E, 0x13, 0x0E, 0x0D, 0x13, 0x0F, 0x0E, 0x15, 0x11, 0x0B, 0x0D,
	0x0F, 0x0A, 0x0E, 0x14, 0x14, 0x0C, 0x0F, 0x0B, 0x0B, 0x11, 0x13, 0x10, 0x0C, 0x0B, 0x0F, 0x10
};

const uint8_t SfxPlayer::_musicDataSample5[] = {
	0x09, 0xE4, 0x00, 0x40, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
	0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x08, 0x0C, 0x0C, 0x0C, 0x10, 0x14, 0x28, 0x28, 0x28,
	0x28, 0x2C, 0x28, 0x24, 0x24, 0x1C, 0x1C, 0x1C, 0x10, 0x14, 0x14, 0x10, 0x10, 0x08, 0x08, 0x04,
	0x0C, 0x00, 0x0C, 0x04, 0x04, 0x04, 0x14, 0x04, 0x00, 0x14, 0x1C, 0x0C, 0x00, 0xF4, 0xE4, 0xC4,
	0xB8, 0xB4, 0xB0, 0xA8, 0xA4, 0xA0, 0xA0, 0xA0, 0xA4, 0xB0, 0xC4, 0xCC, 0xD4, 0xDC, 0xE0, 0xE8,
	0xEC, 0xF4, 0xF8, 0xFC, 0x04, 0x04, 0x24, 0x3C, 0x3C, 0x44, 0x50, 0x5C, 0x5C, 0x5C, 0x64, 0x68,
	0x68, 0x5C, 0x64, 0x64, 0x6C, 0x68, 0x6C, 0x78, 0x74, 0x68, 0x64, 0x6C, 0x6C, 0x58, 0x68, 0x58,
	0x34, 0x38, 0x48, 0x58, 0x58, 0x3C, 0x08, 0xDC, 0xC4, 0x9C, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x8C, 0x98, 0x9C, 0xA4, 0xA8, 0xBC, 0xD0, 0xD8, 0xF0, 0x08, 0x0C,
	0x0C, 0x10, 0x18, 0x20, 0x28, 0x48, 0x5C, 0x6C, 0x7C, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C, 0x7F,
	0x7F, 0x74, 0x68, 0x5C, 0x4C, 0x3C, 0x2C, 0x28, 0x2C, 0x30, 0x34, 0x34, 0x24, 0x1C, 0x14, 0x1C,
	0x20, 0x20, 0x0C, 0x00, 0xF4, 0xE4, 0xCC, 0xBC, 0xB4, 0xB4, 0xA8, 0x94, 0x80, 0x80, 0x80, 0x80,
	0x84, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x84, 0x84, 0x8C, 0xA0, 0xC0, 0xD4, 0xD0, 0xE4, 0xEC, 0xF0,
	0xF8, 0x10, 0x20, 0x4C, 0x64, 0x68, 0x6C, 0x78, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x6C, 0x64, 0x58,
	0x34, 0x2C, 0x34, 0x38, 0x2C, 0x14, 0x14, 0x20, 0x2C, 0x38, 0x34, 0x34, 0x3C, 0x3C, 0x3C, 0x2C,
	0x38, 0x54, 0x70, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x74, 0x78, 0x78, 0x7C, 0x6C, 0x74, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x74, 0x4C, 0x4C, 0x4C, 0x30, 0x14, 0x14, 0x04, 0x10, 0x1C, 0xF4, 0xCC, 0xAC, 0x84, 0x88, 0x80,
	0x80, 0x80, 0x84, 0xA8, 0x80, 0x80, 0x80, 0x84, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xAC,
	0x80, 0x80, 0xA4, 0xFC, 0x14, 0x00, 0x00, 0xF8, 0x3C, 0x70, 0x64, 0x30, 0xEC, 0x34, 0x7F, 0x44,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x70, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x70, 0x68, 0x4C, 0x68, 0x7F, 0x7F, 0x7F, 0x48, 0x3C, 0x44, 0x2C, 0x5C,
	0x68, 0x30, 0x18, 0x30, 0xF8, 0x44, 0x4C, 0x54, 0x48, 0x20, 0x14, 0xEC, 0xE0, 0xF4, 0x0C, 0x20,
	0xFC, 0x1C, 0x1C, 0x04, 0x5C, 0x3C, 0x14, 0x40, 0xCC, 0xBC, 0xF4, 0x00, 0x2C, 0xEC, 0xEC, 0x84,
	0x80, 0x9C, 0xCC, 0x90, 0x80, 0x8C, 0x80, 0x80, 0x80, 0xB4, 0xEC, 0x90, 0xC4, 0x38, 0xAC, 0xBC,
	0xAC, 0x80, 0x84, 0xA4, 0x94, 0xCC, 0xCC, 0xD4, 0x10, 0x94, 0xA4, 0xDC, 0xAC, 0xCC, 0x08, 0xF4,
	0xE4, 0x04, 0xEC, 0x4C, 0x0C, 0x04, 0x34, 0x28, 0x24, 0x50, 0x28, 0x18, 0x1C, 0x00, 0x0C, 0x1C,
	0x48, 0x74, 0x54, 0x3C, 0x1C, 0xE0, 0xCC, 0x04, 0xD8, 0xD4, 0xD8, 0xF4, 0x48, 0x44, 0x3C, 0x54,
	0x3C, 0x7F, 0x40, 0x1C, 0x6C, 0x6C, 0x7F, 0x7F, 0x5C, 0x64, 0x48, 0x50, 0x20, 0x00, 0x30, 0x0C,
	0x14, 0x28, 0x2C, 0x50, 0x70, 0x6C, 0x54, 0x54, 0x6C, 0x54, 0x28, 0x5C, 0x3C, 0x7F, 0x74, 0x7F,
	0x7F, 0x5C, 0x7C, 0x58, 0x58, 0x3C, 0xD8, 0x10, 0xCC, 0xCC, 0xA0, 0x88, 0xA4, 0xBC, 0x8C, 0xCC,
	0xF0, 0xC8, 0xB0, 0x8C, 0xBC, 0xD4, 0x80, 0x80, 0x94, 0x94, 0x84, 0xA8, 0x80, 0xF8, 0xD0, 0xE0,
	0xBC, 0x80, 0x80, 0xB4, 0x84, 0xD4, 0x9C, 0xA0, 0xD4, 0xC8, 0x00, 0xCC, 0x14, 0xD4, 0x08, 0xE8,
	0x44, 0x4C, 0xEC, 0x10, 0x1C, 0x04, 0x24, 0x50, 0x2C, 0x54, 0x64, 0x74, 0x3C, 0x24, 0x00, 0x20,
	0x24, 0x50, 0x78, 0x68, 0x24, 0x28, 0x44, 0x5C, 0x58, 0x54, 0x5C, 0x7C, 0x7F, 0x64, 0xFC, 0x2C,
	0x08, 0x58, 0x24, 0x50, 0xD4, 0x04, 0x48, 0x4C, 0x50, 0x4C, 0xE0, 0xDC, 0xDC, 0x4C, 0xD8, 0x28,
	0x60, 0xC8, 0x2C, 0xCC, 0x94, 0xC0, 0x5C, 0x54, 0x44, 0x1C, 0xEC, 0x24, 0xF0, 0xCC, 0x1C, 0xE4,
	0x7F, 0x1C, 0xD4, 0xAC, 0xA0, 0x9C, 0xEC, 0xD8, 0x1C, 0xF8, 0x20, 0x04, 0xD8, 0xD8, 0xE4, 0xC4,
	0x14, 0xCC, 0xD4, 0xD0, 0xA0, 0xDC, 0xB8, 0x80, 0xE8, 0x00, 0x2C, 0xEC, 0xE4, 0x24, 0x7F, 0xE8,
	0x14, 0xD4, 0xDC, 0xF4, 0xEC, 0x44, 0x74, 0x1C, 0xA0, 0x9C, 0xCC, 0xCC, 0x04, 0xC4, 0x14, 0x6C,
	0x7F, 0x10, 0xA0, 0x1C, 0x7F, 0x58, 0x44, 0x58, 0x4C, 0x1C, 0x08, 0x34, 0xF4, 0xCC, 0x10, 0xE4,
	0xF8, 0x50, 0x18, 0x10, 0x3C, 0x0C, 0x30, 0x44, 0xCC, 0xD4, 0x48, 0x70, 0xC8, 0x20, 0x54, 0x0C,
	0xD0, 0xF8, 0x60, 0xAC, 0xE4, 0xE8, 0x38, 0xE8, 0xFC, 0xF4, 0xD4, 0x34, 0x54, 0x0C, 0x14, 0x74,
	0x44, 0x14, 0x0C, 0x00, 0x0C, 0xC8, 0x34, 0x54, 0x6C, 0x7F, 0x30, 0xE8, 0x18, 0xD0, 0xB0, 0x08,
	0x20, 0xD0, 0x38, 0x34, 0xCC, 0x7F, 0x1C, 0x14, 0x2C, 0x30, 0xDC, 0xE0, 0xF4, 0x34, 0x28, 0xC8,
	0xAC, 0xA8, 0x14, 0xAC, 0x90, 0xBC, 0xCC, 0xD4, 0xD4, 0xD4, 0xE4, 0x0C, 0x14, 0xFC, 0xD0, 0xEC,
	0x1C, 0x24, 0x0C, 0x08, 0xEC, 0x14, 0x70, 0x2C, 0xC4, 0x84, 0xCC, 0xA4, 0x2C, 0x24, 0xA0, 0x0C,
	0x74, 0x04, 0xE4, 0x0C, 0x04, 0xDC, 0x1C, 0xF4, 0xD4, 0xFC, 0xCC, 0x94, 0xD4, 0x54, 0x24, 0x08,
	0xCC, 0xD4, 0xF4, 0x44, 0x54, 0x0C, 0x18, 0x28, 0xF0, 0x18, 0x68, 0x28, 0x60, 0x6C, 0x44, 0xC4,
	0x14, 0x64, 0x74, 0x7C, 0x5C, 0x7F, 0x7F, 0x7F, 0x20, 0x58, 0x7F, 0x28, 0x7F, 0x58, 0x68, 0x18,
	0x54, 0x04, 0x08, 0xE4, 0x14, 0x34, 0x08, 0xDC, 0xE4, 0x08, 0x3C, 0x24, 0xAC, 0xEC, 0xF4, 0xCC,
	0xF4, 0x1C, 0xE4, 0x0C, 0xF4, 0xD0, 0xE8, 0xD0, 0xDC, 0xBC, 0xA0, 0xEC, 0xB4, 0xB4, 0x28, 0xD8,
	0xF4, 0xDC, 0xBC, 0x28, 0x44, 0xF0, 0xF8, 0xE0, 0xFC, 0xC8, 0x1C, 0x4C, 0xEC, 0x00, 0xF8, 0x00,
	0xC8, 0xCC, 0xDC, 0xBC, 0xD0, 0xAC, 0xE0, 0xCC, 0xF4, 0xF8, 0xF0, 0x08, 0x10, 0x1C, 0xEC, 0x30,
	0x28, 0x44, 0x34, 0x90, 0x34, 0x3C, 0xC4, 0xE0, 0xCC, 0x00, 0x34, 0xF8, 0x34, 0xB4, 0x34, 0x3C,
	0x34, 0xEC, 0xFC, 0x7C, 0x34, 0xCC, 0x0C, 0x4C, 0x10, 0x44, 0x20, 0x14, 0x3C, 0x78, 0x64, 0x50,
	0x20, 0x4C, 0x7F, 0x20, 0x24, 0x34, 0x0C, 0x1C, 0x28, 0x04, 0x48, 0x04, 0x5C, 0x60, 0x10, 0x1C,
	0x18, 0x10, 0xEC, 0x20, 0x10, 0xAC, 0xE0, 0x10, 0x0C, 0xD0, 0xCC, 0x24, 0xE4, 0xBC, 0xE8, 0x58,
	0x00, 0xBC, 0x00, 0x4C, 0xF4, 0xBC, 0xF4, 0x28, 0xDC, 0xB4, 0xEC, 0x24, 0xF0, 0x04, 0xE4, 0xB0,
	0xF0, 0xB0, 0xC8, 0x3C, 0x2C, 0xB8, 0xB8, 0xDC, 0xF0, 0x10, 0xD8, 0xEC, 0x2C, 0x08, 0xF8, 0xC8,
	0xF4, 0x2C, 0x0C, 0x0C, 0x10, 0xE0, 0xDC, 0x28, 0x1C, 0x20, 0x38, 0xFC, 0x34, 0xF4, 0x08, 0x3C,
	0x64, 0x2C, 0xC4, 0xE4, 0xE4, 0xCC, 0x08, 0x7F, 0x3C, 0xEC, 0x14, 0xD8, 0x14, 0x48, 0x1C, 0x74,
	0x1C, 0x18, 0x74, 0x34, 0xF4, 0xE0, 0x44, 0x44, 0x58, 0x4C, 0x50, 0x28, 0x4C, 0x48, 0x08, 0x08,
	0x40, 0x64, 0x3C, 0x2C, 0x14, 0x4C, 0x40, 0x5C, 0x10, 0xFC, 0x3C, 0x28, 0xF4, 0xF4, 0x08, 0xEC,
	0x00, 0x34, 0x28, 0x80, 0xF0, 0xDC, 0xF4, 0xFC, 0xD4, 0xF0, 0x34, 0xE8, 0xEC, 0xBC, 0x90, 0x88,
	0x34, 0xF4, 0x9C, 0xAC, 0xC4, 0xDC, 0xD4, 0xCC, 0xF4, 0xE4, 0xE4, 0x2C, 0xD4, 0x08, 0xEC, 0x3C,
	0x10, 0x14, 0x24, 0x00, 0x44, 0x34, 0x2C, 0xF8, 0x0C, 0x1C, 0x44, 0x5C, 0xFC, 0x24, 0x14, 0xD4,
	0x24, 0x7F, 0xF0, 0x34, 0xE4, 0xC8, 0xE8, 0xF0, 0x2C, 0xDC, 0x0C, 0x28, 0xA4, 0xBC, 0x14, 0x60,
	0xF4, 0x2C, 0xF4, 0xE8, 0x14, 0xE8, 0x1C, 0x04, 0x28, 0x60, 0x0C, 0x0C, 0x28, 0x44, 0x3C, 0x18,
	0x4C, 0x4C, 0x68, 0x04, 0xE8, 0x28, 0x0C, 0x2C, 0x7C, 0x58, 0x5C, 0x4C, 0x68, 0x7F, 0x60, 0x6C,
	0x30, 0xEC, 0x0C, 0xFC, 0xE0, 0x30, 0x34, 0x00, 0x08, 0x1C, 0xF8, 0xAC, 0xCC, 0x0C, 0x08, 0x2C,
	0xE8, 0x08, 0x0C, 0xB4, 0xD4, 0xC4, 0x00, 0xEC, 0xCC, 0xE4, 0x10, 0xE4, 0xF8, 0xA0, 0xAC, 0xD0,
	0xF4, 0x14, 0x04, 0xC4, 0xE8, 0xDC, 0x00, 0x08, 0xF0, 0xD0, 0xD8, 0xD4, 0x10, 0xE0, 0x08, 0x1C,
	0xF8, 0xCC, 0xF4, 0xF8, 0x14, 0x04, 0x1C, 0x20, 0x04, 0xD8, 0xEC, 0x00, 0x14, 0x14, 0xEC, 0x24,
	0xF4, 0x10, 0x04, 0xC4, 0x14, 0x30, 0x28, 0x3C, 0xCC, 0x30, 0x44, 0x44, 0x10, 0x3C, 0x4C, 0x0C,
	0x4C, 0x2C, 0x48, 0x50, 0x5C, 0x2C, 0x24, 0x7F, 0x48, 0x4C, 0x24, 0x30, 0x18, 0x40, 0x24, 0x0C,
	0xF4, 0x44, 0x30, 0x48, 0x28, 0x18, 0xFC, 0xDC, 0xDC, 0x34, 0xFC, 0xE8, 0xEC, 0x4C, 0x50, 0xF4,
	0xE8, 0x20, 0x18, 0x0C, 0x20, 0x20, 0x2C, 0xE8, 0xEC, 0x10, 0xE0, 0xFC, 0x1C, 0x3C, 0x24, 0x1C,
	0x3C, 0x1C, 0x0C, 0x1C, 0xBC, 0xAC, 0x04, 0x50, 0x14, 0xE4, 0xF8, 0xEC, 0xCC, 0xE4, 0xD4, 0xE0,
	0xD8, 0xF4, 0xF4, 0xD4, 0xB4, 0xBC, 0xC8, 0xFC, 0xCC, 0xD0, 0xEC, 0xE4, 0xF0, 0xEC, 0xCC, 0xD0,
	0xE0, 0x94, 0xB8, 0xE8, 0x24, 0x04, 0xCC, 0x0C, 0xE4, 0xEC, 0xD4, 0x00, 0xE4, 0x08, 0x18, 0x00,
	0xEC, 0xEC, 0xEC, 0x28, 0xD4, 0xEC, 0x2C, 0x44, 0x44, 0x2C, 0x30, 0x54, 0x78, 0x70, 0x3C, 0x34,
	0x7C, 0x7F, 0x44, 0x2C, 0x5C, 0x54, 0x4C, 0x44, 0x5C, 0x20, 0x14, 0x1C, 0x5C, 0x78, 0x34, 0x3C,
	0x34, 0x40, 0x40, 0x54, 0x3C, 0x04, 0x14, 0x14, 0x2C, 0x2C, 0x2C, 0x2C, 0x0C, 0xD4, 0x34, 0x08,
	0xE4, 0x00, 0x14, 0x14, 0x04, 0x0C, 0xDC, 0xE4, 0xF4, 0x24, 0xEC, 0xC8, 0xB4, 0xCC, 0xD8, 0xBC,
	0xD0, 0xE0, 0xEC, 0xC4, 0xF8, 0xC4, 0xE4, 0xD4, 0xC4, 0x14, 0xF4, 0xDC, 0xDC, 0xB0, 0xA0, 0xE4,
	0x0C, 0xF8, 0x0C, 0xEC, 0xB4, 0xAC, 0xEC, 0x0C, 0xD8, 0x1C, 0x30, 0x3C, 0x0C, 0xD4, 0x0C, 0xF8,
	0xF4, 0xFC, 0x28, 0x3C, 0x28, 0x30, 0x3C, 0x38, 0x04, 0x04, 0xF4, 0x18, 0x50, 0x0C, 0xF8, 0x24,
	0xF0, 0x34, 0x20, 0x0C, 0x08, 0xF4, 0x18, 0xD8, 0xDC, 0x14, 0x24, 0xEC, 0x04, 0x2C, 0xF8, 0x30,
	0x1C, 0x2C, 0x0C, 0x0C, 0x1C, 0x18, 0x24, 0x34, 0x3C, 0x2C, 0x38, 0x3C, 0x1C, 0x38, 0x3C, 0x28,
	0x58, 0x54, 0x24, 0x24, 0x44, 0x30, 0x10, 0xEC, 0x2C, 0x1C, 0x1C, 0x14, 0xF8, 0x0C, 0x08, 0x00,
	0x04, 0xF8, 0xE8, 0x00, 0x14, 0xDC, 0xF4, 0xE4, 0xDC, 0xF0, 0xF4, 0xEC, 0xE4, 0x20, 0x1C, 0xE4,
	0x00, 0xDC, 0xF4, 0xF4, 0xE8, 0xF8, 0x28, 0x14, 0x00, 0x04, 0x5C, 0x1C, 0xE0, 0x04, 0xF0, 0xF4,
	0x0C, 0x24, 0xE4, 0xF0, 0xDC, 0xF4, 0xF8, 0xE0, 0x0C, 0xEC, 0xEC, 0xF8, 0xE4, 0xD4, 0x08, 0x04,
	0xE4, 0xF0, 0x14, 0xF4, 0xF4, 0xF0, 0x08, 0x08, 0x04, 0x04, 0xE4, 0xE8, 0xFC, 0x14, 0x14, 0x0C,
	0x24, 0x2C, 0x34, 0x14, 0x0C, 0x0C, 0x2C, 0x14, 0xF8, 0x1C, 0x10, 0x0C, 0x14, 0x14, 0x1C, 0x44,
	0x30, 0x14, 0x1C, 0x04, 0x24, 0x44, 0x18, 0x24, 0x1C, 0xFC, 0xF0, 0xEC, 0xFC, 0xEC, 0x0C, 0xF8,
	0x04, 0xFC, 0xF0, 0xE8, 0x0C, 0x2C, 0x20, 0xE4, 0xFC, 0x18, 0xF4, 0xFC, 0x0C, 0x18, 0x08, 0xF0,
	0x04, 0x0C, 0x00, 0x0C, 0x0C, 0x28, 0x1C, 0xF4, 0x08, 0x0C, 0x10, 0x14, 0x1C, 0x28, 0x2C, 0xFC,
	0x1C, 0x18, 0x10, 0x04, 0x0C, 0x24, 0x34, 0x14, 0x0C, 0x1C, 0x1C, 0x00, 0xE4, 0xFC, 0x0C, 0x28,
	0xF0, 0xEC, 0xE8, 0xFC, 0x00, 0xE4, 0x00, 0xF4, 0x24, 0x18, 0xE0, 0x0C, 0xFC, 0xF0, 0x14, 0x04,
	0x14, 0xE8, 0xEC, 0x0C, 0x08, 0x10, 0x00, 0xF0, 0xEC, 0x04, 0x14, 0xEC, 0x1C, 0x10, 0x0C, 0x14,
	0xE0, 0xF4, 0x00, 0x18, 0x04, 0xFC, 0xE4, 0xE4, 0xE0, 0x00, 0x04, 0xF0, 0xF0, 0x10, 0x00, 0x04,
	0x10, 0x0C, 0x1C, 0x08, 0x00, 0x10, 0x04, 0x0C, 0xF8, 0x04, 0x14, 0x04, 0xFC, 0x20, 0x24, 0x14,
	0x1C, 0x2C, 0x1C, 0xF0, 0x28, 0x44, 0x0C, 0x14, 0x40, 0x34, 0x1C, 0x08, 0x0C, 0x28, 0x20, 0x20,
	0x14, 0x0C, 0x04, 0x0C, 0x2C, 0x1C, 0x0C, 0x04, 0x10, 0x18, 0x14, 0x10, 0x2C, 0x2C, 0x1C, 0x04,
	0x00, 0xFC, 0x18, 0x10, 0x1C, 0x24, 0x0C, 0x28, 0x14, 0x04, 0xF8, 0x1C, 0x0C, 0x18, 0x18, 0xF8,
	0xFC, 0x08, 0xD4, 0xFC, 0xEC, 0xE4, 0xE0, 0xF4, 0x0C, 0xE8, 0xE8, 0xE8, 0xBC, 0xEC, 0x04, 0xEC,
	0xEC, 0xE0, 0xE4, 0x04, 0x10, 0x0C, 0xF8, 0xF8, 0xEC, 0xDC, 0xF4, 0x0C, 0x0C, 0xF4, 0x0C, 0x04,
	0xF0, 0xFC, 0x0C, 0x20, 0x14, 0x1C, 0x28, 0x34, 0x28, 0x18, 0x20, 0x54, 0x3C, 0x1C, 0x24, 0x24,
	0x28, 0x3C, 0x28, 0x1C, 0x18, 0x1C, 0x14, 0x00, 0x0C, 0x14, 0xF0, 0xFC, 0x24, 0x0C, 0x00, 0xF4,
	0x04, 0x24, 0x1C, 0xF4, 0x08, 0xEC, 0xF4, 0x0C, 0xF8, 0xEC, 0xF4, 0x0C, 0xF4, 0xEC, 0xEC, 0x18,
	0x18, 0x08, 0xE0, 0xF4, 0x0C, 0x20, 0x0C, 0x00, 0x00, 0x10, 0x1C, 0x00, 0xEC, 0x0C, 0x10, 0x14,
	0x10, 0x0C, 0xF8, 0xF8, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x04, 0x1C, 0x30, 0x24, 0x0C, 0xE4, 0xF4,
	0x08, 0x14, 0x0C, 0x00, 0x00, 0x0C, 0x08, 0x00, 0xEC, 0x04, 0x1C, 0x14, 0x08, 0x1C, 0x24, 0x2C,
	0x18, 0x10, 0x20, 0x0C, 0x20, 0x3C, 0x24, 0x20, 0x20, 0x38, 0x38, 0x18, 0x14, 0x1C, 0x18, 0x24,
	0x2C, 0x0C, 0x14, 0x24, 0x00, 0xEC, 0xF4, 0xEC, 0xD8, 0xD8, 0xE8, 0xE0, 0xB4, 0xC4, 0xF0, 0xEC,
	0xD0, 0xD4, 0xE0, 0xE4, 0xE0, 0xE4, 0xDC, 0x0C, 0x0C, 0x00, 0x00, 0x10, 0x20, 0x14, 0x14, 0x18,
	0x14, 0x14, 0x14, 0x10, 0x08, 0x24, 0x2C, 0x28, 0x24, 0x34, 0x30, 0x30, 0x34, 0x34, 0x38, 0x2C,
	0x1C, 0x1C, 0x34, 0x18, 0x04, 0x14, 0x10, 0x14, 0x14, 0x00, 0xE4, 0xEC, 0xE4, 0xFC, 0x10, 0x0C,
	0x0C, 0x14, 0x20, 0x04, 0x0C, 0x2C, 0x20, 0x14, 0x04, 0x08, 0x10, 0x2C, 0x2C, 0x14, 0x24, 0x00,
	0xEC, 0xFC, 0x10, 0x0C, 0x00, 0x10, 0x08, 0xF4, 0x00, 0xF4, 0x00, 0xFC, 0x08, 0x18, 0xF4, 0x00,
	0x0C, 0x0C, 0xF8, 0xF8, 0x10, 0x0C, 0x10, 0xE4, 0xE8, 0xFC, 0x04, 0x18, 0x0C, 0x0C, 0x04, 0x18,
	0x18, 0x14, 0x04, 0x0C, 0x10, 0x20, 0x0C, 0x10, 0x28, 0x34, 0x30, 0x34, 0x2C, 0x20, 0x1C, 0x1C,
	0x2C, 0x40, 0x3C, 0x24, 0x24, 0x1C, 0x18, 0x14, 0x24, 0x14, 0xEC, 0xFC, 0x04, 0xF8, 0xF4, 0xE4,
	0xE4, 0xFC, 0x04, 0xF8, 0xEC, 0xF8, 0xF8, 0xF4, 0x00, 0xF0, 0x00, 0xF4, 0xEC, 0x10, 0x04, 0xFC,
	0x08, 0x04, 0x00, 0xEC, 0x00, 0x00, 0x00, 0x14, 0x10, 0x0C, 0x04, 0x20, 0x1C, 0x24, 0x14, 0xF8,
	0x08, 0x28, 0x14, 0x0C, 0x24, 0x2C, 0x18, 0x0C, 0x24, 0x34, 0x04, 0xF8, 0xEC, 0x0C, 0x1C, 0x18,
	0x00, 0x04, 0x28, 0x1C, 0x14, 0x24, 0x18, 0x14, 0x20, 0x10, 0x10, 0x24, 0x1C, 0x04, 0x0C, 0x14,
	0x1C, 0x1C, 0x1C, 0x28, 0x24, 0x20, 0x2C, 0x24, 0x14, 0x04, 0x1C, 0x2C, 0x24, 0x24, 0x00, 0xF8,
	0xFC, 0x18, 0xF4, 0xEC, 0xFC, 0x04, 0xE4, 0xE4, 0xF4, 0xF0, 0xF8, 0x1C, 0x14, 0x14, 0x04, 0x04,
	0x00, 0x04, 0x1C, 0x1C, 0x08, 0xF4, 0xF0, 0xF8, 0x14, 0xFC, 0xF4, 0x10, 0x10, 0x18, 0x20, 0x24,
	0x14, 0x1C, 0x38, 0x28, 0x24, 0x14, 0x34, 0x44, 0x20, 0x24, 0x14, 0x10, 0x28, 0x24, 0x0C, 0x18,
	0x04, 0xF4, 0xF8, 0x14, 0xF8, 0xDC, 0xE4, 0xEC, 0xE4, 0x04, 0xFC, 0xEC, 0xF4, 0xFC, 0xFC, 0xFC,
	0xE4, 0xE4, 0xF0, 0xE0, 0xD4, 0xE8, 0xE4, 0xE4, 0xF8, 0xF0, 0xE4, 0xEC, 0xE4, 0xE4, 0xF4, 0xF8,
	0xFC, 0x04, 0x14, 0x04, 0x00, 0xF8, 0x14, 0x10, 0x14, 0x20, 0x20, 0x14, 0x08, 0x04, 0x20, 0x2C,
	0x1C, 0x0C, 0x1C, 0x1C, 0x0C, 0x1C, 0x1C, 0x00, 0x04, 0xF8, 0x20, 0x24, 0x2C, 0x3C, 0x1C, 0x28,
	0x34, 0x20, 0x2C, 0x20, 0x30, 0x2C, 0x28, 0x28, 0x24, 0x24, 0x3C, 0x3C, 0x34, 0x34, 0x34, 0x3C,
	0x24, 0x3C, 0x3C, 0x3C, 0x34, 0x34, 0x2C, 0x24, 0x18, 0x0C, 0x1C, 0x1C, 0x14, 0xF4, 0xFC, 0x0C,
	0x0C, 0x00, 0xF8, 0xFC, 0x04, 0x0C, 0x00, 0xF8, 0xF8, 0xEC, 0xEC, 0xE8, 0xF0, 0xDC, 0xE4, 0xF4,
	0xF0, 0xF0, 0xF4, 0x04, 0xDC, 0xEC, 0xEC, 0xDC, 0xE0, 0xEC, 0xEC, 0xF4, 0xEC, 0xE8, 0xF0, 0xE4,
	0xDC, 0xC4, 0xC4, 0xE4, 0xF4, 0x04, 0xF4, 0xF0, 0x08, 0x24, 0x14, 0x1C, 0x1C, 0x14, 0x30, 0x2C,
	0x08, 0x08, 0x1C, 0x14, 0x0C, 0x00, 0x08, 0x18, 0x10, 0x04, 0x04, 0x08, 0x14, 0x04, 0x10, 0x0C,
	0x00, 0x2C, 0x34, 0x1C, 0x0C, 0x1C, 0x20, 0x2C, 0x1C, 0x2C, 0x38, 0x44, 0x2C, 0x1C, 0x20, 0x44,
	0x48, 0x1C, 0x18, 0x1C, 0x24, 0x3C, 0x28, 0x24, 0x38, 0x28, 0x18, 0x1C, 0x1C, 0x1C, 0x2C, 0x14,
	0x04, 0x10, 0x24, 0x18, 0xF4, 0xFC, 0x24, 0x24, 0x14, 0xFC, 0x04, 0xF0, 0xF4, 0xF8, 0xEC, 0xE4,
	0xEC, 0xF8, 0xF4, 0xEC, 0xE4, 0x04, 0xF4, 0xEC, 0xE8, 0xFC, 0xF4, 0xF4, 0x0C, 0x0C, 0x04, 0x04,
	0x00, 0x00, 0x0C, 0x00, 0xFC, 0x00, 0x04, 0xEC, 0xEC, 0xEC, 0xF4, 0x04, 0x14, 0x0C, 0x04, 0xE0,
	0xE4, 0xF4, 0xDC, 0xE8, 0x08, 0xEC, 0xF4, 0xEC, 0xE4, 0xF4, 0x08, 0x0C, 0x08, 0xFC, 0xF0, 0xF0,
	0x00, 0xF8, 0xFC, 0xFC, 0xF8, 0xF8, 0x08, 0x0C, 0xFC, 0xF8, 0x04, 0x14, 0x18, 0x0C, 0x0C, 0x20,
	0x28, 0x34, 0x24, 0x24, 0x1C, 0x28, 0x34, 0x38, 0x2C, 0x28, 0x20, 0x1C, 0x1C, 0x1C, 0x20, 0x20,
	0x24, 0x18, 0x0C, 0x20, 0x28, 0x24, 0x0C, 0x0C, 0x2C, 0x1C, 0x14, 0x04, 0x08, 0x1C, 0x24, 0x10,
	0x04, 0x18, 0x18, 0x08, 0x04, 0x18, 0x24, 0x14, 0x04, 0xF8, 0xE4, 0x00, 0x00, 0x04, 0x08, 0xFC,
	0xF4, 0xFC, 0xF0, 0xF0, 0x00, 0x08, 0xF4, 0xE4, 0xF4, 0xEC, 0xEC, 0xEC, 0xE8, 0xF4, 0xE8, 0xD8,
	0xDC, 0xE4, 0xF0, 0xEC, 0xF0, 0x04, 0xF4, 0xE8, 0xFC, 0xFC, 0xE4, 0xE8, 0xF4, 0xF4, 0x04, 0xEC,
	0xF0, 0xE4, 0xE8, 0x10, 0x0C, 0xF4, 0xEC, 0x00, 0x14, 0x0C, 0x0C, 0x04
};

const uint8_t SfxPlayer::_musicDataSample6[] = {
	0x09, 0x2E, 0x00, 0x20, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x03, 0x03, 0x03, 0x06, 0x06, 0x0A,
	0x00, 0x10, 0x05, 0x0C, 0x04, 0x07, 0x08, 0xEF, 0xF4, 0xEB, 0xFC, 0xE3, 0x21, 0x10, 0x10, 0x08,
	0x22, 0x0E, 0x27, 0x3A, 0x35, 0x38, 0x2D, 0x38, 0x19, 0x0B, 0xCE, 0xDA, 0xCA, 0xD2, 0xCE, 0xEB,
	0x0B, 0x16, 0x14, 0x05, 0x04, 0xED, 0xF1, 0xB8, 0xCD, 0xCB, 0xD5, 0xE9, 0xF3, 0x22, 0x29, 0x2A,
	0x13, 0x1A, 0x3A, 0x32, 0x1F, 0x3B, 0x42, 0x4F, 0x3C, 0x2E, 0x08, 0x14, 0xFF, 0xE7, 0xF0, 0xF6,
	0x0D, 0xF5, 0x0E, 0xFE, 0x08, 0x05, 0xDD, 0xC4, 0xC9, 0xB1, 0xB7, 0xCC, 0xE6, 0xF8, 0x0D, 0x20,
	0xFF, 0x3A, 0x40, 0x4F, 0x2F, 0x57, 0x4C, 0x4A, 0x39, 0xF6, 0xF4, 0xDA, 0xD1, 0xBF, 0xD4, 0xE8,
	0x02, 0xFE, 0x0B, 0xF8, 0x06, 0xF0, 0xC6, 0xB8, 0xCA, 0xB3, 0xCF, 0xDF, 0x09, 0x27, 0x2D, 0x21,
	0x1F, 0x46, 0x59, 0x40, 0x5F, 0x67, 0x6C, 0x62, 0x3A, 0x0E, 0x08, 0xE9, 0xCF, 0xCC, 0xCE, 0xED,
	0xE4, 0xF3, 0xF0, 0xF3, 0x00, 0xE5, 0xB9, 0xDD, 0xB0, 0xBF, 0xC3, 0xDF, 0x01, 0x13, 0x2D, 0x06,
	0x3C, 0x49, 0x58, 0x37, 0x65, 0x5A, 0x5F, 0x50, 0x0C, 0xFE, 0xDF, 0xC5, 0xB9, 0xB5, 0xCB, 0xE4,
	0xE2, 0x0B, 0xE7, 0x17, 0x02, 0xDA, 0xD2, 0xD8, 0xC2, 0xD7, 0xE2, 0x0D, 0x24, 0x3F, 0x2E, 0x2D,
	0x3B, 0x58, 0x36, 0x4E, 0x60, 0x56, 0x6A, 0x31, 0x15, 0xF8, 0xE0, 0xCA, 0xBC, 0xC1, 0xD8, 0xD1,
	0xF5, 0xE1, 0xF3, 0x04, 0xED, 0xC7, 0xDE, 0xC2, 0xC9, 0xC9, 0xE3, 0x09, 0x1F, 0x39, 0x1C, 0x31,
	0x4E, 0x46, 0x3A, 0x55, 0x54, 0x66, 0x5C, 0x2D, 0x14, 0xF6, 0xDA, 0xC4, 0xBF, 0xC5, 0xD2, 0xDB,
	0xF4, 0xE3, 0x0C, 0x0F, 0xE6, 0xD9, 0xD4, 0xCA, 0xCB, 0xD9, 0x03, 0x0E, 0x3F, 0x2C, 0x29, 0x33,
	0x43, 0x36, 0x39, 0x55, 0x4E, 0x6B, 0x45, 0x24, 0x04, 0xE6, 0xCC, 0xBB, 0xB9, 0xCA, 0xC7, 0xE7,
	0xDE, 0xE9, 0x03, 0x00, 0xDC, 0xE2, 0xD8, 0xCC, 0xCF, 0xEB, 0xF9, 0x25, 0x2C, 0x2B, 0x1E, 0x3B,
	0x3B, 0x2E, 0x43, 0x4C, 0x5B, 0x6A, 0x44, 0x2A, 0x0C, 0xE8, 0xD1, 0xC0, 0xC9, 0xC9, 0xD7, 0xE7,
	0xE6, 0xF8, 0x1B, 0xF0, 0xE7, 0xE0, 0xCC, 0xC6, 0xCF, 0xEC, 0xFF, 0x25, 0x2D, 0x20, 0x23, 0x37,
	0x2D, 0x2A, 0x46, 0x42, 0x66, 0x5A, 0x38, 0x25, 0x00, 0xE3, 0xCA, 0xC0, 0xCD, 0xC7, 0xDE, 0xE4,
	0xDA, 0x07, 0x04, 0xEA, 0xE9, 0xD4, 0xD1, 0xBF, 0xE2, 0xEB, 0x19, 0x27, 0x35, 0x1C, 0x39, 0x3A,
	0x2D, 0x3F, 0x43, 0x53, 0x6B, 0x4C, 0x3A, 0x20, 0xF8, 0xE8, 0xC3, 0xD3, 0xC6, 0xD1, 0xDE, 0xDC,
	0xE5, 0x0E, 0xF1, 0xEF, 0xDA, 0xD7, 0xBC, 0xC9, 0xD7, 0xF3, 0x13, 0x31, 0x1C, 0x21, 0x32, 0x28,
	0x29, 0x38, 0x3E, 0x5D, 0x62, 0x45, 0x3B, 0x10, 0xFE, 0xD4, 0xCF, 0xD0, 0xCD, 0xD7, 0xE7, 0xD6,
	0xFB, 0x04, 0xF2, 0xF0, 0xDA, 0xD8, 0xBF, 0xDB, 0xE1, 0x06, 0x23, 0x36, 0x24, 0x32, 0x39, 0x2C,
	0x35, 0x38, 0x47, 0x5D, 0x58, 0x42, 0x2E, 0x08, 0xF3, 0xCF, 0xD4, 0xC9, 0xCA, 0xD8, 0xDB, 0xD6,
	0xFF, 0xF3, 0xF5, 0xDC, 0xE0, 0xC2, 0xCB, 0xD2, 0xED, 0x07, 0x2D, 0x2A, 0x22, 0x32, 0x2C, 0x26,
	0x31, 0x37, 0x49, 0x63, 0x4A, 0x48, 0x21, 0x0C, 0xE6, 0xD8, 0xD3, 0xD0, 0xCF, 0xE7, 0xD3, 0xEB,
	0x00, 0xFB, 0xEE, 0xE4, 0xD8, 0xC5, 0xD0, 0xDD, 0xF7, 0x17, 0x33, 0x28, 0x29, 0x3C, 0x28, 0x33,
	0x34, 0x3A, 0x57, 0x57, 0x4C, 0x38, 0x17, 0x00, 0xE0, 0xD5, 0xD2, 0xC4, 0xD5, 0xDC, 0xCB, 0xF4,
	0xF7, 0xF8, 0xE6, 0xE2, 0xC9, 0xC5, 0xC9, 0xE1, 0xF6, 0x22, 0x2D, 0x1E, 0x33, 0x2A, 0x27, 0x2E,
	0x30, 0x3F, 0x59, 0x54, 0x51, 0x30, 0x19, 0xF8, 0xDE, 0xDD, 0xD2, 0xCB, 0xEB, 0xD0, 0xE7, 0xF6,
	0x03, 0xF5, 0xF1, 0xE0, 0xCE, 0xC4, 0xD7, 0xE0, 0x03, 0x25, 0x26, 0x1F, 0x34, 0x26, 0x2C, 0x32,
	0x2C, 0x4B, 0x50, 0x58, 0x42, 0x2C, 0x11, 0xF1, 0xDE, 0xDB, 0xC6, 0xDA, 0xDA, 0xD5, 0xE4, 0xF7,
	0xFB, 0xF1, 0xEA, 0xD6, 0xC6, 0xC6, 0xD4, 0xE3, 0x0B, 0x27, 0x1B, 0x2D, 0x2C, 0x26, 0x32, 0x2A,
	0x3A, 0x4B, 0x5B, 0x55, 0x41, 0x28, 0x0A, 0xEA, 0xDE, 0xD8, 0xC7, 0xE8, 0xD7, 0xE2, 0xED, 0x03,
	0xF6, 0xF8, 0xE3, 0xD6, 0xC1, 0xD1, 0xD2, 0xEF, 0x15, 0x21, 0x1B, 0x2A, 0x24, 0x23, 0x30, 0x22,
	0x3F, 0x49, 0x5A, 0x4E, 0x3A, 0x22, 0x06, 0xE4, 0xEA, 0xC4, 0xDB, 0xDA, 0xDC, 0xDB, 0xF6, 0xFC,
	0xFA, 0xF2, 0xE2, 0xCC, 0xC7, 0xCE, 0xD9, 0xF7, 0x22, 0x1E, 0x25, 0x31, 0x20, 0x35, 0x24, 0x33,
	0x3F, 0x55, 0x5B, 0x4B, 0x36, 0x1D, 0xF8, 0xEB, 0xDC, 0xC9, 0xDE, 0xDB, 0xDA, 0xE3, 0xFB, 0xF8,
	0xFB, 0xE8, 0xE0, 0xC5, 0xCC, 0xCF, 0xD9, 0x07, 0x1C, 0x1B, 0x27, 0x24, 0x24, 0x2C, 0x23, 0x33,
	0x43, 0x57, 0x58, 0x48, 0x31, 0x1C, 0xF0, 0xF6, 0xCA, 0xD7, 0xDB, 0xDD, 0xD5, 0xEA, 0xF7, 0xFB,
	0xF2, 0xEC, 0xD0, 0xCA, 0xC9, 0xCC, 0xDF, 0x0F, 0x1B, 0x1C, 0x30, 0x1F, 0x34, 0x28, 0x2B, 0x38,
	0x47, 0x5D, 0x54, 0x41, 0x34, 0x04, 0xFB, 0xE2, 0xCF, 0xD7, 0xDF, 0xD7, 0xDB, 0xF1, 0xF8, 0xF9,
	0xF2, 0xE2, 0xD0, 0xC7, 0xCF, 0xC9, 0xF3, 0x12, 0x13, 0x25, 0x20, 0x28, 0x2A, 0x28, 0x2C, 0x3A,
	0x51, 0x5B, 0x51, 0x40, 0x2C, 0x02, 0x00, 0xDB, 0xD5, 0xDF, 0xE0, 0xD5, 0xE3, 0xF1, 0xFD, 0xF4,
	0xF2, 0xDA, 0xCC, 0xCB, 0xC5, 0xCF, 0xFD, 0x12, 0x17, 0x26, 0x21, 0x2A, 0x2C, 0x24, 0x2F, 0x3D,
	0x53, 0x5C, 0x44, 0x46, 0x12, 0x0A, 0xEE, 0xD7, 0xD4, 0xDF, 0xD8, 0xD6, 0xE3, 0xF8, 0xF4, 0xFA,
	0xE8, 0xDB, 0xC9, 0xD0, 0xC3, 0xDB, 0x09, 0x0B, 0x23, 0x1E, 0x27, 0x2C, 0x29, 0x29, 0x32, 0x44,
	0x5D, 0x52, 0x4F, 0x38, 0x17, 0x04, 0xEE, 0xD6, 0xDE, 0xE3, 0xD6, 0xDD, 0xE9, 0xF8, 0xF6, 0xF4,
	0xE8, 0xD0, 0xCF, 0xC6, 0xC0, 0xEB, 0x01, 0x15, 0x1C, 0x22, 0x26, 0x2C, 0x26, 0x27, 0x35, 0x46,
	0x5E, 0x49, 0x52, 0x28, 0x16, 0x00, 0xE2, 0xD4, 0xE1, 0xD8, 0xD8, 0xD8, 0xF3, 0xF0, 0xF9, 0xF0,
	0xE0, 0xD0, 0xCF, 0xC4, 0xC7, 0xF9, 0x05, 0x1B, 0x1F, 0x23, 0x2D, 0x2C, 0x26, 0x2E, 0x33, 0x59,
	0x4D, 0x57, 0x44, 0x28, 0x12, 0xFC, 0xDE, 0xDC, 0xE3, 0xDB, 0xD6, 0xE5, 0xF1, 0xF7, 0xF5, 0xF2,
	0xD9, 0xD2, 0xD0, 0xB6, 0xDD, 0xF1, 0x0D, 0x16, 0x1D, 0x25, 0x29, 0x28, 0x24, 0x2A, 0x3D, 0x54,
	0x4D, 0x53, 0x3C, 0x20, 0x0E, 0xF4, 0xD8, 0xE2, 0xDD, 0xDB, 0xD6, 0xEA, 0xF3, 0xF4, 0xF9, 0xE8,
	0xD8, 0xD5, 0xC4, 0xBF, 0xE3, 0xFD, 0x11, 0x1C, 0x21, 0x29, 0x2E, 0x24, 0x2E, 0x27, 0x4F, 0x4B,
	0x56, 0x50, 0x34, 0x1E, 0x0A, 0xE8, 0xDD, 0xDE, 0xE0, 0xD1, 0xDE, 0xE8, 0xF3, 0xF5, 0xF6, 0xE6,
	0xD4, 0xD8, 0xB9, 0xCB, 0xE5, 0xFE, 0x12, 0x18, 0x22, 0x29, 0x26, 0x2A, 0x20, 0x37, 0x47, 0x4E,
	0x53, 0x49, 0x2C, 0x1B, 0x02, 0xE2, 0xE0, 0xE3, 0xDB, 0xD7, 0xDF, 0xF2, 0xEF, 0xF9, 0xF4, 0xDA,
	0xDE, 0xC8, 0xBF, 0xD1, 0xED, 0x05, 0x15, 0x1E, 0x25, 0x2D, 0x27, 0x2C, 0x23, 0x3F, 0x4A, 0x51,
	0x57, 0x42, 0x28, 0x1A, 0xF5, 0xE4, 0xDD, 0xE4, 0xD4, 0xD8, 0xE4, 0xED, 0xF1, 0xF9, 0xEC, 0xDB,
	0xDB, 0xC2, 0xC0, 0xD7, 0xEF, 0x07, 0x16, 0x19, 0x2C, 0x21, 0x32, 0x1E, 0x2F, 0x3F, 0x4A, 0x53,
	0x54, 0x38, 0x29, 0x10, 0xF3, 0xDE, 0xE6, 0xDC, 0xD9, 0xDB, 0xEB, 0xEF, 0xF4, 0xFE, 0xE0, 0xE5,
	0xD2, 0xC1, 0xC7, 0xDD, 0xF7, 0x0D, 0x13, 0x23, 0x24, 0x2B, 0x28, 0x21, 0x34, 0x44, 0x4B, 0x58,
	0x4E, 0x33, 0x28, 0x07, 0xEE, 0xE1, 0xE4, 0xDC, 0xD6, 0xDF, 0xEB, 0xEB, 0xFD, 0xF2, 0xE3, 0xE0,
	0xCE, 0xBF, 0xCB, 0xE2, 0xFA, 0x12, 0x13, 0x29, 0x20, 0x31, 0x21, 0x26, 0x37, 0x42, 0x4D, 0x59,
	0x42, 0x37, 0x1D, 0x06, 0xE5, 0xE5, 0xE2, 0xD8, 0xD8, 0xE1, 0xEB, 0xEF, 0x00, 0xEB, 0xE7, 0xE0,
	0xC9, 0xC3, 0xD2, 0xE6, 0x06, 0x0A, 0x1F, 0x1F, 0x29, 0x2B, 0x21, 0x29, 0x3A, 0x43, 0x54, 0x54,
	0x3F, 0x30, 0x1C, 0xFA, 0xE7, 0xE5, 0xE1, 0xD8, 0xD9, 0xE9, 0xE4, 0xFA, 0xF8, 0xE9, 0xE7, 0xD8,
	0xC6, 0xC5, 0xD5, 0xEF, 0x06, 0x0F, 0x20, 0x1E, 0x2C, 0x26, 0x20, 0x2D, 0x3A, 0x43, 0x58, 0x49,
	0x3E, 0x2B, 0x16, 0xF3, 0xE6, 0xE6, 0xDD, 0xD5, 0xDE, 0xE4, 0xE9, 0xFC, 0xF2, 0xE9, 0xE6, 0xD4,
	0xC3, 0xCB, 0xD7, 0xFB, 0x02, 0x18, 0x1A, 0x23, 0x2C, 0x23, 0x23, 0x34, 0x39, 0x4F, 0x54, 0x4B,
	0x38, 0x2C, 0x0C, 0xF0, 0xE8, 0xE6, 0xDD, 0xD8, 0xE6, 0xE2, 0xF3, 0xFC, 0xEE, 0xEA, 0xE4, 0xCD,
	0xC7, 0xC8, 0xE1, 0xF8, 0x07, 0x16, 0x19, 0x25, 0x2A, 0x1E, 0x27, 0x31, 0x3D, 0x51, 0x51, 0x44,
	0x38, 0x26, 0x04, 0xEE, 0xE8, 0xE6, 0xD8, 0xDF, 0xE2, 0xE6, 0xF9, 0xF8, 0xEE, 0xEC, 0xE0, 0xCB,
	0xC7, 0xCA, 0xE9, 0xF8, 0x0D, 0x13, 0x1B, 0x27, 0x25, 0x1C, 0x2D, 0x2F, 0x46, 0x51, 0x50, 0x40,
	0x38, 0x20, 0xFE, 0xEC, 0xEA, 0xE1, 0xD8, 0xE2, 0xDF, 0xED, 0xFB, 0xF6, 0xED, 0xEE, 0xD8, 0xCE,
	0xC1, 0xD6, 0xE9, 0xFF, 0x0D, 0x14, 0x1D, 0x2B, 0x1E, 0x24, 0x2A, 0x35, 0x48, 0x52, 0x4A, 0x3E,
	0x34, 0x14, 0xFA, 0xEB, 0xED, 0xDB, 0xDF, 0xE0, 0xE1, 0xF1, 0xFB, 0xEF, 0xF0, 0xE6, 0xD6, 0xC8,
	0xC5, 0xDC, 0xED, 0x05, 0x0E, 0x14, 0x23, 0x27, 0x1D, 0x28, 0x2B, 0x3B, 0x4B, 0x53, 0x45, 0x40,
	0x2C, 0x10, 0xF2, 0xEF, 0xE8, 0xDB, 0xE3, 0xDE, 0xE6, 0xF6, 0xF8, 0xEE, 0xF2, 0xE0, 0xD7, 0xC2,
	0xCD, 0xDD, 0xF4, 0x06, 0x0F, 0x17, 0x2A, 0x21, 0x22, 0x27, 0x2E, 0x3E, 0x4F, 0x4E, 0x44, 0x3D,
	0x26, 0x06, 0xF0, 0xF0, 0xE0, 0xDD, 0xDF, 0xDE, 0xE9, 0xFA, 0xF1, 0xF3, 0xEC, 0xE1, 0xCE, 0xC2,
	0xD1, 0xE1, 0xF9, 0x09, 0x0E, 0x1F, 0x27, 0x21, 0x24, 0x27, 0x32, 0x43, 0x51, 0x49, 0x45, 0x39,
	0x20, 0x00, 0xF2, 0xEE, 0xDE, 0xE1, 0xDF, 0xDF, 0xF2, 0xF8, 0xF3, 0xF4, 0xEA, 0xE0, 0xC8, 0xC7,
	0xD2, 0xE5, 0xFC, 0x08, 0x0F, 0x23, 0x24, 0x21, 0x24, 0x29, 0x33, 0x47, 0x4C, 0x47, 0x41, 0x34,
	0x16, 0xF8, 0xF5, 0xE8, 0xE0, 0xE1, 0xDE, 0xE3, 0xF7, 0xF4, 0xF6, 0xF2, 0xEB, 0xD9, 0xC7, 0xC8,
	0xD7, 0xE9, 0x03, 0x04, 0x17, 0x24, 0x22, 0x22, 0x25, 0x2A, 0x39, 0x4A, 0x4B, 0x46, 0x40, 0x2E,
	0x0C, 0xF9, 0xF3, 0xE5, 0xE0, 0xE4, 0xDA, 0xED, 0xF5, 0xF6, 0xF7, 0xF1, 0xEA, 0xD4, 0xC7, 0xCC,
	0xD7, 0xF2, 0x00, 0x06, 0x19, 0x21, 0x21, 0x20, 0x26, 0x28, 0x3E, 0x47, 0x49, 0x44, 0x3E, 0x28,
	0x06, 0xFB, 0xF0, 0xE4, 0xE5, 0xE0, 0xDF, 0xF1, 0xF4, 0xF8, 0xF4, 0xF3, 0xE4, 0xD2, 0xC6, 0xD0,
	0xDB, 0xF9, 0xFD, 0x0B, 0x1B, 0x20, 0x1F, 0x23, 0x23, 0x2F, 0x40, 0x4A, 0x48, 0x43, 0x3E, 0x20,
	0x06, 0xF9, 0xF0, 0xE4, 0xE9, 0xDC, 0xE7, 0xF2, 0xF6, 0xF8, 0xF5, 0xF1, 0xE0, 0xCA, 0xCB, 0xCC,
	0xE5, 0xF9, 0xFD, 0x0F, 0x1A, 0x1F, 0x1D, 0x24, 0x21, 0x32, 0x43, 0x49, 0x44, 0x44, 0x38, 0x16,
	0x02, 0xFA, 0xE8, 0xEA, 0xE4, 0xDF, 0xED, 0xF2, 0xFB, 0xF5, 0xF8, 0xEE, 0xDA, 0xCB, 0xCA, 0xCF,
	0xEC, 0xF7, 0x02, 0x12, 0x1D, 0x1C, 0x22, 0x1F, 0x25, 0x36, 0x45, 0x49, 0x43, 0x47, 0x2D, 0x13,
	0x01, 0xF6, 0xE7, 0xEB, 0xDF, 0xE2, 0xED, 0xF6, 0xF8, 0xF8, 0xF5, 0xED, 0xD3, 0xCD, 0xC7, 0xD7,
	0xEF, 0xF6, 0x05, 0x13, 0x1C, 0x1D, 0x20, 0x1F, 0x28, 0x3B, 0x48, 0x46, 0x47, 0x42, 0x2A, 0x0D,
	0x03, 0xF0, 0xEB, 0xE8, 0xDD, 0xE7, 0xED, 0xF8, 0xF7, 0xF7, 0xF6, 0xE4, 0xD3, 0xCA, 0xC7, 0xDD,
	0xEE, 0xF8, 0x06, 0x17, 0x19, 0x20, 0x1F, 0x20, 0x2E, 0x3F, 0x4A, 0x45, 0x4C, 0x40, 0x20, 0x0F,
	0xFE, 0xEE, 0xED, 0xE3, 0xE1, 0xE7, 0xF3, 0xF6, 0xF8, 0xF6, 0xF4, 0xDD, 0xD1, 0xC5, 0xC9, 0xE3,
	0xEF, 0xF9, 0x0C, 0x16, 0x1C, 0x1F, 0x1F, 0x22, 0x31, 0x46, 0x46, 0x49, 0x4B, 0x3A, 0x1C, 0x0D,
	0xF8, 0xEE, 0xEC, 0xE0, 0xE2, 0xEB, 0xF3, 0xF9, 0xF5, 0xFB, 0xEC, 0xDC, 0xCE, 0xC2, 0xD2, 0xE5,
	0xEF, 0xFD, 0x0F, 0x16, 0x1D, 0x20, 0x1D, 0x24, 0x37, 0x46, 0x46, 0x49, 0x4C, 0x2E, 0x1C, 0x07,
	0xF4, 0xF0, 0xE7, 0xE2, 0xE3, 0xEE, 0xF6, 0xF6, 0xF9, 0xF8, 0xE8, 0xDA, 0xC8, 0xC6, 0xD7, 0xE9,
	0xEF, 0x05, 0x0F, 0x19, 0x1E, 0x1E, 0x1E, 0x25, 0x3E, 0x43, 0x45, 0x4E, 0x45, 0x2B, 0x19, 0x01,
	0xF4, 0xEE, 0xE7, 0xDE, 0xE7, 0xEE, 0xF9, 0xF5, 0xFD, 0xF5, 0xE6, 0xD9, 0xC5, 0xC9, 0xDC, 0xE8,
	0xF5, 0x05, 0x11, 0x19, 0x1E, 0x1F, 0x1B, 0x2D, 0x3C, 0x44, 0x43, 0x4E, 0x3B, 0x27, 0x13, 0xFB,
	0xF4, 0xEC, 0xE3, 0xE1, 0xE7, 0xF4, 0xF6, 0xF9, 0xFE, 0xF1, 0xE8, 0xD2, 0xC7, 0xCD, 0xE1, 0xE9,
	0xFA, 0x09, 0x14, 0x1D, 0x20, 0x1D, 0x1F, 0x31, 0x3F, 0x3E, 0x48, 0x4A, 0x34, 0x24, 0x0A, 0xFA,
	0xF0, 0xEB, 0xDF, 0xE2, 0xE9, 0xF5, 0xF6, 0xFC, 0xFC, 0xF0, 0xE4, 0xCE, 0xC6, 0xD3, 0xE1, 0xED,
	0xFE, 0x0B, 0x17, 0x1C, 0x22, 0x19, 0x24, 0x35, 0x3F, 0x3F, 0x4C, 0x45, 0x32, 0x20, 0x06, 0xF8,
	0xF1, 0xE5, 0xE1, 0xE1, 0xEF, 0xF5, 0xF7, 0xFF, 0xF8, 0xF2, 0xE0, 0xCC, 0xC8, 0xD7, 0xE3, 0xEF,
	0xFF, 0x0D, 0x17, 0x1F, 0x1D, 0x1B, 0x25, 0x3A, 0x3B, 0x43, 0x4D, 0x3E, 0x30, 0x19, 0x04, 0xF6,
	0xEE, 0xE5, 0xE0, 0xE5, 0xF2, 0xF5, 0xFB, 0xFE, 0xF9, 0xEE, 0xDC, 0xC9, 0xCC, 0xDA, 0xE4, 0xF3,
	0x01, 0x0F, 0x17, 0x1F, 0x1B, 0x1A, 0x2B, 0x39, 0x3B, 0x47, 0x4A, 0x3E, 0x2C, 0x16, 0x00, 0xF7,
	0xEB, 0xE5, 0xDF, 0xE9, 0xF4, 0xF6, 0xFE, 0xFD, 0xF8, 0xEC, 0xD5, 0xC8, 0xCF, 0xDC, 0xE7, 0xF5,
	0x06, 0x0E, 0x1B, 0x1C, 0x18, 0x1B, 0x30, 0x37, 0x3D, 0x4B, 0x48, 0x3B, 0x2A, 0x10, 0x00, 0xF4,
	0xEB, 0xE0, 0xDF, 0xED, 0xF2, 0xF8, 0xFD, 0xFD, 0xF6, 0xE8, 0xD0, 0xC8, 0xD2, 0xDC, 0xE7, 0xF9,
	0x05, 0x12, 0x1B, 0x1D, 0x16, 0x22, 0x33, 0x36, 0x41, 0x4B, 0x46, 0x38, 0x26, 0x0C, 0xFF, 0xF2,
	0xEA, 0xDF, 0xE5, 0xEF, 0xF3, 0xF9, 0xFF, 0xFB, 0xF6, 0xE1, 0xCC, 0xCB, 0xD4, 0xDF, 0xEB, 0xFD,
	0x06, 0x15, 0x1C, 0x1A, 0x16, 0x27, 0x32, 0x37, 0x45, 0x4C, 0x42, 0x38, 0x20, 0x0B, 0xFC, 0xF2,
	0xE6, 0xDE, 0xE8, 0xEE, 0xF4, 0xFB, 0xFD, 0xFB, 0xF2, 0xDC, 0xCB, 0xCD, 0xD7, 0xDF, 0xEF, 0xFC,
	0x09, 0x15, 0x1D, 0x16, 0x1A, 0x2C, 0x32, 0x3B, 0x48, 0x4A, 0x42, 0x34, 0x1A, 0x08, 0xF9, 0xF1,
	0xE2, 0xE3, 0xE9, 0xF0, 0xF6, 0xFD, 0xFC, 0xFB, 0xEE, 0xD5, 0xCB, 0xCE, 0xD8, 0xE3, 0xF3, 0xFF,
	0x0C, 0x19, 0x1B, 0x14, 0x1F, 0x2C, 0x32, 0x3D, 0x49, 0x47, 0x40, 0x2C, 0x16, 0x03, 0xF8, 0xEC,
	0xE1, 0xE4, 0xEB, 0xF1, 0xF9, 0xFC, 0xFD, 0xFA, 0xE8, 0xD2, 0xCA, 0xD1, 0xD7, 0xE7, 0xF5, 0x01,
	0x0F, 0x1B, 0x18, 0x15, 0x23, 0x2D, 0x33, 0x43, 0x49, 0x49, 0x3E, 0x29, 0x13, 0x01, 0xF7, 0xE8,
	0xE1, 0xE5, 0xEB, 0xF2, 0xF9, 0xFC, 0xFD, 0xF8, 0xE2, 0xCF, 0xCD, 0xD1, 0xDC, 0xEA, 0xF7, 0x04,
	0x13, 0x1C, 0x15, 0x18, 0x27, 0x2D, 0x37, 0x45, 0x49, 0x48, 0x39, 0x24, 0x0D, 0x00, 0xF4, 0xE6,
	0xE1, 0xE7, 0xEC, 0xF4, 0xF9, 0xFB, 0xFE, 0xF3, 0xDD, 0xCE, 0xCF, 0xD2, 0xDF, 0xEC, 0xFA, 0x06,
	0x17, 0x1A, 0x15, 0x1C, 0x29, 0x2D, 0x3B, 0x46, 0x4B, 0x45, 0x36, 0x20, 0x0B, 0xFE, 0xF1, 0xE4,
	0xE4, 0xE8, 0xED, 0xF5, 0xF9, 0xFD, 0xFB, 0xEE, 0xD6, 0xCF, 0xCD, 0xD5, 0xE1, 0xEF, 0xFB, 0x0A,
	0x18, 0x18, 0x15, 0x1F, 0x27, 0x2F, 0x3F, 0x47, 0x4B, 0x42, 0x33, 0x1A, 0x0A, 0xFC, 0xEE, 0xE4,
	0xE6, 0xE9, 0xF0, 0xF6, 0xFA, 0xFD, 0xFA, 0xE8, 0xD4, 0xCE, 0xCE, 0xD7, 0xE3, 0xF2, 0xFD, 0x0E,
	0x19, 0x15, 0x16, 0x21, 0x26, 0x33, 0x3F, 0x48, 0x49, 0x41, 0x2E, 0x18, 0x08, 0xFA, 0xEB, 0xE4,
	0xE7, 0xEA, 0xF2, 0xF7, 0xFB, 0xFD, 0xF8, 0xE1, 0xD3, 0xCB, 0xD0, 0xD7, 0xE7, 0xF2, 0xFF, 0x12,
	0x19, 0x13, 0x1A, 0x21, 0x28, 0x36, 0x40, 0x49, 0x47, 0x3D, 0x29, 0x14, 0x06, 0xF8, 0xE9, 0xE6,
	0xE7, 0xED, 0xF3, 0xF8, 0xFB, 0xFE, 0xF2, 0xDF, 0xD2, 0xCD, 0xD1, 0xDB, 0xE9, 0xF3, 0x02, 0x14,
	0x16, 0x13, 0x1D, 0x21, 0x2C, 0x37, 0x44, 0x49, 0x47, 0x3A, 0x25, 0x12, 0x04, 0xF4, 0xE9, 0xE7,
	0xE8, 0xEE, 0xF5, 0xF8, 0xFC, 0xFD, 0xEE, 0xDC, 0xD0, 0xCE, 0xD2, 0xDF, 0xEB, 0xF6, 0x07, 0x16,
	0x13, 0x17, 0x1D, 0x23, 0x2E, 0x3B, 0x45, 0x4A, 0x45, 0x36, 0x21, 0x10, 0x01, 0xF0, 0xEA, 0xE6,
	0xEB, 0xEF, 0xF7, 0xF8, 0xFF, 0xFA, 0xEA, 0xD8, 0xD0, 0xCD, 0xD4, 0xE0, 0xEC, 0xF7, 0x0C, 0x15,
	0x12, 0x19, 0x1D, 0x26, 0x30, 0x3E, 0x47, 0x49, 0x44, 0x32, 0x1E, 0x0F, 0xFE, 0xF0, 0xE8, 0xE7,
	0xEA, 0xF2, 0xF5, 0xFA, 0xFF, 0xF8, 0xE6, 0xD6, 0xCF, 0xCD, 0xD5, 0xE3, 0xEB, 0xFB, 0x0F, 0x12,
	0x15, 0x19, 0x1F, 0x27, 0x34, 0x3F
};

const uint8_t SfxPlayer::_musicDataSample7[] = {
	0x03, 0x46, 0x00, 0x40, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x0F, 0x0A, 0x0F, 0x08, 0x15, 0x0D,
	0x11, 0x16, 0x08, 0x0B, 0x17, 0xFA, 0x0E, 0x17, 0x06, 0x0F, 0x0F, 0x13, 0x11, 0xFA, 0x28, 0xFF,
	0x0E, 0x23, 0xFD, 0x14, 0x1F, 0xF2, 0x1C, 0x0F, 0x00, 0x37, 0xF7, 0x04, 0x1B, 0xF3, 0x1C, 0x0F,
	0x06, 0x0F, 0x12, 0xFF, 0x14, 0x0D, 0x10, 0x0B, 0xF4, 0x4F, 0xCF, 0x28, 0xEA, 0x2B, 0xFF, 0x10,
	0x2F, 0xE4, 0x13, 0xFF, 0x12, 0x0F, 0x16, 0x07, 0x2F, 0xD4, 0x24, 0xFF, 0x00, 0x18, 0x11, 0x00,
	0x17, 0x02, 0x11, 0xFA, 0x2F, 0xEA, 0x18, 0xFF, 0x0C, 0x04, 0x30, 0xFF, 0x24, 0xE3, 0x30, 0xFF,
	0x00, 0x3F, 0xEF, 0x1C, 0xFC, 0x17, 0xEF, 0x28, 0xF7, 0x2B, 0x03, 0x07, 0x10, 0x22, 0xEF, 0x18,
	0x2F, 0xD9, 0x21, 0x08, 0x1F, 0xEC, 0x2C, 0xFC, 0x05, 0x0C, 0x2C, 0xF0, 0x1F, 0x0A, 0x02, 0x17,
	0x0C, 0xF2, 0x34, 0xFF, 0xF8, 0x19, 0x13, 0x09, 0xFC, 0x55, 0xAF, 0x10, 0x37, 0xD2, 0x31, 0x08,
	0x07, 0x09, 0x0C, 0x17, 0x04, 0xFE, 0x24, 0x00, 0x1D, 0x10, 0x10, 0x07, 0x19, 0x03, 0x05, 0x06,
	0x07, 0x0F, 0x18, 0x17, 0x00, 0x24, 0xDF, 0x20, 0x07, 0xF8, 0x1F, 0x00, 0x3F, 0xD2, 0x2A, 0x07,
	0x0C, 0x05, 0x20, 0x0F, 0xE8, 0x27, 0x0D, 0x0C, 0x0F, 0x1D, 0xEF, 0x1C, 0x00, 0x13, 0x0E, 0x00,
	0x2B, 0xF5, 0x08, 0x1F, 0xD0, 0x50, 0xFB, 0xE8, 0x3F, 0xE0, 0x20, 0x05, 0x1C, 0xEE, 0x1C, 0x02,
	0x2B, 0xE3, 0x20, 0x17, 0xE0, 0x58, 0xDF, 0x20, 0x11, 0xEF, 0x1C, 0x06, 0x27, 0xFA, 0x07, 0x1F,
	0xE1, 0x2C, 0xFF, 0x0A, 0x1F, 0x06, 0xFF, 0x00, 0x2F, 0xEB, 0x1A, 0x08, 0x2B, 0xDB, 0x20, 0x1B,
	0xE8, 0x30, 0xF7, 0x08, 0x23, 0xEF, 0x20, 0xFF, 0x27, 0xFB, 0x12, 0x0A, 0x15, 0xFE, 0x0E, 0x17,
	0x11, 0xF7, 0x11, 0x09, 0x15, 0xFF, 0x10, 0x1F, 0xEA, 0x1A, 0x0C, 0xFF, 0x19, 0x1C, 0xFF, 0x15,
	0x06, 0x05, 0x11, 0x19, 0xFA, 0x12, 0x0B, 0x04, 0x1B, 0x0E, 0x04, 0x13, 0x15, 0xFF, 0x04, 0x27,
	0xEC, 0x24, 0xFF, 0x00, 0x2B, 0xE6, 0x20, 0x08, 0x06, 0x0B, 0x08, 0x1B, 0x00, 0x1C, 0x0B, 0x04,
	0x09, 0x0C, 0x0F, 0x06, 0x0C, 0x13, 0x07, 0x03, 0x1F, 0xF3, 0x20, 0x0D, 0xF8, 0x20, 0x0B, 0xF8,
	0x26, 0xFF, 0x14, 0x0F, 0x09, 0x09, 0x0E, 0x1B, 0xE4, 0x40, 0xF7, 0x00, 0x22, 0xFF, 0x11, 0x00,
	0x2B, 0xFA, 0x0A, 0x11, 0x16, 0x03, 0x0C, 0x1B, 0xFC, 0x07, 0x08, 0x1F, 0xE2, 0x40, 0xFB, 0x00,
	0x23, 0xFB, 0x10, 0x16, 0x05, 0x12, 0x06, 0x06, 0x2C, 0xEF, 0x10, 0x17, 0xF8, 0x20, 0xFF, 0x10,
	0x0A, 0x0B, 0x12, 0x05, 0x17, 0x0C, 0x0D, 0x08, 0x0E, 0x12, 0x08, 0x17, 0x05, 0x0C, 0x0F, 0x04,
	0x10, 0x15, 0x04, 0x1D, 0xEF, 0x2C, 0xFF, 0x00, 0x1F, 0x03, 0x12, 0x08, 0x09, 0x18, 0x0B, 0x00,
	0x1E, 0xFF, 0x08, 0xFF, 0x2C, 0xFD, 0x08, 0x1F, 0xF2, 0x14, 0x17, 0xF4, 0x2D, 0xFF, 0x02, 0x2F,
	0xF0, 0x07, 0x10, 0x17, 0xFD, 0x20, 0xFF, 0x0C, 0x0E, 0x06, 0x08, 0x19, 0xFB, 0x12, 0x17, 0xF8,
	0x18, 0x0B, 0x17, 0xF8, 0x16, 0x07, 0x0C, 0x13, 0x08, 0x07, 0x04, 0x0F, 0x09, 0x10, 0x08, 0x1F,
	0xEC, 0x18, 0x17, 0xF8, 0x1F, 0x05, 0x04, 0x17, 0xFF, 0x18, 0x0F, 0x08, 0x0C, 0x08, 0x10, 0x04,
	0x16, 0x09, 0x16, 0x02, 0x0E, 0x12, 0x0F, 0xF6, 0x32, 0xEF, 0x10, 0x1F, 0xF7, 0x16, 0x0C, 0x0E,
	0x16, 0xFB, 0x13, 0x04, 0x11, 0x11, 0x06, 0x1F, 0xFB, 0x12, 0x0F, 0x04, 0x14, 0x07, 0x04, 0x1F,
	0xF3, 0x18, 0x09, 0x16, 0x06, 0x0A, 0x13, 0xFC, 0x1A, 0x07, 0x0C, 0x1C, 0xEF, 0x14, 0x15, 0xF1,
	0x30, 0xFF, 0x08, 0x1C, 0xEF, 0x18, 0x08, 0x13, 0x09, 0x0C, 0x17, 0xF0, 0x28, 0x07, 0x08, 0x1D,
	0xFD, 0x10, 0x15, 0xFD, 0x28, 0xFF, 0x04, 0x1C, 0xF7, 0x18, 0x07, 0x1E, 0x07, 0x08, 0x17, 0xF4,
	0x1C, 0x07, 0x0B, 0x0C, 0x1A, 0x06, 0x06, 0x19, 0x04, 0x10, 0x04, 0x14, 0x07, 0x0A, 0x1F, 0xEE,
	0x28, 0xFF, 0x09, 0x0F, 0x10, 0x07, 0x08, 0x18, 0x02, 0x14, 0x00, 0x1C, 0x05, 0x0B, 0x06, 0x1F,
	0xEF, 0x18, 0x0F, 0x0C, 0x0E, 0x06, 0x13, 0x02, 0x0D, 0x14, 0x04, 0x13, 0x0B, 0x0F, 0x04, 0x1B,
	0xFF, 0x0C, 0x13, 0x06, 0x0E, 0x0E, 0x0F, 0x09, 0x0B, 0x0E, 0x06, 0x12, 0x0B, 0x0A, 0x11, 0x0B,
	0x09, 0x0C, 0x0E, 0x07, 0x11, 0x08, 0x11, 0x0F, 0x09, 0x0C, 0x17, 0xFA, 0x1A, 0x07, 0x16, 0xFF,
	0x18, 0x0F, 0x02, 0x17, 0x05, 0x10, 0x04, 0x19, 0x06, 0x11, 0x02, 0x1D, 0xFF, 0x08, 0x1B, 0xFE,
	0x18, 0x0A, 0x11, 0x07, 0x14, 0x0E, 0x0C, 0x0D, 0x0D, 0x0E, 0x03, 0x16, 0x09, 0x10, 0x03, 0x1A,
	0x06, 0x08, 0x1B, 0xFF, 0x11, 0x0B, 0x0A, 0x0E, 0x0A, 0x0F, 0x06, 0x16, 0x06, 0x06, 0x15, 0x05,
	0x14, 0x0B, 0x07, 0x12, 0x0A, 0x11, 0x02, 0x1C, 0x09, 0x07, 0x1E, 0x00, 0x10, 0x0D, 0x0C, 0x12,
	0x0A, 0x0E, 0x0D, 0x12, 0x07, 0x08, 0x0F, 0x0E, 0x11, 0x08, 0x17, 0x06, 0x0E, 0x0D, 0x0F, 0x10,
	0x07, 0x10, 0x10, 0x08, 0x0E, 0x09, 0x10, 0x0B, 0x10, 0x0A, 0x14, 0x06, 0x10, 0x0F, 0x0D, 0x09,
	0x0E, 0x0B, 0x12, 0x07, 0x0E, 0x13, 0x05, 0x15, 0x08, 0x0D, 0x0D, 0x0E, 0x0B, 0x12, 0x09, 0x0B,
	0x10, 0x0E, 0x0B, 0x0B, 0x10, 0x08, 0x17, 0x03, 0x13, 0x0A, 0x15, 0x03, 0x10, 0x0F, 0x05, 0x14,
	0x0D, 0x0E, 0x0B, 0x13, 0x0A, 0x0E, 0x10, 0x07, 0x10, 0x17, 0xFC, 0x1C, 0x0D, 0x02, 0x1A, 0x0B,
	0x0B, 0x0F, 0x0F, 0x0C, 0x0E, 0x0A, 0x11, 0x0A, 0x11, 0x09, 0x10, 0x0F, 0x0B, 0x17, 0x0B, 0x0C,
	0x0E, 0x0F, 0x0A, 0x11, 0x0B, 0x0E, 0x0C, 0x10, 0x0E, 0x08, 0x14, 0x0B, 0x0E, 0x14, 0x04, 0x16,
	0x0A, 0x10, 0x0E, 0x0C, 0x0F, 0x02, 0x1B, 0x07, 0x10, 0x13, 0x08, 0x14, 0x07, 0x12, 0x07, 0x10,
	0x0F, 0x08, 0x14, 0x0B, 0x0E, 0x0F, 0x0E, 0x10, 0x0B, 0x11, 0x10, 0x0E, 0x0D, 0x08, 0x14, 0x0B,
	0x0E, 0x0F, 0x10, 0x0D, 0x0C, 0x13, 0x0C, 0x10, 0x0F, 0x0C, 0x0E, 0x0E, 0x0F, 0x00
};

const uint8_t SfxPlayer::_musicDataSample8[] = {
	0x00, 0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00
};

const SfxPlayer::Module SfxPlayer::_module68 = {
	{ _musicDataSample1, _musicDataSample8, _musicDataSample3, _musicDataSample4, _musicDataSample8 },
	_musicData68
};

const SfxPlayer::Module SfxPlayer::_module70 = {
	{ _musicDataSample1, _musicDataSample2, _musicDataSample3, _musicDataSample3, _musicDataSample8	},
	_musicData70
};

const SfxPlayer::Module SfxPlayer::_module72 = {
	{ _musicDataSample1, _musicDataSample2, _musicDataSample5, _musicDataSample4, _musicDataSample8 },
	_musicData72
};

const SfxPlayer::Module SfxPlayer::_module73 = {
	{ _musicDataSample1, _musicDataSample2, _musicDataSample4, _musicDataSample3, _musicDataSample8 },
	_musicData73
};

const SfxPlayer::Module SfxPlayer::_module74 = {
	{ _musicDataSample1, _musicDataSample2, _musicDataSample5, _musicDataSample6, _musicDataSample7	},
	_musicData74
};

const SfxPlayer::Module SfxPlayer::_module75 = {
	{ _musicDataSample1, _musicDataSample2, _musicDataSample5, _musicDataSample6, _musicDataSample7 },
	_musicData75
};

const uint16_t SfxPlayer::_periodTable[] = {
	0x434, 0x3F8, 0x3C0, 0x38A, 0x358, 0x328, 0x2FA, 0x2D0, 0x2A6, 0x280,
	0x25C, 0x23A, 0x21A, 0x1FC, 0x1E0, 0x1C5, 0x1AC, 0x194, 0x17D, 0x168,
	0x153, 0x140, 0x12E, 0x11D, 0x10D, 0x0FE, 0x0F0, 0x0E2, 0x0D6, 0x0CA,
	0x0BE, 0x0B4, 0x0AA, 0x0A0, 0x097, 0x08F, 0x087, 0x07F, 0x078, 0x071
};

const uint8_t Cutscene::_caillouSetData[] = {
	0x50, 0x4f, 0x4c, 0x59, 0x00, 0x0a, 0x00, 0x02, 0xff, 0xff, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x00, 0x00, 0x03,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x01, 0xff, 0xb8,
	0xff, 0xbd, 0x00, 0x00, 0x00, 0x03, 0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25,
	0x00, 0x17, 0x00, 0x02, 0xff, 0xf0, 0xff, 0xcf, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0d, 0x00, 0x26,
	0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x02, 0x00, 0x1c, 0xff, 0xe2, 0x00, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00,
	0x00, 0x25, 0x00, 0x17, 0x00, 0x03, 0x00, 0x03, 0xff, 0xdd, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x04, 0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17,
	0x00, 0x03, 0x00, 0x0d, 0xff, 0xe2, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
	0x00, 0x0d, 0x00, 0x26, 0x00, 0x18, 0x00, 0x00, 0x00, 0x25, 0x00, 0x17, 0x00, 0x04, 0x00, 0x02,
	0xff, 0xea, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0d, 0x00, 0x14,
	0x00, 0x1d, 0x00, 0x00, 0x00, 0x21, 0x00, 0x0f, 0x00, 0x05, 0x00, 0x03, 0xff, 0xf2, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0d, 0xff, 0xed, 0x00, 0x21, 0x00, 0x00,
	0x00, 0x0f, 0xff, 0xff, 0x00, 0x05, 0xff, 0xed, 0xff, 0xe5, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0xff, 0xf7, 0xff, 0xf7, 0x00, 0x05, 0xff, 0xd5, 0xff, 0xdd,
	0x00, 0x0d, 0xff, 0xc6, 0x00, 0x27, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x00, 0xff, 0xcd, 0xff, 0xea, 0x00, 0x06, 0xff, 0xe6, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x00, 0xff, 0x92, 0xff, 0xd7, 0x00, 0x06, 0xff, 0xaf, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x00, 0x00, 0x00, 0x78,
	0x00, 0x14, 0xff, 0xff, 0x00, 0x0e, 0x00, 0x99, 0x00, 0x3b, 0x00, 0x45, 0x00, 0x30, 0x00, 0x59,
	0x00, 0x30, 0x00, 0x88, 0x00, 0x35, 0x00, 0x99, 0x00, 0x3c, 0x00, 0x86, 0x00, 0x37, 0x00, 0x4d,
	0x00, 0x23, 0x00, 0x2a, 0x00, 0x69, 0x00, 0x47, 0x00, 0x62, 0x00, 0x54, 0x00, 0x62, 0x00, 0x6d,
	0x00, 0x62, 0x00, 0x53, 0x00, 0x70, 0x00, 0x3a, 0x00, 0x3e, 0x00, 0x92, 0x00, 0x51, 0xff, 0xff,
	0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4,
	0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00,
	0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a,
	0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4,
	0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00,
	0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a,
	0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4,
	0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00,
	0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a,
	0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4,
	0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00,
	0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a,
	0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4,
	0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00,
	0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a,
	0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4,
	0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00,
	0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a,
	0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4,
	0x00, 0x5a, 0x00, 0x03, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00,
	0x00, 0xb4, 0x00, 0x5a, 0x00, 0x0a, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a,
	0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x0e, 0x00, 0xbd,
	0x00, 0x5a, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x10, 0x00, 0xb4, 0x00, 0x5a, 0x00, 0x00,
	0x00, 0xb4, 0x00, 0x5a, 0x00, 0x01, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x00, 0x00, 0x00, 0xef, 0x00, 0x7f,
	0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x35, 0x00, 0x00, 0x0b, 0x0b,
	0x00, 0x35, 0x00, 0x00, 0x00, 0xef, 0x00, 0x00, 0x00, 0xef, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x04, 0x00, 0x10, 0x00, 0x6d, 0x0b, 0x0b, 0x00, 0x10, 0x00, 0x6d, 0x00, 0xef, 0x00, 0x74,
	0x00, 0xef, 0x00, 0x7f, 0x00, 0x18, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x00, 0x00,
	0x00, 0x2a, 0x08, 0x08, 0x00, 0x70, 0x00, 0x2a, 0x00, 0x6d, 0x00, 0x2f, 0x00, 0x64, 0x00, 0x33,
	0x00, 0x4e, 0x00, 0x37, 0x00, 0x33, 0x00, 0x3a, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x2f,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x0a, 0xff, 0xfe, 0x00, 0x19, 0x05, 0x05, 0x00, 0x68, 0x00, 0x19,
	0x00, 0x71, 0x00, 0x1c, 0x00, 0x72, 0x00, 0x22, 0x00, 0x70, 0x00, 0x2a, 0x00, 0x6a, 0x00, 0x2f,
	0x00, 0x57, 0x00, 0x33, 0x00, 0x44, 0x00, 0x35, 0x00, 0x20, 0x00, 0x32, 0xff, 0xfe, 0x00, 0x2e,
	0xff, 0xfe, 0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0a, 0x00, 0x2f, 0x00, 0x01, 0x03, 0x03,
	0x00, 0x3b, 0x00, 0x01, 0x00, 0x3f, 0x00, 0x02, 0x00, 0x46, 0x00, 0x08, 0x00, 0x57, 0x00, 0x12,
	0x00, 0x65, 0x00, 0x17, 0x00, 0x6d, 0x00, 0x1c, 0x00, 0x67, 0x00, 0x22, 0x00, 0x5f, 0x00, 0x25,
	0x00, 0x4e, 0x00, 0x28, 0x00, 0x2f, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00, 0x01, 0x14, 0x00, 0x04,
	0x00, 0x09, 0x02, 0x02, 0x00, 0x31, 0x00, 0x09, 0x00, 0x38, 0x00, 0x08, 0x00, 0x41, 0x00, 0x0c,
	0x00, 0x46, 0x00, 0x13, 0x00, 0x4e, 0x00, 0x17, 0x00, 0x56, 0x00, 0x19, 0x00, 0x49, 0x00, 0x1f,
	0x00, 0x37, 0x00, 0x21, 0x00, 0x34, 0x00, 0x22, 0x00, 0x30, 0x00, 0x25, 0x00, 0x31, 0x00, 0x27,
	0x00, 0x22, 0x00, 0x28, 0x00, 0x1b, 0x00, 0x29, 0x00, 0x14, 0x00, 0x29, 0x00, 0x05, 0x00, 0x28,
	0x00, 0x01, 0x00, 0x26, 0xff, 0xff, 0x00, 0x23, 0xff, 0xff, 0x00, 0x1e, 0xff, 0xff, 0x00, 0x18,
	0x00, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x0a, 0x00, 0x07, 0x04, 0x04,
	0x00, 0x08, 0x00, 0x06, 0x00, 0x34, 0x00, 0x07, 0x00, 0x31, 0x00, 0x08, 0x00, 0x28, 0x00, 0x10,
	0x00, 0x21, 0x00, 0x17, 0x00, 0x15, 0x00, 0x19, 0x00, 0x0d, 0x00, 0x15, 0x00, 0x07, 0x00, 0x0e,
	0x00, 0x05, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x04, 0x00, 0x30, 0x05, 0x05,
	0xff, 0xff, 0x00, 0x2f, 0x00, 0x21, 0x00, 0x32, 0x00, 0x0c, 0x00, 0x34, 0x00, 0x04, 0x00, 0x33,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x00, 0x04, 0x00, 0x00, 0x07, 0x07, 0x00, 0x39, 0xff, 0xff,
	0x00, 0x38, 0x00, 0x07, 0x00, 0x27, 0x00, 0x0a, 0x00, 0x11, 0x00, 0x0b, 0x00, 0x01, 0x00, 0x06,
	0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x44, 0x00, 0x05, 0x02, 0x02,
	0x00, 0x3f, 0x00, 0x04, 0x00, 0x46, 0x00, 0x0a, 0x00, 0x58, 0x00, 0x13, 0x00, 0x59, 0x00, 0x15,
	0x00, 0x49, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0a, 0x00, 0x2e, 0x00, 0x0c, 0x03, 0x03,
	0x00, 0x3f, 0x00, 0x0c, 0x00, 0x41, 0x00, 0x0e, 0x00, 0x46, 0x00, 0x14, 0x00, 0x4e, 0x00, 0x18,
	0x00, 0x54, 0x00, 0x19, 0x00, 0x50, 0x00, 0x1b, 0x00, 0x4a, 0x00, 0x1d, 0x00, 0x44, 0x00, 0x1e,
	0x00, 0x38, 0x00, 0x1c, 0x00, 0x2e, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x0a,
	0x00, 0x0f, 0x03, 0x03, 0x00, 0x05, 0x00, 0x0e, 0x00, 0x08, 0x00, 0x13, 0x00, 0x10, 0x00, 0x18,
	0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x5c, 0x00, 0x16, 0x02, 0x02,
	0x00, 0x5a, 0x00, 0x15, 0x00, 0x57, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x00, 0x1e,
	0x00, 0x29, 0x09, 0x09, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2f, 0x00, 0x2a, 0x00, 0x30, 0x00, 0x2f,
	0x00, 0x34, 0x00, 0x34, 0x00, 0x1e, 0x00, 0x32, 0x00, 0x1e, 0x00, 0x2b, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x09, 0x00, 0x00, 0x00, 0x26, 0x09, 0x09, 0x00, 0x00, 0x00, 0x26, 0x00, 0x02, 0x00, 0x28,
	0x00, 0x07, 0x00, 0x29, 0x00, 0x0e, 0x00, 0x2b, 0x00, 0x1d, 0x00, 0x2b, 0x00, 0x21, 0x00, 0x32,
	0x00, 0x0c, 0x00, 0x34, 0x00, 0x06, 0x00, 0x34, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x00, 0x12, 0x00, 0x1f, 0x0a, 0x0a, 0x00, 0x1a, 0x00, 0x1f, 0x00, 0x12, 0x00, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x31, 0x00, 0x22, 0x0a, 0x0a, 0x00, 0x33, 0x00, 0x22,
	0x00, 0x31, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x30, 0x00, 0x25, 0x0a, 0x0a,
	0x00, 0x31, 0x00, 0x25, 0x00, 0x30, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x1f,
	0x00, 0x1c, 0x0a, 0x0a, 0x00, 0x25, 0x00, 0x1c, 0x00, 0x1f, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x00, 0x1b, 0x00, 0x1e, 0x0a, 0x0a, 0x00, 0x1f, 0x00, 0x1e, 0x00, 0x1b, 0x00, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x19, 0x00, 0x19, 0x0a, 0x0a, 0x00, 0x19, 0x00, 0x19,
	0x00, 0x1c, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0d, 0x00, 0x24, 0x00, 0x08, 0x03, 0x03,
	0x00, 0x32, 0x00, 0x09, 0x00, 0x35, 0x00, 0x08, 0x00, 0x39, 0x00, 0x09, 0x00, 0x3e, 0x00, 0x0c,
	0x00, 0x3e, 0x00, 0x10, 0x00, 0x33, 0x00, 0x10, 0x00, 0x2f, 0x00, 0x13, 0x00, 0x29, 0x00, 0x18,
	0x00, 0x26, 0x00, 0x19, 0x00, 0x25, 0x00, 0x18, 0x00, 0x24, 0x00, 0x17, 0x00, 0x26, 0x00, 0x16,
	0x00, 0x2a, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07,
	0x00, 0x00, 0x00, 0x45, 0x00, 0x17, 0x00, 0x73, 0x00, 0x19, 0x00, 0x7a, 0x00, 0x19, 0x00, 0x7f,
	0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
	0x00, 0x00, 0x06, 0x88, 0x0a, 0xaa, 0x0c, 0xcc, 0x06, 0x66, 0x0a, 0xa8, 0x0e, 0xa8, 0x06, 0x6a,
	0x04, 0x66, 0x08, 0x86, 0x08, 0x88, 0x04, 0x88, 0x0a, 0x8a, 0x0d, 0xdd, 0x0e, 0xee, 0x0f, 0xff,
	0x00, 0x00, 0x0e, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x58, 0x00, 0x34, 0x0a,
	0x0a, 0x00, 0xb1, 0x00, 0x4e, 0x00, 0x86, 0x00, 0x4e, 0x00, 0x7d, 0x00, 0x4b, 0x00, 0x77, 0x00,
	0x47, 0x00, 0x74, 0x00, 0x40, 0x00, 0x74, 0x00, 0x39, 0x00, 0x7e, 0x00, 0x2f, 0x00, 0x87, 0x00,
	0x2b, 0x00, 0x95, 0x00, 0x29, 0x00, 0xa3, 0x00, 0x2c, 0x00, 0xad, 0x00, 0x31, 0x00, 0xb8, 0x00,
	0x39, 0x00, 0xbf, 0x00, 0x41, 0x00, 0xbd, 0x00, 0x49, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00,
	0x68, 0x00, 0x54, 0x0e, 0x0e, 0x00, 0x84, 0x00, 0x4e, 0x00, 0xa6, 0x00, 0x4d, 0x00, 0xad, 0x00,
	0x49, 0x00, 0xb2, 0x00, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x00, 0x67, 0x00, 0x34, 0x0b,
	0x0b, 0x00, 0x83, 0x00, 0x2d, 0x00, 0x91, 0x00, 0x29, 0x00, 0x9f, 0x00, 0x2a, 0x00, 0xaa, 0x00,
	0x2f, 0x00, 0x9b, 0x00, 0x37, 0x00, 0x8d, 0x00, 0x37, 0x00, 0x8a, 0x00, 0x34, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x08, 0x00, 0x5c, 0x00, 0x40, 0x0d, 0x0d, 0x00, 0x84, 0x00, 0x4d, 0x00, 0x7e, 0x00,
	0x41, 0x00, 0x78, 0x00, 0x3e, 0x00, 0x88, 0x00, 0x35, 0x00, 0x9a, 0x00, 0x37, 0x00, 0xa3, 0x00,
	0x3f, 0x00, 0xac, 0x00, 0x48, 0x00, 0xa5, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00,
	0x91, 0x00, 0x4b, 0x0d, 0x0d, 0x00, 0xad, 0x00, 0x49, 0x00, 0xbf, 0x00, 0x40, 0x00, 0xbf, 0x00,
	0x44, 0x00, 0xbd, 0x00, 0x49, 0x00, 0xb3, 0x00, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x00,
	0x58, 0x00, 0x44, 0x0e, 0x0e, 0x00, 0x74, 0x00, 0x39, 0x00, 0x7c, 0x00, 0x3c, 0x00, 0x84, 0x00,
	0x4e, 0x00, 0x7c, 0x00, 0x4b, 0x00, 0x77, 0x00, 0x48, 0x00, 0x74, 0x00, 0x42, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x06, 0x00, 0x58, 0x00, 0x34, 0x0c, 0x0c, 0x00, 0x7c, 0x00, 0x3b, 0x00, 0x74, 0x00,
	0x38, 0x00, 0x7e, 0x00, 0x2e, 0x00, 0x83, 0x00, 0x2c, 0x00, 0x8f, 0x00, 0x29, 0x00, 0x8a, 0x00,
	0x34, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x70, 0x00, 0x40, 0x0c, 0x0c, 0x00, 0x8c, 0x00,
	0x35, 0x00, 0x9a, 0x00, 0x37, 0x00, 0x94, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00,
	0x71, 0x00, 0x51, 0x0e, 0x0e, 0x00, 0x94, 0x00, 0x4d, 0x00, 0x8d, 0x00, 0x4d, 0x00, 0x94, 0x00,
	0x46, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x84, 0x00, 0x46, 0x0c, 0x0c, 0x00, 0xad, 0x00,
	0x48, 0x00, 0xa0, 0x00, 0x3b, 0x00, 0xb2, 0x00, 0x3b, 0x00, 0xbc, 0x00, 0x3d, 0x00, 0xbe, 0x00,
	0x3f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x7f, 0x00, 0x42, 0x0c, 0x0c, 0x00, 0x9f, 0x00,
	0x3b, 0x00, 0x9b, 0x00, 0x37, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x76, 0x00, 0x40, 0x0a,
	0x0a, 0x00, 0x9d, 0x00, 0x36, 0x00, 0x92, 0x00, 0x35, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00,
	0x94, 0x00, 0x42, 0x0e, 0x0e, 0x00, 0x94, 0x00, 0x46, 0x00, 0x94, 0x00, 0x42, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x02, 0x00, 0x79, 0x00, 0x48, 0x0c, 0x0c, 0x00, 0x95, 0x00, 0x3d, 0x00, 0x95, 0x00,
	0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x08,
	0x88, 0x04, 0x88, 0x00, 0x00, 0x08, 0x64, 0x0c, 0x86, 0x0e, 0xa8, 0x08, 0xaa, 0x04, 0x66, 0x04,
	0x48, 0x0c, 0xcc, 0x0a, 0xaa, 0x06, 0x66, 0x04, 0x44, 0x02, 0x22, 0x04, 0x66, 0x00, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x12, 0x00, 0x33, 0x00, 0x1b, 0x06, 0x06, 0x00, 0x44, 0x00, 0x24,
	0x00, 0x50, 0x00, 0x1e, 0x00, 0x56, 0x00, 0x1d, 0x00, 0x64, 0x00, 0x22, 0x00, 0x75, 0x00, 0x2c,
	0x00, 0x74, 0x00, 0x2e, 0x00, 0x6c, 0x00, 0x30, 0x00, 0x5e, 0x00, 0x2f, 0x00, 0x63, 0x00, 0x35,
	0x00, 0x6d, 0x00, 0x3a, 0x00, 0x7c, 0x00, 0x45, 0x00, 0x8a, 0x00, 0x4e, 0x00, 0x8c, 0x00, 0x52,
	0x00, 0x8a, 0x00, 0x54, 0x00, 0x86, 0x00, 0x55, 0x00, 0x79, 0x00, 0x51, 0x00, 0x6e, 0x00, 0x4b,
	0x00, 0x32, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04,
	0x00, 0x32, 0x00, 0x02, 0x00, 0x3c, 0x00, 0x1c, 0x00, 0x43, 0x00, 0x23, 0x00, 0x44, 0x00, 0x2b,
	0x00, 0x40, 0x00, 0x39, 0x00, 0x39, 0x00, 0x42, 0x00, 0x31, 0x00, 0x48, 0x00, 0x2c, 0x00, 0x48,
	0x00, 0x24, 0x00, 0x42, 0x00, 0x13, 0x00, 0x42, 0x00, 0x00, 0x00, 0x37, 0xff, 0xff, 0x00, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x33, 0x00, 0x46, 0x06, 0x06, 0x00, 0x32, 0x00, 0x48,
	0x00, 0x6a, 0x00, 0x4a, 0x00, 0x74, 0x00, 0x54, 0x00, 0x81, 0x00, 0x59, 0x00, 0x82, 0x00, 0x5a,
	0x00, 0x82, 0x00, 0x5c, 0x00, 0x7e, 0x00, 0x5e, 0x00, 0x70, 0x00, 0x5e, 0x00, 0x6a, 0x00, 0x5b,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x35, 0x00, 0x48, 0x06, 0x06, 0x00, 0x34, 0x00, 0x4a,
	0x00, 0x67, 0x00, 0x5b, 0x00, 0x66, 0x00, 0x5d, 0x00, 0x63, 0x00, 0x5f, 0x00, 0x5d, 0x00, 0x5f,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x38, 0x00, 0x4b, 0x06, 0x06, 0x00, 0x37, 0x00, 0x4d,
	0x00, 0x57, 0x00, 0x5d, 0x00, 0x53, 0x00, 0x5f, 0x00, 0x4d, 0x00, 0x5f, 0x00, 0x40, 0x00, 0x59,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x61, 0x00, 0x50, 0x05, 0x05, 0x00, 0x60, 0x00, 0x52,
	0x00, 0x6b, 0x00, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x53, 0x00, 0x57, 0x05, 0x05,
	0x00, 0x52, 0x00, 0x59, 0x00, 0x57, 0x00, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x5d,
	0x00, 0x2a, 0x05, 0x05, 0x00, 0x5c, 0x00, 0x2c, 0x00, 0x61, 0x00, 0x33, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x08, 0x88, 0x04, 0x88, 0x06, 0x42,
	0x08, 0x64, 0x0c, 0x86, 0x0e, 0xa8, 0x08, 0xaa, 0x04, 0x66, 0x04, 0x48, 0x00, 0xe0, 0x02, 0x20,
	0x04, 0x44, 0x06, 0x66, 0x00, 0x00, 0x04, 0x66, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x07, 0x00, 0x69, 0x00, 0x36, 0x06, 0x06, 0x00, 0x75, 0x00, 0x36, 0x00, 0x8d, 0x00, 0x50, 0x00,
	0x90, 0x00, 0x59, 0x00, 0x8f, 0x00, 0x5d, 0x00, 0x8c, 0x00, 0x5e, 0x00, 0x7f, 0x00, 0x56, 0x00,
	0x69, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x75, 0x00, 0x35, 0x06, 0x06, 0x00,
	0x75, 0x00, 0x35, 0x00, 0x97, 0x00, 0x45, 0x00, 0x9f, 0x00, 0x4f, 0x00, 0xa7, 0x00, 0x58, 0x00,
	0xa7, 0x00, 0x5c, 0x00, 0xa3, 0x00, 0x5d, 0x00, 0x9a, 0x00, 0x58, 0x00, 0x93, 0x00, 0x52, 0x00,
	0x8b, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0c, 0x00, 0x6d, 0x00, 0x1f, 0x06, 0x06, 0x00,
	0x73, 0x00, 0x21, 0x00, 0x7b, 0x00, 0x20, 0x00, 0x81, 0x00, 0x1f, 0x00, 0x91, 0x00, 0x2b, 0x00,
	0x93, 0x00, 0x2e, 0x00, 0x90, 0x00, 0x30, 0x00, 0xa2, 0x00, 0x3d, 0x00, 0xad, 0x00, 0x49, 0x00,
	0xad, 0x00, 0x4d, 0x00, 0xab, 0x00, 0x50, 0x00, 0x99, 0x00, 0x47, 0x00, 0x6d, 0x00, 0x30, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x06, 0x00, 0x00, 0x04, 0x04, 0x00, 0x68, 0x00, 0x00, 0x00,
	0x71, 0x00, 0x08, 0x00, 0x70, 0x00, 0x18, 0x00, 0x72, 0x00, 0x1f, 0x00, 0x70, 0x00, 0x22, 0x00,
	0x74, 0x00, 0x29, 0x00, 0x76, 0x00, 0x30, 0x00, 0x73, 0x00, 0x38, 0x00, 0x6b, 0x00, 0x41, 0x00,
	0x64, 0x00, 0x44, 0x00, 0x60, 0x00, 0x46, 0x00, 0x46, 0x00, 0x3e, 0x00, 0x18, 0x00, 0x17, 0x00,
	0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x00, 0x62, 0x00, 0x43, 0x06, 0x06, 0x00,
	0x69, 0x00, 0x43, 0x00, 0x7e, 0x00, 0x56, 0x00, 0x81, 0x00, 0x5c, 0x00, 0x80, 0x00, 0x5f, 0x00,
	0x7c, 0x00, 0x60, 0x00, 0x65, 0x00, 0x4f, 0x00, 0x62, 0x00, 0x46, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x02, 0x00, 0x82, 0x00, 0x26, 0x05, 0x05, 0x00, 0x82, 0x00, 0x26, 0x00, 0x8a, 0x00, 0x2e, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x8a, 0x00, 0x2e, 0x05, 0x05, 0x00, 0x8a, 0x00, 0x2e, 0x00,
	0x90, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0xa0, 0x00, 0x54, 0x05, 0x05, 0x00,
	0xa1, 0x00, 0x54, 0x00, 0xa0, 0x00, 0x58, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x9c, 0x00,
	0x58, 0x05, 0x05, 0x00, 0xa0, 0x00, 0x58, 0x00, 0x9c, 0x00, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x08, 0x88, 0x04, 0x88, 0x06, 0x42, 0x08,
	0x64, 0x0c, 0x86, 0x0e, 0xa8, 0x08, 0xaa, 0x04, 0x66, 0x04, 0x48, 0x00, 0xe0, 0x02, 0x20, 0x04,
	0x44, 0x06, 0x66, 0x00, 0x00, 0x04, 0x66, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09,
	0x00, 0x87, 0x00, 0x44, 0x06, 0x06, 0x00, 0x95, 0x00, 0x44, 0x00, 0xa6, 0x00, 0x59, 0x00, 0xa5,
	0x00, 0x5a, 0x00, 0xa6, 0x00, 0x62, 0x00, 0xa3, 0x00, 0x69, 0x00, 0x9e, 0x00, 0x65, 0x00, 0x9b,
	0x00, 0x5d, 0x00, 0x92, 0x00, 0x58, 0x00, 0x87, 0x00, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x00, 0x96, 0x00, 0x44, 0x06, 0x06, 0x00, 0x96, 0x00, 0x44, 0x00, 0xad, 0x00, 0x53, 0x00, 0xb2,
	0x00, 0x5a, 0x00, 0xb4, 0x00, 0x5e, 0x00, 0xb3, 0x00, 0x68, 0x00, 0xb0, 0x00, 0x6a, 0x00, 0xae,
	0x00, 0x66, 0x00, 0xae, 0x00, 0x61, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x00, 0x97, 0x00, 0x32,
	0x06, 0x06, 0x00, 0x9d, 0x00, 0x32, 0x00, 0xb2, 0x00, 0x3b, 0x00, 0xb4, 0x00, 0x3e, 0x00, 0xc0,
	0x00, 0x46, 0x00, 0xc3, 0x00, 0x49, 0x00, 0xc8, 0x00, 0x51, 0x00, 0xc7, 0x00, 0x53, 0x00, 0xc3,
	0x00, 0x54, 0x00, 0xc6, 0x00, 0x59, 0x00, 0xc6, 0x00, 0x5e, 0x00, 0xc5, 0x00, 0x62, 0x00, 0xc2,
	0x00, 0x62, 0x00, 0xbf, 0x00, 0x5b, 0x00, 0xbd, 0x00, 0x58, 0x00, 0xaf, 0x00, 0x52, 0x00, 0x97,
	0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0c, 0x00, 0x49, 0x00, 0x00, 0x04, 0x04, 0x00, 0x94,
	0x00, 0x00, 0x00, 0x9b, 0x00, 0x0d, 0x00, 0x9c, 0x00, 0x12, 0x00, 0x9e, 0x00, 0x22, 0x00, 0x9c,
	0x00, 0x2b, 0x00, 0x9c, 0x00, 0x37, 0x00, 0x98, 0x00, 0x40, 0x00, 0x91, 0x00, 0x48, 0x00, 0x85,
	0x00, 0x4a, 0x00, 0x74, 0x00, 0x43, 0x00, 0x56, 0x00, 0x1b, 0x00, 0x49, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x04, 0x00, 0x9b, 0x00, 0x66, 0x06, 0x06, 0x00, 0x9d, 0x00, 0x66, 0x00, 0xa2,
	0x00, 0x69, 0x00, 0x9d, 0x00, 0x6b, 0x00, 0x9b, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02,
	0x00, 0xb6, 0x00, 0x48, 0x05, 0x05, 0x00, 0xb6, 0x00, 0x48, 0x00, 0xbf, 0x00, 0x4d, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x02, 0x00, 0xbf, 0x00, 0x4d, 0x05, 0x05, 0x00, 0xbf, 0x00, 0x4d, 0x00, 0xc3,
	0x00, 0x53, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0xb0, 0x00, 0x62, 0x05, 0x05, 0x00, 0xb0,
	0x00, 0x63, 0x00, 0xb2, 0x00, 0x62, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0xb2, 0x00, 0x5e,
	0x05, 0x05, 0x00, 0xb2, 0x00, 0x62, 0x00, 0xb4, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02,
	0x00, 0xa0, 0x00, 0x66, 0x05, 0x05, 0x00, 0xa0, 0x00, 0x66, 0x00, 0xa2, 0x00, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x02, 0x00, 0xa2, 0x00, 0x64, 0x05, 0x05, 0x00, 0xa2, 0x00, 0x66, 0x00, 0xa5,
	0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
	0x08, 0x88, 0x04, 0x88, 0x06, 0x42, 0x08, 0x64, 0x0c, 0x86, 0x0e, 0xa8, 0x08, 0xaa, 0x04, 0x66,
	0x04, 0x48, 0x00, 0xe0, 0x02, 0x20, 0x04, 0x44, 0x06, 0x66, 0x00, 0x00, 0x04, 0x66, 0x00, 0x00,
	0x0a, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x00, 0x94, 0x00, 0x42, 0x06, 0x06, 0x00, 0xa7, 0x00,
	0x42, 0x00, 0xbc, 0x00, 0x62, 0x00, 0xb0, 0x00, 0x5c, 0x00, 0x9e, 0x00, 0x59, 0x00, 0x98, 0x00,
	0x54, 0x00, 0x94, 0x00, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0d, 0x00, 0x5c, 0x00, 0x00, 0x04,
	0x04, 0x00, 0xa5, 0x00, 0x00, 0x00, 0xa7, 0x00, 0x06, 0x00, 0xa6, 0x00, 0x1f, 0x00, 0xa2, 0x00,
	0x31, 0x00, 0xa7, 0x00, 0x3d, 0x00, 0xa4, 0x00, 0x45, 0x00, 0xa0, 0x00, 0x48, 0x00, 0x95, 0x00,
	0x4b, 0x00, 0x8c, 0x00, 0x4b, 0x00, 0x82, 0x00, 0x39, 0x00, 0x7b, 0x00, 0x37, 0x00, 0x69, 0x00,
	0x1d, 0x00, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0xa8, 0x00, 0x3d, 0x06,
	0x06, 0x00, 0xa8, 0x00, 0x3d, 0x00, 0xc9, 0x00, 0x4e, 0x00, 0xc9, 0x00, 0x51, 0x00, 0xcc, 0x00,
	0x53, 0x00, 0xd0, 0x00, 0x5b, 0x00, 0xd4, 0x00, 0x60, 0x00, 0xd7, 0x00, 0x68, 0x00, 0xd4, 0x00,
	0x69, 0x00, 0xcb, 0x00, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0xa8, 0x00, 0x3f, 0x06,
	0x06, 0x00, 0xa8, 0x00, 0x3f, 0x00, 0xcd, 0x00, 0x5c, 0x00, 0xbe, 0x00, 0x59, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x07, 0x00, 0xa7, 0x00, 0x40, 0x06, 0x06, 0x00, 0xa7, 0x00, 0x40, 0x00, 0xc4, 0x00,
	0x5f, 0x00, 0xc6, 0x00, 0x62, 0x00, 0xc3, 0x00, 0x72, 0x00, 0xbf, 0x00, 0x78, 0x00, 0xbd, 0x00,
	0x75, 0x00, 0xbe, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x00, 0xaa, 0x00, 0x5b, 0x06,
	0x06, 0x00, 0xb0, 0x00, 0x5b, 0x00, 0xb4, 0x00, 0x65, 0x00, 0xb0, 0x00, 0x71, 0x00, 0xad, 0x00,
	0x77, 0x00, 0xaa, 0x00, 0x76, 0x00, 0xad, 0x00, 0x62, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00,
	0x9f, 0x00, 0x59, 0x06, 0x06, 0x00, 0x9f, 0x00, 0x59, 0x00, 0xb0, 0x00, 0x5a, 0x00, 0xad, 0x00,
	0x65, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0xc1, 0x00, 0x4e, 0x05, 0x05, 0x00, 0xc1, 0x00,
	0x4e, 0x00, 0xca, 0x00, 0x51, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0xbe, 0x00, 0x59, 0x05,
	0x05, 0x00, 0xbe, 0x00, 0x59, 0x00, 0xbf, 0x00, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x08, 0x88, 0x04, 0x88, 0x06, 0x42, 0x08, 0x64, 0x0c,
	0x86, 0x0e, 0xa8, 0x08, 0xaa, 0x04, 0x66, 0x04, 0x48, 0x00, 0xe0, 0x02, 0x20, 0x04, 0x44, 0x06,
	0x66, 0x00, 0x00, 0x04, 0x66, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x88,
	0x00, 0x1e, 0x06, 0x06, 0x00, 0x9a, 0x00, 0x30, 0x00, 0xc7, 0x00, 0x59, 0x00, 0x97, 0x00, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x0b, 0x00, 0x3a, 0x00, 0x06, 0x04, 0x04, 0x00, 0x91, 0x00, 0x06,
	0x00, 0x97, 0x00, 0x2c, 0x00, 0x99, 0x00, 0x2f, 0x00, 0x9a, 0x00, 0x3d, 0x00, 0x94, 0x00, 0x47,
	0x00, 0x89, 0x00, 0x4d, 0x00, 0x84, 0x00, 0x4a, 0x00, 0x73, 0x00, 0x48, 0x00, 0x4a, 0x00, 0x2c,
	0x00, 0x41, 0x00, 0x24, 0x00, 0x3a, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0b, 0x00, 0x8b,
	0x00, 0x1d, 0x06, 0x06, 0x00, 0x9a, 0x00, 0x2f, 0x00, 0xa0, 0x00, 0x30, 0x00, 0xaf, 0x00, 0x34,
	0x00, 0xba, 0x00, 0x3b, 0x00, 0xc9, 0x00, 0x43, 0x00, 0xd2, 0x00, 0x50, 0x00, 0xcf, 0x00, 0x52,
	0x00, 0xca, 0x00, 0x52, 0x00, 0xd2, 0x00, 0x5f, 0x00, 0xcf, 0x00, 0x62, 0x00, 0xc5, 0x00, 0x58,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x89, 0x00, 0x31, 0x06, 0x06, 0x00, 0x98, 0x00, 0x43,
	0x00, 0xb2, 0x00, 0x4f, 0x00, 0xb0, 0x00, 0x52, 0x00, 0xb6, 0x00, 0x5b, 0x00, 0xb8, 0x00, 0x60,
	0x00, 0xb9, 0x00, 0x67, 0x00, 0xb6, 0x00, 0x69, 0x00, 0xb1, 0x00, 0x68, 0x00, 0xaf, 0x00, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x86, 0x00, 0x32, 0x06, 0x06, 0x00, 0x97, 0x00, 0x44,
	0x00, 0xb1, 0x00, 0x5f, 0x00, 0x95, 0x00, 0x53, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x7b,
	0x00, 0x32, 0x06, 0x06, 0x00, 0x96, 0x00, 0x44, 0x00, 0xa4, 0x00, 0x5a, 0x00, 0xa6, 0x00, 0x5e,
	0x00, 0xa6, 0x00, 0x63, 0x00, 0xa2, 0x00, 0x65, 0x00, 0xa0, 0x00, 0x64, 0x00, 0x9e, 0x00, 0x5f,
	0x00, 0x92, 0x00, 0x57, 0x00, 0x8a, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0xac,
	0x00, 0x35, 0x05, 0x05, 0x00, 0xbb, 0x00, 0x47, 0x00, 0xca, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x00, 0xbb, 0x00, 0x3e, 0x05, 0x05, 0x00, 0xca, 0x00, 0x50, 0x00, 0xca, 0x00, 0x52,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0xa5, 0x00, 0x4f, 0x05, 0x05, 0x00, 0xb8, 0x00, 0x61,
	0x00, 0xb4, 0x00, 0x63, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0xa3, 0x00, 0x50, 0x05, 0x05,
	0x00, 0xb4, 0x00, 0x63, 0x00, 0xb2, 0x00, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x08, 0x88, 0x04, 0x88, 0x06, 0x42, 0x08, 0x64, 0x0c, 0x86,
	0x0e, 0xa8, 0x08, 0xaa, 0x04, 0x66, 0x04, 0x48, 0x00, 0xe0, 0x02, 0x20, 0x04, 0x44, 0x06, 0x66,
	0x00, 0x00, 0x04, 0x66, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x45, 0x00,
	0x0c, 0x06, 0x06, 0x00, 0x52, 0x00, 0x0c, 0x00, 0x65, 0x00, 0x30, 0x00, 0x6a, 0x00, 0x40, 0x00,
	0x69, 0x00, 0x42, 0x00, 0x66, 0x00, 0x44, 0x00, 0x5c, 0x00, 0x40, 0x00, 0x51, 0x00, 0x39, 0x00,
	0x45, 0x00, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x4d, 0x00, 0x00, 0x00, 0x52, 0x00, 0x0b, 0x00, 0x53, 0x00, 0x16, 0x00, 0x50, 0x00, 0x20, 0x00,
	0x47, 0x00, 0x29, 0x00, 0x41, 0x00, 0x2d, 0x00, 0x20, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x1e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0c, 0x00, 0x51, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x51, 0x00, 0x04, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x62, 0x00, 0x00, 0x00, 0x6e, 0x00, 0x09, 0x00,
	0x6d, 0x00, 0x0d, 0x00, 0x77, 0x00, 0x11, 0x00, 0x7d, 0x00, 0x16, 0x00, 0x92, 0x00, 0x23, 0x00,
	0x9b, 0x00, 0x2d, 0x00, 0x9a, 0x00, 0x2f, 0x00, 0x98, 0x00, 0x30, 0x00, 0x8d, 0x00, 0x28, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x51, 0x00, 0x05, 0x06, 0x06, 0x00, 0x51, 0x00, 0x05, 0x00,
	0x90, 0x00, 0x29, 0x00, 0x78, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x52, 0x00,
	0x06, 0x06, 0x06, 0x00, 0x52, 0x00, 0x06, 0x00, 0x7b, 0x00, 0x23, 0x00, 0x7d, 0x00, 0x29, 0x00,
	0x90, 0x00, 0x34, 0x00, 0x94, 0x00, 0x36, 0x00, 0x98, 0x00, 0x3c, 0x00, 0x96, 0x00, 0x3f, 0x00,
	0x75, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x92, 0x00, 0x3d, 0x06, 0x06, 0x00,
	0x92, 0x00, 0x3d, 0x00, 0x95, 0x00, 0x3f, 0x00, 0x93, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x09, 0x00, 0x51, 0x00, 0x07, 0x06, 0x06, 0x00, 0x51, 0x00, 0x07, 0x00, 0x79, 0x00, 0x2e, 0x00,
	0x74, 0x00, 0x32, 0x00, 0x79, 0x00, 0x3e, 0x00, 0x7e, 0x00, 0x40, 0x00, 0x7e, 0x00, 0x44, 0x00,
	0x7a, 0x00, 0x46, 0x00, 0x72, 0x00, 0x43, 0x00, 0x68, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x02, 0x00, 0x63, 0x00, 0x07, 0x05, 0x05, 0x00, 0x63, 0x00, 0x07, 0x00, 0x71, 0x00, 0x0f, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x76, 0x00, 0x42, 0x05, 0x05, 0x00, 0x76, 0x00, 0x43, 0x00,
	0x79, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x79, 0x00, 0x3f, 0x05, 0x05, 0x00,
	0x79, 0x00, 0x42, 0x00, 0x7a, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x00,
	0x3f, 0x01, 0x01, 0x00, 0x00, 0x08, 0x88, 0x04, 0x88, 0x06, 0x42, 0x08, 0x64, 0x0c, 0x86, 0x0e,
	0xa8, 0x08, 0xaa, 0x04, 0x66, 0x04, 0x48, 0x00, 0xe0, 0x02, 0x20, 0x04, 0x44, 0x06, 0x66, 0x00,
	0x00, 0x04, 0x66, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x1a, 0x00, 0x7b,
	0x08, 0x08, 0x00, 0x1a, 0x00, 0x7b, 0x00, 0x53, 0x00, 0x7f, 0x00, 0x1a, 0x00, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x03, 0x00, 0x18, 0x00, 0x72, 0x08, 0x08, 0x00, 0x18, 0x00, 0x72, 0x00, 0x54,
	0x00, 0x7f, 0x00, 0x1a, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x54,
	0x09, 0x09, 0x00, 0x00, 0x00, 0x54, 0x00, 0x08, 0x00, 0x58, 0x00, 0x0e, 0x00, 0x60, 0x00, 0x18,
	0x00, 0x75, 0x00, 0x19, 0x00, 0x7a, 0x00, 0x19, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x08, 0x88, 0x04, 0x88,
	0x06, 0x42, 0x08, 0x64, 0x0c, 0x86, 0x0e, 0xa8, 0x08, 0xaa, 0x04, 0x66, 0x04, 0x48, 0x00, 0xe0,
	0x02, 0x20, 0x04, 0x44, 0x06, 0x66, 0x00, 0x00, 0x04, 0x66, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x08, 0x00, 0x11, 0x00, 0x65, 0x08, 0x08, 0x00, 0x11, 0x00, 0x65, 0x00, 0x3e, 0x00,
	0x70, 0x00, 0x63, 0x00, 0x77, 0x00, 0x70, 0x00, 0x74, 0x00, 0x79, 0x00, 0x76, 0x00, 0x7a, 0x00,
	0x7a, 0x00, 0x7e, 0x00, 0x7f, 0x00, 0x1b, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00,
	0x00, 0x00, 0x45, 0x09, 0x09, 0x00, 0x00, 0x00, 0x45, 0x00, 0x0f, 0x00, 0x62, 0x00, 0x1a, 0x00,
	0x7d, 0x00, 0x1a, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x00,
	0x71, 0x00, 0x78, 0x08, 0x08, 0x00, 0x8a, 0x00, 0x78, 0x00, 0x8d, 0x00, 0x79, 0x00, 0x8e, 0x00,
	0x7c, 0x00, 0x87, 0x00, 0x7f, 0x00, 0x71, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7a, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x05, 0x00, 0x67, 0x00, 0x71, 0x08, 0x08, 0x00, 0x79, 0x00, 0x71, 0x00, 0x7e, 0x00,
	0x72, 0x00, 0x7e, 0x00, 0x75, 0x00, 0x78, 0x00, 0x7a, 0x00, 0x67, 0x00, 0x77, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x08, 0x88, 0x04, 0x88, 0x06,
	0x42, 0x08, 0x64, 0x0c, 0x86, 0x0e, 0xa8, 0x08, 0xaa, 0x04, 0x66, 0x04, 0x48, 0x00, 0xe0, 0x02,
	0x20, 0x04, 0x44, 0x06, 0x66, 0x00, 0x00, 0x04, 0x66, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x06, 0x00, 0x7c, 0x00, 0x68, 0x08, 0x08, 0x00, 0x8c, 0x00, 0x68, 0x00, 0x93, 0x00, 0x68,
	0x00, 0x97, 0x00, 0x69, 0x00, 0x99, 0x00, 0x6d, 0x00, 0x85, 0x00, 0x6b, 0x00, 0x7c, 0x00, 0x69,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x9a, 0x00, 0x6d, 0x08, 0x08, 0x00, 0x9f, 0x00, 0x6d,
	0x00, 0xa8, 0x00, 0x73, 0x00, 0xa8, 0x00, 0x77, 0x00, 0xa1, 0x00, 0x73, 0x00, 0x9a, 0x00, 0x6d,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x82, 0x00, 0x79, 0x08, 0x08, 0x00, 0x9d, 0x00, 0x79,
	0x00, 0xa8, 0x00, 0x7f, 0x00, 0x9e, 0x00, 0x7f, 0x00, 0x82, 0x00, 0x7d, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x0a, 0x00, 0x0d, 0x00, 0x43, 0x08, 0x08, 0x00, 0x0d, 0x00, 0x5c, 0x00, 0x36, 0x00, 0x65,
	0x00, 0x56, 0x00, 0x69, 0x00, 0x86, 0x00, 0x6a, 0x00, 0x95, 0x00, 0x6c, 0x00, 0xa0, 0x00, 0x70,
	0x00, 0xa7, 0x00, 0x78, 0x00, 0x8d, 0x00, 0x7b, 0x00, 0xa3, 0x00, 0x86, 0x00, 0x22, 0x00, 0x86,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x45, 0x09, 0x09, 0x00, 0x00, 0x00, 0x45,
	0x00, 0x19, 0x00, 0x77, 0x00, 0x1a, 0x00, 0x7b, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x03, 0x00, 0x00, 0x00, 0x47, 0x09, 0x09, 0x00, 0x00, 0x00, 0x47, 0x00, 0x0d, 0x00, 0x72,
	0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x27, 0x00, 0x7a, 0x08, 0x08,
	0x00, 0x27, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x1a, 0x00, 0x5a, 0x08, 0x08,
	0x00, 0x1a, 0x00, 0x73, 0x00, 0x23, 0x00, 0x86, 0x00, 0x1a, 0x00, 0x86, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x08, 0x88, 0x04, 0x88, 0x06, 0x42,
	0x08, 0x64, 0x0c, 0x86, 0x0e, 0xa8, 0x08, 0xaa, 0x04, 0x66, 0x04, 0x48, 0x00, 0xe0, 0x02, 0x20,
	0x04, 0x44, 0x06, 0x66, 0x00, 0x00, 0x04, 0x66, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x0c, 0x00, 0x0a, 0x00, 0x55, 0x08, 0x08, 0x00, 0x0a, 0x00, 0x55, 0x00, 0x40, 0x00, 0x60, 0x00,
	0x6a, 0x00, 0x66, 0x00, 0x77, 0x00, 0x65, 0x00, 0x89, 0x00, 0x69, 0x00, 0xa8, 0x00, 0x69, 0x00,
	0xb8, 0x00, 0x6b, 0x00, 0xc6, 0x00, 0x70, 0x00, 0xc8, 0x00, 0x77, 0x00, 0xc0, 0x00, 0x7c, 0x00,
	0xb3, 0x00, 0x7f, 0x00, 0x1e, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00,
	0x45, 0x09, 0x09, 0x00, 0x00, 0x00, 0x45, 0x00, 0x14, 0x00, 0x6b, 0x00, 0x0a, 0x00, 0x63, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x47, 0x09, 0x09, 0x00, 0x00, 0x00, 0x47, 0x00,
	0x09, 0x00, 0x63, 0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0xc7, 0x00,
	0x6f, 0x08, 0x08, 0x00, 0xd6, 0x00, 0x76, 0x00, 0xc9, 0x00, 0x73, 0x00, 0xc7, 0x00, 0x70, 0x00,
	0xd3, 0x00, 0x6f, 0x00, 0xda, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x19, 0x00,
	0x75, 0x08, 0x08, 0x00, 0x19, 0x00, 0x75, 0x00, 0x1e, 0x00, 0x7f, 0x00, 0x1a, 0x00, 0x7f, 0x00,
	0x1a, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00,
	0x00, 0x08, 0x88, 0x04, 0x88, 0x06, 0x42, 0x08, 0x64, 0x0c, 0x86, 0x0e, 0xa8, 0x08, 0xaa, 0x04,
	0x66, 0x04, 0x48, 0x00, 0xe0, 0x02, 0x20, 0x04, 0x44, 0x06, 0x66, 0x00, 0x00, 0x04, 0x66, 0x00,
	0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x10, 0x00, 0x62, 0x08, 0x08, 0x00, 0x10,
	0x00, 0x62, 0x00, 0x3e, 0x00, 0x6f, 0x00, 0x65, 0x00, 0x71, 0x00, 0x7f, 0x00, 0x6f, 0x00, 0x92,
	0x00, 0x75, 0x00, 0x96, 0x00, 0x79, 0x00, 0x91, 0x00, 0x7f, 0x00, 0x1b, 0x00, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x08, 0x88, 0x04, 0x88,
	0x06, 0x42, 0x08, 0x64, 0x0c, 0x86, 0x0e, 0xa8, 0x08, 0xaa, 0x04, 0x66, 0x04, 0x48, 0x00, 0xe0,
	0x02, 0x20, 0x04, 0x44, 0x06, 0x66, 0x00, 0x00, 0x04, 0x66, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x45, 0x09, 0x09, 0x00, 0x3f, 0x00, 0x43, 0x00, 0x4e, 0x00,
	0x60, 0x00, 0x59, 0x00, 0x7b, 0x00, 0x59, 0x00, 0x7d, 0x00, 0x3f, 0x00, 0x7d, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x07, 0x00, 0x1b, 0x00, 0x00, 0x09, 0x09, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x28, 0x00,
	0x08, 0x00, 0x2e, 0x00, 0x10, 0x00, 0x38, 0x00, 0x25, 0x00, 0x39, 0x00, 0x2a, 0x00, 0x39, 0x00,
	0x2f, 0x00, 0x1b, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x00, 0x00, 0x08, 0x88, 0x04, 0x88, 0x06, 0x42, 0x08, 0x64, 0x0c, 0x86, 0x0e, 0xa8, 0x08,
	0xaa, 0x04, 0x66, 0x04, 0x48, 0x00, 0xe0, 0x02, 0x20, 0x04, 0x44, 0x06, 0x66, 0x00, 0x00, 0x04,
	0x66, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0b, 0x00, 0x69, 0x00, 0x47, 0x08, 0x08,
	0x00, 0xba, 0x00, 0x4c, 0x00, 0xbc, 0x00, 0x4e, 0x00, 0xbc, 0x00, 0x51, 0x00, 0xb7, 0x00, 0x53,
	0x00, 0x97, 0x00, 0x5a, 0x00, 0x84, 0x00, 0x5c, 0x00, 0x78, 0x00, 0x5a, 0x00, 0x6a, 0x00, 0x52,
	0x00, 0x69, 0x00, 0x4c, 0x00, 0x71, 0x00, 0x48, 0x00, 0x75, 0x00, 0x47, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x08, 0x88, 0x04, 0x88, 0x00, 0x00,
	0x08, 0x64, 0x0c, 0x86, 0x0e, 0xa8, 0x08, 0xaa, 0x04, 0x66, 0x04, 0x48, 0x0c, 0xcc, 0x0a, 0xaa,
	0x06, 0x66, 0x04, 0x44, 0x02, 0x22, 0x04, 0x66, 0x00
};

const uint8_t Cutscene::_memoSetShape2Data[] = {
	0x00, 0x25, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x41, 0x00, 0x27, 0x0c, 0x0c, 0x00, 0x69,
	0x00, 0x22, 0x00, 0x7c, 0x00, 0x31, 0x00, 0x7c, 0x00, 0x34, 0x00, 0x78, 0x00, 0x36, 0x00, 0x72,
	0x00, 0x36, 0x00, 0x67, 0x00, 0x32, 0x00, 0x5d, 0x00, 0x20, 0x00, 0x64, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x10, 0x00, 0x92, 0x00, 0x23, 0x0c, 0x0c, 0x00, 0x75, 0x00, 0x4f, 0x00, 0x77,
	0x00, 0x55, 0x00, 0x77, 0x00, 0x5a, 0x00, 0x74, 0x00, 0x70, 0x00, 0x47, 0x00, 0x70, 0x00, 0x32,
	0x00, 0x4c, 0x00, 0x33, 0x00, 0x47, 0x00, 0x37, 0x00, 0x40, 0x00, 0x37, 0x00, 0x3a, 0x00, 0x39,
	0x00, 0x35, 0x00, 0x4a, 0x00, 0x24, 0x00, 0x51, 0x00, 0x23, 0x00, 0x55, 0x00, 0x1a, 0x00, 0x5a,
	0x00, 0x1a, 0x00, 0x5f, 0x00, 0x23, 0x00, 0x61, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0a,
	0x00, 0xb5, 0x00, 0x2d, 0x0d, 0x0d, 0x00, 0x4d, 0x00, 0x27, 0x00, 0x4f, 0x00, 0x2e, 0x00, 0x53,
	0x00, 0x3a, 0x00, 0x54, 0x00, 0x41, 0x00, 0x54, 0x00, 0x4f, 0x00, 0x50, 0x00, 0x3b, 0x00, 0x4c,
	0x00, 0x31, 0x00, 0x4b, 0x00, 0x28, 0x00, 0x4c, 0x00, 0x24, 0x00, 0x4d, 0x00, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x07, 0x00, 0x42, 0x00, 0x34, 0x0d, 0x0d, 0x00, 0x76, 0x00, 0x36, 0x00, 0x79,
	0x00, 0x36, 0x00, 0x7b, 0x00, 0x35, 0x00, 0x79, 0x00, 0x37, 0x00, 0x73, 0x00, 0x37, 0x00, 0x63,
	0x00, 0x2f, 0x00, 0x65, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x8e, 0x00, 0x36,
	0x0c, 0x0c, 0x00, 0x7a, 0x00, 0x3f, 0x00, 0x7b, 0x00, 0x40, 0x00, 0x7b, 0x00, 0x42, 0x00, 0x79,
	0x00, 0x45, 0x00, 0x74, 0x00, 0x46, 0x00, 0x65, 0x00, 0x3f, 0x00, 0x63, 0x00, 0x2d, 0x00, 0x6f,
	0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0xa1, 0x00, 0x20, 0x0c, 0x0c, 0x00, 0x5e,
	0x00, 0x23, 0x00, 0x68, 0x00, 0x3b, 0x00, 0x56, 0x00, 0x40, 0x00, 0x4e, 0x00, 0x26, 0x00, 0x4e,
	0x00, 0x1c, 0x00, 0x51, 0x00, 0x18, 0x00, 0x55, 0x00, 0x17, 0x00, 0x59, 0x00, 0x19, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x0c, 0x00, 0x73, 0x00, 0x37, 0x0d, 0x0d, 0x00, 0x3d, 0x00, 0x41, 0x00, 0x41,
	0x00, 0x4d, 0x00, 0x4a, 0x00, 0x62, 0x00, 0x40, 0x00, 0x5d, 0x00, 0x39, 0x00, 0x49, 0x00, 0x37,
	0x00, 0x43, 0x00, 0x37, 0x00, 0x3b, 0x00, 0x38, 0x00, 0x36, 0x00, 0x3e, 0x00, 0x30, 0x00, 0x3b,
	0x00, 0x35, 0x00, 0x3b, 0x00, 0x3a, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02,
	0x00, 0x54, 0x00, 0x27, 0x0d, 0x0d, 0x00, 0x64, 0x00, 0x32, 0x00, 0x5e, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x02, 0x00, 0x52, 0x00, 0x39, 0x0d, 0x0d, 0x00, 0x6b, 0x00, 0x40, 0x00, 0x64,
	0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x63, 0x00, 0x2b, 0x0d, 0x0d, 0x00, 0x55,
	0x00, 0x24, 0x00, 0x5a, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x68, 0x00, 0x2b,
	0x0d, 0x0d, 0x00, 0x51, 0x00, 0x26, 0x00, 0x55, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02,
	0x00, 0x6c, 0x00, 0x27, 0x0d, 0x0d, 0x00, 0x4f, 0x00, 0x20, 0x00, 0x51, 0x00, 0x26, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x02, 0x00, 0x6e, 0x00, 0x24, 0x0d, 0x0d, 0x00, 0x4f, 0x00, 0x1d, 0x00, 0x4f,
	0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x5f, 0x00, 0x35, 0x0d, 0x0d, 0x00, 0x56,
	0x00, 0x2e, 0x00, 0x5e, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x5e, 0x00, 0x35,
	0x0d, 0x0d, 0x00, 0x5f, 0x00, 0x30, 0x00, 0x56, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05,
	0x00, 0x4d, 0x00, 0x5a, 0x0c, 0x0c, 0x00, 0x4d, 0x00, 0x8c, 0x00, 0x47, 0x00, 0x70, 0x00, 0x73,
	0x00, 0x67, 0x00, 0x77, 0x00, 0x75, 0x00, 0x83, 0x00, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0a,
	0x00, 0x6a, 0x00, 0x4c, 0x0d, 0x0d, 0x00, 0x53, 0x00, 0x8c, 0x00, 0x4c, 0x00, 0x8c, 0x00, 0x47,
	0x00, 0x72, 0x00, 0x33, 0x00, 0x50, 0x00, 0x31, 0x00, 0x49, 0x00, 0x34, 0x00, 0x45, 0x00, 0x34,
	0x00, 0x4b, 0x00, 0x37, 0x00, 0x4f, 0x00, 0x40, 0x00, 0x57, 0x00, 0x4f, 0x00, 0x76, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x04, 0x00, 0x53, 0x00, 0x34, 0x0d, 0x0d, 0x00, 0x63, 0x00, 0x2d, 0x00, 0x66,
	0x00, 0x2d, 0x00, 0x6a, 0x00, 0x31, 0x00, 0x64, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04,
	0x00, 0x56, 0x00, 0x30, 0x0d, 0x0d, 0x00, 0x67, 0x00, 0x2d, 0x00, 0x65, 0x00, 0x2c, 0x00, 0x66,
	0x00, 0x2c, 0x00, 0x67, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x4a, 0x00, 0x45,
	0x0d, 0x0d, 0x00, 0x73, 0x00, 0x4b, 0x00, 0x6a, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03,
	0x00, 0x51, 0x00, 0x40, 0x0d, 0x0d, 0x00, 0x69, 0x00, 0x3b, 0x00, 0x6c, 0x00, 0x39, 0x00, 0x6a,
	0x00, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x42, 0x00, 0x47, 0x0d, 0x0d, 0x00, 0x7b,
	0x00, 0x43, 0x00, 0x77, 0x00, 0x46, 0x00, 0x73, 0x00, 0x46, 0x00, 0x70, 0x00, 0x45, 0x00, 0x6c,
	0x00, 0x40, 0x00, 0x73, 0x00, 0x44, 0x00, 0x77, 0x00, 0x44, 0x00, 0x7b, 0x00, 0x42, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x05, 0x00, 0x51, 0x00, 0x5f, 0x0d, 0x0d, 0x00, 0x77, 0x00, 0x75, 0x00, 0x7f,
	0x00, 0x84, 0x00, 0x75, 0x00, 0x7a, 0x00, 0x73, 0x00, 0x75, 0x00, 0x75, 0x00, 0x6c, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x03, 0x00, 0x6d, 0x00, 0x3d, 0x0d, 0x0d, 0x00, 0x4f, 0x00, 0x37, 0x00, 0x49,
	0x00, 0x37, 0x00, 0x4c, 0x00, 0x34, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x6d, 0x00, 0x40,
	0x0d, 0x0d, 0x00, 0x4f, 0x00, 0x37, 0x00, 0x4b, 0x00, 0x39, 0x00, 0x4e, 0x00, 0x37, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x05, 0x00, 0x56, 0x00, 0x38, 0x0c, 0x0c, 0x00, 0x7a, 0x00, 0x4e, 0x00, 0x7a,
	0x00, 0x52, 0x00, 0x79, 0x00, 0x53, 0x00, 0x6d, 0x00, 0x52, 0x00, 0x6a, 0x00, 0x45, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x02, 0x00, 0x5b, 0x00, 0x3b, 0x0d, 0x0d, 0x00, 0x75, 0x00, 0x4c, 0x00, 0x71,
	0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x58, 0x00, 0x46, 0x0d, 0x0d, 0x00, 0x78,
	0x00, 0x55, 0x00, 0x78, 0x00, 0x53, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x58, 0x00, 0x3f,
	0x0d, 0x0d, 0x00, 0x78, 0x00, 0x54, 0x00, 0x75, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05,
	0x00, 0x55, 0x00, 0x42, 0x0d, 0x0d, 0x00, 0x7b, 0x00, 0x51, 0x00, 0x79, 0x00, 0x53, 0x00, 0x77,
	0x00, 0x51, 0x00, 0x7a, 0x00, 0x51, 0x00, 0x7b, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04,
	0x00, 0x1a, 0x00, 0x34, 0x05, 0x05, 0x00, 0x50, 0x00, 0x34, 0x00, 0x53, 0x00, 0x40, 0x00, 0x2b,
	0x00, 0x45, 0x00, 0x1a, 0x00, 0x34, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x66, 0x00, 0x34,
	0x05, 0x05, 0x00, 0x66, 0x00, 0x34, 0x00, 0x85, 0x00, 0x34, 0x00, 0x87, 0x00, 0x37, 0x00, 0x6a,
	0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x25, 0x00, 0x41, 0x04, 0x04, 0x00, 0x2a,
	0x00, 0x46, 0x00, 0x52, 0x00, 0x41, 0x00, 0x52, 0x00, 0x44, 0x00, 0x25, 0x00, 0x4b, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x04, 0x00, 0x14, 0x00, 0x34, 0x04, 0x04, 0x00, 0x19, 0x00, 0x34, 0x00, 0x2a,
	0x00, 0x45, 0x00, 0x26, 0x00, 0x4b, 0x00, 0x14, 0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04,
	0x00, 0x6a, 0x00, 0x37, 0x04, 0x04, 0x00, 0x6a, 0x00, 0x3c, 0x00, 0x87, 0x00, 0x37, 0x00, 0x87,
	0x00, 0x38, 0x00, 0x6c, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x34, 0x00, 0x34,
	0x03, 0x03, 0x00, 0x34, 0x00, 0x34, 0x00, 0x4c, 0x00, 0x34, 0x00, 0x4e, 0x00, 0x39, 0x00, 0x3b,
	0x00, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
	0x0e, 0xa8, 0x00, 0x00, 0x02, 0x22, 0x04, 0x44, 0x06, 0x66, 0x08, 0x88, 0x0a, 0xaa, 0x00, 0x40,
	0x00, 0x80, 0x00, 0xa0, 0x06, 0x42, 0x0c, 0x86, 0x0a, 0x64, 0x00, 0xe0, 0x0e, 0xe0, 0x00
};

const uint8_t Cutscene::_memoSetShape4Data[] = {
	0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0x00, 0x8f, 0x00, 0x3d, 0x0e, 0x0e, 0x00, 0x0a,
	0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
	0x0a, 0xa0, 0x00, 0x00, 0x02, 0x22, 0x04, 0x44, 0x06, 0x66, 0x08, 0x88, 0x0a, 0xaa, 0x00, 0x40,
	0x00, 0x80, 0x00, 0xa0, 0x06, 0x42, 0x0c, 0x86, 0x0a, 0x64, 0x00, 0xe0, 0x0f, 0xf0, 0x00
};

const uint8_t Menu::_flagEn16x12[] = {
	0x73, 0x00, 0x19, 0x8e, 0x00, 0x00, 0x82, 0x91, 0x9d, 0x4e, 0x4f, 0xad, 0x00, 0x00, 0x89, 0x00,
	0x00, 0x89, 0x82, 0x91, 0x9d, 0x8e, 0x00, 0x00, 0x8e, 0x00, 0x00, 0x82, 0x91, 0x9d, 0x00, 0x00,
	0x89, 0x2d, 0x2e, 0x9e, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x8e, 0x00, 0x00, 0x74, 0x00, 0x19,
	0x8e, 0x00, 0x00, 0xef, 0x3d, 0x32, 0xf7, 0xa5, 0xa0, 0xfe, 0xfd, 0xfd, 0x93, 0x93, 0xe9, 0x37,
	0x37, 0xd6, 0xf2, 0xf2, 0xfc, 0xe8, 0x28, 0x28, 0xe8, 0x28, 0x28, 0xf2, 0xf2, 0xfc, 0x74, 0x75,
	0xe2, 0xf4, 0xf5, 0xfc, 0xf9, 0xbb, 0xb7, 0xf0, 0x45, 0x3b, 0xf0, 0x4e, 0x45, 0x8e, 0x00, 0x00,
	0x82, 0x91, 0x9d, 0xf2, 0xa7, 0xa6, 0xec, 0x43, 0x3a, 0xf0, 0x68, 0x60, 0xfc, 0xe8, 0xe7, 0xa7,
	0xa7, 0xed, 0xf2, 0xf2, 0xfc, 0xe8, 0x28, 0x28, 0xe8, 0x28, 0x28, 0xf9, 0xf9, 0xfe, 0xfc, 0xf2,
	0xf2, 0xf2, 0x7d, 0x77, 0xeb, 0x3b, 0x30, 0xf1, 0x95, 0x93, 0xf7, 0xef, 0xf5, 0x73, 0x73, 0xbe,
	0x03, 0x03, 0x8a, 0x99, 0x99, 0xea, 0xf6, 0xea, 0xef, 0xee, 0x85, 0x82, 0xe8, 0x40, 0x37, 0xf6,
	0xb7, 0xb4, 0xfb, 0xfb, 0xfe, 0xe8, 0x28, 0x28, 0xe8, 0x28, 0x28, 0xff, 0xfc, 0xfc, 0xe9, 0x48,
	0x40, 0xed, 0x73, 0x6f, 0xf5, 0xe0, 0xe4, 0xa1, 0xa1, 0xec, 0x47, 0x47, 0xd9, 0x00, 0x00, 0x89,
	0x82, 0x91, 0x9d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x28, 0x28, 0xe8, 0x28, 0x28, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x91, 0x9d,
	0x8e, 0x00, 0x00, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6,
	0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19,
	0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0x8e, 0x00, 0x00,
	0x8e, 0x00, 0x00, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6,
	0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19,
	0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0xe6, 0x19, 0x19, 0x8e, 0x00, 0x00,
	0x82, 0x91, 0x9d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x28, 0x28, 0xe8, 0x28, 0x28, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x91, 0x9d,
	0x00, 0x00, 0x89, 0x87, 0x87, 0xe6, 0xf1, 0xd6, 0xdb, 0xd8, 0x48, 0x45, 0xec, 0xa7, 0xa5, 0xf6,
	0xf8, 0xfc, 0xf8, 0xf8, 0xfe, 0xe8, 0x28, 0x28, 0xe8, 0x28, 0x28, 0xfe, 0xfe, 0xff, 0xf2, 0xc3,
	0xc1, 0xd7, 0x41, 0x3d, 0xee, 0xc4, 0xc8, 0x8f, 0x8f, 0xe8, 0x3f, 0x3f, 0xd8, 0x00, 0x00, 0x89,
	0x82, 0x91, 0x9d, 0xe8, 0xab, 0xad, 0xd2, 0x39, 0x35, 0xf4, 0xcf, 0xce, 0xe4, 0xe6, 0xf8, 0x56,
	0x57, 0xdc, 0xf2, 0xf2, 0xfc, 0xe8, 0x28, 0x28, 0xe8, 0x28, 0x28, 0xf4, 0xf4, 0xfd, 0xdb, 0xdc,
	0xf7, 0xf8, 0xe2, 0xe1, 0xd5, 0x44, 0x41, 0xe3, 0x8f, 0x90, 0xf7, 0xf6, 0xfc, 0x45, 0x45, 0xa9,
	0x8e, 0x00, 0x00, 0xd4, 0x4b, 0x48, 0xfa, 0xeb, 0xeb, 0xd0, 0xd1, 0xf5, 0x40, 0x40, 0xd8, 0x37,
	0x37, 0xd6, 0xf2, 0xf2, 0xfc, 0xe8, 0x28, 0x28, 0xe8, 0x28, 0x28, 0xf2, 0xf2, 0xfc, 0x3a, 0x3a,
	0xd6, 0xbd, 0xbe, 0xf1, 0xfd, 0xf6, 0xf6, 0xda, 0x67, 0x64, 0xd5, 0x53, 0x52, 0x8e, 0x00, 0x00,
	0x74, 0x00, 0x19, 0x8e, 0x00, 0x00, 0x94, 0x95, 0xce, 0x00, 0x00, 0x89, 0x00, 0x00, 0x89, 0x00,
	0x00, 0x89, 0x82, 0x91, 0x9d, 0x8e, 0x00, 0x00, 0x8e, 0x00, 0x00, 0x82, 0x91, 0x9d, 0x00, 0x00,
	0x89, 0x00, 0x00, 0x89, 0x6c, 0x6d, 0xbb, 0x82, 0x91, 0x9d, 0x8e, 0x00, 0x00, 0x74, 0x00, 0x19
};

const uint8_t Menu::_flagFr16x12[] = {
	0x45, 0x2f, 0x9f, 0x46, 0x2f, 0x9e, 0x46, 0x2f, 0x9e, 0x46, 0x2f, 0x9e, 0x46, 0x2f, 0x9e, 0x82,
	0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91,
	0x9d, 0xa5, 0x0a, 0x0a, 0xa5, 0x0a, 0x0a, 0xa5, 0x0a, 0x0a, 0xa5, 0x0a, 0x0a, 0xa5, 0x0a, 0x0a,
	0x46, 0x2f, 0x9e, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xa5, 0x0a, 0x0a,
	0x46, 0x2f, 0x9e, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xa5, 0x0a, 0x0a,
	0x46, 0x2f, 0x9e, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xa5, 0x0a, 0x0a,
	0x46, 0x2f, 0x9e, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xa5, 0x0a, 0x0a,
	0x46, 0x2f, 0x9e, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xa5, 0x0a, 0x0a,
	0x46, 0x2f, 0x9e, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xa5, 0x0a, 0x0a,
	0x46, 0x2f, 0x9e, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xa5, 0x0a, 0x0a,
	0x46, 0x2f, 0x9e, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xa5, 0x0a, 0x0a,
	0x46, 0x2f, 0x9e, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xa5, 0x0a, 0x0a,
	0x46, 0x2f, 0x9e, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0x66, 0x42, 0xf2, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xe5, 0x1d, 0x1d, 0xa5, 0x0a, 0x0a,
	0x46, 0x2f, 0x9e, 0x46, 0x2f, 0x9e, 0x46, 0x2f, 0x9e, 0x46, 0x2f, 0x9e, 0x46, 0x2f, 0x9e, 0x82,
	0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91,
	0x9d, 0xa5, 0x0a, 0x0a, 0xa5, 0x0a, 0x0a, 0xa5, 0x0a, 0x0a, 0xa5, 0x0a, 0x0a, 0xa6, 0x0a, 0x0a
};

const uint8_t Menu::_flagDe16x12[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
	0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
	0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
	0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
	0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
	0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
	0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x00, 0x00, 0x00,
	0xba, 0x01, 0x00, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3,
	0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d,
	0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xba, 0x01, 0x00,
	0xba, 0x01, 0x00, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3,
	0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d,
	0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xba, 0x01, 0x00,
	0xba, 0x01, 0x00, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3,
	0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d,
	0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xba, 0x01, 0x00,
	0xba, 0x01, 0x00, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3,
	0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d,
	0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xe3, 0x1d, 0x1c, 0xba, 0x01, 0x00,
	0xca, 0x80, 0x00, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff,
	0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0,
	0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xca, 0x80, 0x00,
	0xca, 0x80, 0x00, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff,
	0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0,
	0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xca, 0x80, 0x00,
	0xca, 0x80, 0x00, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff,
	0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0,
	0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xff, 0xd0, 0x18, 0xca, 0x80, 0x00,
	0xca, 0x80, 0x00, 0xca, 0x80, 0x00, 0xca, 0x80, 0x00, 0xca, 0x80, 0x00, 0xca, 0x80, 0x00, 0xca,
	0x80, 0x00, 0xca, 0x80, 0x00, 0xca, 0x80, 0x00, 0xca, 0x80, 0x00, 0xca, 0x80, 0x00, 0xca, 0x80,
	0x00, 0xca, 0x80, 0x00, 0xca, 0x80, 0x00, 0xca, 0x80, 0x00, 0xca, 0x80, 0x00, 0xca, 0x81, 0x00
};

const uint8_t Menu::_flagIt16x12[] = {
	0x00, 0x7a, 0x4a, 0x00, 0x7a, 0x4a, 0x00, 0x7a, 0x4a, 0x00, 0x7a, 0x4a, 0x00, 0x7a, 0x4a, 0x82,
	0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91,
	0x9d, 0xab, 0x00, 0x07, 0xab, 0x00, 0x07, 0xab, 0x00, 0x07, 0xab, 0x00, 0x07, 0xaa, 0x00, 0x07,
	0x00, 0x7a, 0x4a, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xab, 0x00, 0x07,
	0x00, 0x7a, 0x4a, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xab, 0x00, 0x07,
	0x00, 0x7a, 0x4a, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xab, 0x00, 0x07,
	0x00, 0x7a, 0x4a, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xab, 0x00, 0x07,
	0x00, 0x7a, 0x4a, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xab, 0x00, 0x07,
	0x00, 0x7a, 0x4a, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xab, 0x00, 0x07,
	0x00, 0x7a, 0x4a, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xab, 0x00, 0x07,
	0x00, 0x7a, 0x4a, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xab, 0x00, 0x07,
	0x00, 0x7a, 0x4a, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xab, 0x00, 0x07,
	0x00, 0x7a, 0x4a, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0x2f, 0xb0, 0x77, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xf4, 0x43, 0x4a, 0xab, 0x00, 0x07,
	0x00, 0x7a, 0x49, 0x00, 0x7a, 0x4a, 0x00, 0x7a, 0x4a, 0x00, 0x7a, 0x4a, 0x00, 0x7a, 0x4a, 0x82,
	0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91,
	0x9d, 0xab, 0x00, 0x07, 0xab, 0x00, 0x07, 0xab, 0x00, 0x07, 0xab, 0x00, 0x07, 0xab, 0x00, 0x07
};

const uint8_t Menu::_flagJp16x12[] = {
	0x82, 0x92, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82,
	0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91,
	0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x83, 0x91, 0x9d,
	0x82, 0x91, 0x9d, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0x82, 0x91, 0x9d,
	0x82, 0x91, 0x9d, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0x82, 0x91, 0x9d,
	0x82, 0x91, 0x9d, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf4,
	0xf2, 0xf4, 0xdf, 0x70, 0x6d, 0xd1, 0x19, 0x13, 0xd1, 0x19, 0x13, 0xdf, 0x70, 0x6d, 0xf4, 0xf2,
	0xf4, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0x82, 0x91, 0x9d,
	0x82, 0x91, 0x9d, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xe1,
	0x7c, 0x7a, 0xd0, 0x11, 0x0b, 0xd0, 0x11, 0x0b, 0xd0, 0x11, 0x0b, 0xd0, 0x11, 0x0b, 0xe1, 0x7c,
	0x7a, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0x82, 0x91, 0x9d,
	0x82, 0x91, 0x9d, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xd3,
	0x26, 0x21, 0xd0, 0x11, 0x0b, 0xd0, 0x11, 0x0b, 0xd0, 0x11, 0x0b, 0xd0, 0x11, 0x0b, 0xd3, 0x26,
	0x20, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0x82, 0x91, 0x9d,
	0x82, 0x91, 0x9d, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xd4,
	0x28, 0x23, 0xd0, 0x11, 0x0b, 0xd0, 0x11, 0x0b, 0xd0, 0x11, 0x0b, 0xd0, 0x11, 0x0b, 0xd4, 0x27,
	0x22, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0x82, 0x91, 0x9d,
	0x82, 0x91, 0x9d, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xe3,
	0x85, 0x84, 0xd0, 0x11, 0x0b, 0xd0, 0x11, 0x0b, 0xd0, 0x11, 0x0b, 0xd0, 0x11, 0x0b, 0xe3, 0x85,
	0x84, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0x82, 0x91, 0x9d,
	0x82, 0x91, 0x9d, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf4,
	0xf4, 0xf7, 0xe1, 0x7d, 0x7b, 0xd4, 0x27, 0x22, 0xd4, 0x27, 0x22, 0xe1, 0x7d, 0x7b, 0xf4, 0xf4,
	0xf7, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0x82, 0x91, 0x9d,
	0x82, 0x91, 0x9d, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0x82, 0x91, 0x9d,
	0x82, 0x91, 0x9d, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5,
	0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8,
	0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0xf5, 0xf8, 0xfb, 0x82, 0x91, 0x9d,
	0x99, 0xa4, 0xaf, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82,
	0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91,
	0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x82, 0x91, 0x9d, 0x98, 0xa4, 0xaf
};

const uint8_t Menu::_flagSp16x12[] = {
	0x8e, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d,
	0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03,
	0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00,
	0x8d, 0x03, 0x00, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff,
	0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f,
	0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0x8d, 0x03, 0x00,
	0x8d, 0x03, 0x00, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff,
	0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f,
	0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0x8d, 0x03, 0x00,
	0xca, 0x80, 0x00, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xd6, 0xad, 0x35, 0xcf, 0xac, 0x46, 0xb5,
	0x9a, 0x5b, 0xc1, 0xa3, 0x56, 0xcb, 0xab, 0x51, 0xe3, 0xbc, 0x42, 0xff, 0xd4, 0x39, 0xff, 0xd4,
	0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xca, 0x80, 0x00,
	0xca, 0x80, 0x00, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd3, 0x39, 0xbf, 0x8e, 0x72, 0xe5,
	0x28, 0x1e, 0xea, 0xe5, 0xe0, 0xca, 0xbb, 0x9e, 0xfe, 0xd5, 0x44, 0xff, 0xd4, 0x39, 0xff, 0xd4,
	0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xca, 0x80, 0x00,
	0xca, 0x80, 0x00, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xcf, 0xae, 0x4f, 0xe5, 0xde, 0xd5, 0xf4,
	0xba, 0xb6, 0xe5, 0x28, 0x1e, 0xdb, 0xd3, 0xc5, 0xd1, 0xb5, 0x67, 0xff, 0xd4, 0x39, 0xff, 0xd4,
	0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xca, 0x80, 0x00,
	0xca, 0x80, 0x00, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xc1, 0xa4, 0x55, 0xe1, 0xda, 0xcf, 0xac,
	0x98, 0x7a, 0xaa, 0x78, 0x59, 0xc3, 0xb5, 0xad, 0xb8, 0x9a, 0x57, 0xff, 0xd4, 0x39, 0xff, 0xd4,
	0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xca, 0x80, 0x00,
	0xca, 0x80, 0x00, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xf7, 0xcd, 0x3d, 0xdf, 0xc8, 0x84, 0xab,
	0x8f, 0x52, 0xc0, 0xa3, 0x56, 0xe3, 0xca, 0x7e, 0xfb, 0xd2, 0x41, 0xff, 0xd4, 0x39, 0xff, 0xd4,
	0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xca, 0x80, 0x00,
	0xca, 0x80, 0x00, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xfb,
	0xd0, 0x3b, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4,
	0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xff, 0xd4, 0x39, 0xca, 0x80, 0x00,
	0x8d, 0x03, 0x00, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff,
	0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f,
	0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0x8d, 0x03, 0x00,
	0x8d, 0x03, 0x00, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff,
	0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f,
	0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0xff, 0x2f, 0x29, 0x8d, 0x03, 0x00,
	0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d,
	0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03,
	0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8d, 0x03, 0x00, 0x8e, 0x03, 0x00
};

const char *PrfPlayer::_names[] = {
	"introl3",
	"option3",
	"journal3",
	"chute3",
	"desinte3",
	"capture3",
	"voyage3",
	"telepor3",
	"planexp3",
	"end31",
	"lift3",
	"present3",
	"gameove3",
	"holo3",
	"memory3",
	"chutevi3",
	"reveil3",
	"misvali3",
	"taxi3",
	"donner3",
	"mission3",
	"objet3",
	"recharg3",
	"generat3",
	"pont3",
	"rechage3"
};

const int PrfPlayer::_namesCount = ARRAYSIZE(_names);

const ResourcePaqEntry ResourcePaq::_entries[] = {
	{ 0x00001039,  0, 26 },
	{ 0x08a52f85,  6, 24 },
	{ 0x08a5805c,  0, 24 },
	{ 0x0e081b27,  0,  7 },
	{ 0x0e087c7e,  6,  7 },
	{ 0x0e1b5c24,  0,  5 },
	{ 0x0e1b83fd,  6,  5 },
	{ 0x16af1e8d,  6, 19 },
	{ 0x16af6f54,  0, 19 },
	{ 0x182b9bc9,  6, 10 },
	{ 0x182beb90,  0, 10 },
	{ 0x18c3ef2a,  3,  2 },
	{ 0x18c42074, 10,  2 },
	{ 0x19c14742,  6,  6 },
	{ 0x19c17e9b,  0,  6 },
	{ 0x1e854e40,  6, 25 },
	{ 0x1e859619,  0, 25 },
	{ 0x208c90f9,  5,  2 },
	{ 0x208c92cc,  9,  2 },
	{ 0x208d98bb,  5,  0 },
	{ 0x208d9a8e,  9,  0 },
	{ 0x208e2d58,  5,  1 },
	{ 0x208e2f6d,  9,  1 },
	{ 0x208fa83f,  5,  5 },
	{ 0x208faa0a,  9,  5 },
	{ 0x2091449e,  5,  4 },
	{ 0x209146ab,  9,  4 },
	{ 0x2391ff67,  0, 15 },
	{ 0x23923ebe,  6, 15 },
	{ 0x2fb61d4f,  6, 16 },
	{ 0x2fb65c96,  0, 16 },
	{ 0x321e730a, 12,  2 },
	{ 0x321e7b89,  4,  2 },
	{ 0x321ea488, 11,  2 },
	{ 0x321ed556, 13,  2 },
	{ 0x321ee5fc,  1,  2 },
	{ 0x321ee633,  2,  2 },
	{ 0x32407b0b,  4,  0 },
	{ 0x32408388, 12,  0 },
	{ 0x3240b50a, 11,  0 },
	{ 0x3240e5d4, 13,  0 },
	{ 0x3240f631,  2,  0 },
	{ 0x3240f67e,  1,  0 },
	{ 0x32539bcb, 12,  1 },
	{ 0x3253a448,  4,  1 },
	{ 0x3253cd49, 11,  1 },
	{ 0x32540597, 13,  1 },
	{ 0x3254167d,  1,  1 },
	{ 0x325416b2,  2,  1 },
	{ 0x3284a48c, 12,  5 },
	{ 0x3284f535,  2,  5 },
	{ 0x32b9cd4d, 12,  4 },
	{ 0x32ba25b4,  2,  4 },
	{ 0x3bf1f5c2, 11,  4 },
	{ 0x3bf21ec3,  4,  4 },
	{ 0x3bf2239c, 13,  4 },
	{ 0x3bf23436,  1,  4 },
	{ 0x3c052600,  4,  3 },
	{ 0x3c052e01, 11,  3 },
	{ 0x3c05655f, 13,  3 },
	{ 0x3c057535,  1,  3 },
	{ 0x3c106f0f,  0, 22 },
	{ 0x3c10bfd6,  6, 22 },
	{ 0x41907702,  6,  9 },
	{ 0x4190af5b,  0,  9 },
	{ 0x43014da4,  7,  3 },
	{ 0x43018680, 14,  0 },
	{ 0x43e24d42,  6, 20 },
	{ 0x43e2849b,  0, 20 },
	{ 0x4eb06a97,  8,  4 },
	{ 0x4eb0b316,  8,  5 },
	{ 0x4ec16216,  8,  2 },
	{ 0x4ec1c397,  8,  3 },
	{ 0x4ed25995,  8,  0 },
	{ 0x4ed2c314,  8,  1 },
	{ 0x51031061, 10,  3 },
	{ 0x5103843f,  3,  3 },
	{ 0x597d5389,  7,  1 },
	{ 0x59acc8c7,  3,  0 },
	{ 0x59ad1c19, 10,  0 },
	{ 0x68750080,  6, 21 },
	{ 0x68754959,  0, 21 },
	{ 0x693ed4ae,  6,  4 },
	{ 0x693f1d77,  0,  4 },
	{ 0x72233560,  0, 27 },
	{ 0x72237d39,  6, 27 },
	{ 0x90c1edc9,  0, 12 },
	{ 0x90c22d10,  6, 12 },
	{ 0x912b75c4,  6, 11 },
	{ 0x912bbd9d,  0, 11 },
	{ 0x92cffb04,  0, 13 },
	{ 0x92d0335d,  6, 13 },
	{ 0xb5d7f0a5,  0, 23 },
	{ 0xb5d8207c,  6, 23 },
	{ 0xbdf1ee40, 10,  1 },
	{ 0xbdf2621e,  3,  1 },
	{ 0xc28f67f0,  7,  4 },
	{ 0xc85e93c0,  6, 14 },
	{ 0xc85edb99,  0, 14 },
	{ 0xc8d9a9c1,  4,  5 },
	{ 0xc8d9b1c0, 11,  5 },
	{ 0xc8d9df9e, 13,  5 },
	{ 0xc8d9f034,  1,  5 },
	{ 0xc930c903, 11,  6 },
	{ 0xc930f202,  4,  6 },
	{ 0xc931005d, 13,  6 },
	{ 0xc9311037,  1,  6 },
	{ 0xd028ec6b,  8,  7 },
	{ 0xd029456a,  8,  6 },
	{ 0xd9de38cc,  0,  8 },
	{ 0xd9de7015,  6,  8 },
	{ 0xe3dd675e,  7,  2 },
	{ 0xe3ff885c,  7,  0 },
	{ 0xe501ba80,  6,  2 },
	{ 0xe5020359,  0,  2 },
	{ 0xe5223c8b,  6, 17 },
	{ 0xe5227cd2,  0, 17 },
	{ 0xeaf9a981, 10,  4 },
	{ 0xeafa1e5f,  3,  4 },
	{ 0xecde9285,  6, 18 },
	{ 0xecdee35c,  0, 18 },
	{ 0xf3a238a3,  6,  0 },
	{ 0xf3a2897a,  0,  0 },
	{ 0xf7de62cd,  6,  3 },
	{ 0xf7deb294,  0,  3 },
	{ 0xfedf9dce,  0,  1 },
	{ 0xfedfe597,  6,  1 },
	{ 0xffffb7e0,  6, 26 }
};

const int ResourcePaq::_entriesCount = ARRAYSIZE(_entries);

const char *ResourcePaq::_names[] = {
	"POL", "PGE", "PAL", "OFF", "OBJ", "CT", "CMD", "DEMO", "IMG", "RP", "SPR", "ANI", "MBK", "TBN", "GLOBAL"
};

const int ResourcePaq::_namesCount = ARRAYSIZE(_names);
