% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproj-extent.R
\name{reproj_extent}
\alias{reproj_extent}
\title{Reproject extent}
\usage{
reproj_extent(extent, target, limit = NULL, ..., source = NULL)
}
\arguments{
\item{extent}{a four element vector of extent \code{c(xmin, xmax, ymin, ymax)}}

\item{target}{target specification (PROJ.4 string or epsg code)}

\item{limit}{if used, a one or two element numeric vector to give the maximum radius to the edge of the extent from the middle}

\item{...}{arguments passed to \code{\link[proj4:transform]{proj4::ptransform()}}}

\item{source}{source specification (PROJ.4 string or epsg code)}
}
\value{
four value extent \code{c(xmin, xmax, ymin, ymax)}
}
\description{
A four figure extent (xmin, xmax, ymin, ymax) is used to approximate the boundary of its
reprojected version by interpolating new vertices along each edge.
}
\details{
This is a simple version of what GDAL's 'SuggestedWarpOutput' does, and similar functions like
the raster package 'projectExtent()'.

Internal functions unpack the various stages, and might be exposed in future. These stages are
\enumerate{
\item interpolate around the boundary with correct ordering (can be used as a polygon or line)
\item reproject the interpolated boundary
\item summarize the interpolated boundary to the new extent
}
}
\examples{
reproj_extent(c(0, 10, 0, 20), "+proj=laea", source = "+proj=longlat")
}
