% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalebar.R
\name{addscalebar}
\alias{addscalebar}
\title{Auto Plot Scalebar}
\usage{
addscalebar(
  plotunit = NULL,
  plotepsg = NULL,
  widthhint = 0.25,
  unitcategory = "metric",
  htin = 0.1,
  padin = c(0.15, 0.15),
  style = "bar",
  bar.cols = c("black", "white"),
  lwd = 1,
  linecol = "black",
  tick.cex = 0.7,
  labelpadin = 0.08,
  label.cex = 0.8,
  label.col = "black",
  pos = "bottomleft"
)
}
\arguments{
\item{plotunit}{The unit which the current plot is plotted in, one of \code{cm},
\code{m}, \code{km}, \code{in}, \code{ft}, \code{mi}. or \code{latlon}. This
parameter is optional if \code{plotepsg} is passed.}

\item{plotepsg}{The projection of the current plot. If extents are valid lat/lons,
the projection is assumed to be lat/lon (EPSG:4326), or Spherical Mercator otherwise
(EPSG:3857). This is done to work seamlessly with OpenStreetMap packages.}

\item{widthhint}{The fraction of the plottable width which the scale bar should
(mostly) occupy.}

\item{unitcategory}{One of "metric" or "imperial"}

\item{htin}{Height (in inches) of the desired scale bar}

\item{padin}{A vector of length 2 determining the distance in inches between the scalebar
and the edge of the plottable area.}

\item{style}{One of "bar" or "ticks".}

\item{bar.cols}{If \code{style=="bar"}, the colors to be repeated to make the bar.}

\item{lwd}{The line width to use when drawing the scalebar}

\item{linecol}{The line color to use when drawing the scalebar}

\item{tick.cex}{If \code{style=="ticks"}, the height of interior ticks.}

\item{labelpadin}{The distance between the end of the scalebar and the label (inches)}

\item{label.cex}{The font size of the label}

\item{label.col}{The color of the label}

\item{pos}{Where to align the scalebar. One of "bottomleft", "bottomright", "topleft",
or "topright".}
}
\description{
Automatically determines the geographical scale of the plot and
draws a labelled scalebar.
}
\examples{
plot(1:5, 1:5, asp=1)
addscalebar(plotunit="m")

}
