% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git-protocol.R
\name{git_list_files}
\alias{git_list_files}
\title{List files in a remote git repository}
\usage{
git_list_files(url, ref = "HEAD")
}
\arguments{
\item{url}{Repository URL, e.g. \verb{https://github.com/r-lib/pak.git}.
It might include authentication information, e.g. a GitHub token.}

\item{ref}{Either a SHA or a ref name. It may also be a branch name
without the \code{refs/heads} prefix, or a partial (but unique) SHA of
at least seven hexadecimal digits.
See \code{\link[=git_list_refs]{git_list_refs()}} for how branches, tags and GitHub pull
requests are named.}
}
\value{
A list with entries:
\itemize{
\item \code{ref}: The \code{ref} the function was called with.
\item \code{sha}: SHA of \code{ref}.
\item \code{commit}: named character vector of the data of the commit object
belonging to \code{ref}. It has fields named: \code{tree}, \code{parent},
\code{author}, \code{committer}, \code{encoding}, \code{message}.
\item \code{tree}: SHA of the \code{tree} object belonging to \code{commit}.
\item \code{files}: a data frame of files and directories. It has columns:
\itemize{
\item \code{hash}: SHA hash of the tree or blob.
\item \code{type}: Either \code{"tree"} or \code{"blob"}.
\item \code{mode}: Unix mode.
\item \code{path}: Relative path from the repository's root directory.
}
}
}
\description{
List files in a remote git repository
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{fls <- git_list_files("https://github.com/r-lib/pak.git", "refs/heads/main")
fls$files
#>                                         hash type   mode
#> 1   78637c7741f1d05b867e6380b39841f1cc93c6ae blob 100644
#> 2   09365afed2c2de2690f0a2242998b429a74385ee tree  40000
#> 3   2d19fc766d98a08d9d1437896bfb008a7b15f340 blob 100644
#> 4   3e048b6fbe23121b71a8b6e49d78c75b8a211ced tree  40000
#> 5   9b71b7d8638f643f41d9d2eb13017ce72bb60134 blob 100644
#> 6   d906b2bad68d3d516127d003f005a5ccef912235 blob 100644
#> 7   2718673d32485ebc9a92c2b6dfde4e444ab55e7a blob 100644
#> 8   b9f2c86fd564d49bb17b3c5001f8fc3889172e14 blob 100644
#> 9   27a004b785b382edc66d48a4e23d03a255d5de5c blob 100644
#> 10  0d8d414b0375b28538cdf8389691fe2fecfbd47e blob 100644
#> 11  97271eb29faf3b1cecb81f5f7e7caf732c380bc4 blob 100644
#> 12  4b65418291f5c25e76750e3506a05430f623f73f blob 100644
#> 13  02fe05be5eaedabc818c6a3a4494b86561146815 blob 100644
#> 14  398a86d33a97dda48ddf5d8d775a3acab11bd02f blob 100644
#> 15  e0871627c1a339b113f3c37b558c1d9c361d0613 blob 100644
#> 16  ab25a2db01855917a3cee50cba8dcbbdff008e27 blob 100644
#> 17  b464e4652c292e274d1557a59ccf77c31ff1d0ea blob 100644
#> 18  16634163e7dd63b68dde40f6d33a368c0f52ad7b tree  40000
#> 19  cc0b4c1a148451aed7508a6dceef65734e1e81ae blob 100644
#> 20  d992e9f19ef2cdae01f31a59a4c5c2ca42e8bc6e blob 100644
#> 21  ddee0eaff1186dc75bd892ceeb4bb6a763553dbd blob 100644
#> 22  34860cf4adecb83d71e481dce5377c56c7aff53d blob 100644
#> 23  0e5cae27866cdd3dbb334c2d756b120f74d3acf2 blob 100644
#> 24  8d7b0b5e9ed3f6c183fd8ca9b8639156bd6568f9 blob 100644
#> 25  c45156b7dcf689e2bec9c38fa7760c04c665489c blob 100644
#> 26  bbad5095b4f5da6707fe7636a26d0cbe3b76f562 blob 100644
#> 27  d2236e702180ce578b7af8c10ff22a73f47bac5c blob 100644
#> 28  e8df0e553f1235e493264cf2b66981772de10f71 blob 100644
#> 29  5e3f4c049761c50c636d02f0c7214f84c3155302 blob 100644
#> 30  c6a2c28489f590160a7e75a18b910b6d0834ab4c blob 100644
#> 31  09123886d32910c815f53809098e09304518420f blob 100644
#> 32  07e5117d02d56f17864435cb4711d44c9b402d77 blob 100644
#> 33  8b4046c479b3ef98e995c898a20ade4280eb0838 blob 100644
#> 34  6d0209d93f8e87c08c038e9ddffba176294369a3 blob 100644
#> 35  2b615ee9e1f062391280476a558f65edb7a7908e blob 100644
#> 36  9f6edd092486f92a080df8b6712f503fd7824193 blob 100644
#> 37  3b46adf93274cfc402f3a24abb123101ce401a8e blob 100644
#> 38  8e7d159dbdc6ae2f2cd021576c62de37d0407633 blob 100644
#> 39  3cf6e5a441eb00a227a98a2b0c32da7e34dd8d52 blob 100644
#> 40  f277587288a01b20b1b896b70b59fc0ca4422428 blob 100644
#> 41  23bc3da8517a75db4ad69e30f7e79f6da52b4758 blob 100644
#> 42  40f6f0162de3172cd27b140809a91da2f61f1499 blob 100644
#> 43  3356ee4bb7ef406f1103669be14b5df4368dfe9b blob 100644
#> 44  a8ade609dd10a9da209277238e3d5fba586918be blob 100644
#> 45  db30fdc8f45f09108b2e543027f9b4532797a1a7 blob 100644
#> 46  8ebbddd4fa5fec9941ac149b442aa2ead1df6b54 blob 100644
#> 47  99fa806f2a20f2e31d0c5fda57296cde323b2ed0 blob 100644
#> 48  ece743c56ec87c879f8feae78b369dc74fafa903 blob 100644
#> 49  c91a1ebf5bd3a065fab680e19e06a9a2fb361169 blob 100644
#> 50  435614511f3e6fb4f3ce083eda7a5fd708aa16d5 blob 100644
#> 51  062b171dfe9761cc1b6fef5dcdebdfb54a455484 blob 100644
#> 52  db73a46218520379d4a322c26fec19a68f802fbb blob 100644
#> 53  7d168c39d4a6d7bcc08216d5cdd69d32c10544ee blob 100644
#> 54  2e2f5dd3d7e95a8efe14b66ee11f71b3d4b2dff1 blob 100644
#> 55  ca48de1b748b8cd82fe6251cdf67e9dcc02d1e12 blob 100644
#> 56  ba16de3e25c0b98d1d7d1fcaf1cd5ed377d46975 blob 100644
#> 57  391e1fa7b5334b8c4ec7609b1cb7428cdb4602e7 blob 100644
#> 58  34509a42215e00f1a2b2e83eebe52d8433451dd6 blob 100644
#> 59  351c3e7bc9eae89276958ab699d2aec059650c12 blob 100644
#> 60  0adcdf2b124cbced9bf4b2ba3aa373e35db7ad8a blob 100644
#> 61  a351cb8fa452aa7a3d5219be475795c9dbf81a78 blob 100644
#> 62  597abaccad4473498e2ae58c2521d35e0c699bd6 blob 100755
#> 63  04c55859903c1a7db8ce30f4a37f144795cce7c4 blob 100644
#> 64  a6fbe0b30e28e44255d7bb7860e155a235062c9a blob 100755
#> 65  994f9fdcd999611bc799761323fba728edf79389 blob 100644
#> 66  025b39ee265412d822f515f991ce81d39d52cb8b tree  40000
#> 67  cdf512b63d1e4709f538107ad9bdfec0828e56b8 blob 100644
#> 68  f6138ff9081cd95a7d18801e1d89c5f04e5866f1 tree  40000
#> 69  c3b2104e779ca5ca3a79ee69fc7d1041cbe977f6 blob 100644
#> 70  99d774f214e479cfb5d63055afa8fbcb583111f2 blob 100644
#> 71  e8e94bf558013a41dca7de2200ffb2daa3c46770 tree  40000
#> 72  a82fed0623dc0a20a0ccfceb0baceda61144801a blob 100644
#> 73  d6459e005434a49a66a3ddec92279a86160ad71f blob 100644
#> 74  ba11122d4ef6842a3901dfe4f08b9e91aadf1bfb blob 100644
#> 75  25b6e2293346439646077441c41ffc77c20fad1d blob 100644
#> 76  e3b63731626da84ef1f4af9d63c5284408629b4c blob 100644
#> 77  a8afa85ec5c8fd965b74e31a9267e20ad75f5243 blob 100644
#> 78  c32822a40b4a26156da35265d219e15b1b8ba51b blob 100644
#> 79  4c1a1aeb066f22b0ec1f71ae0b42dc9c686b899b tree  40000
#> 80  19a17499e520a9040d13cdb46c98605b4ec21b9d blob 100644
#> 81  fbd95956ddddff2c33a7095103d7a3435b837fdc tree  40000
#> 82  6c613005a2b2b5b1892f2220888c625f992d29ee blob 100644
#> 83  88302306891209038aa0d25f3e5bf5002812e086 blob 100644
#> 84  ab19d1cc3798b651f02a28ceb2cd00cd432207b6 blob 100644
#> 85  621ab042b5c98815ce2eaa25f65eaed1851d6d05 blob 100644
#> 86  c5b9874a2f342052f690e622163d7fa202439dcf blob 100644
#> 87  bb7c1c80e1675267d35174a3c7af47c1132b142b blob 100644
#> 88  95c7c05cd177ad28aa6a1fa00d5b67d2cf954077 tree  40000
#> 89  4d3a18e1abbc29f0facacb0e48e2c00cc3113e16 blob 100644
#> 90  863a64ce1d9c96ba0dc0a7d1832f9c9fb0e9f0ee blob 100644
#> 91  a16a6b75c8a0c73ac56d3f851de1d5ce3e3e97a2 blob 100644
#> 92  d26b353c949e4720978a24f847a5488422b23ab7 blob 100644
#> 93  57e26c7eeccb26cec849f3de52e640fb81076013 blob 100644
#> 94  4071a5a590525325930c0242bfd1f33503bf195c blob 100644
#> 95  2f7049ae7f268d4185333718813e23895ab769ea blob 100644
#> 96  65304a330f52028b5622f227502267a6f1cadcdd blob 100644
#> 97  bc278d72b4f342585d3a9dc4a15dab610298c58e blob 100644
#> 98  51cd88fcf36a1a40da3d5c4ed9739e5047230de7 blob 100644
#> 99  3b20bab9000d791e1991947ac5525b141c5b5dd8 blob 100644
#> 100 9836125cb5dc016f22c6cdea72edfec7477f968d blob 100644
#> 101 6ff2166291d7e9514cb7561b4dd6f59adf9ffa1b blob 100644
#> 102 379c0aa9015ff343d73da8ec37f39fe60f275e21 blob 100644
#> 103 e206c9ea9faabc2c765fe08df489861cfb13273a blob 100644
#> 104 7220d3271aa842edf6d21fc74ca08763a29ddf9a blob 100644
#> 105 c41dd490b63048c5c763a94ff8bfba1be1913dde blob 100644
#> 106 f7bb775c4cdb68b6e3dfeb6bf81246028559f812 blob 100644
#> 107 f657cb12851b53427e799ed39810d0f6cccf8721 blob 100644
#> 108 f74333c25f4691082e1dca8a68f8893a0961f975 blob 100644
#> 109 8a66ec44325a69c96b6409e1d680f934db005a9f blob 100644
#> 110 c5514b382cc5acb15fd55bf65bc3cf57343ed442 blob 100644
#> 111 c75bf73c8a095046862ff2d88cc00bda55c964ba blob 100644
#> 112 3b34b39ffbf4459bfb61f26f10bac2c37d067a74 blob 100644
#> 113 5c40d48c034b2c140b411cc97249cbc29928e3d5 tree  40000
#> 114 ec5c3152480c860a7891341f922352cbd2578c49 blob 100644
#> 115 779824c68264b03ca1b370493c68935c05111dd0 blob 100644
#> 116 64d294582713e9179c5021027699e3cbf0e2064f blob 100644
#> 117 945355ddf0b1a401b43d2587871eecef560ccb87 blob 100644
#> 118 14ebcc4bf98a8df856723a58b30715a474f79683 blob 100644
#> 119 0f290b95d53ce469fe776d2d9e49826b658c98a8 blob 100644
#> 120 21a2426182a8685d40ef20e2641d8f81fd700db8 blob 100644
#> 121 6570312475be4e1a077725cccf3c48af49d89ed5 blob 100644
#> 122 0c107388edf8276ddb41345ae12800af4f10861f blob 100644
#> 123 933f9c94ee403ef0abd8c35c9ef5f73b47ebfeee blob 100644
#> 124 feec47fafdf68fb5252d4f7068977e9a17d6df44 blob 100644
#> 125 ab3ad9618f073b704509fb6db338164c09e652f0 blob 100644
#> 126 606507c0cbc321dac5da2faebc3f687160310725 blob 100644
#> 127 0c6844a99c5f86a1f992061f77a1bf0e5be5185f blob 100644
#> 128 10eee6579377f6c1bbd4f2816a171777105dd935 blob 100644
#> 129 34ae0b70c57113e27cd8570aeaccdb75d0d7aa10 blob 100644
#> 130 902d269ac9e6ed617245785eafcf86097683b080 blob 100644
#> 131 56bd4dded11a76997485fbb42670194c4b6af022 blob 100644
#> 132 c77ac48379e2b00d18f6091ca459fbadd7cc9bd7 blob 100644
#> 133 45ccd98504cf1334c36930ec6adf4bcb87b07454 blob 100644
#> 134 11c167b9d57d7f8e6da22a991c8cff651d7ddf95 blob 100644
#> 135 4e631fe83ce7a46b4bf6d5ac890e6d2551f714d8 blob 100644
#> 136 b71efd8f0f61d95e8ada1088b3be41743a4b8b3e blob 100644
#> 137 1ef531fdc641016b347eb39ae7a4d31af30c541f blob 100644
#> 138 4a48f62c7f735c48ef4c93e0b79a4e7eb40d9f42 blob 100644
#> 139 721eb3e08884c2bfca365183d80ed24ad1dcd6f3 tree  40000
#> 140 2bb9ea0544508dcf9d419bf976bf6e0b9ca249cb blob 100644
#> 141 270314b87d171300f76501b32e8a0354926d9c84 blob 100644
#> 142 261949d09b1fb399b89e48430f5ca18d3a41b34a tree  40000
#> 143 65d5e8e273c120c2bfe0f73a3a4a934e5c81c7eb blob 100644
#> 144 b556efa9133831e2c7fd52092b4b9b74d5b5234f tree  40000
#> 145 9043e8f13610b5e4d25b3520959704058e8df210 tree  40000
#> 146 53589d891b748348206f5b3660a2eab2cfad868e blob 100644
#> 147 ee1b568a9714489e1f2afe58af5517402dd67288 blob 100644
#> 148 93cdf17fc1fc85b62e344dee549e6679c15daf1f blob 100644
#> 149 669cbd2f5b3c5c493f3139d2731b8a0ff52e4dc4 blob 100644
#> 150 e64a41a84776f9d52a4016f1363f648c3403621b blob 100644
#> 151 0ff31ac05c572f1b797faa1de823bbf64a156773 blob 100644
#> 152 7083b82932c1df6117ed4348a6b75eba0210e9e6 blob 100644
#> 153 ab41d001d7a5b8a0e6ebead68844106b905add60 blob 100644
#> 154 bf707418d737259ecdefeee50358f4b904b6b2c6 blob 100644
#> 155 63c494c86d0721196c560f2abb05ed5def1bf5bf blob 100644
#> 156 01b5f065f869e4dd302c86983d76fc5561f61d46 blob 100644
#> 157 1cb24179f61be7f6257c505b0ef8e64a6666d8c7 blob 100644
#> 158 9448734642b391308c0cc142d2ea2c5eee5e58ac blob 100644
#> 159 071c6c4c9c83d52c3609f31ffd8b25333308ca2d tree  40000
#> 160 cc96b41c901541add156a02c39dbfda0ff1cb898 tree  40000
#> 161 552a325bc9790007ec52353c33d03e57ad263978 tree  40000
#> 162 0ce1318498219e9783606b303c90cf2fc893369d blob 100644
#> 163 49e8e97903bde8a58026712473021d5d3ff17da7 blob 100644
#> 164 088477679097737cccdc1bd46d90b577b88a4817 blob 100644
#> 165 9811c5c118d9d190eee3d605bb38c42cf6a3f3d9 blob 100644
#> 166 fc40496978d53be1e58be4a1359cc10b15d23c96 tree  40000
#> 167 58efaf8c4bfed6d3624b0e9fb1bef845951b09a9 blob 100644
#> 168 2ec0d3edc4c016a043028bd748ee09b6f8df0273 blob 100644
#> 169 f8090ad4071bf668868f50c7754ad968cf85cdbf blob 100644
#> 170 7e62ecf2bdea2bdbb1d530cf79c0d451bc9cc294 blob 100755
#> 171 165c68c868430f8129739ca53631645545f4c2bb tree  40000
#> 172 a65b41774ad52b3cc7b60496d35eaafc5da4bb16 blob 100644
#> 173 8260e0f7ee227b2fc002179bb7fe6720ddf2cb34 blob 100644
#> 174 dd8700466c8dafabf9ab08c0bc9dc6fe5ea8b82b blob 100644
#> 175 13f0120982af72c5ed254fcbb74192dc5c20a3f0 tree  40000
#> 176 9d2d50de04bfa00067b74c6d5428d266d8674a7e blob 100644
#>                                                path
#> 1                                     .Rbuildignore
#> 2                                           .github
#> 3                                .github/.gitignore
#> 4                                 .github/workflows
#> 5                .github/workflows/R-CMD-check.yaml
#> 6              .github/workflows/build-package.yaml
#> 7                      .github/workflows/build.yaml
#> 8   .github/workflows/linux-builder-containers.yaml
#> 9                    .github/workflows/nightly.yaml
#> 10                   .github/workflows/pkgdown.yaml
#> 11               .github/workflows/pr-commands.yaml
#> 12             .github/workflows/test-coverage.yaml
#> 13                                       .gitignore
#> 14                                      DESCRIPTION
#> 15                                         Makefile
#> 16                                        NAMESPACE
#> 17                                          NEWS.md
#> 18                                                R
#> 19                           R/aaa-rstudio-detect.R
#> 20                             R/build-pak-binary.R
#> 21                                        R/cache.R
#> 22                                 R/compat-vctrs.R
#> 23                                 R/confirmation.R
#> 24                           R/cran-install-order.R
#> 25                          R/default-cran-mirror.R
#> 26                                 R/deps-explain.R
#> 27                                     R/dev-mode.R
#> 28                                         R/docs.R
#> 29                               R/embed-ca-certs.R
#> 30                                    R/embed-lib.R
#> 31                                       R/errors.R
#> 32                                        R/extra.R
#> 33                                    R/formatted.R
#> 34                               R/global-handler.R
#> 35                                         R/json.R
#> 36                                      R/library.R
#> 37                                        R/local.R
#> 38                                     R/lockfile.R
#> 39                                   R/name-check.R
#> 40                                       R/onload.R
#> 41                                      R/package.R
#> 42                                  R/pak-cleanup.R
#> 43                                  R/pak-install.R
#> 44                                   R/pak-update.R
#> 45                                          R/pak.R
#> 46                                        R/print.R
#> 47                                  R/private-lib.R
#> 48                                R/push-packages.R
#> 49                                         R/repo.R
#> 50                               R/rstudio-detect.R
#> 51                            R/safe-cran-install.R
#> 52                                       R/search.R
#> 53                                   R/subprocess.R
#> 54                          R/system-requirements.R
#> 55                                    R/terminate.R
#> 56                                       R/unload.R
#> 57                                        R/utils.R
#> 58                                  R/warn-loaded.R
#> 59                                       README.Rmd
#> 60                                        README.md
#> 61                                     _pkgdown.yml
#> 62                                          cleanup
#> 63                                      codecov.yml
#> 64                                        configure
#> 65                                    configure.win
#> 66                                             data
#> 67                           data/pak_sitrep_data.R
#> 68                                             inst
#> 69                                    inst/WORDLIST
#> 70                                   inst/header.md
#> 71                                       inst/tools
#> 72                         inst/tools/pkg_1.0.0.tgz
#> 73                                   inst/tools/xxx
#> 74                               inst/tools/xxx.bz2
#> 75                                inst/tools/xxx.gz
#> 76                            inst/tools/xxx.tar.gz
#> 77                                inst/tools/xxx.xz
#> 78                               inst/tools/xxx.zip
#> 79                                              man
#> 80                                     man/cache.Rd
#> 81                                       man/chunks
#> 82                               man/chunks/FAQ.Rmd
#> 83                          man/chunks/features.Rmd
#> 84                           man/chunks/install.Rmd
#> 85                              man/chunks/tldr.Rmd
#> 86                                       man/faq.Rd
#> 87                                  man/features.Rd
#> 88                                      man/figures
#> 89                        man/figures/cran-dark.svg
#> 90                             man/figures/cran.svg
#> 91                        man/figures/deps-dark.svg
#> 92                             man/figures/deps.svg
#> 93                     man/figures/explain-dark.svg
#> 94                          man/figures/explain.svg
#> 95                          man/figures/gh-dark.svg
#> 96                               man/figures/gh.svg
#> 97                       man/figures/local-dark.svg
#> 98                            man/figures/local.svg
#> 99                        man/figures/tldr-cran.svg
#> 100                              man/get-started.Rd
#> 101                 man/handle_package_not_found.Rd
#> 102                                  man/install.Rd
#> 103                               man/lib_status.Rd
#> 104                               man/local_deps.Rd
#> 105                       man/local_deps_explain.Rd
#> 106                            man/local_install.Rd
#> 107                       man/local_install_deps.Rd
#> 108                   man/local_install_dev_deps.Rd
#> 109                      man/local_package_trees.Rd
#> 110                man/local_system_requirements.Rd
#> 111                          man/lockfile_create.Rd
#> 112                         man/lockfile_install.Rd
#> 113                                      man/macros
#> 114                              man/macros/eval.Rd
#> 115                                 man/metadata.Rd
#> 116                 man/package-dependency-types.Rd
#> 117                               man/pak-config.Rd
#> 118                                      man/pak.Rd
#> 119                              man/pak_cleanup.Rd
#> 120                        man/pak_install_extra.Rd
#> 121                      man/pak_package_sources.Rd
#> 122                                man/pak_setup.Rd
#> 123                               man/pak_sitrep.Rd
#> 124                               man/pak_solver.Rd
#> 125                               man/pak_update.Rd
#> 126                                 man/pkg_deps.Rd
#> 127                         man/pkg_deps_explain.Rd
#> 128                            man/pkg_deps_tree.Rd
#> 129                             man/pkg_download.Rd
#> 130                              man/pkg_history.Rd
#> 131                              man/pkg_install.Rd
#> 132                           man/pkg_name_check.Rd
#> 133                               man/pkg_remove.Rd
#> 134                               man/pkg_search.Rd
#> 135                               man/pkg_status.Rd
#> 136                                 man/repo_add.Rd
#> 137                                 man/repo_get.Rd
#> 138                              man/repo_status.Rd
#> 139                                     man/roxygen
#> 140                              man/roxygen/meta.R
#> 141                                       pak.Rproj
#> 142                                           tests
#> 143                                tests/testthat.R
#> 144                                  tests/testthat
#> 145                           tests/testthat/_snaps
#> 146                  tests/testthat/_snaps/print.md
#> 147                        tests/testthat/helpers.R
#> 148                          tests/testthat/setup.R
#> 149                    tests/testthat/test-bundle.R
#> 150           tests/testthat/test-create-pak-repo.R
#> 151                  tests/testthat/test-platform.R
#> 152                     tests/testthat/test-print.R
#> 153               tests/testthat/test-private-lib.R
#> 154                      tests/testthat/test-repo.R
#> 155                tests/testthat/test-subprocess.R
#> 156       tests/testthat/test-system-requirements.R
#> 157                        tests/testthat/test-ui.R
#> 158                     tests/testthat/test-utils.R
#> 159                                           tools
#> 160                                     tools/build
#> 161                               tools/build/linux
#> 162                    tools/build/linux/Dockerfile
#> 163            tools/build/linux/Dockerfile-builder
#> 164                      tools/build/linux/Makefile
#> 165              tools/build/linux/Makevars-builder
#> 166                               tools/build/macos
#> 167                    tools/build/macos/.gitignore
#> 168                      tools/build/macos/Makefile
#> 169              tools/build/macos/Makevars-curl.in
#> 170                   tools/build/macos/download.sh
#> 171                             tools/build/windows
#> 172                  tools/build/windows/.gitignore
#> 173                    tools/build/windows/Makefile
#> 174                            tools/dynamic-help.R
#> 175                                       vignettes
#> 176                         vignettes/internals.Rmd
}\if{html}{\out{</div>}}
}

\keyword{internal}
