% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{debugme}
\alias{debugme}
\title{Debug R Packages}
\usage{
debugme(env = topenv(parent.frame()), pkg = environmentName(env))
}
\arguments{
\item{env}{Environment to instument debugging in. Defaults to the
package environment of the calling package.}

\item{pkg}{Name of the calling package. The default should be fine
for almost all cases.}
}
\description{
Specify debug messages as special string constants, and control
debugging of packages via environment variables.
}
\details{
To add debugging to your package, you need to
\enumerate{
\item Import the \code{debugme} package.
\item Define an \code{.onLoad} function in your package, that calls \code{debugme}.
An example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{.onLoad <- function(libname, pkgname) \{ debugme::debugme() \}
}\if{html}{\out{</div>}}
}

By default debugging is off. To turn on debugging, set the \code{DEBUGME}
environment variable to the names of the packages you want to debug.
Package names can be separated by commas.

This environment variable is read when the package is loaded,
and with every call to \code{debugme()}.

Example \code{debugme} entries:

\if{html}{\out{<div class="sourceCode">}}\preformatted{"!DEBUG Start Shiny app"
}\if{html}{\out{</div>}}
}
\section{Dynamic debug messsages}{


It is often desired that the debug messages contain values of R
expressions evaluated at runtime. For example, when starting a Shiny
app, it is useful to also print out the path to the app. Similarly,
when debugging an HTTP response, it is desired to log the HTTP status
code.

\code{debugme} allows embedding R code into the debug messages, within
backticks. The code will be evaluated at runtime. Here are some
examples:

\if{html}{\out{<div class="sourceCode">}}\preformatted{"!DEBUG Start Shiny app at `path`"
"!DEBUG Got HTTP response `httr::status_code(reponse)`"
}\if{html}{\out{</div>}}

Note that parsing the debug strings for code is not very sophisticated
currently, and you cannot embed backticks into the code itself.
}

\section{Log levels}{

\code{debugme} has two ways to organize log messages into log levels:
a quick informal way, and a more formal one.

For the informal way, you can start the \code{!DEBUG} token with multiple
\code{!} characters. You can then select the desired level of logging via
\code{!} characters before the package name in the \code{DEBUGME} environment
variable. E.g. \code{DEBUGME=!!mypackage} means that only debug messages
with two or less \code{!} marks will be printed.

A more formal way is to use log level names: \code{"FATAL"}, \code{"ERROR"},
\code{"WARNING"}, \code{"INFO"}, \code{"DEBUG"}, and \code{"VERBOSE"}. To specify the log
level of the message, append the log level to \code{"!DEBUG"}, with a dash.
E.g.:

\if{html}{\out{<div class="sourceCode">}}\preformatted{"!DEBUG-INFO Just letting you know that..."
}\if{html}{\out{</div>}}

To select the log level of a package, you can specify the level either
with the number of \code{!} characters, as above, or adding the log level
as a suffix to the package name, separated by a dash. E.g.:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Sys.setenv(DEBUGME = "mypackage-INFO")
}\if{html}{\out{</div>}}

(Use either methods to set the log level, but do not mix them.)
}

\section{Debug stack}{

By default \code{debugme} prints the \emph{debug stack} at the beginning of
the debug messages. The debug stack contains the functions in the call
stack that have (and emit) debug messages. To suppress printing the call
stack set the \code{DEBUGME_SHOW_STACK} environment variable to \code{no}.
}

\section{Redirecting the output}{


If the \code{DEBUGME_OUTPUT_FILE} environment variable is set to
a filename, then the output is written there instead of the standard
output stream of the R process.

If \code{DEBUGME_OUTPUT_FILE} is not set, but \code{DEBUGME_OUTPUT_DIR} is, then
a log file is created there, and the name of the file will contain
the process id. This is is useful for logging from several parallel R
processes.
}

