/*
    default.cpp
    OpenAG, libOpenAG, OpenAG X
    
    Created by Eric Seidel on Wed Mar 20 2002.
    
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    ****************
    
    This, and all other platform specific code sections are required
    by all modules and should be adapted per header-file specification
    to each individual platform.
    
    This is the default platform specific code, and MUST BE ADAPTED in
    order to work properly on each system.  Changes should eventually
    be added to the Autoconf system whenever that gets up and running.
*/

#include "common.h"

//#include "AGString.h"

#include "AGMain.h"
#include "AGPrefs.h"
#include <errno.h>


int AGMove(const char* PathFrom, const char* PathTo)
{
    /*
    if(link(PathFrom, PathTo) == 0)
    {
        if(unlink(PathFrom) != 0)
        {
            if(unlink(PathTo) !=0)
                err_exit("SERIOUS error encountered while moving files... Filelinks may be corrupt... \nFrom: %s\nTo: %s\nPlease report.\n", PathFrom, PathTo);
            else
            {
                err_print("Linking errors prevented file move.\nFrom: %s\nTo: %s  Check to make sure that the directory exists then please report.\n", PathFrom, PathTo);
                return(-1);
            }
        }
        else
            return 0;
    }
    
    return (-1);
    */
    
    
    errno = 0;
    if ((PathFrom == NULL) || (PathTo == NULL))
    {
        err_print("woh.  AGMove was passed a null pointer!\n That's no good.\n");
        return (-1); // defensive programming.
    }

    int size = PATH_MAX + PATH_MAX + 20;
    char* temp = new char[size];
    memset(temp, '\0', size);
    snprintf(temp, size, "mv \"%s\" \"%s\"", PathFrom, PathTo);
    int theReturn = 0;
    if (system(temp) != 0) theReturn = -1;
    delete(temp);
    
    return theReturn;
}
/*
AGString::AGString(unsigned char* theBuffer, unsigned short int type)
{
    if (theBuffer == NULL) return;
    
    switch(type)
    {
    case kAGServerEncoding:
        break;
    case kAGLocalDisplayEncoding:
        break;
    case kAGLocalFileSystemEncoding:
        break;
    default:
        err_exit("Improper use of AGString, you passed type: %i\n", type);
    }
    
    Data = strdup(theBuffer);
}

AGString::~AGString()
{
    if (Data != NULL)
        delete(Data);
}

void AGString::getBufferWithEncoding(unsigned char*& theBuffer, int& length, unsigned short int type)
{
    if (theBuffer != NULL)
        delete(theBuffer);
    theBuffer = NULL;
    length = 0;
    if (Data == NULL) return;
    
    switch(type)
    {
    case kAGServerEncoding:
        //Truncate code!
        break;
    case kAGLocalDisplayEncoding:
        break;
    case kAGLocalFileSystemEncoding:
        break;
    default:
        err_exit("Improper use of AGString, you passed type: %i\n", type);
    }
    
    theBuffer = strdup(Data);
    length = strlen(Data);
}

unsigned int AGString::length()
{
    return strlen((char*)Data);
}

*/


unsigned short int string_serverToLocal(unsigned char* &newString, unsigned const char* oldString, unsigned short int theLength)
{
    /* SHOULD IMPLEMENT HERE FOR YOUR SPECIFIC PLATFORM.  COPY THIS FILE, IMPLEMENT AND ADD TO AUTOCONF */
    if (newString != NULL) delete newString;
    newString = (unsigned char*)strdup((const char*)oldString);
    return theLength;
}

unsigned short int string_localToServer(unsigned char* &newString, unsigned const char* oldString, unsigned short int theLength)
{
    /* SHOULD IMPLEMENT HERE FOR YOUR SPECIFIC PLATFORM.  COPY THIS FILE, IMPLEMENT AND ADD TO AUTOCONF */
    if (newString != NULL) delete newString;
    newString = (unsigned char*)strdup((const char*)oldString);
    return theLength;
}




