/*
    AGPrefs.h
    OpenAG, libOpenAG, OpenAG X
    
    Created by Eric Seidel on Thu Nov 22 2001.
    
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _AGPREFS_H_
#define _AGPREFS_H_

#define AG_DEFAULT_SCAN_DEPTH		100

struct ShareFolder
{
    char*  	  	FolderPath;	// Maybe AGString???
    unsigned int   	ScanDepth;
};

class AGPrefs
{
public:
    AGPrefs(); // constructs empty AGPref object
    ~AGPrefs();
    
    int readFromDisk(const char* BaseDirectory); // reads prefs from disk
    
    char*  	EmailAddress;	// AGString?
    char*  	Password;	// needs to be AGString
    bool	IsGoldAccount;
    
    ShareFolder**	ShareDirectories;
    char* 		FinishedDownloadsDirectory;	// NOT AGString
    char* 		IncompleteDownloadsDirectory;	// NOT AGString
    
    char*		SpecifiedIP;  // NOT AGString
    
    int		IncomingLimit;
    int		OutgoingLimit;
};

#endif


