//////////////////////////////////////////////
// NovaWM - Nova Window Manager for X11     //
//////////////////////////////////////////////
// By: Tim Walters                          //
//////////////////////////////////////////////
// Copyright (C) 2001-2002 Tim Walters      //
//////////////////////////////////////////////

////////////////////////////////////////////////////////////////
//This code is released under the terms of the GNU GPL. Refer //
//to the license file included with this source code.         //
////////////////////////////////////////////////////////////////


#include "novawm.h"

Config::Config ()
{
  itemExec = (char **) calloc (sizeof (char *), 81);
  disableBar = false;
  clockFormat = 1;
}

Config::~Config ()
{
}

void
Config::LoadMenu ()
{
  FILE *menuFile = 0;
  char menuFName[355];
  char *line;
  int lineType = 0;

  strcpy (menuFName, getenv ("HOME"));

  nMenuItems = 0;

  strcat (menuFName, "/.novawm.menu");

  menuFile = fopen (menuFName, "r");

  if (!menuFile)
    {
      printf ("novawm: failed to open %s\n", menuFName);
      //No Menu file, at least add xterm
      novaMenu.AddItem ("xterm");
      itemExec[0] = (char *) malloc (81);
      itemExec[0] = "xterm";
      return;
    }

  line = (char *) malloc (255);	//new char;

  while (fgets (line, 255, menuFile) != NULL)
    {
      //Remove the \n from each line
      line[strlen (line) - 1] = ' ';
      if (lineType == 0)
	{
	  novaMenu.AddItem (line);
	}

      if (lineType == 1)
	{
	  itemExec[nMenuItems] = line;
	  nMenuItems++;
	}

      if (lineType == 0)
	lineType = 1;
      else
	lineType = 0;

      line = (char *) malloc (81);

    }

//      fclose(menuFile);

}
