//NovaWM Desktop Manager
//By: Tim Walters

#include "dmgr.h"

int screen;
Window root;
int pagerWidth;
int pagerHeight;
Window pagerWindow;
NovaWM_Window_Hints *novawmWindowHints;
Atom novawmWindowHints_Atom;

void Create_Pager()
{
	XSetWindowAttributes attr;

	screen = DefaultScreen(display);

	root = RootWindow(display,screen);
	
	attr.background_pixel = WhitePixel(display,screen);

	attr.event_mask = ExposureMask|ButtonPressMask|ButtonReleaseMask|
		FocusChangeMask;

	pagerWidth = 3 * (XDisplayWidth(display,screen)/16)+8;
	pagerHeight = 2 * (XDisplayHeight(display,screen)/20)+8;
	
	pagerWindow = XCreateWindow(display,root,PAGER_X,PAGER_Y,pagerWidth,
			pagerHeight,0,DefaultDepth(display,screen),
			CopyFromParent,DefaultVisual(display,screen),
			CWBackPixel|CWEventMask,&attr);

	XStoreName(display,pagerWindow,"Desktop Manager");

	XMapWindow(display,pagerWindow);

	Update();
	
	Pager_Events();
	
}

void Pager_Events()
{
	XEvent event;

	while(1)
	{
		XNextEvent(display,&event);
		switch(event.type)
		{
			case Expose:
				break;
				
		}
	}
}

void Update()
{
	Atom wmHints;
	Atom cList = XInternAtom(display,"_WIN_CLIENT_LIST",true);
	int format;
	unsigned long dummy,items;
	NovaWM_Hints *data;
	int *wdata;

	Status status = XGetWindowProperty(display,root,novawmHints_Atom,0L,
			20L,false,XA_CARDINAL,&wmHints,
			&format,&dummy,&dummy,(unsigned char **)&data);

	if(status != Success)
		return;

	printf("CURRENT DESKTOP %d\n",data->nDesktops);
	
	XFree(data);

	XGetWindowProperty(display,root,cList,0,0x7fffffff,false,
			XA_CARDINAL,&wmHints,&format,&items,
			&dummy,(unsigned char **)&wdata);

	printf("ITEMS: %d\n",items);
	int i = 0;
	while(wdata[i])
	{
		printf("WID: %x\n",wdata[i]);
		i++;
	}
		
	
}

