//By: Tim Walters

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include <stdio.h>

class NovaWM_Window_Hints
{
public:
  int hasTitlebar;
  int hasBorder;
  int titlebarPosition;
  int hasKillButton;
  int hasStretchButton;
  int hasHideButton;
  unsigned int backgroundColor;
  int textStlye;
  unsigned int textColor;
  int noMoving;
  int desktop;
  int x, y, width, height;
};

//Needed to get window geometry for desktop previews
class Novawm_Window
{
public:
  Window window;
  Window titlebar;
  Window kill;
  Window stretch;
  Window hide;
  Window *tChild;		//Transient Window
  char *title;
  int x, y, width, height;
  int orig_width, orig_height;
  int state;
  int nTChildren;
  int desktop;
  bool hasTitlebar;
  bool isTransient;
  bool ignoreTransient;
  XSizeHints *size_hints;
  NovaWM_Window_Hints *novawm_window_hints;

  Novawm_Window *prev;
  Novawm_Window *next;
};

class NovaWM_Hints
{
public:
  int currentDesktop;
  int nDesktops;
  int maxDesktops;
  int nWindows;
  Novawm_Window *topWindow;
  unsigned int defaultColor;
};

#define PAGER_X XDisplayWidth(display,screen)-pagerWidth-4
#define PAGER_Y XDisplayHeight(display,screen)-pagerHeight-4

extern Display *display;
extern int screen;
extern Window root;
extern Window pagerWindow;

extern int pagerWidth;
extern int pagerHeight;

extern NovaWM_Hints *novawm_hints;
extern int nDesktops;
extern int cDesktop;

extern Atom novawmHints_Atom;
extern Atom novawmWindowHints_Atom;

void Create_Pager ();
void Update ();
void Update_Pager ();
void New_Desktop ();
void Remove_Desktop (int desktop);
void Pager_Events ();
