use strict;
use warnings;

package ConfigHandler;

sub new() {
    my $self  = {};
    $self->{"ifname"} = "test_design.html";
    $self->{"ofnametxt"} = "result.txt";
    $self->{"ofnamebsl"} = "result.bsl";
    bless($self);           # but see below
    return $self;
}

sub read($) {
  my $self = shift;

  if(open(my $fh, "C:\\levelparser.conf")) {
      my @lines = <$fh>;
      foreach my $line (@lines) {
          chomp $line;
          if($line =~ /(.*)=(.*)/) {
            my ($key, $val) = ($1, $2);
            if(defined($self->{$key})) {
                $self->{$key} = $val;
            }
          }
      }
  }
}

sub write($$$$) {
    my $self = shift;
    ($self->{"ifname"}, $self->{"ofnametxt"}, $self->{"ofnamebsl"}) = @_;
    open(my $fh, ">", "C:\\levelparser.conf") or return;
    foreach my $key (qw[ifname ofnametxt ofnamebsl]) {
        print $fh "$key=" . $self->{$key} . "\n";
    }
    close($fh);
}

1;
