// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//


#include "globals.h"
#include "showpicture.h"
#include "memops.h"
#include "errorhandler.h"
#include "engine.h"
#include "drawprimitives.h"
#include "bsscreen.h"

void showPicture(const char *fname, Uint32 ticks) {
	//Uint32 lasttick = BS_GetTicks() + ticks;

	if(enableColor3D) {
		BS_Set3DMode(COLOR3D_NONE);
	}
	
	SDL_Surface* temp2 = BS_IMG_Load_DisplayFormat(configGetPath(fname),DIE_ON_FILE_ERROR);
/*
	// Lock Surfaces if needed
	if (SDL_MUSTLOCK(temp2))
		if (SDL_LockSurface(temp2) < 0)
			return;
	if (SDL_MUSTLOCK(gScreen))
		if (SDL_LockSurface(gScreen) < 0)
			return;

	Uint32 pitch_tmp = temp2->pitch / 4;
	Uint32 pitch_bg = gScreen->pitch / 4;
	Uint32 i, j;

	// Copy the background into the bigger surface
	for(i=0; i < (Uint32)temp2->w; i++) {
		for(j=0; j < (Uint32)temp2->h; j++) {
			((Uint32 *)gScreen->pixels)[j * pitch_bg + i] =
			((Uint32 *)temp2->pixels)[j * pitch_tmp + i];
		}
	}

	// Unlock Surfaces if needed
	if (SDL_MUSTLOCK(gScreen))
		SDL_UnlockSurface(gScreen);
	if (SDL_MUSTLOCK(temp2))
		SDL_UnlockSurface(temp2);

	// Tell SDL to update the whole screen
	BS_Flip(gScreen);

	// Wait until time is up
	int timediff = BS_GetTicks() - lasttick ;
	if(timediff < 0) {
		SDL_Delay(- timediff);
	}
*/
	
	SDL_BlitSurface(temp2, NULL, gScreen, NULL);
	
	// Tell SDL to update the whole screen
	BS_Flip(gScreen);

	SDL_FreeSurface(temp2);

}
