// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information

#ifndef DISABLE_NETWORK

#ifndef HTTPCLIENT_H
#define HTTPCLIENT_H

#include "globals.h"

#ifndef DISABLE_NETWORK
#include <SDL_net.h>
#endif // DISABLE_NETWORK

class HTTPClient
	{
	public:
		HTTPClient(const char* server, Uint32 port, bool debug, const char * proxyurl);
		~HTTPClient();
	
#ifdef SATISFY_CPP_WITH_USELESS_CONSTRUCTORS
		// Now two dummy functions for the fools of the C++ consortium who require this, if it's used or not...
		// Calling this functions will exit(1) the program, just to shut up the g++ compiler
		HTTPClient(const HTTPClient& bullshit);
		HTTPClient& operator= (const HTTPClient& bullshit);
#endif // SATISFY_CPP_WITH_USELESS_CONSTRUCTORS
		
		bool get(char* relative_url);
		bool networkstatus(); /* returns true, if networking is okay, false if it is not (*very* simple networking test - DNS resolve did not work */
		
		void setDebug(bool debug);
		bool save(char* fname);
		
	private:
		bool m_debug;
		IPaddress* m_ip;		/* Server address */
		TCPsocket m_sd;		/* Socket descriptor */
		char m_hostname[1000];
		Uint32 oldpercent;
		
		void printDebug(const char* txt);
		bool sendLine(const char* line);
		bool getLine(char* line);
		bool getData(int length);
		void showProgress(Uint32 percent);
		SDL_Surface* downloadbg;
		SDL_Surface* progressbar;
		
	public:
		char* m_extbuffer;
		Uint32 m_size;
		
	};
#endif // HTTPCLIENT_H
#endif // DISABLE_NETWORK

