// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See LICENSE for licensing information
//


#include "globals.h"
#include "fginlay.h"
#include "errorhandler.h"
#include "blending.h"
#include "engine.h"
#include "drawprimitives.h"

SDL_Surface *FGInlay;
SDL_Surface *FGInlay_help;
SDL_Surface *FGInlay_news;

typedef enum _FGINLAY {
	FGINLAY_WAITBLANK,
	FGINLAY_FADEINBAR,
	FGINLAY_FADEINHELP,
	FGINLAY_WAITDISPLAYHELP,
	FGINLAY_FADEOUTHELP,
	FGINLAY_FADEINNEWS,
	FGINLAY_WAITDISPLAYNEWS,
	FGINLAY_FADEOUTNEWS,
	FGINLAY_FADEOUTBAR
} FGINLAY;

FGINLAY inlaystate;
Uint32 inlayalpha;
Uint32 inlaycounter;
Uint32 inlaybaralpha;

void initFGInlay()
{
	FGInlay_help = BS_IMG_Load_DisplayFormat(configGetPath("needhelpinlay.bmp"),DIE_ON_FILE_ERROR);
	FGInlay_news = BS_IMG_Load_DisplayFormat(configGetPath("newsflashinlay.bmp"),DIE_ON_FILE_ERROR);
}

void deInitFGInlay ()
{
	SDL_FreeSurface(FGInlay_help);
	SDL_FreeSurface(FGInlay_news);
}

void resetFGInlay()
{
	inlaystate = FGINLAY_WAITBLANK;
	inlayalpha = 0;
	inlaycounter = 500;
	inlaybaralpha = 255;
}

void calcFGInlay()
{
	switch(inlaystate) {			
		case FGINLAY_WAITBLANK:
			inlaycounter--;
			if(!inlaycounter) {
				inlaystate = FGINLAY_FADEINBAR;
				inlaycounter = 0;
				FGInlay = FGInlay_help;
			}
			break;
		case FGINLAY_FADEINBAR:
			inlaybaralpha--;
			if(inlaybaralpha == 128) {
				inlaystate = FGINLAY_FADEINHELP;
			}
			break;
		case FGINLAY_FADEINHELP:
			inlayalpha++;
			if(inlayalpha == 255) {
				inlaystate = FGINLAY_WAITDISPLAYHELP;
				inlaycounter = 1000;
			}
			break;
		case FGINLAY_WAITDISPLAYHELP:
			inlaycounter--;
			if(!inlaycounter) {
				inlaystate = FGINLAY_FADEOUTHELP;
			}
			break;
		case FGINLAY_FADEOUTHELP:
			inlayalpha--;
			if(inlayalpha == 0) {
				inlaystate = FGINLAY_FADEINNEWS;
				FGInlay = FGInlay_news;
			}
			break;
		case FGINLAY_FADEINNEWS:
			inlayalpha++;
			if(inlayalpha == 255) {
				inlaystate = FGINLAY_WAITDISPLAYNEWS;
				inlaycounter = 1000;
			}
			break;
		case FGINLAY_WAITDISPLAYNEWS:
			inlaycounter--;
			if(!inlaycounter) {
				inlaystate = FGINLAY_FADEOUTNEWS;
			}
			break;
		case FGINLAY_FADEOUTNEWS:
			inlayalpha--;
			if(inlayalpha == 0) {
				inlaystate = FGINLAY_FADEOUTBAR;
			}
			break;
		case FGINLAY_FADEOUTBAR:
			inlaybaralpha++;
			if(inlaybaralpha == 255) {
				inlaystate = FGINLAY_WAITBLANK;
				inlaycounter = 3000;
			}
			break;
	}
			
}

void renderFGInlay()
{

	if(inlaybaralpha == 255) {
		return;
	}
	
	Uint32 i, j;
	Uint32 scrpitch = gScreen->pitch / 4;
	Uint32 fgpitch = FGInlay->pitch / 4;
	Uint32 fgpixel, scrpixel;
	
	// Dark rectangle blending for text
	//blend_darkenRect(0, 447, 640, 32, 0x00808080);
	blend_darkenRect(0, 447, 640, 32, inlaybaralpha | (inlaybaralpha << 8) | (inlaybaralpha << 16));

	if(!inlayalpha) {
		return;
	}	
	
	// Foreground
	// Lock foreground if needed
	if (SDL_MUSTLOCK(FGInlay))
		if (SDL_LockSurface(FGInlay) < 0) 
			return;

	// Draw non-transparent parts of FG
	for(i=0; i < 640; i++) {
		for(j=0; j < 32; j++) {
			fgpixel = ((Uint32 *)FGInlay->pixels)[j * fgpitch + i];
			if(fgpixel != 0x00ff00) {
				scrpixel = ((Uint32 *)gScreen->pixels)[(j+447) * scrpitch + i];
				if(inlayalpha == 255) {
					((Uint32 *)gScreen->pixels)[(j+447) * scrpitch + i] = 
							((Uint32 *)FGInlay->pixels)[j * fgpitch + i];
				} else {
					((Uint32 *)gScreen->pixels)[(j+447) * scrpitch + i] = blend_alpha(scrpixel, fgpixel, inlayalpha);
				}
			}
		}
	}
	
	
	// Unlock foreground if needed
	if (SDL_MUSTLOCK(FGInlay)) 
		SDL_UnlockSurface(FGInlay);
	
}

