#ifndef DISABLE_NETWORK
#include "globals.h"

#ifndef BLPFRAMES_H
#define BLPFRAMES_H

#define BLPSCR_M 0
#define BLPSCR_H 8
#define BLPSCR_W 18

#define BLPKATE_X 9
#define BLPKATE_Y 3

#define BLP_XOFFSET TILESIZE/2
#define BLP_YOFFSET TILESIZE*3.0/4.0

#include <SDL_net.h>

struct BLP_Frame {
	char magic[4];
	char frameNum[4];
	char width[2];
	char height[2];
	char pixels[144]; // currently fixed
};

void initBLPSocket();
void deInitBLPSocket();
void initBLPFrames();
void deInitBLPFrames();
void sendBLPFrame();
void clearBLPFrame();
void showBLPTiles();
void showBLPFgObjects();
void showBLPPixels();
void showBLPMonster();
void initBLPMovie(const char* filename);
bool showBLPMovie();
void deInitBLPMovie();

extern BLP_Frame currentBLPFrame;
extern Uint32 currentBLPFrameNum;

extern UDPsocket BLPsd;
extern UDPpacket *BLPp;
#endif // DISABLE_NETWORK

#endif // BLPFRAMES_H
