#
# Commands: /ASCII, /COLSAY, /COLME, /COLTOPIC, /COLKICK, /COLQUIT
# Usage:
#	/ASCII [-c1234] [-f <fontname>] [-p <prefix>] [-l|-s|-m <where>] <text>
#	/COLSAY [-1234] [-m <where>] <text>
#	/COLME [-1234] <text>
#	/COLTOPIC [-1234] <text>
#	/COLKICK [-1234] [nick(,nick_1,...,nick_n)] <reason>
#	/COLQUIT [-1234] <reason>
# Settings:
#	/SET ascii_figlet_path [path]
#	/SET ascii_default_font [fontname]	
#	/SET ascii_default_colormode [1-4]
#	/SET ascii_default_prefix [prefix]
#	/SET ascii_default_kickreason [reason]
#	/SET ascii_default_quitreason [reason]
#
# Script is bassed on figlet.
#

package COLORTXT;
use strict;
use warnings;

use vars qw($VERSION %IRSSI);

# defaults
my $ascii_last_color = undef;
my @ascii_colors = (12, 12, 12, 9, 5, 4, 13, 8, 7, 3, 11, 10, 2, 6, 6, 6, 6, 10, 8, 7, 4, 3, 9, 11, 2, 12, 13, 5);

# int randcolor()
sub randcolor {
	return $ascii_colors[int(rand(12)+2)];
}

# str colorline($colormode, $text)
sub colorline {
	my ($colormode, $text) = @_;
	my $colortext = undef;
	my $last = ($ascii_last_color) ? $ascii_last_color : randcolor();
	my $indx = $last;

	if ($colormode =~ /3/) {
		$ascii_last_color = randcolor();
	}elsif ($colormode =~ /4/) {
		$ascii_last_color = $ascii_colors[$last];
	}elsif ($colormode !~ /2/) {
		$ascii_last_color = $ascii_colors[14+$last];
	}

	while ($text =~ /./g)
	{
		my $char = "$&";

		if ($colormode =~ /3/) {
			while ($indx == $last) { $indx = randcolor(); };
			$last = $indx;
		}elsif ($colormode =~ /4/) {
			$indx = $ascii_colors[$indx];
		}elsif ($last) {
			$indx = $ascii_colors[$last];
			undef $last;
		} else {
			$indx = $ascii_colors[$indx];
			$last = $indx + 14;
		};

		$colortext .= $char, next if ($char eq " ");
		$colortext .= "\003" . sprintf("%02d", $indx) . $char;
		$colortext .= $char if ($char eq ",");
	};

	return $colortext;
};
