#!/usr/bin/perl

use strict;
use warnings;

foreach my $fname (@ARGV) {
	$fname =~ s/\r//g;
	chomp $fname;

	if($fname =~ /errorhandler.cpp/) {
		print "IGNORING errorhandler.cpp\n";
		next;
	}

	print "Formatting $fname...\n";
	
	open(my $ifh, "$fname") or die("$!");
	my @lines = <$ifh>;
	close $ifh;

	open(my $ofh, ">", $fname) or die("$!");
	foreach my $line (@lines) {
		$line =~ s/\r//go;
		chomp $line;
		$line =~ s/\ \ \ \ /\t/go;
		print $ofh "$line\n";
	}
	close $ofh;
}
