#!/bin/bash

# Blinkensisters compiletest with various versions of cmake, options, ...
# run it from the "cmake-build" directory with ../SCRIPTS/compiletest.sh

# be sure to be in the cmake-build directory, because the script executes "rm -rf *"

cmakeversions="/usr/bin/cmake"   # included in my distribution: 2.4.7
cmakeversions="$cmakeversions /usr/local/cmake-2.6.0/bin/cmake"
cmakeversions="$cmakeversions /usr/local/cmake-2.6.1/bin/cmake"
#cmakeversions="$cmakeversions /usr/local/cmake-2.4.2/bin/cmake" # That version causes an error - not supported

mixersettings="USE_SDL_MIXER=ON USE_SDL_MIXER=OFF"
networksettings="USE_SDL_NET=ON USE_SDL_NET=OFF"
theorasettings="USE_THEORA=ON USE_THEORA=OFF"

for cm in $cmakeversions ; do
	for mix in $mixersettings ; do
		for net in $networksettings ; do
			for theo in $theorasettings ; do
				rm -rf *
				echo $cm -D$mix -D$net -D$theo ..
				$cm -D$mix -D$net ..
				make 
				done
		done
	done
done