#!/usr/bin/perl
die("For testing only!");

# BlinkGame - Hunt for the Lost Pixels
# an SDL game in honor of the BlinkenArea crew
#
# (C) 2005-06 Rene Schickbauer
#
# See License.txt for licensing information
#

use strict;
use warnings;

print "Generating operating system dependand 'osdef.h'...\n";

my @lines = `uname -a`;

my $osstring = shift @lines;
chomp $osstring;

print " OS: $osstring\n";
my $osname;
my $sdl;
my $sdlmixer;

if($osstring =~ /Darwin/) {
    $osname = "Darwin (MacOSX) / XCode 2.2";
    $sdl = "SDL/SDL.h";
    $sdlmixer = "SDL_Mixer.h";
} elsif($osstring =~ /Linux/) {
    $osname = "Linux / Generic";
    $sdl = "SDL/SDL.h";
    $sdlmixer = "SDL/SDL_mixer.h";
} elsif($osstring =~ /WIN/) {
    $osname = "Win32 / Generic";
    $sdl = "SDL.h";
    $sdlmixer = "SDL_mixer.h";
} else {
    die("Can't determine OS correctly - edit OS_deps.pl");
}

open(my $fh, ">", "osdef.h") or die("Can't write to osdef.h");
print $fh "// AUTO-GENERATED FILE - NO NOT EDIT\n" .
          "//\n" .
          "//\n" .
          "// Generated for: $osname\n" .
          "\n" .
          "\n" .
          "#ifndef OSDEPS_H\n" .
          "#define OSDEPS_H\n" .
          "#include <$sdl>\n" .
          "#include <$sdlmixer>\n" .
          "#endif // OSDEPS_H\n" .
          "";
close $fh;

print "DONE (used '$osname' defaults)\n";
