// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//


#include <stdlib.h>
#include "../globals.h"
#include "blinkensound.h"
#include "../errorhandler.h"
#include <string.h>


int audio_rate = 22050;
Uint16 audio_format = AUDIO_S16SYS; /* 16-bit stereo */
int audio_channels = 2;
Uint32 audio_buffers = 2048;
bool soundInitOK = false;
bool isPlaying = false;
bool isPaused = false;

char captureSound[8192];

void initSound()
{
	/* This is where we open up our audio device.  Mix_OpenAudio takes
	as its parameters the audio format we'd /like/ to have. */
	if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers)) {
		printf("Unable to open audio!\n");
		soundInitOK = false;
		return;
	} else {
		soundInitOK = true;
		Mix_HookMusicFinished(soundMusicFinished);
		if(!Mix_RegisterEffect(MIX_CHANNEL_POST, soundCaptureOutput, NULL, NULL)) {
            printf("Unable to register display callback\n");                                         
        }
	}
	
	/* If we actually care about what we got, we can ask here.  In this
	program we don't... yet */
	Mix_QuerySpec(&audio_rate, &audio_format, &audio_channels);
	memset(captureSound, 0, sizeof(captureSound));
}

void soundLoad(Uint32 idx, char* fname) {
	char fullfname[MAX_FNAME_LENGTH];
	sprintf(fullfname, "%s", configGetPath(fname));
	titles[idx].sdlmusic = Mix_LoadMUS(fullfname);
	if(!titles[idx].sdlmusic) {
		DIE(ERROR_SOUND_READ, fullfname);
	}
}

void deInitSound()
{
	if(!soundInitOK) {
		return;
	}
	soundStopMusic();
	
	for(Uint32 i = 0; i < 100; i++) {
       if(titles[i].sdlmusic) {
           Mix_FreeMusic(titles[i].sdlmusic);
           titles[i].sdlmusic = 0;
       }
    }
	
	Mix_CloseAudio();
	soundInitOK = false;
}

void soundStartMusic()
{
	if(!soundInitOK) {
		return;
	}
	if(isPaused) {
        soundPauseMusic();
        return;
    }
	if(isPlaying) {
        soundStopMusic();
    }
	
	Mix_PlayMusic(titles[curSnd].sdlmusic, 1);
	Mix_VolumeMusic(MIX_MAX_VOLUME / 2);
	isPlaying = true;
}

void soundStopMusic()
{
	if(!soundInitOK) {
		return;
	}
	if(isPaused) {
        soundPauseMusic();
    }
	
	Mix_HaltMusic();
	isPlaying = false;
}

void soundStepNext() {
     curSnd++;
     if(curSnd == maxSnd) {
         curSnd = 0;
     }
     if(isPaused) {
         soundStopMusic();
     } else if(isPlaying) {
         soundStartMusic();
     }
}

void soundStepPrev() {
     if(curSnd == 0) {
         curSnd = maxSnd;
     }
     curSnd--;
     if(isPaused) {
         soundStopMusic();
     } else if(isPlaying) {
         soundStartMusic();
     }
}

void soundPauseMusic() {
     if(!isPlaying) {
         return;
     }
     if(!isPaused) {
         Mix_PauseMusic();
     } else {
         Mix_ResumeMusic();
     }
     isPaused = !isPaused;
}
     
void soundMusicFinished() {
	soundStepNext();
}

void soundCaptureOutput(int chan, void* stream, int len, void* udata) {
     memcpy(captureSound, stream, len);
     if(chan || udata) {
             // Supress "unused variables" warning
     }
}
