// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//

#include "bl_lua_obj_engine.h"

#define NEED_REGISTER_FUNCTION
#include "bl_lua.h"
#undef NEED_REGISTER_FUNCTION

// Kills the engine
int luaObjDie(lua_State *L) {
	if(!lua_isstring(L, 1)) {
		LUADIE(L, ERROR_LUAL2BTYPE, "");
	} else {
		LUADIE(L, ERROR_LUAL2BDIE, (char *)lua_tostring(L, 1));
	}
	return 0;
}

// Loads an additional file
int luaObjInclude(lua_State *L) {
	Uint32 n = lua_gettop(L);
	if(n != 1) {
		LUADIE(L, ERROR_LUAARGCOUNT, "luaObjInclude");
	}

	if(!lua_isstring(L, 1)) {
		LUADIE(L, ERROR_LUAL2BTYPE, "");
	} else {
		char fullfname[MAX_FNAME_LENGTH];
		sprintf(fullfname, "%s", configGetPath(lua_tostring(L, 1)));
		if(luaL_loadfile(L, fullfname)) {
			LUADIE(L, ERROR_LUALOAD, (char *)lua_tostring(L, -1));
		}
		if(lua_pcall(L,0,0,0)) {
			LUADIE(L, ERROR_LUAPARSE, (char *)lua_tostring(L, -1));
		}
	}
	return 0;
}

// Plays a video
int luaObjPlayVideo(lua_State *L) {
	char name[1000];
	bool trackergui = false;
	bool userCanCancel = false;
	Uint32 n = lua_gettop(L);
	if(n != 3) {
		LUADIE(L, ERROR_LUAARGCOUNT, "luaObjPlayVideo");
	}
	if(!lua_isstring(L, 1)) {
		LUADIE(L, ERROR_LUAL2BTYPE, "luaObjPlayVideo (arg1)");
	} else {
		sprintf(name, "%s", lua_tostring(L, 1));
	}
	if(!lua_isnumber(L, 2)) {
		LUADIE(L, ERROR_LUAL2BTYPE, "luaObjPlayVideo (arg2)");
	} else {
		if(lua_tonumber(L, 2) == 0) {
			trackergui = false;
		} else if(lua_tonumber(L, 2) == 1){
			trackergui = true;
		} else {
			LUADIE(L, ERROR_LUAL2BRANGE, "luaObjPlayVideo (arg2)");
		}
	}
	if(!lua_isnumber(L, 3)) {
		LUADIE(L, ERROR_LUAL2BTYPE, "luaObjPlayVideo (arg3)");
	} else {
		if(lua_tonumber(L, 3) == 0) {
			userCanCancel = false;
		} else if(lua_tonumber(L, 3) == 1){
			userCanCancel = true;
		} else {
			LUADIE(L, ERROR_LUAL2BRANGE, "luaObjPlayVideo (arg3)");
		}
	}

	showVideo(name, trackergui, userCanCancel);
	gLastTick = BS_GetTicks();

	return 0;
}

