// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//

#define NEED_REGISTER_FUNCTION
#include "bl_lua.h"
#undef NEED_REGISTER_FUNCTION

#include "bl_lua_configbindings.h"


// +++++++++++++++++++++++   REGISTERING GLOBALS IN LUA 	+++++++++++++++++++++++++++++++

void blRegisterLuaConfigBindings(lua_State *L) {
    // Register globals with default values

    /*
    		CFG_SIMPLE_STR("bg", &(lhandle.bgfile)),
		CFG_SIMPLE_STR("bg2", &(lhandle.bg2file)),
		CFG_SIMPLE_STR("leveldata", &(lhandle.leveldata)),
		CFG_SIMPLE_STR("magictile", &(val)),
		CFG_SIMPLE_STR("ooscript", &(lhandle.ooscriptfile)),
		CFG_SIMPLE_STR("script", &(lhandle.scriptfile)),
		CFG_SIMPLE_STR("snd", &(lhandle.sndfile)),
		CFG_SIMPLE_STR("tiles", &(lhandle.tilesfile)),

		CFG_SIMPLE_INT("leveltime", &(lhandle.leveltime)),
		CFG_SIMPLE_INT("timebonuspixel", &(lhandle.timebonuspixel)),
		CFG_SIMPLE_INT("timebonusmultiplicator", &(lhandle.timebonusmultiplicator)),
		CFG_SIMPLE_INT("timemalusifkatedies", &(lhandle.timemalusifkatedies)),
		CFG_INT_LIST("nextlevels", 0, CFGF_NONE),
		CFG_FUNC("include", &cfg_include),
		CFG_END()
       };
       */
    bsl_addstringvalue("bg", "");
    bsl_addstringvalue("bg2", "");
    bsl_addstringvalue("leveldata", "");
    bsl_addstringvalue("magictile", "");
    bsl_addstringvalue("ooscript", "");
    bsl_addstringvalue("script", "");
    bsl_addstringvalue("snd", "");
    bsl_addstringvalue("tiles", "");


	bsl_addnumbervalue("leveltime", 0);
	bsl_addnumbervalue("timebonuspixel", 0);
	bsl_addnumbervalue("timebonusmultiplicator", 0);
	bsl_addnumbervalue("timemalusifkatedies", 0);

    /* ??? INCLUDE ??? */
    /* ??? NEXTLEVELS ??? */

}

void blGetLuaConfigValues(lua_State *L) {
    /*
    		CFG_SIMPLE_STR("bg", &(lhandle.bgfile)),
		CFG_SIMPLE_STR("bg2", &(lhandle.bg2file)),
		CFG_SIMPLE_STR("leveldata", &(lhandle.leveldata)),
		CFG_SIMPLE_STR("magictile", &(val)),
		CFG_SIMPLE_STR("ooscript", &(lhandle.ooscriptfile)),
		CFG_SIMPLE_STR("script", &(lhandle.scriptfile)),
		CFG_SIMPLE_STR("snd", &(lhandle.sndfile)),
		CFG_SIMPLE_STR("tiles", &(lhandle.tilesfile)),

		CFG_SIMPLE_INT("leveltime", &(lhandle.leveltime)),
		CFG_SIMPLE_INT("timebonuspixel", &(lhandle.timebonuspixel)),
		CFG_SIMPLE_INT("timebonusmultiplicator", &(lhandle.timebonusmultiplicator)),
		CFG_SIMPLE_INT("timemalusifkatedies", &(lhandle.timemalusifkatedies)),
		CFG_INT_LIST("nextlevels", 0, CFGF_NONE),
		CFG_FUNC("include", &cfg_include),
		CFG_END()
       };
       */
       /*
       bool blLuaGetDouble(lua_State* blState, const char *globalname, double* locDouble);
bool blLuaGetSint32(lua_State* blState, const char *globalname, Sint32* locInt);
bool blLuaGetUint32(lua_State* blState, const char *globalname, Uint32* locInt);
bool blLuaGetString(lua_State* blState, const char *globalname, char* locString);
*/
    blLuaGetString(L, "bg", &lhandle.bgfile[0]);
    blLuaGetString(L, "bg2", &lhandle.bg2file[0]);
    blLuaGetString(L, "leveldata", &lhandle.leveldata[0]);
    blLuaGetString(L, "magictile", &lhandle.magictile[0]);
    blLuaGetString(L, "ooscript", &lhandle.ooscriptfile[0]);
    blLuaGetString(L, "script", &lhandle.scriptfile[0]);
    blLuaGetString(L, "snd", &lhandle.sndfile[0]);
    blLuaGetString(L, "tiles", &lhandle.tilesfile[0]);

    blLuaGetUint32(L, "leveltime", &lhandle.leveltime);
    blLuaGetUint32(L, "timebonuspixel", &lhandle.timebonuspixel);
    blLuaGetUint32(L, "timebonusmultiplicator", &lhandle.timebonusmultiplicator);
    blLuaGetUint32(L, "timemalusifkatedies", &lhandle.timemalusifkatedies);
    /* ??? INCLUDE ??? */
    /* ??? NEXTLEVELS ??? */

}
