// Bastard File System
// (C) 2007 Rene Schickbauer
//
// The Bastard File System (BFS) is a small virtual FS for Applications
// that would normally use Tarballs and/or Zipfiles but have to dynamically
// change its contents
//
// WARNING: This is still ALPHA QUALITY CODE! Use with care!
//
//
#include "bfs_data.h"
#include "bfs.h"
#include "bfs_rawio.h"
#include "string.h"

// *********** WRAPPER ****************    
bool readDataBlock(sBFS* handle, int blocknum, BLOCK_RAW* data) {
    
    int blocknum_real = blocknum + 1 + handle->numHeadBlocks; // Calculate offset from start of file
    
    if(!readRawBlock(handle, blocknum_real, data)) {
        return false;
    }
    return true;
}


bool writeDataBlock(sBFS* handle, int blocknum, BLOCK_RAW* data) {
    int blocknum_real = blocknum + 1 + handle->numHeadBlocks; // Calculate offset from start of file
    return writeRawBlock(handle, blocknum_real, data);
    
}

// ************* FREE BLOCKS ****************

// ->  read/write data is NOT automated (cleared) here, might need for recovery operations
bool readDataBlock_Free(sBFS* handle, int blocknum, BLOCK_FREE* data) {
    BLOCK_RAW raw;
    
    if(!readDataBlock(handle, blocknum, &raw)) {
        return false;
    }
    memcpy(data, &raw, 512); // Assume compiler adds no stupid padding
    if(data->blockType[0] != BLOCKTYPE_FREE) {
		// this is bad, very bad. You DID make those backups, didn't you?
		return false;
	}
        
    return true;
}


bool writeDataBlock_Free(sBFS* handle, int blocknum, BLOCK_FREE* data) {
    BLOCK_RAW raw;
    
    data->blockType[0] = BLOCKTYPE_FREE;
    memset(&raw, 0, sizeof(raw));
    
    // copy data to RAW block
    memcpy(&raw, data, 512); // Assume compiler adds no stupid padding
    
    return writeDataBlock(handle, blocknum, &raw);
    
}

// ************* FILE BLOCKS ****************
bool readDataBlock_File(sBFS* handle, int blocknum, BLOCK_FILE* data) {
    BLOCK_RAW raw;
    
    if(!readDataBlock(handle, blocknum, &raw)) {
        return false;
    }
    memcpy(data, &raw, 512); // Assume compiler adds no stupid padding
    if(data->blockType[0] != BLOCKTYPE_FILE) {
		// this is bad, very bad. You DID make those backups, didn't you?
		return false;
	}
        
    return true;
}


bool writeDataBlock_File(sBFS* handle, int blocknum, BLOCK_FILE* data) {
    BLOCK_RAW raw;
    
    data->blockType[0] = BLOCKTYPE_FILE;
    memset(&raw, 0, sizeof(raw));
    
    // copy data to RAW block
    memcpy(&raw, data, 512); // Assume compiler adds no stupid padding
    
    return writeDataBlock(handle, blocknum, &raw);
    
}

// ************* DIR BLOCKS ****************
bool readDataBlock_Dir(sBFS* handle, int blocknum, BLOCK_DIR* data) {
    BLOCK_RAW raw;
    
    if(!readDataBlock(handle, blocknum, &raw)) {
        return false;
    }
    memcpy(data, &raw, 512); // Assume compiler adds no stupid padding
    if(data->blockType[0] != BLOCKTYPE_DIR) {
		// this is bad, very bad. You DID make those backups, didn't you?
		return false;
	}
        
    return true;
}


bool writeDataBlock_Dir(sBFS* handle, int blocknum, BLOCK_DIR* data) {
    BLOCK_RAW raw;
    
    data->blockType[0] = BLOCKTYPE_DIR;
    memset(&raw, 0, sizeof(raw));
    
    // copy data to RAW block
    memcpy(&raw, data, 512); // Assume compiler adds no stupid padding
    
    return writeDataBlock(handle, blocknum, &raw);
    
}
