-- write out that we loaded sucessfully (more or less, anyway)
io.write("Starting script for Level9 in BlinkenLUA / ",_VERSION,"!\n")
bs.callback.engine.init("initLevel");
-- declare some global variables


-- Required function: Initializing the level
function initLevel ()
    door1open = 0;
	door2open = 0;
    
    
    -- preload all gfx (on-the-fly loading is NOT recommended)
    GFX_DOOR_CLOSED = bs.gfx.load("boxtile_door_closed.bmp");
    GFX_DOOR_OPEN = bs.gfx.load("boxtile_door_open.bmp");
    
    -- create doors
    OBJ_DOOR1 = bs.obj.new(57*32, 3*32, GFX_DOOR_CLOSED, "visible,ontop,blocking");
    OBJ_DOOR2 = bs.obj.new(6*32, 9*32, GFX_DOOR_CLOSED, "visible,ontop,blocking");

    -- load extra sound
    SND_DOOR_OPEN = bs.snd.load("fx_open_door.ogg");
    bs.callback.engine.physics("scriptPhysics");
end

-- Required function: Physics-loop for scripting part
function scriptPhysics ()
    --Count collectet pixels and open doors if enough pixels are collected
    if bs.level.pixels.collected()>15 then
        openDoor1();
    end

    if bs.level.pixels.collected()>31 then
        openDoor2();
    end
    
end


-- Script-internal functions
function openDoor1()
    if door1open == 0 then
        door1open = 1;
    
        -- exchange GFX for door
        OBJ_DOOR1.gfx(GFX_DOOR_OPEN);

       -- make door nonblocking
       OBJ_DOOR1.blocking(bs.no);

       -- play sound
       SND_DOOR_OPEN.play();
   end
end

function openDoor2()
    if door2open == 0 then
        door2open = 1;
    
        -- exchange GFX for door
        OBJ_DOOR2.gfx(GFX_DOOR_OPEN);

       -- make door nonblocking
       OBJ_DOOR2.blocking(bs.no);

       -- play sound
       SND_DOOR_OPEN.play();
    end
end
