-- write out that we loaded sucessfully (more or less, anyway)
io.write("Starting script for Level: Desert 1 (14) in BlinkenLUA / ",_VERSION,"!\n");
bs.callback.engine.init("initLevel");


-- Required function: Initializing the level
function initLevel ()
    -- preload all gfx (on-the-fly loading is NOT recommended)
    GFX_DOOR_CLOSED = bs.gfx.load("desert_door_closed.bmp");
    GFX_DOOR_OPEN = bs.gfx.load("desert_door_open.bmp");

    GFX_WALL_TILE = bs.gfx.load("wall_tile.bmp");

    GFX_SWITCH_RED = bs.gfx.load("fg_switch_aegypten_off.bmp");
    GFX_SWITCH_GREEN = bs.gfx.load("fg_switch_aegypten_on.bmp");
    
    GFX_WORM_HOLE_SMALL = bs.gfx.load("fg_wormhole32x32.png");
    GFX_WORM_HOLE_BIG = bs.gfx.load("fg_wormhole64x64.png");

    -- create door Am Ausgang positionieren
    OBJ_DOOR1 = bs.obj.new(441*32, 56*32, GFX_DOOR_CLOSED, "visible,ontop,blocking");
    door1open = 0;
    
    -- create door Am Start positionieren
    OBJ_DOOR2 = bs.obj.new(18*32, 67*32, GFX_DOOR_CLOSED, "visible,ontop,blocking");
    door2open = 0;
    -- create switch for that door
    OBJ_SWITCH = bs.obj.new(23*32, 67*32, GFX_SWITCH_RED, "visible");
	OBJ_SWITCH.callback.playeraction("toggle_switch");

    -- create Switches
    OBJ_SWITCH_A = bs.obj.new(381*32, 37*32, GFX_SWITCH_RED, "visible");
    OBJ_SWITCH_B = bs.obj.new(383*32, 37*32, GFX_SWITCH_RED, "visible");
    OBJ_SWITCH_C = bs.obj.new(385*32, 37*32, GFX_SWITCH_RED, "visible");

    -- create raetsel-tiles
    OBJ_WALL_TILE_A = bs.obj.new(382*32, 36*32, GFX_WALL_TILE, "!visible");
    OBJ_WALL_TILE_B = bs.obj.new(384*32, 34*32, GFX_WALL_TILE, "!visible");
    OBJ_WALL_TILE_C = bs.obj.new(386*32, 32*32, GFX_WALL_TILE, "!visible");

    OBJ_SWITCH_A.callback.playeraction("handleSwitchAction");
    OBJ_SWITCH_B.callback.playeraction("handleSwitchAction");
    OBJ_SWITCH_C.callback.playeraction("handleSwitchAction");


    -- create WormHole-Gfx
   	bs.include("_wormhole.inc.bsl");
	Wormhole:new(143*32, 65*32, 255, 255, "64");
	Wormhole:new(134*32, 60*32, 4767, 254, "64");
	Wormhole:new(0, 44*32, 11872, 1103, "32");
	Wormhole:new(453*32, 37*32, 4660, 2060, "64");
	Wormhole:new(446*32, 60*32, 31*32, 56*32, "32");

	-- create other fgObjects
	GFX_STATUE = bs.gfx.load("fg_object_002.bmp");
	OBJ_STATUE = bs.obj.new(97*32, 62*32, GFX_STATUE, "visible");
    
    -- load extra sound
    SND_DOOR_OPEN = bs.snd.load("fx_open_door.ogg");
    SND_SWITCH_ON = bs.snd.load("fx_altemark__syn1.wav");
    SND_SWITCH_OFF = bs.snd.load("fx_altemark__syn10.wav");
    SND_RAETSEL_RESTART = bs.snd.load("fx_altemark__alarm2.wav");
    SND_RAETSEL_CONTINUE = bs.snd.load("fx_altemark__1up.wav");
    SND_RAETSEL_COMPLETE_1 = bs.snd.load("fx_altemark__digitalpitchup.wav");
    SND_RAETSEL_COMPLETE_2 = bs.snd.load("fx_altemark__end.wav");
    SND_BEAM = bs.snd.load("fx_altemark__gongend.wav");
    
    
	raetsel_stage = 0;
	switch_a_on = 0;
	switch_b_on = 0;
	switch_c_on = 0;
	raetsel_abort_delay = 0;
	    

    bs.callback.engine.physics("scriptPhysics");
end



-- Required function: Physics-loop for scripting part
function scriptPhysics ()
    -- Handle beaming
    -- von pyramiedenspitze (20/140-160) zureuck vor gruft 1 (60/129)
    if bs.player.x()>4438 and bs.player.x()<5100 and bs.player.y()>590 and bs.player.y()<620 then
        SND_BEAM.play();
        bs.player.x(4098);
        bs.player.y(1845);
    end
    
    -- handle raetsel_abort_delay if needed
    if raetsel_abort_delay > 0 then
        if raetsel_abort_delay == 1 then
            reset_raetsel();
        else
            raetsel_abort_delay=raetsel_abort_delay-1;
            if raetsel_abort_delay == 230 then
                SND_RAETSEL_COMPLETE_2.play();
            end
        end
    end


    -- oeffne Ausgang wenn alle Pixel gesammelt wurden
    if  bs.level.exitopen() == 1 and door1open == 0 then
        door1open=1;
        OBJ_DOOR1.gfx(GFX_DOOR_OPEN);
        OBJ_DOOR1.blocking(bs.no);
        SND_DOOR_OPEN.play();
    end
end

function handleSwitchAction(obj_id)
    -- Raetsel (l, _r, r, _m, _l)
    if obj_id.x() == OBJ_SWITCH_A.x() then
        toggle_switch_a();
        if raetsel_stage == 0 then
            set_raetsel_stage(1);
        else
            if raetsel_stage == 4 then
                set_raetsel_stage(5);
            else
                set_raetsel_stage(-1);
            end
        end
    end
    if obj_id.x() == OBJ_SWITCH_B.x() then
        toggle_switch_b();
        if raetsel_stage == 3 then
            set_raetsel_stage(4);
        else
            set_raetsel_stage(-1);
        end
    end
    if obj_id.x() == OBJ_SWITCH_C.x() then
        toggle_switch_c();
        if raetsel_stage == 1 then
            set_raetsel_stage(2);
        else
            if raetsel_stage == 2 then
                set_raetsel_stage(3);
            else
                set_raetsel_stage(-1);
            end
        end
    end
end



-- Script-internal functions
function toggle_switch()
    if door2open == 0 then
        OBJ_SWITCH.gfx(GFX_SWITCH_GREEN);
        SND_SWITCH_ON.play();
        door2open = 1;
        OBJ_DOOR2.gfx(GFX_DOOR_OPEN);
        OBJ_DOOR2.blocking(bs.no);
    else
        OBJ_SWITCH.gfx(GFX_SWITCH_RED);
        SND_SWITCH_OFF.play();
        door2open = 0;
        OBJ_DOOR2.gfx(GFX_DOOR_CLOSED);
        OBJ_DOOR2.blocking(bs.yes);
    end
end

function toggle_switch_a()
    if switch_a_on == 0 then
        OBJ_SWITCH_A.gfx(GFX_SWITCH_GREEN);
        SND_SWITCH_ON.play();
        switch_a_on = 1;
    else
        OBJ_SWITCH_A.gfx(GFX_SWITCH_RED);
        SND_SWITCH_OFF.play();
        switch_a_on = 0;
    end
end

function toggle_switch_b()
    if switch_b_on == 0 then
        OBJ_SWITCH_B.gfx(GFX_SWITCH_GREEN);
        SND_SWITCH_ON.play();
        switch_b_on = 1;
    else
        OBJ_SWITCH_B.gfx(GFX_SWITCH_RED);
        SND_SWITCH_OFF.play();
        switch_b_on = 0;
    end
end

function toggle_switch_c()
    if switch_c_on == 0 then
        OBJ_SWITCH_C.gfx(GFX_SWITCH_GREEN);
        SND_SWITCH_ON.play();
        switch_c_on = 1;
    else
        OBJ_SWITCH_C.gfx(GFX_SWITCH_RED);
        SND_SWITCH_OFF.play();
        switch_c_on = 0;
    end
end


function set_raetsel_stage(s)
    raetsel_stage = s;
    if s == -1 then
        raetsel_abort_delay=50;
    else
        if s == 2 then
            raetsel_tile_a();
        end
        if s == 4 then
            raetsel_tile_b();
        end
        if s == 5 then
            raetsel_tile_c();
            SND_RAETSEL_COMPLETE_1.play();
            raetsel_abort_delay=600;
        end
    end
    if s > 0 and s < 5 then
        SND_RAETSEL_CONTINUE.play();
    end
end


function raetsel_tile_a()
    OBJ_WALL_TILE_A.visible(bs.yes)
    OBJ_WALL_TILE_A.blocking(bs.yes);
end

function raetsel_tile_b()
    OBJ_WALL_TILE_B.visible(bs.yes)
    OBJ_WALL_TILE_B.blocking(bs.yes);
end

function raetsel_tile_c()
    OBJ_WALL_TILE_C.visible(bs.yes)
    OBJ_WALL_TILE_C.blocking(bs.yes);
end


function reset_raetsel()
    OBJ_SWITCH_A.gfx(GFX_SWITCH_RED);
    OBJ_SWITCH_B.gfx(GFX_SWITCH_RED);
    OBJ_SWITCH_C.gfx(GFX_SWITCH_RED);
    OBJ_WALL_TILE_A.visible(bs.no)
    OBJ_WALL_TILE_A.blocking(bs.no);
    OBJ_WALL_TILE_B.visible(bs.no)
    OBJ_WALL_TILE_B.blocking(bs.no);
    OBJ_WALL_TILE_C.visible(bs.no)
    OBJ_WALL_TILE_C.blocking(bs.no);
    SND_RAETSEL_RESTART.play();
    raetsel_stage = 0;
    switch_a_on = 0;
    switch_b_on = 0;
    switch_c_on = 0;
    raetsel_abort_delay = 0;
end
