-- write out that we loaded sucessfully (more or less, anyway)
io.write("Starting script for Level12 in BlinkenLUA / ",_VERSION,"!\n")
bs.callback.engine.init("initLevel");


BEE_POS_X=2624;
BEE_POS_Y=352;
BEE_DIR_X=2;
BEE_DIR_Y=3;
BEE_TIMER=0;
BEE_RAND=0;



door1open = 0;
door2open = 0;
door3open = 0;
door4open = 0;
door5open = 0;
door6open = 0;
door7open = 0;
door8open = 0;

-- Required function: Initializing the level
function initLevel ()
	-- preload all gfx (on-the-fly loading is NOT recommended)
	GFX_SECRET_POINTER = bs.gfx.load("fg_secret_pointer.png");
	OBJ_SECRET_POINTER = bs.obj.new(95*32, 10*32, GFX_SECRET_POINTER, "visible");
	
	GFX_BEE_RIGHT = bs.gfx.load("monster_bee_right.bmp");
	GFX_BEE_RIGHT2 = bs.gfx.load("monster_bee_right2.bmp");
	GFX_BEE_LEFT = bs.gfx.load("monster_bee_left.bmp");
	GFX_BEE_LEFT2 = bs.gfx.load("monster_bee_left2.bmp");
	OBJ_BEE = bs.obj.new(82*32, 11*32, GFX_BEE_RIGHT, "visible,blocking,ontop,killing");
	
	GFX_DOOR_CLOSED = bs.gfx.load("fg_door_closed.bmp");
	GFX_DOOR_OPEN = bs.gfx.load("fg_door_open.bmp");

	GFX_WALL_TILE = bs.gfx.load("wall_tile.bmp");

	bs.include("_wormhole.inc.bsl");
	wurmloch = Wormhole:new(125*32, 19*32, 2304, 32, "32");
	
	
	-- create doors
	OBJ_DOOR1 = bs.obj.new(59*32, 10*32, GFX_DOOR_CLOSED, "visible,blocking,ontop");
	OBJ_DOOR2 = bs.obj.new(69*32, 2*32, GFX_DOOR_CLOSED, "visible,blocking,ontop");
	OBJ_DOOR3 = bs.obj.new(24*32, 6*32, GFX_DOOR_CLOSED, "visible,blocking,ontop");
	OBJ_DOOR4 = bs.obj.new(24*32, 11*32, GFX_DOOR_CLOSED, "visible,blocking,ontop");
	OBJ_DOOR5 = bs.obj.new(25*32, 17*32, GFX_DOOR_CLOSED, "visible,blocking,ontop");
	OBJ_DOOR6 = bs.obj.new(45*32, 25*32, GFX_DOOR_CLOSED, "visible,blocking,ontop");
	OBJ_DOOR7 = bs.obj.new(96*32, 24*32, GFX_DOOR_CLOSED, "visible,blocking,ontop");
	OBJ_DOOR8 = bs.obj.new(45*32, 33*32, GFX_DOOR_CLOSED, "visible,blocking,ontop");
	
	-- create Walls (visible but not blocking)
	OBJ_WALL_TILE = bs.obj.new(105*32, 19*32, GFX_WALL_TILE, "visible");
	OBJ_WALL_TILE = bs.obj.new(104*32, 13*32, GFX_WALL_TILE, "visible");

	-- load extra sound
	SND_DOOR_OPEN = bs.snd.load("fx_open_door.ogg");
	SND_BEAM = bs.snd.load("fx_altemark__gongend.wav");
	bs.callback.engine.physics("scriptPhysics");
end

-- Required function: Physics-loop for scripting part
function scriptPhysics ()
	--Move Bee-Monster
	BEE_POS_X = BEE_POS_X + BEE_DIR_X;
	BEE_POS_Y = BEE_POS_Y + BEE_DIR_Y;
	
	if BEE_POS_X < 2600 then
		BEE_DIR_X = 3;
	end
	if bs.player.x() > 2753 then
		rand = BEE_RAND;
	else
		rand = 0
	end
	if BEE_POS_X > 2900 + rand then
		BEE_DIR_X = -4;
		BEE_RAND = math.random(400);
	end
	
	if BEE_POS_X > 2675 and BEE_POS_X < 2830 and BEE_POS_Y < 320 then
		if BEE_POS_Y + 2 * (BEE_POS_X - 2675)  < 320 then
			BEE_DIR_X = 2;
			BEE_DIR_Y = 3;
		end
		if BEE_POS_Y - 2 * (BEE_POS_X - 2830) < 320 then
			BEE_DIR_X = -2;
			BEE_DIR_Y = 3;
		end
	else
		if BEE_POS_Y < 320 then
			BEE_DIR_Y = 2;
		end
	end
	if BEE_DIR_Y == 3 and BEE_POS_Y < 350 and BEE_POS_Y > 346 then
		if BEE_DIR_X < 0 and BEE_POS_X > 2753 then
			BEE_DIR_X = 4;
		end
		if BEE_DIR_X > 0 and BEE_POS_X < 2754 then
			BEE_DIR_X = -5;
		end
	end
	if BEE_POS_Y > 390 then
		BEE_DIR_Y = -2;
	end
	
	OBJ_BEE.x(BEE_POS_X);
	OBJ_BEE.y(BEE_POS_Y);
	
	if BEE_DIR_X > 0 then
		 if BEE_TIMER > 12 then
			 OBJ_BEE.gfx(GFX_BEE_RIGHT);
		 else
			 OBJ_BEE.gfx(GFX_BEE_RIGHT2);
		 end
	else
		 if BEE_TIMER > 12 then
			 OBJ_BEE.gfx(GFX_BEE_LEFT);
		 else
			 OBJ_BEE.gfx(GFX_BEE_LEFT2);
		 end
	end
	
	BEE_TIMER = BEE_TIMER +1;
	if BEE_TIMER > 23 then
		BEE_TIMER = 0;
	end
	
	
	--Count collectet pixels and open doors if enough pixels are collected
	if bs.level.pixels.collected()>5 then
		openDoor1();
	end
	
	if bs.level.pixels.collected()>23 then
		openDoor2();
	end

	if bs.level.pixels.collected()>32 then
		openDoor3();
	end

	if bs.level.pixels.collected()>34 then
		openDoor4();
	end

	if bs.level.pixels.collected()>51 then
		openDoor5();
	end

	if bs.level.pixels.collected()>55 then
		openDoor6();
	end
	
	if bs.level.pixels.collected()>73 then
		openDoor7();
	end

	if bs.level.pixels.collected()>91 then
		openDoor8();
	end

	-- Handle beaming
	if door8open == 1 then
		wurmloch.x_to = 1760;
		wurmloch.y_to = 1024;		
	elseif door7open == 1 then 
		wurmloch.x_to = 3032;
		wurmloch.y_to = 1056;
	elseif door6open == 1 then 
		wurmloch.x_to = 1056;
		wurmloch.y_to = 576;
	elseif door4open == 1 then 
		wurmloch.x_to = 320;
		wurmloch.y_to = 500;
	elseif door2open == 1 then 
		wurmloch.x_to = 2122;
		wurmloch.y_to = 64;
	end
	if  bs.player.x() > 3900 then
		--Kill Bee
		OBJ_BEE.visible(bs.no);
		OBJ_BEE.blocking(bs.no);
		OBJ_BEE.killing(bs.no);
	end
end

function handleAction (obj_id)
	--not needed
end

-- Script-internal functions
function openDoor1()
	if door1open == 0 then
		door1open = 1;
	
		-- exchange GFX for door
		OBJ_DOOR1.gfx(GFX_DOOR_OPEN);

	   -- make door nonblocking
	   OBJ_DOOR1.blocking(bs.no);

	   -- play sound
	   SND_DOOR_OPEN.play();
   end
end

function openDoor2()
	if door2open == 0 then
		door2open = 1;
	
		-- exchange GFX for door
		OBJ_DOOR2.gfx(GFX_DOOR_OPEN);

	   -- make door nonblocking
	   OBJ_DOOR2.blocking(bs.no);

	   -- play sound
	   SND_DOOR_OPEN.play();
	end
end

function openDoor3()
	if door3open == 0 then
		door3open = 1;
	
		-- exchange GFX for door
		OBJ_DOOR3.gfx(GFX_DOOR_OPEN);

	   -- make door nonblocking
	   OBJ_DOOR3.blocking(bs.no);

	   -- play sound
	   SND_DOOR_OPEN.play();
   end
end

function openDoor4()
	if door4open == 0 then
		door4open = 1;
	
		-- exchange GFX for door
		OBJ_DOOR4.gfx(GFX_DOOR_OPEN);

	   -- make door nonblocking
	   OBJ_DOOR4.blocking(bs.no);

	   -- play sound
	   SND_DOOR_OPEN.play();
	end
end

function openDoor5()
	if door5open == 0 then
		door5open = 1;
	
		-- exchange GFX for door
		OBJ_DOOR5.gfx(GFX_DOOR_OPEN);

	   -- make door nonblocking
	   OBJ_DOOR5.blocking(bs.no);

	   -- play sound
	   SND_DOOR_OPEN.play();
   end
end

function openDoor6()
	if door6open == 0 then
		door6open = 1;
	
		-- exchange GFX for door
		OBJ_DOOR6.gfx(GFX_DOOR_OPEN);

	   -- make door nonblocking
	   OBJ_DOOR6.blocking(bs.no);

	   -- play sound
	   SND_DOOR_OPEN.play();
	end
end

function openDoor7()
	if door7open == 0 then
		door7open = 1;
	
		-- exchange GFX for door
		OBJ_DOOR7.gfx(GFX_DOOR_OPEN);

	   -- make door nonblocking
	   OBJ_DOOR7.blocking(bs.no);

	   -- play sound
	   SND_DOOR_OPEN.play();
   end
end

function openDoor8()
	if door8open == 0 then
		door8open = 1;
	
		-- exchange GFX for door
		OBJ_DOOR8.gfx(GFX_DOOR_OPEN);

	   -- make door nonblocking
	   OBJ_DOOR8.blocking(bs.no);

	   -- play sound
	   SND_DOOR_OPEN.play();
	end
end
