io.write("Wormhole-Maker included!\n")

--
-- required files:
--  * wormhole64x64_%%%%.gif (1-24)
--  * fg_wormhole32x32.png
--  * fx_altemark__gongend.wav
--
-- use with:
--  Wormhole:new(x_pos, y_pos, x_to, y_to, "64" or "32");
--

Wormhole = {
	gfx64 = bs.anim.load("wormhole64x64_%%%%.gif", 1, 24, 10, bs.anim.type.forwardloop),
	gfx32 = bs.gfx.load("fg_wormhole32x32.png"),
	snd = bs.snd.load("fx_altemark__gongend.wav");
};
function Wormhole:new(x, y, x_to, y_to, size)
	local obj = {};
    setmetatable(obj, self);
	self.__index = self;
	obj.x_to = x_to;
	obj.y_to = y_to;
	if size == "64" then
		obj.fgobject = bs.obj.new(x, y, obj.gfx64, "visible");
	else
		obj.fgobject = bs.obj.new(x, y, obj.gfx32, "visible");
	end
	obj.fgobject.callback.playercollision("WormholeCallback");
	self[obj.fgobject.internal] = obj;
	return obj;
end

function WormholeCallback (obj)
	Wormhole.snd.play();
	bs.player.speed_x(0);
	bs.player.speed_y(0);
	bs.player.x(Wormhole[obj.internal].x_to);
	bs.player.y(Wormhole[obj.internal].y_to);
end
