io.write("Firetile-Maker included!\n")

--
-- required files:
--  * ...
--
-- use with:
--  Firetile:new(x, y);
--

Firetile = {
	gfx = {
			[1] = bs.gfx.load("firetile1.png"),
			[2] = bs.gfx.load("firetile2.png"),
			[3] = bs.gfx.load("firetile3.png"),
			[4] = bs.gfx.load("firetile4.png"),
			[5] = bs.gfx.load("firetile5.png"),
			[6] = bs.gfx.load("firetile6.png")
	},
	obj_cnt = 0
};
function Firetile:new(x, y)
	local obj = {};
    setmetatable(obj, self);
	self.__index = self;
	obj.animationFrame = math.random(6);
	obj.fgobject = bs.obj.new((x-1)*32, (y-1)*32, obj.gfx[obj.animationFrame], "visible, killing");
	self.obj_cnt = self.obj_cnt + 1;
	self[self.obj_cnt] = obj;
end

bs.timer.new("FiretileTimer", 0.1);

function FiretileTimer ()
	for i = 1, Firetile.obj_cnt do
		Firetile[i].animationFrame = math.mod(Firetile[i].animationFrame, 6) + 1;
		Firetile[i].fgobject.gfx(Firetile.gfx[Firetile[i].animationFrame]);
		if (math.random(100)>95) then
			Firetile[i].animationFrame = math.random(6);
		end
	end
end
