/*
	scrab.h - includes, defines and structures
*/

#include "xscrab.h"
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

#include <assert.h>

/* make sure this is bigger than the number of words in the dictionary used -
   119000 is okay for the supplied dictionary.
*/
#define DICTSIZE 119000


#define NAMELEN 14
#define BARLEN 7
#define BOARDSIZE 15
#define BAGSIZE 100 /* must be the same as sum of letter frequency */
#define MAXPLAYERS 4
#define NUMLETTERS 26
#define LETTER_FREQUENCY_TABLE {9,2,2,4,12,2,3,2,9,1,1,4,2,6,8,2,1,6,4,6,4,2,2,1,2,1}
#define LETTER_SCORES {1,3,3,2,1,4,2,4,1,8,5,1,3,1,1,3,10,1,1,1,1,4,4,8,4,10}

#define SAVENAME "/.xscrabble.save"

#define MAXPATHLEN 256
#define MAGNUM 99 /* magic number for checksum calculation */
#define BLANKTILES {'a','e','i','o','s','t'}
#define NUMBLANKS 6
#define NUMHIGHSCORES 8
#define NUMGOSCORES 10
#define BESTGOWORDSLEN 30

/* define MAKEPERMS if you would rather have the permutations created at runtime*/
#ifdef MAKEPERMS 
#undef MAKEPERMS
#endif

/* board validation flags */
#define INVALID 0  /* invalid words */
#define VALID 1    /* valid words */
#define HORLICKS 2 /* move was complete horlicks */
#define NOTCENTRE 3 /* first move was not in centre */

/* player statistics structure */
typedef struct { int score;
		 char name[NAMELEN];
		 char bar[BARLEN]; } playerStat;

typedef struct { int score;
		 char name[NAMELEN];
		 time_t date; } scoreStat;
		 
typedef struct { int score;
		 char name[NAMELEN];
		 time_t date;
		 char words[BESTGOWORDSLEN]; } goStat;
